package main

import (
	"flag"

	"pkg.deepin.io/daemon/sync/deepinid"
	"pkg.deepin.io/daemon/sync/infrastructure/helper"
	"pkg.deepin.io/daemon/sync/infrastructure/log"
	"pkg.deepin.io/daemon/sync/pusher"
)

var (
	login    = flag.Bool("l", false, "start login app")
	duration = flag.Int("d", 0, "the timer interval")

	syncDaemon   *Daemon
	pusherClient *pusher.Client
	deepinID     *deepinid.DeepinID
)

func main() {
	flag.Parse()

	var err error
	err = helper.Init()
	if err != nil {
		log.Fatal("failed to init helper:", err)
		return
	}
	hw, err := helper.GetHardware()
	if err != nil {
		log.Fatal("failed to get hardware info:", err)
		return
	}

	deepinID, err = deepinid.NewDeepinID(hw)
	if err != nil {
		log.Fatal("failed to new deepinid:", err)
		return
	}

	pusherClient, err = pusher.NewClient()
	if err != nil {
		log.Fatal("failed to new pusher:", err)
		return
	}

	syncDaemon, err = newDaemon(hw)
	if err != nil {
		log.Fatal("failed to new daemon:", err)
		return
	}
	syncDaemon.initModules()
	err = syncDaemon.SetupDBus(syncDaemon.conn, syncDaemon)
	if err != nil {
		log.Fatal("Failed to export manager bus:", err)
		return
	}

	pusherClient.Monitor(syncDaemon.conn)
	syncDaemon.Monitor(syncDaemon.conn)

	deepinID.VerifyToken()

	syncDaemon.startTimer(*duration)
}
