/*
 * Copyright (C) 2015 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifdef STATE

/* No state... */

#endif /*STATE*/

#ifdef BEHAVIOUR

/* beautiful helper macros to create the function names*/
#define PASTER(x,y,z)		x ## _ ## y ## _ ## z
#define EVALUATOR(x,y,z)	PASTER(x,y,z)

static void
EVALUATOR(NAME, IN, in_set)(struct cpssp *cpssp, unsigned int val)
{
	switch (val) {
	case SIG_STD_LOGIC_L:
	case SIG_STD_LOGIC_0:
		val = SIG_STD_LOGIC_0;
		break;
	case SIG_STD_LOGIC_H:
	case SIG_STD_LOGIC_1:
	case SIG_STD_LOGIC_Z: /* ! */
		val = SIG_STD_LOGIC_1;
		break;
	default:
		/* val = val; */
		break;
	}

#if DEBUG
	fprintf(stderr, "%s(%p): %08x\n", SNAME, &cpssp->NAME, val);
#endif

	EVALUATOR(NAME, OUT, out_set)(cpssp, val);
}

static void
NAME_(create)(struct cpssp *cpssp)
{
}

static void
NAME_(destroy)(struct cpssp *cpssp)
{
}

#endif /*BEHAVIOUR*/
