/*
 * Copyright (C) 2016 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <assert.h>
#include <stdio.h>
#include <string.h>

#include <gtk/gtk.h>
#include "glue.h"
#include "glue-gui-gtk.h"
#include "glue-gui-gtk-potentiometer.h"
#include "sig_integer.h"
#include "sig_manage.h"
#include "sig_std_logic.h"

typedef struct {
	GtkHBoxClass parent_class;

    	void (*value_changed_gui) (GuiGtkPotentiometer *potentiometer);
} GuiGtkPotentiometerClass;

enum{
	VALUE_CHANGED_GUI,
	GUI_GTK_POTENTIOMETER_LAST_SIGNAL
};

static guint gui_gtk_potentiometer_signals[GUI_GTK_POTENTIOMETER_LAST_SIGNAL] = { 0 };

static void
gui_gtk_potentiometer_class_init(GuiGtkPotentiometerClass *class)
{	
    gui_gtk_potentiometer_signals[VALUE_CHANGED_GUI] =
	g_signal_new("value-changed-gui",
		     G_TYPE_FROM_CLASS(class),
		     G_SIGNAL_RUN_FIRST | G_SIGNAL_ACTION, /* FIXME */
		     G_STRUCT_OFFSET(GuiGtkPotentiometerClass, value_changed_gui),
		     NULL, NULL,
		     g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);

}

static void
gui_gtk_potentiometer_init(GuiGtkPotentiometer *potentiometer)
{
}

void
gui_gtk_potentiometer_adj_sim(void *_potentiometer, int val)
{
	GuiGtkPotentiometer *poti;
	
	poti = _potentiometer;
	if (val <= 0){
		gtk_adjustment_set_value(poti->adj, 0.0);	
	}else{
		gtk_adjustment_set_value(poti->adj, val);	
	}
	
}

static void
gui_gtk_potentiometer_adj_gui(GtkAdjustment *adj, void *_potentiometer)
{	
	GuiGtkPotentiometer *potentiometer = _potentiometer;
	int val = (int)adj->value;
	g_signal_emit(G_OBJECT(potentiometer),
			gui_gtk_potentiometer_signals[VALUE_CHANGED_GUI], 0, val);
#if 0
	GuiGtkPotentiometer *potentiometer = _potentiometer;
	sig_integer_set(potentiometer->port_adj, potentiometer, (int) adj->value);
#endif /* wrong approach  */
}

GType
gui_gtk_potentiometer_get_type(void)
{
	static GType ttt_type = 0;

	if (! ttt_type) {
		static const GTypeInfo ttt_info = {
			sizeof(GuiGtkPotentiometerClass),
			NULL,	/* base_init */
			NULL,	/* base_finalize */
			(GClassInitFunc) gui_gtk_potentiometer_class_init,
			NULL,	/* class_finalize */
			NULL,	/* class_data */
			sizeof(GuiGtkPotentiometer),
			0,	/* n_preallocs */
			(GInstanceInitFunc) gui_gtk_potentiometer_init,
		};

		ttt_type = g_type_register_static (GTK_TYPE_HBOX,
				"Potentiometer", &ttt_info, 0);
	}

	return ttt_type;
}

#define GUIGTKPOTENTIOMETER_TYPE gui_gtk_potentiometer_get_type()

GtkWidget *
gui_gtk_potentiometer_new(const char *desc)
{
	GtkWidget *hbox;
	GuiGtkPotentiometer *potentiometer;
	
	potentiometer = GUI_GTK_POTENTIOMETER(g_object_new(GUIGTKPOTENTIOMETER_TYPE, NULL));
	/* GTK_WIDGET_UNSET_FLAGS(potentiometer, GTK_CAN_FOCUS); */
	hbox = gtk_vbox_new(FALSE, 1);
	potentiometer->label = gtk_label_new(desc);
	GTK_WIDGET_UNSET_FLAGS(potentiometer->label, GTK_CAN_FOCUS);
	gtk_widget_show(potentiometer->label);
	gtk_box_pack_start(GTK_BOX(hbox), potentiometer->label,
			FALSE, FALSE, 1);
	
	potentiometer->adj = (GtkAdjustment *) gtk_adjustment_new(0.0, 
						0.0,
						110.0,
						5.0,
						10.0,
						10.0);
	potentiometer->scale = gtk_hscale_new(potentiometer->adj);
	gtk_widget_show(potentiometer->scale);
	gtk_box_pack_start(GTK_BOX(hbox), potentiometer->scale, 
			FALSE, FALSE, 0.0);

	gtk_widget_show(hbox);
	gtk_box_pack_start(GTK_BOX(potentiometer), hbox,
			FALSE, FALSE, 1);
	gtk_widget_show(potentiometer->scale);
	gtk_widget_show(potentiometer->label);	
	gtk_widget_show(GTK_WIDGET(potentiometer));

	g_signal_connect(potentiometer->adj, "value_changed",
			G_CALLBACK(gui_gtk_potentiometer_adj_gui), potentiometer);
	return GTK_WIDGET(potentiometer);
}
