# Setup default test variables ... 
SET(CTEST_CMAKE_COMMAND "\"${CMAKE_EXECUTABLE_NAME}\"")
SET(CTEST_COMMAND "\"${CTEST_EXECUTABLE_NAME}\" --track Nightly-Release -D Nightly -A \"${CTEST_SCRIPT_DIRECTORY}/${CTEST_SCRIPT_NAME}\"")
SET(CTEST_SOURCE_DIRECTORY "${CTEST_SCRIPT_DIRECTORY}/../..")
SET(CTEST_START_WITH_EMPTY_BINARY_DIRECTORY TRUE)

SET(CTEST_INITIAL_CACHE "

CMAKE_BUILD_TYPE:STRING=Release
K3D_BUILD_DEVELOPMENT_MODULE:BOOL=OFF
K3D_BUILD_EULER_OPERATIONS_MODULE:BOOL=OFF
K3D_BUILD_GLX_MODULE:BOOL=OFF
K3D_BUILD_LSYSTEM_MODULE:BOOL=OFF
K3D_BUILD_QSLIM_MODULE:BOOL=OFF
K3D_BUILD_VIRTUAL_OFFSCREEN_MODULE:BOOL=OFF
K3D_ENABLE_DISTRIBUTION:BOOL=ON
K3D_ENABLE_TESTING:BOOL=ON
$ENV{K3D_EXTRA_INITIAL_CACHE}

")

# Allow the caller to override test variables ... note that the caller MUST specify CTEST_BINARY_DIRECTORY at-a-minimum.
SET(VARIABLE)
FOREACH(ARGUMENT ${CTEST_SCRIPT_ARG})
	IF(VARIABLE)
		SET(${VARIABLE} ${ARGUMENT})
		SET(VARIABLE)
	ELSE(VARIABLE)
		SET(VARIABLE ${ARGUMENT})
	ENDIF(VARIABLE)
ENDFOREACH(ARGUMENT)

