/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MvQRequestPanelWidget_H
#define MvQRequestPanelWidget_H

#include <QWidget>

#include <string>
#include <vector>

class IconClass;
class IconObject;

class MvQRequestPanelWidget : public QWidget
{
Q_OBJECT  
  
public:  
    MvQRequestPanelWidget(const std::vector<std::string>&,QWidget* parent=0);
    void delayedForceRepaint();

signals:
    void iconDropped(IconObject*);
	
protected slots:
    void forceRepaint();

protected:
    bool isAccepted(const IconClass& kind) const;
    void paintEvent(QPaintEvent*);
	void dragEnterEvent(QDragEnterEvent *);
	void dragMoveEvent(QDragMoveEvent *);
	void dropEvent(QDropEvent *);

	static QBrush bgBrushLeft_;
	static QBrush bgBrushRight_;
	static QPen   linePenHorizontal_;
	static QPen   linePenVertical_;
	static QPen   linePenReset_;
    std::vector<std::string> classes_;
    bool delayedRepaintScheduled_;
}; 

#endif
