/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MvQCursorData_H
#define MvQCursorData_H

#include <QBrush>
#include <QGraphicsItem>
#include <QPen>

#include "MvQPlotItem.h"

#include "Layer.h"

class QTextDocument;

class MgQLayoutItem;
class MgQSceneItem;

using namespace std;

class MvQCursorData : public MvQPlotItem, public ValuesCollectorVisitor
{

Q_OBJECT  
  
public:
	enum PositionMode {Anchored, FollowCursor};
	enum ProbeMode {AnchoredProbe, FollowCursorProbe};

	MvQCursorData(MgQPlotScene*,MvQPlotView*,QGraphicsItem *parent=0);
	~MvQCursorData();

	void paint(QPainter *, const QStyleOptionGraphicsItem*, QWidget*);
	QRectF boundingRect() const;
	
	void setActivated(bool);
	void prepareForReset();
	void reset();

	void setPositionMode(PositionMode);
	void changePositionMode(QPointF&);
	void changeProbeMode(QPointF&);
	void setCursorPos(QPointF&);
	void setText(QPointF,QList<ValuesCollector> layerData,QString,QString,bool);
	void setText();	
	void setMagnifierInfo(bool,QPointF magScenePos=QPointF(),float magZoomFactor=1.);

	void mousePressEventFromView(QMouseEvent*);
	void mouseMoveEventFromView(QMouseEvent*);	
	void mouseReleaseEventFromView(QMouseEvent*);	

	void setZoomWasPerformedAfterMouseRelease(bool b) {zoomWasPerformedAfterMouseRelease_=b;} ;
		
	QString  unitsString(QString);
	
	void visit(const ValuesCollectorData&);
	void visit(const ValuesCollectorUVData&);
	void visit(const ValuesCollectorSDData&);

signals:
    	void positionChanged(QPointF,QList<ValuesCollector>);
	void probeEnabled(bool);
private:	
	void setText(QString);
	QString formatNumber(double);
	void setData(QPointF);

	QGraphicsScene* scene_;
	QString text_;
	QPointF         coordinates_;

	PositionMode    positionMode_;		
	QPointF         offsetFromCursor_;
	QPointF 	cursorPos_;
	
	ProbeMode    	probeMode_;
	
	QRectF		 boundingRect_;
	QRectF		 textBoundingRect_;
	QFont*           font_;
	QFontMetrics*    fontMetrics_;
	QTextDocument*   textDoc_;

	QPen	fontPen_;
	QBrush  fontBrush_;
	QPen    areaPen_;
	QBrush  areaBrush_;

	MgQLayoutItem*     dataLayout_;
	MgQSceneItem*      sceneItem_;

	bool pointInMagnifier_;
	QPointF magnifierScenePos_;
	float magnifierZoomFactor_;
	bool zoomWasPerformedAfterMouseRelease_; 
	
	vector<float>currentValues_;
};



#endif
