/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.gui.plaf.palette;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;
import org.apache.batik.ext.awt.LinearGradientPaint;
import org.apache.batik.ext.awt.MultipleGradientPaint;
import org.jhotdraw.gui.plaf.palette.PaletteLookAndFeel;

public class PaletteSliderUI
extends BasicSliderUI {
    private static final float[] enabledStops = new float[]{0.0f, 0.35f, 0.35f, 1.0f};
    private static final Color[] enabledStopColors = new Color[]{new Color(0xF3F3F3), new Color(0xCCCCCC), new Color(0xBABABA), new Color(0xF3F3F3)};
    private static final float[] disabledStops = new float[]{0.0f, 0.35f, 0.35f, 1.0f};
    private static final Color[] disabledStopColors = new Color[]{new Color(0xF3F3F3), new Color(0xEEEEEE), new Color(0xCACACA), new Color(0xF3F3F3)};
    private static final float[] selectedStops = new float[]{0.0f, 0.2f, 1.0f};
    private static final Color[] selectedStopColors = new Color[]{new Color(0x999999), new Color(0xAAAAAA), new Color(0x666666)};

    public static ComponentUI createUI(JComponent jComponent) {
        return new PaletteSliderUI((JSlider)jComponent);
    }

    public PaletteSliderUI(JSlider jSlider) {
        super(jSlider);
    }

    @Override
    protected void installDefaults(JSlider jSlider) {
        super.installDefaults(jSlider);
        PaletteLookAndFeel paletteLookAndFeel = PaletteLookAndFeel.getInstance();
        PaletteLookAndFeel.installBorder(jSlider, "Slider.border");
        PaletteLookAndFeel.installColors(jSlider, "Slider.background", "Slider.foreground");
    }

    @Override
    public Dimension getPreferredHorizontalSize() {
        Dimension dimension = (Dimension)PaletteLookAndFeel.getInstance().get("Slider.horizontalSize");
        if (dimension == null) {
            dimension = new Dimension(100, 21);
        }
        return dimension;
    }

    @Override
    public Dimension getPreferredVerticalSize() {
        Dimension dimension = (Dimension)PaletteLookAndFeel.getInstance().get("Slider.verticalSize");
        if (dimension == null) {
            dimension = new Dimension(21, 100);
        }
        return dimension;
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        super.paint(graphics2D, jComponent);
    }

    @Override
    public void paintFocus(Graphics graphics) {
    }

    @Override
    public void paintTrack(Graphics graphics) {
        Rectangle rectangle = this.trackRect;
        if (this.slider.getOrientation() == 0) {
            int n;
            int n2 = n = this.trackBuffer;
            int n3 = rectangle.height / 2 - 2;
            int n4 = rectangle.width;
            graphics.translate(rectangle.x, rectangle.y + n3);
            graphics.setColor(this.getShadowColor());
            graphics.drawLine(0, 0, n4 - 1, 0);
            graphics.drawLine(0, 1, 0, 2);
            graphics.setColor(this.getHighlightColor());
            graphics.drawLine(0, 3, n4, 3);
            graphics.drawLine(n4, 0, n4, 3);
            graphics.setColor(Color.black);
            graphics.drawLine(1, 1, n4 - 2, 1);
            graphics.translate(-rectangle.x, -(rectangle.y + n3));
        } else {
            int n = this.trackBuffer;
            int n5 = rectangle.width / 2 - 2;
            int n6 = n;
            int n7 = rectangle.height;
            graphics.setColor(new Color(this.slider.isEnabled() ? 0x888888 : 0xAAAAAA));
            graphics.drawRoundRect(rectangle.x + n5, rectangle.y, 5, n7, 5, 5);
        }
    }

    @Override
    public void paintThumb(Graphics graphics) {
        Color[] colorArray;
        float[] fArray;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Rectangle rectangle = this.thumbRect;
        int n = rectangle.width;
        int n2 = rectangle.height;
        graphics2D.translate(rectangle.x, rectangle.y);
        if (this.slider.isEnabled()) {
            graphics2D.setColor(this.slider.getBackground());
            if (this.slider.getModel().getValueIsAdjusting()) {
                fArray = selectedStops;
                colorArray = selectedStopColors;
            } else {
                fArray = enabledStops;
                colorArray = enabledStopColors;
            }
        } else {
            graphics2D.setColor(this.slider.getBackground().darker());
            fArray = enabledStops;
            colorArray = enabledStopColors;
        }
        Boolean bl = (Boolean)this.slider.getClientProperty("Slider.paintThumbArrowShape");
        if (!this.slider.getPaintTicks() && bl == null || bl == Boolean.FALSE) {
            LinearGradientPaint linearGradientPaint = new LinearGradientPaint(new Point2D.Float(2.0f, 2.0f), new Point2D.Float(2.0f, 2 + n2 - 4), fArray, colorArray, MultipleGradientPaint.REPEAT, MultipleGradientPaint.LINEAR_RGB);
            graphics2D.setPaint(linearGradientPaint);
            graphics2D.fillOval(2, 2, n - 4, n2 - 4);
            graphics2D.setColor(new Color(0x444444));
            graphics2D.drawOval(1, 1, n - 3, n2 - 3);
        } else if (this.slider.getOrientation() == 0) {
            int n3 = n / 2;
            graphics2D.fillRect(1, 1, n - 3, n2 - 1 - n3);
            Polygon polygon = new Polygon();
            polygon.addPoint(1, n2 - n3);
            polygon.addPoint(n3 - 1, n2 - 1);
            polygon.addPoint(n - 2, n2 - 1 - n3);
            graphics2D.fillPolygon(polygon);
            graphics2D.setColor(this.getHighlightColor());
            graphics2D.drawLine(0, 0, n - 2, 0);
            graphics2D.drawLine(0, 1, 0, n2 - 1 - n3);
            graphics2D.drawLine(0, n2 - n3, n3 - 1, n2 - 1);
            graphics2D.setColor(Color.black);
            graphics2D.drawLine(n - 1, 0, n - 1, n2 - 2 - n3);
            graphics2D.drawLine(n - 1, n2 - 1 - n3, n - 1 - n3, n2 - 1);
            graphics2D.setColor(this.getShadowColor());
            graphics2D.drawLine(n - 2, 1, n - 2, n2 - 2 - n3);
            graphics2D.drawLine(n - 2, n2 - 1 - n3, n - 1 - n3, n2 - 2);
        } else {
            int n4 = n2 / 2;
            if (this.slider.getComponentOrientation().isLeftToRight()) {
                graphics2D.fillRect(1, 1, n - 1 - n4, n2 - 3);
                Polygon polygon = new Polygon();
                polygon.addPoint(n - n4 - 1, 0);
                polygon.addPoint(n - 1, n4);
                polygon.addPoint(n - 1 - n4, n2 - 2);
                graphics2D.fillPolygon(polygon);
                graphics2D.setColor(this.getHighlightColor());
                graphics2D.drawLine(0, 0, 0, n2 - 2);
                graphics2D.drawLine(1, 0, n - 1 - n4, 0);
                graphics2D.drawLine(n - n4 - 1, 0, n - 1, n4);
                graphics2D.setColor(Color.black);
                graphics2D.drawLine(0, n2 - 1, n - 2 - n4, n2 - 1);
                graphics2D.drawLine(n - 1 - n4, n2 - 1, n - 1, n2 - 1 - n4);
                graphics2D.setColor(this.getShadowColor());
                graphics2D.drawLine(1, n2 - 2, n - 2 - n4, n2 - 2);
                graphics2D.drawLine(n - 1 - n4, n2 - 2, n - 2, n2 - n4 - 1);
            } else {
                graphics2D.fillRect(5, 1, n - 1 - n4, n2 - 3);
                Polygon polygon = new Polygon();
                polygon.addPoint(n4, 0);
                polygon.addPoint(0, n4);
                polygon.addPoint(n4, n2 - 2);
                graphics2D.fillPolygon(polygon);
                graphics2D.setColor(this.getHighlightColor());
                graphics2D.drawLine(n4 - 1, 0, n - 2, 0);
                graphics2D.drawLine(0, n4, n4, 0);
                graphics2D.setColor(Color.black);
                graphics2D.drawLine(0, n2 - 1 - n4, n4, n2 - 1);
                graphics2D.drawLine(n4, n2 - 1, n - 1, n2 - 1);
                graphics2D.setColor(this.getShadowColor());
                graphics2D.drawLine(n4, n2 - 2, n - 2, n2 - 2);
                graphics2D.drawLine(n - 1, 1, n - 1, n2 - 2);
            }
        }
        graphics2D.translate(-rectangle.x, -rectangle.y);
    }

    @Override
    protected Dimension getThumbSize() {
        Dimension dimension = new Dimension();
        if (this.slider.getOrientation() == 1) {
            dimension.width = 15;
            dimension.height = 15;
        } else {
            dimension.width = 15;
            dimension.height = 15;
        }
        return dimension;
    }
}

