/* moonshot-utils.c generated by valac 0.34.9, the Vala compiler
 * generated from moonshot-utils.vala, do not modify */

/*
 * Copyright (c) 2011-2016, JANET(UK)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * 3. Neither the name of JANET(UK) nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <stdio.h>
#include <glib/gstdio.h>
#include <gdk/gdk.h>
#include <atk/atk.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <pango/pango.h>


#define TYPE_ID_CARD (id_card_get_type ())
#define ID_CARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ID_CARD, IdCard))
#define ID_CARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ID_CARD, IdCardClass))
#define IS_ID_CARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ID_CARD))
#define IS_ID_CARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ID_CARD))
#define ID_CARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ID_CARD, IdCardClass))

typedef struct _IdCard IdCard;
typedef struct _IdCardClass IdCardClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))


extern gboolean gtk_available;
gboolean gtk_available = FALSE;
extern GdkColor white;
GdkColor white = {0};

GdkPixbuf* find_icon_sized (const gchar* name, GtkIconSize icon_size);
GdkPixbuf* find_icon (const gchar* name, gint size);
GType id_card_get_type (void) G_GNUC_CONST;
GdkPixbuf* get_pixbuf (IdCard* id);
const gchar* GetUserName (void);
const gchar* GetFlatStoreUsersFilePath (void);
gboolean UserForcesFlatFileStore (void);
void make_color (guint16 red, guint16 green, guint16 blue, GdkColor* result);
void set_atk_relation (GtkWidget* widget, GtkWidget* target_widget, AtkRelationType relationship);
GtkWidget* make_ta_fingerprint_widget (const gchar* server_cert, const gchar* label_text);
gchar* colonize (const gchar* input, gint bytes_per_line);
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
void clear_password_entry (GtkEntry* entry);
void set_bg_color (GtkWidget* w);


GdkPixbuf* find_icon_sized (const gchar* name, GtkIconSize icon_size) {
	GdkPixbuf* result = NULL;
	gint width = 0;
	gint height = 0;
	GtkIconSize _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	const gchar* _tmp3_ = NULL;
	GdkPixbuf* _tmp4_ = NULL;
#line 40 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 43 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	_tmp0_ = icon_size;
#line 43 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	gtk_icon_size_lookup (_tmp0_, &_tmp1_, &_tmp2_);
#line 43 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	width = _tmp1_;
#line 43 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	height = _tmp2_;
#line 44 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	_tmp3_ = name;
#line 44 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	_tmp4_ = find_icon (_tmp3_, width);
#line 44 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	result = _tmp4_;
#line 44 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	return result;
#line 118 "moonshot-utils.c"
}


GdkPixbuf* get_pixbuf (IdCard* id) {
	GdkPixbuf* result = NULL;
	GdkPixbuf* _tmp0_ = NULL;
#line 54 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 56 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	_tmp0_ = find_icon ("avatar-default", 48);
#line 56 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	result = _tmp0_;
#line 56 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	return result;
#line 133 "moonshot-utils.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 77 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	return self ? g_object_ref (self) : NULL;
#line 140 "moonshot-utils.c"
}


GdkPixbuf* find_icon (const gchar* name, gint size) {
	GdkPixbuf* result = NULL;
	gboolean _tmp0_ = FALSE;
	GError * _inner_error_ = NULL;
#line 59 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 61 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	_tmp0_ = gtk_available;
#line 61 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	if (!_tmp0_) {
#line 62 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
		result = NULL;
#line 62 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
		return result;
#line 158 "moonshot-utils.c"
	}
	{
		GtkIconTheme* icon_theme = NULL;
		GtkIconTheme* _tmp1_ = NULL;
		GtkIconTheme* _tmp2_ = NULL;
		GdkPixbuf* _tmp3_ = NULL;
		GtkIconTheme* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		GdkPixbuf* _tmp7_ = NULL;
		GdkPixbuf* _tmp8_ = NULL;
#line 77 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
		_tmp1_ = gtk_icon_theme_get_default ();
#line 77 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
		_tmp2_ = _g_object_ref0 (_tmp1_);
#line 77 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
		icon_theme = _tmp2_;
#line 78 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
		_tmp4_ = icon_theme;
#line 78 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
		_tmp5_ = name;
#line 78 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
		_tmp6_ = size;
#line 78 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
		_tmp7_ = gtk_icon_theme_load_icon (_tmp4_, _tmp5_, _tmp6_, GTK_ICON_LOOKUP_FORCE_SIZE, &_inner_error_);
#line 78 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
		_tmp3_ = _tmp7_;
#line 78 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 78 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
			_g_object_unref0 (icon_theme);
#line 190 "moonshot-utils.c"
			goto __catch20_g_error;
		}
#line 78 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
		_tmp8_ = _tmp3_;
#line 78 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
		_tmp3_ = NULL;
#line 78 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
		result = _tmp8_;
#line 78 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
		_g_object_unref0 (_tmp3_);
#line 78 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
		_g_object_unref0 (icon_theme);
#line 78 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
		return result;
#line 205 "moonshot-utils.c"
	}
	goto __finally20;
	__catch20_g_error:
	{
		GError* e = NULL;
		FILE* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		GError* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
#line 63 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
		e = _inner_error_;
#line 63 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
		_inner_error_ = NULL;
#line 83 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
		_tmp9_ = stdout;
#line 83 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
		_tmp10_ = name;
#line 83 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
		_tmp11_ = e;
#line 83 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
		_tmp12_ = _tmp11_->message;
#line 83 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
		fprintf (_tmp9_, "Error loading icon '%s': %s\n", _tmp10_, _tmp12_);
#line 84 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
		result = NULL;
#line 84 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
		_g_error_free0 (e);
#line 84 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
		return result;
#line 235 "moonshot-utils.c"
	}
	__finally20:
#line 63 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 63 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	g_clear_error (&_inner_error_);
#line 63 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	return NULL;
#line 244 "moonshot-utils.c"
}


static gchar* g_file_stream_read_line (FILE* self) {
	gchar* result = NULL;
	gint c = 0;
	GString* ret = NULL;
	GString* _tmp7_ = NULL;
#line 3459 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 3461 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	ret = NULL;
#line 3462 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	while (TRUE) {
#line 259 "moonshot-utils.c"
		gint _tmp0_ = 0;
		gint _tmp1_ = 0;
		GString* _tmp2_ = NULL;
		gint _tmp4_ = 0;
		GString* _tmp5_ = NULL;
		gint _tmp6_ = 0;
#line 3462 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp0_ = fgetc (self);
#line 3462 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		c = _tmp0_;
#line 3462 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp1_ = c;
#line 3462 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		if (!(_tmp1_ != EOF)) {
#line 3462 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			break;
#line 276 "moonshot-utils.c"
		}
#line 3463 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp2_ = ret;
#line 3463 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		if (_tmp2_ == NULL) {
#line 282 "moonshot-utils.c"
			GString* _tmp3_ = NULL;
#line 3464 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			_tmp3_ = g_string_new ("");
#line 3464 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			_g_string_free0 (ret);
#line 3464 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			ret = _tmp3_;
#line 290 "moonshot-utils.c"
		}
#line 3466 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp4_ = c;
#line 3466 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		if (_tmp4_ == ((gint) '\n')) {
#line 3467 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			break;
#line 298 "moonshot-utils.c"
		}
#line 3469 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp5_ = ret;
#line 3469 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp6_ = c;
#line 3469 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		g_string_append_c ((GString*) _tmp5_, (gchar) _tmp6_);
#line 306 "moonshot-utils.c"
	}
#line 3471 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp7_ = ret;
#line 3471 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp7_ == NULL) {
#line 3472 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		result = NULL;
#line 3472 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_g_string_free0 (ret);
#line 3472 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		return result;
#line 318 "moonshot-utils.c"
	} else {
		GString* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
#line 3474 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp8_ = ret;
#line 3474 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp9_ = ((GString*) _tmp8_)->str;
#line 3474 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp10_ = g_strdup (_tmp9_);
#line 3474 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		result = _tmp10_;
#line 3474 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_g_string_free0 (ret);
#line 3474 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		return result;
#line 335 "moonshot-utils.c"
	}
#line 3459 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_g_string_free0 (ret);
#line 339 "moonshot-utils.c"
}


gboolean UserForcesFlatFileStore (void) {
	gboolean result = FALSE;
	gchar* username = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* flatstore_users_filename = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	FILE* flatstore_users = NULL;
	const gchar* _tmp4_ = NULL;
	FILE* _tmp5_ = NULL;
	FILE* _tmp6_ = NULL;
	gchar* flatstore_username = NULL;
#line 93 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	_tmp0_ = GetUserName ();
#line 93 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 93 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	username = _tmp1_;
#line 94 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	_tmp2_ = GetFlatStoreUsersFilePath ();
#line 94 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 94 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	flatstore_users_filename = _tmp3_;
#line 95 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	_tmp4_ = flatstore_users_filename;
#line 95 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	_tmp5_ = g_fopen (_tmp4_, "r");
#line 95 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	flatstore_users = _tmp5_;
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	_tmp6_ = flatstore_users;
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	if (_tmp6_ == NULL) {
#line 97 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
		result = FALSE;
#line 97 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
		_fclose0 (flatstore_users);
#line 97 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
		_g_free0 (flatstore_users_filename);
#line 97 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
		_g_free0 (username);
#line 97 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
		return result;
#line 388 "moonshot-utils.c"
	}
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	flatstore_username = NULL;
#line 100 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	while (TRUE) {
#line 394 "moonshot-utils.c"
		FILE* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
#line 100 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
		_tmp7_ = flatstore_users;
#line 100 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
		_tmp8_ = g_file_stream_read_line (_tmp7_);
#line 100 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
		_g_free0 (flatstore_username);
#line 100 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
		flatstore_username = _tmp8_;
#line 100 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
		_tmp9_ = flatstore_username;
#line 100 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
		if (!(_tmp9_ != NULL)) {
#line 100 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
			break;
#line 414 "moonshot-utils.c"
		}
#line 101 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
		_tmp10_ = username;
#line 101 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
		_tmp11_ = flatstore_username;
#line 101 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
		if (g_strcmp0 (_tmp10_, _tmp11_) == 0) {
#line 102 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
			result = TRUE;
#line 102 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
			_g_free0 (flatstore_username);
#line 102 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
			_fclose0 (flatstore_users);
#line 102 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
			_g_free0 (flatstore_users_filename);
#line 102 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
			_g_free0 (username);
#line 102 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
			return result;
#line 434 "moonshot-utils.c"
		}
	}
#line 105 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	result = FALSE;
#line 105 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	_g_free0 (flatstore_username);
#line 105 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	_fclose0 (flatstore_users);
#line 105 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	_g_free0 (flatstore_users_filename);
#line 105 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	_g_free0 (username);
#line 105 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	return result;
#line 449 "moonshot-utils.c"
}


void make_color (guint16 red, guint16 green, guint16 blue, GdkColor* result) {
	GdkColor color = {0};
	guint16 _tmp0_ = 0U;
	guint16 _tmp1_ = 0U;
	guint16 _tmp2_ = 0U;
#line 110 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	memset (&color, 0, sizeof (GdkColor));
#line 111 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	_tmp0_ = red;
#line 111 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	color.red = _tmp0_;
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	_tmp1_ = green;
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	color.green = _tmp1_;
#line 113 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	_tmp2_ = blue;
#line 113 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	color.blue = _tmp2_;
#line 115 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	*result = color;
#line 115 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	return;
#line 476 "moonshot-utils.c"
}


void set_atk_relation (GtkWidget* widget, GtkWidget* target_widget, AtkRelationType relationship) {
	AtkObject* atk_widget = NULL;
	GtkWidget* _tmp0_ = NULL;
	AtkObject* _tmp1_ = NULL;
	AtkObject* _tmp2_ = NULL;
	AtkObject* atk_target_widget = NULL;
	GtkWidget* _tmp3_ = NULL;
	AtkObject* _tmp4_ = NULL;
	AtkObject* _tmp5_ = NULL;
	AtkRelationType _tmp6_ = 0;
#line 118 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	g_return_if_fail (widget != NULL);
#line 118 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	g_return_if_fail (target_widget != NULL);
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	_tmp0_ = widget;
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	_tmp1_ = gtk_widget_get_accessible (_tmp0_);
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	atk_widget = _tmp2_;
#line 121 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	_tmp3_ = target_widget;
#line 121 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	_tmp4_ = gtk_widget_get_accessible (_tmp3_);
#line 121 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 121 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	atk_target_widget = _tmp5_;
#line 123 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	_tmp6_ = relationship;
#line 123 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	atk_object_add_relationship (atk_widget, _tmp6_, atk_target_widget);
#line 118 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	_g_object_unref0 (atk_target_widget);
#line 118 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	_g_object_unref0 (atk_widget);
#line 518 "moonshot-utils.c"
}


static void _vala_PangoFontDescription_free (PangoFontDescription* self) {
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	g_boxed_free (pango_font_description_get_type (), self);
#line 525 "moonshot-utils.c"
}


GtkWidget* make_ta_fingerprint_widget (const gchar* server_cert, const gchar* label_text) {
	GtkWidget* result = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkLabel* fingerprint_label = NULL;
	GtkLabel* _tmp3_ = NULL;
	GtkTextView* fingerprint = NULL;
	GtkTextView* _tmp4_ = NULL;
	PangoFontDescription* fontdesc = NULL;
	PangoFontDescription* _tmp5_ = NULL;
	GtkTextBuffer* buffer = NULL;
	GtkTextBuffer* _tmp6_ = NULL;
	GtkTextBuffer* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	GtkScrolledWindow* fingerprint_width_constraint = NULL;
	GtkScrolledWindow* _tmp11_ = NULL;
	GtkVBox* vbox = NULL;
	GtkVBox* _tmp12_ = NULL;
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	g_return_val_if_fail (server_cert != NULL, NULL);
#line 129 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	_tmp1_ = label_text;
#line 129 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	_tmp0_ = _tmp1_;
#line 129 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	if (_tmp0_ == NULL) {
#line 557 "moonshot-utils.c"
		const gchar* _tmp2_ = NULL;
#line 129 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
		_tmp2_ = _ ("SHA-256 fingerprint:");
#line 129 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
		_tmp0_ = _tmp2_;
#line 563 "moonshot-utils.c"
	}
#line 129 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	_tmp3_ = (GtkLabel*) gtk_label_new (_tmp0_);
#line 129 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	g_object_ref_sink (_tmp3_);
#line 129 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	fingerprint_label = _tmp3_;
#line 130 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	gtk_misc_set_alignment ((GtkMisc*) fingerprint_label, (gfloat) 0, 0.5f);
#line 132 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	_tmp4_ = (GtkTextView*) gtk_text_view_new ();
#line 132 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	g_object_ref_sink (_tmp4_);
#line 132 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	fingerprint = _tmp4_;
#line 133 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	_tmp5_ = pango_font_description_from_string ("monospace 10");
#line 133 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	fontdesc = _tmp5_;
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	gtk_widget_modify_font ((GtkWidget*) fingerprint, fontdesc);
#line 135 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	gtk_text_view_set_editable (fingerprint, FALSE);
#line 136 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	gtk_text_view_set_left_margin (fingerprint, 3);
#line 137 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	_tmp6_ = gtk_text_view_get_buffer (fingerprint);
#line 137 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	_tmp7_ = _g_object_ref0 (_tmp6_);
#line 137 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	buffer = _tmp7_;
#line 138 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	_tmp8_ = server_cert;
#line 138 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	_tmp9_ = colonize (_tmp8_, 16);
#line 138 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	_tmp10_ = _tmp9_;
#line 138 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	gtk_text_buffer_set_text (buffer, _tmp10_, -1);
#line 138 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	_g_free0 (_tmp10_);
#line 139 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	gtk_text_view_set_wrap_mode (fingerprint, GTK_WRAP_WORD_CHAR);
#line 141 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	set_atk_relation ((GtkWidget*) fingerprint_label, (GtkWidget*) fingerprint, ATK_RELATION_LABEL_FOR);
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	_tmp11_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	g_object_ref_sink (_tmp11_);
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	fingerprint_width_constraint = _tmp11_;
#line 144 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	gtk_scrolled_window_set_policy (fingerprint_width_constraint, GTK_POLICY_NEVER, GTK_POLICY_NEVER);
#line 145 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	gtk_scrolled_window_set_shadow_type (fingerprint_width_constraint, GTK_SHADOW_IN);
#line 146 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	gtk_widget_set_size_request ((GtkWidget*) fingerprint_width_constraint, 360, 60);
#line 147 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	gtk_scrolled_window_add_with_viewport (fingerprint_width_constraint, (GtkWidget*) fingerprint);
#line 149 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	_tmp12_ = (GtkVBox*) gtk_vbox_new (FALSE, 0);
#line 149 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	g_object_ref_sink (_tmp12_);
#line 149 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	vbox = _tmp12_;
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) fingerprint_label, TRUE, TRUE, (guint) 2);
#line 151 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) fingerprint_width_constraint, TRUE, TRUE, (guint) 2);
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	result = (GtkWidget*) vbox;
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	_g_object_unref0 (fingerprint_width_constraint);
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	_g_object_unref0 (buffer);
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	__vala_PangoFontDescription_free0 (fontdesc);
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	_g_object_unref0 (fingerprint);
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	_g_object_unref0 (fingerprint_label);
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	return result;
#line 647 "moonshot-utils.c"
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_ = 0L;
	glong _tmp16_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	gchar* _tmp21_ = NULL;
#line 1336 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1337 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1337 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1337 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1338 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp2_ = start;
#line 1338 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp2_ < ((glong) 0)) {
#line 680 "moonshot-utils.c"
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
#line 1339 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp3_ = string_length;
#line 1339 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp4_ = start;
#line 1339 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		start = _tmp3_ + _tmp4_;
#line 689 "moonshot-utils.c"
	}
#line 1341 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp5_ = end;
#line 1341 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp5_ < ((glong) 0)) {
#line 695 "moonshot-utils.c"
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
#line 1342 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp6_ = string_length;
#line 1342 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp7_ = end;
#line 1342 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		end = _tmp6_ + _tmp7_;
#line 704 "moonshot-utils.c"
	}
#line 1344 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp9_ = start;
#line 1344 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp9_ >= ((glong) 0)) {
#line 710 "moonshot-utils.c"
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
#line 1344 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp10_ = start;
#line 1344 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp11_ = string_length;
#line 1344 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp10_ <= _tmp11_;
#line 719 "moonshot-utils.c"
	} else {
#line 1344 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp8_ = FALSE;
#line 723 "moonshot-utils.c"
	}
#line 1344 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp8_, NULL);
#line 1345 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp13_ = end;
#line 1345 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp13_ >= ((glong) 0)) {
#line 731 "moonshot-utils.c"
		glong _tmp14_ = 0L;
		glong _tmp15_ = 0L;
#line 1345 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp14_ = end;
#line 1345 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1345 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp12_ = _tmp14_ <= _tmp15_;
#line 740 "moonshot-utils.c"
	} else {
#line 1345 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp12_ = FALSE;
#line 744 "moonshot-utils.c"
	}
#line 1345 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp12_, NULL);
#line 1346 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp16_ = start;
#line 1346 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp17_ = end;
#line 1346 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
#line 1347 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp18_ = start;
#line 1347 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp19_ = end;
#line 1347 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp20_ = start;
#line 1347 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
#line 1347 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	result = _tmp21_;
#line 1347 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	return result;
#line 766 "moonshot-utils.c"
}


gchar* colonize (const gchar* input, gint bytes_per_line) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gchar* _result_ = NULL;
	gchar* _tmp3_ = NULL;
	gint i = 0;
	gint line_bytes = 0;
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	g_return_val_if_fail (input != NULL, NULL);
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	_tmp0_ = input;
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	_tmp1_ = strlen (_tmp0_);
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	_tmp2_ = _tmp1_;
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	g_return_if_fail ((_tmp2_ % 2) == 0);
#line 159 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	_tmp3_ = g_strdup ("");
#line 159 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	_result_ = _tmp3_;
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	i = 0;
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	line_bytes = 0;
#line 162 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	while (TRUE) {
#line 799 "moonshot-utils.c"
		gint _tmp4_ = 0;
		const gchar* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		const gchar* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		gint _tmp17_ = 0;
		gint _tmp18_ = 0;
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		gint _tmp22_ = 0;
		gint _tmp23_ = 0;
#line 162 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
		_tmp4_ = i;
#line 162 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
		_tmp5_ = input;
#line 162 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
		_tmp6_ = strlen (_tmp5_);
#line 162 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
		_tmp7_ = _tmp6_;
#line 162 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
		if (!(_tmp4_ < _tmp7_)) {
#line 162 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
			break;
#line 827 "moonshot-utils.c"
		}
#line 163 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
		_tmp8_ = line_bytes;
#line 163 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
		_tmp9_ = bytes_per_line;
#line 163 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
		if (_tmp8_ == _tmp9_) {
#line 835 "moonshot-utils.c"
			const gchar* _tmp10_ = NULL;
			gchar* _tmp11_ = NULL;
#line 164 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
			_tmp10_ = _result_;
#line 164 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
			_tmp11_ = g_strconcat (_tmp10_, "\n", NULL);
#line 164 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
			_g_free0 (_result_);
#line 164 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
			_result_ = _tmp11_;
#line 165 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
			line_bytes = 0;
#line 848 "moonshot-utils.c"
		} else {
			gint _tmp12_ = 0;
#line 167 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
			_tmp12_ = i;
#line 167 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
			if (_tmp12_ > 0) {
#line 855 "moonshot-utils.c"
				const gchar* _tmp13_ = NULL;
				gchar* _tmp14_ = NULL;
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
				_tmp13_ = _result_;
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
				_tmp14_ = g_strconcat (_tmp13_, ":", NULL);
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
				_g_free0 (_result_);
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
				_result_ = _tmp14_;
#line 866 "moonshot-utils.c"
			}
		}
#line 170 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
		_tmp15_ = _result_;
#line 170 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
		_tmp16_ = input;
#line 170 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
		_tmp17_ = i;
#line 170 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
		_tmp18_ = i;
#line 170 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
		_tmp19_ = string_slice (_tmp16_, (glong) _tmp17_, (glong) (_tmp18_ + 2));
#line 170 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
		_tmp20_ = _tmp19_;
#line 170 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
		_tmp21_ = g_strconcat (_tmp15_, _tmp20_, NULL);
#line 170 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
		_g_free0 (_result_);
#line 170 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
		_result_ = _tmp21_;
#line 170 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
		_g_free0 (_tmp20_);
#line 171 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
		_tmp22_ = i;
#line 171 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
		i = _tmp22_ + 2;
#line 172 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
		_tmp23_ = line_bytes;
#line 172 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
		line_bytes = _tmp23_ + 1;
#line 897 "moonshot-utils.c"
	}
#line 174 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	result = _result_;
#line 174 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	return result;
#line 903 "moonshot-utils.c"
}


static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res = NULL;
	gint res_length1 = 0;
	gint _res_size_ = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	guint8* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	guint8* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
#line 1406 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1407 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	res = (guint8*) self;
#line 1407 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	res_length1 = -1;
#line 1407 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_res_size_ = res_length1;
#line 1408 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1408 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1408 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	res_length1 = (gint) _tmp1_;
#line 1408 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp2_ = res_length1;
#line 1409 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp3_ = res;
#line 1409 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp3__length1 = res_length1;
#line 1409 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp4_ = _tmp3_;
#line 1409 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp4__length1 = _tmp3__length1;
#line 1409 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (result_length1) {
#line 1409 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		*result_length1 = _tmp4__length1;
#line 947 "moonshot-utils.c"
	}
#line 1409 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	result = _tmp4_;
#line 1409 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	return result;
#line 953 "moonshot-utils.c"
}


void clear_password_entry (GtkEntry* entry) {
	gint len = 0;
	GtkEntry* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gchar* random_chars = NULL;
	gint _tmp4_ = 0;
	gchar* _tmp5_ = NULL;
	gint random_chars_length1 = 0;
	gint _random_chars_size_ = 0;
	gchar* _tmp14_ = NULL;
	gint _tmp14__length1 = 0;
	gint _tmp15_ = 0;
	gchar _tmp16_ = '\0';
	gchar* r = NULL;
	gchar* _tmp17_ = NULL;
	gint _tmp17__length1 = 0;
	gchar* _tmp18_ = NULL;
	GtkEntryBuffer* buf = NULL;
	GtkEntry* _tmp19_ = NULL;
	GtkEntryBuffer* _tmp20_ = NULL;
	GtkEntryBuffer* _tmp21_ = NULL;
	guint8* _tmp22_ = NULL;
	gint _tmp22__length1 = 0;
	guint8* _tmp23_ = NULL;
	gint _tmp23__length1 = 0;
	gint _tmp24_ = 0;
#line 177 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	g_return_if_fail (entry != NULL);
#line 180 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	_tmp0_ = entry;
#line 180 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	_tmp1_ = gtk_entry_get_text (_tmp0_);
#line 180 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	_tmp2_ = strlen (_tmp1_);
#line 180 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	_tmp3_ = _tmp2_;
#line 180 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	len = _tmp3_;
#line 181 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	_tmp4_ = len;
#line 181 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	_tmp5_ = g_new0 (gchar, _tmp4_ + 1);
#line 181 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	random_chars = _tmp5_;
#line 181 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	random_chars_length1 = _tmp4_ + 1;
#line 181 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	_random_chars_size_ = random_chars_length1;
#line 1007 "moonshot-utils.c"
	{
		gint i = 0;
#line 182 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
		i = 0;
#line 1012 "moonshot-utils.c"
		{
			gboolean _tmp6_ = FALSE;
#line 182 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
			_tmp6_ = TRUE;
#line 182 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
			while (TRUE) {
#line 1019 "moonshot-utils.c"
				gint _tmp8_ = 0;
				gint _tmp9_ = 0;
				gchar* _tmp10_ = NULL;
				gint _tmp10__length1 = 0;
				gint _tmp11_ = 0;
				gint32 _tmp12_ = 0;
				gchar _tmp13_ = '\0';
#line 182 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
				if (!_tmp6_) {
#line 1029 "moonshot-utils.c"
					gint _tmp7_ = 0;
#line 182 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
					_tmp7_ = i;
#line 182 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
					i = _tmp7_ + 1;
#line 1035 "moonshot-utils.c"
				}
#line 182 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
				_tmp6_ = FALSE;
#line 182 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
				_tmp8_ = i;
#line 182 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
				_tmp9_ = len;
#line 182 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
				if (!(_tmp8_ < _tmp9_)) {
#line 182 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
					break;
#line 1047 "moonshot-utils.c"
				}
#line 183 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
				_tmp10_ = random_chars;
#line 183 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
				_tmp10__length1 = random_chars_length1;
#line 183 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
				_tmp11_ = i;
#line 183 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
				_tmp12_ = g_random_int_range ((gint32) 40, (gint32) 127);
#line 183 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
				_tmp10_[_tmp11_] = (gchar) _tmp12_;
#line 183 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
				_tmp13_ = _tmp10_[_tmp11_];
#line 1061 "moonshot-utils.c"
			}
		}
	}
#line 185 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	_tmp14_ = random_chars;
#line 185 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	_tmp14__length1 = random_chars_length1;
#line 185 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	_tmp15_ = len;
#line 185 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	_tmp14_[_tmp15_] = (gchar) 0;
#line 185 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	_tmp16_ = _tmp14_[_tmp15_];
#line 186 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	_tmp17_ = random_chars;
#line 186 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	_tmp17__length1 = random_chars_length1;
#line 186 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	_tmp18_ = g_strdup ((const gchar*) _tmp17_);
#line 186 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	r = _tmp18_;
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	_tmp19_ = entry;
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	_tmp20_ = gtk_entry_get_buffer (_tmp19_);
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	_tmp21_ = _g_object_ref0 (_tmp20_);
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	buf = _tmp21_;
#line 188 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	_tmp22_ = string_get_data (r, &_tmp22__length1);
#line 188 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	_tmp23_ = _tmp22_;
#line 188 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	_tmp23__length1 = _tmp22__length1;
#line 188 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	gtk_entry_buffer_set_text (buf, _tmp23_, _tmp23__length1);
#line 191 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	_tmp24_ = len;
#line 191 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	gtk_entry_buffer_delete_text (buf, (guint) 0, _tmp24_);
#line 177 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	_g_object_unref0 (buf);
#line 177 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	_g_free0 (r);
#line 177 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	random_chars = (g_free (random_chars), NULL);
#line 1109 "moonshot-utils.c"
}


void set_bg_color (GtkWidget* w) {
#line 195 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-utils.vala"
	g_return_if_fail (w != NULL);
#line 1116 "moonshot-utils.c"
}



