#!/bin/sh
#
# srecord - Manipulate EPROM load files
# Copyright (C) 2012 Peter Miller
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or (at
# your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.
#

TEST_SUBJECT="trs80 long data records"
. test_prelude

cat > test.in.srec << 'fubar'
S00600004844521B
S1230000051200006F6F2C206C6F6F6B2C207368696E79210102000000000000000000004B
S12300200000000000000000000000000000000000000000000000000000000000000000BC
S123004000000000000000000000000000000000000000000000000000000000000000009C
S123006000000000000000000000000000000000000000000000000000000000000000007C
S123008000000000000000000000000000000000000000000000000000000000000000005C
S12300A000000000000000000000000000000000000000000000000000000000000000003C
S12300C000000000000000000000000000000000000000000000000000000000000000001C
S12300E00000000000000000000000000000000000000000000000000000000000000000FC
S11F010000000000000000000000000000000000000000000000000003020000DA
S5030009F3
S9030000FC
fubar
if test $? -ne 0; then no_result; fi

srec_cat test.in.srec -o test.in -bin
if test $? -ne 0; then no_result; fi

cat > test.ok << 'fubar'
S01300006F6F2C206C6F6F6B2C207368696E792175
S12300000000000000000000000000000000000000000000000000000000000000000000DC
S12300200000000000000000000000000000000000000000000000000000000000000000BC
S123004000000000000000000000000000000000000000000000000000000000000000009C
S123006000000000000000000000000000000000000000000000000000000000000000007C
S123008000000000000000000000000000000000000000000000000000000000000000005C
S12300A000000000000000000000000000000000000000000000000000000000000000003C
S12300C000000000000000000000000000000000000000000000000000000000000000001C
S12300E00000000000000000000000000000000000000000000000000000000000000000FC
S5030008F4
S9030000FC
fubar
if test $? -ne 0; then no_result; fi

srec_cat test.in -trs80 -o test.out
if test $? -ne 0; then fail; fi

diff test.ok test.out
if test $? -ne 0; then fail; fi

#
# The things tested here, worked.
# No other guarantees are made.
#
pass

# vim: set ts=8 sw=4 et :
