/* ====================================================================
 * Copyright (c) 2009  Martin Hauner
 *                     http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "subcommander/wcview/ItemModel.h"
#include "subcommander-test/WcViewItemTest.h"
#include "sublib/OStreamQt.h"
#include "util-test/Link.h"
EXPORT_TESTCASE (AnyModel);

// gmock
#include <gmock/gmock.h>
using testing::_;
using testing::Return;


namespace wcview
{

class MockItemData : public WcViewItemData
{
public:
  MOCK_CONST_METHOD0(columns, int());
  MOCK_CONST_METHOD2(data, QString(int,const WcViewItem*));
  MOCK_CONST_METHOD2(color, QColor(int,const WcViewItem*));
  MOCK_CONST_METHOD2(dataSort, QVariant(int,const WcViewItem*));
  MOCK_CONST_METHOD1(header, QString(int));
  MOCK_CONST_METHOD1(alignment, Qt::Alignment(int));
  MOCK_CONST_METHOD1(deep, bool(int));
};



class AnyModel : public ::testing::Test
{
protected:
  AnyModel() 
    : _model(sc::String("invisible/root"), &_mockData)
  {
  }

protected:
  MockItemData _mockData;
  ItemModel    _model;
};


TEST_F (AnyModel,shouldDelegateColumnCountToWcViewItemData)
{
  EXPECT_CALL(_mockData, columns())
    .Times(1).WillOnce(Return(2));

  EXPECT_EQ (2,_model.columnCount (QModelIndex ()));
}

TEST_F (AnyModel,shouldDelegateHeaderDataToWcViewItemData)
{
  QString one("one"), two("two");

  EXPECT_CALL(_mockData, header(0))
    .Times(1).WillOnce(Return(one));
  EXPECT_CALL(_mockData, header(1))
    .Times(1).WillOnce(Return(two));

  EXPECT_EQ(one,
    _model.headerData(0,Qt::Horizontal,Qt::DisplayRole).toString());
  EXPECT_EQ(two,
    _model.headerData(1,Qt::Horizontal,Qt::DisplayRole).toString());
}


} // namespace
