/* ====================================================================
 * Copyright (c) 2009       Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_WCVIEW_ITEMFOLDER_H
#define _SC_WCVIEW_ITEMFOLDER_H

// sc
#include "Item.h"

namespace wcview
{

class Target
{
public:
  void addedAt (Item* parent, Index row);
};

class ItemFolder : public Item
{
public:
  ItemFolder (const WcViewItemPtr& item, Item* parent);
  virtual ~ItemFolder ();

  const sc::String& getName () const;
  const WcViewItemPtr& getViewItem () const;

  Item* getParent () const;
  Index getParentIndex () const;

  Index getChildCount () const;
  Item* getChild (const Index& index) const;
  Item* getChild (const sc::String& name) const;
  Index getChildIndex (const sc::String& name) const;

  void insertChild (Item* item);
  void insertChild (Item* item, Target* t);

  //Index getIndexInParent ();
  //Index getChildIndex (const sc::String& name) const;

  //Item* findParent( const WcViewItemPtr& item ) const;
  //const Item* getItem(const sc::String& item) const;
  //const Item* addItem(const WcViewItemPtr& item);

private:
#if 0
  bool isDirectChild(const sc::String& path) const;
  const Item* addDirectChild(const WcViewItemPtr& item);
  const Item* addDeepChild(const WcViewItemPtr& item);
  sc::String getIntermediatePath(const sc::String& path) const;
#endif

  WcViewItemPtr _item;
  Item*         _parent;

  class Childs;
  Childs* _childs;
};

} // namespace

#endif // _SC_WCVIEW_ITEMFOLDER_H
