/* ====================================================================
 * Copyright (c) 2008       Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#include "LayoutSettingsHandlerTest.h"

// cppunit
#include <cppunit/TestSuite.h>
#include <cppunit/TestCaller.h>

// sc
#include "TestConfig.h"
#include "sublib/settings/LayoutSettingsHandler.h"
#include "sublib/config/ConfigData.h"


void LayoutSettingsHandlerTest::setUp()
{
  _tconf = new TestConfig();
  _cdata = new ConfigData(_tconf);
}

void LayoutSettingsHandlerTest::tearDown()
{
  delete _cdata;
  delete _tconf;
}

void LayoutSettingsHandlerTest::getExistingQByteArray()
{
  QByteArray src( "Wow, a QByteArray" );

  LayoutSettingsHandler::
    setByteArray( _cdata, "bytearray", src );

  QByteArray dst = LayoutSettingsHandler::
    getByteArray( _cdata, "bytearray", QByteArray() );

  CPPUNIT_ASSERT_EQUAL( true, src == dst );
}

void LayoutSettingsHandlerTest::getMissingQByteArray()
{
  QByteArray src( "def" );

  QByteArray dst = LayoutSettingsHandler::
    getByteArray( _cdata, "bytearray", src );

  CPPUNIT_ASSERT_EQUAL( true, src == dst );
}
