/* XRACER (C) 1999-2000 Richard W.M. Jones <rich@annexia.org> and other AUTHORS
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Id: xracer-log.h,v 1.3 2000/01/18 22:29:57 rich Exp $
 */

#ifndef __xracer_log_h__
#define __xracer_log_h__

/* Unlike other libraries, you *may* call entry points into this library
 * *before* the library has been initialized (ie. before xrLogInit is
 * called).
 */
extern void xrLogInit (void);

/* Change the threshold for messages to be sent to stderr. If a message
 * comes in with debug level < threshold, it is discarded. The old
 * threshold is returned.
 */
extern int xrLogSetStderrThreshold (int new_threshold);

/* Change the threshold for messages to be sent to display. If a message
 * comes in with debug level < threshold, it is discarded. The old
 * threshold is returned.
 */
extern int xrLogSetDisplayThreshold (int new_threshold);

#ifdef __GNUC__
#define XR_LOG_NORETURN __attribute__((noreturn))
#define XR_LOG_FORMAT(type,fs,args) __attribute__((format (type,fs,args)))
#else
#define XR_LOG_NORETURN
#define XR_LOG_FORMAT(type,fs,args)
#endif

/* You would not normally need to call any of the following functions
 * directly. Use the macros below instead.
 */
extern void xrLogAssertFail (const char *file, int line, const char *expr)
  XR_LOG_NORETURN;
extern void xrLogFatalWithLine (const char *file, int line,
				const char *fs, ...)
  XR_LOG_NORETURN;
extern void xrLogWithLine (const char *file, int line, int level,
			   const char *fs, ...)
  XR_LOG_FORMAT (printf, 4, 5);
extern void xrLogPerrorWithLine (const char *file, int line,
				 const char *fs, ...)
  XR_LOG_FORMAT (printf, 3, 4);
extern void xrLogNotImplWithLine (const char *file, int line)
  XR_LOG_NORETURN;

extern void xrLogDisplay (void);

#if !defined(xrStringify)
#if defined(__STDC__) && __STDC__
#define xrStringify(x) #x
#else
#define xrStringify(x) "x"
#endif
#endif

/* Use these macros in your program code to log signficant events. */
#define xrLogAssert(expr)   ((void) ((expr) ? 0 : (xrLogAssertFail (__FILE__, __LINE__, xrStringify (expr))), 0))
#define xrLogFatal(fs...)   xrLogFatalWithLine (__FILE__, __LINE__, fs)
#define xrLog(lvl, fs...)   xrLogWithLine (__FILE__, __LINE__, lvl, fs)
#define xrLogPerror(fs...)  xrLogPerrorWithLine (__FILE__, __LINE__, fs)
#define xrLogNotImpl()      xrLogNotImplWithLine (__FILE__, __LINE__)

/* Logging levels. */
#define LOG_DEBUG    0
#define LOG_INFO     1
#define LOG_WARNING  2
#define LOG_ERROR    3

#endif /* __xracer_log_h__ */
