#ifndef IMMU_BASE_TABLE_VIEW_H
#define IMMU_BASE_TABLE_VIEW_H

#include <DHeaderView>

#include "BaseHeaderView.h"
#include "BaseTableView.h"

DWIDGET_USE_NAMESPACE

class QModelIndex;

class ImmuBaseHeaderView : public BaseHeaderView
{
    Q_OBJECT

public:
    explicit ImmuBaseHeaderView(Qt::Orientation orientation, QWidget *parent = nullptr);

protected:
    void paintEvent(QPaintEvent *event) override;
    void paintSection(QPainter *painter, const QRect &rect, int logicalIndex) const override;
};

class ImmuBaseTableView : public BaseTableView
{
    Q_OBJECT
public:
    explicit ImmuBaseTableView(DWidget *parent = nullptr);

protected:
    void paintEvent(QPaintEvent *event) override;

protected:
    ImmuBaseHeaderView *m_headerView = nullptr;
};

#endif  // IMMU_BASE_TABLE_VIEW_H