//
// Created by 张雪明 <zhangxueming@uniontech.com> on 2024/12/2.
//

#ifndef UOS_RECOVERY_IMMU_DATA_BACKUP_WIDGET_H
#define UOS_RECOVERY_IMMU_DATA_BACKUP_WIDGET_H

#include <DWidget>
#include <DLabel>
#include <DLineEdit>
#include <DTextEdit>
#include <DComboBox>
#include <DPushButton>
#include <DSuggestButton>
#include <DSpinner>
#include <DIconButton>
#include <QVBoxLayout>
#include <QStandardItemModel>
#include <QMap>
#include <QPair>
#include <QList>
#include <DTipLabel>
#include <QStringList>
#include <DListView>
#include "utils/global.h"
#include "utils/FsTab.h"

DTK_USE_NAMESPACE
DWIDGET_USE_NAMESPACE

class ImmuBaseTableView;

// 创建一个自定义的圆角弹出窗口类
class RoundedPopup : public QWidget
{
public:
    explicit RoundedPopup(QWidget *parent = nullptr, Qt::WindowFlags flags = Qt::Popup);

protected:
    void paintEvent(QPaintEvent *event);
};

class ImmuBackupIconComboBox : public QWidget
{
    Q_OBJECT
public:
    explicit ImmuBackupIconComboBox(QWidget *parent = nullptr);
    void setDStyleIcon(const Dtk::Widget::DStyle::StandardPixmap &icon);
    QAbstractButton* button();
    QComboBox* comboBox();
    DListView* listView();
    QLabel* titleLabel();
    void setMaxVisibleCount(int count);
    void initContent();

signals:
    void combCurrentIndexChanged(const int &index);

private:
    DIconButton* m_button = nullptr;
    QComboBox* m_comboBox = nullptr;
    RoundedPopup* m_popup = nullptr;
    DListView* m_listView = nullptr;
    QLabel* m_titleLabel  = nullptr;
    int m_maxVisibleCount = 10;
};

class ImmuBackupPathDeleteWidget : public QWidget {
    Q_OBJECT
public:
    //static bool m_isRemoving;
    explicit ImmuBackupPathDeleteWidget(QWidget *parent = nullptr);
    void setBackupPathInfo(const QString &opID, const QString &path);
    void setDeleteBtnVisible(bool visible);
    void setSpinnerVisible(bool visible);
    void stopSpinner();

Q_SIGNALS:
    void deleteBackupPathClicked(const QString &opID);

public Q_SLOTS:
    void onDelete();
    void onThemeChange(Dtk::Gui::DGuiApplicationHelper::ColorType themeType);

private:
    DPushButton *m_deleteBtn = nullptr;
    DSpinner *m_spinner = nullptr;
    QPair<QString, QString> m_opIDPath;
    Dtk::Gui::DGuiApplicationHelper *m_guiHelper = nullptr;
};

class ImmuDataBackupWidget : public DWidget {
    Q_OBJECT
public:
    explicit ImmuDataBackupWidget(DWidget *parent = nullptr);
    void initUI();
    void initLayout();
    void initTableView();
    void setDestDevice(const QJsonObject &jsonObject);
    QString getDestDeviceUUID();
    QStringList getBackupFiles();
    void setTips(const QString &tips);
    void setTipsStyleSheet(const QString &styleSheet);
    void startSpinner();
    void stopSpinner();
    void setButtonEnable(bool enable);
    QString getNote();
    void resetWidget();
    void setAddIconBtnEnable(bool enable);
    void setMoreIconBtnEnable(bool enable);
    QString getDirBindPath(const QString &path);

Q_SIGNALS:
    void cancel();
    void start(const QString &remark);

private Q_SLOTS:
    void onAddBtnClicked(bool clicked);
    void onDeleteBackupPathClicked(const QString &opID);
    void onStartBackup();
    void onNoteTextChanged();
    void onBackDirFontChanged(const QFont &font);
    void updateNoteCharNum(int num);
    void onThemeChange(Dtk::Gui::DGuiApplicationHelper::ColorType themeType);
    void onMoreIconBtnCurrentIndexChanged(const int &index);

private:
    int getComboWidth(const QFont &font);

private:
    DLabel *m_title = nullptr;
    DLabel *m_titleDes = nullptr;
    DLabel *m_backupDirTitle = nullptr;
    DIconButton *m_addIconBtn = nullptr;
    ImmuBackupIconComboBox *m_moreIconBtn = nullptr;
    ImmuBaseTableView *m_tableView = nullptr;
    QStandardItemModel *m_model = nullptr;
    DLabel *m_backupDir = nullptr;
    DComboBox *m_comboBox;
    DLabel *m_noteLabel = nullptr;
    DTextEdit *m_noteEdit = nullptr;
    DTipLabel *m_noteEditCount = nullptr;
    DSpinner *m_spinner = nullptr;
    DLabel *m_tips = nullptr;
    DPushButton *m_cancelBtn = nullptr;
    DPushButton *m_startBtn = nullptr;
    QVBoxLayout *m_mainVLayout = nullptr;
    QList<Partition> m_partitionList;
    FSTabInfoList m_fstabInfos;
    QMap<QString, QString> m_bindDirMap;
    bool m_isImmutable = false;
    int m_maxNum = 40;
    Dtk::Gui::DGuiApplicationHelper *m_guiHelper = nullptr;
};

#endif //UOS_RECOVERY_IMMU_DATA_BACKUP_WIDGET_H
