/*
 * Copyright (C) 2020 Uniontech Technology Co., Ltd.
 *
 * Author:     xinbo wang <wangxinbo@uniontech.com>
 *
 * Maintainer: xinbo wang <wangxinbo@uniontech.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "paths.h"

#include <pwd.h>
#include <sys/inotify.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <unistd.h>

#include <stdexcept>

std::filesystem::path Paths::getHomePath()
{
    // $HOME should be checked first
    const char *homeEnvVar = getenv("HOME");
    if (homeEnvVar != nullptr) {
        return std::filesystem::path{homeEnvVar};
    }

    // In case $HOME is not set fallback to getpwuid
    const struct passwd *userInfo = getpwuid(getuid());
    if (userInfo == nullptr) {
        throw std::runtime_error { "Error getting your home directory path (getpwuid).\n" };
    }

    const char *workingDir = userInfo->pw_dir;
    if (workingDir == nullptr) {
        throw std::runtime_error { "Error getting your home directory path (pw_dir).\n" };
    }

    return std::filesystem::path{workingDir};
}

std::filesystem::path Paths::getSystemConfigFilePath()
{
    return std::filesystem::path{"/usr/share/prohibitscreenshot/prohibitscreenshotDbus.conf"};
}
