/*
 * Copyright (C) 2020 Uniontech Technology Co., Ltd.
 *
 * Author:     xinbo wang <wangxinbo@uniontech.com>
 *
 * Maintainer: xinbo wang <wangxinbo@uniontech.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef DTK_WMJACK_H
#define DTK_WMJACK_H

#ifdef __cplusplus
extern "C" {
#endif

#include <stdio.h>
#include <stdbool.h>
#include <sys/types.h>
#include "wayland_client.h"

#define WindowId ulong

typedef struct _size{
    int w;
    int h;
}Size;

typedef struct _pos{
    int x;
    int y;
}Position;

/**
 * @brief get the window effect switch status.
 * @return true open, false close
 */
bool GetCompositorSwitchStatus(void);

/**
 * @brief Maximize Window.
 * @param wid: window ID
 * @return 0 success, -1 failure
 */
int MaximizeWindow(WindowId wid);

/**
 * @brief Show Multitask View.
 * @return 0 success, -1 failure
 */
int ToggleMultitaskView();

/**
 * @brief Minimize Window.
 * @param wid: window ID
 * @return 0 success, -1 failure
 */
int MinimizeWindow(WindowId wid);

/**
 * @brief Restore Window.
 * @param wid: window ID
 * @return 0 success, -1 failure
 */
int RestoreWindow(WindowId wid);

/**
 * @brief Get Window Title.
 * @param wid: window ID
 * @return -1 failure, otherwise success
 */
char * GetWindowText(WindowId wid);

/**
 * @brief Get Window Size.
 * @param wid: window ID
 * @return x:-1,y:-1 failure, otherwise success
 */
Size GetWindowSize(WindowId wid);

/**
 * @brief Get Window Position.
 * @param wid: window ID
 * @return w:-1,h:-1 failure, otherwise success
 */
Position GetWindowPosition(WindowId wid);

/**
 * @brief Get Active Window ID.
 * @return 0 failure, otherwise success
 */
WindowId GetActiveWindowID();

/**
 * @brief Get Desktop Window ID.
 * @return 0 failure, otherwise success
 */
WindowId GetDesktopWindowID();

/**
 * @brief Get Window Title.
 * @param wid: window ID
 * @param pChildIDs: child data
 * @return -1 failure, otherwise success
 */
int GetWindowChildren(WindowId wid, WindowId **pChildIDs);

/**
 * @brief Get Mouse Position.
 * @return w:-1,h:-1 failure, otherwise success
 */
Position GetPointerPosition();

/**
 * @brief free data.
 * @param windownlist: windowlist
 */
void FreeWindowList(WindowId *windownlist);

/**
 * @brief get all windows states
 */
struct dtk_array* GetAllWindowStates();

/**
 * @brief get Window State
 * @param windowId window id
 * @return window state
 */
WindowState* GetWindowState(WindowId wid);

/**
 * @brief Get Window PID.
 * @param wid: window ID
 * @return -1 failure, otherwise success
 */
int GetWindowPID(WindowId wid);

WindowId GetWindowFromPoint();

void ShowSplitMenu(int x, int y, int width, int height);

void HideSplitMenu(bool delay, WindowId wid);

int GetDevicePerformanceLevel();

WindowState GetSpecificWindowState(uint32_t wid);

int GetAllWindowStatesList(WindowState **states);

/**
 * @brief init dtkwmdisplay content
 */
int InitDtkWmDisplay();

/**
 * @brief destory dtkwmdisplay content
 */
void DestoryDtkWmDisplay();

#ifdef __cplusplus
}
#endif

#endif

