#!/usr/bin/python2
#----------------------------------------------------------------------------
# Name:         pv_noctar_io.py
# Purpose:      This is the IO Panel for Noctar!
#
# Author:       Victor Wollesen
#
# Created:      2012-12-12
# Copyright:    (c) 2012 Per Vices Corporation
#----------------------------------------------------------------------------


import wx
import wx.lib.inspection
import wx.lib.wordwrap
import wx.lib.mixins.inspection
import sys, os
import time
import subprocess, multiprocessing
#import math, numpy, decimal, random
#import types
import math
#import io
import string #, StringIO

#----------------------------------------------------------------------------
#
## This is the data collection command line generation function.
## It returns a properly formatted command for execution.
#

def worker_def(self, lockA, stream, cmd):
    lockA.acquire()
    try:
        stream.write('Lock Acquired: '+str(cmd)+'\n')
        subprocess.check_call( cmd, stdout=stream )
    except:
        print 'Error Executing Commands.'
    finally:
        stream.write('Lock Releasing \n')
        lockA.release()

def open_if_not_exists(filename):
    try:
        fd = os.open(filename, os.O_CREAT | os.O_EXCL | os.O_WRONLY)
    except:
        print "Ooops - unable to open file."
        return None
    fobj = os.fdopen(fd)
    return fobj

#----------------------------------------------------------------------------

class Log:
    def WriteText(self, text):
        if text[-1:] == '\n':
            text = text[:-1]
        wx.LogMessage(text)
    write = WriteText


class RunDemoApp(wx.App, wx.lib.mixins.inspection.InspectionMixin):
    def __init__(self, moduleIO):
        self.moduleIO = moduleIO
        wx.App.__init__(self, redirect=False)

    def OnInit(self):
        wx.Log_SetActiveTarget(wx.LogStderr())
        self.Init()  # InspectionMixin

        frame = wx.Frame(None, -1, title="Per Vices Noctar: IO Panel", pos=(50,50), size=(200,100),
                        style=wx.DEFAULT_FRAME_STYLE, name="Noctar")
        frame.CreateStatusBar()
        menuBar = wx.MenuBar()

        self.rx_sr = 125e6 #ADC Samplerate. Note that data rate is twice this.
        self.tx_sr = 250e6 #DAC Samplerate. The datarate will be twice this..

        #File Menu
        menu = wx.Menu()
        item = menu.Append(wx.ID_ABOUT, "&About"," Information about this program")
        self.Bind(wx.EVT_MENU, self.OnAbout, item)
        item = menu.Append(-1, "&Widget Inspector\tF6", "Show the wxPython Widget Inspection Tool")
        self.Bind(wx.EVT_MENU, self.OnWidgetInspector, item)
        item = menu.Append(-1, "E&xit\tCtrl-Q", "Exit")
        self.Bind(wx.EVT_MENU, self.OnExitApp, item)
        menuBar.Append(menu, "&File")

#        Icon and Logo
#        pvicon = wx.Image(opj('pvlogo.png'), wx.BITMAP_TYPE_ANY)
#        pvicon = pvicon.ConvertToBitmap()
#

        frame.SetMenuBar(menuBar)
        frame.Show(True)
        frame.Bind(wx.EVT_CLOSE, self.OnCloseFrame)
        
        #Get Panels
        #panelIO = self.moduleIO.initPanel(frame,frame)
        #panelIO = self.moduleIO.pv_noctar_io_panel(frame)
        #panelDisplay = self.moduleDisplay.initPanel(frame, frame, Log())

        pv_noctar_util = 'langford_util'
        pv_noctar_adc_util = 'langford_adc_util'
        pv_noctar_fsynth = 'langford_rf_fsynth'
        pv_noctar_vga = 'langford_rx_rf_bb_vga'

        class panelIO_t( self.moduleIO.pv_noctar_io_panel ):
            #Overriding default form methods
            
            #Disable Freq if using Baseband stage 
            ##TODO: Implement ddc/duc access using gui)
            def OnRxReset(self, event):
                print 'Rx Reset Initiated!'
                c_pv_rxreset_cmd = []
                c_pv_rxreset_cmd.append( [pv_noctar_util, str(panelIO.pv_noctar_dev_path.GetValue()), 'RxDspEn', '0' ] )
                c_pv_rxreset_cmd.append( [pv_noctar_util, str(panelIO.pv_noctar_dev_path.GetValue()), 'RxDspEn', '1' ] )
                lockRxReset = multiprocessing.Lock() #Acquisition lock
                getData = []
                #Initiate all workers
                for cmd in c_pv_rxreset_cmd:
                    getData.append( multiprocessing.Process(target=worker_def, args=(self, lockRxReset, sys.stdout, cmd) ) )
                    getData[c_pv_rxreset_cmd.index(cmd)].start()
                    getData[c_pv_rxreset_cmd.index(cmd)].join() #No multithreading - wait on child now.
                    print c_pv_rxreset_cmd.index(cmd)
                print 'Rx Reset Completed.'
                event.Skip()
                
            def OnTxReset(self, event):
                print 'Tx Reset Initiated!'
                c_pv_txreset_cmd = []
                c_pv_txreset_cmd.append( [pv_noctar_util, str(panelIO.pv_noctar_dev_path.GetValue()), 'TxDspEn', '0' ] )
                c_pv_txreset_cmd.append( [pv_noctar_util, str(panelIO.pv_noctar_dev_path.GetValue()), 'TxDspEn', '1' ] )
                lockTxReset = multiprocessing.Lock() #Acquisition lock
                getData = []
                #Initiate all workers
                for cmd in c_pv_txreset_cmd:
                    getData.append( multiprocessing.Process(target=worker_def, args=(self, lockTxReset, sys.stdout, cmd) ) )
                    getData[c_pv_txreset_cmd.index(cmd)].start()
                    getData[c_pv_txreset_cmd.index(cmd)].join() #No multithreading - wait on child now.
                    print c_pv_txreset_cmd.index(cmd)                
                print 'Tx Reset Completed.'
                event.Skip()
                
            def OnDisableRxFreq(self, event):
                panelIO.pv_noctar_rx_freq.Enable(not( bool( panelIO.pv_noctar_rx_branch_sel.GetSelection() ) ))
                panelIO.pv_noctar_rx_dec.SetSelection(not( bool( panelIO.pv_noctar_rx_branch_sel.GetSelection() ) ))
                panelIO.pv_noctar_rx_dec.Enable(not( bool( panelIO.pv_noctar_rx_branch_sel.GetSelection() ) ))
                panelIO.pv_noctar_rx_dXc.Enable(not( bool( panelIO.pv_noctar_rx_branch_sel.GetSelection() ) ))
                panelIO.pv_noctar_rx_adc_clk.SetSelection(( bool( panelIO.pv_noctar_rx_branch_sel.GetSelection() ) ))
                event.Skip()
    
            def OnDisableTxFreq(self, event):
                panelIO.pv_noctar_tx_freq.Enable(not( bool( panelIO.pv_noctar_tx_branch_sel.GetSelection() ) ))
                panelIO.pv_noctar_tx_int.SetSelection(not( bool( panelIO.pv_noctar_tx_branch_sel.GetSelection() ) ))
                ##panelIO.pv_noctar_tx_int.Enable(not( bool( panelIO.pv_noctar_tx_branch_sel.GetSelection() ) ))
                panelIO.pv_noctar_tx_dXc.Enable(not( bool( panelIO.pv_noctar_tx_branch_sel.GetSelection() ) ))
                
                event.Skip()

            def OnApply(self, event):
                c_pv_cmd = []
                
                #This could be implemented in a far better and more classful way. Too late...
                #The following returns the pin and value necessary to pass to the appropriate utility program
                #Receive Parameters
                c_pv_noctar_rx_branch_sel = [pv_noctar_util, str(panelIO.pv_noctar_dev_path.GetValue()), 'NASRxA', str( panelIO.pv_noctar_rx_branch_sel.GetSelection() ) ]
                c_pv_cmd.append(c_pv_noctar_rx_branch_sel)

                #If the branch is Low, enable the VGA/LNA. Otherwise, disable it
                if( not(bool( panelIO.pv_noctar_rx_branch_sel.GetSelection() )) ):
                    c_pv_noctar_rx_freq = [ pv_noctar_fsynth, str(panelIO.pv_noctar_dev_path.GetValue()), 'rx', str( float(panelIO.pv_noctar_rx_freq.GetValue())  ), '2' ]
                    c_pv_cmd.append(c_pv_noctar_rx_freq)
                    c_pv_noctar_rx_rf_gain = [ pv_noctar_util, str(panelIO.pv_noctar_dev_path.GetValue()), 'N21at0', str( int( panelIO.pv_noctar_rx_rf_gain.GetValue()) ) ]
                    c_pv_cmd.append(c_pv_noctar_rx_rf_gain)
                #We're inverting the VGA outputs in order to always have a higher number correspond to higher gain. This is strictly
                #to present a consistent user interface. Reference the LMH6521 for actual power specifications.
                    c_pv_noctar_rx_rf_vga0 = [ pv_noctar_vga, str(panelIO.pv_noctar_dev_path.GetValue()), '0', str( float( panelIO.pv_noctar_rx_rf_vga0.GetValue()*(-1)+63 )/2 ), '2' ]
                    c_pv_cmd.append(c_pv_noctar_rx_rf_vga0)
                    c_pv_noctar_rx_rf_vga1 = [ pv_noctar_vga, str(panelIO.pv_noctar_dev_path.GetValue()), '1', str( float( panelIO.pv_noctar_rx_rf_vga1.GetValue()*(-1)+63)/2 ), '2' ] 
                    c_pv_cmd.append(c_pv_noctar_rx_rf_vga1)
                    c_pv_noctar_rx_dec = [ pv_noctar_util, str(panelIO.pv_noctar_dev_path.GetValue()), 'RXDecEn', str( hex(pow(2,panelIO.pv_noctar_rx_dec.GetSelection()) - 1)  ) ]
                    c_pv_cmd.append(c_pv_noctar_rx_dec)
                    if (float(panelIO.pv_noctar_rx_dXc.GetValue()) > 0):
                        c_pv_noctar_rx_dXcc = [ pv_noctar_util, str(panelIO.pv_noctar_dev_path.GetValue()), 'RXRevFreq', '0' ]
                        c_pv_cmd.append(c_pv_noctar_rx_dXcc)
                    elif (float(panelIO.pv_noctar_rx_dXc.GetValue()) < 0):
                        c_pv_noctar_rx_dXcc = [ pv_noctar_util, str(panelIO.pv_noctar_dev_path.GetValue()), 'RXRevFreq', '1' ]
                        c_pv_cmd.append(c_pv_noctar_rx_dXcc)
                    c_pv_noctar_rx_dXc = [ pv_noctar_util, str(panelIO.pv_noctar_dev_path.GetValue()), 'RXPhase', str( abs(int(float(panelIO.pv_noctar_rx_dXc.GetValue())*(pow(2,32))/125e6))) ]
                    c_pv_cmd.append(c_pv_noctar_rx_dXc)
                    #Interleave Clocking
                    c_pv_noctar_rx_adc_clk_A = [ pv_noctar_adc_util, str(panelIO.pv_noctar_dev_path.GetValue()), 'A', 'ClkSel', str( int( panelIO.pv_noctar_rx_adc_clk.GetSelection()) ) ]
                    c_pv_cmd.append(c_pv_noctar_rx_adc_clk_A)
                    c_pv_noctar_rx_adc_clk_B = [ pv_noctar_adc_util, str(panelIO.pv_noctar_dev_path.GetValue()), 'B', 'ClkSel', str( int( 0 ) ) ]
                    c_pv_cmd.append(c_pv_noctar_rx_adc_clk_B)
                    #Set Decimation and Sample Rate
                    panelIO.pv_noctar_fb_rx_sr.SetValue('{:g}'.format(float(250e6/(2**panelIO.pv_noctar_rx_dec.GetSelection()))))

                elif ( bool ( panelIO.pv_noctar_rx_branch_sel.GetSelection() ) ):
                    c_pv_noctar_rx_bb_mode_sel = [ pv_noctar_util, str(panelIO.pv_noctar_dev_path.GetValue()), 'N3HILO', str( panelIO.pv_noctar_rx_bb_mode_sel.GetSelection() ) ]
                    c_pv_cmd.append(c_pv_noctar_rx_bb_mode_sel)
                    c_pv_noctar_rx_bb_en = [ pv_noctar_util, str(panelIO.pv_noctar_dev_path.GetValue()), 'N3ENB', str( int( panelIO.pv_noctar_rx_branch_sel.GetSelection() ) ) ]
                    c_pv_cmd.append(c_pv_noctar_rx_bb_en)
                    c_pv_noctar_rx_bb_gain = [ pv_noctar_util, str(panelIO.pv_noctar_dev_path.GetValue()), 'N3GAIN', str( int( panelIO.pv_noctar_rx_bb_gain.GetValue()) ) ]
                    c_pv_cmd.append(c_pv_noctar_rx_bb_gain)
                    #Interleave Clocking
                    c_pv_noctar_rx_adc_clk_A = [ pv_noctar_adc_util, str(panelIO.pv_noctar_dev_path.GetValue()), 'A', 'ClkSel', str( int( panelIO.pv_noctar_rx_adc_clk.GetSelection()) ) ]
                    c_pv_cmd.append(c_pv_noctar_rx_adc_clk_A)
                    c_pv_noctar_rx_adc_clk_B = [ pv_noctar_adc_util, str(panelIO.pv_noctar_dev_path.GetValue()), 'B', 'ClkSel', str( int( 0 ) ) ]
                    c_pv_cmd.append(c_pv_noctar_rx_adc_clk_B)
                    
                    #Determine Sample Rate and display
                    panelIO.pv_noctar_fb_rx_sr.SetValue('{:g}'.format(float(250e6)))
                
                #Transmission Parameters
                c_pv_noctar_tx_branch_sel = [ pv_noctar_util, str(panelIO.pv_noctar_dev_path.GetValue()), 'NASTxA', str( panelIO.pv_noctar_tx_branch_sel.GetSelection() ) ]
                c_pv_cmd.append(c_pv_noctar_tx_branch_sel)
                
                #Tx High
                if( not(bool( panelIO.pv_noctar_tx_branch_sel.GetSelection() )) ):
                    c_pv_noctar_tx_freq = [ pv_noctar_fsynth, str(panelIO.pv_noctar_dev_path.GetValue()), 'tx', str( float(panelIO.pv_noctar_tx_freq.GetValue()) ), '2' ]
                    c_pv_cmd.append(c_pv_noctar_tx_freq) 
                    c_pv_noctar_tx_int = [ pv_noctar_util, str(panelIO.pv_noctar_dev_path.GetValue()), 'TXIntEn', str( hex(pow(2,panelIO.pv_noctar_tx_int.GetSelection()) - 1)  ) ]
                    c_pv_cmd.append(c_pv_noctar_tx_int)
                    c_pv_noctar_tx_rf_gain = [ pv_noctar_util, str(panelIO.pv_noctar_dev_path.GetValue()), 'N22at0', str( int( panelIO.pv_noctar_tx_rf_gain.GetValue()) ) ]
                    c_pv_cmd.append(c_pv_noctar_tx_rf_gain)
                    if (float(panelIO.pv_noctar_tx_dXc.GetValue()) > 0):
                        c_pv_noctar_tx_dXcc = [ pv_noctar_util, str(panelIO.pv_noctar_dev_path.GetValue()), 'TXRevFreq', '0' ]
                        c_pv_cmd.append(c_pv_noctar_tx_dXcc)
                    elif (float(panelIO.pv_noctar_tx_dXc.GetValue()) < 0):
                        c_pv_noctar_tx_dXcc = [ pv_noctar_util, str(panelIO.pv_noctar_dev_path.GetValue()), 'TXRevFreq', '1' ]
                        c_pv_cmd.append(c_pv_noctar_tx_dXcc)
                    c_pv_noctar_tx_dXc = [ pv_noctar_util, str(panelIO.pv_noctar_dev_path.GetValue()), 'TXPhase', str( abs(int(float(panelIO.pv_noctar_tx_dXc.GetValue())*(pow(2,32))/125e6))) ]
                    c_pv_cmd.append(c_pv_noctar_tx_dXc) 
                    #Determine Sample Rate and display                    
                    panelIO.pv_noctar_fb_tx_sr.SetValue('{:g}'.format(float(125e6/(2**panelIO.pv_noctar_tx_int.GetSelection()))))
                #Tx Low - No additional parameters.
                elif ( bool( panelIO.pv_noctar_tx_branch_sel.GetSelection() )):
                    c_pv_noctar_tx_int = [ pv_noctar_util, str(panelIO.pv_noctar_dev_path.GetValue()), 'TXIntEn', str( hex(pow(2,panelIO.pv_noctar_tx_int.GetSelection()) - 1)  ) ]
                    c_pv_cmd.append(c_pv_noctar_tx_int)
                    #Determine Sample Rate and display
                    panelIO.pv_noctar_fb_tx_sr.SetValue('{:g}'.format(float(125e6/(2**panelIO.pv_noctar_tx_int.GetSelection()))))

                #Clock and Timing
                c_pv_noctar_clk_sel = [ pv_noctar_util, str(panelIO.pv_noctar_dev_path.GetValue()), 'NRXTALSEL', str( panelIO.pv_noctar_clk_sel.GetSelection() ) ]
                c_pv_cmd.append(c_pv_noctar_clk_sel)
                c_pv_noctar_clk_vcobypass = [ pv_noctar_util, str(panelIO.pv_noctar_dev_path.GetValue()), 'NRVCOSEL', str( panelIO.pv_noctar_clk_vcobypass.GetSelection() ) ]
                c_pv_cmd.append(c_pv_noctar_clk_vcobypass)

                #Device/DSP related
                c_pv_noctar_rx_dsp_en =  [ pv_noctar_util, str(panelIO.pv_noctar_dev_path.GetValue()), 'RxDspEn', str( panelIO.pv_noctar_rx_dsp_en.GetSelection() ) ]

                #Setting RxDspEn to 0 is not recommended.                
                #c_pv_cmd.append(c_pv_noctar_rx_dsp_en)
                c_pv_noctar_tx_dsp_en =  [ pv_noctar_util, str(panelIO.pv_noctar_dev_path.GetValue()), 'TxDspEn', str( panelIO.pv_noctar_tx_dsp_en.GetSelection() ) ]
                #Setting TxDspEn to 0 is not recommended.                
                #c_pv_cmd.append(c_pv_noctar_tx_dsp_en)
                c_pv_noctar_rx_adc0_pwr = [ pv_noctar_util, str(panelIO.pv_noctar_dev_path.GetValue()), 'ADCAPD', str( panelIO.pv_noctar_rx_adc0_pwr.GetSelection() ) ]
                #Setting ADC0 power to 0 is not recommended.                
                #c_pv_cmd.append(c_pv_noctar_rx_adc0_pwr)                
                c_pv_noctar_rx_adc1_pwr = [ pv_noctar_util, str(panelIO.pv_noctar_dev_path.GetValue()), 'ADCBPD', str( panelIO.pv_noctar_rx_adc1_pwr.GetSelection() ) ]
                #Setting ADC1 power to 0 is not recommended.                
                #c_pv_cmd.append(c_pv_noctar_rx_adc1_pwr)                
                c_pv_noctar_tx_dac_pwr = [ pv_noctar_util, str(panelIO.pv_noctar_dev_path.GetValue()), 'DACSDO', str( panelIO.pv_noctar_tx_dac_pwr.GetSelection()) ]
                c_pv_cmd.append(c_pv_noctar_tx_dac_pwr)

                self.c_pv_cmd = c_pv_cmd

                ### Multiprocessing parameters ###
                #This needs to be fixed; this code is only here because
                #I know it works; it's copypasta from an earlier project.
                lockA = multiprocessing.Lock() #Acquisition lock
                getData = []
                #Initiate all workers
                for cmd in c_pv_cmd:
                    getData.append( multiprocessing.Process(target=worker_def, args=(self, lockA, sys.stdout, cmd) ) )
                    getData[c_pv_cmd.index(cmd)].start()
                    getData[c_pv_cmd.index(cmd)].join() #No multithreading - wait on child now.
                    print c_pv_cmd.index(cmd)                

                event.Skip()

        

        panelIO = panelIO_t( frame )

        self.Bind(wx.EVT_BUTTON, self.OnApply, panelIO.g_pv_io_buttonApply)

        panelIO.WindowStyle = wx.SUNKEN_BORDER
        box = wx.BoxSizer(wx.VERTICAL)

        box.Add(panelIO, 0, wx.CENTER)
        frame.SetAutoLayout(True)
        frame.SetSizerAndFit(box)

        #Set File Configuration Parameters
        self.SetTopWindow(frame)
        self.frame = frame
        self.panelIO = panelIO
        return True

    def OnApply(self, evt):
        print 'Caught against button.'
        

    def OnAbout(self,evt):
        # First we create and fill the info object
        info = wx.AboutDialogInfo()
        info.Name = "Per Vices Noctar IO Panel"
        info.Version = "0.1"
        info.Copyright = "(C) 2012 Per Vices Corporation"
        info.Description = wx.lib.wordwrap.wordwrap(
            "This utility provides a demonstration interface to the Noctar transceiver"
            "and demonstrates its functionality."
            "\n\nThis program is dual licensed under the GPLv3 and commerical licenses."
            "\n",
            400, wx.ClientDC(self.frame))
        info.WebSite = ("http://www.pervices.com", "www.pervices.com")
        info.Developers = [ "Per Vices Corporation\n\t\tsolutions@pervices.com" #,
                            #"Engineering\n\n\t\tYi Yao\n\t\tyi.y@pervices.com\n"
                            ]
        #info.License

        # Then we call wx.AboutBox giving it that info object
        wx.AboutBox(info)

    def OnExitApp(self, evt):
        self.frame.Close(True)

    def OnCloseFrame(self, evt):
        if hasattr(self, "window") and hasattr(self.window, "ShutdownDemo"):
            self.window.ShutdownDemo()
        evt.Skip()

    def OnWidgetInspector(self, evt):
        #wx.lib.inspection.InspectionTool().Show()
        evt.Skip()


#----------------------------------------------------------------------------
def opj(path):
    """Convert paths to the platform-specific separator"""
    st = apply(os.path.join, tuple(path.split('/')))
    # HACK: on Linux, a leading / gets lost...
    if path.startswith('/'):
        st = '/' + st
    return st
#----------------------------------------------------------------------------

def main(argv):
    #if len(argv) < 2:
    #    print "Please specify a demo module name on the command-line"
    #    raise SystemExit

    name0, ext0  = os.path.splitext('pv_noctar_io_panel.py')
    module0 = __import__(name0)

    app = RunDemoApp(module0)
    app.MainLoop()

if __name__ == "__main__":
    main(sys.argv)
