/* Copyright (C) 2016-2017 Shengyu Zhang <i@silverrainz.me>
 *
 * This file is part of Srain.
 *
 * Srain is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __SUI_CONFIG_H
#define __SUI_CONFIG_H

#ifndef __IN_SUI_H
	#error This file should not be included directly, include just sui.h
#endif

#include "srain.h"
#include "ret.h"

typedef struct _SuiApplicationConfig SuiApplicationConfig;
typedef struct _SuiApplicationOptions SuiApplicationOptions;
typedef struct _SuiWindowConfig SuiWindowConfig;
typedef struct _SuiBufferConfig SuiBufferConfig;

struct _SuiWindowConfig {
    bool csd;
    bool send_on_ctrl_enter;
    bool exit_on_close;
    bool server_visibility;
    bool scroll_on_new_message;
};

struct _SuiApplicationConfig {
    char *theme;

    SuiWindowConfig window;
};

// NOTE: SuiApplicationOptions is different from SuiApplicationConfig,
// SuiApplicationOptions contains options which are specified via commandline.
struct _SuiApplicationOptions {
    // Whether auto connect to servers
    bool no_auto_connect;
};

struct _SuiBufferConfig {
    bool notify;
    bool show_topic;
    bool show_avatar;
    bool show_user_list;
    bool preview_url;
    bool auto_preview_url;
    char *nick_completion_suffix;
};

SuiApplicationConfig *sui_application_config_new(void);
SrnRet sui_application_config_check(SuiApplicationConfig *cfg);
void sui_application_config_free(SuiApplicationConfig *cfg);

SuiApplicationOptions *sui_application_options_new(void);
void sui_application_options_free(SuiApplicationOptions *opts);

SuiWindowConfig *sui_window_config_new(void);
SrnRet sui_window_config_check(SuiWindowConfig *cfg);
void sui_window_config_free(SuiWindowConfig *cfg);

SuiBufferConfig *sui_buffer_config_new(void);
SrnRet sui_buffer_config_check(SuiBufferConfig *cfg);
void sui_buffer_config_free(SuiBufferConfig *cfg);

#endif /* __SUI_CONFIG_H */
