// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_SQRDMLSH_8H_TRACE_AARCH64_H_
#define VIXL_SIM_SQRDMLSH_8H_TRACE_AARCH64_H_

const uint16_t kExpected_NEON_sqrdmlsh_8H[] = {
  0x0000, 0x0001, 0xeb87, 0xc72d, 0x8083, 0x8082, 0x8081, 0x3333,
  0x0000, 0xffce, 0xdde0, 0xaabd, 0x8082, 0x8081, 0x007f, 0x3333,
  0xffce, 0xffac, 0xccd0, 0xaabc, 0x8081, 0x007e, 0x007e, 0x3333,
  0xffac, 0xff82, 0xccd0, 0xaabc, 0x007d, 0x007d, 0x007d, 0x3333,
  0xff82, 0xff82, 0xcccf, 0x0010, 0x007c, 0x007c, 0x006f, 0x3333,
  0xff82, 0xff82, 0x0002, 0x000f, 0x007b, 0x006e, 0x0002, 0x3333,
  0xff82, 0x0001, 0x0002, 0x000f, 0x006d, 0x0001, 0x0001, 0x3333,
  0x0000, 0x0001, 0x0001, 0x0005, 0x0000, 0x0000, 0x0000, 0x3333,
  0x0000, 0x0001, 0xfffc, 0xffbd, 0xffff, 0xffff, 0xcd4c, 0x3333,
  0x0000, 0x0001, 0xffd0, 0xffbc, 0xfffe, 0xcd4c, 0xab2b, 0x3333,
  0x0000, 0x0001, 0xffd0, 0xffbb, 0xcd4b, 0xab2a, 0x8083, 0x3333,
  0x0000, 0x0001, 0xffcf, 0xddee, 0xab2a, 0x8083, 0x8082, 0x3333,
  0x0000, 0x0001, 0xeb87, 0xc72d, 0x8083, 0x8082, 0x8081, 0x3333,
  0x0000, 0xffce, 0xdde0, 0xaabd, 0x8082, 0x8081, 0x7fff, 0x3333,
  0xffce, 0xffac, 0xccd0, 0xaabc, 0x8081, 0x7fff, 0x7fff, 0x3333,
  0xffac, 0xff82, 0xccd0, 0xaabc, 0x7fff, 0x7fff, 0x55d4, 0x3333,
  0xff82, 0xff82, 0xcccf, 0x5565, 0x7fff, 0x55d3, 0x33b3, 0x3333,
  0xff82, 0xff82, 0x3335, 0x5564, 0x55d1, 0x33b1, 0x00ff, 0x3333,
  0xff82, 0x0080, 0x3335, 0x38f4, 0x33b0, 0x00fe, 0x00fe, 0x3333,
  0x007e, 0x0080, 0x2224, 0x2233, 0x00fd, 0x00fd, 0x00fd, 0x3333,
  0x007e, 0x0056, 0x147d, 0x0065, 0x00fc, 0x00fc, 0x00fc, 0x3333,
  0x0054, 0x0034, 0x0035, 0x0065, 0x00fb, 0x00fb, 0x008f, 0x3333,
  0x0032, 0x0001, 0x0035, 0x0064, 0x00fa, 0x008e, 0x0082, 0x3333,
  0x0000, 0x0001, 0x0034, 0x0063, 0x008d, 0x0081, 0x0081, 0x3333,
  0x0000, 0x0033, 0x0055, 0x0020, 0x0080, 0x0080, 0x007f, 0x3333,
  0x0000, 0x0033, 0x000d, 0x0013, 0x007f, 0x007f, 0x007f, 0x3333,
  0x0000, 0x0007, 0x0004, 0x0012, 0x007e, 0x007e, 0x007f, 0x3333,
  0x0000, 0x0002, 0x0003, 0x0011, 0x007d, 0x007d, 0x007f, 0x3333,
  0x0000, 0x0002, 0x0003, 0x0010, 0x007c, 0x007c, 0x007f, 0x3333,
  0x0000, 0x0001, 0x0002, 0x000f, 0x007b, 0x006e, 0x007f, 0x3333,
  0x0000, 0x0001, 0x0001, 0x000e, 0x006d, 0x0001, 0x007f, 0x3333,
  0x0000, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x007f, 0x3333,
  0x0000, 0x0000, 0xfff7, 0xff93, 0xffff, 0xffff, 0x007f, 0x3332,
  0x0000, 0xfffb, 0xffaf, 0xff92, 0xfffe, 0xcd4b, 0x007f, 0x3332,
  0x0000, 0xffcf, 0xffae, 0xff91, 0xcd4b, 0xab2a, 0x007f, 0x3332,
  0x0000, 0xffcf, 0xffad, 0xccde, 0xab29, 0x8082, 0x007f, 0x3332,
  0x0000, 0xffce, 0xdde0, 0xaabd, 0x8082, 0x8081, 0x007f, 0x3334,
  0x0000, 0xeb86, 0xc71f, 0x8016, 0x8081, 0x8080, 0x007f, 0x3334,
  0xffcd, 0xdddf, 0xaaaf, 0x8015, 0x8080, 0x7fff, 0x007f, 0x3334,
  0xffab, 0xcccf, 0xaaae, 0x8014, 0x7fff, 0x7fff, 0x007f, 0x3333,
  0xff81, 0xcccf, 0xaaae, 0x7fff, 0x7fff, 0x55d3, 0x007f, 0x3333,
  0xff81, 0xccce, 0x5557, 0x7fff, 0x55d2, 0x33b2, 0x007f, 0x3333,
  0xff81, 0x3334, 0x5556, 0x5564, 0x33b0, 0x00fe, 0x007f, 0x3333,
  0x007f, 0x3334, 0x38e6, 0x3343, 0x00fd, 0x00fd, 0x007f, 0x3333,
  0x007f, 0x2223, 0x2225, 0x0090, 0x00fc, 0x00fc, 0x007f, 0x3333,
  0x0055, 0x147c, 0x0057, 0x008f, 0x00fb, 0x00fb, 0x007f, 0x3333,
  0x0033, 0x0034, 0x0057, 0x008e, 0x00fa, 0x008e, 0x007f, 0x3333,
  0x0000, 0x0034, 0x0056, 0x008d, 0x008d, 0x0081, 0x007f, 0x3333,
  0x0033, 0x0055, 0x007f, 0x0020, 0x0080, 0x007e, 0x007f, 0x3333,
  0x0032, 0x0054, 0x0012, 0x0013, 0x007f, 0x007e, 0x007f, 0x3333,
  0x0032, 0x000c, 0x0005, 0x0012, 0x007e, 0x007e, 0x007f, 0x3333,
  0x0006, 0x0003, 0x0004, 0x0011, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0001, 0x0002, 0x0003, 0x0010, 0x007c, 0x007e, 0x007f, 0x3333,
  0x0001, 0x0002, 0x0002, 0x000f, 0x007b, 0x007e, 0x007f, 0x3333,
  0x0000, 0x0001, 0x0001, 0x000e, 0x006d, 0x007e, 0x007f, 0x3333,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x007e, 0x007f, 0x3332,
  0x0000, 0x0000, 0xfff2, 0xff93, 0xffff, 0x007e, 0x007f, 0x3332,
  0xffff, 0xfff6, 0xff85, 0xff92, 0xfffe, 0x007e, 0x007e, 0x3331,
  0xfffa, 0xffae, 0xff84, 0xff91, 0xcd4a, 0x007e, 0x007e, 0x3331,
  0xffce, 0xffad, 0xff83, 0xccde, 0xab29, 0x007e, 0x007e, 0x3331,
  0xffce, 0xffac, 0xccd0, 0xaabc, 0x8081, 0x007e, 0x007e, 0x3335,
  0xffcd, 0xdddf, 0xaaaf, 0x8015, 0x8080, 0x007e, 0x0080, 0x3335,
  0xeb85, 0xc71e, 0x8008, 0x8014, 0x807f, 0x007e, 0x0080, 0x3334,
  0xddde, 0xaaae, 0x8007, 0x8013, 0x7fff, 0x007e, 0x0080, 0x3334,
  0xccce, 0xaaad, 0x8006, 0x7fff, 0x7fff, 0x007e, 0x007f, 0x3333,
  0xccce, 0xaaad, 0x7fff, 0x7fff, 0x55d2, 0x007e, 0x007f, 0x3333,
  0xcccd, 0x5556, 0x7ffe, 0x5565, 0x33b1, 0x007e, 0x007f, 0x3333,
  0x3333, 0x5555, 0x5556, 0x3343, 0x00fd, 0x007e, 0x007f, 0x3333,
  0x3333, 0x38e5, 0x3335, 0x0090, 0x00fc, 0x007e, 0x007f, 0x3333,
  0x2222, 0x2224, 0x0082, 0x008f, 0x00fb, 0x007e, 0x007f, 0x3333,
  0x147b, 0x0056, 0x0081, 0x008e, 0x00fa, 0x007e, 0x007f, 0x3333,
  0x0033, 0x0056, 0x0080, 0x008d, 0x008d, 0x007e, 0x007f, 0x3333,
  0x0055, 0x007f, 0x007f, 0x0020, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0054, 0x007e, 0x0012, 0x0013, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0053, 0x0011, 0x0005, 0x0012, 0x007d, 0x007e, 0x007f, 0x3333,
  0x000b, 0x0004, 0x0004, 0x0011, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0002, 0x0003, 0x0003, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0001, 0x0002, 0x0002, 0x000f, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0001, 0x0001, 0x0001, 0x000e, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0000, 0x0000, 0x0000, 0x0000, 0x007d, 0x007e, 0x007f, 0x332d,
  0xffff, 0xffff, 0xfff2, 0xff93, 0x007d, 0x007e, 0x007e, 0x3328,
  0xffff, 0xfff1, 0xff85, 0xff92, 0x007d, 0x007e, 0x007e, 0x3323,
  0xfff5, 0xff84, 0xff84, 0xff91, 0x007d, 0x007d, 0x007d, 0x3323,
  0xffad, 0xff83, 0xff83, 0xccdd, 0x007d, 0x007d, 0x007d, 0x3323,
  0xffac, 0xff82, 0xccd0, 0xaabc, 0x007d, 0x007d, 0x007d, 0x3343,
  0xffab, 0xcccf, 0xaaae, 0x8014, 0x007d, 0x007d, 0x0081, 0x3343,
  0xddde, 0xaaae, 0x8007, 0x8013, 0x007d, 0x007f, 0x0081, 0x333e,
  0xc71d, 0x8007, 0x8006, 0x8012, 0x007d, 0x007f, 0x0080, 0x3339,
  0xaaad, 0x8006, 0x8005, 0x7fff, 0x007d, 0x007f, 0x0080, 0x3333,
  0xaaac, 0x8005, 0x7fff, 0x7fff, 0x007d, 0x007e, 0x007f, 0x3333,
  0xaaac, 0x7ffe, 0x7fff, 0x5565, 0x007d, 0x007e, 0x007f, 0x3333,
  0x5555, 0x7ffd, 0x5557, 0x3344, 0x007d, 0x007e, 0x007f, 0x3333,
  0x5554, 0x5555, 0x3335, 0x0090, 0x007d, 0x007e, 0x007f, 0x3333,
  0x38e4, 0x3334, 0x0082, 0x008f, 0x007d, 0x007e, 0x007f, 0x3333,
  0x2223, 0x0081, 0x0081, 0x008e, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0055, 0x0080, 0x0080, 0x008d, 0x007d, 0x007e, 0x007f, 0x3333,
  0x007f, 0x007f, 0x007f, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x007e, 0x007e, 0x0012, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x007d, 0x0011, 0x0005, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0010, 0x0004, 0x0004, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0003, 0x0003, 0x0003, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0002, 0x0002, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0001, 0x0001, 0x0001, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0000, 0x0000, 0x0000, 0x0010, 0x007d, 0x007e, 0x007f, 0x3301,
  0xffff, 0xffff, 0xfff2, 0x0010, 0x007d, 0x007e, 0x0079, 0x32e0,
  0xfffe, 0xfff1, 0xff85, 0x0010, 0x007d, 0x007d, 0x0074, 0x32b6,
  0xfff0, 0xff84, 0xff84, 0x0010, 0x007d, 0x007d, 0x006f, 0x32b6,
  0xff83, 0xff83, 0xff83, 0x0010, 0x007c, 0x007c, 0x006f, 0x32b6,
  0xff82, 0xff82, 0xcccf, 0x0010, 0x007c, 0x007c, 0x006f, 0x33b0,
  0xff81, 0xcccf, 0xaaae, 0x0010, 0x007c, 0x007c, 0x008f, 0x33b0,
  0xccce, 0xaaad, 0x8006, 0x0010, 0x007c, 0x0080, 0x008f, 0x3386,
  0xaaad, 0x8006, 0x8005, 0x0010, 0x007e, 0x0080, 0x008a, 0x3365,
  0x8006, 0x8005, 0x8004, 0x0010, 0x007e, 0x007f, 0x0085, 0x3333,
  0x8005, 0x8004, 0x7fff, 0x0010, 0x007e, 0x007f, 0x007f, 0x3333,
  0x8004, 0x7fff, 0x7fff, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x7ffd, 0x7ffe, 0x5557, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x7ffc, 0x5556, 0x3336, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x5554, 0x3334, 0x0082, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x3333, 0x0081, 0x0081, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0080, 0x0080, 0x0080, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x007f, 0x007f, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x007e, 0x007e, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x007d, 0x0011, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0010, 0x0004, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0003, 0x0003, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0002, 0x0002, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0001, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0000, 0x0000, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3301,
  0xffff, 0xffff, 0x0002, 0x0010, 0x007d, 0x007e, 0x004d, 0x32df,
  0xfffe, 0xfff1, 0x0002, 0x0010, 0x007d, 0x0078, 0x002c, 0x32b5,
  0xfff0, 0xff84, 0x0002, 0x0010, 0x007c, 0x0073, 0x0002, 0x32b5,
  0xff83, 0xff83, 0x0002, 0x0010, 0x007c, 0x006e, 0x0002, 0x32b5,
  0xff82, 0xff82, 0x0002, 0x000f, 0x007b, 0x006e, 0x0002, 0x33b1,
  0xff81, 0xccce, 0x0002, 0x000f, 0x007b, 0x006e, 0x00fc, 0x33b1,
  0xccce, 0xaaad, 0x0002, 0x000f, 0x007b, 0x008e, 0x00fc, 0x3387,
  0xaaac, 0x8005, 0x0002, 0x000f, 0x007f, 0x008e, 0x00d2, 0x3365,
  0x8005, 0x8004, 0x0002, 0x0011, 0x007f, 0x0089, 0x00b1, 0x3333,
  0x8004, 0x8003, 0x0002, 0x0011, 0x007e, 0x0084, 0x007f, 0x3333,
  0x8003, 0x7fff, 0x0002, 0x0011, 0x007e, 0x007e, 0x007f, 0x3333,
  0x7ffe, 0x7fff, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x7ffd, 0x5556, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x5555, 0x3335, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x3333, 0x0081, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0080, 0x0080, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x007f, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x007e, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x007d, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0010, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0003, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0002, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0001, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3300,
  0xffff, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x004d, 0x32de,
  0xfffe, 0x0001, 0x0002, 0x0010, 0x007d, 0x004c, 0x002b, 0x32b4,
  0xfff0, 0x0001, 0x0002, 0x0010, 0x0077, 0x002b, 0x0001, 0x32b4,
  0xff83, 0x0001, 0x0002, 0x000f, 0x0072, 0x0001, 0x0001, 0x32b4,
  0xff82, 0x0001, 0x0002, 0x000f, 0x006d, 0x0001, 0x0001, 0x33b2,
  0xff81, 0x0001, 0x0001, 0x000e, 0x006d, 0x0001, 0x00fd, 0x33b2,
  0xcccd, 0x0001, 0x0001, 0x000e, 0x006d, 0x00fb, 0x00fd, 0x3388,
  0xaaac, 0x0001, 0x0001, 0x000e, 0x008d, 0x00fb, 0x00d3, 0x3366,
  0x8004, 0x0001, 0x0001, 0x0012, 0x008d, 0x00d1, 0x00b1, 0x3333,
  0x8003, 0x0001, 0x0003, 0x0012, 0x0088, 0x00b0, 0x007f, 0x3333,
  0x8002, 0x0001, 0x0003, 0x0011, 0x0083, 0x007e, 0x007f, 0x3333,
  0x7fff, 0x0001, 0x0003, 0x0011, 0x007d, 0x007e, 0x007f, 0x3333,
  0x7ffe, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x5555, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x3334, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0080, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3332,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x332d,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3301,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3301,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3300,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x1eb8,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x004c, 0x1111,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x004c, 0x002a, 0x0001,
  0x0000, 0x0001, 0x0002, 0x0010, 0x004b, 0x002a, 0x0000, 0x0001,
  0x0000, 0x0001, 0x0002, 0x000a, 0x002a, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0001, 0x0005, 0x0000, 0x0000, 0x0000, 0x6666,
  0x0000, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x00fe, 0x6666,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00fc, 0x00fe, 0x5555,
  0x0000, 0x0000, 0x0000, 0x0000, 0x00fa, 0x00fc, 0x00d4, 0x47ae,
  0x0000, 0x0000, 0x0000, 0x0020, 0x00fa, 0x00d2, 0x00b2, 0x3366,
  0x0000, 0x0000, 0x0004, 0x0020, 0x00d0, 0x00b0, 0x007f, 0x3366,
  0x0000, 0x0002, 0x0004, 0x001b, 0x00af, 0x007e, 0x007f, 0x3365,
  0x0000, 0x0002, 0x0003, 0x0016, 0x007d, 0x007e, 0x007f, 0x3365,
  0x0000, 0x0002, 0x0003, 0x0010, 0x007d, 0x007e, 0x007f, 0x3339,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3334,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3334,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3332,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3332,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007e, 0x3328,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x0079, 0x32e0,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x004d, 0x32df,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x004d, 0x32de,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x004c, 0x1111,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0xec04, 0xfa50,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x004b, 0xde5d, 0xdde0,
  0x0000, 0x0001, 0x0002, 0x0010, 0x004b, 0x0029, 0xcd4d, 0xdddf,
  0x0000, 0x0001, 0x0002, 0xffde, 0x0029, 0xffff, 0xcd4d, 0xdddf,
  0x0000, 0x0001, 0xfffc, 0xffbd, 0xffff, 0xffff, 0xcd4c, 0x7fff,
  0x0000, 0x0000, 0xfff7, 0xff93, 0xffff, 0xffff, 0x33b2, 0x7fff,
  0x0000, 0x0000, 0xfff2, 0xff93, 0xffff, 0x00fd, 0x33b2, 0x6c17,
  0xffff, 0xffff, 0xfff2, 0xff93, 0x00fb, 0x00fd, 0x22a1, 0x5556,
  0xffff, 0xffff, 0xfff2, 0x008d, 0x00fb, 0x00d3, 0x14fa, 0x3388,
  0xffff, 0xffff, 0x0012, 0x008d, 0x00d1, 0x00b1, 0x00b2, 0x3388,
  0xffff, 0x0003, 0x0012, 0x0063, 0x00af, 0x007e, 0x00b2, 0x3387,
  0x0001, 0x0003, 0x000d, 0x0042, 0x007d, 0x007e, 0x00b1, 0x3386,
  0x0001, 0x0002, 0x0008, 0x0010, 0x007d, 0x007e, 0x00b1, 0x333e,
  0x0001, 0x0002, 0x0002, 0x0010, 0x007d, 0x007e, 0x0085, 0x3335,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x0080, 0x3334,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x0080, 0x3334,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007f, 0x0080, 0x3333,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3332,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007e, 0x3331,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007e, 0x3323,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007d, 0x0074, 0x32b6,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x0078, 0x002c, 0x32b5,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x004c, 0x002b, 0x32b4,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x004c, 0x002a, 0x0001,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x004b, 0xde5d, 0xdde0,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0xec03, 0xc79c, 0xb339,
  0x0000, 0x0001, 0x0002, 0x0010, 0x004a, 0xde5c, 0xab2c, 0xb338,
  0x0000, 0x0001, 0x0002, 0xffde, 0x0028, 0xcd4c, 0xab2b, 0xb337,
  0x0000, 0x0001, 0xffd0, 0xffbc, 0xfffe, 0xcd4c, 0xab2b, 0x7fff,
  0x0000, 0xfffb, 0xffaf, 0xff92, 0xfffe, 0xcd4b, 0x55d4, 0x7fff,
  0xffff, 0xfff6, 0xff85, 0xff92, 0xfffe, 0x33b1, 0x55d3, 0x7fff,
  0xffff, 0xfff1, 0xff85, 0xff92, 0x00fc, 0x33b1, 0x3963, 0x6666,
  0xfffe, 0xfff1, 0xff85, 0x008e, 0x00fc, 0x22a0, 0x22a2, 0x33b3,
  0xfffe, 0xfff1, 0x007f, 0x008e, 0x00d2, 0x14f9, 0x00d4, 0x33b2,
  0xfffe, 0x0011, 0x007f, 0x0064, 0x00b0, 0x00b1, 0x00d4, 0x33b1,
  0x0002, 0x0011, 0x0055, 0x0042, 0x007d, 0x00b1, 0x00d3, 0x33b0,
  0x0002, 0x000c, 0x0034, 0x0010, 0x007d, 0x00b0, 0x00d2, 0x3343,
  0x0001, 0x0007, 0x0002, 0x0010, 0x007d, 0x00b0, 0x008a, 0x3336,
  0x0001, 0x0001, 0x0002, 0x0010, 0x007d, 0x0084, 0x0081, 0x3335,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007f, 0x0080, 0x3334,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007e, 0x007f, 0x0080, 0x3333,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007e, 0x007f, 0x007f, 0x3332,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007e, 0x3331,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007d, 0x007d, 0x3323,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007d, 0x006f, 0x32b6,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007c, 0x0073, 0x0002, 0x32b5,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0077, 0x002b, 0x0001, 0x32b4,
  0x0000, 0x0001, 0x0002, 0x0010, 0x004b, 0x002a, 0x0000, 0x0001,
  0x0000, 0x0001, 0x0002, 0x0010, 0x004b, 0x0029, 0xcd4d, 0xdddf,
  0x0000, 0x0001, 0x0002, 0x0010, 0x004a, 0xde5c, 0xab2c, 0xb338,
  0x0000, 0x0001, 0x0002, 0x0010, 0xec02, 0xc79b, 0x8085, 0xb337,
  0x0000, 0x0001, 0x0002, 0xffdd, 0xde5b, 0xab2b, 0x8084, 0xb336,
  0x0000, 0x0001, 0xffd0, 0xffbb, 0xcd4b, 0xab2a, 0x8083, 0x7fff,
  0x0000, 0xffcf, 0xffae, 0xff91, 0xcd4b, 0xab2a, 0x7fff, 0x7fff,
  0xfffa, 0xffae, 0xff84, 0xff91, 0xcd4a, 0x55d3, 0x7fff, 0x7fff,
  0xfff5, 0xff84, 0xff84, 0xff91, 0x33b0, 0x55d2, 0x55d3, 0x6666,
  0xfff0, 0xff84, 0xff84, 0x008f, 0x33b0, 0x3962, 0x33b2, 0x33b3,
  0xfff0, 0xff84, 0x0080, 0x008f, 0x229f, 0x22a1, 0x00ff, 0x33b2,
  0xfff0, 0x007e, 0x0080, 0x0065, 0x14f8, 0x00d3, 0x00fe, 0x33b1,
  0x0010, 0x007e, 0x0056, 0x0043, 0x00b0, 0x00d3, 0x00fd, 0x33b0,
  0x0010, 0x0054, 0x0034, 0x0010, 0x00b0, 0x00d2, 0x00fc, 0x3343,
  0x000b, 0x0033, 0x0002, 0x0010, 0x00af, 0x00d1, 0x008f, 0x3336,
  0x0006, 0x0001, 0x0002, 0x0010, 0x00af, 0x0089, 0x0082, 0x3335,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0083, 0x0080, 0x0081, 0x3334,
  0x0000, 0x0001, 0x0002, 0x0016, 0x007f, 0x0080, 0x0080, 0x3333,
  0x0000, 0x0001, 0x0002, 0x0011, 0x007e, 0x007f, 0x007f, 0x3332,
  0x0000, 0x0001, 0x0002, 0x0011, 0x007e, 0x007e, 0x007e, 0x3331,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007d, 0x007d, 0x3323,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007c, 0x007c, 0x006f, 0x32b6,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007c, 0x006e, 0x0002, 0x32b5,
  0x0000, 0x0001, 0x0002, 0x000f, 0x0072, 0x0001, 0x0001, 0x32b4,
  0x0000, 0x0001, 0x0002, 0x000a, 0x002a, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0xffde, 0x0029, 0xffff, 0xcd4d, 0xdddf,
  0x0000, 0x0001, 0x0002, 0xffde, 0x0028, 0xcd4c, 0xab2b, 0xb337,
  0x0000, 0x0001, 0x0002, 0xffdd, 0xde5b, 0xab2b, 0x8084, 0xb336,
  0x0000, 0x0001, 0x0002, 0xeb95, 0xc79a, 0x8084, 0x8083, 0xb335,
  0x0000, 0x0001, 0xffcf, 0xddee, 0xab2a, 0x8083, 0x8082, 0x7fff,
  0x0000, 0xffcf, 0xffad, 0xccde, 0xab29, 0x8082, 0x7fff, 0x7fff,
  0xffce, 0xffad, 0xff83, 0xccde, 0xab29, 0x7fff, 0x7fff, 0x7fff,
  0xffad, 0xff83, 0xff83, 0xccdd, 0x55d2, 0x7fff, 0x55d4, 0x6667,
  0xff83, 0xff83, 0xff83, 0x3343, 0x55d1, 0x55d2, 0x33b2, 0x33b3,
  0xff83, 0xff83, 0x0081, 0x3343, 0x3961, 0x33b1, 0x00ff, 0x33b2,
  0xff83, 0x007f, 0x0081, 0x2232, 0x22a0, 0x00fe, 0x00fe, 0x33b1,
  0x007d, 0x007f, 0x0057, 0x148b, 0x00d2, 0x00fd, 0x00fd, 0x33b0,
  0x007d, 0x0055, 0x0035, 0x0043, 0x00d2, 0x00fc, 0x00fc, 0x3343,
  0x0053, 0x0033, 0x0002, 0x0043, 0x00d1, 0x00fb, 0x008f, 0x3336,
  0x0032, 0x0001, 0x0002, 0x0042, 0x00d0, 0x008e, 0x0082, 0x3335,
  0x0000, 0x0001, 0x0002, 0x0042, 0x0088, 0x0081, 0x0081, 0x3334,
  0x0000, 0x0001, 0x0034, 0x001b, 0x0080, 0x0080, 0x0080, 0x3333,
  0x0000, 0x0001, 0x0008, 0x0012, 0x007f, 0x007f, 0x007f, 0x3334,
  0x0000, 0x0001, 0x0003, 0x0011, 0x007e, 0x007e, 0x007e, 0x3335,
  0x0000, 0x0001, 0x0003, 0x0011, 0x007d, 0x007d, 0x007d, 0x3343,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007c, 0x007c, 0x006f, 0x33b0,
  0x0000, 0x0001, 0x0002, 0x000f, 0x007b, 0x006e, 0x0002, 0x33b1,
  0x0000, 0x0001, 0x0002, 0x000f, 0x006d, 0x0001, 0x0001, 0x33b2,
  0x0000, 0x0001, 0x0001, 0x0005, 0x0000, 0x0000, 0x0000, 0x6666,
  0x0000, 0x0001, 0xfffc, 0xffbd, 0xffff, 0xffff, 0xcd4c, 0x7fff,
  0x0000, 0x0001, 0xffd0, 0xffbc, 0xfffe, 0xcd4c, 0xab2b, 0x7fff,
  0x0000, 0x0001, 0xffd0, 0xffbb, 0xcd4b, 0xab2a, 0x8083, 0x7fff,
  0x0000, 0x0001, 0xffcf, 0xddee, 0xab2a, 0x8083, 0x8082, 0x7fff,
  0x0000, 0x0001, 0xeb87, 0xc72d, 0x8083, 0x8082, 0x8081, 0xb333,
  0x0000, 0xffce, 0xdde0, 0xaabd, 0x8082, 0x8081, 0x7fff, 0xb334,
  0xffce, 0xffac, 0xccd0, 0xaabc, 0x8081, 0x7fff, 0x7fff, 0xdddd,
  0xffac, 0xff82, 0xccd0, 0xaabc, 0x7fff, 0x7fff, 0x55d4, 0xffff,
  0xff82, 0xff82, 0xcccf, 0x5565, 0x7fff, 0x55d3, 0x33b3, 0x32b3,
  0xff82, 0xff82, 0x3335, 0x5564, 0x55d1, 0x33b1, 0x00ff, 0x32b4,
  0xff82, 0x0080, 0x3335, 0x38f4, 0x33b0, 0x00fe, 0x00fe, 0x32b5,
  0x007e, 0x0080, 0x2224, 0x2233, 0x00fd, 0x00fd, 0x00fd, 0x32b6,
  0x007e, 0x0056, 0x147d, 0x0065, 0x00fc, 0x00fc, 0x00fc, 0x3323,
  0x0054, 0x0034, 0x0035, 0x0065, 0x00fb, 0x00fb, 0x008f, 0x3330,
  0x0032, 0x0001, 0x0035, 0x0064, 0x00fa, 0x008e, 0x0082, 0x3331,
  0x0000, 0x0001, 0x0034, 0x0063, 0x008d, 0x0081, 0x0081, 0x3332,
  0x0000, 0x0033, 0x0055, 0x0020, 0x0080, 0x0080, 0x007e, 0x3333,
  0x0000, 0x0033, 0x000d, 0x0013, 0x007f, 0x007f, 0x007f, 0x3334,
  0x0000, 0x0007, 0x0004, 0x0012, 0x007e, 0x007e, 0x0080, 0x3335,
  0x0000, 0x0002, 0x0003, 0x0011, 0x007d, 0x007d, 0x0081, 0x3343,
  0x0000, 0x0002, 0x0003, 0x0010, 0x007c, 0x007c, 0x008f, 0x33b0,
  0x0000, 0x0001, 0x0002, 0x000f, 0x007b, 0x006e, 0x00fc, 0x33b1,
  0x0000, 0x0001, 0x0001, 0x000e, 0x006d, 0x0001, 0x00fd, 0x33b2,
  0x0000, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x00fe, 0x6666,
  0x0000, 0x0000, 0xfff7, 0xff93, 0xffff, 0xffff, 0x33b2, 0x7fff,
  0x0000, 0xfffb, 0xffaf, 0xff92, 0xfffe, 0xcd4b, 0x55d4, 0x7fff,
  0x0000, 0xffcf, 0xffae, 0xff91, 0xcd4b, 0xab2a, 0x7fff, 0x7fff,
  0x0000, 0xffcf, 0xffad, 0xccde, 0xab29, 0x8082, 0x7fff, 0x7fff,
  0x0000, 0xffce, 0xdde0, 0xaabd, 0x8082, 0x8081, 0x7fff, 0xb334,
  0x0000, 0xeb86, 0xc71f, 0x8016, 0x8081, 0x8080, 0x807f, 0xb335,
  0xffcd, 0xdddf, 0xaaaf, 0x8015, 0x8080, 0x7fff, 0x8080, 0xddde,
  0xffab, 0xcccf, 0xaaae, 0x8014, 0x7fff, 0x7fff, 0xab29, 0xffff,
  0xff81, 0xcccf, 0xaaae, 0x7fff, 0x7fff, 0x55d3, 0xcd4b, 0x32b3,
  0xff81, 0xccce, 0x5557, 0x7fff, 0x55d2, 0x33b2, 0xffff, 0x32b4,
  0xff81, 0x3334, 0x5556, 0x5564, 0x33b0, 0x00fe, 0x0000, 0x32b5,
  0x007f, 0x3334, 0x38e6, 0x3343, 0x00fd, 0x00fd, 0x0001, 0x32b6,
  0x007f, 0x2223, 0x2225, 0x0090, 0x00fc, 0x00fc, 0x0002, 0x3323,
  0x0055, 0x147c, 0x0057, 0x008f, 0x00fb, 0x00fb, 0x006f, 0x3330,
  0x0033, 0x0034, 0x0057, 0x008e, 0x00fa, 0x008e, 0x007c, 0x3331,
  0x0000, 0x0034, 0x0056, 0x008d, 0x008d, 0x0081, 0x007d, 0x3332,
  0x0033, 0x0055, 0x007f, 0x0020, 0x0080, 0x007c, 0x007e, 0x3333,
  0x0032, 0x0054, 0x0012, 0x0013, 0x007f, 0x007d, 0x007f, 0x3334,
  0x0032, 0x000c, 0x0005, 0x0012, 0x007e, 0x007e, 0x0080, 0x3334,
  0x0006, 0x0003, 0x0004, 0x0011, 0x007d, 0x007f, 0x0081, 0x333e,
  0x0001, 0x0002, 0x0003, 0x0010, 0x007c, 0x0080, 0x008f, 0x3386,
  0x0001, 0x0002, 0x0002, 0x000f, 0x007b, 0x008e, 0x00fc, 0x3387,
  0x0000, 0x0001, 0x0001, 0x000e, 0x006d, 0x00fb, 0x00fd, 0x3388,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00fc, 0x00fe, 0x5555,
  0x0000, 0x0000, 0xfff2, 0xff93, 0xffff, 0x00fd, 0x33b2, 0x6c17,
  0xffff, 0xfff6, 0xff85, 0xff92, 0xfffe, 0x33b1, 0x55d3, 0x7fff,
  0xfffa, 0xffae, 0xff84, 0xff91, 0xcd4a, 0x55d3, 0x7fff, 0x7fff,
  0xffce, 0xffad, 0xff83, 0xccde, 0xab29, 0x7fff, 0x7fff, 0x7fff,
  0xffce, 0xffac, 0xccd0, 0xaabc, 0x8081, 0x7fff, 0x7fff, 0xdddd,
  0xffcd, 0xdddf, 0xaaaf, 0x8015, 0x8080, 0x7fff, 0x8080, 0xddde,
  0xeb85, 0xc71e, 0x8008, 0x8014, 0x807f, 0x807e, 0x8081, 0xfa4f,
  0xddde, 0xaaae, 0x8007, 0x8013, 0x7fff, 0x807f, 0xab2a, 0x1110,
  0xccce, 0xaaad, 0x8006, 0x7fff, 0x7fff, 0xab28, 0xcd4b, 0x32de,
  0xccce, 0xaaad, 0x7fff, 0x7fff, 0x55d2, 0xcd4a, 0xffff, 0x32de,
  0xcccd, 0x5556, 0x7ffe, 0x5565, 0x33b1, 0xfffe, 0x0000, 0x32df,
  0x3333, 0x5555, 0x5556, 0x3343, 0x00fd, 0xffff, 0x0001, 0x32e0,
  0x3333, 0x38e5, 0x3335, 0x0090, 0x00fc, 0x0000, 0x0002, 0x3328,
  0x2222, 0x2224, 0x0082, 0x008f, 0x00fb, 0x0001, 0x006f, 0x3331,
  0x147b, 0x0056, 0x0081, 0x008e, 0x00fa, 0x006e, 0x007c, 0x3332,
  0x0033, 0x0056, 0x0080, 0x008d, 0x008d, 0x007b, 0x007d, 0x3332,
  0x0055, 0x007f, 0x007f, 0x0020, 0x007a, 0x007c, 0x007e, 0x3333,
  0x0054, 0x007e, 0x0012, 0x0013, 0x007b, 0x007d, 0x007f, 0x3333,
  0x0053, 0x0011, 0x0005, 0x0012, 0x007c, 0x007e, 0x0080, 0x3334,
  0x000b, 0x0004, 0x0004, 0x0011, 0x007d, 0x007f, 0x0080, 0x3339,
  0x0002, 0x0003, 0x0003, 0x0010, 0x007e, 0x0080, 0x008a, 0x3365,
  0x0001, 0x0002, 0x0002, 0x000f, 0x007f, 0x008e, 0x00d2, 0x3365,
  0x0001, 0x0001, 0x0001, 0x000e, 0x008d, 0x00fb, 0x00d3, 0x3366,
  0x0000, 0x0000, 0x0000, 0x0000, 0x00fa, 0x00fc, 0x00d4, 0x47ae,
  0xffff, 0xffff, 0xfff2, 0xff93, 0x00fb, 0x00fd, 0x22a1, 0x5556,
  0xffff, 0xfff1, 0xff85, 0xff92, 0x00fc, 0x33b1, 0x3963, 0x6666,
  0xfff5, 0xff84, 0xff84, 0xff91, 0x33b0, 0x55d2, 0x55d3, 0x6666,
  0xffad, 0xff83, 0xff83, 0xccdd, 0x55d2, 0x7fff, 0x55d4, 0x6667,
  0xffac, 0xff82, 0xccd0, 0xaabc, 0x7fff, 0x7fff, 0x55d4, 0xffff,
  0xffab, 0xcccf, 0xaaae, 0x8014, 0x7fff, 0x7fff, 0xab29, 0xffff,
  0xddde, 0xaaae, 0x8007, 0x8013, 0x7fff, 0x807f, 0xab2a, 0x1110,
  0xc71d, 0x8007, 0x8006, 0x8012, 0x807d, 0x8080, 0xc79b, 0x1eb7,
  0xaaad, 0x8006, 0x8005, 0x7fff, 0x807e, 0xab29, 0xde5c, 0x3300,
  0xaaac, 0x8005, 0x7fff, 0x7fff, 0xab27, 0xcd4a, 0x002a, 0x3300,
  0xaaac, 0x7ffe, 0x7fff, 0x5565, 0xcd49, 0xfffe, 0x002a, 0x3301,
  0x5555, 0x7ffd, 0x5557, 0x3344, 0xfffd, 0xffff, 0x002b, 0x3301,
  0x5554, 0x5555, 0x3335, 0x0090, 0xfffe, 0x0000, 0x002c, 0x332d,
  0x38e4, 0x3334, 0x0082, 0x008f, 0xffff, 0x0001, 0x0074, 0x3332,
  0x2223, 0x0081, 0x0081, 0x008e, 0x0000, 0x006e, 0x007d, 0x3332,
  0x0055, 0x0080, 0x0080, 0x008d, 0x006d, 0x007b, 0x007e, 0x3333,
  0x007f, 0x007f, 0x007f, 0x0000, 0x007a, 0x007d, 0x007f, 0x3333,
  0x007e, 0x007e, 0x0012, 0x000d, 0x007b, 0x007d, 0x007f, 0x3333,
  0x007d, 0x0011, 0x0005, 0x000e, 0x007c, 0x007e, 0x007f, 0x3333,
  0x0010, 0x0004, 0x0004, 0x000f, 0x007d, 0x007f, 0x0080, 0x3333,
  0x0003, 0x0003, 0x0003, 0x0010, 0x007e, 0x007f, 0x0085, 0x3333,
  0x0002, 0x0002, 0x0002, 0x0011, 0x007f, 0x0089, 0x00b1, 0x3333,
  0x0001, 0x0001, 0x0001, 0x0012, 0x008d, 0x00d1, 0x00b1, 0x3333,
  0x0000, 0x0000, 0x0000, 0x0020, 0x00fa, 0x00d2, 0x00b2, 0x3366,
  0xffff, 0xffff, 0xfff2, 0x008d, 0x00fb, 0x00d3, 0x14fa, 0x3388,
  0xfffe, 0xfff1, 0xff85, 0x008e, 0x00fc, 0x22a0, 0x22a2, 0x33b3,
  0xfff0, 0xff84, 0xff84, 0x008f, 0x33b0, 0x3962, 0x33b2, 0x33b3,
  0xff83, 0xff83, 0xff83, 0x3343, 0x55d1, 0x55d2, 0x33b2, 0x33b3,
  0xff82, 0xff82, 0xcccf, 0x5565, 0x7fff, 0x55d3, 0x33b3, 0x32b3,
  0xff81, 0xcccf, 0xaaae, 0x7fff, 0x7fff, 0x55d3, 0xcd4b, 0x32b3,
  0xccce, 0xaaad, 0x8006, 0x7fff, 0x7fff, 0xab28, 0xcd4b, 0x32de,
  0xaaad, 0x8006, 0x8005, 0x7fff, 0x807e, 0xab29, 0xde5c, 0x3300,
  0x8006, 0x8005, 0x8004, 0x8010, 0x807f, 0xc79a, 0xec03, 0x3333,
  0x8005, 0x8004, 0x7fff, 0x8011, 0xab28, 0xde5b, 0x004c, 0x3333,
  0x8004, 0x7fff, 0x7fff, 0xaaba, 0xcd49, 0x0029, 0x004c, 0x3333,
  0x7ffd, 0x7ffe, 0x5557, 0xccdc, 0xfffd, 0x0029, 0x004d, 0x3333,
  0x7ffc, 0x5556, 0x3336, 0xff90, 0xfffe, 0x002a, 0x004d, 0x3333,
  0x5554, 0x3334, 0x0082, 0xff91, 0xffff, 0x002b, 0x0079, 0x3333,
  0x3333, 0x0081, 0x0081, 0xff92, 0x0000, 0x0073, 0x007e, 0x3333,
  0x0080, 0x0080, 0x0080, 0xff93, 0x006d, 0x007c, 0x007e, 0x3333,
  0x007f, 0x007f, 0xff85, 0x0000, 0x007b, 0x007d, 0x007f, 0x3333,
  0x007e, 0x007e, 0xfff2, 0x000d, 0x007c, 0x007e, 0x007f, 0x3333,
  0x007d, 0x0011, 0xffff, 0x000e, 0x007c, 0x007e, 0x007f, 0x3333,
  0x0010, 0x0004, 0x0000, 0x000f, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0003, 0x0003, 0x0001, 0x0010, 0x007e, 0x007f, 0x007f, 0x3333,
  0x0002, 0x0002, 0x0002, 0x0011, 0x007e, 0x0084, 0x007f, 0x3333,
  0x0001, 0x0001, 0x0003, 0x0012, 0x0088, 0x00b0, 0x007f, 0x3333,
  0x0000, 0x0000, 0x0004, 0x0020, 0x00d0, 0x00b0, 0x007f, 0x3366,
  0xffff, 0xffff, 0x0012, 0x008d, 0x00d1, 0x00b1, 0x00b2, 0x3388,
  0xfffe, 0xfff1, 0x007f, 0x008e, 0x00d2, 0x14f9, 0x00d4, 0x33b2,
  0xfff0, 0xff84, 0x0080, 0x008f, 0x229f, 0x22a1, 0x00ff, 0x33b2,
  0xff83, 0xff83, 0x0081, 0x3343, 0x3961, 0x33b1, 0x00ff, 0x33b2,
  0xff82, 0xff82, 0x3335, 0x5564, 0x55d1, 0x33b1, 0x00ff, 0x32b4,
  0xff81, 0xccce, 0x5557, 0x7fff, 0x55d2, 0x33b2, 0xffff, 0x32b4,
  0xccce, 0xaaad, 0x7fff, 0x7fff, 0x55d2, 0xcd4a, 0xffff, 0x32de,
  0xaaac, 0x8005, 0x7fff, 0x7fff, 0xab27, 0xcd4a, 0x002a, 0x3300,
  0x8005, 0x8004, 0x7fff, 0x8011, 0xab28, 0xde5b, 0x004c, 0x3333,
  0x8004, 0x8003, 0x8002, 0x8012, 0xc799, 0xec02, 0x007f, 0x3333,
  0x8003, 0x7fff, 0x8003, 0xaabb, 0xde5a, 0x004b, 0x007f, 0x3333,
  0x7ffe, 0x7fff, 0xaaac, 0xccdc, 0x0028, 0x004b, 0x007f, 0x3333,
  0x7ffd, 0x5556, 0xccce, 0xff90, 0x0028, 0x004c, 0x007f, 0x3333,
  0x5555, 0x3335, 0xff82, 0xff91, 0x0029, 0x004c, 0x007f, 0x3333,
  0x3333, 0x0081, 0xff83, 0xff92, 0x002a, 0x0078, 0x007f, 0x3333,
  0x0080, 0x0080, 0xff84, 0xff93, 0x0072, 0x007d, 0x007f, 0x3333,
  0x007f, 0xff83, 0xff85, 0x0005, 0x007c, 0x007e, 0x007f, 0x3333,
  0x007e, 0xff84, 0xfff2, 0x000e, 0x007c, 0x007e, 0x007f, 0x3333,
  0x007d, 0xfff1, 0xffff, 0x000f, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0010, 0xfffe, 0x0000, 0x000f, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0003, 0xffff, 0x0001, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0002, 0x0000, 0x0002, 0x0011, 0x007e, 0x007e, 0x007f, 0x3333,
  0x0001, 0x0001, 0x0003, 0x0011, 0x0083, 0x007e, 0x007f, 0x3333,
  0x0000, 0x0002, 0x0004, 0x001b, 0x00af, 0x007e, 0x007f, 0x3365,
  0xffff, 0x0003, 0x0012, 0x0063, 0x00af, 0x007e, 0x00b2, 0x3387,
  0xfffe, 0x0011, 0x007f, 0x0064, 0x00b0, 0x00b1, 0x00d4, 0x33b1,
  0xfff0, 0x007e, 0x0080, 0x0065, 0x14f8, 0x00d3, 0x00fe, 0x33b1,
  0xff83, 0x007f, 0x0081, 0x2232, 0x22a0, 0x00fe, 0x00fe, 0x33b1,
  0xff82, 0x0080, 0x3335, 0x38f4, 0x33b0, 0x00fe, 0x00fe, 0x32b5,
  0xff81, 0x3334, 0x5556, 0x5564, 0x33b0, 0x00fe, 0x0000, 0x32b5,
  0xcccd, 0x5556, 0x7ffe, 0x5565, 0x33b1, 0xfffe, 0x0000, 0x32df,
  0xaaac, 0x7ffe, 0x7fff, 0x5565, 0xcd49, 0xfffe, 0x002a, 0x3301,
  0x8004, 0x7fff, 0x7fff, 0xaaba, 0xcd49, 0x0029, 0x004c, 0x3333,
  0x8003, 0x7fff, 0x8003, 0xaabb, 0xde5a, 0x004b, 0x007f, 0x3333,
  0x8002, 0x8001, 0x8004, 0xc72c, 0xec01, 0x007e, 0x007f, 0x3333,
  0x7fff, 0x8002, 0xaaad, 0xdded, 0x004a, 0x007e, 0x007f, 0x3333,
  0x7ffe, 0xaaab, 0xccce, 0xffbb, 0x004a, 0x007e, 0x007f, 0x3333,
  0x5555, 0xcccd, 0xff82, 0xffbb, 0x004b, 0x007e, 0x007f, 0x3333,
  0x3334, 0xff81, 0xff83, 0xffbc, 0x004b, 0x007e, 0x007f, 0x3333,
  0x0080, 0xff82, 0xff84, 0xffbd, 0x0077, 0x007e, 0x007f, 0x3333,
  0xff81, 0xff83, 0xffaf, 0x000a, 0x007d, 0x007e, 0x007f, 0x3333,
  0xff82, 0xff84, 0xfff7, 0x000f, 0x007d, 0x007e, 0x007f, 0x3333,
  0xff83, 0xfff1, 0x0000, 0x000f, 0x007d, 0x007e, 0x007f, 0x3333,
  0xfff0, 0xfffe, 0x0001, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0xfffd, 0xffff, 0x0001, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0xfffe, 0x0000, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0xffff, 0x0001, 0x0003, 0x0011, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0000, 0x0002, 0x0003, 0x0016, 0x007d, 0x007e, 0x007f, 0x3365,
  0x0001, 0x0003, 0x000d, 0x0042, 0x007d, 0x007e, 0x00b1, 0x3386,
  0x0002, 0x0011, 0x0055, 0x0042, 0x007d, 0x00b1, 0x00d3, 0x33b0,
  0x0010, 0x007e, 0x0056, 0x0043, 0x00b0, 0x00d3, 0x00fd, 0x33b0,
  0x007d, 0x007f, 0x0057, 0x148b, 0x00d2, 0x00fd, 0x00fd, 0x33b0,
  0x007e, 0x0080, 0x2224, 0x2233, 0x00fd, 0x00fd, 0x00fd, 0x32b6,
  0x007f, 0x3334, 0x38e6, 0x3343, 0x00fd, 0x00fd, 0x0001, 0x32b6,
  0x3333, 0x5555, 0x5556, 0x3343, 0x00fd, 0xffff, 0x0001, 0x32e0,
  0x5555, 0x7ffd, 0x5557, 0x3344, 0xfffd, 0xffff, 0x002b, 0x3301,
  0x7ffd, 0x7ffe, 0x5557, 0xccdc, 0xfffd, 0x0029, 0x004d, 0x3333,
  0x7ffe, 0x7fff, 0xaaac, 0xccdc, 0x0028, 0x004b, 0x007f, 0x3333,
  0x7fff, 0x8002, 0xaaad, 0xdded, 0x004a, 0x007e, 0x007f, 0x3333,
  0x8000, 0x8003, 0xc71e, 0xeb94, 0x007d, 0x007e, 0x007f, 0x3333,
  0x8001, 0xaaac, 0xdddf, 0xffdd, 0x007d, 0x007e, 0x007f, 0x3333,
  0xaaaa, 0xcccd, 0xffad, 0xffdd, 0x007d, 0x007e, 0x007f, 0x3333,
  0xcccc, 0xff81, 0xffad, 0xffde, 0x007d, 0x007e, 0x007f, 0x3333,
  0xff80, 0xff82, 0xffae, 0xffde, 0x007d, 0x007e, 0x007f, 0x3333,
  0xff81, 0xffad, 0xffd0, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0xff82, 0xffae, 0xfffc, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0xff83, 0xfff6, 0x0001, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0xfff0, 0xffff, 0x0001, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0xfffd, 0x0000, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0xfffe, 0x0000, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0xffff, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0000, 0x0002, 0x0003, 0x0010, 0x007d, 0x007e, 0x007f, 0x3339,
  0x0001, 0x0002, 0x0008, 0x0010, 0x007d, 0x007e, 0x00b1, 0x333e,
  0x0002, 0x000c, 0x0034, 0x0010, 0x007d, 0x00b0, 0x00d2, 0x3343,
  0x0010, 0x0054, 0x0034, 0x0010, 0x00b0, 0x00d2, 0x00fc, 0x3343,
  0x007d, 0x0055, 0x0035, 0x0043, 0x00d2, 0x00fc, 0x00fc, 0x3343,
  0x007e, 0x0056, 0x147d, 0x0065, 0x00fc, 0x00fc, 0x00fc, 0x3323,
  0x007f, 0x2223, 0x2225, 0x0090, 0x00fc, 0x00fc, 0x0002, 0x3323,
  0x3333, 0x38e5, 0x3335, 0x0090, 0x00fc, 0x0000, 0x0002, 0x3328,
  0x5554, 0x5555, 0x3335, 0x0090, 0xfffe, 0x0000, 0x002c, 0x332d,
  0x7ffc, 0x5556, 0x3336, 0xff90, 0xfffe, 0x002a, 0x004d, 0x3333,
  0x7ffd, 0x5556, 0xccce, 0xff90, 0x0028, 0x004c, 0x007f, 0x3333,
  0x7ffe, 0xaaab, 0xccce, 0xffbb, 0x004a, 0x007e, 0x007f, 0x3333,
  0x8001, 0xaaac, 0xdddf, 0xffdd, 0x007d, 0x007e, 0x007f, 0x3333,
  0x8002, 0xc71d, 0xeb86, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0xaaab, 0xddde, 0xffcf, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0xcccc, 0xffac, 0xffcf, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0xff80, 0xffac, 0xffd0, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0xffab, 0xffcf, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0xffac, 0xffcf, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0xffad, 0xfffb, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0xfff5, 0x0000, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0xfffe, 0x0000, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0xffff, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0xffff, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3334,
  0x0001, 0x0002, 0x0002, 0x0010, 0x007d, 0x007e, 0x0085, 0x3335,
  0x0001, 0x0007, 0x0002, 0x0010, 0x007d, 0x00b0, 0x008a, 0x3336,
  0x000b, 0x0033, 0x0002, 0x0010, 0x00af, 0x00d1, 0x008f, 0x3336,
  0x0053, 0x0033, 0x0002, 0x0043, 0x00d1, 0x00fb, 0x008f, 0x3336,
  0x0054, 0x0034, 0x0035, 0x0065, 0x00fb, 0x00fb, 0x008f, 0x3330,
  0x0055, 0x147c, 0x0057, 0x008f, 0x00fb, 0x00fb, 0x006f, 0x3330,
  0x2222, 0x2224, 0x0082, 0x008f, 0x00fb, 0x0001, 0x006f, 0x3331,
  0x38e4, 0x3334, 0x0082, 0x008f, 0xffff, 0x0001, 0x0074, 0x3332,
  0x5554, 0x3334, 0x0082, 0xff91, 0xffff, 0x002b, 0x0079, 0x3333,
  0x5555, 0x3335, 0xff82, 0xff91, 0x0029, 0x004c, 0x007f, 0x3333,
  0x5555, 0xcccd, 0xff82, 0xffbb, 0x004b, 0x007e, 0x007f, 0x3333,
  0xaaaa, 0xcccd, 0xffad, 0xffdd, 0x007d, 0x007e, 0x007f, 0x3333,
  0xaaab, 0xddde, 0xffcf, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0xc71c, 0xeb85, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0xdddd, 0xffce, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0xffab, 0xffce, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0xffcd, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0xffce, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0xffce, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0xfffa, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0xffff, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0xffff, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3334,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x0080, 0x3334,
  0x0001, 0x0001, 0x0002, 0x0010, 0x007d, 0x0084, 0x0081, 0x3335,
  0x0006, 0x0001, 0x0002, 0x0010, 0x00af, 0x0089, 0x0082, 0x3335,
  0x0032, 0x0001, 0x0002, 0x0042, 0x00d0, 0x008e, 0x0082, 0x3335,
  0x0032, 0x0001, 0x0035, 0x0064, 0x00fa, 0x008e, 0x0082, 0x3331,
  0x0033, 0x0034, 0x0057, 0x008e, 0x00fa, 0x008e, 0x007c, 0x3331,
  0x147b, 0x0056, 0x0081, 0x008e, 0x00fa, 0x006e, 0x007c, 0x3332,
  0x2223, 0x0081, 0x0081, 0x008e, 0x0000, 0x006e, 0x007d, 0x3332,
  0x3333, 0x0081, 0x0081, 0xff92, 0x0000, 0x0073, 0x007e, 0x3333,
  0x3333, 0x0081, 0xff83, 0xff92, 0x002a, 0x0078, 0x007f, 0x3333,
  0x3334, 0xff81, 0xff83, 0xffbc, 0x004b, 0x007e, 0x007f, 0x3333,
  0xcccc, 0xff81, 0xffad, 0xffde, 0x007d, 0x007e, 0x007f, 0x3333,
  0xcccc, 0xffac, 0xffcf, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0xdddd, 0xffce, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0xeb84, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0xffcd, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x0080, 0x3334,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007f, 0x0080, 0x3334,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0083, 0x0080, 0x0081, 0x3334,
  0x0000, 0x0001, 0x0002, 0x0042, 0x0088, 0x0081, 0x0081, 0x3334,
  0x0000, 0x0001, 0x0034, 0x0063, 0x008d, 0x0081, 0x0081, 0x3332,
  0x0000, 0x0034, 0x0056, 0x008d, 0x008d, 0x0081, 0x007d, 0x3332,
  0x0033, 0x0056, 0x0080, 0x008d, 0x008d, 0x007b, 0x007d, 0x3332,
  0x0055, 0x0080, 0x0080, 0x008d, 0x006d, 0x007b, 0x007e, 0x3333,
  0x0080, 0x0080, 0x0080, 0xff93, 0x006d, 0x007c, 0x007e, 0x3333,
  0x0080, 0x0080, 0xff84, 0xff93, 0x0072, 0x007d, 0x007f, 0x3333,
  0x0080, 0xff82, 0xff84, 0xffbd, 0x0077, 0x007e, 0x007f, 0x3333,
  0xff80, 0xff82, 0xffae, 0xffde, 0x007d, 0x007e, 0x007f, 0x3333,
  0xff80, 0xffac, 0xffd0, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0xffab, 0xffce, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0xffcd, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
};
const unsigned kExpectedCount_NEON_sqrdmlsh_8H = 576;

#endif  // VIXL_SIM_SQRDMLSH_8H_TRACE_AARCH64_H_
