function(test_variable name expected_type expected_value)
  if(NOT DEFINED "${name}")
    message(SEND_ERROR "${name} is not defined")
  elseif(NOT "${${name}}" STREQUAL expected_value)
    message(SEND_ERROR "Expected value of ${name}: \"${expected_value}\"\nActual value: \"${${name}}\"")
  endif()
  if(expected_type)
    if(NOT DEFINED "CACHE{${name}}")
      message(SEND_ERROR "Cache entry ${name} does not exist")
    else()
      get_property(type CACHE ${name} PROPERTY TYPE)
      if(NOT type STREQUAL expected_type)
        message(SEND_ERROR "Expected type of ${name}: \"${expected_type}\"\nActual type: \"${type}\"")
      endif()
    endif()
  endif()
endfunction()

function(test_environment_variable name expected_value)
  if(NOT DEFINED "ENV{${name}}")
    message(SEND_ERROR "Environment variable ${name} is not defined")
  elseif(NOT "$ENV{${name}}" STREQUAL expected_value)
    message(SEND_ERROR "Expected value of environment variable ${name}: \"${expected_value}\"\nActual value: \"$ENV{${name}}\"")
  endif()
endfunction()
