// SPDX-FileCopyrightText: 2024 UnionTech Software Technology Co., Ltd.
//
// SPDX-License-Identifier: GPL-3.0-or-later

#include "modelrepo_p.h"
#include "modelinfo.h"

#include <QStandardPaths>
#include <QDir>
#include <QDebug>

GLOBAL_USE_NAMESPACE

ModelRepoPrivate::ModelRepoPrivate(ModelRepo *parent)
    : q(parent)
{
    // defalut repo
    for (const QString &p : QStandardPaths::standardLocations(QStandardPaths::GenericDataLocation)) {
        path.append(p + "/" + EXE_NAME + "/models");
    }

#ifdef QT_DEBUG
    qDebug() << "defalut model repo" << path;
#endif
}

ModelRepo::ModelRepo(QObject *parent)
    : QObject(parent)
    , d(new ModelRepoPrivate(this))
{

}

void ModelRepo::setRepoPath(const QStringList &path)
{
    d->path = path;
}

QStringList ModelRepo::list() const
{
    QStringList models;
    for (const QString &path : d->path) {
        QDir dir(path);
        auto infos = dir.entryInfoList(QDir::Dirs|QDir::NoDotAndDotDot);

        for (const QFileInfo &info : infos) {
            models.append(info.fileName());
        }
    }

    return models;
}

QList<ModelProperty> ModelRepo::show(const QString &model) const
{
    return {};
}

QSharedPointer<ModelInfo> ModelRepo::modelInfo(const QString &model) const
{
    ModelInfoPointer ptr;
    if (model.isEmpty())
        return ptr;

    for (const QString &path : d->path) {
        QDir dir(path);
        auto modelPath = dir.absoluteFilePath(model);
        if (QFileInfo::exists(modelPath)) {
            ptr.reset(new ModelInfo(modelPath));
            break;
        }
    }

    return ptr;
}
