/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.sizes;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

@StatelessCheck
public class LambdaBodyLengthCheck
extends AbstractCheck {
    public static final String MSG_KEY = "maxLen.lambdaBody";
    private static final int DEFAULT_MAX = 10;
    private int max = 10;

    public void setMax(int length) {
        this.max = length;
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{181};
    }

    @Override
    public void visitToken(DetailAST ast) {
        int length;
        if (ast.getParent().getType() != 208 && (length = LambdaBodyLengthCheck.getLength(ast)) > this.max) {
            this.log(ast, MSG_KEY, length, this.max);
        }
    }

    private static int getLength(DetailAST ast) {
        DetailAST lambdaBody = ast.getLastChild();
        int length = lambdaBody.getType() == 7 ? lambdaBody.getLastChild().getLineNo() - lambdaBody.getLineNo() : LambdaBodyLengthCheck.getLastNodeLineNumber(lambdaBody) - LambdaBodyLengthCheck.getFirstNodeLineNumber(lambdaBody);
        return length + 1;
    }

    private static int getLastNodeLineNumber(DetailAST lambdaBody) {
        int result;
        DetailAST node = lambdaBody;
        do {
            result = node.getLineNo();
        } while ((node = node.getLastChild()) != null);
        return result;
    }

    private static int getFirstNodeLineNumber(DetailAST lambdaBody) {
        int result;
        DetailAST node = lambdaBody;
        do {
            result = node.getLineNo();
        } while ((node = node.getFirstChild()) != null);
        return result;
    }
}

