// Generated by gmmproc 2.50.1 -- DO NOT MODIFY!


#include <glibmm.h>

#include <gstreamermm/element.h>
#include <gstreamermm/private/element_p.h>


/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008-2016 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gst/gst.h>
#include <gstreamermm/bus.h>
#include <gstreamermm/caps.h>
#include <gstreamermm/elementfactory.h>
#include <gstreamermm/event.h>
#include <gstreamermm/pad.h>
#include <gstreamermm/padtemplate.h>
#include <gstreamermm/query.h>
#include <gstreamermm/iterator.h>
#include <gstreamermm/handle_error.h>


namespace Gst
{

namespace Enums
{

Glib::ustring get_name(State s)
{
  return gst_element_state_get_name(GstState(s));
}

Glib::ustring get_name(StateChangeReturn s)
{
  return gst_element_state_change_return_get_name(GstStateChangeReturn(s));
}

} //namespace Enums

Glib::RefPtr<Gst::Element> Element::link(const Glib::RefPtr<Gst::Element>& dest)
{
  if(!dest)
    gstreamermm_handle_error("Failed to link null element.");
    
  const bool result = gst_element_link(gobj(), Glib::unwrap(dest));

  if(result)
    return dest;
  else
  {
    gstreamermm_handle_error("failed to link: " + get_name() + "->" +
      dest->get_name());
    return Glib::RefPtr<Gst::Element>();
  }
}

Glib::RefPtr<Gst::Element> Element::link(const Glib::RefPtr<Gst::Element>& dest, const Glib::RefPtr<Gst::Caps>& filter)
{
  if(!dest)
    gstreamermm_handle_error("Failed to link null element.");
    
  const bool result = gst_element_link_filtered(gobj(), Glib::unwrap(dest),
    Glib::unwrap(filter));

  if(result)
    return dest;
  else
  {
    gstreamermm_handle_error("failed to link: " + get_name() + "->" +
      dest->get_name());
    return Glib::RefPtr<Gst::Element>();
  }
}

void Element::post_message(int code, int line, MessageType type,
  const Glib::QueryQuark& domain, const Glib::ustring& text,
  const Glib::ustring& debug, const Glib::ustring& file,
  const Glib::ustring& function)
{
  gchar* gst_text = g_strdup(text.c_str());
  gchar* gst_debug = g_strdup(debug.c_str());

  gst_element_message_full(gobj(), static_cast<GstMessageType>(type),
    domain, code, gst_text, gst_debug, file.c_str(), function.c_str(), line);
}

bool Element::send_event(const Glib::RefPtr<Gst::Event>& event)
{
  event->reference();
  return gst_element_send_event(gobj(), Glib::unwrap(event));
}

Glib::RefPtr<Gst::PadTemplate> Gst::Element::get_pad_template(const Glib::ustring &factory_name) const
{
  return Glib::wrap(gst_element_class_get_pad_template(GST_ELEMENT_GET_CLASS(gobject_), factory_name.c_str()), true);
}

} //namespace Gst

namespace
{


static const Glib::SignalProxyInfo Element_signal_no_more_pads_info =
{
  "no-more-pads",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static void Element_signal_pad_added_callback(GstElement* self, GstPad* p0,void* data)
{
  using namespace Gst;
  using SlotType = sigc::slot< void,const Glib::RefPtr<Gst::Pad>& >;

  auto obj = dynamic_cast<Element*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
);
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }
}

static const Glib::SignalProxyInfo Element_signal_pad_added_info =
{
  "pad-added",
  (GCallback) &Element_signal_pad_added_callback,
  (GCallback) &Element_signal_pad_added_callback
};


static void Element_signal_pad_removed_callback(GstElement* self, GstPad* p0,void* data)
{
  using namespace Gst;
  using SlotType = sigc::slot< void,const Glib::RefPtr<Gst::Pad>& >;

  auto obj = dynamic_cast<Element*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
);
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }
}

static const Glib::SignalProxyInfo Element_signal_pad_removed_info =
{
  "pad-removed",
  (GCallback) &Element_signal_pad_removed_callback,
  (GCallback) &Element_signal_pad_removed_callback
};


} // anonymous namespace

// static
GType Glib::Value<Gst::ElementFlags>::value_type()
{
  return gst_element_flags_get_type();
}

// static
GType Glib::Value<Gst::StateChange>::value_type()
{
  return gst_state_change_get_type();
}

// static
GType Glib::Value<Gst::StateChangeReturn>::value_type()
{
  return gst_state_change_return_get_type();
}


namespace Glib
{

Glib::RefPtr<Gst::Element> wrap(GstElement* object, bool take_copy)
{
  return Glib::RefPtr<Gst::Element>( dynamic_cast<Gst::Element*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gst
{


/* The *_Class implementation: */

const Glib::Class& Element_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Element_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gst_element_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:

  }

  return *this;
}


void Element_Class::class_init_function(void* g_class, void* class_data)
{
  const auto klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);

  klass->release_pad = &release_pad_vfunc_callback;
  klass->request_new_pad = &request_new_pad_vfunc_callback;
  klass->get_state = &get_state_vfunc_callback;
  klass->set_state = &set_state_vfunc_callback;
  klass->change_state = &change_state_vfunc_callback;
  klass->state_changed = &state_changed_vfunc_callback;
  klass->set_bus = &set_bus_vfunc_callback;
  klass->provide_clock = &provide_clock_vfunc_callback;
  klass->set_clock = &set_clock_vfunc_callback;
  klass->send_event = &send_event_vfunc_callback;
  klass->query = &query_vfunc_callback;
  klass->set_context = &set_context_vfunc_callback;
  klass->post_message = &post_message_vfunc_callback;

  klass->no_more_pads = &no_more_pads_callback;
  klass->pad_added = &pad_added_callback;
  klass->pad_removed = &pad_removed_callback;
}

void Element_Class::release_pad_vfunc_callback(GstElement* self, GstPad* pad)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->release_pad_vfunc(Glib::wrap(pad, true)
);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->release_pad)
    (*base->release_pad)(self, pad);
}
GstPad* Element_Class::request_new_pad_vfunc_callback(GstElement* self, GstPadTemplate* templ, const gchar* name, const GstCaps* caps)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return Glib::unwrap(obj->request_new_pad_vfunc(Glib::wrap(templ)
, Glib::convert_const_gchar_ptr_to_ustring(name)
, Glib::wrap(const_cast<GstCaps*>(caps))
));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->request_new_pad)
    return (*base->request_new_pad)(self, templ, name, caps);

  using RType = GstPad*;
  return RType();
}
GstStateChangeReturn Element_Class::get_state_vfunc_callback(GstElement* self, GstState* state, GstState* pending, GstClockTime timeout)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return ((GstStateChangeReturn)(obj->get_state_vfunc(*reinterpret_cast<Gst::State*>(state)
, *reinterpret_cast<Gst::State*>(pending)
, ((ClockTime)(timeout))
)));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->get_state)
    return (*base->get_state)(self, state, pending, timeout);

  using RType = GstStateChangeReturn;
  return RType();
}
GstStateChangeReturn Element_Class::set_state_vfunc_callback(GstElement* self, GstState state)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return ((GstStateChangeReturn)(obj->set_state_vfunc(((State)(state))
)));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->set_state)
    return (*base->set_state)(self, state);

  using RType = GstStateChangeReturn;
  return RType();
}
GstStateChangeReturn Element_Class::change_state_vfunc_callback(GstElement* self, GstStateChange transition)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return ((GstStateChangeReturn)(obj->change_state_vfunc(((StateChange)(transition))
)));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->change_state)
    return (*base->change_state)(self, transition);

  using RType = GstStateChangeReturn;
  return RType();
}
void Element_Class::state_changed_vfunc_callback(GstElement* self, GstState oldstate, GstState newstate, GstState pending)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->state_changed_vfunc(((Gst::State)(oldstate))
, ((Gst::State)(newstate))
, ((Gst::State)(pending))
);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->state_changed)
    (*base->state_changed)(self, oldstate, newstate, pending);
}
void Element_Class::set_bus_vfunc_callback(GstElement* self, GstBus* bus)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->set_bus_vfunc(Glib::wrap(bus, true)
);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->set_bus)
    (*base->set_bus)(self, bus);
}
GstClock* Element_Class::provide_clock_vfunc_callback(GstElement* self)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return Glib::unwrap(obj->provide_clock_vfunc());
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->provide_clock)
    return (*base->provide_clock)(self);

  using RType = GstClock*;
  return RType();
}
gboolean Element_Class::set_clock_vfunc_callback(GstElement* self, GstClock* clock)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->set_clock_vfunc(Glib::wrap(clock, true)
));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->set_clock)
    return (*base->set_clock)(self, clock);

  return static_cast<int>(true);
}
gboolean Element_Class::send_event_vfunc_callback(GstElement* self, GstEvent* event)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->send_event_vfunc(Glib::wrap(event, true)
));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->send_event)
    return (*base->send_event)(self, event);

  using RType = gboolean;
  return RType();
}
gboolean Element_Class::query_vfunc_callback(GstElement* self, GstQuery* query)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->query_vfunc(Glib::wrap(query, true)
));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->query)
    return (*base->query)(self, query);

  using RType = gboolean;
  return RType();
}
void Element_Class::set_context_vfunc_callback(GstElement* self, GstContext* context)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->set_context_vfunc(Glib::wrap(context)
);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->set_context)
    (*base->set_context)(self, context);
}
gboolean Element_Class::post_message_vfunc_callback(GstElement* self, GstMessage* message)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->post_message_vfunc(Glib::wrap(message, true)
));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->post_message)
    return (*base->post_message)(self, message);

  using RType = gboolean;
  return RType();
}

void Element_Class::no_more_pads_callback(GstElement* self)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_no_more_pads();
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->no_more_pads)
    (*base->no_more_pads)(self);
}
void Element_Class::pad_added_callback(GstElement* self, GstPad* p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_pad_added(Glib::wrap(p0, true)
);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->pad_added)
    (*base->pad_added)(self, p0);
}
void Element_Class::pad_removed_callback(GstElement* self, GstPad* p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_pad_removed(Glib::wrap(p0, true)
);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->pad_removed)
    (*base->pad_removed)(self, p0);
}


Glib::ObjectBase* Element_Class::wrap_new(GObject* object)
{
  return new Element((GstElement*)object);
}


/* The implementation: */

GstElement* Element::gobj_copy()
{
  reference();
  return gobj();
}

Element::Element(const Glib::ConstructParams& construct_params)
:
  Gst::Object(construct_params)
{

}

Element::Element(GstElement* castitem)
:
  Gst::Object((GstObject*)(castitem))
{}


Element::Element(Element&& src) noexcept
: Gst::Object(std::move(src))
{}

Element& Element::operator=(Element&& src) noexcept
{
  Gst::Object::operator=(std::move(src));
  return *this;
}


Element::~Element() noexcept
{}


Element::CppClassType Element::element_class_; // initialize static member

GType Element::get_type()
{
  return element_class_.init().get_type();
}


GType Element::get_base_type()
{
  return gst_element_get_type();
}


bool Element::add_pad(const Glib::RefPtr<Gst::Pad>& pad)
{
  return gst_element_add_pad(gobj(), Glib::unwrap(pad));
}

void Element::create_all_pads()
{
  gst_element_create_all_pads(gobj());
}

Glib::RefPtr<Gst::Pad> Element::create_compatible_pad(const Glib::RefPtr<const Gst::Pad>& pad, const Glib::RefPtr<const Gst::Caps>& caps)
{
  return Glib::wrap(gst_element_get_compatible_pad(gobj(), const_cast<GstPad*>(Glib::unwrap(pad)), const_cast<GstCaps*>(Glib::unwrap(caps))));
}

Glib::RefPtr<Gst::PadTemplate> Element::get_compatible_pad_template(const Glib::RefPtr<const Gst::PadTemplate>& compattempl)
{
  Glib::RefPtr<Gst::PadTemplate> retvalue = Glib::wrap(gst_element_get_compatible_pad_template(gobj(), const_cast<GstPadTemplate*>(Glib::unwrap(compattempl))));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Gst::PadTemplate> Element::get_compatible_pad_template(const Glib::RefPtr<const Gst::PadTemplate>& compattempl) const
{
  return const_cast<Element*>(this)->get_compatible_pad_template(compattempl);
}

Glib::RefPtr<Gst::Pad> Element::get_request_pad(const Glib::ustring& name)
{
  return Glib::wrap(gst_element_get_request_pad(gobj(), name.c_str()));
}

Glib::RefPtr<Gst::Pad> Element::request_pad(const Glib::RefPtr<Gst::PadTemplate>& templ, const Glib::ustring& name, const Glib::RefPtr<const Gst::Caps>& caps)
{
  return Glib::wrap(gst_element_request_pad(gobj(), Glib::unwrap(templ), name.empty() ? nullptr : name.c_str(), Glib::unwrap(caps)));
}

Glib::RefPtr<Gst::Pad> Element::request_pad(const Glib::RefPtr<Gst::PadTemplate>& templ, const Glib::ustring& name)
{
  return Glib::wrap(gst_element_request_pad(gobj(), Glib::unwrap(templ), name.empty() ? nullptr : name.c_str(), nullptr));
}

Glib::RefPtr<Gst::Pad> Element::request_pad(const Glib::RefPtr<Gst::PadTemplate>& templ, const Glib::RefPtr<const Gst::Caps>& caps)
{
  return Glib::wrap(gst_element_request_pad(gobj(), Glib::unwrap(templ), nullptr, Glib::unwrap(caps)));
}

Glib::RefPtr<Gst::Pad> Element::request_pad(const Glib::RefPtr<Gst::PadTemplate>& templ)
{
  return Glib::wrap(gst_element_request_pad(gobj(), Glib::unwrap(templ), nullptr, nullptr));
}

Glib::RefPtr<Gst::Pad> Element::get_static_pad(const Glib::ustring& name)
{
  return Glib::wrap(gst_element_get_static_pad(gobj(), name.c_str()));
}

Glib::RefPtr<const Gst::Pad> Element::get_static_pad(const Glib::ustring& name) const
{
  return const_cast<Element*>(this)->get_static_pad(name);
}

void Element::no_more_pads()
{
  gst_element_no_more_pads(gobj());
}

void Element::release_request_pad(const Glib::RefPtr<Gst::Pad>& pad)
{
  gst_element_release_request_pad(gobj(), Glib::unwrap(pad));
}

bool Element::remove_pad(const Glib::RefPtr<Gst::Pad>& pad)
{
  return gst_element_remove_pad(gobj(), Glib::unwrap(pad));
}

Gst::Iterator<Gst::Pad> Element::iterate_pads()
{
  return Gst::Iterator<Gst::Pad>(gst_element_iterate_pads(gobj()));
}

Gst::Iterator<const Gst::Pad> Element::iterate_pads() const
{
  return Gst::Iterator<const Gst::Pad>(gst_element_iterate_pads(const_cast<GstElement*>(gobj())));
}

Gst::Iterator<Gst::Pad> Element::iterate_sink_pads()
{
  return Gst::Iterator<Gst::Pad>(gst_element_iterate_sink_pads(gobj()));
}

Gst::Iterator<const Gst::Pad> Element::iterate_sink_pads() const
{
  return Gst::Iterator<const Gst::Pad>(gst_element_iterate_sink_pads(const_cast<GstElement*>(gobj())));
}

Gst::Iterator<Gst::Pad> Element::iterate_src_pads()
{
  return Gst::Iterator<Gst::Pad>(gst_element_iterate_src_pads(gobj()));
}

Gst::Iterator<const Gst::Pad> Element::iterate_src_pads() const
{
  return Gst::Iterator<const Gst::Pad>(gst_element_iterate_src_pads(const_cast<GstElement*>(gobj())));
}

void Element::unlink(const Glib::RefPtr<Gst::Element>& dest)
{
  gst_element_unlink(gobj(), Glib::unwrap(dest));
}

void Element::set_context(const Glib::RefPtr<Gst::Context>& context)
{
  gst_element_set_context(gobj(), context->gobj());
}

bool Element::link_pads(const Glib::ustring& srcpadname, const Glib::RefPtr<Gst::Element>& dest, const Glib::ustring& destpadname)
{
  return gst_element_link_pads(gobj(), srcpadname.c_str(), Glib::unwrap(dest), destpadname.c_str());
}

void Element::unlink_pads(const Glib::ustring& srcpadname, const Glib::RefPtr<Gst::Element>& dest, const Glib::ustring& destpadname)
{
  gst_element_unlink_pads(gobj(), srcpadname.c_str(), Glib::unwrap(dest), destpadname.c_str());
}

bool Element::link_pads(const Glib::ustring& srcpadname, const Glib::RefPtr<Gst::Element>& dest, const Glib::ustring& destpadname, const Glib::RefPtr<Gst::Caps>& filter)
{
  return gst_element_link_pads_filtered(gobj(), srcpadname.c_str(), Glib::unwrap(dest), destpadname.c_str(), Glib::unwrap(filter));
}

bool Element::link_pads(const Glib::ustring& srcpadname, const Glib::RefPtr<Gst::Element>& dest, const Glib::ustring& destpadname, PadLinkCheck flags)
{
  return gst_element_link_pads_full(gobj(), srcpadname.c_str(), Glib::unwrap(dest), destpadname.c_str(), ((GstPadLinkCheck)(flags)));
}

void Element::set_base_time(ClockTime time)
{
  gst_element_set_base_time(gobj(), ((GstClockTime)(time)));
}

ClockTime Element::get_base_time() const
{
  return ((ClockTime)(gst_element_get_base_time(const_cast<GstElement*>(gobj()))));
}

void Element::set_start_time(Gst::ClockTime time)
{
  gst_element_set_start_time(gobj(), ((GstClockTime)(time)));
}

Gst::ClockTime Element::get_start_time() const
{
  return ((Gst::ClockTime)(gst_element_get_start_time(const_cast<GstElement*>(gobj()))));
}

void Element::set_bus(const Glib::RefPtr<Gst::Bus>& bus)
{
  gst_element_set_bus(gobj(), Glib::unwrap(bus));
}

Glib::RefPtr<Gst::Bus> Element::get_bus()
{
  return Glib::wrap(gst_element_get_bus(gobj()));
}

Glib::RefPtr<const Gst::Bus> Element::get_bus() const
{
  return const_cast<Element*>(this)->get_bus();
}

Glib::RefPtr<Gst::ElementFactory> Element::get_factory()
{
  Glib::RefPtr<Gst::ElementFactory> retvalue = Glib::wrap(gst_element_get_factory(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Gst::ElementFactory> Element::get_factory() const
{
  return const_cast<Element*>(this)->get_factory();
}

bool Element::set_clock(const Glib::RefPtr<Gst::Clock>& clock)
{
  return gst_element_set_clock(gobj(), Glib::unwrap(clock));
}

Glib::RefPtr<Gst::Clock> Element::get_clock()
{
  return Glib::wrap(gst_element_get_clock(gobj()));
}

Glib::RefPtr<const Gst::Clock> Element::get_clock() const
{
  return const_cast<Element*>(this)->get_clock();
}

Glib::RefPtr<Gst::Clock> Element::provide_clock()
{
  return Glib::wrap(gst_element_provide_clock(gobj()));
}

Glib::RefPtr<const Gst::Clock> Element::provide_clock() const
{
  return const_cast<Element*>(this)->provide_clock();
}

StateChangeReturn Element::set_state(State state)
{
  return ((StateChangeReturn)(gst_element_set_state(gobj(), ((GstState)(state)))));
}

StateChangeReturn Element::get_state(State& state, State& pending, ClockTime timeout) const
{
  return ((StateChangeReturn)(gst_element_get_state(const_cast<GstElement*>(gobj()), (GstState*)(&state), (GstState*)(&pending), ((GstClockTime)(timeout)))));
}

bool Element::set_locked_state(gboolean locked_state)
{
  return gst_element_set_locked_state(gobj(), locked_state);
}

bool Element::is_locked_state() const
{
  return gst_element_is_locked_state(const_cast<GstElement*>(gobj()));
}

void Element::abort_state()
{
  gst_element_abort_state(gobj());
}

StateChangeReturn Element::continue_state(StateChangeReturn ret)
{
  return ((StateChangeReturn)(gst_element_continue_state(gobj(), ((GstStateChangeReturn)(ret)))));
}

void Element::lost_state()
{
  gst_element_lost_state(gobj());
}

bool Element::sync_state_with_parent()
{
  return gst_element_sync_state_with_parent(gobj());
}

StateChangeReturn Element::change_state(StateChange transition)
{
  return ((StateChangeReturn)(gst_element_change_state(gobj(), ((GstStateChange)(transition)))));
}

bool Element::post_message(Glib::RefPtr<Gst::Message>&& message)
{
  return gst_element_post_message(gobj(), (message) ? message.release()->gobj() : nullptr);
}

bool Element::query(const Glib::RefPtr<Gst::Query>& query) const
{
  return gst_element_query(const_cast<GstElement*>(gobj()), Glib::unwrap(query));
}

bool Element::query_convert(Gst::Format src_format, gint64 src_val, Format dest_format, gint64& dest_val) const
{
  return gst_element_query_convert(const_cast<GstElement*>(gobj()), ((GstFormat)(src_format)), src_val, ((GstFormat)(dest_format)), &(dest_val));
}

bool Element::query_position(Gst::Format format, gint64& cur) const
{
  return gst_element_query_position(const_cast<GstElement*>(gobj()), ((GstFormat)(format)), &(cur));
}

bool Element::query_position(Gst::Format format) const
{
  return gst_element_query_position(const_cast<GstElement*>(gobj()), ((GstFormat)(format)), nullptr);
}

bool Element::query_duration(Gst::Format format, gint64& duration) const
{
  return gst_element_query_duration(const_cast<GstElement*>(gobj()), ((GstFormat)(format)), &(duration));
}

bool Element::query_duration(Gst::Format format) const
{
  return gst_element_query_duration(const_cast<GstElement*>(gobj()), ((GstFormat)(format)), nullptr);
}

bool Element::seek(Format format, SeekFlags seek_flags, gint64 seek_pos)
{
  return gst_element_seek_simple(gobj(), ((GstFormat)(format)), ((GstSeekFlags)(seek_flags)), seek_pos);
}

bool Element::seek(double rate, Format format, SeekFlags flags, SeekType cur_type, gint64 cur, SeekType stop_type, gint64 stop)
{
  return gst_element_seek(gobj(), rate, ((GstFormat)(format)), ((GstSeekFlags)(flags)), ((GstSeekType)(cur_type)), cur, ((GstSeekType)(stop_type)), stop);
}

bool Element::send_event(Glib::RefPtr<Gst::Event>&& event)
{
  return gst_element_send_event(gobj(), (event) ? event.release()->gobj() : nullptr);
}

Glib::RefPtr<Gst::Context> Element::get_context(const Glib::ustring& context_type)
{
  return Glib::wrap(gst_element_get_context(gobj(), context_type.c_str()));
}

Glib::RefPtr<Gst::Context> Element::get_context_unlocked(const Glib::ustring& context_type)
{
  return Glib::wrap(gst_element_get_context_unlocked(gobj(), context_type.c_str()));
}

std::vector< Glib::RefPtr<Gst::Context> > Element::get_contexts()
{
  return Glib::ListHandler< Glib::RefPtr<Gst::Context> >::list_to_vector(const_cast<GList*>(gst_element_get_contexts(gobj())), Glib::OWNERSHIP_DEEP);
}


Glib::SignalProxy< void > Element::signal_no_more_pads()
{
  return Glib::SignalProxy< void >(this, &Element_signal_no_more_pads_info);
}


Glib::SignalProxy< void,const Glib::RefPtr<Gst::Pad>& > Element::signal_pad_added()
{
  return Glib::SignalProxy< void,const Glib::RefPtr<Gst::Pad>& >(this, &Element_signal_pad_added_info);
}


Glib::SignalProxy< void,const Glib::RefPtr<Gst::Pad>& > Element::signal_pad_removed()
{
  return Glib::SignalProxy< void,const Glib::RefPtr<Gst::Pad>& >(this, &Element_signal_pad_removed_info);
}


void Gst::Element::on_no_more_pads()
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->no_more_pads)
    (*base->no_more_pads)(gobj());
}
void Gst::Element::on_pad_added(const Glib::RefPtr<Gst::Pad>& new_pad)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->pad_added)
    (*base->pad_added)(gobj(),Glib::unwrap(new_pad));
}
void Gst::Element::on_pad_removed(const Glib::RefPtr<Gst::Pad>& old_pad)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->pad_removed)
    (*base->pad_removed)(gobj(),Glib::unwrap(old_pad));
}

void Gst::Element::release_pad_vfunc(const Glib::RefPtr<Gst::Pad>& pad) 
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->release_pad)
  {
    (*base->release_pad)(gobj(),Glib::unwrap(pad));
  }
}
Glib::RefPtr<Gst::Pad> Gst::Element::request_new_pad_vfunc(Glib::RefPtr<Gst::PadTemplate> templ, const Glib::ustring& name, const Glib::RefPtr<const Gst::Caps>& caps) 
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->request_new_pad)
  {
    Glib::RefPtr<Gst::Pad> retval(Glib::wrap((*base->request_new_pad)(gobj(),Glib::unwrap(templ),name.c_str(),Glib::unwrap(caps))));
    return retval;
  }

  using RType = Glib::RefPtr<Gst::Pad>;
  return RType();
}
StateChangeReturn Gst::Element::get_state_vfunc(State& state, State& pending, ClockTime timeout) const
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->get_state)
  {
    StateChangeReturn retval(((StateChangeReturn)((*base->get_state)(const_cast<GstElement*>(gobj()),(GstState*)(&state),(GstState*)(&pending),((GstClockTime)(timeout))))));
    return retval;
  }

  using RType = StateChangeReturn;
  return RType();
}
StateChangeReturn Gst::Element::set_state_vfunc(State state) 
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->set_state)
  {
    StateChangeReturn retval(((StateChangeReturn)((*base->set_state)(gobj(),((GstState)(state))))));
    return retval;
  }

  using RType = StateChangeReturn;
  return RType();
}
StateChangeReturn Gst::Element::change_state_vfunc(StateChange transition) 
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->change_state)
  {
    StateChangeReturn retval(((StateChangeReturn)((*base->change_state)(gobj(),((GstStateChange)(transition))))));
    return retval;
  }

  using RType = StateChangeReturn;
  return RType();
}
void Gst::Element::state_changed_vfunc(Gst::State oldstate, Gst::State newstate, Gst::State pending) 
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->state_changed)
  {
    (*base->state_changed)(gobj(),((GstState)(oldstate)),((GstState)(newstate)),((GstState)(pending)));
  }
}
void Gst::Element::set_bus_vfunc(const Glib::RefPtr<Gst::Bus>& bus) 
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->set_bus)
  {
    (*base->set_bus)(gobj(),Glib::unwrap(bus));
  }
}
Glib::RefPtr<Gst::Clock> Gst::Element::provide_clock_vfunc() 
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->provide_clock)
  {
    Glib::RefPtr<Gst::Clock> retval(Glib::wrap((*base->provide_clock)(gobj())));
    return retval;
  }

  using RType = Glib::RefPtr<Gst::Clock>;
  return RType();
}
bool Gst::Element::set_clock_vfunc(const Glib::RefPtr<Gst::Clock>& clock) 
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->set_clock)
  {
    bool retval((*base->set_clock)(gobj(),Glib::unwrap(clock)));
    return retval;
  }

  return true;
}
bool Gst::Element::send_event_vfunc(const Glib::RefPtr<Gst::Event>& event) 
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->send_event)
  {
    bool retval((*base->send_event)(gobj(),Glib::unwrap(event)));
    return retval;
  }

  using RType = bool;
  return RType();
}
bool Gst::Element::query_vfunc(const Glib::RefPtr<Gst::Query>& query) const
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->query)
  {
    bool retval((*base->query)(const_cast<GstElement*>(gobj()),Glib::unwrap(query)));
    return retval;
  }

  using RType = bool;
  return RType();
}
void Gst::Element::set_context_vfunc(const Glib::RefPtr<Gst::Context>& context) 
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->set_context)
  {
    (*base->set_context)(gobj(),context->gobj());
  }
}
bool Gst::Element::post_message_vfunc(const Glib::RefPtr<Gst::Message>& message) 
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->post_message)
  {
    bool retval((*base->post_message)(gobj(),Glib::unwrap(message)));
    return retval;
  }

  using RType = bool;
  return RType();
}


} // namespace Gst


