#ifndef UOS_RECOVERY_ADVANCEDGHOSTWIDGET_H
#define UOS_RECOVERY_ADVANCEDGHOSTWIDGET_H

#include <DGuiApplicationHelper>
#include <DWidget>
#include <DSpinner>
#include <DPushButton>
#include <DSuggestButton>

DTK_USE_NAMESPACE
DWIDGET_USE_NAMESPACE

class QWidget;
class QLabel;
class QPushButton;
class QVBoxLayout;

class AdvancedGhostWidget  : public DWidget
{
    Q_OBJECT

public:
    explicit AdvancedGhostWidget(QWidget *parent = nullptr);
    void setDestDirText(const QString &path);
    QString getDestDirText();
    void setResultInfo(const QString &info, bool error = false);

private:
    void initUI();
    void initConnect();
    void startCalculateTip(bool start);
    void setErrorInfo(const QString &info, bool normalStyle = false);

signals:
    void checkSpaceSignal(const QString &selectDir);
    void cancelBtnSignal();
    void startMakeBtnSignal(const QString &selectDir);

private Q_SLOTS:
    void startMakeBtnClicked();
    void selectPathBtnClicked();
    void onThemeChange();

private:
    Dtk::Gui::DGuiApplicationHelper *m_guiHelper;
    QLabel *m_title           = nullptr;
    QLabel *m_subTitle        = nullptr;
    QLabel *m_destPathLabel   = nullptr;
    QLabel *m_errorInfoLabel  = nullptr;
    DPushButton *m_selectPath = nullptr;
    DPushButton *m_cancel     = nullptr;
    DSuggestButton *m_startMake  = nullptr;
    QVBoxLayout *m_mainLayout = nullptr;
    DSpinner *m_calculateTip = nullptr;
};


#endif //UOS_RECOVERY_ADVANCEDGHOSTWIDGET_H
