#ifndef _UOS_RECOVERY_LVM_USER_DATA_H_
#define _UOS_RECOVERY_LVM_USER_DATA_H_

#include "UserDataRecovery.h"

class LvmUserData : public UserDataRecovery
{
    Q_OBJECT
public:
    explicit LvmUserData();
    virtual ~LvmUserData();

    bool supported(FSTabInfoList &fsTabInfoList) override;
    //备份用户数据
    ErrorCode userDataBackup(UserDataBackupRequest &request) override;
    ErrorCode checkUserDataBackupSpace(UserDataBackupRequest &request) override;

    //还原用户数据
    ErrorCode userDataRestore(UserDataRestoreRequest &request) override;
    BackupInfoList listUserDataBackup(const QString &username) override;
    ErrorCode removeUserDataBackup(RemoveUserDataBackupRequest &request) override;

private:
    void writeBackupInfo();
    ErrorCode fillBackupInfo();
    ErrorCode parseUserDataBackupReq(const UserDataBackupRequest &request);

private:
    BackupInfo m_backupInfo;
    UserDataBackupRequest m_request;
};

#endif
