--[[ Copyright (c) 2012 lwglwsss

Permission is hereby granted, free of charge, to any person obtaining a copy of
this software and associated documentation files (the "Software"), to deal in
the Software without restriction, including without limitation the rights to
use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
of the Software, and to permit persons to whom the Software is furnished to do
so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE. --]]

-- Note: This file contains UTF-8 text. Make sure your editor is set to UTF-8.

Font("unicode")
Language("简体中文", "Chinese (simplified)", "zh(s)", "chi(s)", "zho(s)")
Inherit("english")
Encoding(utf8)

------------------------------------
--NEW STRINGS IN LANGUAGE "简体中文":
------------------------------------
date_format = {
  daymonth = "%2%月 %1%日",
}
misc = {
  no_heliport = "还没有疾病被发现或者地图上需要一个直升机场",
  not_yet_implemented = "(尚未实现)",
}
debug_patient_window = {
  caption = "病人除错",
}
totd_window = {
  tips = {
    "医院想开张就需要一个前台桌子和一个问诊室.这之后还需要根据不同病人建立各种房间.但有个药房总是对的.",
    "有一些机器需要维护,比如说充气机.所以雇一两个修理人员还是必要的, 不然那就是个定时炸弹.",
    "你的员工会不时感到疲倦. 所以建一间休闲室也很必要.",
    "多放点几个暖气,让你的员工和病人感到春天般温暖.用全景地图来查看它们的覆盖面积以决定是否还需要多放些.",
    "一个医生的医疗水平很大程度影响他的诊断速度.把最牛逼的医生放在问诊室,这样你会省下其他的问诊室.",
    "实习生和医生们可以通过在学习室向专家学习来提高水平.如果请来的专家拥有某一项专长,他也会教给他的学生们.",
    "有没有试过在传真机上拨112?这是欧洲的急救电话.别忘了把你的音箱开到最大!",
    "在主菜单和游戏菜单里面,找到选项窗口,在那里可以调整分辨率和语言.",
    "你选择了中文,但是你还是可能会在游戏中不停地看到英文.把他们翻译了吧,我们需要你的帮助!",
    "CorsixTH小组正在壮大!如果你对编程,翻译,创做主题医院需要的图片等等任何方面感兴趣,请通过我们的论坛,邮件列表或者IRC频道(corsix-th at freenode)联系我们.",
    "如果你碰到了bug,请提交给我们: th-issues.corsix.org",
    "每一关都需要满足特定的条件才能过关.你可以通过状态窗口看到你的进度.",
    "如果你需要编辑或者删除一间房间,屏幕下方找到工具栏,然后点编辑房间按钮.",
    "在成群结队等待就诊的病人中, 你可以通过指向房间的门来找到哪些病人在等.",
    "点击房间门可以看到等待队列.你可以做些调整让某些人走个后门,或者送到另一个房间去.",
    "不开心的员工只有通过涨薪来平衡自己了.你要保证你的员工的工作环境像家一样,才能让他们甘心给你卖命.",
    "病人等的时间长了,会口渴,如果开了暖气,口渴得会更快!放些自动贩卖机吧,还能多些零花钱.",
    "如果你见过某种病,你可以中断诊疗过程直接去治,治死了不要找我.",
    "从紧急事件总能赚一大笔,但是你要按时处理好才行.",
  },
  previous = "前一项提示",
  next = "下一项提示",
}
tooltip = {
  totd_window = {
    previous = "显示上一个提示",
    next = "显示下一个提示",
  },
  message = {
    button = "点击打开消息",
    button_dismiss = "点击打开消息，右键点击忽略",
  },
  custom_game_window = {
    start_game_with_name = "%s",
  },
  cheats_window = {
    close = "关闭作弊窗口",
    cheats = {
      end_month = "跳到月末.",
      emergency = "建一个急诊室.",
      win_level = "赢得当前关卡.",
      create_patient = "在地图的边缘生成一个病人.",
      money = "往银行里存 10.000.",
      lose_level = "在当前关卡败北.",
      all_research = "完成所有的研究.",
      end_year = "跳到年末.",
    },
  },
  casebook = {
    cure_requirement = {
      hire_staff = "您需要雇佣人员来治疗该疾病",
    },
    cure_type = {
      unknown = "您还不知道如何治疗该疾病",
    },
  },
  main_menu = {
    exit = "退出",
    custom_level = "自定义游戏",
    options = "选项",
  },
  menu_list_window = {
    back = "返回",
  },
  new_game_window = {
    hard = "游戏难度：困难",
    cancel = "返回",
    tutorial = "游戏上手教程",
    easy = "游戏难度：简单",
    medium = "游戏难度：中等",
  },
  save_game_window = {
    new_save_game = "",
    save_game = "%s",
  },
  calls_dispatcher = {
    assigned = "这个框代表是否有人被分配给此任务.",
    task = "任务列表 - 点击任务打开人员分配窗口然后滚动到任务的位置",
    close = "关闭接线员窗口",
  },
  research_policy = {
    research_progress = "此类研究下次发现的进度: %1%/%2%",
    no_research = "当前没有任何此类研究在进行中",
  },
  information = {
    close = "关闭",
  },
  lua_console = {
    textbox = "输入Lua代码可直接运行",
    execute_code = "运行输入的代码",
    close = "关闭控制台",
  },
  load_game_window = {
    load_game = "%s",
    load_autosave = "载入自动保存的游戏",
    load_game_number = "载入游戏 %d",
  },
  fax = {
    close = "关闭此窗口，但不删除消息",
  },
  objects = {
    litter = "废弃物: 病人找不到垃圾桶,所以随意丢在了地上.",
  },
  options_window = {
    fullscreen_button = "全屏幕",
    change_resolution = "更改分辨率",
    height = "垂直像素",
    width = "水平像素",
    language = "转换语言为%s",
    back = "返回",
  },
}
custom_game_window = {
  caption = "自定义游戏",
}
cheats_window = {
  cheats = {
    end_month = "月末",
    emergency = "修建急诊室",
    win_level = "获胜",
    create_patient = "生成病人",
    money = "给我钱!!",
    lose_level = "失败",
    all_research = "所有研究",
    end_year = "年末",
  },
  close = "关闭",
  caption = "作弊",
  cheated = {
    no = "作弊了吗: 否",
    yes = "作弊了吗: 是",
  },
  warning = "警告: 如果作弊关卡结束时你将得不到任何奖励!",
}
errors = {
  unavailable_screen_size = "你设置的屏幕大小无法应用于全屏模式。",
  dialog_missing_graphics = "哎呀, Demo 数据文件不包含这个对话框.",
  load_prefix = "载入游戏失败：",
  save_prefix = "保存游戏失败：",
  map_file_missing = "找不到该关卡的地图文件 %s！",
  minimum_screen_size = "最小屏幕大小为 640x480。",
}
main_menu = {
  new_game = "开始游戏",
  custom_level = "自定义游戏",
  continue = "继续游戏",
  load_game = "载入游戏",
  options = "选项",
  version = "版本: ",
  exit = "退出"
}
menu_debug = {
  lua_console = "  (F12) LUA 控制台  ",
  disable_salary_raise = "  关闭涨工资  ",
  make_debug_fax = "  建一个传真DEBUG  ",
  make_debug_patient = "  建一个病人DEBUG   ",
  sprite_viewer = "  图像浏览器  ",
  dump_strings = "  输出字符串  ",
  map_overlay = "  地图层次  ",
  calls_dispatcher = "  接线员窗口  ",
  cheats = "  (F11) 作弊  ",
  dump_gamelog = "  (CTRL+D) 输出游戏记录文本  ",
  limit_camera = "   限制镜头   ",
  transparent_walls = "  (X) 把墙变透明 ",
  jump_to_level = "  跳关  ",
}
menu_options = {
  edge_scrolling = "    边缘滚动",
  lock_windows = "    锁定窗口",
  sound = "  (ALT+S) 音效   ",
  announcements = "  (ALT+A) 公告   ",
  music = "  (ALT+M) 音乐   ",
  jukebox = "  (J) 音乐盒  ",
  adviser_disabled = "  (SHIFT+A) 建议  ",
  warmth_colors = "  暖气区域显示  ",
  wage_increase = "  涨工资要求",
  twentyfour_hour_clock = "  24小时时钟  "
}
menu_options_game_speed = {
  pause = "    暂停",
}
lua_console = {
  execute_code = "运行",
  close = "关闭",
}
install = {
  title = "-------------------------------- CorsixTH  游戏设置 -------------------------------",
  th_directory = "运行游戏需要原版主题医院。请指定原版主题医院游戏安装文件夹。",
  ok = "确定",
  exit = "退出",
  cancel = "取消"
}
load_game_window = {
  caption = "载入游戏",
}
adviser = {
  cheats = {
    th_cheat = "恭喜, 你解锁了作弊选项!",
    hairyitis_cheat = "Hairyitis 作弊模式已经开启!",
    roujin_on_cheat = "Roujin's challenge已经开启!祝你好运...",
    crazy_on_cheat = "不会吧!所有的医生都疯了!",
    bloaty_off_cheat = "大头病作弊被关闭.",
    bloaty_cheat = "大头病作弊开启!",
    crazy_off_cheat = "还好... 所有的一生都恢复理智了.",
    roujin_off_cheat = "Roujin's challenge关闭.",
    hairyitis_off_cheat = "Hairyitis 作弊模式关闭.",
  },
  warnings = {
    no_desk = "你总得有个前台吧!",
    no_desk_1 = "你得有个前台,这样才会有病人来!",
    no_desk_2 = "干的不错, 基本上也是个世界纪录了吧:快一年了,一个病人都没有! 如果你想继续当这个经理的话,你需要去雇一个前台,然后给她一张桌子工作!",
    no_desk_3 = "你真是个天才,一年了连个前台都没有! 你怎么可能有任何的病人来? 赶紧给我搞定,别在那里不务正业了!",
    no_desk_4 = "前台需要一个桌子来接待来访的病人",
    no_desk_5 = "Well it's about time, you should start to see some patients arriving soon!",
    no_desk_6 = "You have a receptionist, so how about building a reception desk for her to work from?",
    no_desk_7 = "You've built the reception desk, so how about hiring a receptionist?  You won't see any patients until you get this sorted out you know!",
    falling_1 = "嘿!别开玩笑了, 看看你都是怎么点鼠标的, 你可能会伤到人!",
    falling_2 = "不要再胡搞了, 跟有病似的?",
    falling_3 = "啊~有人受伤了,赶紧叫医生!",
    falling_4 = "这里是医院,不是主题公园!",
    falling_5 = "这里不适合逗人玩,他们是病人好吗?",
    falling_6 = "这里不是保龄球馆, 应该对待病人如春天般温暖!",
    cannot_afford = "你已经没有足够的钱来雇这个人!",-- I can't see anything like this in the original strings
    cannot_afford_2 = "你没有足够的存款来做这件事!",
    research_screen_open_1 = "你需要建设一个研究科室才能访问研究页面.",
    research_screen_open_2 = "这一关不能开展研究.",
    researcher_needs_desk_1 = "研究员需要一张桌子展开工作.",
    researcher_needs_desk_2 = "你的研究员对你允许他休息片刻表示感谢,但如果你想让每个人都工作,你需要给每个人一张桌子.",
    researcher_needs_desk_3 = "每个研究院需要自己的桌子.",
    nurse_needs_desk_1 = "每个护士都需要自己的桌子.",
    nurse_needs_desk_2 = "你的护士对你允许他休息片刻表示感谢,但如果你想让每个人都工作,你需要给每个人一张桌子.",
  },
  room_forbidden_non_reachable_parts = "在这个地方放置房间会导致医院的部分空间无法到达.",
}
calls_dispatcher = {
  repair = "修理 %s",
  summary = "%d 次电话; %d 被分配",
  close = "关闭",
  watering = "浇水 @ %d,%d",
  staff = "%s - %s",
}
information = {
  level_lost = {
    [1] = "您失败了！游戏结束。",
    [2] = "由于：",
    reputation = "声望低于%d。",
    balance = "银行账户资金低于%d。",
    percentage_killed = "杀死了%d的病人。",
  },
  cannot_restart = "不幸的是这个自定义地图是在 重新开始 功能开发之前创建的.",
  custom_game = "欢迎来到 CorsixTH。尽情享受自定义地图吧！",
}
new_game_window = {
  caption = "竞争上岗",
  player_name = "玩家名称",
  option_on = "开",
  option_off = "关",
  difficulty = "难度",
  easy = "实习医生（容易）",
  medium = "医生（一般）",
  hard = "专家（难）",
  tutorial = "游戏教程",
  start = "开始",
  cancel = "返回",
}

options_window = {
  caption = "设置",
  option_on = "开",
  option_off = "关",
  fullscreen = "全屏幕",
  resolution = "分辨率",
  custom_resolution = "自定义...",
  width = "宽度",
  height = "高度",
  audio = "全局音效",
  customise = "自定义",
  folder = "文件夹",
  language = "语言",
  apply = "应用",
  cancel = "取消",
  back = "返回",
}

menu_list_window = {
  name = "名称",
  save_date = "已修改",
  back = "返回",
}

save_game_window = {
  caption = "保存游戏",
  new_save_game = "给新游戏存档起个名",
}
fax = {
  choices = {
    decline_new_level = "继续经营这个医院",
    accept_new_level = "接手下一个医院",
    return_to_main_menu = "返回到主菜单",
  },
}
menu_debug_overlay = {
  heat = "  温度  ",
  byte_0_1 = "  BYTE 0 & 1  ",
  byte_6 = "  BYTE 6  ",
  flags = "  FLAGS  ",
  byte_7 = "  BYTE 7  ",
  byte_5 = "  BYTE 5  ",
  byte_floor = "  BYTE FLOOR  ",
  positions = "  POSITIONS  ",
  byte_w_wall = "  BYTE W WALL  ",
  parcel = "  PARCEL  ",
  byte_n_wall = "  BYTE N WALL  ",
  none = "  NONE  ",
}
confirmation = {
  abort_edit_room = "你正在修建或者就该一个房间.如果所有必需的物品都被放置了就没有问题,否则所做的修改将被删除. 继续吗?",
  needs_restart = "这项设置的改动需要重新启动 CorsixTH. 尚未保存的进度将会丢失. 确定要这么做吗?",
}
dynamic_info = {
  patient = {
    actions = {
      no_gp_available = "您需要建造一般诊断室",
    },
  },
  staff = {
    actions = {
      fired = "已解雇",
      heading_for = "前往%s",
    },
  },
}
introduction_texts = {
  demo =
    "欢迎来到演示版医院!//" ..
    "演示版本只有当前这一个关卡. 但有一堆事情足够你忙一阵了! " ..
    "你将会遇到各种疾病需要各种医疗室来救治. 紧急情况也会经常性地发生. 你需要通过研究室来研发更多的医疗室. " ..
    "你的目标是挣够 $100,000, 使医院的价值达到 $70,000 以及得到 700 声望值, 同时你还需要救治超过 75% 的病人. " ..
    "确保你的声望值不会掉到 300 以下, 你的病人死亡率不超过 40% , 否则你就完了.//" ..
    "祝你好运!",
}
object = {
  litter = "废弃物",
}
letter = {
  custom_level_completed = "做的好！你已完成自定义游戏的所有目标！",
  dear_player = "亲爱的 %s",
  return_to_main_menu = "你想要回到主菜单还是继续游戏?",
}

update_window = {
  caption = "可升级新版本！",
  new_version = "新版本：",
  current_version = "当前版本：",
  download = "打开下载页面",
  ignore = "回到主菜单"
}

tooltip.custom_game_window.free_build = "勾选此框你将不需要为钱以及胜利失败而操心"
tooltip.cheats_window.cheats.vip = "创建一个 VIP."
tooltip.menu_list_window.save_date = "点击整理一个按照最后修改日期排序的列表"
tooltip.menu_list_window.name = "点击按照名字整理"
custom_game_window.free_build = "自由模式"
cheats_window.cheats.vip = "创建 VIP"
main_menu.version = "版本: "
main_menu.savegame_version = "存档版本: "
progress_report.free_build = "自由模式"
menu_options.adviser_disabled = "    显示建议"
install.exit = "退出"
information.very_old_save = "你上次存档之后,这个游戏有很多更新. 为了保证你能玩到最新最酷的游戏,请考虑重新来过"
options_window.cancel = "取消"
menu_list_window.save_date = "修改日期"
menu_list_window.name = "名称"
fax.vip_visit_result.remarks.free_build[1] = "你的医院相当不错! 没有预算的限制,搞定很容易吧?"
fax.vip_visit_result.remarks.free_build[2] = "我不是一个经济学家, 但我要是你我也行. 你懂我啥意思..."
fax.vip_visit_result.remarks.free_build[3] = "医院经营的不错. 但要小心经济不景气. 哦对了,你才不操那个心."
fax.emergency.free_build = "成功的话,你的声望就会上升,但你要是失败了, 就会一落千丈."
fax.emergency.num_disease_singular = "那里有一个人患了 %s ,他们需要马上救治."

------------------------------------
--OLD STRINGS IN LANGUAGE "简体中文":
------------------------------------
misc = {
  hospital_open = "医院开门",
  save_success = "游戏存档成功",
  save_failed = "错误：无法存档",
  low_res = "低清晰度",
  grade_adverb = {
    extremely = "极端的",
    mildly = "柔和的",
    moderately = "适当的",
  },
  send_message = "向玩家%d发送信息",
  out_of_sync = "游戏失去同步",
  balance = "难度选择：",
  load_failed = "存档游戏没有被读取",
  mouse = "老鼠",
  done = "完成",
  force = "力量",
  pause = "暂停",
  send_message_all = "向所有玩家发送信息",
}
staff_list = {
  morale = "士气",
  tiredness = "疲劳程度",
  skill = "技能",
  total_wages = "工资总额",
}
research = {
  allocated_amount = "已分配量",
  funds_allocation = "资金配置",
  categories = {
    improvements = "改良",
    drugs = "药品研究",
    diagnosis = "诊断仪器",
    cure = "治疗仪器",
    specialisation = "专项",
  },
}
queue_window = {
  num_in_queue = "队伍长度",
  num_entered = "访问者人数",
  max_queue_size = "最大长度",
  num_expected = "预期",
}
staff_class = {
  doctor = "医生",
  handyman = "清洁工",
  receptionist = "接待员",
  nurse = "护士",
  surgeon = "外科医生",
}
tooltip = {
  hire_staff_window = {
    prev_person = "查看前一个人",
    cancel = "取消",
    psychiatrist = "精神病医生",
    salary = "月薪",
    next_person = "查看后一个人",
    nurses = "查看可雇佣的护士",
    surgeon = "外科医生",
    handymen = "查看可雇佣的清洁工人",
    doctors = "查看可雇佣的医生",
    doctor_seniority = "医生资历（实习医生，医生，专家）",
    hire = "雇佣",
    researcher = "科研人员",
    qualifications = "医生的特殊技能",
    receptionists = "查看可雇佣的接待员",
    staff_ability = "员工能力",
  },
  handyman_window = {
    close = "取消请求",
    ability = "能力",
    face = "清洁工的面孔",
    prio_machines = "提高清洁工维修机器的优先级",
    prio_litter = "提高清洁工清除垃圾的优先级",
    happiness = "快乐程度",
    prio_plants = "提高清洁工给植物浇水的优先级",
    name = "清洁工的名字",
    tiredness = "疲劳程度",
    center_view = "切换到当前人物",
    salary = "工资",
    sack = "解雇",
    pick_up = "拾起",
  },
  staff_list = {
    ability_2 = "员工的能力水平",
    next_person = "下一页",
    detail = "细心程度",
    happiness = "显示员工满意程度",
    researcher_train = "已经接受了%d%%的研究技能培训",
    handymen = "查看医院中被雇佣清洁工人名单",
    tiredness = "显示员工疲劳程度",
    researcher = "合格研究人员",
    happiness_2 = "员工士气",
    pay_rise = "提高员工工资10%",
    bonus = "付给该员工10%奖金",
    prev_person = "上一页",
    nurses = "查看医院中被雇佣护士名单",
    psychiatrist = "合格精神病医生",
    salary = "该员工当前工资",
    ability = "显示员工能力水平",
    close = "退出并返回游戏",
    sack = "解雇员工",
    surgeon = "合格外科医生",
    tiredness_2 = "员工的疲劳程度",
    doctors = "查看医院中被雇佣医生名单",
    doctor_seniority = "医生资历",
    view_staff = "查看员工工作情况",
    surgeon_train = "已经接受了%d%%的外科培训",
    skills = "特殊技能",
    receptionists = "查看医院中被雇佣接待员名单",
    psychiatrist_train = "已经接受了%d%%的精神病治疗培训",
  },
  research = {
    cure_inc = "提高科研百分比",
    close = "关闭研究画面",
    specialisation_dec = "降低专门研究百分比",
    diagnosis_dec = "降低科研百分比",
    allocated_amount = "已分配预算",
    improvements_inc = "提高改良研究百分比",
    drugs_dec = "降低药品研究百分比",
    drugs_inc = "提高药品研究百分比",
    cure_dec = "降低疗效研究百分比",
    specialisation_inc = "提高专门研究百分比",
    improvements_dec = "降低改良研究百分比",
    diagnosis_inc = "提高仪器研究百分比",
  },
  machine_window = {
    repair = "呼叫清洁工维修机器",
    name = "名字",
    close = "关闭",
    times_used = "机器被使用次数",
    status = "机器状况",
    replace = "改良机器",
  },
  place_objects_window = {
    confirm = "确认",
    cancel = "取消",
    pick_up = "拾起物品",
    buy_sell = "买/卖物品",
  },
  status = {
    percentage_cured = "您需要治疗%d%%前来就诊的病人。当前您已经治疗了%d%%",
    thirst = "医院中所有人的总体干渴程度",
    close = "关闭总览画面",
    population_chart = "图表显示每个医院对当地居民的吸引程度",
    win_progress_own = "显示当前进展情况",
    reputation = "您的声望必须至少有%d。当前值为%d",
    population = "您至少需要总人口的%d%%来访问您的医院",
    warmth = "医院中所有人的总体温暖程度",
    percentage_killed = "任务要求最多只能杀死%d%%的就诊病人。到目前为止，您已经杀死了%d%%的病人。",
    balance = "您的现金必须至少有$%d。当前值为$%d",
    value = "您的医院价值必须至少有$%d。当前值为$%d",
    win_progress_other = "显示当前%s方面的进展情况",
    num_cured = "您的目标是治愈%d个病人。现在您已经治愈%d个",
    happiness = "医院中所有人的总体快乐程度",
  },
  queue_window = {
    end_of_queue = "拖动一位病人到该按钮处，将使其移动到队尾",
    num_entered = "到目前为止该房间已处理病人数目",
    close = "关闭面板",
    num_in_queue = "排队等候的病人数目",
    num_expected = "即将加入队伍的病人数目",
    front_of_queue = "拖动一位病人到该按钮处，将使其移动到队首",
    dec_queue_size = "减少队伍的最大长度",
    max_queue_size = "接待员允许的最大排队人数",
    inc_queue_size = "增加队伍的最大长度",
    patient = "拖动病人将改变其排队位置。右击某个病人可以选择将其遣送回家或遣送到竞争对手的医院。",
    patient_dropdown = {
      send_home = "让病人离开医院",
      hospital_2 = "将病人送到其它医院",
      reception = "将病人送到接待员处",
      hospital_1 = "将病人送到其它医院",
      hospital_3 = "将病人送到其它医院",
    },
  },
  jukebox = {
    rewind = "向后",
    loop = "循环播放",
    stop = "停止播放",
    close = "关闭音乐盒",
    current_title = "音乐盒",
    play = "播放",
    fast_forward = "向前",
  },
  graphs = {
    deaths = "切换死亡人数",
    close = "关闭图表画面",
    scale = "比例尺",
    money_out = "切换支出",
    visitors = "切换访问人数",
    wages = "切换工资",
    balance = "切换现金",
    money_in = "切换收入",
    cures = "切换治愈人数",
    reputation = "切换医院价值",
  },
  toolbar = {
    reputation = "声望",
    casebook = "治疗手册",
    edit = "编辑房间/物品",
    staff_list = "员工管理",
    policy = "制度",
    date = "日期",
    charts = "图表",
    objects = "设置走廊",
    balance = "现金",
    research = "研究",
    hire = "雇佣员工",
    status = "状态",
    town_map = "城市地图",
    rooms = "建造房屋",
    bank_button = "左击进入银行经理画面，右击进入银行帐户",
  },
  pay_rise_window = {
    accept = "满足要求",
    decline = "拒绝－将其解雇",
  },
  town_map = {
    close = "退出城镇地图画面",
    plants = "切换植物",
    fire_extinguishers = "切换灭火器",
    people = "切换人员",
    balance = "现金",
    heat_dec = "减少供热",
    heating_bill = "供暖费",
    radiators = "切换暖气",
    objects = "切换物品",
    heat_level = "供热强度",
    heat_inc = "增加供热",
  },
  casebook = {
    sent_home = "转走人数",
    cure_requirement = {
      hire_staff_old = "您需要雇佣一名%s来治疗该疾病",
      possible = "您有能力治疗这种疾病",
      not_possible = "您还没有能力治疗该种疾病",
      ward_hire_nurse = "您需要一位护士在病房中照料病人",
      hire_surgeon = "您需要雇佣第二位外科医生来完成手术",
      research_machine = "您需要研究一些仪器来治疗这种疾病",
      build_room = "您需要修建一个房间来治疗这种疾病",
      build_ward = "您需要建造一个病房来治疗该疾病",
      hire_surgeons = "您需要雇佣两名外科医生完成手术",
    },
    increase = "增加",
    up = "向上滚动",
    reputation = "治疗或诊断声望",
    research = "点击这里可以为治疗使用专门研究预算",
    close = "关闭治疗手册",
    earned_money = "总收入",
    cure_type = {
      psychiatrist = "由精神病医生完成治疗工作",
      drug_percentage = "治疗使用药品－其疗效为%d%%",
      drug = "治疗时将使用药品",
      machine = "该疾病需要仪器辅助治疗",
      surgery = "该疾病需要手术",
    },
    decrease = "减少",
    deaths = "死亡人数",
    cured = "治愈人数",
    down = "向下滚动",
    treatment_charge = "花费",
  },
  policy = {
    diag_termination = "对于一个病人的诊断将一直持续到设定的治疗结束百分比，或所有的诊断机器都已经尝试一遍",
    close = "关闭制度画面",
    staff_leave = "点击这里可以让处于空闲状态的员工帮助其他员工",
    diag_procedure = "如果医生的诊断结果为，治愈概率小于设定的遣送回家百分比，则该病人将被自动遣送回家。如果治愈概率大于设定的尝试治疗百分比，则该病人将被自动送去进行治疗",
    staff_rest = "员工休息时的最低疲劳程度",
    staff_stay = "点击这里可以使所有员工停留在设定的房间内",
  },
  bank_manager = {
    graph = "显示%s支付曲线",
    close = "关闭银行经理画面",
    hospital_value = "医院当前价值",
    graph_return = "返回上个画面",
    current_loan = "当前未偿还贷款",
    borrow_5000 = "向银行借款$5000",
    balance = "银行现金",
    interest_payment = "每月利息支付",
    inflation_rate = "年通货膨胀率",
    interest_rate = "年利率",
    repay_5000 = "向银行偿还$5000",
    show_graph = "显示%s支付曲线",
    insurance_owed = "%s欠款的金额",
  },
  main_menu = {
    new_game = "开始新游戏",
    load_game = "载入进度",
    network = "开始网络游戏",
    exit = "不要，不要，请不要退出游戏！",
    quit = "确定要退出游戏吗？",
    continue = "继续游戏最近的游戏",
    load_menu = {
      load_slot = "读取进度",
      empty_slot = "空"
    }
  },
  patient_window = {
    graph = "通过点击可以在健康情况和病史之间切换",
    casebook = "查看有关疾病的详细情况",
    close = "关闭",
    queue = "查看队伍详细资料",
    happiness = "快乐程度",
    warmth = "温暖程度",
    center_view = "切换到当前人物",
    thirst = "干渴程度",
    send_home = "把病人赶出医院",
    abort_diagnosis = "无需诊断直接去治疗",
  },
  watch = {
    emergency = "紧急情况：剩余时间内尽快治愈所有急救病人。",
    hospital_opening = "建造计时器：它主要用来指示距离医院开门的时间多少。直接点击开门按钮就可以立即开门迎接客人。",
    epidemic = "传染病：剩余时间内尽快阻止传染病蔓延。当时间耗尽或一个被传染病人离开医院，则卫生巡查员将出现。通过按钮可以切换预防接种模式开或者关。点击病人就可以让护士为其接种。",
  },
  staff_window = {
    doctor_seniority = "资历－是实习医生，医生还是专家",
    psychiatrist = "精神病",
    close = "关闭",
    ability = "能力",
    pick_up = "拾起",
    sack = "解雇",
    surgeon = "外科",
    happiness = "快乐程度",
    salary = "月薪",
    name = "员工名字",
    tiredness = "疲劳程度",
    center_view = "点击鼠标右键切换人物",
    skills = "特殊技术",
    researcher = "研究",
    face = "面孔－点击进入管理",
  },
  rooms = {
    ultrascan = "医生使用超级扫描仪房间诊断病人",
    research_room = "拥有研究技能的医生可以在研究部门开发新的药品和机器。",
    fracture_clinic = "护士使用骨折诊所治疗骨折病人",
    gps_office = "病人在一般诊断室内接受初始诊断",
    inflation = "医生使用充气机房间治疗头部肿胀病人",
    staffroom = "医生和护士在员工休息室内可以恢复疲劳",
    jelly_vat = "医生使用胶桶诊所治疗失衡患者",
    scanner = "医生使用扫描仪房间诊断病人",
    decontamination = "医生使用净化淋浴装置可以治疗放射病",
    pharmacy = "护士在药房为病人配药治疗",
    cardiogram = "医生使用心电图室诊断病人",
    ward = "病房对于诊断和治疗都是非常有用的。病人手术前要在病房中观察一段时间。病房需要护士",
    training_room = "专家使用培训室对其他医生进行培训",
    operating_theatre = "手术中心需要两名具备外科技能的医生",
    psychiatry = "精神病诊断治疗室可以治疗精神病患者同时也能帮助诊断其他病人，但是需要一位拥有精神病治疗技能的医生",
    hair_restoration = "医生使用毛发恢复房间治疗秃顶病人",
    tongue_clinic = "医生使用舌头松弛诊断室治疗舌头松弛症病人",
    dna_fixer = "医生使用DNA恢复装置房间治疗外星人DNA病人",
    general_diag = "医生使用高级诊断室为患者进行基本诊断。花费很少但效率很高",
    toilets = "建造洗手间可以防止病人把医院弄得一团糟！",
    electrolysis = "医生使用电分解房间治疗多毛症病人",
    x_ray = "医生使用X光房间诊断病人",
    blood_machine = "医生使用血液机器房间诊断病人",
  },
  statement = {
    close = "关闭银行帐户画面",
  },
  buy_objects_window = {
    confirm = "购买物品",
    cancel = "取消",
    increase = "多买一个",
    total_value = "定购物品总值",
    price = "物品价格",
    decrease = "少买一个",
  },
  window_general = {
    confirm = "确定",
    cancel = "取消",
  },
  objects = {
    chair = "椅子：供病人使用，以讨论病情。",
    sofa = "沙发：摆放在员工休息室中，员工如果没有更好的放松方式，则可以坐在上面恢复疲劳。",
    operating_table = "30 OB_OP_TABLE",
    bed2 = "未使用",
    bench = "长椅：为病人提供一个座位，使其可以比较舒适地等待。",
    scanner = "14 OB_SCANNER",
    couch = "18 OB_COUCH",
    blood_machine = "42 OB_BLOOD_MC",
    table1 = "桌子（已删除）：摆放大量杂志，使等待的病人感到快乐。",
    video_game = "视频游戏：让您的员工在游戏中彻底放松。",
    lamp = "灯：照明用。",
    op_sink2 = "34 OB_OP_SINK_2",
    door = "房门：人们出入房间时必需。",
    auto_autopsy = "验尸机：对研究新的治疗方法有很大帮助。",
    reception_desk = "接待台：需要一名接待员为病人服务。",
    hair_restorer = "25 OB_HAIR_RESTORER",
    projector = "37 OB_PROJECTOR",
    crash_trolley = "20 OB_CRASH",
    tv = "电视：使员工不会错过喜爱的节目。",
    ultrascanner = "22 OB_ULTRASCAN",
    surgeon_screen = "35 OB_SURGEON_SCREEN",
    litter_bomb = "垃圾炸弹：来自对手医院的破坏活动",
    inflator = "充气机：治疗头部肿胀病患者。",
    table2 = "12 OB_BTABLE",
    desk = "办公桌：医生可以在上面放置电脑。",
    pool_table = "台球桌：帮助员工放松。",
    x_ray_viewer = "29 OB_XRAY_VIEWER",
    radiation_shield = "28 OB_RAD_SHIELD",
    bed = "床：病情严重的病人需要卧床。",
    swing_door2 = "53 OB_DOUBLE_DOOR2",
    console = "15 OB_SCANNER_CONSOLE",
    op_sink1 = "33 OB_OP_SINK_1",
    bookcase = "书柜：放置医生的参考资料。",
    drinks_machine = "饮料机：为病人止渴，也是收入来源之一。",
    comfortable_chair = "61 OB_COMFY_CHAIR",
    skeleton = "骨骼模型：主要用于培训。",
    computer = "计算机：关键的研究部件。",
    bin = "垃圾桶：放置垃圾。",
    pharmacy_cabinet = "药房：用来保存药品",
    radiator = "暖气：保持医院内的温度。",
    cast_remover = "24 OB_CAST_REMOVE",
    atom_analyser = "化学混合器：摆放在研究部门中，该机器可以加速全部研究进程。",
    plant = "植物：使病人快乐并净化空气。",
    jelly_moulder = "47 OB_JELLY_VAT",
    cardio = "13 OB_CARDIO",
    toilet = "洗手间：提供给病人使用。",
    electrolyser = "46 OB_ELECTRO",
    fire_extinguisher = "灭火器：降低治疗仪器爆炸所产生的危险。",
    bed3 = "未使用",
    swing_door1 = "52 OB_DOUBLE_DOOR1",
    lecture_chair = "演讲座位：接受培训的医生坐在上面，收听无聊的演讲。座位摆放得越多，则教室越大。",
    screen = "16 OB_SCREEN",
    toilet_sink = "洗手池：讲卫生的病人可以在洗手池中洗净脏手。如果没有足够的洗手池，病人将感到不高兴。",
    shower = "54 OB_DECON_SHOWER",
    gates_of_hell = "48 OB_HELL",
    entrance_right = "59 OB_ENT_RDOOR",
    entrance_left = "58 OB_ENT_LDOOR",
    slicer = "26 OB_SLICER",
    dna_fixer = "23 OB_DNA_FIXER",
    x_ray = "27 OB_XRAY",
    cabinet = "文件柜：包含了病人文件，备忘录以及研究档案。",
  },
  build_room_window = {
    cost = "当前被选择房间价格",
    room_classes = {
      treatment = "选择处理类房间",
      diagnosis = "选择诊断类房间",
      facilities = "选择附属类房间",
      clinic = "选择治疗类房间",
    },
    close = "取消并返回游戏",
  },
}
menu_charts = {
  briefing     = "   任务简报",
  casebook     = " (F5) 治疗手册",
  graphs       = " (F8) 图表",
  policy       = " (F9) 制度",
  bank_manager = " (F1) 银行经理",
  statement    = " (F2) 银行账户",
  town_map     = " (F4) 城市地图  ",
  staff_listing= " (F3) 员工列表",
  research     = " (F6) 研究",
  status       = " (F7) 状态",
}
town_map = {
  number = "地区编号",
  not_for_sale = "非拥有的",
  chat = "城镇细节",
  price = "地区售价",
  for_sale = "出售",
  owner = "地区所有",
  area = "地区面积",
}
vip_names = {
  [1] = "伟大的查普顿市长",
  [2] = "南丁格尔",
  [3] = "来自荷兰的伯那德国王",
  [4] = "缅甸民主党领袖：昂山素季",
  [5] = "克朗伯先生",
  [6] = "比利先生",
  [7] = "克劳福议员",
  [8] = "罗尼",
  [9] = "一个超级联赛球星",
  [10] = "拉里普罗斯特",
  health_minister = "卫生部部长",
}
room_descriptions = {
  ultrascan = {
    [1] = "超级扫描仪//",
    [2] = "超级扫描仪是诊断类仪器中最重要的。它虽然花费惊人，但效果卓著，可以使医院对病人的诊断达到完美。//",
    [3] = "超级扫描仪需要医生。它也需要维护。",
  },
  gp = {
    [1] = "一般诊断室//",
    [2] = "这是您的医院中一个基本诊断房间。就诊病人将到这里来检查病因。随后再决定是做进一步的诊断还是立即治疗。如果一间普通诊断室不够用，则您可以再建造另一间。房间越大，则可以在里面摆放更多的特殊物品，从而使医生的威信越高。这对于其它房间也是一样的。//",
    [3] = "一般诊断室需要一名医生。",
  },
  fracture_clinic = {
    [1] = "骨折诊所//",
    [2] = "骨折患者将到这里来接受治疗。石膏剥离装置将使用高能激光将坚硬的石膏切开，而病人只需忍受很小的痛苦。//",
    [3] = "骨折诊所需要一名护士。它也需要日常维护。",
  },
  tv_room = {
    [1] = "电视房间没有使用",
  },
  inflation = {
    [1] = "充气机诊所//",
    [2] = "患有头部肿胀症的病人需要在充气机诊所接受治疗，病人膨胀的头盖骨将被去掉，并对脑袋重新充气到正常大小。//",
    [3] = "充气机诊所需要医生。它也需要清洁工人的维护。",
  },
  jelly_vat = {
    [1] = "胶桶诊所//",
    [2] = "对于患有失衡症的患者需要到胶桶诊所接受治疗，在这里将被放入胶桶中。该治疗方法的原理医学界目前还无法完全理解。//",
    [3] = "胶桶诊所需要医生。它也需要清洁工维护机器。",
  },
  scanner = {
    [1] = "扫描仪//",
    [2] = "通过扫描仪病人得到确诊。随后他们就可以到一般诊断室接受进一步的治疗指示。//",
    [3] = "扫描仪需要医生。它也同样需要维护。",
  },
  blood_machine = {
    [1] = "血液机器//",
    [2] = "血液机器也是一种诊断用仪器，通过它可以检查病人的血液细胞，从而找出病人的病因。//",
    [3] = "血液机器需要医生。它也需要维护。",
  },
  pharmacy = {
    [1] = "药房//",
    [2] = "被诊断且需要接受药物治疗的病人一定要到药房去抓药。当越来越多的药品被研制出来。该房间也将变得越来越繁忙。这时就需要再建造一间药房。//",
    [3] = "药房需要一名护士。",
  },
  cardiogram = {
    [1] = "心电图仪//",
    [2] = "病人在这里被诊断检查，随后再到一般诊断室接受治疗提示。//",
    [3] = "心电图仪需要医生。当然它也需要维护。",
  },
  ward = {
    [1] = "病房//",
    [2] = "病人在病房中停留一段时间，以便护士进行观察。随后再做手术。//",
    [3] = "病房需要一名护士。",
  },
  psych = {
    [1] = "精神病诊断治疗室//",
    [2] = "被诊断为精神有问题的病人必须到精神病诊断治疗室中接受治疗。精神病医生可以对病人进行诊断，发现其病因，且如果确实是心理问题，将使用长沙发椅对其进行治疗。//",
    [3] = "精神病诊断治疗室需要一名具有精神病治疗技能的医生。",
  },
  staff_room = {
    [1] = "员工休息室//",
    [2] = "您的员工感觉疲劳时，需要房间来放松紧张的神经，从而恢复疲劳。处于极度疲劳的员工效率很低，并不时要求加薪，甚至不辞而别。他们还会常常犯错误。建造一个员工休息室，并在里面摆放尽可能多的物品，这是十分值得的。请确认该房间可以同时使多名员工得到休息。",
  },
  operating_theatre = {
    [1] = "手术中心//",
    [2] = "它可以提供非常重要的治疗手段。手术中心必须要有足够的尺寸，必须配置适当的仪器设备。它将是医院中最重要的部门。//",
    [3] = "手术中心需要两名拥有外科技能的医生。",
  },
  training = {
    [1] = "培训室//",
    [2] = "您的实习医生和医生在该房间内可以得到特殊技能的培训。拥有外科，研究或精神病技能的专家将把自己的经验传授给接受培训的医生。对于已拥有这些技能的医生，他们的能力将大幅提高。//",
    [3] = "培训室需要一名专家。",
  },
  dna_fixer = {
    [1] = "DNA诊所//",
    [2] = "这些有外星人DNA的病人必须在这里恢复其原有的DNA。DNA修复装置是最复杂的仪器，因此一定要在其房间内摆放一个灭火器，以防万一。//",
    [3] = "这台DNA修复装置需要清洁工不时维护。它也需要一名具有研究能力的医生才能够正常工作。",
  },
  research = {
    [1] = "研究室//",
    [2] = "在研究室可以研制新的药品和治疗方法，并对各种仪器进行改进提高。这是医院中的一个重要部门，并对提高医院的治愈率产生绝对影响。//",
    [3] = "研究室需要一名拥有研究技能的医生。",
  },
  hair_restoration = {
    [1] = "毛发恢复诊所//",
    [2] = "对于身患秃顶的病人将被送到该毛发恢复诊所，使用其中的毛发恢复装置进行治疗。需要一名医生操作机器，且该机器将很快地使病人的脑袋长满头发。//",
    [3] = "毛发恢复诊所需要医生。它也需要维护。",
  },
  general_diag = {
    [1] = "高级诊断室//",
    [2] = "需要进一步诊断的病人将被送到这里。如果一般诊断室无法发现病人的病因，高级诊断室将有可能找出。诊断结束后，他们将返回一般诊断室分析结果。//",
    [3] = "高级诊断室需要医生。",
  },
  electrolysis = {
    [1] = "电分解房间//",
    [2] = "多毛症患者将到该房间接受电分解机器的治疗，该机器将猛拉毛发并使用一种混合物填充毛孔。//",
    [3] = "电分解房间需要医生。它也需要清洁工进行维护。",
  },
  slack_tongue = {
    [1] = "舌头松弛治疗诊所//",
    [2] = "在普通诊断室中被诊断为舌头松弛的病人将被送到该诊所接受治疗。医生将使用一种高科技的仪器使舌头伸直并切掉多余部分，从而使病人恢复正常。//",
    [3] = "舌头松弛诊所需要医生。它也需要日常维护。",
  },
  toilets = {
    [1] = "洗手间//",
    [2] = "当病人感到需要上厕所时就需要洗手间这类设施。如果您希望洗手间多一些访问者，可以在其中多摆放洗手池和马桶请考虑在医院的其它位置也建造一些附属设施。",
  },
  no_room = {
    [1] = "",
  },
  x_ray = {
    [1] = "X光机//",
    [2] = "X光机可以使用特殊辐射为病人照内部透视照片。它对于医生诊断病因有很大帮助。//",
    [3] = "X光机需要医生。它也需要维护。",
  },
  decontamination = {
    [1] = "净化诊所//",
    [2] = "对于被暴露在强放射性的病人需要快速送到净化诊所。该房间包含了一个淋浴器，可以将病人身上的放射能清除干净。//",
    [3] = "净化淋浴器需要医生。它也需要清洁工人维护。",
  },
}
bank_manager = {
  current_loan = "当前贷款",
  balance = "现金",
  interest_payment = "应付利息",
  hospital_value = "医院价值",
  interest_rate = "利率",
  insurance_owed = "保险公司欠款",
  statistics_page = {
    balance = "现金",
    details = "细节",
    date = "日期",
    current_balance = "当前现金",
    money_in = "收入",
    money_out = "支出",
  },
  inflation_rate = "通货膨胀率",
}
menu_display = {
  high_res = " 阴影 ",
}
original_credits = {
  [1] = "",
  [2] = "",
  [3] = "",
  [4] = "",
  [5] = "",
  [6] = "",
  [7] = "",
  [8] = "",
  [9] = "",
  [10] = "",
  [11] = "",
  [12] = ":设计制作",
  [13] = ":牛蛙制造",
  [14] = "",
  [15] = ":冥王星开发组",
  [16] = ",",
  [17] = "Mark Webley",
  [18] = "Gary Carr",
  [19] = "Matt Chilton",
  [20] = "Matt Sullivan",
  [21] = "Jo Rider",
  [22] = "Rajan Tande",
  [23] = "Wayne Imlach",
  [24] = "Andy Bass",
  [25] = "Jon Rennie",
  [26] = "Adam Coglan",
  [27] = "Natalie White",
  [28] = "",
  [29] = "",
  [30] = "",
  [31] = ":编程",
  [32] = ",",
  [33] = "Mark Webley",
  [34] = "Matt Chilton",
  [35] = "Matt Sullivan",
  [36] = "Rajan Tande",
  [37] = "",
  [38] = "",
  [39] = "",
  [40] = ":美工",
  [41] = ",",
  [42] = "Gary Carr",
  [43] = "Jo Rider",
  [44] = "Andy Bass",
  [45] = "Adam Coglan",
  [46] = "",
  [47] = "",
  [48] = "",
  [49] = ":助理编程",
  [50] = ",",
  [51] = "Ben Deane",
  [52] = "Gary Morgan",
  [53] = "Jonty Barnes",
  [54] = "",
  [55] = "",
  [56] = "",
  [57] = ":助理美工",
  [58] = ",",
  [59] = "Eoin Rogan",
  [60] = "George Svarovsky",
  [61] = "Saurev Sarkar",
  [62] = "Jason Brown",
  [63] = "John Kershaw",
  [64] = "Dee Lee",
  [65] = "",
  [66] = "",
  [67] = "",
  [68] = ":游戏介绍",
  [69] = ",",
  [70] = "Stuart Black",
  [71] = "",
  [72] = "",
  [73] = "",
  [74] = ":音乐音效",
  [75] = ",",
  [76] = "Russell Shaw",
  [77] = "Adrian Moore",
  [78] = "",
  [79] = "",
  [80] = "",
  [81] = ":助理音乐",
  [82] = ",",
  [83] = "Jeremy Longley",
  [84] = "Andy Wood",
  [85] = "",
  [86] = "",
  [87] = "",
  [88] = ":配音",
  [89] = ",",
  [90] = "Rebecca Green",
  [91] = "",
  [92] = "",
  [93] = "",
  [94] = ":任务设计",
  [95] = ",",
  [96] = "Wayne Imlach",
  [97] = "Natalie White",
  [98] = "Steven Jarrett",
  [99] = "Shin Kanaoya",
  [100] = "",
  [101] = "",
  [102] = "",
  [103] = ":剧本",
  [104] = ",",
  [105] = "James Leach",
  [106] = "Sean Masterson",
  [107] = "Neil Cook",
  [108] = "",
  [109] = "",
  [110] = "",
  [111] = ":R&D",
  [112] = "",
  [113] = ":图形引擎",
  [114] = ",",
  [115] = "Andy Cakebread",
  [116] = "Richard Reed",
  [117] = "",
  [118] = "",
  [119] = "",
  [120] = ":R&D支持",
  [121] = ",",
  [122] = "Glenn Corpes",
  [123] = "Martin Bell",
  [124] = "Ian Shaw",
  [125] = "Jan Svarovsky",
  [126] = "",
  [127] = "",
  [128] = "",
  [129] = ":库和工具",
  [130] = "",
  [131] = "Dos和Win95库",
  [132] = ",",
  [133] = "Mark Huntley",
  [134] = "Alex Peters",
  [135] = "Rik Heywood",
  [136] = "",
  [137] = "",
  [138] = "",
  [139] = ":网络库",
  [140] = ",",
  [141] = "Ian Shippen",
  [142] = "Mark Lamport",
  [143] = "",
  [144] = "",
  [145] = "",
  [146] = ":声音库",
  [147] = ",",
  [148] = "Russell Shaw",
  [149] = "Tony Cox",
  [150] = "",
  [151] = "",
  [152] = "",
  [153] = ":安装程序",
  [154] = ",",
  [155] = "Andy Nuttall",
  [156] = "Tony Cox",
  [157] = "Andy Cakebread",
  [158] = "",
  [159] = "",
  [160] = "",
  [161] = ":支持",
  [162] = ",",
  [163] = "Peter Molyneux",
  [164] = "",
  [165] = "",
  [166] = "",
  [167] = ":测试经理",
  [168] = ",",
  [169] = "Andy Robson",
  [170] = "",
  [171] = "",
  [172] = "",
  [173] = ":测试主管",
  [174] = ",",
  [175] = "Wayne Imlach",
  [176] = "Jon Rennie",
  [177] = "",
  [178] = "",
  [179] = "",
  [180] = ":测试",
  [181] = ",",
  [182] = "Jeff Brutus",
  [183] = "Wayne Frost",
  [184] = "Steven Lawrie",
  [185] = "Tristan Paramor",
  [186] = "Nathan Smethurst",
  [187] = "",
  [188] = "Ryan Corkery",
  [189] = "Simon Doherty",
  [190] = "James Dormer",
  [191] = "Martin Gregory",
  [192] = "Ben Lawley",
  [193] = "Joel Lewis",
  [194] = "David Lowe",
  [195] = "Robert Monczak",
  [196] = "Dominic Mortoza",
  [197] = "Karl O'Keeffe",
  [198] = "Michael Singletary",
  [199] = "Andrew Skipper",
  [200] = "Stuart Stephen",
  [201] = "David Wallington",
  [202] = "",
  [203] = "And all our other Work Experience Play Testers",
  [204] = "",
  [205] = "",
  [206] = "",
  [207] = ":技术支持",
  [208] = ",",
  [209] = "Kevin Donkin",
  [210] = "Mike Burnham",
  [211] = "Simon Handby",
  [212] = "",
  [213] = "",
  [214] = "",
  [215] = ":市场",
  [216] = ",",
  [217] = "Pete Murphy",
  [218] = "Sean Ratcliffe",
  [219] = "",
  [220] = "",
  [221] = "",
  [222] = ":特别感谢",
  [223] = ",",
  [224] = "Tamara Burke",
  [225] = "Annabel Roose",
  [226] = "Chris Morgan",
  [227] = "Pete Larsen",
  [228] = "",
  [229] = "",
  [230] = "",
  [231] = ":公关",
  [232] = ",",
  [233] = "Cathy Campos",
  [234] = "",
  [235] = "",
  [236] = "",
  [237] = ":文档",
  [238] = ",",
  [239] = "Mark Casey",
  [240] = "Richard Johnston",
  [241] = "James Lenoel",
  [242] = "Jon Rennie",
  [243] = "",
  [244] = "",
  [245] = "",
  [246] = ":文档及包装盒设计",
  [247] = ",",
  [248] = "Caroline Arthur",
  [249] = "James Nolan",
  [250] = "",
  [251] = "",
  [252] = "",
  [253] = ":本地化项目经理",
  [254] = ",",
  [255] = "Carol Aggett",
  [256] = "",
  [257] = "",
  [258] = "",
  [259] = ":本地化工作",
  [260] = ",",
  [261] = "Sandra Picaper",
  [262] = "Sonia 'Sam' Yazmadjian",
  [263] = "",
  [264] = "Bettina Klos",
  [265] = "Alexa Kortsch",
  [266] = "Bianca Normann",
  [267] = "",
  [268] = "C。T。O。S。p。A。ZolaPredosa(BO)",
  [269] = "Gian Maria Battistini",
  [270] = "Maria Ziino",
  [271] = "Gabriele Vegetti",
  [272] = "",
  [273] = "Elena Ruiz de Velasco",
  [274] = "Julio Valladares",
  [275] = "Ricardo Mart*nez",
  [276] = "",
  [277] = "Kia Collin",
  [278] = "CBG Consult",
  [279] = "Ulf Thor",
  [280] = "",
  [281] = "",
  [282] = "",
  [283] = ":生产",
  [284] = ",",
  [285] = "Rachel Holman",
  [286] = "",
  [287] = "",
  [288] = "",
  [289] = ":制片人",
  [290] = ",",
  [291] = "Mark Webley",
  [292] = "",
  [293] = "",
  [294] = "",
  [295] = ":联合制片人",
  [296] = ",",
  [297] = "Andy Nuttall",
  [298] = "",
  [299] = "",
  [300] = "",
  [301] = ":运作",
  [302] = ",",
  [303] = "Steve Fitton",
  [304] = "",
  [305] = "",
  [306] = "",
  [307] = ":行政",
  [308] = ",",
  [309] = "Audrey Adams",
  [310] = "Annette Dabb",
  [311] = "Emma Gibbs",
  [312] = "Lucia Gobbo",
  [313] = "Jo Goodwin",
  [314] = "Sian Jones",
  [315] = "Kathy McEntee",
  [316] = "Louise Ratcliffe",
  [317] = " ",
  [318] = " ",
  [319] = " ",
  [320] = ":公司管理",
  [321] = ",",
  [322] = "Les Edgar",
  [323] = "Peter Molyneux",
  [324] = "David Byrne",
  [325] = " ",
  [326] = " ",
  [327] = ":All at Bullfrog Productions",
  [328] = " ",
  [329] = " ",
  [330] = " ",
  [331] = ":特别感谢",
  [332] = ",",
  [333] = "弗莱利公园医院中每个人",
  [334] = "",
  [335] = ":特别是",
  [336] = ",",
  [337] = "Beverley Cannell",
  [338] = "Doug Carlisle",
  [339] = "",
  [340] = "",
  [341] = "",
  [342] = ":中文版制作",
  [343] = ",",
  [344] = "飞龙工作室",
  [345] = "",
  [346] = "",
  [347] = "",
  [348] = ":监制/项目主管",
  [349] = ",",
  [350] = "曲洋",
  [351] = "",
  [352] = "",
  [353] = ":翻译：刘波",
  [354] = "",
  [355] = ":录音师：蓝信刚",
  [356] = "",
  [357] = "",
  [358] = ":配音：夏莉莉",
  [359] = "",
  [360] = "",
  [361] = "",
  [362] = ":中文版包装/手册设计",
  [363] = ",",
  [364] = "骆智中 王越鹏",
  [365] = "",
  [366] = "",
  [367] = ":生产",
  [368] = ",",
  [369] = "杨平 张威",
  [370] = "",
  [371] = "",
  [372] = "",
  [373] = ":测试",
  [374] = ",",
  [375] = "罗耀 陈雷 赫闻 汤宇力",
  [376] = "",
  [377] = "",
  [378] = ":特别感谢",
  [379] = ",",
  [380] = "Les Edgar",
  [381] = "Rajan Tande",
  [382] = "Steve Fitton",
  [383] = "",
  [384] = "",
  [385] = "",
  [386] = "",
  [387] = "",
  [388] = "",
  [389] = "",
  [390] = "",
  [391] = "",
  [392] = "",
  [393] = "",
  [394] = "",
  [395] = "",
  [396] = "",
  [397] = ".",
}
pay_rise = {
  definite_quit = "不论您做什么都无法留住我了。",
  regular = {
    [1] = "我真的太累了。如果您不希望我辞职的话，请让我好好休息，并增加工资$%d。",
    [2] = "我真的太累了。我需要休息，以及增加工资$%d。立即答应，你这个暴君。",
    [3] = "好吧。我在这里工作就象一只狗一样。给我奖金$%d我就还留在这个医院里。",
    [4] = "我很不快乐。我要求增加工资$%d，使我的工资达到$%d，否则我就不干了。",
    [5] = "我的父母告诉我医学专家的待遇是很高的。因此，请给我加薪$%d，否则我将辞职去做电脑游戏。",
    [6] = "我已经受够了。请调整我的工资到合理程度。我希望加薪$%d。",
  },
  poached = "%s答应给我工资%d。如果您无法达到这个数目，那么我就要跳槽了。",
}
menu_debug = {
  porter_pagers = " PORTER PAGERS        ",
  object_cells = " OBJECT CELLS         ",
  display_pager = " DISPLAY PAGER        ",
  display_big_cells = " DISPLAY BIG CELLS    ",
  mapwho_checking = " MAPWHO CHECKING      ",
  keep_clear_cells = " KEEP CLEAR CELLS     ",
  machine_pagers = " MACHINE PAGERS       ",
  remove_walls = " REMOVE WALLS         ",
  enter_nav_debug = " ENTER NAV DEBUG      ",
  lose_game_anim = {
    [1] = " LOSE GAME 1 ANIM     ",
    [2] = " LOSE GAME 2 ANIM     ",
    [3] = " LOSE GAME 3 ANIM     ",
    [4] = " LOSE GAME 4 ANIM     ",
    [5] = " LOSE GAME 5 ANIM     ",
    [6] = " LOSE GAME 6 ANIM     ",
    [7] = " LOSE GAME 7 ANIM     ",
  },
  show_nav_cells = " SHOW NAV CELLS       ",
  win_game_anim = " WIN GAME ANIM        ",
  display_room_status = " DISPLAY ROOM STATUS  ",
  remove_objects = " REMOVE OBJECTS       ",
  nav_bits = " NAV BITS             ",
  win_level_anim = " WIN LEVEL ANIM       ",
  pixbuf_cells = " PIXBUF CELLS         ",
  show_help_hotspot = " SHOW HELP HOTSPOTS   ",
  entry_cells = " ENTRY CELLS          ",
  plant_pagers = " PLANT PAGERS         ",
}
progress_report = {
  quite_unhappy = "人们有点不高兴。",
  header = "进展报告",
  very_unhappy = "人们感到非常不高兴。",
  more_drinks_machines = "多摆放一些饮料机。",
  too_cold = "太冷了。多摆放一些暖气。",
  too_hot = "调节供热系统。太热了。",
  percentage_pop = "% 人口",
  win_criteria = "视窗标准",
}
menu_options = {
  game_speed = "    游戏速度",
  sound_vol = "    音效音量",
  music_vol = "    音乐音量",
  announcements = "    语音",
  sound = "    音效",
  announcements_vol = "    语音音量",
  music = "    音乐",
  autosave = "    自动存盘",
  jukebox = "    音乐盒",
}
menu_options_game_speed = {
  normal = "    正常",
  slower = "    较慢",
  max_speed = "    快速",
  slowest = "    非常慢",
  and_then_some_more = "    极快",
}
rooms_short = {
  ultrascan = "超级扫描仪",
  research_room = "研究部门",
  fracture_clinic = "骨折诊所",
  gps_office = "一般诊断室",
  destroyed = "已毁坏",
  staffroom = "员工休息室",
  jelly_vat = "胶桶诊所",
  scanner = "扫描仪",
  decontamination = "净化设备",
  pharmacy = "药房",
  cardiogram = "心电图仪",
  reception = "接待台",
  training_room = "培训室",
  corridor_objects = "走廊物品",
  operating_theatre = "手术中心",
  dna_fixer = "DNA修复装置",
  ward = "病房",
  psychiatric = "精神病诊疗室",
  hair_restoration = "毛发恢复机器",
  general_diag = "高级诊断室",
  inflation = "充气机",
  tongue_clinic = "舌头治疗机",
  toilets = "洗手间",
  electrolysis = "电分解诊所",
  x_ray = "X光仪器",
  blood_machine = "血液机器",
}
level_names = {
  [1] = "毒气城",
  [2] = "昏睡城",
  [3] = "大柴斯特城",
  [4] = "福来明顿城",
  [5] = "新普顿城",
  [6] = "世界之疮",
  [7] = "绿池城",
  [8] = "曼葵城",
  [9] = "依斯特威尔",
  [10] = "爱格森海姆城",
  [11] = "蛙鸣城",
  [12] = "巴登堡",
  [13] = "查姆雷城",
  [14] = "小爪槟城",
  [15] = "葬礼城",
}
insurance_companies = {
  [1] = "天鹅绒有限公司",
  [2] = "诺福克洋葱公司",
  [3] = "双峰公司",
  [4] = "刀疤有限公司",
  [5] = "潜水艇有限公司",
  [6] = "诚实的泰瑞公司",
  [7] = "矮胖先生股份有限公司",
  [8] = "里昂猫公司",
  [9] = "普里邦有限公司",
  [10] = "快乐保险公司",
  [11] = "辛迪加保险公司",
  out_of_business = "无",
}
staff_descriptions = {
  good = {
    [1] = "手脚勤快并努力的员工。",
    [2] = "很有责任心。非常细心。",
    [3] = "掌握了很多技术。",
    [4] = "很友善并爱笑。",
    [5] = "富有活力。",
    [6] = "很有礼貌并和蔼可亲。",
    [7] = "富有才干和能力。",
    [8] = "工作能力极强。",
    [9] = "意志坚强。",
    [10] = "微笑着为病人服务。",
    [11] = "迷人的，有礼貌的并爱帮助别人。",
    [12] = "专注于工作。",
    [13] = "本性善良，工作努力。",
    [14] = "忠实且待人友善。",
    [15] = "细心并能够独立处理紧急事件。",
  },
  misc = {
    [1] = "打高尔夫球。",
    [2] = "潜水运动。",
    [3] = "冰雕。",
    [4] = "喝葡萄酒。",
    [5] = "拉力车赛。",
    [6] = "蹦跳。",
    [7] = "收集啤酒盖子。",
    [8] = "喜欢跳水。",
    [9] = "喜欢冲浪运动。",
    [10] = "喜欢游泳。",
    [11] = "蒸馏威士忌酒。",
    [12] = "DIY专家。",
    [13] = "喜欢欣赏法国电影。",
    [14] = "玩地下城守护者游戏。",
    [15] = "拥有HGV执照。",
    [16] = "摩托车比赛。",
    [17] = "弹奏古典提琴。",
    [18] = "训练营救员。",
    [19] = "喜欢养狗。",
    [20] = "听收音机。",
    [21] = "经常洗澡。",
    [22] = "工作指导。",
    [23] = "种植蔬菜。",
    [24] = "义务巡警。",
    [25] = "展览。",
    [26] = "收集二战武器。",
    [27] = "重新摆放家具。",
    [28] = "听刺激音乐。",
    [29] = "杀虫。",
    [30] = "喜剧演员。",
    [31] = "议会调查人员。",
    [32] = "园艺家。",
    [33] = "走私假手表。",
    [34] = "唱歌。",
    [35] = "喜欢日间电视。",
    [36] = "喜欢鲑鱼。",
    [37] = "向观光者介绍博物馆。",
  },
  bad = {
    [1] = "动作缓慢，且爱烦恼。",
    [2] = "懒惰。",
    [3] = "培训很少且没有精神。",
    [4] = "待人粗鲁。",
    [5] = "态度恶劣。",
    [6] = "耳聋。且身上有一股卷心菜的味道。",
    [7] = "不用心工作。",
    [8] = "鲁莽而且容易犯错误。",
    [9] = "容易犯错误。",
    [10] = "心理变态。",
    [11] = "粗心大意。",
    [12] = "懒散。",
    [13] = "愚蠢。",
    [14] = "狡猾且有破坏欲。",
    [15] = "傲慢自大。",
  },
}
room_classes = {
  diagnosis = "诊断室",
  clinics = "诊所",
  facilities = "附属设施",
  treatment = "治疗室",
}
place_objects_window = {
  pick_up_object = "点击物品可以将其拾起，也可以选择不同的选项",
  place_objects_in_corridor = "将物品放在走廊上",
  place_windows = "请设置一些窗户，点击鼠标表示确定",
  confirm_or_buy_objects = "您可以确认该房间，或买入或移动其中的一些物品",
  drag_blueprint = "拉伸蓝图直到您满意的尺寸",
  place_door = "设置房门",
  place_objects = "可以设置并移动这些物品直到满意为止，随后再确定",
}
newspaper = {
  [1] = {
    [1] = "医生震惊四座",
    [2] = "这医生扮演玩弄上帝",
    [3] = "科学狂人的震撼",
    [4] = "实验室地板上摆放着什么？",
    [5] = "查获一项危险的研究",
  },
  [2] = {
    [1] = "酗酒",
    [2] = "外科医生醉酒",
    [3] = "挑剔的顾问",
    [4] = "外科医生的酒量",
    [5] = "外科医生痛饮失态",
    [6] = "外科医生的灵魂",
  },
  [3] = {
    [1] = "粗鲁的医生",
    [2] = "医生臭名远扬",
    [3] = "医生完了",
    [4] = "贪得无厌的医生",
  },
  [4] = {
    [1] = "篡改数据",
    [2] = "器官买卖犯罪",
    [3] = "银行危机",
    [4] = "调查基金数据",
  },
  [5] = {
    [1] = "医学工作者盗墓",
    [2] = "医生盗墓",
    [3] = "医生盗墓，人赃并获",
    [4] = "医生死期不远了",
    [5] = "超级渎职",
    [6] = "医生盗墓",
  },
  [6] = {
    [1] = "医生？庸医！",
    [2] = "庸医露馅了",
    [3] = "令人诅咒的诊断",
    [4] = "笨蛋专家",
  },
  [7] = {
    [1] = "医生真情放纵",
    [2] = "医生自我“手术”",
    [3] = "医生完了",
    [4] = "医生大丑闻",
    [5] = "医生搞得一团糟",
  },
}
staff_title = {
  junior = "实习医生",
  psychiatrist = "精神病医生",
  consultant = "专家",
  surgeon = "外科医生",
  doctor = "医生",
  researcher = "研究员",
  nurse = "护士",
  receptionist = "接待员",
  general = "普通人",
}
graphs = {
  deaths = "死亡",
  money_in = "收入",
  money_out = "支出",
  visitors = "访问者",
  wages = "工资",
  balance = "现金",
  time_spans = {
    [1] = "1 年",
    [2] = "12 年",
    [3] = "48 年",
  },
  cures = "治愈",
  reputation = "声望",
}
adviser = {
  tutorial = {
    hire_receptionist = "您也需要一位接待员来接待病人。",
    build_pharmacy = "恭喜！现在应建造一个药房并雇佣一位护士，使医院正常运转。",
    hire_doctor = "您需要一个医生来诊断和治疗病人。",
    place_receptionist = "移动接待员并将她放到任意位置。她将很聪明地自己走到接待台。",
    place_windows = "设置窗户的方法与设置房门的方法相同。您可以不需要窗户，但是当您的员工可以从窗户向外张望时，他们将感到快乐。",
    confirm_room = "左键单击闪动光标就可以开业了，也可以通过点击交叉按钮返回上一步。",
    rotate_and_place_reception = "点击鼠标右键可以旋转桌子，并用鼠标左键将其放在医院中合适位置。",
    build_reception = "你好。首先，您的医院需要一个接待台，您可以从布置走廊菜单中选取。",
    doctor_in_invalid_position = "嗨！您不能将医生放在那里。",
    start_tutorial = "阅读任务简报，随后点击鼠标左键就可以启动教程。",
    receptionist_invalid_position = "您不能将接待员放在那里。",
    room_too_small_and_invalid = "蓝图尺寸太小了且处于非法位置。",
    window_in_invalid_position = "该窗口处于非法位置。请尝试蓝图墙壁上的其它位置。",
    choose_doctor = "在选择医生之前，应重点考虑其能力。",
    information_window = "帮助条将告诉您刚刚建造的一般诊断室信息。",
    build_gps_office = "您必须建造一般诊断室才可以诊断病人。",
    select_doctors = "点击闪动的光标挑选可被雇佣的医生。",
    select_diagnosis_rooms = "点击闪动的光标将弹出诊断类房间列表。",
    select_receptionists = "使用鼠标左键单击闪动的光标来查看当前可选择的接待员。光标下方的数字表示共有多少个接待员可供选择。",
    order_one_reception = "使用鼠标左键单击闪动的光标，可以定购一个接待台。",
    choose_receptionist = "判断哪一个接待员拥有好的能力与合适的工资，再左键单击闪动的光标来雇佣她。",
    prev_receptionist = "左键单击闪动的光标将可以浏览到前一个可供选择的接待员。",
    accept_purchase = "点击闪动的光标表示购买。",
    place_door = "沿着蓝图墙壁移动鼠标，寻找放置房门的合适位置。",
    click_and_drag_to_build = "建造一般诊断室时应先决定具体的尺寸。点击并按住鼠标左键可以设置房间尺寸。",
    room_in_invalid_position = "该蓝图是非法的，红色区域表示蓝图与其它房间或墙壁重叠。",
    place_objects = "右击可以旋转房屋中的各种物品，再左击表示确认。",
    room_too_small = "该房间的蓝图为红色是因为其尺寸太小了。通过拖动使其尺寸增大。",
    click_gps_office = "点击闪动光标表示选择一般诊断室。",
    reception_invalid_position = "如果接待台是灰色的，则表示当前位置是非法的。应尝试移动或旋转它。",
    next_receptionist = "这是接待员列表中的第一个。左键单击闪动的光标可以浏览下一个可供选用的接待员。",
    room_big_enough = "蓝图尺寸已经足够大了。当您松开鼠标按键表示确认。如果需要的话，以后还可以根据需要移动或改变其尺寸。",
    object_in_invalid_position = "该物品当前位置非法。请要么将其放到其它位置，要么对其进行旋转。",
    door_in_invalid_position = "房门设置位置非法。请尝试蓝图墙壁上的其它位置。",
    place_doctor = "将医生放在医院中的任意位置。他将直奔一般诊断室，为病人诊断。",
  },
  epidemic = {
    hurry_up = "如果无法立即控制传染病那么您的医院将出大乱子。加油！",
    serious_warning = "传染病疫情越来越严重。您必须立即行动！",
    multiple_epidemies = "看来医院里同时有不只一种传染病。这将是一场空前灾难，加油！",
  },
  staff_advice = {
    need_handyman_machines = "如果希望维护医院内的各种医疗机器，则需要雇佣清洁工人。",
    need_doctors = "您需要更多的医生。请将最得力的医生放在排队等候人数最多的房间内。",
    need_handyman_plants = "您需要雇佣一位清洁工人来为植物浇水。",
    need_handyman_litter = "医院中出现了垃圾。请雇佣一个清洁工人打扫垃圾。",
    need_nurses = "您需要雇佣更多的护士。病房和药房都需要护士。",
    too_many_doctors = "您雇佣的医生太多了。其中有一些人当前正闲着。",
    too_many_nurses = "我认为您现在雇佣了太多的护士。",
  },
  earthquake = {
    damage = "地震损坏了医院中%d台机器，并使%d个人受伤。",
    alert = "地震警报。在地震过程中，医院中的机器将受损。如果它们没有得到及时维护将彻底毁坏。",
    ended = "我认为这是一个大家伙－按照里氏标准为%d。",
  },
  multiplayer = {
    objective_completed = "您已经完成任务了。恭喜！",
    everyone_failed = "每个人都没有完成最终目标。因此每个人都要继续努力！",
    players_failed = "下面的玩家没有完成最终目标：",
    poaching = {
      in_progress = "我将让您了解这个人是否愿意为您工作。",
      not_interested = "哈哈！他们对为您工作不感兴趣－他们希望找寻自我价值。",
      already_poached_by_someone = "没门！有人想要挖走这个人。",
    },
    objective_failed = "任务失败。",
  },
  surgery_requirements = {
    need_surgeons_ward_op = "您需要雇佣两位外科医生，并修建一个病房和手术中心，这样才可以完成外科手术。",
    need_surgeon_ward = "为了完成外科手术，您还需要雇佣一名外科医生，以及修建一个病房。",
  },
  vomit_wave = {
    started = "请赶快处理医院中的呕吐物，否则呕吐现象会四处传播。也许您需要多雇佣几个清洁工人。",
    ended = "嗨！呕吐现象已被控制。今后一定要保持医院的清洁。",
  },
  level_progress = {
    halfway_lost = "您距离失败还差一半。",
    dont_kill_more_patients = "您实际上无力支付太多的医疗事故赔款！",
    another_patient_killed = "哦，不！您已经杀死了一个病人。这已经是第%d个了。",
    halfway_won = "您距离胜利还差一半。",
    close_to_win_increase_value = "您距离胜利只有一步之遥了。再增加医院价值%d。",
    financial_criteria_met = "您已经完成了本任务要求达到的财政目标。现在请保持现金在%d以上，使我们确信您的医院运行良好。",
    nearly_won = "您已经距离胜利非常接近了。",
    hospital_value_enough = "保持医院价值在%d以上，并解决好其它问题，就能胜利完成任务了。",
    another_patient_cured = "干得好－治愈了一个病人。收入$%d。",
    three_quarters_lost = "您距离失败还差四分之三。",
    reputation_good_enough = "好的，您的声望已经达到任务要求了。保持在%d以上，并解决好其它方面的问题。",
    cured_enough_patients = "您已经治愈了足够多的病人，但是您只有达到更高的标准才能胜利完成任务。",
    nearly_lost = "您距离失败只有一步之遥了。",
    improve_reputation = "您需要提高声望%d，这样才能有机会完成任务。",
    three_quarters_won = "您距离胜利还差四分之三。",
  },
  staff_place_advice = {
    receptionists_only_at_desk = "接待员只能在接待台工作。",
    only_psychiatrists = "只有具有精神病治疗技能的医生才可以在精神病诊断治疗室中工作。",
    only_surgeons = "只有拥有外科技能的医生才可以在手术中心工作。",
    only_nurses_in_room = "只有护士可以在%s中工作",
    only_doctors_in_room = "只有医生可以在%s中工作",
    only_researchers = "只有拥有研究技能的医生才可以在研究部门工作。",
    nurses_cannot_work_in_room = "护士无法在%s中工作",
    doctors_cannot_work_in_room = "医生无法在%s中工作",
  },
  research = {
    machine_improved = "%s的疗效被您的研究部门增强了。",
    autopsy_discovered_rep_loss = "您的自动验尸机已经研制成功。对公众将产生副作用。",
    drug_fully_researched = "您已经研究%s到达100%%了。",
    new_machine_researched = "一个新的%s刚刚被成功研究出来。",
    drug_improved = "治疗%s的药品被您的研究部门改良了。",
    new_available = "一种新的%s可以使用了。",
    new_drug_researched = "治疗%s的一种新药被研究成功。",
  },
  boiler_issue = {
    minimum_heat = "噢，终于找到您了。锅炉坏了。也就是说医院里的人将感到有点冷。",
    maximum_heat = "锅炉快失控了。暖气的供暖能力已经达到极限了。医院里的人都快被熔化了！多设置一些饮料机。",
    resolved = "好消息。锅炉和暖气现在工作正常。气温很快就可以恢复到正常水平。",
  },
  competitors = {
    staff_poached = "您的一位员工被其它医院挖走了。",
    hospital_opened = "竞争对手%s的医院在本区域内已经开张了。",
    land_purchased = "%s已经购买了一些土地。",
  },
  room_requirements = {
    research_room_need_researcher = "您需要为研究室雇佣一个拥有研究技巧的医生。",
    op_need_another_surgeon = "您至少还需要为手术中心雇佣一名外科医生。",
    op_need_ward = "您必须为外科手术前的患者建造病房。",
    reception_need_receptionist = "您必须为病人雇佣一位接待员。",
    psychiatry_need_psychiatrist = "您需要雇佣一位精神病医生，现在您已经建成了一个精神病诊断治疗室。",
    pharmacy_need_nurse = "您应该为药房雇佣一位护士。",
    ward_need_nurse = "您需要为病房雇佣一名护士。",
    op_need_two_surgeons = "请为手术中心雇佣两名外科医生完成手术。",
    training_room_need_consultant = "您应该为培训室雇佣一位专家，负责讲演。",
    gps_office_need_doctor = "您需要为一般诊断室雇佣一名医生。",
  },
  goals = {
    win = {
      money = "您还需要%d才能完成本关中的财政指标。",
      cure = "再治愈%d个病人您就可以满足本关任务的要求了。",
      reputation = "提高声望%d将达到胜利完成本任务的要求",
      value = "您需要增加医院收入到$%d",
    },
    lose = {
      kill = "再杀死%d个病人将导致本任务失败！",
    },
  },
  warnings = {
    charges_too_low = "治疗费用太低了。它将使更多的病人到医院就诊，但您无法从每个病人身上获取太多的利润。",
    charges_too_high = "治疗费用太高了。短期内它将产生很好的效益，但最终会把病人吓跑的。",
    staff_overworked = "您的员工已经劳累过度。他们的办事效率正在下降，并将有可能发生医疗事故。",
    doctor_crazy_overwork = "喔，不！您的一位医生已经由于劳累过度快要发狂了。如果能够立即让他休息，他将得到恢复。",
    doctors_tired = "您的医生太累了。立即让他们休息。",
    people_did_it_on_the_floor = "您的一些病人坚持不住了。赶快打扫干净。",
    queues_too_long = "队伍太长了。",
    money_very_low_take_loan = "您的现金量太少了。您可以尝试贷款。",
    patients_very_thirsty = "人们感到太口渴了。如果您不立即设置一些饮料机，则将看到大多数人回家去喝可乐。",
    machinery_very_damaged = "紧急！立即派清洁工去修理机器！它们要爆炸了！",
    handymen_tired2 = "您的清洁工太疲倦了。立即让他们休息。",
    desperate_need_for_watering = "您需要雇佣一名清洁工照料医院中的植物。",
    nurses_tired = "您的护士感到疲倦了。立即让她们休息。",
    too_much_litter = "医院中的废弃物不断增多。派几个清洁工人就可以解决。",
    reception_bottleneck = "接待台已无法满足需要。再雇佣一名接待员。",
    place_plants4 = "在医院中多摆放一些植物使所有病人感到快乐。",
    change_priorities_to_plants = "您必须改变清洁工的工作优先级，使他们更多地为植物浇水。",
    staff_too_hot = "您的工作人员感到太热了。请调低供热标准或拆除房间内的暖气。",
    finanical_trouble2 = "多增加一些收入。如果再亏损$%d任务就会失败。",
    plants_thirsty = "您需要对植物进行照料。它们正感到干渴。",
    litter_everywhere = "医院中的废弃物到处都是。多派几个清洁工人就可以解决。",
    nurses_tired2 = "您的护士太疲倦了。立即让她们休息。",
    plants_dying = "您的植物快干死了。它们需要水。多为植物派些清洁工。病人可不愿意看到枯死的植物。",
    reduce_staff_rest_threshold = "尝试在医院制度画面中减少员工休息时的疲劳程度，这样员工将经常休息。这只是一个主意。",
    more_toilets = "您需要更多的马桶。人们都已急不可待了。",
    hospital_is_rubbish = "人们在到处宣扬您的医院是垃圾。要知道您的医院很快就会臭名远扬。",
    pay_back_loan = "您已经挣到了很多钱。为什么不考虑偿还贷款？",
    financial_trouble3 = "您的现金状况不太妙。想办法增加一些收入。您距离失败还差$%d。",
    bankruptcy_imminent = "嗨！您快破产了。小心啊！",
    build_toilet_now = "立即建造洗手间。人们已经忍无可忍了。别傻笑，这可是一个严重问题。",
    patient_stuck = "有人被卡住了，更好地规划您的医院。",
    no_patients_last_month = "上个月，没有新的病人前来您的医院。太可怕了！",
    more_benches = "是否考虑多摆放一些长椅。一些病情严重的病人现在正被迫站着等待治疗。",
    many_epidemics = "看来医院里同时有不只一种传染病。这将是一场空前灾难，加油！",
    place_plants_to_keep_people = "人们正在离开。多摆放一些植物可以挽留他们。",
    patients_thirsty2 = "人们抱怨口渴。您应该在医院中多设置一些饮料机，或将已有的饮料机移动到他们身边。",
    money_low = "",
    staff_unhappy = "您的工作人员不是很快乐。可以尝试给他们一些奖金，或为他们建造一个员工休息室。您也可以在医院制度画面中调整员工需要休息时的疲劳程度。",
    people_freezing = "无法相信，在这个拥有中央空调的时代，您的一些病人竟然快被冻僵了。赶快摆放一些暖气并打开供暖开关使他们感到温暖。",
    need_toilets = "病人需要洗手间。请在一些易找的地方建造洗手间。",
    nobody_cured_last_month = "上个月几乎没有治愈一个病人。",
    patients_very_cold = "病人们感到太冷了。请增加医院的供热，或在医院中多摆放一些暖气。",
    build_toilets = "立即建造一个洗手间，否则您将看到非常不雅的事情发生。想象一下医院中将会出现的味道。",
    many_killed = "您已经杀死了%d个病人。您本应该治愈他们的病。",
    place_plants2 = "人们正在离开。多摆放一些植物可以使他们多停留一会儿。",
    staff_tired = "您的员工感到太疲倦了。如果您再不让他们到员工休息室休息一会儿，则某些人会由于长时间的紧张疲劳导致崩溃。",
    machines_falling_apart = "您的机器快爆炸了。请立即让清洁工进行维修！",
    patients_unhappy = "病人不喜欢您的医院。您必须为提高环境质量做一些事情。",
    place_plants3 = "人们的情绪很糟。多摆放一些植物使他们快乐。",
    staff_unhappy2 = "您的员工都不是很快乐。很快他们就会要求发奖金。",
    cash_low_consider_loan = "您的流动资金状况十分不妙。是否考虑贷款？",
    queue_too_long_at_reception = "在接待台前排队等待的病人太多了。请再建一个接待台并雇佣一名接待员。",
    queue_too_long_send_doctor = "您的%s队伍太长了。请确认房间中是否有医生。",
    financial_trouble = "您正面临着严重的财政危机。立即整理帐户！如果您再亏损$%d，本关任务将失败。",
    doctors_tired2 = "您的医生太疲倦了。立即让他们休息。",
    handymen_tired = "您的清洁工人太劳累了。立即让他们休息。",
    patient_leaving = "一个病人离开了。原因？医院管理不善，员工工作不力，再加上设施不全。",
    machinery_damaged2 = "您必须立即雇佣一名清洁工去负责修理维护机器。",
    patients_leaving = "病人们正在离去。在医院中多摆放一些植物，长椅，饮料机等物品将有助于挽留他们。",
    epidemic_getting_serious = "传染病疫情越来越严重。您必须立即行动！",
    machinery_damaged = "立即修理您的机器。它们无法支撑太久。",
    people_have_to_stand = "病人不得不站立等待。立即多摆放一些长椅。",
    receptionists_tired = "您的接待员太疲劳了。立即让她们休息。",
    build_staffroom = "立即建造一个员工休息室。您的员工工作太辛苦了，而且将要精神崩溃了。快点！",
    machinery_slightly_damaged = "您的医疗仪器有轻微损伤。别忘了维护。",
    need_staffroom = "建造一个员工休息室使您的员工得以休息。",
    patients_getting_hot = "病人们感到太热了。请降低医院的供热，或移走一些暖气。",
    machinery_deteriorating = "您的机器由于过度使用已经出现老化现象。小心。",
    patients_too_hot = "病人们感到太热了。要么拆除一些暖气，调低供热标准，要么为他们多设置一些饮料机。",
    patients_thirsty = "人们感到口渴。也许您应该向他们提供饮料机。",
    machine_severely_damaged = "%s已经快彻底毁坏了。",
    litter_catastrophy = "医院中的废弃物太多了。立即派一队清洁工人解决这个问题。",
    staff_very_cold = "员工们感觉太冷了。请增加医院的供热，或在医院中多摆放一些暖气。",
    deal_with_epidemic_now = "如果无法立即控制传染病那么您的医院将出大乱子。加油！",
    too_many_plants = "您已经布置了足够多的植物了。医院都快变成丛林了。",
    patients_really_thirsty = "病人们感到口渴。多放置一些饮料机，或将已有的饮料机移动到最长的队伍旁边。",
    some_litter = "清洁工人可以在垃圾成堆之前清除所有垃圾。",
    patients_annoyed = "人们对医院的管理感到极端愤怒。我不能责备他们，抓紧时间解决问题吧！",
    receptionists_tired2 = "您的接待员太疲倦了。立即让她们休息。",
  },
  placement_info = {
    door_can_place = "如果您愿意的话可以在这里设置房门。",
    window_can_place = "你可以在这里设置窗户，这样很好。",
    door_cannot_place = "抱歉，您无法在这里设置房门。",
    object_can_place = "您可以在这里摆放物品。",
    reception_can_place = "您可以在这里放置接待台。",
    staff_cannot_place = "您无法在这里安置员工。对不起。",
    staff_can_place = "您可以在这里安置员工。",
    object_cannot_place = "嗨，您无法在这里摆放物品。",
    room_cannot_place = "您无法在这里建房。",
    room_cannot_place_2 = "您无法在这里建房。",
    window_cannot_place = "您实际上无法在这里设置窗户。",
    reception_cannot_place = "您无法在这里放置接待台。",
  },
  praise = {
    many_benches = "病人拥有足够的座位。太棒了。",
    many_plants = "太可爱了。您已经布置了足够的植物。病人将感到满意。",
    plants_are_well = "太棒了。植物被照料得很好。",
    few_have_to_stand = "在您的医院中几乎每个人都有座位。所有的病人都感到快乐。",
    plenty_of_benches = "座椅已经足够了。",
    plants_thriving = "太棒了。医院中的植物生长得很茂盛。它们看起来令人感到惊奇。坚持住，您将有可能赢得一个大奖。",
    patients_cured = "已经治愈了%d个病人。",
  },
  information = {
    larger_rooms = "大的房间将使员工感觉到自己的重要，并提高他们的表现。",
    extra_items = "房间中摆放物品将使员工感到舒服并提高他们的表现。",
    epidemic = "在您的医院中发现了一种传染病。您必须立即处理！",
    promotion_to_doctor = "您的一个实习医生提升为医生了。",
    emergency = "紧急情况！快！快！快！",
    patient_abducted = "您的一位病人被外星人诱拐了。",
    first_cure = "干得好！您已经治愈了第一个病人。",
    promotion_to_consultant = "您的一名医生已经提升为专家了。",
    handyman_adjust = "您可以通过调整清洁工人工作的优先级使其打扫得更干净。",
    promotion_to_specialist = "您的一个医生被提升为%s。",
    initial_general_advice = {
      rats_have_arrived = "老鼠在您的医院中到处乱跑。使用鼠标打死它们。",
      autopsy_available = "自动验尸机被研制出来了。通过它，您可以处置惹麻烦或不欢迎的病人，还可以对他们进行研究。要注意－能否使用该机器还有很大的争议。",
      first_patients_thirsty = "医院中的人们感到口渴。为他们多摆放一些饮料机。",
      research_now_available = "您已经建造了第一个研究房间。现在您可以进入研究画面。",
      psychiatric_symbol = "拥有精神病技能的医生后跟符号：|",
      decrease_heating = "医院中的人们感到太热了。在城镇地图画面中，降低供热量。",
      surgeon_symbol = "拥有外科手术技能的医生后跟符号：{",
      first_emergency = "急救病人的头顶有一个闪亮的蓝色急救灯。在死亡之前或时间倒数结束之前治愈他们。",
      first_epidemic = "在医院中爆发了传染病请决定是掩盖病情还是将其清除出去。",
      taking_your_staff = "有人想要挖走您的员工。您要抓紧与他们进行斗争。",
      place_radiators = "医院中的人们感到寒冷－您可以多摆放一些暖气。",
      epidemic_spreading = "您的医院中发现传染病。在病人离开医院之前一定要治愈他们。",
      research_symbol = "拥有研究技能的医生后跟符号：}",
      machine_needs_repair = "您有一台机器需要维修。确定机器位置－它可能正在冒烟－在机器上点击一下，再点击清洁工人按钮。",
      increase_heating = "人们感到寒冷。打开城镇地图画面中的供暖设施。",
      first_VIP = "您要接待来访的第一位贵宾。一定要确保贵宾没有看到任何不良事件，或其他不高兴的病人。",
    },
    patient_leaving_too_expensive = "一位病人没有为%s付款就离开了。这损失太大了。",
    vip_arrived = "小心！%s正准备访问您的医院！保持医院运转正常，这样才能使他感到愉快。",
    epidemic_health_inspector = "您的医院中出现传染病的消息已经到达了卫生部。卫生巡查员很快就要到达，快做准备。",
    first_death = "这是您第一次杀死病人。感觉如何？",
    pay_rise = "您的一个员工威胁要辞职。选择是否同意其请求，或将其解雇。点击屏幕左下方的标志可以查看威胁要辞职的员工信息。",
    place_windows = "设置窗户将使房间更加明亮，并振奋员工的精神。",
    fax_received = "在屏幕左下角刚刚弹出的标志表示一些重要事件的相关信息，或某些需要您决定的事情。",
  },
  build_advice = {
    placing_object_blocks_door = "设置该物品可以阻止其他人接近。",
    blueprint_would_block = "蓝图与其它房间重叠了。请尝试重新设置蓝图尺寸，或移动蓝图位置。",
    door_not_reachable = "病人无法进入那扇门。仔细想一想。",
    blueprint_invalid = "蓝图位置非法。",
  },
}
casebook = {
  sent_home = "转走",
  deaths = "死亡",
  treatment_charge = "治疗花费",
  reputation = "声望",
  research = "集中研究",
  cure = "治疗",
  cured = "治愈",
  earned_money = "收入",
  cure_desc = {
    hire_psychiatrists = "您需要雇佣一些精神病医生。",
    improve_cure = "提高疗效。",
    hire_nurses = "您需要雇佣一些护士。",
    build_ward = "您仍需要建造一个病房。",
    no_cure_known = "未治愈。",
    cure_known = "治愈。",
    build_room = "我建议您修建%s",
    hire_doctors = "您需要雇佣一些医生。",
    hire_surgeons = "您需要雇佣一些外科医生。",
  },
}
diseases = {
  diag_ward = {
    name = "病房诊断",
  },
  diag_ultrascan = {
    name = "超级扫描仪诊断",
  },
  autopsy = {
    name = "验尸",
  },
  third_degree_sideburns = {
    cause = "病因－向往20世纪70年代。",
    cure = "治疗－精神病医生必须使用最新科技，使病人认识到这些奇装异服都是垃圾。",
    name = "络腮胡子",
    symptoms = "症状－长头发，全身闪闪发光。",
  },
  discrete_itching = {
    cause = "病因－昆虫叮咬。",
    cure = "治疗－病人喝下胶状糖浆阻止皮肤发痒。",
    name = "搔痒症",
    symptoms = "症状－到处乱抓，引起全身发炎。",
  },
  the_squits = {
    cause = "病因－吃了变质的比萨饼。",
    cure = "治疗－服用粘性药剂修补病人的内脏。",
    name = "呕吐",
    symptoms = "症状－噢。想必您也可以猜得到。",
  },
  spare_ribs = {
    cause = "病因－坐在冰冷的石地板上。",
    cure = "治疗－由两名外科医生执行手术。",
    name = "瘦骨",
    symptoms = "症状－胸部感觉不适。",
  },
  diag_blood_machine = {
    name = "血液机器诊断",
  },
  king_complex = {
    cause = "病因－猫王的思想进入病人大脑并取而代之。",
    cure = "治疗－由精神病医生告诉病人其荒谬的举止。",
    name = "猫王综合症",
    symptoms = "症状－穿着举止怪异。",
  },
  diag_x_ray = {
    name = "X光诊断",
  },
  pregnancy = {
    cause = "病因－怀孕。",
    cure = "治疗－在手术中心中将婴儿取出，洗净送到病人面前。",
    name = "产妇",
    symptoms = "症状－不断增大的啤酒肚。",
  },
  fake_blood = {
    cause = "病因－病人常常开玩笑。",
    cure = "治疗－只有精神病医生才能使病人安静下来。",
    name = "假血",
    symptoms = "症状－流出红色液体。",
  },
  diag_psych = {
    name = "精神病诊断",
  },
  invisibility = {
    cause = "病因－被有放射性的蚂蚁叮咬。",
    cure = "治疗－在药房喝下彩色液体，将很快使病人恢复正常。",
    name = "隐身",
    symptoms = "症状－病人本身感觉不到任何不适，并常常和家里人开玩笑。",
  },
  golf_stones = {
    cause = "病因－吸入了高尔夫球内部的有毒气体。",
    cure = "治疗－由两名外科医生执行手术。",
    name = "高尔夫症",
    symptoms = "症状－神经错乱且胡言乱语。",
  },
  diag_general_diag = {
    name = "一般诊断",
  },
  infectious_laughter = {
    cause = "病因－观看古典喜剧。",
    cure = "治疗－精神病医生必须让病人了解其当前严重的病情。",
    name = "狂笑症",
    symptoms = "症状－不住狂笑。",
  },
  general_practice = {
    name = "一般诊断",
  },
  baldness = {
    cause = "病因－向公众说谎话。",
    cure = "治疗－使用仪器将头发缝合到病人的头上。",
    name = "秃顶",
    symptoms = "症状－脑门发亮，十分困窘。",
  },
  heaped_piles = {
    cause = "病因－站立在水冷却器旁边。",
    cure = "治疗－服用药剂。",
    name = "痔疮",
    symptoms = "症状－病人感觉就象坐在大理石上。",
  },
  unexpected_swelling = {
    cause = "病因－意外事件。",
    cure = "治疗－由两名外科医生实行手术。",
    name = "肿胀",
    symptoms = "症状－肿胀。",
  },
  jellyitis = {
    cause = "病因－日常饮食含有过多的胶状物并完成太多的练习。",
    cure = "治疗－将病人浸入到胶桶中。",
    name = "失衡症",
    symptoms = "症状－走路摇摇晃晃并不时摔倒。",
  },
  hairyitis = {
    cause = "病因－在月光下停留过长时间。",
    cure = "治疗－使用电分解机器去掉毛发并填补遗留的毛孔。",
    name = "多毛症",
    symptoms = "症状－嗅觉特别灵敏。",
  },
  alien_dna = {
    cause = "病因－拥有了外星人的DNA。",
    cure = "治疗－利用仪器快速清除病人体内的DNA。",
    name = "外星人DNA",
    symptoms = "症状－逐渐蜕变成外星人并阴谋摧毁我们的城市。",
  },
  bloaty_head = {
    cause = "病因－闻到了坏乳酪并喝了不干净的雨水。",
    cure = "治疗－打破肿胀脑袋，并使用充气机使脑袋恢复正常。",
    name = "头部肿胀",
    symptoms = "症状－非常不舒服。",
  },
  gastric_ejections = {
    cause = "病因－吃了过辣的四川菜。",
    cure = "治疗－服用特殊凝固剂从而阻止呕吐。",
    name = "反胃症",
    symptoms = "症状－半消化的食物被病人不时吐出。",
  },
  uncommon_cold = {
    cause = "病因－吸进了空气中的灰尘。",
    cure = "治疗－服用药房配制的特效药。",
    name = "感冒",
    symptoms = "症状－流鼻涕，打喷嚏。",
  },
  corrugated_ankles = {
    cause = "病因－驾驶时间过长。",
    cure = "治疗－服用少量毒草和香料制成的药剂，从而打通关节。",
    name = "脚踝弯曲",
    symptoms = "症状－脚踝感觉不舒服。",
  },
  sleeping_illness = {
    cause = "病因－内分泌失调。",
    cure = "治疗－由护士配制一剂威力强大的兴奋剂给病人服用。",
    name = "嗜睡症",
    symptoms = "症状－无论走到那里都想睡觉。",
  },
  sweaty_palms = {
    cause = "病因－害怕找工作时的面试。",
    cure = "治疗－精神病医生使病人走出心理误区。",
    name = "手心出汗症",
    symptoms = "症状－当与病人握手时，感觉就象攥着一块吸满了水的海绵。",
  },
  serious_radiation = {
    cause = "病因－不小心错误吞吃了含有钚元素的口香糖。",
    cure = "治疗－病人必须被放置在净化淋浴器内彻底清洗。",
    name = "放射病",
    symptoms = "症状－病人感到非常非常的不舒服。",
  },
  diag_cardiogram = {
    name = "心电图仪诊断",
  },
  diag_scanner = {
    name = "扫描仪诊断",
  },
  gut_rot = {
    cause = "病因－喝了太多的威士忌酒。",
    cure = "治疗－由护士配制药剂，交给病人服下。",
    name = "内脏腐烂",
    symptoms = "症状－不咳嗽，但胃壁也没有了。",
  },
  iron_lungs = {
    cause = "病因－城市中浑浊的空气。",
    cure = "治疗－两名外科医生在手术中心执行手术。",
    name = "铁肺",
    symptoms = "症状－浑身难受。",
  },
  broken_wind = {
    cause = "病因－饭后使用健身房的脚踏车进行运动。",
    cure = "治疗－服用药房配制的特效药。",
    name = "臭屁症",
    symptoms = "症状－使身后的人感到极度的不舒服。",
  },
  kidney_beans = {
    cause = "病因－饮料中加入了大量冰块。",
    cure = "治疗－由两名外科医生执行手术。",
    name = "肾豆",
    symptoms = "症状－疼痛且经常去厕所。",
  },
  transparency = {
    cause = "病因－舔了打开的容器的铅箔上的酸乳酪。",
    cure = "治疗－服用药房配制的特殊清凉彩色冲剂就可以治愈疾病。",
    name = "透明症",
    symptoms = "症状－肌肉变得透明，对光敏感。",
  },
  broken_heart = {
    cause = "病因－一些人比病人富有，年轻，瘦。",
    cure = "治疗－由两名外科医生打开病人的胸腔，轻轻地修补其心脏缺陷。",
    name = "破碎的心",
    symptoms = "症状－痛哭流涕。",
  },
  slack_tongue = {
    cause = "病因－过多地讨论肥皂剧。",
    cure = "治疗－将舌头放入舌头切片机中，将快速有效地得到治疗。",
    name = "舌头松弛症",
    symptoms = "症状－舌头增长到正常的5倍。",
  },
  tv_personalities = {
    cause = "病因－日间电视节目。",
    cure = "治疗－精神病医生必须使病人有信心卖掉电视机，而购买收音机。",
    name = "电视病",
    symptoms = "症状－产生错觉，以为自己正在表演。",
  },
  ruptured_nodules = {
    cause = "病因－在寒冷的季节中跳跃。",
    cure = "治疗－两名称职的外科医生必须使用稳定的双手切除肿瘤。",
    name = "肿瘤",
    symptoms = "症状－无法舒适地坐下。",
  },
  fractured_bones = {
    cause = "病因－从高处摔到混凝土地面上。",
    cure = "治疗－将已打好的石膏使用仪器去除。",
    name = "骨折",
    symptoms = "症状－剧痛且无法使用四肢。",
  },
  chronic_nosehair = {
    cause = "病因－经常对不如自己的人嗤之以鼻。",
    cure = "治疗－口服令人厌恶的毛发去除剂，该药剂由护士在药房配制。",
    name = "鼻毛过多症",
    symptoms = "症状－鼻毛过长过多，快成鸟巢了。",
  },
}
policy = {
  header = "医院制度",
  diag_termination = "诊断结束",
  sliders = {
    guess = "尝试治疗",
    send_home = "遣送回家",
    stop = "停止治疗",
    staff_room = "去员工休息室",
  },
  diag_procedure = "诊断程序",
  staff_rest = "员工休息",
  staff_leave_rooms = "员工离开房间",
}
competitor_names = {
  [1] = "神谕",
  [2] = "巨人",
  [3] = "黑尔",
  [4] = "马笛维克",
  [5] = "冬青树",
  [6] = "沉思",
  [7] = "禅",
  [8] = "里昂",
  [9] = "玛文",
  [10] = "晶体",
  [11] = "母亲",
  [12] = "洁尼",
  [13] = "CORSIX",
  [14] = "ROUJIN",
  [15] = "EDVIN",
  [16] = "萨姆",
  [17] = "查理",
  [18] = "亚瑟",
  [19] = "马格尼斯",
  [20] = "赛尔",
  [21] = "约书亚",
  [22] = "丹尼尔",
  [23] = "奥利文",
  [24] = "尼克",
}
buy_objects_window = {
  price = "价格：",
  choose_items = "选择物品",
  total = "总共：",
}
trophy_room = {
  wait_times = {
    award = {
      [1] = "恭喜。您的医院的排队等待时间非常短。这是给您的奖励。",
    },
    penalty = {
      [1] = "病人在您的医院中排队等待时间太长了。您应该好好地管理前来就诊的病人。",
    },
  },
  happy_vips = {
    trophies = {
      [1] = "由于您的医院在过去一年中给来访的贵宾们留下了深深地好感，特此向您颁发诺贝尔奖。",
      [2] = "由于您的医院使每位造访贵宾都感到快乐，特此由名人机构颁发著名人士奖。您已经成为我们名人行列中的一员。",
      [3] = "由于您的医院在过去一年中使每一位来访贵宾都感到了员工的工作热情，特此颁发贵宾满意奖。",
    },
  },
  hosp_value = {
    penalty = {
      [1] = "您的医院价值太低了。您的理财能力太次了。记住一个好的医院通常也是价值最高的医院。",
    },
    awards = {
      [1] = "由于您的医院价值不菲，因此卫生部向您表示恭喜。",
    },
    regional = {
      [1] = "您真是一个理财高手。您的医院的价值比其它医院的总和还要多。",
    },
  },
  rats_accuracy = {
    trophies = {
      [1] = "由于您击打老鼠的命中率为%d%%，特此颁发极道枭雄2 射击准确奖。",
      [2] = "由于您的医院在过去一年中以难以置信的命中率%d%%击毙老鼠，特此颁奖。",
      [3] = "由于您的医院在过去一年中击毙了%d%%的老鼠，特此颁发地下城守护者除害奖。恭喜！",
    },
  },
  all_cured = {
    awards = {
      [1] = "由于您的医院在过去一年中成功地治疗了所有病人，特此颁发玛丽治疗奖。",
    },
    trophies = {
      [1] = "由于您的医院在过去一年中成功地治疗了就诊的每个病人，国际治疗基金会特此向您颁发全部治愈奖。",
      [2] = "由于您的医院在过去一年中治愈了大量患者，特此颁发急病克星奖。",
    },
  },
  best_value_hosp = {
    trophies = {
      [1] = "由于您的医院在过去一年中赢得了最高的声望，特此颁发白衣天使奖。这是您应得的。",
    },
    penalty = {
      [1] = "周围每个医院都比您的医院富有。您要加油啊。多购买一些昂贵的东西。",
    },
    regional = {
      [1] = "恭喜您管理的医院成为最有价值的医院。干得好。保持下去。",
    },
  },
  high_rep = {
    penalty = {
      [1] = "在过去一年中，您赢得了很低的声望。以后一定要加油啊。",
      [2] = "您的声望是本区域最低的。真丢人。加油干。",
    },
    awards = {
      [1] = "干得好。在上一个年度，由于您获得了很高的声望，特此颁发一个小小的奖励。",
      [2] = "太棒了! 由于您在过去一年中取得了很高的声望，特此颁发奖励。",
    },
    regional = {
      [1] = "由于您的医院在过去一年中赢得了最高的声望，特此颁发牛蛙奖。这是您应得的。",
      [2] = "在这一年中，您的医院的声望超过了其它所有医院的总和。真是一项伟大的成就。",
    },
  },
  consistant_rep = {
    trophies = {
      [1] = "由于您的医院在过去一年中无懈可击的运营以及最高的声望，您被授予内阁大臣奖。干得好。",
      [2] = "由于您的医院在过去一年中赢得了最高的声望，特此颁发白衣天使奖。这是您应得的。",
    },
  },
  curesvdeaths = {
    awards = {
      [1] = "恭喜您在过去一年中使医院保持了很高的治愈率和很低的死亡率。",
    },
    penalty = {
      [1] = "您的治愈率实在是太低了。您应该使治愈的病人多于死亡的病人。不要颠倒了。",
    },
  },
  cleanliness = {
    regional_good = {
      [1] = "您的医院是最脏乱的医院之一。一个脏乱的医院不仅味道难闻，而且是十分危险的。请密切留意。",
    },
    award = {
      [1] = "卫生巡查员注意到您的医院非常干净。干净的医院意味着安全的医院。坚持下去。",
    },
    regional_bad = {
      [1] = "您的医院是本区域中最脏乱的。其它医院都使走廊保持整洁。您使医学界蒙羞。",
    },
  },
  happy_patients = {
    awards = {
      [1] = "在过去一年中，您的医院使所有访问的病人都感到快乐，您将为此感到骄傲。",
      [2] = "访问您的医院的病人比其它医院内的病人要快乐得多。",
    },
    penalty = {
      [1] = "前去您的医院就诊的病人感到非常不满。您必须改进提高才可以获得卫生部的尊重。",
      [2] = "在您的医院中接受治疗的病人感到非常不高兴。您应多为病人的福利着想。",
    },
  },
  emergencies = {
    regional_good = {
      [1] = "卫生部认识到您的医院在处理紧急事件时比其它医院都要好，特此颁发奖励。",
    },
    penalty = {
      [1] = "您处理紧急事件的能力实在太差了。前来就诊的急救病人并没有得到正确的治疗。",
    },
    regional_bad = {
      [1] = "您的医院是本区域中处理紧急事件最差的。这都是您的过错。",
    },
    award = {
      [1] = "恭喜：由于您的努力和卓有成效的紧急事件处理能力，使您荣获该特别大奖。干得好。",
      [2] = "您处理紧急事件的能力非常突出。由于您最佳的处理能力，特此颁发奖励。",
    },
  },
  gen_repairs = {
    awards = {
      [1] = "由于您的清洁工人使医院内的仪器设备运行良好，特此颁发特别奖金。干得好。假期愉快。",
      [2] = "您的清洁工人比其它医院的都要好。这真是一件值得庆祝的事情。",
      [3] = "您的仪器维护得很好。这一切都离不开清洁工人的努力。干得好。",
    },
    penalty = {
      [1] = "您的清洁工人在维护机器方面表现不是很好。您应该让他们更多地关心维护保养工作，或者再多雇佣几名清洁工人。",
      [2] = "维修工作一团糟。您的清洁工人无法很好的照料各种医疗仪器。",
    },
  },
  no_deaths = {
    trophies = {
      [1] = "由于您的医院在过去一年中没有发生任何病人死亡事件，特此颁发安全奖。",
      [2] = "由于您的医院在过去一年中没有发生病人死亡事件，特此由生命发展组织向您颁奖。",
      [3] = "由于您的医院在过去一年中避免发生病人死亡事件，特此颁发挽留妙手回春奖。",
    },
    penalty = {
      [1] = "在过去一年中，您的医院的死亡人数始终很高。一定要多加注意。以后一定要确保病人的存活。",
      [2] = "您的医院对于病人的健康简直就是在冒险。您应该治愈大量的病人，而不是让他们加速死亡。",
    },
    awards = {
      [1] = "由于您的医院在本年度保持了很低的死亡人数，特此颁发奖励。太棒了。",
      [2] = "由于您的天才管理使医院的死亡人数达到最低点。这真是令人高兴的事情。",
    },
    regional = {
      [1] = "您的医院的死亡人数比其它医院都低。请接受这个奖励。",
    },
  },
  rats_killed = {
    trophies = {
      [1] = "由于您的医院在过去一年中共击毙了%d只老鼠，特此颁发除害奖。",
      [2] = "由于您高超的击鼠技巧共击毙老鼠%d只，特此颁发联邦灭鼠奖。",
      [3] = "由于您的医院在过去一年中共击毙了%d只老鼠，特此颁发老鼠克星奖。",
    },
  },
  happy_staff = {
    trophies = {
      [1] = "由于您的医院在过去一年中使努力工作的员工保持快乐，特此颁发微笑奖。",
      [2] = "由于您的医院在过去一年中没有不快乐的员工，特此颁发阿达尼学院奖。",
      [3] = "由于您的医院在过去一年中使努力工作的员工保持快乐，特此颁发笑星奖杯。快乐地笑吧！",
    },
    awards = {
      [1] = "您的员工表示要向您颁奖。他们说虽然还有很多需要改进的地方，但您对待他们的态度使他们感到很快乐。",
      [2] = "您的员工感到能够为您工作是一件非常快乐的事情，他们的笑容挂在脸上。您真是一个超级管理人才。",
    },
    penalty = {
      [1] = "您的员工希望您知道他们非常不高兴。好的员工就是最有价值的资产。使他们快乐，否则您将在一天之内失去全部。",
    },
    regional_good = {
      [1] = "您的员工比其它医院的员工都要快乐。快乐的员工意味着更高的利润和更低的死亡率。卫生部感到非常高兴。",
    },
    regional_bad = {
      [1] = "您的员工在上一年度中非常不幸。您一定要加以留意。其它医院的员工都比您的员工快乐。",
    },
  },
  healthy_plants = {
    awards = {
      [1] = "由于您的医院在过去一年中是植物保持健康成长，特此颁发茁壮成长奖。",
    },
    trophies = {
      [1] = "由于您的医院在过去十二个月中使所有植物长势良好，特此盆栽植物协会向您颁发绿色健康奖。",
      [2] = "由于您的医院在过去一年中使所有植物长势良好，特此颁发绿色名人奖。",
    },
  },
  sold_drinks = {
    trophies = {
      [1] = "由于您的医院在过去一年中售出了大量的罐装饮料，特此由全球牙医联合会向您颁奖。",
      [2] = "由于您的医院在过去一年中卖出大量饮料，特此软饮料零售组织向您颁发清凉饮料奖。",
      [3] = "由于您的医院在过去一年中卖出大量软饮料，特此由DK饮料公司向您颁发巧克力奖杯。",
    },
  },
  many_cured = {
    trophies = {
      [1] = "由于您的医院在过去一年中成功地治疗了几乎所有病人，特此恭喜您荣获玛丽治疗奖。",
      [2] = "由于您的医院在过去一年中治愈了大量患者，国际治疗基金会特此向您颁发悬壶济世奖。",
      [3] = "由于您的医院在过去一年中治愈了大量患者，特此颁发疾病克星奖。",
    },
    penalty = {
      [1] = "您的医院无法使病人得到很好的治疗。请关注并加以改进。",
      [2] = "您的医院对病人的治疗效果不如其它医院。您使卫生部和您自己都名声扫地。下不为例。",
    },
    awards = {
      [1] = "恭喜您在过去一年中治愈了这么多的病人。很多人都感觉不错，感谢您的工作。",
      [2] = "由于您的医院治愈了比其它医院更多的病人，所以请接受这个奖励。您的表现太棒了。",
    },
    regional = {
      [1] = "由于您的医院治愈的病人数目比其它医院的总和还多，特此颁发奖励。",
    },
  },
  pop_percentage = {
    awards = {
      [1] = "在过去一年中，您的医院在城镇人口中获得了很高的份额。干得好。",
      [2] = "恭喜。访问您的医院的居民人数超过了其它任何一个医院。",
      [3] = "干得好。访问您的医院的居民人数超过了其它医院的总和。",
    },
    penalty = {
      [1] = "在过去一年中，您的医院在城镇人口中获得了很高的份额。干得好。",
      [2] = "恭喜。访问您的医院的居民人数超过了其它任何一个医院。",
    },
  },
  research = {
    regional_good = {
      [1] = "您的研究使您的医院始终紧跟最新发展。这是您的科研人员应得的奖励。",
    },
    penalty = {
      [1] = "您研究开发新治疗方案，仪器和药品的速度太慢了。这将无法赶上时代的步伐。",
    },
    regional_bad = {
      [1] = "本区域中的每个医院在研究方面都强于您的医院。这一点使卫生部感到震怒。",
    },
    awards = {
      [1] = "您的研究使您的医院始终紧跟最新发展。这是您的科研人员应得的奖励。",
      [2] = "在过去一年中，您比其它医院研究出更多的药品和仪器设备。请接受卫生部颁发的这个奖励。",
    },
  },
  reputation = "声望",
  cash = "现金",
}
menu_options_volume = {
  [50] = "    50%",
  [100] = "    100%",
  [30] = "    30%",
  [60] = "    60%",
  [90] = "    90%",
  [10] = "    10%",
  [20] = "    20%",
  [40] = "    40%",
  [80] = "    80%",
  [70] = "    70%",
}
menu_file_load = {
  [1] = " 存档一 ",
  [2] = " 存档二 ",
  [3] = " 存档三 ",
  [4] = " 存档四 ",
  [5] = " 存档五 ",
  [6] = " 存档六 ",
  [7] = " 存档七 ",
  [8] = " 存档八 ",
}
menu_file = {
  quit = "    退出",
  save = "    存储",
  load = "    读取",
  restart = "    重新开始",
}
rooms_long = {
  ultrascan = "超级扫描仪房间",
  research_room = "研究部门",
  general = "一般",
  gps_office = "一般诊断室",
  inflation = "充气房间",
  staffroom = "员工休息室",
  jelly_vat = "胶桶",
  scanner = "扫描仪房间",
  emergency = "紧急事件",
  decontamination = "净化",
  corridors = "走廊",
  cardiogram = "心电图仪房间",
  ward = "病房",
  training_room = "培训室",
  psychiatric = "精神病诊断治疗室",
  operating_theatre = "手术中心",
  dna_fixer = "DNA修复装置",
  tongue_clinic = "舌头松弛诊治所",
  hair_restoration = "毛发恢复装置",
  general_diag = "高级诊断室",
  pharmacy = "药房",
  fracture_clinic = "骨折诊所",
  toilets = "洗手间",
  electrolysis = "电分解诊所",
  x_ray = "X光房间",
  blood_machine = "血液机器房间",
}
fax = {
  epidemic_result = {
    fine_amount = "政府宣布全国紧急状态，并对您罚款%d。",
    close_text = "哈！",
    hospital_evacuated = "会议决定只能疏散您的医院。",
    succeeded = {
      part_1_name = "卫生巡查员听到了传闻，您的医院正在处理严重疾病%s。",
      part_2 = "然而他还没有能够找到证实传闻的证据。",
    },
    compensation_amount = "政府决定奖励您%d作为补偿谣言对您医院声誉所造成的损失。",
    failed = {
      part_1_name = "尝试掩盖病情，他们正面临着传染病%s爆发。",
      part_2 = "医院中的员工已经制止了传染病向医院附近居民传播。",
    },
    rep_loss_fine_amount = "报纸将整版报道此事。您的声望将大幅受损。另外，还要缴纳罚款%d。",
  },
  vip_visit_query = {
    choices = {
      invite = "向贵宾发出邀请。",
      refuse = "找借口阻止贵宾访问。",
    },
    vip_name = "%s希望能够访问您的医院！",
  },
  vip_visit_result = {
    telegram = "电报！",
    remarks = {
      good = {
        [1] = "医院经营得太棒了。感谢您能够邀请我来访问。",
        [2] = "嗯。医院经营得还可以。",
        [3] = "我很欣赏您的医院。",
      },
      super = {
        [1] = "医院太棒了。下次我生病一定要到那里去就诊。",
        [2] = "那就是我访问的医院。",
        [3] = "那是一个超级医院。并且我想知道更多一点。",
      },
      bad = {
        [1] = "我为什么烦恼？这比看一场持续4个小时的歌剧好多了！",
        [2] = "我为我所看到的感到恶心。这也是医院？胡说八道！",
        [3] = "我已经受够了！",
      },
      mediocre = {
        [1] = "喔，有点差劲。您应多做一些改进。",
        [2] = "喔，亲爱的。这个地方可不怎么样。",
        [3] = "这是一个比较一般的医院。但坦白地讲，我希望能够做得更好。",
      },
      very_bad = {
        [1] = "真是一个垃圾。我要争取关闭它。",
        [2] = "我从没有见过这样可怕的医院。真是丢人！",
        [3] = "我被震惊了。这也能称为医院！给我一点酒。",
      },
    },
    rep_boost = "您的声望在公众中是很好的。",
    vip_remarked_name = "%s访问医院结束后发表评论：",
    cash_grant = "您将得到奖金%d。",
    rep_loss = "您的声望因此受到损害。",
    close_text = "感谢您访问医院。",
  },
  disease_discovered_patient_choice = {
    need_to_build = "您必需建造一个%s才能处理该疾病。",
    need_to_employ = "雇佣一名%s就可以处理该情况。",
    what_to_do_question = "您打算怎样处理这个病人？",
    guessed_percentage_name = "您的员工正在尝试治疗该病人。我们有%d%%的几率治愈该病：%s",
    choices = {
      send_home = "送病人回家。",
      research = "将病人送到研究部门。",
      wait = "让病人在医院中等一会儿。",
    },
    disease_name = "发现了新情况。该疾病为%s",
    need_to_build_and_employ = "如果您建造了一个%s并雇佣了一名%s，您就能成功。",
    can_not_cure = "您无法治疗该疾病。",
  },
  emergency_result = {
    earned_money = "最大奖金额为$%d，您得到了$%d。",
    close_text = "点击这里退出。",
    saved_people = "您挽救了%d个病人，总共需要治愈%d个。",
  },
  disease_discovered = {
    discovered_name = "您的员工发现了一种新的疾病。它是%s",
    need_to_employ = "雇佣一名%s就可以处理这种危机。",
    need_to_build_and_employ = "如果您建造了一个%s并雇佣了一名%s，您就能成功。",
    need_to_build = "您必需建造一个%s才能处理该疾病。",
    close_text = "新发现了一种疾病。",
    can_cure = "您可以处理这种疾病。",
  },
  emergency = {
    locations = {
      [1] = "赛澈化学药品工厂。",
      [2] = "斯尼得大学。",
      [3] = "派拉奎特园艺中心。",
      [4] = "危险物质研究机构。",
      [5] = "莫理斯舞蹈家协会。",
      [6] = "青蛙与公牛酒店。",
      [7] = "大戴维殡葬馆。",
      [8] = "太子制革店。",
      [9] = "伯特二手石化产品商场。",
    },
    num_disease = "%d个病人患有%s，他们需要紧急治疗。",
    cure_possible_drug_name_efficiency = "您已经拥有了要求的设备和技能。您拥有他们所需要的药品。药品%s的疗效为%d%%。",
    cure_not_possible_employ = "您将需要雇佣一名%s",
    cure_not_possible = "现在您还不能治疗这种疾病。",
    cure_possible = "由于您拥有准备和技能，所以您应该可以处理这个紧急事件。",
    choices = {
      accept = "好的。我已做好准备处理紧急事件。",
      refuse = "不。我拒绝处理这个紧急事件。",
    },
    location = "在%s发生了事故",
    cure_not_possible_build = "您将需要建造一间%s",
    cure_not_possible_build_and_employ = "您将需要建造一间%s并雇佣一名%s",
    bonus = "处理这个紧急事件的最大奖金额为%d。如果您失败了，则您的声望将大幅下降。",
  },
  debug_fax = {
    text4 = "FACTORS  : DOCS %d  NURSES %d  AREA %d  ROOMS %d  PRICING %d",
    text5 = "CONTRIBN : DOCS %d  NURSES %d  AREA %d  ROOMS %d  PRICING %d PERCENT",
    text3 = "FIGURES  : DOCS %d  NURSES %d  AREA %d  ROOMS %d  PRICING %d",
    text9 = "DISASTERS %d ALLOWED (MTHS) %d (%d)REDUCTION %d",
    close_text = "嗨，哈，哈！",
    text1 = "BEST COUNT %d",
    text6 = "THE FOLLOWING FACTORS ARE ALSO APPLIED",
    text8 = "AMENITIES %d PEEPS HANDLED %d REDUCTION %d",
    text2 = "TOTAL PEOPLE IN HOSPITAL %d CHECKING AGAINST %d",
    text10 = "KILLS %d ALLOWED (MTHS) %d (%d) REDUCTION %d",
    text11 = "PEOPLE THIS MONTH %d",
    text7 = "REPUTATION: %d EXPECTED %d REDUCTION %d",
  },
  epidemic = {
    cover_up_explanation_1 = "如果您想要掩盖传染病，您将必须在有限时间内，即卫生巡查员到来之前，治愈所有被传染的病人。",
    cover_up_explanation_2 = "如果卫生巡查员到达，并发现了您正在试图掩盖传染病，则他将对您采取严厉的惩罚。",
    choices = {
      cover_up = "在指定时间内且病人离开医院之前，尽量治愈所有被感染的病人。",
      declare = "宣布一种传染病。支付罚款且名誉受损。",
    },
    disease_name = "医生发现了传染病%s。",
    declare_explanation_fine = "如果您宣布出现传染病，则您将支付罚款%d，且名誉受损。所有病人将自动被接种疫苗。",
  },
  diagnosis_failed = {
    choices = {
      send_home = "送病人回家。",
      take_chance = "尝试治疗病人。",
      wait = "让病人多等待一会儿，您需要多建造一些诊断室。",
    },
    situation = "我们已经对该病人尝试了所有可供使用的机器，但是仍然没有发现病因。",
    what_to_do_question = "我们将怎样处置这个病人？",
    partial_diagnosis_percentage_name = "我们有%d%%的概率确定该病人所患疾病类型。",
  },
}
drug_companies = {
  [1] = "良药公司",
  [2] = "名医公司",
  [3] = "小药片公司",
  [4] = "普芬公司",
  [5] = "欧米尼公司",
}
humanoid_name_ends = {
  [1] = "斯密斯",
  [2] = "威克",
  [3] = "克利夫",
  [4] = "桑",
  [5] = "因格顿",
  [6] = "贝里",
  [7] = "顿",
  [8] = "桑",
  [9] = "李",
  [10] = "伯利",
  [11] = "波姆",
  [12] = "兰",
  [13] = "汉默",
  [14] = "希尔",
  [15] = "温",
  [16] = "莱特",
  [17] = "艾尔斯",
  [18] = "顿",
  [19] = "蒙德",
  [20] = "曼",
  [21] = "爱尔顿",
  [22] = "依",
  [23] = "摩",
  [24] = "摩尔",
  [25] = "莱特",
  [26] = "林",
}
confirmation = {
  return_to_blueprint = "您定要返回蓝图模式吗？",
  restart_level = "确定要重新开始这个任务吗？",
  delete_room = "确定要拆除这个房间吗？",
  quit = "确定要退出游戏吗？",
  overwrite_save = "该位置已有游戏进度。是否覆盖？",
  sack_staff = "确定要解雇该员工吗？",
  replace_machine = "确定要更新%s，并花费$%d？",
}
months = {
  [1] = "1 月",
  [2] = "2 月",
  [3] = "3 月",
  [4] = "4 月",
  [5] = "5 月",
  [6] = "6 月",
  [7] = "7 月",
  [8] = "8 月",
  [9] = "9 月",
  [10] = "10 月",
  [11] = "11 月",
  [12] = "12 月",
}
dynamic_info = {
  patient = {
    emergency = "紧急情况：%s",
    guessed_diagnosis = "尝试诊断：%s",
    diagnosis_progress = "诊断过程",
    actions = {
      sent_to_other_hospital = "指派到其它医院",
      prices_too_high = "费用太高了－我要回家了",
      waiting_for_treatment_rooms = "等待为我建造一间治疗室",
      dying = "快死了！",
      no_diagnoses_available = "无法诊断－我要回家了",
      epidemic_sent_home = "被巡查员赶回家",
      cured = "治愈！",
      waiting_for_diagnosis_rooms = "等待建造更多的诊断室",
      epidemic_contagious = "我有传染病",
      awaiting_decision = "等待您的决定",
      sent_home = "遣送回家",
      fed_up = "受够了，要离开",
      no_treatment_available = "无法治疗－我要回家了",
      on_my_way_to = "在去%s的路上",
      queueing_for = "排队等待%s",
    },
    diagnosed = "诊断：%s",
  },
  health_inspector = "卫生巡查员",
  vip = "来访贵宾",
  object = {
    times_used = "使用次数%d",
    queue_size = "排队人数%d",
    strength = "力量%d",
    queue_expected = "即将加入队伍人数%d",
  },
  staff = {
    ability = "能力",
    psychiatrist_abbrev = "精神分析",
    actions = {
      going_to_repair = "前往维修%s",
      waiting_for_patient = "等待病人",
      wandering = "正在到处走动",
    },
    tiredness = "疲劳",
  },
}
introduction_texts = {
  level17 =
    "最后的警告－时刻关注您的声望－这是真正吸引病人前来就诊的关键。" ..
    "如果您没有杀死太多的病人，且使就诊病人保持快乐，则不必太担心声望！" ..
    "决定权就在您的手中。祝您好运。",
  level1 =
    "欢迎来到您的第一座医院！//" ..
    "首先要摆放接待台，建造一般诊断室，并雇佣一名接待员和一名医生。" ..
    "随后就可以等待开张了。" ..
    "建造精神病诊断治疗室并雇佣一名精神病医生是一个好主意。" ..
    "药房和护士也是治疗病人所必需的。" ..
    "建造一个充气机房间就可以治疗头部肿胀患者。" ..
    "您需要治愈10个病人，并使声望保持在200以上。",
  level9 =
    "当填满了卫生部的银行帐户并为部长大人购买了一辆轿车后，您现在又要开始新的工作了。" ..
    "在这里您要面对很多问题。" ..
    "只有拥有足够经验充分的员工和房间，您才能够顺利过关。" ..
    "医院价值需要达到$200,000，且银行帐户上要有$400,000。" ..
    "如果无法达到上述要求，则无法胜利完成任务。",
  level2 =
    "在该区域内还有一些其它的疾病。" ..
    "建造医院从而可以治疗更多的病人，并应该考虑建造研究部门。" ..
    "记住保持内部的清洁，从而使声望尽可能地高－您将遇到患有舌头松弛症的病人，因此需要建造舌头诊治房间。" ..
    "您也可以建造心电图房间来帮助诊断疾病。" ..
    "这些房间都需要经过研究才能够被建造。现在你可以购买其它土地扩展医院－使用城镇地图就可以购买土地。" ..
    "目标是声望300，银行现金为10000，且治愈40个病人。",
  level7 =
    "在这里您将受到卫生部的密切监察，因此要在赚钱的同时，努力提高自己的声望。" ..
    "我们无法处理太多的医疗事故－这对于医院的运营是十分不利的。" ..
    "确认所有员工都很快乐，并确认已经购买了所有需要的仪器装备。" ..
    "声望需要达到600，且银行里需要有$200,000。",
  level5 =
    "医院将非常繁忙，处理各种各样的病人。" ..
    "医生都是刚刚毕业的实习医生，因此需要建造一间培训室对他们进行培训，提高能力。" ..
    "您只有3名专家可以帮助培训这些员工，因此一定要让专家快乐。" ..
    "另外要注意的是，医院的位置不是很好。" ..
    "经常会发生地震。" ..
    "地震将对医院中的机器产生损坏，从而影响医院的运营。" ..
    "使您声望达到400以上，现金达到$50,000。另外需要治愈200个病人。",
  level4 =
    "使所有的病人快乐，保持治疗的高效率并尽量降低死亡人数。" ..
    "声望是十分重要的，因此尽量赢得更高的声望。" ..
    "不要太多担心收入情况－当声望提高了，收入也自然会提高。" ..
    "您需要培训您的医生，拓宽他们的能力。" ..
    "这样他们就可以更好的为病人服务。" ..
    "胜利条件是声望达到500以上。",
  level14 =
    "这里还有一个挑战－一个充满惊奇的医院。" ..
    "如果您能够成功完成这个任务，则您将成为所有胜利者中的佼佼者。" ..
    "不要认为完成这个任务就象吃蛋糕一样，这将是您所遇到的最艰苦的工作。" ..
    "祝您好运！",
  level15 =
    "好的，下面是管理医院的一些技巧。//" ..
    "医生需要各种帮助来诊断病人。您可以" ..
    "建造另一个诊断类房间，例如高级诊断室。",
  level8 =
    "需要您来建造一座高效的医院。" ..
    "很多人都无事可做，因此需要适量的裁员以保持高效。" ..
    "记住治愈病人是很重要的一件事情，但是您更要从中赚钱。" ..
    "让恶心呕吐的病人靠近清洁工人。" ..
    "需要赚取$300,000就可以过关。",
  level13 =
    "您的高超管理技能被特殊机密部门获知。" ..
    "他们将向您提高特别奖金，因为他们有一座被老鼠困扰的医院需要有效管理。" ..
    "您必须杀死尽可能多的老鼠，并让清洁工人打扫干净。" ..
    "接受这个任务？",
  level16 =
    "当对病人完成诊断后，需要建造处理和治疗类房间完成对病人的治疗工作。可以从" ..
    "建造药房开始。在药房中需要一名护士分配各种药品。",
  level6 =
    "使用您的所有知识来建造一个运行平稳的医院，从而可以赚取利润并处理任何问题。" ..
    "您需要注意一点，医院周围的空气对细菌繁殖，传染病流行非常适宜。" ..
    "如果您没有保持医院的清洁，则将面对传染病的流行。" ..
    "赚取$150,000，并使医院价值超过$140,000。",
  level12 =
    "您现在遇到了最大的挑战。" ..
    "我们为您的成功感到由衷地高兴，卫生部为您准备了一项顶级工作；他们需要有人建造另一个超级医院，赚钱的同时获取较高的声望。" ..
    "您可以购买任何需要的土地，治疗各种疾病赢得各种奖励。" ..
    "动心了吗？" ..
    "赚取$650,000，治愈750个病人，使声望达到800就可以胜利过关。",
  level3 =
    "这次您将在一个富裕地区建造医院。" ..
    "卫生部希望您能够在这里赚取更多的利润。" ..
    "开始时您被要求获取好的声望，但是一旦医院步入正轨，就可以集中精力赚取更多的钱。" ..
    "有可能会发生紧急事件。" ..
    "也就是说一次会有大量病人就诊，且他们的病情都一样。" ..
    "在时间限制内如果能够治愈他们，则不仅可以拿到奖金，声望也会提高。" ..
    "一些疾病如猫王综合症等有可能发生，因此最好建造一间手术中心和附属病房。" ..
    "胜利条件是赚取$20,000。",
  level10 =
    "随着您的经验不断增长，卫生部要求您集中精力提高药品的治疗效果。" ..
    "有人对您颇有微辞，为此您必须使所有的药物都非常有效。" ..
    "另外，一定要降低医疗事故的发生次数，减少死亡人数。" ..
    "作为提示，您需要为建造胶桶留一些空地。" ..
    "使所有药物的疗效都达到80%%，声望达到650且在银行帐户上有$500,000，这样就可以胜利过关。",
  level11 =
    "现在您有机会建造一座终极医院。" ..
    "该地区享有极高的声望，因此卫生部希望能够看到最好的医院建造在这里。" ..
    "我们希望您能够赚取大量的金钱，获得很高的声望，并能够成功地处理任何事件。" ..
    "这是一项非常重要的工作。" ..
    "这需要您的努力工作。" ..
    "注意一点，该区域常常会看到不明飞行物。因此请让您的员工做好准备迎接不速之客。" ..
    "您的医院价值需要达到$240,000，在银行帐户内需要$500,000，且声望需要达到700。",
  level18 = "",
}
humanoid_name_starts = {
  [1] = "欧得",
  [2] = "黑尔",
  [3] = "安德",
  [4] = "本",
  [5] = "班",
  [6] = "比尔",
  [7] = "维",
  [8] = "瓦特",
  [9] = "宝得",
  [10] = "金",
  [11] = "巴",
  [12] = "派特",
  [13] = "曼",
  [14] = "宝艾",
  [15] = "沃",
  [16] = "杰克",
  [17] = "克来伯",
  [18] = "费什",
  [19] = "瓦特",
  [20] = "米尔",
  [21] = "白",
  [22] = "芬",
  [23] = "里奇",
  [24] = "斯科特",
  [25] = "伯尔",
  [26] = "派克",
  [27] = "科",
  [28] = "维特",
  [29] = "比恩",
  [30] = "宝恩",
  [31] = "伯格",
  [32] = "怀特",
  [33] = "科尔",
}
transactions = {
  severance = "隔离花费",
  research = "研究花费",
  eoy_trophy_bonus = "年度物品奖励",
  buy_object = "购买物品",
  cure_colon = "治疗：",
  epidemy_coverup_fine = "隐瞒传染病罚款",
  final_treat_colon = "最终治疗：",
  jukebox = "收入：音乐盒",
  loan_interest = "贷款利率",
  overdraft = "透支利率",
  wages = "工资",
  loan_repayment = "贷款偿还",
  personal_bonus = "支付个人奖金",
  drug_cost = "药品花费",
  cure = "治愈",
  heating = "供暖费",
  treat_colon = "治疗：",
  compensation = "政府赔偿金",
  epidemy_fine = "传染病罚款",
  buy_land = "购买土地",
  research_bonus = "研究奖金",
  general_bonus = "支付一般奖金",
  deposit = "治疗收入",
  eoy_bonus_penalty = "年度奖金/罚款",
  cheat = "骗钱",
  drinks = "收入：饮料机",
  vaccination = "接种疫苗",
  advance_colon = "进阶：",
  vip_award = "贵宾现金奖励",
  hire_staff = "雇佣员工",
  bank_loan = "银行贷款",
  machine_replacement = "更换机器花费",
  emergency_bonus = "支付紧急事件奖金",
  build_room = "建造房屋",
  insurance_colon = "保险费：",
  sell_object = "卖出物品",
}
object = {
  chair = "椅子",
  sofa = "沙发",
  operating_table = "手术台",
  bed2 = "床",
  bench = "长椅",
  scanner = "扫描仪",
  couch = "长沙发椅",
  blood_machine = "血液机器",
  table1 = "桌子",
  video_game = "电视游戏",
  lamp = "灯",
  op_sink2 = "洗手池",
  door = "房门",
  auto_autopsy = "自动验尸仪",
  reception_desk = "接待台",
  hair_restorer = "毛发恢复机",
  projector = "放映机",
  crash_trolley = "诊断仪器小推车",
  tv = "电视机",
  ultrascanner = "超级扫描仪",
  surgeon_screen = "外科屏风",
  litter_bomb = "垃圾炸弹",
  inflator = "充气机",
  table2 = "桌子",
  desk = "办公桌",
  pool_table = "台球桌",
  x_ray_viewer = "X光透视仪",
  radiation_shield = "射线防护",
  bed = "床",
  swing_door2 = "转门",
  console = "控制台",
  op_sink1 = "洗手池",
  bookcase = "书柜",
  drinks_machine = "饮料机",
  comfortable_chair = "舒适座椅",
  skeleton = "骨骼模型",
  computer = "计算机",
  bin = "垃圾桶",
  pharmacy_cabinet = "医药柜",
  radiator = "暖气",
  cast_remover = "石膏剥离装置",
  atom_analyser = "原子分析仪",
  plant = "植物",
  jelly_moulder = "胶桶",
  cardio = "心电图仪",
  toilet = "厕所",
  electrolyser = "电分解机器",
  fire_extinguisher = "灭火器",
  bed3 = "床",
  swing_door1 = "转门",
  lecture_chair = "演讲座位",
  screen = "屏风",
  toilet_sink = "洗手池",
  shower = "淋浴",
  gates_of_hell = "地狱之门",
  entrance_right = "左入口",
  entrance_left = "右入口",
  slicer = "舌头治疗机",
  dna_fixer = "DNA修复装置",
  x_ray = "X光机",
  cabinet = "文件柜",
}
letter = {
  [1] = {
    [1] = "亲爱的%s//",
    [2] = "太令人惊奇了！您已经成功地经营了这个医院。卫生部的官员想要知道您是否有兴趣接手一个大项目。我们认为有一个工作对您很适合。薪水将达到$%d。怎么样。//",
    [3] = "您是否对%s医院的工作感兴趣？",
  },
  [2] = {
    [1] = "亲爱的%s//",
    [2] = "太棒了！您的医院经营得很好。我们又有了一些新的任务如果您喜欢新的挑战，可以接受这项任务。您不要勉强，但这项工作确实很适合您。薪水是$%d//",
    [3] = "您希望接管%s医院吗？",
  },
  [3] = {
    [1] = "亲爱的%s//",
    [2] = "在您接管这座医院期间，管理非常成功。因此，我们对您寄予厚望，并为您找到了一个新的工作。薪水将达到$%d，同时我们也希望您喜欢新的挑战。//",
    [3] = "您希望接手%s医院吗？",
  },
  [4] = {
    [1] = "亲爱的%s//",
    [2] = "恭喜！部门官员对您的能力赞不绝口。您是卫生部的第一高手。我们觉得您一定喜欢更困难的工作。您的薪水将达到$%d，但决定权在您手中。//",
    [3] = "您是否愿意在%s医院工作？",
  },
  [5] = {
    [1] = "亲爱的%s//",
    [2] = "您好。我们尊重您不希望离开这个迷人的医院，但是提醒您要仔细考虑。您的薪水将达到$%d，如果您愿意到其它医院工作并将其运行得很好。//",
    [3] = "您现在是否愿意移动到%s医院？",
  },
  [6] = {
    [1] = "亲爱的%s//",
    [2] = "恭喜。我们理解您在这个可爱的运行良好医院中工作的快乐心情，但是我们认为您现在应该为未来考虑。您的薪水将达到$%d，如果您决定调任。这是很值得考虑的。//",
    [3] = "您是否愿意接手%s医院？",
  },
  [7] = {
    [1] = "亲爱的%s//",
    [2] = "您好！卫生部想要知道您经过重新考虑是否决定仍然留在当前的医院中。我们很欣赏您现在那个可爱的医院，但我们觉得您如果愿意接受这个极富挑战性的工作，也一定能干得很好，并且您的薪水将达到$%d。//",
    [3] = "您是否愿意接手%s医院？",
  },
  [8] = {
    [1] = "亲爱的%s//",
    [2] = "您好。您否定了我们上一封信中提供的新医院，以及薪水$%d。我们觉得不论怎样，您必须重新考虑这个决定。我们已经为您准备了一个很好的工作。//",
    [3] = "您是否愿意接手%s医院？怎么样？",
  },
  [9] = {
    [1] = "亲爱的%s//",
    [2] = "您已经成功地证明了自己是医学界有史以来最棒的管理者。这样的成就一定要给予奖励，因此我们决定任命您为所有医院的至尊主席。这是一项光荣的工作，且薪水可以达到$%d。不论您走到那里，都将受到人们的热烈欢迎。//",
    [3] = "感谢您的努力工作。希望您好好享受未来的半退休生活。//",
    [4] = "",
  },
  [10] = {
    [1] = "亲爱的%s//",
    [2] = "恭喜您在我们指派的每个医院中的成功管理。您的成功表现使您可以自由出入世界各大城市。您将获得退休金$%d，再加上一辆轿车，我们希望您在旅途中能够促进各个医院管理水平的提高。//",
    [3] = "我们都为您感到骄傲。我们中间每个人都为您挽救生命感到由衷的感谢。//",
    [4] = "",
  },
  [11] = {
    [1] = "亲爱的%s//",
    [2] = "您的工作十分成功，我们从您身上获得了灵感。谢谢您管理了这么多个医院，并使它们都运行得很出色。我们将给予您终身工资$%d，并提供政府敞蓬轿车使您可以从一个城市到另一个城市，发表演讲告诉公众您是怎样在这么短的时间内达到如此成就。//",
    [3] = "您是所有人的榜样，毫无例外，世界上每个人都以您为荣。//",
    [4] = "",
  },
  [12] = {
    [1] = "亲爱的%s//",
    [2] = "您的成就使您成为最好的医院管理者。卫生部将向您提供$%d作为奖励，并召开庆祝会。整个世界都在为您沸腾，太棒了！//",
    [3] = "请接受我们的安排。如果您不再希望辛苦工作，我们将向您提供一辆轿车，且无论走到那里，都有警察为您开路。//",
    [4] = "",
  },
}
high_score = {
  categories = {
    deaths = "死亡人数",
    total_value = "总价值",
    money = "最富有",
    cures = "治愈人数",
    visitors = "访问者最多",
    staff_number = "员工数目最多",
    cure_death_ratio = "医治无效死亡率",
    patient_happiness = "顾客满意",
    staff_happiness = "员工满意",
    salary = "工资最高",
    clean = "最干净",
  },
  player = "玩家",
  score = "分数",
  pos = "名次",
  best_scores = "荣誉堂",
  worst_scores = "耻辱堂",
  killed = "杀死病人数目",
}
menu_file_save = {
  [1] = " 存档一 ",
  [2] = " 存档二 ",
  [3] = " 存档三 ",
  [4] = " 存档四 ",
  [5] = " 存档五 ",
  [6] = " 存档六 ",
  [7] = " 存档七 ",
  [8] = " 存档八 ",
}
build_room_window = {
  pick_room_type = "选择房间类型",
  pick_department = "选择部门",
  cost = "花费：",
}
menu = {
  debug = "除错",
  display = "显示",
  file = "文件",
  options = "选项",
  charts = "图表",
}
menu_display.shadows = "  影子  "
menu_display.mcga_lo_res = "  MCGA低分辨率  "
cheats_window.cheats.earthquake = "制造地震"
confirmation.maximum_screen_size = "你使用的分辨率比 3000 x 2000 大。大的分辨率是可行的，但是要维持一个可以接受的帧率你需要好点的硬件。是否继续？"
confirmation.music_warning = "選擇MP3檔為你的音樂之前，你需要有 smpeg.dll 或者你的作業系統的版本，否則你在遊戲裡不會有任何音樂。是否繼續?"
menu_options_wage_increase.deny = "    拒绝 "
menu_options_wage_increase.grant = "    允许 "
tooltip.options_window.select_language = "选择语言"
tooltip.options_window.select_resolution = "选择分辨率"
tooltip.options_window.language_dropdown_item = "选择 %s 为语言"
tooltip.options_window.audio_button = "开关所有的声音"
tooltip.options_window.resolution = "在此分辨率下运行游戏"
tooltip.options_window.audio_toggle = "开关"
tooltip.options_window.fullscreen = "應該在全屏還是窗口模式運行"
tooltip.options_window.apply = "应用此分辨率"
tooltip.options_window.cancel = "取消"
tooltip.options_window.folder_button = "文件夹选项"
tooltip.options_window.customise_button = "更多可以改变游戏体验的选项"
tooltip.cheats_window.cheats.earthquake = "制造地震"
tooltip.new_game_window.difficulty = "选择游戏难度"
tooltip.new_game_window.player_name = "输入你游戏中的名字"
tooltip.new_game_window.start = "使用当前设置开始游戏"
tooltip.update_window.download = "前往下载页面下载CorsixTH"
tooltip.update_window.ignore = "忽略这次更新。你将在下次启动CorsixTH时再次被通知"
tooltip.folders_window.browse_font = "寻找另一个字体 ( 现在的位置: %1% )"
tooltip.folders_window.screenshots_location = "屏幕截图默认和设置文件在一起。如果不想这样，选择你想存储屏幕截图的位置。"
tooltip.folders_window.reset_to_default = "重置到默认选项"
tooltip.folders_window.back = "关闭及返回选项菜单"
tooltip.folders_window.music_location = "选择存储MP3文件的位置. 此目录必须已经存在."
tooltip.folders_window.font_location = "选择可以显示你的语言所需Unicode字体的位置,如果没有指定，你将不能使用原游戏提供字体之外的语言,例如中文和俄语.（你一定已经选了,要不怎么可以看到这句话呢?）"
tooltip.folders_window.savegames_location = "游戏存档默认和设置文件在一起。如果不想这样，选择你想存储游戏存档的位置。"
tooltip.folders_window.browse_data = "寻找主题医院安装位置 ( 現在的位置: %1% )"
tooltip.folders_window.browse = "寻找文件夹的位置"
tooltip.folders_window.browse_screenshots = "寻找另一个储存屏幕截图的位置 ( 现在的位置: %1% )"
tooltip.folders_window.browse_music = "寻找另一个存储音乐的位置 ( 现在的位置: %1% )"
tooltip.folders_window.no_font_specified = "没有指定字体的位置！"
tooltip.folders_window.not_specified = "没有指定文件夹位置！"
tooltip.folders_window.browse_saves = "寻找另一个储存游戏存档的位置  ( 现在的位置: %1% ) "
tooltip.folders_window.default = "默认位置"
tooltip.folders_window.data_location = "需要用来运行CorsixTH的主题医院的位置"
tooltip.customise_window.aliens = "因为缺少动画,默认设置下外星人DNA病人只会从紧急事件中来. 要在紧急事件以外允许有外星人DNA的病人来你的意愿,请关闭此选项。"
