# D.11 Can politics and economics be separated from each other?

A key aspect of anarchism is the idea that the political and economic aspects
of society cannot be separated. [Section D](secDcon.md) has been an attempt
to show how these two aspects of society interact and influence each other.
This means that economic liberty cannot be separated from political liberty
and vice versa. If working class people are subject to authoritarian political
organisations then their economic liberty will likewise be restricted and,
conversely, if their economic freedoms are limited then so, too, will their
political freedoms. As Proudhon put it, _"industrial liberty is inseparable
from political liberty."_ [quoted by Alan Ritter, **The Political Thought of
Pierre-Joseph Proudhon**, p. 188]

Some disagree, arguing that economic liberty is of primary importance. When
Milton Friedman died in 2006, for example, many of his supporters parroted his
defence of working with the Pinochet regime and noted that Chile had
(eventually) become a democracy. For Friedman, this justified his praise for
the "economic liberty" the regime had introduced and rationalised the advice
he gave it. For him, Chile provided his earlier assertion that _"economic
freedom is an indispensable means toward the achievement of political
freedom."_ For while Friedman stated that there was _"an intimate connection
between economics and politics,"_ he meant simply that capitalism was required
to produce democracy (to use his words, _"capitalism is a necessary condition
for political freedom"_). [**Capitalism and Freedom**, p. 8 and p. 10]

So it should first be stressed that by "economic liberty" Friedman meant
capitalism and by "political liberty" he meant representative government and a
democratic state. Anarchists would disagree that either of those institutions
have much to do with genuine liberty. However, we will ignore this for the
moment and take his general point. Sadly, such a position makes little sense.
In fact, Friedman's separation of "economic" and "political" liberties is
simply wrong as well as having authoritarian implications and lacking
empirical basis.

The easiest way of showing that statism and capitalism cannot be separated is
to look at a country where "economic liberty" (i.e. free market capitalism)
existed but "political liberty" (i.e. a democratic government with basic human
rights) did not. The most obvious example is Pinochet's Chile, an experiment
which Friedman praised as an "economic miracle" shortly before it collapsed.
In [section C.11](secC11.md) we discussed the Chilean "economic miracle" at
face value, refusing to discuss the issue of whether describing the regime as
one of "economic liberty" could be justified. Rather, we exposed the results
of applying what leading ideologues of capitalism have called "free market"
policies on the country. As would be expected, the results were hardly an
"economic miracle" if you were working class. Which shows how little our lives
are valued by the elite and their "experts."

As to be expected with Friedman, the actual experience of implementing his
economic dogmas in Chile refuted them. Much the same can be said of his
distinction of "economic" and "political" liberty. Friedman discussed the
Chilean regime in 1991, arguing that _"Pinochet and the military in Chile were
led to adopt free market principles after they took over only because they did
not have any other choice."_ [**Economic Freedom, Human Freedom, Political
Freedom**] This is an interesting definition of _"free market principles."_ It
seems to be compatible with a regime in which the secret police can seize
uppity workers, torture them and dump their bodies in a ditch as a warning to
others.

For Friedman, the economic and political regimes could be separated. As he put
it, _"I have nothing good to say about the political regime that Pinochet
imposed. It was a terrible political regime. The real miracle of Chile is not
how well it has done economically; the real miracle of Chile is that a
military junta was willing to go against its principles and support a free
market regime designed by principled believers in a free market."_ [**Op.
Cit.**] How, exactly, could the political regime **not** impact on the
economic one? How is a "free market" possible if people who make up the labour
market are repressed and in fear of their lives? True, the Chilean workers
could, as workers in Tsarist Russia, _"change their jobs without getting
permission from political authorities"_ (as Friedman put it [**Capitalism and
Freedom**, p. 10]), however this is only a small part of what anarchists
consider to be genuine economic liberty.

To see why, it is useful to show a snapshot of what life was like under
Friedman's "economic liberty" for working class people. Once this is done, it
is easy to see how incredulous Friedman was being. Peter Winn gives a good
description of what Chile's "economic liberty" was based on:

> _"In the wake of the coup, most of the 'revolutionary' leaders of the
textile workers disappeared, some to unmarked graves, jails, or concentration
camps, others to exile or the underground resistance. Moreover, when the
textile factories resumed production, it was under military administration and
with soldiers patrolling the plants. Authoritarian management and industrial
discipline were reimposed at the point of a bayonet, and few workers dared to
protest. Some feared for their lives or liberty; many more feared for their
jobs. Military intelligence officers interrogated the workers one by one,
pressing them to inform on each other and then firing those considered to be
leftist activists. The dismissals often continued after the mills were
returned to their former owners, at first for political reasons or for
personal revenge, but, with the recession of 1975, for economic motives as
well. The unions, decimated by their leadership losses, intimidated by the
repression, and proscribed by military decree from collective bargaining,
strikes, or other militant actions, were incapable of defending their members'
jobs, wages, or working conditions. With wages frozen and prices rising
rapidly, living standards fell precipitously, even for those fortunate enough
to keep their jobs."_ [_"No Miracle for Us"_, Peter Winn (ed.), **Victims of
the Chilean Miracle: Workers and Neoliberalism in the Pinochet Era,
1973-2002**, p. 131]

In the copper mines, _"[h]undreds of leftist activists were fired, and many
were arrested and tortured . . . the military exercised a firm control over
union leaders and activity within the unions remained dormant until the
1980s."_ The _"decade following the military coup was defined by intense
repression and a generalised climate of terror and fear."_ Workers recalled
that people who spoke at union meetings were detained and until 1980 police
permission was required to hold a meeting, which was held under police
supervision. At work, _"supervisors and foremen ruled with an authoritarian
discipline"_ while miners _"reported that spies denounced workers who talked
politics or spoke at union meetings to the company administration and
police."_ [Thomas Miller Klubock, _"Class, Community, and Neoliberalism in
Chile"_, Winn (ed.), **Op. Cit.**, p. 214 p. 216 and p. 217]

Over all, Workers _"bore the brunt of the repression during the military take-
over and throughout the Pinochet regime. The armed forces viewed workers --
and the level of organisation they had achieved under previous governments --
as the greatest threat to traditional power structure in Chile . . . Armed
troops went after workers in general and union members and leaders in
particular with a virulence that contradicted their claim to be stamping out
'class hatred.'"_ As for the relationship between "economic" and "political"
liberty, the latter was dependent on the end of the former: _"Fear of
repression was clearly essential to the implementation of free-market labour
policies, but far more pervasive was the fear of unemployment"_ generated by
the so-called "economic miracle." [John Lear and Joseph Collins, _"Working in
Chile's Free Market"_, pp. 10-29, **Latin American Perspectives**, vol. 22,
No. 1, pp. 12-3 and p. 14]

Thus the ready police repression made strikes and other forms of protest both
impractical and dangerous. When working class people did take to the streets
after the economic crash of 1982, they were subject to intense state
repression as Pinochet _"cracked down, sending in army troops to curb the
demonstrators."_ According to a report by the Roman Catholic Church 113
protesters had been killed during social protest, with several thousand
detained for political activity and protests between May 1983 and mid-1984.
Thousands of strikers were also fired and union leaders jailed. [Rayack, **Op.
Cit.**, p. 70] In fact, the _"brutal government repression put even the
militant copper miners on the defensive."_ [Winn, _"The Pinochet Era"_, Winn
(ed.), **Op. Cit.**, p. 43] Workers were aware that the regime _"was likely to
use the full rigour of the law against workers who acted in defence of their
interests. Moreover, even though the arbitrary actions of the secret police
diminished in the last years of the dictatorship, they did not disappear, nor
did their internalised legacy. Fear of becoming a target of repression still
exercised a chilling effect on both workers and their leaders."_ [Winn, _"No
Miracle for Us"_, Winn (ed.), **Op. Cit.**, p. 133]

All of which puts into stark light Friedman's 1982 comment that _"Chile is an
even more amazing political miracle. A military regime has supported reforms
that sharply reduce the role of the state and replace control from the top
with control from the bottom."_ [quoted by Rayack, **Not so Free to Choose**,
p. 37] Clearly Friedman had no idea what he was talking about. While the
_"role of the state"_ **was** reduced in terms of welfare for the masses, it
was obviously massively **increased** in terms of warfare against them (we
will address the _"control from the bottom"_ nonsense shortly).

For anarchists, it is simply common-sense that "economic liberty" cannot exist
within an authoritarian state for the mass of the population. In reality, the
economic and political regime cannot be so easily compartmentalised. As
Malatesta noted, _"every economic question of some importance automatically
becomes a political question . . . Workers' organisations must therefore, of
necessity, adopt a line of action in face of present as well as possible
future government action."_ [**Errico Malatesta: His Life and Ideas**, pp.
130-1] Such common-sense is sadly lacking with Friedman who seriously seems to
believe that "economic liberty" could exist without the freedom of workers to
take collective action if they so desired. In other words, the "economic
miracle" Friedman praises was built on the corpses, fears and backs of working
class people. Unlike Friedman, Chile's workers and bosses know that
_"employers could count on the backing of the military in any conflict with
workers."_ [Lear and Collins, **Op. Cit.**, p. 13] As can be seen, Malatesta
had a much firmer grasp of the question of liberty that Friedman, as expected
as the latter equals it with capitalism and its hierarchies while the former
spent much of his live in prison and exile trying to increase the freedom of
working class people by fighting the former and the state which maintains
them.

As we argued in [section D.1.4](secD1.md#secd14), laissez-faire capitalism
does not end statism. Rather it focuses it on purely defending economic power
(i.e. "economic liberty" for the capitalist class). The example of Chile's
"economic liberty" proves this beyond doubt and shows that the separation of
economic and political freedom is impossible and, consequently, both
capitalism **and** the state need to be fought and, ultimately, abolished.

## D.11.1 What does Chile tell us about the right and its vision of liberty?

The key to understanding how Friedman managed to ignore the obvious lack of
"economic liberty" for the bulk of the population under Pinochet lies in
remembering that he is a supporter of capitalism. As capitalism is a
hierarchical system in which workers sell their liberty to a boss, it comes as
no real surprise that Friedman's concern for liberty is selective.

Pinochet did introduce free-market capitalism, but this meant real liberty
only for the rich. For the working class, "economic liberty" did not exist, as
they did not manage their own work nor control their workplaces and lived
under a fascist state. The liberty to take economic (never mind political)
action in the forms of forming unions, going on strike, organising go-slows
and so on was severely curtailed by the very likely threat of repression. Of
course, the supporters of the Chilean "Miracle" and its "economic liberty" did
not bother to question how the suppression of political liberty effected the
economy or how people acted within it. They maintained that the repression of
labour, the death squads, the fear installed in rebel workers could be ignored
when looking at the economy. But in the real world, people will put up with a
lot more if they face the barrel of a gun than if they do not. So the claim
that "economic liberty" existed in Chile makes sense only if we take into
account that there was only **real** liberty for one class. The bosses may
have been "left alone" but the workers were not, unless they submitted to
authority (capitalist or state). Hardly what most people would term as
"liberty".

Beyond the ideologues of capitalism who term themselves "economists," it is
generally admitted that the "labour market," if it exists, is a somewhat
unique market. As "labour" cannot be separated from its owner, it means that
when you "buy" labour you "buy" the time, and so liberty, of the individual
involved. Rather than be bought on the market all at once, as with a slave,
the wage slave's life is bought piecemeal. This is the key to understanding
Friedman's nonsensical claims for never forget that by "economic freedom" he
means capitalism. To understand the difference we need only compare two of
Friedman's arguments to the reality of capitalism. Once we do that then his
blindness to Chile's neo-liberal dictatorship's impact on genuine economic
liberty becomes clear.

The most obvious fallacy within his argument is this assertion:

> _"A characteristic feature of a free private market is that all parties to a
transaction believe that they are going to be better off by that transaction.
It is not a zero sum game in which some can benefit only at the expense of
others. It is a situation in which everybody thinks he is going to be better
off."_ [**Economic Freedom, Human Freedom, Political Freedom**]

Who can deny that the worker who sells her liberty to the autocrat of a
capitalist firm is _"going to be better off"_ than one starving to death? As
we noted in [section B.4.1](secB4.md#secb41), Friedman avoids the obvious
fact that a capitalist economy is dependent on there being a class of people
who have no means of supporting themselves **except** by selling their labour
(i.e. liberty). While full employment will mitigate this dependency (and, as a
result, bring the system to crisis), it never goes away. And given that
Pinochet's _"free market regime designed by principled believers in a free
market"_ had substantial unemployment, it is unsurprising that the capitalist
was _"better off"_ than the worker as a result. As the experience of the
_"free private market"_ in Chile suggests, workers need to be free to organise
without the fear of death squads otherwise they will be oppressed and
exploited by their bosses. By denying that freedom, Pinochet's regime could
only be considered "free" by the ideologues and savants of capitalism. The
only positive thing that can be said is that it provided empirical evidence
that the ideal neo-classical labour market would increase inequality and
exploitation (see [section C.11.3](secC11.md#secc113)).

The problem with Friedman's argument is that he fails to recognise the
hierarchical nature of capitalism and the limited liberty it produces. This
can be seen from Friedman's comparison of military dictatorships to
capitalism:

> _"Almost all military juntas are adverse to economic freedom for obvious
reasons. The military is organised from the top down: the general tells the
colonel, the colonel tells the captain, the captain tells the lieutenant, and
so on. A market economy is organised from the bottom up: the consumer tells
the retailer, the retailer tells the wholesaler, the wholesaler tells the
producer, and the producer delivers. The principles underlying a military
organisation are precisely the reverse of those underlying a market
organisation."_ [**Op. Cit.**]

Obviously geometry was not Friedman's strong point. A "market economy" is
characterised by **horizontal** links between workplaces and consumers, not
vertical ones. However, the key issue is that the dominant _"market
organisation"_ under capitalism **_is_** marked by the _"principles underlying
a military organisation."_ To present a more accurate picture than Friedman,
in the _"market organisation"_ of a capitalist firm the boss tells the worker
what to do. It is _"organised from the top down"_ just as a military junta is.
That Friedman ignores the organisational structure which 90% of the population
have to operate within for most of their waking hours is significant. It shows
how little he understands of capitalism and "economic freedom."

In Pinochet's Chile, the workplace **did** become more like _"a military
organisation."_ Without effective unions and basic human rights, the bosses
acted like the autocrats they are. Discussing the textile industry, Peter Winn
notes that _"most mill owners took full advantage of the regime's probusiness
Labour Code . . . At many mills, sweatshop conditions prevailed, wages were
low, and management was authoritarian, even tyrannical . . . Workers might
resent these conditions, but they often felt powerless to oppose them.
Informers and the threat of dismissal kept even alienated and discontented
workers in line."_ [_"No Miracle for Us"_, Winn (ed.), **Op. Cit.**, p. 132
and pp. 132-3] John Lear and Joseph Collins generalise the picture, noting
that _"[i]n wake of the coup, factory owners suddenly had absolute control
over their workers and could fire any worker without case. From 1973 through
1978, practically every labour right for organised and unorganised workers was
suspended. All tools of collective bargaining, including of course the right
to strike, were outlawed."_ [**Op. Cit.**, p. 13] The Junta themselves had no
illusions about the military-like regime they desired within the workplace,
stating in 1974 its intention of _"imposing authority and discipline in
production and labour relations."_ [quoted by Joseph Collins and John Lear,
**Chile's Free-Market Miracle: A Second Look**, p. 27]

The reality of life under Pinochet for working class people should make anyone
with sense wary of praising the regime in any way, but Friedman argued that
the _"results were spectacular. Inflation came down sharply. After a
transitory period of recession and low output that is unavoidable in the
course of reversing a strong inflation, output started to expand, and ever
since, the Chilean economy has performed better than any other South American
economy."_ [**Op. Cit.**] Of course, by downplaying the deep recession caused
by applying his recommended _"shock-treatment"_ policies, Friedman can confuse
the high growth resulting from coming out of the boom combined with ready
repression on labour with sound economic policies. Strangely he failed to
mention the _"spectacular"_ recession of 1982 which wiped out the gains of
1976 to 1981. As indicated in [section C.11](secC11.md), looking over the
whole of the Pinochet period the results were hardly _"spectacular"_ (unless
you were rich) and the moderate gains were paid for by the working class in
terms of longer hours, lower pay and political and economic oppression.

In other words, Friedman and the 'Chicago boys' provided an appearance of
technical respectability to the dreams, greed and power of the landlords and
capitalists who made up the Chilean oligarchy. The military simply applied the
brutal force required to achieve those goals. As such, there is only an
apparent contradiction between political tyranny and "economic liberty," not a
real one. Repression for the working class and "economic liberty" for the
elite are two sides of the same coin.

This should be common-sense and, as such, it is nonsensical for the likes of
Friedman to support an economic policy while pretending to reject the system
of terror it required to implement. After all, economic policies do not occur
in a social and political vacuum. They are conditioned by, and at the same
time modify, the social and political situation where they are put into
practice. Thus there cannot be "economic liberty" for workers if they expect a
visit from the secret police if they talk back to their boss. Yet for Friedman
and those like him, there seems to be a lack of awareness of such basic and
obvious facts. There is a necessary connection between economic policy (and
its outcome) and the socio-political setting in which it is implemented.

Friedman exposes the utter hypocrisy of the supporters of capitalism. His
myopia about the reality of the regime was expressed in articles which amount
to little more than apologetics for the dictatorship. For example, in 1982 he
noted in response to the economic problems of the previous year _"the
opposition to the free-market policies that had been largely silence by
success is being given full voice."_ [quoted by Rayack, **Op. Cit.**, p. p.
63] No mention that the real cause of the _"silence"_ of the opposition was
not the _"success"_ of policies which had impoverished the working class and
enriched the elite but, rather, the expectation of a visit by the secret
police. Given that Pinochet had sent murder squads to kill prominent
dissidents abroad, Friedman's comments are incredulous -- particularly as
Allende's former foreign minister, Orlando Letelier, was assassinated in
Washington in 1976 by a car bomb.

The state terror, the violation of human rights and drastic control and
suppression of every form of meaningful dissent is discussed (and often
condemned) as something only indirectly linked, or indeed entirely unrelated,
to the economic policies that the military imposed. To publicly praise and
support the economic policies adopted by the dictatorship while regretting its
political regime is simply illogical hypocrisy. However, it does expose the
limited nature of the right's concept of liberty as well as its priorities and
values.

## D.11.2 But surely Chile proves that "economic freedom" creates political
freedom?

As noted above, Friedman defended his praise for the Pinochet regime by
arguing that its "economic liberty" helped produce the end of the
dictatorship. In the words of Friedman:

> _"The economic development and the recovery produced by economic freedom in
turn promoted the public's desire for a greater degree of political freedom .
. . In Chile, the drive for political freedom, that was generated by economic
freedom and the resulting economic success, ultimately resulted in a
referendum that introduced political democracy. Now, at long last, Chile has
all three things: political freedom, human freedom and economic freedom. Chile
will continue to be an interesting experiment to watch to see whether it can
keep all three or whether, now that it has political freedom, that political
freedom will tend to be used to destroy or reduce economic freedom."_ [**Op.
Cit.**]

It is hard to find an account so skewed by ideological blindness as this. The
notion that Chile's "free market" capitalism provided the base for eliminating
Pinochet's dictatorship is hard to defend. If it were true then we would
expect Pinochet's rule to be substantially shorter than other military
dictatorships in the region. However, this is **not** the case. For example,
Argentina's Military Junta lasted from 1976 to 1983, 7 years; Peru's 12 years
(1968 to 1980); Uruguay's 12 years (1973 to 1985); Bolivia's 18 years (1964 to
1982). Pinochet's lasted 17 years, exceeded by Brazil's 21 years (1964 to
1985). If Friedman's argument were valid then Pinochet would have fallen long
before the rest. In fact, Chile was one of the last Latin American countries
to return to democracy.

Nor can it be said that ending of the Pinochet regime was an automatic outcome
of economic forces. Rather, it was a product of struggle by ordinary people
who took to the streets in the early 1980s to protest in the face of state
repression. The regime was subject to popular pressures from below and these,
not capitalism, were the key factor. After all, it was not "economic liberty"
which produced the desire for "political freedom." Working class people could
remember what political freedom was before it was destroyed in order to create
Friedman's "economic liberty" and tried to recreate it.

In the face of state terror, political activists and trade unionists fought
the regime. The 1988 referendum Friedman alludes to was the product of this
heroic activity, not some abstract economic force. As Cathy Schneider points
out, the 1983-86 _"cycle of protests had set the stage for a negotiated
transition to democracy in 1990."_ These protests, it should be noted, were
subject to extreme state repression (one demonstration saw Pinochet send
18,000 troops onto the streets, who shot 129 people, 29 fatally, and tortured
some of the 1,000 arrested). [**Shantytown protest in Pinochet's Chile**, p.
194 and p. 165] Peter Winn, for example, notes _"the resistance of workers to
both the dictatorship and its neoliberal policies, often against great odds
and at great risks."_ In fact, _"during the Pinochet era, with its repression
and restrictions on union activism, Chile's workers displayed great creativity
in devising new ways to resist . . . Nor was this resistance confined to the
workplace or workers' issues . . . it was Chile's workers who first raised the
flag of political resistance against the dictatorship in the 1970s and
sustained it during the years when political parties were banned. And it was
the copper miners who mobilised the social protests and political opposition
to the military regime in the 1980s to demand an end to Pinochet's
dictatorship and the restoration of democracy and civil liberties."_
[_"Introduction"_, Winn (ed.), **Op. Cit.**, p. 11] This is confirmed by John
Lear and Joseph Collins, who note that _"[d]uring the mid-1980s, unions were
fundamental to organising the national protests that led eventually to the
negotiations of the 1988 plebiscite."_ [**Op. Cit.**, p. 20]

This, it should be noted, has always been the case. Political freedoms have
**never** been given by the powers that be but rather won by long struggles by
working class people. This has always been the case, as Kropotkin stressed
basic political liberties were _"extorted from parliament by force, by
agitations that threatened to become rebellions. It was by establishing trade
unions and practising strike action despite the edicts of Parliament and the
hangings"_ that workers _"won the right to associate and strike"_ in Britain
for example. [**Words of a Rebel**, pp. 123-4] To ignore that often heroic
struggle shows an ignorance about history which only matches an ignorance
about liberty. The history of capitalism is important in this regard. It first
developed under Absolutist states which used its power to bolster the position
of their capitalist class within both national (against the working class) and
international markets (against foreign competitors). As we discuss in [section
F.8](secF8.md), they actively intervened to create the pre-conditions for
generalised wage slavery before becoming a handicap to the rising bourgeoisie.
These regimes were generally replaced by liberal states with limited voting
rights which generally lifted the burden of state regulation from the
capitalist class. The working class had to fight long and hard to win basic
civil liberties and the vote. As Chomsky notes, such progress _"didn't just
happen; it happened through the struggles of the labour movement, and the
Civil Rights Movement, and the women's movement, and everything else. It's the
popular movements which expanded the domain of freedom of speech [and other
liberties] until it began to be meaningful."_ [**Understanding Power**, pp.
268-9]

Once these rights were won, the ruling elite has always turned to fascism to
control them once they started to threaten their power and wealth. This
obviously applies to Chile. Until the coup of 11 September 1973, Chile had
been seen increasing participation of the working class in economic and social
decision making. The coup was, simply, a massive class revenge of the wealthy
against a working class which had dared to imagine that another world was
possible. Unsurprisingly, given the key role of working class people in the
struggle for freedom, _"Worker leaders and activists . . . were central
targets of the military regime's state terror, whose goal was to intimidate
them into passivity, in large part so that neoliberal policies could be
imposed."_ [Peter Winn, _"Introduction"_, **Op. Cit.**, p. 12] Equally
unsurprising, those who had taken to the streets aimed for political freedom
in order to **end** the "economic liberty" imposed by the regime.

This means that Friedman's maxim that economic liberty is required to produce
political liberty is a deeply flawed position to take. Not only does it ignore
the popular struggles which have always had to be fought to end minority
government, it also allows its advocates to justify and work with
authoritarian regimes. At best, this position ensures that you will be
indifferent to the destruction of political freedom as long as "economic
liberty" (i.e. capitalism) was secured. At worse, it ensures that you would
actively support such a destruction as you can justify it in terms of a return
to "democracy" in the long run. Friedman and the "Chicago Boys" express both
ends of that spectrum. That he can comment on _"the paradox that economic
freedom produces political freedom but political freedom may destroy economic
freedom"_ in the context of Chile is staggering, as it was the destruction of
"political freedom" that allowed "economic freedom" (for the rich) to be
imposed. [**Op. Cit.**] In reality, Chile provides evidence to support the
alternative argument that the introduction of free market capitalism requires
the elimination or, at best, the reduction of "political liberty."

In other words, fascism was an ideal political environment to introduce
"economic liberty" **because** it had destroyed political liberty. Perhaps we
should conclude that the denial of political liberty is both necessary and
sufficient in order to create (and preserve) "free market" capitalism? After
all, the history of capitalism has been marked by the ruling class
overthrowing "political liberty" when their power was threatened by popular
movements. In other words, that Malatesta was right to argue that the
_"capitalists can maintain the struggle in the economic field so long as
workers demand small . . . improvements; but as soon as they see their profits
seriously diminished and the very existence of their privileges threatened,
they appeal to government and if it is not sufficiently understanding and not
strong enough to defend them . . . they use their own wealth to finance new
repressive forces and to set up a new government which will serve them
better."_ [**Op. Cit.**, p. 131]

Friedman's argument implies that "economic liberty" is more important than
"political liberty," so making people less concerned about dictatorships as
long as they support the interests of the capitalist class. While the long
list of capitalists, conservatives and right-wing ("classical") liberals who
supported fascism or fascist-like regimes shows that giving them an
ideological prop to justify it is unnecessary, it is hardly wise.

Then there is the question of whether Chile does, in fact, have genuine
political liberty (i.e. a democratic government). The answer is, not quite.
Chile's democracy is a "managed" one, constrained both by the political legacy
of Pinochet's constitution and the threat of military intervention.
Significantly, Friedman seems unconcerned about the quality of the post-
Pinochet democracy Chile experiences. Simply put, the existence of an
electoral regime cannot be confused with democracy or "political liberty."

It is clear that Pinochet went into the 1988 plebiscite expecting to win
(particularly as he tried to rig it like the 1980 one). According to many
reports from members of his cabinet and staff, he was absolutely furious and
wanted to annul the results. The popular backlash this would have created
ensured he abided by the result. Instead, he ensured that the new governments
had to accept his authoritarian constitution and decree-laws. In other words,
knowing he would be replaced he immediately took steps to limit the subsequent
democratically elected governments as well as remaining as the head of the
armed forces (as we discuss below, this obviously ensures the threat of a coup
hung over the new governments).

This means that post-Pinochet Chile is not your typical "democracy." Pinochet
became an unelected senator for life after his retirement as armed forces
commander in March 1998 and 28% of the Senate is _"designated,"_ including
four retired military officers named by the National Security Council.
Pinochet also imposed a _"unique binomial electoral law, [in] which to elect
two deputies or senators from the same district, a party or electoral alliance
needed to double its opponent's vote -- a difficult feat -- or else the
opponent received an equal number of seats in congress."_ This ensured
rightist control of the Senate despite a decade of majority victories by the
centre-left in elections and so _"Pinochet's 'designated senators' and
undemocratic electoral law continued to frustrate the popular will and limit
Chile's restored democracy."_ The majority could not _"pass laws without the
consent of its rightist opponents."_ Pinochet used _"final months as president
to decree laws that would hamstring his opponents, even if a majority of the
electorate supported them."_ In addition, any new government was _"confronted
by a judiciary and government bureaucracy packed by Pinochet with his own
adherents. Moreover, the Right enjoyed a near monopoly of the press and media
that grew as the decade advanced."_ [Winn, _"The Pinochet Era"_, **Op. Cit.**,
p. 64 and p. 49]

Thus Chile is lumbered with Pinochet's legacy, _"the authoritarian
constitution of 1980, which sought to create a 'protected democracy' under
military tutelage. It was written so as to be difficult to amend and designed
to handcuff a future opposition government and frustrate popular will."_ It
_"removed the military from civilian control, while submitting future elected
governments to a military-dominated National Security Council with a vague but
broad purview."_ It also _"banned measures against private property."_ With
some _"relative minor modifications of some of its most egregious features
during the transition to democracy"_ it remained _"in effect for the rest of
the century"_ and in 2004 was _"still Chile's fundamental charter."_ [Winn,
**Op. Cit.**, p. 30] This constitution built upon the work of
right-"libertarian" Friedrich von Hayek and, unsurprisingly aimed to insulate
"economic liberty" from popular pressures, i.e. to limit and reduce democracy
to secure the freedom of capitalism (and, of course, the capitalist class).

In addition, the threat of military intervention is always at the forefront of
political discussions. For example, on 11 September 1990, Pinochet _"warned
that he would lead another coup is conditions warranted it. In 1993, when
investigations into an arms procurement scandal implicated his son, Pinochet
ordered combat-ready troops and tanks onto the streets for an 'exercise' . . .
Throughout the Aylwin presidency, Pinochet maintained an army 'shadow cabinet'
that acted as a political pressure group."_ Unsurprisingly, the first post-
Pinochet government _"often backed down in practice for the sake of social
peace -- or out of fear of endangering the transition to democracy. As a
result, Aylwin was unable to fulfil his promises of constitutional and
institutional reforms that would reverse Pinochet's authoritarian legacy."_
This was because the new government thought that the coup and dictatorship
_"reflected the decision of business elites to call in the military, because
they could not protect their core interests under Chile's radicalised
democracy. The lesson that . . . [they] drew . . . was that to avoid its
repetition in the 1990s it was necessary to reassure business that its
interests would be protected."_ [Winn, **Op. Cit.**, p. 50 and p. 53]

The limited nature of Chile's democracy was seen in 1998, when Pinochet was
arrested in Britain in regard of a warrant issued by a Spanish Judge for the
murders of Spanish citizens during his regime. Commentators, particularly
those on the right, stressed that Pinochet's arrest could undermine Chile's
"fragile democracy" by provoking the military. In other words, Chile is only a
democracy in-so-far as the military let it be. Of course, few commentators
acknowledged the fact that this meant that Chile was not, in fact, a democracy
after all.

All of which explains why subsequent governments have only tinkered with the
free-market policies introduced by Pinochet. They have dared not reverse them
not due to their popular nature but to the obvious fact that recent Chilean
history shows that progressive politicians and their supporters have something
to fear besides losing an election. Unsurprisingly, workers _"socio-economic
aspirations were postponed in the interest of not jeopardising the transition
and their expectations of labour law reform were sacrificed on the same
alter."_ [Winn, _"Introduction"_, Winn (ed.), **Op. Cit.**, p. 10] While 2002
saw the election of the first socialist president since Allende, it is
unlikely that Chile will experience anything beyond minor reforms -- the
legacy of fear and political restrictions will ensure that the ruling class
will have little to fear from "political liberty" being used by politicians to
curb their power and wealth.

Then there is the social legacy of 17 years of dictatorship. As one expert on
Latin America, Cathy Scheider, noted in 1993, _"the transformation of the
economic and political system"_ under Pinochet _"has had a profound impact on
the world view of the typical Chilean,"_ with most having _"little contact
with other workers or with their neighbours, and only limited time with their
family. Their exposure to political or labour organisations is minimal. . .
they lack either the political resources or the disposition to confront the
state. The fragmentation of opposition communities has accomplished what brute
military repression could not. It has transformed Chile, both culturally and
politically, from a country of active participatory grassroots communities, to
a land of disconnected, apolitical individuals. The cumulative impact of this
change is such that we are unlikely to see any concerted challenge to the
current ideology in the near future."_ [quoted by Noam Chomsky, **World
Orders, Old and New**, p. 184]

In such circumstances, political liberty can be re-introduced, as no one is in
a position to effectively use it. In addition, Chileans live with the memory
that challenging the state in the near past resulted in a fascist dictatorship
murdering thousands of people as well as repeated and persistent violations of
human rights by the junta, not to mention the existence of "anti-Marxist"
death squads -- for example in 1986 _"Amnesty International accused the
Chilean government of employing death squads."_ [P. Gunson, A. Thompson, G.
Chamberlain, **Op. Cit.**, p. 86] According to one Human Rights group, the
Pinochet regime was responsible for 11,536 human rights violations between
1984 and 1988 alone. [Calculation of _"Comite Nacional de Defensa do los
Derechos del Pueblo,"_ reported in **Fortin**, September 23, 1988]

These facts that would have a strongly deterrent effect on people
contemplating the use of political liberty to actually **change** the status
quo in ways that the military and economic elites did not approve of. This
does not mean, of course, that the Chilean people are not resisting oppression
and exploitation and rebuilding their organisations, simply that using free
speech, striking and other forms of social action is more difficult. That is
protects and increases the power, wealth and authority of the employer and
state over their wage slaves goes without sating -- it was what was intended.
As Kropotkin pointed out years ago, _"freedom of press . . . and all the rest,
are only respected if the people do not make use of them against the
privileged classes. But the day the people begin to take advantage of them to
undermine those privileges, then the so-called liberties will be cast
overboard."_ [**Op. Cit.**, p. 42] Chile is a classic example of this, a
bloody example which helps deter genuine democracy in that country decades
later.

[‹ D.10 How does capitalism affect technology?](secD10.md "Go to previous
page" ) [up](secDcon.md "Go to parent page" ) [Section E - What do
anarchists think causes ecological problems? ›](secEcon.md "Go to next page"
)

