/**************************************************************************
 *
 * Copyright 2016 VMware, Inc.
 * All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 **************************************************************************/


#include "glretrace_wgl.hpp"
#include "glproc.hpp"


enum Function {
    F_BEGIN,
    F_FRONTFACE,
    F_VERTEX3F,
    F_NORMAL3F,
    F_END,
    F_TRANSLATEF,
};


struct Call {
    enum Function function;
    float args[3];
};


struct CallList {
    const Call *calls;
    size_t length;
};


#define C_Begin(mode)          { F_BEGIN,      { mode } }
#define C_FrontFace(mode)      { F_FRONTFACE,  { mode } }
#define C_Vertex3f(x, y, z)    { F_VERTEX3F,   { x, y, z } }
#define C_Normal3f(nx, ny, nz) { F_NORMAL3F,   { nx, ny, nz } }
#define C_End()                { F_END }
#define C_Translatef(x, y, z)  { F_TRANSLATEF, { x, y, z } }


/*
 * This matches the calls done by wglUseFontOutlines for Arial font.
 */
static const Call char_0 [] = {
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_FrontFace(GL_CW),
    C_Begin(GL_QUADS),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Normal3f(-0.f, 0.99999994f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Normal3f(-0.f, -0.99999994f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Normal3f(-0.f, -1.f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, -1.f),
    C_FrontFace(GL_CW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_End(),
    C_Translatef(0.671386719f, 0.f, 0.f),
};
static const Call char_1[] = {
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_FrontFace(GL_CW),
    C_Begin(GL_QUADS),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Normal3f(-0.f, 0.99999994f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Normal3f(-0.f, -0.99999994f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Normal3f(-0.f, -1.f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, -1.f),
    C_FrontFace(GL_CW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_End(),
    C_Translatef(0.671386719f, 0.f, 0.f),
};
static const Call char_2[] = {
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_FrontFace(GL_CW),
    C_Begin(GL_QUADS),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Normal3f(-0.f, 0.99999994f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Normal3f(-0.f, -0.99999994f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Normal3f(-0.f, -1.f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, -1.f),
    C_FrontFace(GL_CW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_End(),
    C_Translatef(0.671386719f, 0.f, 0.f),
};
static const Call char_3[] = {
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_FrontFace(GL_CW),
    C_Begin(GL_QUADS),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Normal3f(-0.f, 0.99999994f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Normal3f(-0.f, -0.99999994f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Normal3f(-0.f, -1.f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, -1.f),
    C_FrontFace(GL_CW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_End(),
    C_Translatef(0.671386719f, 0.f, 0.f),
};
static const Call char_4[] = {
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_FrontFace(GL_CW),
    C_Begin(GL_QUADS),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Normal3f(-0.f, 0.99999994f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Normal3f(-0.f, -0.99999994f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Normal3f(-0.f, -1.f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, -1.f),
    C_FrontFace(GL_CW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_End(),
    C_Translatef(0.671386719f, 0.f, 0.f),
};
static const Call char_5[] = {
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_FrontFace(GL_CW),
    C_Begin(GL_QUADS),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Normal3f(-0.f, 0.99999994f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Normal3f(-0.f, -0.99999994f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Normal3f(-0.f, -1.f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, -1.f),
    C_FrontFace(GL_CW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_End(),
    C_Translatef(0.671386719f, 0.f, 0.f),
};
static const Call char_6[] = {
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_FrontFace(GL_CW),
    C_Begin(GL_QUADS),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Normal3f(-0.f, 0.99999994f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Normal3f(-0.f, -0.99999994f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Normal3f(-0.f, -1.f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, -1.f),
    C_FrontFace(GL_CW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_End(),
    C_Translatef(0.671386719f, 0.f, 0.f),
};
static const Call char_7[] = {
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_FrontFace(GL_CW),
    C_Begin(GL_QUADS),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Normal3f(-0.f, 0.99999994f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Normal3f(-0.f, -0.99999994f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Normal3f(-0.f, -1.f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, -1.f),
    C_FrontFace(GL_CW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_End(),
    C_Translatef(0.671386719f, 0.f, 0.f),
};
static const Call char_8[] = {
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_FrontFace(GL_CW),
    C_Begin(GL_QUADS),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Normal3f(-0.f, 0.99999994f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Normal3f(-0.f, -0.99999994f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Normal3f(-0.f, -1.f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, -1.f),
    C_FrontFace(GL_CW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_End(),
    C_Translatef(0.671386719f, 0.f, 0.f),
};
static const Call char_9[] = {
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_FrontFace(GL_CW),
    C_Begin(GL_QUADS),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Normal3f(-0.f, 0.99999994f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Normal3f(-0.f, -0.99999994f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Normal3f(-0.f, -1.f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, -1.f),
    C_FrontFace(GL_CW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_End(),
    C_Translatef(0.671386719f, 0.f, 0.f),
};
static const Call char_10[] = {
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_FrontFace(GL_CW),
    C_Begin(GL_QUADS),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Normal3f(-0.f, 0.99999994f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Normal3f(-0.f, -0.99999994f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Normal3f(-0.f, -1.f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, -1.f),
    C_FrontFace(GL_CW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_End(),
    C_Translatef(0.671386719f, 0.f, 0.f),
};
static const Call char_11[] = {
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_FrontFace(GL_CW),
    C_Begin(GL_QUADS),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Normal3f(-0.f, 0.99999994f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Normal3f(-0.f, -0.99999994f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Normal3f(-0.f, -1.f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, -1.f),
    C_FrontFace(GL_CW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_End(),
    C_Translatef(0.671386719f, 0.f, 0.f),
};
static const Call char_12[] = {
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_FrontFace(GL_CW),
    C_Begin(GL_QUADS),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Normal3f(-0.f, 0.99999994f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Normal3f(-0.f, -0.99999994f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Normal3f(-0.f, -1.f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, -1.f),
    C_FrontFace(GL_CW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_End(),
    C_Translatef(0.671386719f, 0.f, 0.f),
};
static const Call char_13[] = {
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_FrontFace(GL_CW),
    C_Begin(GL_QUADS),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Normal3f(-0.f, 0.99999994f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Normal3f(-0.f, -0.99999994f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Normal3f(-0.f, -1.f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, -1.f),
    C_FrontFace(GL_CW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_End(),
    C_Translatef(0.671386719f, 0.f, 0.f),
};
static const Call char_14[] = {
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_FrontFace(GL_CW),
    C_Begin(GL_QUADS),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Normal3f(-0.f, 0.99999994f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Normal3f(-0.f, -0.99999994f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Normal3f(-0.f, -1.f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, -1.f),
    C_FrontFace(GL_CW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_End(),
    C_Translatef(0.671386719f, 0.f, 0.f),
};
static const Call char_15[] = {
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_FrontFace(GL_CW),
    C_Begin(GL_QUADS),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Normal3f(-0.f, 0.99999994f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Normal3f(-0.f, -0.99999994f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Normal3f(-0.f, -1.f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, -1.f),
    C_FrontFace(GL_CW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_End(),
    C_Translatef(0.671386719f, 0.f, 0.f),
};
static const Call char_16[] = {
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_FrontFace(GL_CW),
    C_Begin(GL_QUADS),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Normal3f(-0.f, 0.99999994f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Normal3f(-0.f, -0.99999994f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Normal3f(-0.f, -1.f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, -1.f),
    C_FrontFace(GL_CW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_End(),
    C_Translatef(0.671386719f, 0.f, 0.f),
};
static const Call char_17[] = {
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_FrontFace(GL_CW),
    C_Begin(GL_QUADS),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Normal3f(-0.f, 0.99999994f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Normal3f(-0.f, -0.99999994f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Normal3f(-0.f, -1.f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, -1.f),
    C_FrontFace(GL_CW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_End(),
    C_Translatef(0.671386719f, 0.f, 0.f),
};
static const Call char_18[] = {
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_FrontFace(GL_CW),
    C_Begin(GL_QUADS),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Normal3f(-0.f, 0.99999994f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Normal3f(-0.f, -0.99999994f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Normal3f(-0.f, -1.f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, -1.f),
    C_FrontFace(GL_CW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_End(),
    C_Translatef(0.671386719f, 0.f, 0.f),
};
static const Call char_19[] = {
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_FrontFace(GL_CW),
    C_Begin(GL_QUADS),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Normal3f(-0.f, 0.99999994f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Normal3f(-0.f, -0.99999994f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Normal3f(-0.f, -1.f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, -1.f),
    C_FrontFace(GL_CW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_End(),
    C_Translatef(0.671386719f, 0.f, 0.f),
};
static const Call char_20[] = {
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_FrontFace(GL_CW),
    C_Begin(GL_QUADS),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Normal3f(-0.f, 0.99999994f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Normal3f(-0.f, -0.99999994f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Normal3f(-0.f, -1.f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, -1.f),
    C_FrontFace(GL_CW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_End(),
    C_Translatef(0.671386719f, 0.f, 0.f),
};
static const Call char_21[] = {
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_FrontFace(GL_CW),
    C_Begin(GL_QUADS),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Normal3f(-0.f, 0.99999994f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Normal3f(-0.f, -0.99999994f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Normal3f(-0.f, -1.f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, -1.f),
    C_FrontFace(GL_CW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_End(),
    C_Translatef(0.671386719f, 0.f, 0.f),
};
static const Call char_22[] = {
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_FrontFace(GL_CW),
    C_Begin(GL_QUADS),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Normal3f(-0.f, 0.99999994f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Normal3f(-0.f, -0.99999994f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Normal3f(-0.f, -1.f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, -1.f),
    C_FrontFace(GL_CW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_End(),
    C_Translatef(0.671386719f, 0.f, 0.f),
};
static const Call char_23[] = {
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_FrontFace(GL_CW),
    C_Begin(GL_QUADS),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Normal3f(-0.f, 0.99999994f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Normal3f(-0.f, -0.99999994f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Normal3f(-0.f, -1.f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, -1.f),
    C_FrontFace(GL_CW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_End(),
    C_Translatef(0.671386719f, 0.f, 0.f),
};
static const Call char_24[] = {
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_FrontFace(GL_CW),
    C_Begin(GL_QUADS),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Normal3f(-0.f, 0.99999994f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Normal3f(-0.f, -0.99999994f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Normal3f(-0.f, -1.f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, -1.f),
    C_FrontFace(GL_CW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_End(),
    C_Translatef(0.671386719f, 0.f, 0.f),
};
static const Call char_25[] = {
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_FrontFace(GL_CW),
    C_Begin(GL_QUADS),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Normal3f(-0.f, 0.99999994f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Normal3f(-0.f, -0.99999994f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Normal3f(-0.f, -1.f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, -1.f),
    C_FrontFace(GL_CW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_End(),
    C_Translatef(0.671386719f, 0.f, 0.f),
};
static const Call char_26[] = {
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_FrontFace(GL_CW),
    C_Begin(GL_QUADS),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Normal3f(-0.f, 0.99999994f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Normal3f(-0.f, -0.99999994f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Normal3f(-0.f, -1.f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, -1.f),
    C_FrontFace(GL_CW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_End(),
    C_Translatef(0.671386719f, 0.f, 0.f),
};
static const Call char_27[] = {
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_FrontFace(GL_CW),
    C_Begin(GL_QUADS),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Normal3f(-0.f, 0.99999994f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Normal3f(-0.f, -0.99999994f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Normal3f(-0.f, -1.f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, -1.f),
    C_FrontFace(GL_CW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_End(),
    C_Translatef(0.671386719f, 0.f, 0.f),
};
static const Call char_28[] = {
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_FrontFace(GL_CW),
    C_Begin(GL_QUADS),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Normal3f(-0.f, 0.99999994f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Normal3f(-0.f, -0.99999994f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Normal3f(-0.f, -1.f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, -1.f),
    C_FrontFace(GL_CW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_End(),
    C_Translatef(0.671386719f, 0.f, 0.f),
};
static const Call char_29[] = {
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_FrontFace(GL_CW),
    C_Begin(GL_QUADS),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Normal3f(-0.f, 0.99999994f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Normal3f(-0.f, -0.99999994f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Normal3f(-0.f, -1.f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, -1.f),
    C_FrontFace(GL_CW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_End(),
    C_Translatef(0.671386719f, 0.f, 0.f),
};
static const Call char_30[] = {
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_FrontFace(GL_CW),
    C_Begin(GL_QUADS),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Normal3f(-0.f, 0.99999994f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Normal3f(-0.f, -0.99999994f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Normal3f(-0.f, -1.f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, -1.f),
    C_FrontFace(GL_CW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_End(),
    C_Translatef(0.671386719f, 0.f, 0.f),
};
static const Call char_31[] = {
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_FrontFace(GL_CW),
    C_Begin(GL_QUADS),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Normal3f(-0.f, 0.99999994f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Normal3f(-0.f, -0.99999994f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Normal3f(-0.f, -1.f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.111816406f, 0.559570313f, 0.f),
    C_Vertex3f(0.125976563f, 0.545410156f, 0.f),
    C_Vertex3f(0.559570313f, 0.559570313f, 0.f),
    C_Vertex3f(0.545410156f, 0.545410156f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, 0.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.125976563f, 0.0141601563f, 0.f),
    C_Vertex3f(0.111816406f, 0.f, 0.f),
    C_Vertex3f(0.559570313f, 0.f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, -1.f),
    C_FrontFace(GL_CW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.111816406f, 0.559570313f, -1.f),
    C_Vertex3f(0.125976563f, 0.545410156f, -1.f),
    C_Vertex3f(0.559570313f, 0.559570313f, -1.f),
    C_Vertex3f(0.545410156f, 0.545410156f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_Vertex3f(0.545410156f, 0.0141601563f, -1.f),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.125976563f, 0.0141601563f, -1.f),
    C_Vertex3f(0.111816406f, 0.f, -1.f),
    C_Vertex3f(0.559570313f, 0.f, -1.f),
    C_End(),
    C_Translatef(0.671386719f, 0.f, 0.f),
};
static const Call char_32[] = {
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_Normal3f(0.f, 0.f, -1.f),
    C_FrontFace(GL_CW),
    C_Translatef(0.248535156f, 0.f, 0.f),
};
static const Call char_33[] = {
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_FrontFace(GL_CW),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.997530401f, -0.0702363178f, 0.f),
    C_Vertex3f(0.101074219f, 0.158691406f, 0.f),
    C_Vertex3f(0.101074219f, 0.158691406f, -1.f),
    C_Vertex3f(0.0771484375f, 0.498497009f, -1.f),
    C_Vertex3f(0.0771484375f, 0.498497009f, 0.f),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.0771484375f, 0.498497009f, 0.f),
    C_Vertex3f(0.0771484375f, 0.498497009f, -1.f),
    C_Vertex3f(0.0771484375f, 0.640625f, -1.f),
    C_Vertex3f(0.0771484375f, 0.640625f, 0.f),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.0771484375f, 0.640625f, 0.f),
    C_Vertex3f(0.0771484375f, 0.640625f, -1.f),
    C_Vertex3f(0.174804688f, 0.640625f, -1.f),
    C_Vertex3f(0.174804688f, 0.640625f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.174804688f, 0.640625f, 0.f),
    C_Vertex3f(0.174804688f, 0.640625f, -1.f),
    C_Vertex3f(0.174804688f, 0.498497009f, -1.f),
    C_Vertex3f(0.174804688f, 0.498497009f, 0.f),
    C_Normal3f(0.997727215f, -0.06738282f, 0.f),
    C_Vertex3f(0.174804688f, 0.498497009f, 0.f),
    C_Vertex3f(0.174804688f, 0.498497009f, -1.f),
    C_Vertex3f(0.151855469f, 0.158691406f, -1.f),
    C_Vertex3f(0.151855469f, 0.158691406f, 0.f),
    C_Normal3f(-0.f, -1.f, 0.f),
    C_Vertex3f(0.151855469f, 0.158691406f, 0.f),
    C_Vertex3f(0.151855469f, 0.158691406f, -1.f),
    C_Vertex3f(0.101074219f, 0.158691406f, -1.f),
    C_Vertex3f(0.101074219f, 0.158691406f, 0.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.0805664063f, 0.f, 0.f),
    C_Vertex3f(0.0805664063f, 0.f, -1.f),
    C_Vertex3f(0.0805664063f, 0.0893554688f, -1.f),
    C_Vertex3f(0.0805664063f, 0.0893554688f, 0.f),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.0805664063f, 0.0893554688f, 0.f),
    C_Vertex3f(0.0805664063f, 0.0893554688f, -1.f),
    C_Vertex3f(0.171386719f, 0.0893554688f, -1.f),
    C_Vertex3f(0.171386719f, 0.0893554688f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.171386719f, 0.0893554688f, 0.f),
    C_Vertex3f(0.171386719f, 0.0893554688f, -1.f),
    C_Vertex3f(0.171386719f, 0.f, -1.f),
    C_Vertex3f(0.171386719f, 0.f, 0.f),
    C_Normal3f(-0.f, -1.f, 0.f),
    C_Vertex3f(0.171386719f, 0.f, 0.f),
    C_Vertex3f(0.171386719f, 0.f, -1.f),
    C_Vertex3f(0.0805664063f, 0.f, -1.f),
    C_Vertex3f(0.0805664063f, 0.f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.174804688f, 0.640625f, 0.f),
    C_Vertex3f(0.0771484375f, 0.640625f, 0.f),
    C_Vertex3f(0.101074219f, 0.158691406f, 0.f),
    C_Vertex3f(0.151855469f, 0.158691406f, 0.f),
    C_Vertex3f(0.174804688f, 0.498497009f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.0805664063f, 0.0893554688f, 0.f),
    C_Vertex3f(0.0805664063f, 0.f, 0.f),
    C_Vertex3f(0.171386719f, 0.f, 0.f),
    C_Vertex3f(0.171386719f, 0.0893554688f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.101074219f, 0.158691406f, 0.f),
    C_Vertex3f(0.0771484375f, 0.640625f, 0.f),
    C_Vertex3f(0.0771484375f, 0.498497009f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, -1.f),
    C_FrontFace(GL_CW),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.174804688f, 0.640625f, -1.f),
    C_Vertex3f(0.0771484375f, 0.640625f, -1.f),
    C_Vertex3f(0.101074219f, 0.158691406f, -1.f),
    C_Vertex3f(0.151855469f, 0.158691406f, -1.f),
    C_Vertex3f(0.174804688f, 0.498497009f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.0805664063f, 0.0893554688f, -1.f),
    C_Vertex3f(0.0805664063f, 0.f, -1.f),
    C_Vertex3f(0.171386719f, 0.f, -1.f),
    C_Vertex3f(0.171386719f, 0.0893554688f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.101074219f, 0.158691406f, -1.f),
    C_Vertex3f(0.0771484375f, 0.640625f, -1.f),
    C_Vertex3f(0.0771484375f, 0.498497009f, -1.f),
    C_End(),
    C_Translatef(0.248535156f, 0.f, 0.f),
};
static const Call char_34[] = {
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_FrontFace(GL_CW),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.984425306f, -0.175803423f, 0.f),
    C_Vertex3f(0.0628128052f, 0.413574219f, 0.f),
    C_Vertex3f(0.0628128052f, 0.413574219f, -1.f),
    C_Vertex3f(0.041015625f, 0.535629272f, -1.f),
    C_Vertex3f(0.041015625f, 0.535629272f, 0.f),
    C_Normal3f(-0.99999994f, 0.f, 0.f),
    C_Vertex3f(0.041015625f, 0.535629272f, 0.f),
    C_Vertex3f(0.041015625f, 0.535629272f, -1.f),
    C_Vertex3f(0.041015625f, 0.640625f, -1.f),
    C_Vertex3f(0.041015625f, 0.640625f, 0.f),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.041015625f, 0.640625f, 0.f),
    C_Vertex3f(0.041015625f, 0.640625f, -1.f),
    C_Vertex3f(0.130371094f, 0.640625f, -1.f),
    C_Vertex3f(0.130371094f, 0.640625f, 0.f),
    C_Normal3f(0.99999994f, 0.f, 0.f),
    C_Vertex3f(0.130371094f, 0.640625f, 0.f),
    C_Vertex3f(0.130371094f, 0.640625f, -1.f),
    C_Vertex3f(0.130371094f, 0.535629272f, -1.f),
    C_Vertex3f(0.130371094f, 0.535629272f, 0.f),
    C_Normal3f(0.98733145f, -0.158671662f, 0.f),
    C_Vertex3f(0.130371094f, 0.535629272f, 0.f),
    C_Vertex3f(0.130371094f, 0.535629272f, -1.f),
    C_Vertex3f(0.11075592f, 0.413574219f, -1.f),
    C_Vertex3f(0.11075592f, 0.413574219f, 0.f),
    C_Normal3f(-0.f, -0.99999994f, 0.f),
    C_Vertex3f(0.11075592f, 0.413574219f, 0.f),
    C_Vertex3f(0.11075592f, 0.413574219f, -1.f),
    C_Vertex3f(0.0628128052f, 0.413574219f, -1.f),
    C_Vertex3f(0.0628128052f, 0.413574219f, 0.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.985037327f, -0.172341511f, 0.f),
    C_Vertex3f(0.207878113f, 0.413574219f, 0.f),
    C_Vertex3f(0.207878113f, 0.413574219f, -1.f),
    C_Vertex3f(0.186523438f, 0.535629272f, -1.f),
    C_Vertex3f(0.186523438f, 0.535629272f, 0.f),
    C_Normal3f(-0.99999994f, 0.f, 0.f),
    C_Vertex3f(0.186523438f, 0.535629272f, 0.f),
    C_Vertex3f(0.186523438f, 0.535629272f, -1.f),
    C_Vertex3f(0.186523438f, 0.640625f, -1.f),
    C_Vertex3f(0.186523438f, 0.640625f, 0.f),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.186523438f, 0.640625f, 0.f),
    C_Vertex3f(0.186523438f, 0.640625f, -1.f),
    C_Vertex3f(0.275878906f, 0.640625f, -1.f),
    C_Vertex3f(0.275878906f, 0.640625f, 0.f),
    C_Normal3f(0.99999994f, 0.f, 0.f),
    C_Vertex3f(0.275878906f, 0.640625f, 0.f),
    C_Vertex3f(0.275878906f, 0.640625f, -1.f),
    C_Vertex3f(0.275878906f, 0.535629272f, -1.f),
    C_Vertex3f(0.275878906f, 0.535629272f, 0.f),
    C_Normal3f(0.985627592f, -0.168933049f, 0.f),
    C_Vertex3f(0.275878906f, 0.535629272f, 0.f),
    C_Vertex3f(0.275878906f, 0.535629272f, -1.f),
    C_Vertex3f(0.254959106f, 0.413574219f, -1.f),
    C_Vertex3f(0.254959106f, 0.413574219f, 0.f),
    C_Normal3f(-0.f, -1.f, 0.f),
    C_Vertex3f(0.254959106f, 0.413574219f, 0.f),
    C_Vertex3f(0.254959106f, 0.413574219f, -1.f),
    C_Vertex3f(0.207878113f, 0.413574219f, -1.f),
    C_Vertex3f(0.207878113f, 0.413574219f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.130371094f, 0.640625f, 0.f),
    C_Vertex3f(0.041015625f, 0.640625f, 0.f),
    C_Vertex3f(0.0628128052f, 0.413574219f, 0.f),
    C_Vertex3f(0.11075592f, 0.413574219f, 0.f),
    C_Vertex3f(0.130371094f, 0.535629272f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.275878906f, 0.640625f, 0.f),
    C_Vertex3f(0.186523438f, 0.640625f, 0.f),
    C_Vertex3f(0.207878113f, 0.413574219f, 0.f),
    C_Vertex3f(0.254959106f, 0.413574219f, 0.f),
    C_Vertex3f(0.275878906f, 0.535629272f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.207878113f, 0.413574219f, 0.f),
    C_Vertex3f(0.186523438f, 0.640625f, 0.f),
    C_Vertex3f(0.186523438f, 0.535629272f, 0.f),
    C_Vertex3f(0.0628128052f, 0.413574219f, 0.f),
    C_Vertex3f(0.041015625f, 0.640625f, 0.f),
    C_Vertex3f(0.041015625f, 0.535629272f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, -1.f),
    C_FrontFace(GL_CW),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.130371094f, 0.640625f, -1.f),
    C_Vertex3f(0.041015625f, 0.640625f, -1.f),
    C_Vertex3f(0.0628128052f, 0.413574219f, -1.f),
    C_Vertex3f(0.11075592f, 0.413574219f, -1.f),
    C_Vertex3f(0.130371094f, 0.535629272f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.275878906f, 0.640625f, -1.f),
    C_Vertex3f(0.186523438f, 0.640625f, -1.f),
    C_Vertex3f(0.207878113f, 0.413574219f, -1.f),
    C_Vertex3f(0.254959106f, 0.413574219f, -1.f),
    C_Vertex3f(0.275878906f, 0.535629272f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.207878113f, 0.413574219f, -1.f),
    C_Vertex3f(0.186523438f, 0.640625f, -1.f),
    C_Vertex3f(0.186523438f, 0.535629272f, -1.f),
    C_Vertex3f(0.0628128052f, 0.413574219f, -1.f),
    C_Vertex3f(0.041015625f, 0.640625f, -1.f),
    C_Vertex3f(0.041015625f, 0.535629272f, -1.f),
    C_End(),
    C_Translatef(0.317871094f, 0.f, 0.f),
};
static const Call char_35[] = {
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_FrontFace(GL_CW),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.979767263f, 0.200140283f, 0.f),
    C_Vertex3f(0.044921875f, -0.0107421875f, 0.f),
    C_Vertex3f(0.044921875f, -0.0107421875f, -1.f),
    C_Vertex3f(0.0829238892f, 0.175292969f, -1.f),
    C_Vertex3f(0.0829238892f, 0.175292969f, 0.f),
    C_Normal3f(-0.f, -1.f, 0.f),
    C_Vertex3f(0.0829238892f, 0.175292969f, 0.f),
    C_Vertex3f(0.0829238892f, 0.175292969f, -1.f),
    C_Vertex3f(0.00927734375f, 0.175292969f, -1.f),
    C_Vertex3f(0.00927734375f, 0.175292969f, 0.f),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.00927734375f, 0.175292969f, 0.f),
    C_Vertex3f(0.00927734375f, 0.175292969f, -1.f),
    C_Vertex3f(0.00927734375f, 0.240234375f, -1.f),
    C_Vertex3f(0.00927734375f, 0.240234375f, 0.f),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.00927734375f, 0.240234375f, 0.f),
    C_Vertex3f(0.00927734375f, 0.240234375f, -1.f),
    C_Vertex3f(0.0961914063f, 0.240234375f, -1.f),
    C_Vertex3f(0.0961914063f, 0.240234375f, 0.f),
    C_Normal3f(-0.97976613f, 0.200145498f, 0.f),
    C_Vertex3f(0.0961914063f, 0.240234375f, 0.f),
    C_Vertex3f(0.0961914063f, 0.240234375f, -1.f),
    C_Vertex3f(0.128608704f, 0.398925781f, -1.f),
    C_Vertex3f(0.128608704f, 0.398925781f, 0.f),
    C_Normal3f(-0.f, -1.f, 0.f),
    C_Vertex3f(0.128608704f, 0.398925781f, 0.f),
    C_Vertex3f(0.128608704f, 0.398925781f, -1.f),
    C_Vertex3f(0.00927734375f, 0.398925781f, -1.f),
    C_Vertex3f(0.00927734375f, 0.398925781f, 0.f),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.00927734375f, 0.398925781f, 0.f),
    C_Vertex3f(0.00927734375f, 0.398925781f, -1.f),
    C_Vertex3f(0.00927734375f, 0.463867188f, -1.f),
    C_Vertex3f(0.00927734375f, 0.463867188f, 0.f),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.00927734375f, 0.463867188f, 0.f),
    C_Vertex3f(0.00927734375f, 0.463867188f, -1.f),
    C_Vertex3f(0.141876221f, 0.463867188f, -1.f),
    C_Vertex3f(0.141876221f, 0.463867188f, 0.f),
    C_Normal3f(-0.979768932f, 0.200131834f, 0.f),
    C_Vertex3f(0.141876221f, 0.463867188f, 0.f),
    C_Vertex3f(0.141876221f, 0.463867188f, -1.f),
    C_Vertex3f(0.180175781f, 0.651367188f, -1.f),
    C_Vertex3f(0.180175781f, 0.651367188f, 0.f),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.180175781f, 0.651367188f, 0.f),
    C_Vertex3f(0.180175781f, 0.651367188f, -1.f),
    C_Vertex3f(0.245735168f, 0.651367188f, -1.f),
    C_Vertex3f(0.245735168f, 0.651367188f, 0.f),
    C_Normal3f(0.979768932f, -0.200131834f, 0.f),
    C_Vertex3f(0.245735168f, 0.651367188f, 0.f),
    C_Vertex3f(0.245735168f, 0.651367188f, -1.f),
    C_Vertex3f(0.207435608f, 0.463867188f, -1.f),
    C_Vertex3f(0.207435608f, 0.463867188f, 0.f),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.207435608f, 0.463867188f, 0.f),
    C_Vertex3f(0.207435608f, 0.463867188f, -1.f),
    C_Vertex3f(0.344863892f, 0.463867188f, -1.f),
    C_Vertex3f(0.344863892f, 0.463867188f, 0.f),
    C_Normal3f(-0.979768932f, 0.200131834f, 0.f),
    C_Vertex3f(0.344863892f, 0.463867188f, 0.f),
    C_Vertex3f(0.344863892f, 0.463867188f, -1.f),
    C_Vertex3f(0.383163452f, 0.651367188f, -1.f),
    C_Vertex3f(0.383163452f, 0.651367188f, 0.f),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.383163452f, 0.651367188f, 0.f),
    C_Vertex3f(0.383163452f, 0.651367188f, -1.f),
    C_Vertex3f(0.448730469f, 0.651367188f, -1.f),
    C_Vertex3f(0.448730469f, 0.651367188f, 0.f),
    C_Normal3f(0.979768932f, -0.200131834f, 0.f),
    C_Vertex3f(0.448730469f, 0.651367188f, 0.f),
    C_Vertex3f(0.448730469f, 0.651367188f, -1.f),
    C_Vertex3f(0.410430908f, 0.463867188f, -1.f),
    C_Vertex3f(0.410430908f, 0.463867188f, 0.f),
    C_Normal3f(-0.f, 0.99999994f, 0.f),
    C_Vertex3f(0.410430908f, 0.463867188f, 0.f),
    C_Vertex3f(0.410430908f, 0.463867188f, -1.f),
    C_Vertex3f(0.486816406f, 0.463867188f, -1.f),
    C_Vertex3f(0.486816406f, 0.463867188f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.486816406f, 0.463867188f, 0.f),
    C_Vertex3f(0.486816406f, 0.463867188f, -1.f),
    C_Vertex3f(0.486816406f, 0.398925781f, -1.f),
    C_Vertex3f(0.486816406f, 0.398925781f, 0.f),
    C_Normal3f(-0.f, -1.f, 0.f),
    C_Vertex3f(0.486816406f, 0.398925781f, 0.f),
    C_Vertex3f(0.486816406f, 0.398925781f, -1.f),
    C_Vertex3f(0.397163391f, 0.398925781f, -1.f),
    C_Vertex3f(0.397163391f, 0.398925781f, 0.f),
    C_Normal3f(0.97976613f, -0.200145498f, 0.f),
    C_Vertex3f(0.397163391f, 0.398925781f, 0.f),
    C_Vertex3f(0.397163391f, 0.398925781f, -1.f),
    C_Vertex3f(0.364746094f, 0.240234375f, -1.f),
    C_Vertex3f(0.364746094f, 0.240234375f, 0.f),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.364746094f, 0.240234375f, 0.f),
    C_Vertex3f(0.364746094f, 0.240234375f, -1.f),
    C_Vertex3f(0.486816406f, 0.240234375f, -1.f),
    C_Vertex3f(0.486816406f, 0.240234375f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.486816406f, 0.240234375f, 0.f),
    C_Vertex3f(0.486816406f, 0.240234375f, -1.f),
    C_Vertex3f(0.486816406f, 0.175292969f, -1.f),
    C_Vertex3f(0.486816406f, 0.175292969f, 0.f),
    C_Normal3f(-0.f, -1.f, 0.f),
    C_Vertex3f(0.486816406f, 0.175292969f, 0.f),
    C_Vertex3f(0.486816406f, 0.175292969f, -1.f),
    C_Vertex3f(0.351478577f, 0.175292969f, -1.f),
    C_Vertex3f(0.351478577f, 0.175292969f, 0.f),
    C_Normal3f(0.979767263f, -0.200140283f, 0.f),
    C_Vertex3f(0.351478577f, 0.175292969f, 0.f),
    C_Vertex3f(0.351478577f, 0.175292969f, -1.f),
    C_Vertex3f(0.313476563f, -0.0107421875f, -1.f),
    C_Vertex3f(0.313476563f, -0.0107421875f, 0.f),
    C_Normal3f(-0.f, -1.f, 0.f),
    C_Vertex3f(0.313476563f, -0.0107421875f, 0.f),
    C_Vertex3f(0.313476563f, -0.0107421875f, -1.f),
    C_Vertex3f(0.247917175f, -0.0107421875f, -1.f),
    C_Vertex3f(0.247917175f, -0.0107421875f, 0.f),
    C_Normal3f(-0.979767263f, 0.200140283f, 0.f),
    C_Vertex3f(0.247917175f, -0.0107421875f, 0.f),
    C_Vertex3f(0.247917175f, -0.0107421875f, -1.f),
    C_Vertex3f(0.285919189f, 0.175292969f, -1.f),
    C_Vertex3f(0.285919189f, 0.175292969f, 0.f),
    C_Normal3f(-0.f, -1.f, 0.f),
    C_Vertex3f(0.285919189f, 0.175292969f, 0.f),
    C_Vertex3f(0.285919189f, 0.175292969f, -1.f),
    C_Vertex3f(0.148490906f, 0.175292969f, -1.f),
    C_Vertex3f(0.148490906f, 0.175292969f, 0.f),
    C_Normal3f(0.979767263f, -0.200140283f, 0.f),
    C_Vertex3f(0.148490906f, 0.175292969f, 0.f),
    C_Vertex3f(0.148490906f, 0.175292969f, -1.f),
    C_Vertex3f(0.110488892f, -0.0107421875f, -1.f),
    C_Vertex3f(0.110488892f, -0.0107421875f, 0.f),
    C_Normal3f(-0.f, -1.f, 0.f),
    C_Vertex3f(0.110488892f, -0.0107421875f, 0.f),
    C_Vertex3f(0.110488892f, -0.0107421875f, -1.f),
    C_Vertex3f(0.044921875f, -0.0107421875f, -1.f),
    C_Vertex3f(0.044921875f, -0.0107421875f, 0.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.161758423f, 0.240234375f, 0.f),
    C_Vertex3f(0.161758423f, 0.240234375f, -1.f),
    C_Vertex3f(0.299186707f, 0.240234375f, -1.f),
    C_Vertex3f(0.299186707f, 0.240234375f, 0.f),
    C_Normal3f(-0.979775369f, 0.200100288f, 0.f),
    C_Vertex3f(0.299186707f, 0.240234375f, 0.f),
    C_Vertex3f(0.299186707f, 0.240234375f, -1.f),
    C_Vertex3f(0.331596375f, 0.398925781f, -1.f),
    C_Vertex3f(0.331596375f, 0.398925781f, 0.f),
    C_Normal3f(-0.f, -1.f, 0.f),
    C_Vertex3f(0.331596375f, 0.398925781f, 0.f),
    C_Vertex3f(0.331596375f, 0.398925781f, -1.f),
    C_Vertex3f(0.194168091f, 0.398925781f, -1.f),
    C_Vertex3f(0.194168091f, 0.398925781f, 0.f),
    C_Normal3f(0.979775369f, -0.200100288f, 0.f),
    C_Vertex3f(0.194168091f, 0.398925781f, 0.f),
    C_Vertex3f(0.194168091f, 0.398925781f, -1.f),
    C_Vertex3f(0.161758423f, 0.240234375f, -1.f),
    C_Vertex3f(0.161758423f, 0.240234375f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.180175781f, 0.651367188f, 0.f),
    C_Vertex3f(0.141876221f, 0.463867188f, 0.f),
    C_Vertex3f(0.148490906f, 0.175292969f, 0.f),
    C_Vertex3f(0.128608704f, 0.398925781f, 0.f),
    C_Vertex3f(0.110488892f, -0.0107421875f, 0.f),
    C_Vertex3f(0.0961914063f, 0.240234375f, 0.f),
    C_Vertex3f(0.0829238892f, 0.175292969f, 0.f),
    C_Vertex3f(0.00927734375f, 0.240234375f, 0.f),
    C_Vertex3f(0.00927734375f, 0.175292969f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.00927734375f, 0.463867188f, 0.f),
    C_Vertex3f(0.00927734375f, 0.398925781f, 0.f),
    C_Vertex3f(0.128608704f, 0.398925781f, 0.f),
    C_Vertex3f(0.141876221f, 0.463867188f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.245735168f, 0.651367188f, 0.f),
    C_Vertex3f(0.194168091f, 0.398925781f, 0.f),
    C_Vertex3f(0.207435608f, 0.463867188f, 0.f),
    C_Vertex3f(0.331596375f, 0.398925781f, 0.f),
    C_Vertex3f(0.344863892f, 0.463867188f, 0.f),
    C_Vertex3f(0.351478577f, 0.175292969f, 0.f),
    C_Vertex3f(0.383163452f, 0.651367188f, 0.f),
    C_Vertex3f(0.364746094f, 0.240234375f, 0.f),
    C_Vertex3f(0.397163391f, 0.398925781f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.180175781f, 0.651367188f, 0.f),
    C_Vertex3f(0.148490906f, 0.175292969f, 0.f),
    C_Vertex3f(0.161758423f, 0.240234375f, 0.f),
    C_Vertex3f(0.194168091f, 0.398925781f, 0.f),
    C_Vertex3f(0.245735168f, 0.651367188f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.351478577f, 0.175292969f, 0.f),
    C_Vertex3f(0.331596375f, 0.398925781f, 0.f),
    C_Vertex3f(0.313476563f, -0.0107421875f, 0.f),
    C_Vertex3f(0.299186707f, 0.240234375f, 0.f),
    C_Vertex3f(0.285919189f, 0.175292969f, 0.f),
    C_Vertex3f(0.161758423f, 0.240234375f, 0.f),
    C_Vertex3f(0.148490906f, 0.175292969f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.397163391f, 0.398925781f, 0.f),
    C_Vertex3f(0.486816406f, 0.398925781f, 0.f),
    C_Vertex3f(0.410430908f, 0.463867188f, 0.f),
    C_Vertex3f(0.448730469f, 0.651367188f, 0.f),
    C_Vertex3f(0.383163452f, 0.651367188f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.364746094f, 0.240234375f, 0.f),
    C_Vertex3f(0.351478577f, 0.175292969f, 0.f),
    C_Vertex3f(0.486816406f, 0.175292969f, 0.f),
    C_Vertex3f(0.486816406f, 0.240234375f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.410430908f, 0.463867188f, 0.f),
    C_Vertex3f(0.486816406f, 0.398925781f, 0.f),
    C_Vertex3f(0.486816406f, 0.463867188f, 0.f),
    C_Vertex3f(0.313476563f, -0.0107421875f, 0.f),
    C_Vertex3f(0.285919189f, 0.175292969f, 0.f),
    C_Vertex3f(0.247917175f, -0.0107421875f, 0.f),
    C_Vertex3f(0.110488892f, -0.0107421875f, 0.f),
    C_Vertex3f(0.0829238892f, 0.175292969f, 0.f),
    C_Vertex3f(0.044921875f, -0.0107421875f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, -1.f),
    C_FrontFace(GL_CW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.180175781f, 0.651367188f, -1.f),
    C_Vertex3f(0.141876221f, 0.463867188f, -1.f),
    C_Vertex3f(0.148490906f, 0.175292969f, -1.f),
    C_Vertex3f(0.128608704f, 0.398925781f, -1.f),
    C_Vertex3f(0.110488892f, -0.0107421875f, -1.f),
    C_Vertex3f(0.0961914063f, 0.240234375f, -1.f),
    C_Vertex3f(0.0829238892f, 0.175292969f, -1.f),
    C_Vertex3f(0.00927734375f, 0.240234375f, -1.f),
    C_Vertex3f(0.00927734375f, 0.175292969f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.00927734375f, 0.463867188f, -1.f),
    C_Vertex3f(0.00927734375f, 0.398925781f, -1.f),
    C_Vertex3f(0.128608704f, 0.398925781f, -1.f),
    C_Vertex3f(0.141876221f, 0.463867188f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.245735168f, 0.651367188f, -1.f),
    C_Vertex3f(0.194168091f, 0.398925781f, -1.f),
    C_Vertex3f(0.207435608f, 0.463867188f, -1.f),
    C_Vertex3f(0.331596375f, 0.398925781f, -1.f),
    C_Vertex3f(0.344863892f, 0.463867188f, -1.f),
    C_Vertex3f(0.351478577f, 0.175292969f, -1.f),
    C_Vertex3f(0.383163452f, 0.651367188f, -1.f),
    C_Vertex3f(0.364746094f, 0.240234375f, -1.f),
    C_Vertex3f(0.397163391f, 0.398925781f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.180175781f, 0.651367188f, -1.f),
    C_Vertex3f(0.148490906f, 0.175292969f, -1.f),
    C_Vertex3f(0.161758423f, 0.240234375f, -1.f),
    C_Vertex3f(0.194168091f, 0.398925781f, -1.f),
    C_Vertex3f(0.245735168f, 0.651367188f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.351478577f, 0.175292969f, -1.f),
    C_Vertex3f(0.331596375f, 0.398925781f, -1.f),
    C_Vertex3f(0.313476563f, -0.0107421875f, -1.f),
    C_Vertex3f(0.299186707f, 0.240234375f, -1.f),
    C_Vertex3f(0.285919189f, 0.175292969f, -1.f),
    C_Vertex3f(0.161758423f, 0.240234375f, -1.f),
    C_Vertex3f(0.148490906f, 0.175292969f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.397163391f, 0.398925781f, -1.f),
    C_Vertex3f(0.486816406f, 0.398925781f, -1.f),
    C_Vertex3f(0.410430908f, 0.463867188f, -1.f),
    C_Vertex3f(0.448730469f, 0.651367188f, -1.f),
    C_Vertex3f(0.383163452f, 0.651367188f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.364746094f, 0.240234375f, -1.f),
    C_Vertex3f(0.351478577f, 0.175292969f, -1.f),
    C_Vertex3f(0.486816406f, 0.175292969f, -1.f),
    C_Vertex3f(0.486816406f, 0.240234375f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.410430908f, 0.463867188f, -1.f),
    C_Vertex3f(0.486816406f, 0.398925781f, -1.f),
    C_Vertex3f(0.486816406f, 0.463867188f, -1.f),
    C_Vertex3f(0.313476563f, -0.0107421875f, -1.f),
    C_Vertex3f(0.285919189f, 0.175292969f, -1.f),
    C_Vertex3f(0.247917175f, -0.0107421875f, -1.f),
    C_Vertex3f(0.110488892f, -0.0107421875f, -1.f),
    C_Vertex3f(0.0829238892f, 0.175292969f, -1.f),
    C_Vertex3f(0.044921875f, -0.0107421875f, -1.f),
    C_End(),
    C_Translatef(0.497558594f, 0.f, 0.f),
};
static const Call char_36[] = {
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_FrontFace(GL_CW),
    C_Begin(GL_QUADS),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.222167969f, -0.0922851563f, 0.f),
    C_Vertex3f(0.222167969f, -0.0922851563f, -1.f),
    C_Vertex3f(0.222167969f, -0.013671875f, -1.f),
    C_Vertex3f(0.222167969f, -0.013671875f, 0.f),
    C_End(),
    C_Begin(GL_QUAD_STRIP),
    C_Normal3f(-0.12531729f, -0.99211669f, 0.f),
    C_Vertex3f(0.222167969f, -0.013671875f, 0.f),
    C_Vertex3f(0.222167969f, -0.013671875f, -1.f),
    C_Normal3f(-0.167302385f, -0.985905647f, 0.f),
    C_Vertex3f(0.207460403f, -0.0118141174f, 0.f),
    C_Vertex3f(0.207460403f, -0.0118141174f, -1.f),
    C_Normal3f(-0.226709396f, -0.973962486f, 0.f),
    C_Vertex3f(0.180796623f, -0.00665140152f, 0.f),
    C_Vertex3f(0.180796623f, -0.00665140152f, -1.f),
    C_Normal3f(-0.309432268f, -0.950921476f, 0.f),
    C_Vertex3f(0.156884193f, -4.14848328e-005f, 0.f),
    C_Vertex3f(0.156884193f, -4.14848328e-005f, -1.f),
    C_Normal3f(-0.405644834f, -0.91403079f, 0.f),
    C_Vertex3f(0.135723114f, 0.00801563263f, 0.f),
    C_Vertex3f(0.135723114f, 0.00801563263f, -1.f),
    C_Normal3f(-0.524854243f, -0.851192117f, 0.f),
    C_Vertex3f(0.117313385f, 0.0175199509f, 0.f),
    C_Vertex3f(0.117313385f, 0.0175199509f, -1.f),
    C_Normal3f(-0.643237889f, -0.765666306f, 0.f),
    C_Vertex3f(0.10015583f, 0.029946804f, 0.f),
    C_Vertex3f(0.10015583f, 0.029946804f, -1.f),
    C_Normal3f(-0.740008473f, -0.672597587f, 0.f),
    C_Vertex3f(0.0842504501f, 0.0452961922f, 0.f),
    C_Vertex3f(0.0842504501f, 0.0452961922f, -1.f),
    C_Normal3f(-0.815060079f, -0.5793764f, 0.f),
    C_Vertex3f(0.0695972443f, 0.0635681152f, 0.f),
    C_Vertex3f(0.0695972443f, 0.0635681152f, -1.f),
    C_Normal3f(-0.881236613f, -0.472675413f, 0.f),
    C_Vertex3f(0.0561962128f, 0.0847625732f, 0.f),
    C_Vertex3f(0.0561962128f, 0.0847625732f, -1.f),
    C_Normal3f(-0.937281966f, -0.348571897f, 0.f),
    C_Vertex3f(0.0456008911f, 0.108305931f, 0.f),
    C_Vertex3f(0.0456008911f, 0.108305931f, -1.f),
    C_Normal3f(-0.973271728f, -0.229656667f, 0.f),
    C_Vertex3f(0.0378112793f, 0.134198189f, 0.f),
    C_Vertex3f(0.0378112793f, 0.134198189f, -1.f),
    C_Normal3f(-0.990410566f, -0.138155445f, 0.f),
    C_Vertex3f(0.0328273773f, 0.162439346f, 0.f),
    C_Vertex3f(0.0328273773f, 0.162439346f, -1.f),
    C_Normal3f(-0.997474432f, -0.0710260496f, 0.f),
    C_Vertex3f(0.0317382813f, 0.177734375f, 0.f),
    C_Vertex3f(0.0317382813f, 0.177734375f, -1.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.182089254f, 0.98328203f, 0.f),
    C_Vertex3f(0.0317382813f, 0.177734375f, 0.f),
    C_Vertex3f(0.0317382813f, 0.177734375f, -1.f),
    C_Vertex3f(0.110839844f, 0.192382813f, -1.f),
    C_Vertex3f(0.110839844f, 0.192382813f, 0.f),
    C_End(),
    C_Begin(GL_QUAD_STRIP),
    C_Normal3f(0.989745557f, 0.142841265f, 0.f),
    C_Vertex3f(0.110839844f, 0.192382813f, 0.f),
    C_Vertex3f(0.110839844f, 0.192382813f, -1.f),
    C_Normal3f(0.98582685f, 0.167765915f, 0.f),
    C_Vertex3f(0.111981392f, 0.184473038f, 0.f),
    C_Vertex3f(0.111981392f, 0.184473038f, -1.f),
    C_Normal3f(0.979420185f, 0.201831445f, 0.f),
    C_Vertex3f(0.114699364f, 0.169703484f, 0.f),
    C_Vertex3f(0.114699364f, 0.169703484f, -1.f),
    C_Normal3f(0.968891919f, 0.247483939f, 0.f),
    C_Vertex3f(0.117852211f, 0.155983925f, 0.f),
    C_Vertex3f(0.117852211f, 0.155983925f, -1.f),
    C_Normal3f(0.954256356f, 0.298989564f, 0.f),
    C_Vertex3f(0.121439934f, 0.143314362f, 0.f),
    C_Vertex3f(0.121439934f, 0.143314362f, -1.f),
    C_Normal3f(0.934108198f, 0.356990159f, 0.f),
    C_Vertex3f(0.125462532f, 0.131694794f, 0.f),
    C_Vertex3f(0.125462532f, 0.131694794f, -1.f),
    C_Normal3f(0.906616926f, 0.421954513f, 0.f),
    C_Vertex3f(0.129920006f, 0.121125221f, 0.f),
    C_Vertex3f(0.129920006f, 0.121125221f, -1.f),
    C_Normal3f(0.869488537f, 0.493953198f, 0.f),
    C_Vertex3f(0.134812355f, 0.111605644f, 0.f),
    C_Vertex3f(0.134812355f, 0.111605644f, -1.f),
    C_Normal3f(0.81595248f, 0.57811898f, 0.f),
    C_Vertex3f(0.14013958f, 0.103136063f, 0.f),
    C_Vertex3f(0.14013958f, 0.103136063f, -1.f),
    C_Normal3f(0.758622766f, 0.651530087f, 0.f),
    C_Vertex3f(0.147151947f, 0.0941896439f, 0.f),
    C_Vertex3f(0.147151947f, 0.0941896439f, -1.f),
    C_Normal3f(0.701474249f, 0.712694764f, 0.f),
    C_Vertex3f(0.155822277f, 0.0848755836f, 0.f),
    C_Vertex3f(0.155822277f, 0.0848755836f, -1.f),
    C_Normal3f(0.632287979f, 0.774733365f, 0.f),
    C_Vertex3f(0.164900303f, 0.0767207146f, 0.f),
    C_Vertex3f(0.164900303f, 0.0767207146f, -1.f),
    C_Normal3f(0.552098334f, 0.833779037f, 0.f),
    C_Vertex3f(0.174386024f, 0.0697250366f, 0.f),
    C_Vertex3f(0.174386024f, 0.0697250366f, -1.f),
    C_Normal3f(0.46178925f, 0.886989713f, 0.f),
    C_Vertex3f(0.184279442f, 0.0638885498f, 0.f),
    C_Vertex3f(0.184279442f, 0.0638885498f, -1.f),
    C_Normal3f(0.363404214f, 0.931631625f, 0.f),
    C_Vertex3f(0.194580555f, 0.0592112541f, 0.f),
    C_Vertex3f(0.194580555f, 0.0592112541f, -1.f),
    C_Normal3f(0.26001358f, 0.965604961f, 0.f),
    C_Vertex3f(0.205289364f, 0.0556931496f, 0.f),
    C_Vertex3f(0.205289364f, 0.0556931496f, -1.f),
    C_Normal3f(0.172664493f, 0.984980643f, 0.f),
    C_Vertex3f(0.216405869f, 0.0533342361f, 0.f),
    C_Vertex3f(0.216405869f, 0.0533342361f, -1.f),
    C_Normal3f(0.103545018f, 0.994624794f, 0.f),
    C_Vertex3f(0.222167969f, 0.052734375f, 0.f),
    C_Vertex3f(0.222167969f, 0.052734375f, -1.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.99999994f, 0.f, 0.f),
    C_Vertex3f(0.222167969f, 0.052734375f, 0.f),
    C_Vertex3f(0.222167969f, 0.052734375f, -1.f),
    C_Vertex3f(0.222167969f, 0.300125122f, -1.f),
    C_Vertex3f(0.222167969f, 0.300125122f, 0.f),
    C_End(),
    C_Begin(GL_QUAD_STRIP),
    C_Normal3f(-0.248605967f, -0.968604743f, 0.f),
    C_Vertex3f(0.222167969f, 0.300125122f, 0.f),
    C_Vertex3f(0.222167969f, 0.300125122f, -1.f),
    C_Normal3f(-0.295930803f, -0.955209434f, 0.f),
    C_Vertex3f(0.21021843f, 0.303192139f, 0.f),
    C_Vertex3f(0.21021843f, 0.303192139f, -1.f),
    C_Normal3f(-0.350919276f, -0.936405778f, 0.f),
    C_Vertex3f(0.185955048f, 0.311344147f, 0.f),
    C_Vertex3f(0.185955048f, 0.311344147f, -1.f),
    C_Normal3f(-0.41080907f, -0.911721408f, 0.f),
    C_Vertex3f(0.161327362f, 0.32151413f, 0.f),
    C_Vertex3f(0.161327362f, 0.32151413f, -1.f),
    C_Normal3f(-0.462284803f, -0.886731565f, 0.f),
    C_Vertex3f(0.136335373f, 0.333702087f, 0.f),
    C_Vertex3f(0.136335373f, 0.333702087f, -1.f),
    C_Normal3f(-0.540422857f, -0.84139359f, 0.f),
    C_Vertex3f(0.11425972f, 0.34605217f, 0.f),
    C_Vertex3f(0.11425972f, 0.34605217f, -1.f),
    C_Normal3f(-0.656078458f, -0.754692614f, 0.f),
    C_Vertex3f(0.0976223946f, 0.358567238f, 0.f),
    C_Vertex3f(0.0976223946f, 0.358567238f, -1.f),
    C_Normal3f(-0.757439077f, -0.652905822f, 0.f),
    C_Vertex3f(0.0831427574f, 0.373103142f, 0.f),
    C_Vertex3f(0.0831427574f, 0.373103142f, -1.f),
    C_Normal3f(-0.842268705f, -0.53905791f, 0.f),
    C_Vertex3f(0.0708208084f, 0.389659882f, 0.f),
    C_Vertex3f(0.0708208084f, 0.389659882f, -1.f),
    C_Normal3f(-0.907430172f, -0.420202941f, 0.f),
    C_Vertex3f(0.0606565475f, 0.408237457f, 0.f),
    C_Vertex3f(0.0606565475f, 0.408237457f, -1.f),
    C_Normal3f(-0.95503664f, -0.296487749f, 0.f),
    C_Vertex3f(0.0530333519f, 0.428071976f, 0.f),
    C_Vertex3f(0.0530333519f, 0.428071976f, -1.f),
    C_Normal3f(-0.984948635f, -0.172847137f, 0.f),
    C_Vertex3f(0.0479512215f, 0.449163437f, 0.f),
    C_Vertex3f(0.0479512215f, 0.449163437f, -1.f),
    C_Normal3f(-0.998383999f, -0.0568283983f, 0.f),
    C_Vertex3f(0.0454101563f, 0.471511841f, 0.f),
    C_Vertex3f(0.0454101563f, 0.471511841f, -1.f),
    C_Normal3f(-0.999043703f, 0.0437230207f, 0.f),
    C_Vertex3f(0.0454101563f, 0.493805885f, 0.f),
    C_Vertex3f(0.0454101563f, 0.493805885f, -1.f),
    C_Normal3f(-0.990008652f, 0.141006738f, 0.f),
    C_Vertex3f(0.0472605228f, 0.513791561f, 0.f),
    C_Vertex3f(0.0472605228f, 0.513791561f, -1.f),
    C_Normal3f(-0.970100522f, 0.242703378f, 0.f),
    C_Vertex3f(0.050961256f, 0.53278017f, 0.f),
    C_Vertex3f(0.050961256f, 0.53278017f, -1.f),
    C_Normal3f(-0.937794328f, 0.347191334f, 0.f),
    C_Vertex3f(0.0565123558f, 0.550771713f, 0.f),
    C_Vertex3f(0.0565123558f, 0.550771713f, -1.f),
    C_Normal3f(-0.89271754f, 0.450616628f, 0.f),
    C_Vertex3f(0.0639138222f, 0.56776619f, 0.f),
    C_Vertex3f(0.0639138222f, 0.56776619f, -1.f),
    C_Normal3f(-0.835902452f, 0.548878014f, 0.f),
    C_Vertex3f(0.0731656551f, 0.583763599f, 0.f),
    C_Vertex3f(0.0731656551f, 0.583763599f, -1.f),
    C_Normal3f(-0.769719124f, 0.638382792f, 0.f),
    C_Vertex3f(0.0842678547f, 0.598763943f, 0.f),
    C_Vertex3f(0.0842678547f, 0.598763943f, -1.f),
    C_Normal3f(-0.7010445f, 0.71311754f, 0.f),
    C_Vertex3f(0.0972204208f, 0.61276722f, 0.f),
    C_Vertex3f(0.0972204208f, 0.61276722f, -1.f),
    C_Normal3f(-0.624821782f, 0.780767322f, 0.f),
    C_Vertex3f(0.109574318f, 0.623641968f, 0.f),
    C_Vertex3f(0.109574318f, 0.623641968f, -1.f),
    C_Normal3f(-0.538251579f, 0.842784226f, 0.f),
    C_Vertex3f(0.120676279f, 0.631538153f, 0.f),
    C_Vertex3f(0.120676279f, 0.631538153f, -1.f),
    C_Normal3f(-0.456937611f, 0.889498711f, 0.f),
    C_Vertex3f(0.13297534f, 0.638587236f, 0.f),
    C_Vertex3f(0.13297534f, 0.638587236f, -1.f),
    C_Normal3f(-0.379330844f, 0.92526108f, 0.f),
    C_Vertex3f(0.1464715f, 0.644789219f, 0.f),
    C_Vertex3f(0.1464715f, 0.644789219f, -1.f),
    C_Normal3f(-0.306917578f, 0.951736093f, 0.f),
    C_Vertex3f(0.161164761f, 0.6501441f, 0.f),
    C_Vertex3f(0.161164761f, 0.6501441f, -1.f),
    C_Normal3f(-0.240429789f, 0.970666587f, 0.f),
    C_Vertex3f(0.17705512f, 0.65465188f, 0.f),
    C_Vertex3f(0.17705512f, 0.65465188f, -1.f),
    C_Normal3f(-0.180042297f, 0.983658791f, 0.f),
    C_Vertex3f(0.19414258f, 0.658312559f, 0.f),
    C_Vertex3f(0.19414258f, 0.658312559f, -1.f),
    C_Normal3f(-0.134251282f, 0.990947306f, 0.f),
    C_Vertex3f(0.212427139f, 0.661126137f, 0.f),
    C_Vertex3f(0.212427139f, 0.661126137f, -1.f),
    C_Normal3f(-0.100429557f, 0.994944215f, 0.f),
    C_Vertex3f(0.222167969f, 0.662109375f, 0.f),
    C_Vertex3f(0.222167969f, 0.662109375f, -1.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.222167969f, 0.662109375f, 0.f),
    C_Vertex3f(0.222167969f, 0.662109375f, -1.f),
    C_Vertex3f(0.222167969f, 0.699707031f, -1.f),
    C_Vertex3f(0.222167969f, 0.699707031f, 0.f),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.222167969f, 0.699707031f, 0.f),
    C_Vertex3f(0.222167969f, 0.699707031f, -1.f),
    C_Vertex3f(0.268554688f, 0.699707031f, -1.f),
    C_Vertex3f(0.268554688f, 0.699707031f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.268554688f, 0.699707031f, 0.f),
    C_Vertex3f(0.268554688f, 0.699707031f, -1.f),
    C_Vertex3f(0.268554688f, 0.662109375f, -1.f),
    C_Vertex3f(0.268554688f, 0.662109375f, 0.f),
    C_End(),
    C_Begin(GL_QUAD_STRIP),
    C_Normal3f(0.0959435776f, 0.995386779f, 0.f),
    C_Vertex3f(0.268554688f, 0.662109375f, 0.f),
    C_Vertex3f(0.268554688f, 0.662109375f, -1.f),
    C_Normal3f(0.133008912f, 0.991114914f, 0.f),
    C_Vertex3f(0.277083397f, 0.661287308f, 0.f),
    C_Vertex3f(0.277083397f, 0.661287308f, -1.f),
    C_Normal3f(0.182337344f, 0.983235955f, 0.f),
    C_Vertex3f(0.293257952f, 0.658794165f, 0.f),
    C_Vertex3f(0.293257952f, 0.658794165f, -1.f),
    C_Normal3f(0.245857179f, 0.969306171f, 0.f),
    C_Vertex3f(0.308549643f, 0.655452013f, 0.f),
    C_Vertex3f(0.308549643f, 0.655452013f, -1.f),
    C_Normal3f(0.313771278f, 0.949498653f, 0.f),
    C_Vertex3f(0.322958469f, 0.651260853f, 0.f),
    C_Vertex3f(0.322958469f, 0.651260853f, -1.f),
    C_Normal3f(0.385383517f, 0.922756493f, 0.f),
    C_Vertex3f(0.336484432f, 0.646220684f, 0.f),
    C_Vertex3f(0.336484432f, 0.646220684f, -1.f),
    C_Normal3f(0.459565043f, 0.888144195f, 0.f),
    C_Vertex3f(0.349127531f, 0.640331507f, 0.f),
    C_Vertex3f(0.349127531f, 0.640331507f, -1.f),
    C_Normal3f(0.534738481f, 0.845017672f, 0.f),
    C_Vertex3f(0.360887766f, 0.633593321f, 0.f),
    C_Vertex3f(0.360887766f, 0.633593321f, -1.f),
    C_Normal3f(0.610403895f, 0.792090356f, 0.f),
    C_Vertex3f(0.371765137f, 0.626006126f, 0.f),
    C_Vertex3f(0.371765137f, 0.626006126f, -1.f),
    C_Normal3f(0.680616021f, 0.732640386f, 0.f),
    C_Vertex3f(0.383172989f, 0.616419792f, 0.f),
    C_Vertex3f(0.383172989f, 0.616419792f, -1.f),
    C_Normal3f(0.746510267f, 0.665373981f, 0.f),
    C_Vertex3f(0.394717455f, 0.604683638f, 0.f),
    C_Vertex3f(0.394717455f, 0.604683638f, -1.f),
    C_Normal3f(0.808636844f, 0.588308096f, 0.f),
    C_Vertex3f(0.404985189f, 0.591947794f, 0.f),
    C_Vertex3f(0.404985189f, 0.591947794f, -1.f),
    C_Normal3f(0.86249274f, 0.506069422f, 0.f),
    C_Vertex3f(0.413976192f, 0.578212261f, 0.f),
    C_Vertex3f(0.413976192f, 0.578212261f, -1.f),
    C_Normal3f(0.9069525f, 0.421232849f, 0.f),
    C_Vertex3f(0.421690464f, 0.563477039f, 0.f),
    C_Vertex3f(0.421690464f, 0.563477039f, -1.f),
    C_Normal3f(0.941722631f, 0.336390257f, 0.f),
    C_Vertex3f(0.428128004f, 0.547742128f, 0.f),
    C_Vertex3f(0.428128004f, 0.547742128f, -1.f),
    C_Normal3f(0.96725297f, 0.253814161f, 0.f),
    C_Vertex3f(0.433288813f, 0.531007528f, 0.f),
    C_Vertex3f(0.433288813f, 0.531007528f, -1.f),
    C_Normal3f(0.982167661f, 0.18800737f, 0.f),
    C_Vertex3f(0.43717289f, 0.513273239f, 0.f),
    C_Vertex3f(0.43717289f, 0.513273239f, -1.f),
    C_Normal3f(0.990453243f, 0.13784866f, 0.f),
    C_Vertex3f(0.438476563f, 0.50390625f, 0.f),
    C_Vertex3f(0.438476563f, 0.50390625f, -1.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(0.14892301f, -0.988848746f, 0.f),
    C_Vertex3f(0.438476563f, 0.50390625f, 0.f),
    C_Vertex3f(0.438476563f, 0.50390625f, -1.f),
    C_Vertex3f(0.357421875f, 0.491699219f, -1.f),
    C_Vertex3f(0.357421875f, 0.491699219f, 0.f),
    C_End(),
    C_Begin(GL_QUAD_STRIP),
    C_Normal3f(-0.989068091f, -0.14745988f, 0.f),
    C_Vertex3f(0.357421875f, 0.491699219f, 0.f),
    C_Vertex3f(0.357421875f, 0.491699219f, -1.f),
    C_Normal3f(-0.976688147f, -0.214662939f, 0.f),
    C_Vertex3f(0.355688095f, 0.503328323f, 0.f),
    C_Vertex3f(0.355688095f, 0.503328323f, -1.f),
    C_Normal3f(-0.950497031f, -0.310733527f, 0.f),
    C_Vertex3f(0.350350857f, 0.523871422f, 0.f),
    C_Vertex3f(0.350350857f, 0.523871422f, -1.f),
    C_Normal3f(-0.896452665f, -0.443139493f, 0.f),
    C_Vertex3f(0.34314394f, 0.541699409f, 0.f),
    C_Vertex3f(0.34314394f, 0.541699409f, -1.f),
    C_Normal3f(-0.808524549f, -0.588462472f, 0.f),
    C_Vertex3f(0.334067345f, 0.556812286f, 0.f),
    C_Vertex3f(0.334067345f, 0.556812286f, -1.f),
    C_Normal3f(-0.688031852f, -0.72568047f, 0.f),
    C_Vertex3f(0.323121071f, 0.569210052f, 0.f),
    C_Vertex3f(0.323121071f, 0.569210052f, -1.f),
    C_Normal3f(-0.550557852f, -0.834797025f, 0.f),
    C_Vertex3f(0.310142994f, 0.57949543f, 0.f),
    C_Vertex3f(0.310142994f, 0.57949543f, -1.f),
    C_Normal3f(-0.405863434f, -0.913933754f, 0.f),
    C_Vertex3f(0.295133114f, 0.587668419f, 0.f),
    C_Vertex3f(0.295133114f, 0.587668419f, -1.f),
    C_Normal3f(-0.289368659f, -0.957217753f, 0.f),
    C_Vertex3f(0.278091431f, 0.593729019f, 0.f),
    C_Vertex3f(0.278091431f, 0.593729019f, -1.f),
    C_Normal3f(-0.202702746f, -0.979240298f, 0.f),
    C_Vertex3f(0.268554688f, 0.595703125f, 0.f),
    C_Vertex3f(0.268554688f, 0.595703125f, -1.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.268554688f, 0.595703125f, 0.f),
    C_Vertex3f(0.268554688f, 0.595703125f, -1.f),
    C_Vertex3f(0.268554688f, 0.369354248f, -1.f),
    C_Vertex3f(0.268554688f, 0.369354248f, 0.f),
    C_End(),
    C_Begin(GL_QUAD_STRIP),
    C_Normal3f(0.251965344f, 0.967736304f, 0.f),
    C_Vertex3f(0.268554688f, 0.369354248f, 0.f),
    C_Vertex3f(0.268554688f, 0.369354248f, -1.f),
    C_Normal3f(0.25642693f, 0.966563582f, 0.f),
    C_Vertex3f(0.275960922f, 0.367425919f, 0.f),
    C_Vertex3f(0.275960922f, 0.367425919f, -1.f),
    C_Normal3f(0.262785554f, 0.96485424f, 0.f),
    C_Vertex3f(0.289520979f, 0.363791943f, 0.f),
    C_Vertex3f(0.289520979f, 0.363791943f, -1.f),
    C_Normal3f(0.27185598f, 0.962337911f, 0.f),
    C_Vertex3f(0.301828623f, 0.36038065f, 0.f),
    C_Vertex3f(0.301828623f, 0.36038065f, -1.f),
    C_Normal3f(0.28300488f, 0.959118426f, 0.f),
    C_Vertex3f(0.312883854f, 0.357192039f, 0.f),
    C_Vertex3f(0.312883854f, 0.357192039f, -1.f),
    C_Normal3f(0.297032356f, 0.954867363f, 0.f),
    C_Vertex3f(0.322686672f, 0.354226112f, 0.f),
    C_Vertex3f(0.322686672f, 0.354226112f, -1.f),
    C_Normal3f(0.315203935f, 0.949023962f, 0.f),
    C_Vertex3f(0.331237078f, 0.351482868f, 0.f),
    C_Vertex3f(0.331237078f, 0.351482868f, -1.f),
    C_Normal3f(0.339639902f, 0.940555513f, 0.f),
    C_Vertex3f(0.33853507f, 0.348962307f, 0.f),
    C_Vertex3f(0.33853507f, 0.348962307f, -1.f),
    C_Normal3f(0.386725634f, 0.922194779f, 0.f),
    C_Vertex3f(0.34458065f, 0.346664429f, 0.f),
    C_Vertex3f(0.34458065f, 0.346664429f, -1.f),
    C_Normal3f(0.446164489f, 0.894950986f, 0.f),
    C_Vertex3f(0.356126785f, 0.341585159f, 0.f),
    C_Vertex3f(0.356126785f, 0.341585159f, -1.f),
    C_Normal3f(0.511901081f, 0.859044433f, 0.f),
    C_Vertex3f(0.372737408f, 0.332627296f, 0.f),
    C_Vertex3f(0.372737408f, 0.332627296f, -1.f),
    C_Normal3f(0.589340925f, 0.807884455f, 0.f),
    C_Vertex3f(0.38765955f, 0.322794914f, 0.f),
    C_Vertex3f(0.38765955f, 0.322794914f, -1.f),
    C_Normal3f(0.668755233f, 0.743482649f, 0.f),
    C_Vertex3f(0.400893211f, 0.312088013f, 0.f),
    C_Vertex3f(0.400893211f, 0.312088013f, -1.f),
    C_Normal3f(0.744409382f, 0.667723477f, 0.f),
    C_Vertex3f(0.412438393f, 0.300506592f, 0.f),
    C_Vertex3f(0.412438393f, 0.300506592f, -1.f),
    C_Normal3f(0.810778737f, 0.585352838f, 0.f),
    C_Vertex3f(0.422649384f, 0.287833214f, 0.f),
    C_Vertex3f(0.422649384f, 0.287833214f, -1.f),
    C_Normal3f(0.867411375f, 0.497591794f, 0.f),
    C_Vertex3f(0.431526184f, 0.274067879f, 0.f),
    C_Vertex3f(0.431526184f, 0.274067879f, -1.f),
    C_Normal3f(0.913158715f, 0.407604098f, 0.f),
    C_Vertex3f(0.439068794f, 0.259210587f, 0.f),
    C_Vertex3f(0.439068794f, 0.259210587f, -1.f),
    C_Normal3f(0.948565185f, 0.316582084f, 0.f),
    C_Vertex3f(0.445277214f, 0.243261337f, 0.f),
    C_Vertex3f(0.445277214f, 0.243261337f, -1.f),
    C_Normal3f(0.97473222f, 0.223376706f, 0.f),
    C_Vertex3f(0.449933529f, 0.226656914f, 0.f),
    C_Vertex3f(0.449933529f, 0.226656914f, -1.f),
    C_Normal3f(0.991351604f, 0.1312332f, 0.f),
    C_Vertex3f(0.453037739f, 0.209397316f, 0.f),
    C_Vertex3f(0.453037739f, 0.209397316f, -1.f),
    C_Normal3f(0.99914068f, 0.0414483435f, 0.f),
    C_Vertex3f(0.454589844f, 0.191482544f, 0.f),
    C_Vertex3f(0.454589844f, 0.191482544f, -1.f),
    C_Normal3f(0.999141812f, -0.0414194837f, 0.f),
    C_Vertex3f(0.454589844f, 0.171982765f, 0.f),
    C_Vertex3f(0.454589844f, 0.171982765f, -1.f),
    C_Normal3f(0.992051125f, -0.125835374f, 0.f),
    C_Vertex3f(0.45296967f, 0.152399898f, 0.f),
    C_Vertex3f(0.45296967f, 0.152399898f, -1.f),
    C_Normal3f(0.976401925f, -0.21596159f, 0.f),
    C_Vertex3f(0.449729323f, 0.133663774f, 0.f),
    C_Vertex3f(0.449729323f, 0.133663774f, -1.f),
    C_Normal3f(0.951127589f, -0.308798134f, 0.f),
    C_Vertex3f(0.444868803f, 0.115774393f, 0.f),
    C_Vertex3f(0.444868803f, 0.115774393f, -1.f),
    C_Normal3f(0.915755212f, -0.401736796f, 0.f),
    C_Vertex3f(0.438388109f, 0.0987317562f, 0.f),
    C_Vertex3f(0.438388109f, 0.0987317562f, -1.f),
    C_Normal3f(0.870656192f, -0.49189201f, 0.f),
    C_Vertex3f(0.430287242f, 0.0825358629f, 0.f),
    C_Vertex3f(0.430287242f, 0.0825358629f, -1.f),
    C_Normal3f(0.817089498f, -0.576510906f, 0.f),
    C_Vertex3f(0.420566201f, 0.0671867132f, 0.f),
    C_Vertex3f(0.420566201f, 0.0671867132f, -1.f),
    C_Normal3f(0.757032156f, -0.653377593f, 0.f),
    C_Vertex3f(0.409224987f, 0.0526843071f, 0.f),
    C_Vertex3f(0.409224987f, 0.0526843071f, -1.f),
    C_Normal3f(0.691500723f, -0.72237581f, 0.f),
    C_Vertex3f(0.396263599f, 0.0390286446f, 0.f),
    C_Vertex3f(0.396263599f, 0.0390286446f, -1.f),
    C_Normal3f(0.616880596f, -0.787056804f, 0.f),
    C_Vertex3f(0.382349133f, 0.0269571543f, 0.f),
    C_Vertex3f(0.382349133f, 0.0269571543f, -1.f),
    C_Normal3f(0.534159601f, -0.845383584f, 0.f),
    C_Vertex3f(0.367481589f, 0.0164698362f, 0.f),
    C_Vertex3f(0.367481589f, 0.0164698362f, -1.f),
    C_Normal3f(0.445563942f, -0.895250142f, 0.f),
    C_Vertex3f(0.351660967f, 0.00756669044f, 0.f),
    C_Vertex3f(0.351660967f, 0.00756669044f, -1.f),
    C_Normal3f(0.35388118f, -0.935290396f, 0.f),
    C_Vertex3f(0.334887266f, 0.000247716904f, 0.f),
    C_Vertex3f(0.334887266f, 0.000247716904f, -1.f),
    C_Normal3f(0.262040257f, -0.965057015f, 0.f),
    C_Vertex3f(0.317160487f, -0.00548708439f, 0.f),
    C_Vertex3f(0.317160487f, -0.00548708439f, -1.f),
    C_Normal3f(0.17268832f, -0.98497647f, 0.f),
    C_Vertex3f(0.29848063f, -0.00963771343f, 0.f),
    C_Vertex3f(0.29848063f, -0.00963771343f, -1.f),
    C_Normal3f(0.101643033f, -0.994820893f, 0.f),
    C_Vertex3f(0.278847694f, -0.0122041702f, 0.f),
    C_Vertex3f(0.278847694f, -0.0122041702f, -1.f),
    C_Normal3f(0.0476618819f, -0.998863459f, 0.f),
    C_Vertex3f(0.268554688f, -0.0126953125f, 0.f),
    C_Vertex3f(0.268554688f, -0.0126953125f, -1.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.268554688f, -0.0126953125f, 0.f),
    C_Vertex3f(0.268554688f, -0.0126953125f, -1.f),
    C_Vertex3f(0.268554688f, -0.0922851563f, -1.f),
    C_Vertex3f(0.268554688f, -0.0922851563f, 0.f),
    C_Normal3f(-0.f, -1.f, 0.f),
    C_Vertex3f(0.268554688f, -0.0922851563f, 0.f),
    C_Vertex3f(0.268554688f, -0.0922851563f, -1.f),
    C_Vertex3f(0.222167969f, -0.0922851563f, -1.f),
    C_Vertex3f(0.222167969f, -0.0922851563f, 0.f),
    C_End(),
    C_Begin(GL_QUAD_STRIP),
    C_Normal3f(0.151808649f, -0.988409877f, 0.f),
    C_Vertex3f(0.222167969f, 0.596679688f, 0.f),
    C_Vertex3f(0.222167969f, 0.596679688f, -1.f),
    C_Normal3f(0.246894479f, -0.969042301f, 0.f),
    C_Vertex3f(0.210767746f, 0.594928741f, 0.f),
    C_Vertex3f(0.210767746f, 0.594928741f, -1.f),
    C_Normal3f(0.375525355f, -0.926812112f, 0.f),
    C_Vertex3f(0.190383434f, 0.588581562f, 0.f),
    C_Vertex3f(0.190383434f, 0.588581562f, -1.f),
    C_Normal3f(0.535065472f, -0.844810486f, 0.f),
    C_Vertex3f(0.172415257f, 0.579389095f, 0.f),
    C_Vertex3f(0.172415257f, 0.579389095f, -1.f),
    C_Normal3f(0.684290588f, -0.729209363f, 0.f),
    C_Vertex3f(0.156863213f, 0.567351341f, 0.f),
    C_Vertex3f(0.156863213f, 0.567351341f, -1.f),
    C_Normal3f(0.804467916f, -0.593996048f, 0.f),
    C_Vertex3f(0.143727303f, 0.5524683f, 0.f),
    C_Vertex3f(0.143727303f, 0.5524683f, -1.f),
    C_Normal3f(0.899820924f, -0.436259538f, 0.f),
    C_Vertex3f(0.13387537f, 0.536218166f, 0.f),
    C_Vertex3f(0.13387537f, 0.536218166f, -1.f),
    C_Normal3f(0.965631187f, -0.259916186f, 0.f),
    C_Vertex3f(0.127307415f, 0.518600941f, 0.f),
    C_Vertex3f(0.127307415f, 0.518600941f, -1.f),
    C_Normal3f(0.99651432f, -0.0834213868f, 0.f),
    C_Vertex3f(0.124023438f, 0.499616623f, 0.f),
    C_Vertex3f(0.124023438f, 0.499616623f, -1.f),
    C_Normal3f(0.997366369f, 0.0725276992f, 0.f),
    C_Vertex3f(0.124023438f, 0.479372025f, 0.f),
    C_Vertex3f(0.124023438f, 0.479372025f, -1.f),
    C_Normal3f(0.97258848f, 0.232533291f, 0.f),
    C_Vertex3f(0.126840591f, 0.460876465f, 0.f),
    C_Vertex3f(0.126840591f, 0.460876465f, -1.f),
    C_Normal3f(0.915552616f, 0.402198344f, 0.f),
    C_Vertex3f(0.132474899f, 0.444023132f, 0.f),
    C_Vertex3f(0.132474899f, 0.444023132f, -1.f),
    C_Normal3f(0.832386851f, 0.554194987f, 0.f),
    C_Vertex3f(0.140926361f, 0.428812027f, 0.f),
    C_Vertex3f(0.140926361f, 0.428812027f, -1.f),
    C_Normal3f(0.739837706f, 0.672785282f, 0.f),
    C_Vertex3f(0.149377823f, 0.418635368f, 0.f),
    C_Vertex3f(0.149377823f, 0.418635368f, -1.f),
    C_Normal3f(0.656612396f, 0.754228115f, 0.f),
    C_Vertex3f(0.155966282f, 0.412273169f, 0.f),
    C_Vertex3f(0.155966282f, 0.412273169f, -1.f),
    C_Normal3f(0.58127135f, 0.813709736f, 0.f),
    C_Vertex3f(0.163508892f, 0.406333208f, 0.f),
    C_Vertex3f(0.163508892f, 0.406333208f, -1.f),
    C_Normal3f(0.509005129f, 0.86076349f, 0.f),
    C_Vertex3f(0.172005653f, 0.400815487f, 0.f),
    C_Vertex3f(0.172005653f, 0.400815487f, -1.f),
    C_Normal3f(0.441446662f, 0.897287548f, 0.f),
    C_Vertex3f(0.181456566f, 0.395720005f, 0.f),
    C_Vertex3f(0.181456566f, 0.395720005f, -1.f),
    C_Normal3f(0.37938574f, 0.925238609f, 0.f),
    C_Vertex3f(0.191861629f, 0.391046762f, 0.f),
    C_Vertex3f(0.191861629f, 0.391046762f, -1.f),
    C_Normal3f(0.323016644f, 0.946393311f, 0.f),
    C_Vertex3f(0.203220844f, 0.386795759f, 0.f),
    C_Vertex3f(0.203220844f, 0.386795759f, -1.f),
    C_Normal3f(0.280269921f, 0.959921181f, 0.f),
    C_Vertex3f(0.21553421f, 0.382966995f, 0.f),
    C_Vertex3f(0.21553421f, 0.382966995f, -1.f),
    C_Normal3f(0.248690262f, 0.968583107f, 0.f),
    C_Vertex3f(0.222167969f, 0.381263733f, 0.f),
    C_Vertex3f(0.222167969f, 0.381263733f, -1.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.222167969f, 0.381263733f, 0.f),
    C_Vertex3f(0.222167969f, 0.381263733f, -1.f),
    C_Vertex3f(0.222167969f, 0.596679688f, -1.f),
    C_Vertex3f(0.222167969f, 0.596679688f, 0.f),
    C_End(),
    C_Begin(GL_QUAD_STRIP),
    C_Normal3f(-0.123830169f, 0.992303491f, 0.f),
    C_Vertex3f(0.268554688f, 0.052734375f, 0.f),
    C_Vertex3f(0.268554688f, 0.052734375f, -1.f),
    C_Normal3f(-0.179115683f, 0.983828068f, 0.f),
    C_Vertex3f(0.274248123f, 0.0534448624f, 0.f),
    C_Vertex3f(0.274248123f, 0.0534448624f, -1.f),
    C_Normal3f(-0.250397712f, 0.968143046f, 0.f),
    C_Vertex3f(0.285140276f, 0.0557539463f, 0.f),
    C_Vertex3f(0.285140276f, 0.0557539463f, -1.f),
    C_Normal3f(-0.337670147f, 0.94126451f, 0.f),
    C_Vertex3f(0.29553771f, 0.0589511395f, 0.f),
    C_Vertex3f(0.29553771f, 0.0589511395f, -1.f),
    C_Normal3f(-0.424695879f, 0.905336022f, 0.f),
    C_Vertex3f(0.305440426f, 0.0630364418f, 0.f),
    C_Vertex3f(0.305440426f, 0.0630364418f, -1.f),
    C_Normal3f(-0.509033024f, 0.86074692f, 0.f),
    C_Vertex3f(0.314848423f, 0.0680098534f, 0.f),
    C_Vertex3f(0.314848423f, 0.0680098534f, -1.f),
    C_Normal3f(-0.58836019f, 0.808598995f, 0.f),
    C_Vertex3f(0.323761702f, 0.0738713741f, 0.f),
    C_Vertex3f(0.323761702f, 0.0738713741f, -1.f),
    C_Normal3f(-0.660784662f, 0.750575602f, 0.f),
    C_Vertex3f(0.332180262f, 0.0806210041f, 0.f),
    C_Vertex3f(0.332180262f, 0.0806210041f, -1.f),
    C_Normal3f(-0.725054145f, 0.688691795f, 0.f),
    C_Vertex3f(0.340104103f, 0.0882587433f, 0.f),
    C_Vertex3f(0.340104103f, 0.0882587433f, -1.f),
    C_Normal3f(-0.783389568f, 0.62153089f, 0.f),
    C_Vertex3f(0.347533226f, 0.0967845917f, 0.f),
    C_Vertex3f(0.347533226f, 0.0967845917f, -1.f),
    C_Normal3f(-0.838379622f, 0.545086682f, 0.f),
    C_Vertex3f(0.354033709f, 0.105815887f, 0.f),
    C_Vertex3f(0.354033709f, 0.105815887f, -1.f),
    C_Normal3f(-0.886585832f, 0.46256417f, 0.f),
    C_Vertex3f(0.359605551f, 0.115352631f, 0.f),
    C_Vertex3f(0.359605551f, 0.115352631f, -1.f),
    C_Normal3f(-0.926574111f, 0.376112252f, 0.f),
    C_Vertex3f(0.364248753f, 0.125394821f, 0.f),
    C_Vertex3f(0.364248753f, 0.125394821f, -1.f),
    C_Normal3f(-0.957578659f, 0.288171977f, 0.f),
    C_Vertex3f(0.367963314f, 0.135942459f, 0.f),
    C_Vertex3f(0.367963314f, 0.135942459f, -1.f),
    C_Normal3f(-0.979560733f, 0.201148733f, 0.f),
    C_Vertex3f(0.370749235f, 0.146995544f, 0.f),
    C_Vertex3f(0.370749235f, 0.146995544f, -1.f),
    C_Normal3f(-0.993117392f, 0.117123306f, 0.f),
    C_Vertex3f(0.372606516f, 0.158554077f, 0.f),
    C_Vertex3f(0.372606516f, 0.158554077f, -1.f),
    C_Normal3f(-0.999489784f, 0.0319392607f, 0.f),
    C_Vertex3f(0.373535156f, 0.170618057f, 0.f),
    C_Vertex3f(0.373535156f, 0.170618057f, -1.f),
    C_Normal3f(-0.997525215f, -0.0703087673f, 0.f),
    C_Vertex3f(0.373535156f, 0.187614441f, 0.f),
    C_Vertex3f(0.373535156f, 0.187614441f, -1.f),
    C_Normal3f(-0.978618085f, -0.205686048f, 0.f),
    C_Vertex3f(0.370975494f, 0.206933975f, 0.f),
    C_Vertex3f(0.370975494f, 0.206933975f, -1.f),
    C_Normal3f(-0.929787338f, -0.368096828f, 0.f),
    C_Vertex3f(0.365856171f, 0.224149704f, 0.f),
    C_Vertex3f(0.365856171f, 0.224149704f, -1.f),
    C_Normal3f(-0.8508237f, -0.525451183f, 0.f),
    C_Vertex3f(0.358177185f, 0.239261627f, 0.f),
    C_Vertex3f(0.358177185f, 0.239261627f, -1.f),
    C_Normal3f(-0.748062432f, -0.66362828f, 0.f),
    C_Vertex3f(0.350498199f, 0.249017715f, 0.f),
    C_Vertex3f(0.350498199f, 0.249017715f, -1.f),
    C_Normal3f(-0.645684659f, -0.763604224f, 0.f),
    C_Vertex3f(0.344017982f, 0.255222321f, 0.f),
    C_Vertex3f(0.344017982f, 0.255222321f, -1.f),
    C_Normal3f(-0.559698224f, -0.828696489f, 0.f),
    C_Vertex3f(0.336176872f, 0.261127472f, 0.f),
    C_Vertex3f(0.336176872f, 0.261127472f, -1.f),
    C_Normal3f(-0.483320773f, -0.875443399f, 0.f),
    C_Vertex3f(0.326974869f, 0.26673317f, 0.f),
    C_Vertex3f(0.326974869f, 0.26673317f, -1.f),
    C_Normal3f(-0.416876376f, -0.908963203f, 0.f),
    C_Vertex3f(0.316411972f, 0.272039413f, 0.f),
    C_Vertex3f(0.316411972f, 0.272039413f, -1.f),
    C_Normal3f(-0.359577477f, -0.933115184f, 0.f),
    C_Vertex3f(0.304488182f, 0.277046204f, 0.f),
    C_Vertex3f(0.304488182f, 0.277046204f, -1.f),
    C_Normal3f(-0.31025213f, -0.950654328f, 0.f),
    C_Vertex3f(0.291203499f, 0.28175354f, 0.f),
    C_Vertex3f(0.291203499f, 0.28175354f, -1.f),
    C_Normal3f(-0.274368137f, -0.961624682f, 0.f),
    C_Vertex3f(0.276557922f, 0.286161423f, 0.f),
    C_Vertex3f(0.276557922f, 0.286161423f, -1.f),
    C_Normal3f(-0.248614177f, -0.968602657f, 0.f),
    C_Vertex3f(0.268554688f, 0.288215637f, 0.f),
    C_Vertex3f(0.268554688f, 0.288215637f, -1.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.268554688f, 0.288215637f, 0.f),
    C_Vertex3f(0.268554688f, 0.288215637f, -1.f),
    C_Vertex3f(0.268554688f, 0.052734375f, -1.f),
    C_Vertex3f(0.268554688f, 0.052734375f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.205289364f, 0.0556931496f, 0.f),
    C_Vertex3f(0.207460403f, -0.0118141174f, 0.f),
    C_Vertex3f(0.216405869f, 0.0533342361f, 0.f),
    C_Vertex3f(0.222167969f, -0.013671875f, 0.f),
    C_Vertex3f(0.222167969f, 0.052734375f, 0.f),
    C_Vertex3f(0.268554688f, -0.0922851563f, 0.f),
    C_Vertex3f(0.222167969f, 0.300125122f, 0.f),
    C_Vertex3f(0.222167969f, 0.381263733f, 0.f),
    C_Vertex3f(0.21553421f, 0.382966995f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.205289364f, 0.0556931496f, 0.f),
    C_Vertex3f(0.194580555f, 0.0592112541f, 0.f),
    C_Vertex3f(0.207460403f, -0.0118141174f, 0.f),
    C_Vertex3f(0.184279442f, 0.0638885498f, 0.f),
    C_Vertex3f(0.180796623f, -0.00665140152f, 0.f),
    C_Vertex3f(0.174386024f, 0.0697250366f, 0.f),
    C_Vertex3f(0.164900303f, 0.0767207146f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.156884193f, -4.14848328e-005f, 0.f),
    C_Vertex3f(0.180796623f, -0.00665140152f, 0.f),
    C_Vertex3f(0.164900303f, 0.0767207146f, 0.f),
    C_Vertex3f(0.155822277f, 0.0848755836f, 0.f),
    C_Vertex3f(0.147151947f, 0.0941896439f, 0.f),
    C_Vertex3f(0.14013958f, 0.103136063f, 0.f),
    C_Vertex3f(0.135723114f, 0.00801563263f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.135723114f, 0.00801563263f, 0.f),
    C_Vertex3f(0.14013958f, 0.103136063f, 0.f),
    C_Vertex3f(0.134812355f, 0.111605644f, 0.f),
    C_Vertex3f(0.129920006f, 0.121125221f, 0.f),
    C_Vertex3f(0.125462532f, 0.131694794f, 0.f),
    C_Vertex3f(0.121439934f, 0.143314362f, 0.f),
    C_Vertex3f(0.117852211f, 0.155983925f, 0.f),
    C_Vertex3f(0.117313385f, 0.0175199509f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.117313385f, 0.0175199509f, 0.f),
    C_Vertex3f(0.117852211f, 0.155983925f, 0.f),
    C_Vertex3f(0.114699364f, 0.169703484f, 0.f),
    C_Vertex3f(0.111981392f, 0.184473038f, 0.f),
    C_Vertex3f(0.110839844f, 0.192382813f, 0.f),
    C_Vertex3f(0.10015583f, 0.029946804f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.110839844f, 0.192382813f, 0.f),
    C_Vertex3f(0.0317382813f, 0.177734375f, 0.f),
    C_Vertex3f(0.0328273773f, 0.162439346f, 0.f),
    C_Vertex3f(0.0378112793f, 0.134198189f, 0.f),
    C_Vertex3f(0.0456008911f, 0.108305931f, 0.f),
    C_Vertex3f(0.0561962128f, 0.0847625732f, 0.f),
    C_Vertex3f(0.0695972443f, 0.0635681152f, 0.f),
    C_Vertex3f(0.0842504501f, 0.0452961922f, 0.f),
    C_Vertex3f(0.10015583f, 0.029946804f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.21021843f, 0.303192139f, 0.f),
    C_Vertex3f(0.222167969f, 0.300125122f, 0.f),
    C_Vertex3f(0.21553421f, 0.382966995f, 0.f),
    C_Vertex3f(0.203220844f, 0.386795759f, 0.f),
    C_Vertex3f(0.191861629f, 0.391046762f, 0.f),
    C_Vertex3f(0.185955048f, 0.311344147f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.185955048f, 0.311344147f, 0.f),
    C_Vertex3f(0.191861629f, 0.391046762f, 0.f),
    C_Vertex3f(0.181456566f, 0.395720005f, 0.f),
    C_Vertex3f(0.172005653f, 0.400815487f, 0.f),
    C_Vertex3f(0.163508892f, 0.406333208f, 0.f),
    C_Vertex3f(0.161327362f, 0.32151413f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.161327362f, 0.32151413f, 0.f),
    C_Vertex3f(0.163508892f, 0.406333208f, 0.f),
    C_Vertex3f(0.155966282f, 0.412273169f, 0.f),
    C_Vertex3f(0.149377823f, 0.418635368f, 0.f),
    C_Vertex3f(0.140926361f, 0.428812027f, 0.f),
    C_Vertex3f(0.136335373f, 0.333702087f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.136335373f, 0.333702087f, 0.f),
    C_Vertex3f(0.140926361f, 0.428812027f, 0.f),
    C_Vertex3f(0.132474899f, 0.444023132f, 0.f),
    C_Vertex3f(0.126840591f, 0.460876465f, 0.f),
    C_Vertex3f(0.124023438f, 0.479372025f, 0.f),
    C_Vertex3f(0.11425972f, 0.34605217f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.11425972f, 0.34605217f, 0.f),
    C_Vertex3f(0.124023438f, 0.479372025f, 0.f),
    C_Vertex3f(0.120676279f, 0.631538153f, 0.f),
    C_Vertex3f(0.124023438f, 0.499616623f, 0.f),
    C_Vertex3f(0.13297534f, 0.638587236f, 0.f),
    C_Vertex3f(0.127307415f, 0.518600941f, 0.f),
    C_Vertex3f(0.13387537f, 0.536218166f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.109574318f, 0.623641968f, 0.f),
    C_Vertex3f(0.0972204208f, 0.61276722f, 0.f),
    C_Vertex3f(0.0976223946f, 0.358567238f, 0.f),
    C_Vertex3f(0.11425972f, 0.34605217f, 0.f),
    C_Vertex3f(0.120676279f, 0.631538153f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.0472605228f, 0.513791561f, 0.f),
    C_Vertex3f(0.0479512215f, 0.449163437f, 0.f),
    C_Vertex3f(0.050961256f, 0.53278017f, 0.f),
    C_Vertex3f(0.0530333519f, 0.428071976f, 0.f),
    C_Vertex3f(0.0565123558f, 0.550771713f, 0.f),
    C_Vertex3f(0.0606565475f, 0.408237457f, 0.f),
    C_Vertex3f(0.0639138222f, 0.56776619f, 0.f),
    C_Vertex3f(0.0708208084f, 0.389659882f, 0.f),
    C_Vertex3f(0.0731656551f, 0.583763599f, 0.f),
    C_Vertex3f(0.0831427574f, 0.373103142f, 0.f),
    C_Vertex3f(0.0842678547f, 0.598763943f, 0.f),
    C_Vertex3f(0.0976223946f, 0.358567238f, 0.f),
    C_Vertex3f(0.0972204208f, 0.61276722f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.0454101563f, 0.493805885f, 0.f),
    C_Vertex3f(0.0454101563f, 0.471511841f, 0.f),
    C_Vertex3f(0.0479512215f, 0.449163437f, 0.f),
    C_Vertex3f(0.0472605228f, 0.513791561f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.268554688f, 0.699707031f, 0.f),
    C_Vertex3f(0.222167969f, 0.699707031f, 0.f),
    C_Vertex3f(0.268554688f, -0.0922851563f, 0.f),
    C_Vertex3f(0.222167969f, 0.662109375f, 0.f),
    C_Vertex3f(0.222167969f, 0.596679688f, 0.f),
    C_Vertex3f(0.212427139f, 0.661126137f, 0.f),
    C_Vertex3f(0.210767746f, 0.594928741f, 0.f),
    C_Vertex3f(0.19414258f, 0.658312559f, 0.f),
    C_Vertex3f(0.190383434f, 0.588581562f, 0.f),
    C_Vertex3f(0.17705512f, 0.65465188f, 0.f),
    C_Vertex3f(0.172415257f, 0.579389095f, 0.f),
    C_Vertex3f(0.161164761f, 0.6501441f, 0.f),
    C_Vertex3f(0.156863213f, 0.567351341f, 0.f),
    C_Vertex3f(0.1464715f, 0.644789219f, 0.f),
    C_Vertex3f(0.143727303f, 0.5524683f, 0.f),
    C_Vertex3f(0.13387537f, 0.536218166f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.293257952f, 0.658794165f, 0.f),
    C_Vertex3f(0.277083397f, 0.661287308f, 0.f),
    C_Vertex3f(0.278091431f, 0.593729019f, 0.f),
    C_Vertex3f(0.268554688f, 0.662109375f, 0.f),
    C_Vertex3f(0.268554688f, 0.595703125f, 0.f),
    C_Vertex3f(0.268554688f, 0.699707031f, 0.f),
    C_Vertex3f(0.268554688f, 0.369354248f, 0.f),
    C_Vertex3f(0.268554688f, 0.288215637f, 0.f),
    C_Vertex3f(0.276557922f, 0.286161423f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.268554688f, 0.052734375f, 0.f),
    C_Vertex3f(0.268554688f, 0.288215637f, 0.f),
    C_Vertex3f(0.268554688f, 0.699707031f, 0.f),
    C_Vertex3f(0.268554688f, -0.0126953125f, 0.f),
    C_Vertex3f(0.278847694f, -0.0122041702f, 0.f),
    C_Vertex3f(0.274248123f, 0.0534448624f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.438476563f, 0.50390625f, 0.f),
    C_Vertex3f(0.43717289f, 0.513273239f, 0.f),
    C_Vertex3f(0.433288813f, 0.531007528f, 0.f),
    C_Vertex3f(0.428128004f, 0.547742128f, 0.f),
    C_Vertex3f(0.421690464f, 0.563477039f, 0.f),
    C_Vertex3f(0.413976192f, 0.578212261f, 0.f),
    C_Vertex3f(0.404985189f, 0.591947794f, 0.f),
    C_Vertex3f(0.394717455f, 0.604683638f, 0.f),
    C_Vertex3f(0.383172989f, 0.616419792f, 0.f),
    C_Vertex3f(0.371765137f, 0.626006126f, 0.f),
    C_Vertex3f(0.360887766f, 0.633593321f, 0.f),
    C_Vertex3f(0.357421875f, 0.491699219f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.323121071f, 0.569210052f, 0.f),
    C_Vertex3f(0.334067345f, 0.556812286f, 0.f),
    C_Vertex3f(0.336484432f, 0.646220684f, 0.f),
    C_Vertex3f(0.34314394f, 0.541699409f, 0.f),
    C_Vertex3f(0.349127531f, 0.640331507f, 0.f),
    C_Vertex3f(0.350350857f, 0.523871422f, 0.f),
    C_Vertex3f(0.360887766f, 0.633593321f, 0.f),
    C_Vertex3f(0.355688095f, 0.503328323f, 0.f),
    C_Vertex3f(0.357421875f, 0.491699219f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.293257952f, 0.658794165f, 0.f),
    C_Vertex3f(0.295133114f, 0.587668419f, 0.f),
    C_Vertex3f(0.308549643f, 0.655452013f, 0.f),
    C_Vertex3f(0.310142994f, 0.57949543f, 0.f),
    C_Vertex3f(0.322958469f, 0.651260853f, 0.f),
    C_Vertex3f(0.323121071f, 0.569210052f, 0.f),
    C_Vertex3f(0.336484432f, 0.646220684f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.373535156f, 0.187614441f, 0.f),
    C_Vertex3f(0.382349133f, 0.0269571543f, 0.f),
    C_Vertex3f(0.38765955f, 0.322794914f, 0.f),
    C_Vertex3f(0.396263599f, 0.0390286446f, 0.f),
    C_Vertex3f(0.400893211f, 0.312088013f, 0.f),
    C_Vertex3f(0.409224987f, 0.0526843071f, 0.f),
    C_Vertex3f(0.412438393f, 0.300506592f, 0.f),
    C_Vertex3f(0.420566201f, 0.0671867132f, 0.f),
    C_Vertex3f(0.422649384f, 0.287833214f, 0.f),
    C_Vertex3f(0.430287242f, 0.0825358629f, 0.f),
    C_Vertex3f(0.431526184f, 0.274067879f, 0.f),
    C_Vertex3f(0.438388109f, 0.0987317562f, 0.f),
    C_Vertex3f(0.439068794f, 0.259210587f, 0.f),
    C_Vertex3f(0.444868803f, 0.115774393f, 0.f),
    C_Vertex3f(0.445277214f, 0.243261337f, 0.f),
    C_Vertex3f(0.449729323f, 0.133663774f, 0.f),
    C_Vertex3f(0.449933529f, 0.226656914f, 0.f),
    C_Vertex3f(0.45296967f, 0.152399898f, 0.f),
    C_Vertex3f(0.453037739f, 0.209397316f, 0.f),
    C_Vertex3f(0.454589844f, 0.171982765f, 0.f),
    C_Vertex3f(0.454589844f, 0.191482544f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.372737408f, 0.332627296f, 0.f),
    C_Vertex3f(0.356126785f, 0.341585159f, 0.f),
    C_Vertex3f(0.358177185f, 0.239261627f, 0.f),
    C_Vertex3f(0.365856171f, 0.224149704f, 0.f),
    C_Vertex3f(0.370975494f, 0.206933975f, 0.f),
    C_Vertex3f(0.373535156f, 0.187614441f, 0.f),
    C_Vertex3f(0.38765955f, 0.322794914f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.358177185f, 0.239261627f, 0.f),
    C_Vertex3f(0.356126785f, 0.341585159f, 0.f),
    C_Vertex3f(0.350498199f, 0.249017715f, 0.f),
    C_Vertex3f(0.34458065f, 0.346664429f, 0.f),
    C_Vertex3f(0.344017982f, 0.255222321f, 0.f),
    C_Vertex3f(0.33853507f, 0.348962307f, 0.f),
    C_Vertex3f(0.336176872f, 0.261127472f, 0.f),
    C_Vertex3f(0.331237078f, 0.351482868f, 0.f),
    C_Vertex3f(0.326974869f, 0.26673317f, 0.f),
    C_Vertex3f(0.322686672f, 0.354226112f, 0.f),
    C_Vertex3f(0.316411972f, 0.272039413f, 0.f),
    C_Vertex3f(0.312883854f, 0.357192039f, 0.f),
    C_Vertex3f(0.304488182f, 0.277046204f, 0.f),
    C_Vertex3f(0.301828623f, 0.36038065f, 0.f),
    C_Vertex3f(0.291203499f, 0.28175354f, 0.f),
    C_Vertex3f(0.289520979f, 0.363791943f, 0.f),
    C_Vertex3f(0.276557922f, 0.286161423f, 0.f),
    C_Vertex3f(0.275960922f, 0.367425919f, 0.f),
    C_Vertex3f(0.268554688f, 0.369354248f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.382349133f, 0.0269571543f, 0.f),
    C_Vertex3f(0.373535156f, 0.187614441f, 0.f),
    C_Vertex3f(0.373535156f, 0.170618057f, 0.f),
    C_Vertex3f(0.372606516f, 0.158554077f, 0.f),
    C_Vertex3f(0.370749235f, 0.146995544f, 0.f),
    C_Vertex3f(0.367963314f, 0.135942459f, 0.f),
    C_Vertex3f(0.367481589f, 0.0164698362f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.367481589f, 0.0164698362f, 0.f),
    C_Vertex3f(0.367963314f, 0.135942459f, 0.f),
    C_Vertex3f(0.364248753f, 0.125394821f, 0.f),
    C_Vertex3f(0.359605551f, 0.115352631f, 0.f),
    C_Vertex3f(0.354033709f, 0.105815887f, 0.f),
    C_Vertex3f(0.351660967f, 0.00756669044f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.354033709f, 0.105815887f, 0.f),
    C_Vertex3f(0.347533226f, 0.0967845917f, 0.f),
    C_Vertex3f(0.351660967f, 0.00756669044f, 0.f),
    C_Vertex3f(0.340104103f, 0.0882587433f, 0.f),
    C_Vertex3f(0.334887266f, 0.000247716904f, 0.f),
    C_Vertex3f(0.332180262f, 0.0806210041f, 0.f),
    C_Vertex3f(0.323761702f, 0.0738713741f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.317160487f, -0.00548708439f, 0.f),
    C_Vertex3f(0.334887266f, 0.000247716904f, 0.f),
    C_Vertex3f(0.323761702f, 0.0738713741f, 0.f),
    C_Vertex3f(0.314848423f, 0.0680098534f, 0.f),
    C_Vertex3f(0.305440426f, 0.0630364418f, 0.f),
    C_Vertex3f(0.29848063f, -0.00963771343f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.274248123f, 0.0534448624f, 0.f),
    C_Vertex3f(0.278847694f, -0.0122041702f, 0.f),
    C_Vertex3f(0.285140276f, 0.0557539463f, 0.f),
    C_Vertex3f(0.29848063f, -0.00963771343f, 0.f),
    C_Vertex3f(0.29553771f, 0.0589511395f, 0.f),
    C_Vertex3f(0.305440426f, 0.0630364418f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.293257952f, 0.658794165f, 0.f),
    C_Vertex3f(0.278091431f, 0.593729019f, 0.f),
    C_Vertex3f(0.295133114f, 0.587668419f, 0.f),
    C_Vertex3f(0.268554688f, -0.0922851563f, 0.f),
    C_Vertex3f(0.222167969f, -0.013671875f, 0.f),
    C_Vertex3f(0.222167969f, -0.0922851563f, 0.f),
    C_Vertex3f(0.222167969f, 0.381263733f, 0.f),
    C_Vertex3f(0.268554688f, -0.0922851563f, 0.f),
    C_Vertex3f(0.222167969f, 0.596679688f, 0.f),
    C_Vertex3f(0.268554688f, 0.699707031f, 0.f),
    C_Vertex3f(0.268554688f, -0.0922851563f, 0.f),
    C_Vertex3f(0.268554688f, -0.0126953125f, 0.f),
    C_Vertex3f(0.13297534f, 0.638587236f, 0.f),
    C_Vertex3f(0.13387537f, 0.536218166f, 0.f),
    C_Vertex3f(0.1464715f, 0.644789219f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, -1.f),
    C_FrontFace(GL_CW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.205289364f, 0.0556931496f, -1.f),
    C_Vertex3f(0.207460403f, -0.0118141174f, -1.f),
    C_Vertex3f(0.216405869f, 0.0533342361f, -1.f),
    C_Vertex3f(0.222167969f, -0.013671875f, -1.f),
    C_Vertex3f(0.222167969f, 0.052734375f, -1.f),
    C_Vertex3f(0.268554688f, -0.0922851563f, -1.f),
    C_Vertex3f(0.222167969f, 0.300125122f, -1.f),
    C_Vertex3f(0.222167969f, 0.381263733f, -1.f),
    C_Vertex3f(0.21553421f, 0.382966995f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.205289364f, 0.0556931496f, -1.f),
    C_Vertex3f(0.194580555f, 0.0592112541f, -1.f),
    C_Vertex3f(0.207460403f, -0.0118141174f, -1.f),
    C_Vertex3f(0.184279442f, 0.0638885498f, -1.f),
    C_Vertex3f(0.180796623f, -0.00665140152f, -1.f),
    C_Vertex3f(0.174386024f, 0.0697250366f, -1.f),
    C_Vertex3f(0.164900303f, 0.0767207146f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.156884193f, -4.14848328e-005f, -1.f),
    C_Vertex3f(0.180796623f, -0.00665140152f, -1.f),
    C_Vertex3f(0.164900303f, 0.0767207146f, -1.f),
    C_Vertex3f(0.155822277f, 0.0848755836f, -1.f),
    C_Vertex3f(0.147151947f, 0.0941896439f, -1.f),
    C_Vertex3f(0.14013958f, 0.103136063f, -1.f),
    C_Vertex3f(0.135723114f, 0.00801563263f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.135723114f, 0.00801563263f, -1.f),
    C_Vertex3f(0.14013958f, 0.103136063f, -1.f),
    C_Vertex3f(0.134812355f, 0.111605644f, -1.f),
    C_Vertex3f(0.129920006f, 0.121125221f, -1.f),
    C_Vertex3f(0.125462532f, 0.131694794f, -1.f),
    C_Vertex3f(0.121439934f, 0.143314362f, -1.f),
    C_Vertex3f(0.117852211f, 0.155983925f, -1.f),
    C_Vertex3f(0.117313385f, 0.0175199509f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.117313385f, 0.0175199509f, -1.f),
    C_Vertex3f(0.117852211f, 0.155983925f, -1.f),
    C_Vertex3f(0.114699364f, 0.169703484f, -1.f),
    C_Vertex3f(0.111981392f, 0.184473038f, -1.f),
    C_Vertex3f(0.110839844f, 0.192382813f, -1.f),
    C_Vertex3f(0.10015583f, 0.029946804f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.110839844f, 0.192382813f, -1.f),
    C_Vertex3f(0.0317382813f, 0.177734375f, -1.f),
    C_Vertex3f(0.0328273773f, 0.162439346f, -1.f),
    C_Vertex3f(0.0378112793f, 0.134198189f, -1.f),
    C_Vertex3f(0.0456008911f, 0.108305931f, -1.f),
    C_Vertex3f(0.0561962128f, 0.0847625732f, -1.f),
    C_Vertex3f(0.0695972443f, 0.0635681152f, -1.f),
    C_Vertex3f(0.0842504501f, 0.0452961922f, -1.f),
    C_Vertex3f(0.10015583f, 0.029946804f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.21021843f, 0.303192139f, -1.f),
    C_Vertex3f(0.222167969f, 0.300125122f, -1.f),
    C_Vertex3f(0.21553421f, 0.382966995f, -1.f),
    C_Vertex3f(0.203220844f, 0.386795759f, -1.f),
    C_Vertex3f(0.191861629f, 0.391046762f, -1.f),
    C_Vertex3f(0.185955048f, 0.311344147f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.185955048f, 0.311344147f, -1.f),
    C_Vertex3f(0.191861629f, 0.391046762f, -1.f),
    C_Vertex3f(0.181456566f, 0.395720005f, -1.f),
    C_Vertex3f(0.172005653f, 0.400815487f, -1.f),
    C_Vertex3f(0.163508892f, 0.406333208f, -1.f),
    C_Vertex3f(0.161327362f, 0.32151413f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.161327362f, 0.32151413f, -1.f),
    C_Vertex3f(0.163508892f, 0.406333208f, -1.f),
    C_Vertex3f(0.155966282f, 0.412273169f, -1.f),
    C_Vertex3f(0.149377823f, 0.418635368f, -1.f),
    C_Vertex3f(0.140926361f, 0.428812027f, -1.f),
    C_Vertex3f(0.136335373f, 0.333702087f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.136335373f, 0.333702087f, -1.f),
    C_Vertex3f(0.140926361f, 0.428812027f, -1.f),
    C_Vertex3f(0.132474899f, 0.444023132f, -1.f),
    C_Vertex3f(0.126840591f, 0.460876465f, -1.f),
    C_Vertex3f(0.124023438f, 0.479372025f, -1.f),
    C_Vertex3f(0.11425972f, 0.34605217f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.11425972f, 0.34605217f, -1.f),
    C_Vertex3f(0.124023438f, 0.479372025f, -1.f),
    C_Vertex3f(0.120676279f, 0.631538153f, -1.f),
    C_Vertex3f(0.124023438f, 0.499616623f, -1.f),
    C_Vertex3f(0.13297534f, 0.638587236f, -1.f),
    C_Vertex3f(0.127307415f, 0.518600941f, -1.f),
    C_Vertex3f(0.13387537f, 0.536218166f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.109574318f, 0.623641968f, -1.f),
    C_Vertex3f(0.0972204208f, 0.61276722f, -1.f),
    C_Vertex3f(0.0976223946f, 0.358567238f, -1.f),
    C_Vertex3f(0.11425972f, 0.34605217f, -1.f),
    C_Vertex3f(0.120676279f, 0.631538153f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.0472605228f, 0.513791561f, -1.f),
    C_Vertex3f(0.0479512215f, 0.449163437f, -1.f),
    C_Vertex3f(0.050961256f, 0.53278017f, -1.f),
    C_Vertex3f(0.0530333519f, 0.428071976f, -1.f),
    C_Vertex3f(0.0565123558f, 0.550771713f, -1.f),
    C_Vertex3f(0.0606565475f, 0.408237457f, -1.f),
    C_Vertex3f(0.0639138222f, 0.56776619f, -1.f),
    C_Vertex3f(0.0708208084f, 0.389659882f, -1.f),
    C_Vertex3f(0.0731656551f, 0.583763599f, -1.f),
    C_Vertex3f(0.0831427574f, 0.373103142f, -1.f),
    C_Vertex3f(0.0842678547f, 0.598763943f, -1.f),
    C_Vertex3f(0.0976223946f, 0.358567238f, -1.f),
    C_Vertex3f(0.0972204208f, 0.61276722f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.0454101563f, 0.493805885f, -1.f),
    C_Vertex3f(0.0454101563f, 0.471511841f, -1.f),
    C_Vertex3f(0.0479512215f, 0.449163437f, -1.f),
    C_Vertex3f(0.0472605228f, 0.513791561f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.268554688f, 0.699707031f, -1.f),
    C_Vertex3f(0.222167969f, 0.699707031f, -1.f),
    C_Vertex3f(0.268554688f, -0.0922851563f, -1.f),
    C_Vertex3f(0.222167969f, 0.662109375f, -1.f),
    C_Vertex3f(0.222167969f, 0.596679688f, -1.f),
    C_Vertex3f(0.212427139f, 0.661126137f, -1.f),
    C_Vertex3f(0.210767746f, 0.594928741f, -1.f),
    C_Vertex3f(0.19414258f, 0.658312559f, -1.f),
    C_Vertex3f(0.190383434f, 0.588581562f, -1.f),
    C_Vertex3f(0.17705512f, 0.65465188f, -1.f),
    C_Vertex3f(0.172415257f, 0.579389095f, -1.f),
    C_Vertex3f(0.161164761f, 0.6501441f, -1.f),
    C_Vertex3f(0.156863213f, 0.567351341f, -1.f),
    C_Vertex3f(0.1464715f, 0.644789219f, -1.f),
    C_Vertex3f(0.143727303f, 0.5524683f, -1.f),
    C_Vertex3f(0.13387537f, 0.536218166f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.293257952f, 0.658794165f, -1.f),
    C_Vertex3f(0.277083397f, 0.661287308f, -1.f),
    C_Vertex3f(0.278091431f, 0.593729019f, -1.f),
    C_Vertex3f(0.268554688f, 0.662109375f, -1.f),
    C_Vertex3f(0.268554688f, 0.595703125f, -1.f),
    C_Vertex3f(0.268554688f, 0.699707031f, -1.f),
    C_Vertex3f(0.268554688f, 0.369354248f, -1.f),
    C_Vertex3f(0.268554688f, 0.288215637f, -1.f),
    C_Vertex3f(0.276557922f, 0.286161423f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.268554688f, 0.052734375f, -1.f),
    C_Vertex3f(0.268554688f, 0.288215637f, -1.f),
    C_Vertex3f(0.268554688f, 0.699707031f, -1.f),
    C_Vertex3f(0.268554688f, -0.0126953125f, -1.f),
    C_Vertex3f(0.278847694f, -0.0122041702f, -1.f),
    C_Vertex3f(0.274248123f, 0.0534448624f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.438476563f, 0.50390625f, -1.f),
    C_Vertex3f(0.43717289f, 0.513273239f, -1.f),
    C_Vertex3f(0.433288813f, 0.531007528f, -1.f),
    C_Vertex3f(0.428128004f, 0.547742128f, -1.f),
    C_Vertex3f(0.421690464f, 0.563477039f, -1.f),
    C_Vertex3f(0.413976192f, 0.578212261f, -1.f),
    C_Vertex3f(0.404985189f, 0.591947794f, -1.f),
    C_Vertex3f(0.394717455f, 0.604683638f, -1.f),
    C_Vertex3f(0.383172989f, 0.616419792f, -1.f),
    C_Vertex3f(0.371765137f, 0.626006126f, -1.f),
    C_Vertex3f(0.360887766f, 0.633593321f, -1.f),
    C_Vertex3f(0.357421875f, 0.491699219f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.323121071f, 0.569210052f, -1.f),
    C_Vertex3f(0.334067345f, 0.556812286f, -1.f),
    C_Vertex3f(0.336484432f, 0.646220684f, -1.f),
    C_Vertex3f(0.34314394f, 0.541699409f, -1.f),
    C_Vertex3f(0.349127531f, 0.640331507f, -1.f),
    C_Vertex3f(0.350350857f, 0.523871422f, -1.f),
    C_Vertex3f(0.360887766f, 0.633593321f, -1.f),
    C_Vertex3f(0.355688095f, 0.503328323f, -1.f),
    C_Vertex3f(0.357421875f, 0.491699219f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.293257952f, 0.658794165f, -1.f),
    C_Vertex3f(0.295133114f, 0.587668419f, -1.f),
    C_Vertex3f(0.308549643f, 0.655452013f, -1.f),
    C_Vertex3f(0.310142994f, 0.57949543f, -1.f),
    C_Vertex3f(0.322958469f, 0.651260853f, -1.f),
    C_Vertex3f(0.323121071f, 0.569210052f, -1.f),
    C_Vertex3f(0.336484432f, 0.646220684f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.373535156f, 0.187614441f, -1.f),
    C_Vertex3f(0.382349133f, 0.0269571543f, -1.f),
    C_Vertex3f(0.38765955f, 0.322794914f, -1.f),
    C_Vertex3f(0.396263599f, 0.0390286446f, -1.f),
    C_Vertex3f(0.400893211f, 0.312088013f, -1.f),
    C_Vertex3f(0.409224987f, 0.0526843071f, -1.f),
    C_Vertex3f(0.412438393f, 0.300506592f, -1.f),
    C_Vertex3f(0.420566201f, 0.0671867132f, -1.f),
    C_Vertex3f(0.422649384f, 0.287833214f, -1.f),
    C_Vertex3f(0.430287242f, 0.0825358629f, -1.f),
    C_Vertex3f(0.431526184f, 0.274067879f, -1.f),
    C_Vertex3f(0.438388109f, 0.0987317562f, -1.f),
    C_Vertex3f(0.439068794f, 0.259210587f, -1.f),
    C_Vertex3f(0.444868803f, 0.115774393f, -1.f),
    C_Vertex3f(0.445277214f, 0.243261337f, -1.f),
    C_Vertex3f(0.449729323f, 0.133663774f, -1.f),
    C_Vertex3f(0.449933529f, 0.226656914f, -1.f),
    C_Vertex3f(0.45296967f, 0.152399898f, -1.f),
    C_Vertex3f(0.453037739f, 0.209397316f, -1.f),
    C_Vertex3f(0.454589844f, 0.171982765f, -1.f),
    C_Vertex3f(0.454589844f, 0.191482544f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.372737408f, 0.332627296f, -1.f),
    C_Vertex3f(0.356126785f, 0.341585159f, -1.f),
    C_Vertex3f(0.358177185f, 0.239261627f, -1.f),
    C_Vertex3f(0.365856171f, 0.224149704f, -1.f),
    C_Vertex3f(0.370975494f, 0.206933975f, -1.f),
    C_Vertex3f(0.373535156f, 0.187614441f, -1.f),
    C_Vertex3f(0.38765955f, 0.322794914f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.358177185f, 0.239261627f, -1.f),
    C_Vertex3f(0.356126785f, 0.341585159f, -1.f),
    C_Vertex3f(0.350498199f, 0.249017715f, -1.f),
    C_Vertex3f(0.34458065f, 0.346664429f, -1.f),
    C_Vertex3f(0.344017982f, 0.255222321f, -1.f),
    C_Vertex3f(0.33853507f, 0.348962307f, -1.f),
    C_Vertex3f(0.336176872f, 0.261127472f, -1.f),
    C_Vertex3f(0.331237078f, 0.351482868f, -1.f),
    C_Vertex3f(0.326974869f, 0.26673317f, -1.f),
    C_Vertex3f(0.322686672f, 0.354226112f, -1.f),
    C_Vertex3f(0.316411972f, 0.272039413f, -1.f),
    C_Vertex3f(0.312883854f, 0.357192039f, -1.f),
    C_Vertex3f(0.304488182f, 0.277046204f, -1.f),
    C_Vertex3f(0.301828623f, 0.36038065f, -1.f),
    C_Vertex3f(0.291203499f, 0.28175354f, -1.f),
    C_Vertex3f(0.289520979f, 0.363791943f, -1.f),
    C_Vertex3f(0.276557922f, 0.286161423f, -1.f),
    C_Vertex3f(0.275960922f, 0.367425919f, -1.f),
    C_Vertex3f(0.268554688f, 0.369354248f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.382349133f, 0.0269571543f, -1.f),
    C_Vertex3f(0.373535156f, 0.187614441f, -1.f),
    C_Vertex3f(0.373535156f, 0.170618057f, -1.f),
    C_Vertex3f(0.372606516f, 0.158554077f, -1.f),
    C_Vertex3f(0.370749235f, 0.146995544f, -1.f),
    C_Vertex3f(0.367963314f, 0.135942459f, -1.f),
    C_Vertex3f(0.367481589f, 0.0164698362f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.367481589f, 0.0164698362f, -1.f),
    C_Vertex3f(0.367963314f, 0.135942459f, -1.f),
    C_Vertex3f(0.364248753f, 0.125394821f, -1.f),
    C_Vertex3f(0.359605551f, 0.115352631f, -1.f),
    C_Vertex3f(0.354033709f, 0.105815887f, -1.f),
    C_Vertex3f(0.351660967f, 0.00756669044f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.354033709f, 0.105815887f, -1.f),
    C_Vertex3f(0.347533226f, 0.0967845917f, -1.f),
    C_Vertex3f(0.351660967f, 0.00756669044f, -1.f),
    C_Vertex3f(0.340104103f, 0.0882587433f, -1.f),
    C_Vertex3f(0.334887266f, 0.000247716904f, -1.f),
    C_Vertex3f(0.332180262f, 0.0806210041f, -1.f),
    C_Vertex3f(0.323761702f, 0.0738713741f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.317160487f, -0.00548708439f, -1.f),
    C_Vertex3f(0.334887266f, 0.000247716904f, -1.f),
    C_Vertex3f(0.323761702f, 0.0738713741f, -1.f),
    C_Vertex3f(0.314848423f, 0.0680098534f, -1.f),
    C_Vertex3f(0.305440426f, 0.0630364418f, -1.f),
    C_Vertex3f(0.29848063f, -0.00963771343f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.274248123f, 0.0534448624f, -1.f),
    C_Vertex3f(0.278847694f, -0.0122041702f, -1.f),
    C_Vertex3f(0.285140276f, 0.0557539463f, -1.f),
    C_Vertex3f(0.29848063f, -0.00963771343f, -1.f),
    C_Vertex3f(0.29553771f, 0.0589511395f, -1.f),
    C_Vertex3f(0.305440426f, 0.0630364418f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.293257952f, 0.658794165f, -1.f),
    C_Vertex3f(0.278091431f, 0.593729019f, -1.f),
    C_Vertex3f(0.295133114f, 0.587668419f, -1.f),
    C_Vertex3f(0.268554688f, -0.0922851563f, -1.f),
    C_Vertex3f(0.222167969f, -0.013671875f, -1.f),
    C_Vertex3f(0.222167969f, -0.0922851563f, -1.f),
    C_Vertex3f(0.222167969f, 0.381263733f, -1.f),
    C_Vertex3f(0.268554688f, -0.0922851563f, -1.f),
    C_Vertex3f(0.222167969f, 0.596679688f, -1.f),
    C_Vertex3f(0.268554688f, 0.699707031f, -1.f),
    C_Vertex3f(0.268554688f, -0.0922851563f, -1.f),
    C_Vertex3f(0.268554688f, -0.0126953125f, -1.f),
    C_Vertex3f(0.13297534f, 0.638587236f, -1.f),
    C_Vertex3f(0.13387537f, 0.536218166f, -1.f),
    C_Vertex3f(0.1464715f, 0.644789219f, -1.f),
    C_End(),
    C_Translatef(0.497558594f, 0.f, 0.f),
};
static const Call char_37[] = {
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_FrontFace(GL_CW),
    C_Begin(GL_QUAD_STRIP),
    C_Normal3f(-0.999542296f, -0.0302517843f, 0.f),
    C_Vertex3f(0.0522460938f, 0.475595474f, 0.f),
    C_Vertex3f(0.0522460938f, 0.475595474f, -1.f),
    C_Normal3f(-0.9995507f, 0.029973954f, 0.f),
    C_Vertex3f(0.0522460938f, 0.495107651f, 0.f),
    C_Vertex3f(0.0522460938f, 0.495107651f, -1.f),
    C_Normal3f(-0.995031834f, 0.0995573699f, 0.f),
    C_Vertex3f(0.0533266068f, 0.511627674f, 0.f),
    C_Vertex3f(0.0533266068f, 0.511627674f, -1.f),
    C_Normal3f(-0.985256791f, 0.171082452f, 0.f),
    C_Vertex3f(0.0554876328f, 0.527505398f, 0.f),
    C_Vertex3f(0.0554876328f, 0.527505398f, -1.f),
    C_Normal3f(-0.969323039f, 0.245790139f, 0.f),
    C_Vertex3f(0.0587291718f, 0.542740822f, 0.f),
    C_Vertex3f(0.0587291718f, 0.542740822f, -1.f),
    C_Normal3f(-0.946573734f, 0.322487503f, 0.f),
    C_Vertex3f(0.0630512238f, 0.557333946f, 0.f),
    C_Vertex3f(0.0630512238f, 0.557333946f, -1.f),
    C_Normal3f(-0.916654587f, 0.399680465f, 0.f),
    C_Vertex3f(0.0684537888f, 0.571284771f, 0.f),
    C_Vertex3f(0.0684537888f, 0.571284771f, -1.f),
    C_Normal3f(-0.879617751f, 0.475681156f, 0.f),
    C_Vertex3f(0.0749368668f, 0.584593296f, 0.f),
    C_Vertex3f(0.0749368668f, 0.584593296f, -1.f),
    C_Normal3f(-0.83597362f, 0.548769653f, 0.f),
    C_Vertex3f(0.0825004578f, 0.597259521f, 0.f),
    C_Vertex3f(0.0825004578f, 0.597259521f, -1.f),
    C_Normal3f(-0.77710247f, 0.629374087f, 0.f),
    C_Vertex3f(0.0911445618f, 0.609283447f, 0.f),
    C_Vertex3f(0.0911445618f, 0.609283447f, -1.f),
    C_Normal3f(-0.695233703f, 0.718783677f, 0.f),
    C_Vertex3f(0.100759506f, 0.619804382f, 0.f),
    C_Vertex3f(0.100759506f, 0.619804382f, -1.f),
    C_Normal3f(-0.598286867f, 0.801282048f, 0.f),
    C_Vertex3f(0.111345291f, 0.628822327f, 0.f),
    C_Vertex3f(0.111345291f, 0.628822327f, -1.f),
    C_Normal3f(-0.489700556f, 0.871890724f, 0.f),
    C_Vertex3f(0.122901917f, 0.63633728f, 0.f),
    C_Vertex3f(0.122901917f, 0.63633728f, -1.f),
    C_Normal3f(-0.374785423f, 0.927111566f, 0.f),
    C_Vertex3f(0.135429382f, 0.642349243f, 0.f),
    C_Vertex3f(0.135429382f, 0.642349243f, -1.f),
    C_Normal3f(-0.259498686f, 0.965743423f, 0.f),
    C_Vertex3f(0.148927689f, 0.646858215f, 0.f),
    C_Vertex3f(0.148927689f, 0.646858215f, -1.f),
    C_Normal3f(-0.149071217f, 0.988826454f, 0.f),
    C_Vertex3f(0.163396835f, 0.649864197f, 0.f),
    C_Vertex3f(0.163396835f, 0.649864197f, -1.f),
    C_Normal3f(-0.0481236875f, 0.998841345f, 0.f),
    C_Vertex3f(0.178836823f, 0.651367188f, 0.f),
    C_Vertex3f(0.178836823f, 0.651367188f, -1.f),
    C_Normal3f(0.0445118397f, 0.999008954f, 0.f),
    C_Vertex3f(0.194592476f, 0.651367188f, 0.f),
    C_Vertex3f(0.194592476f, 0.651367188f, -1.f),
    C_Normal3f(0.141479254f, 0.989941239f, 0.f),
    C_Vertex3f(0.209043145f, 0.650021315f, 0.f),
    C_Vertex3f(0.209043145f, 0.650021315f, -1.f),
    C_Normal3f(0.242243826f, 0.97021544f, 0.f),
    C_Vertex3f(0.222844005f, 0.647329569f, 0.f),
    C_Vertex3f(0.222844005f, 0.647329569f, -1.f),
    C_Normal3f(0.344747186f, 0.93869555f, 0.f),
    C_Vertex3f(0.235995054f, 0.64329195f, 0.f),
    C_Vertex3f(0.235995054f, 0.64329195f, -1.f),
    C_Normal3f(0.445345551f, 0.89535886f, 0.f),
    C_Vertex3f(0.248496294f, 0.637908459f, 0.f),
    C_Vertex3f(0.248496294f, 0.637908459f, -1.f),
    C_Normal3f(0.540364563f, 0.841431022f, 0.f),
    C_Vertex3f(0.260347724f, 0.631179094f, 0.f),
    C_Vertex3f(0.260347724f, 0.631179094f, -1.f),
    C_Normal3f(0.626737356f, 0.779230535f, 0.f),
    C_Vertex3f(0.271549344f, 0.623103857f, 0.f),
    C_Vertex3f(0.271549344f, 0.623103857f, -1.f),
    C_Normal3f(0.702468693f, 0.711714625f, 0.f),
    C_Vertex3f(0.282101154f, 0.613682747f, 0.f),
    C_Vertex3f(0.282101154f, 0.613682747f, -1.f),
    C_Normal3f(0.775400639f, 0.631469607f, 0.f),
    C_Vertex3f(0.292003155f, 0.602915764f, 0.f),
    C_Vertex3f(0.292003155f, 0.602915764f, -1.f),
    C_Normal3f(0.84405303f, 0.536259651f, 0.f),
    C_Vertex3f(0.300667405f, 0.590884686f, 0.f),
    C_Vertex3f(0.300667405f, 0.590884686f, -1.f),
    C_Normal3f(0.898415864f, 0.439145625f, 0.f),
    C_Vertex3f(0.308093905f, 0.577589512f, 0.f),
    C_Vertex3f(0.308093905f, 0.577589512f, -1.f),
    C_Normal3f(0.938881755f, 0.344239712f, 0.f),
    C_Vertex3f(0.314282656f, 0.563030243f, 0.f),
    C_Vertex3f(0.314282656f, 0.563030243f, -1.f),
    C_Normal3f(0.967049181f, 0.254589677f, 0.f),
    C_Vertex3f(0.319233656f, 0.547206879f, 0.f),
    C_Vertex3f(0.319233656f, 0.547206879f, -1.f),
    C_Normal3f(0.985092163f, 0.172027618f, 0.f),
    C_Vertex3f(0.322946906f, 0.530119419f, 0.f),
    C_Vertex3f(0.322946906f, 0.530119419f, -1.f),
    C_Normal3f(0.995251417f, 0.0973370969f, 0.f),
    C_Vertex3f(0.325422406f, 0.511767864f, 0.f),
    C_Vertex3f(0.325422406f, 0.511767864f, -1.f),
    C_Normal3f(0.999526858f, 0.0307593662f, 0.f),
    C_Vertex3f(0.326660156f, 0.492152214f, 0.f),
    C_Vertex3f(0.326660156f, 0.492152214f, -1.f),
    C_Normal3f(0.999505162f, -0.0314538181f, 0.f),
    C_Vertex3f(0.326660156f, 0.471547127f, 0.f),
    C_Vertex3f(0.326660156f, 0.471547127f, -1.f),
    C_Normal3f(0.994934082f, -0.100529537f, 0.f),
    C_Vertex3f(0.325408697f, 0.45238471f, 0.f),
    C_Vertex3f(0.325408697f, 0.45238471f, -1.f),
    C_Normal3f(0.98423481f, -0.176866949f, 0.f),
    C_Vertex3f(0.322905779f, 0.434390306f, 0.f),
    C_Vertex3f(0.322905779f, 0.434390306f, -1.f),
    C_Normal3f(0.965508878f, -0.260370135f, 0.f),
    C_Vertex3f(0.319151402f, 0.417563915f, 0.f),
    C_Vertex3f(0.319151402f, 0.417563915f, -1.f),
    C_Normal3f(0.936764181f, -0.34996146f, 0.f),
    C_Vertex3f(0.314145565f, 0.401905537f, 0.f),
    C_Vertex3f(0.314145565f, 0.401905537f, -1.f),
    C_Normal3f(0.896228433f, -0.443592936f, 0.f),
    C_Vertex3f(0.307888269f, 0.387415171f, 0.f),
    C_Vertex3f(0.307888269f, 0.387415171f, -1.f),
    C_Normal3f(0.842813432f, -0.538205802f, 0.f),
    C_Vertex3f(0.300379515f, 0.374092817f, 0.f),
    C_Vertex3f(0.300379515f, 0.374092817f, -1.f),
    C_Normal3f(0.77660501f, -0.629987895f, 0.f),
    C_Vertex3f(0.291619301f, 0.361938477f, 0.f),
    C_Vertex3f(0.291619301f, 0.361938477f, -1.f),
    C_Normal3f(0.707016706f, -0.707196772f, 0.f),
    C_Vertex3f(0.281607628f, 0.350952148f, 0.f),
    C_Vertex3f(0.281607628f, 0.350952148f, -1.f),
    C_Normal3f(0.63415879f, -0.773202837f, 0.f),
    C_Vertex3f(0.27101469f, 0.341339111f, 0.f),
    C_Vertex3f(0.27101469f, 0.341339111f, -1.f),
    C_Normal3f(0.550147414f, -0.835067511f, 0.f),
    C_Vertex3f(0.259840488f, 0.333099365f, 0.f),
    C_Vertex3f(0.259840488f, 0.333099365f, -1.f),
    C_Normal3f(0.456452489f, -0.889747739f, 0.f),
    C_Vertex3f(0.248085022f, 0.32623291f, 0.f),
    C_Vertex3f(0.248085022f, 0.32623291f, -1.f),
    C_Normal3f(0.355742872f, -0.934583843f, 0.f),
    C_Vertex3f(0.235748291f, 0.320739746f, 0.f),
    C_Vertex3f(0.235748291f, 0.320739746f, -1.f),
    C_Normal3f(0.251564145f, -0.967840672f, 0.f),
    C_Vertex3f(0.222830296f, 0.316619873f, 0.f),
    C_Vertex3f(0.222830296f, 0.316619873f, -1.f),
    C_Normal3f(0.147740901f, -0.989026129f, 0.f),
    C_Vertex3f(0.209331036f, 0.313873291f, 0.f),
    C_Vertex3f(0.209331036f, 0.313873291f, -1.f),
    C_Normal3f(0.0478167869f, -0.998856187f, 0.f),
    C_Vertex3f(0.195250511f, 0.3125f, 0.f),
    C_Vertex3f(0.195250511f, 0.3125f, -1.f),
    C_Normal3f(-0.0473313145f, -0.998879313f, 0.f),
    C_Vertex3f(0.180644035f, 0.3125f, 0.f),
    C_Vertex3f(0.180644035f, 0.3125f, -1.f),
    C_Normal3f(-0.147163376f, -0.989112198f, 0.f),
    C_Vertex3f(0.166701317f, 0.313852787f, 0.f),
    C_Vertex3f(0.166701317f, 0.313852787f, -1.f),
    C_Normal3f(-0.251227051f, -0.967928112f, 0.f),
    C_Vertex3f(0.153367043f, 0.316558361f, 0.f),
    C_Vertex3f(0.153367043f, 0.316558361f, -1.f),
    C_Normal3f(-0.356173575f, -0.934419811f, 0.f),
    C_Vertex3f(0.140641212f, 0.320616722f, 0.f),
    C_Vertex3f(0.140641212f, 0.320616722f, -1.f),
    C_Normal3f(-0.458073854f, -0.888914049f, 0.f),
    C_Vertex3f(0.128523827f, 0.32602787f, 0.f),
    C_Vertex3f(0.128523827f, 0.32602787f, -1.f),
    C_Normal3f(-0.553181589f, -0.833060622f, 0.f),
    C_Vertex3f(0.117014885f, 0.332791805f, 0.f),
    C_Vertex3f(0.117014885f, 0.332791805f, -1.f),
    C_Normal3f(-0.638592303f, -0.769545197f, 0.f),
    C_Vertex3f(0.106114388f, 0.340908527f, 0.f),
    C_Vertex3f(0.106114388f, 0.340908527f, -1.f),
    C_Normal3f(-0.712636352f, -0.701533556f, 0.f),
    C_Vertex3f(0.0958223343f, 0.350378036f, 0.f),
    C_Vertex3f(0.0958223343f, 0.350378036f, -1.f),
    C_Normal3f(-0.785222948f, -0.619213164f, 0.f),
    C_Vertex3f(0.0861387253f, 0.361200333f, 0.f),
    C_Vertex3f(0.0861387253f, 0.361200333f, -1.f),
    C_Normal3f(-0.853595793f, -0.520935893f, 0.f),
    C_Vertex3f(0.0776655674f, 0.373402596f, 0.f),
    C_Vertex3f(0.0776655674f, 0.373402596f, -1.f),
    C_Normal3f(-0.906253219f, -0.422735006f, 0.f),
    C_Vertex3f(0.0704028606f, 0.386984825f, 0.f),
    C_Vertex3f(0.0704028606f, 0.386984825f, -1.f),
    C_Normal3f(-0.944444418f, -0.328670979f, 0.f),
    C_Vertex3f(0.064350605f, 0.401947021f, 0.f),
    C_Vertex3f(0.064350605f, 0.401947021f, -1.f),
    C_Normal3f(-0.97042954f, -0.241384804f, 0.f),
    C_Vertex3f(0.0595088005f, 0.418289185f, 0.f),
    C_Vertex3f(0.0595088005f, 0.418289185f, -1.f),
    C_Normal3f(-0.986761332f, -0.162179425f, 0.f),
    C_Vertex3f(0.0558774471f, 0.436011314f, 0.f),
    C_Vertex3f(0.0558774471f, 0.436011314f, -1.f),
    C_Normal3f(-0.995818496f, -0.091353938f, 0.f),
    C_Vertex3f(0.0534565449f, 0.455113411f, 0.f),
    C_Vertex3f(0.0534565449f, 0.455113411f, -1.f),
    C_Normal3f(-0.999542296f, -0.0302517843f, 0.f),
    C_Vertex3f(0.0522460938f, 0.475595474f, 0.f),
    C_Vertex3f(0.0522460938f, 0.475595474f, -1.f),
    C_End(),
    C_Begin(GL_QUAD_STRIP),
    C_Normal3f(-0.111304335f, -0.993786335f, 0.f),
    C_Vertex3f(0.196548462f, 0.597167969f, 0.f),
    C_Vertex3f(0.196548462f, 0.597167969f, -1.f),
    C_Normal3f(0.112364031f, -0.993667126f, 0.f),
    C_Vertex3f(0.181915283f, 0.597167969f, 0.f),
    C_Vertex3f(0.181915283f, 0.597167969f, -1.f),
    C_Normal3f(0.348519921f, -0.937301397f, 0.f),
    C_Vertex3f(0.168510914f, 0.593997478f, 0.f),
    C_Vertex3f(0.168510914f, 0.593997478f, -1.f),
    C_Normal3f(0.565459251f, -0.824776232f, 0.f),
    C_Vertex3f(0.156335354f, 0.587656498f, 0.f),
    C_Vertex3f(0.156335354f, 0.587656498f, -1.f),
    C_Normal3f(0.721895516f, -0.692002058f, 0.f),
    C_Vertex3f(0.145388603f, 0.578145027f, 0.f),
    C_Vertex3f(0.145388603f, 0.578145027f, -1.f),
    C_Normal3f(0.830083966f, -0.557638586f, 0.f),
    C_Vertex3f(0.138100147f, 0.568633556f, 0.f),
    C_Vertex3f(0.138100147f, 0.568633556f, -1.f),
    C_Normal3f(0.903640091f, -0.428292572f, 0.f),
    C_Vertex3f(0.133848548f, 0.560966849f, 0.f),
    C_Vertex3f(0.133848548f, 0.560966849f, -1.f),
    C_Normal3f(0.945036769f, -0.32696408f, 0.f),
    C_Vertex3f(0.13020432f, 0.551974416f, 0.f),
    C_Vertex3f(0.13020432f, 0.551974416f, -1.f),
    C_Normal3f(0.9703933f, -0.241530389f, 0.f),
    C_Vertex3f(0.127167463f, 0.541656256f, 0.f),
    C_Vertex3f(0.127167463f, 0.541656256f, -1.f),
    C_Normal3f(0.985407174f, -0.170213774f, 0.f),
    C_Vertex3f(0.124737978f, 0.530012369f, 0.f),
    C_Vertex3f(0.124737978f, 0.530012369f, -1.f),
    C_Normal3f(0.993854046f, -0.110698603f, 0.f),
    C_Vertex3f(0.122915864f, 0.517042756f, 0.f),
    C_Vertex3f(0.122915864f, 0.517042756f, -1.f),
    C_Normal3f(0.998150289f, -0.0607941896f, 0.f),
    C_Vertex3f(0.121701121f, 0.502747416f, 0.f),
    C_Vertex3f(0.121701121f, 0.502747416f, -1.f),
    C_Normal3f(0.999817669f, -0.0190950092f, 0.f),
    C_Vertex3f(0.12109375f, 0.48712635f, 0.f),
    C_Vertex3f(0.12109375f, 0.48712635f, -1.f),
    C_Normal3f(0.999796689f, 0.0201660916f, 0.f),
    C_Vertex3f(0.12109375f, 0.470945358f, 0.f),
    C_Vertex3f(0.12109375f, 0.470945358f, -1.f),
    C_Normal3f(0.997747064f, 0.067088455f, 0.f),
    C_Vertex3f(0.121708035f, 0.456671238f, 0.f),
    C_Vertex3f(0.121708035f, 0.456671238f, -1.f),
    C_Normal3f(0.992610693f, 0.121342421f, 0.f),
    C_Vertex3f(0.122936606f, 0.443538189f, 0.f),
    C_Vertex3f(0.122936606f, 0.443538189f, -1.f),
    C_Normal3f(0.982739747f, 0.184993237f, 0.f),
    C_Vertex3f(0.124779463f, 0.431546211f, 0.f),
    C_Vertex3f(0.124779463f, 0.431546211f, -1.f),
    C_Normal3f(0.965698421f, 0.259666264f, 0.f),
    C_Vertex3f(0.127236605f, 0.420695305f, 0.f),
    C_Vertex3f(0.127236605f, 0.420695305f, -1.f),
    C_Normal3f(0.937961102f, 0.346740723f, 0.f),
    C_Vertex3f(0.130308032f, 0.41098547f, 0.f),
    C_Vertex3f(0.130308032f, 0.41098547f, -1.f),
    C_Normal3f(0.894707084f, 0.446653426f, 0.f),
    C_Vertex3f(0.133993745f, 0.402416706f, 0.f),
    C_Vertex3f(0.133993745f, 0.402416706f, -1.f),
    C_Normal3f(0.822174847f, 0.569235086f, 0.f),
    C_Vertex3f(0.138293743f, 0.394989014f, 0.f),
    C_Vertex3f(0.138293743f, 0.394989014f, -1.f),
    C_Normal3f(0.716807783f, 0.697270989f, 0.f),
    C_Vertex3f(0.145665169f, 0.385559082f, 0.f),
    C_Vertex3f(0.145665169f, 0.385559082f, -1.f),
    C_Normal3f(0.562608302f, 0.826723576f, 0.f),
    C_Vertex3f(0.156639576f, 0.37612915f, 0.f),
    C_Vertex3f(0.156639576f, 0.37612915f, -1.f),
    C_Normal3f(0.348209977f, 0.937416613f, 0.f),
    C_Vertex3f(0.168759823f, 0.369842529f, 0.f),
    C_Vertex3f(0.168759823f, 0.369842529f, -1.f),
    C_Normal3f(0.111958086f, 0.993712962f, 0.f),
    C_Vertex3f(0.182025909f, 0.366699219f, 0.f),
    C_Vertex3f(0.182025909f, 0.366699219f, -1.f),
    C_Normal3f(-0.111711197f, 0.993740737f, 0.f),
    C_Vertex3f(0.196659088f, 0.366699219f, 0.f),
    C_Vertex3f(0.196659088f, 0.366699219f, -1.f),
    C_Normal3f(-0.345238507f, 0.938515007f, 0.f),
    C_Vertex3f(0.210229397f, 0.369869709f, 0.f),
    C_Vertex3f(0.210229397f, 0.369869709f, -1.f),
    C_Normal3f(-0.562709033f, 0.82665503f, 0.f),
    C_Vertex3f(0.222515583f, 0.37621069f, 0.f),
    C_Vertex3f(0.222515583f, 0.37621069f, -1.f),
    C_Normal3f(-0.720847607f, 0.693093479f, 0.f),
    C_Vertex3f(0.233517647f, 0.38572216f, 0.f),
    C_Vertex3f(0.233517647f, 0.38572216f, -1.f),
    C_Normal3f(-0.829879522f, 0.557942629f, 0.f),
    C_Vertex3f(0.240806103f, 0.395233631f, 0.f),
    C_Vertex3f(0.240806103f, 0.395233631f, -1.f),
    C_Normal3f(-0.90323323f, 0.429149985f, 0.f),
    C_Vertex3f(0.245057702f, 0.402886748f, 0.f),
    C_Vertex3f(0.245057702f, 0.402886748f, -1.f),
    C_Normal3f(-0.944679618f, 0.327994645f, 0.f),
    C_Vertex3f(0.24870193f, 0.411852002f, 0.f),
    C_Vertex3f(0.24870193f, 0.411852002f, -1.f),
    C_Normal3f(-0.970146537f, 0.242519438f, 0.f),
    C_Vertex3f(0.251738787f, 0.422129393f, 0.f),
    C_Vertex3f(0.251738787f, 0.422129393f, -1.f),
    C_Normal3f(-0.985264242f, 0.171039f, 0.f),
    C_Vertex3f(0.254168272f, 0.43371892f, 0.f),
    C_Vertex3f(0.254168272f, 0.43371892f, -1.f),
    C_Normal3f(-0.993786693f, 0.111301348f, 0.f),
    C_Vertex3f(0.255990386f, 0.446620584f, 0.f),
    C_Vertex3f(0.255990386f, 0.446620584f, -1.f),
    C_Normal3f(-0.998128355f, 0.061153993f, 0.f),
    C_Vertex3f(0.257205129f, 0.460834384f, 0.f),
    C_Vertex3f(0.257205129f, 0.460834384f, -1.f),
    C_Normal3f(-0.999816597f, 0.0191522781f, 0.f),
    C_Vertex3f(0.2578125f, 0.476360321f, 0.f),
    C_Vertex3f(0.2578125f, 0.476360321f, -1.f),
    C_Normal3f(-0.999798f, -0.0201033223f, 0.f),
    C_Vertex3f(0.2578125f, 0.492541313f, 0.f),
    C_Vertex3f(0.2578125f, 0.492541313f, -1.f),
    C_Normal3f(-0.997775733f, -0.0666606799f, 0.f),
    C_Vertex3f(0.257198215f, 0.506910563f, 0.f),
    C_Vertex3f(0.257198215f, 0.506910563f, -1.f),
    C_Normal3f(-0.992696941f, -0.120635211f, 0.f),
    C_Vertex3f(0.255969644f, 0.520125151f, 0.f),
    C_Vertex3f(0.255969644f, 0.520125151f, -1.f),
    C_Normal3f(-0.982918441f, -0.18404147f, 0.f),
    C_Vertex3f(0.254126787f, 0.532185078f, 0.f),
    C_Vertex3f(0.254126787f, 0.532185078f, -1.f),
    C_Normal3f(-0.965997696f, -0.258550465f, 0.f),
    C_Vertex3f(0.251669645f, 0.543090343f, 0.f),
    C_Vertex3f(0.251669645f, 0.543090343f, -1.f),
    C_Normal3f(-0.938378155f, -0.345610112f, 0.f),
    C_Vertex3f(0.248598218f, 0.552840948f, 0.f),
    C_Vertex3f(0.248598218f, 0.552840948f, -1.f),
    C_Normal3f(-0.895160556f, -0.445743769f, 0.f),
    C_Vertex3f(0.244912505f, 0.561436892f, 0.f),
    C_Vertex3f(0.244912505f, 0.561436892f, -1.f),
    C_Normal3f(-0.822389424f, -0.568925023f, 0.f),
    C_Vertex3f(0.240612507f, 0.568878174f, 0.f),
    C_Vertex3f(0.240612507f, 0.568878174f, -1.f),
    C_Normal3f(-0.715757668f, -0.698348701f, 0.f),
    C_Vertex3f(0.233241081f, 0.578308105f, 0.f),
    C_Vertex3f(0.233241081f, 0.578308105f, -1.f),
    C_Normal3f(-0.559855759f, -0.828589976f, 0.f),
    C_Vertex3f(0.222211361f, 0.587738037f, 0.f),
    C_Vertex3f(0.222211361f, 0.587738037f, -1.f),
    C_Normal3f(-0.344905913f, -0.938637316f, 0.f),
    C_Vertex3f(0.209980488f, 0.594024658f, 0.f),
    C_Vertex3f(0.209980488f, 0.594024658f, -1.f),
    C_Normal3f(-0.111304335f, -0.993786335f, 0.f),
    C_Vertex3f(0.196548462f, 0.597167969f, 0.f),
    C_Vertex3f(0.196548462f, 0.597167969f, -1.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.887815773f, 0.460199118f, 0.f),
    C_Vertex3f(0.189674377f, -0.0234375f, 0.f),
    C_Vertex3f(0.189674377f, -0.0234375f, -1.f),
    C_Vertex3f(0.539459229f, 0.651367188f, -1.f),
    C_Vertex3f(0.539459229f, 0.651367188f, 0.f),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.539459229f, 0.651367188f, 0.f),
    C_Vertex3f(0.539459229f, 0.651367188f, -1.f),
    C_Vertex3f(0.60345459f, 0.651367188f, -1.f),
    C_Vertex3f(0.60345459f, 0.651367188f, 0.f),
    C_Normal3f(0.888405979f, -0.459058642f, 0.f),
    C_Vertex3f(0.60345459f, 0.651367188f, 0.f),
    C_Vertex3f(0.60345459f, 0.651367188f, -1.f),
    C_Vertex3f(0.254768372f, -0.0234375f, -1.f),
    C_Vertex3f(0.254768372f, -0.0234375f, 0.f),
    C_Normal3f(-0.f, -1.f, 0.f),
    C_Vertex3f(0.254768372f, -0.0234375f, 0.f),
    C_Vertex3f(0.254768372f, -0.0234375f, -1.f),
    C_Vertex3f(0.189674377f, -0.0234375f, -1.f),
    C_Vertex3f(0.189674377f, -0.0234375f, 0.f),
    C_End(),
    C_Begin(GL_QUAD_STRIP),
    C_Normal3f(-0.999541819f, -0.0302679744f, 0.f),
    C_Vertex3f(0.465820313f, 0.139712334f, 0.f),
    C_Vertex3f(0.465820313f, 0.139712334f, -1.f),
    C_Normal3f(-0.999554336f, 0.0298512783f, 0.f),
    C_Vertex3f(0.465820313f, 0.15922451f, 0.f),
    C_Vertex3f(0.465820313f, 0.15922451f, -1.f),
    C_Normal3f(-0.995095313f, 0.0989217609f, 0.f),
    C_Vertex3f(0.466899037f, 0.175832868f, 0.f),
    C_Vertex3f(0.466899037f, 0.175832868f, -1.f),
    C_Normal3f(-0.985410571f, 0.170194119f, 0.f),
    C_Vertex3f(0.469056487f, 0.191778541f, 0.f),
    C_Vertex3f(0.469056487f, 0.191778541f, -1.f),
    C_Normal3f(-0.96956563f, 0.244831294f, 0.f),
    C_Vertex3f(0.472292662f, 0.207061529f, 0.f),
    C_Vertex3f(0.472292662f, 0.207061529f, -1.f),
    C_Normal3f(-0.94685328f, 0.321666032f, 0.f),
    C_Vertex3f(0.476607561f, 0.221681833f, 0.f),
    C_Vertex3f(0.476607561f, 0.221681833f, -1.f),
    C_Normal3f(-0.916860342f, 0.399208099f, 0.f),
    C_Vertex3f(0.482001185f, 0.235639453f, 0.f),
    C_Vertex3f(0.482001185f, 0.235639453f, -1.f),
    C_Normal3f(-0.879582644f, 0.475746185f, 0.f),
    C_Vertex3f(0.488473535f, 0.248934388f, 0.f),
    C_Vertex3f(0.488473535f, 0.248934388f, -1.f),
    C_Normal3f(-0.835487843f, 0.549509108f, 0.f),
    C_Vertex3f(0.496024609f, 0.261566639f, 0.f),
    C_Vertex3f(0.496024609f, 0.261566639f, -1.f),
    C_Normal3f(-0.775977373f, 0.63076061f, 0.f),
    C_Vertex3f(0.504654408f, 0.273536205f, 0.f),
    C_Vertex3f(0.504654408f, 0.273536205f, -1.f),
    C_Normal3f(-0.693445206f, 0.720509291f, 0.f),
    C_Vertex3f(0.514267564f, 0.284009576f, 0.f),
    C_Vertex3f(0.514267564f, 0.284009576f, -1.f),
    C_Normal3f(-0.595956802f, 0.803016424f, 0.f),
    C_Vertex3f(0.524864078f, 0.292986751f, 0.f),
    C_Vertex3f(0.524864078f, 0.292986751f, -1.f),
    C_Normal3f(-0.48710534f, 0.873343289f, 0.f),
    C_Vertex3f(0.536443949f, 0.30046773f, 0.f),
    C_Vertex3f(0.536443949f, 0.30046773f, -1.f),
    C_Normal3f(-0.372292787f, 0.928115368f, 0.f),
    C_Vertex3f(0.549007177f, 0.306452513f, 0.f),
    C_Vertex3f(0.549007177f, 0.306452513f, -1.f),
    C_Normal3f(-0.257466793f, 0.966287196f, 0.f),
    C_Vertex3f(0.562553763f, 0.3109411f, 0.f),
    C_Vertex3f(0.562553763f, 0.3109411f, -1.f),
    C_Normal3f(-0.147764146f, 0.989022613f, 0.f),
    C_Vertex3f(0.577083707f, 0.313933492f, 0.f),
    C_Vertex3f(0.577083707f, 0.313933492f, -1.f),
    C_Normal3f(-0.0477495156f, 0.998859286f, 0.f),
    C_Vertex3f(0.592597008f, 0.315429688f, 0.f),
    C_Vertex3f(0.592597008f, 0.315429688f, -1.f),
    C_Normal3f(0.0445055254f, 0.999009132f, 0.f),
    C_Vertex3f(0.608382225f, 0.315429688f, 0.f),
    C_Vertex3f(0.608382225f, 0.315429688f, -1.f),
    C_Normal3f(0.141720682f, 0.989906669f, 0.f),
    C_Vertex3f(0.622807622f, 0.314083815f, 0.f),
    C_Vertex3f(0.622807622f, 0.314083815f, -1.f),
    C_Normal3f(0.242635757f, 0.970117509f, 0.f),
    C_Vertex3f(0.63658464f, 0.311392069f, 0.f),
    C_Vertex3f(0.63658464f, 0.311392069f, -1.f),
    C_Normal3f(0.345261753f, 0.938506424f, 0.f),
    C_Vertex3f(0.649713278f, 0.30735445f, 0.f),
    C_Vertex3f(0.649713278f, 0.30735445f, -1.f),
    C_Normal3f(0.445940405f, 0.895062685f, 0.f),
    C_Vertex3f(0.662193537f, 0.301970959f, 0.f),
    C_Vertex3f(0.662193537f, 0.301970959f, -1.f),
    C_Normal3f(0.540990233f, 0.84102881f, 0.f),
    C_Vertex3f(0.674025416f, 0.295241594f, 0.f),
    C_Vertex3f(0.674025416f, 0.295241594f, -1.f),
    C_Normal3f(0.627346754f, 0.778740048f, 0.f),
    C_Vertex3f(0.685208917f, 0.287166357f, 0.f),
    C_Vertex3f(0.685208917f, 0.287166357f, -1.f),
    C_Normal3f(0.703024745f, 0.711165428f, 0.f),
    C_Vertex3f(0.695744038f, 0.277745247f, 0.f),
    C_Vertex3f(0.695744038f, 0.277745247f, -1.f),
    C_Normal3f(0.775877118f, 0.630883992f, 0.f),
    C_Vertex3f(0.705630779f, 0.266978264f, 0.f),
    C_Vertex3f(0.705630779f, 0.266978264f, -1.f),
    C_Normal3f(0.84442699f, 0.535670519f, 0.f),
    C_Vertex3f(0.714281678f, 0.254947186f, 0.f),
    C_Vertex3f(0.714281678f, 0.254947186f, -1.f),
    C_Normal3f(0.898682773f, 0.438599199f, 0.f),
    C_Vertex3f(0.721696734f, 0.241652012f, 0.f),
    C_Vertex3f(0.721696734f, 0.241652012f, -1.f),
    C_Normal3f(0.939053118f, 0.343771964f, 0.f),
    C_Vertex3f(0.727875948f, 0.227092743f, 0.f),
    C_Vertex3f(0.727875948f, 0.227092743f, -1.f),
    C_Normal3f(0.967145681f, 0.254222751f, 0.f),
    C_Vertex3f(0.732819319f, 0.211269379f, 0.f),
    C_Vertex3f(0.732819319f, 0.211269379f, -1.f),
    C_Normal3f(0.985137045f, 0.171770364f, 0.f),
    C_Vertex3f(0.736526847f, 0.194181919f, 0.f),
    C_Vertex3f(0.736526847f, 0.194181919f, -1.f),
    C_Normal3f(0.99526602f, 0.0971885324f, 0.f),
    C_Vertex3f(0.738998532f, 0.175830364f, 0.f),
    C_Vertex3f(0.738998532f, 0.175830364f, -1.f),
    C_Normal3f(0.999528289f, 0.0307120122f, 0.f),
    C_Vertex3f(0.740234375f, 0.156214714f, 0.f),
    C_Vertex3f(0.740234375f, 0.156214714f, -1.f),
    C_Normal3f(0.999506831f, -0.0314029381f, 0.f),
    C_Vertex3f(0.740234375f, 0.135609627f, 0.f),
    C_Vertex3f(0.740234375f, 0.135609627f, -1.f),
    C_Normal3f(0.994950294f, -0.100368381f, 0.f),
    C_Vertex3f(0.738984942f, 0.11644721f, 0.f),
    C_Vertex3f(0.738984942f, 0.11644721f, -1.f),
    C_Normal3f(0.984284639f, -0.176589489f, 0.f),
    C_Vertex3f(0.736486077f, 0.0984528065f, 0.f),
    C_Vertex3f(0.736486077f, 0.0984528065f, -1.f),
    C_Normal3f(0.965614736f, -0.259977013f, 0.f),
    C_Vertex3f(0.73273778f, 0.0816264153f, 0.f),
    C_Vertex3f(0.73273778f, 0.0816264153f, -1.f),
    C_Normal3f(0.93694979f, -0.349463969f, 0.f),
    C_Vertex3f(0.727740049f, 0.0659680367f, 0.f),
    C_Vertex3f(0.727740049f, 0.0659680367f, -1.f),
    C_Normal3f(0.89651382f, -0.443015635f, 0.f),
    C_Vertex3f(0.721492887f, 0.0514776707f, 0.f),
    C_Vertex3f(0.721492887f, 0.0514776707f, -1.f),
    C_Normal3f(0.843208671f, -0.537586272f, 0.f),
    C_Vertex3f(0.713996291f, 0.0381553173f, 0.f),
    C_Vertex3f(0.713996291f, 0.0381553173f, -1.f),
    C_Normal3f(0.777104139f, -0.629371941f, 0.f),
    C_Vertex3f(0.705250263f, 0.0260009766f, 0.f),
    C_Vertex3f(0.705250263f, 0.0260009766f, -1.f),
    C_Normal3f(0.707354367f, -0.706859052f, 0.f),
    C_Vertex3f(0.695254803f, 0.0150146484f, 0.f),
    C_Vertex3f(0.695254803f, 0.0150146484f, -1.f),
    C_Normal3f(0.634057045f, -0.773286223f, 0.f),
    C_Vertex3f(0.684665322f, 0.00540161133f, 0.f),
    C_Vertex3f(0.684665322f, 0.00540161133f, -1.f),
    C_Normal3f(0.549623251f, -0.835412621f, 0.f),
    C_Vertex3f(0.673481822f, -0.00283813477f, 0.f),
    C_Vertex3f(0.673481822f, -0.00283813477f, -1.f),
    C_Normal3f(0.455601037f, -0.890184104f, 0.f),
    C_Vertex3f(0.661704302f, -0.00970458984f, 0.f),
    C_Vertex3f(0.661704302f, -0.00970458984f, -1.f),
    C_Normal3f(0.354732096f, -0.934968054f, 0.f),
    C_Vertex3f(0.649332762f, -0.0151977539f, 0.f),
    C_Vertex3f(0.649332762f, -0.0151977539f, -1.f),
    C_Normal3f(0.250605345f, -0.968089283f, 0.f),
    C_Vertex3f(0.636367202f, -0.019317627f, 0.f),
    C_Vertex3f(0.636367202f, -0.019317627f, -1.f),
    C_Normal3f(0.147045165f, -0.989129722f, 0.f),
    C_Vertex3f(0.622807622f, -0.022064209f, 0.f),
    C_Vertex3f(0.622807622f, -0.022064209f, -1.f),
    C_Normal3f(0.0476419777f, -0.998864532f, 0.f),
    C_Vertex3f(0.608654022f, -0.0234375f, 0.f),
    C_Vertex3f(0.608654022f, -0.0234375f, -1.f),
    C_Normal3f(-0.0475485139f, -0.998869002f, 0.f),
    C_Vertex3f(0.594015121f, -0.0234375f, 0.f),
    C_Vertex3f(0.594015121f, -0.0234375f, -1.f),
    C_Normal3f(-0.14809978f, -0.988972366f, 0.f),
    C_Vertex3f(0.580092788f, -0.0220779181f, 0.f),
    C_Vertex3f(0.580092788f, -0.0220779181f, -1.f),
    C_Normal3f(-0.252762735f, -0.967528284f, 0.f),
    C_Vertex3f(0.566778302f, -0.0193587542f, 0.f),
    C_Vertex3f(0.566778302f, -0.0193587542f, -1.f),
    C_Normal3f(-0.358209252f, -0.933641315f, 0.f),
    C_Vertex3f(0.554071665f, -0.0152800083f, 0.f),
    C_Vertex3f(0.554071665f, -0.0152800083f, -1.f),
    C_Normal3f(-0.460451365f, -0.887684882f, 0.f),
    C_Vertex3f(0.541972876f, -0.00984168053f, 0.f),
    C_Vertex3f(0.541972876f, -0.00984168053f, -1.f),
    C_Normal3f(-0.555712759f, -0.831374288f, 0.f),
    C_Vertex3f(0.530481935f, -0.00304377079f, 0.f),
    C_Vertex3f(0.530481935f, -0.00304377079f, -1.f),
    C_Normal3f(-0.641096294f, -0.767460525f, 0.f),
    C_Vertex3f(0.519598842f, 0.00511372089f, 0.f),
    C_Vertex3f(0.519598842f, 0.00511372089f, -1.f),
    C_Normal3f(-0.714969695f, -0.699155331f, 0.f),
    C_Vertex3f(0.509323597f, 0.0146307945f, 0.f),
    C_Vertex3f(0.509323597f, 0.0146307945f, -1.f),
    C_Normal3f(-0.78687644f, -0.61711067f, 0.f),
    C_Vertex3f(0.4996562f, 0.0255074501f, 0.f),
    C_Vertex3f(0.4996562f, 0.0255074501f, -1.f),
    C_Normal3f(-0.854409218f, -0.519600809f, 0.f),
    C_Vertex3f(0.491197228f, 0.0377436876f, 0.f),
    C_Vertex3f(0.491197228f, 0.0377436876f, -1.f),
    C_Normal3f(-0.906562805f, -0.42207092f, 0.f),
    C_Vertex3f(0.483946681f, 0.0513395071f, 0.f),
    C_Vertex3f(0.483946681f, 0.0513395071f, -1.f),
    C_Normal3f(-0.944504619f, -0.328498125f, 0.f),
    C_Vertex3f(0.477904558f, 0.0662949085f, 0.f),
    C_Vertex3f(0.477904558f, 0.0662949085f, -1.f),
    C_Normal3f(-0.970400035f, -0.241503254f, 0.f),
    C_Vertex3f(0.47307086f, 0.0826098919f, 0.f),
    C_Vertex3f(0.47307086f, 0.0826098919f, -1.f),
    C_Normal3f(-0.986723185f, -0.162411109f, 0.f),
    C_Vertex3f(0.469445586f, 0.100284457f, 0.f),
    C_Vertex3f(0.469445586f, 0.100284457f, -1.f),
    C_Normal3f(-0.995799482f, -0.0915607437f, 0.f),
    C_Vertex3f(0.467028737f, 0.119318604f, 0.f),
    C_Vertex3f(0.467028737f, 0.119318604f, -1.f),
    C_Normal3f(-0.999541819f, -0.0302679744f, 0.f),
    C_Vertex3f(0.465820313f, 0.139712334f, 0.f),
    C_Vertex3f(0.465820313f, 0.139712334f, -1.f),
    C_End(),
    C_Begin(GL_QUAD_STRIP),
    C_Normal3f(-0.111224085f, -0.993795276f, 0.f),
    C_Vertex3f(0.610321045f, 0.261230469f, 0.f),
    C_Vertex3f(0.610321045f, 0.261230469f, -1.f),
    C_Normal3f(0.111640364f, -0.993748665f, 0.f),
    C_Vertex3f(0.595624924f, 0.261230469f, 0.f),
    C_Vertex3f(0.595624924f, 0.261230469f, -1.f),
    C_Normal3f(0.346239418f, -0.938146234f, 0.f),
    C_Vertex3f(0.582099438f, 0.258059978f, 0.f),
    C_Vertex3f(0.582099438f, 0.258059978f, -1.f),
    C_Normal3f(0.563955128f, -0.825805366f, 0.f),
    C_Vertex3f(0.569853306f, 0.251718998f, 0.f),
    C_Vertex3f(0.569853306f, 0.251718998f, -1.f),
    C_Normal3f(0.721949756f, -0.691945434f, 0.f),
    C_Vertex3f(0.558886528f, 0.242207527f, 0.f),
    C_Vertex3f(0.558886528f, 0.242207527f, -1.f),
    C_Normal3f(0.830894351f, -0.556430101f, 0.f),
    C_Vertex3f(0.55162096f, 0.232696056f, 0.f),
    C_Vertex3f(0.55162096f, 0.232696056f, -1.f),
    C_Normal3f(0.904160261f, -0.427193344f, 0.f),
    C_Vertex3f(0.547382712f, 0.225029349f, 0.f),
    C_Vertex3f(0.547382712f, 0.225029349f, -1.f),
    C_Normal3f(0.945353687f, -0.326046616f, 0.f),
    C_Vertex3f(0.543749928f, 0.216036916f, 0.f),
    C_Vertex3f(0.543749928f, 0.216036916f, -1.f),
    C_Normal3f(0.970570743f, -0.240815938f, 0.f),
    C_Vertex3f(0.540722609f, 0.205718756f, 0.f),
    C_Vertex3f(0.540722609f, 0.205718756f, -1.f),
    C_Normal3f(0.98549664f, -0.169694647f, 0.f),
    C_Vertex3f(0.538300753f, 0.194074869f, 0.f),
    C_Vertex3f(0.538300753f, 0.194074869f, -1.f),
    C_Normal3f(0.993892193f, -0.110355213f, 0.f),
    C_Vertex3f(0.536484361f, 0.181105256f, 0.f),
    C_Vertex3f(0.536484361f, 0.181105256f, -1.f),
    C_Normal3f(0.998161852f, -0.0606039762f, 0.f),
    C_Vertex3f(0.535273433f, 0.166809916f, 0.f),
    C_Vertex3f(0.535273433f, 0.166809916f, -1.f),
    C_Normal3f(0.999818146f, -0.0190676469f, 0.f),
    C_Vertex3f(0.534667969f, 0.15118885f, 0.f),
    C_Vertex3f(0.534667969f, 0.15118885f, -1.f),
    C_Normal3f(0.999796093f, 0.0201941673f, 0.f),
    C_Vertex3f(0.534667969f, 0.135062218f, 0.f),
    C_Vertex3f(0.534667969f, 0.135062218f, -1.f),
    C_Normal3f(0.997736156f, 0.0672498718f, 0.f),
    C_Vertex3f(0.535280228f, 0.120876431f, 0.f),
    C_Vertex3f(0.535280228f, 0.120876431f, -1.f),
    C_Normal3f(0.99259156f, 0.121498376f, 0.f),
    C_Vertex3f(0.536504745f, 0.107811332f, 0.f),
    C_Vertex3f(0.536504745f, 0.107811332f, -1.f),
    C_Normal3f(0.98274076f, 0.184988424f, 0.f),
    C_Vertex3f(0.538341522f, 0.0958669186f, 0.f),
    C_Vertex3f(0.538341522f, 0.0958669186f, -1.f),
    C_Normal3f(0.965805709f, 0.259266764f, 0.f),
    C_Vertex3f(0.540790558f, 0.0850431919f, 0.f),
    C_Vertex3f(0.540790558f, 0.0850431919f, -1.f),
    C_Normal3f(0.938374341f, 0.345620573f, 0.f),
    C_Vertex3f(0.543851852f, 0.0753401518f, 0.f),
    C_Vertex3f(0.543851852f, 0.0753401518f, -1.f),
    C_Normal3f(0.895821929f, 0.444413185f, 0.f),
    C_Vertex3f(0.547525406f, 0.0667577982f, 0.f),
    C_Vertex3f(0.547525406f, 0.0667577982f, -1.f),
    C_Normal3f(0.824860394f, 0.565336525f, 0.f),
    C_Vertex3f(0.551811218f, 0.0592961311f, 0.f),
    C_Vertex3f(0.551811218f, 0.0592961311f, -1.f),
    C_Normal3f(0.720919788f, 0.693018377f, 0.f),
    C_Vertex3f(0.559158325f, 0.0497846603f, 0.f),
    C_Vertex3f(0.559158325f, 0.0497846603f, -1.f),
    C_Normal3f(0.56712091f, 0.823634624f, 0.f),
    C_Vertex3f(0.570097923f, 0.0402731895f, 0.f),
    C_Vertex3f(0.570097923f, 0.0402731895f, -1.f),
    C_Normal3f(0.351784319f, 0.936081052f, 0.f),
    C_Vertex3f(0.582180977f, 0.033932209f, 0.f),
    C_Vertex3f(0.582180977f, 0.033932209f, -1.f),
    C_Normal3f(0.112820596f, 0.993615389f, 0.f),
    C_Vertex3f(0.595407486f, 0.0307617188f, 0.f),
    C_Vertex3f(0.595407486f, 0.0307617188f, -1.f),
    C_Normal3f(-0.111006893f, 0.993819714f, 0.f),
    C_Vertex3f(0.610103607f, 0.0307617188f, 0.f),
    C_Vertex3f(0.610103607f, 0.0307617188f, -1.f),
    C_Normal3f(-0.343053162f, 0.939315915f, 0.f),
    C_Vertex3f(0.623792171f, 0.033932209f, 0.f),
    C_Vertex3f(0.623792171f, 0.033932209f, -1.f),
    C_Normal3f(-0.561263204f, 0.827637434f, 0.f),
    C_Vertex3f(0.636147022f, 0.0402731895f, 0.f),
    C_Vertex3f(0.636147022f, 0.0402731895f, -1.f),
    C_Normal3f(-0.720919788f, 0.693018377f, 0.f),
    C_Vertex3f(0.647168159f, 0.0497846603f, 0.f),
    C_Vertex3f(0.647168159f, 0.0497846603f, -1.f),
    C_Normal3f(-0.830690742f, 0.556734204f, 0.f),
    C_Vertex3f(0.654433727f, 0.0592961311f, 0.f),
    C_Vertex3f(0.654433727f, 0.0592961311f, -1.f),
    C_Normal3f(-0.903755248f, 0.428049564f, 0.f),
    C_Vertex3f(0.658671975f, 0.0669492483f, 0.f),
    C_Vertex3f(0.658671975f, 0.0669492483f, -1.f),
    C_Normal3f(-0.944998443f, 0.327074975f, 0.f),
    C_Vertex3f(0.662304759f, 0.0759145021f, 0.f),
    C_Vertex3f(0.662304759f, 0.0759145021f, -1.f),
    C_Normal3f(-0.97032553f, 0.241802454f, 0.f),
    C_Vertex3f(0.665332079f, 0.0861918926f, 0.f),
    C_Vertex3f(0.665332079f, 0.0861918926f, -1.f),
    C_Normal3f(-0.985354662f, 0.170517534f, 0.f),
    C_Vertex3f(0.667753935f, 0.0977814198f, 0.f),
    C_Vertex3f(0.667753935f, 0.0977814198f, -1.f),
    C_Normal3f(-0.993825257f, 0.110956132f, 0.f),
    C_Vertex3f(0.669570327f, 0.110683084f, 0.f),
    C_Vertex3f(0.669570327f, 0.110683084f, -1.f),
    C_Normal3f(-0.998140037f, 0.0609626621f, 0.f),
    C_Vertex3f(0.670781255f, 0.124896884f, 0.f),
    C_Vertex3f(0.670781255f, 0.124896884f, -1.f),
    C_Normal3f(-0.999817848f, 0.0190921575f, 0.f),
    C_Vertex3f(0.671386719f, 0.140422821f, 0.f),
    C_Vertex3f(0.671386719f, 0.140422821f, -1.f),
    C_Normal3f(-0.999799252f, -0.0200370271f, 0.f),
    C_Vertex3f(0.671386719f, 0.156603813f, 0.f),
    C_Vertex3f(0.671386719f, 0.156603813f, -1.f),
    C_Normal3f(-0.997790277f, -0.0664417297f, 0.f),
    C_Vertex3f(0.67077446f, 0.170973063f, 0.f),
    C_Vertex3f(0.67077446f, 0.170973063f, -1.f),
    C_Normal3f(-0.992744446f, -0.120242991f, 0.f),
    C_Vertex3f(0.669549942f, 0.184187651f, 0.f),
    C_Vertex3f(0.669549942f, 0.184187651f, -1.f),
    C_Normal3f(-0.983028173f, -0.183454767f, 0.f),
    C_Vertex3f(0.667713165f, 0.196247578f, 0.f),
    C_Vertex3f(0.667713165f, 0.196247578f, -1.f),
    C_Normal3f(-0.966210544f, -0.257754266f, 0.f),
    C_Vertex3f(0.66526413f, 0.207152843f, 0.f),
    C_Vertex3f(0.66526413f, 0.207152843f, -1.f),
    C_Normal3f(-0.938747525f, -0.344605535f, 0.f),
    C_Vertex3f(0.662202835f, 0.216903448f, 0.f),
    C_Vertex3f(0.662202835f, 0.216903448f, -1.f),
    C_Normal3f(-0.895747006f, -0.444564313f, 0.f),
    C_Vertex3f(0.658529282f, 0.225499392f, 0.f),
    C_Vertex3f(0.658529282f, 0.225499392f, -1.f),
    C_Normal3f(-0.823267579f, -0.567653596f, 0.f),
    C_Vertex3f(0.654243469f, 0.232940674f, 0.f),
    C_Vertex3f(0.654243469f, 0.232940674f, -1.f),
    C_Normal3f(-0.716898263f, -0.697177768f, 0.f),
    C_Vertex3f(0.646896362f, 0.242370605f, 0.f),
    C_Vertex3f(0.646896362f, 0.242370605f, -1.f),
    C_Normal3f(-0.561095059f, -0.827751338f, 0.f),
    C_Vertex3f(0.635902405f, 0.251800537f, 0.f),
    C_Vertex3f(0.635902405f, 0.251800537f, -1.f),
    C_Normal3f(-0.345873922f, -0.93828094f, 0.f),
    C_Vertex3f(0.623710632f, 0.258087158f, 0.f),
    C_Vertex3f(0.623710632f, 0.258087158f, -1.f),
    C_Normal3f(-0.111224085f, -0.993795276f, 0.f),
    C_Vertex3f(0.610321045f, 0.261230469f, 0.f),
    C_Vertex3f(0.610321045f, 0.261230469f, -1.f),
    C_End(),
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.2578125f, 0.492541313f, 0.f),
    C_Vertex3f(0.259840488f, 0.333099365f, 0.f),
    C_Vertex3f(0.260347724f, 0.631179094f, 0.f),
    C_Vertex3f(0.27101469f, 0.341339111f, 0.f),
    C_Vertex3f(0.271549344f, 0.623103857f, 0.f),
    C_Vertex3f(0.281607628f, 0.350952148f, 0.f),
    C_Vertex3f(0.282101154f, 0.613682747f, 0.f),
    C_Vertex3f(0.291619301f, 0.361938477f, 0.f),
    C_Vertex3f(0.292003155f, 0.602915764f, 0.f),
    C_Vertex3f(0.300379515f, 0.374092817f, 0.f),
    C_Vertex3f(0.300667405f, 0.590884686f, 0.f),
    C_Vertex3f(0.307888269f, 0.387415171f, 0.f),
    C_Vertex3f(0.308093905f, 0.577589512f, 0.f),
    C_Vertex3f(0.314145565f, 0.401905537f, 0.f),
    C_Vertex3f(0.314282656f, 0.563030243f, 0.f),
    C_Vertex3f(0.319151402f, 0.417563915f, 0.f),
    C_Vertex3f(0.319233656f, 0.547206879f, 0.f),
    C_Vertex3f(0.322905779f, 0.434390306f, 0.f),
    C_Vertex3f(0.322946906f, 0.530119419f, 0.f),
    C_Vertex3f(0.325408697f, 0.45238471f, 0.f),
    C_Vertex3f(0.325422406f, 0.511767864f, 0.f),
    C_Vertex3f(0.326660156f, 0.471547127f, 0.f),
    C_Vertex3f(0.326660156f, 0.492152214f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.260347724f, 0.631179094f, 0.f),
    C_Vertex3f(0.248496294f, 0.637908459f, 0.f),
    C_Vertex3f(0.248598218f, 0.552840948f, 0.f),
    C_Vertex3f(0.251669645f, 0.543090343f, 0.f),
    C_Vertex3f(0.254126787f, 0.532185078f, 0.f),
    C_Vertex3f(0.255969644f, 0.520125151f, 0.f),
    C_Vertex3f(0.257198215f, 0.506910563f, 0.f),
    C_Vertex3f(0.2578125f, 0.492541313f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.209980488f, 0.594024658f, 0.f),
    C_Vertex3f(0.222211361f, 0.587738037f, 0.f),
    C_Vertex3f(0.222844005f, 0.647329569f, 0.f),
    C_Vertex3f(0.233241081f, 0.578308105f, 0.f),
    C_Vertex3f(0.235995054f, 0.64329195f, 0.f),
    C_Vertex3f(0.240612507f, 0.568878174f, 0.f),
    C_Vertex3f(0.248496294f, 0.637908459f, 0.f),
    C_Vertex3f(0.244912505f, 0.561436892f, 0.f),
    C_Vertex3f(0.248598218f, 0.552840948f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.138100147f, 0.568633556f, 0.f),
    C_Vertex3f(0.145388603f, 0.578145027f, 0.f),
    C_Vertex3f(0.148927689f, 0.646858215f, 0.f),
    C_Vertex3f(0.156335354f, 0.587656498f, 0.f),
    C_Vertex3f(0.163396835f, 0.649864197f, 0.f),
    C_Vertex3f(0.168510914f, 0.593997478f, 0.f),
    C_Vertex3f(0.178836823f, 0.651367188f, 0.f),
    C_Vertex3f(0.181915283f, 0.597167969f, 0.f),
    C_Vertex3f(0.194592476f, 0.651367188f, 0.f),
    C_Vertex3f(0.196548462f, 0.597167969f, 0.f),
    C_Vertex3f(0.209043145f, 0.650021315f, 0.f),
    C_Vertex3f(0.209980488f, 0.594024658f, 0.f),
    C_Vertex3f(0.222844005f, 0.647329569f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.135429382f, 0.642349243f, 0.f),
    C_Vertex3f(0.122901917f, 0.63633728f, 0.f),
    C_Vertex3f(0.122915864f, 0.517042756f, 0.f),
    C_Vertex3f(0.124737978f, 0.530012369f, 0.f),
    C_Vertex3f(0.127167463f, 0.541656256f, 0.f),
    C_Vertex3f(0.13020432f, 0.551974416f, 0.f),
    C_Vertex3f(0.133848548f, 0.560966849f, 0.f),
    C_Vertex3f(0.138100147f, 0.568633556f, 0.f),
    C_Vertex3f(0.148927689f, 0.646858215f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.121708035f, 0.456671238f, 0.f),
    C_Vertex3f(0.12109375f, 0.470945358f, 0.f),
    C_Vertex3f(0.117014885f, 0.332791805f, 0.f),
    C_Vertex3f(0.12109375f, 0.48712635f, 0.f),
    C_Vertex3f(0.122901917f, 0.63633728f, 0.f),
    C_Vertex3f(0.121701121f, 0.502747416f, 0.f),
    C_Vertex3f(0.122915864f, 0.517042756f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.0533266068f, 0.511627674f, 0.f),
    C_Vertex3f(0.0534565449f, 0.455113411f, 0.f),
    C_Vertex3f(0.0554876328f, 0.527505398f, 0.f),
    C_Vertex3f(0.0558774471f, 0.436011314f, 0.f),
    C_Vertex3f(0.0587291718f, 0.542740822f, 0.f),
    C_Vertex3f(0.0595088005f, 0.418289185f, 0.f),
    C_Vertex3f(0.0630512238f, 0.557333946f, 0.f),
    C_Vertex3f(0.064350605f, 0.401947021f, 0.f),
    C_Vertex3f(0.0684537888f, 0.571284771f, 0.f),
    C_Vertex3f(0.0704028606f, 0.386984825f, 0.f),
    C_Vertex3f(0.0749368668f, 0.584593296f, 0.f),
    C_Vertex3f(0.0776655674f, 0.373402596f, 0.f),
    C_Vertex3f(0.0825004578f, 0.597259521f, 0.f),
    C_Vertex3f(0.0861387253f, 0.361200333f, 0.f),
    C_Vertex3f(0.0911445618f, 0.609283447f, 0.f),
    C_Vertex3f(0.0958223343f, 0.350378036f, 0.f),
    C_Vertex3f(0.100759506f, 0.619804382f, 0.f),
    C_Vertex3f(0.106114388f, 0.340908527f, 0.f),
    C_Vertex3f(0.111345291f, 0.628822327f, 0.f),
    C_Vertex3f(0.117014885f, 0.332791805f, 0.f),
    C_Vertex3f(0.122901917f, 0.63633728f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.0522460938f, 0.495107651f, 0.f),
    C_Vertex3f(0.0522460938f, 0.475595474f, 0.f),
    C_Vertex3f(0.0534565449f, 0.455113411f, 0.f),
    C_Vertex3f(0.0533266068f, 0.511627674f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.259840488f, 0.333099365f, 0.f),
    C_Vertex3f(0.2578125f, 0.492541313f, 0.f),
    C_Vertex3f(0.2578125f, 0.476360321f, 0.f),
    C_Vertex3f(0.257205129f, 0.460834384f, 0.f),
    C_Vertex3f(0.255990386f, 0.446620584f, 0.f),
    C_Vertex3f(0.254168272f, 0.43371892f, 0.f),
    C_Vertex3f(0.251738787f, 0.422129393f, 0.f),
    C_Vertex3f(0.24870193f, 0.411852002f, 0.f),
    C_Vertex3f(0.248085022f, 0.32623291f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.24870193f, 0.411852002f, 0.f),
    C_Vertex3f(0.245057702f, 0.402886748f, 0.f),
    C_Vertex3f(0.248085022f, 0.32623291f, 0.f),
    C_Vertex3f(0.240806103f, 0.395233631f, 0.f),
    C_Vertex3f(0.235748291f, 0.320739746f, 0.f),
    C_Vertex3f(0.233517647f, 0.38572216f, 0.f),
    C_Vertex3f(0.222830296f, 0.316619873f, 0.f),
    C_Vertex3f(0.222515583f, 0.37621069f, 0.f),
    C_Vertex3f(0.210229397f, 0.369869709f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.222830296f, 0.316619873f, 0.f),
    C_Vertex3f(0.210229397f, 0.369869709f, 0.f),
    C_Vertex3f(0.209331036f, 0.313873291f, 0.f),
    C_Vertex3f(0.196659088f, 0.366699219f, 0.f),
    C_Vertex3f(0.195250511f, 0.3125f, 0.f),
    C_Vertex3f(0.182025909f, 0.366699219f, 0.f),
    C_Vertex3f(0.180644035f, 0.3125f, 0.f),
    C_Vertex3f(0.168759823f, 0.369842529f, 0.f),
    C_Vertex3f(0.166701317f, 0.313852787f, 0.f),
    C_Vertex3f(0.156639576f, 0.37612915f, 0.f),
    C_Vertex3f(0.153367043f, 0.316558361f, 0.f),
    C_Vertex3f(0.145665169f, 0.385559082f, 0.f),
    C_Vertex3f(0.140641212f, 0.320616722f, 0.f),
    C_Vertex3f(0.138293743f, 0.394989014f, 0.f),
    C_Vertex3f(0.133993745f, 0.402416706f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.130308032f, 0.41098547f, 0.f),
    C_Vertex3f(0.127236605f, 0.420695305f, 0.f),
    C_Vertex3f(0.128523827f, 0.32602787f, 0.f),
    C_Vertex3f(0.140641212f, 0.320616722f, 0.f),
    C_Vertex3f(0.133993745f, 0.402416706f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.128523827f, 0.32602787f, 0.f),
    C_Vertex3f(0.127236605f, 0.420695305f, 0.f),
    C_Vertex3f(0.124779463f, 0.431546211f, 0.f),
    C_Vertex3f(0.122936606f, 0.443538189f, 0.f),
    C_Vertex3f(0.121708035f, 0.456671238f, 0.f),
    C_Vertex3f(0.117014885f, 0.332791805f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.539459229f, 0.651367188f, 0.f),
    C_Vertex3f(0.189674377f, -0.0234375f, 0.f),
    C_Vertex3f(0.254768372f, -0.0234375f, 0.f),
    C_Vertex3f(0.60345459f, 0.651367188f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.671386719f, 0.156603813f, 0.f),
    C_Vertex3f(0.673481822f, -0.00283813477f, 0.f),
    C_Vertex3f(0.674025416f, 0.295241594f, 0.f),
    C_Vertex3f(0.684665322f, 0.00540161133f, 0.f),
    C_Vertex3f(0.685208917f, 0.287166357f, 0.f),
    C_Vertex3f(0.695254803f, 0.0150146484f, 0.f),
    C_Vertex3f(0.695744038f, 0.277745247f, 0.f),
    C_Vertex3f(0.705250263f, 0.0260009766f, 0.f),
    C_Vertex3f(0.705630779f, 0.266978264f, 0.f),
    C_Vertex3f(0.713996291f, 0.0381553173f, 0.f),
    C_Vertex3f(0.714281678f, 0.254947186f, 0.f),
    C_Vertex3f(0.721492887f, 0.0514776707f, 0.f),
    C_Vertex3f(0.721696734f, 0.241652012f, 0.f),
    C_Vertex3f(0.727740049f, 0.0659680367f, 0.f),
    C_Vertex3f(0.727875948f, 0.227092743f, 0.f),
    C_Vertex3f(0.73273778f, 0.0816264153f, 0.f),
    C_Vertex3f(0.732819319f, 0.211269379f, 0.f),
    C_Vertex3f(0.736486077f, 0.0984528065f, 0.f),
    C_Vertex3f(0.736526847f, 0.194181919f, 0.f),
    C_Vertex3f(0.738984942f, 0.11644721f, 0.f),
    C_Vertex3f(0.738998532f, 0.175830364f, 0.f),
    C_Vertex3f(0.740234375f, 0.135609627f, 0.f),
    C_Vertex3f(0.740234375f, 0.156214714f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.674025416f, 0.295241594f, 0.f),
    C_Vertex3f(0.662193537f, 0.301970959f, 0.f),
    C_Vertex3f(0.662202835f, 0.216903448f, 0.f),
    C_Vertex3f(0.66526413f, 0.207152843f, 0.f),
    C_Vertex3f(0.667713165f, 0.196247578f, 0.f),
    C_Vertex3f(0.669549942f, 0.184187651f, 0.f),
    C_Vertex3f(0.67077446f, 0.170973063f, 0.f),
    C_Vertex3f(0.671386719f, 0.156603813f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.623710632f, 0.258087158f, 0.f),
    C_Vertex3f(0.635902405f, 0.251800537f, 0.f),
    C_Vertex3f(0.63658464f, 0.311392069f, 0.f),
    C_Vertex3f(0.646896362f, 0.242370605f, 0.f),
    C_Vertex3f(0.649713278f, 0.30735445f, 0.f),
    C_Vertex3f(0.654243469f, 0.232940674f, 0.f),
    C_Vertex3f(0.662193537f, 0.301970959f, 0.f),
    C_Vertex3f(0.658529282f, 0.225499392f, 0.f),
    C_Vertex3f(0.662202835f, 0.216903448f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.55162096f, 0.232696056f, 0.f),
    C_Vertex3f(0.558886528f, 0.242207527f, 0.f),
    C_Vertex3f(0.562553763f, 0.3109411f, 0.f),
    C_Vertex3f(0.569853306f, 0.251718998f, 0.f),
    C_Vertex3f(0.577083707f, 0.313933492f, 0.f),
    C_Vertex3f(0.582099438f, 0.258059978f, 0.f),
    C_Vertex3f(0.592597008f, 0.315429688f, 0.f),
    C_Vertex3f(0.595624924f, 0.261230469f, 0.f),
    C_Vertex3f(0.608382225f, 0.315429688f, 0.f),
    C_Vertex3f(0.610321045f, 0.261230469f, 0.f),
    C_Vertex3f(0.622807622f, 0.314083815f, 0.f),
    C_Vertex3f(0.623710632f, 0.258087158f, 0.f),
    C_Vertex3f(0.63658464f, 0.311392069f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.549007177f, 0.306452513f, 0.f),
    C_Vertex3f(0.536443949f, 0.30046773f, 0.f),
    C_Vertex3f(0.536484361f, 0.181105256f, 0.f),
    C_Vertex3f(0.538300753f, 0.194074869f, 0.f),
    C_Vertex3f(0.540722609f, 0.205718756f, 0.f),
    C_Vertex3f(0.543749928f, 0.216036916f, 0.f),
    C_Vertex3f(0.547382712f, 0.225029349f, 0.f),
    C_Vertex3f(0.55162096f, 0.232696056f, 0.f),
    C_Vertex3f(0.562553763f, 0.3109411f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.535280228f, 0.120876431f, 0.f),
    C_Vertex3f(0.534667969f, 0.135062218f, 0.f),
    C_Vertex3f(0.530481935f, -0.00304377079f, 0.f),
    C_Vertex3f(0.534667969f, 0.15118885f, 0.f),
    C_Vertex3f(0.536443949f, 0.30046773f, 0.f),
    C_Vertex3f(0.535273433f, 0.166809916f, 0.f),
    C_Vertex3f(0.536484361f, 0.181105256f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.466899037f, 0.175832868f, 0.f),
    C_Vertex3f(0.467028737f, 0.119318604f, 0.f),
    C_Vertex3f(0.469056487f, 0.191778541f, 0.f),
    C_Vertex3f(0.469445586f, 0.100284457f, 0.f),
    C_Vertex3f(0.472292662f, 0.207061529f, 0.f),
    C_Vertex3f(0.47307086f, 0.0826098919f, 0.f),
    C_Vertex3f(0.476607561f, 0.221681833f, 0.f),
    C_Vertex3f(0.477904558f, 0.0662949085f, 0.f),
    C_Vertex3f(0.482001185f, 0.235639453f, 0.f),
    C_Vertex3f(0.483946681f, 0.0513395071f, 0.f),
    C_Vertex3f(0.488473535f, 0.248934388f, 0.f),
    C_Vertex3f(0.491197228f, 0.0377436876f, 0.f),
    C_Vertex3f(0.496024609f, 0.261566639f, 0.f),
    C_Vertex3f(0.4996562f, 0.0255074501f, 0.f),
    C_Vertex3f(0.504654408f, 0.273536205f, 0.f),
    C_Vertex3f(0.509323597f, 0.0146307945f, 0.f),
    C_Vertex3f(0.514267564f, 0.284009576f, 0.f),
    C_Vertex3f(0.519598842f, 0.00511372089f, 0.f),
    C_Vertex3f(0.524864078f, 0.292986751f, 0.f),
    C_Vertex3f(0.530481935f, -0.00304377079f, 0.f),
    C_Vertex3f(0.536443949f, 0.30046773f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.465820313f, 0.15922451f, 0.f),
    C_Vertex3f(0.465820313f, 0.139712334f, 0.f),
    C_Vertex3f(0.467028737f, 0.119318604f, 0.f),
    C_Vertex3f(0.466899037f, 0.175832868f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.673481822f, -0.00283813477f, 0.f),
    C_Vertex3f(0.671386719f, 0.156603813f, 0.f),
    C_Vertex3f(0.671386719f, 0.140422821f, 0.f),
    C_Vertex3f(0.670781255f, 0.124896884f, 0.f),
    C_Vertex3f(0.669570327f, 0.110683084f, 0.f),
    C_Vertex3f(0.667753935f, 0.0977814198f, 0.f),
    C_Vertex3f(0.665332079f, 0.0861918926f, 0.f),
    C_Vertex3f(0.662304759f, 0.0759145021f, 0.f),
    C_Vertex3f(0.661704302f, -0.00970458984f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.662304759f, 0.0759145021f, 0.f),
    C_Vertex3f(0.658671975f, 0.0669492483f, 0.f),
    C_Vertex3f(0.661704302f, -0.00970458984f, 0.f),
    C_Vertex3f(0.654433727f, 0.0592961311f, 0.f),
    C_Vertex3f(0.649332762f, -0.0151977539f, 0.f),
    C_Vertex3f(0.647168159f, 0.0497846603f, 0.f),
    C_Vertex3f(0.636367202f, -0.019317627f, 0.f),
    C_Vertex3f(0.636147022f, 0.0402731895f, 0.f),
    C_Vertex3f(0.623792171f, 0.033932209f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.636367202f, -0.019317627f, 0.f),
    C_Vertex3f(0.623792171f, 0.033932209f, 0.f),
    C_Vertex3f(0.622807622f, -0.022064209f, 0.f),
    C_Vertex3f(0.610103607f, 0.0307617188f, 0.f),
    C_Vertex3f(0.608654022f, -0.0234375f, 0.f),
    C_Vertex3f(0.595407486f, 0.0307617188f, 0.f),
    C_Vertex3f(0.594015121f, -0.0234375f, 0.f),
    C_Vertex3f(0.582180977f, 0.033932209f, 0.f),
    C_Vertex3f(0.580092788f, -0.0220779181f, 0.f),
    C_Vertex3f(0.570097923f, 0.0402731895f, 0.f),
    C_Vertex3f(0.566778302f, -0.0193587542f, 0.f),
    C_Vertex3f(0.559158325f, 0.0497846603f, 0.f),
    C_Vertex3f(0.554071665f, -0.0152800083f, 0.f),
    C_Vertex3f(0.551811218f, 0.0592961311f, 0.f),
    C_Vertex3f(0.547525406f, 0.0667577982f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.543851852f, 0.0753401518f, 0.f),
    C_Vertex3f(0.540790558f, 0.0850431919f, 0.f),
    C_Vertex3f(0.541972876f, -0.00984168053f, 0.f),
    C_Vertex3f(0.554071665f, -0.0152800083f, 0.f),
    C_Vertex3f(0.547525406f, 0.0667577982f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.541972876f, -0.00984168053f, 0.f),
    C_Vertex3f(0.540790558f, 0.0850431919f, 0.f),
    C_Vertex3f(0.538341522f, 0.0958669186f, 0.f),
    C_Vertex3f(0.536504745f, 0.107811332f, 0.f),
    C_Vertex3f(0.535280228f, 0.120876431f, 0.f),
    C_Vertex3f(0.530481935f, -0.00304377079f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, -1.f),
    C_FrontFace(GL_CW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.2578125f, 0.492541313f, -1.f),
    C_Vertex3f(0.259840488f, 0.333099365f, -1.f),
    C_Vertex3f(0.260347724f, 0.631179094f, -1.f),
    C_Vertex3f(0.27101469f, 0.341339111f, -1.f),
    C_Vertex3f(0.271549344f, 0.623103857f, -1.f),
    C_Vertex3f(0.281607628f, 0.350952148f, -1.f),
    C_Vertex3f(0.282101154f, 0.613682747f, -1.f),
    C_Vertex3f(0.291619301f, 0.361938477f, -1.f),
    C_Vertex3f(0.292003155f, 0.602915764f, -1.f),
    C_Vertex3f(0.300379515f, 0.374092817f, -1.f),
    C_Vertex3f(0.300667405f, 0.590884686f, -1.f),
    C_Vertex3f(0.307888269f, 0.387415171f, -1.f),
    C_Vertex3f(0.308093905f, 0.577589512f, -1.f),
    C_Vertex3f(0.314145565f, 0.401905537f, -1.f),
    C_Vertex3f(0.314282656f, 0.563030243f, -1.f),
    C_Vertex3f(0.319151402f, 0.417563915f, -1.f),
    C_Vertex3f(0.319233656f, 0.547206879f, -1.f),
    C_Vertex3f(0.322905779f, 0.434390306f, -1.f),
    C_Vertex3f(0.322946906f, 0.530119419f, -1.f),
    C_Vertex3f(0.325408697f, 0.45238471f, -1.f),
    C_Vertex3f(0.325422406f, 0.511767864f, -1.f),
    C_Vertex3f(0.326660156f, 0.471547127f, -1.f),
    C_Vertex3f(0.326660156f, 0.492152214f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.260347724f, 0.631179094f, -1.f),
    C_Vertex3f(0.248496294f, 0.637908459f, -1.f),
    C_Vertex3f(0.248598218f, 0.552840948f, -1.f),
    C_Vertex3f(0.251669645f, 0.543090343f, -1.f),
    C_Vertex3f(0.254126787f, 0.532185078f, -1.f),
    C_Vertex3f(0.255969644f, 0.520125151f, -1.f),
    C_Vertex3f(0.257198215f, 0.506910563f, -1.f),
    C_Vertex3f(0.2578125f, 0.492541313f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.209980488f, 0.594024658f, -1.f),
    C_Vertex3f(0.222211361f, 0.587738037f, -1.f),
    C_Vertex3f(0.222844005f, 0.647329569f, -1.f),
    C_Vertex3f(0.233241081f, 0.578308105f, -1.f),
    C_Vertex3f(0.235995054f, 0.64329195f, -1.f),
    C_Vertex3f(0.240612507f, 0.568878174f, -1.f),
    C_Vertex3f(0.248496294f, 0.637908459f, -1.f),
    C_Vertex3f(0.244912505f, 0.561436892f, -1.f),
    C_Vertex3f(0.248598218f, 0.552840948f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.138100147f, 0.568633556f, -1.f),
    C_Vertex3f(0.145388603f, 0.578145027f, -1.f),
    C_Vertex3f(0.148927689f, 0.646858215f, -1.f),
    C_Vertex3f(0.156335354f, 0.587656498f, -1.f),
    C_Vertex3f(0.163396835f, 0.649864197f, -1.f),
    C_Vertex3f(0.168510914f, 0.593997478f, -1.f),
    C_Vertex3f(0.178836823f, 0.651367188f, -1.f),
    C_Vertex3f(0.181915283f, 0.597167969f, -1.f),
    C_Vertex3f(0.194592476f, 0.651367188f, -1.f),
    C_Vertex3f(0.196548462f, 0.597167969f, -1.f),
    C_Vertex3f(0.209043145f, 0.650021315f, -1.f),
    C_Vertex3f(0.209980488f, 0.594024658f, -1.f),
    C_Vertex3f(0.222844005f, 0.647329569f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.135429382f, 0.642349243f, -1.f),
    C_Vertex3f(0.122901917f, 0.63633728f, -1.f),
    C_Vertex3f(0.122915864f, 0.517042756f, -1.f),
    C_Vertex3f(0.124737978f, 0.530012369f, -1.f),
    C_Vertex3f(0.127167463f, 0.541656256f, -1.f),
    C_Vertex3f(0.13020432f, 0.551974416f, -1.f),
    C_Vertex3f(0.133848548f, 0.560966849f, -1.f),
    C_Vertex3f(0.138100147f, 0.568633556f, -1.f),
    C_Vertex3f(0.148927689f, 0.646858215f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.121708035f, 0.456671238f, -1.f),
    C_Vertex3f(0.12109375f, 0.470945358f, -1.f),
    C_Vertex3f(0.117014885f, 0.332791805f, -1.f),
    C_Vertex3f(0.12109375f, 0.48712635f, -1.f),
    C_Vertex3f(0.122901917f, 0.63633728f, -1.f),
    C_Vertex3f(0.121701121f, 0.502747416f, -1.f),
    C_Vertex3f(0.122915864f, 0.517042756f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.0533266068f, 0.511627674f, -1.f),
    C_Vertex3f(0.0534565449f, 0.455113411f, -1.f),
    C_Vertex3f(0.0554876328f, 0.527505398f, -1.f),
    C_Vertex3f(0.0558774471f, 0.436011314f, -1.f),
    C_Vertex3f(0.0587291718f, 0.542740822f, -1.f),
    C_Vertex3f(0.0595088005f, 0.418289185f, -1.f),
    C_Vertex3f(0.0630512238f, 0.557333946f, -1.f),
    C_Vertex3f(0.064350605f, 0.401947021f, -1.f),
    C_Vertex3f(0.0684537888f, 0.571284771f, -1.f),
    C_Vertex3f(0.0704028606f, 0.386984825f, -1.f),
    C_Vertex3f(0.0749368668f, 0.584593296f, -1.f),
    C_Vertex3f(0.0776655674f, 0.373402596f, -1.f),
    C_Vertex3f(0.0825004578f, 0.597259521f, -1.f),
    C_Vertex3f(0.0861387253f, 0.361200333f, -1.f),
    C_Vertex3f(0.0911445618f, 0.609283447f, -1.f),
    C_Vertex3f(0.0958223343f, 0.350378036f, -1.f),
    C_Vertex3f(0.100759506f, 0.619804382f, -1.f),
    C_Vertex3f(0.106114388f, 0.340908527f, -1.f),
    C_Vertex3f(0.111345291f, 0.628822327f, -1.f),
    C_Vertex3f(0.117014885f, 0.332791805f, -1.f),
    C_Vertex3f(0.122901917f, 0.63633728f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.0522460938f, 0.495107651f, -1.f),
    C_Vertex3f(0.0522460938f, 0.475595474f, -1.f),
    C_Vertex3f(0.0534565449f, 0.455113411f, -1.f),
    C_Vertex3f(0.0533266068f, 0.511627674f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.259840488f, 0.333099365f, -1.f),
    C_Vertex3f(0.2578125f, 0.492541313f, -1.f),
    C_Vertex3f(0.2578125f, 0.476360321f, -1.f),
    C_Vertex3f(0.257205129f, 0.460834384f, -1.f),
    C_Vertex3f(0.255990386f, 0.446620584f, -1.f),
    C_Vertex3f(0.254168272f, 0.43371892f, -1.f),
    C_Vertex3f(0.251738787f, 0.422129393f, -1.f),
    C_Vertex3f(0.24870193f, 0.411852002f, -1.f),
    C_Vertex3f(0.248085022f, 0.32623291f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.24870193f, 0.411852002f, -1.f),
    C_Vertex3f(0.245057702f, 0.402886748f, -1.f),
    C_Vertex3f(0.248085022f, 0.32623291f, -1.f),
    C_Vertex3f(0.240806103f, 0.395233631f, -1.f),
    C_Vertex3f(0.235748291f, 0.320739746f, -1.f),
    C_Vertex3f(0.233517647f, 0.38572216f, -1.f),
    C_Vertex3f(0.222830296f, 0.316619873f, -1.f),
    C_Vertex3f(0.222515583f, 0.37621069f, -1.f),
    C_Vertex3f(0.210229397f, 0.369869709f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.222830296f, 0.316619873f, -1.f),
    C_Vertex3f(0.210229397f, 0.369869709f, -1.f),
    C_Vertex3f(0.209331036f, 0.313873291f, -1.f),
    C_Vertex3f(0.196659088f, 0.366699219f, -1.f),
    C_Vertex3f(0.195250511f, 0.3125f, -1.f),
    C_Vertex3f(0.182025909f, 0.366699219f, -1.f),
    C_Vertex3f(0.180644035f, 0.3125f, -1.f),
    C_Vertex3f(0.168759823f, 0.369842529f, -1.f),
    C_Vertex3f(0.166701317f, 0.313852787f, -1.f),
    C_Vertex3f(0.156639576f, 0.37612915f, -1.f),
    C_Vertex3f(0.153367043f, 0.316558361f, -1.f),
    C_Vertex3f(0.145665169f, 0.385559082f, -1.f),
    C_Vertex3f(0.140641212f, 0.320616722f, -1.f),
    C_Vertex3f(0.138293743f, 0.394989014f, -1.f),
    C_Vertex3f(0.133993745f, 0.402416706f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.130308032f, 0.41098547f, -1.f),
    C_Vertex3f(0.127236605f, 0.420695305f, -1.f),
    C_Vertex3f(0.128523827f, 0.32602787f, -1.f),
    C_Vertex3f(0.140641212f, 0.320616722f, -1.f),
    C_Vertex3f(0.133993745f, 0.402416706f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.128523827f, 0.32602787f, -1.f),
    C_Vertex3f(0.127236605f, 0.420695305f, -1.f),
    C_Vertex3f(0.124779463f, 0.431546211f, -1.f),
    C_Vertex3f(0.122936606f, 0.443538189f, -1.f),
    C_Vertex3f(0.121708035f, 0.456671238f, -1.f),
    C_Vertex3f(0.117014885f, 0.332791805f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.539459229f, 0.651367188f, -1.f),
    C_Vertex3f(0.189674377f, -0.0234375f, -1.f),
    C_Vertex3f(0.254768372f, -0.0234375f, -1.f),
    C_Vertex3f(0.60345459f, 0.651367188f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.671386719f, 0.156603813f, -1.f),
    C_Vertex3f(0.673481822f, -0.00283813477f, -1.f),
    C_Vertex3f(0.674025416f, 0.295241594f, -1.f),
    C_Vertex3f(0.684665322f, 0.00540161133f, -1.f),
    C_Vertex3f(0.685208917f, 0.287166357f, -1.f),
    C_Vertex3f(0.695254803f, 0.0150146484f, -1.f),
    C_Vertex3f(0.695744038f, 0.277745247f, -1.f),
    C_Vertex3f(0.705250263f, 0.0260009766f, -1.f),
    C_Vertex3f(0.705630779f, 0.266978264f, -1.f),
    C_Vertex3f(0.713996291f, 0.0381553173f, -1.f),
    C_Vertex3f(0.714281678f, 0.254947186f, -1.f),
    C_Vertex3f(0.721492887f, 0.0514776707f, -1.f),
    C_Vertex3f(0.721696734f, 0.241652012f, -1.f),
    C_Vertex3f(0.727740049f, 0.0659680367f, -1.f),
    C_Vertex3f(0.727875948f, 0.227092743f, -1.f),
    C_Vertex3f(0.73273778f, 0.0816264153f, -1.f),
    C_Vertex3f(0.732819319f, 0.211269379f, -1.f),
    C_Vertex3f(0.736486077f, 0.0984528065f, -1.f),
    C_Vertex3f(0.736526847f, 0.194181919f, -1.f),
    C_Vertex3f(0.738984942f, 0.11644721f, -1.f),
    C_Vertex3f(0.738998532f, 0.175830364f, -1.f),
    C_Vertex3f(0.740234375f, 0.135609627f, -1.f),
    C_Vertex3f(0.740234375f, 0.156214714f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.674025416f, 0.295241594f, -1.f),
    C_Vertex3f(0.662193537f, 0.301970959f, -1.f),
    C_Vertex3f(0.662202835f, 0.216903448f, -1.f),
    C_Vertex3f(0.66526413f, 0.207152843f, -1.f),
    C_Vertex3f(0.667713165f, 0.196247578f, -1.f),
    C_Vertex3f(0.669549942f, 0.184187651f, -1.f),
    C_Vertex3f(0.67077446f, 0.170973063f, -1.f),
    C_Vertex3f(0.671386719f, 0.156603813f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.623710632f, 0.258087158f, -1.f),
    C_Vertex3f(0.635902405f, 0.251800537f, -1.f),
    C_Vertex3f(0.63658464f, 0.311392069f, -1.f),
    C_Vertex3f(0.646896362f, 0.242370605f, -1.f),
    C_Vertex3f(0.649713278f, 0.30735445f, -1.f),
    C_Vertex3f(0.654243469f, 0.232940674f, -1.f),
    C_Vertex3f(0.662193537f, 0.301970959f, -1.f),
    C_Vertex3f(0.658529282f, 0.225499392f, -1.f),
    C_Vertex3f(0.662202835f, 0.216903448f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.55162096f, 0.232696056f, -1.f),
    C_Vertex3f(0.558886528f, 0.242207527f, -1.f),
    C_Vertex3f(0.562553763f, 0.3109411f, -1.f),
    C_Vertex3f(0.569853306f, 0.251718998f, -1.f),
    C_Vertex3f(0.577083707f, 0.313933492f, -1.f),
    C_Vertex3f(0.582099438f, 0.258059978f, -1.f),
    C_Vertex3f(0.592597008f, 0.315429688f, -1.f),
    C_Vertex3f(0.595624924f, 0.261230469f, -1.f),
    C_Vertex3f(0.608382225f, 0.315429688f, -1.f),
    C_Vertex3f(0.610321045f, 0.261230469f, -1.f),
    C_Vertex3f(0.622807622f, 0.314083815f, -1.f),
    C_Vertex3f(0.623710632f, 0.258087158f, -1.f),
    C_Vertex3f(0.63658464f, 0.311392069f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.549007177f, 0.306452513f, -1.f),
    C_Vertex3f(0.536443949f, 0.30046773f, -1.f),
    C_Vertex3f(0.536484361f, 0.181105256f, -1.f),
    C_Vertex3f(0.538300753f, 0.194074869f, -1.f),
    C_Vertex3f(0.540722609f, 0.205718756f, -1.f),
    C_Vertex3f(0.543749928f, 0.216036916f, -1.f),
    C_Vertex3f(0.547382712f, 0.225029349f, -1.f),
    C_Vertex3f(0.55162096f, 0.232696056f, -1.f),
    C_Vertex3f(0.562553763f, 0.3109411f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.535280228f, 0.120876431f, -1.f),
    C_Vertex3f(0.534667969f, 0.135062218f, -1.f),
    C_Vertex3f(0.530481935f, -0.00304377079f, -1.f),
    C_Vertex3f(0.534667969f, 0.15118885f, -1.f),
    C_Vertex3f(0.536443949f, 0.30046773f, -1.f),
    C_Vertex3f(0.535273433f, 0.166809916f, -1.f),
    C_Vertex3f(0.536484361f, 0.181105256f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.466899037f, 0.175832868f, -1.f),
    C_Vertex3f(0.467028737f, 0.119318604f, -1.f),
    C_Vertex3f(0.469056487f, 0.191778541f, -1.f),
    C_Vertex3f(0.469445586f, 0.100284457f, -1.f),
    C_Vertex3f(0.472292662f, 0.207061529f, -1.f),
    C_Vertex3f(0.47307086f, 0.0826098919f, -1.f),
    C_Vertex3f(0.476607561f, 0.221681833f, -1.f),
    C_Vertex3f(0.477904558f, 0.0662949085f, -1.f),
    C_Vertex3f(0.482001185f, 0.235639453f, -1.f),
    C_Vertex3f(0.483946681f, 0.0513395071f, -1.f),
    C_Vertex3f(0.488473535f, 0.248934388f, -1.f),
    C_Vertex3f(0.491197228f, 0.0377436876f, -1.f),
    C_Vertex3f(0.496024609f, 0.261566639f, -1.f),
    C_Vertex3f(0.4996562f, 0.0255074501f, -1.f),
    C_Vertex3f(0.504654408f, 0.273536205f, -1.f),
    C_Vertex3f(0.509323597f, 0.0146307945f, -1.f),
    C_Vertex3f(0.514267564f, 0.284009576f, -1.f),
    C_Vertex3f(0.519598842f, 0.00511372089f, -1.f),
    C_Vertex3f(0.524864078f, 0.292986751f, -1.f),
    C_Vertex3f(0.530481935f, -0.00304377079f, -1.f),
    C_Vertex3f(0.536443949f, 0.30046773f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.465820313f, 0.15922451f, -1.f),
    C_Vertex3f(0.465820313f, 0.139712334f, -1.f),
    C_Vertex3f(0.467028737f, 0.119318604f, -1.f),
    C_Vertex3f(0.466899037f, 0.175832868f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.673481822f, -0.00283813477f, -1.f),
    C_Vertex3f(0.671386719f, 0.156603813f, -1.f),
    C_Vertex3f(0.671386719f, 0.140422821f, -1.f),
    C_Vertex3f(0.670781255f, 0.124896884f, -1.f),
    C_Vertex3f(0.669570327f, 0.110683084f, -1.f),
    C_Vertex3f(0.667753935f, 0.0977814198f, -1.f),
    C_Vertex3f(0.665332079f, 0.0861918926f, -1.f),
    C_Vertex3f(0.662304759f, 0.0759145021f, -1.f),
    C_Vertex3f(0.661704302f, -0.00970458984f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.662304759f, 0.0759145021f, -1.f),
    C_Vertex3f(0.658671975f, 0.0669492483f, -1.f),
    C_Vertex3f(0.661704302f, -0.00970458984f, -1.f),
    C_Vertex3f(0.654433727f, 0.0592961311f, -1.f),
    C_Vertex3f(0.649332762f, -0.0151977539f, -1.f),
    C_Vertex3f(0.647168159f, 0.0497846603f, -1.f),
    C_Vertex3f(0.636367202f, -0.019317627f, -1.f),
    C_Vertex3f(0.636147022f, 0.0402731895f, -1.f),
    C_Vertex3f(0.623792171f, 0.033932209f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.636367202f, -0.019317627f, -1.f),
    C_Vertex3f(0.623792171f, 0.033932209f, -1.f),
    C_Vertex3f(0.622807622f, -0.022064209f, -1.f),
    C_Vertex3f(0.610103607f, 0.0307617188f, -1.f),
    C_Vertex3f(0.608654022f, -0.0234375f, -1.f),
    C_Vertex3f(0.595407486f, 0.0307617188f, -1.f),
    C_Vertex3f(0.594015121f, -0.0234375f, -1.f),
    C_Vertex3f(0.582180977f, 0.033932209f, -1.f),
    C_Vertex3f(0.580092788f, -0.0220779181f, -1.f),
    C_Vertex3f(0.570097923f, 0.0402731895f, -1.f),
    C_Vertex3f(0.566778302f, -0.0193587542f, -1.f),
    C_Vertex3f(0.559158325f, 0.0497846603f, -1.f),
    C_Vertex3f(0.554071665f, -0.0152800083f, -1.f),
    C_Vertex3f(0.551811218f, 0.0592961311f, -1.f),
    C_Vertex3f(0.547525406f, 0.0667577982f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.543851852f, 0.0753401518f, -1.f),
    C_Vertex3f(0.540790558f, 0.0850431919f, -1.f),
    C_Vertex3f(0.541972876f, -0.00984168053f, -1.f),
    C_Vertex3f(0.554071665f, -0.0152800083f, -1.f),
    C_Vertex3f(0.547525406f, 0.0667577982f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.541972876f, -0.00984168053f, -1.f),
    C_Vertex3f(0.540790558f, 0.0850431919f, -1.f),
    C_Vertex3f(0.538341522f, 0.0958669186f, -1.f),
    C_Vertex3f(0.536504745f, 0.107811332f, -1.f),
    C_Vertex3f(0.535280228f, 0.120876431f, -1.f),
    C_Vertex3f(0.530481935f, -0.00304377079f, -1.f),
    C_End(),
    C_Translatef(0.795898438f, 0.f, 0.f),
};
static const Call char_38[] = {
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_FrontFace(GL_CW),
    C_Begin(GL_QUAD_STRIP),
    C_Normal3f(0.742816985f, -0.669494569f, 0.f),
    C_Vertex3f(0.425132751f, 0.0755157471f, 0.f),
    C_Vertex3f(0.425132751f, 0.0755157471f, -1.f),
    C_Normal3f(0.702629447f, -0.711555958f, 0.f),
    C_Vertex3f(0.41541481f, 0.0647335052f, 0.f),
    C_Vertex3f(0.41541481f, 0.0647335052f, -1.f),
    C_Normal3f(0.645213008f, -0.764002681f, 0.f),
    C_Vertex3f(0.395104885f, 0.0458645821f, 0.f),
    C_Vertex3f(0.395104885f, 0.0458645821f, -1.f),
    C_Normal3f(0.565522134f, -0.824733019f, 0.f),
    C_Vertex3f(0.373920918f, 0.0296912193f, 0.f),
    C_Vertex3f(0.373920918f, 0.0296912193f, -1.f),
    C_Normal3f(0.474624872f, -0.880188107f, 0.f),
    C_Vertex3f(0.351862907f, 0.0162134171f, 0.f),
    C_Vertex3f(0.351862907f, 0.0162134171f, -1.f),
    C_Normal3f(0.373984993f, -0.927434802f, 0.f),
    C_Vertex3f(0.328930855f, 0.00543117523f, 0.f),
    C_Vertex3f(0.328930855f, 0.00543117523f, -1.f),
    C_Normal3f(0.266983688f, -0.963701069f, 0.f),
    C_Vertex3f(0.3050704f, -0.00265550613f, 0.f),
    C_Vertex3f(0.3050704f, -0.00265550613f, -1.f),
    C_Normal3f(0.158099204f, -0.987423241f, 0.f),
    C_Vertex3f(0.280281544f, -0.00804662704f, 0.f),
    C_Vertex3f(0.280281544f, -0.00804662704f, -1.f),
    C_Normal3f(0.0524478033f, -0.998623669f, 0.f),
    C_Vertex3f(0.254564285f, -0.0107421875f, 0.f),
    C_Vertex3f(0.254564285f, -0.0107421875f, -1.f),
    C_Normal3f(-0.0423890352f, -0.999101222f, 0.f),
    C_Vertex3f(0.228957176f, -0.0107421875f, 0.f),
    C_Vertex3f(0.228957176f, -0.0107421875f, -1.f),
    C_Normal3f(-0.136049315f, -0.990702093f, 0.f),
    C_Vertex3f(0.205657959f, -0.00866723061f, 0.f),
    C_Vertex3f(0.205657959f, -0.00866723061f, -1.f),
    C_Normal3f(-0.235628992f, -0.971843064f, 0.f),
    C_Vertex3f(0.183628082f, -0.00451731682f, 0.f),
    C_Vertex3f(0.183628082f, -0.00451731682f, -1.f),
    C_Normal3f(-0.339424312f, -0.940633416f, 0.f),
    C_Vertex3f(0.162867546f, 0.00170755386f, 0.f),
    C_Vertex3f(0.162867546f, 0.00170755386f, -1.f),
    C_Normal3f(-0.44375211f, -0.896149576f, 0.f),
    C_Vertex3f(0.14337635f, 0.0100073814f, 0.f),
    C_Vertex3f(0.14337635f, 0.0100073814f, -1.f),
    C_Normal3f(-0.544337451f, -0.838866353f, 0.f),
    C_Vertex3f(0.125154495f, 0.0203821659f, 0.f),
    C_Vertex3f(0.125154495f, 0.0203821659f, -1.f),
    C_Normal3f(-0.637085319f, -0.770793319f, 0.f),
    C_Vertex3f(0.108201981f, 0.0328319073f, 0.f),
    C_Vertex3f(0.108201981f, 0.0328319073f, -1.f),
    C_Normal3f(-0.717482865f, -0.696576118f, 0.f),
    C_Vertex3f(0.0925188065f, 0.0473566055f, 0.f),
    C_Vertex3f(0.0925188065f, 0.0473566055f, -1.f),
    C_Normal3f(-0.77997607f, -0.625809312f, 0.f),
    C_Vertex3f(0.0794696808f, 0.0624265671f, 0.f),
    C_Vertex3f(0.0794696808f, 0.0624265671f, -1.f),
    C_Normal3f(-0.830128014f, -0.557572782f, 0.f),
    C_Vertex3f(0.0692458153f, 0.0763628483f, 0.f),
    C_Vertex3f(0.0692458153f, 0.0763628483f, -1.f),
    C_Normal3f(-0.875161648f, -0.48383072f, 0.f),
    C_Vertex3f(0.060482502f, 0.0906951427f, 0.f),
    C_Vertex3f(0.060482502f, 0.0906951427f, -1.f),
    C_Normal3f(-0.915204108f, -0.402990639f, 0.f),
    C_Vertex3f(0.0531797409f, 0.10542345f, 0.f),
    C_Vertex3f(0.0531797409f, 0.10542345f, -1.f),
    C_Normal3f(-0.948599875f, -0.316477954f, 0.f),
    C_Vertex3f(0.047337532f, 0.120547771f, 0.f),
    C_Vertex3f(0.047337532f, 0.120547771f, -1.f),
    C_Normal3f(-0.974063396f, -0.226275548f, 0.f),
    C_Vertex3f(0.0429558754f, 0.136068106f, 0.f),
    C_Vertex3f(0.0429558754f, 0.136068106f, -1.f),
    C_Normal3f(-0.990884304f, -0.134715766f, 0.f),
    C_Vertex3f(0.040034771f, 0.151984453f, 0.f),
    C_Vertex3f(0.040034771f, 0.151984453f, -1.f),
    C_Normal3f(-0.998965979f, -0.0454645529f, 0.f),
    C_Vertex3f(0.0385742188f, 0.168296814f, 0.f),
    C_Vertex3f(0.0385742188f, 0.168296814f, -1.f),
    C_Normal3f(-0.999222755f, 0.0394201688f, 0.f),
    C_Vertex3f(0.0385742188f, 0.184076309f, 0.f),
    C_Vertex3f(0.0385742188f, 0.184076309f, -1.f),
    C_Normal3f(-0.99225527f, 0.124215335f, 0.f),
    C_Vertex3f(0.0397683382f, 0.198565364f, 0.f),
    C_Vertex3f(0.0397683382f, 0.198565364f, -1.f),
    C_Normal3f(-0.977849543f, 0.209309042f, 0.f),
    C_Vertex3f(0.0421565771f, 0.212692857f, 0.f),
    C_Vertex3f(0.0421565771f, 0.212692857f, -1.f),
    C_Normal3f(-0.955791473f, 0.294045478f, 0.f),
    C_Vertex3f(0.0457389355f, 0.226458788f, 0.f),
    C_Vertex3f(0.0457389355f, 0.226458788f, -1.f),
    C_Normal3f(-0.92643106f, 0.376464546f, 0.f),
    C_Vertex3f(0.0505154133f, 0.239863157f, 0.f),
    C_Vertex3f(0.0505154133f, 0.239863157f, -1.f),
    C_Normal3f(-0.890610576f, 0.454766959f, 0.f),
    C_Vertex3f(0.0564860106f, 0.252905965f, 0.f),
    C_Vertex3f(0.0564860106f, 0.252905965f, -1.f),
    C_Normal3f(-0.84955287f, 0.52750355f, 0.f),
    C_Vertex3f(0.0636507273f, 0.265587211f, 0.f),
    C_Vertex3f(0.0636507273f, 0.265587211f, -1.f),
    C_Normal3f(-0.80469352f, 0.593690515f, 0.f),
    C_Vertex3f(0.0720095634f, 0.277906895f, 0.f),
    C_Vertex3f(0.0720095634f, 0.277906895f, -1.f),
    C_Normal3f(-0.757717788f, 0.652582407f, 0.f),
    C_Vertex3f(0.0815625191f, 0.289865017f, 0.f),
    C_Vertex3f(0.0815625191f, 0.289865017f, -1.f),
    C_Normal3f(-0.709962845f, 0.70423919f, 0.f),
    C_Vertex3f(0.0922957659f, 0.301461339f, 0.f),
    C_Vertex3f(0.0922957659f, 0.301461339f, -1.f),
    C_Normal3f(-0.662327468f, 0.74921447f, 0.f),
    C_Vertex3f(0.104209304f, 0.312695861f, 0.f),
    C_Vertex3f(0.104209304f, 0.312695861f, -1.f),
    C_Normal3f(-0.61568749f, 0.787990391f, 0.f),
    C_Vertex3f(0.117303133f, 0.323568583f, 0.f),
    C_Vertex3f(0.117303133f, 0.323568583f, -1.f),
    C_Normal3f(-0.570679605f, 0.821172833f, 0.f),
    C_Vertex3f(0.131577253f, 0.334079504f, 0.f),
    C_Vertex3f(0.131577253f, 0.334079504f, -1.f),
    C_Normal3f(-0.527727008f, 0.849413931f, 0.f),
    C_Vertex3f(0.147031665f, 0.344228625f, 0.f),
    C_Vertex3f(0.147031665f, 0.344228625f, -1.f),
    C_Normal3f(-0.48707819f, 0.873358369f, 0.f),
    C_Vertex3f(0.163666368f, 0.354015946f, 0.f),
    C_Vertex3f(0.163666368f, 0.354015946f, -1.f),
    C_Normal3f(-0.45504877f, 0.89046663f, 0.f),
    C_Vertex3f(0.181481361f, 0.363441467f, 0.f),
    C_Vertex3f(0.181481361f, 0.363441467f, -1.f),
    C_Normal3f(-0.430644006f, 0.902521849f, 0.f),
    C_Vertex3f(0.190979004f, 0.367973328f, 0.f),
    C_Vertex3f(0.190979004f, 0.367973328f, -1.f),
    C_End(),
    C_Begin(GL_QUAD_STRIP),
    C_Normal3f(-0.755975723f, -0.654599667f, 0.f),
    C_Vertex3f(0.190979004f, 0.367973328f, 0.f),
    C_Vertex3f(0.190979004f, 0.367973328f, -1.f),
    C_Normal3f(-0.764071584f, -0.645131409f, 0.f),
    C_Vertex3f(0.185590744f, 0.374196053f, 0.f),
    C_Vertex3f(0.185590744f, 0.374196053f, -1.f),
    C_Normal3f(-0.775041997f, -0.631909788f, 0.f),
    C_Vertex3f(0.175712347f, 0.386054635f, 0.f),
    C_Vertex3f(0.175712347f, 0.386054635f, -1.f),
    C_Normal3f(-0.789611816f, -0.613606632f, 0.f),
    C_Vertex3f(0.166732073f, 0.39732635f, 0.f),
    C_Vertex3f(0.166732073f, 0.39732635f, -1.f),
    C_Normal3f(-0.80593425f, -0.592004955f, 0.f),
    C_Vertex3f(0.158649921f, 0.408011198f, 0.f),
    C_Vertex3f(0.158649921f, 0.408011198f, -1.f),
    C_Normal3f(-0.82426399f, -0.56620574f, 0.f),
    C_Vertex3f(0.151465893f, 0.418109179f, 0.f),
    C_Vertex3f(0.151465893f, 0.418109179f, -1.f),
    C_Normal3f(-0.844861329f, -0.534985423f, 0.f),
    C_Vertex3f(0.145179987f, 0.427620292f, 0.f),
    C_Vertex3f(0.145179987f, 0.427620292f, -1.f),
    C_Normal3f(-0.867947102f, -0.496656537f, 0.f),
    C_Vertex3f(0.139792204f, 0.436544538f, 0.f),
    C_Vertex3f(0.139792204f, 0.436544538f, -1.f),
    C_Normal3f(-0.896297872f, -0.443452388f, 0.f),
    C_Vertex3f(0.135302544f, 0.444881916f, 0.f),
    C_Vertex3f(0.135302544f, 0.444881916f, -1.f),
    C_Normal3f(-0.928080618f, -0.372379243f, 0.f),
    C_Vertex3f(0.129915237f, 0.456507683f, 0.f),
    C_Vertex3f(0.129915237f, 0.456507683f, -1.f),
    C_Normal3f(-0.958486795f, -0.285136849f, 0.f),
    C_Vertex3f(0.124527931f, 0.471735477f, 0.f),
    C_Vertex3f(0.124527931f, 0.471735477f, -1.f),
    C_Normal3f(-0.98387593f, -0.178851992f, 0.f),
    C_Vertex3f(0.120936394f, 0.486690044f, 0.f),
    C_Vertex3f(0.120936394f, 0.486690044f, -1.f),
    C_Normal3f(-0.998100042f, -0.0616133362f, 0.f),
    C_Vertex3f(0.119140625f, 0.501371384f, 0.f),
    C_Vertex3f(0.119140625f, 0.501371384f, -1.f),
    C_Normal3f(-0.99875921f, 0.0497987345f, 0.f),
    C_Vertex3f(0.119140625f, 0.515780449f, 0.f),
    C_Vertex3f(0.119140625f, 0.515780449f, -1.f),
    C_Normal3f(-0.988242269f, 0.152895957f, 0.f),
    C_Vertex3f(0.12055409f, 0.52971971f, 0.f),
    C_Vertex3f(0.12055409f, 0.52971971f, -1.f),
    C_Normal3f(-0.966147184f, 0.257991731f, 0.f),
    C_Vertex3f(0.123381019f, 0.543188214f, 0.f),
    C_Vertex3f(0.123381019f, 0.543188214f, -1.f),
    C_Normal3f(-0.932399392f, 0.361429572f, 0.f),
    C_Vertex3f(0.127621412f, 0.556185961f, 0.f),
    C_Vertex3f(0.127621412f, 0.556185961f, -1.f),
    C_Normal3f(-0.888133287f, 0.459585994f, 0.f),
    C_Vertex3f(0.13327527f, 0.56871295f, 0.f),
    C_Vertex3f(0.13327527f, 0.56871295f, -1.f),
    C_Normal3f(-0.835508585f, 0.549477279f, 0.f),
    C_Vertex3f(0.140342593f, 0.580769181f, 0.f),
    C_Vertex3f(0.140342593f, 0.580769181f, -1.f),
    C_Normal3f(-0.777266681f, 0.629171193f, 0.f),
    C_Vertex3f(0.14882338f, 0.592354655f, 0.f),
    C_Vertex3f(0.14882338f, 0.592354655f, -1.f),
    C_Normal3f(-0.71620971f, 0.697885096f, 0.f),
    C_Vertex3f(0.158717632f, 0.603469372f, 0.f),
    C_Vertex3f(0.158717632f, 0.603469372f, -1.f),
    C_Normal3f(-0.649783075f, 0.760119855f, 0.f),
    C_Vertex3f(0.170025349f, 0.614113331f, 0.f),
    C_Vertex3f(0.170025349f, 0.614113331f, -1.f),
    C_Normal3f(-0.57192564f, 0.820305467f, 0.f),
    C_Vertex3f(0.182063937f, 0.623426795f, 0.f),
    C_Vertex3f(0.182063937f, 0.623426795f, -1.f),
    C_Normal3f(-0.486687332f, 0.873576283f, 0.f),
    C_Vertex3f(0.194833398f, 0.631409764f, 0.f),
    C_Vertex3f(0.194833398f, 0.631409764f, -1.f),
    C_Normal3f(-0.396421283f, 0.918068707f, 0.f),
    C_Vertex3f(0.208333731f, 0.638062239f, 0.f),
    C_Vertex3f(0.208333731f, 0.638062239f, -1.f),
    C_Normal3f(-0.303935289f, 0.952692628f, 0.f),
    C_Vertex3f(0.222564936f, 0.643384218f, 0.f),
    C_Vertex3f(0.222564936f, 0.643384218f, -1.f),
    C_Normal3f(-0.212074637f, 0.977253437f, 0.f),
    C_Vertex3f(0.237527013f, 0.647375703f, 0.f),
    C_Vertex3f(0.237527013f, 0.647375703f, -1.f),
    C_Normal3f(-0.123331577f, 0.992365539f, 0.f),
    C_Vertex3f(0.253219962f, 0.650036693f, 0.f),
    C_Vertex3f(0.253219962f, 0.650036693f, -1.f),
    C_Normal3f(-0.04004886f, 0.999197662f, 0.f),
    C_Vertex3f(0.269643784f, 0.651367188f, 0.f),
    C_Vertex3f(0.269643784f, 0.651367188f, -1.f),
    C_Normal3f(0.0387290753f, 0.999249756f, 0.f),
    C_Vertex3f(0.2864151f, 0.651367188f, 0.f),
    C_Vertex3f(0.2864151f, 0.651367188f, -1.f),
    C_Normal3f(0.122471318f, 0.992472053f, 0.f),
    C_Vertex3f(0.302058816f, 0.650110841f, 0.f),
    C_Vertex3f(0.302058816f, 0.650110841f, -1.f),
    C_Normal3f(0.211320668f, 0.977416754f, 0.f),
    C_Vertex3f(0.316958308f, 0.647598147f, 0.f),
    C_Vertex3f(0.316958308f, 0.647598147f, -1.f),
    C_Normal3f(0.303935647f, 0.952692568f, 0.f),
    C_Vertex3f(0.331113577f, 0.643829107f, 0.f),
    C_Vertex3f(0.331113577f, 0.643829107f, -1.f),
    C_Normal3f(0.397806227f, 0.917469501f, 0.f),
    C_Vertex3f(0.344524622f, 0.63880372f, 0.f),
    C_Vertex3f(0.344524622f, 0.63880372f, -1.f),
    C_Normal3f(0.489945203f, 0.871753275f, 0.f),
    C_Vertex3f(0.357191443f, 0.632521987f, 0.f),
    C_Vertex3f(0.357191443f, 0.632521987f, -1.f),
    C_Normal3f(0.577295005f, 0.816535711f, 0.f),
    C_Vertex3f(0.369114041f, 0.624983907f, 0.f),
    C_Vertex3f(0.369114041f, 0.624983907f, -1.f),
    C_Normal3f(0.657204807f, 0.753712058f, 0.f),
    C_Vertex3f(0.380292416f, 0.61618948f, 0.f),
    C_Vertex3f(0.380292416f, 0.61618948f, -1.f),
    C_Normal3f(0.725219011f, 0.688518226f, 0.f),
    C_Vertex3f(0.390726566f, 0.606138706f, 0.f),
    C_Vertex3f(0.390726566f, 0.606138706f, -1.f),
    C_Normal3f(0.786843419f, 0.61715275f, 0.f),
    C_Vertex3f(0.399856448f, 0.595582604f, 0.f),
    C_Vertex3f(0.399856448f, 0.595582604f, -1.f),
    C_Normal3f(0.844552875f, 0.535472095f, 0.f),
    C_Vertex3f(0.407682061f, 0.584521174f, 0.f),
    C_Vertex3f(0.407682061f, 0.584521174f, -1.f),
    C_Normal3f(0.89565146f, 0.444756627f, 0.f),
    C_Vertex3f(0.414203405f, 0.572954416f, 0.f),
    C_Vertex3f(0.414203405f, 0.572954416f, -1.f),
    C_Normal3f(0.937743306f, 0.347328961f, 0.f),
    C_Vertex3f(0.419420481f, 0.56088233f, 0.f),
    C_Vertex3f(0.419420481f, 0.56088233f, -1.f),
    C_Normal3f(0.969190419f, 0.246312767f, 0.f),
    C_Vertex3f(0.423333287f, 0.548304915f, 0.f),
    C_Vertex3f(0.423333287f, 0.548304915f, -1.f),
    C_Normal3f(0.989409089f, 0.145153672f, 0.f),
    C_Vertex3f(0.425941825f, 0.535222173f, 0.f),
    C_Vertex3f(0.425941825f, 0.535222173f, -1.f),
    C_Normal3f(0.999173045f, 0.0406596325f, 0.f),
    C_Vertex3f(0.427246094f, 0.521634102f, 0.f),
    C_Vertex3f(0.427246094f, 0.521634102f, -1.f),
    C_Normal3f(0.995619297f, -0.0934995413f, 0.f),
    C_Vertex3f(0.427246094f, 0.503170967f, 0.f),
    C_Vertex3f(0.427246094f, 0.503170967f, -1.f),
    C_Normal3f(0.966853142f, -0.255333304f, 0.f),
    C_Vertex3f(0.423446178f, 0.481171131f, 0.f),
    C_Vertex3f(0.423446178f, 0.481171131f, -1.f),
    C_Normal3f(0.909243345f, -0.4162651f, 0.f),
    C_Vertex3f(0.415846348f, 0.46000433f, 0.f),
    C_Vertex3f(0.415846348f, 0.46000433f, -1.f),
    C_Normal3f(0.831635058f, -0.555322647f, 0.f),
    C_Vertex3f(0.404446602f, 0.439670563f, 0.f),
    C_Vertex3f(0.404446602f, 0.439670563f, -1.f),
    C_Normal3f(0.744770467f, -0.667320669f, 0.f),
    C_Vertex3f(0.389246941f, 0.42016983f, 0.f),
    C_Vertex3f(0.389246941f, 0.42016983f, -1.f),
    C_Normal3f(0.65777123f, -0.753217697f, 0.f),
    C_Vertex3f(0.370247364f, 0.401502132f, 0.f),
    C_Vertex3f(0.370247364f, 0.401502132f, -1.f),
    C_Normal3f(0.576313019f, -0.817229033f, 0.f),
    C_Vertex3f(0.347447872f, 0.383667469f, 0.f),
    C_Vertex3f(0.347447872f, 0.383667469f, -1.f),
    C_Normal3f(0.514593601f, -0.857434273f, 0.f),
    C_Vertex3f(0.320848465f, 0.36666584f, 0.f),
    C_Vertex3f(0.320848465f, 0.36666584f, -1.f),
    C_Normal3f(0.469584495f, -0.882887542f, 0.f),
    C_Vertex3f(0.305648804f, 0.358581543f, 0.f),
    C_Vertex3f(0.305648804f, 0.358581543f, -1.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(0.783489406f, 0.621405125f, 0.f),
    C_Vertex3f(0.305648804f, 0.358581543f, 0.f),
    C_Vertex3f(0.305648804f, 0.358581543f, -1.f),
    C_Vertex3f(0.421302795f, 0.212760925f, -1.f),
    C_Vertex3f(0.421302795f, 0.212760925f, 0.f),
    C_End(),
    C_Begin(GL_QUAD_STRIP),
    C_Normal3f(-0.891721725f, 0.452584147f, 0.f),
    C_Vertex3f(0.421302795f, 0.212760925f, 0.f),
    C_Vertex3f(0.421302795f, 0.212760925f, -1.f),
    C_Normal3f(-0.913196743f, 0.407518893f, 0.f),
    C_Vertex3f(0.426181793f, 0.222373962f, 0.f),
    C_Vertex3f(0.426181793f, 0.222373962f, -1.f),
    C_Normal3f(-0.935458302f, 0.353436828f, 0.f),
    C_Vertex3f(0.434855461f, 0.243130684f, 0.f),
    C_Vertex3f(0.434855461f, 0.243130684f, -1.f),
    C_Normal3f(-0.956313372f, 0.292343676f, 0.f),
    C_Vertex3f(0.442444801f, 0.265418053f, 0.f),
    C_Vertex3f(0.442444801f, 0.265418053f, -1.f),
    C_Normal3f(-0.969562948f, 0.244842201f, 0.f),
    C_Vertex3f(0.448949814f, 0.289236069f, 0.f),
    C_Vertex3f(0.448949814f, 0.289236069f, -1.f),
    C_Normal3f(-0.97789067f, 0.209117025f, 0.f),
    C_Vertex3f(0.451660156f, 0.3019104f, 0.f),
    C_Vertex3f(0.451660156f, 0.3019104f, -1.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(0.209591568f, 0.977789044f, 0.f),
    C_Vertex3f(0.451660156f, 0.3019104f, 0.f),
    C_Vertex3f(0.451660156f, 0.3019104f, -1.f),
    C_Vertex3f(0.533203125f, 0.284431458f, -1.f),
    C_Vertex3f(0.533203125f, 0.284431458f, 0.f),
    C_End(),
    C_Begin(GL_QUAD_STRIP),
    C_Normal3f(0.970762491f, -0.24004212f, 0.f),
    C_Vertex3f(0.533203125f, 0.284431458f, 0.f),
    C_Vertex3f(0.533203125f, 0.284431458f, -1.f),
    C_Normal3f(0.965468407f, -0.260519862f, 0.f),
    C_Vertex3f(0.530610085f, 0.273944855f, 0.f),
    C_Vertex3f(0.530610085f, 0.273944855f, -1.f),
    C_Normal3f(0.957811654f, -0.28739658f, 0.f),
    C_Vertex3f(0.524965048f, 0.25390172f, 0.f),
    C_Vertex3f(0.524965048f, 0.25390172f, -1.f),
    C_Normal3f(0.94687885f, -0.321590513f, 0.f),
    C_Vertex3f(0.518861055f, 0.234788656f, 0.f),
    C_Vertex3f(0.518861055f, 0.234788656f, -1.f),
    C_Normal3f(0.933736503f, -0.35796091f, 0.f),
    C_Vertex3f(0.512298107f, 0.216605663f, 0.f),
    C_Vertex3f(0.512298107f, 0.216605663f, -1.f),
    C_Normal3f(0.918021262f, -0.396531314f, 0.f),
    C_Vertex3f(0.505276203f, 0.199352741f, 0.f),
    C_Vertex3f(0.505276203f, 0.199352741f, -1.f),
    C_Normal3f(0.899330497f, -0.437269658f, 0.f),
    C_Vertex3f(0.497795343f, 0.18302989f, 0.f),
    C_Vertex3f(0.497795343f, 0.18302989f, -1.f),
    C_Normal3f(0.877230525f, -0.480069399f, 0.f),
    C_Vertex3f(0.489855528f, 0.16763711f, 0.f),
    C_Vertex3f(0.489855528f, 0.16763711f, -1.f),
    C_Normal3f(0.855884135f, -0.517167747f, 0.f),
    C_Vertex3f(0.481456757f, 0.1531744f, 0.f),
    C_Vertex3f(0.481456757f, 0.1531744f, -1.f),
    C_Normal3f(0.956226945f, 0.292626143f, 0.f),
    C_Vertex3f(0.477027893f, 0.146408081f, 0.f),
    C_Vertex3f(0.477027893f, 0.146408081f, -1.f),
    C_Normal3f(0.770648122f, 0.637260914f, 0.f),
    C_Vertex3f(0.488014221f, 0.131746292f, 0.f),
    C_Vertex3f(0.488014221f, 0.131746292f, -1.f),
    C_Normal3f(0.729652047f, 0.683818638f, 0.f),
    C_Vertex3f(0.511454582f, 0.104775429f, 0.f),
    C_Vertex3f(0.511454582f, 0.104775429f, -1.f),
    C_Normal3f(0.674733937f, 0.738061011f, 0.f),
    C_Vertex3f(0.536362648f, 0.08015728f, 0.f),
    C_Vertex3f(0.536362648f, 0.08015728f, -1.f),
    C_Normal3f(0.624503434f, 0.781022072f, 0.f),
    C_Vertex3f(0.562738419f, 0.0578918457f, 0.f),
    C_Vertex3f(0.562738419f, 0.0578918457f, -1.f),
    C_Normal3f(0.581712425f, 0.813394427f, 0.f),
    C_Vertex3f(0.576660156f, 0.0479354858f, 0.f),
    C_Vertex3f(0.576660156f, 0.0479354858f, -1.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(0.764717758f, -0.64436537f, 0.f),
    C_Vertex3f(0.576660156f, 0.0479354858f, 0.f),
    C_Vertex3f(0.576660156f, 0.0479354858f, -1.f),
    C_Vertex3f(0.523925781f, -0.0146484375f, -1.f),
    C_Vertex3f(0.523925781f, -0.0146484375f, 0.f),
    C_End(),
    C_Begin(GL_QUAD_STRIP),
    C_Normal3f(-0.53726691f, -0.84341228f, 0.f),
    C_Vertex3f(0.523925781f, -0.0146484375f, 0.f),
    C_Vertex3f(0.523925781f, -0.0146484375f, -1.f),
    C_Normal3f(-0.590055466f, -0.807362795f, 0.f),
    C_Vertex3f(0.511960983f, -0.00702667236f, 0.f),
    C_Vertex3f(0.511960983f, -0.00702667236f, -1.f),
    C_Normal3f(-0.645592511f, -0.763682187f, 0.f),
    C_Vertex3f(0.487647057f, 0.0118656158f, 0.f),
    C_Vertex3f(0.487647057f, 0.0118656158f, -1.f),
    C_Normal3f(-0.699530303f, -0.714602947f, 0.f),
    C_Vertex3f(0.462948799f, 0.034406662f, 0.f),
    C_Vertex3f(0.462948799f, 0.034406662f, -1.f),
    C_Normal3f(-0.735969543f, -0.677014768f, 0.f),
    C_Vertex3f(0.437866211f, 0.0605964661f, 0.f),
    C_Vertex3f(0.437866211f, 0.0605964661f, -1.f),
    C_Normal3f(-0.760627747f, -0.64918828f, 0.f),
    C_Vertex3f(0.425132751f, 0.0755157471f, 0.f),
    C_Vertex3f(0.425132751f, 0.0755157471f, -1.f),
    C_End(),
    C_Begin(GL_QUAD_STRIP),
    C_Normal3f(-0.509632707f, 0.860392034f, 0.f),
    C_Vertex3f(0.265274048f, 0.409492493f, 0.f),
    C_Vertex3f(0.265274048f, 0.409492493f, -1.f),
    C_Normal3f(-0.524717748f, 0.851276219f, 0.f),
    C_Vertex3f(0.271636963f, 0.413261414f, 0.f),
    C_Vertex3f(0.271636963f, 0.413261414f, -1.f),
    C_Normal3f(-0.545607924f, 0.838040531f, 0.f),
    C_Vertex3f(0.283241034f, 0.420567155f, 0.f),
    C_Vertex3f(0.283241034f, 0.420567155f, -1.f),
    C_Normal3f(-0.574159384f, 0.818743587f, 0.f),
    C_Vertex3f(0.293723345f, 0.427640796f, 0.f),
    C_Vertex3f(0.293723345f, 0.427640796f, -1.f),
    C_Normal3f(-0.607240975f, 0.794517756f, 0.f),
    C_Vertex3f(0.303083897f, 0.434482336f, 0.f),
    C_Vertex3f(0.303083897f, 0.434482336f, -1.f),
    C_Normal3f(-0.645750642f, 0.763548374f, 0.f),
    C_Vertex3f(0.311322689f, 0.441091776f, 0.f),
    C_Vertex3f(0.311322689f, 0.441091776f, -1.f),
    C_Normal3f(-0.690657079f, 0.723182321f, 0.f),
    C_Vertex3f(0.318439722f, 0.447469115f, 0.f),
    C_Vertex3f(0.318439722f, 0.447469115f, -1.f),
    C_Normal3f(-0.742796302f, 0.669517577f, 0.f),
    C_Vertex3f(0.324434996f, 0.453614354f, 0.f),
    C_Vertex3f(0.324434996f, 0.453614354f, -1.f),
    C_Normal3f(-0.808651209f, 0.588288426f, 0.f),
    C_Vertex3f(0.32930851f, 0.459527493f, 0.f),
    C_Vertex3f(0.32930851f, 0.459527493f, -1.f),
    C_Normal3f(-0.876422584f, 0.481542796f, 0.f),
    C_Vertex3f(0.334936142f, 0.468049049f, 0.f),
    C_Vertex3f(0.334936142f, 0.468049049f, -1.f),
    C_Normal3f(-0.934038818f, 0.357171476f, 0.f),
    C_Vertex3f(0.340563774f, 0.480012417f, 0.f),
    C_Vertex3f(0.340563774f, 0.480012417f, -1.f),
    C_Normal3f(-0.976907492f, 0.213662863f, 0.f),
    C_Vertex3f(0.344315529f, 0.492577076f, 0.f),
    C_Vertex3f(0.344315529f, 0.492577076f, -1.f),
    C_Normal3f(-0.997801602f, 0.0662719086f, 0.f),
    C_Vertex3f(0.346191406f, 0.505743027f, 0.f),
    C_Vertex3f(0.346191406f, 0.505743027f, -1.f),
    C_Normal3f(-0.996314168f, -0.0857784376f, 0.f),
    C_Vertex3f(0.346191406f, 0.520820618f, 0.f),
    C_Vertex3f(0.346191406f, 0.520820618f, -1.f),
    C_Normal3f(-0.964507639f, -0.264054775f, 0.f),
    C_Vertex3f(0.343611717f, 0.535706043f, 0.f),
    C_Vertex3f(0.343611717f, 0.535706043f, -1.f),
    C_Normal3f(-0.890633345f, -0.454722106f, 0.f),
    C_Vertex3f(0.338452339f, 0.549088955f, 0.f),
    C_Vertex3f(0.338452339f, 0.549088955f, -1.f),
    C_Normal3f(-0.776575327f, -0.630024374f, 0.f),
    C_Vertex3f(0.330713272f, 0.560969353f, 0.f),
    C_Vertex3f(0.330713272f, 0.560969353f, -1.f),
    C_Normal3f(-0.638092518f, -0.769959688f, 0.f),
    C_Vertex3f(0.320394516f, 0.571347237f, 0.f),
    C_Vertex3f(0.320394516f, 0.571347237f, -1.f),
    C_Normal3f(-0.468408972f, -0.883511782f, 0.f),
    C_Vertex3f(0.30879879f, 0.57913065f, 0.f),
    C_Vertex3f(0.30879879f, 0.57913065f, -1.f),
    C_Normal3f(-0.276783139f, -0.960932434f, 0.f),
    C_Vertex3f(0.295926094f, 0.584319592f, 0.f),
    C_Vertex3f(0.295926094f, 0.584319592f, -1.f),
    C_Normal3f(-0.0867527723f, -0.996229887f, 0.f),
    C_Vertex3f(0.281776428f, 0.586914063f, 0.f),
    C_Vertex3f(0.281776428f, 0.586914063f, -1.f),
    C_Normal3f(0.0847758874f, -0.996400058f, 0.f),
    C_Vertex3f(0.266132355f, 0.586914063f, 0.f),
    C_Vertex3f(0.266132355f, 0.586914063f, -1.f),
    C_Normal3f(0.267623365f, -0.963523626f, 0.f),
    C_Vertex3f(0.251602173f, 0.584346771f, 0.f),
    C_Vertex3f(0.251602173f, 0.584346771f, -1.f),
    C_Normal3f(0.455807865f, -0.890078247f, 0.f),
    C_Vertex3f(0.23840332f, 0.579212189f, 0.f),
    C_Vertex3f(0.23840332f, 0.579212189f, -1.f),
    C_Normal3f(0.625714958f, -0.780051768f, 0.f),
    C_Vertex3f(0.226535797f, 0.571510315f, 0.f),
    C_Vertex3f(0.226535797f, 0.571510315f, -1.f),
    C_Normal3f(0.761842608f, -0.647762239f, 0.f),
    C_Vertex3f(0.215999603f, 0.56124115f, 0.f),
    C_Vertex3f(0.215999603f, 0.56124115f, -1.f),
    C_Normal3f(0.876506507f, -0.481390119f, 0.f),
    C_Vertex3f(0.208097458f, 0.549824715f, 0.f),
    C_Vertex3f(0.208097458f, 0.549824715f, -1.f),
    C_Normal3f(0.957628071f, -0.288007915f, 0.f),
    C_Vertex3f(0.202829361f, 0.537261009f, 0.f),
    C_Vertex3f(0.202829361f, 0.537261009f, -1.f),
    C_Normal3f(0.99577713f, -0.0918033496f, 0.f),
    C_Vertex3f(0.200195313f, 0.523550034f, 0.f),
    C_Vertex3f(0.200195313f, 0.523550034f, -1.f),
    C_Normal3f(0.992336988f, 0.123560913f, 0.f),
    C_Vertex3f(0.200195313f, 0.50868988f, 0.f),
    C_Vertex3f(0.200195313f, 0.50868988f, -1.f),
    C_Normal3f(0.946780384f, 0.321880102f, 0.f),
    C_Vertex3f(0.203990936f, 0.493066788f, 0.f),
    C_Vertex3f(0.203990936f, 0.493066788f, -1.f),
    C_Normal3f(0.893120766f, 0.449817091f, 0.f),
    C_Vertex3f(0.209684372f, 0.480778694f, 0.f),
    C_Vertex3f(0.209684372f, 0.480778694f, -1.f),
    C_Normal3f(0.853806198f, 0.520590901f, 0.f),
    C_Vertex3f(0.214429855f, 0.472340107f, 0.f),
    C_Vertex3f(0.214429855f, 0.472340107f, -1.f),
    C_Normal3f(0.819039226f, 0.573737621f, 0.f),
    C_Vertex3f(0.220125198f, 0.463654995f, 0.f),
    C_Vertex3f(0.220125198f, 0.463654995f, -1.f),
    C_Normal3f(0.791429281f, 0.611260831f, 0.f),
    C_Vertex3f(0.226770401f, 0.454723358f, 0.f),
    C_Vertex3f(0.226770401f, 0.454723358f, -1.f),
    C_Normal3f(0.760454476f, 0.649391294f, 0.f),
    C_Vertex3f(0.230567932f, 0.450134277f, 0.f),
    C_Vertex3f(0.230567932f, 0.450134277f, -1.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(0.760454476f, 0.649391294f, 0.f),
    C_Vertex3f(0.230567932f, 0.450134277f, 0.f),
    C_Vertex3f(0.230567932f, 0.450134277f, -1.f),
    C_Vertex3f(0.265274048f, 0.409492493f, -1.f),
    C_Vertex3f(0.265274048f, 0.409492493f, 0.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.780421376f, -0.625253975f, 0.f),
    C_Vertex3f(0.37563324f, 0.137496948f, 0.f),
    C_Vertex3f(0.37563324f, 0.137496948f, -1.f),
    C_Vertex3f(0.232032776f, 0.316734314f, -1.f),
    C_Vertex3f(0.232032776f, 0.316734314f, 0.f),
    C_End(),
    C_Begin(GL_QUAD_STRIP),
    C_Normal3f(0.51191318f, -0.85903728f, 0.f),
    C_Vertex3f(0.232032776f, 0.316734314f, 0.f),
    C_Vertex3f(0.232032776f, 0.316734314f, -1.f),
    C_Normal3f(0.528495848f, -0.848935843f, 0.f),
    C_Vertex3f(0.224048615f, 0.311976433f, 0.f),
    C_Vertex3f(0.224048615f, 0.311976433f, -1.f),
    C_Normal3f(0.551100314f, -0.834439039f, 0.f),
    C_Vertex3f(0.209379077f, 0.302631497f, 0.f),
    C_Vertex3f(0.209379077f, 0.302631497f, -1.f),
    C_Normal3f(0.581323326f, -0.813672721f, 0.f),
    C_Vertex3f(0.196008325f, 0.293457389f, 0.f),
    C_Vertex3f(0.196008325f, 0.293457389f, -1.f),
    C_Normal3f(0.615386128f, -0.78822577f, 0.f),
    C_Vertex3f(0.183936357f, 0.284454107f, 0.f),
    C_Vertex3f(0.183936357f, 0.284454107f, -1.f),
    C_Normal3f(0.653781176f, -0.756683648f, 0.f),
    C_Vertex3f(0.173163176f, 0.275621653f, 0.f),
    C_Vertex3f(0.173163176f, 0.275621653f, -1.f),
    C_Normal3f(0.696925879f, -0.717143238f, 0.f),
    C_Vertex3f(0.163688779f, 0.266960025f, 0.f),
    C_Vertex3f(0.163688779f, 0.266960025f, -1.f),
    C_Normal3f(0.744994223f, -0.667070925f, 0.f),
    C_Vertex3f(0.155513167f, 0.258469224f, 0.f),
    C_Vertex3f(0.155513167f, 0.258469224f, -1.f),
    C_Normal3f(0.803064525f, -0.595892131f, 0.f),
    C_Vertex3f(0.148636341f, 0.25014925f, 0.f),
    C_Vertex3f(0.148636341f, 0.25014925f, -1.f),
    C_Normal3f(0.861868143f, -0.50713253f, 0.f),
    C_Vertex3f(0.140269279f, 0.237925529f, 0.f),
    C_Vertex3f(0.140269279f, 0.237925529f, -1.f),
    C_Normal3f(0.918308377f, -0.395865768f, 0.f),
    C_Vertex3f(0.131902218f, 0.221709728f, 0.f),
    C_Vertex3f(0.131902218f, 0.221709728f, -1.f),
    C_Normal3f(0.967828393f, -0.251611024f, 0.f),
    C_Vertex3f(0.126324177f, 0.20557642f, 0.f),
    C_Vertex3f(0.126324177f, 0.20557642f, -1.f),
    C_Normal3f(0.996606946f, -0.08230827f, 0.f),
    C_Vertex3f(0.123535156f, 0.189525604f, 0.f),
    C_Vertex3f(0.123535156f, 0.189525604f, -1.f),
    C_Normal3f(0.994734704f, 0.102484375f, 0.f),
    C_Vertex3f(0.123535156f, 0.171806335f, 0.f),
    C_Vertex3f(0.123535156f, 0.171806335f, -1.f),
    C_Normal3f(0.960512042f, 0.278238088f, 0.f),
    C_Vertex3f(0.12740612f, 0.15195322f, 0.f),
    C_Vertex3f(0.12740612f, 0.15195322f, -1.f),
    C_Normal3f(0.903716564f, 0.428131223f, 0.f),
    C_Vertex3f(0.135148048f, 0.131717205f, 0.f),
    C_Vertex3f(0.135148048f, 0.131717205f, -1.f),
    C_Normal3f(0.842809618f, 0.538211882f, 0.f),
    C_Vertex3f(0.146760941f, 0.111098289f, 0.f),
    C_Vertex3f(0.146760941f, 0.111098289f, -1.f),
    C_Normal3f(0.777705848f, 0.628628433f, 0.f),
    C_Vertex3f(0.158373833f, 0.0953469276f, 0.f),
    C_Vertex3f(0.158373833f, 0.0953469276f, -1.f),
    C_Normal3f(0.690074325f, 0.723738432f, 0.f),
    C_Vertex3f(0.166919947f, 0.0861586332f, 0.f),
    C_Vertex3f(0.166919947f, 0.0861586332f, -1.f),
    C_Normal3f(0.59498167f, 0.803739309f, 0.f),
    C_Vertex3f(0.176270247f, 0.0782829523f, 0.f),
    C_Vertex3f(0.176270247f, 0.0782829523f, -1.f),
    C_Normal3f(0.488293499f, 0.872679472f, 0.f),
    C_Vertex3f(0.186424732f, 0.0717198849f, 0.f),
    C_Vertex3f(0.186424732f, 0.0717198849f, -1.f),
    C_Normal3f(0.374894232f, 0.927067578f, 0.f),
    C_Vertex3f(0.197383404f, 0.0664694309f, 0.f),
    C_Vertex3f(0.197383404f, 0.0664694309f, -1.f),
    C_Normal3f(0.260443687f, 0.96548897f, 0.f),
    C_Vertex3f(0.209146261f, 0.0625315905f, 0.f),
    C_Vertex3f(0.209146261f, 0.0625315905f, -1.f),
    C_Normal3f(0.150095984f, 0.988671422f, 0.f),
    C_Vertex3f(0.221713305f, 0.0599063635f, 0.f),
    C_Vertex3f(0.221713305f, 0.0599063635f, -1.f),
    C_Normal3f(0.0447695181f, 0.998997331f, 0.f),
    C_Vertex3f(0.235084534f, 0.05859375f, 0.f),
    C_Vertex3f(0.235084534f, 0.05859375f, -1.f),
    C_Normal3f(-0.0809533373f, 0.99671787f, 0.f),
    C_Vertex3f(0.251003265f, 0.05859375f, 0.f),
    C_Vertex3f(0.251003265f, 0.05859375f, -1.f),
    C_Normal3f(-0.222195745f, 0.97500205f, 0.f),
    C_Vertex3f(0.268965721f, 0.0613455772f, 0.f),
    C_Vertex3f(0.268965721f, 0.0613455772f, -1.f),
    C_Normal3f(-0.349993318f, 0.9367522f, 0.f),
    C_Vertex3f(0.287228584f, 0.0668492317f, 0.f),
    C_Vertex3f(0.287228584f, 0.0668492317f, -1.f),
    C_Normal3f(-0.457623184f, 0.889146328f, 0.f),
    C_Vertex3f(0.305791855f, 0.0751047134f, 0.f),
    C_Vertex3f(0.305791855f, 0.0751047134f, -1.f),
    C_Normal3f(-0.550245106f, 0.835003257f, 0.f),
    C_Vertex3f(0.324655533f, 0.0861120224f, 0.f),
    C_Vertex3f(0.324655533f, 0.0861120224f, -1.f),
    C_Normal3f(-0.641580462f, 0.76705575f, 0.f),
    C_Vertex3f(0.341638565f, 0.0987267494f, 0.f),
    C_Vertex3f(0.341638565f, 0.0987267494f, -1.f),
    C_Normal3f(-0.72771436f, 0.685880303f, 0.f),
    C_Vertex3f(0.356740952f, 0.112948895f, 0.f),
    C_Vertex3f(0.356740952f, 0.112948895f, -1.f),
    C_Normal3f(-0.792480886f, 0.609896719f, 0.f),
    C_Vertex3f(0.369962692f, 0.128778458f, 0.f),
    C_Vertex3f(0.369962692f, 0.128778458f, -1.f),
    C_Normal3f(-0.838288546f, 0.545226812f, 0.f),
    C_Vertex3f(0.37563324f, 0.137496948f, 0.f),
    C_Vertex3f(0.37563324f, 0.137496948f, -1.f),
    C_End(),
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.151465893f, 0.418109179f, 0.f),
    C_Vertex3f(0.158649921f, 0.408011198f, 0.f),
    C_Vertex3f(0.158717632f, 0.603469372f, 0.f),
    C_Vertex3f(0.166732073f, 0.39732635f, 0.f),
    C_Vertex3f(0.170025349f, 0.614113331f, 0.f),
    C_Vertex3f(0.175712347f, 0.386054635f, 0.f),
    C_Vertex3f(0.182063937f, 0.623426795f, 0.f),
    C_Vertex3f(0.185590744f, 0.374196053f, 0.f),
    C_Vertex3f(0.194833398f, 0.631409764f, 0.f),
    C_Vertex3f(0.190979004f, 0.367973328f, 0.f),
    C_Vertex3f(0.196008325f, 0.293457389f, 0.f),
    C_Vertex3f(0.183936357f, 0.284454107f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.135302544f, 0.444881916f, 0.f),
    C_Vertex3f(0.139792204f, 0.436544538f, 0.f),
    C_Vertex3f(0.140342593f, 0.580769181f, 0.f),
    C_Vertex3f(0.145179987f, 0.427620292f, 0.f),
    C_Vertex3f(0.14882338f, 0.592354655f, 0.f),
    C_Vertex3f(0.151465893f, 0.418109179f, 0.f),
    C_Vertex3f(0.158717632f, 0.603469372f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.12055409f, 0.52971971f, 0.f),
    C_Vertex3f(0.120936394f, 0.486690044f, 0.f),
    C_Vertex3f(0.123381019f, 0.543188214f, 0.f),
    C_Vertex3f(0.124527931f, 0.471735477f, 0.f),
    C_Vertex3f(0.127621412f, 0.556185961f, 0.f),
    C_Vertex3f(0.129915237f, 0.456507683f, 0.f),
    C_Vertex3f(0.13327527f, 0.56871295f, 0.f),
    C_Vertex3f(0.135302544f, 0.444881916f, 0.f),
    C_Vertex3f(0.140342593f, 0.580769181f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.119140625f, 0.515780449f, 0.f),
    C_Vertex3f(0.119140625f, 0.501371384f, 0.f),
    C_Vertex3f(0.120936394f, 0.486690044f, 0.f),
    C_Vertex3f(0.12055409f, 0.52971971f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.533203125f, 0.284431458f, 0.f),
    C_Vertex3f(0.451660156f, 0.3019104f, 0.f),
    C_Vertex3f(0.477027893f, 0.146408081f, 0.f),
    C_Vertex3f(0.481456757f, 0.1531744f, 0.f),
    C_Vertex3f(0.489855528f, 0.16763711f, 0.f),
    C_Vertex3f(0.497795343f, 0.18302989f, 0.f),
    C_Vertex3f(0.505276203f, 0.199352741f, 0.f),
    C_Vertex3f(0.512298107f, 0.216605663f, 0.f),
    C_Vertex3f(0.518861055f, 0.234788656f, 0.f),
    C_Vertex3f(0.524965048f, 0.25390172f, 0.f),
    C_Vertex3f(0.530610085f, 0.273944855f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.536362648f, 0.08015728f, 0.f),
    C_Vertex3f(0.511454582f, 0.104775429f, 0.f),
    C_Vertex3f(0.511960983f, -0.00702667236f, 0.f),
    C_Vertex3f(0.488014221f, 0.131746292f, 0.f),
    C_Vertex3f(0.487647057f, 0.0118656158f, 0.f),
    C_Vertex3f(0.477027893f, 0.146408081f, 0.f),
    C_Vertex3f(0.462948799f, 0.034406662f, 0.f),
    C_Vertex3f(0.451660156f, 0.3019104f, 0.f),
    C_Vertex3f(0.448949814f, 0.289236069f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.442444801f, 0.265418053f, 0.f),
    C_Vertex3f(0.434855461f, 0.243130684f, 0.f),
    C_Vertex3f(0.437866211f, 0.0605964661f, 0.f),
    C_Vertex3f(0.462948799f, 0.034406662f, 0.f),
    C_Vertex3f(0.448949814f, 0.289236069f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.395104885f, 0.0458645821f, 0.f),
    C_Vertex3f(0.41541481f, 0.0647335052f, 0.f),
    C_Vertex3f(0.421302795f, 0.212760925f, 0.f),
    C_Vertex3f(0.425132751f, 0.0755157471f, 0.f),
    C_Vertex3f(0.426181793f, 0.222373962f, 0.f),
    C_Vertex3f(0.437866211f, 0.0605964661f, 0.f),
    C_Vertex3f(0.434855461f, 0.243130684f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.37563324f, 0.137496948f, 0.f),
    C_Vertex3f(0.369962692f, 0.128778458f, 0.f),
    C_Vertex3f(0.373920918f, 0.0296912193f, 0.f),
    C_Vertex3f(0.395104885f, 0.0458645821f, 0.f),
    C_Vertex3f(0.421302795f, 0.212760925f, 0.f),
    C_Vertex3f(0.305648804f, 0.358581543f, 0.f),
    C_Vertex3f(0.283241034f, 0.420567155f, 0.f),
    C_Vertex3f(0.271636963f, 0.413261414f, 0.f),
    C_Vertex3f(0.265274048f, 0.409492493f, 0.f),
    C_Vertex3f(0.232032776f, 0.316734314f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.324434996f, 0.453614354f, 0.f),
    C_Vertex3f(0.318439722f, 0.447469115f, 0.f),
    C_Vertex3f(0.320848465f, 0.36666584f, 0.f),
    C_Vertex3f(0.311322689f, 0.441091776f, 0.f),
    C_Vertex3f(0.305648804f, 0.358581543f, 0.f),
    C_Vertex3f(0.303083897f, 0.434482336f, 0.f),
    C_Vertex3f(0.293723345f, 0.427640796f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.265274048f, 0.409492493f, 0.f),
    C_Vertex3f(0.230567932f, 0.450134277f, 0.f),
    C_Vertex3f(0.232032776f, 0.316734314f, 0.f),
    C_Vertex3f(0.226770401f, 0.454723358f, 0.f),
    C_Vertex3f(0.224048615f, 0.311976433f, 0.f),
    C_Vertex3f(0.220125198f, 0.463654995f, 0.f),
    C_Vertex3f(0.214429855f, 0.472340107f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.209684372f, 0.480778694f, 0.f),
    C_Vertex3f(0.203990936f, 0.493066788f, 0.f),
    C_Vertex3f(0.209379077f, 0.302631497f, 0.f),
    C_Vertex3f(0.224048615f, 0.311976433f, 0.f),
    C_Vertex3f(0.214429855f, 0.472340107f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.208333731f, 0.638062239f, 0.f),
    C_Vertex3f(0.194833398f, 0.631409764f, 0.f),
    C_Vertex3f(0.200195313f, 0.523550034f, 0.f),
    C_Vertex3f(0.196008325f, 0.293457389f, 0.f),
    C_Vertex3f(0.200195313f, 0.50868988f, 0.f),
    C_Vertex3f(0.209379077f, 0.302631497f, 0.f),
    C_Vertex3f(0.203990936f, 0.493066788f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.523925781f, -0.0146484375f, 0.f),
    C_Vertex3f(0.576660156f, 0.0479354858f, 0.f),
    C_Vertex3f(0.562738419f, 0.0578918457f, 0.f),
    C_Vertex3f(0.536362648f, 0.08015728f, 0.f),
    C_Vertex3f(0.511960983f, -0.00702667236f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.324655533f, 0.0861120224f, 0.f),
    C_Vertex3f(0.328930855f, 0.00543117523f, 0.f),
    C_Vertex3f(0.341638565f, 0.0987267494f, 0.f),
    C_Vertex3f(0.351862907f, 0.0162134171f, 0.f),
    C_Vertex3f(0.356740952f, 0.112948895f, 0.f),
    C_Vertex3f(0.373920918f, 0.0296912193f, 0.f),
    C_Vertex3f(0.369962692f, 0.128778458f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.251003265f, 0.05859375f, 0.f),
    C_Vertex3f(0.254564285f, -0.0107421875f, 0.f),
    C_Vertex3f(0.268965721f, 0.0613455772f, 0.f),
    C_Vertex3f(0.280281544f, -0.00804662704f, 0.f),
    C_Vertex3f(0.287228584f, 0.0668492317f, 0.f),
    C_Vertex3f(0.3050704f, -0.00265550613f, 0.f),
    C_Vertex3f(0.305791855f, 0.0751047134f, 0.f),
    C_Vertex3f(0.328930855f, 0.00543117523f, 0.f),
    C_Vertex3f(0.324655533f, 0.0861120224f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.235084534f, 0.05859375f, 0.f),
    C_Vertex3f(0.221713305f, 0.0599063635f, 0.f),
    C_Vertex3f(0.228957176f, -0.0107421875f, 0.f),
    C_Vertex3f(0.254564285f, -0.0107421875f, 0.f),
    C_Vertex3f(0.251003265f, 0.05859375f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.209146261f, 0.0625315905f, 0.f),
    C_Vertex3f(0.197383404f, 0.0664694309f, 0.f),
    C_Vertex3f(0.205657959f, -0.00866723061f, 0.f),
    C_Vertex3f(0.228957176f, -0.0107421875f, 0.f),
    C_Vertex3f(0.221713305f, 0.0599063635f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.186424732f, 0.0717198849f, 0.f),
    C_Vertex3f(0.176270247f, 0.0782829523f, 0.f),
    C_Vertex3f(0.183628082f, -0.00451731682f, 0.f),
    C_Vertex3f(0.205657959f, -0.00866723061f, 0.f),
    C_Vertex3f(0.197383404f, 0.0664694309f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.166919947f, 0.0861586332f, 0.f),
    C_Vertex3f(0.158373833f, 0.0953469276f, 0.f),
    C_Vertex3f(0.162867546f, 0.00170755386f, 0.f),
    C_Vertex3f(0.183628082f, -0.00451731682f, 0.f),
    C_Vertex3f(0.176270247f, 0.0782829523f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.146760941f, 0.111098289f, 0.f),
    C_Vertex3f(0.135148048f, 0.131717205f, 0.f),
    C_Vertex3f(0.14337635f, 0.0100073814f, 0.f),
    C_Vertex3f(0.162867546f, 0.00170755386f, 0.f),
    C_Vertex3f(0.158373833f, 0.0953469276f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.126324177f, 0.20557642f, 0.f),
    C_Vertex3f(0.131577253f, 0.334079504f, 0.f),
    C_Vertex3f(0.123535156f, 0.189525604f, 0.f),
    C_Vertex3f(0.117303133f, 0.323568583f, 0.f),
    C_Vertex3f(0.123535156f, 0.171806335f, 0.f),
    C_Vertex3f(0.125154495f, 0.0203821659f, 0.f),
    C_Vertex3f(0.12740612f, 0.15195322f, 0.f),
    C_Vertex3f(0.14337635f, 0.0100073814f, 0.f),
    C_Vertex3f(0.135148048f, 0.131717205f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.125154495f, 0.0203821659f, 0.f),
    C_Vertex3f(0.117303133f, 0.323568583f, 0.f),
    C_Vertex3f(0.108201981f, 0.0328319073f, 0.f),
    C_Vertex3f(0.104209304f, 0.312695861f, 0.f),
    C_Vertex3f(0.0925188065f, 0.0473566055f, 0.f),
    C_Vertex3f(0.0922957659f, 0.301461339f, 0.f),
    C_Vertex3f(0.0815625191f, 0.289865017f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.0925188065f, 0.0473566055f, 0.f),
    C_Vertex3f(0.0815625191f, 0.289865017f, 0.f),
    C_Vertex3f(0.0794696808f, 0.0624265671f, 0.f),
    C_Vertex3f(0.0720095634f, 0.277906895f, 0.f),
    C_Vertex3f(0.0692458153f, 0.0763628483f, 0.f),
    C_Vertex3f(0.0636507273f, 0.265587211f, 0.f),
    C_Vertex3f(0.060482502f, 0.0906951427f, 0.f),
    C_Vertex3f(0.0564860106f, 0.252905965f, 0.f),
    C_Vertex3f(0.0531797409f, 0.10542345f, 0.f),
    C_Vertex3f(0.0505154133f, 0.239863157f, 0.f),
    C_Vertex3f(0.047337532f, 0.120547771f, 0.f),
    C_Vertex3f(0.0457389355f, 0.226458788f, 0.f),
    C_Vertex3f(0.0429558754f, 0.136068106f, 0.f),
    C_Vertex3f(0.0421565771f, 0.212692857f, 0.f),
    C_Vertex3f(0.040034771f, 0.151984453f, 0.f),
    C_Vertex3f(0.0397683382f, 0.198565364f, 0.f),
    C_Vertex3f(0.0385742188f, 0.184076309f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.425941825f, 0.535222173f, 0.f),
    C_Vertex3f(0.423333287f, 0.548304915f, 0.f),
    C_Vertex3f(0.423446178f, 0.481171131f, 0.f),
    C_Vertex3f(0.427246094f, 0.503170967f, 0.f),
    C_Vertex3f(0.427246094f, 0.521634102f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.419420481f, 0.56088233f, 0.f),
    C_Vertex3f(0.414203405f, 0.572954416f, 0.f),
    C_Vertex3f(0.415846348f, 0.46000433f, 0.f),
    C_Vertex3f(0.423446178f, 0.481171131f, 0.f),
    C_Vertex3f(0.423333287f, 0.548304915f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.407682061f, 0.584521174f, 0.f),
    C_Vertex3f(0.399856448f, 0.595582604f, 0.f),
    C_Vertex3f(0.404446602f, 0.439670563f, 0.f),
    C_Vertex3f(0.415846348f, 0.46000433f, 0.f),
    C_Vertex3f(0.414203405f, 0.572954416f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.369114041f, 0.624983907f, 0.f),
    C_Vertex3f(0.370247364f, 0.401502132f, 0.f),
    C_Vertex3f(0.380292416f, 0.61618948f, 0.f),
    C_Vertex3f(0.389246941f, 0.42016983f, 0.f),
    C_Vertex3f(0.390726566f, 0.606138706f, 0.f),
    C_Vertex3f(0.404446602f, 0.439670563f, 0.f),
    C_Vertex3f(0.399856448f, 0.595582604f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.357191443f, 0.632521987f, 0.f),
    C_Vertex3f(0.344524622f, 0.63880372f, 0.f),
    C_Vertex3f(0.346191406f, 0.520820618f, 0.f),
    C_Vertex3f(0.347447872f, 0.383667469f, 0.f),
    C_Vertex3f(0.370247364f, 0.401502132f, 0.f),
    C_Vertex3f(0.369114041f, 0.624983907f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.320394516f, 0.571347237f, 0.f),
    C_Vertex3f(0.330713272f, 0.560969353f, 0.f),
    C_Vertex3f(0.331113577f, 0.643829107f, 0.f),
    C_Vertex3f(0.338452339f, 0.549088955f, 0.f),
    C_Vertex3f(0.344524622f, 0.63880372f, 0.f),
    C_Vertex3f(0.343611717f, 0.535706043f, 0.f),
    C_Vertex3f(0.346191406f, 0.520820618f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.23840332f, 0.579212189f, 0.f),
    C_Vertex3f(0.251602173f, 0.584346771f, 0.f),
    C_Vertex3f(0.253219962f, 0.650036693f, 0.f),
    C_Vertex3f(0.266132355f, 0.586914063f, 0.f),
    C_Vertex3f(0.269643784f, 0.651367188f, 0.f),
    C_Vertex3f(0.281776428f, 0.586914063f, 0.f),
    C_Vertex3f(0.2864151f, 0.651367188f, 0.f),
    C_Vertex3f(0.295926094f, 0.584319592f, 0.f),
    C_Vertex3f(0.302058816f, 0.650110841f, 0.f),
    C_Vertex3f(0.30879879f, 0.57913065f, 0.f),
    C_Vertex3f(0.316958308f, 0.647598147f, 0.f),
    C_Vertex3f(0.320394516f, 0.571347237f, 0.f),
    C_Vertex3f(0.331113577f, 0.643829107f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.202829361f, 0.537261009f, 0.f),
    C_Vertex3f(0.208097458f, 0.549824715f, 0.f),
    C_Vertex3f(0.208333731f, 0.638062239f, 0.f),
    C_Vertex3f(0.215999603f, 0.56124115f, 0.f),
    C_Vertex3f(0.222564936f, 0.643384218f, 0.f),
    C_Vertex3f(0.226535797f, 0.571510315f, 0.f),
    C_Vertex3f(0.237527013f, 0.647375703f, 0.f),
    C_Vertex3f(0.23840332f, 0.579212189f, 0.f),
    C_Vertex3f(0.253219962f, 0.650036693f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.181481361f, 0.363441467f, 0.f),
    C_Vertex3f(0.163666368f, 0.354015946f, 0.f),
    C_Vertex3f(0.163688779f, 0.266960025f, 0.f),
    C_Vertex3f(0.173163176f, 0.275621653f, 0.f),
    C_Vertex3f(0.183936357f, 0.284454107f, 0.f),
    C_Vertex3f(0.190979004f, 0.367973328f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.131902218f, 0.221709728f, 0.f),
    C_Vertex3f(0.140269279f, 0.237925529f, 0.f),
    C_Vertex3f(0.147031665f, 0.344228625f, 0.f),
    C_Vertex3f(0.148636341f, 0.25014925f, 0.f),
    C_Vertex3f(0.163666368f, 0.354015946f, 0.f),
    C_Vertex3f(0.155513167f, 0.258469224f, 0.f),
    C_Vertex3f(0.163688779f, 0.266960025f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.131577253f, 0.334079504f, 0.f),
    C_Vertex3f(0.126324177f, 0.20557642f, 0.f),
    C_Vertex3f(0.131902218f, 0.221709728f, 0.f),
    C_Vertex3f(0.147031665f, 0.344228625f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.347447872f, 0.383667469f, 0.f),
    C_Vertex3f(0.346191406f, 0.520820618f, 0.f),
    C_Vertex3f(0.346191406f, 0.505743027f, 0.f),
    C_Vertex3f(0.344315529f, 0.492577076f, 0.f),
    C_Vertex3f(0.340563774f, 0.480012417f, 0.f),
    C_Vertex3f(0.334936142f, 0.468049049f, 0.f),
    C_Vertex3f(0.32930851f, 0.459527493f, 0.f),
    C_Vertex3f(0.324434996f, 0.453614354f, 0.f),
    C_Vertex3f(0.320848465f, 0.36666584f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.208333731f, 0.638062239f, 0.f),
    C_Vertex3f(0.200195313f, 0.523550034f, 0.f),
    C_Vertex3f(0.202829361f, 0.537261009f, 0.f),
    C_Vertex3f(0.040034771f, 0.151984453f, 0.f),
    C_Vertex3f(0.0385742188f, 0.184076309f, 0.f),
    C_Vertex3f(0.0385742188f, 0.168296814f, 0.f),
    C_Vertex3f(0.283241034f, 0.420567155f, 0.f),
    C_Vertex3f(0.305648804f, 0.358581543f, 0.f),
    C_Vertex3f(0.293723345f, 0.427640796f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, -1.f),
    C_FrontFace(GL_CW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.151465893f, 0.418109179f, -1.f),
    C_Vertex3f(0.158649921f, 0.408011198f, -1.f),
    C_Vertex3f(0.158717632f, 0.603469372f, -1.f),
    C_Vertex3f(0.166732073f, 0.39732635f, -1.f),
    C_Vertex3f(0.170025349f, 0.614113331f, -1.f),
    C_Vertex3f(0.175712347f, 0.386054635f, -1.f),
    C_Vertex3f(0.182063937f, 0.623426795f, -1.f),
    C_Vertex3f(0.185590744f, 0.374196053f, -1.f),
    C_Vertex3f(0.194833398f, 0.631409764f, -1.f),
    C_Vertex3f(0.190979004f, 0.367973328f, -1.f),
    C_Vertex3f(0.196008325f, 0.293457389f, -1.f),
    C_Vertex3f(0.183936357f, 0.284454107f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.135302544f, 0.444881916f, -1.f),
    C_Vertex3f(0.139792204f, 0.436544538f, -1.f),
    C_Vertex3f(0.140342593f, 0.580769181f, -1.f),
    C_Vertex3f(0.145179987f, 0.427620292f, -1.f),
    C_Vertex3f(0.14882338f, 0.592354655f, -1.f),
    C_Vertex3f(0.151465893f, 0.418109179f, -1.f),
    C_Vertex3f(0.158717632f, 0.603469372f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.12055409f, 0.52971971f, -1.f),
    C_Vertex3f(0.120936394f, 0.486690044f, -1.f),
    C_Vertex3f(0.123381019f, 0.543188214f, -1.f),
    C_Vertex3f(0.124527931f, 0.471735477f, -1.f),
    C_Vertex3f(0.127621412f, 0.556185961f, -1.f),
    C_Vertex3f(0.129915237f, 0.456507683f, -1.f),
    C_Vertex3f(0.13327527f, 0.56871295f, -1.f),
    C_Vertex3f(0.135302544f, 0.444881916f, -1.f),
    C_Vertex3f(0.140342593f, 0.580769181f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.119140625f, 0.515780449f, -1.f),
    C_Vertex3f(0.119140625f, 0.501371384f, -1.f),
    C_Vertex3f(0.120936394f, 0.486690044f, -1.f),
    C_Vertex3f(0.12055409f, 0.52971971f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.533203125f, 0.284431458f, -1.f),
    C_Vertex3f(0.451660156f, 0.3019104f, -1.f),
    C_Vertex3f(0.477027893f, 0.146408081f, -1.f),
    C_Vertex3f(0.481456757f, 0.1531744f, -1.f),
    C_Vertex3f(0.489855528f, 0.16763711f, -1.f),
    C_Vertex3f(0.497795343f, 0.18302989f, -1.f),
    C_Vertex3f(0.505276203f, 0.199352741f, -1.f),
    C_Vertex3f(0.512298107f, 0.216605663f, -1.f),
    C_Vertex3f(0.518861055f, 0.234788656f, -1.f),
    C_Vertex3f(0.524965048f, 0.25390172f, -1.f),
    C_Vertex3f(0.530610085f, 0.273944855f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.536362648f, 0.08015728f, -1.f),
    C_Vertex3f(0.511454582f, 0.104775429f, -1.f),
    C_Vertex3f(0.511960983f, -0.00702667236f, -1.f),
    C_Vertex3f(0.488014221f, 0.131746292f, -1.f),
    C_Vertex3f(0.487647057f, 0.0118656158f, -1.f),
    C_Vertex3f(0.477027893f, 0.146408081f, -1.f),
    C_Vertex3f(0.462948799f, 0.034406662f, -1.f),
    C_Vertex3f(0.451660156f, 0.3019104f, -1.f),
    C_Vertex3f(0.448949814f, 0.289236069f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.442444801f, 0.265418053f, -1.f),
    C_Vertex3f(0.434855461f, 0.243130684f, -1.f),
    C_Vertex3f(0.437866211f, 0.0605964661f, -1.f),
    C_Vertex3f(0.462948799f, 0.034406662f, -1.f),
    C_Vertex3f(0.448949814f, 0.289236069f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.395104885f, 0.0458645821f, -1.f),
    C_Vertex3f(0.41541481f, 0.0647335052f, -1.f),
    C_Vertex3f(0.421302795f, 0.212760925f, -1.f),
    C_Vertex3f(0.425132751f, 0.0755157471f, -1.f),
    C_Vertex3f(0.426181793f, 0.222373962f, -1.f),
    C_Vertex3f(0.437866211f, 0.0605964661f, -1.f),
    C_Vertex3f(0.434855461f, 0.243130684f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.37563324f, 0.137496948f, -1.f),
    C_Vertex3f(0.369962692f, 0.128778458f, -1.f),
    C_Vertex3f(0.373920918f, 0.0296912193f, -1.f),
    C_Vertex3f(0.395104885f, 0.0458645821f, -1.f),
    C_Vertex3f(0.421302795f, 0.212760925f, -1.f),
    C_Vertex3f(0.305648804f, 0.358581543f, -1.f),
    C_Vertex3f(0.283241034f, 0.420567155f, -1.f),
    C_Vertex3f(0.271636963f, 0.413261414f, -1.f),
    C_Vertex3f(0.265274048f, 0.409492493f, -1.f),
    C_Vertex3f(0.232032776f, 0.316734314f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.324434996f, 0.453614354f, -1.f),
    C_Vertex3f(0.318439722f, 0.447469115f, -1.f),
    C_Vertex3f(0.320848465f, 0.36666584f, -1.f),
    C_Vertex3f(0.311322689f, 0.441091776f, -1.f),
    C_Vertex3f(0.305648804f, 0.358581543f, -1.f),
    C_Vertex3f(0.303083897f, 0.434482336f, -1.f),
    C_Vertex3f(0.293723345f, 0.427640796f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.265274048f, 0.409492493f, -1.f),
    C_Vertex3f(0.230567932f, 0.450134277f, -1.f),
    C_Vertex3f(0.232032776f, 0.316734314f, -1.f),
    C_Vertex3f(0.226770401f, 0.454723358f, -1.f),
    C_Vertex3f(0.224048615f, 0.311976433f, -1.f),
    C_Vertex3f(0.220125198f, 0.463654995f, -1.f),
    C_Vertex3f(0.214429855f, 0.472340107f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.209684372f, 0.480778694f, -1.f),
    C_Vertex3f(0.203990936f, 0.493066788f, -1.f),
    C_Vertex3f(0.209379077f, 0.302631497f, -1.f),
    C_Vertex3f(0.224048615f, 0.311976433f, -1.f),
    C_Vertex3f(0.214429855f, 0.472340107f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.208333731f, 0.638062239f, -1.f),
    C_Vertex3f(0.194833398f, 0.631409764f, -1.f),
    C_Vertex3f(0.200195313f, 0.523550034f, -1.f),
    C_Vertex3f(0.196008325f, 0.293457389f, -1.f),
    C_Vertex3f(0.200195313f, 0.50868988f, -1.f),
    C_Vertex3f(0.209379077f, 0.302631497f, -1.f),
    C_Vertex3f(0.203990936f, 0.493066788f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.523925781f, -0.0146484375f, -1.f),
    C_Vertex3f(0.576660156f, 0.0479354858f, -1.f),
    C_Vertex3f(0.562738419f, 0.0578918457f, -1.f),
    C_Vertex3f(0.536362648f, 0.08015728f, -1.f),
    C_Vertex3f(0.511960983f, -0.00702667236f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.324655533f, 0.0861120224f, -1.f),
    C_Vertex3f(0.328930855f, 0.00543117523f, -1.f),
    C_Vertex3f(0.341638565f, 0.0987267494f, -1.f),
    C_Vertex3f(0.351862907f, 0.0162134171f, -1.f),
    C_Vertex3f(0.356740952f, 0.112948895f, -1.f),
    C_Vertex3f(0.373920918f, 0.0296912193f, -1.f),
    C_Vertex3f(0.369962692f, 0.128778458f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.251003265f, 0.05859375f, -1.f),
    C_Vertex3f(0.254564285f, -0.0107421875f, -1.f),
    C_Vertex3f(0.268965721f, 0.0613455772f, -1.f),
    C_Vertex3f(0.280281544f, -0.00804662704f, -1.f),
    C_Vertex3f(0.287228584f, 0.0668492317f, -1.f),
    C_Vertex3f(0.3050704f, -0.00265550613f, -1.f),
    C_Vertex3f(0.305791855f, 0.0751047134f, -1.f),
    C_Vertex3f(0.328930855f, 0.00543117523f, -1.f),
    C_Vertex3f(0.324655533f, 0.0861120224f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.235084534f, 0.05859375f, -1.f),
    C_Vertex3f(0.221713305f, 0.0599063635f, -1.f),
    C_Vertex3f(0.228957176f, -0.0107421875f, -1.f),
    C_Vertex3f(0.254564285f, -0.0107421875f, -1.f),
    C_Vertex3f(0.251003265f, 0.05859375f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.209146261f, 0.0625315905f, -1.f),
    C_Vertex3f(0.197383404f, 0.0664694309f, -1.f),
    C_Vertex3f(0.205657959f, -0.00866723061f, -1.f),
    C_Vertex3f(0.228957176f, -0.0107421875f, -1.f),
    C_Vertex3f(0.221713305f, 0.0599063635f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.186424732f, 0.0717198849f, -1.f),
    C_Vertex3f(0.176270247f, 0.0782829523f, -1.f),
    C_Vertex3f(0.183628082f, -0.00451731682f, -1.f),
    C_Vertex3f(0.205657959f, -0.00866723061f, -1.f),
    C_Vertex3f(0.197383404f, 0.0664694309f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.166919947f, 0.0861586332f, -1.f),
    C_Vertex3f(0.158373833f, 0.0953469276f, -1.f),
    C_Vertex3f(0.162867546f, 0.00170755386f, -1.f),
    C_Vertex3f(0.183628082f, -0.00451731682f, -1.f),
    C_Vertex3f(0.176270247f, 0.0782829523f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.146760941f, 0.111098289f, -1.f),
    C_Vertex3f(0.135148048f, 0.131717205f, -1.f),
    C_Vertex3f(0.14337635f, 0.0100073814f, -1.f),
    C_Vertex3f(0.162867546f, 0.00170755386f, -1.f),
    C_Vertex3f(0.158373833f, 0.0953469276f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.126324177f, 0.20557642f, -1.f),
    C_Vertex3f(0.131577253f, 0.334079504f, -1.f),
    C_Vertex3f(0.123535156f, 0.189525604f, -1.f),
    C_Vertex3f(0.117303133f, 0.323568583f, -1.f),
    C_Vertex3f(0.123535156f, 0.171806335f, -1.f),
    C_Vertex3f(0.125154495f, 0.0203821659f, -1.f),
    C_Vertex3f(0.12740612f, 0.15195322f, -1.f),
    C_Vertex3f(0.14337635f, 0.0100073814f, -1.f),
    C_Vertex3f(0.135148048f, 0.131717205f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.125154495f, 0.0203821659f, -1.f),
    C_Vertex3f(0.117303133f, 0.323568583f, -1.f),
    C_Vertex3f(0.108201981f, 0.0328319073f, -1.f),
    C_Vertex3f(0.104209304f, 0.312695861f, -1.f),
    C_Vertex3f(0.0925188065f, 0.0473566055f, -1.f),
    C_Vertex3f(0.0922957659f, 0.301461339f, -1.f),
    C_Vertex3f(0.0815625191f, 0.289865017f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.0925188065f, 0.0473566055f, -1.f),
    C_Vertex3f(0.0815625191f, 0.289865017f, -1.f),
    C_Vertex3f(0.0794696808f, 0.0624265671f, -1.f),
    C_Vertex3f(0.0720095634f, 0.277906895f, -1.f),
    C_Vertex3f(0.0692458153f, 0.0763628483f, -1.f),
    C_Vertex3f(0.0636507273f, 0.265587211f, -1.f),
    C_Vertex3f(0.060482502f, 0.0906951427f, -1.f),
    C_Vertex3f(0.0564860106f, 0.252905965f, -1.f),
    C_Vertex3f(0.0531797409f, 0.10542345f, -1.f),
    C_Vertex3f(0.0505154133f, 0.239863157f, -1.f),
    C_Vertex3f(0.047337532f, 0.120547771f, -1.f),
    C_Vertex3f(0.0457389355f, 0.226458788f, -1.f),
    C_Vertex3f(0.0429558754f, 0.136068106f, -1.f),
    C_Vertex3f(0.0421565771f, 0.212692857f, -1.f),
    C_Vertex3f(0.040034771f, 0.151984453f, -1.f),
    C_Vertex3f(0.0397683382f, 0.198565364f, -1.f),
    C_Vertex3f(0.0385742188f, 0.184076309f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.425941825f, 0.535222173f, -1.f),
    C_Vertex3f(0.423333287f, 0.548304915f, -1.f),
    C_Vertex3f(0.423446178f, 0.481171131f, -1.f),
    C_Vertex3f(0.427246094f, 0.503170967f, -1.f),
    C_Vertex3f(0.427246094f, 0.521634102f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.419420481f, 0.56088233f, -1.f),
    C_Vertex3f(0.414203405f, 0.572954416f, -1.f),
    C_Vertex3f(0.415846348f, 0.46000433f, -1.f),
    C_Vertex3f(0.423446178f, 0.481171131f, -1.f),
    C_Vertex3f(0.423333287f, 0.548304915f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.407682061f, 0.584521174f, -1.f),
    C_Vertex3f(0.399856448f, 0.595582604f, -1.f),
    C_Vertex3f(0.404446602f, 0.439670563f, -1.f),
    C_Vertex3f(0.415846348f, 0.46000433f, -1.f),
    C_Vertex3f(0.414203405f, 0.572954416f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.369114041f, 0.624983907f, -1.f),
    C_Vertex3f(0.370247364f, 0.401502132f, -1.f),
    C_Vertex3f(0.380292416f, 0.61618948f, -1.f),
    C_Vertex3f(0.389246941f, 0.42016983f, -1.f),
    C_Vertex3f(0.390726566f, 0.606138706f, -1.f),
    C_Vertex3f(0.404446602f, 0.439670563f, -1.f),
    C_Vertex3f(0.399856448f, 0.595582604f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.357191443f, 0.632521987f, -1.f),
    C_Vertex3f(0.344524622f, 0.63880372f, -1.f),
    C_Vertex3f(0.346191406f, 0.520820618f, -1.f),
    C_Vertex3f(0.347447872f, 0.383667469f, -1.f),
    C_Vertex3f(0.370247364f, 0.401502132f, -1.f),
    C_Vertex3f(0.369114041f, 0.624983907f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.320394516f, 0.571347237f, -1.f),
    C_Vertex3f(0.330713272f, 0.560969353f, -1.f),
    C_Vertex3f(0.331113577f, 0.643829107f, -1.f),
    C_Vertex3f(0.338452339f, 0.549088955f, -1.f),
    C_Vertex3f(0.344524622f, 0.63880372f, -1.f),
    C_Vertex3f(0.343611717f, 0.535706043f, -1.f),
    C_Vertex3f(0.346191406f, 0.520820618f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.23840332f, 0.579212189f, -1.f),
    C_Vertex3f(0.251602173f, 0.584346771f, -1.f),
    C_Vertex3f(0.253219962f, 0.650036693f, -1.f),
    C_Vertex3f(0.266132355f, 0.586914063f, -1.f),
    C_Vertex3f(0.269643784f, 0.651367188f, -1.f),
    C_Vertex3f(0.281776428f, 0.586914063f, -1.f),
    C_Vertex3f(0.2864151f, 0.651367188f, -1.f),
    C_Vertex3f(0.295926094f, 0.584319592f, -1.f),
    C_Vertex3f(0.302058816f, 0.650110841f, -1.f),
    C_Vertex3f(0.30879879f, 0.57913065f, -1.f),
    C_Vertex3f(0.316958308f, 0.647598147f, -1.f),
    C_Vertex3f(0.320394516f, 0.571347237f, -1.f),
    C_Vertex3f(0.331113577f, 0.643829107f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.202829361f, 0.537261009f, -1.f),
    C_Vertex3f(0.208097458f, 0.549824715f, -1.f),
    C_Vertex3f(0.208333731f, 0.638062239f, -1.f),
    C_Vertex3f(0.215999603f, 0.56124115f, -1.f),
    C_Vertex3f(0.222564936f, 0.643384218f, -1.f),
    C_Vertex3f(0.226535797f, 0.571510315f, -1.f),
    C_Vertex3f(0.237527013f, 0.647375703f, -1.f),
    C_Vertex3f(0.23840332f, 0.579212189f, -1.f),
    C_Vertex3f(0.253219962f, 0.650036693f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.181481361f, 0.363441467f, -1.f),
    C_Vertex3f(0.163666368f, 0.354015946f, -1.f),
    C_Vertex3f(0.163688779f, 0.266960025f, -1.f),
    C_Vertex3f(0.173163176f, 0.275621653f, -1.f),
    C_Vertex3f(0.183936357f, 0.284454107f, -1.f),
    C_Vertex3f(0.190979004f, 0.367973328f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.131902218f, 0.221709728f, -1.f),
    C_Vertex3f(0.140269279f, 0.237925529f, -1.f),
    C_Vertex3f(0.147031665f, 0.344228625f, -1.f),
    C_Vertex3f(0.148636341f, 0.25014925f, -1.f),
    C_Vertex3f(0.163666368f, 0.354015946f, -1.f),
    C_Vertex3f(0.155513167f, 0.258469224f, -1.f),
    C_Vertex3f(0.163688779f, 0.266960025f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.131577253f, 0.334079504f, -1.f),
    C_Vertex3f(0.126324177f, 0.20557642f, -1.f),
    C_Vertex3f(0.131902218f, 0.221709728f, -1.f),
    C_Vertex3f(0.147031665f, 0.344228625f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.347447872f, 0.383667469f, -1.f),
    C_Vertex3f(0.346191406f, 0.520820618f, -1.f),
    C_Vertex3f(0.346191406f, 0.505743027f, -1.f),
    C_Vertex3f(0.344315529f, 0.492577076f, -1.f),
    C_Vertex3f(0.340563774f, 0.480012417f, -1.f),
    C_Vertex3f(0.334936142f, 0.468049049f, -1.f),
    C_Vertex3f(0.32930851f, 0.459527493f, -1.f),
    C_Vertex3f(0.324434996f, 0.453614354f, -1.f),
    C_Vertex3f(0.320848465f, 0.36666584f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.208333731f, 0.638062239f, -1.f),
    C_Vertex3f(0.200195313f, 0.523550034f, -1.f),
    C_Vertex3f(0.202829361f, 0.537261009f, -1.f),
    C_Vertex3f(0.040034771f, 0.151984453f, -1.f),
    C_Vertex3f(0.0385742188f, 0.184076309f, -1.f),
    C_Vertex3f(0.0385742188f, 0.168296814f, -1.f),
    C_Vertex3f(0.283241034f, 0.420567155f, -1.f),
    C_Vertex3f(0.305648804f, 0.358581543f, -1.f),
    C_Vertex3f(0.293723345f, 0.427640796f, -1.f),
    C_End(),
    C_Translatef(0.597167969f, 0.f, 0.f),
};
static const Call char_39[] = {
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_FrontFace(GL_CW),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.986297071f, -0.164979234f, 0.f),
    C_Vertex3f(0.0596008301f, 0.413574219f, 0.f),
    C_Vertex3f(0.0596008301f, 0.413574219f, -1.f),
    C_Vertex3f(0.0395507813f, 0.533439636f, -1.f),
    C_Vertex3f(0.0395507813f, 0.533439636f, 0.f),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.0395507813f, 0.533439636f, 0.f),
    C_Vertex3f(0.0395507813f, 0.533439636f, -1.f),
    C_Vertex3f(0.0395507813f, 0.640625f, -1.f),
    C_Vertex3f(0.0395507813f, 0.640625f, 0.f),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.0395507813f, 0.640625f, 0.f),
    C_Vertex3f(0.0395507813f, 0.640625f, -1.f),
    C_Vertex3f(0.12890625f, 0.640625f, -1.f),
    C_Vertex3f(0.12890625f, 0.640625f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.12890625f, 0.640625f, 0.f),
    C_Vertex3f(0.12890625f, 0.640625f, -1.f),
    C_Vertex3f(0.12890625f, 0.533439636f, -1.f),
    C_Vertex3f(0.12890625f, 0.533439636f, 0.f),
    C_Normal3f(0.985109389f, -0.171928585f, 0.f),
    C_Vertex3f(0.12890625f, 0.533439636f, 0.f),
    C_Vertex3f(0.12890625f, 0.533439636f, -1.f),
    C_Vertex3f(0.10798645f, 0.413574219f, -1.f),
    C_Vertex3f(0.10798645f, 0.413574219f, 0.f),
    C_Normal3f(-0.f, -1.f, 0.f),
    C_Vertex3f(0.10798645f, 0.413574219f, 0.f),
    C_Vertex3f(0.10798645f, 0.413574219f, -1.f),
    C_Vertex3f(0.0596008301f, 0.413574219f, -1.f),
    C_Vertex3f(0.0596008301f, 0.413574219f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.0596008301f, 0.413574219f, 0.f),
    C_Vertex3f(0.10798645f, 0.413574219f, 0.f),
    C_Vertex3f(0.12890625f, 0.533439636f, 0.f),
    C_Vertex3f(0.12890625f, 0.640625f, 0.f),
    C_Vertex3f(0.0395507813f, 0.640625f, 0.f),
    C_Vertex3f(0.0395507813f, 0.533439636f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, -1.f),
    C_FrontFace(GL_CW),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.0596008301f, 0.413574219f, -1.f),
    C_Vertex3f(0.10798645f, 0.413574219f, -1.f),
    C_Vertex3f(0.12890625f, 0.533439636f, -1.f),
    C_Vertex3f(0.12890625f, 0.640625f, -1.f),
    C_Vertex3f(0.0395507813f, 0.640625f, -1.f),
    C_Vertex3f(0.0395507813f, 0.533439636f, -1.f),
    C_End(),
    C_Translatef(0.170898438f, 0.f, 0.f),
};
static const Call char_40[] = {
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_FrontFace(GL_CW),
    C_Begin(GL_QUAD_STRIP),
    C_Normal3f(-0.783403635f, -0.621513307f, 0.f),
    C_Vertex3f(0.209472656f, -0.188476563f, 0.f),
    C_Vertex3f(0.209472656f, -0.188476563f, -1.f),
    C_Normal3f(-0.799380183f, -0.600825608f, 0.f),
    C_Vertex3f(0.20132637f, -0.178208351f, 0.f),
    C_Vertex3f(0.20132637f, -0.178208351f, -1.f),
    C_Normal3f(-0.818240702f, -0.574875832f, 0.f),
    C_Vertex3f(0.185662508f, -0.156797886f, 0.f),
    C_Vertex3f(0.185662508f, -0.156797886f, -1.f),
    C_Normal3f(-0.839256108f, -0.543736279f, 0.f),
    C_Vertex3f(0.170627356f, -0.134513378f, 0.f),
    C_Vertex3f(0.170627356f, -0.134513378f, -1.f),
    C_Normal3f(-0.858538628f, -0.512748837f, 0.f),
    C_Vertex3f(0.156220913f, -0.111354828f, 0.f),
    C_Vertex3f(0.156220913f, -0.111354828f, -1.f),
    C_Normal3f(-0.876138926f, -0.482058674f, 0.f),
    C_Vertex3f(0.14244318f, -0.0873222351f, 0.f),
    C_Vertex3f(0.14244318f, -0.0873222351f, -1.f),
    C_Normal3f(-0.892122626f, -0.451793462f, 0.f),
    C_Vertex3f(0.129294157f, -0.0624155998f, 0.f),
    C_Vertex3f(0.129294157f, -0.0624155998f, -1.f),
    C_Normal3f(-0.90656656f, -0.422062725f, 0.f),
    C_Vertex3f(0.116773844f, -0.036634922f, 0.f),
    C_Vertex3f(0.116773844f, -0.036634922f, -1.f),
    C_Normal3f(-0.919556201f, -0.392958522f, 0.f),
    C_Vertex3f(0.10488224f, -0.00998020172f, 0.f),
    C_Vertex3f(0.10488224f, -0.00998020172f, -1.f),
    C_Normal3f(-0.934206545f, -0.356732637f, 0.f),
    C_Vertex3f(0.0936193466f, 0.0175485611f, 0.f),
    C_Vertex3f(0.0936193466f, 0.0175485611f, -1.f),
    C_Normal3f(-0.950185239f, -0.311685562f, 0.f),
    C_Vertex3f(0.0837643147f, 0.0453231335f, 0.f),
    C_Vertex3f(0.0837643147f, 0.0453231335f, -1.f),
    C_Normal3f(-0.964171767f, -0.265278637f, 0.f),
    C_Vertex3f(0.0753171444f, 0.0733435154f, 0.f),
    C_Vertex3f(0.0753171444f, 0.0733435154f, -1.f),
    C_Normal3f(-0.975992382f, -0.21780476f, 0.f),
    C_Vertex3f(0.0682778358f, 0.101609707f, 0.f),
    C_Vertex3f(0.0682778358f, 0.101609707f, -1.f),
    C_Normal3f(-0.985514998f, -0.169588149f, 0.f),
    C_Vertex3f(0.062646389f, 0.130121708f, 0.f),
    C_Vertex3f(0.062646389f, 0.130121708f, -1.f),
    C_Normal3f(-0.992655694f, -0.120973632f, 0.f),
    C_Vertex3f(0.0584228039f, 0.158879519f, 0.f),
    C_Vertex3f(0.0584228039f, 0.158879519f, -1.f),
    C_Normal3f(-0.997381926f, -0.0723142847f, 0.f),
    C_Vertex3f(0.0556070805f, 0.187883139f, 0.f),
    C_Vertex3f(0.0556070805f, 0.187883139f, -1.f),
    C_Normal3f(-0.999695003f, -0.0246932749f, 0.f),
    C_Vertex3f(0.0541992188f, 0.217132568f, 0.f),
    C_Vertex3f(0.0541992188f, 0.217132568f, -1.f),
    C_Normal3f(-0.999806404f, 0.0196766835f, 0.f),
    C_Vertex3f(0.0541992188f, 0.244879723f, 0.f),
    C_Vertex3f(0.0541992188f, 0.244879723f, -1.f),
    C_Normal3f(-0.998102665f, 0.0615709201f, 0.f),
    C_Vertex3f(0.0552515984f, 0.270605803f, 0.f),
    C_Vertex3f(0.0552515984f, 0.270605803f, -1.f),
    C_Normal3f(-0.994643509f, 0.10336525f, 0.f),
    C_Vertex3f(0.0573563576f, 0.296058893f, 0.f),
    C_Vertex3f(0.0573563576f, 0.296058893f, -1.f),
    C_Normal3f(-0.989356577f, 0.14551121f, 0.f),
    C_Vertex3f(0.0605134964f, 0.321238995f, 0.f),
    C_Vertex3f(0.0605134964f, 0.321238995f, -1.f),
    C_Normal3f(-0.982210875f, 0.187781513f, 0.f),
    C_Vertex3f(0.0647230148f, 0.346146107f, 0.f),
    C_Vertex3f(0.0647230148f, 0.346146107f, -1.f),
    C_Normal3f(-0.973204792f, 0.229940414f, 0.f),
    C_Vertex3f(0.0699849129f, 0.37078023f, 0.f),
    C_Vertex3f(0.0699849129f, 0.37078023f, -1.f),
    C_Normal3f(-0.962367892f, 0.271750033f, 0.f),
    C_Vertex3f(0.0762991905f, 0.395141363f, 0.f),
    C_Vertex3f(0.0762991905f, 0.395141363f, -1.f),
    C_Normal3f(-0.94929719f, 0.314380258f, 0.f),
    C_Vertex3f(0.0836658478f, 0.419229507f, 0.f),
    C_Vertex3f(0.0836658478f, 0.419229507f, -1.f),
    C_Normal3f(-0.934527814f, 0.355890036f, 0.f),
    C_Vertex3f(0.0927963257f, 0.444955826f, 0.f),
    C_Vertex3f(0.0927963257f, 0.444955826f, -1.f),
    C_Normal3f(-0.918856561f, 0.394591779f, 0.f),
    C_Vertex3f(0.10397768f, 0.472566128f, 0.f),
    C_Vertex3f(0.10397768f, 0.472566128f, -1.f),
    C_Normal3f(-0.902069449f, 0.431590706f, 0.f),
    C_Vertex3f(0.11649847f, 0.50014925f, 0.f),
    C_Vertex3f(0.11649847f, 0.50014925f, -1.f),
    C_Normal3f(-0.884468198f, 0.466600388f, 0.f),
    C_Vertex3f(0.130358696f, 0.527705193f, 0.f),
    C_Vertex3f(0.130358696f, 0.527705193f, -1.f),
    C_Normal3f(-0.866250396f, 0.499610037f, 0.f),
    C_Vertex3f(0.145558357f, 0.555233955f, 0.f),
    C_Vertex3f(0.145558357f, 0.555233955f, -1.f),
    C_Normal3f(-0.847598672f, 0.530637801f, 0.f),
    C_Vertex3f(0.162097454f, 0.582735538f, 0.f),
    C_Vertex3f(0.162097454f, 0.582735538f, -1.f),
    C_Normal3f(-0.828677893f, 0.559725761f, 0.f),
    C_Vertex3f(0.179975986f, 0.610209942f, 0.f),
    C_Vertex3f(0.179975986f, 0.610209942f, -1.f),
    C_Normal3f(-0.812811077f, 0.582527339f, 0.f),
    C_Vertex3f(0.199193954f, 0.637657166f, 0.f),
    C_Vertex3f(0.199193954f, 0.637657166f, -1.f),
    C_Normal3f(-0.800106883f, 0.599857569f, 0.f),
    C_Vertex3f(0.209472656f, 0.651367188f, 0.f),
    C_Vertex3f(0.209472656f, 0.651367188f, -1.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.f, 0.99999994f, 0.f),
    C_Vertex3f(0.209472656f, 0.651367188f, 0.f),
    C_Vertex3f(0.209472656f, 0.651367188f, -1.f),
    C_Vertex3f(0.265625f, 0.651367188f, -1.f),
    C_Vertex3f(0.265625f, 0.651367188f, 0.f),
    C_End(),
    C_Begin(GL_QUAD_STRIP),
    C_Normal3f(0.864859104f, -0.502014637f, 0.f),
    C_Vertex3f(0.265625f, 0.651367188f, 0.f),
    C_Vertex3f(0.265625f, 0.651367188f, -1.f),
    C_Normal3f(0.866869211f, -0.498535752f, 0.f),
    C_Vertex3f(0.259030342f, 0.640006065f, 0.f),
    C_Vertex3f(0.259030342f, 0.640006065f, -1.f),
    C_Normal3f(0.869675517f, -0.493623674f, 0.f),
    C_Vertex3f(0.246958256f, 0.618908882f, 0.f),
    C_Vertex3f(0.246958256f, 0.618908882f, -1.f),
    C_Normal3f(0.873564363f, -0.48670876f, 0.f),
    C_Vertex3f(0.236003399f, 0.59943676f, 0.f),
    C_Vertex3f(0.236003399f, 0.59943676f, -1.f),
    C_Normal3f(0.878167391f, -0.478353441f, 0.f),
    C_Vertex3f(0.226165771f, 0.581589699f, 0.f),
    C_Vertex3f(0.226165771f, 0.581589699f, -1.f),
    C_Normal3f(0.883697152f, -0.468059242f, 0.f),
    C_Vertex3f(0.217445374f, 0.565367699f, 0.f),
    C_Vertex3f(0.217445374f, 0.565367699f, -1.f),
    C_Normal3f(0.890455842f, -0.455069512f, 0.f),
    C_Vertex3f(0.209842205f, 0.55077076f, 0.f),
    C_Vertex3f(0.209842205f, 0.55077076f, -1.f),
    C_Normal3f(0.89888674f, -0.438180864f, 0.f),
    C_Vertex3f(0.203356266f, 0.537798882f, 0.f),
    C_Vertex3f(0.203356266f, 0.537798882f, -1.f),
    C_Normal3f(0.911201239f, -0.411961406f, 0.f),
    C_Vertex3f(0.197987556f, 0.526452065f, 0.f),
    C_Vertex3f(0.197987556f, 0.526452065f, -1.f),
    C_Normal3f(0.926197827f, -0.377038121f, 0.f),
    C_Vertex3f(0.189212799f, 0.506515503f, 0.f),
    C_Vertex3f(0.189212799f, 0.506515503f, -1.f),
    C_Normal3f(0.941219926f, -0.337794334f, 0.f),
    C_Vertex3f(0.177330971f, 0.475708961f, 0.f),
    C_Vertex3f(0.177330971f, 0.475708961f, -1.f),
    C_Normal3f(0.955980062f, -0.293431818f, 0.f),
    C_Vertex3f(0.166865349f, 0.444247246f, 0.f),
    C_Vertex3f(0.166865349f, 0.444247246f, -1.f),
    C_Normal3f(0.96907568f, -0.246763766f, 0.f),
    C_Vertex3f(0.157815933f, 0.412130356f, 0.f),
    C_Vertex3f(0.157815933f, 0.412130356f, -1.f),
    C_Normal3f(0.980637014f, -0.195834011f, 0.f),
    C_Vertex3f(0.149312973f, 0.37531662f, 0.f),
    C_Vertex3f(0.149312973f, 0.37531662f, -1.f),
    C_Normal3f(0.989956379f, -0.141373023f, 0.f),
    C_Vertex3f(0.14228344f, 0.33435154f, 0.f),
    C_Vertex3f(0.14228344f, 0.33435154f, -1.f),
    C_Normal3f(0.996368527f, -0.0851455852f, 0.f),
    C_Vertex3f(0.137597084f, 0.293276787f, 0.f),
    C_Vertex3f(0.137597084f, 0.293276787f, -1.f),
    C_Normal3f(0.999511838f, -0.0312405061f, 0.f),
    C_Vertex3f(0.135253906f, 0.252092361f, 0.f),
    C_Vertex3f(0.135253906f, 0.252092361f, -1.f),
    C_Normal3f(0.999856174f, 0.0169580523f, 0.f),
    C_Vertex3f(0.135253906f, 0.218308926f, 0.f),
    C_Vertex3f(0.135253906f, 0.218308926f, -1.f),
    C_Normal3f(0.998312831f, 0.0580642819f, 0.f),
    C_Vertex3f(0.13627243f, 0.192039609f, 0.f),
    C_Vertex3f(0.13627243f, 0.192039609f, -1.f),
    C_Normal3f(0.995333135f, 0.0964976624f, 0.f),
    C_Vertex3f(0.138309479f, 0.165773749f, 0.f),
    C_Vertex3f(0.138309479f, 0.165773749f, -1.f),
    C_Normal3f(0.990911663f, 0.134514302f, 0.f),
    C_Vertex3f(0.141365051f, 0.139511347f, 0.f),
    C_Vertex3f(0.141365051f, 0.139511347f, -1.f),
    C_Normal3f(0.98510468f, 0.171956077f, 0.f),
    C_Vertex3f(0.145439148f, 0.113252401f, 0.f),
    C_Vertex3f(0.145439148f, 0.113252401f, -1.f),
    C_Normal3f(0.977984607f, 0.208676979f, 0.f),
    C_Vertex3f(0.150531769f, 0.086996913f, 0.f),
    C_Vertex3f(0.150531769f, 0.086996913f, -1.f),
    C_Normal3f(0.969637811f, 0.244545639f, 0.f),
    C_Vertex3f(0.156642914f, 0.0607448816f, 0.f),
    C_Vertex3f(0.156642914f, 0.0607448816f, -1.f),
    C_Normal3f(0.96016115f, 0.279447109f, 0.f),
    C_Vertex3f(0.163772583f, 0.0344963074f, 0.f),
    C_Vertex3f(0.163772583f, 0.0344963074f, -1.f),
    C_Normal3f(0.949659526f, 0.313284039f, 0.f),
    C_Vertex3f(0.171920776f, 0.00825119019f, 0.f),
    C_Vertex3f(0.171920776f, 0.00825119019f, -1.f),
    C_Normal3f(0.938242912f, 0.345977247f, 0.f),
    C_Vertex3f(0.181087494f, -0.0179904699f, 0.f),
    C_Vertex3f(0.181087494f, -0.0179904699f, -1.f),
    C_Normal3f(0.926023602f, 0.377465457f, 0.f),
    C_Vertex3f(0.191272736f, -0.044228673f, 0.f),
    C_Vertex3f(0.191272736f, -0.044228673f, -1.f),
    C_Normal3f(0.913113832f, 0.40770483f, 0.f),
    C_Vertex3f(0.202476501f, -0.070463419f, 0.f),
    C_Vertex3f(0.202476501f, -0.070463419f, -1.f),
    C_Normal3f(0.899622977f, 0.436667502f, 0.f),
    C_Vertex3f(0.214698792f, -0.0966947079f, 0.f),
    C_Vertex3f(0.214698792f, -0.0966947079f, -1.f),
    C_Normal3f(0.885656595f, 0.464340657f, 0.f),
    C_Vertex3f(0.227939606f, -0.12292254f, 0.f),
    C_Vertex3f(0.227939606f, -0.12292254f, -1.f),
    C_Normal3f(0.871314704f, 0.490724653f, 0.f),
    C_Vertex3f(0.242198944f, -0.149146914f, 0.f),
    C_Vertex3f(0.242198944f, -0.149146914f, -1.f),
    C_Normal3f(0.859143555f, 0.511734664f, 0.f),
    C_Vertex3f(0.257476807f, -0.175367832f, 0.f),
    C_Vertex3f(0.257476807f, -0.175367832f, -1.f),
    C_Normal3f(0.849299133f, 0.527911842f, 0.f),
    C_Vertex3f(0.265625f, -0.188476563f, 0.f),
    C_Vertex3f(0.265625f, -0.188476563f, -1.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.f, -0.99999994f, 0.f),
    C_Vertex3f(0.265625f, -0.188476563f, 0.f),
    C_Vertex3f(0.265625f, -0.188476563f, -1.f),
    C_Vertex3f(0.209472656f, -0.188476563f, -1.f),
    C_Vertex3f(0.209472656f, -0.188476563f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.209472656f, -0.188476563f, 0.f),
    C_Vertex3f(0.265625f, -0.188476563f, 0.f),
    C_Vertex3f(0.257476807f, -0.175367832f, 0.f),
    C_Vertex3f(0.242198944f, -0.149146914f, 0.f),
    C_Vertex3f(0.227939606f, -0.12292254f, 0.f),
    C_Vertex3f(0.214698792f, -0.0966947079f, 0.f),
    C_Vertex3f(0.202476501f, -0.070463419f, 0.f),
    C_Vertex3f(0.20132637f, -0.178208351f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.191272736f, -0.044228673f, 0.f),
    C_Vertex3f(0.181087494f, -0.0179904699f, 0.f),
    C_Vertex3f(0.185662508f, -0.156797886f, 0.f),
    C_Vertex3f(0.20132637f, -0.178208351f, 0.f),
    C_Vertex3f(0.202476501f, -0.070463419f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.171920776f, 0.00825119019f, 0.f),
    C_Vertex3f(0.163772583f, 0.0344963074f, 0.f),
    C_Vertex3f(0.170627356f, -0.134513378f, 0.f),
    C_Vertex3f(0.185662508f, -0.156797886f, 0.f),
    C_Vertex3f(0.181087494f, -0.0179904699f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.156642914f, 0.0607448816f, 0.f),
    C_Vertex3f(0.150531769f, 0.086996913f, 0.f),
    C_Vertex3f(0.156220913f, -0.111354828f, 0.f),
    C_Vertex3f(0.170627356f, -0.134513378f, 0.f),
    C_Vertex3f(0.163772583f, 0.0344963074f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.145439148f, 0.113252401f, 0.f),
    C_Vertex3f(0.141365051f, 0.139511347f, 0.f),
    C_Vertex3f(0.14244318f, -0.0873222351f, 0.f),
    C_Vertex3f(0.156220913f, -0.111354828f, 0.f),
    C_Vertex3f(0.150531769f, 0.086996913f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.14244318f, -0.0873222351f, 0.f),
    C_Vertex3f(0.141365051f, 0.139511347f, 0.f),
    C_Vertex3f(0.138309479f, 0.165773749f, 0.f),
    C_Vertex3f(0.13627243f, 0.192039609f, 0.f),
    C_Vertex3f(0.135253906f, 0.218308926f, 0.f),
    C_Vertex3f(0.129294157f, -0.0624155998f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.0836658478f, 0.419229507f, 0.f),
    C_Vertex3f(0.0837643147f, 0.0453231335f, 0.f),
    C_Vertex3f(0.0927963257f, 0.444955826f, 0.f),
    C_Vertex3f(0.0936193466f, 0.0175485611f, 0.f),
    C_Vertex3f(0.10397768f, 0.472566128f, 0.f),
    C_Vertex3f(0.10488224f, -0.00998020172f, 0.f),
    C_Vertex3f(0.11649847f, 0.50014925f, 0.f),
    C_Vertex3f(0.116773844f, -0.036634922f, 0.f),
    C_Vertex3f(0.130358696f, 0.527705193f, 0.f),
    C_Vertex3f(0.129294157f, -0.0624155998f, 0.f),
    C_Vertex3f(0.135253906f, 0.218308926f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.0552515984f, 0.270605803f, 0.f),
    C_Vertex3f(0.0556070805f, 0.187883139f, 0.f),
    C_Vertex3f(0.0573563576f, 0.296058893f, 0.f),
    C_Vertex3f(0.0584228039f, 0.158879519f, 0.f),
    C_Vertex3f(0.0605134964f, 0.321238995f, 0.f),
    C_Vertex3f(0.062646389f, 0.130121708f, 0.f),
    C_Vertex3f(0.0647230148f, 0.346146107f, 0.f),
    C_Vertex3f(0.0682778358f, 0.101609707f, 0.f),
    C_Vertex3f(0.0699849129f, 0.37078023f, 0.f),
    C_Vertex3f(0.0753171444f, 0.0733435154f, 0.f),
    C_Vertex3f(0.0762991905f, 0.395141363f, 0.f),
    C_Vertex3f(0.0837643147f, 0.0453231335f, 0.f),
    C_Vertex3f(0.0836658478f, 0.419229507f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.0541992188f, 0.244879723f, 0.f),
    C_Vertex3f(0.0541992188f, 0.217132568f, 0.f),
    C_Vertex3f(0.0556070805f, 0.187883139f, 0.f),
    C_Vertex3f(0.0552515984f, 0.270605803f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.209472656f, 0.651367188f, 0.f),
    C_Vertex3f(0.199193954f, 0.637657166f, 0.f),
    C_Vertex3f(0.203356266f, 0.537798882f, 0.f),
    C_Vertex3f(0.209842205f, 0.55077076f, 0.f),
    C_Vertex3f(0.217445374f, 0.565367699f, 0.f),
    C_Vertex3f(0.226165771f, 0.581589699f, 0.f),
    C_Vertex3f(0.236003399f, 0.59943676f, 0.f),
    C_Vertex3f(0.246958256f, 0.618908882f, 0.f),
    C_Vertex3f(0.259030342f, 0.640006065f, 0.f),
    C_Vertex3f(0.265625f, 0.651367188f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.166865349f, 0.444247246f, 0.f),
    C_Vertex3f(0.177330971f, 0.475708961f, 0.f),
    C_Vertex3f(0.179975986f, 0.610209942f, 0.f),
    C_Vertex3f(0.189212799f, 0.506515503f, 0.f),
    C_Vertex3f(0.199193954f, 0.637657166f, 0.f),
    C_Vertex3f(0.197987556f, 0.526452065f, 0.f),
    C_Vertex3f(0.203356266f, 0.537798882f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.162097454f, 0.582735538f, 0.f),
    C_Vertex3f(0.145558357f, 0.555233955f, 0.f),
    C_Vertex3f(0.149312973f, 0.37531662f, 0.f),
    C_Vertex3f(0.157815933f, 0.412130356f, 0.f),
    C_Vertex3f(0.166865349f, 0.444247246f, 0.f),
    C_Vertex3f(0.179975986f, 0.610209942f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.145558357f, 0.555233955f, 0.f),
    C_Vertex3f(0.130358696f, 0.527705193f, 0.f),
    C_Vertex3f(0.135253906f, 0.252092361f, 0.f),
    C_Vertex3f(0.137597084f, 0.293276787f, 0.f),
    C_Vertex3f(0.14228344f, 0.33435154f, 0.f),
    C_Vertex3f(0.149312973f, 0.37531662f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.135253906f, 0.252092361f, 0.f),
    C_Vertex3f(0.130358696f, 0.527705193f, 0.f),
    C_Vertex3f(0.135253906f, 0.218308926f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, -1.f),
    C_FrontFace(GL_CW),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.209472656f, -0.188476563f, -1.f),
    C_Vertex3f(0.265625f, -0.188476563f, -1.f),
    C_Vertex3f(0.257476807f, -0.175367832f, -1.f),
    C_Vertex3f(0.242198944f, -0.149146914f, -1.f),
    C_Vertex3f(0.227939606f, -0.12292254f, -1.f),
    C_Vertex3f(0.214698792f, -0.0966947079f, -1.f),
    C_Vertex3f(0.202476501f, -0.070463419f, -1.f),
    C_Vertex3f(0.20132637f, -0.178208351f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.191272736f, -0.044228673f, -1.f),
    C_Vertex3f(0.181087494f, -0.0179904699f, -1.f),
    C_Vertex3f(0.185662508f, -0.156797886f, -1.f),
    C_Vertex3f(0.20132637f, -0.178208351f, -1.f),
    C_Vertex3f(0.202476501f, -0.070463419f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.171920776f, 0.00825119019f, -1.f),
    C_Vertex3f(0.163772583f, 0.0344963074f, -1.f),
    C_Vertex3f(0.170627356f, -0.134513378f, -1.f),
    C_Vertex3f(0.185662508f, -0.156797886f, -1.f),
    C_Vertex3f(0.181087494f, -0.0179904699f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.156642914f, 0.0607448816f, -1.f),
    C_Vertex3f(0.150531769f, 0.086996913f, -1.f),
    C_Vertex3f(0.156220913f, -0.111354828f, -1.f),
    C_Vertex3f(0.170627356f, -0.134513378f, -1.f),
    C_Vertex3f(0.163772583f, 0.0344963074f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.145439148f, 0.113252401f, -1.f),
    C_Vertex3f(0.141365051f, 0.139511347f, -1.f),
    C_Vertex3f(0.14244318f, -0.0873222351f, -1.f),
    C_Vertex3f(0.156220913f, -0.111354828f, -1.f),
    C_Vertex3f(0.150531769f, 0.086996913f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.14244318f, -0.0873222351f, -1.f),
    C_Vertex3f(0.141365051f, 0.139511347f, -1.f),
    C_Vertex3f(0.138309479f, 0.165773749f, -1.f),
    C_Vertex3f(0.13627243f, 0.192039609f, -1.f),
    C_Vertex3f(0.135253906f, 0.218308926f, -1.f),
    C_Vertex3f(0.129294157f, -0.0624155998f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.0836658478f, 0.419229507f, -1.f),
    C_Vertex3f(0.0837643147f, 0.0453231335f, -1.f),
    C_Vertex3f(0.0927963257f, 0.444955826f, -1.f),
    C_Vertex3f(0.0936193466f, 0.0175485611f, -1.f),
    C_Vertex3f(0.10397768f, 0.472566128f, -1.f),
    C_Vertex3f(0.10488224f, -0.00998020172f, -1.f),
    C_Vertex3f(0.11649847f, 0.50014925f, -1.f),
    C_Vertex3f(0.116773844f, -0.036634922f, -1.f),
    C_Vertex3f(0.130358696f, 0.527705193f, -1.f),
    C_Vertex3f(0.129294157f, -0.0624155998f, -1.f),
    C_Vertex3f(0.135253906f, 0.218308926f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.0552515984f, 0.270605803f, -1.f),
    C_Vertex3f(0.0556070805f, 0.187883139f, -1.f),
    C_Vertex3f(0.0573563576f, 0.296058893f, -1.f),
    C_Vertex3f(0.0584228039f, 0.158879519f, -1.f),
    C_Vertex3f(0.0605134964f, 0.321238995f, -1.f),
    C_Vertex3f(0.062646389f, 0.130121708f, -1.f),
    C_Vertex3f(0.0647230148f, 0.346146107f, -1.f),
    C_Vertex3f(0.0682778358f, 0.101609707f, -1.f),
    C_Vertex3f(0.0699849129f, 0.37078023f, -1.f),
    C_Vertex3f(0.0753171444f, 0.0733435154f, -1.f),
    C_Vertex3f(0.0762991905f, 0.395141363f, -1.f),
    C_Vertex3f(0.0837643147f, 0.0453231335f, -1.f),
    C_Vertex3f(0.0836658478f, 0.419229507f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.0541992188f, 0.244879723f, -1.f),
    C_Vertex3f(0.0541992188f, 0.217132568f, -1.f),
    C_Vertex3f(0.0556070805f, 0.187883139f, -1.f),
    C_Vertex3f(0.0552515984f, 0.270605803f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.209472656f, 0.651367188f, -1.f),
    C_Vertex3f(0.199193954f, 0.637657166f, -1.f),
    C_Vertex3f(0.203356266f, 0.537798882f, -1.f),
    C_Vertex3f(0.209842205f, 0.55077076f, -1.f),
    C_Vertex3f(0.217445374f, 0.565367699f, -1.f),
    C_Vertex3f(0.226165771f, 0.581589699f, -1.f),
    C_Vertex3f(0.236003399f, 0.59943676f, -1.f),
    C_Vertex3f(0.246958256f, 0.618908882f, -1.f),
    C_Vertex3f(0.259030342f, 0.640006065f, -1.f),
    C_Vertex3f(0.265625f, 0.651367188f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.166865349f, 0.444247246f, -1.f),
    C_Vertex3f(0.177330971f, 0.475708961f, -1.f),
    C_Vertex3f(0.179975986f, 0.610209942f, -1.f),
    C_Vertex3f(0.189212799f, 0.506515503f, -1.f),
    C_Vertex3f(0.199193954f, 0.637657166f, -1.f),
    C_Vertex3f(0.197987556f, 0.526452065f, -1.f),
    C_Vertex3f(0.203356266f, 0.537798882f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.162097454f, 0.582735538f, -1.f),
    C_Vertex3f(0.145558357f, 0.555233955f, -1.f),
    C_Vertex3f(0.149312973f, 0.37531662f, -1.f),
    C_Vertex3f(0.157815933f, 0.412130356f, -1.f),
    C_Vertex3f(0.166865349f, 0.444247246f, -1.f),
    C_Vertex3f(0.179975986f, 0.610209942f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.145558357f, 0.555233955f, -1.f),
    C_Vertex3f(0.130358696f, 0.527705193f, -1.f),
    C_Vertex3f(0.135253906f, 0.252092361f, -1.f),
    C_Vertex3f(0.137597084f, 0.293276787f, -1.f),
    C_Vertex3f(0.14228344f, 0.33435154f, -1.f),
    C_Vertex3f(0.149312973f, 0.37531662f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.135253906f, 0.252092361f, -1.f),
    C_Vertex3f(0.130358696f, 0.527705193f, -1.f),
    C_Vertex3f(0.135253906f, 0.218308926f, -1.f),
    C_End(),
    C_Translatef(0.297851563f, 0.f, 0.f),
};
static const Call char_41[] = {
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_FrontFace(GL_CW),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.f, -0.99999994f, 0.f),
    C_Vertex3f(0.110351563f, -0.188476563f, 0.f),
    C_Vertex3f(0.110351563f, -0.188476563f, -1.f),
    C_Vertex3f(0.0541992188f, -0.188476563f, -1.f),
    C_Vertex3f(0.0541992188f, -0.188476563f, 0.f),
    C_End(),
    C_Begin(GL_QUAD_STRIP),
    C_Normal3f(-0.849299133f, 0.527911842f, 0.f),
    C_Vertex3f(0.0541992188f, -0.188476563f, 0.f),
    C_Vertex3f(0.0541992188f, -0.188476563f, -1.f),
    C_Normal3f(-0.859143555f, 0.511734664f, 0.f),
    C_Vertex3f(0.0623474121f, -0.175367832f, 0.f),
    C_Vertex3f(0.0623474121f, -0.175367832f, -1.f),
    C_Normal3f(-0.871314704f, 0.490724653f, 0.f),
    C_Vertex3f(0.0776252747f, -0.149146914f, 0.f),
    C_Vertex3f(0.0776252747f, -0.149146914f, -1.f),
    C_Normal3f(-0.885656595f, 0.464340657f, 0.f),
    C_Vertex3f(0.091884613f, -0.12292254f, 0.f),
    C_Vertex3f(0.091884613f, -0.12292254f, -1.f),
    C_Normal3f(-0.899622977f, 0.436667502f, 0.f),
    C_Vertex3f(0.105125427f, -0.0966947079f, 0.f),
    C_Vertex3f(0.105125427f, -0.0966947079f, -1.f),
    C_Normal3f(-0.913113832f, 0.40770483f, 0.f),
    C_Vertex3f(0.117347717f, -0.070463419f, 0.f),
    C_Vertex3f(0.117347717f, -0.070463419f, -1.f),
    C_Normal3f(-0.926023602f, 0.377465457f, 0.f),
    C_Vertex3f(0.128551483f, -0.044228673f, 0.f),
    C_Vertex3f(0.128551483f, -0.044228673f, -1.f),
    C_Normal3f(-0.938242912f, 0.345977247f, 0.f),
    C_Vertex3f(0.138736725f, -0.0179904699f, 0.f),
    C_Vertex3f(0.138736725f, -0.0179904699f, -1.f),
    C_Normal3f(-0.949659526f, 0.313284039f, 0.f),
    C_Vertex3f(0.147903442f, 0.00825119019f, 0.f),
    C_Vertex3f(0.147903442f, 0.00825119019f, -1.f),
    C_Normal3f(-0.96016115f, 0.279447109f, 0.f),
    C_Vertex3f(0.156051636f, 0.0344963074f, 0.f),
    C_Vertex3f(0.156051636f, 0.0344963074f, -1.f),
    C_Normal3f(-0.969637811f, 0.244545639f, 0.f),
    C_Vertex3f(0.163181305f, 0.0607448816f, 0.f),
    C_Vertex3f(0.163181305f, 0.0607448816f, -1.f),
    C_Normal3f(-0.977984607f, 0.208676979f, 0.f),
    C_Vertex3f(0.16929245f, 0.086996913f, 0.f),
    C_Vertex3f(0.16929245f, 0.086996913f, -1.f),
    C_Normal3f(-0.98510468f, 0.171956077f, 0.f),
    C_Vertex3f(0.174385071f, 0.113252401f, 0.f),
    C_Vertex3f(0.174385071f, 0.113252401f, -1.f),
    C_Normal3f(-0.990911663f, 0.134514302f, 0.f),
    C_Vertex3f(0.178459167f, 0.139511347f, 0.f),
    C_Vertex3f(0.178459167f, 0.139511347f, -1.f),
    C_Normal3f(-0.995333135f, 0.0964976624f, 0.f),
    C_Vertex3f(0.18151474f, 0.165773749f, 0.f),
    C_Vertex3f(0.18151474f, 0.165773749f, -1.f),
    C_Normal3f(-0.998312831f, 0.0580642819f, 0.f),
    C_Vertex3f(0.183551788f, 0.192039609f, 0.f),
    C_Vertex3f(0.183551788f, 0.192039609f, -1.f),
    C_Normal3f(-0.999855578f, 0.0169893391f, 0.f),
    C_Vertex3f(0.184570313f, 0.218308926f, 0.f),
    C_Vertex3f(0.184570313f, 0.218308926f, -1.f),
    C_Normal3f(-0.999506831f, -0.0314017348f, 0.f),
    C_Vertex3f(0.184570313f, 0.251981735f, 0.f),
    C_Vertex3f(0.184570313f, 0.251981735f, -1.f),
    C_Normal3f(-0.996314943f, -0.0857694522f, 0.f),
    C_Vertex3f(0.182227135f, 0.292891502f, 0.f),
    C_Vertex3f(0.182227135f, 0.292891502f, -1.f),
    C_Normal3f(-0.989783108f, -0.142581403f, 0.f),
    C_Vertex3f(0.177540779f, 0.333638191f, 0.f),
    C_Vertex3f(0.177540779f, 0.333638191f, -1.f),
    C_Normal3f(-0.98061049f, -0.195967004f, 0.f),
    C_Vertex3f(0.170511246f, 0.374221802f, 0.f),
    C_Vertex3f(0.170511246f, 0.374221802f, -1.f),
    C_Normal3f(-0.969801903f, -0.243894055f, 0.f),
    C_Vertex3f(0.162117004f, 0.4108181f, 0.f),
    C_Vertex3f(0.162117004f, 0.4108181f, -1.f),
    C_Normal3f(-0.957120419f, -0.289690197f, 0.f),
    C_Vertex3f(0.153230667f, 0.44293499f, 0.f),
    C_Vertex3f(0.153230667f, 0.44293499f, -1.f),
    C_Normal3f(-0.94200182f, -0.335607886f, 0.f),
    C_Vertex3f(0.142873764f, 0.474396706f, 0.f),
    C_Vertex3f(0.142873764f, 0.474396706f, -1.f),
    C_Normal3f(-0.926686645f, -0.375834703f, 0.f),
    C_Vertex3f(0.131046295f, 0.505203247f, 0.f),
    C_Vertex3f(0.131046295f, 0.505203247f, -1.f),
    C_Normal3f(-0.911933899f, -0.41033709f, 0.f),
    C_Vertex3f(0.122271538f, 0.525195122f, 0.f),
    C_Vertex3f(0.122271538f, 0.525195122f, -1.f),
    C_Normal3f(-0.900132418f, -0.435616374f, 0.f),
    C_Vertex3f(0.116889238f, 0.536665916f, 0.f),
    C_Vertex3f(0.116889238f, 0.536665916f, -1.f),
    C_Normal3f(-0.89148128f, -0.453057736f, 0.f),
    C_Vertex3f(0.11037612f, 0.549775124f, 0.f),
    C_Vertex3f(0.11037612f, 0.549775124f, -1.f),
    C_Normal3f(-0.884536624f, -0.466470718f, 0.f),
    C_Vertex3f(0.102732182f, 0.564522743f, 0.f),
    C_Vertex3f(0.102732182f, 0.564522743f, -1.f),
    C_Normal3f(-0.878849566f, -0.477099001f, 0.f),
    C_Vertex3f(0.0939574242f, 0.580908775f, 0.f),
    C_Vertex3f(0.0939574242f, 0.580908775f, -1.f),
    C_Normal3f(-0.874112189f, -0.485724181f, 0.f),
    C_Vertex3f(0.0840518475f, 0.59893322f, 0.f),
    C_Vertex3f(0.0840518475f, 0.59893322f, -1.f),
    C_Normal3f(-0.87010783f, -0.492861569f, 0.f),
    C_Vertex3f(0.0730154514f, 0.618596077f, 0.f),
    C_Vertex3f(0.0730154514f, 0.618596077f, -1.f),
    C_Normal3f(-0.867216706f, -0.497930974f, 0.f),
    C_Vertex3f(0.0608482361f, 0.639897346f, 0.f),
    C_Vertex3f(0.0608482361f, 0.639897346f, -1.f),
    C_Normal3f(-0.865145445f, -0.501521051f, 0.f),
    C_Vertex3f(0.0541992188f, 0.651367188f, 0.f),
    C_Vertex3f(0.0541992188f, 0.651367188f, -1.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.f, 0.99999994f, 0.f),
    C_Vertex3f(0.0541992188f, 0.651367188f, 0.f),
    C_Vertex3f(0.0541992188f, 0.651367188f, -1.f),
    C_Vertex3f(0.110351563f, 0.651367188f, -1.f),
    C_Vertex3f(0.110351563f, 0.651367188f, 0.f),
    C_End(),
    C_Begin(GL_QUAD_STRIP),
    C_Normal3f(0.800106883f, 0.599857569f, 0.f),
    C_Vertex3f(0.110351563f, 0.651367188f, 0.f),
    C_Vertex3f(0.110351563f, 0.651367188f, -1.f),
    C_Normal3f(0.812811077f, 0.582527339f, 0.f),
    C_Vertex3f(0.120630264f, 0.637657166f, 0.f),
    C_Vertex3f(0.120630264f, 0.637657166f, -1.f),
    C_Normal3f(0.828677893f, 0.559725761f, 0.f),
    C_Vertex3f(0.139848232f, 0.610209942f, 0.f),
    C_Vertex3f(0.139848232f, 0.610209942f, -1.f),
    C_Normal3f(0.847598672f, 0.530637801f, 0.f),
    C_Vertex3f(0.157726765f, 0.582735538f, 0.f),
    C_Vertex3f(0.157726765f, 0.582735538f, -1.f),
    C_Normal3f(0.866250396f, 0.499610037f, 0.f),
    C_Vertex3f(0.174265862f, 0.555233955f, 0.f),
    C_Vertex3f(0.174265862f, 0.555233955f, -1.f),
    C_Normal3f(0.884468198f, 0.466600388f, 0.f),
    C_Vertex3f(0.189465523f, 0.527705193f, 0.f),
    C_Vertex3f(0.189465523f, 0.527705193f, -1.f),
    C_Normal3f(0.902069449f, 0.431590706f, 0.f),
    C_Vertex3f(0.203325748f, 0.50014925f, 0.f),
    C_Vertex3f(0.203325748f, 0.50014925f, -1.f),
    C_Normal3f(0.918856561f, 0.394591779f, 0.f),
    C_Vertex3f(0.215846539f, 0.472566128f, 0.f),
    C_Vertex3f(0.215846539f, 0.472566128f, -1.f),
    C_Normal3f(0.934527814f, 0.355890036f, 0.f),
    C_Vertex3f(0.227027893f, 0.444955826f, 0.f),
    C_Vertex3f(0.227027893f, 0.444955826f, -1.f),
    C_Normal3f(0.94929719f, 0.314380258f, 0.f),
    C_Vertex3f(0.236158371f, 0.419229507f, 0.f),
    C_Vertex3f(0.236158371f, 0.419229507f, -1.f),
    C_Normal3f(0.962367892f, 0.271750033f, 0.f),
    C_Vertex3f(0.243525028f, 0.395141363f, 0.f),
    C_Vertex3f(0.243525028f, 0.395141363f, -1.f),
    C_Normal3f(0.973204792f, 0.229940414f, 0.f),
    C_Vertex3f(0.249839306f, 0.37078023f, 0.f),
    C_Vertex3f(0.249839306f, 0.37078023f, -1.f),
    C_Normal3f(0.982210875f, 0.187781513f, 0.f),
    C_Vertex3f(0.255101204f, 0.346146107f, 0.f),
    C_Vertex3f(0.255101204f, 0.346146107f, -1.f),
    C_Normal3f(0.989356577f, 0.14551121f, 0.f),
    C_Vertex3f(0.259310722f, 0.321238995f, 0.f),
    C_Vertex3f(0.259310722f, 0.321238995f, -1.f),
    C_Normal3f(0.994643509f, 0.10336525f, 0.f),
    C_Vertex3f(0.262467861f, 0.296058893f, 0.f),
    C_Vertex3f(0.262467861f, 0.296058893f, -1.f),
    C_Normal3f(0.998102665f, 0.0615709201f, 0.f),
    C_Vertex3f(0.26457262f, 0.270605803f, 0.f),
    C_Vertex3f(0.26457262f, 0.270605803f, -1.f),
    C_Normal3f(0.999806404f, 0.0196766835f, 0.f),
    C_Vertex3f(0.265625f, 0.244879723f, 0.f),
    C_Vertex3f(0.265625f, 0.244879723f, -1.f),
    C_Normal3f(0.999692082f, -0.0248123817f, 0.f),
    C_Vertex3f(0.265625f, 0.217132568f, 0.f),
    C_Vertex3f(0.265625f, 0.217132568f, -1.f),
    C_Normal3f(0.997356713f, -0.0726614669f, 0.f),
    C_Vertex3f(0.264210343f, 0.187883139f, 0.f),
    C_Vertex3f(0.264210343f, 0.187883139f, -1.f),
    C_Normal3f(0.992585421f, -0.121548891f, 0.f),
    C_Vertex3f(0.26138103f, 0.158879519f, 0.f),
    C_Vertex3f(0.26138103f, 0.158879519f, -1.f),
    C_Normal3f(0.985377908f, -0.170382962f, 0.f),
    C_Vertex3f(0.25713706f, 0.130121708f, 0.f),
    C_Vertex3f(0.25713706f, 0.130121708f, -1.f),
    C_Normal3f(0.975768507f, -0.218805775f, 0.f),
    C_Vertex3f(0.251478434f, 0.101609707f, 0.f),
    C_Vertex3f(0.251478434f, 0.101609707f, -1.f),
    C_Normal3f(0.963843703f, -0.266468287f, 0.f),
    C_Vertex3f(0.24440515f, 0.0733435154f, 0.f),
    C_Vertex3f(0.24440515f, 0.0733435154f, -1.f),
    C_Normal3f(0.949739039f, -0.313042819f, 0.f),
    C_Vertex3f(0.235917211f, 0.0453231335f, 0.f),
    C_Vertex3f(0.235917211f, 0.0453231335f, -1.f),
    C_Normal3f(0.933631837f, -0.358233869f, 0.f),
    C_Vertex3f(0.226014614f, 0.0175485611f, 0.f),
    C_Vertex3f(0.226014614f, 0.0175485611f, -1.f),
    C_Normal3f(0.919013917f, -0.394225031f, 0.f),
    C_Vertex3f(0.214697361f, -0.00998020172f, 0.f),
    C_Vertex3f(0.214697361f, -0.00998020172f, -1.f),
    C_Normal3f(0.906251848f, -0.422738284f, 0.f),
    C_Vertex3f(0.202771783f, -0.036634922f, 0.f),
    C_Vertex3f(0.202771783f, -0.036634922f, -1.f),
    C_Normal3f(0.892074406f, -0.451888621f, 0.f),
    C_Vertex3f(0.19023788f, -0.0624155998f, 0.f),
    C_Vertex3f(0.19023788f, -0.0624155998f, -1.f),
    C_Normal3f(0.876395822f, -0.481591582f, 0.f),
    C_Vertex3f(0.177095652f, -0.0873222351f, 0.f),
    C_Vertex3f(0.177095652f, -0.0873222351f, -1.f),
    C_Normal3f(0.859137058f, -0.511745512f, 0.f),
    C_Vertex3f(0.163345098f, -0.111354828f, 0.f),
    C_Vertex3f(0.163345098f, -0.111354828f, -1.f),
    C_Normal3f(0.840229392f, -0.542231023f, 0.f),
    C_Vertex3f(0.14898622f, -0.134513378f, 0.f),
    C_Vertex3f(0.14898622f, -0.134513378f, -1.f),
    C_Normal3f(0.819617271f, -0.572911441f, 0.f),
    C_Vertex3f(0.134019017f, -0.156797886f, 0.f),
    C_Vertex3f(0.134019017f, -0.156797886f, -1.f),
    C_Normal3f(0.80110991f, -0.598517179f, 0.f),
    C_Vertex3f(0.118443489f, -0.178208351f, 0.f),
    C_Vertex3f(0.118443489f, -0.178208351f, -1.f),
    C_Normal3f(0.785423994f, -0.618958175f, 0.f),
    C_Vertex3f(0.110351563f, -0.188476563f, 0.f),
    C_Vertex3f(0.110351563f, -0.188476563f, -1.f),
    C_End(),
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.189465523f, 0.527705193f, 0.f),
    C_Vertex3f(0.174265862f, 0.555233955f, 0.f),
    C_Vertex3f(0.177540779f, 0.333638191f, 0.f),
    C_Vertex3f(0.182227135f, 0.292891502f, 0.f),
    C_Vertex3f(0.184570313f, 0.251981735f, 0.f),
    C_Vertex3f(0.19023788f, -0.0624155998f, 0.f),
    C_Vertex3f(0.203325748f, 0.50014925f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.142873764f, 0.474396706f, 0.f),
    C_Vertex3f(0.153230667f, 0.44293499f, 0.f),
    C_Vertex3f(0.157726765f, 0.582735538f, 0.f),
    C_Vertex3f(0.162117004f, 0.4108181f, 0.f),
    C_Vertex3f(0.174265862f, 0.555233955f, 0.f),
    C_Vertex3f(0.170511246f, 0.374221802f, 0.f),
    C_Vertex3f(0.177540779f, 0.333638191f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.139848232f, 0.610209942f, 0.f),
    C_Vertex3f(0.120630264f, 0.637657166f, 0.f),
    C_Vertex3f(0.122271538f, 0.525195122f, 0.f),
    C_Vertex3f(0.131046295f, 0.505203247f, 0.f),
    C_Vertex3f(0.142873764f, 0.474396706f, 0.f),
    C_Vertex3f(0.157726765f, 0.582735538f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.0939574242f, 0.580908775f, 0.f),
    C_Vertex3f(0.102732182f, 0.564522743f, 0.f),
    C_Vertex3f(0.110351563f, 0.651367188f, 0.f),
    C_Vertex3f(0.11037612f, 0.549775124f, 0.f),
    C_Vertex3f(0.120630264f, 0.637657166f, 0.f),
    C_Vertex3f(0.116889238f, 0.536665916f, 0.f),
    C_Vertex3f(0.122271538f, 0.525195122f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.110351563f, 0.651367188f, 0.f),
    C_Vertex3f(0.0541992188f, 0.651367188f, 0.f),
    C_Vertex3f(0.0608482361f, 0.639897346f, 0.f),
    C_Vertex3f(0.0730154514f, 0.618596077f, 0.f),
    C_Vertex3f(0.0840518475f, 0.59893322f, 0.f),
    C_Vertex3f(0.0939574242f, 0.580908775f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.243525028f, 0.395141363f, 0.f),
    C_Vertex3f(0.24440515f, 0.0733435154f, 0.f),
    C_Vertex3f(0.249839306f, 0.37078023f, 0.f),
    C_Vertex3f(0.251478434f, 0.101609707f, 0.f),
    C_Vertex3f(0.255101204f, 0.346146107f, 0.f),
    C_Vertex3f(0.25713706f, 0.130121708f, 0.f),
    C_Vertex3f(0.259310722f, 0.321238995f, 0.f),
    C_Vertex3f(0.26138103f, 0.158879519f, 0.f),
    C_Vertex3f(0.262467861f, 0.296058893f, 0.f),
    C_Vertex3f(0.264210343f, 0.187883139f, 0.f),
    C_Vertex3f(0.26457262f, 0.270605803f, 0.f),
    C_Vertex3f(0.265625f, 0.217132568f, 0.f),
    C_Vertex3f(0.265625f, 0.244879723f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.19023788f, -0.0624155998f, 0.f),
    C_Vertex3f(0.202771783f, -0.036634922f, 0.f),
    C_Vertex3f(0.203325748f, 0.50014925f, 0.f),
    C_Vertex3f(0.214697361f, -0.00998020172f, 0.f),
    C_Vertex3f(0.215846539f, 0.472566128f, 0.f),
    C_Vertex3f(0.226014614f, 0.0175485611f, 0.f),
    C_Vertex3f(0.227027893f, 0.444955826f, 0.f),
    C_Vertex3f(0.235917211f, 0.0453231335f, 0.f),
    C_Vertex3f(0.236158371f, 0.419229507f, 0.f),
    C_Vertex3f(0.24440515f, 0.0733435154f, 0.f),
    C_Vertex3f(0.243525028f, 0.395141363f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.19023788f, -0.0624155998f, 0.f),
    C_Vertex3f(0.184570313f, 0.251981735f, 0.f),
    C_Vertex3f(0.184570313f, 0.218308926f, 0.f),
    C_Vertex3f(0.183551788f, 0.192039609f, 0.f),
    C_Vertex3f(0.18151474f, 0.165773749f, 0.f),
    C_Vertex3f(0.178459167f, 0.139511347f, 0.f),
    C_Vertex3f(0.177095652f, -0.0873222351f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.178459167f, 0.139511347f, 0.f),
    C_Vertex3f(0.174385071f, 0.113252401f, 0.f),
    C_Vertex3f(0.177095652f, -0.0873222351f, 0.f),
    C_Vertex3f(0.16929245f, 0.086996913f, 0.f),
    C_Vertex3f(0.163345098f, -0.111354828f, 0.f),
    C_Vertex3f(0.163181305f, 0.0607448816f, 0.f),
    C_Vertex3f(0.156051636f, 0.0344963074f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.14898622f, -0.134513378f, 0.f),
    C_Vertex3f(0.163345098f, -0.111354828f, 0.f),
    C_Vertex3f(0.156051636f, 0.0344963074f, 0.f),
    C_Vertex3f(0.147903442f, 0.00825119019f, 0.f),
    C_Vertex3f(0.138736725f, -0.0179904699f, 0.f),
    C_Vertex3f(0.134019017f, -0.156797886f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.105125427f, -0.0966947079f, 0.f),
    C_Vertex3f(0.110351563f, -0.188476563f, 0.f),
    C_Vertex3f(0.117347717f, -0.070463419f, 0.f),
    C_Vertex3f(0.118443489f, -0.178208351f, 0.f),
    C_Vertex3f(0.128551483f, -0.044228673f, 0.f),
    C_Vertex3f(0.134019017f, -0.156797886f, 0.f),
    C_Vertex3f(0.138736725f, -0.0179904699f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.110351563f, -0.188476563f, 0.f),
    C_Vertex3f(0.105125427f, -0.0966947079f, 0.f),
    C_Vertex3f(0.091884613f, -0.12292254f, 0.f),
    C_Vertex3f(0.0776252747f, -0.149146914f, 0.f),
    C_Vertex3f(0.0623474121f, -0.175367832f, 0.f),
    C_Vertex3f(0.0541992188f, -0.188476563f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, -1.f),
    C_FrontFace(GL_CW),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.189465523f, 0.527705193f, -1.f),
    C_Vertex3f(0.174265862f, 0.555233955f, -1.f),
    C_Vertex3f(0.177540779f, 0.333638191f, -1.f),
    C_Vertex3f(0.182227135f, 0.292891502f, -1.f),
    C_Vertex3f(0.184570313f, 0.251981735f, -1.f),
    C_Vertex3f(0.19023788f, -0.0624155998f, -1.f),
    C_Vertex3f(0.203325748f, 0.50014925f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.142873764f, 0.474396706f, -1.f),
    C_Vertex3f(0.153230667f, 0.44293499f, -1.f),
    C_Vertex3f(0.157726765f, 0.582735538f, -1.f),
    C_Vertex3f(0.162117004f, 0.4108181f, -1.f),
    C_Vertex3f(0.174265862f, 0.555233955f, -1.f),
    C_Vertex3f(0.170511246f, 0.374221802f, -1.f),
    C_Vertex3f(0.177540779f, 0.333638191f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.139848232f, 0.610209942f, -1.f),
    C_Vertex3f(0.120630264f, 0.637657166f, -1.f),
    C_Vertex3f(0.122271538f, 0.525195122f, -1.f),
    C_Vertex3f(0.131046295f, 0.505203247f, -1.f),
    C_Vertex3f(0.142873764f, 0.474396706f, -1.f),
    C_Vertex3f(0.157726765f, 0.582735538f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.0939574242f, 0.580908775f, -1.f),
    C_Vertex3f(0.102732182f, 0.564522743f, -1.f),
    C_Vertex3f(0.110351563f, 0.651367188f, -1.f),
    C_Vertex3f(0.11037612f, 0.549775124f, -1.f),
    C_Vertex3f(0.120630264f, 0.637657166f, -1.f),
    C_Vertex3f(0.116889238f, 0.536665916f, -1.f),
    C_Vertex3f(0.122271538f, 0.525195122f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.110351563f, 0.651367188f, -1.f),
    C_Vertex3f(0.0541992188f, 0.651367188f, -1.f),
    C_Vertex3f(0.0608482361f, 0.639897346f, -1.f),
    C_Vertex3f(0.0730154514f, 0.618596077f, -1.f),
    C_Vertex3f(0.0840518475f, 0.59893322f, -1.f),
    C_Vertex3f(0.0939574242f, 0.580908775f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.243525028f, 0.395141363f, -1.f),
    C_Vertex3f(0.24440515f, 0.0733435154f, -1.f),
    C_Vertex3f(0.249839306f, 0.37078023f, -1.f),
    C_Vertex3f(0.251478434f, 0.101609707f, -1.f),
    C_Vertex3f(0.255101204f, 0.346146107f, -1.f),
    C_Vertex3f(0.25713706f, 0.130121708f, -1.f),
    C_Vertex3f(0.259310722f, 0.321238995f, -1.f),
    C_Vertex3f(0.26138103f, 0.158879519f, -1.f),
    C_Vertex3f(0.262467861f, 0.296058893f, -1.f),
    C_Vertex3f(0.264210343f, 0.187883139f, -1.f),
    C_Vertex3f(0.26457262f, 0.270605803f, -1.f),
    C_Vertex3f(0.265625f, 0.217132568f, -1.f),
    C_Vertex3f(0.265625f, 0.244879723f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.19023788f, -0.0624155998f, -1.f),
    C_Vertex3f(0.202771783f, -0.036634922f, -1.f),
    C_Vertex3f(0.203325748f, 0.50014925f, -1.f),
    C_Vertex3f(0.214697361f, -0.00998020172f, -1.f),
    C_Vertex3f(0.215846539f, 0.472566128f, -1.f),
    C_Vertex3f(0.226014614f, 0.0175485611f, -1.f),
    C_Vertex3f(0.227027893f, 0.444955826f, -1.f),
    C_Vertex3f(0.235917211f, 0.0453231335f, -1.f),
    C_Vertex3f(0.236158371f, 0.419229507f, -1.f),
    C_Vertex3f(0.24440515f, 0.0733435154f, -1.f),
    C_Vertex3f(0.243525028f, 0.395141363f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.19023788f, -0.0624155998f, -1.f),
    C_Vertex3f(0.184570313f, 0.251981735f, -1.f),
    C_Vertex3f(0.184570313f, 0.218308926f, -1.f),
    C_Vertex3f(0.183551788f, 0.192039609f, -1.f),
    C_Vertex3f(0.18151474f, 0.165773749f, -1.f),
    C_Vertex3f(0.178459167f, 0.139511347f, -1.f),
    C_Vertex3f(0.177095652f, -0.0873222351f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.178459167f, 0.139511347f, -1.f),
    C_Vertex3f(0.174385071f, 0.113252401f, -1.f),
    C_Vertex3f(0.177095652f, -0.0873222351f, -1.f),
    C_Vertex3f(0.16929245f, 0.086996913f, -1.f),
    C_Vertex3f(0.163345098f, -0.111354828f, -1.f),
    C_Vertex3f(0.163181305f, 0.0607448816f, -1.f),
    C_Vertex3f(0.156051636f, 0.0344963074f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.14898622f, -0.134513378f, -1.f),
    C_Vertex3f(0.163345098f, -0.111354828f, -1.f),
    C_Vertex3f(0.156051636f, 0.0344963074f, -1.f),
    C_Vertex3f(0.147903442f, 0.00825119019f, -1.f),
    C_Vertex3f(0.138736725f, -0.0179904699f, -1.f),
    C_Vertex3f(0.134019017f, -0.156797886f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.105125427f, -0.0966947079f, -1.f),
    C_Vertex3f(0.110351563f, -0.188476563f, -1.f),
    C_Vertex3f(0.117347717f, -0.070463419f, -1.f),
    C_Vertex3f(0.118443489f, -0.178208351f, -1.f),
    C_Vertex3f(0.128551483f, -0.044228673f, -1.f),
    C_Vertex3f(0.134019017f, -0.156797886f, -1.f),
    C_Vertex3f(0.138736725f, -0.0179904699f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.110351563f, -0.188476563f, -1.f),
    C_Vertex3f(0.105125427f, -0.0966947079f, -1.f),
    C_Vertex3f(0.091884613f, -0.12292254f, -1.f),
    C_Vertex3f(0.0776252747f, -0.149146914f, -1.f),
    C_Vertex3f(0.0623474121f, -0.175367832f, -1.f),
    C_Vertex3f(0.0541992188f, -0.188476563f, -1.f),
    C_End(),
    C_Translatef(0.297851563f, 0.f, 0.f),
};
static const Call char_42[] = {
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_FrontFace(GL_CW),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.951283157f, 0.308318704f, 0.f),
    C_Vertex3f(0.0278320313f, 0.522949219f, 0.f),
    C_Vertex3f(0.0278320313f, 0.522949219f, -1.f),
    C_Vertex3f(0.0479354858f, 0.584976196f, -1.f),
    C_Vertex3f(0.0479354858f, 0.584976196f, 0.f),
    C_End(),
    C_Begin(GL_QUAD_STRIP),
    C_Normal3f(0.332061499f, 0.943257689f, 0.f),
    C_Vertex3f(0.0479354858f, 0.584976196f, 0.f),
    C_Vertex3f(0.0479354858f, 0.584976196f, -1.f),
    C_Normal3f(0.33923775f, 0.94070065f, 0.f),
    C_Vertex3f(0.0566205978f, 0.581918716f, 0.f),
    C_Vertex3f(0.0566205978f, 0.581918716f, -1.f),
    C_Normal3f(0.349135071f, 0.937072396f, 0.f),
    C_Vertex3f(0.0728032589f, 0.57600832f, 0.f),
    C_Vertex3f(0.0728032589f, 0.57600832f, -1.f),
    C_Normal3f(0.362617135f, 0.931938171f, 0.f),
    C_Vertex3f(0.087798357f, 0.570302486f, 0.f),
    C_Vertex3f(0.087798357f, 0.570302486f, -1.f),
    C_Normal3f(0.378234446f, 0.925709784f, 0.f),
    C_Vertex3f(0.101605892f, 0.564801216f, 0.f),
    C_Vertex3f(0.101605892f, 0.564801216f, -1.f),
    C_Normal3f(0.396519512f, 0.918026328f, 0.f),
    C_Vertex3f(0.114225864f, 0.559504509f, 0.f),
    C_Vertex3f(0.114225864f, 0.559504509f, -1.f),
    C_Normal3f(0.418188751f, 0.908360124f, 0.f),
    C_Vertex3f(0.125658274f, 0.554412365f, 0.f),
    C_Vertex3f(0.125658274f, 0.554412365f, -1.f),
    C_Normal3f(0.444223225f, 0.895916164f, 0.f),
    C_Vertex3f(0.13590312f, 0.549524784f, 0.f),
    C_Vertex3f(0.13590312f, 0.549524784f, -1.f),
    C_Normal3f(0.470223367f, 0.882547379f, 0.f),
    C_Vertex3f(0.144960403f, 0.544841766f, 0.f),
    C_Vertex3f(0.144960403f, 0.544841766f, -1.f),
    C_Normal3f(0.494595587f, 0.86912322f, 0.f),
    C_Vertex3f(0.148895264f, 0.542602539f, 0.f),
    C_Vertex3f(0.148895264f, 0.542602539f, -1.f),
    C_End(),
    C_Begin(GL_QUAD_STRIP),
    C_Normal3f(-0.994503856f, -0.104699768f, 0.f),
    C_Vertex3f(0.148895264f, 0.542602539f, 0.f),
    C_Vertex3f(0.148895264f, 0.542602539f, -1.f),
    C_Normal3f(-0.994809568f, -0.101754352f, 0.f),
    C_Vertex3f(0.147854805f, 0.552485466f, 0.f),
    C_Vertex3f(0.147854805f, 0.552485466f, -1.f),
    C_Normal3f(-0.995227695f, -0.0975798741f, 0.f),
    C_Vertex3f(0.146020412f, 0.570708752f, 0.f),
    C_Vertex3f(0.146020412f, 0.570708752f, -1.f),
    C_Normal3f(-0.995789289f, -0.091671288f, 0.f),
    C_Vertex3f(0.144432545f, 0.587389469f, 0.f),
    C_Vertex3f(0.144432545f, 0.587389469f, -1.f),
    C_Normal3f(-0.996425033f, -0.0844809189f, 0.f),
    C_Vertex3f(0.143091202f, 0.602527618f, 0.f),
    C_Vertex3f(0.143091202f, 0.602527618f, -1.f),
    C_Normal3f(-0.997142613f, -0.0755425096f, 0.f),
    C_Vertex3f(0.141996384f, 0.616123199f, 0.f),
    C_Vertex3f(0.141996384f, 0.616123199f, -1.f),
    C_Normal3f(-0.997941375f, -0.0641336367f, 0.f),
    C_Vertex3f(0.14114809f, 0.628176212f, 0.f),
    C_Vertex3f(0.14114809f, 0.628176212f, -1.f),
    C_Normal3f(-0.998795211f, -0.0490729772f, 0.f),
    C_Vertex3f(0.140546322f, 0.638686657f, 0.f),
    C_Vertex3f(0.140546322f, 0.638686657f, -1.f),
    C_Normal3f(-0.999478757f, -0.0322848968f, 0.f),
    C_Vertex3f(0.140191078f, 0.647654533f, 0.f),
    C_Vertex3f(0.140191078f, 0.647654533f, -1.f),
    C_Normal3f(-0.999892831f, -0.0146400956f, 0.f),
    C_Vertex3f(0.140136719f, 0.651367188f, 0.f),
    C_Vertex3f(0.140136719f, 0.651367188f, -1.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.140136719f, 0.651367188f, 0.f),
    C_Vertex3f(0.140136719f, 0.651367188f, -1.f),
    C_Vertex3f(0.203613281f, 0.651367188f, -1.f),
    C_Vertex3f(0.203613281f, 0.651367188f, 0.f),
    C_End(),
    C_Begin(GL_QUAD_STRIP),
    C_Normal3f(0.999539852f, -0.030331837f, 0.f),
    C_Vertex3f(0.203613281f, 0.651367188f, 0.f),
    C_Vertex3f(0.203613281f, 0.651367188f, -1.f),
    C_Normal3f(0.998520195f, -0.0543810278f, 0.f),
    C_Vertex3f(0.203285217f, 0.640556335f, 0.f),
    C_Vertex3f(0.203285217f, 0.640556335f, -1.f),
    C_Normal3f(0.996830523f, -0.0795542076f, 0.f),
    C_Vertex3f(0.201698303f, 0.616205215f, 0.f),
    C_Vertex3f(0.201698303f, 0.616205215f, -1.f),
    C_Normal3f(0.994545937f, -0.104299456f, 0.f),
    C_Vertex3f(0.199180603f, 0.58912468f, 0.f),
    C_Vertex3f(0.199180603f, 0.58912468f, -1.f),
    C_Normal3f(0.99259752f, -0.12145032f, 0.f),
    C_Vertex3f(0.195732117f, 0.559314728f, 0.f),
    C_Vertex3f(0.195732117f, 0.559314728f, -1.f),
    C_Normal3f(0.991064847f, -0.133381292f, 0.f),
    C_Vertex3f(0.19354248f, 0.543045044f, 0.f),
    C_Vertex3f(0.19354248f, 0.543045044f, -1.f),
    C_End(),
    C_Begin(GL_QUAD_STRIP),
    C_Normal3f(-0.45011425f, 0.892971039f, 0.f),
    C_Vertex3f(0.19354248f, 0.543045044f, 0.f),
    C_Vertex3f(0.19354248f, 0.543045044f, -1.f),
    C_Normal3f(-0.424185932f, 0.905575097f, 0.f),
    C_Vertex3f(0.204807281f, 0.548723221f, 0.f),
    C_Vertex3f(0.204807281f, 0.548723221f, -1.f),
    C_Normal3f(-0.393663138f, 0.919254839f, 0.f),
    C_Vertex3f(0.22897625f, 0.559642792f, 0.f),
    C_Vertex3f(0.22897625f, 0.559642792f, -1.f),
    C_Normal3f(-0.35967654f, 0.933077037f, 0.f),
    C_Vertex3f(0.254784584f, 0.57012558f, 0.f),
    C_Vertex3f(0.254784584f, 0.57012558f, -1.f),
    C_Normal3f(-0.333422601f, 0.942777455f, 0.f),
    C_Vertex3f(0.282232285f, 0.580171585f, 0.f),
    C_Vertex3f(0.282232285f, 0.580171585f, -1.f),
    C_Normal3f(-0.313686252f, 0.949526668f, 0.f),
    C_Vertex3f(0.296775818f, 0.584976196f, 0.f),
    C_Vertex3f(0.296775818f, 0.584976196f, -1.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(0.951214433f, 0.30853042f, 0.f),
    C_Vertex3f(0.296775818f, 0.584976196f, 0.f),
    C_Vertex3f(0.296775818f, 0.584976196f, -1.f),
    C_Vertex3f(0.316894531f, 0.522949219f, -1.f),
    C_Vertex3f(0.316894531f, 0.522949219f, 0.f),
    C_End(),
    C_Begin(GL_QUAD_STRIP),
    C_Normal3f(0.313409209f, -0.94961822f, 0.f),
    C_Vertex3f(0.316894531f, 0.522949219f, 0.f),
    C_Vertex3f(0.316894531f, 0.522949219f, -1.f),
    C_Normal3f(0.283221424f, -0.95905453f, 0.f),
    C_Vertex3f(0.303007126f, 0.51836586f, 0.f),
    C_Vertex3f(0.303007126f, 0.51836586f, -1.f),
    C_Normal3f(0.243680745f, -0.969855428f, 0.f),
    C_Vertex3f(0.275506973f, 0.510726929f, 0.f),
    C_Vertex3f(0.275506973f, 0.510726929f, -1.f),
    C_Normal3f(0.193664536f, -0.981067896f, 0.f),
    C_Vertex3f(0.248281479f, 0.504615784f, 0.f),
    C_Vertex3f(0.248281479f, 0.504615784f, -1.f),
    C_Normal3f(0.149967596f, -0.988690853f, 0.f),
    C_Vertex3f(0.221330643f, 0.500032425f, 0.f),
    C_Vertex3f(0.221330643f, 0.500032425f, -1.f),
    C_Normal3f(0.113799013f, -0.993503749f, 0.f),
    C_Vertex3f(0.207992554f, 0.498504639f, 0.f),
    C_Vertex3f(0.207992554f, 0.498504639f, -1.f),
    C_End(),
    C_Begin(GL_QUAD_STRIP),
    C_Normal3f(0.655193746f, 0.755460858f, 0.f),
    C_Vertex3f(0.207992554f, 0.498504639f, 0.f),
    C_Vertex3f(0.207992554f, 0.498504639f, -1.f),
    C_Normal3f(0.676153302f, 0.736761034f, 0.f),
    C_Vertex3f(0.211326599f, 0.495613098f, 0.f),
    C_Vertex3f(0.211326599f, 0.495613098f, -1.f),
    C_Normal3f(0.697145641f, 0.716929495f, 0.f),
    C_Vertex3f(0.218678474f, 0.488697767f, 0.f),
    C_Vertex3f(0.218678474f, 0.488697767f, -1.f),
    C_Normal3f(0.716865301f, 0.697211742f, 0.f),
    C_Vertex3f(0.226714134f, 0.480650187f, 0.f),
    C_Vertex3f(0.226714134f, 0.480650187f, -1.f),
    C_Normal3f(0.732361734f, 0.680915892f, 0.f),
    C_Vertex3f(0.235433578f, 0.471470356f, 0.f),
    C_Vertex3f(0.235433578f, 0.471470356f, -1.f),
    C_Normal3f(0.744833231f, 0.667250693f, 0.f),
    C_Vertex3f(0.244836807f, 0.461158276f, 0.f),
    C_Vertex3f(0.244836807f, 0.461158276f, -1.f),
    C_Normal3f(0.755071282f, 0.655642688f, 0.f),
    C_Vertex3f(0.25492382f, 0.449713945f, 0.f),
    C_Vertex3f(0.25492382f, 0.449713945f, -1.f),
    C_Normal3f(0.763617218f, 0.645669341f, 0.f),
    C_Vertex3f(0.265694618f, 0.437137365f, 0.f),
    C_Vertex3f(0.265694618f, 0.437137365f, -1.f),
    C_Normal3f(0.769724905f, 0.638375819f, 0.f),
    C_Vertex3f(0.2771492f, 0.423428535f, 0.f),
    C_Vertex3f(0.2771492f, 0.423428535f, -1.f),
    C_Normal3f(0.774068117f, 0.633102357f, 0.f),
    C_Vertex3f(0.283218384f, 0.416007996f, 0.f),
    C_Vertex3f(0.283218384f, 0.416007996f, -1.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(0.577200294f, -0.816602528f, 0.f),
    C_Vertex3f(0.283218384f, 0.416007996f, 0.f),
    C_Vertex3f(0.283218384f, 0.416007996f, -1.f),
    C_Vertex3f(0.230728149f, 0.37890625f, -1.f),
    C_Vertex3f(0.230728149f, 0.37890625f, 0.f),
    C_End(),
    C_Begin(GL_QUAD_STRIP),
    C_Normal3f(-0.805525959f, -0.592560589f, 0.f),
    C_Vertex3f(0.230728149f, 0.37890625f, 0.f),
    C_Vertex3f(0.230728149f, 0.37890625f, -1.f),
    C_Normal3f(-0.82062155f, -0.571471989f, 0.f),
    C_Vertex3f(0.224386215f, 0.387527466f, 0.f),
    C_Vertex3f(0.224386215f, 0.387527466f, -1.f),
    C_Normal3f(-0.835455954f, -0.549557388f, 0.f),
    C_Vertex3f(0.210551262f, 0.407879829f, 0.f),
    C_Vertex3f(0.210551262f, 0.407879829f, -1.f),
    C_Normal3f(-0.849128366f, -0.5281865f, 0.f),
    C_Vertex3f(0.195565224f, 0.431342125f, 0.f),
    C_Vertex3f(0.195565224f, 0.431342125f, -1.f),
    C_Normal3f(-0.85810256f, -0.513478279f, 0.f),
    C_Vertex3f(0.179428101f, 0.457914352f, 0.f),
    C_Vertex3f(0.179428101f, 0.457914352f, -1.f),
    C_Normal3f(-0.864113033f, -0.503297806f, 0.f),
    C_Vertex3f(0.170783997f, 0.472755432f, 0.f),
    C_Vertex3f(0.170783997f, 0.472755432f, -1.f),
    C_End(),
    C_Begin(GL_QUAD_STRIP),
    C_Normal3f(0.884908736f, -0.465764523f, 0.f),
    C_Vertex3f(0.170783997f, 0.472755432f, 0.f),
    C_Vertex3f(0.170783997f, 0.472755432f, -1.f),
    C_Normal3f(0.87683785f, -0.480786294f, 0.f),
    C_Vertex3f(0.162685394f, 0.457368851f, 0.f),
    C_Vertex3f(0.162685394f, 0.457368851f, -1.f),
    C_Normal3f(0.864375889f, -0.502846181f, 0.f),
    C_Vertex3f(0.147478104f, 0.430251122f, 0.f),
    C_Vertex3f(0.147478104f, 0.430251122f, -1.f),
    C_Normal3f(0.844456851f, -0.53562361f, 0.f),
    C_Vertex3f(0.133260727f, 0.406788826f, 0.f),
    C_Vertex3f(0.133260727f, 0.406788826f, -1.f),
    C_Normal3f(0.82159996f, -0.570064545f, 0.f),
    C_Vertex3f(0.120033264f, 0.386981964f, 0.f),
    C_Vertex3f(0.120033264f, 0.386981964f, -1.f),
    C_Normal3f(0.797053754f, -0.603908479f, 0.f),
    C_Vertex3f(0.11391449f, 0.37890625f, 0.f),
    C_Vertex3f(0.11391449f, 0.37890625f, -1.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.584086359f, -0.811691523f, 0.f),
    C_Vertex3f(0.11391449f, 0.37890625f, 0.f),
    C_Vertex3f(0.11391449f, 0.37890625f, -1.f),
    C_Vertex3f(0.0623550415f, 0.416007996f, -1.f),
    C_Vertex3f(0.0623550415f, 0.416007996f, 0.f),
    C_End(),
    C_Begin(GL_QUAD_STRIP),
    C_Normal3f(-0.776256204f, 0.630417585f, 0.f),
    C_Vertex3f(0.0623550415f, 0.416007996f, 0.f),
    C_Vertex3f(0.0623550415f, 0.416007996f, -1.f),
    C_Normal3f(-0.773287654f, 0.634055316f, 0.f),
    C_Vertex3f(0.0686912537f, 0.423810005f, 0.f),
    C_Vertex3f(0.0686912537f, 0.423810005f, -1.f),
    C_Normal3f(-0.769046605f, 0.6391927f, 0.f),
    C_Vertex3f(0.0804619789f, 0.43809104f, 0.f),
    C_Vertex3f(0.0804619789f, 0.43809104f, -1.f),
    C_Normal3f(-0.762976229f, 0.646426558f, 0.f),
    C_Vertex3f(0.0913310051f, 0.451049089f, 0.f),
    C_Vertex3f(0.0913310051f, 0.451049089f, -1.f),
    C_Normal3f(-0.755482972f, 0.655168295f, 0.f),
    C_Vertex3f(0.101298332f, 0.462684155f, 0.f),
    C_Vertex3f(0.101298332f, 0.462684155f, -1.f),
    C_Normal3f(-0.746007502f, 0.665937603f, 0.f),
    C_Vertex3f(0.11036396f, 0.472996235f, 0.f),
    C_Vertex3f(0.11036396f, 0.472996235f, -1.f),
    C_Normal3f(-0.733658016f, 0.679518759f, 0.f),
    C_Vertex3f(0.118527889f, 0.481985331f, 0.f),
    C_Vertex3f(0.118527889f, 0.481985331f, -1.f),
    C_Normal3f(-0.716926634f, 0.697148621f, 0.f),
    C_Vertex3f(0.125790119f, 0.489651442f, 0.f),
    C_Vertex3f(0.125790119f, 0.489651442f, -1.f),
    C_Normal3f(-0.697716177f, 0.716374338f, 0.f),
    C_Vertex3f(0.13215065f, 0.495994568f, 0.f),
    C_Vertex3f(0.13215065f, 0.495994568f, -1.f),
    C_Normal3f(-0.676911652f, 0.736064255f, 0.f),
    C_Vertex3f(0.134880066f, 0.498504639f, 0.f),
    C_Vertex3f(0.134880066f, 0.498504639f, -1.f),
    C_End(),
    C_Begin(GL_QUAD_STRIP),
    C_Normal3f(-0.190054953f, -0.981773436f, 0.f),
    C_Vertex3f(0.134880066f, 0.498504639f, 0.f),
    C_Vertex3f(0.134880066f, 0.498504639f, -1.f),
    C_Normal3f(-0.211467117f, -0.977385163f, 0.f),
    C_Vertex3f(0.106700897f, 0.503959656f, 0.f),
    C_Vertex3f(0.106700897f, 0.503959656f, -1.f),
    C_Normal3f(-0.234084293f, -0.972216308f, 0.f),
    C_Vertex3f(0.0531768799f, 0.516181946f, 0.f),
    C_Vertex3f(0.0531768799f, 0.516181946f, -1.f),
    C_Normal3f(-0.257970363f, -0.966152847f, 0.f),
    C_Vertex3f(0.0278320313f, 0.522949219f, 0.f),
    C_Vertex3f(0.0278320313f, 0.522949219f, -1.f),
    C_End(),
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.134880066f, 0.498504639f, 0.f),
    C_Vertex3f(0.13215065f, 0.495994568f, 0.f),
    C_Vertex3f(0.133260727f, 0.406788826f, 0.f),
    C_Vertex3f(0.147478104f, 0.430251122f, 0.f),
    C_Vertex3f(0.13590312f, 0.549524784f, 0.f),
    C_Vertex3f(0.125658274f, 0.554412365f, 0.f),
    C_Vertex3f(0.114225864f, 0.559504509f, 0.f),
    C_Vertex3f(0.106700897f, 0.503959656f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.106700897f, 0.503959656f, 0.f),
    C_Vertex3f(0.114225864f, 0.559504509f, 0.f),
    C_Vertex3f(0.101605892f, 0.564801216f, 0.f),
    C_Vertex3f(0.087798357f, 0.570302486f, 0.f),
    C_Vertex3f(0.0728032589f, 0.57600832f, 0.f),
    C_Vertex3f(0.0566205978f, 0.581918716f, 0.f),
    C_Vertex3f(0.0531768799f, 0.516181946f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.0479354858f, 0.584976196f, 0.f),
    C_Vertex3f(0.0278320313f, 0.522949219f, 0.f),
    C_Vertex3f(0.0531768799f, 0.516181946f, 0.f),
    C_Vertex3f(0.0566205978f, 0.581918716f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.203613281f, 0.651367188f, 0.f),
    C_Vertex3f(0.140136719f, 0.651367188f, 0.f),
    C_Vertex3f(0.140191078f, 0.647654533f, 0.f),
    C_Vertex3f(0.140546322f, 0.638686657f, 0.f),
    C_Vertex3f(0.14114809f, 0.628176212f, 0.f),
    C_Vertex3f(0.141996384f, 0.616123199f, 0.f),
    C_Vertex3f(0.143091202f, 0.602527618f, 0.f),
    C_Vertex3f(0.144432545f, 0.587389469f, 0.f),
    C_Vertex3f(0.146020412f, 0.570708752f, 0.f),
    C_Vertex3f(0.147854805f, 0.552485466f, 0.f),
    C_Vertex3f(0.148895264f, 0.542602539f, 0.f),
    C_Vertex3f(0.162685394f, 0.457368851f, 0.f),
    C_Vertex3f(0.170783997f, 0.472755432f, 0.f),
    C_Vertex3f(0.179428101f, 0.457914352f, 0.f),
    C_Vertex3f(0.19354248f, 0.543045044f, 0.f),
    C_Vertex3f(0.195732117f, 0.559314728f, 0.f),
    C_Vertex3f(0.199180603f, 0.58912468f, 0.f),
    C_Vertex3f(0.201698303f, 0.616205215f, 0.f),
    C_Vertex3f(0.203285217f, 0.640556335f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.283218384f, 0.416007996f, 0.f),
    C_Vertex3f(0.2771492f, 0.423428535f, 0.f),
    C_Vertex3f(0.265694618f, 0.437137365f, 0.f),
    C_Vertex3f(0.25492382f, 0.449713945f, 0.f),
    C_Vertex3f(0.244836807f, 0.461158276f, 0.f),
    C_Vertex3f(0.235433578f, 0.471470356f, 0.f),
    C_Vertex3f(0.230728149f, 0.37890625f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.226714134f, 0.480650187f, 0.f),
    C_Vertex3f(0.218678474f, 0.488697767f, 0.f),
    C_Vertex3f(0.224386215f, 0.387527466f, 0.f),
    C_Vertex3f(0.230728149f, 0.37890625f, 0.f),
    C_Vertex3f(0.235433578f, 0.471470356f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.22897625f, 0.559642792f, 0.f),
    C_Vertex3f(0.204807281f, 0.548723221f, 0.f),
    C_Vertex3f(0.207992554f, 0.498504639f, 0.f),
    C_Vertex3f(0.210551262f, 0.407879829f, 0.f),
    C_Vertex3f(0.211326599f, 0.495613098f, 0.f),
    C_Vertex3f(0.224386215f, 0.387527466f, 0.f),
    C_Vertex3f(0.218678474f, 0.488697767f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.195565224f, 0.431342125f, 0.f),
    C_Vertex3f(0.210551262f, 0.407879829f, 0.f),
    C_Vertex3f(0.204807281f, 0.548723221f, 0.f),
    C_Vertex3f(0.19354248f, 0.543045044f, 0.f),
    C_Vertex3f(0.179428101f, 0.457914352f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.207992554f, 0.498504639f, 0.f),
    C_Vertex3f(0.221330643f, 0.500032425f, 0.f),
    C_Vertex3f(0.22897625f, 0.559642792f, 0.f),
    C_Vertex3f(0.248281479f, 0.504615784f, 0.f),
    C_Vertex3f(0.254784584f, 0.57012558f, 0.f),
    C_Vertex3f(0.275506973f, 0.510726929f, 0.f),
    C_Vertex3f(0.282232285f, 0.580171585f, 0.f),
    C_Vertex3f(0.303007126f, 0.51836586f, 0.f),
    C_Vertex3f(0.296775818f, 0.584976196f, 0.f),
    C_Vertex3f(0.316894531f, 0.522949219f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.147478104f, 0.430251122f, 0.f),
    C_Vertex3f(0.162685394f, 0.457368851f, 0.f),
    C_Vertex3f(0.148895264f, 0.542602539f, 0.f),
    C_Vertex3f(0.144960403f, 0.544841766f, 0.f),
    C_Vertex3f(0.13590312f, 0.549524784f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.11036396f, 0.472996235f, 0.f),
    C_Vertex3f(0.11391449f, 0.37890625f, 0.f),
    C_Vertex3f(0.118527889f, 0.481985331f, 0.f),
    C_Vertex3f(0.120033264f, 0.386981964f, 0.f),
    C_Vertex3f(0.125790119f, 0.489651442f, 0.f),
    C_Vertex3f(0.133260727f, 0.406788826f, 0.f),
    C_Vertex3f(0.13215065f, 0.495994568f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.11391449f, 0.37890625f, 0.f),
    C_Vertex3f(0.11036396f, 0.472996235f, 0.f),
    C_Vertex3f(0.101298332f, 0.462684155f, 0.f),
    C_Vertex3f(0.0913310051f, 0.451049089f, 0.f),
    C_Vertex3f(0.0804619789f, 0.43809104f, 0.f),
    C_Vertex3f(0.0686912537f, 0.423810005f, 0.f),
    C_Vertex3f(0.0623550415f, 0.416007996f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, -1.f),
    C_FrontFace(GL_CW),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.134880066f, 0.498504639f, -1.f),
    C_Vertex3f(0.13215065f, 0.495994568f, -1.f),
    C_Vertex3f(0.133260727f, 0.406788826f, -1.f),
    C_Vertex3f(0.147478104f, 0.430251122f, -1.f),
    C_Vertex3f(0.13590312f, 0.549524784f, -1.f),
    C_Vertex3f(0.125658274f, 0.554412365f, -1.f),
    C_Vertex3f(0.114225864f, 0.559504509f, -1.f),
    C_Vertex3f(0.106700897f, 0.503959656f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.106700897f, 0.503959656f, -1.f),
    C_Vertex3f(0.114225864f, 0.559504509f, -1.f),
    C_Vertex3f(0.101605892f, 0.564801216f, -1.f),
    C_Vertex3f(0.087798357f, 0.570302486f, -1.f),
    C_Vertex3f(0.0728032589f, 0.57600832f, -1.f),
    C_Vertex3f(0.0566205978f, 0.581918716f, -1.f),
    C_Vertex3f(0.0531768799f, 0.516181946f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.0479354858f, 0.584976196f, -1.f),
    C_Vertex3f(0.0278320313f, 0.522949219f, -1.f),
    C_Vertex3f(0.0531768799f, 0.516181946f, -1.f),
    C_Vertex3f(0.0566205978f, 0.581918716f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.203613281f, 0.651367188f, -1.f),
    C_Vertex3f(0.140136719f, 0.651367188f, -1.f),
    C_Vertex3f(0.140191078f, 0.647654533f, -1.f),
    C_Vertex3f(0.140546322f, 0.638686657f, -1.f),
    C_Vertex3f(0.14114809f, 0.628176212f, -1.f),
    C_Vertex3f(0.141996384f, 0.616123199f, -1.f),
    C_Vertex3f(0.143091202f, 0.602527618f, -1.f),
    C_Vertex3f(0.144432545f, 0.587389469f, -1.f),
    C_Vertex3f(0.146020412f, 0.570708752f, -1.f),
    C_Vertex3f(0.147854805f, 0.552485466f, -1.f),
    C_Vertex3f(0.148895264f, 0.542602539f, -1.f),
    C_Vertex3f(0.162685394f, 0.457368851f, -1.f),
    C_Vertex3f(0.170783997f, 0.472755432f, -1.f),
    C_Vertex3f(0.179428101f, 0.457914352f, -1.f),
    C_Vertex3f(0.19354248f, 0.543045044f, -1.f),
    C_Vertex3f(0.195732117f, 0.559314728f, -1.f),
    C_Vertex3f(0.199180603f, 0.58912468f, -1.f),
    C_Vertex3f(0.201698303f, 0.616205215f, -1.f),
    C_Vertex3f(0.203285217f, 0.640556335f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.283218384f, 0.416007996f, -1.f),
    C_Vertex3f(0.2771492f, 0.423428535f, -1.f),
    C_Vertex3f(0.265694618f, 0.437137365f, -1.f),
    C_Vertex3f(0.25492382f, 0.449713945f, -1.f),
    C_Vertex3f(0.244836807f, 0.461158276f, -1.f),
    C_Vertex3f(0.235433578f, 0.471470356f, -1.f),
    C_Vertex3f(0.230728149f, 0.37890625f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.226714134f, 0.480650187f, -1.f),
    C_Vertex3f(0.218678474f, 0.488697767f, -1.f),
    C_Vertex3f(0.224386215f, 0.387527466f, -1.f),
    C_Vertex3f(0.230728149f, 0.37890625f, -1.f),
    C_Vertex3f(0.235433578f, 0.471470356f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.22897625f, 0.559642792f, -1.f),
    C_Vertex3f(0.204807281f, 0.548723221f, -1.f),
    C_Vertex3f(0.207992554f, 0.498504639f, -1.f),
    C_Vertex3f(0.210551262f, 0.407879829f, -1.f),
    C_Vertex3f(0.211326599f, 0.495613098f, -1.f),
    C_Vertex3f(0.224386215f, 0.387527466f, -1.f),
    C_Vertex3f(0.218678474f, 0.488697767f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.195565224f, 0.431342125f, -1.f),
    C_Vertex3f(0.210551262f, 0.407879829f, -1.f),
    C_Vertex3f(0.204807281f, 0.548723221f, -1.f),
    C_Vertex3f(0.19354248f, 0.543045044f, -1.f),
    C_Vertex3f(0.179428101f, 0.457914352f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.207992554f, 0.498504639f, -1.f),
    C_Vertex3f(0.221330643f, 0.500032425f, -1.f),
    C_Vertex3f(0.22897625f, 0.559642792f, -1.f),
    C_Vertex3f(0.248281479f, 0.504615784f, -1.f),
    C_Vertex3f(0.254784584f, 0.57012558f, -1.f),
    C_Vertex3f(0.275506973f, 0.510726929f, -1.f),
    C_Vertex3f(0.282232285f, 0.580171585f, -1.f),
    C_Vertex3f(0.303007126f, 0.51836586f, -1.f),
    C_Vertex3f(0.296775818f, 0.584976196f, -1.f),
    C_Vertex3f(0.316894531f, 0.522949219f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.147478104f, 0.430251122f, -1.f),
    C_Vertex3f(0.162685394f, 0.457368851f, -1.f),
    C_Vertex3f(0.148895264f, 0.542602539f, -1.f),
    C_Vertex3f(0.144960403f, 0.544841766f, -1.f),
    C_Vertex3f(0.13590312f, 0.549524784f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.11036396f, 0.472996235f, -1.f),
    C_Vertex3f(0.11391449f, 0.37890625f, -1.f),
    C_Vertex3f(0.118527889f, 0.481985331f, -1.f),
    C_Vertex3f(0.120033264f, 0.386981964f, -1.f),
    C_Vertex3f(0.125790119f, 0.489651442f, -1.f),
    C_Vertex3f(0.133260727f, 0.406788826f, -1.f),
    C_Vertex3f(0.13215065f, 0.495994568f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.11391449f, 0.37890625f, -1.f),
    C_Vertex3f(0.11036396f, 0.472996235f, -1.f),
    C_Vertex3f(0.101298332f, 0.462684155f, -1.f),
    C_Vertex3f(0.0913310051f, 0.451049089f, -1.f),
    C_Vertex3f(0.0804619789f, 0.43809104f, -1.f),
    C_Vertex3f(0.0686912537f, 0.423810005f, -1.f),
    C_Vertex3f(0.0623550415f, 0.416007996f, -1.f),
    C_End(),
    C_Translatef(0.348144531f, 0.f, 0.f),
};
static const Call char_43[] = {
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_FrontFace(GL_CW),
    C_Begin(GL_QUADS),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.224121094f, 0.103515625f, 0.f),
    C_Vertex3f(0.224121094f, 0.103515625f, -1.f),
    C_Vertex3f(0.224121094f, 0.279296875f, -1.f),
    C_Vertex3f(0.224121094f, 0.279296875f, 0.f),
    C_Normal3f(-0.f, -1.f, 0.f),
    C_Vertex3f(0.224121094f, 0.279296875f, 0.f),
    C_Vertex3f(0.224121094f, 0.279296875f, -1.f),
    C_Vertex3f(0.0498046875f, 0.279296875f, -1.f),
    C_Vertex3f(0.0498046875f, 0.279296875f, 0.f),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.0498046875f, 0.279296875f, 0.f),
    C_Vertex3f(0.0498046875f, 0.279296875f, -1.f),
    C_Vertex3f(0.0498046875f, 0.352539063f, -1.f),
    C_Vertex3f(0.0498046875f, 0.352539063f, 0.f),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.0498046875f, 0.352539063f, 0.f),
    C_Vertex3f(0.0498046875f, 0.352539063f, -1.f),
    C_Vertex3f(0.224121094f, 0.352539063f, -1.f),
    C_Vertex3f(0.224121094f, 0.352539063f, 0.f),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.224121094f, 0.352539063f, 0.f),
    C_Vertex3f(0.224121094f, 0.352539063f, -1.f),
    C_Vertex3f(0.224121094f, 0.526855469f, -1.f),
    C_Vertex3f(0.224121094f, 0.526855469f, 0.f),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.224121094f, 0.526855469f, 0.f),
    C_Vertex3f(0.224121094f, 0.526855469f, -1.f),
    C_Vertex3f(0.298339844f, 0.526855469f, -1.f),
    C_Vertex3f(0.298339844f, 0.526855469f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.298339844f, 0.526855469f, 0.f),
    C_Vertex3f(0.298339844f, 0.526855469f, -1.f),
    C_Vertex3f(0.298339844f, 0.352539063f, -1.f),
    C_Vertex3f(0.298339844f, 0.352539063f, 0.f),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.298339844f, 0.352539063f, 0.f),
    C_Vertex3f(0.298339844f, 0.352539063f, -1.f),
    C_Vertex3f(0.47265625f, 0.352539063f, -1.f),
    C_Vertex3f(0.47265625f, 0.352539063f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.47265625f, 0.352539063f, 0.f),
    C_Vertex3f(0.47265625f, 0.352539063f, -1.f),
    C_Vertex3f(0.47265625f, 0.279296875f, -1.f),
    C_Vertex3f(0.47265625f, 0.279296875f, 0.f),
    C_Normal3f(-0.f, -1.f, 0.f),
    C_Vertex3f(0.47265625f, 0.279296875f, 0.f),
    C_Vertex3f(0.47265625f, 0.279296875f, -1.f),
    C_Vertex3f(0.298339844f, 0.279296875f, -1.f),
    C_Vertex3f(0.298339844f, 0.279296875f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.298339844f, 0.279296875f, 0.f),
    C_Vertex3f(0.298339844f, 0.279296875f, -1.f),
    C_Vertex3f(0.298339844f, 0.103515625f, -1.f),
    C_Vertex3f(0.298339844f, 0.103515625f, 0.f),
    C_Normal3f(-0.f, -1.f, 0.f),
    C_Vertex3f(0.298339844f, 0.103515625f, 0.f),
    C_Vertex3f(0.298339844f, 0.103515625f, -1.f),
    C_Vertex3f(0.224121094f, 0.103515625f, -1.f),
    C_Vertex3f(0.224121094f, 0.103515625f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.298339844f, 0.526855469f, 0.f),
    C_Vertex3f(0.224121094f, 0.526855469f, 0.f),
    C_Vertex3f(0.298339844f, 0.103515625f, 0.f),
    C_Vertex3f(0.224121094f, 0.352539063f, 0.f),
    C_Vertex3f(0.224121094f, 0.279296875f, 0.f),
    C_Vertex3f(0.0498046875f, 0.352539063f, 0.f),
    C_Vertex3f(0.0498046875f, 0.279296875f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.298339844f, 0.279296875f, 0.f),
    C_Vertex3f(0.47265625f, 0.279296875f, 0.f),
    C_Vertex3f(0.298339844f, 0.352539063f, 0.f),
    C_Vertex3f(0.298339844f, 0.526855469f, 0.f),
    C_Vertex3f(0.298339844f, 0.103515625f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.298339844f, 0.352539063f, 0.f),
    C_Vertex3f(0.47265625f, 0.279296875f, 0.f),
    C_Vertex3f(0.47265625f, 0.352539063f, 0.f),
    C_Vertex3f(0.298339844f, 0.103515625f, 0.f),
    C_Vertex3f(0.224121094f, 0.279296875f, 0.f),
    C_Vertex3f(0.224121094f, 0.103515625f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, -1.f),
    C_FrontFace(GL_CW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.298339844f, 0.526855469f, -1.f),
    C_Vertex3f(0.224121094f, 0.526855469f, -1.f),
    C_Vertex3f(0.298339844f, 0.103515625f, -1.f),
    C_Vertex3f(0.224121094f, 0.352539063f, -1.f),
    C_Vertex3f(0.224121094f, 0.279296875f, -1.f),
    C_Vertex3f(0.0498046875f, 0.352539063f, -1.f),
    C_Vertex3f(0.0498046875f, 0.279296875f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.298339844f, 0.279296875f, -1.f),
    C_Vertex3f(0.47265625f, 0.279296875f, -1.f),
    C_Vertex3f(0.298339844f, 0.352539063f, -1.f),
    C_Vertex3f(0.298339844f, 0.526855469f, -1.f),
    C_Vertex3f(0.298339844f, 0.103515625f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.298339844f, 0.352539063f, -1.f),
    C_Vertex3f(0.47265625f, 0.279296875f, -1.f),
    C_Vertex3f(0.47265625f, 0.352539063f, -1.f),
    C_Vertex3f(0.298339844f, 0.103515625f, -1.f),
    C_Vertex3f(0.224121094f, 0.279296875f, -1.f),
    C_Vertex3f(0.224121094f, 0.103515625f, -1.f),
    C_End(),
    C_Translatef(0.522460938f, 0.f, 0.f),
};
static const Call char_44[] = {
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_FrontFace(GL_CW),
    C_Begin(GL_QUADS),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.0795898438f, 0.f, 0.f),
    C_Vertex3f(0.0795898438f, 0.f, -1.f),
    C_Vertex3f(0.0795898438f, 0.0893554688f, -1.f),
    C_Vertex3f(0.0795898438f, 0.0893554688f, 0.f),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.0795898438f, 0.0893554688f, 0.f),
    C_Vertex3f(0.0795898438f, 0.0893554688f, -1.f),
    C_Vertex3f(0.168945313f, 0.0893554688f, -1.f),
    C_Vertex3f(0.168945313f, 0.0893554688f, 0.f),
    C_End(),
    C_Begin(GL_QUAD_STRIP),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.168945313f, 0.0893554688f, 0.f),
    C_Vertex3f(0.168945313f, 0.0893554688f, -1.f),
    C_Normal3f(0.999845922f, -0.017552482f, 0.f),
    C_Vertex3f(0.168945313f, -0.0123672485f, 0.f),
    C_Vertex3f(0.168945313f, -0.0123672485f, -1.f),
    C_Normal3f(0.988292277f, -0.152572513f, 0.f),
    C_Vertex3f(0.16676712f, -0.0347213745f, 0.f),
    C_Vertex3f(0.16676712f, -0.0347213745f, -1.f),
    C_Normal3f(0.960453153f, -0.278441697f, 0.f),
    C_Vertex3f(0.162410736f, -0.0546951294f, 0.f),
    C_Vertex3f(0.162410736f, -0.0546951294f, -1.f),
    C_Normal3f(0.906842053f, -0.421470672f, 0.f),
    C_Vertex3f(0.15587616f, -0.0722885132f, 0.f),
    C_Vertex3f(0.15587616f, -0.0722885132f, -1.f),
    C_Normal3f(0.820653856f, -0.571425498f, 0.f),
    C_Vertex3f(0.147163391f, -0.0875015259f, 0.f),
    C_Vertex3f(0.147163391f, -0.0875015259f, -1.f),
    C_Normal3f(0.709192693f, -0.705014646f, 0.f),
    C_Vertex3f(0.135890961f, -0.100990295f, 0.f),
    C_Vertex3f(0.135890961f, -0.100990295f, -1.f),
    C_Normal3f(0.585075676f, -0.810978711f, 0.f),
    C_Vertex3f(0.122058868f, -0.112754822f, 0.f),
    C_Vertex3f(0.122058868f, -0.112754822f, -1.f),
    C_Normal3f(0.481169224f, -0.876627743f, 0.f),
    C_Vertex3f(0.105667114f, -0.122795105f, 0.f),
    C_Vertex3f(0.105667114f, -0.122795105f, -1.f),
    C_Normal3f(0.401824236f, -0.915716887f, 0.f),
    C_Vertex3f(0.0961914063f, -0.126953125f, 0.f),
    C_Vertex3f(0.0961914063f, -0.126953125f, -1.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.837610602f, -0.546267807f, 0.f),
    C_Vertex3f(0.0961914063f, -0.126953125f, 0.f),
    C_Vertex3f(0.0961914063f, -0.126953125f, -1.f),
    C_Vertex3f(0.07421875f, -0.0932617188f, -1.f),
    C_Vertex3f(0.07421875f, -0.0932617188f, 0.f),
    C_End(),
    C_Begin(GL_QUAD_STRIP),
    C_Normal3f(-0.402259469f, 0.915525675f, 0.f),
    C_Vertex3f(0.07421875f, -0.0932617188f, 0.f),
    C_Vertex3f(0.07421875f, -0.0932617188f, -1.f),
    C_Normal3f(-0.486655027f, 0.873594284f, 0.f),
    C_Vertex3f(0.0804481506f, -0.0905246735f, 0.f),
    C_Vertex3f(0.0804481506f, -0.0905246735f, -1.f),
    C_Normal3f(-0.595042884f, 0.80369401f, 0.f),
    C_Vertex3f(0.0912671089f, -0.0837645531f, 0.f),
    C_Vertex3f(0.0912671089f, -0.0837645531f, -1.f),
    C_Normal3f(-0.720657885f, 0.693290889f, 0.f),
    C_Vertex3f(0.100446224f, -0.0757184029f, 0.f),
    C_Vertex3f(0.100446224f, -0.0757184029f, -1.f),
    C_Normal3f(-0.829384446f, 0.558678269f, 0.f),
    C_Vertex3f(0.107985497f, -0.0663862228f, 0.f),
    C_Vertex3f(0.107985497f, -0.0663862228f, -1.f),
    C_Normal3f(-0.913580418f, 0.406658173f, 0.f),
    C_Vertex3f(0.113884926f, -0.055768013f, 0.f),
    C_Vertex3f(0.113884926f, -0.055768013f, -1.f),
    C_Normal3f(-0.963258266f, 0.268576592f, 0.f),
    C_Vertex3f(0.11847353f, -0.0428242683f, 0.f),
    C_Vertex3f(0.11847353f, -0.0428242683f, -1.f),
    C_Normal3f(-0.987503946f, 0.157594293f, 0.f),
    C_Vertex3f(0.121751308f, -0.0275549889f, 0.f),
    C_Vertex3f(0.121751308f, -0.0275549889f, -1.f),
    C_Normal3f(-0.996549428f, 0.0830012336f, 0.f),
    C_Vertex3f(0.123718262f, -0.00996017456f, 0.f),
    C_Vertex3f(0.123718262f, -0.00996017456f, -1.f),
    C_Normal3f(-0.999457955f, 0.0329197198f, 0.f),
    C_Vertex3f(0.124046326f, 0.f, 0.f),
    C_Vertex3f(0.124046326f, 0.f, -1.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.f, -1.f, 0.f),
    C_Vertex3f(0.124046326f, 0.f, 0.f),
    C_Vertex3f(0.124046326f, 0.f, -1.f),
    C_Vertex3f(0.0795898438f, 0.f, -1.f),
    C_Vertex3f(0.0795898438f, 0.f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.168945313f, 0.0893554688f, 0.f),
    C_Vertex3f(0.0795898438f, 0.0893554688f, 0.f),
    C_Vertex3f(0.124046326f, 0.f, 0.f),
    C_Vertex3f(0.135890961f, -0.100990295f, 0.f),
    C_Vertex3f(0.147163391f, -0.0875015259f, 0.f),
    C_Vertex3f(0.15587616f, -0.0722885132f, 0.f),
    C_Vertex3f(0.162410736f, -0.0546951294f, 0.f),
    C_Vertex3f(0.16676712f, -0.0347213745f, 0.f),
    C_Vertex3f(0.168945313f, -0.0123672485f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.123718262f, -0.00996017456f, 0.f),
    C_Vertex3f(0.121751308f, -0.0275549889f, 0.f),
    C_Vertex3f(0.122058868f, -0.112754822f, 0.f),
    C_Vertex3f(0.135890961f, -0.100990295f, 0.f),
    C_Vertex3f(0.124046326f, 0.f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.122058868f, -0.112754822f, 0.f),
    C_Vertex3f(0.121751308f, -0.0275549889f, 0.f),
    C_Vertex3f(0.11847353f, -0.0428242683f, 0.f),
    C_Vertex3f(0.113884926f, -0.055768013f, 0.f),
    C_Vertex3f(0.107985497f, -0.0663862228f, 0.f),
    C_Vertex3f(0.105667114f, -0.122795105f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.100446224f, -0.0757184029f, 0.f),
    C_Vertex3f(0.0912671089f, -0.0837645531f, 0.f),
    C_Vertex3f(0.0961914063f, -0.126953125f, 0.f),
    C_Vertex3f(0.105667114f, -0.122795105f, 0.f),
    C_Vertex3f(0.107985497f, -0.0663862228f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.0804481506f, -0.0905246735f, 0.f),
    C_Vertex3f(0.07421875f, -0.0932617188f, 0.f),
    C_Vertex3f(0.0961914063f, -0.126953125f, 0.f),
    C_Vertex3f(0.0912671089f, -0.0837645531f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.124046326f, 0.f, 0.f),
    C_Vertex3f(0.0795898438f, 0.0893554688f, 0.f),
    C_Vertex3f(0.0795898438f, 0.f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, -1.f),
    C_FrontFace(GL_CW),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.168945313f, 0.0893554688f, -1.f),
    C_Vertex3f(0.0795898438f, 0.0893554688f, -1.f),
    C_Vertex3f(0.124046326f, 0.f, -1.f),
    C_Vertex3f(0.135890961f, -0.100990295f, -1.f),
    C_Vertex3f(0.147163391f, -0.0875015259f, -1.f),
    C_Vertex3f(0.15587616f, -0.0722885132f, -1.f),
    C_Vertex3f(0.162410736f, -0.0546951294f, -1.f),
    C_Vertex3f(0.16676712f, -0.0347213745f, -1.f),
    C_Vertex3f(0.168945313f, -0.0123672485f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.123718262f, -0.00996017456f, -1.f),
    C_Vertex3f(0.121751308f, -0.0275549889f, -1.f),
    C_Vertex3f(0.122058868f, -0.112754822f, -1.f),
    C_Vertex3f(0.135890961f, -0.100990295f, -1.f),
    C_Vertex3f(0.124046326f, 0.f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.122058868f, -0.112754822f, -1.f),
    C_Vertex3f(0.121751308f, -0.0275549889f, -1.f),
    C_Vertex3f(0.11847353f, -0.0428242683f, -1.f),
    C_Vertex3f(0.113884926f, -0.055768013f, -1.f),
    C_Vertex3f(0.107985497f, -0.0663862228f, -1.f),
    C_Vertex3f(0.105667114f, -0.122795105f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.100446224f, -0.0757184029f, -1.f),
    C_Vertex3f(0.0912671089f, -0.0837645531f, -1.f),
    C_Vertex3f(0.0961914063f, -0.126953125f, -1.f),
    C_Vertex3f(0.105667114f, -0.122795105f, -1.f),
    C_Vertex3f(0.107985497f, -0.0663862228f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.0804481506f, -0.0905246735f, -1.f),
    C_Vertex3f(0.07421875f, -0.0932617188f, -1.f),
    C_Vertex3f(0.0961914063f, -0.126953125f, -1.f),
    C_Vertex3f(0.0912671089f, -0.0837645531f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.124046326f, 0.f, -1.f),
    C_Vertex3f(0.0795898438f, 0.0893554688f, -1.f),
    C_Vertex3f(0.0795898438f, 0.f, -1.f),
    C_End(),
    C_Translatef(0.248535156f, 0.f, 0.f),
};
static const Call char_45[] = {
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_FrontFace(GL_CW),
    C_Begin(GL_QUADS),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.0278320313f, 0.192382813f, 0.f),
    C_Vertex3f(0.0278320313f, 0.192382813f, -1.f),
    C_Vertex3f(0.0278320313f, 0.271484375f, -1.f),
    C_Vertex3f(0.0278320313f, 0.271484375f, 0.f),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.0278320313f, 0.271484375f, 0.f),
    C_Vertex3f(0.0278320313f, 0.271484375f, -1.f),
    C_Vertex3f(0.270019531f, 0.271484375f, -1.f),
    C_Vertex3f(0.270019531f, 0.271484375f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.270019531f, 0.271484375f, 0.f),
    C_Vertex3f(0.270019531f, 0.271484375f, -1.f),
    C_Vertex3f(0.270019531f, 0.192382813f, -1.f),
    C_Vertex3f(0.270019531f, 0.192382813f, 0.f),
    C_Normal3f(-0.f, -1.f, 0.f),
    C_Vertex3f(0.270019531f, 0.192382813f, 0.f),
    C_Vertex3f(0.270019531f, 0.192382813f, -1.f),
    C_Vertex3f(0.0278320313f, 0.192382813f, -1.f),
    C_Vertex3f(0.0278320313f, 0.192382813f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.0278320313f, 0.192382813f, 0.f),
    C_Vertex3f(0.270019531f, 0.192382813f, 0.f),
    C_Vertex3f(0.270019531f, 0.271484375f, 0.f),
    C_Vertex3f(0.0278320313f, 0.271484375f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, -1.f),
    C_FrontFace(GL_CW),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.0278320313f, 0.192382813f, -1.f),
    C_Vertex3f(0.270019531f, 0.192382813f, -1.f),
    C_Vertex3f(0.270019531f, 0.271484375f, -1.f),
    C_Vertex3f(0.0278320313f, 0.271484375f, -1.f),
    C_End(),
    C_Translatef(0.297851563f, 0.f, 0.f),
};
static const Call char_46[] = {
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_FrontFace(GL_CW),
    C_Begin(GL_QUADS),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.0810546875f, 0.f, 0.f),
    C_Vertex3f(0.0810546875f, 0.f, -1.f),
    C_Vertex3f(0.0810546875f, 0.0893554688f, -1.f),
    C_Vertex3f(0.0810546875f, 0.0893554688f, 0.f),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.0810546875f, 0.0893554688f, 0.f),
    C_Vertex3f(0.0810546875f, 0.0893554688f, -1.f),
    C_Vertex3f(0.170410156f, 0.0893554688f, -1.f),
    C_Vertex3f(0.170410156f, 0.0893554688f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.170410156f, 0.0893554688f, 0.f),
    C_Vertex3f(0.170410156f, 0.0893554688f, -1.f),
    C_Vertex3f(0.170410156f, 0.f, -1.f),
    C_Vertex3f(0.170410156f, 0.f, 0.f),
    C_Normal3f(-0.f, -1.f, 0.f),
    C_Vertex3f(0.170410156f, 0.f, 0.f),
    C_Vertex3f(0.170410156f, 0.f, -1.f),
    C_Vertex3f(0.0810546875f, 0.f, -1.f),
    C_Vertex3f(0.0810546875f, 0.f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.0810546875f, 0.f, 0.f),
    C_Vertex3f(0.170410156f, 0.f, 0.f),
    C_Vertex3f(0.170410156f, 0.0893554688f, 0.f),
    C_Vertex3f(0.0810546875f, 0.0893554688f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, -1.f),
    C_FrontFace(GL_CW),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.0810546875f, 0.f, -1.f),
    C_Vertex3f(0.170410156f, 0.f, -1.f),
    C_Vertex3f(0.170410156f, 0.0893554688f, -1.f),
    C_Vertex3f(0.0810546875f, 0.0893554688f, -1.f),
    C_End(),
    C_Translatef(0.248535156f, 0.f, 0.f),
};
static const Call char_47[] = {
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_FrontFace(GL_CW),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.96290499f, 0.269840628f, 0.f),
    C_Vertex3f(0.f, -0.0107421875f, 0.f),
    C_Vertex3f(0.f, -0.0107421875f, -1.f),
    C_Vertex3f(0.185546875f, 0.651367188f, -1.f),
    C_Vertex3f(0.185546875f, 0.651367188f, 0.f),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.185546875f, 0.651367188f, 0.f),
    C_Vertex3f(0.185546875f, 0.651367188f, -1.f),
    C_Vertex3f(0.248916626f, 0.651367188f, -1.f),
    C_Vertex3f(0.248916626f, 0.651367188f, 0.f),
    C_Normal3f(0.96290499f, -0.269840628f, 0.f),
    C_Vertex3f(0.248916626f, 0.651367188f, 0.f),
    C_Vertex3f(0.248916626f, 0.651367188f, -1.f),
    C_Vertex3f(0.063369751f, -0.0107421875f, -1.f),
    C_Vertex3f(0.063369751f, -0.0107421875f, 0.f),
    C_Normal3f(-0.f, -1.f, 0.f),
    C_Vertex3f(0.063369751f, -0.0107421875f, 0.f),
    C_Vertex3f(0.063369751f, -0.0107421875f, -1.f),
    C_Vertex3f(0.f, -0.0107421875f, -1.f),
    C_Vertex3f(0.f, -0.0107421875f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.f, -0.0107421875f, 0.f),
    C_Vertex3f(0.063369751f, -0.0107421875f, 0.f),
    C_Vertex3f(0.248916626f, 0.651367188f, 0.f),
    C_Vertex3f(0.185546875f, 0.651367188f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, -1.f),
    C_FrontFace(GL_CW),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.f, -0.0107421875f, -1.f),
    C_Vertex3f(0.063369751f, -0.0107421875f, -1.f),
    C_Vertex3f(0.248916626f, 0.651367188f, -1.f),
    C_Vertex3f(0.185546875f, 0.651367188f, -1.f),
    C_End(),
    C_Translatef(0.248535156f, 0.f, 0.f),
};
static const Call char_48[] = {
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_FrontFace(GL_CW),
    C_Begin(GL_QUAD_STRIP),
    C_Normal3f(-0.999683976f, -0.0251354929f, 0.f),
    C_Vertex3f(0.037109375f, 0.293394089f, 0.f),
    C_Vertex3f(0.037109375f, 0.293394089f, -1.f),
    C_Normal3f(-0.999934494f, 0.0114529217f, 0.f),
    C_Vertex3f(0.037109375f, 0.330135345f, 0.f),
    C_Vertex3f(0.037109375f, 0.330135345f, -1.f),
    C_Normal3f(-0.999135077f, 0.041581504f, 0.f),
    C_Vertex3f(0.0378395319f, 0.357142806f, 0.f),
    C_Vertex3f(0.0378395319f, 0.357142806f, -1.f),
    C_Normal3f(-0.997331142f, 0.0730101019f, 0.f),
    C_Vertex3f(0.0392998457f, 0.38276875f, 0.f),
    C_Vertex3f(0.0392998457f, 0.38276875f, -1.f),
    C_Normal3f(-0.994165421f, 0.107865937f, 0.f),
    C_Vertex3f(0.0414903164f, 0.407013178f, 0.f),
    C_Vertex3f(0.0414903164f, 0.407013178f, -1.f),
    C_Normal3f(-0.989197373f, 0.146589816f, 0.f),
    C_Vertex3f(0.044410944f, 0.429876089f, 0.f),
    C_Vertex3f(0.044410944f, 0.429876089f, -1.f),
    C_Normal3f(-0.981851399f, 0.189651757f, 0.f),
    C_Vertex3f(0.0480617285f, 0.451357484f, 0.f),
    C_Vertex3f(0.0480617285f, 0.451357484f, -1.f),
    C_Normal3f(-0.971381009f, 0.237527177f, 0.f),
    C_Vertex3f(0.0524426699f, 0.471457362f, 0.f),
    C_Vertex3f(0.0524426699f, 0.471457362f, -1.f),
    C_Normal3f(-0.956828773f, 0.290652245f, 0.f),
    C_Vertex3f(0.0575537682f, 0.490175724f, 0.f),
    C_Vertex3f(0.0575537682f, 0.490175724f, -1.f),
    C_Normal3f(-0.938479424f, 0.345335066f, 0.f),
    C_Vertex3f(0.0633950233f, 0.507512569f, 0.f),
    C_Vertex3f(0.0633950233f, 0.507512569f, -1.f),
    C_Normal3f(-0.91668582f, 0.399608523f, 0.f),
    C_Vertex3f(0.0699458122f, 0.523852229f, 0.f),
    C_Vertex3f(0.0699458122f, 0.523852229f, -1.f),
    C_Normal3f(-0.889748216f, 0.456451535f, 0.f),
    C_Vertex3f(0.0772061348f, 0.539194703f, 0.f),
    C_Vertex3f(0.0772061348f, 0.539194703f, -1.f),
    C_Normal3f(-0.857039094f, 0.515251279f, 0.f),
    C_Vertex3f(0.0851759911f, 0.553539991f, 0.f),
    C_Vertex3f(0.0851759911f, 0.553539991f, -1.f),
    C_Normal3f(-0.818048716f, 0.575148821f, 0.f),
    C_Vertex3f(0.093855381f, 0.566888094f, 0.f),
    C_Vertex3f(0.093855381f, 0.566888094f, -1.f),
    C_Normal3f(-0.772475183f, 0.635044992f, 0.f),
    C_Vertex3f(0.103244305f, 0.579239011f, 0.f),
    C_Vertex3f(0.103244305f, 0.579239011f, -1.f),
    C_Normal3f(-0.720315933f, 0.693646073f, 0.f),
    C_Vertex3f(0.113342762f, 0.590592742f, 0.f),
    C_Vertex3f(0.113342762f, 0.590592742f, -1.f),
    C_Normal3f(-0.661940992f, 0.749555945f, 0.f),
    C_Vertex3f(0.124150753f, 0.600949287f, 0.f),
    C_Vertex3f(0.124150753f, 0.600949287f, -1.f),
    C_Normal3f(-0.593803763f, 0.804609954f, 0.f),
    C_Vertex3f(0.135668278f, 0.610308647f, 0.f),
    C_Vertex3f(0.135668278f, 0.610308647f, -1.f),
    C_Normal3f(-0.515721619f, 0.85675627f, 0.f),
    C_Vertex3f(0.147929549f, 0.618498087f, 0.f),
    C_Vertex3f(0.147929549f, 0.618498087f, -1.f),
    C_Normal3f(-0.433478385f, 0.901163995f, 0.f),
    C_Vertex3f(0.160934567f, 0.625517607f, 0.f),
    C_Vertex3f(0.160934567f, 0.625517607f, -1.f),
    C_Normal3f(-0.349342674f, 0.936995029f, 0.f),
    C_Vertex3f(0.174683332f, 0.631367207f, 0.f),
    C_Vertex3f(0.174683332f, 0.631367207f, -1.f),
    C_Normal3f(-0.265579373f, 0.964088917f, 0.f),
    C_Vertex3f(0.189175844f, 0.636046886f, 0.f),
    C_Vertex3f(0.189175844f, 0.636046886f, -1.f),
    C_Normal3f(-0.184183598f, 0.982891858f, 0.f),
    C_Vertex3f(0.204412103f, 0.639556646f, 0.f),
    C_Vertex3f(0.204412103f, 0.639556646f, -1.f),
    C_Normal3f(-0.106707044f, 0.99429059f, 0.f),
    C_Vertex3f(0.220392108f, 0.641896486f, 0.f),
    C_Vertex3f(0.220392108f, 0.641896486f, -1.f),
    C_Normal3f(-0.0305003598f, 0.999534786f, 0.f),
    C_Vertex3f(0.23711586f, 0.643066406f, 0.f),
    C_Vertex3f(0.23711586f, 0.643066406f, -1.f),
    C_Normal3f(0.0565099902f, 0.998402059f, 0.f),
    C_Vertex3f(0.258731842f, 0.643066406f, 0.f),
    C_Vertex3f(0.258731842f, 0.643066406f, -1.f),
    C_Normal3f(0.163879335f, 0.986480474f, 0.f),
    C_Vertex3f(0.282928944f, 0.640473366f, 0.f),
    C_Vertex3f(0.282928944f, 0.640473366f, -1.f),
    C_Normal3f(0.284479469f, 0.958682239f, 0.f),
    C_Vertex3f(0.305558681f, 0.635287285f, 0.f),
    C_Vertex3f(0.305558681f, 0.635287285f, -1.f),
    C_Normal3f(0.40850091f, 0.912757993f, 0.f),
    C_Vertex3f(0.326621056f, 0.627508163f, 0.f),
    C_Vertex3f(0.326621056f, 0.627508163f, -1.f),
    C_Normal3f(0.525819063f, 0.850596368f, 0.f),
    C_Vertex3f(0.346116066f, 0.617136002f, 0.f),
    C_Vertex3f(0.346116066f, 0.617136002f, -1.f),
    C_Normal3f(0.632587612f, 0.774488747f, 0.f),
    C_Vertex3f(0.363887787f, 0.60447073f, 0.f),
    C_Vertex3f(0.363887787f, 0.60447073f, -1.f),
    C_Normal3f(0.727541268f, 0.686063826f, 0.f),
    C_Vertex3f(0.379936218f, 0.589512348f, 0.f),
    C_Vertex3f(0.379936218f, 0.589512348f, -1.f),
    C_Normal3f(0.80699867f, 0.590553164f, 0.f),
    C_Vertex3f(0.39426136f, 0.572260857f, 0.f),
    C_Vertex3f(0.39426136f, 0.572260857f, -1.f),
    C_Normal3f(0.86550349f, 0.500902832f, 0.f),
    C_Vertex3f(0.406863213f, 0.552716255f, 0.f),
    C_Vertex3f(0.406863213f, 0.552716255f, -1.f),
    C_Normal3f(0.906683326f, 0.421811998f, 0.f),
    C_Vertex3f(0.418116093f, 0.531042576f, 0.f),
    C_Vertex3f(0.418116093f, 0.531042576f, -1.f),
    C_Normal3f(0.937511384f, 0.347954512f, 0.f),
    C_Vertex3f(0.42802f, 0.507239819f, 0.f),
    C_Vertex3f(0.42802f, 0.507239819f, -1.f),
    C_Normal3f(0.958574712f, 0.284841239f, 0.f),
    C_Vertex3f(0.436574936f, 0.481307983f, 0.f),
    C_Vertex3f(0.436574936f, 0.481307983f, -1.f),
    C_Normal3f(0.973318875f, 0.229456589f, 0.f),
    C_Vertex3f(0.441979408f, 0.460262299f, 0.f),
    C_Vertex3f(0.441979408f, 0.460262299f, -1.f),
    C_Normal3f(0.983394623f, 0.181480303f, 0.f),
    C_Vertex3f(0.445132017f, 0.445010185f, 0.f),
    C_Vertex3f(0.445132017f, 0.445010185f, -1.f),
    C_Normal3f(0.989652157f, 0.143486992f, 0.f),
    C_Vertex3f(0.447834253f, 0.428536415f, 0.f),
    C_Vertex3f(0.447834253f, 0.428536415f, -1.f),
    C_Normal3f(0.993927479f, 0.110037252f, 0.f),
    C_Vertex3f(0.450086117f, 0.410840988f, 0.f),
    C_Vertex3f(0.450086117f, 0.410840988f, -1.f),
    C_Normal3f(0.996757984f, 0.0804588869f, 0.f),
    C_Vertex3f(0.451887608f, 0.391923904f, 0.f),
    C_Vertex3f(0.451887608f, 0.391923904f, -1.f),
    C_Normal3f(0.998531044f, 0.0541831888f, 0.f),
    C_Vertex3f(0.453238726f, 0.371785164f, 0.f),
    C_Vertex3f(0.453238726f, 0.371785164f, -1.f),
    C_Normal3f(0.999527693f, 0.0307329223f, 0.f),
    C_Vertex3f(0.454139471f, 0.350424767f, 0.f),
    C_Vertex3f(0.454139471f, 0.350424767f, -1.f),
    C_Normal3f(0.999957085f, 0.00927249715f, 0.f),
    C_Vertex3f(0.454589844f, 0.327842712f, 0.f),
    C_Vertex3f(0.454589844f, 0.327842712f, -1.f),
    C_Normal3f(0.999906182f, -0.0136959227f, 0.f),
    C_Vertex3f(0.454589844f, 0.301856041f, 0.f),
    C_Vertex3f(0.454589844f, 0.301856041f, -1.f),
    C_Normal3f(0.999139726f, -0.041468773f, 0.f),
    C_Vertex3f(0.453866601f, 0.275040507f, 0.f),
    C_Vertex3f(0.453866601f, 0.275040507f, -1.f),
    C_Normal3f(0.99734956f, -0.0727601051f, 0.f),
    C_Vertex3f(0.452420115f, 0.249579072f, 0.f),
    C_Vertex3f(0.452420115f, 0.249579072f, -1.f),
    C_Normal3f(0.994214535f, -0.10741245f, 0.f),
    C_Vertex3f(0.450250387f, 0.225471735f, 0.f),
    C_Vertex3f(0.450250387f, 0.225471735f, -1.f),
    C_Normal3f(0.989306867f, -0.145849019f, 0.f),
    C_Vertex3f(0.447357416f, 0.202718496f, 0.f),
    C_Vertex3f(0.447357416f, 0.202718496f, -1.f),
    C_Normal3f(0.982069552f, -0.188519135f, 0.f),
    C_Vertex3f(0.443741202f, 0.181319356f, 0.f),
    C_Vertex3f(0.443741202f, 0.181319356f, -1.f),
    C_Normal3f(0.97178334f, -0.235875204f, 0.f),
    C_Vertex3f(0.439401746f, 0.161274314f, 0.f),
    C_Vertex3f(0.439401746f, 0.161274314f, -1.f),
    C_Normal3f(0.957530975f, -0.288330495f, 0.f),
    C_Vertex3f(0.434339046f, 0.14258337f, 0.f),
    C_Vertex3f(0.434339046f, 0.14258337f, -1.f),
    C_Normal3f(0.939434826f, -0.342727661f, 0.f),
    C_Vertex3f(0.428553104f, 0.125246525f, 0.f),
    C_Vertex3f(0.428553104f, 0.125246525f, -1.f),
    C_Normal3f(0.917726338f, -0.397213221f, 0.f),
    C_Vertex3f(0.422050595f, 0.10890007f, 0.f),
    C_Vertex3f(0.422050595f, 0.10890007f, -1.f),
    C_Normal3f(0.890876234f, -0.454245985f, 0.f),
    C_Vertex3f(0.414831519f, 0.0935440063f, 0.f),
    C_Vertex3f(0.414831519f, 0.0935440063f, -1.f),
    C_Normal3f(0.858266115f, -0.513204873f, 0.f),
    C_Vertex3f(0.406895876f, 0.0791783333f, 0.f),
    C_Vertex3f(0.406895876f, 0.0791783333f, -1.f),
    C_Normal3f(0.819398284f, -0.573224664f, 0.f),
    C_Vertex3f(0.398243666f, 0.065803051f, 0.f),
    C_Vertex3f(0.398243666f, 0.065803051f, -1.f),
    C_Normal3f(0.773985207f, -0.633203804f, 0.f),
    C_Vertex3f(0.388874888f, 0.0534181595f, 0.f),
    C_Vertex3f(0.388874888f, 0.0534181595f, -1.f),
    C_Normal3f(0.722039163f, -0.691852152f, 0.f),
    C_Vertex3f(0.378789544f, 0.0420236588f, 0.f),
    C_Vertex3f(0.378789544f, 0.0420236588f, -1.f),
    C_Normal3f(0.663942337f, -0.74778378f, 0.f),
    C_Vertex3f(0.367987633f, 0.0316195488f, 0.f),
    C_Vertex3f(0.367987633f, 0.0316195488f, -1.f),
    C_Normal3f(0.595781207f, -0.80314678f, 0.f),
    C_Vertex3f(0.356469154f, 0.0222058296f, 0.f),
    C_Vertex3f(0.356469154f, 0.0222058296f, -1.f),
    C_Normal3f(0.517280996f, -0.855815589f, 0.f),
    C_Vertex3f(0.344193459f, 0.0139688253f, 0.f),
    C_Vertex3f(0.344193459f, 0.0139688253f, -1.f),
    C_Normal3f(0.434607655f, -0.900619864f, 0.f),
    C_Vertex3f(0.331160545f, 0.00690853596f, 0.f),
    C_Vertex3f(0.331160545f, 0.00690853596f, -1.f),
    C_Normal3f(0.350076407f, -0.936721087f, 0.f),
    C_Vertex3f(0.317370415f, 0.00102496147f, 0.f),
    C_Vertex3f(0.317370415f, 0.00102496147f, -1.f),
    C_Normal3f(0.265988827f, -0.963976145f, 0.f),
    C_Vertex3f(0.302823067f, -0.00368189812f, 0.f),
    C_Vertex3f(0.302823067f, -0.00368189812f, -1.f),
    C_Normal3f(0.184360713f, -0.982858717f, 0.f),
    C_Vertex3f(0.287518501f, -0.00721204281f, 0.f),
    C_Vertex3f(0.287518501f, -0.00721204281f, -1.f),
    C_Normal3f(0.106748484f, -0.99428606f, 0.f),
    C_Vertex3f(0.271456718f, -0.0095654726f, 0.f),
    C_Vertex3f(0.271456718f, -0.0095654726f, -1.f),
    C_Normal3f(0.0316333435f, -0.999499559f, 0.f),
    C_Vertex3f(0.254637718f, -0.0107421875f, 0.f),
    C_Vertex3f(0.254637718f, -0.0107421875f, -1.f),
    C_Normal3f(-0.0488444343f, -0.998806417f, 0.f),
    C_Vertex3f(0.234276772f, -0.0107421875f, 0.f),
    C_Vertex3f(0.234276772f, -0.0107421875f, -1.f),
    C_Normal3f(-0.144151539f, -0.989555657f, 0.f),
    C_Vertex3f(0.212373257f, -0.00867533684f, 0.f),
    C_Vertex3f(0.212373257f, -0.00867533684f, -1.f),
    C_Normal3f(-0.249671578f, -0.968330562f, 0.f),
    C_Vertex3f(0.191711903f, -0.00454163551f, 0.f),
    C_Vertex3f(0.191711903f, -0.00454163551f, -1.f),
    C_Normal3f(-0.359149218f, -0.93328017f, 0.f),
    C_Vertex3f(0.172292709f, 0.00165891647f, 0.f),
    C_Vertex3f(0.172292709f, 0.00165891647f, -1.f),
    C_Normal3f(-0.468143255f, -0.883652568f, 0.f),
    C_Vertex3f(0.154115677f, 0.00992631912f, 0.f),
    C_Vertex3f(0.154115677f, 0.00992631912f, -1.f),
    C_Normal3f(-0.571706712f, -0.820458114f, 0.f),
    C_Vertex3f(0.137180805f, 0.0202605724f, 0.f),
    C_Vertex3f(0.137180805f, 0.0202605724f, -1.f),
    C_Normal3f(-0.665401399f, -0.74648571f, 0.f),
    C_Vertex3f(0.121488094f, 0.0326616764f, 0.f),
    C_Vertex3f(0.121488094f, 0.0326616764f, -1.f),
    C_Normal3f(-0.74907285f, -0.662487686f, 0.f),
    C_Vertex3f(0.107037544f, 0.047129631f, 0.f),
    C_Vertex3f(0.107037544f, 0.047129631f, -1.f),
    C_Normal3f(-0.825281441f, -0.564721704f, 0.f),
    C_Vertex3f(0.0925178528f, 0.0654182434f, 0.f),
    C_Vertex3f(0.0925178528f, 0.0654182434f, -1.f),
    C_Normal3f(-0.887244105f, -0.461300254f, 0.f),
    C_Vertex3f(0.0786657333f, 0.0885920525f, 0.f),
    C_Vertex3f(0.0786657333f, 0.0885920525f, -1.f),
    C_Normal3f(-0.931494236f, -0.363756001f, 0.f),
    C_Vertex3f(0.0667924881f, 0.114897251f, 0.f),
    C_Vertex3f(0.0667924881f, 0.114897251f, -1.f),
    C_Normal3f(-0.961136937f, -0.276071966f, 0.f),
    C_Vertex3f(0.0568981171f, 0.144333839f, 0.f),
    C_Vertex3f(0.0568981171f, 0.144333839f, -1.f),
    C_Normal3f(-0.98002851f, -0.198857471f, 0.f),
    C_Vertex3f(0.0489826202f, 0.176901817f, 0.f),
    C_Vertex3f(0.0489826202f, 0.176901817f, -1.f),
    C_Normal3f(-0.991302729f, -0.131602049f, 0.f),
    C_Vertex3f(0.0430459976f, 0.212601185f, 0.f),
    C_Vertex3f(0.0430459976f, 0.212601185f, -1.f),
    C_Normal3f(-0.997311234f, -0.0732819363f, 0.f),
    C_Vertex3f(0.0390882492f, 0.251431942f, 0.f),
    C_Vertex3f(0.0390882492f, 0.251431942f, -1.f),
    C_Normal3f(-0.999683976f, -0.0251354929f, 0.f),
    C_Vertex3f(0.037109375f, 0.293394089f, 0.f),
    C_Vertex3f(0.037109375f, 0.293394089f, -1.f),
    C_End(),
    C_Begin(GL_QUAD_STRIP),
    C_Normal3f(0.99986136f, -0.016653141f, 0.f),
    C_Vertex3f(0.118164063f, 0.335638046f, 0.f),
    C_Vertex3f(0.118164063f, 0.335638046f, -1.f),
    C_Normal3f(0.999884427f, 0.0152069544f, 0.f),
    C_Vertex3f(0.118164063f, 0.296167374f, 0.f),
    C_Vertex3f(0.118164063f, 0.296167374f, -1.f),
    C_Normal3f(0.998753488f, 0.0499157831f, 0.f),
    C_Vertex3f(0.11931479f, 0.259975672f, 0.f),
    C_Vertex3f(0.11931479f, 0.259975672f, -1.f),
    C_Normal3f(0.995783329f, 0.0917361453f, 0.f),
    C_Vertex3f(0.121616244f, 0.227093458f, 0.f),
    C_Vertex3f(0.121616244f, 0.227093458f, -1.f),
    C_Normal3f(0.989753664f, 0.142785326f, 0.f),
    C_Vertex3f(0.125068426f, 0.197520733f, 0.f),
    C_Vertex3f(0.125068426f, 0.197520733f, -1.f),
    C_Normal3f(0.978569567f, 0.205916718f, 0.f),
    C_Vertex3f(0.129671335f, 0.171257496f, 0.f),
    C_Vertex3f(0.129671335f, 0.171257496f, -1.f),
    C_Normal3f(0.958574891f, 0.284840554f, 0.f),
    C_Vertex3f(0.135424972f, 0.148303747f, 0.f),
    C_Vertex3f(0.135424972f, 0.148303747f, -1.f),
    C_Normal3f(0.923366487f, 0.383919686f, 0.f),
    C_Vertex3f(0.142329335f, 0.128659487f, 0.f),
    C_Vertex3f(0.142329335f, 0.128659487f, -1.f),
    C_Normal3f(0.862058759f, 0.506808221f, 0.f),
    C_Vertex3f(0.150384426f, 0.112324715f, 0.f),
    C_Vertex3f(0.150384426f, 0.112324715f, -1.f),
    C_Normal3f(0.790066242f, 0.613021493f, 0.f),
    C_Vertex3f(0.159590244f, 0.0992994308f, 0.f),
    C_Vertex3f(0.159590244f, 0.0992994308f, -1.f),
    C_Normal3f(0.726406097f, 0.687265754f, 0.f),
    C_Vertex3f(0.169334054f, 0.0879023075f, 0.f),
    C_Vertex3f(0.169334054f, 0.0879023075f, -1.f),
    C_Normal3f(0.647090495f, 0.762413144f, 0.f),
    C_Vertex3f(0.179615855f, 0.0781333447f, 0.f),
    C_Vertex3f(0.179615855f, 0.0781333447f, -1.f),
    C_Normal3f(0.551267743f, 0.834328294f, 0.f),
    C_Vertex3f(0.190435648f, 0.0699925423f, 0.f),
    C_Vertex3f(0.190435648f, 0.0699925423f, -1.f),
    C_Normal3f(0.440104902f, 0.897946358f, 0.f),
    C_Vertex3f(0.201793432f, 0.0634799004f, 0.f),
    C_Vertex3f(0.201793432f, 0.0634799004f, -1.f),
    C_Normal3f(0.317313462f, 0.948320746f, 0.f),
    C_Vertex3f(0.213689208f, 0.0585954189f, 0.f),
    C_Vertex3f(0.213689208f, 0.0585954189f, -1.f),
    C_Normal3f(0.188802779f, 0.982015014f, 0.f),
    C_Vertex3f(0.226122975f, 0.055339098f, 0.f),
    C_Vertex3f(0.226122975f, 0.055339098f, -1.f),
    C_Normal3f(0.0613670424f, 0.998115301f, 0.f),
    C_Vertex3f(0.239094734f, 0.0537109375f, 0.f),
    C_Vertex3f(0.239094734f, 0.0537109375f, -1.f),
    C_Normal3f(-0.0616221726f, 0.998099446f, 0.f),
    C_Vertex3f(0.252604485f, 0.0537109375f, 0.f),
    C_Vertex3f(0.252604485f, 0.0537109375f, -1.f),
    C_Normal3f(-0.189562485f, 0.981868684f, 0.f),
    C_Vertex3f(0.265576243f, 0.0553458929f, 0.f),
    C_Vertex3f(0.265576243f, 0.0553458929f, -1.f),
    C_Normal3f(-0.318503648f, 0.947921693f, 0.f),
    C_Vertex3f(0.278010011f, 0.0586158037f, 0.f),
    C_Vertex3f(0.278010011f, 0.0586158037f, -1.f),
    C_Normal3f(-0.441584051f, 0.897219896f, 0.f),
    C_Vertex3f(0.289905787f, 0.0635206699f, 0.f),
    C_Vertex3f(0.289905787f, 0.0635206699f, -1.f),
    C_Normal3f(-0.55286628f, 0.833270013f, 0.f),
    C_Vertex3f(0.301263571f, 0.0700604916f, 0.f),
    C_Vertex3f(0.301263571f, 0.0700604916f, -1.f),
    C_Normal3f(-0.648656189f, 0.761081576f, 0.f),
    C_Vertex3f(0.312083364f, 0.0782352686f, 0.f),
    C_Vertex3f(0.312083364f, 0.0782352686f, -1.f),
    C_Normal3f(-0.727833271f, 0.68575412f, 0.f),
    C_Vertex3f(0.322365165f, 0.088045001f, 0.f),
    C_Vertex3f(0.322365165f, 0.088045001f, -1.f),
    C_Normal3f(-0.791300476f, 0.611427426f, 0.f),
    C_Vertex3f(0.332108974f, 0.0994896889f, 0.f),
    C_Vertex3f(0.332108974f, 0.0994896889f, -1.f),
    C_Normal3f(-0.862722695f, 0.505677164f, 0.f),
    C_Vertex3f(0.341314793f, 0.112569332f, 0.f),
    C_Vertex3f(0.341314793f, 0.112569332f, -1.f),
    C_Normal3f(-0.923546076f, 0.383487403f, 0.f),
    C_Vertex3f(0.349369884f, 0.128938079f, 0.f),
    C_Vertex3f(0.349369884f, 0.128938079f, -1.f),
    C_Normal3f(-0.958587348f, 0.284798831f, 0.f),
    C_Vertex3f(0.356274247f, 0.148595929f, 0.f),
    C_Vertex3f(0.356274247f, 0.148595929f, -1.f),
    C_Normal3f(-0.978540897f, 0.206052914f, 0.f),
    C_Vertex3f(0.362027884f, 0.171542883f, 0.f),
    C_Vertex3f(0.362027884f, 0.171542883f, -1.f),
    C_Normal3f(-0.989726603f, 0.142972812f, 0.f),
    C_Vertex3f(0.366630793f, 0.19777894f, 0.f),
    C_Vertex3f(0.366630793f, 0.19777894f, -1.f),
    C_Normal3f(-0.995767891f, 0.0919046998f, 0.f),
    C_Vertex3f(0.370082974f, 0.227304101f, 0.f),
    C_Vertex3f(0.370082974f, 0.227304101f, -1.f),
    C_Normal3f(-0.998747885f, 0.0500286967f, 0.f),
    C_Vertex3f(0.372384429f, 0.260118365f, 0.f),
    C_Vertex3f(0.372384429f, 0.260118365f, -1.f),
    C_Normal3f(-0.999884069f, 0.0152247241f, 0.f),
    C_Vertex3f(0.373535156f, 0.296221733f, 0.f),
    C_Vertex3f(0.373535156f, 0.296221733f, -1.f),
    C_Normal3f(-0.999884844f, -0.0151739856f, 0.f),
    C_Vertex3f(0.373535156f, 0.335692406f, 0.f),
    C_Vertex3f(0.373535156f, 0.335692406f, -1.f),
    C_Normal3f(-0.998759985f, -0.0497839674f, 0.f),
    C_Vertex3f(0.372386336f, 0.371922851f, 0.f),
    C_Vertex3f(0.372386336f, 0.371922851f, -1.f),
    C_Normal3f(-0.995804012f, -0.0915117562f, 0.f),
    C_Vertex3f(0.370088696f, 0.404834867f, 0.f),
    C_Vertex3f(0.370088696f, 0.404834867f, -1.f),
    C_Normal3f(-0.989798903f, -0.142471522f, 0.f),
    C_Vertex3f(0.366642237f, 0.434428453f, 0.f),
    C_Vertex3f(0.366642237f, 0.434428453f, -1.f),
    C_Normal3f(-0.978650808f, -0.205530241f, 0.f),
    C_Vertex3f(0.362046957f, 0.460703611f, 0.f),
    C_Vertex3f(0.362046957f, 0.460703611f, -1.f),
    C_Normal3f(-0.958698332f, -0.284424961f, 0.f),
    C_Vertex3f(0.356302857f, 0.48366034f, 0.f),
    C_Vertex3f(0.356302857f, 0.48366034f, -1.f),
    C_Normal3f(-0.923513174f, -0.383566618f, 0.f),
    C_Vertex3f(0.349409938f, 0.50329864f, 0.f),
    C_Vertex3f(0.349409938f, 0.50329864f, -1.f),
    C_Normal3f(-0.862133741f, -0.506680787f, 0.f),
    C_Vertex3f(0.341368198f, 0.519618511f, 0.f),
    C_Vertex3f(0.341368198f, 0.519618511f, -1.f),
    C_Normal3f(-0.789484382f, -0.613770545f, 0.f),
    C_Vertex3f(0.332177639f, 0.532619953f, 0.f),
    C_Vertex3f(0.332177639f, 0.532619953f, -1.f),
    C_Normal3f(-0.724608481f, -0.689160764f, 0.f),
    C_Vertex3f(0.322416186f, 0.543996215f, 0.f),
    C_Vertex3f(0.322416186f, 0.543996215f, -1.f),
    C_Normal3f(-0.644017398f, -0.765010834f, 0.f),
    C_Vertex3f(0.31208384f, 0.553747296f, 0.f),
    C_Vertex3f(0.31208384f, 0.553747296f, -1.f),
    C_Normal3f(-0.54712522f, -0.837050736f, 0.f),
    C_Vertex3f(0.301180601f, 0.561873198f, 0.f),
    C_Vertex3f(0.301180601f, 0.561873198f, -1.f),
    C_Normal3f(-0.43543759f, -0.900218904f, 0.f),
    C_Vertex3f(0.289706469f, 0.568373919f, 0.f),
    C_Vertex3f(0.289706469f, 0.568373919f, -1.f),
    C_Normal3f(-0.312953323f, -0.949768484f, 0.f),
    C_Vertex3f(0.277661443f, 0.573249459f, 0.f),
    C_Vertex3f(0.277661443f, 0.573249459f, -1.f),
    C_Normal3f(-0.185668975f, -0.982612371f, 0.f),
    C_Vertex3f(0.265045524f, 0.57649982f, 0.f),
    C_Vertex3f(0.265045524f, 0.57649982f, -1.f),
    C_Normal3f(-0.0604836755f, -0.998169184f, 0.f),
    C_Vertex3f(0.251858711f, 0.578125f, 0.f),
    C_Vertex3f(0.251858711f, 0.578125f, -1.f),
    C_Normal3f(0.0540969484f, -0.998535752f, 0.f),
    C_Vertex3f(0.238224983f, 0.578125f, 0.f),
    C_Vertex3f(0.238224983f, 0.578125f, -1.f),
    C_Normal3f(0.169648081f, -0.985504687f, 0.f),
    C_Vertex3f(0.225392342f, 0.576691151f, 0.f),
    C_Vertex3f(0.225392342f, 0.576691151f, -1.f),
    C_Normal3f(0.290283322f, -0.956940651f, 0.f),
    C_Vertex3f(0.213236809f, 0.573823452f, 0.f),
    C_Vertex3f(0.213236809f, 0.573823452f, -1.f),
    C_Normal3f(0.410741121f, -0.911751986f, 0.f),
    C_Vertex3f(0.201758385f, 0.569521904f, 0.f),
    C_Vertex3f(0.201758385f, 0.569521904f, -1.f),
    C_Normal3f(0.524905562f, -0.851160526f, 0.f),
    C_Vertex3f(0.190957069f, 0.563786507f, 0.f),
    C_Vertex3f(0.190957069f, 0.563786507f, -1.f),
    C_Normal3f(0.627488017f, -0.778626204f, 0.f),
    C_Vertex3f(0.180832863f, 0.55661726f, 0.f),
    C_Vertex3f(0.180832863f, 0.55661726f, -1.f),
    C_Normal3f(0.715174079f, -0.698946297f, 0.f),
    C_Vertex3f(0.171385765f, 0.548014164f, 0.f),
    C_Vertex3f(0.171385765f, 0.548014164f, -1.f),
    C_Normal3f(0.77608031f, -0.630634189f, 0.f),
    C_Vertex3f(0.162615776f, 0.537977219f, 0.f),
    C_Vertex3f(0.162615776f, 0.537977219f, -1.f),
    C_Normal3f(0.820468962f, -0.571691275f, 0.f),
    C_Vertex3f(0.158569336f, 0.532241821f, 0.f),
    C_Vertex3f(0.158569336f, 0.532241821f, -1.f),
    C_Normal3f(0.874653757f, -0.484748274f, 0.f),
    C_Vertex3f(0.153518677f, 0.524921417f, 0.f),
    C_Vertex3f(0.153518677f, 0.524921417f, -1.f),
    C_Normal3f(0.920180082f, -0.391495317f, 0.f),
    C_Vertex3f(0.144680023f, 0.507180691f, 0.f),
    C_Vertex3f(0.144680023f, 0.507180691f, -1.f),
    C_Normal3f(0.955114305f, -0.296237677f, 0.f),
    C_Vertex3f(0.137104034f, 0.486340046f, 0.f),
    C_Vertex3f(0.137104034f, 0.486340046f, -1.f),
    C_Normal3f(0.97604543f, -0.217566431f, 0.f),
    C_Vertex3f(0.13079071f, 0.462399483f, 0.f),
    C_Vertex3f(0.13079071f, 0.462399483f, -1.f),
    C_Normal3f(0.988263428f, -0.152759418f, 0.f),
    C_Vertex3f(0.125740051f, 0.435359001f, 0.f),
    C_Vertex3f(0.125740051f, 0.435359001f, -1.f),
    C_Normal3f(0.995075643f, -0.0991190225f, 0.f),
    C_Vertex3f(0.121952057f, 0.405218601f, 0.f),
    C_Vertex3f(0.121952057f, 0.405218601f, -1.f),
    C_Normal3f(0.998521388f, -0.0543599203f, 0.f),
    C_Vertex3f(0.119426727f, 0.371978283f, 0.f),
    C_Vertex3f(0.119426727f, 0.371978283f, -1.f),
    C_Normal3f(0.99986136f, -0.016653141f, 0.f),
    C_Vertex3f(0.118164063f, 0.335638046f, 0.f),
    C_Vertex3f(0.118164063f, 0.335638046f, -1.f),
    C_End(),
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.450086117f, 0.410840988f, 0.f),
    C_Vertex3f(0.450250387f, 0.225471735f, 0.f),
    C_Vertex3f(0.451887608f, 0.391923904f, 0.f),
    C_Vertex3f(0.452420115f, 0.249579072f, 0.f),
    C_Vertex3f(0.453238726f, 0.371785164f, 0.f),
    C_Vertex3f(0.453866601f, 0.275040507f, 0.f),
    C_Vertex3f(0.454139471f, 0.350424767f, 0.f),
    C_Vertex3f(0.454589844f, 0.301856041f, 0.f),
    C_Vertex3f(0.454589844f, 0.327842712f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.428553104f, 0.125246525f, 0.f),
    C_Vertex3f(0.434339046f, 0.14258337f, 0.f),
    C_Vertex3f(0.436574936f, 0.481307983f, 0.f),
    C_Vertex3f(0.439401746f, 0.161274314f, 0.f),
    C_Vertex3f(0.441979408f, 0.460262299f, 0.f),
    C_Vertex3f(0.443741202f, 0.181319356f, 0.f),
    C_Vertex3f(0.445132017f, 0.445010185f, 0.f),
    C_Vertex3f(0.447357416f, 0.202718496f, 0.f),
    C_Vertex3f(0.447834253f, 0.428536415f, 0.f),
    C_Vertex3f(0.450250387f, 0.225471735f, 0.f),
    C_Vertex3f(0.450086117f, 0.410840988f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.406895876f, 0.0791783333f, 0.f),
    C_Vertex3f(0.414831519f, 0.0935440063f, 0.f),
    C_Vertex3f(0.418116093f, 0.531042576f, 0.f),
    C_Vertex3f(0.422050595f, 0.10890007f, 0.f),
    C_Vertex3f(0.42802f, 0.507239819f, 0.f),
    C_Vertex3f(0.428553104f, 0.125246525f, 0.f),
    C_Vertex3f(0.436574936f, 0.481307983f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.373535156f, 0.335692406f, 0.f),
    C_Vertex3f(0.378789544f, 0.0420236588f, 0.f),
    C_Vertex3f(0.379936218f, 0.589512348f, 0.f),
    C_Vertex3f(0.388874888f, 0.0534181595f, 0.f),
    C_Vertex3f(0.39426136f, 0.572260857f, 0.f),
    C_Vertex3f(0.398243666f, 0.065803051f, 0.f),
    C_Vertex3f(0.406863213f, 0.552716255f, 0.f),
    C_Vertex3f(0.406895876f, 0.0791783333f, 0.f),
    C_Vertex3f(0.418116093f, 0.531042576f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.379936218f, 0.589512348f, 0.f),
    C_Vertex3f(0.363887787f, 0.60447073f, 0.f),
    C_Vertex3f(0.366642237f, 0.434428453f, 0.f),
    C_Vertex3f(0.370088696f, 0.404834867f, 0.f),
    C_Vertex3f(0.372386336f, 0.371922851f, 0.f),
    C_Vertex3f(0.373535156f, 0.335692406f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.363887787f, 0.60447073f, 0.f),
    C_Vertex3f(0.346116066f, 0.617136002f, 0.f),
    C_Vertex3f(0.349409938f, 0.50329864f, 0.f),
    C_Vertex3f(0.356302857f, 0.48366034f, 0.f),
    C_Vertex3f(0.362046957f, 0.460703611f, 0.f),
    C_Vertex3f(0.366642237f, 0.434428453f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.31208384f, 0.553747296f, 0.f),
    C_Vertex3f(0.322416186f, 0.543996215f, 0.f),
    C_Vertex3f(0.326621056f, 0.627508163f, 0.f),
    C_Vertex3f(0.332177639f, 0.532619953f, 0.f),
    C_Vertex3f(0.346116066f, 0.617136002f, 0.f),
    C_Vertex3f(0.341368198f, 0.519618511f, 0.f),
    C_Vertex3f(0.349409938f, 0.50329864f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.305558681f, 0.635287285f, 0.f),
    C_Vertex3f(0.282928944f, 0.640473366f, 0.f),
    C_Vertex3f(0.289706469f, 0.568373919f, 0.f),
    C_Vertex3f(0.301180601f, 0.561873198f, 0.f),
    C_Vertex3f(0.31208384f, 0.553747296f, 0.f),
    C_Vertex3f(0.326621056f, 0.627508163f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.238224983f, 0.578125f, 0.f),
    C_Vertex3f(0.251858711f, 0.578125f, 0.f),
    C_Vertex3f(0.258731842f, 0.643066406f, 0.f),
    C_Vertex3f(0.265045524f, 0.57649982f, 0.f),
    C_Vertex3f(0.282928944f, 0.640473366f, 0.f),
    C_Vertex3f(0.277661443f, 0.573249459f, 0.f),
    C_Vertex3f(0.289706469f, 0.568373919f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.190957069f, 0.563786507f, 0.f),
    C_Vertex3f(0.201758385f, 0.569521904f, 0.f),
    C_Vertex3f(0.204412103f, 0.639556646f, 0.f),
    C_Vertex3f(0.213236809f, 0.573823452f, 0.f),
    C_Vertex3f(0.220392108f, 0.641896486f, 0.f),
    C_Vertex3f(0.225392342f, 0.576691151f, 0.f),
    C_Vertex3f(0.23711586f, 0.643066406f, 0.f),
    C_Vertex3f(0.238224983f, 0.578125f, 0.f),
    C_Vertex3f(0.258731842f, 0.643066406f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.162615776f, 0.537977219f, 0.f),
    C_Vertex3f(0.171385765f, 0.548014164f, 0.f),
    C_Vertex3f(0.174683332f, 0.631367207f, 0.f),
    C_Vertex3f(0.180832863f, 0.55661726f, 0.f),
    C_Vertex3f(0.189175844f, 0.636046886f, 0.f),
    C_Vertex3f(0.190957069f, 0.563786507f, 0.f),
    C_Vertex3f(0.204412103f, 0.639556646f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.160934567f, 0.625517607f, 0.f),
    C_Vertex3f(0.147929549f, 0.618498087f, 0.f),
    C_Vertex3f(0.153518677f, 0.524921417f, 0.f),
    C_Vertex3f(0.158569336f, 0.532241821f, 0.f),
    C_Vertex3f(0.162615776f, 0.537977219f, 0.f),
    C_Vertex3f(0.174683332f, 0.631367207f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.125740051f, 0.435359001f, 0.f),
    C_Vertex3f(0.13079071f, 0.462399483f, 0.f),
    C_Vertex3f(0.135668278f, 0.610308647f, 0.f),
    C_Vertex3f(0.137104034f, 0.486340046f, 0.f),
    C_Vertex3f(0.147929549f, 0.618498087f, 0.f),
    C_Vertex3f(0.144680023f, 0.507180691f, 0.f),
    C_Vertex3f(0.153518677f, 0.524921417f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.124150753f, 0.600949287f, 0.f),
    C_Vertex3f(0.113342762f, 0.590592742f, 0.f),
    C_Vertex3f(0.118164063f, 0.335638046f, 0.f),
    C_Vertex3f(0.119426727f, 0.371978283f, 0.f),
    C_Vertex3f(0.121952057f, 0.405218601f, 0.f),
    C_Vertex3f(0.125740051f, 0.435359001f, 0.f),
    C_Vertex3f(0.135668278f, 0.610308647f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.113342762f, 0.590592742f, 0.f),
    C_Vertex3f(0.103244305f, 0.579239011f, 0.f),
    C_Vertex3f(0.107037544f, 0.047129631f, 0.f),
    C_Vertex3f(0.121488094f, 0.0326616764f, 0.f),
    C_Vertex3f(0.118164063f, 0.296167374f, 0.f),
    C_Vertex3f(0.118164063f, 0.335638046f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.378789544f, 0.0420236588f, 0.f),
    C_Vertex3f(0.373535156f, 0.335692406f, 0.f),
    C_Vertex3f(0.373535156f, 0.296221733f, 0.f),
    C_Vertex3f(0.372384429f, 0.260118365f, 0.f),
    C_Vertex3f(0.370082974f, 0.227304101f, 0.f),
    C_Vertex3f(0.367987633f, 0.0316195488f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.370082974f, 0.227304101f, 0.f),
    C_Vertex3f(0.366630793f, 0.19777894f, 0.f),
    C_Vertex3f(0.367987633f, 0.0316195488f, 0.f),
    C_Vertex3f(0.362027884f, 0.171542883f, 0.f),
    C_Vertex3f(0.356469154f, 0.0222058296f, 0.f),
    C_Vertex3f(0.356274247f, 0.148595929f, 0.f),
    C_Vertex3f(0.349369884f, 0.128938079f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.344193459f, 0.0139688253f, 0.f),
    C_Vertex3f(0.356469154f, 0.0222058296f, 0.f),
    C_Vertex3f(0.349369884f, 0.128938079f, 0.f),
    C_Vertex3f(0.341314793f, 0.112569332f, 0.f),
    C_Vertex3f(0.332108974f, 0.0994896889f, 0.f),
    C_Vertex3f(0.331160545f, 0.00690853596f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.301263571f, 0.0700604916f, 0.f),
    C_Vertex3f(0.302823067f, -0.00368189812f, 0.f),
    C_Vertex3f(0.312083364f, 0.0782352686f, 0.f),
    C_Vertex3f(0.317370415f, 0.00102496147f, 0.f),
    C_Vertex3f(0.322365165f, 0.088045001f, 0.f),
    C_Vertex3f(0.331160545f, 0.00690853596f, 0.f),
    C_Vertex3f(0.332108974f, 0.0994896889f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.252604485f, 0.0537109375f, 0.f),
    C_Vertex3f(0.254637718f, -0.0107421875f, 0.f),
    C_Vertex3f(0.265576243f, 0.0553458929f, 0.f),
    C_Vertex3f(0.271456718f, -0.0095654726f, 0.f),
    C_Vertex3f(0.278010011f, 0.0586158037f, 0.f),
    C_Vertex3f(0.287518501f, -0.00721204281f, 0.f),
    C_Vertex3f(0.289905787f, 0.0635206699f, 0.f),
    C_Vertex3f(0.302823067f, -0.00368189812f, 0.f),
    C_Vertex3f(0.301263571f, 0.0700604916f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.239094734f, 0.0537109375f, 0.f),
    C_Vertex3f(0.226122975f, 0.055339098f, 0.f),
    C_Vertex3f(0.234276772f, -0.0107421875f, 0.f),
    C_Vertex3f(0.254637718f, -0.0107421875f, 0.f),
    C_Vertex3f(0.252604485f, 0.0537109375f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.190435648f, 0.0699925423f, 0.f),
    C_Vertex3f(0.191711903f, -0.00454163551f, 0.f),
    C_Vertex3f(0.201793432f, 0.0634799004f, 0.f),
    C_Vertex3f(0.212373257f, -0.00867533684f, 0.f),
    C_Vertex3f(0.213689208f, 0.0585954189f, 0.f),
    C_Vertex3f(0.234276772f, -0.0107421875f, 0.f),
    C_Vertex3f(0.226122975f, 0.055339098f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.179615855f, 0.0781333447f, 0.f),
    C_Vertex3f(0.169334054f, 0.0879023075f, 0.f),
    C_Vertex3f(0.172292709f, 0.00165891647f, 0.f),
    C_Vertex3f(0.191711903f, -0.00454163551f, 0.f),
    C_Vertex3f(0.190435648f, 0.0699925423f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.159590244f, 0.0992994308f, 0.f),
    C_Vertex3f(0.150384426f, 0.112324715f, 0.f),
    C_Vertex3f(0.154115677f, 0.00992631912f, 0.f),
    C_Vertex3f(0.172292709f, 0.00165891647f, 0.f),
    C_Vertex3f(0.169334054f, 0.0879023075f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.142329335f, 0.128659487f, 0.f),
    C_Vertex3f(0.135424972f, 0.148303747f, 0.f),
    C_Vertex3f(0.137180805f, 0.0202605724f, 0.f),
    C_Vertex3f(0.154115677f, 0.00992631912f, 0.f),
    C_Vertex3f(0.150384426f, 0.112324715f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.137180805f, 0.0202605724f, 0.f),
    C_Vertex3f(0.135424972f, 0.148303747f, 0.f),
    C_Vertex3f(0.129671335f, 0.171257496f, 0.f),
    C_Vertex3f(0.125068426f, 0.197520733f, 0.f),
    C_Vertex3f(0.121616244f, 0.227093458f, 0.f),
    C_Vertex3f(0.121488094f, 0.0326616764f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.11931479f, 0.259975672f, 0.f),
    C_Vertex3f(0.118164063f, 0.296167374f, 0.f),
    C_Vertex3f(0.121488094f, 0.0326616764f, 0.f),
    C_Vertex3f(0.121616244f, 0.227093458f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.0772061348f, 0.539194703f, 0.f),
    C_Vertex3f(0.0786657333f, 0.0885920525f, 0.f),
    C_Vertex3f(0.0851759911f, 0.553539991f, 0.f),
    C_Vertex3f(0.0925178528f, 0.0654182434f, 0.f),
    C_Vertex3f(0.093855381f, 0.566888094f, 0.f),
    C_Vertex3f(0.107037544f, 0.047129631f, 0.f),
    C_Vertex3f(0.103244305f, 0.579239011f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.0699458122f, 0.523852229f, 0.f),
    C_Vertex3f(0.0633950233f, 0.507512569f, 0.f),
    C_Vertex3f(0.0667924881f, 0.114897251f, 0.f),
    C_Vertex3f(0.0786657333f, 0.0885920525f, 0.f),
    C_Vertex3f(0.0772061348f, 0.539194703f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.0480617285f, 0.451357484f, 0.f),
    C_Vertex3f(0.0489826202f, 0.176901817f, 0.f),
    C_Vertex3f(0.0524426699f, 0.471457362f, 0.f),
    C_Vertex3f(0.0568981171f, 0.144333839f, 0.f),
    C_Vertex3f(0.0575537682f, 0.490175724f, 0.f),
    C_Vertex3f(0.0667924881f, 0.114897251f, 0.f),
    C_Vertex3f(0.0633950233f, 0.507512569f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.044410944f, 0.429876089f, 0.f),
    C_Vertex3f(0.0414903164f, 0.407013178f, 0.f),
    C_Vertex3f(0.0430459976f, 0.212601185f, 0.f),
    C_Vertex3f(0.0489826202f, 0.176901817f, 0.f),
    C_Vertex3f(0.0480617285f, 0.451357484f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.0392998457f, 0.38276875f, 0.f),
    C_Vertex3f(0.0378395319f, 0.357142806f, 0.f),
    C_Vertex3f(0.0390882492f, 0.251431942f, 0.f),
    C_Vertex3f(0.0430459976f, 0.212601185f, 0.f),
    C_Vertex3f(0.0414903164f, 0.407013178f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.037109375f, 0.330135345f, 0.f),
    C_Vertex3f(0.037109375f, 0.293394089f, 0.f),
    C_Vertex3f(0.0390882492f, 0.251431942f, 0.f),
    C_Vertex3f(0.0378395319f, 0.357142806f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, -1.f),
    C_FrontFace(GL_CW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.450086117f, 0.410840988f, -1.f),
    C_Vertex3f(0.450250387f, 0.225471735f, -1.f),
    C_Vertex3f(0.451887608f, 0.391923904f, -1.f),
    C_Vertex3f(0.452420115f, 0.249579072f, -1.f),
    C_Vertex3f(0.453238726f, 0.371785164f, -1.f),
    C_Vertex3f(0.453866601f, 0.275040507f, -1.f),
    C_Vertex3f(0.454139471f, 0.350424767f, -1.f),
    C_Vertex3f(0.454589844f, 0.301856041f, -1.f),
    C_Vertex3f(0.454589844f, 0.327842712f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.428553104f, 0.125246525f, -1.f),
    C_Vertex3f(0.434339046f, 0.14258337f, -1.f),
    C_Vertex3f(0.436574936f, 0.481307983f, -1.f),
    C_Vertex3f(0.439401746f, 0.161274314f, -1.f),
    C_Vertex3f(0.441979408f, 0.460262299f, -1.f),
    C_Vertex3f(0.443741202f, 0.181319356f, -1.f),
    C_Vertex3f(0.445132017f, 0.445010185f, -1.f),
    C_Vertex3f(0.447357416f, 0.202718496f, -1.f),
    C_Vertex3f(0.447834253f, 0.428536415f, -1.f),
    C_Vertex3f(0.450250387f, 0.225471735f, -1.f),
    C_Vertex3f(0.450086117f, 0.410840988f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.406895876f, 0.0791783333f, -1.f),
    C_Vertex3f(0.414831519f, 0.0935440063f, -1.f),
    C_Vertex3f(0.418116093f, 0.531042576f, -1.f),
    C_Vertex3f(0.422050595f, 0.10890007f, -1.f),
    C_Vertex3f(0.42802f, 0.507239819f, -1.f),
    C_Vertex3f(0.428553104f, 0.125246525f, -1.f),
    C_Vertex3f(0.436574936f, 0.481307983f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.373535156f, 0.335692406f, -1.f),
    C_Vertex3f(0.378789544f, 0.0420236588f, -1.f),
    C_Vertex3f(0.379936218f, 0.589512348f, -1.f),
    C_Vertex3f(0.388874888f, 0.0534181595f, -1.f),
    C_Vertex3f(0.39426136f, 0.572260857f, -1.f),
    C_Vertex3f(0.398243666f, 0.065803051f, -1.f),
    C_Vertex3f(0.406863213f, 0.552716255f, -1.f),
    C_Vertex3f(0.406895876f, 0.0791783333f, -1.f),
    C_Vertex3f(0.418116093f, 0.531042576f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.379936218f, 0.589512348f, -1.f),
    C_Vertex3f(0.363887787f, 0.60447073f, -1.f),
    C_Vertex3f(0.366642237f, 0.434428453f, -1.f),
    C_Vertex3f(0.370088696f, 0.404834867f, -1.f),
    C_Vertex3f(0.372386336f, 0.371922851f, -1.f),
    C_Vertex3f(0.373535156f, 0.335692406f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.363887787f, 0.60447073f, -1.f),
    C_Vertex3f(0.346116066f, 0.617136002f, -1.f),
    C_Vertex3f(0.349409938f, 0.50329864f, -1.f),
    C_Vertex3f(0.356302857f, 0.48366034f, -1.f),
    C_Vertex3f(0.362046957f, 0.460703611f, -1.f),
    C_Vertex3f(0.366642237f, 0.434428453f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.31208384f, 0.553747296f, -1.f),
    C_Vertex3f(0.322416186f, 0.543996215f, -1.f),
    C_Vertex3f(0.326621056f, 0.627508163f, -1.f),
    C_Vertex3f(0.332177639f, 0.532619953f, -1.f),
    C_Vertex3f(0.346116066f, 0.617136002f, -1.f),
    C_Vertex3f(0.341368198f, 0.519618511f, -1.f),
    C_Vertex3f(0.349409938f, 0.50329864f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.305558681f, 0.635287285f, -1.f),
    C_Vertex3f(0.282928944f, 0.640473366f, -1.f),
    C_Vertex3f(0.289706469f, 0.568373919f, -1.f),
    C_Vertex3f(0.301180601f, 0.561873198f, -1.f),
    C_Vertex3f(0.31208384f, 0.553747296f, -1.f),
    C_Vertex3f(0.326621056f, 0.627508163f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.238224983f, 0.578125f, -1.f),
    C_Vertex3f(0.251858711f, 0.578125f, -1.f),
    C_Vertex3f(0.258731842f, 0.643066406f, -1.f),
    C_Vertex3f(0.265045524f, 0.57649982f, -1.f),
    C_Vertex3f(0.282928944f, 0.640473366f, -1.f),
    C_Vertex3f(0.277661443f, 0.573249459f, -1.f),
    C_Vertex3f(0.289706469f, 0.568373919f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.190957069f, 0.563786507f, -1.f),
    C_Vertex3f(0.201758385f, 0.569521904f, -1.f),
    C_Vertex3f(0.204412103f, 0.639556646f, -1.f),
    C_Vertex3f(0.213236809f, 0.573823452f, -1.f),
    C_Vertex3f(0.220392108f, 0.641896486f, -1.f),
    C_Vertex3f(0.225392342f, 0.576691151f, -1.f),
    C_Vertex3f(0.23711586f, 0.643066406f, -1.f),
    C_Vertex3f(0.238224983f, 0.578125f, -1.f),
    C_Vertex3f(0.258731842f, 0.643066406f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.162615776f, 0.537977219f, -1.f),
    C_Vertex3f(0.171385765f, 0.548014164f, -1.f),
    C_Vertex3f(0.174683332f, 0.631367207f, -1.f),
    C_Vertex3f(0.180832863f, 0.55661726f, -1.f),
    C_Vertex3f(0.189175844f, 0.636046886f, -1.f),
    C_Vertex3f(0.190957069f, 0.563786507f, -1.f),
    C_Vertex3f(0.204412103f, 0.639556646f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.160934567f, 0.625517607f, -1.f),
    C_Vertex3f(0.147929549f, 0.618498087f, -1.f),
    C_Vertex3f(0.153518677f, 0.524921417f, -1.f),
    C_Vertex3f(0.158569336f, 0.532241821f, -1.f),
    C_Vertex3f(0.162615776f, 0.537977219f, -1.f),
    C_Vertex3f(0.174683332f, 0.631367207f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.125740051f, 0.435359001f, -1.f),
    C_Vertex3f(0.13079071f, 0.462399483f, -1.f),
    C_Vertex3f(0.135668278f, 0.610308647f, -1.f),
    C_Vertex3f(0.137104034f, 0.486340046f, -1.f),
    C_Vertex3f(0.147929549f, 0.618498087f, -1.f),
    C_Vertex3f(0.144680023f, 0.507180691f, -1.f),
    C_Vertex3f(0.153518677f, 0.524921417f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.124150753f, 0.600949287f, -1.f),
    C_Vertex3f(0.113342762f, 0.590592742f, -1.f),
    C_Vertex3f(0.118164063f, 0.335638046f, -1.f),
    C_Vertex3f(0.119426727f, 0.371978283f, -1.f),
    C_Vertex3f(0.121952057f, 0.405218601f, -1.f),
    C_Vertex3f(0.125740051f, 0.435359001f, -1.f),
    C_Vertex3f(0.135668278f, 0.610308647f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.113342762f, 0.590592742f, -1.f),
    C_Vertex3f(0.103244305f, 0.579239011f, -1.f),
    C_Vertex3f(0.107037544f, 0.047129631f, -1.f),
    C_Vertex3f(0.121488094f, 0.0326616764f, -1.f),
    C_Vertex3f(0.118164063f, 0.296167374f, -1.f),
    C_Vertex3f(0.118164063f, 0.335638046f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.378789544f, 0.0420236588f, -1.f),
    C_Vertex3f(0.373535156f, 0.335692406f, -1.f),
    C_Vertex3f(0.373535156f, 0.296221733f, -1.f),
    C_Vertex3f(0.372384429f, 0.260118365f, -1.f),
    C_Vertex3f(0.370082974f, 0.227304101f, -1.f),
    C_Vertex3f(0.367987633f, 0.0316195488f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.370082974f, 0.227304101f, -1.f),
    C_Vertex3f(0.366630793f, 0.19777894f, -1.f),
    C_Vertex3f(0.367987633f, 0.0316195488f, -1.f),
    C_Vertex3f(0.362027884f, 0.171542883f, -1.f),
    C_Vertex3f(0.356469154f, 0.0222058296f, -1.f),
    C_Vertex3f(0.356274247f, 0.148595929f, -1.f),
    C_Vertex3f(0.349369884f, 0.128938079f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.344193459f, 0.0139688253f, -1.f),
    C_Vertex3f(0.356469154f, 0.0222058296f, -1.f),
    C_Vertex3f(0.349369884f, 0.128938079f, -1.f),
    C_Vertex3f(0.341314793f, 0.112569332f, -1.f),
    C_Vertex3f(0.332108974f, 0.0994896889f, -1.f),
    C_Vertex3f(0.331160545f, 0.00690853596f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.301263571f, 0.0700604916f, -1.f),
    C_Vertex3f(0.302823067f, -0.00368189812f, -1.f),
    C_Vertex3f(0.312083364f, 0.0782352686f, -1.f),
    C_Vertex3f(0.317370415f, 0.00102496147f, -1.f),
    C_Vertex3f(0.322365165f, 0.088045001f, -1.f),
    C_Vertex3f(0.331160545f, 0.00690853596f, -1.f),
    C_Vertex3f(0.332108974f, 0.0994896889f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.252604485f, 0.0537109375f, -1.f),
    C_Vertex3f(0.254637718f, -0.0107421875f, -1.f),
    C_Vertex3f(0.265576243f, 0.0553458929f, -1.f),
    C_Vertex3f(0.271456718f, -0.0095654726f, -1.f),
    C_Vertex3f(0.278010011f, 0.0586158037f, -1.f),
    C_Vertex3f(0.287518501f, -0.00721204281f, -1.f),
    C_Vertex3f(0.289905787f, 0.0635206699f, -1.f),
    C_Vertex3f(0.302823067f, -0.00368189812f, -1.f),
    C_Vertex3f(0.301263571f, 0.0700604916f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.239094734f, 0.0537109375f, -1.f),
    C_Vertex3f(0.226122975f, 0.055339098f, -1.f),
    C_Vertex3f(0.234276772f, -0.0107421875f, -1.f),
    C_Vertex3f(0.254637718f, -0.0107421875f, -1.f),
    C_Vertex3f(0.252604485f, 0.0537109375f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.190435648f, 0.0699925423f, -1.f),
    C_Vertex3f(0.191711903f, -0.00454163551f, -1.f),
    C_Vertex3f(0.201793432f, 0.0634799004f, -1.f),
    C_Vertex3f(0.212373257f, -0.00867533684f, -1.f),
    C_Vertex3f(0.213689208f, 0.0585954189f, -1.f),
    C_Vertex3f(0.234276772f, -0.0107421875f, -1.f),
    C_Vertex3f(0.226122975f, 0.055339098f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.179615855f, 0.0781333447f, -1.f),
    C_Vertex3f(0.169334054f, 0.0879023075f, -1.f),
    C_Vertex3f(0.172292709f, 0.00165891647f, -1.f),
    C_Vertex3f(0.191711903f, -0.00454163551f, -1.f),
    C_Vertex3f(0.190435648f, 0.0699925423f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.159590244f, 0.0992994308f, -1.f),
    C_Vertex3f(0.150384426f, 0.112324715f, -1.f),
    C_Vertex3f(0.154115677f, 0.00992631912f, -1.f),
    C_Vertex3f(0.172292709f, 0.00165891647f, -1.f),
    C_Vertex3f(0.169334054f, 0.0879023075f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.142329335f, 0.128659487f, -1.f),
    C_Vertex3f(0.135424972f, 0.148303747f, -1.f),
    C_Vertex3f(0.137180805f, 0.0202605724f, -1.f),
    C_Vertex3f(0.154115677f, 0.00992631912f, -1.f),
    C_Vertex3f(0.150384426f, 0.112324715f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.137180805f, 0.0202605724f, -1.f),
    C_Vertex3f(0.135424972f, 0.148303747f, -1.f),
    C_Vertex3f(0.129671335f, 0.171257496f, -1.f),
    C_Vertex3f(0.125068426f, 0.197520733f, -1.f),
    C_Vertex3f(0.121616244f, 0.227093458f, -1.f),
    C_Vertex3f(0.121488094f, 0.0326616764f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.11931479f, 0.259975672f, -1.f),
    C_Vertex3f(0.118164063f, 0.296167374f, -1.f),
    C_Vertex3f(0.121488094f, 0.0326616764f, -1.f),
    C_Vertex3f(0.121616244f, 0.227093458f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.0772061348f, 0.539194703f, -1.f),
    C_Vertex3f(0.0786657333f, 0.0885920525f, -1.f),
    C_Vertex3f(0.0851759911f, 0.553539991f, -1.f),
    C_Vertex3f(0.0925178528f, 0.0654182434f, -1.f),
    C_Vertex3f(0.093855381f, 0.566888094f, -1.f),
    C_Vertex3f(0.107037544f, 0.047129631f, -1.f),
    C_Vertex3f(0.103244305f, 0.579239011f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.0699458122f, 0.523852229f, -1.f),
    C_Vertex3f(0.0633950233f, 0.507512569f, -1.f),
    C_Vertex3f(0.0667924881f, 0.114897251f, -1.f),
    C_Vertex3f(0.0786657333f, 0.0885920525f, -1.f),
    C_Vertex3f(0.0772061348f, 0.539194703f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.0480617285f, 0.451357484f, -1.f),
    C_Vertex3f(0.0489826202f, 0.176901817f, -1.f),
    C_Vertex3f(0.0524426699f, 0.471457362f, -1.f),
    C_Vertex3f(0.0568981171f, 0.144333839f, -1.f),
    C_Vertex3f(0.0575537682f, 0.490175724f, -1.f),
    C_Vertex3f(0.0667924881f, 0.114897251f, -1.f),
    C_Vertex3f(0.0633950233f, 0.507512569f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.044410944f, 0.429876089f, -1.f),
    C_Vertex3f(0.0414903164f, 0.407013178f, -1.f),
    C_Vertex3f(0.0430459976f, 0.212601185f, -1.f),
    C_Vertex3f(0.0489826202f, 0.176901817f, -1.f),
    C_Vertex3f(0.0480617285f, 0.451357484f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.0392998457f, 0.38276875f, -1.f),
    C_Vertex3f(0.0378395319f, 0.357142806f, -1.f),
    C_Vertex3f(0.0390882492f, 0.251431942f, -1.f),
    C_Vertex3f(0.0430459976f, 0.212601185f, -1.f),
    C_Vertex3f(0.0414903164f, 0.407013178f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.037109375f, 0.330135345f, -1.f),
    C_Vertex3f(0.037109375f, 0.293394089f, -1.f),
    C_Vertex3f(0.0390882492f, 0.251431942f, -1.f),
    C_Vertex3f(0.0378395319f, 0.357142806f, -1.f),
    C_End(),
    C_Translatef(0.497558594f, 0.f, 0.f),
};
static const Call char_49[] = {
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_FrontFace(GL_CW),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.f, -1.f, 0.f),
    C_Vertex3f(0.333007813f, 0.f, 0.f),
    C_Vertex3f(0.333007813f, 0.f, -1.f),
    C_Vertex3f(0.254394531f, 0.f, -1.f),
    C_Vertex3f(0.254394531f, 0.f, 0.f),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.254394531f, 0.f, 0.f),
    C_Vertex3f(0.254394531f, 0.f, -1.f),
    C_Vertex3f(0.254394531f, 0.501083374f, -1.f),
    C_Vertex3f(0.254394531f, 0.501083374f, 0.f),
    C_End(),
    C_Begin(GL_QUAD_STRIP),
    C_Normal3f(0.6902861f, -0.723536551f, 0.f),
    C_Vertex3f(0.254394531f, 0.501083374f, 0.f),
    C_Vertex3f(0.254394531f, 0.501083374f, -1.f),
    C_Normal3f(0.653910816f, -0.75657171f, 0.f),
    C_Vertex3f(0.247297287f, 0.494312286f, 0.f),
    C_Vertex3f(0.247297287f, 0.494312286f, -1.f),
    C_Normal3f(0.611769915f, -0.791035771f, 0.f),
    C_Vertex3f(0.230892181f, 0.480770111f, 0.f),
    C_Vertex3f(0.230892181f, 0.480770111f, -1.f),
    C_Normal3f(0.566073596f, -0.824354649f, 0.f),
    C_Vertex3f(0.212276459f, 0.467227936f, 0.f),
    C_Vertex3f(0.212276459f, 0.467227936f, -1.f),
    C_Normal3f(0.525384963f, -0.850864589f, 0.f),
    C_Vertex3f(0.191450119f, 0.45368576f, 0.f),
    C_Vertex3f(0.191450119f, 0.45368576f, -1.f),
    C_Normal3f(0.492245495f, -0.870456457f, 0.f),
    C_Vertex3f(0.168413162f, 0.440143585f, 0.f),
    C_Vertex3f(0.168413162f, 0.440143585f, -1.f),
    C_Normal3f(0.459338963f, -0.88826102f, 0.f),
    C_Vertex3f(0.146549225f, 0.428294182f, 0.f),
    C_Vertex3f(0.146549225f, 0.428294182f, -1.f),
    C_Normal3f(0.420222044f, -0.90742135f, 0.f),
    C_Vertex3f(0.125858307f, 0.41813755f, 0.f),
    C_Vertex3f(0.125858307f, 0.41813755f, -1.f),
    C_Normal3f(0.381733924f, -0.924272299f, 0.f),
    C_Vertex3f(0.106340408f, 0.409673691f, 0.f),
    C_Vertex3f(0.106340408f, 0.409673691f, -1.f),
    C_Normal3f(0.346265763f, -0.938136399f, 0.f),
    C_Vertex3f(0.0971679688f, 0.406288147f, 0.f),
    C_Vertex3f(0.0971679688f, 0.406288147f, -1.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.0971679688f, 0.406288147f, 0.f),
    C_Vertex3f(0.0971679688f, 0.406288147f, -1.f),
    C_Vertex3f(0.0971679688f, 0.482299805f, -1.f),
    C_Vertex3f(0.0971679688f, 0.482299805f, 0.f),
    C_End(),
    C_Begin(GL_QUAD_STRIP),
    C_Normal3f(-0.425645769f, 0.904889882f, 0.f),
    C_Vertex3f(0.0971679688f, 0.482299805f, 0.f),
    C_Vertex3f(0.0971679688f, 0.482299805f, -1.f),
    C_Normal3f(-0.465204477f, 0.885203242f, 0.f),
    C_Vertex3f(0.11365509f, 0.490055084f, 0.f),
    C_Vertex3f(0.11365509f, 0.490055084f, -1.f),
    C_Normal3f(-0.515538633f, 0.8568663f, 0.f),
    C_Vertex3f(0.144554615f, 0.507203102f, 0.f),
    C_Vertex3f(0.144554615f, 0.507203102f, -1.f),
    C_Normal3f(-0.576477826f, 0.817112803f, 0.f),
    C_Vertex3f(0.173379421f, 0.525988579f, 0.f),
    C_Vertex3f(0.173379421f, 0.525988579f, -1.f),
    C_Normal3f(-0.636894226f, 0.770951271f, 0.f),
    C_Vertex3f(0.200129509f, 0.546411514f, 0.f),
    C_Vertex3f(0.200129509f, 0.546411514f, -1.f),
    C_Normal3f(-0.691507041f, 0.722369671f, 0.f),
    C_Vertex3f(0.224804878f, 0.568471909f, 0.f),
    C_Vertex3f(0.224804878f, 0.568471909f, -1.f),
    C_Normal3f(-0.745715618f, 0.666264415f, 0.f),
    C_Vertex3f(0.245877743f, 0.590205193f, 0.f),
    C_Vertex3f(0.245877743f, 0.590205193f, -1.f),
    C_Normal3f(-0.804754436f, 0.593607783f, 0.f),
    C_Vertex3f(0.263348103f, 0.611611366f, 0.f),
    C_Vertex3f(0.263348103f, 0.611611366f, -1.f),
    C_Normal3f(-0.855958343f, 0.517044723f, 0.f),
    C_Vertex3f(0.277215958f, 0.63269043f, 0.f),
    C_Vertex3f(0.277215958f, 0.63269043f, -1.f),
    C_Normal3f(-0.896330357f, 0.443386942f, 0.f),
    C_Vertex3f(0.282348633f, 0.643066406f, 0.f),
    C_Vertex3f(0.282348633f, 0.643066406f, -1.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.282348633f, 0.643066406f, 0.f),
    C_Vertex3f(0.282348633f, 0.643066406f, -1.f),
    C_Vertex3f(0.333007813f, 0.643066406f, -1.f),
    C_Vertex3f(0.333007813f, 0.643066406f, 0.f),
    C_Normal3f(0.99999994f, 0.f, 0.f),
    C_Vertex3f(0.333007813f, 0.643066406f, 0.f),
    C_Vertex3f(0.333007813f, 0.643066406f, -1.f),
    C_Vertex3f(0.333007813f, 0.f, -1.f),
    C_Vertex3f(0.333007813f, 0.f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.146549225f, 0.428294182f, 0.f),
    C_Vertex3f(0.168413162f, 0.440143585f, 0.f),
    C_Vertex3f(0.173379421f, 0.525988579f, 0.f),
    C_Vertex3f(0.191450119f, 0.45368576f, 0.f),
    C_Vertex3f(0.200129509f, 0.546411514f, 0.f),
    C_Vertex3f(0.212276459f, 0.467227936f, 0.f),
    C_Vertex3f(0.224804878f, 0.568471909f, 0.f),
    C_Vertex3f(0.230892181f, 0.480770111f, 0.f),
    C_Vertex3f(0.245877743f, 0.590205193f, 0.f),
    C_Vertex3f(0.247297287f, 0.494312286f, 0.f),
    C_Vertex3f(0.263348103f, 0.611611366f, 0.f),
    C_Vertex3f(0.254394531f, 0.501083374f, 0.f),
    C_Vertex3f(0.333007813f, 0.f, 0.f),
    C_Vertex3f(0.254394531f, 0.f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.0971679688f, 0.482299805f, 0.f),
    C_Vertex3f(0.106340408f, 0.409673691f, 0.f),
    C_Vertex3f(0.11365509f, 0.490055084f, 0.f),
    C_Vertex3f(0.125858307f, 0.41813755f, 0.f),
    C_Vertex3f(0.144554615f, 0.507203102f, 0.f),
    C_Vertex3f(0.146549225f, 0.428294182f, 0.f),
    C_Vertex3f(0.173379421f, 0.525988579f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.333007813f, 0.f, 0.f),
    C_Vertex3f(0.333007813f, 0.643066406f, 0.f),
    C_Vertex3f(0.282348633f, 0.643066406f, 0.f),
    C_Vertex3f(0.277215958f, 0.63269043f, 0.f),
    C_Vertex3f(0.263348103f, 0.611611366f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.106340408f, 0.409673691f, 0.f),
    C_Vertex3f(0.0971679688f, 0.482299805f, 0.f),
    C_Vertex3f(0.0971679688f, 0.406288147f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, -1.f),
    C_FrontFace(GL_CW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.146549225f, 0.428294182f, -1.f),
    C_Vertex3f(0.168413162f, 0.440143585f, -1.f),
    C_Vertex3f(0.173379421f, 0.525988579f, -1.f),
    C_Vertex3f(0.191450119f, 0.45368576f, -1.f),
    C_Vertex3f(0.200129509f, 0.546411514f, -1.f),
    C_Vertex3f(0.212276459f, 0.467227936f, -1.f),
    C_Vertex3f(0.224804878f, 0.568471909f, -1.f),
    C_Vertex3f(0.230892181f, 0.480770111f, -1.f),
    C_Vertex3f(0.245877743f, 0.590205193f, -1.f),
    C_Vertex3f(0.247297287f, 0.494312286f, -1.f),
    C_Vertex3f(0.263348103f, 0.611611366f, -1.f),
    C_Vertex3f(0.254394531f, 0.501083374f, -1.f),
    C_Vertex3f(0.333007813f, 0.f, -1.f),
    C_Vertex3f(0.254394531f, 0.f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.0971679688f, 0.482299805f, -1.f),
    C_Vertex3f(0.106340408f, 0.409673691f, -1.f),
    C_Vertex3f(0.11365509f, 0.490055084f, -1.f),
    C_Vertex3f(0.125858307f, 0.41813755f, -1.f),
    C_Vertex3f(0.144554615f, 0.507203102f, -1.f),
    C_Vertex3f(0.146549225f, 0.428294182f, -1.f),
    C_Vertex3f(0.173379421f, 0.525988579f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.333007813f, 0.f, -1.f),
    C_Vertex3f(0.333007813f, 0.643066406f, -1.f),
    C_Vertex3f(0.282348633f, 0.643066406f, -1.f),
    C_Vertex3f(0.277215958f, 0.63269043f, -1.f),
    C_Vertex3f(0.263348103f, 0.611611366f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.106340408f, 0.409673691f, -1.f),
    C_Vertex3f(0.0971679688f, 0.482299805f, -1.f),
    C_Vertex3f(0.0971679688f, 0.406288147f, -1.f),
    C_End(),
    C_Translatef(0.497558594f, 0.f, 0.f),
};
static const Call char_50[] = {
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_FrontFace(GL_CW),
    C_Begin(GL_QUADS),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.450195313f, 0.0756835938f, 0.f),
    C_Vertex3f(0.450195313f, 0.0756835938f, -1.f),
    C_Vertex3f(0.450195313f, 0.f, -1.f),
    C_Vertex3f(0.450195313f, 0.f, 0.f),
    C_Normal3f(-0.f, -0.99999994f, 0.f),
    C_Vertex3f(0.450195313f, 0.f, 0.f),
    C_Vertex3f(0.450195313f, 0.f, -1.f),
    C_Vertex3f(0.0268554688f, 0.f, -1.f),
    C_Vertex3f(0.0268554688f, 0.f, 0.f),
    C_End(),
    C_Begin(GL_QUAD_STRIP),
    C_Normal3f(-0.999532521f, -0.0305733047f, 0.f),
    C_Vertex3f(0.0268554688f, 0.f, 0.f),
    C_Vertex3f(0.0268554688f, 0.f, -1.f),
    C_Normal3f(-0.999426425f, 0.0338650495f, 0.f),
    C_Vertex3f(0.026638031f, 0.00710868835f, 0.f),
    C_Vertex3f(0.026638031f, 0.00710868835f, -1.f),
    C_Normal3f(-0.99323982f, 0.116080932f, 0.f),
    C_Vertex3f(0.0275688171f, 0.0210523605f, 0.f),
    C_Vertex3f(0.0275688171f, 0.0210523605f, -1.f),
    C_Normal3f(-0.976614296f, 0.214998975f, 0.f),
    C_Vertex3f(0.0298652649f, 0.0347223282f, 0.f),
    C_Vertex3f(0.0298652649f, 0.0347223282f, -1.f),
    C_Normal3f(-0.949056089f, 0.315107435f, 0.f),
    C_Vertex3f(0.0335273743f, 0.0481185913f, 0.f),
    C_Vertex3f(0.0335273743f, 0.0481185913f, -1.f),
    C_Normal3f(-0.915489316f, 0.40234229f, 0.f),
    C_Vertex3f(0.0400867462f, 0.0655078888f, 0.f),
    C_Vertex3f(0.0400867462f, 0.0655078888f, -1.f),
    C_Normal3f(-0.8766855f, 0.481063932f, 0.f),
    C_Vertex3f(0.050611496f, 0.086991787f, 0.f),
    C_Vertex3f(0.050611496f, 0.086991787f, -1.f),
    C_Normal3f(-0.831598759f, 0.555376887f, 0.f),
    C_Vertex3f(0.0635700226f, 0.108303547f, 0.f),
    C_Vertex3f(0.0635700226f, 0.108303547f, -1.f),
    C_Normal3f(-0.788429916f, 0.615124643f, 0.f),
    C_Vertex3f(0.078962326f, 0.129443169f, 0.f),
    C_Vertex3f(0.078962326f, 0.129443169f, -1.f),
    C_Normal3f(-0.752858877f, 0.658182085f, 0.f),
    C_Vertex3f(0.0923318863f, 0.145168781f, 0.f),
    C_Vertex3f(0.0923318863f, 0.145168781f, -1.f),
    C_Normal3f(-0.729794562f, 0.683666468f, 0.f),
    C_Vertex3f(0.102230549f, 0.156058431f, 0.f),
    C_Vertex3f(0.102230549f, 0.156058431f, -1.f),
    C_Normal3f(-0.710849822f, 0.703343868f, 0.f),
    C_Vertex3f(0.113114834f, 0.167353988f, 0.f),
    C_Vertex3f(0.113114834f, 0.167353988f, -1.f),
    C_Normal3f(-0.693628967f, 0.720332503f, 0.f),
    C_Vertex3f(0.124984741f, 0.179055452f, 0.f),
    C_Vertex3f(0.124984741f, 0.179055452f, -1.f),
    C_Normal3f(-0.677946448f, 0.735111356f, 0.f),
    C_Vertex3f(0.137840271f, 0.191162825f, 0.f),
    C_Vertex3f(0.137840271f, 0.191162825f, -1.f),
    C_Normal3f(-0.663632751f, 0.748058558f, 0.f),
    C_Vertex3f(0.151681423f, 0.203676105f, 0.f),
    C_Vertex3f(0.151681423f, 0.203676105f, -1.f),
    C_Normal3f(-0.65053606f, 0.75947535f, 0.f),
    C_Vertex3f(0.166508198f, 0.216595292f, 0.f),
    C_Vertex3f(0.166508198f, 0.216595292f, -1.f),
    C_Normal3f(-0.638614714f, 0.76952666f, 0.f),
    C_Vertex3f(0.182320595f, 0.229920387f, 0.f),
    C_Vertex3f(0.182320595f, 0.229920387f, -1.f),
    C_Normal3f(-0.641009688f, 0.767532766f, 0.f),
    C_Vertex3f(0.203754425f, 0.247505188f, 0.f),
    C_Vertex3f(0.203754425f, 0.247505188f, -1.f),
    C_Normal3f(-0.653400242f, 0.757012606f, 0.f),
    C_Vertex3f(0.227708578f, 0.267826438f, 0.f),
    C_Vertex3f(0.227708578f, 0.267826438f, -1.f),
    C_Normal3f(-0.66782409f, 0.744319141f, 0.f),
    C_Vertex3f(0.249547243f, 0.287030339f, 0.f),
    C_Vertex3f(0.249547243f, 0.287030339f, -1.f),
    C_Normal3f(-0.684544384f, 0.728971183f, 0.f),
    C_Vertex3f(0.26927042f, 0.305116892f, 0.f),
    C_Vertex3f(0.26927042f, 0.305116892f, -1.f),
    C_Normal3f(-0.704109609f, 0.710091352f, 0.f),
    C_Vertex3f(0.286878109f, 0.322086096f, 0.f),
    C_Vertex3f(0.286878109f, 0.322086096f, -1.f),
    C_Normal3f(-0.727229178f, 0.686394691f, 0.f),
    C_Vertex3f(0.30237031f, 0.337937951f, 0.f),
    C_Vertex3f(0.30237031f, 0.337937951f, -1.f),
    C_Normal3f(-0.754812241f, 0.65594089f, 0.f),
    C_Vertex3f(0.315747023f, 0.352672458f, 0.f),
    C_Vertex3f(0.315747023f, 0.352672458f, -1.f),
    C_Normal3f(-0.787979245f, 0.615701735f, 0.f),
    C_Vertex3f(0.327008247f, 0.366289616f, 0.f),
    C_Vertex3f(0.327008247f, 0.366289616f, -1.f),
    C_Normal3f(-0.822872043f, 0.568226695f, 0.f),
    C_Vertex3f(0.336153984f, 0.378789425f, 0.f),
    C_Vertex3f(0.336153984f, 0.378789425f, -1.f),
    C_Normal3f(-0.854991615f, 0.518641889f, 0.f),
    C_Vertex3f(0.344156504f, 0.391122699f, 0.f),
    C_Vertex3f(0.344156504f, 0.391122699f, -1.f),
    C_Normal3f(-0.887087941f, 0.461600602f, 0.f),
    C_Vertex3f(0.351015806f, 0.403289437f, 0.f),
    C_Vertex3f(0.351015806f, 0.403289437f, -1.f),
    C_Normal3f(-0.918103635f, 0.3963404f, 0.f),
    C_Vertex3f(0.356731892f, 0.41528964f, 0.f),
    C_Vertex3f(0.356731892f, 0.41528964f, -1.f),
    C_Normal3f(-0.946622252f, 0.322344899f, 0.f),
    C_Vertex3f(0.36130476f, 0.427123308f, 0.f),
    C_Vertex3f(0.36130476f, 0.427123308f, -1.f),
    C_Normal3f(-0.970885813f, 0.239542961f, 0.f),
    C_Vertex3f(0.364734411f, 0.438790441f, 0.f),
    C_Vertex3f(0.364734411f, 0.438790441f, -1.f),
    C_Normal3f(-0.988908052f, 0.148529023f, 0.f),
    C_Vertex3f(0.367020845f, 0.450291038f, 0.f),
    C_Vertex3f(0.367020845f, 0.450291038f, -1.f),
    C_Normal3f(-0.998740673f, 0.0501700975f, 0.f),
    C_Vertex3f(0.368164063f, 0.461625099f, 0.f),
    C_Vertex3f(0.368164063f, 0.461625099f, -1.f),
    C_Normal3f(-0.9989416f, -0.0459977314f, 0.f),
    C_Vertex3f(0.368164063f, 0.473049164f, 0.f),
    C_Vertex3f(0.368164063f, 0.473049164f, -1.f),
    C_Normal3f(-0.990030706f, -0.140851796f, 0.f),
    C_Vertex3f(0.36712122f, 0.484272718f, 0.f),
    C_Vertex3f(0.36712122f, 0.484272718f, -1.f),
    C_Normal3f(-0.970733225f, -0.240160361f, 0.f),
    C_Vertex3f(0.365035534f, 0.495039225f, 0.f),
    C_Vertex3f(0.365035534f, 0.495039225f, -1.f),
    C_Normal3f(-0.940267205f, -0.340437531f, 0.f),
    C_Vertex3f(0.361907005f, 0.505348682f, 0.f),
    C_Vertex3f(0.361907005f, 0.505348682f, -1.f),
    C_Normal3f(-0.898834109f, -0.438288927f, 0.f),
    C_Vertex3f(0.357735634f, 0.515201092f, 0.f),
    C_Vertex3f(0.357735634f, 0.515201092f, -1.f),
    C_Normal3f(-0.847733676f, -0.530421972f, 0.f),
    C_Vertex3f(0.35252142f, 0.524596453f, 0.f),
    C_Vertex3f(0.35252142f, 0.524596453f, -1.f),
    C_Normal3f(-0.789167821f, -0.614177644f, 0.f),
    C_Vertex3f(0.346264362f, 0.533534765f, 0.f),
    C_Vertex3f(0.346264362f, 0.533534765f, -1.f),
    C_Normal3f(-0.7258237f, -0.687880754f, 0.f),
    C_Vertex3f(0.338964462f, 0.542016029f, 0.f),
    C_Vertex3f(0.338964462f, 0.542016029f, -1.f),
    C_Normal3f(-0.655801713f, -0.754933178f, 0.f),
    C_Vertex3f(0.330621719f, 0.550040245f, 0.f),
    C_Vertex3f(0.330621719f, 0.550040245f, -1.f),
    C_Normal3f(-0.574280977f, -0.818658292f, 0.f),
    C_Vertex3f(0.321644783f, 0.557061434f, 0.f),
    C_Vertex3f(0.321644783f, 0.557061434f, -1.f),
    C_Normal3f(-0.485707998f, -0.87412113f, 0.f),
    C_Vertex3f(0.312033653f, 0.563079596f, 0.f),
    C_Vertex3f(0.312033653f, 0.563079596f, -1.f),
    C_Normal3f(-0.392953336f, -0.919558346f, 0.f),
    C_Vertex3f(0.30178833f, 0.56809473f, 0.f),
    C_Vertex3f(0.30178833f, 0.56809473f, -1.f),
    C_Normal3f(-0.299179584f, -0.95419687f, 0.f),
    C_Vertex3f(0.290908813f, 0.572106838f, 0.f),
    C_Vertex3f(0.290908813f, 0.572106838f, -1.f),
    C_Normal3f(-0.207346141f, -0.97826767f, 0.f),
    C_Vertex3f(0.279395103f, 0.575115919f, 0.f),
    C_Vertex3f(0.279395103f, 0.575115919f, -1.f),
    C_Normal3f(-0.119831458f, -0.992794275f, 0.f),
    C_Vertex3f(0.2672472f, 0.577121973f, 0.f),
    C_Vertex3f(0.2672472f, 0.577121973f, -1.f),
    C_Normal3f(-0.0377108715f, -0.999288738f, 0.f),
    C_Vertex3f(0.254465103f, 0.578125f, 0.f),
    C_Vertex3f(0.254465103f, 0.578125f, -1.f),
    C_Normal3f(0.0390183516f, -0.999238491f, 0.f),
    C_Vertex3f(0.240668297f, 0.578125f, 0.f),
    C_Vertex3f(0.240668297f, 0.578125f, -1.f),
    C_Normal3f(0.120883375f, -0.992666721f, 0.f),
    C_Vertex3f(0.227199793f, 0.577060342f, 0.f),
    C_Vertex3f(0.227199793f, 0.577060342f, -1.f),
    C_Normal3f(0.209783167f, -0.977747917f, 0.f),
    C_Vertex3f(0.214440107f, 0.574931026f, 0.f),
    C_Vertex3f(0.214440107f, 0.574931026f, -1.f),
    C_Normal3f(0.303551555f, -0.952815056f, 0.f),
    C_Vertex3f(0.20238924f, 0.571737051f, 0.f),
    C_Vertex3f(0.20238924f, 0.571737051f, -1.f),
    C_Normal3f(0.399689019f, -0.916650832f, 0.f),
    C_Vertex3f(0.191047192f, 0.567478418f, 0.f),
    C_Vertex3f(0.191047192f, 0.567478418f, -1.f),
    C_Normal3f(0.494991928f, -0.868897498f, 0.f),
    C_Vertex3f(0.180413961f, 0.562155128f, 0.f),
    C_Vertex3f(0.180413961f, 0.562155128f, -1.f),
    C_Normal3f(0.585969567f, -0.810333073f, 0.f),
    C_Vertex3f(0.17048955f, 0.555767179f, 0.f),
    C_Vertex3f(0.17048955f, 0.555767179f, -1.f),
    C_Normal3f(0.669421732f, -0.74288249f, 0.f),
    C_Vertex3f(0.161273956f, 0.548314571f, 0.f),
    C_Vertex3f(0.161273956f, 0.548314571f, -1.f),
    C_Normal3f(0.74545902f, -0.666551352f, 0.f),
    C_Vertex3f(0.152767181f, 0.539797306f, 0.f),
    C_Vertex3f(0.152767181f, 0.539797306f, -1.f),
    C_Normal3f(0.814887226f, -0.579619527f, 0.f),
    C_Vertex3f(0.145310163f, 0.530460954f, 0.f),
    C_Vertex3f(0.145310163f, 0.530460954f, -1.f),
    C_Normal3f(0.873702347f, -0.486460924f, 0.f),
    C_Vertex3f(0.138902903f, 0.520305514f, 0.f),
    C_Vertex3f(0.138902903f, 0.520305514f, -1.f),
    C_Normal3f(0.92049402f, -0.390756786f, 0.f),
    C_Vertex3f(0.133545399f, 0.509330988f, 0.f),
    C_Vertex3f(0.133545399f, 0.509330988f, -1.f),
    C_Normal3f(0.955159783f, -0.296090901f, 0.f),
    C_Vertex3f(0.129237652f, 0.497537374f, 0.f),
    C_Vertex3f(0.129237652f, 0.497537374f, -1.f),
    C_Normal3f(0.978677094f, -0.205404967f, 0.f),
    C_Vertex3f(0.125979662f, 0.484924674f, 0.f),
    C_Vertex3f(0.125979662f, 0.484924674f, -1.f),
    C_Normal3f(0.992685616f, -0.120728396f, 0.f),
    C_Vertex3f(0.123771429f, 0.471492887f, 0.f),
    C_Vertex3f(0.123771429f, 0.471492887f, -1.f),
    C_Normal3f(0.998453915f, -0.0555846989f, 0.f),
    C_Vertex3f(0.122612953f, 0.457242012f, 0.f),
    C_Vertex3f(0.122612953f, 0.457242012f, -1.f),
    C_Normal3f(0.999974012f, -0.00721408939f, 0.f),
    C_Vertex3f(0.122558594f, 0.449707031f, 0.f),
    C_Vertex3f(0.122558594f, 0.449707031f, -1.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.10187681f, -0.994797051f, 0.f),
    C_Vertex3f(0.122558594f, 0.449707031f, 0.f),
    C_Vertex3f(0.122558594f, 0.449707031f, -1.f),
    C_Vertex3f(0.0415039063f, 0.458007813f, -1.f),
    C_Vertex3f(0.0415039063f, 0.458007813f, 0.f),
    C_End(),
    C_Begin(GL_QUAD_STRIP),
    C_Normal3f(-0.99580586f, 0.0914910287f, 0.f),
    C_Vertex3f(0.0415039063f, 0.458007813f, 0.f),
    C_Vertex3f(0.0415039063f, 0.458007813f, -1.f),
    C_Normal3f(-0.990376651f, 0.138397574f, 0.f),
    C_Vertex3f(0.0425415039f, 0.469301224f, 0.f),
    C_Vertex3f(0.0425415039f, 0.469301224f, -1.f),
    C_Normal3f(-0.979543269f, 0.201233596f, 0.f),
    C_Vertex3f(0.0460506678f, 0.490544558f, 0.f),
    C_Vertex3f(0.0460506678f, 0.490544558f, -1.f),
    C_Normal3f(-0.959300697f, 0.282386392f, 0.f),
    C_Vertex3f(0.0509938002f, 0.510444403f, 0.f),
    C_Vertex3f(0.0509938002f, 0.510444403f, -1.f),
    C_Normal3f(-0.929543912f, 0.368711591f, 0.f),
    C_Vertex3f(0.0573709011f, 0.529000759f, 0.f),
    C_Vertex3f(0.0573709011f, 0.529000759f, -1.f),
    C_Normal3f(-0.888824284f, 0.458248258f, 0.f),
    C_Vertex3f(0.0651819706f, 0.546213627f, 0.f),
    C_Vertex3f(0.0651819706f, 0.546213627f, -1.f),
    C_Normal3f(-0.836336195f, 0.548216879f, 0.f),
    C_Vertex3f(0.0744270086f, 0.562083006f, 0.f),
    C_Vertex3f(0.0744270086f, 0.562083006f, -1.f),
    C_Normal3f(-0.772294104f, 0.635265172f, 0.f),
    C_Vertex3f(0.0851060152f, 0.576608896f, 0.f),
    C_Vertex3f(0.0851060152f, 0.576608896f, -1.f),
    C_Normal3f(-0.698141515f, 0.715959787f, 0.f),
    C_Vertex3f(0.0972189903f, 0.589791298f, 0.f),
    C_Vertex3f(0.0972189903f, 0.589791298f, -1.f),
    C_Normal3f(-0.617785335f, 0.786346734f, 0.f),
    C_Vertex3f(0.110765934f, 0.601630211f, 0.f),
    C_Vertex3f(0.110765934f, 0.601630211f, -1.f),
    C_Normal3f(-0.532547772f, 0.846399903f, 0.f),
    C_Vertex3f(0.125473619f, 0.61198926f, 0.f),
    C_Vertex3f(0.125473619f, 0.61198926f, -1.f),
    C_Normal3f(-0.443498164f, 0.896275282f, 0.f),
    C_Vertex3f(0.141342044f, 0.620868444f, 0.f),
    C_Vertex3f(0.141342044f, 0.620868444f, -1.f),
    C_Normal3f(-0.353721142f, 0.935350895f, 0.f),
    C_Vertex3f(0.15837121f, 0.628267765f, 0.f),
    C_Vertex3f(0.15837121f, 0.628267765f, -1.f),
    C_Normal3f(-0.266001403f, 0.963972628f, 0.f),
    C_Vertex3f(0.176561117f, 0.634187222f, 0.f),
    C_Vertex3f(0.176561117f, 0.634187222f, -1.f),
    C_Normal3f(-0.182505667f, 0.983204782f, 0.f),
    C_Vertex3f(0.195911765f, 0.638626814f, 0.f),
    C_Vertex3f(0.195911765f, 0.638626814f, -1.f),
    C_Normal3f(-0.104666635f, 0.994507313f, 0.f),
    C_Vertex3f(0.216423154f, 0.641586542f, 0.f),
    C_Vertex3f(0.216423154f, 0.641586542f, -1.f),
    C_Normal3f(-0.0331516638f, 0.999450326f, 0.f),
    C_Vertex3f(0.238095284f, 0.643066406f, 0.f),
    C_Vertex3f(0.238095284f, 0.643066406f, -1.f),
    C_Normal3f(0.0356260724f, 0.999365151f, 0.f),
    C_Vertex3f(0.261037827f, 0.643066406f, 0.f),
    C_Vertex3f(0.261037827f, 0.643066406f, -1.f),
    C_Normal3f(0.112009667f, 0.993707061f, 0.f),
    C_Vertex3f(0.282888174f, 0.641469598f, 0.f),
    C_Vertex3f(0.282888174f, 0.641469598f, -1.f),
    C_Normal3f(0.195293441f, 0.980744839f, 0.f),
    C_Vertex3f(0.303536654f, 0.638275981f, 0.f),
    C_Vertex3f(0.303536654f, 0.638275981f, -1.f),
    C_Normal3f(0.284318686f, 0.958729923f, 0.f),
    C_Vertex3f(0.322983265f, 0.633485556f, 0.f),
    C_Vertex3f(0.322983265f, 0.633485556f, -1.f),
    C_Normal3f(0.377180696f, 0.926139653f, 0.f),
    C_Vertex3f(0.341228008f, 0.627098322f, 0.f),
    C_Vertex3f(0.341228008f, 0.627098322f, -1.f),
    C_Normal3f(0.471148282f, 0.882054031f, 0.f),
    C_Vertex3f(0.358270884f, 0.61911428f, 0.f),
    C_Vertex3f(0.358270884f, 0.61911428f, -1.f),
    C_Normal3f(0.562903404f, 0.826522648f, 0.f),
    C_Vertex3f(0.374111891f, 0.609533429f, 0.f),
    C_Vertex3f(0.374111891f, 0.609533429f, -1.f),
    C_Normal3f(0.649018824f, 0.760772467f, 0.f),
    C_Vertex3f(0.38875103f, 0.59835577f, 0.f),
    C_Vertex3f(0.38875103f, 0.59835577f, -1.f),
    C_Normal3f(0.722285569f, 0.691594899f, 0.f),
    C_Vertex3f(0.402188301f, 0.585581303f, 0.f),
    C_Vertex3f(0.402188301f, 0.585581303f, -1.f),
    C_Normal3f(0.786860168f, 0.617131352f, 0.f),
    C_Vertex3f(0.413945913f, 0.572042823f, 0.f),
    C_Vertex3f(0.413945913f, 0.572042823f, -1.f),
    C_Normal3f(0.84643209f, 0.532496572f, 0.f),
    C_Vertex3f(0.424023867f, 0.557740331f, 0.f),
    C_Vertex3f(0.424023867f, 0.557740331f, -1.f),
    C_Normal3f(0.898249805f, 0.439485073f, 0.f),
    C_Vertex3f(0.432422161f, 0.542673826f, 0.f),
    C_Vertex3f(0.432422161f, 0.542673826f, -1.f),
    C_Normal3f(0.940103292f, 0.340889901f, 0.f),
    C_Vertex3f(0.439140797f, 0.526843309f, 0.f),
    C_Vertex3f(0.439140797f, 0.526843309f, -1.f),
    C_Normal3f(0.970744789f, 0.240113795f, 0.f),
    C_Vertex3f(0.444179773f, 0.51024878f, 0.f),
    C_Vertex3f(0.444179773f, 0.51024878f, -1.f),
    C_Normal3f(0.990065336f, 0.14060773f, 0.f),
    C_Vertex3f(0.447539091f, 0.492890239f, 0.f),
    C_Vertex3f(0.447539091f, 0.492890239f, -1.f),
    C_Normal3f(0.99898082f, 0.0451363623f, 0.f),
    C_Vertex3f(0.44921875f, 0.474767685f, 0.f),
    C_Vertex3f(0.44921875f, 0.474767685f, -1.f),
    C_Normal3f(0.998674393f, -0.0514739379f, 0.f),
    C_Vertex3f(0.44921875f, 0.455715179f, 0.f),
    C_Vertex3f(0.44921875f, 0.455715179f, -1.f),
    C_Normal3f(0.98815608f, -0.153452113f, 0.f),
    C_Vertex3f(0.447254658f, 0.436661243f, 0.f),
    C_Vertex3f(0.447254658f, 0.436661243f, -1.f),
    C_Normal3f(0.967566907f, -0.252615154f, 0.f),
    C_Vertex3f(0.443326473f, 0.417771816f, 0.f),
    C_Vertex3f(0.443326473f, 0.417771816f, -1.f),
    C_Normal3f(0.938245475f, -0.345970005f, 0.f),
    C_Vertex3f(0.437434196f, 0.399046898f, 0.f),
    C_Vertex3f(0.437434196f, 0.399046898f, -1.f),
    C_Normal3f(0.899177194f, -0.437584817f, 0.f),
    C_Vertex3f(0.429577827f, 0.380486488f, 0.f),
    C_Vertex3f(0.429577827f, 0.380486488f, -1.f),
    C_Normal3f(0.854257643f, -0.519849837f, 0.f),
    C_Vertex3f(0.419130325f, 0.361434937f, 0.f),
    C_Vertex3f(0.419130325f, 0.361434937f, -1.f),
    C_Normal3f(0.809849381f, -0.586637795f, 0.f),
    C_Vertex3f(0.40609169f, 0.341892242f, 0.f),
    C_Vertex3f(0.40609169f, 0.341892242f, -1.f),
    C_Normal3f(0.77064985f, -0.637258768f, 0.f),
    C_Vertex3f(0.390461922f, 0.321858406f, 0.f),
    C_Vertex3f(0.390461922f, 0.321858406f, -1.f),
    C_Normal3f(0.738712132f, -0.674021065f, 0.f),
    C_Vertex3f(0.376796246f, 0.306464672f, 0.f),
    C_Vertex3f(0.376796246f, 0.306464672f, -1.f),
    C_Normal3f(0.717080295f, -0.696990609f, 0.f),
    C_Vertex3f(0.366179824f, 0.295245767f, 0.f),
    C_Vertex3f(0.366179824f, 0.295245767f, -1.f),
    C_Normal3f(0.700935543f, -0.713224709f, 0.f),
    C_Vertex3f(0.354057431f, 0.283070445f, 0.f),
    C_Vertex3f(0.354057431f, 0.283070445f, -1.f),
    C_Normal3f(0.687358856f, -0.726317942f, 0.f),
    C_Vertex3f(0.340429068f, 0.269938707f, 0.f),
    C_Vertex3f(0.340429068f, 0.269938707f, -1.f),
    C_Normal3f(0.675799847f, -0.737085104f, 0.f),
    C_Vertex3f(0.325294733f, 0.255850554f, 0.f),
    C_Vertex3f(0.325294733f, 0.255850554f, -1.f),
    C_Normal3f(0.665849984f, -0.746085703f, 0.f),
    C_Vertex3f(0.308654428f, 0.240805984f, 0.f),
    C_Vertex3f(0.308654428f, 0.240805984f, -1.f),
    C_Normal3f(0.65720129f, -0.753715217f, 0.f),
    C_Vertex3f(0.290508151f, 0.224804997f, 0.f),
    C_Vertex3f(0.290508151f, 0.224804997f, -1.f),
    C_Normal3f(0.649056852f, -0.760739863f, 0.f),
    C_Vertex3f(0.270855904f, 0.207847595f, 0.f),
    C_Vertex3f(0.270855904f, 0.207847595f, -1.f),
    C_Normal3f(0.645620167f, -0.763658643f, 0.f),
    C_Vertex3f(0.251429558f, 0.19146347f, 0.f),
    C_Vertex3f(0.251429558f, 0.19146347f, -1.f),
    C_Normal3f(0.648851573f, -0.760914981f, 0.f),
    C_Vertex3f(0.235319018f, 0.177803636f, 0.f),
    C_Vertex3f(0.235319018f, 0.177803636f, -1.f),
    C_Normal3f(0.653815746f, -0.756653845f, 0.f),
    C_Vertex3f(0.220792413f, 0.165338397f, 0.f),
    C_Vertex3f(0.220792413f, 0.165338397f, -1.f),
    C_Normal3f(0.659955919f, -0.751304328f, 0.f),
    C_Vertex3f(0.207849741f, 0.154067755f, 0.f),
    C_Vertex3f(0.207849741f, 0.154067755f, -1.f),
    C_Normal3f(0.667743862f, -0.744391203f, 0.f),
    C_Vertex3f(0.196491003f, 0.143991709f, 0.f),
    C_Vertex3f(0.196491003f, 0.143991709f, -1.f),
    C_Normal3f(0.677939892f, -0.735117376f, 0.f),
    C_Vertex3f(0.186716199f, 0.135110259f, 0.f),
    C_Vertex3f(0.186716199f, 0.135110259f, -1.f),
    C_Normal3f(0.691851437f, -0.722039938f, 0.f),
    C_Vertex3f(0.178525329f, 0.127423406f, 0.f),
    C_Vertex3f(0.178525329f, 0.127423406f, -1.f),
    C_Normal3f(0.717426002f, -0.696634769f, 0.f),
    C_Vertex3f(0.171918392f, 0.120931149f, 0.f),
    C_Vertex3f(0.171918392f, 0.120931149f, -1.f),
    C_Normal3f(0.764170766f, -0.645013988f, 0.f),
    C_Vertex3f(0.159360886f, 0.107686996f, 0.f),
    C_Vertex3f(0.159360886f, 0.107686996f, -1.f),
    C_Normal3f(0.810201466f, -0.586151481f, 0.f),
    C_Vertex3f(0.14276123f, 0.0863876343f, 0.f),
    C_Vertex3f(0.14276123f, 0.0863876343f, -1.f),
    C_Normal3f(0.852845788f, -0.522162855f, 0.f),
    C_Vertex3f(0.136207581f, 0.0756835938f, 0.f),
    C_Vertex3f(0.136207581f, 0.0756835938f, -1.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.136207581f, 0.0756835938f, 0.f),
    C_Vertex3f(0.136207581f, 0.0756835938f, -1.f),
    C_Vertex3f(0.450195313f, 0.0756835938f, -1.f),
    C_Vertex3f(0.450195313f, 0.0756835938f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.136207581f, 0.0756835938f, 0.f),
    C_Vertex3f(0.14276123f, 0.0863876343f, 0.f),
    C_Vertex3f(0.137840271f, 0.191162825f, 0.f),
    C_Vertex3f(0.124984741f, 0.179055452f, 0.f),
    C_Vertex3f(0.113114834f, 0.167353988f, 0.f),
    C_Vertex3f(0.102230549f, 0.156058431f, 0.f),
    C_Vertex3f(0.0923318863f, 0.145168781f, 0.f),
    C_Vertex3f(0.078962326f, 0.129443169f, 0.f),
    C_Vertex3f(0.0635700226f, 0.108303547f, 0.f),
    C_Vertex3f(0.050611496f, 0.086991787f, 0.f),
    C_Vertex3f(0.450195313f, 0.f, 0.f),
    C_Vertex3f(0.450195313f, 0.0756835938f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.450195313f, 0.f, 0.f),
    C_Vertex3f(0.050611496f, 0.086991787f, 0.f),
    C_Vertex3f(0.0400867462f, 0.0655078888f, 0.f),
    C_Vertex3f(0.0335273743f, 0.0481185913f, 0.f),
    C_Vertex3f(0.0298652649f, 0.0347223282f, 0.f),
    C_Vertex3f(0.0275688171f, 0.0210523605f, 0.f),
    C_Vertex3f(0.0268554688f, 0.f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.36712122f, 0.484272718f, 0.f),
    C_Vertex3f(0.368164063f, 0.473049164f, 0.f),
    C_Vertex3f(0.374111891f, 0.609533429f, 0.f),
    C_Vertex3f(0.376796246f, 0.306464672f, 0.f),
    C_Vertex3f(0.38875103f, 0.59835577f, 0.f),
    C_Vertex3f(0.390461922f, 0.321858406f, 0.f),
    C_Vertex3f(0.402188301f, 0.585581303f, 0.f),
    C_Vertex3f(0.40609169f, 0.341892242f, 0.f),
    C_Vertex3f(0.413945913f, 0.572042823f, 0.f),
    C_Vertex3f(0.419130325f, 0.361434937f, 0.f),
    C_Vertex3f(0.424023867f, 0.557740331f, 0.f),
    C_Vertex3f(0.429577827f, 0.380486488f, 0.f),
    C_Vertex3f(0.432422161f, 0.542673826f, 0.f),
    C_Vertex3f(0.437434196f, 0.399046898f, 0.f),
    C_Vertex3f(0.439140797f, 0.526843309f, 0.f),
    C_Vertex3f(0.443326473f, 0.417771816f, 0.f),
    C_Vertex3f(0.444179773f, 0.51024878f, 0.f),
    C_Vertex3f(0.447254658f, 0.436661243f, 0.f),
    C_Vertex3f(0.447539091f, 0.492890239f, 0.f),
    C_Vertex3f(0.44921875f, 0.455715179f, 0.f),
    C_Vertex3f(0.44921875f, 0.474767685f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.35252142f, 0.524596453f, 0.f),
    C_Vertex3f(0.357735634f, 0.515201092f, 0.f),
    C_Vertex3f(0.358270884f, 0.61911428f, 0.f),
    C_Vertex3f(0.361907005f, 0.505348682f, 0.f),
    C_Vertex3f(0.374111891f, 0.609533429f, 0.f),
    C_Vertex3f(0.365035534f, 0.495039225f, 0.f),
    C_Vertex3f(0.36712122f, 0.484272718f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.330621719f, 0.550040245f, 0.f),
    C_Vertex3f(0.338964462f, 0.542016029f, 0.f),
    C_Vertex3f(0.341228008f, 0.627098322f, 0.f),
    C_Vertex3f(0.346264362f, 0.533534765f, 0.f),
    C_Vertex3f(0.358270884f, 0.61911428f, 0.f),
    C_Vertex3f(0.35252142f, 0.524596453f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.322983265f, 0.633485556f, 0.f),
    C_Vertex3f(0.303536654f, 0.638275981f, 0.f),
    C_Vertex3f(0.312033653f, 0.563079596f, 0.f),
    C_Vertex3f(0.321644783f, 0.557061434f, 0.f),
    C_Vertex3f(0.330621719f, 0.550040245f, 0.f),
    C_Vertex3f(0.341228008f, 0.627098322f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.2672472f, 0.577121973f, 0.f),
    C_Vertex3f(0.279395103f, 0.575115919f, 0.f),
    C_Vertex3f(0.282888174f, 0.641469598f, 0.f),
    C_Vertex3f(0.290908813f, 0.572106838f, 0.f),
    C_Vertex3f(0.303536654f, 0.638275981f, 0.f),
    C_Vertex3f(0.30178833f, 0.56809473f, 0.f),
    C_Vertex3f(0.312033653f, 0.563079596f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.261037827f, 0.643066406f, 0.f),
    C_Vertex3f(0.238095284f, 0.643066406f, 0.f),
    C_Vertex3f(0.240668297f, 0.578125f, 0.f),
    C_Vertex3f(0.254465103f, 0.578125f, 0.f),
    C_Vertex3f(0.2672472f, 0.577121973f, 0.f),
    C_Vertex3f(0.282888174f, 0.641469598f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.20238924f, 0.571737051f, 0.f),
    C_Vertex3f(0.214440107f, 0.574931026f, 0.f),
    C_Vertex3f(0.216423154f, 0.641586542f, 0.f),
    C_Vertex3f(0.227199793f, 0.577060342f, 0.f),
    C_Vertex3f(0.238095284f, 0.643066406f, 0.f),
    C_Vertex3f(0.240668297f, 0.578125f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.195911765f, 0.638626814f, 0.f),
    C_Vertex3f(0.176561117f, 0.634187222f, 0.f),
    C_Vertex3f(0.180413961f, 0.562155128f, 0.f),
    C_Vertex3f(0.191047192f, 0.567478418f, 0.f),
    C_Vertex3f(0.20238924f, 0.571737051f, 0.f),
    C_Vertex3f(0.216423154f, 0.641586542f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.145310163f, 0.530460954f, 0.f),
    C_Vertex3f(0.152767181f, 0.539797306f, 0.f),
    C_Vertex3f(0.15837121f, 0.628267765f, 0.f),
    C_Vertex3f(0.161273956f, 0.548314571f, 0.f),
    C_Vertex3f(0.176561117f, 0.634187222f, 0.f),
    C_Vertex3f(0.17048955f, 0.555767179f, 0.f),
    C_Vertex3f(0.180413961f, 0.562155128f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.141342044f, 0.620868444f, 0.f),
    C_Vertex3f(0.125473619f, 0.61198926f, 0.f),
    C_Vertex3f(0.125979662f, 0.484924674f, 0.f),
    C_Vertex3f(0.129237652f, 0.497537374f, 0.f),
    C_Vertex3f(0.133545399f, 0.509330988f, 0.f),
    C_Vertex3f(0.138902903f, 0.520305514f, 0.f),
    C_Vertex3f(0.145310163f, 0.530460954f, 0.f),
    C_Vertex3f(0.15837121f, 0.628267765f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.0972189903f, 0.589791298f, 0.f),
    C_Vertex3f(0.122558594f, 0.449707031f, 0.f),
    C_Vertex3f(0.110765934f, 0.601630211f, 0.f),
    C_Vertex3f(0.122612953f, 0.457242012f, 0.f),
    C_Vertex3f(0.125473619f, 0.61198926f, 0.f),
    C_Vertex3f(0.123771429f, 0.471492887f, 0.f),
    C_Vertex3f(0.125979662f, 0.484924674f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.122558594f, 0.449707031f, 0.f),
    C_Vertex3f(0.0972189903f, 0.589791298f, 0.f),
    C_Vertex3f(0.0851060152f, 0.576608896f, 0.f),
    C_Vertex3f(0.0744270086f, 0.562083006f, 0.f),
    C_Vertex3f(0.0651819706f, 0.546213627f, 0.f),
    C_Vertex3f(0.0573709011f, 0.529000759f, 0.f),
    C_Vertex3f(0.0509938002f, 0.510444403f, 0.f),
    C_Vertex3f(0.0460506678f, 0.490544558f, 0.f),
    C_Vertex3f(0.0425415039f, 0.469301224f, 0.f),
    C_Vertex3f(0.0415039063f, 0.458007813f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.368164063f, 0.473049164f, 0.f),
    C_Vertex3f(0.368164063f, 0.461625099f, 0.f),
    C_Vertex3f(0.376796246f, 0.306464672f, 0.f),
    C_Vertex3f(0.367020845f, 0.450291038f, 0.f),
    C_Vertex3f(0.366179824f, 0.295245767f, 0.f),
    C_Vertex3f(0.364734411f, 0.438790441f, 0.f),
    C_Vertex3f(0.36130476f, 0.427123308f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.356731892f, 0.41528964f, 0.f),
    C_Vertex3f(0.351015806f, 0.403289437f, 0.f),
    C_Vertex3f(0.354057431f, 0.283070445f, 0.f),
    C_Vertex3f(0.366179824f, 0.295245767f, 0.f),
    C_Vertex3f(0.36130476f, 0.427123308f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.344156504f, 0.391122699f, 0.f),
    C_Vertex3f(0.336153984f, 0.378789425f, 0.f),
    C_Vertex3f(0.340429068f, 0.269938707f, 0.f),
    C_Vertex3f(0.354057431f, 0.283070445f, 0.f),
    C_Vertex3f(0.351015806f, 0.403289437f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.207849741f, 0.154067755f, 0.f),
    C_Vertex3f(0.220792413f, 0.165338397f, 0.f),
    C_Vertex3f(0.227708578f, 0.267826438f, 0.f),
    C_Vertex3f(0.235319018f, 0.177803636f, 0.f),
    C_Vertex3f(0.249547243f, 0.287030339f, 0.f),
    C_Vertex3f(0.251429558f, 0.19146347f, 0.f),
    C_Vertex3f(0.26927042f, 0.305116892f, 0.f),
    C_Vertex3f(0.270855904f, 0.207847595f, 0.f),
    C_Vertex3f(0.286878109f, 0.322086096f, 0.f),
    C_Vertex3f(0.290508151f, 0.224804997f, 0.f),
    C_Vertex3f(0.30237031f, 0.337937951f, 0.f),
    C_Vertex3f(0.308654428f, 0.240805984f, 0.f),
    C_Vertex3f(0.315747023f, 0.352672458f, 0.f),
    C_Vertex3f(0.325294733f, 0.255850554f, 0.f),
    C_Vertex3f(0.327008247f, 0.366289616f, 0.f),
    C_Vertex3f(0.340429068f, 0.269938707f, 0.f),
    C_Vertex3f(0.336153984f, 0.378789425f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.203754425f, 0.247505188f, 0.f),
    C_Vertex3f(0.182320595f, 0.229920387f, 0.f),
    C_Vertex3f(0.186716199f, 0.135110259f, 0.f),
    C_Vertex3f(0.196491003f, 0.143991709f, 0.f),
    C_Vertex3f(0.207849741f, 0.154067755f, 0.f),
    C_Vertex3f(0.227708578f, 0.267826438f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.137840271f, 0.191162825f, 0.f),
    C_Vertex3f(0.14276123f, 0.0863876343f, 0.f),
    C_Vertex3f(0.151681423f, 0.203676105f, 0.f),
    C_Vertex3f(0.159360886f, 0.107686996f, 0.f),
    C_Vertex3f(0.166508198f, 0.216595292f, 0.f),
    C_Vertex3f(0.171918392f, 0.120931149f, 0.f),
    C_Vertex3f(0.182320595f, 0.229920387f, 0.f),
    C_Vertex3f(0.178525329f, 0.127423406f, 0.f),
    C_Vertex3f(0.186716199f, 0.135110259f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.0268554688f, 0.f, 0.f),
    C_Vertex3f(0.0275688171f, 0.0210523605f, 0.f),
    C_Vertex3f(0.026638031f, 0.00710868835f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, -1.f),
    C_FrontFace(GL_CW),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.136207581f, 0.0756835938f, -1.f),
    C_Vertex3f(0.14276123f, 0.0863876343f, -1.f),
    C_Vertex3f(0.137840271f, 0.191162825f, -1.f),
    C_Vertex3f(0.124984741f, 0.179055452f, -1.f),
    C_Vertex3f(0.113114834f, 0.167353988f, -1.f),
    C_Vertex3f(0.102230549f, 0.156058431f, -1.f),
    C_Vertex3f(0.0923318863f, 0.145168781f, -1.f),
    C_Vertex3f(0.078962326f, 0.129443169f, -1.f),
    C_Vertex3f(0.0635700226f, 0.108303547f, -1.f),
    C_Vertex3f(0.050611496f, 0.086991787f, -1.f),
    C_Vertex3f(0.450195313f, 0.f, -1.f),
    C_Vertex3f(0.450195313f, 0.0756835938f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.450195313f, 0.f, -1.f),
    C_Vertex3f(0.050611496f, 0.086991787f, -1.f),
    C_Vertex3f(0.0400867462f, 0.0655078888f, -1.f),
    C_Vertex3f(0.0335273743f, 0.0481185913f, -1.f),
    C_Vertex3f(0.0298652649f, 0.0347223282f, -1.f),
    C_Vertex3f(0.0275688171f, 0.0210523605f, -1.f),
    C_Vertex3f(0.0268554688f, 0.f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.36712122f, 0.484272718f, -1.f),
    C_Vertex3f(0.368164063f, 0.473049164f, -1.f),
    C_Vertex3f(0.374111891f, 0.609533429f, -1.f),
    C_Vertex3f(0.376796246f, 0.306464672f, -1.f),
    C_Vertex3f(0.38875103f, 0.59835577f, -1.f),
    C_Vertex3f(0.390461922f, 0.321858406f, -1.f),
    C_Vertex3f(0.402188301f, 0.585581303f, -1.f),
    C_Vertex3f(0.40609169f, 0.341892242f, -1.f),
    C_Vertex3f(0.413945913f, 0.572042823f, -1.f),
    C_Vertex3f(0.419130325f, 0.361434937f, -1.f),
    C_Vertex3f(0.424023867f, 0.557740331f, -1.f),
    C_Vertex3f(0.429577827f, 0.380486488f, -1.f),
    C_Vertex3f(0.432422161f, 0.542673826f, -1.f),
    C_Vertex3f(0.437434196f, 0.399046898f, -1.f),
    C_Vertex3f(0.439140797f, 0.526843309f, -1.f),
    C_Vertex3f(0.443326473f, 0.417771816f, -1.f),
    C_Vertex3f(0.444179773f, 0.51024878f, -1.f),
    C_Vertex3f(0.447254658f, 0.436661243f, -1.f),
    C_Vertex3f(0.447539091f, 0.492890239f, -1.f),
    C_Vertex3f(0.44921875f, 0.455715179f, -1.f),
    C_Vertex3f(0.44921875f, 0.474767685f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.35252142f, 0.524596453f, -1.f),
    C_Vertex3f(0.357735634f, 0.515201092f, -1.f),
    C_Vertex3f(0.358270884f, 0.61911428f, -1.f),
    C_Vertex3f(0.361907005f, 0.505348682f, -1.f),
    C_Vertex3f(0.374111891f, 0.609533429f, -1.f),
    C_Vertex3f(0.365035534f, 0.495039225f, -1.f),
    C_Vertex3f(0.36712122f, 0.484272718f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.330621719f, 0.550040245f, -1.f),
    C_Vertex3f(0.338964462f, 0.542016029f, -1.f),
    C_Vertex3f(0.341228008f, 0.627098322f, -1.f),
    C_Vertex3f(0.346264362f, 0.533534765f, -1.f),
    C_Vertex3f(0.358270884f, 0.61911428f, -1.f),
    C_Vertex3f(0.35252142f, 0.524596453f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.322983265f, 0.633485556f, -1.f),
    C_Vertex3f(0.303536654f, 0.638275981f, -1.f),
    C_Vertex3f(0.312033653f, 0.563079596f, -1.f),
    C_Vertex3f(0.321644783f, 0.557061434f, -1.f),
    C_Vertex3f(0.330621719f, 0.550040245f, -1.f),
    C_Vertex3f(0.341228008f, 0.627098322f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.2672472f, 0.577121973f, -1.f),
    C_Vertex3f(0.279395103f, 0.575115919f, -1.f),
    C_Vertex3f(0.282888174f, 0.641469598f, -1.f),
    C_Vertex3f(0.290908813f, 0.572106838f, -1.f),
    C_Vertex3f(0.303536654f, 0.638275981f, -1.f),
    C_Vertex3f(0.30178833f, 0.56809473f, -1.f),
    C_Vertex3f(0.312033653f, 0.563079596f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.261037827f, 0.643066406f, -1.f),
    C_Vertex3f(0.238095284f, 0.643066406f, -1.f),
    C_Vertex3f(0.240668297f, 0.578125f, -1.f),
    C_Vertex3f(0.254465103f, 0.578125f, -1.f),
    C_Vertex3f(0.2672472f, 0.577121973f, -1.f),
    C_Vertex3f(0.282888174f, 0.641469598f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.20238924f, 0.571737051f, -1.f),
    C_Vertex3f(0.214440107f, 0.574931026f, -1.f),
    C_Vertex3f(0.216423154f, 0.641586542f, -1.f),
    C_Vertex3f(0.227199793f, 0.577060342f, -1.f),
    C_Vertex3f(0.238095284f, 0.643066406f, -1.f),
    C_Vertex3f(0.240668297f, 0.578125f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.195911765f, 0.638626814f, -1.f),
    C_Vertex3f(0.176561117f, 0.634187222f, -1.f),
    C_Vertex3f(0.180413961f, 0.562155128f, -1.f),
    C_Vertex3f(0.191047192f, 0.567478418f, -1.f),
    C_Vertex3f(0.20238924f, 0.571737051f, -1.f),
    C_Vertex3f(0.216423154f, 0.641586542f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.145310163f, 0.530460954f, -1.f),
    C_Vertex3f(0.152767181f, 0.539797306f, -1.f),
    C_Vertex3f(0.15837121f, 0.628267765f, -1.f),
    C_Vertex3f(0.161273956f, 0.548314571f, -1.f),
    C_Vertex3f(0.176561117f, 0.634187222f, -1.f),
    C_Vertex3f(0.17048955f, 0.555767179f, -1.f),
    C_Vertex3f(0.180413961f, 0.562155128f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.141342044f, 0.620868444f, -1.f),
    C_Vertex3f(0.125473619f, 0.61198926f, -1.f),
    C_Vertex3f(0.125979662f, 0.484924674f, -1.f),
    C_Vertex3f(0.129237652f, 0.497537374f, -1.f),
    C_Vertex3f(0.133545399f, 0.509330988f, -1.f),
    C_Vertex3f(0.138902903f, 0.520305514f, -1.f),
    C_Vertex3f(0.145310163f, 0.530460954f, -1.f),
    C_Vertex3f(0.15837121f, 0.628267765f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.0972189903f, 0.589791298f, -1.f),
    C_Vertex3f(0.122558594f, 0.449707031f, -1.f),
    C_Vertex3f(0.110765934f, 0.601630211f, -1.f),
    C_Vertex3f(0.122612953f, 0.457242012f, -1.f),
    C_Vertex3f(0.125473619f, 0.61198926f, -1.f),
    C_Vertex3f(0.123771429f, 0.471492887f, -1.f),
    C_Vertex3f(0.125979662f, 0.484924674f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.122558594f, 0.449707031f, -1.f),
    C_Vertex3f(0.0972189903f, 0.589791298f, -1.f),
    C_Vertex3f(0.0851060152f, 0.576608896f, -1.f),
    C_Vertex3f(0.0744270086f, 0.562083006f, -1.f),
    C_Vertex3f(0.0651819706f, 0.546213627f, -1.f),
    C_Vertex3f(0.0573709011f, 0.529000759f, -1.f),
    C_Vertex3f(0.0509938002f, 0.510444403f, -1.f),
    C_Vertex3f(0.0460506678f, 0.490544558f, -1.f),
    C_Vertex3f(0.0425415039f, 0.469301224f, -1.f),
    C_Vertex3f(0.0415039063f, 0.458007813f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.368164063f, 0.473049164f, -1.f),
    C_Vertex3f(0.368164063f, 0.461625099f, -1.f),
    C_Vertex3f(0.376796246f, 0.306464672f, -1.f),
    C_Vertex3f(0.367020845f, 0.450291038f, -1.f),
    C_Vertex3f(0.366179824f, 0.295245767f, -1.f),
    C_Vertex3f(0.364734411f, 0.438790441f, -1.f),
    C_Vertex3f(0.36130476f, 0.427123308f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.356731892f, 0.41528964f, -1.f),
    C_Vertex3f(0.351015806f, 0.403289437f, -1.f),
    C_Vertex3f(0.354057431f, 0.283070445f, -1.f),
    C_Vertex3f(0.366179824f, 0.295245767f, -1.f),
    C_Vertex3f(0.36130476f, 0.427123308f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.344156504f, 0.391122699f, -1.f),
    C_Vertex3f(0.336153984f, 0.378789425f, -1.f),
    C_Vertex3f(0.340429068f, 0.269938707f, -1.f),
    C_Vertex3f(0.354057431f, 0.283070445f, -1.f),
    C_Vertex3f(0.351015806f, 0.403289437f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.207849741f, 0.154067755f, -1.f),
    C_Vertex3f(0.220792413f, 0.165338397f, -1.f),
    C_Vertex3f(0.227708578f, 0.267826438f, -1.f),
    C_Vertex3f(0.235319018f, 0.177803636f, -1.f),
    C_Vertex3f(0.249547243f, 0.287030339f, -1.f),
    C_Vertex3f(0.251429558f, 0.19146347f, -1.f),
    C_Vertex3f(0.26927042f, 0.305116892f, -1.f),
    C_Vertex3f(0.270855904f, 0.207847595f, -1.f),
    C_Vertex3f(0.286878109f, 0.322086096f, -1.f),
    C_Vertex3f(0.290508151f, 0.224804997f, -1.f),
    C_Vertex3f(0.30237031f, 0.337937951f, -1.f),
    C_Vertex3f(0.308654428f, 0.240805984f, -1.f),
    C_Vertex3f(0.315747023f, 0.352672458f, -1.f),
    C_Vertex3f(0.325294733f, 0.255850554f, -1.f),
    C_Vertex3f(0.327008247f, 0.366289616f, -1.f),
    C_Vertex3f(0.340429068f, 0.269938707f, -1.f),
    C_Vertex3f(0.336153984f, 0.378789425f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.203754425f, 0.247505188f, -1.f),
    C_Vertex3f(0.182320595f, 0.229920387f, -1.f),
    C_Vertex3f(0.186716199f, 0.135110259f, -1.f),
    C_Vertex3f(0.196491003f, 0.143991709f, -1.f),
    C_Vertex3f(0.207849741f, 0.154067755f, -1.f),
    C_Vertex3f(0.227708578f, 0.267826438f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.137840271f, 0.191162825f, -1.f),
    C_Vertex3f(0.14276123f, 0.0863876343f, -1.f),
    C_Vertex3f(0.151681423f, 0.203676105f, -1.f),
    C_Vertex3f(0.159360886f, 0.107686996f, -1.f),
    C_Vertex3f(0.166508198f, 0.216595292f, -1.f),
    C_Vertex3f(0.171918392f, 0.120931149f, -1.f),
    C_Vertex3f(0.182320595f, 0.229920387f, -1.f),
    C_Vertex3f(0.178525329f, 0.127423406f, -1.f),
    C_Vertex3f(0.186716199f, 0.135110259f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.0268554688f, 0.f, -1.f),
    C_Vertex3f(0.0275688171f, 0.0210523605f, -1.f),
    C_Vertex3f(0.026638031f, 0.00710868835f, -1.f),
    C_End(),
    C_Translatef(0.497558594f, 0.f, 0.f),
};
static const Call char_51[] = {
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_FrontFace(GL_CW),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.129339188f, 0.991600454f, 0.f),
    C_Vertex3f(0.0375976563f, 0.169921875f, 0.f),
    C_Vertex3f(0.0375976563f, 0.169921875f, -1.f),
    C_Vertex3f(0.116210938f, 0.180175781f, -1.f),
    C_Vertex3f(0.116210938f, 0.180175781f, 0.f),
    C_End(),
    C_Begin(GL_QUAD_STRIP),
    C_Normal3f(0.98013556f, 0.198328838f, 0.f),
    C_Vertex3f(0.116210938f, 0.180175781f, 0.f),
    C_Vertex3f(0.116210938f, 0.180175781f, -1.f),
    C_Normal3f(0.973069251f, 0.230512768f, 0.f),
    C_Vertex3f(0.117903709f, 0.17181015f, 0.f),
    C_Vertex3f(0.117903709f, 0.17181015f, -1.f),
    C_Normal3f(0.961673141f, 0.274198443f, 0.f),
    C_Vertex3f(0.121879339f, 0.156247616f, 0.f),
    C_Vertex3f(0.121879339f, 0.156247616f, -1.f),
    C_Normal3f(0.943272173f, 0.332020551f, 0.f),
    C_Vertex3f(0.126445055f, 0.141853809f, 0.f),
    C_Vertex3f(0.126445055f, 0.141853809f, -1.f),
    C_Normal3f(0.918264449f, 0.395967871f, 0.f),
    C_Vertex3f(0.131600857f, 0.128628731f, 0.f),
    C_Vertex3f(0.131600857f, 0.128628731f, -1.f),
    C_Normal3f(0.884821415f, 0.465930194f, 0.f),
    C_Vertex3f(0.137346745f, 0.11657238f, 0.f),
    C_Vertex3f(0.137346745f, 0.11657238f, -1.f),
    C_Normal3f(0.840900242f, 0.541190267f, 0.f),
    C_Vertex3f(0.143682718f, 0.105684757f, 0.f),
    C_Vertex3f(0.143682718f, 0.105684757f, -1.f),
    C_Normal3f(0.784480333f, 0.620153666f, 0.f),
    C_Vertex3f(0.150608778f, 0.0959658623f, 0.f),
    C_Vertex3f(0.150608778f, 0.0959658623f, -1.f),
    C_Normal3f(0.714002132f, 0.700143516f, 0.f),
    C_Vertex3f(0.158124924f, 0.0874156952f, 0.f),
    C_Vertex3f(0.158124924f, 0.0874156952f, -1.f),
    C_Normal3f(0.638830364f, 0.769347608f, 0.f),
    C_Vertex3f(0.166231155f, 0.080034256f, 0.f),
    C_Vertex3f(0.166231155f, 0.080034256f, -1.f),
    C_Normal3f(0.563639224f, 0.826021075f, 0.f),
    C_Vertex3f(0.174792767f, 0.0735754967f, 0.f),
    C_Vertex3f(0.174792767f, 0.0735754967f, -1.f),
    C_Normal3f(0.481202632f, 0.876609445f, 0.f),
    C_Vertex3f(0.183809757f, 0.0680394173f, 0.f),
    C_Vertex3f(0.183809757f, 0.0680394173f, -1.f),
    C_Normal3f(0.393510222f, 0.919320285f, 0.f),
    C_Vertex3f(0.193282127f, 0.0634260178f, 0.f),
    C_Vertex3f(0.193282127f, 0.0634260178f, -1.f),
    C_Normal3f(0.303042054f, 0.95297718f, 0.f),
    C_Vertex3f(0.203209877f, 0.0597352982f, 0.f),
    C_Vertex3f(0.203209877f, 0.0597352982f, -1.f),
    C_Normal3f(0.212429643f, 0.977176309f, 0.f),
    C_Vertex3f(0.213593006f, 0.0569672585f, 0.f),
    C_Vertex3f(0.213593006f, 0.0569672585f, -1.f),
    C_Normal3f(0.124100514f, 0.992269695f, 0.f),
    C_Vertex3f(0.224431515f, 0.0551218987f, 0.f),
    C_Vertex3f(0.224431515f, 0.0551218987f, -1.f),
    C_Normal3f(0.0382033736f, 0.999269962f, 0.f),
    C_Vertex3f(0.235725403f, 0.0541992188f, 0.f),
    C_Vertex3f(0.235725403f, 0.0541992188f, -1.f),
    C_Normal3f(-0.0457790941f, 0.998951614f, 0.f),
    C_Vertex3f(0.248565674f, 0.0541992188f, 0.f),
    C_Vertex3f(0.248565674f, 0.0541992188f, -1.f),
    C_Normal3f(-0.136252552f, 0.990674138f, 0.f),
    C_Vertex3f(0.261946321f, 0.0554008484f, 0.f),
    C_Vertex3f(0.261946321f, 0.0554008484f, -1.f),
    C_Normal3f(-0.232709646f, 0.972546279f, 0.f),
    C_Vertex3f(0.27477634f, 0.0578041077f, 0.f),
    C_Vertex3f(0.27477634f, 0.0578041077f, -1.f),
    C_Normal3f(-0.330649942f, 0.943753481f, 0.f),
    C_Vertex3f(0.287055731f, 0.0614089966f, 0.f),
    C_Vertex3f(0.287055731f, 0.0614089966f, -1.f),
    C_Normal3f(-0.426926225f, 0.904286444f, 0.f),
    C_Vertex3f(0.298784494f, 0.0662155151f, 0.f),
    C_Vertex3f(0.298784494f, 0.0662155151f, -1.f),
    C_Normal3f(-0.518370092f, 0.855156422f, 0.f),
    C_Vertex3f(0.30996263f, 0.0722236633f, 0.f),
    C_Vertex3f(0.30996263f, 0.0722236633f, -1.f),
    C_Normal3f(-0.602289736f, 0.798277557f, 0.f),
    C_Vertex3f(0.320590138f, 0.0794334412f, 0.f),
    C_Vertex3f(0.320590138f, 0.0794334412f, -1.f),
    C_Normal3f(-0.676844239f, 0.736126304f, 0.f),
    C_Vertex3f(0.330667019f, 0.0878448486f, 0.f),
    C_Vertex3f(0.330667019f, 0.0878448486f, -1.f),
    C_Normal3f(-0.742510676f, 0.669834137f, 0.f),
    C_Vertex3f(0.340193272f, 0.0974578857f, 0.f),
    C_Vertex3f(0.340193272f, 0.0974578857f, -1.f),
    C_Normal3f(-0.804219961f, 0.594331741f, 0.f),
    C_Vertex3f(0.348528743f, 0.107644558f, 0.f),
    C_Vertex3f(0.348528743f, 0.107644558f, -1.f),
    C_Normal3f(-0.860194027f, 0.50996691f, 0.f),
    C_Vertex3f(0.355673432f, 0.118404865f, 0.f),
    C_Vertex3f(0.355673432f, 0.118404865f, -1.f),
    C_Normal3f(-0.908105314f, 0.418741792f, 0.f),
    C_Vertex3f(0.36162734f, 0.129738808f, 0.f),
    C_Vertex3f(0.36162734f, 0.129738808f, -1.f),
    C_Normal3f(-0.946259737f, 0.32340762f, 0.f),
    C_Vertex3f(0.366390467f, 0.141646385f, 0.f),
    C_Vertex3f(0.366390467f, 0.141646385f, -1.f),
    C_Normal3f(-0.973879278f, 0.227066651f, 0.f),
    C_Vertex3f(0.369962811f, 0.154127598f, 0.f),
    C_Vertex3f(0.369962811f, 0.154127598f, -1.f),
    C_Normal3f(-0.991156876f, 0.132695362f, 0.f),
    C_Vertex3f(0.372344375f, 0.167182446f, 0.f),
    C_Vertex3f(0.372344375f, 0.167182446f, -1.f),
    C_Normal3f(-0.999063969f, 0.0432566293f, 0.f),
    C_Vertex3f(0.373535156f, 0.180810928f, 0.f),
    C_Vertex3f(0.373535156f, 0.180810928f, -1.f),
    C_Normal3f(-0.999151349f, -0.0411898941f, 0.f),
    C_Vertex3f(0.373535156f, 0.194684982f, 0.f),
    C_Vertex3f(0.373535156f, 0.194684982f, -1.f),
    C_Normal3f(-0.991517961f, -0.129969835f, 0.f),
    C_Vertex3f(0.372429252f, 0.207637072f, 0.f),
    C_Vertex3f(0.372429252f, 0.207637072f, -1.f),
    C_Normal3f(-0.974719524f, -0.223432034f, 0.f),
    C_Vertex3f(0.370217443f, 0.21999526f, 0.f),
    C_Vertex3f(0.370217443f, 0.21999526f, -1.f),
    C_Normal3f(-0.947481275f, -0.319811255f, 0.f),
    C_Vertex3f(0.366899729f, 0.231759548f, 0.f),
    C_Vertex3f(0.366899729f, 0.231759548f, -1.f),
    C_Normal3f(-0.909289181f, -0.416164815f, 0.f),
    C_Vertex3f(0.36247611f, 0.242929935f, 0.f),
    C_Vertex3f(0.36247611f, 0.242929935f, -1.f),
    C_Normal3f(-0.860625505f, -0.509238303f, 0.f),
    C_Vertex3f(0.356946588f, 0.253506422f, 0.f),
    C_Vertex3f(0.356946588f, 0.253506422f, -1.f),
    C_Normal3f(-0.803008199f, -0.595967889f, 0.f),
    C_Vertex3f(0.35031116f, 0.263489008f, 0.f),
    C_Vertex3f(0.35031116f, 0.263489008f, -1.f),
    C_Normal3f(-0.738763273f, -0.673965156f, 0.f),
    C_Vertex3f(0.342569828f, 0.272877693f, 0.f),
    C_Vertex3f(0.342569828f, 0.272877693f, -1.f),
    C_Normal3f(-0.669515669f, -0.742797911f, 0.f),
    C_Vertex3f(0.333722591f, 0.281672478f, 0.f),
    C_Vertex3f(0.333722591f, 0.281672478f, -1.f),
    C_Normal3f(-0.591203511f, -0.806522369f, 0.f),
    C_Vertex3f(0.324274659f, 0.289367914f, 0.f),
    C_Vertex3f(0.324274659f, 0.289367914f, -1.f),
    C_Normal3f(-0.504463077f, -0.863433361f, 0.f),
    C_Vertex3f(0.314226031f, 0.295964003f, 0.f),
    C_Vertex3f(0.314226031f, 0.295964003f, -1.f),
    C_Normal3f(-0.41172865f, -0.911306441f, 0.f),
    C_Vertex3f(0.303576708f, 0.301460743f, 0.f),
    C_Vertex3f(0.303576708f, 0.301460743f, -1.f),
    C_Normal3f(-0.316050053f, -0.948742568f, 0.f),
    C_Vertex3f(0.292326689f, 0.305858135f, 0.f),
    C_Vertex3f(0.292326689f, 0.305858135f, -1.f),
    C_Normal3f(-0.220610797f, -0.975361943f, 0.f),
    C_Vertex3f(0.280475974f, 0.309156179f, 0.f),
    C_Vertex3f(0.280475974f, 0.309156179f, -1.f),
    C_Normal3f(-0.128249332f, -0.991742015f, 0.f),
    C_Vertex3f(0.268024564f, 0.311354876f, 0.f),
    C_Vertex3f(0.268024564f, 0.311354876f, -1.f),
    C_Normal3f(-0.0431595892f, -0.999068201f, 0.f),
    C_Vertex3f(0.254972458f, 0.312454224f, 0.f),
    C_Vertex3f(0.254972458f, 0.312454224f, -1.f),
    C_Normal3f(0.0438490137f, -0.99903816f, 0.f),
    C_Vertex3f(0.242576599f, 0.312454224f, 0.f),
    C_Vertex3f(0.242576599f, 0.312454224f, -1.f),
    C_Normal3f(0.123363428f, -0.992361546f, 0.f),
    C_Vertex3f(0.230072021f, 0.311361313f, 0.f),
    C_Vertex3f(0.230072021f, 0.311361313f, -1.f),
    C_Normal3f(0.184521854f, -0.982828438f, 0.f),
    C_Vertex3f(0.216201782f, 0.309175491f, 0.f),
    C_Vertex3f(0.216201782f, 0.309175491f, -1.f),
    C_Normal3f(0.226156473f, -0.974091053f, 0.f),
    C_Vertex3f(0.200965881f, 0.305896759f, 0.f),
    C_Vertex3f(0.200965881f, 0.305896759f, -1.f),
    C_Normal3f(0.25464642f, -0.967034161f, 0.f),
    C_Vertex3f(0.1926651f, 0.303710938f, 0.f),
    C_Vertex3f(0.1926651f, 0.303710938f, -1.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.992046177f, 0.125874653f, 0.f),
    C_Vertex3f(0.1926651f, 0.303710938f, 0.f),
    C_Vertex3f(0.1926651f, 0.303710938f, -1.f),
    C_Vertex3f(0.201400757f, 0.372558594f, -1.f),
    C_Vertex3f(0.201400757f, 0.372558594f, 0.f),
    C_End(),
    C_Begin(GL_QUAD_STRIP),
    C_Normal3f(0.110854723f, 0.993836641f, 0.f),
    C_Vertex3f(0.201400757f, 0.372558594f, 0.f),
    C_Vertex3f(0.201400757f, 0.372558594f, -1.f),
    C_Normal3f(0.0851281956f, 0.996369958f, 0.f),
    C_Vertex3f(0.20533371f, 0.372119904f, 0.f),
    C_Vertex3f(0.20533371f, 0.372119904f, -1.f),
    C_Normal3f(0.0205883458f, 0.999787986f, 0.f),
    C_Vertex3f(0.211669922f, 0.371681213f, 0.f),
    C_Vertex3f(0.211669922f, 0.371681213f, -1.f),
    C_Normal3f(-0.084013395f, 0.99646467f, 0.f),
    C_Vertex3f(0.226636887f, 0.371681213f, 0.f),
    C_Vertex3f(0.226636887f, 0.371681213f, -1.f),
    C_Normal3f(-0.206760541f, 0.978391588f, 0.f),
    C_Vertex3f(0.250507355f, 0.374955654f, 0.f),
    C_Vertex3f(0.250507355f, 0.374955654f, -1.f),
    C_Normal3f(-0.348944038f, 0.937143624f, 0.f),
    C_Vertex3f(0.27312088f, 0.381504536f, 0.f),
    C_Vertex3f(0.27312088f, 0.381504536f, -1.f),
    C_Normal3f(-0.474657565f, 0.880170584f, 0.f),
    C_Vertex3f(0.294477463f, 0.391327858f, 0.f),
    C_Vertex3f(0.294477463f, 0.391327858f, -1.f),
    C_Normal3f(-0.585953832f, 0.810344398f, 0.f),
    C_Vertex3f(0.309552193f, 0.40115118f, 0.f),
    C_Vertex3f(0.309552193f, 0.40115118f, -1.f),
    C_Normal3f(-0.694374084f, 0.719614208f, 0.f),
    C_Vertex3f(0.318345785f, 0.40858686f, 0.f),
    C_Vertex3f(0.318345785f, 0.40858686f, -1.f),
    C_Normal3f(-0.785369575f, 0.619027197f, 0.f),
    C_Vertex3f(0.32588315f, 0.416909337f, 0.f),
    C_Vertex3f(0.32588315f, 0.416909337f, -1.f),
    C_Normal3f(-0.862910032f, 0.505357444f, 0.f),
    C_Vertex3f(0.332164288f, 0.426118612f, 0.f),
    C_Vertex3f(0.332164288f, 0.426118612f, -1.f),
    C_Normal3f(-0.922910511f, 0.385014504f, 0.f),
    C_Vertex3f(0.337189198f, 0.436214685f, 0.f),
    C_Vertex3f(0.337189198f, 0.436214685f, -1.f),
    C_Normal3f(-0.964241147f, 0.265026599f, 0.f),
    C_Vertex3f(0.34095788f, 0.447197556f, 0.f),
    C_Vertex3f(0.34095788f, 0.447197556f, -1.f),
    C_Normal3f(-0.988491774f, 0.151274711f, 0.f),
    C_Vertex3f(0.343470335f, 0.459067225f, 0.f),
    C_Vertex3f(0.343470335f, 0.459067225f, -1.f),
    C_Normal3f(-0.998737872f, 0.0502264425f, 0.f),
    C_Vertex3f(0.344726563f, 0.471823692f, 0.f),
    C_Vertex3f(0.344726563f, 0.471823692f, -1.f),
    C_Normal3f(-0.999178648f, -0.040522296f, 0.f),
    C_Vertex3f(0.344726563f, 0.484046936f, 0.f),
    C_Vertex3f(0.344726563f, 0.484046936f, -1.f),
    C_Normal3f(-0.990905643f, -0.134558558f, 0.f),
    C_Vertex3f(0.343811512f, 0.494386554f, 0.f),
    C_Vertex3f(0.343811512f, 0.494386554f, -1.f),
    C_Normal3f(-0.973001659f, -0.230797961f, 0.f),
    C_Vertex3f(0.341981411f, 0.504262567f, 0.f),
    C_Vertex3f(0.341981411f, 0.504262567f, -1.f),
    C_Normal3f(-0.944195628f, -0.329384953f, 0.f),
    C_Vertex3f(0.339236259f, 0.513674974f, 0.f),
    C_Vertex3f(0.339236259f, 0.513674974f, -1.f),
    C_Normal3f(-0.904193938f, -0.427122146f, 0.f),
    C_Vertex3f(0.335576057f, 0.522623777f, 0.f),
    C_Vertex3f(0.335576057f, 0.522623777f, -1.f),
    C_Normal3f(-0.853786111f, -0.520623982f, 0.f),
    C_Vertex3f(0.331000805f, 0.531108975f, 0.f),
    C_Vertex3f(0.331000805f, 0.531108975f, -1.f),
    C_Normal3f(-0.794804215f, -0.606866002f, 0.f),
    C_Vertex3f(0.325510502f, 0.539130569f, 0.f),
    C_Vertex3f(0.325510502f, 0.539130569f, -1.f),
    C_Normal3f(-0.729806602f, -0.683653712f, 0.f),
    C_Vertex3f(0.319105148f, 0.546688557f, 0.f),
    C_Vertex3f(0.319105148f, 0.546688557f, -1.f),
    C_Normal3f(-0.659211993f, -0.751957178f, 0.f),
    C_Vertex3f(0.311784744f, 0.55378294f, 0.f),
    C_Vertex3f(0.311784744f, 0.55378294f, -1.f),
    C_Normal3f(-0.578885257f, -0.815408945f, 0.f),
    C_Vertex3f(0.303931713f, 0.559990525f, 0.f),
    C_Vertex3f(0.303931713f, 0.559990525f, -1.f),
    C_Normal3f(-0.491075903f, -0.871116757f, 0.f),
    C_Vertex3f(0.295546055f, 0.565311313f, 0.f),
    C_Vertex3f(0.295546055f, 0.565311313f, -1.f),
    C_Normal3f(-0.398498207f, -0.917169094f, 0.f),
    C_Vertex3f(0.286627769f, 0.569745302f, 0.f),
    C_Vertex3f(0.286627769f, 0.569745302f, -1.f),
    C_Normal3f(-0.304267049f, -0.95258671f, 0.f),
    C_Vertex3f(0.277176857f, 0.573292494f, 0.f),
    C_Vertex3f(0.277176857f, 0.573292494f, -1.f),
    C_Normal3f(-0.211406603f, -0.977398157f, 0.f),
    C_Vertex3f(0.267193317f, 0.575952888f, 0.f),
    C_Vertex3f(0.267193317f, 0.575952888f, -1.f),
    C_Normal3f(-0.122438304f, -0.992476106f, 0.f),
    C_Vertex3f(0.256677151f, 0.577726483f, 0.f),
    C_Vertex3f(0.256677151f, 0.577726483f, -1.f),
    C_Normal3f(-0.0392505415f, -0.999229431f, 0.f),
    C_Vertex3f(0.245628357f, 0.578613281f, 0.f),
    C_Vertex3f(0.245628357f, 0.578613281f, -1.f),
    C_Normal3f(0.0401106067f, -0.999195218f, 0.f),
    C_Vertex3f(0.234101295f, 0.578613281f, 0.f),
    C_Vertex3f(0.234101295f, 0.578613281f, -1.f),
    C_Normal3f(0.125096425f, -0.992144644f, 0.f),
    C_Vertex3f(0.223106742f, 0.577709198f, 0.f),
    C_Vertex3f(0.223106742f, 0.577709198f, -1.f),
    C_Normal3f(0.214788839f, -0.97666049f, 0.f),
    C_Vertex3f(0.212590337f, 0.575901031f, 0.f),
    C_Vertex3f(0.212590337f, 0.575901031f, -1.f),
    C_Normal3f(0.307289928f, -0.95161593f, 0.f),
    C_Vertex3f(0.20255208f, 0.573188782f, 0.f),
    C_Vertex3f(0.20255208f, 0.573188782f, -1.f),
    C_Normal3f(0.400028229f, -0.916502774f, 0.f),
    C_Vertex3f(0.192991972f, 0.569572449f, 0.f),
    C_Vertex3f(0.192991972f, 0.569572449f, -1.f),
    C_Normal3f(0.490136564f, -0.871645689f, 0.f),
    C_Vertex3f(0.183910012f, 0.565052032f, 0.f),
    C_Vertex3f(0.183910012f, 0.565052032f, -1.f),
    C_Normal3f(0.57485497f, -0.818255305f, 0.f),
    C_Vertex3f(0.175306201f, 0.559627533f, 0.f),
    C_Vertex3f(0.175306201f, 0.559627533f, -1.f),
    C_Normal3f(0.651937425f, -0.758272707f, 0.f),
    C_Vertex3f(0.167180538f, 0.55329895f, 0.f),
    C_Vertex3f(0.167180538f, 0.55329895f, -1.f),
    C_Normal3f(0.724731624f, -0.689031303f, 0.f),
    C_Vertex3f(0.159533024f, 0.546066284f, 0.f),
    C_Vertex3f(0.159533024f, 0.546066284f, -1.f),
    C_Normal3f(0.791880012f, -0.610676765f, 0.f),
    C_Vertex3f(0.152568221f, 0.537929535f, 0.f),
    C_Vertex3f(0.152568221f, 0.537929535f, -1.f),
    C_Normal3f(0.847689569f, -0.530492604f, 0.f),
    C_Vertex3f(0.14628613f, 0.528888702f, 0.f),
    C_Vertex3f(0.14628613f, 0.528888702f, -1.f),
    C_Normal3f(0.892373502f, -0.451297522f, 0.f),
    C_Vertex3f(0.14068675f, 0.518943787f, 0.f),
    C_Vertex3f(0.14068675f, 0.518943787f, -1.f),
    C_Normal3f(0.926915944f, -0.375268966f, 0.f),
    C_Vertex3f(0.135770082f, 0.508094788f, 0.f),
    C_Vertex3f(0.135770082f, 0.508094788f, -1.f),
    C_Normal3f(0.952719212f, -0.30385232f, 0.f),
    C_Vertex3f(0.131536126f, 0.496341705f, 0.f),
    C_Vertex3f(0.131536126f, 0.496341705f, -1.f),
    C_Normal3f(0.971306443f, -0.237831756f, 0.f),
    C_Vertex3f(0.127984881f, 0.48368454f, 0.f),
    C_Vertex3f(0.127984881f, 0.48368454f, -1.f),
    C_Normal3f(0.982332468f, -0.187143937f, 0.f),
    C_Vertex3f(0.125116348f, 0.470123291f, 0.f),
    C_Vertex3f(0.125116348f, 0.470123291f, -1.f),
    C_Normal3f(0.988775074f, -0.149411425f, 0.f),
    C_Vertex3f(0.124023438f, 0.462890625f, 0.f),
    C_Vertex3f(0.124023438f, 0.462890625f, -1.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.177271411f, -0.984161973f, 0.f),
    C_Vertex3f(0.124023438f, 0.462890625f, 0.f),
    C_Vertex3f(0.124023438f, 0.462890625f, -1.f),
    C_Vertex3f(0.0454101563f, 0.477050781f, -1.f),
    C_Vertex3f(0.0454101563f, 0.477050781f, 0.f),
    C_End(),
    C_Begin(GL_QUAD_STRIP),
    C_Normal3f(-0.983761907f, 0.179478407f, 0.f),
    C_Vertex3f(0.0454101563f, 0.477050781f, 0.f),
    C_Vertex3f(0.0454101563f, 0.477050781f, -1.f),
    C_Normal3f(-0.974604726f, 0.223932147f, 0.f),
    C_Vertex3f(0.0472135544f, 0.486935616f, 0.f),
    C_Vertex3f(0.0472135544f, 0.486935616f, -1.f),
    C_Normal3f(-0.95929718f, 0.282398403f, 0.f),
    C_Vertex3f(0.0519680977f, 0.505592465f, 0.f),
    C_Vertex3f(0.0519680977f, 0.505592465f, -1.f),
    C_Normal3f(-0.934401929f, 0.356220573f, 0.f),
    C_Vertex3f(0.057870388f, 0.523136497f, 0.f),
    C_Vertex3f(0.057870388f, 0.523136497f, -1.f),
    C_Normal3f(-0.901434362f, 0.432915926f, 0.f),
    C_Vertex3f(0.0649204254f, 0.539567709f, 0.f),
    C_Vertex3f(0.0649204254f, 0.539567709f, -1.f),
    C_Normal3f(-0.85968262f, 0.510828495f, 0.f),
    C_Vertex3f(0.0731182098f, 0.554886103f, 0.f),
    C_Vertex3f(0.0731182098f, 0.554886103f, -1.f),
    C_Normal3f(-0.808940768f, 0.587890208f, 0.f),
    C_Vertex3f(0.0824637413f, 0.569091678f, 0.f),
    C_Vertex3f(0.0824637413f, 0.569091678f, -1.f),
    C_Normal3f(-0.749669671f, 0.661812246f, 0.f),
    C_Vertex3f(0.0929570198f, 0.582184434f, 0.f),
    C_Vertex3f(0.0929570198f, 0.582184434f, -1.f),
    C_Normal3f(-0.683051467f, 0.730370224f, 0.f),
    C_Vertex3f(0.104598045f, 0.594164371f, 0.f),
    C_Vertex3f(0.104598045f, 0.594164371f, -1.f),
    C_Normal3f(-0.611629307f, 0.791144371f, 0.f),
    C_Vertex3f(0.117386818f, 0.60503149f, 0.f),
    C_Vertex3f(0.117386818f, 0.60503149f, -1.f),
    C_Normal3f(-0.53463006f, 0.845086157f, 0.f),
    C_Vertex3f(0.130954266f, 0.614540219f, 0.f),
    C_Vertex3f(0.130954266f, 0.614540219f, -1.f),
    C_Normal3f(-0.452214152f, 0.89190942f, 0.f),
    C_Vertex3f(0.145300388f, 0.622690558f, 0.f),
    C_Vertex3f(0.145300388f, 0.622690558f, -1.f),
    C_Normal3f(-0.36658293f, 0.930385351f, 0.f),
    C_Vertex3f(0.160425186f, 0.629482508f, 0.f),
    C_Vertex3f(0.160425186f, 0.629482508f, -1.f),
    C_Normal3f(-0.280124605f, 0.959963679f, 0.f),
    C_Vertex3f(0.176328659f, 0.634916067f, 0.f),
    C_Vertex3f(0.176328659f, 0.634916067f, -1.f),
    C_Normal3f(-0.195103869f, 0.980782568f, 0.f),
    C_Vertex3f(0.193010807f, 0.638991237f, 0.f),
    C_Vertex3f(0.193010807f, 0.638991237f, -1.f),
    C_Normal3f(-0.113412887f, 0.993547976f, 0.f),
    C_Vertex3f(0.21047163f, 0.641708016f, 0.f),
    C_Vertex3f(0.21047163f, 0.641708016f, -1.f),
    C_Normal3f(-0.0332222208f, 0.999448001f, 0.f),
    C_Vertex3f(0.228711128f, 0.643066406f, 0.f),
    C_Vertex3f(0.228711128f, 0.643066406f, -1.f),
    C_Normal3f(0.0586304106f, 0.99827981f, 0.f),
    C_Vertex3f(0.251337051f, 0.643066406f, 0.f),
    C_Vertex3f(0.251337051f, 0.643066406f, -1.f),
    C_Normal3f(0.168297589f, 0.985736191f, 0.f),
    C_Vertex3f(0.276531696f, 0.640257835f, 0.f),
    C_Vertex3f(0.276531696f, 0.640257835f, -1.f),
    C_Normal3f(0.284764469f, 0.958597481f, 0.f),
    C_Vertex3f(0.300687313f, 0.634640694f, 0.f),
    C_Vertex3f(0.300687313f, 0.634640694f, -1.f),
    C_Normal3f(0.398902982f, 0.916993141f, 0.f),
    C_Vertex3f(0.323803902f, 0.626214981f, 0.f),
    C_Vertex3f(0.323803902f, 0.626214981f, -1.f),
    C_Normal3f(0.508041561f, 0.861332476f, 0.f),
    C_Vertex3f(0.345881462f, 0.614980698f, 0.f),
    C_Vertex3f(0.345881462f, 0.614980698f, -1.f),
    C_Normal3f(0.618183315f, 0.786033928f, 0.f),
    C_Vertex3f(0.365363598f, 0.601701736f, 0.f),
    C_Vertex3f(0.365363598f, 0.601701736f, -1.f),
    C_Normal3f(0.723664582f, 0.690151811f, 0.f),
    C_Vertex3f(0.382250309f, 0.586378098f, 0.f),
    C_Vertex3f(0.382250309f, 0.586378098f, -1.f),
    C_Normal3f(0.816718042f, 0.577036917f, 0.f),
    C_Vertex3f(0.396541595f, 0.569009781f, 0.f),
    C_Vertex3f(0.396541595f, 0.569009781f, -1.f),
    C_Normal3f(0.887526929f, 0.460755736f, 0.f),
    C_Vertex3f(0.408237457f, 0.549596786f, 0.f),
    C_Vertex3f(0.408237457f, 0.549596786f, -1.f),
    C_Normal3f(0.940927088f, 0.338609159f, 0.f),
    C_Vertex3f(0.417009354f, 0.529583931f, 0.f),
    C_Vertex3f(0.417009354f, 0.529583931f, -1.f),
    C_Normal3f(0.978707194f, 0.205261379f, 0.f),
    C_Vertex3f(0.422857285f, 0.508971214f, 0.f),
    C_Vertex3f(0.422857285f, 0.508971214f, -1.f),
    C_Normal3f(0.997639477f, 0.0686698854f, 0.f),
    C_Vertex3f(0.42578125f, 0.487758636f, 0.f),
    C_Vertex3f(0.42578125f, 0.487758636f, -1.f),
    C_Normal3f(0.997705936f, -0.0676970482f, 0.f),
    C_Vertex3f(0.42578125f, 0.466491699f, 0.f),
    C_Vertex3f(0.42578125f, 0.466491699f, -1.f),
    C_Normal3f(0.97742027f, -0.211304471f, 0.f),
    C_Vertex3f(0.42299509f, 0.446696758f, 0.f),
    C_Vertex3f(0.42299509f, 0.446696758f, -1.f),
    C_Normal3f(0.935264945f, -0.353948534f, 0.f),
    C_Vertex3f(0.417422771f, 0.427828312f, 0.f),
    C_Vertex3f(0.417422771f, 0.427828312f, -1.f),
    C_Normal3f(0.873282731f, -0.48721388f, 0.f),
    C_Vertex3f(0.409064293f, 0.40988636f, 0.f),
    C_Vertex3f(0.409064293f, 0.40988636f, -1.f),
    C_Normal3f(0.791070402f, -0.611725152f, 0.f),
    C_Vertex3f(0.397919655f, 0.392870903f, 0.f),
    C_Vertex3f(0.397919655f, 0.392870903f, -1.f),
    C_Normal3f(0.688636422f, -0.725106716f, 0.f),
    C_Vertex3f(0.38409853f, 0.377601147f, 0.f),
    C_Vertex3f(0.38409853f, 0.377601147f, -1.f),
    C_Normal3f(0.578549325f, -0.815647423f, 0.f),
    C_Vertex3f(0.367600918f, 0.364077091f, 0.f),
    C_Vertex3f(0.367600918f, 0.364077091f, -1.f),
    C_Normal3f(0.487255991f, -0.873259127f, 0.f),
    C_Vertex3f(0.348426819f, 0.352298737f, 0.f),
    C_Vertex3f(0.348426819f, 0.352298737f, -1.f),
    C_Normal3f(0.417266458f, -0.908784151f, 0.f),
    C_Vertex3f(0.337501526f, 0.34728241f, 0.f),
    C_Vertex3f(0.337501526f, 0.34728241f, -1.f),
    C_End(),
    C_Begin(GL_QUAD_STRIP),
    C_Normal3f(0.224668384f, 0.974435329f, 0.f),
    C_Vertex3f(0.337501526f, 0.34728241f, 0.f),
    C_Vertex3f(0.337501526f, 0.34728241f, -1.f),
    C_Normal3f(0.271781117f, 0.962359071f, 0.f),
    C_Vertex3f(0.344603539f, 0.345644951f, 0.f),
    C_Vertex3f(0.344603539f, 0.345644951f, -1.f),
    C_Normal3f(0.333009481f, 0.942923486f, 0.f),
    C_Vertex3f(0.358011961f, 0.34149003f, 0.f),
    C_Vertex3f(0.358011961f, 0.34149003f, -1.f),
    C_Normal3f(0.409007847f, 0.912530899f, 0.f),
    C_Vertex3f(0.370624781f, 0.336455107f, 0.f),
    C_Vertex3f(0.370624781f, 0.336455107f, -1.f),
    C_Normal3f(0.486274809f, 0.87380594f, 0.f),
    C_Vertex3f(0.382441998f, 0.33054018f, 0.f),
    C_Vertex3f(0.382441998f, 0.33054018f, -1.f),
    C_Normal3f(0.562881172f, 0.826537848f, 0.f),
    C_Vertex3f(0.393463612f, 0.323745251f, 0.f),
    C_Vertex3f(0.393463612f, 0.323745251f, -1.f),
    C_Normal3f(0.636693895f, 0.771116674f, 0.f),
    C_Vertex3f(0.403689623f, 0.316070318f, 0.f),
    C_Vertex3f(0.403689623f, 0.316070318f, -1.f),
    C_Normal3f(0.70562768f, 0.708582759f, 0.f),
    C_Vertex3f(0.413120031f, 0.307515383f, 0.f),
    C_Vertex3f(0.413120031f, 0.307515383f, -1.f),
    C_Normal3f(0.767919481f, 0.640546322f, 0.f),
    C_Vertex3f(0.421754837f, 0.298080444f, 0.f),
    C_Vertex3f(0.421754837f, 0.298080444f, -1.f),
    C_Normal3f(0.822777271f, 0.568364024f, 0.f),
    C_Vertex3f(0.42959404f, 0.287765503f, 0.f),
    C_Vertex3f(0.42959404f, 0.287765503f, -1.f),
    C_Normal3f(0.870901167f, 0.491458237f, 0.f),
    C_Vertex3f(0.436453342f, 0.27680254f, 0.f),
    C_Vertex3f(0.436453342f, 0.27680254f, -1.f),
    C_Normal3f(0.911386251f, 0.411552072f, 0.f),
    C_Vertex3f(0.442332745f, 0.265191555f, 0.f),
    C_Vertex3f(0.442332745f, 0.265191555f, -1.f),
    C_Normal3f(0.943729758f, 0.330717593f, 0.f),
    C_Vertex3f(0.447232246f, 0.252932549f, 0.f),
    C_Vertex3f(0.447232246f, 0.252932549f, -1.f),
    C_Normal3f(0.968007922f, 0.250919789f, 0.f),
    C_Vertex3f(0.451151848f, 0.24002552f, 0.f),
    C_Vertex3f(0.451151848f, 0.24002552f, -1.f),
    C_Normal3f(0.984777331f, 0.173820063f, 0.f),
    C_Vertex3f(0.454091549f, 0.22647047f, 0.f),
    C_Vertex3f(0.454091549f, 0.22647047f, -1.f),
    C_Normal3f(0.994920254f, 0.100666054f, 0.f),
    C_Vertex3f(0.45605135f, 0.212267399f, 0.f),
    C_Vertex3f(0.45605135f, 0.212267399f, -1.f),
    C_Normal3f(0.999561548f, 0.0296094883f, 0.f),
    C_Vertex3f(0.45703125f, 0.197416306f, 0.f),
    C_Vertex3f(0.45703125f, 0.197416306f, -1.f),
    C_Normal3f(0.998762608f, -0.0497328117f, 0.f),
    C_Vertex3f(0.45703125f, 0.179187775f, 0.f),
    C_Vertex3f(0.45703125f, 0.179187775f, -1.f),
    C_Normal3f(0.989636242f, -0.143597081f, 0.f),
    C_Vertex3f(0.455119729f, 0.159028053f, 0.f),
    C_Vertex3f(0.455119729f, 0.159028053f, -1.f),
    C_Normal3f(0.969681084f, -0.244374037f, 0.f),
    C_Vertex3f(0.451296687f, 0.139666557f, 0.f),
    C_Vertex3f(0.451296687f, 0.139666557f, -1.f),
    C_Normal3f(0.938372254f, -0.345626473f, 0.f),
    C_Vertex3f(0.445562124f, 0.121103287f, 0.f),
    C_Vertex3f(0.445562124f, 0.121103287f, -1.f),
    C_Normal3f(0.896095276f, -0.443861693f, 0.f),
    C_Vertex3f(0.43791604f, 0.103338242f, 0.f),
    C_Vertex3f(0.43791604f, 0.103338242f, -1.f),
    C_Normal3f(0.844346881f, -0.535797f, 0.f),
    C_Vertex3f(0.428358436f, 0.0863714218f, 0.f),
    C_Vertex3f(0.428358436f, 0.0863714218f, -1.f),
    C_Normal3f(0.785480857f, -0.618885934f, 0.f),
    C_Vertex3f(0.41688931f, 0.0702028275f, 0.f),
    C_Vertex3f(0.41688931f, 0.0702028275f, -1.f),
    C_Normal3f(0.722254336f, -0.691627443f, 0.f),
    C_Vertex3f(0.403508663f, 0.0548324585f, 0.f),
    C_Vertex3f(0.403508663f, 0.0548324585f, -1.f),
    C_Normal3f(0.654120147f, -0.756390631f, 0.f),
    C_Vertex3f(0.388216496f, 0.0402603149f, 0.f),
    C_Vertex3f(0.388216496f, 0.0402603149f, -1.f),
    C_Normal3f(0.575892985f, -0.817525089f, 0.f),
    C_Vertex3f(0.371914029f, 0.0275096893f, 0.f),
    C_Vertex3f(0.371914029f, 0.0275096893f, -1.f),
    C_Normal3f(0.490104139f, -0.871663988f, 0.f),
    C_Vertex3f(0.354601264f, 0.0165805817f, 0.f),
    C_Vertex3f(0.354601264f, 0.0165805817f, -1.f),
    C_Normal3f(0.399162263f, -0.91688025f, 0.f),
    C_Vertex3f(0.3362782f, 0.00747299194f, 0.f),
    C_Vertex3f(0.3362782f, 0.00747299194f, -1.f),
    C_Normal3f(0.305950403f, -0.952047527f, 0.f),
    C_Vertex3f(0.316944838f, 0.000186920166f, 0.f),
    C_Vertex3f(0.316944838f, 0.000186920166f, -1.f),
    C_Normal3f(0.213389069f, -0.976967275f, 0.f),
    C_Vertex3f(0.296601176f, -0.00527763367f, 0.f),
    C_Vertex3f(0.296601176f, -0.00527763367f, -1.f),
    C_Normal3f(0.124029741f, -0.992278516f, 0.f),
    C_Vertex3f(0.275247216f, -0.00892066956f, 0.f),
    C_Vertex3f(0.275247216f, -0.00892066956f, -1.f),
    C_Normal3f(0.0408149101f, -0.999166667f, 0.f),
    C_Vertex3f(0.252882957f, -0.0107421875f, 0.f),
    C_Vertex3f(0.252882957f, -0.0107421875f, -1.f),
    C_Normal3f(-0.0370388776f, -0.999313831f, 0.f),
    C_Vertex3f(0.23065567f, -0.0107421875f, 0.f),
    C_Vertex3f(0.23065567f, -0.0107421875f, -1.f),
    C_Normal3f(-0.118618131f, -0.992940009f, 0.f),
    C_Vertex3f(0.210469842f, -0.0091701746f, 0.f),
    C_Vertex3f(0.210469842f, -0.0091701746f, -1.f),
    C_Normal3f(-0.20415765f, -0.978938043f, 0.f),
    C_Vertex3f(0.191178203f, -0.0060261488f, 0.f),
    C_Vertex3f(0.191178203f, -0.0060261488f, -1.f),
    C_Normal3f(-0.293056995f, -0.95609498f, 0.f),
    C_Vertex3f(0.172780752f, -0.00131011009f, 0.f),
    C_Vertex3f(0.172780752f, -0.00131011009f, -1.f),
    C_Normal3f(-0.383106947f, -0.923704028f, 0.f),
    C_Vertex3f(0.155277491f, 0.00497794151f, 0.f),
    C_Vertex3f(0.155277491f, 0.00497794151f, -1.f),
    C_Normal3f(-0.471707076f, -0.881755412f, 0.f),
    C_Vertex3f(0.138668418f, 0.012838006f, 0.f),
    C_Vertex3f(0.138668418f, 0.012838006f, -1.f),
    C_Normal3f(-0.556190014f, -0.831055164f, 0.f),
    C_Vertex3f(0.122953534f, 0.0222700834f, 0.f),
    C_Vertex3f(0.122953534f, 0.0222700834f, -1.f),
    C_Normal3f(-0.634200037f, -0.773169041f, 0.f),
    C_Vertex3f(0.108132839f, 0.0332741737f, 0.f),
    C_Vertex3f(0.108132839f, 0.0332741737f, -1.f),
    C_Normal3f(-0.703374207f, -0.710819721f, 0.f),
    C_Vertex3f(0.0942063332f, 0.0458502769f, 0.f),
    C_Vertex3f(0.0942063332f, 0.0458502769f, -1.f),
    C_Normal3f(-0.767092049f, -0.641537011f, 0.f),
    C_Vertex3f(0.0817748308f, 0.0593560934f, 0.f),
    C_Vertex3f(0.0817748308f, 0.0593560934f, -1.f),
    C_Normal3f(-0.825462222f, -0.564457297f, 0.f),
    C_Vertex3f(0.0708383322f, 0.0737916231f, 0.f),
    C_Vertex3f(0.0708383322f, 0.0737916231f, -1.f),
    C_Normal3f(-0.876509428f, -0.481384665f, 0.f),
    C_Vertex3f(0.0613968372f, 0.0891568661f, 0.f),
    C_Vertex3f(0.0613968372f, 0.0891568661f, -1.f),
    C_Normal3f(-0.918823004f, -0.394670099f, 0.f),
    C_Vertex3f(0.053450346f, 0.105451822f, 0.f),
    C_Vertex3f(0.053450346f, 0.105451822f, -1.f),
    C_Normal3f(-0.951745033f, -0.30689007f, 0.f),
    C_Vertex3f(0.0469988585f, 0.122676492f, 0.f),
    C_Vertex3f(0.0469988585f, 0.122676492f, -1.f),
    C_Normal3f(-0.975388825f, -0.220492035f, 0.f),
    C_Vertex3f(0.0420423746f, 0.140830874f, 0.f),
    C_Vertex3f(0.0420423746f, 0.140830874f, -1.f),
    C_Normal3f(-0.988528609f, -0.151034042f, 0.f),
    C_Vertex3f(0.0385808945f, 0.15991497f, 0.f),
    C_Vertex3f(0.0385808945f, 0.15991497f, -1.f),
    C_Normal3f(-0.995207548f, -0.0977850929f, 0.f),
    C_Vertex3f(0.0375976563f, 0.169921875f, 0.f),
    C_Vertex3f(0.0375976563f, 0.169921875f, -1.f),
    C_End(),
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.421754837f, 0.298080444f, 0.f),
    C_Vertex3f(0.413120031f, 0.307515383f, 0.f),
    C_Vertex3f(0.41688931f, 0.0702028275f, 0.f),
    C_Vertex3f(0.403689623f, 0.316070318f, 0.f),
    C_Vertex3f(0.403508663f, 0.0548324585f, 0.f),
    C_Vertex3f(0.393463612f, 0.323745251f, 0.f),
    C_Vertex3f(0.388216496f, 0.0402603149f, 0.f),
    C_Vertex3f(0.382441998f, 0.33054018f, 0.f),
    C_Vertex3f(0.373535156f, 0.194684982f, 0.f),
    C_Vertex3f(0.372429252f, 0.207637072f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.370624781f, 0.336455107f, 0.f),
    C_Vertex3f(0.358011961f, 0.34149003f, 0.f),
    C_Vertex3f(0.36247611f, 0.242929935f, 0.f),
    C_Vertex3f(0.366899729f, 0.231759548f, 0.f),
    C_Vertex3f(0.370217443f, 0.21999526f, 0.f),
    C_Vertex3f(0.372429252f, 0.207637072f, 0.f),
    C_Vertex3f(0.382441998f, 0.33054018f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.337189198f, 0.436214685f, 0.f),
    C_Vertex3f(0.333722591f, 0.281672478f, 0.f),
    C_Vertex3f(0.337501526f, 0.34728241f, 0.f),
    C_Vertex3f(0.342569828f, 0.272877693f, 0.f),
    C_Vertex3f(0.344603539f, 0.345644951f, 0.f),
    C_Vertex3f(0.35031116f, 0.263489008f, 0.f),
    C_Vertex3f(0.358011961f, 0.34149003f, 0.f),
    C_Vertex3f(0.356946588f, 0.253506422f, 0.f),
    C_Vertex3f(0.36247611f, 0.242929935f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.280475974f, 0.309156179f, 0.f),
    C_Vertex3f(0.292326689f, 0.305858135f, 0.f),
    C_Vertex3f(0.294477463f, 0.391327858f, 0.f),
    C_Vertex3f(0.303576708f, 0.301460743f, 0.f),
    C_Vertex3f(0.309552193f, 0.40115118f, 0.f),
    C_Vertex3f(0.314226031f, 0.295964003f, 0.f),
    C_Vertex3f(0.318345785f, 0.40858686f, 0.f),
    C_Vertex3f(0.324274659f, 0.289367914f, 0.f),
    C_Vertex3f(0.32588315f, 0.416909337f, 0.f),
    C_Vertex3f(0.333722591f, 0.281672478f, 0.f),
    C_Vertex3f(0.332164288f, 0.426118612f, 0.f),
    C_Vertex3f(0.337189198f, 0.436214685f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.27312088f, 0.381504536f, 0.f),
    C_Vertex3f(0.250507355f, 0.374955654f, 0.f),
    C_Vertex3f(0.254972458f, 0.312454224f, 0.f),
    C_Vertex3f(0.268024564f, 0.311354876f, 0.f),
    C_Vertex3f(0.280475974f, 0.309156179f, 0.f),
    C_Vertex3f(0.294477463f, 0.391327858f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.211669922f, 0.371681213f, 0.f),
    C_Vertex3f(0.216201782f, 0.309175491f, 0.f),
    C_Vertex3f(0.226636887f, 0.371681213f, 0.f),
    C_Vertex3f(0.230072021f, 0.311361313f, 0.f),
    C_Vertex3f(0.250507355f, 0.374955654f, 0.f),
    C_Vertex3f(0.242576599f, 0.312454224f, 0.f),
    C_Vertex3f(0.254972458f, 0.312454224f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.1926651f, 0.303710938f, 0.f),
    C_Vertex3f(0.200965881f, 0.305896759f, 0.f),
    C_Vertex3f(0.201400757f, 0.372558594f, 0.f),
    C_Vertex3f(0.216201782f, 0.309175491f, 0.f),
    C_Vertex3f(0.20533371f, 0.372119904f, 0.f),
    C_Vertex3f(0.211669922f, 0.371681213f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.451151848f, 0.24002552f, 0.f),
    C_Vertex3f(0.451296687f, 0.139666557f, 0.f),
    C_Vertex3f(0.454091549f, 0.22647047f, 0.f),
    C_Vertex3f(0.455119729f, 0.159028053f, 0.f),
    C_Vertex3f(0.45605135f, 0.212267399f, 0.f),
    C_Vertex3f(0.45703125f, 0.179187775f, 0.f),
    C_Vertex3f(0.45703125f, 0.197416306f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.436453342f, 0.27680254f, 0.f),
    C_Vertex3f(0.43791604f, 0.103338242f, 0.f),
    C_Vertex3f(0.442332745f, 0.265191555f, 0.f),
    C_Vertex3f(0.445562124f, 0.121103287f, 0.f),
    C_Vertex3f(0.447232246f, 0.252932549f, 0.f),
    C_Vertex3f(0.451296687f, 0.139666557f, 0.f),
    C_Vertex3f(0.451151848f, 0.24002552f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.42959404f, 0.287765503f, 0.f),
    C_Vertex3f(0.421754837f, 0.298080444f, 0.f),
    C_Vertex3f(0.428358436f, 0.0863714218f, 0.f),
    C_Vertex3f(0.43791604f, 0.103338242f, 0.f),
    C_Vertex3f(0.436453342f, 0.27680254f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.373535156f, 0.194684982f, 0.f),
    C_Vertex3f(0.373535156f, 0.180810928f, 0.f),
    C_Vertex3f(0.388216496f, 0.0402603149f, 0.f),
    C_Vertex3f(0.372344375f, 0.167182446f, 0.f),
    C_Vertex3f(0.371914029f, 0.0275096893f, 0.f),
    C_Vertex3f(0.369962811f, 0.154127598f, 0.f),
    C_Vertex3f(0.366390467f, 0.141646385f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.366390467f, 0.141646385f, 0.f),
    C_Vertex3f(0.36162734f, 0.129738808f, 0.f),
    C_Vertex3f(0.371914029f, 0.0275096893f, 0.f),
    C_Vertex3f(0.355673432f, 0.118404865f, 0.f),
    C_Vertex3f(0.354601264f, 0.0165805817f, 0.f),
    C_Vertex3f(0.348528743f, 0.107644558f, 0.f),
    C_Vertex3f(0.340193272f, 0.0974578857f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.3362782f, 0.00747299194f, 0.f),
    C_Vertex3f(0.354601264f, 0.0165805817f, 0.f),
    C_Vertex3f(0.340193272f, 0.0974578857f, 0.f),
    C_Vertex3f(0.330667019f, 0.0878448486f, 0.f),
    C_Vertex3f(0.320590138f, 0.0794334412f, 0.f),
    C_Vertex3f(0.316944838f, 0.000186920166f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.320590138f, 0.0794334412f, 0.f),
    C_Vertex3f(0.30996263f, 0.0722236633f, 0.f),
    C_Vertex3f(0.316944838f, 0.000186920166f, 0.f),
    C_Vertex3f(0.298784494f, 0.0662155151f, 0.f),
    C_Vertex3f(0.296601176f, -0.00527763367f, 0.f),
    C_Vertex3f(0.287055731f, 0.0614089966f, 0.f),
    C_Vertex3f(0.275247216f, -0.00892066956f, 0.f),
    C_Vertex3f(0.27477634f, 0.0578041077f, 0.f),
    C_Vertex3f(0.261946321f, 0.0554008484f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.252882957f, -0.0107421875f, 0.f),
    C_Vertex3f(0.275247216f, -0.00892066956f, 0.f),
    C_Vertex3f(0.261946321f, 0.0554008484f, 0.f),
    C_Vertex3f(0.248565674f, 0.0541992188f, 0.f),
    C_Vertex3f(0.235725403f, 0.0541992188f, 0.f),
    C_Vertex3f(0.23065567f, -0.0107421875f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.235725403f, 0.0541992188f, 0.f),
    C_Vertex3f(0.224431515f, 0.0551218987f, 0.f),
    C_Vertex3f(0.23065567f, -0.0107421875f, 0.f),
    C_Vertex3f(0.213593006f, 0.0569672585f, 0.f),
    C_Vertex3f(0.210469842f, -0.0091701746f, 0.f),
    C_Vertex3f(0.203209877f, 0.0597352982f, 0.f),
    C_Vertex3f(0.193282127f, 0.0634260178f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.191178203f, -0.0060261488f, 0.f),
    C_Vertex3f(0.210469842f, -0.0091701746f, 0.f),
    C_Vertex3f(0.193282127f, 0.0634260178f, 0.f),
    C_Vertex3f(0.183809757f, 0.0680394173f, 0.f),
    C_Vertex3f(0.174792767f, 0.0735754967f, 0.f),
    C_Vertex3f(0.172780752f, -0.00131011009f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.174792767f, 0.0735754967f, 0.f),
    C_Vertex3f(0.166231155f, 0.080034256f, 0.f),
    C_Vertex3f(0.172780752f, -0.00131011009f, 0.f),
    C_Vertex3f(0.158124924f, 0.0874156952f, 0.f),
    C_Vertex3f(0.155277491f, 0.00497794151f, 0.f),
    C_Vertex3f(0.150608778f, 0.0959658623f, 0.f),
    C_Vertex3f(0.143682718f, 0.105684757f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.138668418f, 0.012838006f, 0.f),
    C_Vertex3f(0.155277491f, 0.00497794151f, 0.f),
    C_Vertex3f(0.143682718f, 0.105684757f, 0.f),
    C_Vertex3f(0.137346745f, 0.11657238f, 0.f),
    C_Vertex3f(0.131600857f, 0.128628731f, 0.f),
    C_Vertex3f(0.126445055f, 0.141853809f, 0.f),
    C_Vertex3f(0.122953534f, 0.0222700834f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.122953534f, 0.0222700834f, 0.f),
    C_Vertex3f(0.126445055f, 0.141853809f, 0.f),
    C_Vertex3f(0.121879339f, 0.156247616f, 0.f),
    C_Vertex3f(0.117903709f, 0.17181015f, 0.f),
    C_Vertex3f(0.116210938f, 0.180175781f, 0.f),
    C_Vertex3f(0.108132839f, 0.0332741737f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.116210938f, 0.180175781f, 0.f),
    C_Vertex3f(0.0375976563f, 0.169921875f, 0.f),
    C_Vertex3f(0.0385808945f, 0.15991497f, 0.f),
    C_Vertex3f(0.0420423746f, 0.140830874f, 0.f),
    C_Vertex3f(0.0469988585f, 0.122676492f, 0.f),
    C_Vertex3f(0.053450346f, 0.105451822f, 0.f),
    C_Vertex3f(0.0613968372f, 0.0891568661f, 0.f),
    C_Vertex3f(0.0708383322f, 0.0737916231f, 0.f),
    C_Vertex3f(0.0817748308f, 0.0593560934f, 0.f),
    C_Vertex3f(0.0942063332f, 0.0458502769f, 0.f),
    C_Vertex3f(0.108132839f, 0.0332741737f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.42578125f, 0.466491699f, 0.f),
    C_Vertex3f(0.42578125f, 0.487758636f, 0.f),
    C_Vertex3f(0.42299509f, 0.446696758f, 0.f),
    C_Vertex3f(0.422857285f, 0.508971214f, 0.f),
    C_Vertex3f(0.417422771f, 0.427828312f, 0.f),
    C_Vertex3f(0.417009354f, 0.529583931f, 0.f),
    C_Vertex3f(0.409064293f, 0.40988636f, 0.f),
    C_Vertex3f(0.408237457f, 0.549596786f, 0.f),
    C_Vertex3f(0.397919655f, 0.392870903f, 0.f),
    C_Vertex3f(0.396541595f, 0.569009781f, 0.f),
    C_Vertex3f(0.38409853f, 0.377601147f, 0.f),
    C_Vertex3f(0.382250309f, 0.586378098f, 0.f),
    C_Vertex3f(0.367600918f, 0.364077091f, 0.f),
    C_Vertex3f(0.365363598f, 0.601701736f, 0.f),
    C_Vertex3f(0.348426819f, 0.352298737f, 0.f),
    C_Vertex3f(0.345881462f, 0.614980698f, 0.f),
    C_Vertex3f(0.344726563f, 0.484046936f, 0.f),
    C_Vertex3f(0.343811512f, 0.494386554f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.345881462f, 0.614980698f, 0.f),
    C_Vertex3f(0.323803902f, 0.626214981f, 0.f),
    C_Vertex3f(0.325510502f, 0.539130569f, 0.f),
    C_Vertex3f(0.331000805f, 0.531108975f, 0.f),
    C_Vertex3f(0.335576057f, 0.522623777f, 0.f),
    C_Vertex3f(0.339236259f, 0.513674974f, 0.f),
    C_Vertex3f(0.341981411f, 0.504262567f, 0.f),
    C_Vertex3f(0.343811512f, 0.494386554f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.323803902f, 0.626214981f, 0.f),
    C_Vertex3f(0.300687313f, 0.634640694f, 0.f),
    C_Vertex3f(0.303931713f, 0.559990525f, 0.f),
    C_Vertex3f(0.311784744f, 0.55378294f, 0.f),
    C_Vertex3f(0.319105148f, 0.546688557f, 0.f),
    C_Vertex3f(0.325510502f, 0.539130569f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.300687313f, 0.634640694f, 0.f),
    C_Vertex3f(0.276531696f, 0.640257835f, 0.f),
    C_Vertex3f(0.277176857f, 0.573292494f, 0.f),
    C_Vertex3f(0.286627769f, 0.569745302f, 0.f),
    C_Vertex3f(0.295546055f, 0.565311313f, 0.f),
    C_Vertex3f(0.303931713f, 0.559990525f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.234101295f, 0.578613281f, 0.f),
    C_Vertex3f(0.245628357f, 0.578613281f, 0.f),
    C_Vertex3f(0.251337051f, 0.643066406f, 0.f),
    C_Vertex3f(0.256677151f, 0.577726483f, 0.f),
    C_Vertex3f(0.276531696f, 0.640257835f, 0.f),
    C_Vertex3f(0.267193317f, 0.575952888f, 0.f),
    C_Vertex3f(0.277176857f, 0.573292494f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.228711128f, 0.643066406f, 0.f),
    C_Vertex3f(0.21047163f, 0.641708016f, 0.f),
    C_Vertex3f(0.212590337f, 0.575901031f, 0.f),
    C_Vertex3f(0.223106742f, 0.577709198f, 0.f),
    C_Vertex3f(0.234101295f, 0.578613281f, 0.f),
    C_Vertex3f(0.251337051f, 0.643066406f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.183910012f, 0.565052032f, 0.f),
    C_Vertex3f(0.192991972f, 0.569572449f, 0.f),
    C_Vertex3f(0.193010807f, 0.638991237f, 0.f),
    C_Vertex3f(0.20255208f, 0.573188782f, 0.f),
    C_Vertex3f(0.21047163f, 0.641708016f, 0.f),
    C_Vertex3f(0.212590337f, 0.575901031f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.176328659f, 0.634916067f, 0.f),
    C_Vertex3f(0.160425186f, 0.629482508f, 0.f),
    C_Vertex3f(0.167180538f, 0.55329895f, 0.f),
    C_Vertex3f(0.175306201f, 0.559627533f, 0.f),
    C_Vertex3f(0.183910012f, 0.565052032f, 0.f),
    C_Vertex3f(0.193010807f, 0.638991237f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.160425186f, 0.629482508f, 0.f),
    C_Vertex3f(0.145300388f, 0.622690558f, 0.f),
    C_Vertex3f(0.14628613f, 0.528888702f, 0.f),
    C_Vertex3f(0.152568221f, 0.537929535f, 0.f),
    C_Vertex3f(0.159533024f, 0.546066284f, 0.f),
    C_Vertex3f(0.167180538f, 0.55329895f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.145300388f, 0.622690558f, 0.f),
    C_Vertex3f(0.130954266f, 0.614540219f, 0.f),
    C_Vertex3f(0.131536126f, 0.496341705f, 0.f),
    C_Vertex3f(0.135770082f, 0.508094788f, 0.f),
    C_Vertex3f(0.14068675f, 0.518943787f, 0.f),
    C_Vertex3f(0.14628613f, 0.528888702f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.130954266f, 0.614540219f, 0.f),
    C_Vertex3f(0.117386818f, 0.60503149f, 0.f),
    C_Vertex3f(0.124023438f, 0.462890625f, 0.f),
    C_Vertex3f(0.125116348f, 0.470123291f, 0.f),
    C_Vertex3f(0.127984881f, 0.48368454f, 0.f),
    C_Vertex3f(0.131536126f, 0.496341705f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.124023438f, 0.462890625f, 0.f),
    C_Vertex3f(0.117386818f, 0.60503149f, 0.f),
    C_Vertex3f(0.104598045f, 0.594164371f, 0.f),
    C_Vertex3f(0.0929570198f, 0.582184434f, 0.f),
    C_Vertex3f(0.0824637413f, 0.569091678f, 0.f),
    C_Vertex3f(0.0731182098f, 0.554886103f, 0.f),
    C_Vertex3f(0.0649204254f, 0.539567709f, 0.f),
    C_Vertex3f(0.057870388f, 0.523136497f, 0.f),
    C_Vertex3f(0.0519680977f, 0.505592465f, 0.f),
    C_Vertex3f(0.0472135544f, 0.486935616f, 0.f),
    C_Vertex3f(0.0454101563f, 0.477050781f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.348426819f, 0.352298737f, 0.f),
    C_Vertex3f(0.344726563f, 0.484046936f, 0.f),
    C_Vertex3f(0.344726563f, 0.471823692f, 0.f),
    C_Vertex3f(0.343470335f, 0.459067225f, 0.f),
    C_Vertex3f(0.34095788f, 0.447197556f, 0.f),
    C_Vertex3f(0.337501526f, 0.34728241f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.337501526f, 0.34728241f, 0.f),
    C_Vertex3f(0.34095788f, 0.447197556f, 0.f),
    C_Vertex3f(0.337189198f, 0.436214685f, 0.f),
    C_Vertex3f(0.421754837f, 0.298080444f, 0.f),
    C_Vertex3f(0.41688931f, 0.0702028275f, 0.f),
    C_Vertex3f(0.428358436f, 0.0863714218f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, -1.f),
    C_FrontFace(GL_CW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.421754837f, 0.298080444f, -1.f),
    C_Vertex3f(0.413120031f, 0.307515383f, -1.f),
    C_Vertex3f(0.41688931f, 0.0702028275f, -1.f),
    C_Vertex3f(0.403689623f, 0.316070318f, -1.f),
    C_Vertex3f(0.403508663f, 0.0548324585f, -1.f),
    C_Vertex3f(0.393463612f, 0.323745251f, -1.f),
    C_Vertex3f(0.388216496f, 0.0402603149f, -1.f),
    C_Vertex3f(0.382441998f, 0.33054018f, -1.f),
    C_Vertex3f(0.373535156f, 0.194684982f, -1.f),
    C_Vertex3f(0.372429252f, 0.207637072f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.370624781f, 0.336455107f, -1.f),
    C_Vertex3f(0.358011961f, 0.34149003f, -1.f),
    C_Vertex3f(0.36247611f, 0.242929935f, -1.f),
    C_Vertex3f(0.366899729f, 0.231759548f, -1.f),
    C_Vertex3f(0.370217443f, 0.21999526f, -1.f),
    C_Vertex3f(0.372429252f, 0.207637072f, -1.f),
    C_Vertex3f(0.382441998f, 0.33054018f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.337189198f, 0.436214685f, -1.f),
    C_Vertex3f(0.333722591f, 0.281672478f, -1.f),
    C_Vertex3f(0.337501526f, 0.34728241f, -1.f),
    C_Vertex3f(0.342569828f, 0.272877693f, -1.f),
    C_Vertex3f(0.344603539f, 0.345644951f, -1.f),
    C_Vertex3f(0.35031116f, 0.263489008f, -1.f),
    C_Vertex3f(0.358011961f, 0.34149003f, -1.f),
    C_Vertex3f(0.356946588f, 0.253506422f, -1.f),
    C_Vertex3f(0.36247611f, 0.242929935f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.280475974f, 0.309156179f, -1.f),
    C_Vertex3f(0.292326689f, 0.305858135f, -1.f),
    C_Vertex3f(0.294477463f, 0.391327858f, -1.f),
    C_Vertex3f(0.303576708f, 0.301460743f, -1.f),
    C_Vertex3f(0.309552193f, 0.40115118f, -1.f),
    C_Vertex3f(0.314226031f, 0.295964003f, -1.f),
    C_Vertex3f(0.318345785f, 0.40858686f, -1.f),
    C_Vertex3f(0.324274659f, 0.289367914f, -1.f),
    C_Vertex3f(0.32588315f, 0.416909337f, -1.f),
    C_Vertex3f(0.333722591f, 0.281672478f, -1.f),
    C_Vertex3f(0.332164288f, 0.426118612f, -1.f),
    C_Vertex3f(0.337189198f, 0.436214685f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.27312088f, 0.381504536f, -1.f),
    C_Vertex3f(0.250507355f, 0.374955654f, -1.f),
    C_Vertex3f(0.254972458f, 0.312454224f, -1.f),
    C_Vertex3f(0.268024564f, 0.311354876f, -1.f),
    C_Vertex3f(0.280475974f, 0.309156179f, -1.f),
    C_Vertex3f(0.294477463f, 0.391327858f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.211669922f, 0.371681213f, -1.f),
    C_Vertex3f(0.216201782f, 0.309175491f, -1.f),
    C_Vertex3f(0.226636887f, 0.371681213f, -1.f),
    C_Vertex3f(0.230072021f, 0.311361313f, -1.f),
    C_Vertex3f(0.250507355f, 0.374955654f, -1.f),
    C_Vertex3f(0.242576599f, 0.312454224f, -1.f),
    C_Vertex3f(0.254972458f, 0.312454224f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.1926651f, 0.303710938f, -1.f),
    C_Vertex3f(0.200965881f, 0.305896759f, -1.f),
    C_Vertex3f(0.201400757f, 0.372558594f, -1.f),
    C_Vertex3f(0.216201782f, 0.309175491f, -1.f),
    C_Vertex3f(0.20533371f, 0.372119904f, -1.f),
    C_Vertex3f(0.211669922f, 0.371681213f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.451151848f, 0.24002552f, -1.f),
    C_Vertex3f(0.451296687f, 0.139666557f, -1.f),
    C_Vertex3f(0.454091549f, 0.22647047f, -1.f),
    C_Vertex3f(0.455119729f, 0.159028053f, -1.f),
    C_Vertex3f(0.45605135f, 0.212267399f, -1.f),
    C_Vertex3f(0.45703125f, 0.179187775f, -1.f),
    C_Vertex3f(0.45703125f, 0.197416306f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.436453342f, 0.27680254f, -1.f),
    C_Vertex3f(0.43791604f, 0.103338242f, -1.f),
    C_Vertex3f(0.442332745f, 0.265191555f, -1.f),
    C_Vertex3f(0.445562124f, 0.121103287f, -1.f),
    C_Vertex3f(0.447232246f, 0.252932549f, -1.f),
    C_Vertex3f(0.451296687f, 0.139666557f, -1.f),
    C_Vertex3f(0.451151848f, 0.24002552f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.42959404f, 0.287765503f, -1.f),
    C_Vertex3f(0.421754837f, 0.298080444f, -1.f),
    C_Vertex3f(0.428358436f, 0.0863714218f, -1.f),
    C_Vertex3f(0.43791604f, 0.103338242f, -1.f),
    C_Vertex3f(0.436453342f, 0.27680254f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.373535156f, 0.194684982f, -1.f),
    C_Vertex3f(0.373535156f, 0.180810928f, -1.f),
    C_Vertex3f(0.388216496f, 0.0402603149f, -1.f),
    C_Vertex3f(0.372344375f, 0.167182446f, -1.f),
    C_Vertex3f(0.371914029f, 0.0275096893f, -1.f),
    C_Vertex3f(0.369962811f, 0.154127598f, -1.f),
    C_Vertex3f(0.366390467f, 0.141646385f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.366390467f, 0.141646385f, -1.f),
    C_Vertex3f(0.36162734f, 0.129738808f, -1.f),
    C_Vertex3f(0.371914029f, 0.0275096893f, -1.f),
    C_Vertex3f(0.355673432f, 0.118404865f, -1.f),
    C_Vertex3f(0.354601264f, 0.0165805817f, -1.f),
    C_Vertex3f(0.348528743f, 0.107644558f, -1.f),
    C_Vertex3f(0.340193272f, 0.0974578857f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.3362782f, 0.00747299194f, -1.f),
    C_Vertex3f(0.354601264f, 0.0165805817f, -1.f),
    C_Vertex3f(0.340193272f, 0.0974578857f, -1.f),
    C_Vertex3f(0.330667019f, 0.0878448486f, -1.f),
    C_Vertex3f(0.320590138f, 0.0794334412f, -1.f),
    C_Vertex3f(0.316944838f, 0.000186920166f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.320590138f, 0.0794334412f, -1.f),
    C_Vertex3f(0.30996263f, 0.0722236633f, -1.f),
    C_Vertex3f(0.316944838f, 0.000186920166f, -1.f),
    C_Vertex3f(0.298784494f, 0.0662155151f, -1.f),
    C_Vertex3f(0.296601176f, -0.00527763367f, -1.f),
    C_Vertex3f(0.287055731f, 0.0614089966f, -1.f),
    C_Vertex3f(0.275247216f, -0.00892066956f, -1.f),
    C_Vertex3f(0.27477634f, 0.0578041077f, -1.f),
    C_Vertex3f(0.261946321f, 0.0554008484f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.252882957f, -0.0107421875f, -1.f),
    C_Vertex3f(0.275247216f, -0.00892066956f, -1.f),
    C_Vertex3f(0.261946321f, 0.0554008484f, -1.f),
    C_Vertex3f(0.248565674f, 0.0541992188f, -1.f),
    C_Vertex3f(0.235725403f, 0.0541992188f, -1.f),
    C_Vertex3f(0.23065567f, -0.0107421875f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.235725403f, 0.0541992188f, -1.f),
    C_Vertex3f(0.224431515f, 0.0551218987f, -1.f),
    C_Vertex3f(0.23065567f, -0.0107421875f, -1.f),
    C_Vertex3f(0.213593006f, 0.0569672585f, -1.f),
    C_Vertex3f(0.210469842f, -0.0091701746f, -1.f),
    C_Vertex3f(0.203209877f, 0.0597352982f, -1.f),
    C_Vertex3f(0.193282127f, 0.0634260178f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.191178203f, -0.0060261488f, -1.f),
    C_Vertex3f(0.210469842f, -0.0091701746f, -1.f),
    C_Vertex3f(0.193282127f, 0.0634260178f, -1.f),
    C_Vertex3f(0.183809757f, 0.0680394173f, -1.f),
    C_Vertex3f(0.174792767f, 0.0735754967f, -1.f),
    C_Vertex3f(0.172780752f, -0.00131011009f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.174792767f, 0.0735754967f, -1.f),
    C_Vertex3f(0.166231155f, 0.080034256f, -1.f),
    C_Vertex3f(0.172780752f, -0.00131011009f, -1.f),
    C_Vertex3f(0.158124924f, 0.0874156952f, -1.f),
    C_Vertex3f(0.155277491f, 0.00497794151f, -1.f),
    C_Vertex3f(0.150608778f, 0.0959658623f, -1.f),
    C_Vertex3f(0.143682718f, 0.105684757f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.138668418f, 0.012838006f, -1.f),
    C_Vertex3f(0.155277491f, 0.00497794151f, -1.f),
    C_Vertex3f(0.143682718f, 0.105684757f, -1.f),
    C_Vertex3f(0.137346745f, 0.11657238f, -1.f),
    C_Vertex3f(0.131600857f, 0.128628731f, -1.f),
    C_Vertex3f(0.126445055f, 0.141853809f, -1.f),
    C_Vertex3f(0.122953534f, 0.0222700834f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.122953534f, 0.0222700834f, -1.f),
    C_Vertex3f(0.126445055f, 0.141853809f, -1.f),
    C_Vertex3f(0.121879339f, 0.156247616f, -1.f),
    C_Vertex3f(0.117903709f, 0.17181015f, -1.f),
    C_Vertex3f(0.116210938f, 0.180175781f, -1.f),
    C_Vertex3f(0.108132839f, 0.0332741737f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.116210938f, 0.180175781f, -1.f),
    C_Vertex3f(0.0375976563f, 0.169921875f, -1.f),
    C_Vertex3f(0.0385808945f, 0.15991497f, -1.f),
    C_Vertex3f(0.0420423746f, 0.140830874f, -1.f),
    C_Vertex3f(0.0469988585f, 0.122676492f, -1.f),
    C_Vertex3f(0.053450346f, 0.105451822f, -1.f),
    C_Vertex3f(0.0613968372f, 0.0891568661f, -1.f),
    C_Vertex3f(0.0708383322f, 0.0737916231f, -1.f),
    C_Vertex3f(0.0817748308f, 0.0593560934f, -1.f),
    C_Vertex3f(0.0942063332f, 0.0458502769f, -1.f),
    C_Vertex3f(0.108132839f, 0.0332741737f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.42578125f, 0.466491699f, -1.f),
    C_Vertex3f(0.42578125f, 0.487758636f, -1.f),
    C_Vertex3f(0.42299509f, 0.446696758f, -1.f),
    C_Vertex3f(0.422857285f, 0.508971214f, -1.f),
    C_Vertex3f(0.417422771f, 0.427828312f, -1.f),
    C_Vertex3f(0.417009354f, 0.529583931f, -1.f),
    C_Vertex3f(0.409064293f, 0.40988636f, -1.f),
    C_Vertex3f(0.408237457f, 0.549596786f, -1.f),
    C_Vertex3f(0.397919655f, 0.392870903f, -1.f),
    C_Vertex3f(0.396541595f, 0.569009781f, -1.f),
    C_Vertex3f(0.38409853f, 0.377601147f, -1.f),
    C_Vertex3f(0.382250309f, 0.586378098f, -1.f),
    C_Vertex3f(0.367600918f, 0.364077091f, -1.f),
    C_Vertex3f(0.365363598f, 0.601701736f, -1.f),
    C_Vertex3f(0.348426819f, 0.352298737f, -1.f),
    C_Vertex3f(0.345881462f, 0.614980698f, -1.f),
    C_Vertex3f(0.344726563f, 0.484046936f, -1.f),
    C_Vertex3f(0.343811512f, 0.494386554f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.345881462f, 0.614980698f, -1.f),
    C_Vertex3f(0.323803902f, 0.626214981f, -1.f),
    C_Vertex3f(0.325510502f, 0.539130569f, -1.f),
    C_Vertex3f(0.331000805f, 0.531108975f, -1.f),
    C_Vertex3f(0.335576057f, 0.522623777f, -1.f),
    C_Vertex3f(0.339236259f, 0.513674974f, -1.f),
    C_Vertex3f(0.341981411f, 0.504262567f, -1.f),
    C_Vertex3f(0.343811512f, 0.494386554f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.323803902f, 0.626214981f, -1.f),
    C_Vertex3f(0.300687313f, 0.634640694f, -1.f),
    C_Vertex3f(0.303931713f, 0.559990525f, -1.f),
    C_Vertex3f(0.311784744f, 0.55378294f, -1.f),
    C_Vertex3f(0.319105148f, 0.546688557f, -1.f),
    C_Vertex3f(0.325510502f, 0.539130569f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.300687313f, 0.634640694f, -1.f),
    C_Vertex3f(0.276531696f, 0.640257835f, -1.f),
    C_Vertex3f(0.277176857f, 0.573292494f, -1.f),
    C_Vertex3f(0.286627769f, 0.569745302f, -1.f),
    C_Vertex3f(0.295546055f, 0.565311313f, -1.f),
    C_Vertex3f(0.303931713f, 0.559990525f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.234101295f, 0.578613281f, -1.f),
    C_Vertex3f(0.245628357f, 0.578613281f, -1.f),
    C_Vertex3f(0.251337051f, 0.643066406f, -1.f),
    C_Vertex3f(0.256677151f, 0.577726483f, -1.f),
    C_Vertex3f(0.276531696f, 0.640257835f, -1.f),
    C_Vertex3f(0.267193317f, 0.575952888f, -1.f),
    C_Vertex3f(0.277176857f, 0.573292494f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.228711128f, 0.643066406f, -1.f),
    C_Vertex3f(0.21047163f, 0.641708016f, -1.f),
    C_Vertex3f(0.212590337f, 0.575901031f, -1.f),
    C_Vertex3f(0.223106742f, 0.577709198f, -1.f),
    C_Vertex3f(0.234101295f, 0.578613281f, -1.f),
    C_Vertex3f(0.251337051f, 0.643066406f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.183910012f, 0.565052032f, -1.f),
    C_Vertex3f(0.192991972f, 0.569572449f, -1.f),
    C_Vertex3f(0.193010807f, 0.638991237f, -1.f),
    C_Vertex3f(0.20255208f, 0.573188782f, -1.f),
    C_Vertex3f(0.21047163f, 0.641708016f, -1.f),
    C_Vertex3f(0.212590337f, 0.575901031f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.176328659f, 0.634916067f, -1.f),
    C_Vertex3f(0.160425186f, 0.629482508f, -1.f),
    C_Vertex3f(0.167180538f, 0.55329895f, -1.f),
    C_Vertex3f(0.175306201f, 0.559627533f, -1.f),
    C_Vertex3f(0.183910012f, 0.565052032f, -1.f),
    C_Vertex3f(0.193010807f, 0.638991237f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.160425186f, 0.629482508f, -1.f),
    C_Vertex3f(0.145300388f, 0.622690558f, -1.f),
    C_Vertex3f(0.14628613f, 0.528888702f, -1.f),
    C_Vertex3f(0.152568221f, 0.537929535f, -1.f),
    C_Vertex3f(0.159533024f, 0.546066284f, -1.f),
    C_Vertex3f(0.167180538f, 0.55329895f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.145300388f, 0.622690558f, -1.f),
    C_Vertex3f(0.130954266f, 0.614540219f, -1.f),
    C_Vertex3f(0.131536126f, 0.496341705f, -1.f),
    C_Vertex3f(0.135770082f, 0.508094788f, -1.f),
    C_Vertex3f(0.14068675f, 0.518943787f, -1.f),
    C_Vertex3f(0.14628613f, 0.528888702f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.130954266f, 0.614540219f, -1.f),
    C_Vertex3f(0.117386818f, 0.60503149f, -1.f),
    C_Vertex3f(0.124023438f, 0.462890625f, -1.f),
    C_Vertex3f(0.125116348f, 0.470123291f, -1.f),
    C_Vertex3f(0.127984881f, 0.48368454f, -1.f),
    C_Vertex3f(0.131536126f, 0.496341705f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.124023438f, 0.462890625f, -1.f),
    C_Vertex3f(0.117386818f, 0.60503149f, -1.f),
    C_Vertex3f(0.104598045f, 0.594164371f, -1.f),
    C_Vertex3f(0.0929570198f, 0.582184434f, -1.f),
    C_Vertex3f(0.0824637413f, 0.569091678f, -1.f),
    C_Vertex3f(0.0731182098f, 0.554886103f, -1.f),
    C_Vertex3f(0.0649204254f, 0.539567709f, -1.f),
    C_Vertex3f(0.057870388f, 0.523136497f, -1.f),
    C_Vertex3f(0.0519680977f, 0.505592465f, -1.f),
    C_Vertex3f(0.0472135544f, 0.486935616f, -1.f),
    C_Vertex3f(0.0454101563f, 0.477050781f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.348426819f, 0.352298737f, -1.f),
    C_Vertex3f(0.344726563f, 0.484046936f, -1.f),
    C_Vertex3f(0.344726563f, 0.471823692f, -1.f),
    C_Vertex3f(0.343470335f, 0.459067225f, -1.f),
    C_Vertex3f(0.34095788f, 0.447197556f, -1.f),
    C_Vertex3f(0.337501526f, 0.34728241f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.337501526f, 0.34728241f, -1.f),
    C_Vertex3f(0.34095788f, 0.447197556f, -1.f),
    C_Vertex3f(0.337189198f, 0.436214685f, -1.f),
    C_Vertex3f(0.421754837f, 0.298080444f, -1.f),
    C_Vertex3f(0.41688931f, 0.0702028275f, -1.f),
    C_Vertex3f(0.428358436f, 0.0863714218f, -1.f),
    C_End(),
    C_Translatef(0.497558594f, 0.f, 0.f),
};
static const Call char_52[] = {
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_FrontFace(GL_CW),
    C_Begin(GL_QUADS),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.2890625f, 0.f, 0.f),
    C_Vertex3f(0.2890625f, 0.f, -1.f),
    C_Vertex3f(0.2890625f, 0.153320313f, -1.f),
    C_Vertex3f(0.2890625f, 0.153320313f, 0.f),
    C_Normal3f(-0.f, -1.f, 0.f),
    C_Vertex3f(0.2890625f, 0.153320313f, 0.f),
    C_Vertex3f(0.2890625f, 0.153320313f, -1.f),
    C_Vertex3f(0.0112304688f, 0.153320313f, -1.f),
    C_Vertex3f(0.0112304688f, 0.153320313f, 0.f),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.0112304688f, 0.153320313f, 0.f),
    C_Vertex3f(0.0112304688f, 0.153320313f, -1.f),
    C_Vertex3f(0.0112304688f, 0.225585938f, -1.f),
    C_Vertex3f(0.0112304688f, 0.225585938f, 0.f),
    C_Normal3f(-0.817873478f, 0.575398088f, 0.f),
    C_Vertex3f(0.0112304688f, 0.225585938f, 0.f),
    C_Vertex3f(0.0112304688f, 0.225585938f, -1.f),
    C_Vertex3f(0.303222656f, 0.640625f, -1.f),
    C_Vertex3f(0.303222656f, 0.640625f, 0.f),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.303222656f, 0.640625f, 0.f),
    C_Vertex3f(0.303222656f, 0.640625f, -1.f),
    C_Vertex3f(0.367675781f, 0.640625f, -1.f),
    C_Vertex3f(0.367675781f, 0.640625f, 0.f),
    C_Normal3f(0.99999994f, 0.f, 0.f),
    C_Vertex3f(0.367675781f, 0.640625f, 0.f),
    C_Vertex3f(0.367675781f, 0.640625f, -1.f),
    C_Vertex3f(0.367675781f, 0.225585938f, -1.f),
    C_Vertex3f(0.367675781f, 0.225585938f, 0.f),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.367675781f, 0.225585938f, 0.f),
    C_Vertex3f(0.367675781f, 0.225585938f, -1.f),
    C_Vertex3f(0.454101563f, 0.225585938f, -1.f),
    C_Vertex3f(0.454101563f, 0.225585938f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.454101563f, 0.225585938f, 0.f),
    C_Vertex3f(0.454101563f, 0.225585938f, -1.f),
    C_Vertex3f(0.454101563f, 0.153320313f, -1.f),
    C_Vertex3f(0.454101563f, 0.153320313f, 0.f),
    C_Normal3f(-0.f, -1.f, 0.f),
    C_Vertex3f(0.454101563f, 0.153320313f, 0.f),
    C_Vertex3f(0.454101563f, 0.153320313f, -1.f),
    C_Vertex3f(0.367675781f, 0.153320313f, -1.f),
    C_Vertex3f(0.367675781f, 0.153320313f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.367675781f, 0.153320313f, 0.f),
    C_Vertex3f(0.367675781f, 0.153320313f, -1.f),
    C_Vertex3f(0.367675781f, 0.f, -1.f),
    C_Vertex3f(0.367675781f, 0.f, 0.f),
    C_Normal3f(-0.f, -1.f, 0.f),
    C_Vertex3f(0.367675781f, 0.f, 0.f),
    C_Vertex3f(0.367675781f, 0.f, -1.f),
    C_Vertex3f(0.2890625f, 0.f, -1.f),
    C_Vertex3f(0.2890625f, 0.f, 0.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.2890625f, 0.225585938f, 0.f),
    C_Vertex3f(0.2890625f, 0.225585938f, -1.f),
    C_Vertex3f(0.2890625f, 0.514831543f, -1.f),
    C_Vertex3f(0.2890625f, 0.514831543f, 0.f),
    C_Normal3f(0.821854949f, -0.569696844f, 0.f),
    C_Vertex3f(0.2890625f, 0.514831543f, 0.f),
    C_Vertex3f(0.2890625f, 0.514831543f, -1.f),
    C_Vertex3f(0.0885620117f, 0.225585938f, -1.f),
    C_Vertex3f(0.0885620117f, 0.225585938f, 0.f),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.0885620117f, 0.225585938f, 0.f),
    C_Vertex3f(0.0885620117f, 0.225585938f, -1.f),
    C_Vertex3f(0.2890625f, 0.225585938f, -1.f),
    C_Vertex3f(0.2890625f, 0.225585938f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.0112304688f, 0.153320313f, 0.f),
    C_Vertex3f(0.2890625f, 0.153320313f, 0.f),
    C_Vertex3f(0.0112304688f, 0.225585938f, 0.f),
    C_Vertex3f(0.0885620117f, 0.225585938f, 0.f),
    C_Vertex3f(0.303222656f, 0.640625f, 0.f),
    C_Vertex3f(0.2890625f, 0.514831543f, 0.f),
    C_Vertex3f(0.367675781f, 0.f, 0.f),
    C_Vertex3f(0.2890625f, 0.225585938f, 0.f),
    C_Vertex3f(0.2890625f, 0.153320313f, 0.f),
    C_Vertex3f(0.0885620117f, 0.225585938f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.303222656f, 0.640625f, 0.f),
    C_Vertex3f(0.367675781f, 0.f, 0.f),
    C_Vertex3f(0.367675781f, 0.640625f, 0.f),
    C_Vertex3f(0.367675781f, 0.153320313f, 0.f),
    C_Vertex3f(0.367675781f, 0.225585938f, 0.f),
    C_Vertex3f(0.454101563f, 0.153320313f, 0.f),
    C_Vertex3f(0.454101563f, 0.225585938f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.367675781f, 0.f, 0.f),
    C_Vertex3f(0.2890625f, 0.153320313f, 0.f),
    C_Vertex3f(0.2890625f, 0.f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, -1.f),
    C_FrontFace(GL_CW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.0112304688f, 0.153320313f, -1.f),
    C_Vertex3f(0.2890625f, 0.153320313f, -1.f),
    C_Vertex3f(0.0112304688f, 0.225585938f, -1.f),
    C_Vertex3f(0.0885620117f, 0.225585938f, -1.f),
    C_Vertex3f(0.303222656f, 0.640625f, -1.f),
    C_Vertex3f(0.2890625f, 0.514831543f, -1.f),
    C_Vertex3f(0.367675781f, 0.f, -1.f),
    C_Vertex3f(0.2890625f, 0.225585938f, -1.f),
    C_Vertex3f(0.2890625f, 0.153320313f, -1.f),
    C_Vertex3f(0.0885620117f, 0.225585938f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.303222656f, 0.640625f, -1.f),
    C_Vertex3f(0.367675781f, 0.f, -1.f),
    C_Vertex3f(0.367675781f, 0.640625f, -1.f),
    C_Vertex3f(0.367675781f, 0.153320313f, -1.f),
    C_Vertex3f(0.367675781f, 0.225585938f, -1.f),
    C_Vertex3f(0.454101563f, 0.153320313f, -1.f),
    C_Vertex3f(0.454101563f, 0.225585938f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.367675781f, 0.f, -1.f),
    C_Vertex3f(0.2890625f, 0.153320313f, -1.f),
    C_Vertex3f(0.2890625f, 0.f, -1.f),
    C_End(),
    C_Translatef(0.497558594f, 0.f, 0.f),
};
static const Call char_53[] = {
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_FrontFace(GL_CW),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.0825574473f, 0.996586323f, 0.f),
    C_Vertex3f(0.037109375f, 0.16796875f, 0.f),
    C_Vertex3f(0.037109375f, 0.16796875f, -1.f),
    C_Vertex3f(0.119628906f, 0.174804688f, -1.f),
    C_Vertex3f(0.119628906f, 0.174804688f, 0.f),
    C_End(),
    C_Begin(GL_QUAD_STRIP),
    C_Normal3f(0.988623321f, 0.150412783f, 0.f),
    C_Vertex3f(0.119628906f, 0.174804688f, 0.f),
    C_Vertex3f(0.119628906f, 0.174804688f, -1.f),
    C_Normal3f(0.981788993f, 0.189974412f, 0.f),
    C_Vertex3f(0.120776176f, 0.167263985f, 0.f),
    C_Vertex3f(0.120776176f, 0.167263985f, -1.f),
    C_Normal3f(0.970029175f, 0.242988139f, 0.f),
    C_Vertex3f(0.123825192f, 0.153118253f, 0.f),
    C_Vertex3f(0.123825192f, 0.153118253f, -1.f),
    C_Normal3f(0.950164378f, 0.311749429f, 0.f),
    C_Vertex3f(0.127628684f, 0.139908195f, 0.f),
    C_Vertex3f(0.127628684f, 0.139908195f, -1.f),
    C_Normal3f(0.922637641f, 0.385667861f, 0.f),
    C_Vertex3f(0.132186651f, 0.12763381f, 0.f),
    C_Vertex3f(0.132186651f, 0.12763381f, -1.f),
    C_Normal3f(0.885985076f, 0.463713616f, 0.f),
    C_Vertex3f(0.137499094f, 0.116295099f, 0.f),
    C_Vertex3f(0.137499094f, 0.116295099f, -1.f),
    C_Normal3f(0.838972747f, 0.54417336f, 0.f),
    C_Vertex3f(0.143566012f, 0.105892062f, 0.f),
    C_Vertex3f(0.143566012f, 0.105892062f, -1.f),
    C_Normal3f(0.780910671f, 0.62464267f, 0.f),
    C_Vertex3f(0.150387406f, 0.0964246988f, 0.f),
    C_Vertex3f(0.150387406f, 0.0964246988f, -1.f),
    C_Normal3f(0.711978853f, 0.70220083f, 0.f),
    C_Vertex3f(0.157963276f, 0.0878930092f, 0.f),
    C_Vertex3f(0.157963276f, 0.0878930092f, -1.f),
    C_Normal3f(0.639934123f, 0.768429756f, 0.f),
    C_Vertex3f(0.166293621f, 0.0802969933f, 0.f),
    C_Vertex3f(0.166293621f, 0.0802969933f, -1.f),
    C_Normal3f(0.565854907f, 0.824504912f, 0.f),
    C_Vertex3f(0.175065637f, 0.0736504793f, 0.f),
    C_Vertex3f(0.175065637f, 0.0736504793f, -1.f),
    C_Normal3f(0.48428601f, 0.874909699f, 0.f),
    C_Vertex3f(0.184279323f, 0.0679534674f, 0.f),
    C_Vertex3f(0.184279323f, 0.0679534674f, -1.f),
    C_Normal3f(0.397065639f, 0.917790174f, 0.f),
    C_Vertex3f(0.193934679f, 0.0632059574f, 0.f),
    C_Vertex3f(0.193934679f, 0.0632059574f, -1.f),
    C_Normal3f(0.306577802f, 0.951845586f, 0.f),
    C_Vertex3f(0.204031706f, 0.0594079494f, 0.f),
    C_Vertex3f(0.204031706f, 0.0594079494f, -1.f),
    C_Normal3f(0.215438113f, 0.976517558f, 0.f),
    C_Vertex3f(0.214570403f, 0.0565594435f, 0.f),
    C_Vertex3f(0.214570403f, 0.0565594435f, -1.f),
    C_Normal3f(0.126136214f, 0.992012918f, 0.f),
    C_Vertex3f(0.225550771f, 0.0546604395f, 0.f),
    C_Vertex3f(0.225550771f, 0.0546604395f, -1.f),
    C_Normal3f(0.0387219526f, 0.999250054f, 0.f),
    C_Vertex3f(0.236972809f, 0.0537109375f, 0.f),
    C_Vertex3f(0.236972809f, 0.0537109375f, -1.f),
    C_Normal3f(-0.0499646328f, 0.998750985f, 0.f),
    C_Vertex3f(0.250053406f, 0.0537109375f, 0.f),
    C_Vertex3f(0.250053406f, 0.0537109375f, -1.f),
    C_Normal3f(-0.147932872f, 0.9889974f, 0.f),
    C_Vertex3f(0.263787508f, 0.0550523996f, 0.f),
    C_Vertex3f(0.263787508f, 0.0550523996f, -1.f),
    C_Normal3f(-0.251810223f, 0.967776537f, 0.f),
    C_Vertex3f(0.276958227f, 0.0577353239f, 0.f),
    C_Vertex3f(0.276958227f, 0.0577353239f, -1.f),
    C_Normal3f(-0.355971098f, 0.934496999f, 0.f),
    C_Vertex3f(0.289565563f, 0.0617597103f, 0.f),
    C_Vertex3f(0.289565563f, 0.0617597103f, -1.f),
    C_Normal3f(-0.456595123f, 0.889674544f, 0.f),
    C_Vertex3f(0.301609516f, 0.0671255589f, 0.f),
    C_Vertex3f(0.301609516f, 0.0671255589f, -1.f),
    C_Normal3f(-0.550155461f, 0.835062265f, 0.f),
    C_Vertex3f(0.313090086f, 0.0738328695f, 0.f),
    C_Vertex3f(0.313090086f, 0.0738328695f, -1.f),
    C_Normal3f(-0.634009898f, 0.773324847f, 0.f),
    C_Vertex3f(0.324007273f, 0.0818816423f, 0.f),
    C_Vertex3f(0.324007273f, 0.0818816423f, -1.f),
    C_Normal3f(-0.706715226f, 0.707498193f, 0.f),
    C_Vertex3f(0.334361076f, 0.0912718773f, 0.f),
    C_Vertex3f(0.334361076f, 0.0912718773f, -1.f),
    C_Normal3f(-0.772611499f, 0.634879112f, 0.f),
    C_Vertex3f(0.344151497f, 0.102003574f, 0.f),
    C_Vertex3f(0.344151497f, 0.102003574f, -1.f),
    C_Normal3f(-0.834466457f, 0.551058769f, 0.f),
    C_Vertex3f(0.352718115f, 0.113611341f, 0.f),
    C_Vertex3f(0.352718115f, 0.113611341f, -1.f),
    C_Normal3f(-0.886892378f, 0.4619762f, 0.f),
    C_Vertex3f(0.36006093f, 0.126095176f, 0.f),
    C_Vertex3f(0.36006093f, 0.126095176f, -1.f),
    C_Normal3f(-0.928756475f, 0.370690554f, 0.f),
    C_Vertex3f(0.366179943f, 0.13945508f, 0.f),
    C_Vertex3f(0.366179943f, 0.13945508f, -1.f),
    C_Normal3f(-0.959940314f, 0.280204356f, 0.f),
    C_Vertex3f(0.371075153f, 0.153691053f, 0.f),
    C_Vertex3f(0.371075153f, 0.153691053f, -1.f),
    C_Normal3f(-0.981188774f, 0.193050712f, 0.f),
    C_Vertex3f(0.374746561f, 0.168803096f, 0.f),
    C_Vertex3f(0.374746561f, 0.168803096f, -1.f),
    C_Normal3f(-0.993813336f, 0.111063607f, 0.f),
    C_Vertex3f(0.377194166f, 0.184791207f, 0.f),
    C_Vertex3f(0.377194166f, 0.184791207f, -1.f),
    C_Normal3f(-0.999359131f, 0.035795629f, 0.f),
    C_Vertex3f(0.378417969f, 0.201655388f, 0.f),
    C_Vertex3f(0.378417969f, 0.201655388f, -1.f),
    C_Normal3f(-0.999376833f, -0.035299249f, 0.f),
    C_Vertex3f(0.378417969f, 0.218957901f, 0.f),
    C_Vertex3f(0.378417969f, 0.218957901f, -1.f),
    C_Normal3f(-0.993617296f, -0.112803586f, 0.f),
    C_Vertex3f(0.377242565f, 0.234932899f, 0.f),
    C_Vertex3f(0.377242565f, 0.234932899f, -1.f),
    C_Normal3f(-0.980445921f, -0.19678852f, 0.f),
    C_Vertex3f(0.374891758f, 0.25001812f, 0.f),
    C_Vertex3f(0.374891758f, 0.25001812f, -1.f),
    C_Normal3f(-0.958041847f, -0.286628485f, 0.f),
    C_Vertex3f(0.371365547f, 0.264213562f, 0.f),
    C_Vertex3f(0.371365547f, 0.264213562f, -1.f),
    C_Normal3f(-0.92483741f, -0.38036257f, 0.f),
    C_Vertex3f(0.366663933f, 0.277519226f, 0.f),
    C_Vertex3f(0.366663933f, 0.277519226f, -1.f),
    C_Normal3f(-0.879893661f, -0.475170612f, 0.f),
    C_Vertex3f(0.360786915f, 0.289935112f, 0.f),
    C_Vertex3f(0.360786915f, 0.289935112f, -1.f),
    C_Normal3f(-0.82328552f, -0.56762737f, 0.f),
    C_Vertex3f(0.353734493f, 0.30146122f, 0.f),
    C_Vertex3f(0.353734493f, 0.30146122f, -1.f),
    C_Normal3f(-0.756315172f, -0.654207528f, 0.f),
    C_Vertex3f(0.345506668f, 0.312097549f, 0.f),
    C_Vertex3f(0.345506668f, 0.312097549f, -1.f),
    C_Normal3f(-0.682806849f, -0.730598927f, 0.f),
    C_Vertex3f(0.336103439f, 0.321844101f, 0.f),
    C_Vertex3f(0.336103439f, 0.321844101f, -1.f),
    C_Normal3f(-0.6012519f, -0.79905951f, 0.f),
    C_Vertex3f(0.325952768f, 0.330372334f, 0.f),
    C_Vertex3f(0.325952768f, 0.330372334f, -1.f),
    C_Normal3f(-0.510995567f, -0.859583378f, 0.f),
    C_Vertex3f(0.315054655f, 0.337682247f, 0.f),
    C_Vertex3f(0.315054655f, 0.337682247f, -1.f),
    C_Normal3f(-0.415002555f, -0.909820259f, 0.f),
    C_Vertex3f(0.3034091f, 0.343773842f, 0.f),
    C_Vertex3f(0.3034091f, 0.343773842f, -1.f),
    C_Normal3f(-0.316798955f, -0.948492765f, 0.f),
    C_Vertex3f(0.291016102f, 0.348647118f, 0.f),
    C_Vertex3f(0.291016102f, 0.348647118f, -1.f),
    C_Normal3f(-0.21986334f, -0.975530624f, 0.f),
    C_Vertex3f(0.277875662f, 0.352302074f, 0.f),
    C_Vertex3f(0.277875662f, 0.352302074f, -1.f),
    C_Normal3f(-0.127100512f, -0.991889775f, 0.f),
    C_Vertex3f(0.26398778f, 0.354738712f, 0.f),
    C_Vertex3f(0.26398778f, 0.354738712f, -1.f),
    C_Normal3f(-0.0381734818f, -0.999271154f, 0.f),
    C_Vertex3f(0.249352455f, 0.355957031f, 0.f),
    C_Vertex3f(0.249352455f, 0.355957031f, -1.f),
    C_Normal3f(0.0612595342f, -0.998121858f, 0.f),
    C_Vertex3f(0.232095718f, 0.355957031f, 0.f),
    C_Vertex3f(0.232095718f, 0.355957031f, -1.f),
    C_Normal3f(0.181458637f, -0.983398616f, 0.f),
    C_Vertex3f(0.213940144f, 0.353783607f, 0.f),
    C_Vertex3f(0.213940144f, 0.353783607f, -1.f),
    C_Normal3f(0.309517503f, -0.9508937f, 0.f),
    C_Vertex3f(0.196759701f, 0.34943676f, 0.f),
    C_Vertex3f(0.196759701f, 0.34943676f, -1.f),
    C_Normal3f(0.435636222f, -0.900122821f, 0.f),
    C_Vertex3f(0.18055439f, 0.342916489f, 0.f),
    C_Vertex3f(0.18055439f, 0.342916489f, -1.f),
    C_Normal3f(0.543660343f, -0.839305341f, 0.f),
    C_Vertex3f(0.165324211f, 0.334222794f, 0.f),
    C_Vertex3f(0.165324211f, 0.334222794f, -1.f),
    C_Normal3f(0.639068782f, -0.769149661f, 0.f),
    C_Vertex3f(0.151716709f, 0.32423687f, 0.f),
    C_Vertex3f(0.151716709f, 0.32423687f, -1.f),
    C_Normal3f(0.729705572f, -0.683761537f, 0.f),
    C_Vertex3f(0.139731884f, 0.312958717f, 0.f),
    C_Vertex3f(0.139731884f, 0.312958717f, -1.f),
    C_Normal3f(0.797920883f, -0.602762103f, 0.f),
    C_Vertex3f(0.129369736f, 0.300388336f, 0.f),
    C_Vertex3f(0.129369736f, 0.300388336f, -1.f),
    C_Normal3f(0.845925629f, -0.533300936f, 0.f),
    C_Vertex3f(0.125f, 0.293457031f, 0.f),
    C_Vertex3f(0.125f, 0.293457031f, -1.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.131303608f, -0.991342187f, 0.f),
    C_Vertex3f(0.125f, 0.293457031f, 0.f),
    C_Vertex3f(0.125f, 0.293457031f, -1.f),
    C_Vertex3f(0.0512695313f, 0.303222656f, -1.f),
    C_Vertex3f(0.0512695313f, 0.303222656f, 0.f),
    C_Normal3f(-0.982706726f, 0.185168773f, 0.f),
    C_Vertex3f(0.0512695313f, 0.303222656f, 0.f),
    C_Vertex3f(0.0512695313f, 0.303222656f, -1.f),
    C_Vertex3f(0.11328125f, 0.632324219f, -1.f),
    C_Vertex3f(0.11328125f, 0.632324219f, 0.f),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.11328125f, 0.632324219f, 0.f),
    C_Vertex3f(0.11328125f, 0.632324219f, -1.f),
    C_Vertex3f(0.431640625f, 0.632324219f, -1.f),
    C_Vertex3f(0.431640625f, 0.632324219f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.431640625f, 0.632324219f, 0.f),
    C_Vertex3f(0.431640625f, 0.632324219f, -1.f),
    C_Vertex3f(0.431640625f, 0.557128906f, -1.f),
    C_Vertex3f(0.431640625f, 0.557128906f, 0.f),
    C_Normal3f(-0.f, -1.f, 0.f),
    C_Vertex3f(0.431640625f, 0.557128906f, 0.f),
    C_Vertex3f(0.431640625f, 0.557128906f, -1.f),
    C_Vertex3f(0.176139832f, 0.557128906f, -1.f),
    C_Vertex3f(0.176139832f, 0.557128906f, 0.f),
    C_Normal3f(0.980468333f, -0.196676612f, 0.f),
    C_Vertex3f(0.176139832f, 0.557128906f, 0.f),
    C_Vertex3f(0.176139832f, 0.557128906f, -1.f),
    C_Vertex3f(0.141647339f, 0.385177612f, -1.f),
    C_Vertex3f(0.141647339f, 0.385177612f, 0.f),
    C_End(),
    C_Begin(GL_QUAD_STRIP),
    C_Normal3f(-0.571032643f, 0.820927262f, 0.f),
    C_Vertex3f(0.141647339f, 0.385177612f, 0.f),
    C_Vertex3f(0.141647339f, 0.385177612f, -1.f),
    C_Normal3f(-0.534509599f, 0.845162451f, 0.f),
    C_Vertex3f(0.148856163f, 0.390192032f, 0.f),
    C_Vertex3f(0.148856163f, 0.390192032f, -1.f),
    C_Normal3f(-0.485215575f, 0.874394596f, 0.f),
    C_Vertex3f(0.163451433f, 0.398967266f, 0.f),
    C_Vertex3f(0.163451433f, 0.398967266f, -1.f),
    C_Normal3f(-0.420847684f, 0.907131314f, 0.f),
    C_Vertex3f(0.178224325f, 0.406488895f, 0.f),
    C_Vertex3f(0.178224325f, 0.406488895f, -1.f),
    C_Normal3f(-0.351203948f, 0.936298966f, 0.f),
    C_Vertex3f(0.193174839f, 0.41275692f, 0.f),
    C_Vertex3f(0.193174839f, 0.41275692f, -1.f),
    C_Normal3f(-0.277050674f, 0.960855365f, 0.f),
    C_Vertex3f(0.208302975f, 0.417771339f, 0.f),
    C_Vertex3f(0.208302975f, 0.417771339f, -1.f),
    C_Normal3f(-0.199487254f, 0.979900479f, 0.f),
    C_Vertex3f(0.223608732f, 0.421532154f, 0.f),
    C_Vertex3f(0.223608732f, 0.421532154f, -1.f),
    C_Normal3f(-0.119883306f, 0.992787898f, 0.f),
    C_Vertex3f(0.239092112f, 0.424039364f, 0.f),
    C_Vertex3f(0.239092112f, 0.424039364f, -1.f),
    C_Normal3f(-0.0367734171f, 0.999323547f, 0.f),
    C_Vertex3f(0.254753113f, 0.425292969f, 0.f),
    C_Vertex3f(0.254753113f, 0.425292969f, -1.f),
    C_Normal3f(0.0470875688f, 0.998890758f, 0.f),
    C_Vertex3f(0.273159027f, 0.425292969f, 0.f),
    C_Vertex3f(0.273159027f, 0.425292969f, -1.f),
    C_Normal3f(0.13679567f, 0.990599275f, 0.f),
    C_Vertex3f(0.293312907f, 0.423475266f, 0.f),
    C_Vertex3f(0.293312907f, 0.423475266f, -1.f),
    C_Normal3f(0.233483911f, 0.972360671f, 0.f),
    C_Vertex3f(0.312647462f, 0.419839859f, 0.f),
    C_Vertex3f(0.312647462f, 0.419839859f, -1.f),
    C_Normal3f(0.331511319f, 0.943451226f, 0.f),
    C_Vertex3f(0.331162691f, 0.414386749f, 0.f),
    C_Vertex3f(0.331162691f, 0.414386749f, -1.f),
    C_Normal3f(0.427720964f, 0.903910875f, 0.f),
    C_Vertex3f(0.348858595f, 0.407115936f, 0.f),
    C_Vertex3f(0.348858595f, 0.407115936f, -1.f),
    C_Normal3f(0.51896286f, 0.854796767f, 0.f),
    C_Vertex3f(0.365735173f, 0.39802742f, 0.f),
    C_Vertex3f(0.365735173f, 0.39802742f, -1.f),
    C_Normal3f(0.602587819f, 0.798052549f, 0.f),
    C_Vertex3f(0.381792426f, 0.387121201f, 0.f),
    C_Vertex3f(0.381792426f, 0.387121201f, -1.f),
    C_Normal3f(0.676808357f, 0.736159265f, 0.f),
    C_Vertex3f(0.397030354f, 0.374397278f, 0.f),
    C_Vertex3f(0.397030354f, 0.374397278f, -1.f),
    C_Normal3f(0.744214356f, 0.667940915f, 0.f),
    C_Vertex3f(0.411448956f, 0.359855652f, 0.f),
    C_Vertex3f(0.411448956f, 0.359855652f, -1.f),
    C_Normal3f(0.808588862f, 0.588374078f, 0.f),
    C_Vertex3f(0.424065232f, 0.344275236f, 0.f),
    C_Vertex3f(0.424065232f, 0.344275236f, -1.f),
    C_Normal3f(0.865635574f, 0.500674665f, 0.f),
    C_Vertex3f(0.434879184f, 0.327656031f, 0.f),
    C_Vertex3f(0.434879184f, 0.327656031f, -1.f),
    C_Normal3f(0.913220942f, 0.407464713f, 0.f),
    C_Vertex3f(0.44389081f, 0.309998035f, 0.f),
    C_Vertex3f(0.44389081f, 0.309998035f, -1.f),
    C_Normal3f(0.950115919f, 0.311896682f, 0.f),
    C_Vertex3f(0.451100111f, 0.29130125f, 0.f),
    C_Vertex3f(0.451100111f, 0.29130125f, -1.f),
    C_Normal3f(0.976138949f, 0.217146695f, 0.f),
    C_Vertex3f(0.456507087f, 0.271565676f, 0.f),
    C_Vertex3f(0.456507087f, 0.271565676f, -1.f),
    C_Normal3f(0.992036521f, 0.125950456f, 0.f),
    C_Vertex3f(0.460111737f, 0.250791311f, 0.f),
    C_Vertex3f(0.460111737f, 0.250791311f, -1.f),
    C_Normal3f(0.999166608f, 0.0408186205f, 0.f),
    C_Vertex3f(0.461914063f, 0.228978157f, 0.f),
    C_Vertex3f(0.461914063f, 0.228978157f, -1.f),
    C_Normal3f(0.99933207f, -0.0365442298f, 0.f),
    C_Vertex3f(0.461914063f, 0.206673622f, 0.f),
    C_Vertex3f(0.461914063f, 0.206673622f, -1.f),
    C_Normal3f(0.99344337f, -0.114325672f, 0.f),
    C_Vertex3f(0.460329771f, 0.185654402f, 0.f),
    C_Vertex3f(0.460329771f, 0.185654402f, -1.f),
    C_Normal3f(0.980786085f, -0.195086226f, 0.f),
    C_Vertex3f(0.457161188f, 0.165373087f, 0.f),
    C_Vertex3f(0.457161188f, 0.165373087f, -1.f),
    C_Normal3f(0.960637629f, -0.277804732f, 0.f),
    C_Vertex3f(0.452408314f, 0.145829678f, 0.f),
    C_Vertex3f(0.452408314f, 0.145829678f, -1.f),
    C_Normal3f(0.932694376f, -0.360667706f, 0.f),
    C_Vertex3f(0.446071148f, 0.127024174f, 0.f),
    C_Vertex3f(0.446071148f, 0.127024174f, -1.f),
    C_Normal3f(0.897162139f, -0.441701293f, 0.f),
    C_Vertex3f(0.438149691f, 0.108956575f, 0.f),
    C_Vertex3f(0.438149691f, 0.108956575f, -1.f),
    C_Normal3f(0.854780734f, -0.518989265f, 0.f),
    C_Vertex3f(0.428643942f, 0.0916268826f, 0.f),
    C_Vertex3f(0.428643942f, 0.0916268826f, -1.f),
    C_Normal3f(0.806255043f, -0.591567993f, 0.f),
    C_Vertex3f(0.417553902f, 0.0750350952f, 0.f),
    C_Vertex3f(0.417553902f, 0.0750350952f, -1.f),
    C_Normal3f(0.747210979f, -0.664586961f, 0.f),
    C_Vertex3f(0.403513908f, 0.0573768616f, 0.f),
    C_Vertex3f(0.403513908f, 0.0573768616f, -1.f),
    C_Normal3f(0.67011714f, -0.74225533f, 0.f),
    C_Vertex3f(0.386701584f, 0.0403470993f, 0.f),
    C_Vertex3f(0.386701584f, 0.0403470993f, -1.f),
    C_Normal3f(0.577362359f, -0.816488028f, 0.f),
    C_Vertex3f(0.36848259f, 0.0257501602f, 0.f),
    C_Vertex3f(0.36848259f, 0.0257501602f, -1.f),
    C_Normal3f(0.474144131f, -0.880447149f, 0.f),
    C_Vertex3f(0.348856926f, 0.0135860443f, 0.f),
    C_Vertex3f(0.348856926f, 0.0135860443f, -1.f),
    C_Normal3f(0.364756674f, -0.931102872f, 0.f),
    C_Vertex3f(0.327824593f, 0.00385475159f, 0.f),
    C_Vertex3f(0.327824593f, 0.00385475159f, -1.f),
    C_Normal3f(0.254179388f, -0.967157066f, 0.f),
    C_Vertex3f(0.30538559f, -0.00344371796f, 0.f),
    C_Vertex3f(0.30538559f, -0.00344371796f, -1.f),
    C_Normal3f(0.14703536f, -0.989131212f, 0.f),
    C_Vertex3f(0.281539917f, -0.00830936432f, 0.f),
    C_Vertex3f(0.281539917f, -0.00830936432f, -1.f),
    C_Normal3f(0.0490806848f, -0.998794794f, 0.f),
    C_Vertex3f(0.256287575f, -0.0107421875f, 0.f),
    C_Vertex3f(0.256287575f, -0.0107421875f, -1.f),
    C_Normal3f(-0.0338871181f, -0.99942565f, 0.f),
    C_Vertex3f(0.232031822f, -0.0107421875f, 0.f),
    C_Vertex3f(0.232031822f, -0.0107421875f, -1.f),
    C_Normal3f(-0.112035908f, -0.993704081f, 0.f),
    C_Vertex3f(0.21118319f, -0.00921285152f, 0.f),
    C_Vertex3f(0.21118319f, -0.00921285152f, -1.f),
    C_Normal3f(-0.193910003f, -0.981019258f, 0.f),
    C_Vertex3f(0.19133842f, -0.00615417957f, 0.f),
    C_Vertex3f(0.19133842f, -0.00615417957f, -1.f),
    C_Normal3f(-0.280183673f, -0.959946513f, 0.f),
    C_Vertex3f(0.172497511f, -0.00156617165f, 0.f),
    C_Vertex3f(0.172497511f, -0.00156617165f, -1.f),
    C_Normal3f(-0.368984342f, -0.929435551f, 0.f),
    C_Vertex3f(0.154660463f, 0.00455117226f, 0.f),
    C_Vertex3f(0.154660463f, 0.00455117226f, -1.f),
    C_Normal3f(-0.457882464f, -0.889012694f, 0.f),
    C_Vertex3f(0.137827277f, 0.0121978521f, 0.f),
    C_Vertex3f(0.137827277f, 0.0121978521f, -1.f),
    C_Normal3f(-0.544136822f, -0.83899653f, 0.f),
    C_Vertex3f(0.121997952f, 0.021373868f, 0.f),
    C_Vertex3f(0.121997952f, 0.021373868f, -1.f),
    C_Normal3f(-0.625066936f, -0.780571163f, 0.f),
    C_Vertex3f(0.107172489f, 0.0320792198f, 0.f),
    C_Vertex3f(0.107172489f, 0.0320792198f, -1.f),
    C_Normal3f(-0.697521508f, -0.71656394f, 0.f),
    C_Vertex3f(0.0933508873f, 0.0443139076f, 0.f),
    C_Vertex3f(0.0933508873f, 0.0443139076f, -1.f),
    C_Normal3f(-0.763899505f, -0.645335197f, 0.f),
    C_Vertex3f(0.0810111761f, 0.0575453043f, 0.f),
    C_Vertex3f(0.0810111761f, 0.0575453043f, -1.f),
    C_Normal3f(-0.824239552f, -0.566241205f, 0.f),
    C_Vertex3f(0.0701533556f, 0.0717734098f, 0.f),
    C_Vertex3f(0.0701533556f, 0.0717734098f, -1.f),
    C_Normal3f(-0.876516104f, -0.481372625f, 0.f),
    C_Vertex3f(0.0607774258f, 0.0869982243f, 0.f),
    C_Vertex3f(0.0607774258f, 0.0869982243f, -1.f),
    C_Normal3f(-0.91939503f, -0.393335342f, 0.f),
    C_Vertex3f(0.0528833866f, 0.103219748f, 0.f),
    C_Vertex3f(0.0528833866f, 0.103219748f, -1.f),
    C_Normal3f(-0.952394605f, -0.304868162f, 0.f),
    C_Vertex3f(0.0464712381f, 0.12043798f, 0.f),
    C_Vertex3f(0.0464712381f, 0.12043798f, -1.f),
    C_Normal3f(-0.975845754f, -0.218460873f, 0.f),
    C_Vertex3f(0.0415409803f, 0.138652921f, 0.f),
    C_Vertex3f(0.0415409803f, 0.138652921f, -1.f),
    C_Normal3f(-0.988766313f, -0.149469495f, 0.f),
    C_Vertex3f(0.0380926132f, 0.157864571f, 0.f),
    C_Vertex3f(0.0380926132f, 0.157864571f, -1.f),
    C_Normal3f(-0.995298743f, -0.0968525708f, 0.f),
    C_Vertex3f(0.037109375f, 0.16796875f, 0.f),
    C_Vertex3f(0.037109375f, 0.16796875f, -1.f),
    C_End(),
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.431640625f, 0.557128906f, 0.f),
    C_Vertex3f(0.431640625f, 0.632324219f, 0.f),
    C_Vertex3f(0.176139832f, 0.557128906f, 0.f),
    C_Vertex3f(0.11328125f, 0.632324219f, 0.f),
    C_Vertex3f(0.141647339f, 0.385177612f, 0.f),
    C_Vertex3f(0.125f, 0.293457031f, 0.f),
    C_Vertex3f(0.129369736f, 0.300388336f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.163451433f, 0.398967266f, 0.f),
    C_Vertex3f(0.148856163f, 0.390192032f, 0.f),
    C_Vertex3f(0.151716709f, 0.32423687f, 0.f),
    C_Vertex3f(0.141647339f, 0.385177612f, 0.f),
    C_Vertex3f(0.139731884f, 0.312958717f, 0.f),
    C_Vertex3f(0.129369736f, 0.300388336f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.461914063f, 0.206673622f, 0.f),
    C_Vertex3f(0.461914063f, 0.228978157f, 0.f),
    C_Vertex3f(0.460329771f, 0.185654402f, 0.f),
    C_Vertex3f(0.460111737f, 0.250791311f, 0.f),
    C_Vertex3f(0.457161188f, 0.165373087f, 0.f),
    C_Vertex3f(0.456507087f, 0.271565676f, 0.f),
    C_Vertex3f(0.452408314f, 0.145829678f, 0.f),
    C_Vertex3f(0.451100111f, 0.29130125f, 0.f),
    C_Vertex3f(0.446071148f, 0.127024174f, 0.f),
    C_Vertex3f(0.44389081f, 0.309998035f, 0.f),
    C_Vertex3f(0.438149691f, 0.108956575f, 0.f),
    C_Vertex3f(0.434879184f, 0.327656031f, 0.f),
    C_Vertex3f(0.428643942f, 0.0916268826f, 0.f),
    C_Vertex3f(0.424065232f, 0.344275236f, 0.f),
    C_Vertex3f(0.417553902f, 0.0750350952f, 0.f),
    C_Vertex3f(0.411448956f, 0.359855652f, 0.f),
    C_Vertex3f(0.403513908f, 0.0573768616f, 0.f),
    C_Vertex3f(0.397030354f, 0.374397278f, 0.f),
    C_Vertex3f(0.386701584f, 0.0403470993f, 0.f),
    C_Vertex3f(0.381792426f, 0.387121201f, 0.f),
    C_Vertex3f(0.378417969f, 0.218957901f, 0.f),
    C_Vertex3f(0.377242565f, 0.234932899f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.381792426f, 0.387121201f, 0.f),
    C_Vertex3f(0.365735173f, 0.39802742f, 0.f),
    C_Vertex3f(0.366663933f, 0.277519226f, 0.f),
    C_Vertex3f(0.371365547f, 0.264213562f, 0.f),
    C_Vertex3f(0.374891758f, 0.25001812f, 0.f),
    C_Vertex3f(0.377242565f, 0.234932899f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.336103439f, 0.321844101f, 0.f),
    C_Vertex3f(0.345506668f, 0.312097549f, 0.f),
    C_Vertex3f(0.348858595f, 0.407115936f, 0.f),
    C_Vertex3f(0.353734493f, 0.30146122f, 0.f),
    C_Vertex3f(0.365735173f, 0.39802742f, 0.f),
    C_Vertex3f(0.360786915f, 0.289935112f, 0.f),
    C_Vertex3f(0.366663933f, 0.277519226f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.331162691f, 0.414386749f, 0.f),
    C_Vertex3f(0.312647462f, 0.419839859f, 0.f),
    C_Vertex3f(0.315054655f, 0.337682247f, 0.f),
    C_Vertex3f(0.325952768f, 0.330372334f, 0.f),
    C_Vertex3f(0.336103439f, 0.321844101f, 0.f),
    C_Vertex3f(0.348858595f, 0.407115936f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.277875662f, 0.352302074f, 0.f),
    C_Vertex3f(0.291016102f, 0.348647118f, 0.f),
    C_Vertex3f(0.293312907f, 0.423475266f, 0.f),
    C_Vertex3f(0.3034091f, 0.343773842f, 0.f),
    C_Vertex3f(0.312647462f, 0.419839859f, 0.f),
    C_Vertex3f(0.315054655f, 0.337682247f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.163451433f, 0.398967266f, 0.f),
    C_Vertex3f(0.165324211f, 0.334222794f, 0.f),
    C_Vertex3f(0.178224325f, 0.406488895f, 0.f),
    C_Vertex3f(0.18055439f, 0.342916489f, 0.f),
    C_Vertex3f(0.193174839f, 0.41275692f, 0.f),
    C_Vertex3f(0.196759701f, 0.34943676f, 0.f),
    C_Vertex3f(0.208302975f, 0.417771339f, 0.f),
    C_Vertex3f(0.213940144f, 0.353783607f, 0.f),
    C_Vertex3f(0.223608732f, 0.421532154f, 0.f),
    C_Vertex3f(0.232095718f, 0.355957031f, 0.f),
    C_Vertex3f(0.239092112f, 0.424039364f, 0.f),
    C_Vertex3f(0.249352455f, 0.355957031f, 0.f),
    C_Vertex3f(0.254753113f, 0.425292969f, 0.f),
    C_Vertex3f(0.26398778f, 0.354738712f, 0.f),
    C_Vertex3f(0.273159027f, 0.425292969f, 0.f),
    C_Vertex3f(0.277875662f, 0.352302074f, 0.f),
    C_Vertex3f(0.293312907f, 0.423475266f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.386701584f, 0.0403470993f, 0.f),
    C_Vertex3f(0.378417969f, 0.218957901f, 0.f),
    C_Vertex3f(0.378417969f, 0.201655388f, 0.f),
    C_Vertex3f(0.377194166f, 0.184791207f, 0.f),
    C_Vertex3f(0.374746561f, 0.168803096f, 0.f),
    C_Vertex3f(0.371075153f, 0.153691053f, 0.f),
    C_Vertex3f(0.36848259f, 0.0257501602f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.36848259f, 0.0257501602f, 0.f),
    C_Vertex3f(0.371075153f, 0.153691053f, 0.f),
    C_Vertex3f(0.366179943f, 0.13945508f, 0.f),
    C_Vertex3f(0.36006093f, 0.126095176f, 0.f),
    C_Vertex3f(0.352718115f, 0.113611341f, 0.f),
    C_Vertex3f(0.348856926f, 0.0135860443f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.352718115f, 0.113611341f, 0.f),
    C_Vertex3f(0.344151497f, 0.102003574f, 0.f),
    C_Vertex3f(0.348856926f, 0.0135860443f, 0.f),
    C_Vertex3f(0.334361076f, 0.0912718773f, 0.f),
    C_Vertex3f(0.327824593f, 0.00385475159f, 0.f),
    C_Vertex3f(0.324007273f, 0.0818816423f, 0.f),
    C_Vertex3f(0.313090086f, 0.0738328695f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.30538559f, -0.00344371796f, 0.f),
    C_Vertex3f(0.327824593f, 0.00385475159f, 0.f),
    C_Vertex3f(0.313090086f, 0.0738328695f, 0.f),
    C_Vertex3f(0.301609516f, 0.0671255589f, 0.f),
    C_Vertex3f(0.289565563f, 0.0617597103f, 0.f),
    C_Vertex3f(0.281539917f, -0.00830936432f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.289565563f, 0.0617597103f, 0.f),
    C_Vertex3f(0.276958227f, 0.0577353239f, 0.f),
    C_Vertex3f(0.281539917f, -0.00830936432f, 0.f),
    C_Vertex3f(0.263787508f, 0.0550523996f, 0.f),
    C_Vertex3f(0.256287575f, -0.0107421875f, 0.f),
    C_Vertex3f(0.250053406f, 0.0537109375f, 0.f),
    C_Vertex3f(0.236972809f, 0.0537109375f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.232031822f, -0.0107421875f, 0.f),
    C_Vertex3f(0.256287575f, -0.0107421875f, 0.f),
    C_Vertex3f(0.236972809f, 0.0537109375f, 0.f),
    C_Vertex3f(0.225550771f, 0.0546604395f, 0.f),
    C_Vertex3f(0.214570403f, 0.0565594435f, 0.f),
    C_Vertex3f(0.21118319f, -0.00921285152f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.214570403f, 0.0565594435f, 0.f),
    C_Vertex3f(0.204031706f, 0.0594079494f, 0.f),
    C_Vertex3f(0.21118319f, -0.00921285152f, 0.f),
    C_Vertex3f(0.193934679f, 0.0632059574f, 0.f),
    C_Vertex3f(0.19133842f, -0.00615417957f, 0.f),
    C_Vertex3f(0.184279323f, 0.0679534674f, 0.f),
    C_Vertex3f(0.175065637f, 0.0736504793f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.172497511f, -0.00156617165f, 0.f),
    C_Vertex3f(0.19133842f, -0.00615417957f, 0.f),
    C_Vertex3f(0.175065637f, 0.0736504793f, 0.f),
    C_Vertex3f(0.166293621f, 0.0802969933f, 0.f),
    C_Vertex3f(0.157963276f, 0.0878930092f, 0.f),
    C_Vertex3f(0.154660463f, 0.00455117226f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.157963276f, 0.0878930092f, 0.f),
    C_Vertex3f(0.150387406f, 0.0964246988f, 0.f),
    C_Vertex3f(0.154660463f, 0.00455117226f, 0.f),
    C_Vertex3f(0.143566012f, 0.105892062f, 0.f),
    C_Vertex3f(0.137827277f, 0.0121978521f, 0.f),
    C_Vertex3f(0.137499094f, 0.116295099f, 0.f),
    C_Vertex3f(0.132186651f, 0.12763381f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.132186651f, 0.12763381f, 0.f),
    C_Vertex3f(0.127628684f, 0.139908195f, 0.f),
    C_Vertex3f(0.137827277f, 0.0121978521f, 0.f),
    C_Vertex3f(0.123825192f, 0.153118253f, 0.f),
    C_Vertex3f(0.121997952f, 0.021373868f, 0.f),
    C_Vertex3f(0.120776176f, 0.167263985f, 0.f),
    C_Vertex3f(0.119628906f, 0.174804688f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.119628906f, 0.174804688f, 0.f),
    C_Vertex3f(0.037109375f, 0.16796875f, 0.f),
    C_Vertex3f(0.0380926132f, 0.157864571f, 0.f),
    C_Vertex3f(0.0415409803f, 0.138652921f, 0.f),
    C_Vertex3f(0.0464712381f, 0.12043798f, 0.f),
    C_Vertex3f(0.0528833866f, 0.103219748f, 0.f),
    C_Vertex3f(0.0607774258f, 0.0869982243f, 0.f),
    C_Vertex3f(0.0701533556f, 0.0717734098f, 0.f),
    C_Vertex3f(0.0810111761f, 0.0575453043f, 0.f),
    C_Vertex3f(0.0933508873f, 0.0443139076f, 0.f),
    C_Vertex3f(0.107172489f, 0.0320792198f, 0.f),
    C_Vertex3f(0.121997952f, 0.021373868f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.163451433f, 0.398967266f, 0.f),
    C_Vertex3f(0.151716709f, 0.32423687f, 0.f),
    C_Vertex3f(0.165324211f, 0.334222794f, 0.f),
    C_Vertex3f(0.125f, 0.293457031f, 0.f),
    C_Vertex3f(0.11328125f, 0.632324219f, 0.f),
    C_Vertex3f(0.0512695313f, 0.303222656f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, -1.f),
    C_FrontFace(GL_CW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.431640625f, 0.557128906f, -1.f),
    C_Vertex3f(0.431640625f, 0.632324219f, -1.f),
    C_Vertex3f(0.176139832f, 0.557128906f, -1.f),
    C_Vertex3f(0.11328125f, 0.632324219f, -1.f),
    C_Vertex3f(0.141647339f, 0.385177612f, -1.f),
    C_Vertex3f(0.125f, 0.293457031f, -1.f),
    C_Vertex3f(0.129369736f, 0.300388336f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.163451433f, 0.398967266f, -1.f),
    C_Vertex3f(0.148856163f, 0.390192032f, -1.f),
    C_Vertex3f(0.151716709f, 0.32423687f, -1.f),
    C_Vertex3f(0.141647339f, 0.385177612f, -1.f),
    C_Vertex3f(0.139731884f, 0.312958717f, -1.f),
    C_Vertex3f(0.129369736f, 0.300388336f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.461914063f, 0.206673622f, -1.f),
    C_Vertex3f(0.461914063f, 0.228978157f, -1.f),
    C_Vertex3f(0.460329771f, 0.185654402f, -1.f),
    C_Vertex3f(0.460111737f, 0.250791311f, -1.f),
    C_Vertex3f(0.457161188f, 0.165373087f, -1.f),
    C_Vertex3f(0.456507087f, 0.271565676f, -1.f),
    C_Vertex3f(0.452408314f, 0.145829678f, -1.f),
    C_Vertex3f(0.451100111f, 0.29130125f, -1.f),
    C_Vertex3f(0.446071148f, 0.127024174f, -1.f),
    C_Vertex3f(0.44389081f, 0.309998035f, -1.f),
    C_Vertex3f(0.438149691f, 0.108956575f, -1.f),
    C_Vertex3f(0.434879184f, 0.327656031f, -1.f),
    C_Vertex3f(0.428643942f, 0.0916268826f, -1.f),
    C_Vertex3f(0.424065232f, 0.344275236f, -1.f),
    C_Vertex3f(0.417553902f, 0.0750350952f, -1.f),
    C_Vertex3f(0.411448956f, 0.359855652f, -1.f),
    C_Vertex3f(0.403513908f, 0.0573768616f, -1.f),
    C_Vertex3f(0.397030354f, 0.374397278f, -1.f),
    C_Vertex3f(0.386701584f, 0.0403470993f, -1.f),
    C_Vertex3f(0.381792426f, 0.387121201f, -1.f),
    C_Vertex3f(0.378417969f, 0.218957901f, -1.f),
    C_Vertex3f(0.377242565f, 0.234932899f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.381792426f, 0.387121201f, -1.f),
    C_Vertex3f(0.365735173f, 0.39802742f, -1.f),
    C_Vertex3f(0.366663933f, 0.277519226f, -1.f),
    C_Vertex3f(0.371365547f, 0.264213562f, -1.f),
    C_Vertex3f(0.374891758f, 0.25001812f, -1.f),
    C_Vertex3f(0.377242565f, 0.234932899f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.336103439f, 0.321844101f, -1.f),
    C_Vertex3f(0.345506668f, 0.312097549f, -1.f),
    C_Vertex3f(0.348858595f, 0.407115936f, -1.f),
    C_Vertex3f(0.353734493f, 0.30146122f, -1.f),
    C_Vertex3f(0.365735173f, 0.39802742f, -1.f),
    C_Vertex3f(0.360786915f, 0.289935112f, -1.f),
    C_Vertex3f(0.366663933f, 0.277519226f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.331162691f, 0.414386749f, -1.f),
    C_Vertex3f(0.312647462f, 0.419839859f, -1.f),
    C_Vertex3f(0.315054655f, 0.337682247f, -1.f),
    C_Vertex3f(0.325952768f, 0.330372334f, -1.f),
    C_Vertex3f(0.336103439f, 0.321844101f, -1.f),
    C_Vertex3f(0.348858595f, 0.407115936f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.277875662f, 0.352302074f, -1.f),
    C_Vertex3f(0.291016102f, 0.348647118f, -1.f),
    C_Vertex3f(0.293312907f, 0.423475266f, -1.f),
    C_Vertex3f(0.3034091f, 0.343773842f, -1.f),
    C_Vertex3f(0.312647462f, 0.419839859f, -1.f),
    C_Vertex3f(0.315054655f, 0.337682247f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.163451433f, 0.398967266f, -1.f),
    C_Vertex3f(0.165324211f, 0.334222794f, -1.f),
    C_Vertex3f(0.178224325f, 0.406488895f, -1.f),
    C_Vertex3f(0.18055439f, 0.342916489f, -1.f),
    C_Vertex3f(0.193174839f, 0.41275692f, -1.f),
    C_Vertex3f(0.196759701f, 0.34943676f, -1.f),
    C_Vertex3f(0.208302975f, 0.417771339f, -1.f),
    C_Vertex3f(0.213940144f, 0.353783607f, -1.f),
    C_Vertex3f(0.223608732f, 0.421532154f, -1.f),
    C_Vertex3f(0.232095718f, 0.355957031f, -1.f),
    C_Vertex3f(0.239092112f, 0.424039364f, -1.f),
    C_Vertex3f(0.249352455f, 0.355957031f, -1.f),
    C_Vertex3f(0.254753113f, 0.425292969f, -1.f),
    C_Vertex3f(0.26398778f, 0.354738712f, -1.f),
    C_Vertex3f(0.273159027f, 0.425292969f, -1.f),
    C_Vertex3f(0.277875662f, 0.352302074f, -1.f),
    C_Vertex3f(0.293312907f, 0.423475266f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.386701584f, 0.0403470993f, -1.f),
    C_Vertex3f(0.378417969f, 0.218957901f, -1.f),
    C_Vertex3f(0.378417969f, 0.201655388f, -1.f),
    C_Vertex3f(0.377194166f, 0.184791207f, -1.f),
    C_Vertex3f(0.374746561f, 0.168803096f, -1.f),
    C_Vertex3f(0.371075153f, 0.153691053f, -1.f),
    C_Vertex3f(0.36848259f, 0.0257501602f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.36848259f, 0.0257501602f, -1.f),
    C_Vertex3f(0.371075153f, 0.153691053f, -1.f),
    C_Vertex3f(0.366179943f, 0.13945508f, -1.f),
    C_Vertex3f(0.36006093f, 0.126095176f, -1.f),
    C_Vertex3f(0.352718115f, 0.113611341f, -1.f),
    C_Vertex3f(0.348856926f, 0.0135860443f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.352718115f, 0.113611341f, -1.f),
    C_Vertex3f(0.344151497f, 0.102003574f, -1.f),
    C_Vertex3f(0.348856926f, 0.0135860443f, -1.f),
    C_Vertex3f(0.334361076f, 0.0912718773f, -1.f),
    C_Vertex3f(0.327824593f, 0.00385475159f, -1.f),
    C_Vertex3f(0.324007273f, 0.0818816423f, -1.f),
    C_Vertex3f(0.313090086f, 0.0738328695f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.30538559f, -0.00344371796f, -1.f),
    C_Vertex3f(0.327824593f, 0.00385475159f, -1.f),
    C_Vertex3f(0.313090086f, 0.0738328695f, -1.f),
    C_Vertex3f(0.301609516f, 0.0671255589f, -1.f),
    C_Vertex3f(0.289565563f, 0.0617597103f, -1.f),
    C_Vertex3f(0.281539917f, -0.00830936432f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.289565563f, 0.0617597103f, -1.f),
    C_Vertex3f(0.276958227f, 0.0577353239f, -1.f),
    C_Vertex3f(0.281539917f, -0.00830936432f, -1.f),
    C_Vertex3f(0.263787508f, 0.0550523996f, -1.f),
    C_Vertex3f(0.256287575f, -0.0107421875f, -1.f),
    C_Vertex3f(0.250053406f, 0.0537109375f, -1.f),
    C_Vertex3f(0.236972809f, 0.0537109375f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.232031822f, -0.0107421875f, -1.f),
    C_Vertex3f(0.256287575f, -0.0107421875f, -1.f),
    C_Vertex3f(0.236972809f, 0.0537109375f, -1.f),
    C_Vertex3f(0.225550771f, 0.0546604395f, -1.f),
    C_Vertex3f(0.214570403f, 0.0565594435f, -1.f),
    C_Vertex3f(0.21118319f, -0.00921285152f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.214570403f, 0.0565594435f, -1.f),
    C_Vertex3f(0.204031706f, 0.0594079494f, -1.f),
    C_Vertex3f(0.21118319f, -0.00921285152f, -1.f),
    C_Vertex3f(0.193934679f, 0.0632059574f, -1.f),
    C_Vertex3f(0.19133842f, -0.00615417957f, -1.f),
    C_Vertex3f(0.184279323f, 0.0679534674f, -1.f),
    C_Vertex3f(0.175065637f, 0.0736504793f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.172497511f, -0.00156617165f, -1.f),
    C_Vertex3f(0.19133842f, -0.00615417957f, -1.f),
    C_Vertex3f(0.175065637f, 0.0736504793f, -1.f),
    C_Vertex3f(0.166293621f, 0.0802969933f, -1.f),
    C_Vertex3f(0.157963276f, 0.0878930092f, -1.f),
    C_Vertex3f(0.154660463f, 0.00455117226f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.157963276f, 0.0878930092f, -1.f),
    C_Vertex3f(0.150387406f, 0.0964246988f, -1.f),
    C_Vertex3f(0.154660463f, 0.00455117226f, -1.f),
    C_Vertex3f(0.143566012f, 0.105892062f, -1.f),
    C_Vertex3f(0.137827277f, 0.0121978521f, -1.f),
    C_Vertex3f(0.137499094f, 0.116295099f, -1.f),
    C_Vertex3f(0.132186651f, 0.12763381f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.132186651f, 0.12763381f, -1.f),
    C_Vertex3f(0.127628684f, 0.139908195f, -1.f),
    C_Vertex3f(0.137827277f, 0.0121978521f, -1.f),
    C_Vertex3f(0.123825192f, 0.153118253f, -1.f),
    C_Vertex3f(0.121997952f, 0.021373868f, -1.f),
    C_Vertex3f(0.120776176f, 0.167263985f, -1.f),
    C_Vertex3f(0.119628906f, 0.174804688f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.119628906f, 0.174804688f, -1.f),
    C_Vertex3f(0.037109375f, 0.16796875f, -1.f),
    C_Vertex3f(0.0380926132f, 0.157864571f, -1.f),
    C_Vertex3f(0.0415409803f, 0.138652921f, -1.f),
    C_Vertex3f(0.0464712381f, 0.12043798f, -1.f),
    C_Vertex3f(0.0528833866f, 0.103219748f, -1.f),
    C_Vertex3f(0.0607774258f, 0.0869982243f, -1.f),
    C_Vertex3f(0.0701533556f, 0.0717734098f, -1.f),
    C_Vertex3f(0.0810111761f, 0.0575453043f, -1.f),
    C_Vertex3f(0.0933508873f, 0.0443139076f, -1.f),
    C_Vertex3f(0.107172489f, 0.0320792198f, -1.f),
    C_Vertex3f(0.121997952f, 0.021373868f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.163451433f, 0.398967266f, -1.f),
    C_Vertex3f(0.151716709f, 0.32423687f, -1.f),
    C_Vertex3f(0.165324211f, 0.334222794f, -1.f),
    C_Vertex3f(0.125f, 0.293457031f, -1.f),
    C_Vertex3f(0.11328125f, 0.632324219f, -1.f),
    C_Vertex3f(0.0512695313f, 0.303222656f, -1.f),
    C_End(),
    C_Translatef(0.497558594f, 0.f, 0.f),
};
static const Call char_54[] = {
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_FrontFace(GL_CW),
    C_Begin(GL_QUADS),
    C_Normal3f(0.0809831321f, -0.996715486f, 0.f),
    C_Vertex3f(0.445800781f, 0.483398438f, 0.f),
    C_Vertex3f(0.445800781f, 0.483398438f, -1.f),
    C_Vertex3f(0.367675781f, 0.477050781f, -1.f),
    C_Vertex3f(0.367675781f, 0.477050781f, 0.f),
    C_End(),
    C_Begin(GL_QUAD_STRIP),
    C_Normal3f(-0.975490808f, -0.220040321f, 0.f),
    C_Vertex3f(0.367675781f, 0.477050781f, 0.f),
    C_Vertex3f(0.367675781f, 0.477050781f, -1.f),
    C_Normal3f(-0.962286532f, -0.272037834f, 0.f),
    C_Vertex3f(0.365047455f, 0.488702774f, 0.f),
    C_Vertex3f(0.365047455f, 0.488702774f, -1.f),
    C_Normal3f(-0.937081456f, -0.349110663f, 0.f),
    C_Vertex3f(0.35869503f, 0.508818626f, 0.f),
    C_Vertex3f(0.35869503f, 0.508818626f, -1.f),
    C_Normal3f(-0.886681676f, -0.46238035f, 0.f),
    C_Vertex3f(0.351246834f, 0.525746346f, 0.f),
    C_Vertex3f(0.351246834f, 0.525746346f, -1.f),
    C_Normal3f(-0.818156779f, -0.574995279f, 0.f),
    C_Vertex3f(0.342702866f, 0.539485931f, 0.f),
    C_Vertex3f(0.342702866f, 0.539485931f, -1.f),
    C_Normal3f(-0.733194172f, -0.680019438f, 0.f),
    C_Vertex3f(0.337882996f, 0.544761658f, 0.f),
    C_Vertex3f(0.337882996f, 0.544761658f, -1.f),
    C_Normal3f(-0.682577789f, -0.730812907f, 0.f),
    C_Vertex3f(0.333885193f, 0.548993111f, 0.f),
    C_Vertex3f(0.333885193f, 0.548993111f, -1.f),
    C_Normal3f(-0.620348036f, -0.784326613f, 0.f),
    C_Vertex3f(0.325424194f, 0.556398153f, 0.f),
    C_Vertex3f(0.325424194f, 0.556398153f, -1.f),
    C_Normal3f(-0.536202133f, -0.844089627f, 0.f),
    C_Vertex3f(0.316497803f, 0.562745333f, 0.f),
    C_Vertex3f(0.316497803f, 0.562745333f, -1.f),
    C_Normal3f(-0.443345875f, -0.896350682f, 0.f),
    C_Vertex3f(0.307106018f, 0.568034649f, 0.f),
    C_Vertex3f(0.307106018f, 0.568034649f, -1.f),
    C_Normal3f(-0.344492555f, -0.93878907f, 0.f),
    C_Vertex3f(0.29724884f, 0.572266102f, 0.f),
    C_Vertex3f(0.29724884f, 0.572266102f, -1.f),
    C_Normal3f(-0.24304083f, -0.970016122f, 0.f),
    C_Vertex3f(0.28692627f, 0.575439692f, 0.f),
    C_Vertex3f(0.28692627f, 0.575439692f, -1.f),
    C_Normal3f(-0.142513976f, -0.989792824f, 0.f),
    C_Vertex3f(0.276138306f, 0.577555418f, 0.f),
    C_Vertex3f(0.276138306f, 0.577555418f, -1.f),
    C_Normal3f(-0.0398378782f, -0.999206185f, 0.f),
    C_Vertex3f(0.264884949f, 0.578613281f, 0.f),
    C_Vertex3f(0.264884949f, 0.578613281f, -1.f),
    C_Normal3f(0.0792517215f, -0.996854722f, 0.f),
    C_Vertex3f(0.249605179f, 0.578613281f, 0.f),
    C_Vertex3f(0.249605179f, 0.578613281f, -1.f),
    C_Normal3f(0.223530024f, -0.974697053f, 0.f),
    C_Vertex3f(0.231884956f, 0.575989723f, 0.f),
    C_Vertex3f(0.231884956f, 0.575989723f, -1.f),
    C_Normal3f(0.378501058f, -0.925600827f, 0.f),
    C_Vertex3f(0.215285301f, 0.570742607f, 0.f),
    C_Vertex3f(0.215285301f, 0.570742607f, -1.f),
    C_Normal3f(0.529070735f, -0.848577678f, 0.f),
    C_Vertex3f(0.199806213f, 0.562871933f, 0.f),
    C_Vertex3f(0.199806213f, 0.562871933f, -1.f),
    C_Normal3f(0.656264842f, -0.754530609f, 0.f),
    C_Vertex3f(0.183376312f, 0.550848007f, 0.f),
    C_Vertex3f(0.183376312f, 0.550848007f, -1.f),
    C_Normal3f(0.75996846f, -0.649960041f, 0.f),
    C_Vertex3f(0.166817188f, 0.534179211f, 0.f),
    C_Vertex3f(0.166817188f, 0.534179211f, -1.f),
    C_Normal3f(0.842499197f, -0.5386976f, 0.f),
    C_Vertex3f(0.152200222f, 0.514395237f, 0.f),
    C_Vertex3f(0.152200222f, 0.514395237f, -1.f),
    C_Normal3f(0.89846319f, -0.439048886f, 0.f),
    C_Vertex3f(0.139525414f, 0.491496086f, 0.f),
    C_Vertex3f(0.139525414f, 0.491496086f, -1.f),
    C_Normal3f(0.9357723f, -0.352604926f, 0.f),
    C_Vertex3f(0.131475925f, 0.47198534f, 0.f),
    C_Vertex3f(0.131475925f, 0.47198534f, -1.f),
    C_Normal3f(0.959925592f, -0.280255198f, 0.f),
    C_Vertex3f(0.126752973f, 0.457599521f, 0.f),
    C_Vertex3f(0.126752973f, 0.457599521f, -1.f),
    C_Normal3f(0.974896789f, -0.222657278f, 0.f),
    C_Vertex3f(0.122673392f, 0.441835046f, 0.f),
    C_Vertex3f(0.122673392f, 0.441835046f, -1.f),
    C_Normal3f(0.98508811f, -0.172050208f, 0.f),
    C_Vertex3f(0.119237185f, 0.424691916f, 0.f),
    C_Vertex3f(0.119237185f, 0.424691916f, -1.f),
    C_Normal3f(0.991828263f, -0.127580076f, 0.f),
    C_Vertex3f(0.116444349f, 0.40617013f, 0.f),
    C_Vertex3f(0.116444349f, 0.40617013f, -1.f),
    C_Normal3f(0.996083021f, -0.0884233862f, 0.f),
    C_Vertex3f(0.114294887f, 0.386269689f, 0.f),
    C_Vertex3f(0.114294887f, 0.386269689f, -1.f),
    C_Normal3f(0.998549819f, -0.0538357347f, 0.f),
    C_Vertex3f(0.112788796f, 0.364990592f, 0.f),
    C_Vertex3f(0.112788796f, 0.364990592f, -1.f),
    C_Normal3f(0.999607086f, -0.0280311834f, 0.f),
    C_Vertex3f(0.111926079f, 0.34233284f, 0.f),
    C_Vertex3f(0.111926079f, 0.34233284f, -1.f),
    C_Normal3f(0.999958336f, -0.0091251554f, 0.f),
    C_Vertex3f(0.111816406f, 0.330314636f, 0.f),
    C_Vertex3f(0.111816406f, 0.330314636f, -1.f),
    C_End(),
    C_Begin(GL_QUAD_STRIP),
    C_Normal3f(-0.835570157f, 0.5493837f, 0.f),
    C_Vertex3f(0.111816406f, 0.330314636f, 0.f),
    C_Vertex3f(0.111816406f, 0.330314636f, -1.f),
    C_Normal3f(-0.791296482f, 0.611432672f, 0.f),
    C_Vertex3f(0.118927002f, 0.341129303f, 0.f),
    C_Vertex3f(0.118927002f, 0.341129303f, -1.f),
    C_Normal3f(-0.724574983f, 0.68919605f, 0.f),
    C_Vertex3f(0.134733677f, 0.359973431f, 0.f),
    C_Vertex3f(0.134733677f, 0.359973431f, -1.f),
    C_Normal3f(-0.627780378f, 0.778390527f, 0.f),
    C_Vertex3f(0.152125835f, 0.376032352f, 0.f),
    C_Vertex3f(0.152125835f, 0.376032352f, -1.f),
    C_Normal3f(-0.515097558f, 0.857131541f, 0.f),
    C_Vertex3f(0.171103477f, 0.389306068f, 0.f),
    C_Vertex3f(0.171103477f, 0.389306068f, -1.f),
    C_Normal3f(-0.403523296f, 0.914969385f, 0.f),
    C_Vertex3f(0.191666603f, 0.399794579f, 0.f),
    C_Vertex3f(0.191666603f, 0.399794579f, -1.f),
    C_Normal3f(-0.294121206f, 0.955768168f, 0.f),
    C_Vertex3f(0.212722301f, 0.407660961f, 0.f),
    C_Vertex3f(0.212722301f, 0.407660961f, -1.f),
    C_Normal3f(-0.177597836f, 0.984103203f, 0.f),
    C_Vertex3f(0.234270573f, 0.412905216f, 0.f),
    C_Vertex3f(0.234270573f, 0.412905216f, -1.f),
    C_Normal3f(-0.0606525801f, 0.998158991f, 0.f),
    C_Vertex3f(0.256311417f, 0.415527344f, 0.f),
    C_Vertex3f(0.256311417f, 0.415527344f, -1.f),
    C_Normal3f(0.0450858548f, 0.998983085f, 0.f),
    C_Vertex3f(0.277422905f, 0.415527344f, 0.f),
    C_Vertex3f(0.277422905f, 0.415527344f, -1.f),
    C_Normal3f(0.144371927f, 0.98952353f, 0.f),
    C_Vertex3f(0.296380877f, 0.413718939f, 0.f),
    C_Vertex3f(0.296380877f, 0.413718939f, -1.f),
    C_Normal3f(0.245388389f, 0.969424844f, 0.f),
    C_Vertex3f(0.314607263f, 0.410102129f, 0.f),
    C_Vertex3f(0.314607263f, 0.410102129f, -1.f),
    C_Normal3f(0.3466084f, 0.938009977f, 0.f),
    C_Vertex3f(0.33210206f, 0.404676914f, 0.f),
    C_Vertex3f(0.33210206f, 0.404676914f, -1.f),
    C_Normal3f(0.444550753f, 0.895753682f, 0.f),
    C_Vertex3f(0.348865271f, 0.397443295f, 0.f),
    C_Vertex3f(0.348865271f, 0.397443295f, -1.f),
    C_Normal3f(0.535995424f, 0.844220877f, 0.f),
    C_Vertex3f(0.364896894f, 0.38840127f, 0.f),
    C_Vertex3f(0.364896894f, 0.38840127f, -1.f),
    C_Normal3f(0.618490994f, 0.785791874f, 0.f),
    C_Vertex3f(0.380196929f, 0.37755084f, 0.f),
    C_Vertex3f(0.380196929f, 0.37755084f, -1.f),
    C_Normal3f(0.690634489f, 0.723204017f, 0.f),
    C_Vertex3f(0.394765377f, 0.364892006f, 0.f),
    C_Vertex3f(0.394765377f, 0.364892006f, -1.f),
    C_Normal3f(0.75630343f, 0.654221058f, 0.f),
    C_Vertex3f(0.408602238f, 0.350424767f, 0.f),
    C_Vertex3f(0.408602238f, 0.350424767f, -1.f),
    C_Normal3f(0.819121063f, 0.573620737f, 0.f),
    C_Vertex3f(0.420709491f, 0.334899664f, 0.f),
    C_Vertex3f(0.420709491f, 0.334899664f, -1.f),
    C_Normal3f(0.874022186f, 0.485886186f, 0.f),
    C_Vertex3f(0.431087136f, 0.318316698f, 0.f),
    C_Vertex3f(0.431087136f, 0.318316698f, -1.f),
    C_Normal3f(0.919214725f, 0.393756598f, 0.f),
    C_Vertex3f(0.439735174f, 0.300675869f, 0.f),
    C_Vertex3f(0.439735174f, 0.300675869f, -1.f),
    C_Normal3f(0.953842402f, 0.30030781f, 0.f),
    C_Vertex3f(0.446653605f, 0.281977177f, 0.f),
    C_Vertex3f(0.446653605f, 0.281977177f, -1.f),
    C_Normal3f(0.978027701f, 0.208474681f, 0.f),
    C_Vertex3f(0.451842427f, 0.262220621f, 0.f),
    C_Vertex3f(0.451842427f, 0.262220621f, -1.f),
    C_Normal3f(0.992692947f, 0.120667741f, 0.f),
    C_Vertex3f(0.455301642f, 0.241406202f, 0.f),
    C_Vertex3f(0.455301642f, 0.241406202f, -1.f),
    C_Normal3f(0.99936229f, 0.0357089154f, 0.f),
    C_Vertex3f(0.45703125f, 0.21953392f, 0.f),
    C_Vertex3f(0.45703125f, 0.21953392f, -1.f),
    C_Normal3f(0.998293638f, -0.0583938099f, 0.f),
    C_Vertex3f(0.45703125f, 0.193000793f, 0.f),
    C_Vertex3f(0.45703125f, 0.193000793f, -1.f),
    C_Normal3f(0.985700607f, -0.168506458f, 0.f),
    C_Vertex3f(0.453778744f, 0.163929462f, 0.f),
    C_Vertex3f(0.453778744f, 0.163929462f, -1.f),
    C_Normal3f(0.958885789f, -0.283792257f, 0.f),
    C_Vertex3f(0.447273731f, 0.135922909f, 0.f),
    C_Vertex3f(0.447273731f, 0.135922909f, -1.f),
    C_Normal3f(0.918318868f, -0.395841539f, 0.f),
    C_Vertex3f(0.437516212f, 0.108981133f, 0.f),
    C_Vertex3f(0.437516212f, 0.108981133f, -1.f),
    C_Normal3f(0.863543987f, -0.504273474f, 0.f),
    C_Vertex3f(0.424506187f, 0.0831041336f, 0.f),
    C_Vertex3f(0.424506187f, 0.0831041336f, -1.f),
    C_Normal3f(0.788142145f, -0.615493238f, 0.f),
    C_Vertex3f(0.409063339f, 0.060256958f, 0.f),
    C_Vertex3f(0.409063339f, 0.060256958f, -1.f),
    C_Normal3f(0.692020893f, -0.721877515f, 0.f),
    C_Vertex3f(0.391187668f, 0.0404396057f, 0.f),
    C_Vertex3f(0.391187668f, 0.0404396057f, -1.f),
    C_Normal3f(0.578668356f, -0.815563023f, 0.f),
    C_Vertex3f(0.370879173f, 0.0236520767f, 0.f),
    C_Vertex3f(0.370879173f, 0.0236520767f, -1.f),
    C_Normal3f(0.455812365f, -0.890075862f, 0.f),
    C_Vertex3f(0.348137856f, 0.00989437103f, 0.f),
    C_Vertex3f(0.348137856f, 0.00989437103f, -1.f),
    C_Normal3f(0.324801117f, -0.945782244f, 0.f),
    C_Vertex3f(0.323865414f, -0.000423908234f, 0.f),
    C_Vertex3f(0.323865414f, -0.000423908234f, -1.f),
    C_Normal3f(0.190617591f, -0.98166436f, 0.f),
    C_Vertex3f(0.298061848f, -0.00730276108f, 0.f),
    C_Vertex3f(0.298061848f, -0.00730276108f, -1.f),
    C_Normal3f(0.0634856671f, -0.99798274f, 0.f),
    C_Vertex3f(0.270727158f, -0.0107421875f, 0.f),
    C_Vertex3f(0.270727158f, -0.0107421875f, -1.f),
    C_Normal3f(-0.0449524485f, -0.998989165f, 0.f),
    C_Vertex3f(0.243994713f, -0.0107421875f, 0.f),
    C_Vertex3f(0.243994713f, -0.0107421875f, -1.f),
    C_Normal3f(-0.146375075f, -0.989229143f, 0.f),
    C_Vertex3f(0.220529795f, -0.00848340988f, 0.f),
    C_Vertex3f(0.220529795f, -0.00848340988f, -1.f),
    C_Normal3f(-0.251150012f, -0.967948139f, 0.f),
    C_Vertex3f(0.198199034f, -0.00396585464f, 0.f),
    C_Vertex3f(0.198199034f, -0.00396585464f, -1.f),
    C_Normal3f(-0.357846707f, -0.933780313f, 0.f),
    C_Vertex3f(0.17700243f, 0.00281047821f, 0.f),
    C_Vertex3f(0.17700243f, 0.00281047821f, -1.f),
    C_Normal3f(-0.462315828f, -0.886715293f, 0.f),
    C_Vertex3f(0.156939983f, 0.0118455887f, 0.f),
    C_Vertex3f(0.156939983f, 0.0118455887f, -1.f),
    C_Normal3f(-0.560385466f, -0.82823199f, 0.f),
    C_Vertex3f(0.138011694f, 0.0231394768f, 0.f),
    C_Vertex3f(0.138011694f, 0.0231394768f, -1.f),
    C_Normal3f(-0.648649633f, -0.76108712f, 0.f),
    C_Vertex3f(0.120217562f, 0.0366921425f, 0.f),
    C_Vertex3f(0.120217562f, 0.0366921425f, -1.f),
    C_Normal3f(-0.725018561f, -0.688729346f, 0.f),
    C_Vertex3f(0.103557587f, 0.0525035858f, 0.f),
    C_Vertex3f(0.103557587f, 0.0525035858f, -1.f),
    C_Normal3f(-0.801868737f, -0.597500145f, 0.f),
    C_Vertex3f(0.0880317688f, 0.0705738068f, 0.f),
    C_Vertex3f(0.0880317688f, 0.0705738068f, -1.f),
    C_Normal3f(-0.871905208f, -0.489674777f, 0.f),
    C_Vertex3f(0.0744466782f, 0.0915715694f, 0.f),
    C_Vertex3f(0.0744466782f, 0.0915715694f, -1.f),
    C_Normal3f(-0.92184484f, -0.387559265f, 0.f),
    C_Vertex3f(0.0628023148f, 0.115496874f, 0.f),
    C_Vertex3f(0.0628023148f, 0.115496874f, -1.f),
    C_Normal3f(-0.955584586f, -0.294716746f, 0.f),
    C_Vertex3f(0.0530986786f, 0.14234972f, 0.f),
    C_Vertex3f(0.0530986786f, 0.14234972f, -1.f),
    C_Normal3f(-0.977174163f, -0.212439701f, 0.f),
    C_Vertex3f(0.0453357697f, 0.172130108f, 0.f),
    C_Vertex3f(0.0453357697f, 0.172130108f, -1.f),
    C_Normal3f(-0.990070283f, -0.140573651f, 0.f),
    C_Vertex3f(0.039513588f, 0.204838037f, 0.f),
    C_Vertex3f(0.039513588f, 0.204838037f, -1.f),
    C_Normal3f(-0.996935546f, -0.0782272071f, 0.f),
    C_Vertex3f(0.0356321335f, 0.240473509f, 0.f),
    C_Vertex3f(0.0356321335f, 0.240473509f, -1.f),
    C_Normal3f(-0.999723494f, -0.0235142726f, 0.f),
    C_Vertex3f(0.0336914063f, 0.279036522f, 0.f),
    C_Vertex3f(0.0336914063f, 0.279036522f, -1.f),
    C_Normal3f(-0.999697089f, 0.0246117562f, 0.f),
    C_Vertex3f(0.0336914063f, 0.322984695f, 0.f),
    C_Vertex3f(0.0336914063f, 0.322984695f, -1.f),
    C_Normal3f(-0.997026205f, 0.0770637095f, 0.f),
    C_Vertex3f(0.0358378887f, 0.366223812f, 0.f),
    C_Vertex3f(0.0358378887f, 0.366223812f, -1.f),
    C_Normal3f(-0.990420341f, 0.138085827f, 0.f),
    C_Vertex3f(0.0401308537f, 0.406296253f, 0.f),
    C_Vertex3f(0.0401308537f, 0.406296253f, -1.f),
    C_Normal3f(-0.978121221f, 0.208035544f, 0.f),
    C_Vertex3f(0.0465703011f, 0.443202019f, 0.f),
    C_Vertex3f(0.0465703011f, 0.443202019f, -1.f),
    C_Normal3f(-0.957724154f, 0.287687927f, 0.f),
    C_Vertex3f(0.0551562309f, 0.476941109f, 0.f),
    C_Vertex3f(0.0551562309f, 0.476941109f, -1.f),
    C_Normal3f(-0.926144958f, 0.377167821f, 0.f),
    C_Vertex3f(0.0658886433f, 0.507513523f, 0.f),
    C_Vertex3f(0.0658886433f, 0.507513523f, -1.f),
    C_Normal3f(-0.879790843f, 0.47536099f, 0.f),
    C_Vertex3f(0.0787675381f, 0.534919262f, 0.f),
    C_Vertex3f(0.0787675381f, 0.534919262f, -1.f),
    C_Normal3f(-0.816256821f, 0.57768923f, 0.f),
    C_Vertex3f(0.0937929153f, 0.559158325f, 0.f),
    C_Vertex3f(0.0937929153f, 0.559158325f, -1.f),
    C_Normal3f(-0.741472483f, 0.670983195f, 0.f),
    C_Vertex3f(0.109869957f, 0.578866005f, 0.f),
    C_Vertex3f(0.109869957f, 0.578866005f, -1.f),
    C_Normal3f(-0.660738766f, 0.750615895f, 0.f),
    C_Vertex3f(0.126151323f, 0.594916105f, 0.f),
    C_Vertex3f(0.126151323f, 0.594916105f, -1.f),
    C_Normal3f(-0.568903983f, 0.822403967f, 0.f),
    C_Vertex3f(0.143731833f, 0.608673334f, 0.f),
    C_Vertex3f(0.143731833f, 0.608673334f, -1.f),
    C_Normal3f(-0.467142135f, 0.884182274f, 0.f),
    C_Vertex3f(0.162611485f, 0.620137691f, 0.f),
    C_Vertex3f(0.162611485f, 0.620137691f, -1.f),
    C_Normal3f(-0.359530866f, 0.933133185f, 0.f),
    C_Vertex3f(0.182790279f, 0.629309177f, 0.f),
    C_Vertex3f(0.182790279f, 0.629309177f, -1.f),
    C_Normal3f(-0.250774264f, 0.968045533f, 0.f),
    C_Vertex3f(0.204268217f, 0.636187792f, 0.f),
    C_Vertex3f(0.204268217f, 0.636187792f, -1.f),
    C_Normal3f(-0.145254686f, 0.989394248f, 0.f),
    C_Vertex3f(0.227045298f, 0.640773535f, 0.f),
    C_Vertex3f(0.227045298f, 0.640773535f, -1.f),
    C_Normal3f(-0.0495421886f, 0.998771966f, 0.f),
    C_Vertex3f(0.251121521f, 0.643066406f, 0.f),
    C_Vertex3f(0.251121521f, 0.643066406f, -1.f),
    C_Normal3f(0.0329543687f, 0.999456882f, 0.f),
    C_Vertex3f(0.273269653f, 0.643066406f, 0.f),
    C_Vertex3f(0.273269653f, 0.643066406f, -1.f),
    C_Normal3f(0.112047449f, 0.993702948f, 0.f),
    C_Vertex3f(0.29133606f, 0.641740441f, 0.f),
    C_Vertex3f(0.29133606f, 0.641740441f, -1.f),
    C_Normal3f(0.193753928f, 0.981050134f, 0.f),
    C_Vertex3f(0.308547974f, 0.639088511f, 0.f),
    C_Vertex3f(0.308547974f, 0.639088511f, -1.f),
    C_Normal3f(0.27969873f, 0.960087836f, 0.f),
    C_Vertex3f(0.324905396f, 0.635110617f, 0.f),
    C_Vertex3f(0.324905396f, 0.635110617f, -1.f),
    C_Normal3f(0.368015617f, 0.929819643f, 0.f),
    C_Vertex3f(0.340408325f, 0.629806757f, 0.f),
    C_Vertex3f(0.340408325f, 0.629806757f, -1.f),
    C_Normal3f(0.456311136f, 0.889820337f, 0.f),
    C_Vertex3f(0.355056763f, 0.623176932f, 0.f),
    C_Vertex3f(0.355056763f, 0.623176932f, -1.f),
    C_Normal3f(0.541909158f, 0.840437174f, 0.f),
    C_Vertex3f(0.368850708f, 0.615221143f, 0.f),
    C_Vertex3f(0.368850708f, 0.615221143f, -1.f),
    C_Normal3f(0.622211039f, 0.78284961f, 0.f),
    C_Vertex3f(0.381790161f, 0.605939388f, 0.f),
    C_Vertex3f(0.381790161f, 0.605939388f, -1.f),
    C_Normal3f(0.695544779f, 0.718482792f, 0.f),
    C_Vertex3f(0.393875122f, 0.595331669f, 0.f),
    C_Vertex3f(0.393875122f, 0.595331669f, -1.f),
    C_Normal3f(0.763061047f, 0.646326363f, 0.f),
    C_Vertex3f(0.404750347f, 0.58371222f, 0.f),
    C_Vertex3f(0.404750347f, 0.58371222f, -1.f),
    C_Normal3f(0.823195517f, 0.567758143f, 0.f),
    C_Vertex3f(0.414415836f, 0.571081042f, 0.f),
    C_Vertex3f(0.414415836f, 0.571081042f, -1.f),
    C_Normal3f(0.87440753f, 0.48519218f, 0.f),
    C_Vertex3f(0.42287159f, 0.557438135f, 0.f),
    C_Vertex3f(0.42287159f, 0.557438135f, -1.f),
    C_Normal3f(0.915970147f, 0.401246279f, 0.f),
    C_Vertex3f(0.430117607f, 0.542783499f, 0.f),
    C_Vertex3f(0.430117607f, 0.542783499f, -1.f),
    C_Normal3f(0.947965741f, 0.318372548f, 0.f),
    C_Vertex3f(0.436153889f, 0.527117133f, 0.f),
    C_Vertex3f(0.436153889f, 0.527117133f, -1.f),
    C_Normal3f(0.971122622f, 0.238581032f, 0.f),
    C_Vertex3f(0.440980434f, 0.510439038f, 0.f),
    C_Vertex3f(0.440980434f, 0.510439038f, -1.f),
    C_Normal3f(0.984480083f, 0.175496668f, 0.f),
    C_Vertex3f(0.444597244f, 0.492749214f, 0.f),
    C_Vertex3f(0.444597244f, 0.492749214f, -1.f),
    C_Normal3f(0.991818309f, 0.127656788f, 0.f),
    C_Vertex3f(0.445800781f, 0.483398438f, 0.f),
    C_Vertex3f(0.445800781f, 0.483398438f, -1.f),
    C_End(),
    C_Begin(GL_QUAD_STRIP),
    C_Normal3f(0.999371469f, -0.0354490392f, 0.f),
    C_Vertex3f(0.124023438f, 0.215363503f, 0.f),
    C_Vertex3f(0.124023438f, 0.215363503f, -1.f),
    C_Normal3f(0.998379052f, 0.0569146313f, 0.f),
    C_Vertex3f(0.124023438f, 0.197439194f, 0.f),
    C_Vertex3f(0.124023438f, 0.197439194f, -1.f),
    C_Normal3f(0.986759245f, 0.162191764f, 0.f),
    C_Vertex3f(0.126179218f, 0.177547455f, 0.f),
    C_Vertex3f(0.126179218f, 0.177547455f, -1.f),
    C_Normal3f(0.962922275f, 0.269779116f, 0.f),
    C_Vertex3f(0.13049078f, 0.158092499f, 0.f),
    C_Vertex3f(0.13049078f, 0.158092499f, -1.f),
    C_Normal3f(0.928045034f, 0.372467935f, 0.f),
    C_Vertex3f(0.136958122f, 0.139074326f, 0.f),
    C_Vertex3f(0.136958122f, 0.139074326f, -1.f),
    C_Normal3f(0.879080474f, 0.476673335f, 0.f),
    C_Vertex3f(0.145581245f, 0.120492935f, 0.f),
    C_Vertex3f(0.145581245f, 0.120492935f, -1.f),
    C_Normal3f(0.806691349f, 0.59097296f, 0.f),
    C_Vertex3f(0.155909061f, 0.104125023f, 0.f),
    C_Vertex3f(0.155909061f, 0.104125023f, -1.f),
    C_Normal3f(0.71153295f, 0.702652752f, 0.f),
    C_Vertex3f(0.16794157f, 0.0899705887f, 0.f),
    C_Vertex3f(0.16794157f, 0.0899705887f, -1.f),
    C_Normal3f(0.596191645f, 0.80284214f, 0.f),
    C_Vertex3f(0.181678772f, 0.0780296326f, 0.f),
    C_Vertex3f(0.181678772f, 0.0780296326f, -1.f),
    C_Normal3f(0.47764802f, 0.878551245f, 0.f),
    C_Vertex3f(0.197120667f, 0.0683021545f, 0.f),
    C_Vertex3f(0.197120667f, 0.0683021545f, -1.f),
    C_Normal3f(0.35360226f, 0.935395837f, 0.f),
    C_Vertex3f(0.212989807f, 0.061006546f, 0.f),
    C_Vertex3f(0.212989807f, 0.061006546f, -1.f),
    C_Normal3f(0.215741843f, 0.976450384f, 0.f),
    C_Vertex3f(0.229286194f, 0.056142807f, 0.f),
    C_Vertex3f(0.229286194f, 0.056142807f, -1.f),
    C_Normal3f(0.0768462867f, 0.997042954f, 0.f),
    C_Vertex3f(0.246009827f, 0.0537109375f, 0.f),
    C_Vertex3f(0.246009827f, 0.0537109375f, -1.f),
    C_Normal3f(-0.0466981903f, 0.998909056f, 0.f),
    C_Vertex3f(0.260838509f, 0.0537109375f, 0.f),
    C_Vertex3f(0.260838509f, 0.0537109375f, -1.f),
    C_Normal3f(-0.15733555f, 0.987545133f, 0.f),
    C_Vertex3f(0.272896767f, 0.0549678802f, 0.f),
    C_Vertex3f(0.272896767f, 0.0549678802f, -1.f),
    C_Normal3f(-0.266040236f, 0.963961899f, 0.f),
    C_Vertex3f(0.284506798f, 0.0574817657f, 0.f),
    C_Vertex3f(0.284506798f, 0.0574817657f, -1.f),
    C_Normal3f(-0.373161316f, 0.927766562f, 0.f),
    C_Vertex3f(0.295668602f, 0.061252594f, 0.f),
    C_Vertex3f(0.295668602f, 0.061252594f, -1.f),
    C_Normal3f(-0.474624634f, 0.880188227f, 0.f),
    C_Vertex3f(0.306382179f, 0.066280365f, 0.f),
    C_Vertex3f(0.306382179f, 0.066280365f, -1.f),
    C_Normal3f(-0.567076504f, 0.823665082f, 0.f),
    C_Vertex3f(0.31664753f, 0.0725650787f, 0.f),
    C_Vertex3f(0.31664753f, 0.0725650787f, -1.f),
    C_Normal3f(-0.648388445f, 0.761309624f, 0.f),
    C_Vertex3f(0.326464653f, 0.0801067352f, 0.f),
    C_Vertex3f(0.326464653f, 0.0801067352f, -1.f),
    C_Normal3f(-0.717771709f, 0.696278453f, 0.f),
    C_Vertex3f(0.335833549f, 0.0889053345f, 0.f),
    C_Vertex3f(0.335833549f, 0.0889053345f, -1.f),
    C_Normal3f(-0.782391667f, 0.62278676f, 0.f),
    C_Vertex3f(0.344754219f, 0.0989608765f, 0.f),
    C_Vertex3f(0.344754219f, 0.0989608765f, -1.f),
    C_Normal3f(-0.844051719f, 0.536261857f, 0.f),
    C_Vertex3f(0.352559805f, 0.109918118f, 0.f),
    C_Vertex3f(0.352559805f, 0.109918118f, -1.f),
    C_Normal3f(-0.895064235f, 0.445937216f, 0.f),
    C_Vertex3f(0.359250307f, 0.121777058f, 0.f),
    C_Vertex3f(0.359250307f, 0.121777058f, -1.f),
    C_Normal3f(-0.93484205f, 0.355063856f, 0.f),
    C_Vertex3f(0.364825726f, 0.134537697f, 0.f),
    C_Vertex3f(0.364825726f, 0.134537697f, -1.f),
    C_Normal3f(-0.96382612f, 0.266531825f, 0.f),
    C_Vertex3f(0.36928606f, 0.148200035f, 0.f),
    C_Vertex3f(0.36928606f, 0.148200035f, -1.f),
    C_Normal3f(-0.983197868f, 0.182543486f, 0.f),
    C_Vertex3f(0.372631311f, 0.162764072f, 0.f),
    C_Vertex3f(0.372631311f, 0.162764072f, -1.f),
    C_Normal3f(-0.994523644f, 0.104511462f, 0.f),
    C_Vertex3f(0.374861479f, 0.178229809f, 0.f),
    C_Vertex3f(0.374861479f, 0.178229809f, -1.f),
    C_Normal3f(-0.999440134f, 0.0334587023f, 0.f),
    C_Vertex3f(0.375976563f, 0.194597244f, 0.f),
    C_Vertex3f(0.375976563f, 0.194597244f, -1.f),
    C_Normal3f(-0.999432206f, -0.0336936414f, 0.f),
    C_Vertex3f(0.375976563f, 0.211538315f, 0.f),
    C_Vertex3f(0.375976563f, 0.211538315f, -1.f),
    C_Normal3f(-0.994213104f, -0.107426353f, 0.f),
    C_Vertex3f(0.374875069f, 0.227270126f, 0.f),
    C_Vertex3f(0.374875069f, 0.227270126f, -1.f),
    C_Normal3f(-0.982225955f, -0.187702015f, 0.f),
    C_Vertex3f(0.372672081f, 0.242120743f, 0.f),
    C_Vertex3f(0.372672081f, 0.242120743f, -1.f),
    C_Normal3f(-0.961714268f, -0.274053991f, 0.f),
    C_Vertex3f(0.369367599f, 0.256090164f, 0.f),
    C_Vertex3f(0.369367599f, 0.256090164f, -1.f),
    C_Normal3f(-0.931051493f, -0.364887655f, 0.f),
    C_Vertex3f(0.364961624f, 0.269178391f, 0.f),
    C_Vertex3f(0.364961624f, 0.269178391f, -1.f),
    C_Normal3f(-0.889075398f, -0.457760692f, 0.f),
    C_Vertex3f(0.359454155f, 0.281385422f, 0.f),
    C_Vertex3f(0.359454155f, 0.281385422f, -1.f),
    C_Normal3f(-0.83547461f, -0.549529135f, 0.f),
    C_Vertex3f(0.352845192f, 0.292711258f, 0.f),
    C_Vertex3f(0.352845192f, 0.292711258f, -1.f),
    C_Normal3f(-0.771075428f, -0.636743665f, 0.f),
    C_Vertex3f(0.345134735f, 0.303155899f, 0.f),
    C_Vertex3f(0.345134735f, 0.303155899f, -1.f),
    C_Normal3f(-0.70166564f, -0.712506413f, 0.f),
    C_Vertex3f(0.336322784f, 0.312719345f, 0.f),
    C_Vertex3f(0.336322784f, 0.312719345f, -1.f),
    C_Normal3f(-0.625638008f, -0.780113459f, 0.f),
    C_Vertex3f(0.326926231f, 0.32108736f, 0.f),
    C_Vertex3f(0.326926231f, 0.32108736f, -1.f),
    C_Normal3f(-0.539045393f, -0.842276692f, 0.f),
    C_Vertex3f(0.316945076f, 0.328259945f, 0.f),
    C_Vertex3f(0.316945076f, 0.328259945f, -1.f),
    C_Normal3f(-0.443936616f, -0.896058202f, 0.f),
    C_Vertex3f(0.306379318f, 0.334237099f, 0.f),
    C_Vertex3f(0.306379318f, 0.334237099f, -1.f),
    C_Normal3f(-0.343412727f, -0.939184606f, 0.f),
    C_Vertex3f(0.295228958f, 0.339018822f, 0.f),
    C_Vertex3f(0.295228958f, 0.339018822f, -1.f),
    C_Normal3f(-0.241150215f, -0.970487714f, 0.f),
    C_Vertex3f(0.283493996f, 0.342605114f, 0.f),
    C_Vertex3f(0.283493996f, 0.342605114f, -1.f),
    C_Normal3f(-0.14076364f, -0.990043223f, 0.f),
    C_Vertex3f(0.271174431f, 0.344995975f, 0.f),
    C_Vertex3f(0.271174431f, 0.344995975f, -1.f),
    C_Normal3f(-0.0453945212f, -0.998969138f, 0.f),
    C_Vertex3f(0.258270264f, 0.346191406f, 0.f),
    C_Vertex3f(0.258270264f, 0.346191406f, -1.f),
    C_Normal3f(0.0455531366f, -0.998961985f, 0.f),
    C_Vertex3f(0.244867325f, 0.346191406f, 0.f),
    C_Vertex3f(0.244867325f, 0.346191406f, -1.f),
    C_Normal3f(0.141333222f, -0.989962041f, 0.f),
    C_Vertex3f(0.232054949f, 0.344995975f, 0.f),
    C_Vertex3f(0.232054949f, 0.344995975f, -1.f),
    C_Normal3f(0.240622327f, -0.970618844f, 0.f),
    C_Vertex3f(0.219747305f, 0.342605114f, 0.f),
    C_Vertex3f(0.219747305f, 0.342605114f, -1.f),
    C_Normal3f(0.340578765f, -0.940215945f, 0.f),
    C_Vertex3f(0.207944393f, 0.339018822f, 0.f),
    C_Vertex3f(0.207944393f, 0.339018822f, -1.f),
    C_Normal3f(0.437847376f, -0.899049342f, 0.f),
    C_Vertex3f(0.196646214f, 0.334237099f, 0.f),
    C_Vertex3f(0.196646214f, 0.334237099f, -1.f),
    C_Normal3f(0.529228508f, -0.84847939f, 0.f),
    C_Vertex3f(0.185852766f, 0.328259945f, 0.f),
    C_Vertex3f(0.185852766f, 0.328259945f, -1.f),
    C_Normal3f(0.612184167f, -0.790715218f, 0.f),
    C_Vertex3f(0.175564051f, 0.32108736f, 0.f),
    C_Vertex3f(0.175564051f, 0.32108736f, -1.f),
    C_Normal3f(0.685153782f, -0.728398383f, 0.f),
    C_Vertex3f(0.165780067f, 0.312719345f, 0.f),
    C_Vertex3f(0.165780067f, 0.312719345f, -1.f),
    C_Normal3f(0.752369165f, -0.658741653f, 0.f),
    C_Vertex3f(0.156500816f, 0.303155899f, 0.f),
    C_Vertex3f(0.156500816f, 0.303155899f, -1.f),
    C_Normal3f(0.816955507f, -0.576700747f, 0.f),
    C_Vertex3f(0.148381472f, 0.292847872f, 0.f),
    C_Vertex3f(0.148381472f, 0.292847872f, -1.f),
    C_Normal3f(0.873106718f, -0.487529159f, 0.f),
    C_Vertex3f(0.141422033f, 0.281795263f, 0.f),
    C_Vertex3f(0.141422033f, 0.281795263f, -1.f),
    C_Normal3f(0.919033289f, -0.394180059f, 0.f),
    C_Vertex3f(0.135622501f, 0.269998074f, 0.f),
    C_Vertex3f(0.135622501f, 0.269998074f, -1.f),
    C_Normal3f(0.953973293f, -0.299891621f, 0.f),
    C_Vertex3f(0.130982876f, 0.257456303f, 0.f),
    C_Vertex3f(0.130982876f, 0.257456303f, -1.f),
    C_Normal3f(0.978198051f, -0.207674041f, 0.f),
    C_Vertex3f(0.127503157f, 0.24416995f, 0.f),
    C_Vertex3f(0.127503157f, 0.24416995f, -1.f),
    C_Normal3f(0.99278301f, -0.119924754f, 0.f),
    C_Vertex3f(0.125183344f, 0.230139017f, 0.f),
    C_Vertex3f(0.125183344f, 0.230139017f, -1.f),
    C_Normal3f(0.999371469f, -0.0354490392f, 0.f),
    C_Vertex3f(0.124023438f, 0.215363503f, 0.f),
    C_Vertex3f(0.124023438f, 0.215363503f, -1.f),
    C_End(),
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.380196929f, 0.37755084f, 0.f),
    C_Vertex3f(0.364896894f, 0.38840127f, 0.f),
    C_Vertex3f(0.364961624f, 0.269178391f, 0.f),
    C_Vertex3f(0.369367599f, 0.256090164f, 0.f),
    C_Vertex3f(0.372672081f, 0.242120743f, 0.f),
    C_Vertex3f(0.374875069f, 0.227270126f, 0.f),
    C_Vertex3f(0.375976563f, 0.211538315f, 0.f),
    C_Vertex3f(0.391187668f, 0.0404396057f, 0.f),
    C_Vertex3f(0.394765377f, 0.364892006f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.336322784f, 0.312719345f, 0.f),
    C_Vertex3f(0.345134735f, 0.303155899f, 0.f),
    C_Vertex3f(0.348865271f, 0.397443295f, 0.f),
    C_Vertex3f(0.352845192f, 0.292711258f, 0.f),
    C_Vertex3f(0.364896894f, 0.38840127f, 0.f),
    C_Vertex3f(0.359454155f, 0.281385422f, 0.f),
    C_Vertex3f(0.364961624f, 0.269178391f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.33210206f, 0.404676914f, 0.f),
    C_Vertex3f(0.314607263f, 0.410102129f, 0.f),
    C_Vertex3f(0.316945076f, 0.328259945f, 0.f),
    C_Vertex3f(0.326926231f, 0.32108736f, 0.f),
    C_Vertex3f(0.336322784f, 0.312719345f, 0.f),
    C_Vertex3f(0.348865271f, 0.397443295f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.283493996f, 0.342605114f, 0.f),
    C_Vertex3f(0.295228958f, 0.339018822f, 0.f),
    C_Vertex3f(0.296380877f, 0.413718939f, 0.f),
    C_Vertex3f(0.306379318f, 0.334237099f, 0.f),
    C_Vertex3f(0.314607263f, 0.410102129f, 0.f),
    C_Vertex3f(0.316945076f, 0.328259945f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.277422905f, 0.415527344f, 0.f),
    C_Vertex3f(0.256311417f, 0.415527344f, 0.f),
    C_Vertex3f(0.258270264f, 0.346191406f, 0.f),
    C_Vertex3f(0.271174431f, 0.344995975f, 0.f),
    C_Vertex3f(0.283493996f, 0.342605114f, 0.f),
    C_Vertex3f(0.296380877f, 0.413718939f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.219747305f, 0.342605114f, 0.f),
    C_Vertex3f(0.232054949f, 0.344995975f, 0.f),
    C_Vertex3f(0.234270573f, 0.412905216f, 0.f),
    C_Vertex3f(0.244867325f, 0.346191406f, 0.f),
    C_Vertex3f(0.256311417f, 0.415527344f, 0.f),
    C_Vertex3f(0.258270264f, 0.346191406f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.212722301f, 0.407660961f, 0.f),
    C_Vertex3f(0.191666603f, 0.399794579f, 0.f),
    C_Vertex3f(0.196646214f, 0.334237099f, 0.f),
    C_Vertex3f(0.207944393f, 0.339018822f, 0.f),
    C_Vertex3f(0.219747305f, 0.342605114f, 0.f),
    C_Vertex3f(0.234270573f, 0.412905216f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.156500816f, 0.303155899f, 0.f),
    C_Vertex3f(0.165780067f, 0.312719345f, 0.f),
    C_Vertex3f(0.171103477f, 0.389306068f, 0.f),
    C_Vertex3f(0.175564051f, 0.32108736f, 0.f),
    C_Vertex3f(0.191666603f, 0.399794579f, 0.f),
    C_Vertex3f(0.185852766f, 0.328259945f, 0.f),
    C_Vertex3f(0.196646214f, 0.334237099f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.152125835f, 0.376032352f, 0.f),
    C_Vertex3f(0.134733677f, 0.359973431f, 0.f),
    C_Vertex3f(0.135622501f, 0.269998074f, 0.f),
    C_Vertex3f(0.141422033f, 0.281795263f, 0.f),
    C_Vertex3f(0.148381472f, 0.292847872f, 0.f),
    C_Vertex3f(0.156500816f, 0.303155899f, 0.f),
    C_Vertex3f(0.171103477f, 0.389306068f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.134733677f, 0.359973431f, 0.f),
    C_Vertex3f(0.118927002f, 0.341129303f, 0.f),
    C_Vertex3f(0.124023438f, 0.215363503f, 0.f),
    C_Vertex3f(0.125183344f, 0.230139017f, 0.f),
    C_Vertex3f(0.127503157f, 0.24416995f, 0.f),
    C_Vertex3f(0.130982876f, 0.257456303f, 0.f),
    C_Vertex3f(0.135622501f, 0.269998074f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.120217562f, 0.0366921425f, 0.f),
    C_Vertex3f(0.138011694f, 0.0231394768f, 0.f),
    C_Vertex3f(0.124023438f, 0.197439194f, 0.f),
    C_Vertex3f(0.124023438f, 0.215363503f, 0.f),
    C_Vertex3f(0.118927002f, 0.341129303f, 0.f),
    C_Vertex3f(0.111816406f, 0.330314636f, 0.f),
    C_Vertex3f(0.103557587f, 0.0525035858f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.111816406f, 0.330314636f, 0.f),
    C_Vertex3f(0.109869957f, 0.578866005f, 0.f),
    C_Vertex3f(0.103557587f, 0.0525035858f, 0.f),
    C_Vertex3f(0.0937929153f, 0.559158325f, 0.f),
    C_Vertex3f(0.0880317688f, 0.0705738068f, 0.f),
    C_Vertex3f(0.0787675381f, 0.534919262f, 0.f),
    C_Vertex3f(0.0744466782f, 0.0915715694f, 0.f),
    C_Vertex3f(0.0658886433f, 0.507513523f, 0.f),
    C_Vertex3f(0.0628023148f, 0.115496874f, 0.f),
    C_Vertex3f(0.0551562309f, 0.476941109f, 0.f),
    C_Vertex3f(0.0530986786f, 0.14234972f, 0.f),
    C_Vertex3f(0.0465703011f, 0.443202019f, 0.f),
    C_Vertex3f(0.0453357697f, 0.172130108f, 0.f),
    C_Vertex3f(0.0401308537f, 0.406296253f, 0.f),
    C_Vertex3f(0.039513588f, 0.204838037f, 0.f),
    C_Vertex3f(0.0358378887f, 0.366223812f, 0.f),
    C_Vertex3f(0.0356321335f, 0.240473509f, 0.f),
    C_Vertex3f(0.0336914063f, 0.322984695f, 0.f),
    C_Vertex3f(0.0336914063f, 0.279036522f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.446653605f, 0.281977177f, 0.f),
    C_Vertex3f(0.447273731f, 0.135922909f, 0.f),
    C_Vertex3f(0.451842427f, 0.262220621f, 0.f),
    C_Vertex3f(0.453778744f, 0.163929462f, 0.f),
    C_Vertex3f(0.455301642f, 0.241406202f, 0.f),
    C_Vertex3f(0.45703125f, 0.193000793f, 0.f),
    C_Vertex3f(0.45703125f, 0.21953392f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.408602238f, 0.350424767f, 0.f),
    C_Vertex3f(0.409063339f, 0.060256958f, 0.f),
    C_Vertex3f(0.420709491f, 0.334899664f, 0.f),
    C_Vertex3f(0.424506187f, 0.0831041336f, 0.f),
    C_Vertex3f(0.431087136f, 0.318316698f, 0.f),
    C_Vertex3f(0.437516212f, 0.108981133f, 0.f),
    C_Vertex3f(0.439735174f, 0.300675869f, 0.f),
    C_Vertex3f(0.447273731f, 0.135922909f, 0.f),
    C_Vertex3f(0.446653605f, 0.281977177f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.394765377f, 0.364892006f, 0.f),
    C_Vertex3f(0.391187668f, 0.0404396057f, 0.f),
    C_Vertex3f(0.409063339f, 0.060256958f, 0.f),
    C_Vertex3f(0.408602238f, 0.350424767f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.391187668f, 0.0404396057f, 0.f),
    C_Vertex3f(0.375976563f, 0.211538315f, 0.f),
    C_Vertex3f(0.375976563f, 0.194597244f, 0.f),
    C_Vertex3f(0.374861479f, 0.178229809f, 0.f),
    C_Vertex3f(0.372631311f, 0.162764072f, 0.f),
    C_Vertex3f(0.370879173f, 0.0236520767f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.370879173f, 0.0236520767f, 0.f),
    C_Vertex3f(0.372631311f, 0.162764072f, 0.f),
    C_Vertex3f(0.36928606f, 0.148200035f, 0.f),
    C_Vertex3f(0.364825726f, 0.134537697f, 0.f),
    C_Vertex3f(0.359250307f, 0.121777058f, 0.f),
    C_Vertex3f(0.352559805f, 0.109918118f, 0.f),
    C_Vertex3f(0.348137856f, 0.00989437103f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.348137856f, 0.00989437103f, 0.f),
    C_Vertex3f(0.352559805f, 0.109918118f, 0.f),
    C_Vertex3f(0.344754219f, 0.0989608765f, 0.f),
    C_Vertex3f(0.335833549f, 0.0889053345f, 0.f),
    C_Vertex3f(0.326464653f, 0.0801067352f, 0.f),
    C_Vertex3f(0.323865414f, -0.000423908234f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.326464653f, 0.0801067352f, 0.f),
    C_Vertex3f(0.31664753f, 0.0725650787f, 0.f),
    C_Vertex3f(0.323865414f, -0.000423908234f, 0.f),
    C_Vertex3f(0.306382179f, 0.066280365f, 0.f),
    C_Vertex3f(0.298061848f, -0.00730276108f, 0.f),
    C_Vertex3f(0.295668602f, 0.061252594f, 0.f),
    C_Vertex3f(0.284506798f, 0.0574817657f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.272896767f, 0.0549678802f, 0.f),
    C_Vertex3f(0.260838509f, 0.0537109375f, 0.f),
    C_Vertex3f(0.270727158f, -0.0107421875f, 0.f),
    C_Vertex3f(0.298061848f, -0.00730276108f, 0.f),
    C_Vertex3f(0.284506798f, 0.0574817657f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.197120667f, 0.0683021545f, 0.f),
    C_Vertex3f(0.198199034f, -0.00396585464f, 0.f),
    C_Vertex3f(0.212989807f, 0.061006546f, 0.f),
    C_Vertex3f(0.220529795f, -0.00848340988f, 0.f),
    C_Vertex3f(0.229286194f, 0.056142807f, 0.f),
    C_Vertex3f(0.243994713f, -0.0107421875f, 0.f),
    C_Vertex3f(0.246009827f, 0.0537109375f, 0.f),
    C_Vertex3f(0.270727158f, -0.0107421875f, 0.f),
    C_Vertex3f(0.260838509f, 0.0537109375f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.155909061f, 0.104125023f, 0.f),
    C_Vertex3f(0.156939983f, 0.0118455887f, 0.f),
    C_Vertex3f(0.16794157f, 0.0899705887f, 0.f),
    C_Vertex3f(0.17700243f, 0.00281047821f, 0.f),
    C_Vertex3f(0.181678772f, 0.0780296326f, 0.f),
    C_Vertex3f(0.198199034f, -0.00396585464f, 0.f),
    C_Vertex3f(0.197120667f, 0.0683021545f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.145581245f, 0.120492935f, 0.f),
    C_Vertex3f(0.136958122f, 0.139074326f, 0.f),
    C_Vertex3f(0.138011694f, 0.0231394768f, 0.f),
    C_Vertex3f(0.156939983f, 0.0118455887f, 0.f),
    C_Vertex3f(0.155909061f, 0.104125023f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.138011694f, 0.0231394768f, 0.f),
    C_Vertex3f(0.136958122f, 0.139074326f, 0.f),
    C_Vertex3f(0.13049078f, 0.158092499f, 0.f),
    C_Vertex3f(0.126179218f, 0.177547455f, 0.f),
    C_Vertex3f(0.124023438f, 0.197439194f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.445800781f, 0.483398438f, 0.f),
    C_Vertex3f(0.444597244f, 0.492749214f, 0.f),
    C_Vertex3f(0.440980434f, 0.510439038f, 0.f),
    C_Vertex3f(0.436153889f, 0.527117133f, 0.f),
    C_Vertex3f(0.430117607f, 0.542783499f, 0.f),
    C_Vertex3f(0.42287159f, 0.557438135f, 0.f),
    C_Vertex3f(0.414415836f, 0.571081042f, 0.f),
    C_Vertex3f(0.404750347f, 0.58371222f, 0.f),
    C_Vertex3f(0.393875122f, 0.595331669f, 0.f),
    C_Vertex3f(0.381790161f, 0.605939388f, 0.f),
    C_Vertex3f(0.368850708f, 0.615221143f, 0.f),
    C_Vertex3f(0.367675781f, 0.477050781f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.342702866f, 0.539485931f, 0.f),
    C_Vertex3f(0.351246834f, 0.525746346f, 0.f),
    C_Vertex3f(0.355056763f, 0.623176932f, 0.f),
    C_Vertex3f(0.35869503f, 0.508818626f, 0.f),
    C_Vertex3f(0.368850708f, 0.615221143f, 0.f),
    C_Vertex3f(0.365047455f, 0.488702774f, 0.f),
    C_Vertex3f(0.367675781f, 0.477050781f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.340408325f, 0.629806757f, 0.f),
    C_Vertex3f(0.324905396f, 0.635110617f, 0.f),
    C_Vertex3f(0.325424194f, 0.556398153f, 0.f),
    C_Vertex3f(0.333885193f, 0.548993111f, 0.f),
    C_Vertex3f(0.337882996f, 0.544761658f, 0.f),
    C_Vertex3f(0.342702866f, 0.539485931f, 0.f),
    C_Vertex3f(0.355056763f, 0.623176932f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.29724884f, 0.572266102f, 0.f),
    C_Vertex3f(0.307106018f, 0.568034649f, 0.f),
    C_Vertex3f(0.308547974f, 0.639088511f, 0.f),
    C_Vertex3f(0.316497803f, 0.562745333f, 0.f),
    C_Vertex3f(0.324905396f, 0.635110617f, 0.f),
    C_Vertex3f(0.325424194f, 0.556398153f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.29133606f, 0.641740441f, 0.f),
    C_Vertex3f(0.273269653f, 0.643066406f, 0.f),
    C_Vertex3f(0.276138306f, 0.577555418f, 0.f),
    C_Vertex3f(0.28692627f, 0.575439692f, 0.f),
    C_Vertex3f(0.29724884f, 0.572266102f, 0.f),
    C_Vertex3f(0.308547974f, 0.639088511f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.231884956f, 0.575989723f, 0.f),
    C_Vertex3f(0.249605179f, 0.578613281f, 0.f),
    C_Vertex3f(0.251121521f, 0.643066406f, 0.f),
    C_Vertex3f(0.264884949f, 0.578613281f, 0.f),
    C_Vertex3f(0.273269653f, 0.643066406f, 0.f),
    C_Vertex3f(0.276138306f, 0.577555418f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.183376312f, 0.550848007f, 0.f),
    C_Vertex3f(0.199806213f, 0.562871933f, 0.f),
    C_Vertex3f(0.204268217f, 0.636187792f, 0.f),
    C_Vertex3f(0.215285301f, 0.570742607f, 0.f),
    C_Vertex3f(0.227045298f, 0.640773535f, 0.f),
    C_Vertex3f(0.231884956f, 0.575989723f, 0.f),
    C_Vertex3f(0.251121521f, 0.643066406f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.131475925f, 0.47198534f, 0.f),
    C_Vertex3f(0.139525414f, 0.491496086f, 0.f),
    C_Vertex3f(0.143731833f, 0.608673334f, 0.f),
    C_Vertex3f(0.152200222f, 0.514395237f, 0.f),
    C_Vertex3f(0.162611485f, 0.620137691f, 0.f),
    C_Vertex3f(0.166817188f, 0.534179211f, 0.f),
    C_Vertex3f(0.182790279f, 0.629309177f, 0.f),
    C_Vertex3f(0.183376312f, 0.550848007f, 0.f),
    C_Vertex3f(0.204268217f, 0.636187792f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.119237185f, 0.424691916f, 0.f),
    C_Vertex3f(0.122673392f, 0.441835046f, 0.f),
    C_Vertex3f(0.126151323f, 0.594916105f, 0.f),
    C_Vertex3f(0.126752973f, 0.457599521f, 0.f),
    C_Vertex3f(0.143731833f, 0.608673334f, 0.f),
    C_Vertex3f(0.131475925f, 0.47198534f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.126151323f, 0.594916105f, 0.f),
    C_Vertex3f(0.109869957f, 0.578866005f, 0.f),
    C_Vertex3f(0.112788796f, 0.364990592f, 0.f),
    C_Vertex3f(0.114294887f, 0.386269689f, 0.f),
    C_Vertex3f(0.116444349f, 0.40617013f, 0.f),
    C_Vertex3f(0.119237185f, 0.424691916f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.111926079f, 0.34233284f, 0.f),
    C_Vertex3f(0.112788796f, 0.364990592f, 0.f),
    C_Vertex3f(0.109869957f, 0.578866005f, 0.f),
    C_Vertex3f(0.111816406f, 0.330314636f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, -1.f),
    C_FrontFace(GL_CW),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.380196929f, 0.37755084f, -1.f),
    C_Vertex3f(0.364896894f, 0.38840127f, -1.f),
    C_Vertex3f(0.364961624f, 0.269178391f, -1.f),
    C_Vertex3f(0.369367599f, 0.256090164f, -1.f),
    C_Vertex3f(0.372672081f, 0.242120743f, -1.f),
    C_Vertex3f(0.374875069f, 0.227270126f, -1.f),
    C_Vertex3f(0.375976563f, 0.211538315f, -1.f),
    C_Vertex3f(0.391187668f, 0.0404396057f, -1.f),
    C_Vertex3f(0.394765377f, 0.364892006f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.336322784f, 0.312719345f, -1.f),
    C_Vertex3f(0.345134735f, 0.303155899f, -1.f),
    C_Vertex3f(0.348865271f, 0.397443295f, -1.f),
    C_Vertex3f(0.352845192f, 0.292711258f, -1.f),
    C_Vertex3f(0.364896894f, 0.38840127f, -1.f),
    C_Vertex3f(0.359454155f, 0.281385422f, -1.f),
    C_Vertex3f(0.364961624f, 0.269178391f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.33210206f, 0.404676914f, -1.f),
    C_Vertex3f(0.314607263f, 0.410102129f, -1.f),
    C_Vertex3f(0.316945076f, 0.328259945f, -1.f),
    C_Vertex3f(0.326926231f, 0.32108736f, -1.f),
    C_Vertex3f(0.336322784f, 0.312719345f, -1.f),
    C_Vertex3f(0.348865271f, 0.397443295f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.283493996f, 0.342605114f, -1.f),
    C_Vertex3f(0.295228958f, 0.339018822f, -1.f),
    C_Vertex3f(0.296380877f, 0.413718939f, -1.f),
    C_Vertex3f(0.306379318f, 0.334237099f, -1.f),
    C_Vertex3f(0.314607263f, 0.410102129f, -1.f),
    C_Vertex3f(0.316945076f, 0.328259945f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.277422905f, 0.415527344f, -1.f),
    C_Vertex3f(0.256311417f, 0.415527344f, -1.f),
    C_Vertex3f(0.258270264f, 0.346191406f, -1.f),
    C_Vertex3f(0.271174431f, 0.344995975f, -1.f),
    C_Vertex3f(0.283493996f, 0.342605114f, -1.f),
    C_Vertex3f(0.296380877f, 0.413718939f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.219747305f, 0.342605114f, -1.f),
    C_Vertex3f(0.232054949f, 0.344995975f, -1.f),
    C_Vertex3f(0.234270573f, 0.412905216f, -1.f),
    C_Vertex3f(0.244867325f, 0.346191406f, -1.f),
    C_Vertex3f(0.256311417f, 0.415527344f, -1.f),
    C_Vertex3f(0.258270264f, 0.346191406f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.212722301f, 0.407660961f, -1.f),
    C_Vertex3f(0.191666603f, 0.399794579f, -1.f),
    C_Vertex3f(0.196646214f, 0.334237099f, -1.f),
    C_Vertex3f(0.207944393f, 0.339018822f, -1.f),
    C_Vertex3f(0.219747305f, 0.342605114f, -1.f),
    C_Vertex3f(0.234270573f, 0.412905216f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.156500816f, 0.303155899f, -1.f),
    C_Vertex3f(0.165780067f, 0.312719345f, -1.f),
    C_Vertex3f(0.171103477f, 0.389306068f, -1.f),
    C_Vertex3f(0.175564051f, 0.32108736f, -1.f),
    C_Vertex3f(0.191666603f, 0.399794579f, -1.f),
    C_Vertex3f(0.185852766f, 0.328259945f, -1.f),
    C_Vertex3f(0.196646214f, 0.334237099f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.152125835f, 0.376032352f, -1.f),
    C_Vertex3f(0.134733677f, 0.359973431f, -1.f),
    C_Vertex3f(0.135622501f, 0.269998074f, -1.f),
    C_Vertex3f(0.141422033f, 0.281795263f, -1.f),
    C_Vertex3f(0.148381472f, 0.292847872f, -1.f),
    C_Vertex3f(0.156500816f, 0.303155899f, -1.f),
    C_Vertex3f(0.171103477f, 0.389306068f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.134733677f, 0.359973431f, -1.f),
    C_Vertex3f(0.118927002f, 0.341129303f, -1.f),
    C_Vertex3f(0.124023438f, 0.215363503f, -1.f),
    C_Vertex3f(0.125183344f, 0.230139017f, -1.f),
    C_Vertex3f(0.127503157f, 0.24416995f, -1.f),
    C_Vertex3f(0.130982876f, 0.257456303f, -1.f),
    C_Vertex3f(0.135622501f, 0.269998074f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.120217562f, 0.0366921425f, -1.f),
    C_Vertex3f(0.138011694f, 0.0231394768f, -1.f),
    C_Vertex3f(0.124023438f, 0.197439194f, -1.f),
    C_Vertex3f(0.124023438f, 0.215363503f, -1.f),
    C_Vertex3f(0.118927002f, 0.341129303f, -1.f),
    C_Vertex3f(0.111816406f, 0.330314636f, -1.f),
    C_Vertex3f(0.103557587f, 0.0525035858f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.111816406f, 0.330314636f, -1.f),
    C_Vertex3f(0.109869957f, 0.578866005f, -1.f),
    C_Vertex3f(0.103557587f, 0.0525035858f, -1.f),
    C_Vertex3f(0.0937929153f, 0.559158325f, -1.f),
    C_Vertex3f(0.0880317688f, 0.0705738068f, -1.f),
    C_Vertex3f(0.0787675381f, 0.534919262f, -1.f),
    C_Vertex3f(0.0744466782f, 0.0915715694f, -1.f),
    C_Vertex3f(0.0658886433f, 0.507513523f, -1.f),
    C_Vertex3f(0.0628023148f, 0.115496874f, -1.f),
    C_Vertex3f(0.0551562309f, 0.476941109f, -1.f),
    C_Vertex3f(0.0530986786f, 0.14234972f, -1.f),
    C_Vertex3f(0.0465703011f, 0.443202019f, -1.f),
    C_Vertex3f(0.0453357697f, 0.172130108f, -1.f),
    C_Vertex3f(0.0401308537f, 0.406296253f, -1.f),
    C_Vertex3f(0.039513588f, 0.204838037f, -1.f),
    C_Vertex3f(0.0358378887f, 0.366223812f, -1.f),
    C_Vertex3f(0.0356321335f, 0.240473509f, -1.f),
    C_Vertex3f(0.0336914063f, 0.322984695f, -1.f),
    C_Vertex3f(0.0336914063f, 0.279036522f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.446653605f, 0.281977177f, -1.f),
    C_Vertex3f(0.447273731f, 0.135922909f, -1.f),
    C_Vertex3f(0.451842427f, 0.262220621f, -1.f),
    C_Vertex3f(0.453778744f, 0.163929462f, -1.f),
    C_Vertex3f(0.455301642f, 0.241406202f, -1.f),
    C_Vertex3f(0.45703125f, 0.193000793f, -1.f),
    C_Vertex3f(0.45703125f, 0.21953392f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.408602238f, 0.350424767f, -1.f),
    C_Vertex3f(0.409063339f, 0.060256958f, -1.f),
    C_Vertex3f(0.420709491f, 0.334899664f, -1.f),
    C_Vertex3f(0.424506187f, 0.0831041336f, -1.f),
    C_Vertex3f(0.431087136f, 0.318316698f, -1.f),
    C_Vertex3f(0.437516212f, 0.108981133f, -1.f),
    C_Vertex3f(0.439735174f, 0.300675869f, -1.f),
    C_Vertex3f(0.447273731f, 0.135922909f, -1.f),
    C_Vertex3f(0.446653605f, 0.281977177f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.394765377f, 0.364892006f, -1.f),
    C_Vertex3f(0.391187668f, 0.0404396057f, -1.f),
    C_Vertex3f(0.409063339f, 0.060256958f, -1.f),
    C_Vertex3f(0.408602238f, 0.350424767f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.391187668f, 0.0404396057f, -1.f),
    C_Vertex3f(0.375976563f, 0.211538315f, -1.f),
    C_Vertex3f(0.375976563f, 0.194597244f, -1.f),
    C_Vertex3f(0.374861479f, 0.178229809f, -1.f),
    C_Vertex3f(0.372631311f, 0.162764072f, -1.f),
    C_Vertex3f(0.370879173f, 0.0236520767f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.370879173f, 0.0236520767f, -1.f),
    C_Vertex3f(0.372631311f, 0.162764072f, -1.f),
    C_Vertex3f(0.36928606f, 0.148200035f, -1.f),
    C_Vertex3f(0.364825726f, 0.134537697f, -1.f),
    C_Vertex3f(0.359250307f, 0.121777058f, -1.f),
    C_Vertex3f(0.352559805f, 0.109918118f, -1.f),
    C_Vertex3f(0.348137856f, 0.00989437103f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.348137856f, 0.00989437103f, -1.f),
    C_Vertex3f(0.352559805f, 0.109918118f, -1.f),
    C_Vertex3f(0.344754219f, 0.0989608765f, -1.f),
    C_Vertex3f(0.335833549f, 0.0889053345f, -1.f),
    C_Vertex3f(0.326464653f, 0.0801067352f, -1.f),
    C_Vertex3f(0.323865414f, -0.000423908234f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.326464653f, 0.0801067352f, -1.f),
    C_Vertex3f(0.31664753f, 0.0725650787f, -1.f),
    C_Vertex3f(0.323865414f, -0.000423908234f, -1.f),
    C_Vertex3f(0.306382179f, 0.066280365f, -1.f),
    C_Vertex3f(0.298061848f, -0.00730276108f, -1.f),
    C_Vertex3f(0.295668602f, 0.061252594f, -1.f),
    C_Vertex3f(0.284506798f, 0.0574817657f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.272896767f, 0.0549678802f, -1.f),
    C_Vertex3f(0.260838509f, 0.0537109375f, -1.f),
    C_Vertex3f(0.270727158f, -0.0107421875f, -1.f),
    C_Vertex3f(0.298061848f, -0.00730276108f, -1.f),
    C_Vertex3f(0.284506798f, 0.0574817657f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.197120667f, 0.0683021545f, -1.f),
    C_Vertex3f(0.198199034f, -0.00396585464f, -1.f),
    C_Vertex3f(0.212989807f, 0.061006546f, -1.f),
    C_Vertex3f(0.220529795f, -0.00848340988f, -1.f),
    C_Vertex3f(0.229286194f, 0.056142807f, -1.f),
    C_Vertex3f(0.243994713f, -0.0107421875f, -1.f),
    C_Vertex3f(0.246009827f, 0.0537109375f, -1.f),
    C_Vertex3f(0.270727158f, -0.0107421875f, -1.f),
    C_Vertex3f(0.260838509f, 0.0537109375f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.155909061f, 0.104125023f, -1.f),
    C_Vertex3f(0.156939983f, 0.0118455887f, -1.f),
    C_Vertex3f(0.16794157f, 0.0899705887f, -1.f),
    C_Vertex3f(0.17700243f, 0.00281047821f, -1.f),
    C_Vertex3f(0.181678772f, 0.0780296326f, -1.f),
    C_Vertex3f(0.198199034f, -0.00396585464f, -1.f),
    C_Vertex3f(0.197120667f, 0.0683021545f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.145581245f, 0.120492935f, -1.f),
    C_Vertex3f(0.136958122f, 0.139074326f, -1.f),
    C_Vertex3f(0.138011694f, 0.0231394768f, -1.f),
    C_Vertex3f(0.156939983f, 0.0118455887f, -1.f),
    C_Vertex3f(0.155909061f, 0.104125023f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.138011694f, 0.0231394768f, -1.f),
    C_Vertex3f(0.136958122f, 0.139074326f, -1.f),
    C_Vertex3f(0.13049078f, 0.158092499f, -1.f),
    C_Vertex3f(0.126179218f, 0.177547455f, -1.f),
    C_Vertex3f(0.124023438f, 0.197439194f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.445800781f, 0.483398438f, -1.f),
    C_Vertex3f(0.444597244f, 0.492749214f, -1.f),
    C_Vertex3f(0.440980434f, 0.510439038f, -1.f),
    C_Vertex3f(0.436153889f, 0.527117133f, -1.f),
    C_Vertex3f(0.430117607f, 0.542783499f, -1.f),
    C_Vertex3f(0.42287159f, 0.557438135f, -1.f),
    C_Vertex3f(0.414415836f, 0.571081042f, -1.f),
    C_Vertex3f(0.404750347f, 0.58371222f, -1.f),
    C_Vertex3f(0.393875122f, 0.595331669f, -1.f),
    C_Vertex3f(0.381790161f, 0.605939388f, -1.f),
    C_Vertex3f(0.368850708f, 0.615221143f, -1.f),
    C_Vertex3f(0.367675781f, 0.477050781f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.342702866f, 0.539485931f, -1.f),
    C_Vertex3f(0.351246834f, 0.525746346f, -1.f),
    C_Vertex3f(0.355056763f, 0.623176932f, -1.f),
    C_Vertex3f(0.35869503f, 0.508818626f, -1.f),
    C_Vertex3f(0.368850708f, 0.615221143f, -1.f),
    C_Vertex3f(0.365047455f, 0.488702774f, -1.f),
    C_Vertex3f(0.367675781f, 0.477050781f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.340408325f, 0.629806757f, -1.f),
    C_Vertex3f(0.324905396f, 0.635110617f, -1.f),
    C_Vertex3f(0.325424194f, 0.556398153f, -1.f),
    C_Vertex3f(0.333885193f, 0.548993111f, -1.f),
    C_Vertex3f(0.337882996f, 0.544761658f, -1.f),
    C_Vertex3f(0.342702866f, 0.539485931f, -1.f),
    C_Vertex3f(0.355056763f, 0.623176932f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.29724884f, 0.572266102f, -1.f),
    C_Vertex3f(0.307106018f, 0.568034649f, -1.f),
    C_Vertex3f(0.308547974f, 0.639088511f, -1.f),
    C_Vertex3f(0.316497803f, 0.562745333f, -1.f),
    C_Vertex3f(0.324905396f, 0.635110617f, -1.f),
    C_Vertex3f(0.325424194f, 0.556398153f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.29133606f, 0.641740441f, -1.f),
    C_Vertex3f(0.273269653f, 0.643066406f, -1.f),
    C_Vertex3f(0.276138306f, 0.577555418f, -1.f),
    C_Vertex3f(0.28692627f, 0.575439692f, -1.f),
    C_Vertex3f(0.29724884f, 0.572266102f, -1.f),
    C_Vertex3f(0.308547974f, 0.639088511f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.231884956f, 0.575989723f, -1.f),
    C_Vertex3f(0.249605179f, 0.578613281f, -1.f),
    C_Vertex3f(0.251121521f, 0.643066406f, -1.f),
    C_Vertex3f(0.264884949f, 0.578613281f, -1.f),
    C_Vertex3f(0.273269653f, 0.643066406f, -1.f),
    C_Vertex3f(0.276138306f, 0.577555418f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.183376312f, 0.550848007f, -1.f),
    C_Vertex3f(0.199806213f, 0.562871933f, -1.f),
    C_Vertex3f(0.204268217f, 0.636187792f, -1.f),
    C_Vertex3f(0.215285301f, 0.570742607f, -1.f),
    C_Vertex3f(0.227045298f, 0.640773535f, -1.f),
    C_Vertex3f(0.231884956f, 0.575989723f, -1.f),
    C_Vertex3f(0.251121521f, 0.643066406f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.131475925f, 0.47198534f, -1.f),
    C_Vertex3f(0.139525414f, 0.491496086f, -1.f),
    C_Vertex3f(0.143731833f, 0.608673334f, -1.f),
    C_Vertex3f(0.152200222f, 0.514395237f, -1.f),
    C_Vertex3f(0.162611485f, 0.620137691f, -1.f),
    C_Vertex3f(0.166817188f, 0.534179211f, -1.f),
    C_Vertex3f(0.182790279f, 0.629309177f, -1.f),
    C_Vertex3f(0.183376312f, 0.550848007f, -1.f),
    C_Vertex3f(0.204268217f, 0.636187792f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.119237185f, 0.424691916f, -1.f),
    C_Vertex3f(0.122673392f, 0.441835046f, -1.f),
    C_Vertex3f(0.126151323f, 0.594916105f, -1.f),
    C_Vertex3f(0.126752973f, 0.457599521f, -1.f),
    C_Vertex3f(0.143731833f, 0.608673334f, -1.f),
    C_Vertex3f(0.131475925f, 0.47198534f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.126151323f, 0.594916105f, -1.f),
    C_Vertex3f(0.109869957f, 0.578866005f, -1.f),
    C_Vertex3f(0.112788796f, 0.364990592f, -1.f),
    C_Vertex3f(0.114294887f, 0.386269689f, -1.f),
    C_Vertex3f(0.116444349f, 0.40617013f, -1.f),
    C_Vertex3f(0.119237185f, 0.424691916f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.111926079f, 0.34233284f, -1.f),
    C_Vertex3f(0.112788796f, 0.364990592f, -1.f),
    C_Vertex3f(0.109869957f, 0.578866005f, -1.f),
    C_Vertex3f(0.111816406f, 0.330314636f, -1.f),
    C_End(),
    C_Translatef(0.497558594f, 0.f, 0.f),
};
static const Call char_55[] = {
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_FrontFace(GL_CW),
    C_Begin(GL_QUADS),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.0424804688f, 0.556640625f, 0.f),
    C_Vertex3f(0.0424804688f, 0.556640625f, -1.f),
    C_Vertex3f(0.0424804688f, 0.632324219f, -1.f),
    C_Vertex3f(0.0424804688f, 0.632324219f, 0.f),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.0424804688f, 0.632324219f, 0.f),
    C_Vertex3f(0.0424804688f, 0.632324219f, -1.f),
    C_Vertex3f(0.45703125f, 0.632324219f, -1.f),
    C_Vertex3f(0.45703125f, 0.632324219f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.45703125f, 0.632324219f, 0.f),
    C_Vertex3f(0.45703125f, 0.632324219f, -1.f),
    C_Vertex3f(0.45703125f, 0.571075439f, -1.f),
    C_Vertex3f(0.45703125f, 0.571075439f, 0.f),
    C_End(),
    C_Begin(GL_QUAD_STRIP),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.45703125f, 0.571075439f, 0.f),
    C_Vertex3f(0.45703125f, 0.571075439f, -1.f),
    C_Normal3f(0.747414827f, -0.664357603f, 0.f),
    C_Vertex3f(0.449388504f, 0.562935829f, 0.f),
    C_Vertex3f(0.449388504f, 0.562935829f, -1.f),
    C_Normal3f(0.768294573f, -0.640096486f, 0.f),
    C_Vertex3f(0.434136987f, 0.545318961f, 0.f),
    C_Vertex3f(0.434136987f, 0.545318961f, -1.f),
    C_Normal3f(0.790561914f, -0.612382054f, 0.f),
    C_Vertex3f(0.418919444f, 0.526364446f, 0.f),
    C_Vertex3f(0.418919444f, 0.526364446f, -1.f),
    C_Normal3f(0.810163617f, -0.586203873f, 0.f),
    C_Vertex3f(0.403735876f, 0.506072283f, 0.f),
    C_Vertex3f(0.403735876f, 0.506072283f, -1.f),
    C_Normal3f(0.827451825f, -0.561536729f, 0.f),
    C_Vertex3f(0.388586283f, 0.484442472f, 0.f),
    C_Vertex3f(0.388586283f, 0.484442472f, -1.f),
    C_Normal3f(0.8427338f, -0.538330317f, 0.f),
    C_Vertex3f(0.373470664f, 0.461475015f, 0.f),
    C_Vertex3f(0.373470664f, 0.461475015f, -1.f),
    C_Normal3f(0.856275916f, -0.516518772f, 0.f),
    C_Vertex3f(0.35838902f, 0.437169909f, 0.f),
    C_Vertex3f(0.35838902f, 0.437169909f, -1.f),
    C_Normal3f(0.869435072f, -0.494047254f, 0.f),
    C_Vertex3f(0.343341351f, 0.411527157f, 0.f),
    C_Vertex3f(0.343341351f, 0.411527157f, -1.f),
    C_Normal3f(0.888613403f, -0.458656967f, 0.f),
    C_Vertex3f(0.320820808f, 0.371056557f, 0.f),
    C_Vertex3f(0.320820808f, 0.371056557f, -1.f),
    C_Normal3f(0.911239624f, -0.411876678f, 0.f),
    C_Vertex3f(0.294206142f, 0.316331387f, 0.f),
    C_Vertex3f(0.294206142f, 0.316331387f, -1.f),
    C_Normal3f(0.933309436f, -0.359073013f, 0.f),
    C_Vertex3f(0.2710042f, 0.260841846f, 0.f),
    C_Vertex3f(0.2710042f, 0.260841846f, -1.f),
    C_Normal3f(0.951583803f, -0.30738923f, 0.f),
    C_Vertex3f(0.251214981f, 0.204587936f, 0.f),
    C_Vertex3f(0.251214981f, 0.204587936f, -1.f),
    C_Normal3f(0.96740371f, -0.253239065f, 0.f),
    C_Vertex3f(0.237131119f, 0.155981064f, 0.f),
    C_Vertex3f(0.237131119f, 0.155981064f, -1.f),
    C_Normal3f(0.98064363f, -0.195800796f, 0.f),
    C_Vertex3f(0.227468491f, 0.113873482f, 0.f),
    C_Vertex3f(0.227468491f, 0.113873482f, -1.f),
    C_Normal3f(0.989811599f, -0.142383605f, 0.f),
    C_Vertex3f(0.219934464f, 0.0698537827f, 0.f),
    C_Vertex3f(0.219934464f, 0.0698537827f, -1.f),
    C_Normal3f(0.994954348f, -0.100328103f, 0.f),
    C_Vertex3f(0.214529037f, 0.0239219666f, 0.f),
    C_Vertex3f(0.214529037f, 0.0239219666f, -1.f),
    C_Normal3f(0.997662842f, -0.0683298036f, 0.f),
    C_Vertex3f(0.212890625f, 0.f, 0.f),
    C_Vertex3f(0.212890625f, 0.f, -1.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.f, -0.99999994f, 0.f),
    C_Vertex3f(0.212890625f, 0.f, 0.f),
    C_Vertex3f(0.212890625f, 0.f, -1.f),
    C_Vertex3f(0.131835938f, 0.f, -1.f),
    C_Vertex3f(0.131835938f, 0.f, 0.f),
    C_End(),
    C_Begin(GL_QUAD_STRIP),
    C_Normal3f(-0.999849319f, 0.0173588451f, 0.f),
    C_Vertex3f(0.131835938f, 0.f, 0.f),
    C_Vertex3f(0.131835938f, 0.f, -1.f),
    C_Normal3f(-0.998960197f, 0.0455918498f, 0.f),
    C_Vertex3f(0.131999969f, 0.00944805145f, 0.f),
    C_Vertex3f(0.131999969f, 0.00944805145f, -1.f),
    C_Normal3f(-0.996938705f, 0.0781873763f, 0.f),
    C_Vertex3f(0.133174419f, 0.0293273926f, 0.f),
    C_Vertex3f(0.133174419f, 0.0293273926f, -1.f),
    C_Normal3f(-0.993514061f, 0.113709584f, 0.f),
    C_Vertex3f(0.135195255f, 0.0501899719f, 0.f),
    C_Vertex3f(0.135195255f, 0.0501899719f, -1.f),
    C_Normal3f(-0.989324093f, 0.145732328f, 0.f),
    C_Vertex3f(0.138062477f, 0.0720357895f, 0.f),
    C_Vertex3f(0.138062477f, 0.0720357895f, -1.f),
    C_Normal3f(-0.984628618f, 0.174661011f, 0.f),
    C_Vertex3f(0.141776085f, 0.0948648453f, 0.f),
    C_Vertex3f(0.141776085f, 0.0948648453f, -1.f),
    C_Normal3f(-0.979620337f, 0.200857818f, 0.f),
    C_Vertex3f(0.146336079f, 0.118677139f, 0.f),
    C_Vertex3f(0.146336079f, 0.118677139f, -1.f),
    C_Normal3f(-0.974441171f, 0.224642754f, 0.f),
    C_Vertex3f(0.151742458f, 0.143472672f, 0.f),
    C_Vertex3f(0.151742458f, 0.143472672f, -1.f),
    C_Normal3f(-0.968669295f, 0.248354286f, 0.f),
    C_Vertex3f(0.157995224f, 0.169251442f, 0.f),
    C_Vertex3f(0.157995224f, 0.169251442f, -1.f),
    C_Normal3f(-0.957486272f, 0.288478523f, 0.f),
    C_Vertex3f(0.168643951f, 0.209394455f, 0.f),
    C_Vertex3f(0.168643951f, 0.209394455f, -1.f),
    C_Normal3f(-0.940458834f, 0.339907527f, 0.f),
    C_Vertex3f(0.185927868f, 0.261962414f, 0.f),
    C_Vertex3f(0.185927868f, 0.261962414f, -1.f),
    C_Normal3f(-0.919159234f, 0.393886209f, 0.f),
    C_Vertex3f(0.206297398f, 0.313574314f, 0.f),
    C_Vertex3f(0.206297398f, 0.313574314f, -1.f),
    C_Normal3f(-0.896880388f, 0.44227308f, 0.f),
    C_Vertex3f(0.229752541f, 0.364230156f, 0.f),
    C_Vertex3f(0.229752541f, 0.364230156f, -1.f),
    C_Normal3f(-0.877691567f, 0.479226023f, 0.f),
    C_Vertex3f(0.249658108f, 0.401504993f, 0.f),
    C_Vertex3f(0.249658108f, 0.401504993f, -1.f),
    C_Normal3f(-0.864643693f, 0.502385616f, 0.f),
    C_Vertex3f(0.263140082f, 0.42537868f, 0.f),
    C_Vertex3f(0.263140082f, 0.42537868f, -1.f),
    C_Normal3f(-0.851505995f, 0.524344981f, 0.f),
    C_Vertex3f(0.276833653f, 0.448276162f, 0.f),
    C_Vertex3f(0.276833653f, 0.448276162f, -1.f),
    C_Normal3f(-0.837023914f, 0.547166407f, 0.f),
    C_Vertex3f(0.290738821f, 0.470197439f, 0.f),
    C_Vertex3f(0.290738821f, 0.470197439f, -1.f),
    C_Normal3f(-0.821062744f, 0.570838034f, 0.f),
    C_Vertex3f(0.304855585f, 0.491142511f, 0.f),
    C_Vertex3f(0.304855585f, 0.491142511f, -1.f),
    C_Normal3f(-0.803479016f, 0.59533304f, 0.f),
    C_Vertex3f(0.319183946f, 0.511111379f, 0.f),
    C_Vertex3f(0.319183946f, 0.511111379f, -1.f),
    C_Normal3f(-0.784121931f, 0.620606899f, 0.f),
    C_Vertex3f(0.333723903f, 0.530104041f, 0.f),
    C_Vertex3f(0.333723903f, 0.530104041f, -1.f),
    C_Normal3f(-0.766523719f, 0.642216027f, 0.f),
    C_Vertex3f(0.348475456f, 0.548120499f, 0.f),
    C_Vertex3f(0.348475456f, 0.548120499f, -1.f),
    C_Normal3f(-0.751418889f, 0.659825504f, 0.f),
    C_Vertex3f(0.355957031f, 0.556640625f, 0.f),
    C_Vertex3f(0.355957031f, 0.556640625f, -1.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.f, -0.99999994f, 0.f),
    C_Vertex3f(0.355957031f, 0.556640625f, 0.f),
    C_Vertex3f(0.355957031f, 0.556640625f, -1.f),
    C_Vertex3f(0.0424804688f, 0.556640625f, -1.f),
    C_Vertex3f(0.0424804688f, 0.556640625f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.45703125f, 0.632324219f, 0.f),
    C_Vertex3f(0.0424804688f, 0.632324219f, 0.f),
    C_Vertex3f(0.355957031f, 0.556640625f, 0.f),
    C_Vertex3f(0.35838902f, 0.437169909f, 0.f),
    C_Vertex3f(0.373470664f, 0.461475015f, 0.f),
    C_Vertex3f(0.388586283f, 0.484442472f, 0.f),
    C_Vertex3f(0.403735876f, 0.506072283f, 0.f),
    C_Vertex3f(0.418919444f, 0.526364446f, 0.f),
    C_Vertex3f(0.434136987f, 0.545318961f, 0.f),
    C_Vertex3f(0.449388504f, 0.562935829f, 0.f),
    C_Vertex3f(0.45703125f, 0.571075439f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.319183946f, 0.511111379f, 0.f),
    C_Vertex3f(0.320820808f, 0.371056557f, 0.f),
    C_Vertex3f(0.333723903f, 0.530104041f, 0.f),
    C_Vertex3f(0.343341351f, 0.411527157f, 0.f),
    C_Vertex3f(0.348475456f, 0.548120499f, 0.f),
    C_Vertex3f(0.35838902f, 0.437169909f, 0.f),
    C_Vertex3f(0.355957031f, 0.556640625f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.304855585f, 0.491142511f, 0.f),
    C_Vertex3f(0.290738821f, 0.470197439f, 0.f),
    C_Vertex3f(0.294206142f, 0.316331387f, 0.f),
    C_Vertex3f(0.320820808f, 0.371056557f, 0.f),
    C_Vertex3f(0.319183946f, 0.511111379f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.219934464f, 0.0698537827f, 0.f),
    C_Vertex3f(0.227468491f, 0.113873482f, 0.f),
    C_Vertex3f(0.229752541f, 0.364230156f, 0.f),
    C_Vertex3f(0.237131119f, 0.155981064f, 0.f),
    C_Vertex3f(0.249658108f, 0.401504993f, 0.f),
    C_Vertex3f(0.251214981f, 0.204587936f, 0.f),
    C_Vertex3f(0.263140082f, 0.42537868f, 0.f),
    C_Vertex3f(0.2710042f, 0.260841846f, 0.f),
    C_Vertex3f(0.276833653f, 0.448276162f, 0.f),
    C_Vertex3f(0.294206142f, 0.316331387f, 0.f),
    C_Vertex3f(0.290738821f, 0.470197439f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.229752541f, 0.364230156f, 0.f),
    C_Vertex3f(0.206297398f, 0.313574314f, 0.f),
    C_Vertex3f(0.212890625f, 0.f, 0.f),
    C_Vertex3f(0.214529037f, 0.0239219666f, 0.f),
    C_Vertex3f(0.219934464f, 0.0698537827f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.212890625f, 0.f, 0.f),
    C_Vertex3f(0.206297398f, 0.313574314f, 0.f),
    C_Vertex3f(0.185927868f, 0.261962414f, 0.f),
    C_Vertex3f(0.168643951f, 0.209394455f, 0.f),
    C_Vertex3f(0.157995224f, 0.169251442f, 0.f),
    C_Vertex3f(0.151742458f, 0.143472672f, 0.f),
    C_Vertex3f(0.146336079f, 0.118677139f, 0.f),
    C_Vertex3f(0.141776085f, 0.0948648453f, 0.f),
    C_Vertex3f(0.138062477f, 0.0720357895f, 0.f),
    C_Vertex3f(0.135195255f, 0.0501899719f, 0.f),
    C_Vertex3f(0.133174419f, 0.0293273926f, 0.f),
    C_Vertex3f(0.131999969f, 0.00944805145f, 0.f),
    C_Vertex3f(0.131835938f, 0.f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.355957031f, 0.556640625f, 0.f),
    C_Vertex3f(0.0424804688f, 0.632324219f, 0.f),
    C_Vertex3f(0.0424804688f, 0.556640625f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, -1.f),
    C_FrontFace(GL_CW),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.45703125f, 0.632324219f, -1.f),
    C_Vertex3f(0.0424804688f, 0.632324219f, -1.f),
    C_Vertex3f(0.355957031f, 0.556640625f, -1.f),
    C_Vertex3f(0.35838902f, 0.437169909f, -1.f),
    C_Vertex3f(0.373470664f, 0.461475015f, -1.f),
    C_Vertex3f(0.388586283f, 0.484442472f, -1.f),
    C_Vertex3f(0.403735876f, 0.506072283f, -1.f),
    C_Vertex3f(0.418919444f, 0.526364446f, -1.f),
    C_Vertex3f(0.434136987f, 0.545318961f, -1.f),
    C_Vertex3f(0.449388504f, 0.562935829f, -1.f),
    C_Vertex3f(0.45703125f, 0.571075439f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.319183946f, 0.511111379f, -1.f),
    C_Vertex3f(0.320820808f, 0.371056557f, -1.f),
    C_Vertex3f(0.333723903f, 0.530104041f, -1.f),
    C_Vertex3f(0.343341351f, 0.411527157f, -1.f),
    C_Vertex3f(0.348475456f, 0.548120499f, -1.f),
    C_Vertex3f(0.35838902f, 0.437169909f, -1.f),
    C_Vertex3f(0.355957031f, 0.556640625f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.304855585f, 0.491142511f, -1.f),
    C_Vertex3f(0.290738821f, 0.470197439f, -1.f),
    C_Vertex3f(0.294206142f, 0.316331387f, -1.f),
    C_Vertex3f(0.320820808f, 0.371056557f, -1.f),
    C_Vertex3f(0.319183946f, 0.511111379f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.219934464f, 0.0698537827f, -1.f),
    C_Vertex3f(0.227468491f, 0.113873482f, -1.f),
    C_Vertex3f(0.229752541f, 0.364230156f, -1.f),
    C_Vertex3f(0.237131119f, 0.155981064f, -1.f),
    C_Vertex3f(0.249658108f, 0.401504993f, -1.f),
    C_Vertex3f(0.251214981f, 0.204587936f, -1.f),
    C_Vertex3f(0.263140082f, 0.42537868f, -1.f),
    C_Vertex3f(0.2710042f, 0.260841846f, -1.f),
    C_Vertex3f(0.276833653f, 0.448276162f, -1.f),
    C_Vertex3f(0.294206142f, 0.316331387f, -1.f),
    C_Vertex3f(0.290738821f, 0.470197439f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.229752541f, 0.364230156f, -1.f),
    C_Vertex3f(0.206297398f, 0.313574314f, -1.f),
    C_Vertex3f(0.212890625f, 0.f, -1.f),
    C_Vertex3f(0.214529037f, 0.0239219666f, -1.f),
    C_Vertex3f(0.219934464f, 0.0698537827f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.212890625f, 0.f, -1.f),
    C_Vertex3f(0.206297398f, 0.313574314f, -1.f),
    C_Vertex3f(0.185927868f, 0.261962414f, -1.f),
    C_Vertex3f(0.168643951f, 0.209394455f, -1.f),
    C_Vertex3f(0.157995224f, 0.169251442f, -1.f),
    C_Vertex3f(0.151742458f, 0.143472672f, -1.f),
    C_Vertex3f(0.146336079f, 0.118677139f, -1.f),
    C_Vertex3f(0.141776085f, 0.0948648453f, -1.f),
    C_Vertex3f(0.138062477f, 0.0720357895f, -1.f),
    C_Vertex3f(0.135195255f, 0.0501899719f, -1.f),
    C_Vertex3f(0.133174419f, 0.0293273926f, -1.f),
    C_Vertex3f(0.131999969f, 0.00944805145f, -1.f),
    C_Vertex3f(0.131835938f, 0.f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.355957031f, 0.556640625f, -1.f),
    C_Vertex3f(0.0424804688f, 0.632324219f, -1.f),
    C_Vertex3f(0.0424804688f, 0.556640625f, -1.f),
    C_End(),
    C_Translatef(0.497558594f, 0.f, 0.f),
};
static const Call char_56[] = {
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_FrontFace(GL_CW),
    C_Begin(GL_QUAD_STRIP),
    C_Normal3f(-0.34159103f, -0.939848721f, 0.f),
    C_Vertex3f(0.158699036f, 0.347679138f, 0.f),
    C_Vertex3f(0.158699036f, 0.347679138f, -1.f),
    C_Normal3f(-0.413664311f, -0.910429537f, 0.f),
    C_Vertex3f(0.146392822f, 0.352151871f, 0.f),
    C_Vertex3f(0.146392822f, 0.352151871f, -1.f),
    C_Normal3f(-0.511577785f, -0.859237015f, 0.f),
    C_Vertex3f(0.124967098f, 0.363005638f, 0.f),
    C_Vertex3f(0.124967098f, 0.363005638f, -1.f),
    C_Normal3f(-0.635928869f, -0.771747708f, 0.f),
    C_Vertex3f(0.106728077f, 0.375767708f, 0.f),
    C_Vertex3f(0.106728077f, 0.375767708f, -1.f),
    C_Normal3f(-0.757660508f, -0.652648926f, 0.f),
    C_Vertex3f(0.0916757584f, 0.39043808f, 0.f),
    C_Vertex3f(0.0916757584f, 0.39043808f, -1.f),
    C_Normal3f(-0.858710587f, -0.512460887f, 0.f),
    C_Vertex3f(0.0798101425f, 0.407016754f, 0.f),
    C_Vertex3f(0.0798101425f, 0.407016754f, -1.f),
    C_Normal3f(-0.931780219f, -0.363022923f, 0.f),
    C_Vertex3f(0.0709109306f, 0.425232887f, 0.f),
    C_Vertex3f(0.0709109306f, 0.425232887f, -1.f),
    C_Normal3f(-0.977609932f, -0.210425287f, 0.f),
    C_Vertex3f(0.0649781227f, 0.445086479f, 0.f),
    C_Vertex3f(0.0649781227f, 0.445086479f, -1.f),
    C_Normal3f(-0.997489154f, -0.0708198845f, 0.f),
    C_Vertex3f(0.0620117188f, 0.46657753f, 0.f),
    C_Vertex3f(0.0620117188f, 0.46657753f, -1.f),
    C_Normal3f(-0.999105155f, 0.042294994f, 0.f),
    C_Vertex3f(0.0620117188f, 0.486867905f, 0.f),
    C_Vertex3f(0.0620117188f, 0.486867905f, -1.f),
    C_Normal3f(-0.989879251f, 0.141912133f, 0.f),
    C_Vertex3f(0.0635800362f, 0.503624797f, 0.f),
    C_Vertex3f(0.0635800362f, 0.503624797f, -1.f),
    C_Normal3f(-0.970253944f, 0.242089644f, 0.f),
    C_Vertex3f(0.066716671f, 0.519686341f, 0.f),
    C_Vertex3f(0.066716671f, 0.519686341f, -1.f),
    C_Normal3f(-0.939233243f, 0.343279779f, 0.f),
    C_Vertex3f(0.0714216232f, 0.535052538f, 0.f),
    C_Vertex3f(0.0714216232f, 0.535052538f, -1.f),
    C_Normal3f(-0.897021294f, 0.441987455f, 0.f),
    C_Vertex3f(0.0776948929f, 0.549723387f, 0.f),
    C_Vertex3f(0.0776948929f, 0.549723387f, -1.f),
    C_Normal3f(-0.8449651f, 0.534821451f, 0.f),
    C_Vertex3f(0.0855364799f, 0.563698888f, 0.f),
    C_Vertex3f(0.0855364799f, 0.563698888f, -1.f),
    C_Normal3f(-0.785348892f, 0.619053423f, 0.f),
    C_Vertex3f(0.0949463844f, 0.576979041f, 0.f),
    C_Vertex3f(0.0949463844f, 0.576979041f, -1.f),
    C_Normal3f(-0.720953465f, 0.692983389f, 0.f),
    C_Vertex3f(0.105924606f, 0.589563847f, 0.f),
    C_Vertex3f(0.105924606f, 0.589563847f, -1.f),
    C_Normal3f(-0.649044693f, 0.760750294f, 0.f),
    C_Vertex3f(0.118471146f, 0.601453304f, 0.f),
    C_Vertex3f(0.118471146f, 0.601453304f, -1.f),
    C_Normal3f(-0.565163255f, 0.824979126f, 0.f),
    C_Vertex3f(0.13205409f, 0.61185658f, 0.f),
    C_Vertex3f(0.13205409f, 0.61185658f, -1.f),
    C_Normal3f(-0.475136459f, 0.879912078f, 0.f),
    C_Vertex3f(0.146673441f, 0.620773673f, 0.f),
    C_Vertex3f(0.146673441f, 0.620773673f, -1.f),
    C_Normal3f(-0.382115066f, 0.924114764f, 0.f),
    C_Vertex3f(0.162329197f, 0.628204584f, 0.f),
    C_Vertex3f(0.162329197f, 0.628204584f, -1.f),
    C_Normal3f(-0.289313287f, 0.957234442f, 0.f),
    C_Vertex3f(0.179021358f, 0.634149313f, 0.f),
    C_Vertex3f(0.179021358f, 0.634149313f, -1.f),
    C_Normal3f(-0.199528217f, 0.979892075f, 0.f),
    C_Vertex3f(0.196749926f, 0.63860786f, 0.f),
    C_Vertex3f(0.196749926f, 0.63860786f, -1.f),
    C_Normal3f(-0.114842273f, 0.993383646f, 0.f),
    C_Vertex3f(0.215514898f, 0.641580224f, 0.f),
    C_Vertex3f(0.215514898f, 0.641580224f, -1.f),
    C_Normal3f(-0.0364970155f, 0.999333739f, 0.f),
    C_Vertex3f(0.235316277f, 0.643066406f, 0.f),
    C_Vertex3f(0.235316277f, 0.643066406f, -1.f),
    C_Normal3f(0.0372212939f, 0.999306977f, 0.f),
    C_Vertex3f(0.25620842f, 0.643066406f, 0.f),
    C_Vertex3f(0.25620842f, 0.643066406f, -1.f),
    C_Normal3f(0.116669446f, 0.993170798f, 0.f),
    C_Vertex3f(0.276132226f, 0.64154613f, 0.f),
    C_Vertex3f(0.276132226f, 0.64154613f, -1.f),
    C_Normal3f(0.20239684f, 0.979303598f, 0.f),
    C_Vertex3f(0.295033336f, 0.638505578f, 0.f),
    C_Vertex3f(0.295033336f, 0.638505578f, -1.f),
    C_Normal3f(0.292941689f, 0.956130326f, 0.f),
    C_Vertex3f(0.312911749f, 0.63394475f, 0.f),
    C_Vertex3f(0.312911749f, 0.63394475f, -1.f),
    C_Normal3f(0.386109918f, 0.922452748f, 0.f),
    C_Vertex3f(0.329767466f, 0.627863646f, 0.f),
    C_Vertex3f(0.329767466f, 0.627863646f, -1.f),
    C_Normal3f(0.47903949f, 0.877793431f, 0.f),
    C_Vertex3f(0.345600486f, 0.620262265f, 0.f),
    C_Vertex3f(0.345600486f, 0.620262265f, -1.f),
    C_Normal3f(0.568529308f, 0.822663009f, 0.f),
    C_Vertex3f(0.36041081f, 0.611140609f, 0.f),
    C_Vertex3f(0.36041081f, 0.611140609f, -1.f),
    C_Normal3f(0.651529014f, 0.758623719f, 0.f),
    C_Vertex3f(0.374198437f, 0.600498676f, 0.f),
    C_Vertex3f(0.374198437f, 0.600498676f, -1.f),
    C_Normal3f(0.722137749f, 0.691749334f, 0.f),
    C_Vertex3f(0.386963367f, 0.588336468f, 0.f),
    C_Vertex3f(0.386963367f, 0.588336468f, -1.f),
    C_Normal3f(0.785268784f, 0.61915499f, 0.f),
    C_Vertex3f(0.398132682f, 0.575513005f, 0.f),
    C_Vertex3f(0.398132682f, 0.575513005f, -1.f),
    C_Normal3f(0.844095469f, 0.536192894f, 0.f),
    C_Vertex3f(0.40770638f, 0.562028289f, 0.f),
    C_Vertex3f(0.40770638f, 0.562028289f, -1.f),
    C_Normal3f(0.895858824f, 0.44433865f, 0.f),
    C_Vertex3f(0.415684462f, 0.547882318f, 0.f),
    C_Vertex3f(0.415684462f, 0.547882318f, -1.f),
    C_Normal3f(0.938191235f, 0.346117586f, 0.f),
    C_Vertex3f(0.422066927f, 0.533075094f, 0.f),
    C_Vertex3f(0.422066927f, 0.533075094f, -1.f),
    C_Normal3f(0.969572902f, 0.244802848f, 0.f),
    C_Vertex3f(0.426853776f, 0.517606616f, 0.f),
    C_Vertex3f(0.426853776f, 0.517606616f, -1.f),
    C_Normal3f(0.989593446f, 0.143892199f, 0.f),
    C_Vertex3f(0.430045009f, 0.501476884f, 0.f),
    C_Vertex3f(0.430045009f, 0.501476884f, -1.f),
    C_Normal3f(0.999053299f, 0.0435018204f, 0.f),
    C_Vertex3f(0.431640625f, 0.484685898f, 0.f),
    C_Vertex3f(0.431640625f, 0.484685898f, -1.f),
    C_Normal3f(0.997420371f, -0.0717815161f, 0.f),
    C_Vertex3f(0.431640625f, 0.464832306f, 0.f),
    C_Vertex3f(0.431640625f, 0.464832306f, -1.f),
    C_Normal3f(0.976942599f, -0.213502169f, 0.f),
    C_Vertex3f(0.428714275f, 0.444023609f, 0.f),
    C_Vertex3f(0.428714275f, 0.444023609f, -1.f),
    C_Normal3f(0.930865526f, -0.365361661f, 0.f),
    C_Vertex3f(0.422861576f, 0.42466116f, 0.f),
    C_Vertex3f(0.422861576f, 0.42466116f, -1.f),
    C_Normal3f(0.859111667f, -0.51178813f, 0.f),
    C_Vertex3f(0.414082527f, 0.406744957f, 0.f),
    C_Vertex3f(0.414082527f, 0.406744957f, -1.f),
    C_Normal3f(0.761383832f, -0.648301363f, 0.f),
    C_Vertex3f(0.402377129f, 0.390275002f, 0.f),
    C_Vertex3f(0.402377129f, 0.390275002f, -1.f),
    C_Normal3f(0.642958701f, -0.76590085f, 0.f),
    C_Vertex3f(0.387636662f, 0.375686169f, 0.f),
    C_Vertex3f(0.387636662f, 0.375686169f, -1.f),
    C_Normal3f(0.520706773f, -0.853735507f, 0.f),
    C_Vertex3f(0.369861126f, 0.362978458f, 0.f),
    C_Vertex3f(0.369861126f, 0.362978458f, -1.f),
    C_Normal3f(0.423424333f, -0.905931473f, 0.f),
    C_Vertex3f(0.349050522f, 0.352151871f, 0.f),
    C_Vertex3f(0.349050522f, 0.352151871f, -1.f),
    C_Normal3f(0.35123837f, -0.936286151f, 0.f),
    C_Vertex3f(0.337127686f, 0.347679138f, 0.f),
    C_Vertex3f(0.337127686f, 0.347679138f, -1.f),
    C_End(),
    C_Begin(GL_QUAD_STRIP),
    C_Normal3f(0.309335768f, 0.950952888f, 0.f),
    C_Vertex3f(0.337127686f, 0.347679138f, 0.f),
    C_Vertex3f(0.337127686f, 0.347679138f, -1.f),
    C_Normal3f(0.349827409f, 0.936814249f, 0.f),
    C_Vertex3f(0.344518661f, 0.345274925f, 0.f),
    C_Vertex3f(0.344518661f, 0.345274925f, -1.f),
    C_Normal3f(0.402361244f, 0.915480971f, 0.f),
    C_Vertex3f(0.358417749f, 0.339728951f, 0.f),
    C_Vertex3f(0.358417749f, 0.339728951f, -1.f),
    C_Normal3f(0.467616051f, 0.883931637f, 0.f),
    C_Vertex3f(0.371433973f, 0.33344543f, 0.f),
    C_Vertex3f(0.371433973f, 0.33344543f, -1.f),
    C_Normal3f(0.534275532f, 0.84531039f, 0.f),
    C_Vertex3f(0.383567333f, 0.32642436f, 0.f),
    C_Vertex3f(0.383567333f, 0.32642436f, -1.f),
    C_Normal3f(0.600974143f, 0.799268484f, 0.f),
    C_Vertex3f(0.394817829f, 0.318665743f, 0.f),
    C_Vertex3f(0.394817829f, 0.318665743f, -1.f),
    C_Normal3f(0.666110337f, 0.745853305f, 0.f),
    C_Vertex3f(0.405185461f, 0.310169578f, 0.f),
    C_Vertex3f(0.405185461f, 0.310169578f, -1.f),
    C_Normal3f(0.72798425f, 0.685593843f, 0.f),
    C_Vertex3f(0.414670229f, 0.300935864f, 0.f),
    C_Vertex3f(0.414670229f, 0.300935864f, -1.f),
    C_Normal3f(0.78498292f, 0.619517386f, 0.f),
    C_Vertex3f(0.423272133f, 0.290964603f, 0.f),
    C_Vertex3f(0.423272133f, 0.290964603f, -1.f),
    C_Normal3f(0.834698081f, 0.550707757f, 0.f),
    C_Vertex3f(0.430991173f, 0.280255795f, 0.f),
    C_Vertex3f(0.430991173f, 0.280255795f, -1.f),
    C_Normal3f(0.877709627f, 0.479192853f, 0.f),
    C_Vertex3f(0.437745333f, 0.269027829f, 0.f),
    C_Vertex3f(0.437745333f, 0.269027829f, -1.f),
    C_Normal3f(0.914642811f, 0.404262871f, 0.f),
    C_Vertex3f(0.443534613f, 0.257280707f, 0.f),
    C_Vertex3f(0.443534613f, 0.257280707f, -1.f),
    C_Normal3f(0.944844067f, 0.327520519f, 0.f),
    C_Vertex3f(0.448359013f, 0.245014429f, 0.f),
    C_Vertex3f(0.448359013f, 0.245014429f, -1.f),
    C_Normal3f(0.968086243f, 0.250617206f, 0.f),
    C_Vertex3f(0.452218533f, 0.232228994f, 0.f),
    C_Vertex3f(0.452218533f, 0.232228994f, -1.f),
    C_Normal3f(0.984552622f, 0.175089076f, 0.f),
    C_Vertex3f(0.455113173f, 0.218924403f, 0.f),
    C_Vertex3f(0.455113173f, 0.218924403f, -1.f),
    C_Normal3f(0.994760811f, 0.102229916f, 0.f),
    C_Vertex3f(0.457042933f, 0.205100656f, 0.f),
    C_Vertex3f(0.457042933f, 0.205100656f, -1.f),
    C_Normal3f(0.999547064f, 0.0300965123f, 0.f),
    C_Vertex3f(0.458007813f, 0.190757751f, 0.f),
    C_Vertex3f(0.458007813f, 0.190757751f, -1.f),
    C_Normal3f(0.998826027f, -0.0484423116f, 0.f),
    C_Vertex3f(0.458007813f, 0.173055649f, 0.f),
    C_Vertex3f(0.458007813f, 0.173055649f, -1.f),
    C_Normal3f(0.990209043f, -0.139592096f, 0.f),
    C_Vertex3f(0.456192732f, 0.153332829f, 0.f),
    C_Vertex3f(0.456192732f, 0.153332829f, -1.f),
    C_Normal3f(0.971192896f, -0.23829478f, 0.f),
    C_Vertex3f(0.452562571f, 0.134429336f, 0.f),
    C_Vertex3f(0.452562571f, 0.134429336f, -1.f),
    C_Normal3f(0.941057682f, -0.338246197f, 0.f),
    C_Vertex3f(0.447117329f, 0.116345167f, 0.f),
    C_Vertex3f(0.447117329f, 0.116345167f, -1.f),
    C_Normal3f(0.899905205f, -0.436085641f, 0.f),
    C_Vertex3f(0.439857006f, 0.0990803242f, 0.f),
    C_Vertex3f(0.439857006f, 0.0990803242f, -1.f),
    C_Normal3f(0.848935962f, -0.528495669f, 0.f),
    C_Vertex3f(0.430781603f, 0.0826348066f, 0.f),
    C_Vertex3f(0.430781603f, 0.0826348066f, -1.f),
    C_Normal3f(0.790283918f, -0.612740815f, 0.f),
    C_Vertex3f(0.419891119f, 0.0670086145f, 0.f),
    C_Vertex3f(0.419891119f, 0.0670086145f, -1.f),
    C_Normal3f(0.726616323f, -0.687043369f, 0.f),
    C_Vertex3f(0.407185555f, 0.0522017479f, 0.f),
    C_Vertex3f(0.407185555f, 0.0522017479f, -1.f),
    C_Normal3f(0.655841708f, -0.754898429f, 0.f),
    C_Vertex3f(0.392664909f, 0.0382142067f, 0.f),
    C_Vertex3f(0.392664909f, 0.0382142067f, -1.f),
    C_Normal3f(0.573345304f, -0.819313824f, 0.f),
    C_Vertex3f(0.376997709f, 0.0259751081f, 0.f),
    C_Vertex3f(0.376997709f, 0.0259751081f, -1.f),
    C_Normal3f(0.483987242f, -0.875075042f, 0.f),
    C_Vertex3f(0.360183954f, 0.0154844522f, 0.f),
    C_Vertex3f(0.360183954f, 0.0154844522f, -1.f),
    C_Normal3f(0.390771121f, -0.920487821f, 0.f),
    C_Vertex3f(0.342223644f, 0.006742239f, 0.f),
    C_Vertex3f(0.342223644f, 0.006742239f, -1.f),
    C_Normal3f(0.296926677f, -0.954900265f, 0.f),
    C_Vertex3f(0.323116779f, -0.000251531601f, 0.f),
    C_Vertex3f(0.323116779f, -0.000251531601f, -1.f),
    C_Normal3f(0.205404729f, -0.978677154f, 0.f),
    C_Vertex3f(0.302863359f, -0.00549685955f, 0.f),
    C_Vertex3f(0.302863359f, -0.00549685955f, -1.f),
    C_Normal3f(0.118515901f, -0.992952108f, 0.f),
    C_Vertex3f(0.281463385f, -0.00899374485f, 0.f),
    C_Vertex3f(0.281463385f, -0.00899374485f, -1.f),
    C_Normal3f(0.037785653f, -0.999285877f, 0.f),
    C_Vertex3f(0.258916855f, -0.0107421875f, 0.f),
    C_Vertex3f(0.258916855f, -0.0107421875f, -1.f),
    C_Normal3f(-0.0379322879f, -0.999280334f, 0.f),
    C_Vertex3f(0.23522377f, -0.0107421875f, 0.f),
    C_Vertex3f(0.23522377f, -0.0107421875f, -1.f),
    C_Normal3f(-0.118969977f, -0.992897809f, 0.f),
    C_Vertex3f(0.21267724f, -0.00898694992f, 0.f),
    C_Vertex3f(0.21267724f, -0.00898694992f, -1.f),
    C_Normal3f(-0.206169114f, -0.97851634f, 0.f),
    C_Vertex3f(0.191277266f, -0.00547647476f, 0.f),
    C_Vertex3f(0.191277266f, -0.00547647476f, -1.f),
    C_Normal3f(-0.297978342f, -0.954572618f, 0.f),
    C_Vertex3f(0.171023846f, -0.000210762024f, 0.f),
    C_Vertex3f(0.171023846f, -0.000210762024f, -1.f),
    C_Normal3f(-0.392056733f, -0.919941008f, 0.f),
    C_Vertex3f(0.151916981f, 0.00681018829f, 0.f),
    C_Vertex3f(0.151916981f, 0.00681018829f, -1.f),
    C_Normal3f(-0.485425621f, -0.874278009f, 0.f),
    C_Vertex3f(0.133956671f, 0.0155863762f, 0.f),
    C_Vertex3f(0.133956671f, 0.0155863762f, -1.f),
    C_Normal3f(-0.574838161f, -0.818267167f, 0.f),
    C_Vertex3f(0.117142916f, 0.0261178017f, 0.f),
    C_Vertex3f(0.117142916f, 0.0261178017f, -1.f),
    C_Normal3f(-0.657290518f, -0.753637195f, 0.f),
    C_Vertex3f(0.101475716f, 0.0384044647f, 0.f),
    C_Vertex3f(0.101475716f, 0.0384044647f, -1.f),
    C_Normal3f(-0.728475571f, -0.685071766f, 0.f),
    C_Vertex3f(0.0869550705f, 0.0524463654f, 0.f),
    C_Vertex3f(0.0869550705f, 0.0524463654f, -1.f),
    C_Normal3f(-0.792730033f, -0.609572947f, 0.f),
    C_Vertex3f(0.074249506f, 0.0673556328f, 0.f),
    C_Vertex3f(0.074249506f, 0.0673556328f, -1.f),
    C_Normal3f(-0.85148561f, -0.524377942f, 0.f),
    C_Vertex3f(0.0633590221f, 0.083132267f, 0.f),
    C_Vertex3f(0.0633590221f, 0.083132267f, -1.f),
    C_Normal3f(-0.902128577f, -0.431467295f, 0.f),
    C_Vertex3f(0.0542836189f, 0.099776268f, 0.f),
    C_Vertex3f(0.0542836189f, 0.099776268f, -1.f),
    C_Normal3f(-0.942672729f, -0.333718449f, 0.f),
    C_Vertex3f(0.0470232964f, 0.117287636f, 0.f),
    C_Vertex3f(0.0470232964f, 0.117287636f, -1.f),
    C_Normal3f(-0.972120225f, -0.234482959f, 0.f),
    C_Vertex3f(0.0415780544f, 0.13566637f, 0.f),
    C_Vertex3f(0.0415780544f, 0.13566637f, -1.f),
    C_Normal3f(-0.99056536f, -0.137040824f, 0.f),
    C_Vertex3f(0.0379478931f, 0.154912472f, 0.f),
    C_Vertex3f(0.0379478931f, 0.154912472f, -1.f),
    C_Normal3f(-0.998885691f, -0.0471937433f, 0.f),
    C_Vertex3f(0.0361328125f, 0.17502594f, 0.f),
    C_Vertex3f(0.0361328125f, 0.17502594f, -1.f),
    C_Normal3f(-0.999553561f, 0.0298789237f, 0.f),
    C_Vertex3f(0.0361328125f, 0.193329811f, 0.f),
    C_Vertex3f(0.0361328125f, 0.193329811f, -1.f),
    C_Normal3f(-0.994864404f, 0.101216421f, 0.f),
    C_Vertex3f(0.0371280909f, 0.208321452f, 0.f),
    C_Vertex3f(0.0371280909f, 0.208321452f, -1.f),
    C_Normal3f(-0.984654069f, 0.174517944f, 0.f),
    C_Vertex3f(0.0391186476f, 0.222677827f, 0.f),
    C_Vertex3f(0.0391186476f, 0.222677827f, -1.f),
    C_Normal3f(-0.967847645f, 0.251537174f, 0.f),
    C_Vertex3f(0.0421044827f, 0.236398935f, 0.f),
    C_Vertex3f(0.0421044827f, 0.236398935f, -1.f),
    C_Normal3f(-0.943630457f, 0.331000805f, 0.f),
    C_Vertex3f(0.0460855961f, 0.249484777f, 0.f),
    C_Vertex3f(0.0460855961f, 0.249484777f, -1.f),
    C_Normal3f(-0.911521673f, 0.411252081f, 0.f),
    C_Vertex3f(0.0510619879f, 0.261935353f, 0.f),
    C_Vertex3f(0.0510619879f, 0.261935353f, -1.f),
    C_Normal3f(-0.871515036f, 0.490368694f, 0.f),
    C_Vertex3f(0.057033658f, 0.273750663f, 0.f),
    C_Vertex3f(0.057033658f, 0.273750663f, -1.f),
    C_Normal3f(-0.824159503f, 0.566357851f, 0.f),
    C_Vertex3f(0.0640006065f, 0.284930706f, 0.f),
    C_Vertex3f(0.0640006065f, 0.284930706f, -1.f),
    C_Normal3f(-0.770195901f, 0.637807369f, 0.f),
    C_Vertex3f(0.0719628334f, 0.295475483f, 0.f),
    C_Vertex3f(0.0719628334f, 0.295475483f, -1.f),
    C_Normal3f(-0.709238887f, 0.704968095f, 0.f),
    C_Vertex3f(0.0807694197f, 0.305180192f, 0.f),
    C_Vertex3f(0.0807694197f, 0.305180192f, -1.f),
    C_Normal3f(-0.64244163f, 0.766334653f, 0.f),
    C_Vertex3f(0.0904203653f, 0.314044833f, 0.f),
    C_Vertex3f(0.0904203653f, 0.314044833f, -1.f),
    C_Normal3f(-0.571559072f, 0.820560873f, 0.f),
    C_Vertex3f(0.10091567f, 0.322069407f, 0.f),
    C_Vertex3f(0.10091567f, 0.322069407f, -1.f),
    C_Normal3f(-0.498549283f, 0.866861343f, 0.f),
    C_Vertex3f(0.112255335f, 0.329253912f, 0.f),
    C_Vertex3f(0.112255335f, 0.329253912f, -1.f),
    C_Normal3f(-0.425331026f, 0.90503782f, 0.f),
    C_Vertex3f(0.124439359f, 0.33559835f, 0.f),
    C_Vertex3f(0.124439359f, 0.33559835f, -1.f),
    C_Normal3f(-0.353583843f, 0.935402751f, 0.f),
    C_Vertex3f(0.137467742f, 0.341102719f, 0.f),
    C_Vertex3f(0.137467742f, 0.341102719f, -1.f),
    C_Normal3f(-0.295881957f, 0.955224514f, 0.f),
    C_Vertex3f(0.151340485f, 0.345767021f, 0.f),
    C_Vertex3f(0.151340485f, 0.345767021f, -1.f),
    C_Normal3f(-0.251497567f, 0.967857957f, 0.f),
    C_Vertex3f(0.158699036f, 0.347679138f, 0.f),
    C_Vertex3f(0.158699036f, 0.347679138f, -1.f),
    C_End(),
    C_Begin(GL_QUAD_STRIP),
    C_Normal3f(0.998984277f, -0.045059707f, 0.f),
    C_Vertex3f(0.143066406f, 0.485905647f, 0.f),
    C_Vertex3f(0.143066406f, 0.485905647f, -1.f),
    C_Normal3f(0.999116063f, 0.0420362838f, 0.f),
    C_Vertex3f(0.143066406f, 0.475216866f, 0.f),
    C_Vertex3f(0.143066406f, 0.475216866f, -1.f),
    C_Normal3f(0.991844535f, 0.127453804f, 0.f),
    C_Vertex3f(0.143971562f, 0.464391947f, 0.f),
    C_Vertex3f(0.143971562f, 0.464391947f, -1.f),
    C_Normal3f(0.975565374f, 0.219709679f, 0.f),
    C_Vertex3f(0.145781875f, 0.454085112f, 0.f),
    C_Vertex3f(0.145781875f, 0.454085112f, -1.f),
    C_Normal3f(0.948937535f, 0.315463781f, 0.f),
    C_Vertex3f(0.148497343f, 0.44429636f, 0.f),
    C_Vertex3f(0.148497343f, 0.44429636f, -1.f),
    C_Normal3f(0.91124022f, 0.411875278f, 0.f),
    C_Vertex3f(0.152117968f, 0.435025692f, 0.f),
    C_Vertex3f(0.152117968f, 0.435025692f, -1.f),
    C_Normal3f(0.862725139f, 0.505672991f, 0.f),
    C_Vertex3f(0.156643748f, 0.426273108f, 0.f),
    C_Vertex3f(0.156643748f, 0.426273108f, -1.f),
    C_Normal3f(0.804725111f, 0.593647599f, 0.f),
    C_Vertex3f(0.162074685f, 0.418038607f, 0.f),
    C_Vertex3f(0.162074685f, 0.418038607f, -1.f),
    C_Normal3f(0.739483893f, 0.673174202f, 0.f),
    C_Vertex3f(0.168410778f, 0.410322189f, 0.f),
    C_Vertex3f(0.168410778f, 0.410322189f, -1.f),
    C_Normal3f(0.667975485f, 0.744183242f, 0.f),
    C_Vertex3f(0.175652027f, 0.403123856f, 0.f),
    C_Vertex3f(0.175652027f, 0.403123856f, -1.f),
    C_Normal3f(0.586707413f, 0.809799016f, 0.f),
    C_Vertex3f(0.18344748f, 0.396825314f, 0.f),
    C_Vertex3f(0.18344748f, 0.396825314f, -1.f),
    C_Normal3f(0.497599483f, 0.867406964f, 0.f),
    C_Vertex3f(0.191797137f, 0.391426563f, 0.f),
    C_Vertex3f(0.191797137f, 0.391426563f, -1.f),
    C_Normal3f(0.403526545f, 0.914967895f, 0.f),
    C_Vertex3f(0.200700998f, 0.386927605f, 0.f),
    C_Vertex3f(0.200700998f, 0.386927605f, -1.f),
    C_Normal3f(0.307790041f, 0.951454282f, 0.f),
    C_Vertex3f(0.210159063f, 0.383328438f, 0.f),
    C_Vertex3f(0.210159063f, 0.383328438f, -1.f),
    C_Normal3f(0.213577211f, 0.976926148f, 0.f),
    C_Vertex3f(0.220171332f, 0.380629063f, 0.f),
    C_Vertex3f(0.220171332f, 0.380629063f, -1.f),
    C_Normal3f(0.12351577f, 0.992342651f, 0.f),
    C_Vertex3f(0.230737805f, 0.378829479f, 0.f),
    C_Vertex3f(0.230737805f, 0.378829479f, -1.f),
    C_Normal3f(0.0397252738f, 0.999210656f, 0.f),
    C_Vertex3f(0.241858482f, 0.377929688f, 0.f),
    C_Vertex3f(0.241858482f, 0.377929688f, -1.f),
    C_Normal3f(-0.0399405695f, 0.999202073f, 0.f),
    C_Vertex3f(0.253370285f, 0.377929688f, 0.f),
    C_Vertex3f(0.253370285f, 0.377929688f, -1.f),
    C_Normal3f(-0.125739619f, 0.992063344f, 0.f),
    C_Vertex3f(0.26419878f, 0.378822684f, 0.f),
    C_Vertex3f(0.26419878f, 0.378822684f, -1.f),
    C_Normal3f(-0.216890603f, 0.976195931f, 0.f),
    C_Vertex3f(0.274507046f, 0.380608678f, 0.f),
    C_Vertex3f(0.274507046f, 0.380608678f, -1.f),
    C_Normal3f(-0.311692953f, 0.950182855f, 0.f),
    C_Vertex3f(0.284295082f, 0.383287668f, 0.f),
    C_Vertex3f(0.284295082f, 0.383287668f, -1.f),
    C_Normal3f(-0.407413632f, 0.913243711f, 0.f),
    C_Vertex3f(0.293562889f, 0.386859655f, 0.f),
    C_Vertex3f(0.293562889f, 0.386859655f, -1.f),
    C_Normal3f(-0.500859618f, 0.865528464f, 0.f),
    C_Vertex3f(0.302310467f, 0.391324639f, 0.f),
    C_Vertex3f(0.302310467f, 0.391324639f, -1.f),
    C_Normal3f(-0.588843465f, 0.808247089f, 0.f),
    C_Vertex3f(0.310537815f, 0.39668262f, 0.f),
    C_Vertex3f(0.310537815f, 0.39668262f, -1.f),
    C_Normal3f(-0.66869837f, 0.74353379f, 0.f),
    C_Vertex3f(0.318244934f, 0.402933598f, 0.f),
    C_Vertex3f(0.318244934f, 0.402933598f, -1.f),
    C_Normal3f(-0.736915588f, 0.675984859f, 0.f),
    C_Vertex3f(0.325431824f, 0.410077572f, 0.f),
    C_Vertex3f(0.325431824f, 0.410077572f, -1.f),
    C_Normal3f(-0.798562229f, 0.60191226f, 0.f),
    C_Vertex3f(0.331720352f, 0.417623639f, 0.f),
    C_Vertex3f(0.331720352f, 0.417623639f, -1.f),
    C_Normal3f(-0.855101407f, 0.51846087f, 0.f),
    C_Vertex3f(0.337110519f, 0.425571799f, 0.f),
    C_Vertex3f(0.337110519f, 0.425571799f, -1.f),
    C_Normal3f(-0.904064357f, 0.427396268f, 0.f),
    C_Vertex3f(0.341602325f, 0.433922052f, 0.f),
    C_Vertex3f(0.341602325f, 0.433922052f, -1.f),
    C_Normal3f(-0.943510234f, 0.331343174f, 0.f),
    C_Vertex3f(0.34519577f, 0.442674398f, 0.f),
    C_Vertex3f(0.34519577f, 0.442674398f, -1.f),
    C_Normal3f(-0.972373486f, 0.233430594f, 0.f),
    C_Vertex3f(0.347890854f, 0.451828837f, 0.f),
    C_Vertex3f(0.347890854f, 0.451828837f, -1.f),
    C_Normal3f(-0.990598202f, 0.136803657f, 0.f),
    C_Vertex3f(0.349687576f, 0.461385369f, 0.f),
    C_Vertex3f(0.349687576f, 0.461385369f, -1.f),
    C_Normal3f(-0.999044776f, 0.0437001996f, 0.f),
    C_Vertex3f(0.350585938f, 0.471343994f, 0.f),
    C_Vertex3f(0.350585938f, 0.471343994f, -1.f),
    C_Normal3f(-0.999025285f, -0.0441413634f, 0.f),
    C_Vertex3f(0.350585938f, 0.481923103f, 0.f),
    C_Vertex3f(0.350585938f, 0.481923103f, -1.f),
    C_Normal3f(-0.990781069f, -0.135472938f, 0.f),
    C_Vertex3f(0.349660397f, 0.492291212f, 0.f),
    C_Vertex3f(0.349660397f, 0.492291212f, -1.f),
    C_Normal3f(-0.972837567f, -0.231488854f, 0.f),
    C_Vertex3f(0.347809315f, 0.502229929f, 0.f),
    C_Vertex3f(0.347809315f, 0.502229929f, -1.f),
    C_Normal3f(-0.944292367f, -0.329107732f, 0.f),
    C_Vertex3f(0.345032692f, 0.511739254f, 0.f),
    C_Vertex3f(0.345032692f, 0.511739254f, -1.f),
    C_Normal3f(-0.905091584f, -0.425216705f, 0.f),
    C_Vertex3f(0.341330528f, 0.520819187f, 0.f),
    C_Vertex3f(0.341330528f, 0.520819187f, -1.f),
    C_Normal3f(-0.856193066f, -0.516655922f, 0.f),
    C_Vertex3f(0.336702824f, 0.529469728f, 0.f),
    C_Vertex3f(0.336702824f, 0.529469728f, -1.f),
    C_Normal3f(-0.799464047f, -0.600713968f, 0.f),
    C_Vertex3f(0.331149578f, 0.537690878f, 0.f),
    C_Vertex3f(0.331149578f, 0.537690878f, -1.f),
    C_Normal3f(-0.737352014f, -0.675508678f, 0.f),
    C_Vertex3f(0.324670792f, 0.545482635f, 0.f),
    C_Vertex3f(0.324670792f, 0.545482635f, -1.f),
    C_Normal3f(-0.670502663f, -0.74190712f, 0.f),
    C_Vertex3f(0.317266464f, 0.552845001f, 0.f),
    C_Vertex3f(0.317266464f, 0.552845001f, -1.f),
    C_Normal3f(-0.593919098f, -0.804524839f, 0.f),
    C_Vertex3f(0.309396267f, 0.559287071f, 0.f),
    C_Vertex3f(0.309396267f, 0.559287071f, -1.f),
    C_Normal3f(-0.508589685f, -0.861009061f, 0.f),
    C_Vertex3f(0.3010602f, 0.564808846f, 0.f),
    C_Vertex3f(0.3010602f, 0.564808846f, -1.f),
    C_Normal3f(-0.416683614f, -0.909051538f, 0.f),
    C_Vertex3f(0.292258263f, 0.569410324f, 0.f),
    C_Vertex3f(0.292258263f, 0.569410324f, -1.f),
    C_Normal3f(-0.321079046f, -0.947052419f, 0.f),
    C_Vertex3f(0.282990456f, 0.573091507f, 0.f),
    C_Vertex3f(0.282990456f, 0.573091507f, -1.f),
    C_Normal3f(-0.224929318f, -0.974375129f, 0.f),
    C_Vertex3f(0.273256779f, 0.575852394f, 0.f),
    C_Vertex3f(0.273256779f, 0.575852394f, -1.f),
    C_Normal3f(-0.13117826f, -0.991358757f, 0.f),
    C_Vertex3f(0.263057232f, 0.577692986f, 0.f),
    C_Vertex3f(0.263057232f, 0.577692986f, -1.f),
    C_Normal3f(-0.0420794412f, -0.999114215f, 0.f),
    C_Vertex3f(0.252391815f, 0.578613281f, 0.f),
    C_Vertex3f(0.252391815f, 0.578613281f, -1.f),
    C_Normal3f(0.0409781486f, -0.999159992f, 0.f),
    C_Vertex3f(0.241206169f, 0.578613281f, 0.f),
    C_Vertex3f(0.241206169f, 0.578613281f, -1.f),
    C_Normal3f(0.127365947f, -0.9918558f, 0.f),
    C_Vertex3f(0.230452418f, 0.57771349f, 0.f),
    C_Vertex3f(0.230452418f, 0.57771349f, -1.f),
    C_Normal3f(0.218955949f, -0.97573477f, 0.f),
    C_Vertex3f(0.220184922f, 0.575913906f, 0.f),
    C_Vertex3f(0.220184922f, 0.575913906f, -1.f),
    C_Normal3f(0.313529462f, -0.949578464f, 0.f),
    C_Vertex3f(0.210403681f, 0.573214531f, 0.f),
    C_Vertex3f(0.210403681f, 0.573214531f, -1.f),
    C_Normal3f(0.408327997f, -0.9128353f, 0.f),
    C_Vertex3f(0.201108694f, 0.569615364f, 0.f),
    C_Vertex3f(0.201108694f, 0.569615364f, -1.f),
    C_Normal3f(0.50026536f, -0.865872085f, 0.f),
    C_Vertex3f(0.192299962f, 0.565116405f, 0.f),
    C_Vertex3f(0.192299962f, 0.565116405f, -1.f),
    C_Normal3f(0.5863837f, -0.8100335f, 0.f),
    C_Vertex3f(0.183977485f, 0.559717655f, 0.f),
    C_Vertex3f(0.183977485f, 0.559717655f, -1.f),
    C_Normal3f(0.664309919f, -0.747457206f, 0.f),
    C_Vertex3f(0.176141262f, 0.553419113f, 0.f),
    C_Vertex3f(0.176141262f, 0.553419113f, -1.f),
    C_Normal3f(0.730723977f, -0.682673156f, 0.f),
    C_Vertex3f(0.168791294f, 0.546220779f, 0.f),
    C_Vertex3f(0.168791294f, 0.546220779f, -1.f),
    C_Normal3f(0.791355908f, -0.611355841f, 0.f),
    C_Vertex3f(0.162360072f, 0.538667917f, 0.f),
    C_Vertex3f(0.162360072f, 0.538667917f, -1.f),
    C_Normal3f(0.847989142f, -0.530013502f, 0.f),
    C_Vertex3f(0.156847596f, 0.530760527f, 0.f),
    C_Vertex3f(0.156847596f, 0.530760527f, -1.f),
    C_Normal3f(0.898025692f, -0.439942896f, 0.f),
    C_Vertex3f(0.152253866f, 0.522498608f, 0.f),
    C_Vertex3f(0.152253866f, 0.522498608f, -1.f),
    C_Normal3f(0.93917793f, -0.343430758f, 0.f),
    C_Vertex3f(0.148578882f, 0.51388216f, 0.f),
    C_Vertex3f(0.148578882f, 0.51388216f, -1.f),
    C_Normal3f(0.969897449f, -0.243513882f, 0.f),
    C_Vertex3f(0.145822644f, 0.504911184f, 0.f),
    C_Vertex3f(0.145822644f, 0.504911184f, -1.f),
    C_Normal3f(0.98964721f, -0.143521503f, 0.f),
    C_Vertex3f(0.143985152f, 0.49558568f, 0.f),
    C_Vertex3f(0.143985152f, 0.49558568f, -1.f),
    C_Normal3f(0.998984277f, -0.045059707f, 0.f),
    C_Vertex3f(0.143066406f, 0.485905647f, 0.f),
    C_Vertex3f(0.143066406f, 0.485905647f, -1.f),
    C_End(),
    C_Begin(GL_QUAD_STRIP),
    C_Normal3f(0.999213278f, -0.0396613367f, 0.f),
    C_Vertex3f(0.1171875f, 0.191793442f, 0.f),
    C_Vertex3f(0.1171875f, 0.191793442f, -1.f),
    C_Normal3f(0.998095453f, 0.0616884455f, 0.f),
    C_Vertex3f(0.1171875f, 0.176486969f, 0.f),
    C_Vertex3f(0.1171875f, 0.176486969f, -1.f),
    C_Normal3f(0.984206617f, 0.1770235f, 0.f),
    C_Vertex3f(0.119157314f, 0.1599226f, 0.f),
    C_Vertex3f(0.119157314f, 0.1599226f, -1.f),
    C_Normal3f(0.956539273f, 0.291603714f, 0.f),
    C_Vertex3f(0.123096943f, 0.143631935f, 0.f),
    C_Vertex3f(0.123096943f, 0.143631935f, -1.f),
    C_Normal3f(0.917282045f, 0.398238093f, 0.f),
    C_Vertex3f(0.129006386f, 0.127614975f, 0.f),
    C_Vertex3f(0.129006386f, 0.127614975f, -1.f),
    C_Normal3f(0.858837605f, 0.51224798f, 0.f),
    C_Vertex3f(0.136885643f, 0.111871719f, 0.f),
    C_Vertex3f(0.136885643f, 0.111871719f, -1.f),
    C_Normal3f(0.770438612f, 0.637514293f, 0.f),
    C_Vertex3f(0.146726608f, 0.097905159f, 0.f),
    C_Vertex3f(0.146726608f, 0.097905159f, -1.f),
    C_Normal3f(0.662344098f, 0.749199748f, 0.f),
    C_Vertex3f(0.158529282f, 0.0857152939f, 0.f),
    C_Vertex3f(0.158529282f, 0.0857152939f, -1.f),
    C_Normal3f(0.542600095f, 0.839991152f, 0.f),
    C_Vertex3f(0.172293663f, 0.075302124f, 0.f),
    C_Vertex3f(0.172293663f, 0.075302124f, -1.f),
    C_Normal3f(0.426683724f, 0.904400945f, 0.f),
    C_Vertex3f(0.188019753f, 0.0666656494f, 0.f),
    C_Vertex3f(0.188019753f, 0.0666656494f, -1.f),
    C_Normal3f(0.309216678f, 0.950991571f, 0.f),
    C_Vertex3f(0.204329014f, 0.0601882935f, 0.f),
    C_Vertex3f(0.204329014f, 0.0601882935f, -1.f),
    C_Normal3f(0.185209617f, 0.982699037f, 0.f),
    C_Vertex3f(0.221221447f, 0.0558700562f, 0.f),
    C_Vertex3f(0.221221447f, 0.0558700562f, -1.f),
    C_Normal3f(0.0642191693f, 0.997935891f, 0.f),
    C_Vertex3f(0.238697052f, 0.0537109375f, 0.f),
    C_Vertex3f(0.238697052f, 0.0537109375f, -1.f),
    C_Normal3f(-0.0383617431f, 0.999263942f, 0.f),
    C_Vertex3f(0.25477314f, 0.0537109375f, 0.f),
    C_Vertex3f(0.25477314f, 0.0537109375f, -1.f),
    C_Normal3f(-0.128235176f, 0.991743803f, 0.f),
    C_Vertex3f(0.268243194f, 0.0548452139f, 0.f),
    C_Vertex3f(0.268243194f, 0.0548452139f, -1.f),
    C_Normal3f(-0.220645785f, 0.975354075f, 0.f),
    C_Vertex3f(0.281089902f, 0.0571137667f, 0.f),
    C_Vertex3f(0.281089902f, 0.0571137667f, -1.f),
    C_Normal3f(-0.316185027f, 0.948697507f, 0.f),
    C_Vertex3f(0.293313265f, 0.0605165958f, 0.f),
    C_Vertex3f(0.293313265f, 0.0605165958f, -1.f),
    C_Normal3f(-0.412007838f, 0.911180317f, 0.f),
    C_Vertex3f(0.304913282f, 0.0650537014f, 0.f),
    C_Vertex3f(0.304913282f, 0.0650537014f, -1.f),
    C_Normal3f(-0.504913568f, 0.863169909f, 0.f),
    C_Vertex3f(0.315889955f, 0.0707250834f, 0.f),
    C_Vertex3f(0.315889955f, 0.0707250834f, -1.f),
    C_Normal3f(-0.591829062f, 0.806063533f, 0.f),
    C_Vertex3f(0.326243281f, 0.0775307417f, 0.f),
    C_Vertex3f(0.326243281f, 0.0775307417f, -1.f),
    C_Normal3f(-0.670295537f, 0.742094278f, 0.f),
    C_Vertex3f(0.335973263f, 0.0854706764f, 0.f),
    C_Vertex3f(0.335973263f, 0.0854706764f, -1.f),
    C_Normal3f(-0.739600837f, 0.673045754f, 0.f),
    C_Vertex3f(0.345079899f, 0.0945448875f, 0.f),
    C_Vertex3f(0.345079899f, 0.0945448875f, -1.f),
    C_Normal3f(-0.80378139f, 0.594924808f, 0.f),
    C_Vertex3f(0.353048205f, 0.104234099f, 0.f),
    C_Vertex3f(0.353048205f, 0.104234099f, -1.f),
    C_Normal3f(-0.861272812f, 0.508142948f, 0.f),
    C_Vertex3f(0.359878182f, 0.114538312f, 0.f),
    C_Vertex3f(0.359878182f, 0.114538312f, -1.f),
    C_Normal3f(-0.909772396f, 0.415107518f, 0.f),
    C_Vertex3f(0.36556983f, 0.125457525f, 0.f),
    C_Vertex3f(0.36556983f, 0.125457525f, -1.f),
    C_Normal3f(-0.947793186f, 0.318885714f, 0.f),
    C_Vertex3f(0.370123148f, 0.136991739f, 0.f),
    C_Vertex3f(0.370123148f, 0.136991739f, -1.f),
    C_Normal3f(-0.974882782f, 0.222718805f, 0.f),
    C_Vertex3f(0.373538136f, 0.149140954f, 0.f),
    C_Vertex3f(0.373538136f, 0.149140954f, -1.f),
    C_Normal3f(-0.991576195f, 0.129524738f, 0.f),
    C_Vertex3f(0.375814795f, 0.161905169f, 0.f),
    C_Vertex3f(0.375814795f, 0.161905169f, -1.f),
    C_Normal3f(-0.999143362f, 0.0413837656f, 0.f),
    C_Vertex3f(0.376953125f, 0.175284386f, 0.f),
    C_Vertex3f(0.376953125f, 0.175284386f, -1.f),
    C_Normal3f(-0.999105573f, -0.0422843359f, 0.f),
    C_Vertex3f(0.376953125f, 0.189388275f, 0.f),
    C_Vertex3f(0.376953125f, 0.189388275f, -1.f),
    C_Normal3f(-0.991359115f, -0.131175563f, 0.f),
    C_Vertex3f(0.375780702f, 0.202986717f, 0.f),
    C_Vertex3f(0.375780702f, 0.202986717f, -1.f),
    C_Normal3f(-0.97429204f, -0.225288779f, 0.f),
    C_Vertex3f(0.373435855f, 0.215970039f, 0.f),
    C_Vertex3f(0.373435855f, 0.215970039f, -1.f),
    C_Normal3f(-0.946704209f, -0.322104186f, 0.f),
    C_Vertex3f(0.369918585f, 0.228338242f, 0.f),
    C_Vertex3f(0.369918585f, 0.228338242f, -1.f),
    C_Normal3f(-0.908159852f, -0.418623537f, 0.f),
    C_Vertex3f(0.365228891f, 0.240091324f, 0.f),
    C_Vertex3f(0.365228891f, 0.240091324f, -1.f),
    C_Normal3f(-0.859234989f, -0.511581123f, 0.f),
    C_Vertex3f(0.359366775f, 0.251229286f, 0.f),
    C_Vertex3f(0.359366775f, 0.251229286f, -1.f),
    C_Normal3f(-0.801530659f, -0.597953737f, 0.f),
    C_Vertex3f(0.352332234f, 0.261752129f, 0.f),
    C_Vertex3f(0.352332234f, 0.261752129f, -1.f),
    C_Normal3f(-0.737420917f, -0.675433457f, 0.f),
    C_Vertex3f(0.344125271f, 0.271659851f, 0.f),
    C_Vertex3f(0.344125271f, 0.271659851f, -1.f),
    C_Normal3f(-0.66892606f, -0.743328929f, 0.f),
    C_Vertex3f(0.334745884f, 0.280952454f, 0.f),
    C_Vertex3f(0.334745884f, 0.280952454f, -1.f),
    C_Normal3f(-0.591817081f, -0.806072295f, 0.f),
    C_Vertex3f(0.324763656f, 0.289083481f, 0.f),
    C_Vertex3f(0.324763656f, 0.289083481f, -1.f),
    C_Normal3f(-0.506127954f, -0.862458408f, 0.f),
    C_Vertex3f(0.314178586f, 0.296052933f, 0.f),
    C_Vertex3f(0.314178586f, 0.296052933f, -1.f),
    C_Normal3f(-0.41410926f, -0.910227239f, 0.f),
    C_Vertex3f(0.302990675f, 0.301860809f, 0.f),
    C_Vertex3f(0.302990675f, 0.301860809f, -1.f),
    C_Normal3f(-0.318681031f, -0.947862089f, 0.f),
    C_Vertex3f(0.291199923f, 0.306507111f, 0.f),
    C_Vertex3f(0.291199923f, 0.306507111f, -1.f),
    C_Normal3f(-0.222986847f, -0.974821389f, 0.f),
    C_Vertex3f(0.278806329f, 0.309991837f, 0.f),
    C_Vertex3f(0.278806329f, 0.309991837f, -1.f),
    C_Normal3f(-0.129915431f, -0.991525114f, 0.f),
    C_Vertex3f(0.265809894f, 0.312314987f, 0.f),
    C_Vertex3f(0.265809894f, 0.312314987f, -1.f),
    C_Normal3f(-0.041990649f, -0.99911803f, 0.f),
    C_Vertex3f(0.252210617f, 0.313476563f, 0.f),
    C_Vertex3f(0.252210617f, 0.313476563f, -1.f),
    C_Normal3f(0.0419951305f, -0.999117851f, 0.f),
    C_Vertex3f(0.238171577f, 0.313476563f, 0.f),
    C_Vertex3f(0.238171577f, 0.313476563f, -1.f),
    C_Normal3f(0.131596208f, -0.991303444f, 0.f),
    C_Vertex3f(0.224898577f, 0.312328577f, 0.f),
    C_Vertex3f(0.224898577f, 0.312328577f, -1.f),
    C_Normal3f(0.226031855f, -0.974119842f, 0.f),
    C_Vertex3f(0.212228537f, 0.310032606f, 0.f),
    C_Vertex3f(0.212228537f, 0.310032606f, -1.f),
    C_Normal3f(0.323174655f, -0.946339369f, 0.f),
    C_Vertex3f(0.200161457f, 0.30658865f, 0.f),
    C_Vertex3f(0.200161457f, 0.30658865f, -1.f),
    C_Normal3f(0.419992745f, -0.907527387f, 0.f),
    C_Vertex3f(0.188697338f, 0.301996708f, 0.f),
    C_Vertex3f(0.188697338f, 0.301996708f, -1.f),
    C_Normal3f(0.51318711f, -0.858276784f, 0.f),
    C_Vertex3f(0.17783618f, 0.296256781f, 0.f),
    C_Vertex3f(0.17783618f, 0.296256781f, -1.f),
    C_Normal3f(0.599710226f, -0.800217211f, 0.f),
    C_Vertex3f(0.167577982f, 0.289368868f, 0.f),
    C_Vertex3f(0.167577982f, 0.289368868f, -1.f),
    C_Normal3f(0.677245438f, -0.735757232f, 0.f),
    C_Vertex3f(0.157922745f, 0.28133297f, 0.f),
    C_Vertex3f(0.157922745f, 0.28133297f, -1.f),
    C_Normal3f(0.744748056f, -0.667345703f, 0.f),
    C_Vertex3f(0.148870468f, 0.272149086f, 0.f),
    C_Vertex3f(0.148870468f, 0.272149086f, -1.f),
    C_Normal3f(0.8068313f, -0.590781927f, 0.f),
    C_Vertex3f(0.140949726f, 0.262391329f, 0.f),
    C_Vertex3f(0.140949726f, 0.262391329f, -1.f),
    C_Normal3f(0.862741828f, -0.505644679f, 0.f),
    C_Vertex3f(0.134160519f, 0.252059698f, 0.f),
    C_Vertex3f(0.134160519f, 0.252059698f, -1.f),
    C_Normal3f(0.910230637f, -0.41410166f, 0.f),
    C_Vertex3f(0.128502846f, 0.241154194f, 0.f),
    C_Vertex3f(0.128502846f, 0.241154194f, -1.f),
    C_Normal3f(0.947754502f, -0.319000423f, 0.f),
    C_Vertex3f(0.123976707f, 0.229674816f, 0.f),
    C_Vertex3f(0.123976707f, 0.229674816f, -1.f),
    C_Normal3f(0.974717259f, -0.223441944f, 0.f),
    C_Vertex3f(0.120582104f, 0.217621565f, 0.f),
    C_Vertex3f(0.120582104f, 0.217621565f, -1.f),
    C_Normal3f(0.991473377f, -0.130309865f, 0.f),
    C_Vertex3f(0.118319035f, 0.20499444f, 0.f),
    C_Vertex3f(0.118319035f, 0.20499444f, -1.f),
    C_Normal3f(0.999213278f, -0.0396613367f, 0.f),
    C_Vertex3f(0.1171875f, 0.191793442f, 0.f),
    C_Vertex3f(0.1171875f, 0.191793442f, -1.f),
    C_End(),
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.158699036f, 0.347679138f, 0.f),
    C_Vertex3f(0.151340485f, 0.345767021f, 0.f),
    C_Vertex3f(0.157922745f, 0.28133297f, 0.f),
    C_Vertex3f(0.167577982f, 0.289368868f, 0.f),
    C_Vertex3f(0.162074685f, 0.418038607f, 0.f),
    C_Vertex3f(0.156643748f, 0.426273108f, 0.f),
    C_Vertex3f(0.152117968f, 0.435025692f, 0.f),
    C_Vertex3f(0.148497343f, 0.44429636f, 0.f),
    C_Vertex3f(0.146392822f, 0.352151871f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.146392822f, 0.352151871f, 0.f),
    C_Vertex3f(0.148497343f, 0.44429636f, 0.f),
    C_Vertex3f(0.145781875f, 0.454085112f, 0.f),
    C_Vertex3f(0.143971562f, 0.464391947f, 0.f),
    C_Vertex3f(0.143066406f, 0.475216866f, 0.f),
    C_Vertex3f(0.13205409f, 0.61185658f, 0.f),
    C_Vertex3f(0.124967098f, 0.363005638f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.118471146f, 0.601453304f, 0.f),
    C_Vertex3f(0.105924606f, 0.589563847f, 0.f),
    C_Vertex3f(0.106728077f, 0.375767708f, 0.f),
    C_Vertex3f(0.124967098f, 0.363005638f, 0.f),
    C_Vertex3f(0.13205409f, 0.61185658f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.0776948929f, 0.549723387f, 0.f),
    C_Vertex3f(0.0798101425f, 0.407016754f, 0.f),
    C_Vertex3f(0.0855364799f, 0.563698888f, 0.f),
    C_Vertex3f(0.0916757584f, 0.39043808f, 0.f),
    C_Vertex3f(0.0949463844f, 0.576979041f, 0.f),
    C_Vertex3f(0.106728077f, 0.375767708f, 0.f),
    C_Vertex3f(0.105924606f, 0.589563847f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.0635800362f, 0.503624797f, 0.f),
    C_Vertex3f(0.0649781227f, 0.445086479f, 0.f),
    C_Vertex3f(0.066716671f, 0.519686341f, 0.f),
    C_Vertex3f(0.0709109306f, 0.425232887f, 0.f),
    C_Vertex3f(0.0714216232f, 0.535052538f, 0.f),
    C_Vertex3f(0.0798101425f, 0.407016754f, 0.f),
    C_Vertex3f(0.0776948929f, 0.549723387f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.0620117188f, 0.486867905f, 0.f),
    C_Vertex3f(0.0620117188f, 0.46657753f, 0.f),
    C_Vertex3f(0.0649781227f, 0.445086479f, 0.f),
    C_Vertex3f(0.0635800362f, 0.503624797f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.452218533f, 0.232228994f, 0.f),
    C_Vertex3f(0.452562571f, 0.134429336f, 0.f),
    C_Vertex3f(0.455113173f, 0.218924403f, 0.f),
    C_Vertex3f(0.456192732f, 0.153332829f, 0.f),
    C_Vertex3f(0.457042933f, 0.205100656f, 0.f),
    C_Vertex3f(0.458007813f, 0.173055649f, 0.f),
    C_Vertex3f(0.458007813f, 0.190757751f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.437745333f, 0.269027829f, 0.f),
    C_Vertex3f(0.439857006f, 0.0990803242f, 0.f),
    C_Vertex3f(0.443534613f, 0.257280707f, 0.f),
    C_Vertex3f(0.447117329f, 0.116345167f, 0.f),
    C_Vertex3f(0.448359013f, 0.245014429f, 0.f),
    C_Vertex3f(0.452562571f, 0.134429336f, 0.f),
    C_Vertex3f(0.452218533f, 0.232228994f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.405185461f, 0.310169578f, 0.f),
    C_Vertex3f(0.407185555f, 0.0522017479f, 0.f),
    C_Vertex3f(0.414670229f, 0.300935864f, 0.f),
    C_Vertex3f(0.419891119f, 0.0670086145f, 0.f),
    C_Vertex3f(0.423272133f, 0.290964603f, 0.f),
    C_Vertex3f(0.430781603f, 0.0826348066f, 0.f),
    C_Vertex3f(0.430991173f, 0.280255795f, 0.f),
    C_Vertex3f(0.439857006f, 0.0990803242f, 0.f),
    C_Vertex3f(0.437745333f, 0.269027829f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.376953125f, 0.189388275f, 0.f),
    C_Vertex3f(0.376997709f, 0.0259751081f, 0.f),
    C_Vertex3f(0.383567333f, 0.32642436f, 0.f),
    C_Vertex3f(0.392664909f, 0.0382142067f, 0.f),
    C_Vertex3f(0.394817829f, 0.318665743f, 0.f),
    C_Vertex3f(0.407185555f, 0.0522017479f, 0.f),
    C_Vertex3f(0.405185461f, 0.310169578f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.365228891f, 0.240091324f, 0.f),
    C_Vertex3f(0.369918585f, 0.228338242f, 0.f),
    C_Vertex3f(0.371433973f, 0.33344543f, 0.f),
    C_Vertex3f(0.373435855f, 0.215970039f, 0.f),
    C_Vertex3f(0.383567333f, 0.32642436f, 0.f),
    C_Vertex3f(0.375780702f, 0.202986717f, 0.f),
    C_Vertex3f(0.376953125f, 0.189388275f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.365228891f, 0.240091324f, 0.f),
    C_Vertex3f(0.371433973f, 0.33344543f, 0.f),
    C_Vertex3f(0.359366775f, 0.251229286f, 0.f),
    C_Vertex3f(0.358417749f, 0.339728951f, 0.f),
    C_Vertex3f(0.352332234f, 0.261752129f, 0.f),
    C_Vertex3f(0.344518661f, 0.345274925f, 0.f),
    C_Vertex3f(0.344125271f, 0.271659851f, 0.f),
    C_Vertex3f(0.337127686f, 0.347679138f, 0.f),
    C_Vertex3f(0.334745884f, 0.280952454f, 0.f),
    C_Vertex3f(0.337110519f, 0.425571799f, 0.f),
    C_Vertex3f(0.331720352f, 0.417623639f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.302310467f, 0.391324639f, 0.f),
    C_Vertex3f(0.302990675f, 0.301860809f, 0.f),
    C_Vertex3f(0.310537815f, 0.39668262f, 0.f),
    C_Vertex3f(0.314178586f, 0.296052933f, 0.f),
    C_Vertex3f(0.318244934f, 0.402933598f, 0.f),
    C_Vertex3f(0.324763656f, 0.289083481f, 0.f),
    C_Vertex3f(0.325431824f, 0.410077572f, 0.f),
    C_Vertex3f(0.334745884f, 0.280952454f, 0.f),
    C_Vertex3f(0.331720352f, 0.417623639f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.26419878f, 0.378822684f, 0.f),
    C_Vertex3f(0.265809894f, 0.312314987f, 0.f),
    C_Vertex3f(0.274507046f, 0.380608678f, 0.f),
    C_Vertex3f(0.278806329f, 0.309991837f, 0.f),
    C_Vertex3f(0.284295082f, 0.383287668f, 0.f),
    C_Vertex3f(0.291199923f, 0.306507111f, 0.f),
    C_Vertex3f(0.293562889f, 0.386859655f, 0.f),
    C_Vertex3f(0.302990675f, 0.301860809f, 0.f),
    C_Vertex3f(0.302310467f, 0.391324639f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.210159063f, 0.383328438f, 0.f),
    C_Vertex3f(0.212228537f, 0.310032606f, 0.f),
    C_Vertex3f(0.220171332f, 0.380629063f, 0.f),
    C_Vertex3f(0.224898577f, 0.312328577f, 0.f),
    C_Vertex3f(0.230737805f, 0.378829479f, 0.f),
    C_Vertex3f(0.238171577f, 0.313476563f, 0.f),
    C_Vertex3f(0.241858482f, 0.377929688f, 0.f),
    C_Vertex3f(0.252210617f, 0.313476563f, 0.f),
    C_Vertex3f(0.253370285f, 0.377929688f, 0.f),
    C_Vertex3f(0.265809894f, 0.312314987f, 0.f),
    C_Vertex3f(0.26419878f, 0.378822684f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.175652027f, 0.403123856f, 0.f),
    C_Vertex3f(0.17783618f, 0.296256781f, 0.f),
    C_Vertex3f(0.18344748f, 0.396825314f, 0.f),
    C_Vertex3f(0.188697338f, 0.301996708f, 0.f),
    C_Vertex3f(0.191797137f, 0.391426563f, 0.f),
    C_Vertex3f(0.200161457f, 0.30658865f, 0.f),
    C_Vertex3f(0.200700998f, 0.386927605f, 0.f),
    C_Vertex3f(0.212228537f, 0.310032606f, 0.f),
    C_Vertex3f(0.210159063f, 0.383328438f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.168410778f, 0.410322189f, 0.f),
    C_Vertex3f(0.162074685f, 0.418038607f, 0.f),
    C_Vertex3f(0.167577982f, 0.289368868f, 0.f),
    C_Vertex3f(0.17783618f, 0.296256781f, 0.f),
    C_Vertex3f(0.175652027f, 0.403123856f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.128502846f, 0.241154194f, 0.f),
    C_Vertex3f(0.134160519f, 0.252059698f, 0.f),
    C_Vertex3f(0.137467742f, 0.341102719f, 0.f),
    C_Vertex3f(0.140949726f, 0.262391329f, 0.f),
    C_Vertex3f(0.151340485f, 0.345767021f, 0.f),
    C_Vertex3f(0.148870468f, 0.272149086f, 0.f),
    C_Vertex3f(0.157922745f, 0.28133297f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.124439359f, 0.33559835f, 0.f),
    C_Vertex3f(0.112255335f, 0.329253912f, 0.f),
    C_Vertex3f(0.1171875f, 0.191793442f, 0.f),
    C_Vertex3f(0.118319035f, 0.20499444f, 0.f),
    C_Vertex3f(0.120582104f, 0.217621565f, 0.f),
    C_Vertex3f(0.123976707f, 0.229674816f, 0.f),
    C_Vertex3f(0.128502846f, 0.241154194f, 0.f),
    C_Vertex3f(0.137467742f, 0.341102719f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.123096943f, 0.143631935f, 0.f),
    C_Vertex3f(0.119157314f, 0.1599226f, 0.f),
    C_Vertex3f(0.133956671f, 0.0155863762f, 0.f),
    C_Vertex3f(0.1171875f, 0.176486969f, 0.f),
    C_Vertex3f(0.117142916f, 0.0261178017f, 0.f),
    C_Vertex3f(0.1171875f, 0.191793442f, 0.f),
    C_Vertex3f(0.112255335f, 0.329253912f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.101475716f, 0.0384044647f, 0.f),
    C_Vertex3f(0.117142916f, 0.0261178017f, 0.f),
    C_Vertex3f(0.112255335f, 0.329253912f, 0.f),
    C_Vertex3f(0.10091567f, 0.322069407f, 0.f),
    C_Vertex3f(0.0904203653f, 0.314044833f, 0.f),
    C_Vertex3f(0.0869550705f, 0.0524463654f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.0807694197f, 0.305180192f, 0.f),
    C_Vertex3f(0.0719628334f, 0.295475483f, 0.f),
    C_Vertex3f(0.074249506f, 0.0673556328f, 0.f),
    C_Vertex3f(0.0869550705f, 0.0524463654f, 0.f),
    C_Vertex3f(0.0904203653f, 0.314044833f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.0460855961f, 0.249484777f, 0.f),
    C_Vertex3f(0.0470232964f, 0.117287636f, 0.f),
    C_Vertex3f(0.0510619879f, 0.261935353f, 0.f),
    C_Vertex3f(0.0542836189f, 0.099776268f, 0.f),
    C_Vertex3f(0.057033658f, 0.273750663f, 0.f),
    C_Vertex3f(0.0633590221f, 0.083132267f, 0.f),
    C_Vertex3f(0.0640006065f, 0.284930706f, 0.f),
    C_Vertex3f(0.074249506f, 0.0673556328f, 0.f),
    C_Vertex3f(0.0719628334f, 0.295475483f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.0371280909f, 0.208321452f, 0.f),
    C_Vertex3f(0.0379478931f, 0.154912472f, 0.f),
    C_Vertex3f(0.0391186476f, 0.222677827f, 0.f),
    C_Vertex3f(0.0415780544f, 0.13566637f, 0.f),
    C_Vertex3f(0.0421044827f, 0.236398935f, 0.f),
    C_Vertex3f(0.0470232964f, 0.117287636f, 0.f),
    C_Vertex3f(0.0460855961f, 0.249484777f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.0361328125f, 0.193329811f, 0.f),
    C_Vertex3f(0.0361328125f, 0.17502594f, 0.f),
    C_Vertex3f(0.0379478931f, 0.154912472f, 0.f),
    C_Vertex3f(0.0371280909f, 0.208321452f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.376997709f, 0.0259751081f, 0.f),
    C_Vertex3f(0.376953125f, 0.189388275f, 0.f),
    C_Vertex3f(0.376953125f, 0.175284386f, 0.f),
    C_Vertex3f(0.375814795f, 0.161905169f, 0.f),
    C_Vertex3f(0.373538136f, 0.149140954f, 0.f),
    C_Vertex3f(0.370123148f, 0.136991739f, 0.f),
    C_Vertex3f(0.36556983f, 0.125457525f, 0.f),
    C_Vertex3f(0.360183954f, 0.0154844522f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.360183954f, 0.0154844522f, 0.f),
    C_Vertex3f(0.36556983f, 0.125457525f, 0.f),
    C_Vertex3f(0.359878182f, 0.114538312f, 0.f),
    C_Vertex3f(0.353048205f, 0.104234099f, 0.f),
    C_Vertex3f(0.345079899f, 0.0945448875f, 0.f),
    C_Vertex3f(0.342223644f, 0.006742239f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.345079899f, 0.0945448875f, 0.f),
    C_Vertex3f(0.335973263f, 0.0854706764f, 0.f),
    C_Vertex3f(0.342223644f, 0.006742239f, 0.f),
    C_Vertex3f(0.326243281f, 0.0775307417f, 0.f),
    C_Vertex3f(0.323116779f, -0.000251531601f, 0.f),
    C_Vertex3f(0.315889955f, 0.0707250834f, 0.f),
    C_Vertex3f(0.304913282f, 0.0650537014f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.323116779f, -0.000251531601f, 0.f),
    C_Vertex3f(0.304913282f, 0.0650537014f, 0.f),
    C_Vertex3f(0.302863359f, -0.00549685955f, 0.f),
    C_Vertex3f(0.293313265f, 0.0605165958f, 0.f),
    C_Vertex3f(0.281463385f, -0.00899374485f, 0.f),
    C_Vertex3f(0.281089902f, 0.0571137667f, 0.f),
    C_Vertex3f(0.268243194f, 0.0548452139f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.258916855f, -0.0107421875f, 0.f),
    C_Vertex3f(0.281463385f, -0.00899374485f, 0.f),
    C_Vertex3f(0.268243194f, 0.0548452139f, 0.f),
    C_Vertex3f(0.25477314f, 0.0537109375f, 0.f),
    C_Vertex3f(0.238697052f, 0.0537109375f, 0.f),
    C_Vertex3f(0.23522377f, -0.0107421875f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.188019753f, 0.0666656494f, 0.f),
    C_Vertex3f(0.191277266f, -0.00547647476f, 0.f),
    C_Vertex3f(0.204329014f, 0.0601882935f, 0.f),
    C_Vertex3f(0.21267724f, -0.00898694992f, 0.f),
    C_Vertex3f(0.221221447f, 0.0558700562f, 0.f),
    C_Vertex3f(0.23522377f, -0.0107421875f, 0.f),
    C_Vertex3f(0.238697052f, 0.0537109375f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.146726608f, 0.097905159f, 0.f),
    C_Vertex3f(0.151916981f, 0.00681018829f, 0.f),
    C_Vertex3f(0.158529282f, 0.0857152939f, 0.f),
    C_Vertex3f(0.171023846f, -0.000210762024f, 0.f),
    C_Vertex3f(0.172293663f, 0.075302124f, 0.f),
    C_Vertex3f(0.191277266f, -0.00547647476f, 0.f),
    C_Vertex3f(0.188019753f, 0.0666656494f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.136885643f, 0.111871719f, 0.f),
    C_Vertex3f(0.129006386f, 0.127614975f, 0.f),
    C_Vertex3f(0.133956671f, 0.0155863762f, 0.f),
    C_Vertex3f(0.151916981f, 0.00681018829f, 0.f),
    C_Vertex3f(0.146726608f, 0.097905159f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.398132682f, 0.575513005f, 0.f),
    C_Vertex3f(0.386963367f, 0.588336468f, 0.f),
    C_Vertex3f(0.387636662f, 0.375686169f, 0.f),
    C_Vertex3f(0.374198437f, 0.600498676f, 0.f),
    C_Vertex3f(0.369861126f, 0.362978458f, 0.f),
    C_Vertex3f(0.36041081f, 0.611140609f, 0.f),
    C_Vertex3f(0.350585938f, 0.481923103f, 0.f),
    C_Vertex3f(0.349660397f, 0.492291212f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.341330528f, 0.520819187f, 0.f),
    C_Vertex3f(0.345032692f, 0.511739254f, 0.f),
    C_Vertex3f(0.345600486f, 0.620262265f, 0.f),
    C_Vertex3f(0.347809315f, 0.502229929f, 0.f),
    C_Vertex3f(0.36041081f, 0.611140609f, 0.f),
    C_Vertex3f(0.349660397f, 0.492291212f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.317266464f, 0.552845001f, 0.f),
    C_Vertex3f(0.324670792f, 0.545482635f, 0.f),
    C_Vertex3f(0.329767466f, 0.627863646f, 0.f),
    C_Vertex3f(0.331149578f, 0.537690878f, 0.f),
    C_Vertex3f(0.345600486f, 0.620262265f, 0.f),
    C_Vertex3f(0.336702824f, 0.529469728f, 0.f),
    C_Vertex3f(0.341330528f, 0.520819187f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.312911749f, 0.63394475f, 0.f),
    C_Vertex3f(0.295033336f, 0.638505578f, 0.f),
    C_Vertex3f(0.3010602f, 0.564808846f, 0.f),
    C_Vertex3f(0.309396267f, 0.559287071f, 0.f),
    C_Vertex3f(0.317266464f, 0.552845001f, 0.f),
    C_Vertex3f(0.329767466f, 0.627863646f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.263057232f, 0.577692986f, 0.f),
    C_Vertex3f(0.273256779f, 0.575852394f, 0.f),
    C_Vertex3f(0.276132226f, 0.64154613f, 0.f),
    C_Vertex3f(0.282990456f, 0.573091507f, 0.f),
    C_Vertex3f(0.295033336f, 0.638505578f, 0.f),
    C_Vertex3f(0.292258263f, 0.569410324f, 0.f),
    C_Vertex3f(0.3010602f, 0.564808846f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.25620842f, 0.643066406f, 0.f),
    C_Vertex3f(0.235316277f, 0.643066406f, 0.f),
    C_Vertex3f(0.241206169f, 0.578613281f, 0.f),
    C_Vertex3f(0.252391815f, 0.578613281f, 0.f),
    C_Vertex3f(0.263057232f, 0.577692986f, 0.f),
    C_Vertex3f(0.276132226f, 0.64154613f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.201108694f, 0.569615364f, 0.f),
    C_Vertex3f(0.210403681f, 0.573214531f, 0.f),
    C_Vertex3f(0.215514898f, 0.641580224f, 0.f),
    C_Vertex3f(0.220184922f, 0.575913906f, 0.f),
    C_Vertex3f(0.235316277f, 0.643066406f, 0.f),
    C_Vertex3f(0.230452418f, 0.57771349f, 0.f),
    C_Vertex3f(0.241206169f, 0.578613281f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.196749926f, 0.63860786f, 0.f),
    C_Vertex3f(0.179021358f, 0.634149313f, 0.f),
    C_Vertex3f(0.183977485f, 0.559717655f, 0.f),
    C_Vertex3f(0.192299962f, 0.565116405f, 0.f),
    C_Vertex3f(0.201108694f, 0.569615364f, 0.f),
    C_Vertex3f(0.215514898f, 0.641580224f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.179021358f, 0.634149313f, 0.f),
    C_Vertex3f(0.162329197f, 0.628204584f, 0.f),
    C_Vertex3f(0.162360072f, 0.538667917f, 0.f),
    C_Vertex3f(0.168791294f, 0.546220779f, 0.f),
    C_Vertex3f(0.176141262f, 0.553419113f, 0.f),
    C_Vertex3f(0.183977485f, 0.559717655f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.162329197f, 0.628204584f, 0.f),
    C_Vertex3f(0.146673441f, 0.620773673f, 0.f),
    C_Vertex3f(0.148578882f, 0.51388216f, 0.f),
    C_Vertex3f(0.152253866f, 0.522498608f, 0.f),
    C_Vertex3f(0.156847596f, 0.530760527f, 0.f),
    C_Vertex3f(0.162360072f, 0.538667917f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.146673441f, 0.620773673f, 0.f),
    C_Vertex3f(0.13205409f, 0.61185658f, 0.f),
    C_Vertex3f(0.143066406f, 0.485905647f, 0.f),
    C_Vertex3f(0.143985152f, 0.49558568f, 0.f),
    C_Vertex3f(0.145822644f, 0.504911184f, 0.f),
    C_Vertex3f(0.148578882f, 0.51388216f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.422066927f, 0.533075094f, 0.f),
    C_Vertex3f(0.422861576f, 0.42466116f, 0.f),
    C_Vertex3f(0.426853776f, 0.517606616f, 0.f),
    C_Vertex3f(0.428714275f, 0.444023609f, 0.f),
    C_Vertex3f(0.430045009f, 0.501476884f, 0.f),
    C_Vertex3f(0.431640625f, 0.464832306f, 0.f),
    C_Vertex3f(0.431640625f, 0.484685898f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.398132682f, 0.575513005f, 0.f),
    C_Vertex3f(0.402377129f, 0.390275002f, 0.f),
    C_Vertex3f(0.40770638f, 0.562028289f, 0.f),
    C_Vertex3f(0.414082527f, 0.406744957f, 0.f),
    C_Vertex3f(0.415684462f, 0.547882318f, 0.f),
    C_Vertex3f(0.422861576f, 0.42466116f, 0.f),
    C_Vertex3f(0.422066927f, 0.533075094f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.350585938f, 0.481923103f, 0.f),
    C_Vertex3f(0.350585938f, 0.471343994f, 0.f),
    C_Vertex3f(0.369861126f, 0.362978458f, 0.f),
    C_Vertex3f(0.349687576f, 0.461385369f, 0.f),
    C_Vertex3f(0.349050522f, 0.352151871f, 0.f),
    C_Vertex3f(0.347890854f, 0.451828837f, 0.f),
    C_Vertex3f(0.34519577f, 0.442674398f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.341602325f, 0.433922052f, 0.f),
    C_Vertex3f(0.337110519f, 0.425571799f, 0.f),
    C_Vertex3f(0.337127686f, 0.347679138f, 0.f),
    C_Vertex3f(0.349050522f, 0.352151871f, 0.f),
    C_Vertex3f(0.34519577f, 0.442674398f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.398132682f, 0.575513005f, 0.f),
    C_Vertex3f(0.387636662f, 0.375686169f, 0.f),
    C_Vertex3f(0.402377129f, 0.390275002f, 0.f),
    C_Vertex3f(0.143066406f, 0.485905647f, 0.f),
    C_Vertex3f(0.13205409f, 0.61185658f, 0.f),
    C_Vertex3f(0.143066406f, 0.475216866f, 0.f),
    C_Vertex3f(0.123096943f, 0.143631935f, 0.f),
    C_Vertex3f(0.133956671f, 0.0155863762f, 0.f),
    C_Vertex3f(0.129006386f, 0.127614975f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, -1.f),
    C_FrontFace(GL_CW),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.158699036f, 0.347679138f, -1.f),
    C_Vertex3f(0.151340485f, 0.345767021f, -1.f),
    C_Vertex3f(0.157922745f, 0.28133297f, -1.f),
    C_Vertex3f(0.167577982f, 0.289368868f, -1.f),
    C_Vertex3f(0.162074685f, 0.418038607f, -1.f),
    C_Vertex3f(0.156643748f, 0.426273108f, -1.f),
    C_Vertex3f(0.152117968f, 0.435025692f, -1.f),
    C_Vertex3f(0.148497343f, 0.44429636f, -1.f),
    C_Vertex3f(0.146392822f, 0.352151871f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.146392822f, 0.352151871f, -1.f),
    C_Vertex3f(0.148497343f, 0.44429636f, -1.f),
    C_Vertex3f(0.145781875f, 0.454085112f, -1.f),
    C_Vertex3f(0.143971562f, 0.464391947f, -1.f),
    C_Vertex3f(0.143066406f, 0.475216866f, -1.f),
    C_Vertex3f(0.13205409f, 0.61185658f, -1.f),
    C_Vertex3f(0.124967098f, 0.363005638f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.118471146f, 0.601453304f, -1.f),
    C_Vertex3f(0.105924606f, 0.589563847f, -1.f),
    C_Vertex3f(0.106728077f, 0.375767708f, -1.f),
    C_Vertex3f(0.124967098f, 0.363005638f, -1.f),
    C_Vertex3f(0.13205409f, 0.61185658f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.0776948929f, 0.549723387f, -1.f),
    C_Vertex3f(0.0798101425f, 0.407016754f, -1.f),
    C_Vertex3f(0.0855364799f, 0.563698888f, -1.f),
    C_Vertex3f(0.0916757584f, 0.39043808f, -1.f),
    C_Vertex3f(0.0949463844f, 0.576979041f, -1.f),
    C_Vertex3f(0.106728077f, 0.375767708f, -1.f),
    C_Vertex3f(0.105924606f, 0.589563847f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.0635800362f, 0.503624797f, -1.f),
    C_Vertex3f(0.0649781227f, 0.445086479f, -1.f),
    C_Vertex3f(0.066716671f, 0.519686341f, -1.f),
    C_Vertex3f(0.0709109306f, 0.425232887f, -1.f),
    C_Vertex3f(0.0714216232f, 0.535052538f, -1.f),
    C_Vertex3f(0.0798101425f, 0.407016754f, -1.f),
    C_Vertex3f(0.0776948929f, 0.549723387f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.0620117188f, 0.486867905f, -1.f),
    C_Vertex3f(0.0620117188f, 0.46657753f, -1.f),
    C_Vertex3f(0.0649781227f, 0.445086479f, -1.f),
    C_Vertex3f(0.0635800362f, 0.503624797f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.452218533f, 0.232228994f, -1.f),
    C_Vertex3f(0.452562571f, 0.134429336f, -1.f),
    C_Vertex3f(0.455113173f, 0.218924403f, -1.f),
    C_Vertex3f(0.456192732f, 0.153332829f, -1.f),
    C_Vertex3f(0.457042933f, 0.205100656f, -1.f),
    C_Vertex3f(0.458007813f, 0.173055649f, -1.f),
    C_Vertex3f(0.458007813f, 0.190757751f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.437745333f, 0.269027829f, -1.f),
    C_Vertex3f(0.439857006f, 0.0990803242f, -1.f),
    C_Vertex3f(0.443534613f, 0.257280707f, -1.f),
    C_Vertex3f(0.447117329f, 0.116345167f, -1.f),
    C_Vertex3f(0.448359013f, 0.245014429f, -1.f),
    C_Vertex3f(0.452562571f, 0.134429336f, -1.f),
    C_Vertex3f(0.452218533f, 0.232228994f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.405185461f, 0.310169578f, -1.f),
    C_Vertex3f(0.407185555f, 0.0522017479f, -1.f),
    C_Vertex3f(0.414670229f, 0.300935864f, -1.f),
    C_Vertex3f(0.419891119f, 0.0670086145f, -1.f),
    C_Vertex3f(0.423272133f, 0.290964603f, -1.f),
    C_Vertex3f(0.430781603f, 0.0826348066f, -1.f),
    C_Vertex3f(0.430991173f, 0.280255795f, -1.f),
    C_Vertex3f(0.439857006f, 0.0990803242f, -1.f),
    C_Vertex3f(0.437745333f, 0.269027829f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.376953125f, 0.189388275f, -1.f),
    C_Vertex3f(0.376997709f, 0.0259751081f, -1.f),
    C_Vertex3f(0.383567333f, 0.32642436f, -1.f),
    C_Vertex3f(0.392664909f, 0.0382142067f, -1.f),
    C_Vertex3f(0.394817829f, 0.318665743f, -1.f),
    C_Vertex3f(0.407185555f, 0.0522017479f, -1.f),
    C_Vertex3f(0.405185461f, 0.310169578f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.365228891f, 0.240091324f, -1.f),
    C_Vertex3f(0.369918585f, 0.228338242f, -1.f),
    C_Vertex3f(0.371433973f, 0.33344543f, -1.f),
    C_Vertex3f(0.373435855f, 0.215970039f, -1.f),
    C_Vertex3f(0.383567333f, 0.32642436f, -1.f),
    C_Vertex3f(0.375780702f, 0.202986717f, -1.f),
    C_Vertex3f(0.376953125f, 0.189388275f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.365228891f, 0.240091324f, -1.f),
    C_Vertex3f(0.371433973f, 0.33344543f, -1.f),
    C_Vertex3f(0.359366775f, 0.251229286f, -1.f),
    C_Vertex3f(0.358417749f, 0.339728951f, -1.f),
    C_Vertex3f(0.352332234f, 0.261752129f, -1.f),
    C_Vertex3f(0.344518661f, 0.345274925f, -1.f),
    C_Vertex3f(0.344125271f, 0.271659851f, -1.f),
    C_Vertex3f(0.337127686f, 0.347679138f, -1.f),
    C_Vertex3f(0.334745884f, 0.280952454f, -1.f),
    C_Vertex3f(0.337110519f, 0.425571799f, -1.f),
    C_Vertex3f(0.331720352f, 0.417623639f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.302310467f, 0.391324639f, -1.f),
    C_Vertex3f(0.302990675f, 0.301860809f, -1.f),
    C_Vertex3f(0.310537815f, 0.39668262f, -1.f),
    C_Vertex3f(0.314178586f, 0.296052933f, -1.f),
    C_Vertex3f(0.318244934f, 0.402933598f, -1.f),
    C_Vertex3f(0.324763656f, 0.289083481f, -1.f),
    C_Vertex3f(0.325431824f, 0.410077572f, -1.f),
    C_Vertex3f(0.334745884f, 0.280952454f, -1.f),
    C_Vertex3f(0.331720352f, 0.417623639f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.26419878f, 0.378822684f, -1.f),
    C_Vertex3f(0.265809894f, 0.312314987f, -1.f),
    C_Vertex3f(0.274507046f, 0.380608678f, -1.f),
    C_Vertex3f(0.278806329f, 0.309991837f, -1.f),
    C_Vertex3f(0.284295082f, 0.383287668f, -1.f),
    C_Vertex3f(0.291199923f, 0.306507111f, -1.f),
    C_Vertex3f(0.293562889f, 0.386859655f, -1.f),
    C_Vertex3f(0.302990675f, 0.301860809f, -1.f),
    C_Vertex3f(0.302310467f, 0.391324639f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.210159063f, 0.383328438f, -1.f),
    C_Vertex3f(0.212228537f, 0.310032606f, -1.f),
    C_Vertex3f(0.220171332f, 0.380629063f, -1.f),
    C_Vertex3f(0.224898577f, 0.312328577f, -1.f),
    C_Vertex3f(0.230737805f, 0.378829479f, -1.f),
    C_Vertex3f(0.238171577f, 0.313476563f, -1.f),
    C_Vertex3f(0.241858482f, 0.377929688f, -1.f),
    C_Vertex3f(0.252210617f, 0.313476563f, -1.f),
    C_Vertex3f(0.253370285f, 0.377929688f, -1.f),
    C_Vertex3f(0.265809894f, 0.312314987f, -1.f),
    C_Vertex3f(0.26419878f, 0.378822684f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.175652027f, 0.403123856f, -1.f),
    C_Vertex3f(0.17783618f, 0.296256781f, -1.f),
    C_Vertex3f(0.18344748f, 0.396825314f, -1.f),
    C_Vertex3f(0.188697338f, 0.301996708f, -1.f),
    C_Vertex3f(0.191797137f, 0.391426563f, -1.f),
    C_Vertex3f(0.200161457f, 0.30658865f, -1.f),
    C_Vertex3f(0.200700998f, 0.386927605f, -1.f),
    C_Vertex3f(0.212228537f, 0.310032606f, -1.f),
    C_Vertex3f(0.210159063f, 0.383328438f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.168410778f, 0.410322189f, -1.f),
    C_Vertex3f(0.162074685f, 0.418038607f, -1.f),
    C_Vertex3f(0.167577982f, 0.289368868f, -1.f),
    C_Vertex3f(0.17783618f, 0.296256781f, -1.f),
    C_Vertex3f(0.175652027f, 0.403123856f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.128502846f, 0.241154194f, -1.f),
    C_Vertex3f(0.134160519f, 0.252059698f, -1.f),
    C_Vertex3f(0.137467742f, 0.341102719f, -1.f),
    C_Vertex3f(0.140949726f, 0.262391329f, -1.f),
    C_Vertex3f(0.151340485f, 0.345767021f, -1.f),
    C_Vertex3f(0.148870468f, 0.272149086f, -1.f),
    C_Vertex3f(0.157922745f, 0.28133297f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.124439359f, 0.33559835f, -1.f),
    C_Vertex3f(0.112255335f, 0.329253912f, -1.f),
    C_Vertex3f(0.1171875f, 0.191793442f, -1.f),
    C_Vertex3f(0.118319035f, 0.20499444f, -1.f),
    C_Vertex3f(0.120582104f, 0.217621565f, -1.f),
    C_Vertex3f(0.123976707f, 0.229674816f, -1.f),
    C_Vertex3f(0.128502846f, 0.241154194f, -1.f),
    C_Vertex3f(0.137467742f, 0.341102719f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.123096943f, 0.143631935f, -1.f),
    C_Vertex3f(0.119157314f, 0.1599226f, -1.f),
    C_Vertex3f(0.133956671f, 0.0155863762f, -1.f),
    C_Vertex3f(0.1171875f, 0.176486969f, -1.f),
    C_Vertex3f(0.117142916f, 0.0261178017f, -1.f),
    C_Vertex3f(0.1171875f, 0.191793442f, -1.f),
    C_Vertex3f(0.112255335f, 0.329253912f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.101475716f, 0.0384044647f, -1.f),
    C_Vertex3f(0.117142916f, 0.0261178017f, -1.f),
    C_Vertex3f(0.112255335f, 0.329253912f, -1.f),
    C_Vertex3f(0.10091567f, 0.322069407f, -1.f),
    C_Vertex3f(0.0904203653f, 0.314044833f, -1.f),
    C_Vertex3f(0.0869550705f, 0.0524463654f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.0807694197f, 0.305180192f, -1.f),
    C_Vertex3f(0.0719628334f, 0.295475483f, -1.f),
    C_Vertex3f(0.074249506f, 0.0673556328f, -1.f),
    C_Vertex3f(0.0869550705f, 0.0524463654f, -1.f),
    C_Vertex3f(0.0904203653f, 0.314044833f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.0460855961f, 0.249484777f, -1.f),
    C_Vertex3f(0.0470232964f, 0.117287636f, -1.f),
    C_Vertex3f(0.0510619879f, 0.261935353f, -1.f),
    C_Vertex3f(0.0542836189f, 0.099776268f, -1.f),
    C_Vertex3f(0.057033658f, 0.273750663f, -1.f),
    C_Vertex3f(0.0633590221f, 0.083132267f, -1.f),
    C_Vertex3f(0.0640006065f, 0.284930706f, -1.f),
    C_Vertex3f(0.074249506f, 0.0673556328f, -1.f),
    C_Vertex3f(0.0719628334f, 0.295475483f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.0371280909f, 0.208321452f, -1.f),
    C_Vertex3f(0.0379478931f, 0.154912472f, -1.f),
    C_Vertex3f(0.0391186476f, 0.222677827f, -1.f),
    C_Vertex3f(0.0415780544f, 0.13566637f, -1.f),
    C_Vertex3f(0.0421044827f, 0.236398935f, -1.f),
    C_Vertex3f(0.0470232964f, 0.117287636f, -1.f),
    C_Vertex3f(0.0460855961f, 0.249484777f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.0361328125f, 0.193329811f, -1.f),
    C_Vertex3f(0.0361328125f, 0.17502594f, -1.f),
    C_Vertex3f(0.0379478931f, 0.154912472f, -1.f),
    C_Vertex3f(0.0371280909f, 0.208321452f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.376997709f, 0.0259751081f, -1.f),
    C_Vertex3f(0.376953125f, 0.189388275f, -1.f),
    C_Vertex3f(0.376953125f, 0.175284386f, -1.f),
    C_Vertex3f(0.375814795f, 0.161905169f, -1.f),
    C_Vertex3f(0.373538136f, 0.149140954f, -1.f),
    C_Vertex3f(0.370123148f, 0.136991739f, -1.f),
    C_Vertex3f(0.36556983f, 0.125457525f, -1.f),
    C_Vertex3f(0.360183954f, 0.0154844522f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.360183954f, 0.0154844522f, -1.f),
    C_Vertex3f(0.36556983f, 0.125457525f, -1.f),
    C_Vertex3f(0.359878182f, 0.114538312f, -1.f),
    C_Vertex3f(0.353048205f, 0.104234099f, -1.f),
    C_Vertex3f(0.345079899f, 0.0945448875f, -1.f),
    C_Vertex3f(0.342223644f, 0.006742239f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.345079899f, 0.0945448875f, -1.f),
    C_Vertex3f(0.335973263f, 0.0854706764f, -1.f),
    C_Vertex3f(0.342223644f, 0.006742239f, -1.f),
    C_Vertex3f(0.326243281f, 0.0775307417f, -1.f),
    C_Vertex3f(0.323116779f, -0.000251531601f, -1.f),
    C_Vertex3f(0.315889955f, 0.0707250834f, -1.f),
    C_Vertex3f(0.304913282f, 0.0650537014f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.323116779f, -0.000251531601f, -1.f),
    C_Vertex3f(0.304913282f, 0.0650537014f, -1.f),
    C_Vertex3f(0.302863359f, -0.00549685955f, -1.f),
    C_Vertex3f(0.293313265f, 0.0605165958f, -1.f),
    C_Vertex3f(0.281463385f, -0.00899374485f, -1.f),
    C_Vertex3f(0.281089902f, 0.0571137667f, -1.f),
    C_Vertex3f(0.268243194f, 0.0548452139f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.258916855f, -0.0107421875f, -1.f),
    C_Vertex3f(0.281463385f, -0.00899374485f, -1.f),
    C_Vertex3f(0.268243194f, 0.0548452139f, -1.f),
    C_Vertex3f(0.25477314f, 0.0537109375f, -1.f),
    C_Vertex3f(0.238697052f, 0.0537109375f, -1.f),
    C_Vertex3f(0.23522377f, -0.0107421875f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.188019753f, 0.0666656494f, -1.f),
    C_Vertex3f(0.191277266f, -0.00547647476f, -1.f),
    C_Vertex3f(0.204329014f, 0.0601882935f, -1.f),
    C_Vertex3f(0.21267724f, -0.00898694992f, -1.f),
    C_Vertex3f(0.221221447f, 0.0558700562f, -1.f),
    C_Vertex3f(0.23522377f, -0.0107421875f, -1.f),
    C_Vertex3f(0.238697052f, 0.0537109375f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.146726608f, 0.097905159f, -1.f),
    C_Vertex3f(0.151916981f, 0.00681018829f, -1.f),
    C_Vertex3f(0.158529282f, 0.0857152939f, -1.f),
    C_Vertex3f(0.171023846f, -0.000210762024f, -1.f),
    C_Vertex3f(0.172293663f, 0.075302124f, -1.f),
    C_Vertex3f(0.191277266f, -0.00547647476f, -1.f),
    C_Vertex3f(0.188019753f, 0.0666656494f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.136885643f, 0.111871719f, -1.f),
    C_Vertex3f(0.129006386f, 0.127614975f, -1.f),
    C_Vertex3f(0.133956671f, 0.0155863762f, -1.f),
    C_Vertex3f(0.151916981f, 0.00681018829f, -1.f),
    C_Vertex3f(0.146726608f, 0.097905159f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.398132682f, 0.575513005f, -1.f),
    C_Vertex3f(0.386963367f, 0.588336468f, -1.f),
    C_Vertex3f(0.387636662f, 0.375686169f, -1.f),
    C_Vertex3f(0.374198437f, 0.600498676f, -1.f),
    C_Vertex3f(0.369861126f, 0.362978458f, -1.f),
    C_Vertex3f(0.36041081f, 0.611140609f, -1.f),
    C_Vertex3f(0.350585938f, 0.481923103f, -1.f),
    C_Vertex3f(0.349660397f, 0.492291212f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.341330528f, 0.520819187f, -1.f),
    C_Vertex3f(0.345032692f, 0.511739254f, -1.f),
    C_Vertex3f(0.345600486f, 0.620262265f, -1.f),
    C_Vertex3f(0.347809315f, 0.502229929f, -1.f),
    C_Vertex3f(0.36041081f, 0.611140609f, -1.f),
    C_Vertex3f(0.349660397f, 0.492291212f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.317266464f, 0.552845001f, -1.f),
    C_Vertex3f(0.324670792f, 0.545482635f, -1.f),
    C_Vertex3f(0.329767466f, 0.627863646f, -1.f),
    C_Vertex3f(0.331149578f, 0.537690878f, -1.f),
    C_Vertex3f(0.345600486f, 0.620262265f, -1.f),
    C_Vertex3f(0.336702824f, 0.529469728f, -1.f),
    C_Vertex3f(0.341330528f, 0.520819187f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.312911749f, 0.63394475f, -1.f),
    C_Vertex3f(0.295033336f, 0.638505578f, -1.f),
    C_Vertex3f(0.3010602f, 0.564808846f, -1.f),
    C_Vertex3f(0.309396267f, 0.559287071f, -1.f),
    C_Vertex3f(0.317266464f, 0.552845001f, -1.f),
    C_Vertex3f(0.329767466f, 0.627863646f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.263057232f, 0.577692986f, -1.f),
    C_Vertex3f(0.273256779f, 0.575852394f, -1.f),
    C_Vertex3f(0.276132226f, 0.64154613f, -1.f),
    C_Vertex3f(0.282990456f, 0.573091507f, -1.f),
    C_Vertex3f(0.295033336f, 0.638505578f, -1.f),
    C_Vertex3f(0.292258263f, 0.569410324f, -1.f),
    C_Vertex3f(0.3010602f, 0.564808846f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.25620842f, 0.643066406f, -1.f),
    C_Vertex3f(0.235316277f, 0.643066406f, -1.f),
    C_Vertex3f(0.241206169f, 0.578613281f, -1.f),
    C_Vertex3f(0.252391815f, 0.578613281f, -1.f),
    C_Vertex3f(0.263057232f, 0.577692986f, -1.f),
    C_Vertex3f(0.276132226f, 0.64154613f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.201108694f, 0.569615364f, -1.f),
    C_Vertex3f(0.210403681f, 0.573214531f, -1.f),
    C_Vertex3f(0.215514898f, 0.641580224f, -1.f),
    C_Vertex3f(0.220184922f, 0.575913906f, -1.f),
    C_Vertex3f(0.235316277f, 0.643066406f, -1.f),
    C_Vertex3f(0.230452418f, 0.57771349f, -1.f),
    C_Vertex3f(0.241206169f, 0.578613281f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.196749926f, 0.63860786f, -1.f),
    C_Vertex3f(0.179021358f, 0.634149313f, -1.f),
    C_Vertex3f(0.183977485f, 0.559717655f, -1.f),
    C_Vertex3f(0.192299962f, 0.565116405f, -1.f),
    C_Vertex3f(0.201108694f, 0.569615364f, -1.f),
    C_Vertex3f(0.215514898f, 0.641580224f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.179021358f, 0.634149313f, -1.f),
    C_Vertex3f(0.162329197f, 0.628204584f, -1.f),
    C_Vertex3f(0.162360072f, 0.538667917f, -1.f),
    C_Vertex3f(0.168791294f, 0.546220779f, -1.f),
    C_Vertex3f(0.176141262f, 0.553419113f, -1.f),
    C_Vertex3f(0.183977485f, 0.559717655f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.162329197f, 0.628204584f, -1.f),
    C_Vertex3f(0.146673441f, 0.620773673f, -1.f),
    C_Vertex3f(0.148578882f, 0.51388216f, -1.f),
    C_Vertex3f(0.152253866f, 0.522498608f, -1.f),
    C_Vertex3f(0.156847596f, 0.530760527f, -1.f),
    C_Vertex3f(0.162360072f, 0.538667917f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.146673441f, 0.620773673f, -1.f),
    C_Vertex3f(0.13205409f, 0.61185658f, -1.f),
    C_Vertex3f(0.143066406f, 0.485905647f, -1.f),
    C_Vertex3f(0.143985152f, 0.49558568f, -1.f),
    C_Vertex3f(0.145822644f, 0.504911184f, -1.f),
    C_Vertex3f(0.148578882f, 0.51388216f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.422066927f, 0.533075094f, -1.f),
    C_Vertex3f(0.422861576f, 0.42466116f, -1.f),
    C_Vertex3f(0.426853776f, 0.517606616f, -1.f),
    C_Vertex3f(0.428714275f, 0.444023609f, -1.f),
    C_Vertex3f(0.430045009f, 0.501476884f, -1.f),
    C_Vertex3f(0.431640625f, 0.464832306f, -1.f),
    C_Vertex3f(0.431640625f, 0.484685898f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.398132682f, 0.575513005f, -1.f),
    C_Vertex3f(0.402377129f, 0.390275002f, -1.f),
    C_Vertex3f(0.40770638f, 0.562028289f, -1.f),
    C_Vertex3f(0.414082527f, 0.406744957f, -1.f),
    C_Vertex3f(0.415684462f, 0.547882318f, -1.f),
    C_Vertex3f(0.422861576f, 0.42466116f, -1.f),
    C_Vertex3f(0.422066927f, 0.533075094f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.350585938f, 0.481923103f, -1.f),
    C_Vertex3f(0.350585938f, 0.471343994f, -1.f),
    C_Vertex3f(0.369861126f, 0.362978458f, -1.f),
    C_Vertex3f(0.349687576f, 0.461385369f, -1.f),
    C_Vertex3f(0.349050522f, 0.352151871f, -1.f),
    C_Vertex3f(0.347890854f, 0.451828837f, -1.f),
    C_Vertex3f(0.34519577f, 0.442674398f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.341602325f, 0.433922052f, -1.f),
    C_Vertex3f(0.337110519f, 0.425571799f, -1.f),
    C_Vertex3f(0.337127686f, 0.347679138f, -1.f),
    C_Vertex3f(0.349050522f, 0.352151871f, -1.f),
    C_Vertex3f(0.34519577f, 0.442674398f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.398132682f, 0.575513005f, -1.f),
    C_Vertex3f(0.387636662f, 0.375686169f, -1.f),
    C_Vertex3f(0.402377129f, 0.390275002f, -1.f),
    C_Vertex3f(0.143066406f, 0.485905647f, -1.f),
    C_Vertex3f(0.13205409f, 0.61185658f, -1.f),
    C_Vertex3f(0.143066406f, 0.475216866f, -1.f),
    C_Vertex3f(0.123096943f, 0.143631935f, -1.f),
    C_Vertex3f(0.133956671f, 0.0155863762f, -1.f),
    C_Vertex3f(0.129006386f, 0.127614975f, -1.f),
    C_End(),
    C_Translatef(0.497558594f, 0.f, 0.f),
};
static const Call char_57[] = {
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_FrontFace(GL_CW),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.0899563953f, 0.995945752f, 0.f),
    C_Vertex3f(0.048828125f, 0.1484375f, 0.f),
    C_Vertex3f(0.048828125f, 0.1484375f, -1.f),
    C_Vertex3f(0.124511719f, 0.155273438f, -1.f),
    C_Vertex3f(0.124511719f, 0.155273438f, 0.f),
    C_End(),
    C_Begin(GL_QUAD_STRIP),
    C_Normal3f(0.984207809f, 0.17701681f, 0.f),
    C_Vertex3f(0.124511719f, 0.155273438f, 0.f),
    C_Vertex3f(0.124511719f, 0.155273438f, -1.f),
    C_Normal3f(0.97725147f, 0.212083668f, 0.f),
    C_Vertex3f(0.125712395f, 0.148597717f, 0.f),
    C_Vertex3f(0.125712395f, 0.148597717f, -1.f),
    C_Normal3f(0.965718329f, 0.259591848f, 0.f),
    C_Vertex3f(0.128659129f, 0.136162758f, 0.f),
    C_Vertex3f(0.128659129f, 0.136162758f, -1.f),
    C_Normal3f(0.946659803f, 0.32223472f, 0.f),
    C_Vertex3f(0.132151246f, 0.124644279f, 0.f),
    C_Vertex3f(0.132151246f, 0.124644279f, -1.f),
    C_Normal3f(0.920360506f, 0.391071022f, 0.f),
    C_Vertex3f(0.136188745f, 0.114042282f, 0.f),
    C_Vertex3f(0.136188745f, 0.114042282f, -1.f),
    C_Normal3f(0.88495326f, 0.465679735f, 0.f),
    C_Vertex3f(0.140771627f, 0.104356766f, 0.f),
    C_Vertex3f(0.140771627f, 0.104356766f, -1.f),
    C_Normal3f(0.838492572f, 0.544913113f, 0.f),
    C_Vertex3f(0.145899892f, 0.0955877304f, 0.f),
    C_Vertex3f(0.145899892f, 0.0955877304f, -1.f),
    C_Normal3f(0.779278457f, 0.62667793f, 0.f),
    C_Vertex3f(0.151573539f, 0.0877351761f, 0.f),
    C_Vertex3f(0.151573539f, 0.0877351761f, -1.f),
    C_Normal3f(0.698300898f, 0.715804279f, 0.f),
    C_Vertex3f(0.157792568f, 0.0807991028f, 0.f),
    C_Vertex3f(0.157792568f, 0.0807991028f, -1.f),
    C_Normal3f(0.576654494f, 0.816988111f, 0.f),
    C_Vertex3f(0.167939186f, 0.0717697144f, 0.f),
    C_Vertex3f(0.167939186f, 0.0717697144f, -1.f),
    C_Normal3f(0.417151183f, 0.90883708f, 0.f),
    C_Vertex3f(0.183377743f, 0.0627403259f, 0.f),
    C_Vertex3f(0.183377743f, 0.0627403259f, -1.f),
    C_Normal3f(0.239484251f, 0.970900238f, 0.f),
    C_Vertex3f(0.200726032f, 0.0567207336f, 0.f),
    C_Vertex3f(0.200726032f, 0.0567207336f, -1.f),
    C_Normal3f(0.0771460533f, 0.997019827f, 0.f),
    C_Vertex3f(0.219984055f, 0.0537109375f, 0.f),
    C_Vertex3f(0.219984055f, 0.0537109375f, -1.f),
    C_Normal3f(-0.0565973558f, 0.998397052f, 0.f),
    C_Vertex3f(0.239624023f, 0.0537109375f, 0.f),
    C_Vertex3f(0.239624023f, 0.0537109375f, -1.f),
    C_Normal3f(-0.186049134f, 0.982540429f, 0.f),
    C_Vertex3f(0.256633282f, 0.055788517f, 0.f),
    C_Vertex3f(0.256633282f, 0.055788517f, -1.f),
    C_Normal3f(-0.320425451f, 0.94727385f, 0.f),
    C_Vertex3f(0.272539616f, 0.059943676f, 0.f),
    C_Vertex3f(0.272539616f, 0.059943676f, -1.f),
    C_Normal3f(-0.454476625f, 0.890758693f, 0.f),
    C_Vertex3f(0.287343025f, 0.0661764145f, 0.f),
    C_Vertex3f(0.287343025f, 0.0661764145f, -1.f),
    C_Normal3f(-0.567413867f, 0.823432744f, 0.f),
    C_Vertex3f(0.30104351f, 0.0744867325f, 0.f),
    C_Vertex3f(0.30104351f, 0.0744867325f, -1.f),
    C_Normal3f(-0.660829723f, 0.750535965f, 0.f),
    C_Vertex3f(0.313485622f, 0.0841908455f, 0.f),
    C_Vertex3f(0.313485622f, 0.0841908455f, -1.f),
    C_Normal3f(-0.745200336f, 0.666840672f, 0.f),
    C_Vertex3f(0.324669361f, 0.0952887535f, 0.f),
    C_Vertex3f(0.324669361f, 0.0952887535f, -1.f),
    C_Normal3f(-0.817359567f, 0.576127887f, 0.f),
    C_Vertex3f(0.334594727f, 0.107780457f, 0.f),
    C_Vertex3f(0.334594727f, 0.107780457f, -1.f),
    C_Normal3f(-0.875859439f, 0.482566178f, 0.f),
    C_Vertex3f(0.343261719f, 0.121665955f, 0.f),
    C_Vertex3f(0.343261719f, 0.121665955f, -1.f),
    C_Normal3f(-0.916996717f, 0.398894817f, 0.f),
    C_Vertex3f(0.35123539f, 0.137983322f, 0.f),
    C_Vertex3f(0.35123539f, 0.137983322f, -1.f),
    C_Normal3f(-0.944654047f, 0.328068167f, 0.f),
    C_Vertex3f(0.358515739f, 0.156732559f, 0.f),
    C_Vertex3f(0.358515739f, 0.156732559f, -1.f),
    C_Normal3f(-0.963307202f, 0.268401146f, 0.f),
    C_Vertex3f(0.365102768f, 0.177913666f, 0.f),
    C_Vertex3f(0.365102768f, 0.177913666f, -1.f),
    C_Normal3f(-0.977173686f, 0.212441862f, 0.f),
    C_Vertex3f(0.370996475f, 0.201526642f, 0.f),
    C_Vertex3f(0.370996475f, 0.201526642f, -1.f),
    C_Normal3f(-0.988365114f, 0.152100086f, 0.f),
    C_Vertex3f(0.375416756f, 0.225355148f, 0.f),
    C_Vertex3f(0.375416756f, 0.225355148f, -1.f),
    C_Normal3f(-0.995839059f, 0.0911295936f, 0.f),
    C_Vertex3f(0.378363609f, 0.249399185f, 0.f),
    C_Vertex3f(0.378363609f, 0.249399185f, -1.f),
    C_Normal3f(-0.99929142f, 0.0376396999f, 0.f),
    C_Vertex3f(0.379837036f, 0.273658752f, 0.f),
    C_Vertex3f(0.379837036f, 0.273658752f, -1.f),
    C_Normal3f(-0.999952674f, -0.0097359838f, 0.f),
    C_Vertex3f(0.379837036f, 0.288516998f, 0.f),
    C_Vertex3f(0.379837036f, 0.288516998f, -1.f),
    C_Normal3f(-0.999430895f, -0.0337311551f, 0.f),
    C_Vertex3f(0.379615784f, 0.296382904f, 0.f),
    C_Vertex3f(0.379615784f, 0.296382904f, -1.f),
    C_Normal3f(-0.999111474f, -0.0421443395f, 0.f),
    C_Vertex3f(0.379394531f, 0.301628113f, 0.f),
    C_Vertex3f(0.379394531f, 0.301628113f, -1.f),
    C_End(),
    C_Begin(GL_QUAD_STRIP),
    C_Normal3f(0.847127616f, -0.531389415f, 0.f),
    C_Vertex3f(0.379394531f, 0.301628113f, 0.f),
    C_Vertex3f(0.379394531f, 0.301628113f, -1.f),
    C_Normal3f(0.799589336f, -0.600547314f, 0.f),
    C_Vertex3f(0.373500824f, 0.292232513f, 0.f),
    C_Vertex3f(0.373500824f, 0.292232513f, -1.f),
    C_Normal3f(0.731778979f, -0.681541979f, 0.f),
    C_Vertex3f(0.359557629f, 0.275216579f, 0.f),
    C_Vertex3f(0.359557629f, 0.275216579f, -1.f),
    C_Normal3f(0.641211569f, -0.767364144f, 0.f),
    C_Vertex3f(0.343458652f, 0.25997591f, 0.f),
    C_Vertex3f(0.343458652f, 0.25997591f, -1.f),
    C_Normal3f(0.545340359f, -0.838214636f, 0.f),
    C_Vertex3f(0.325203896f, 0.246510506f, 0.f),
    C_Vertex3f(0.325203896f, 0.246510506f, -1.f),
    C_Normal3f(0.440721959f, -0.897643685f, 0.f),
    C_Vertex3f(0.304793358f, 0.234820366f, 0.f),
    C_Vertex3f(0.304793358f, 0.234820366f, -1.f),
    C_Normal3f(0.319358647f, -0.947633922f, 0.f),
    C_Vertex3f(0.283536434f, 0.226052761f, 0.f),
    C_Vertex3f(0.283536434f, 0.226052761f, -1.f),
    C_Normal3f(0.191022873f, -0.981585562f, 0.f),
    C_Vertex3f(0.261433125f, 0.220207691f, 0.f),
    C_Vertex3f(0.261433125f, 0.220207691f, -1.f),
    C_Normal3f(0.0651267543f, -0.997877002f, 0.f),
    C_Vertex3f(0.238483429f, 0.217285156f, 0.f),
    C_Vertex3f(0.238483429f, 0.217285156f, -1.f),
    C_Normal3f(-0.0439695865f, -0.999032915f, 0.f),
    C_Vertex3f(0.216653824f, 0.217285156f, 0.f),
    C_Vertex3f(0.216653824f, 0.217285156f, -1.f),
    C_Normal3f(-0.142879069f, -0.989740074f, 0.f),
    C_Vertex3f(0.197554469f, 0.219086528f, 0.f),
    C_Vertex3f(0.197554469f, 0.219086528f, -1.f),
    C_Normal3f(-0.243298545f, -0.96995151f, 0.f),
    C_Vertex3f(0.179218888f, 0.222689271f, 0.f),
    C_Vertex3f(0.179218888f, 0.222689271f, -1.f),
    C_Normal3f(-0.344342738f, -0.938844025f, 0.f),
    C_Vertex3f(0.161647081f, 0.228093386f, 0.f),
    C_Vertex3f(0.161647081f, 0.228093386f, -1.f),
    C_Normal3f(-0.442538708f, -0.896749437f, 0.f),
    C_Vertex3f(0.144839048f, 0.235298872f, 0.f),
    C_Vertex3f(0.144839048f, 0.235298872f, -1.f),
    C_Normal3f(-0.534591436f, -0.845110595f, 0.f),
    C_Vertex3f(0.128794789f, 0.24430573f, 0.f),
    C_Vertex3f(0.128794789f, 0.24430573f, -1.f),
    C_Normal3f(-0.617915332f, -0.78624469f, 0.f),
    C_Vertex3f(0.113514304f, 0.255113959f, 0.f),
    C_Vertex3f(0.113514304f, 0.255113959f, -1.f),
    C_Normal3f(-0.690956056f, -0.722896755f, 0.f),
    C_Vertex3f(0.0989975929f, 0.26772356f, 0.f),
    C_Vertex3f(0.0989975929f, 0.26772356f, -1.f),
    C_Normal3f(-0.758010685f, -0.652242064f, 0.f),
    C_Vertex3f(0.0852446556f, 0.282134533f, 0.f),
    C_Vertex3f(0.0852446556f, 0.282134533f, -1.f),
    C_Normal3f(-0.822027445f, -0.569447815f, 0.f),
    C_Vertex3f(0.0732108355f, 0.297691941f, 0.f),
    C_Vertex3f(0.0732108355f, 0.297691941f, -1.f),
    C_Normal3f(-0.87722677f, -0.480076164f, 0.f),
    C_Vertex3f(0.0628961325f, 0.314395785f, 0.f),
    C_Vertex3f(0.0628961325f, 0.314395785f, -1.f),
    C_Normal3f(-0.922015071f, -0.387154162f, 0.f),
    C_Vertex3f(0.0543005466f, 0.332246065f, 0.f),
    C_Vertex3f(0.0543005466f, 0.332246065f, -1.f),
    C_Normal3f(-0.955842197f, -0.293880224f, 0.f),
    C_Vertex3f(0.047424078f, 0.351242781f, 0.f),
    C_Vertex3f(0.047424078f, 0.351242781f, -1.f),
    C_Normal3f(-0.979151011f, -0.203133494f, 0.f),
    C_Vertex3f(0.0422667265f, 0.371385932f, 0.f),
    C_Vertex3f(0.0422667265f, 0.371385932f, -1.f),
    C_Normal3f(-0.993115783f, -0.117136098f, 0.f),
    C_Vertex3f(0.0388284922f, 0.392675519f, 0.f),
    C_Vertex3f(0.0388284922f, 0.392675519f, -1.f),
    C_Normal3f(-0.999314368f, -0.0370245762f, 0.f),
    C_Vertex3f(0.037109375f, 0.415111542f, 0.f),
    C_Vertex3f(0.037109375f, 0.415111542f, -1.f),
    C_Normal3f(-0.999275863f, 0.0380483679f, 0.f),
    C_Vertex3f(0.037109375f, 0.43907547f, 0.f),
    C_Vertex3f(0.037109375f, 0.43907547f, -1.f),
    C_Normal3f(-0.992962062f, 0.118432775f, 0.f),
    C_Vertex3f(0.038903594f, 0.462233663f, 0.f),
    C_Vertex3f(0.038903594f, 0.462233663f, -1.f),
    C_Normal3f(-0.978687525f, 0.20535484f, 0.f),
    C_Vertex3f(0.0424920321f, 0.48420465f, 0.f),
    C_Vertex3f(0.0424920321f, 0.48420465f, -1.f),
    C_Normal3f(-0.954878569f, 0.296996593f, 0.f),
    C_Vertex3f(0.0478746891f, 0.504988432f, 0.f),
    C_Vertex3f(0.0478746891f, 0.504988432f, -1.f),
    C_Normal3f(-0.920370638f, 0.39104718f, 0.f),
    C_Vertex3f(0.0550515652f, 0.524585009f, 0.f),
    C_Vertex3f(0.0550515652f, 0.524585009f, -1.f),
    C_Normal3f(-0.874770403f, 0.48453778f, 0.f),
    C_Vertex3f(0.0640226603f, 0.54299438f, 0.f),
    C_Vertex3f(0.0640226603f, 0.54299438f, -1.f),
    C_Normal3f(-0.818712711f, 0.574203193f, 0.f),
    C_Vertex3f(0.0747879744f, 0.560216546f, 0.f),
    C_Vertex3f(0.0747879744f, 0.560216546f, -1.f),
    C_Normal3f(-0.753894985f, 0.656994998f, 0.f),
    C_Vertex3f(0.0873475075f, 0.576251507f, 0.f),
    C_Vertex3f(0.0873475075f, 0.576251507f, -1.f),
    C_Normal3f(-0.684931219f, 0.728607714f, 0.f),
    C_Vertex3f(0.10170126f, 0.591099262f, 0.f),
    C_Vertex3f(0.10170126f, 0.591099262f, -1.f),
    C_Normal3f(-0.608935654f, 0.793219626f, 0.f),
    C_Vertex3f(0.116962314f, 0.604091048f, 0.f),
    C_Vertex3f(0.116962314f, 0.604091048f, -1.f),
    C_Normal3f(-0.523312807f, 0.852140665f, 0.f),
    C_Vertex3f(0.13313067f, 0.615226865f, 0.f),
    C_Vertex3f(0.13313067f, 0.615226865f, -1.f),
    C_Normal3f(-0.430125535f, 0.902769089f, 0.f),
    C_Vertex3f(0.150206327f, 0.624506712f, 0.f),
    C_Vertex3f(0.150206327f, 0.624506712f, -1.f),
    C_Normal3f(-0.332313001f, 0.943169117f, 0.f),
    C_Vertex3f(0.168189287f, 0.63193059f, 0.f),
    C_Vertex3f(0.168189287f, 0.63193059f, -1.f),
    C_Normal3f(-0.233248621f, 0.972417116f, 0.f),
    C_Vertex3f(0.187079549f, 0.637498498f, 0.f),
    C_Vertex3f(0.187079549f, 0.637498498f, -1.f),
    C_Normal3f(-0.136190116f, 0.990682721f, 0.f),
    C_Vertex3f(0.206877112f, 0.641210437f, 0.f),
    C_Vertex3f(0.206877112f, 0.641210437f, -1.f),
    C_Normal3f(-0.0471541733f, 0.998887658f, 0.f),
    C_Vertex3f(0.227581978f, 0.643066406f, 0.f),
    C_Vertex3f(0.227581978f, 0.643066406f, -1.f),
    C_Normal3f(0.0309990626f, 0.999519348f, 0.f),
    C_Vertex3f(0.246192932f, 0.643066406f, 0.f),
    C_Vertex3f(0.246192932f, 0.643066406f, -1.f),
    C_Normal3f(0.103779063f, 0.994600356f, 0.f),
    C_Vertex3f(0.261468291f, 0.642015457f, 0.f),
    C_Vertex3f(0.261468291f, 0.642015457f, -1.f),
    C_Normal3f(0.175092891f, 0.984551907f, 0.f),
    C_Vertex3f(0.276409268f, 0.639913559f, 0.f),
    C_Vertex3f(0.276409268f, 0.639913559f, -1.f),
    C_Normal3f(0.246858105f, 0.969051659f, 0.f),
    C_Vertex3f(0.291015863f, 0.636760712f, 0.f),
    C_Vertex3f(0.291015863f, 0.636760712f, -1.f),
    C_Normal3f(0.317896813f, 0.948125303f, 0.f),
    C_Vertex3f(0.305288076f, 0.632556915f, 0.f),
    C_Vertex3f(0.305288076f, 0.632556915f, -1.f),
    C_Normal3f(0.387036175f, 0.922064483f, 0.f),
    C_Vertex3f(0.319225907f, 0.62730217f, 0.f),
    C_Vertex3f(0.319225907f, 0.62730217f, -1.f),
    C_Normal3f(0.453203142f, 0.891407311f, 0.f),
    C_Vertex3f(0.332829356f, 0.620996475f, 0.f),
    C_Vertex3f(0.332829356f, 0.620996475f, -1.f),
    C_Normal3f(0.515504897f, 0.856886566f, 0.f),
    C_Vertex3f(0.346098423f, 0.613639832f, 0.f),
    C_Vertex3f(0.346098423f, 0.613639832f, -1.f),
    C_Normal3f(0.576626301f, 0.817007959f, 0.f),
    C_Vertex3f(0.359033108f, 0.605232239f, 0.f),
    C_Vertex3f(0.359033108f, 0.605232239f, -1.f),
    C_Normal3f(0.637932718f, 0.770092189f, 0.f),
    C_Vertex3f(0.371190071f, 0.595930696f, 0.f),
    C_Vertex3f(0.371190071f, 0.595930696f, -1.f),
    C_Normal3f(0.695644736f, 0.718385994f, 0.f),
    C_Vertex3f(0.382569313f, 0.585735202f, 0.f),
    C_Vertex3f(0.382569313f, 0.585735202f, -1.f),
    C_Normal3f(0.748759329f, 0.662842095f, 0.f),
    C_Vertex3f(0.393170834f, 0.574645758f, 0.f),
    C_Vertex3f(0.393170834f, 0.574645758f, -1.f),
    C_Normal3f(0.796536863f, 0.604589939f, 0.f),
    C_Vertex3f(0.402994633f, 0.562662363f, 0.f),
    C_Vertex3f(0.402994633f, 0.562662363f, -1.f),
    C_Normal3f(0.838546813f, 0.544829428f, 0.f),
    C_Vertex3f(0.41204071f, 0.549785018f, 0.f),
    C_Vertex3f(0.41204071f, 0.549785018f, -1.f),
    C_Normal3f(0.874667168f, 0.484723955f, 0.f),
    C_Vertex3f(0.420309067f, 0.536013722f, 0.f),
    C_Vertex3f(0.420309067f, 0.536013722f, -1.f),
    C_Normal3f(0.905046046f, 0.425313592f, 0.f),
    C_Vertex3f(0.427799702f, 0.521348476f, 0.f),
    C_Vertex3f(0.427799702f, 0.521348476f, -1.f),
    C_Normal3f(0.93383199f, 0.357711941f, 0.f),
    C_Vertex3f(0.434512615f, 0.50578928f, 0.f),
    C_Vertex3f(0.434512615f, 0.50578928f, -1.f),
    C_Normal3f(0.957776368f, 0.28751421f, 0.f),
    C_Vertex3f(0.440386415f, 0.488489985f, 0.f),
    C_Vertex3f(0.440386415f, 0.488489985f, -1.f),
    C_Normal3f(0.974169493f, 0.225818336f, 0.f),
    C_Vertex3f(0.4454211f, 0.469450593f, 0.f),
    C_Vertex3f(0.4454211f, 0.469450593f, -1.f),
    C_Normal3f(0.985128045f, 0.171821535f, 0.f),
    C_Vertex3f(0.449616671f, 0.448671103f, 0.f),
    C_Vertex3f(0.449616671f, 0.448671103f, -1.f),
    C_Normal3f(0.992208898f, 0.124585852f, 0.f),
    C_Vertex3f(0.452973127f, 0.426151514f, 0.f),
    C_Vertex3f(0.452973127f, 0.426151514f, -1.f),
    C_Normal3f(0.996533811f, 0.0831888616f, 0.f),
    C_Vertex3f(0.45549047f, 0.401891828f, 0.f),
    C_Vertex3f(0.45549047f, 0.401891828f, -1.f),
    C_Normal3f(0.998904705f, 0.0467919782f, 0.f),
    C_Vertex3f(0.457168698f, 0.375892043f, 0.f),
    C_Vertex3f(0.457168698f, 0.375892043f, -1.f),
    C_Normal3f(0.999894679f, 0.0145108262f, 0.f),
    C_Vertex3f(0.458007813f, 0.348152161f, 0.f),
    C_Vertex3f(0.458007813f, 0.348152161f, -1.f),
    C_Normal3f(0.999901175f, -0.0140601723f, 0.f),
    C_Vertex3f(0.458007813f, 0.318071365f, 0.f),
    C_Vertex3f(0.458007813f, 0.318071365f, -1.f),
    C_Normal3f(0.99903059f, -0.0440212935f, 0.f),
    C_Vertex3f(0.457175374f, 0.288952589f, 0.f),
    C_Vertex3f(0.457175374f, 0.288952589f, -1.f),
    C_Normal3f(0.996992886f, -0.0774929896f, 0.f),
    C_Vertex3f(0.455510497f, 0.261396646f, 0.f),
    C_Vertex3f(0.455510497f, 0.261396646f, -1.f),
    C_Normal3f(0.993388712f, -0.114798814f, 0.f),
    C_Vertex3f(0.453013182f, 0.235403538f, 0.f),
    C_Vertex3f(0.453013182f, 0.235403538f, -1.f),
    C_Normal3f(0.987685978f, -0.156449214f, 0.f),
    C_Vertex3f(0.449683428f, 0.210973263f, 0.f),
    C_Vertex3f(0.449683428f, 0.210973263f, -1.f),
    C_Normal3f(0.979182124f, -0.202983513f, 0.f),
    C_Vertex3f(0.445521235f, 0.188105822f, 0.f),
    C_Vertex3f(0.445521235f, 0.188105822f, -1.f),
    C_Normal3f(0.966958404f, -0.254934371f, 0.f),
    C_Vertex3f(0.440526605f, 0.166801214f, 0.f),
    C_Vertex3f(0.440526605f, 0.166801214f, -1.f),
    C_Normal3f(0.949831605f, -0.312761664f, 0.f),
    C_Vertex3f(0.434699535f, 0.147059441f, 0.f),
    C_Vertex3f(0.434699535f, 0.147059441f, -1.f),
    C_Normal3f(0.928279042f, -0.371884465f, 0.f),
    C_Vertex3f(0.428040028f, 0.128880501f, 0.f),
    C_Vertex3f(0.428040028f, 0.128880501f, -1.f),
    C_Normal3f(0.902951181f, -0.429743081f, 0.f),
    C_Vertex3f(0.420568585f, 0.111786485f, 0.f),
    C_Vertex3f(0.420568585f, 0.111786485f, -1.f),
    C_Normal3f(0.871831596f, -0.489805758f, 0.f),
    C_Vertex3f(0.412285209f, 0.0957773924f, 0.f),
    C_Vertex3f(0.412285209f, 0.0957773924f, -1.f),
    C_Normal3f(0.834359825f, -0.551220059f, 0.f),
    C_Vertex3f(0.403189898f, 0.0808532238f, 0.f),
    C_Vertex3f(0.403189898f, 0.0808532238f, -1.f),
    C_Normal3f(0.790178895f, -0.612876296f, 0.f),
    C_Vertex3f(0.393282652f, 0.067013979f, 0.f),
    C_Vertex3f(0.393282652f, 0.067013979f, -1.f),
    C_Normal3f(0.739232898f, -0.673449814f, 0.f),
    C_Vertex3f(0.382563472f, 0.0542596579f, 0.f),
    C_Vertex3f(0.382563472f, 0.0542596579f, -1.f),
    C_Normal3f(0.681848466f, -0.731493473f, 0.f),
    C_Vertex3f(0.371032357f, 0.0425902605f, 0.f),
    C_Vertex3f(0.371032357f, 0.0425902605f, -1.f),
    C_Normal3f(0.618770778f, -0.785571575f, 0.f),
    C_Vertex3f(0.358689308f, 0.0320057869f, 0.f),
    C_Vertex3f(0.358689308f, 0.0320057869f, -1.f),
    C_Normal3f(0.552422583f, -0.833564162f, 0.f),
    C_Vertex3f(0.345534325f, 0.022506237f, 0.f),
    C_Vertex3f(0.345534325f, 0.022506237f, -1.f),
    C_Normal3f(0.482676893f, -0.875798404f, 0.f),
    C_Vertex3f(0.331812859f, 0.0141941309f, 0.f),
    C_Vertex3f(0.331812859f, 0.0141941309f, -1.f),
    C_Normal3f(0.409005195f, -0.912532032f, 0.f),
    C_Vertex3f(0.31752491f, 0.0070694685f, 0.f),
    C_Vertex3f(0.31752491f, 0.0070694685f, -1.f),
    C_Normal3f(0.332863837f, -0.942974925f, 0.f),
    C_Vertex3f(0.302670479f, 0.00113224983f, 0.f),
    C_Vertex3f(0.302670479f, 0.00113224983f, -1.f),
    C_Normal3f(0.255839109f, -0.966719389f, 0.f),
    C_Vertex3f(0.287249565f, -0.0036175251f, 0.f),
    C_Vertex3f(0.287249565f, -0.0036175251f, -1.f),
    C_Normal3f(0.179488927f, -0.983760059f, 0.f),
    C_Vertex3f(0.271262169f, -0.0071798563f, 0.f),
    C_Vertex3f(0.271262169f, -0.0071798563f, -1.f),
    C_Normal3f(0.105200998f, -0.994450927f, 0.f),
    C_Vertex3f(0.25470829f, -0.00955474377f, 0.f),
    C_Vertex3f(0.25470829f, -0.00955474377f, -1.f),
    C_Normal3f(0.0335695483f, -0.999436319f, 0.f),
    C_Vertex3f(0.237587929f, -0.0107421875f, 0.f),
    C_Vertex3f(0.237587929f, -0.0107421875f, -1.f),
    C_Normal3f(-0.0360784829f, -0.999348938f, 0.f),
    C_Vertex3f(0.219355583f, -0.0107421875f, 0.f),
    C_Vertex3f(0.219355583f, -0.0107421875f, -1.f),
    C_Normal3f(-0.111246377f, -0.993792892f, 0.f),
    C_Vertex3f(0.201437473f, -0.0094370842f, 0.f),
    C_Vertex3f(0.201437473f, -0.0094370842f, -1.f),
    C_Normal3f(-0.192543298f, -0.981288433f, 0.f),
    C_Vertex3f(0.184379101f, -0.00682687759f, 0.f),
    C_Vertex3f(0.184379101f, -0.00682687759f, -1.f),
    C_Normal3f(-0.278238982f, -0.960511923f, 0.f),
    C_Vertex3f(0.168180466f, -0.00291156769f, 0.f),
    C_Vertex3f(0.168180466f, -0.00291156769f, -1.f),
    C_Normal3f(-0.366508901f, -0.930414557f, 0.f),
    C_Vertex3f(0.152841568f, 0.00230884552f, 0.f),
    C_Vertex3f(0.152841568f, 0.00230884552f, -1.f),
    C_Normal3f(-0.45497632f, -0.890503526f, 0.f),
    C_Vertex3f(0.138362408f, 0.00883436203f, 0.f),
    C_Vertex3f(0.138362408f, 0.00883436203f, -1.f),
    C_Normal3f(-0.540945828f, -0.84105742f, 0.f),
    C_Vertex3f(0.124742985f, 0.0166649818f, 0.f),
    C_Vertex3f(0.124742985f, 0.0166649818f, -1.f),
    C_Normal3f(-0.621763289f, -0.783205152f, 0.f),
    C_Vertex3f(0.111983299f, 0.025800705f, 0.f),
    C_Vertex3f(0.111983299f, 0.025800705f, -1.f),
    C_Normal3f(-0.696364462f, -0.717688382f, 0.f),
    C_Vertex3f(0.100083351f, 0.0362415314f, 0.f),
    C_Vertex3f(0.100083351f, 0.0362415314f, -1.f),
    C_Normal3f(-0.765257955f, -0.643723667f, 0.f),
    C_Vertex3f(0.0893707275f, 0.0477414131f, 0.f),
    C_Vertex3f(0.0893707275f, 0.0477414131f, -1.f),
    C_Normal3f(-0.826001585f, -0.563667774f, 0.f),
    C_Vertex3f(0.0798454285f, 0.0603003502f, 0.f),
    C_Vertex3f(0.0798454285f, 0.0603003502f, -1.f),
    C_Normal3f(-0.877178311f, -0.480164915f, 0.f),
    C_Vertex3f(0.0715074539f, 0.0739183426f, 0.f),
    C_Vertex3f(0.0715074539f, 0.0739183426f, -1.f),
    C_Normal3f(-0.918270767f, -0.395953089f, 0.f),
    C_Vertex3f(0.0643568039f, 0.0885953903f, 0.f),
    C_Vertex3f(0.0643568039f, 0.0885953903f, -1.f),
    C_Normal3f(-0.949593723f, -0.313483f, 0.f),
    C_Vertex3f(0.0583934784f, 0.104331493f, 0.f),
    C_Vertex3f(0.0583934784f, 0.104331493f, -1.f),
    C_Normal3f(-0.972075641f, -0.234668016f, 0.f),
    C_Vertex3f(0.0536174774f, 0.121126652f, 0.f),
    C_Vertex3f(0.0536174774f, 0.121126652f, -1.f),
    C_Normal3f(-0.984969437f, -0.172728643f, 0.f),
    C_Vertex3f(0.050028801f, 0.138980865f, 0.f),
    C_Vertex3f(0.050028801f, 0.138980865f, -1.f),
    C_Normal3f(-0.992035985f, -0.125955358f, 0.f),
    C_Vertex3f(0.048828125f, 0.1484375f, 0.f),
    C_Vertex3f(0.048828125f, 0.1484375f, -1.f),
    C_End(),
    C_Begin(GL_QUAD_STRIP),
    C_Normal3f(-0.999446273f, 0.0332718454f, 0.f),
    C_Vertex3f(0.370605469f, 0.422379494f, 0.f),
    C_Vertex3f(0.370605469f, 0.422379494f, -1.f),
    C_Normal3f(-0.99942416f, -0.0339323394f, 0.f),
    C_Vertex3f(0.370605469f, 0.439313889f, 0.f),
    C_Vertex3f(0.370605469f, 0.439313889f, -1.f),
    C_Normal3f(-0.994265616f, -0.106938951f, 0.f),
    C_Vertex3f(0.369485259f, 0.455373526f, 0.f),
    C_Vertex3f(0.369485259f, 0.455373526f, -1.f),
    C_Normal3f(-0.982446074f, -0.186546683f, 0.f),
    C_Vertex3f(0.36724484f, 0.470559359f, 0.f),
    C_Vertex3f(0.36724484f, 0.470559359f, -1.f),
    C_Normal3f(-0.96231848f, -0.271925062f, 0.f),
    C_Vertex3f(0.363884211f, 0.484871387f, 0.f),
    C_Vertex3f(0.363884211f, 0.484871387f, -1.f),
    C_Normal3f(-0.932370663f, -0.361503839f, 0.f),
    C_Vertex3f(0.359403372f, 0.498309612f, 0.f),
    C_Vertex3f(0.359403372f, 0.498309612f, -1.f),
    C_Normal3f(-0.891544878f, -0.452932298f, 0.f),
    C_Vertex3f(0.353802323f, 0.510874033f, 0.f),
    C_Vertex3f(0.353802323f, 0.510874033f, -1.f),
    C_Normal3f(-0.839585543f, -0.543227494f, 0.f),
    C_Vertex3f(0.347081065f, 0.52256465f, 0.f),
    C_Vertex3f(0.347081065f, 0.52256465f, -1.f),
    C_Normal3f(-0.777289271f, -0.629143417f, 0.f),
    C_Vertex3f(0.339239597f, 0.533381462f, 0.f),
    C_Vertex3f(0.339239597f, 0.533381462f, -1.f),
    C_Normal3f(-0.711899638f, -0.702281117f, 0.f),
    C_Vertex3f(0.33027792f, 0.543324471f, 0.f),
    C_Vertex3f(0.33027792f, 0.543324471f, -1.f),
    C_Normal3f(-0.641390502f, -0.767214537f, 0.f),
    C_Vertex3f(0.320848346f, 0.552024603f, 0.f),
    C_Vertex3f(0.320848346f, 0.552024603f, -1.f),
    C_Normal3f(-0.559310377f, -0.828958213f, 0.f),
    C_Vertex3f(0.310950875f, 0.559481859f, 0.f),
    C_Vertex3f(0.310950875f, 0.559481859f, -1.f),
    C_Normal3f(-0.466684163f, -0.884424031f, 0.f),
    C_Vertex3f(0.300585508f, 0.565696239f, 0.f),
    C_Vertex3f(0.300585508f, 0.565696239f, -1.f),
    C_Normal3f(-0.365815043f, -0.930687547f, 0.f),
    C_Vertex3f(0.289752245f, 0.570667744f, 0.f),
    C_Vertex3f(0.289752245f, 0.570667744f, -1.f),
    C_Normal3f(-0.260097116f, -0.96558249f, 0.f),
    C_Vertex3f(0.278451085f, 0.574396372f, 0.f),
    C_Vertex3f(0.278451085f, 0.574396372f, -1.f),
    C_Normal3f(-0.153480321f, -0.98815161f, 0.f),
    C_Vertex3f(0.266682029f, 0.576882124f, 0.f),
    C_Vertex3f(0.266682029f, 0.576882124f, -1.f),
    C_Normal3f(-0.0493383482f, -0.998782158f, 0.f),
    C_Vertex3f(0.254445076f, 0.578125f, 0.f),
    C_Vertex3f(0.254445076f, 0.578125f, -1.f),
    C_Normal3f(0.0521502495f, -0.998639226f, 0.f),
    C_Vertex3f(0.241521835f, 0.578125f, 0.f),
    C_Vertex3f(0.241521835f, 0.578125f, -1.f),
    C_Normal3f(0.158699751f, -0.98732686f, 0.f),
    C_Vertex3f(0.228814125f, 0.576786518f, 0.f),
    C_Vertex3f(0.228814125f, 0.576786518f, -1.f),
    C_Normal3f(0.267427653f, -0.963577926f, 0.f),
    C_Vertex3f(0.216540337f, 0.574109554f, 0.f),
    C_Vertex3f(0.216540337f, 0.574109554f, -1.f),
    C_Normal3f(0.373833179f, -0.927495956f, 0.f),
    C_Vertex3f(0.20470047f, 0.570094109f, 0.f),
    C_Vertex3f(0.20470047f, 0.570094109f, -1.f),
    C_Normal3f(0.47399804f, -0.880525947f, 0.f),
    C_Vertex3f(0.193294525f, 0.564740181f, 0.f),
    C_Vertex3f(0.193294525f, 0.564740181f, -1.f),
    C_Normal3f(0.564836681f, -0.825202644f, 0.f),
    C_Vertex3f(0.182322502f, 0.558047771f, 0.f),
    C_Vertex3f(0.182322502f, 0.558047771f, -1.f),
    C_Normal3f(0.644510388f, -0.764595509f, 0.f),
    C_Vertex3f(0.171784401f, 0.55001688f, 0.f),
    C_Vertex3f(0.171784401f, 0.55001688f, -1.f),
    C_Normal3f(0.712458789f, -0.70171392f, 0.f),
    C_Vertex3f(0.161680222f, 0.540647507f, 0.f),
    C_Vertex3f(0.161680222f, 0.540647507f, -1.f),
    C_Normal3f(0.77461046f, -0.6324386f, 0.f),
    C_Vertex3f(0.152009964f, 0.529939651f, 0.f),
    C_Vertex3f(0.152009964f, 0.529939651f, -1.f),
    C_Normal3f(0.834422529f, -0.551125288f, 0.f),
    C_Vertex3f(0.143548489f, 0.51843977f, 0.f),
    C_Vertex3f(0.143548489f, 0.51843977f, -1.f),
    C_Normal3f(0.885766983f, -0.464130133f, 0.f),
    C_Vertex3f(0.136295795f, 0.506147861f, 0.f),
    C_Vertex3f(0.136295795f, 0.506147861f, -1.f),
    C_Normal3f(0.92734468f, -0.374208391f, 0.f),
    C_Vertex3f(0.130251884f, 0.493063927f, 0.f),
    C_Vertex3f(0.130251884f, 0.493063927f, -1.f),
    C_Normal3f(0.958761394f, -0.284212112f, 0.f),
    C_Vertex3f(0.125416756f, 0.479187965f, 0.f),
    C_Vertex3f(0.125416756f, 0.479187965f, -1.f),
    C_Normal3f(0.980465889f, -0.196689069f, 0.f),
    C_Vertex3f(0.121790409f, 0.464519978f, 0.f),
    C_Vertex3f(0.121790409f, 0.464519978f, -1.f),
    C_Normal3f(0.993525207f, -0.113611899f, 0.f),
    C_Vertex3f(0.119372845f, 0.449059963f, 0.f),
    C_Vertex3f(0.119372845f, 0.449059963f, -1.f),
    C_Normal3f(0.999305665f, -0.0372573622f, 0.f),
    C_Vertex3f(0.118164063f, 0.432807922f, 0.f),
    C_Vertex3f(0.118164063f, 0.432807922f, -1.f),
    C_Normal3f(0.999304354f, 0.0372940972f, 0.f),
    C_Vertex3f(0.118164063f, 0.416638374f, 0.f),
    C_Vertex3f(0.118164063f, 0.416638374f, -1.f),
    C_Normal3f(0.992753327f, 0.120169558f, 0.f),
    C_Vertex3f(0.119311571f, 0.402060151f, 0.f),
    C_Vertex3f(0.119311571f, 0.402060151f, -1.f),
    C_Normal3f(0.978168011f, 0.207815856f, 0.f),
    C_Vertex3f(0.121606588f, 0.388198733f, 0.f),
    C_Vertex3f(0.121606588f, 0.388198733f, -1.f),
    C_Normal3f(0.954041541f, 0.299674273f, 0.f),
    C_Vertex3f(0.125049114f, 0.375054121f, 0.f),
    C_Vertex3f(0.125049114f, 0.375054121f, -1.f),
    C_Normal3f(0.919387937f, 0.393352062f, 0.f),
    C_Vertex3f(0.129639149f, 0.362626314f, 0.f),
    C_Vertex3f(0.129639149f, 0.362626314f, -1.f),
    C_Normal3f(0.874016821f, 0.485895783f, 0.f),
    C_Vertex3f(0.135376692f, 0.350915313f, 0.f),
    C_Vertex3f(0.135376692f, 0.350915313f, -1.f),
    C_Normal3f(0.818734288f, 0.574172556f, 0.f),
    C_Vertex3f(0.142261744f, 0.339921117f, 0.f),
    C_Vertex3f(0.142261744f, 0.339921117f, -1.f),
    C_Normal3f(0.75531745f, 0.655359209f, 0.f),
    C_Vertex3f(0.150294304f, 0.329643726f, 0.f),
    C_Vertex3f(0.150294304f, 0.329643726f, -1.f),
    C_Normal3f(0.687980294f, 0.725729406f, 0.f),
    C_Vertex3f(0.159474373f, 0.320083141f, 0.f),
    C_Vertex3f(0.159474373f, 0.320083141f, -1.f),
    C_Normal3f(0.613289833f, 0.789857984f, 0.f),
    C_Vertex3f(0.169203997f, 0.311717629f, 0.f),
    C_Vertex3f(0.169203997f, 0.311717629f, -1.f),
    C_Normal3f(0.528649509f, 0.848840177f, 0.f),
    C_Vertex3f(0.179483175f, 0.304547191f, 0.f),
    C_Vertex3f(0.179483175f, 0.304547191f, -1.f),
    C_Normal3f(0.435899973f, 0.899995148f, 0.f),
    C_Vertex3f(0.190311909f, 0.298571825f, 0.f),
    C_Vertex3f(0.190311909f, 0.298571825f, -1.f),
    C_Normal3f(0.337836415f, 0.941204846f, 0.f),
    C_Vertex3f(0.201690197f, 0.293791533f, 0.f),
    C_Vertex3f(0.201690197f, 0.293791533f, -1.f),
    C_Normal3f(0.237815097f, 0.971310437f, 0.f),
    C_Vertex3f(0.21361804f, 0.290206313f, 0.f),
    C_Vertex3f(0.21361804f, 0.290206313f, -1.f),
    C_Normal3f(0.139204189f, 0.990263641f, 0.f),
    C_Vertex3f(0.226095438f, 0.287816167f, 0.f),
    C_Vertex3f(0.226095438f, 0.287816167f, -1.f),
    C_Normal3f(0.0448363572f, 0.99899435f, 0.f),
    C_Vertex3f(0.239122391f, 0.286621094f, 0.f),
    C_Vertex3f(0.239122391f, 0.286621094f, -1.f),
    C_Normal3f(-0.0448513888f, 0.998993695f, 0.f),
    C_Vertex3f(0.25272274f, 0.286621094f, 0.f),
    C_Vertex3f(0.25272274f, 0.286621094f, -1.f),
    C_Normal3f(-0.139604107f, 0.990207374f, 0.f),
    C_Vertex3f(0.265740752f, 0.287816167f, 0.f),
    C_Vertex3f(0.265740752f, 0.287816167f, -1.f),
    C_Normal3f(-0.239553437f, 0.970883191f, 0.f),
    C_Vertex3f(0.278152585f, 0.290206313f, 0.f),
    C_Vertex3f(0.278152585f, 0.290206313f, -1.f),
    C_Normal3f(-0.341743469f, 0.939793289f, 0.f),
    C_Vertex3f(0.289958239f, 0.293791533f, 0.f),
    C_Vertex3f(0.289958239f, 0.293791533f, -1.f),
    C_Normal3f(-0.442575127f, 0.896731496f, 0.f),
    C_Vertex3f(0.301157713f, 0.298571825f, 0.f),
    C_Vertex3f(0.301157713f, 0.298571825f, -1.f),
    C_Normal3f(-0.538308084f, 0.842748165f, 0.f),
    C_Vertex3f(0.311751008f, 0.304547191f, 0.f),
    C_Vertex3f(0.311751008f, 0.304547191f, -1.f),
    C_Normal3f(-0.625713885f, 0.780052602f, 0.f),
    C_Vertex3f(0.321738124f, 0.311717629f, 0.f),
    C_Vertex3f(0.321738124f, 0.311717629f, -1.f),
    C_Normal3f(-0.702593148f, 0.711591899f, 0.f),
    C_Vertex3f(0.331119061f, 0.320083141f, 0.f),
    C_Vertex3f(0.331119061f, 0.320083141f, -1.f),
    C_Normal3f(-0.772938728f, 0.634480715f, 0.f),
    C_Vertex3f(0.339893818f, 0.329643726f, 0.f),
    C_Vertex3f(0.339893818f, 0.329643726f, -1.f),
    C_Normal3f(-0.837872505f, 0.545865953f, 0.f),
    C_Vertex3f(0.347571731f, 0.340126157f, 0.f),
    C_Vertex3f(0.347571731f, 0.340126157f, -1.f),
    C_Normal3f(-0.891400456f, 0.453216463f, 0.f),
    C_Vertex3f(0.354152799f, 0.351530433f, 0.f),
    C_Vertex3f(0.354152799f, 0.351530433f, -1.f),
    C_Normal3f(-0.932912111f, 0.360104203f, 0.f),
    C_Vertex3f(0.359637022f, 0.363856554f, 0.f),
    C_Vertex3f(0.359637022f, 0.363856554f, -1.f),
    C_Normal3f(-0.962955475f, 0.269660354f, 0.f),
    C_Vertex3f(0.364024401f, 0.377104521f, 0.f),
    C_Vertex3f(0.364024401f, 0.377104521f, -1.f),
    C_Normal3f(-0.982886195f, 0.184213832f, 0.f),
    C_Vertex3f(0.367314935f, 0.391274333f, 0.f),
    C_Vertex3f(0.367314935f, 0.391274333f, -1.f),
    C_Normal3f(-0.994450986f, 0.105200388f, 0.f),
    C_Vertex3f(0.369508624f, 0.406365991f, 0.f),
    C_Vertex3f(0.369508624f, 0.406365991f, -1.f),
    C_Normal3f(-0.999446273f, 0.0332718454f, 0.f),
    C_Vertex3f(0.370605469f, 0.422379494f, 0.f),
    C_Vertex3f(0.370605469f, 0.422379494f, -1.f),
    C_End(),
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.371190071f, 0.595930696f, 0.f),
    C_Vertex3f(0.359033108f, 0.605232239f, 0.f),
    C_Vertex3f(0.359403372f, 0.498309612f, 0.f),
    C_Vertex3f(0.363884211f, 0.484871387f, 0.f),
    C_Vertex3f(0.36724484f, 0.470559359f, 0.f),
    C_Vertex3f(0.369485259f, 0.455373526f, 0.f),
    C_Vertex3f(0.370605469f, 0.439313889f, 0.f),
    C_Vertex3f(0.373500824f, 0.292232513f, 0.f),
    C_Vertex3f(0.382569313f, 0.585735202f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.320848346f, 0.552024603f, 0.f),
    C_Vertex3f(0.33027792f, 0.543324471f, 0.f),
    C_Vertex3f(0.332829356f, 0.620996475f, 0.f),
    C_Vertex3f(0.339239597f, 0.533381462f, 0.f),
    C_Vertex3f(0.346098423f, 0.613639832f, 0.f),
    C_Vertex3f(0.347081065f, 0.52256465f, 0.f),
    C_Vertex3f(0.359033108f, 0.605232239f, 0.f),
    C_Vertex3f(0.353802323f, 0.510874033f, 0.f),
    C_Vertex3f(0.359403372f, 0.498309612f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.278451085f, 0.574396372f, 0.f),
    C_Vertex3f(0.289752245f, 0.570667744f, 0.f),
    C_Vertex3f(0.291015863f, 0.636760712f, 0.f),
    C_Vertex3f(0.300585508f, 0.565696239f, 0.f),
    C_Vertex3f(0.305288076f, 0.632556915f, 0.f),
    C_Vertex3f(0.310950875f, 0.559481859f, 0.f),
    C_Vertex3f(0.319225907f, 0.62730217f, 0.f),
    C_Vertex3f(0.320848346f, 0.552024603f, 0.f),
    C_Vertex3f(0.332829356f, 0.620996475f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.228814125f, 0.576786518f, 0.f),
    C_Vertex3f(0.241521835f, 0.578125f, 0.f),
    C_Vertex3f(0.246192932f, 0.643066406f, 0.f),
    C_Vertex3f(0.254445076f, 0.578125f, 0.f),
    C_Vertex3f(0.261468291f, 0.642015457f, 0.f),
    C_Vertex3f(0.266682029f, 0.576882124f, 0.f),
    C_Vertex3f(0.276409268f, 0.639913559f, 0.f),
    C_Vertex3f(0.278451085f, 0.574396372f, 0.f),
    C_Vertex3f(0.291015863f, 0.636760712f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.193294525f, 0.564740181f, 0.f),
    C_Vertex3f(0.20470047f, 0.570094109f, 0.f),
    C_Vertex3f(0.206877112f, 0.641210437f, 0.f),
    C_Vertex3f(0.216540337f, 0.574109554f, 0.f),
    C_Vertex3f(0.227581978f, 0.643066406f, 0.f),
    C_Vertex3f(0.228814125f, 0.576786518f, 0.f),
    C_Vertex3f(0.246192932f, 0.643066406f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.187079549f, 0.637498498f, 0.f),
    C_Vertex3f(0.168189287f, 0.63193059f, 0.f),
    C_Vertex3f(0.171784401f, 0.55001688f, 0.f),
    C_Vertex3f(0.182322502f, 0.558047771f, 0.f),
    C_Vertex3f(0.193294525f, 0.564740181f, 0.f),
    C_Vertex3f(0.206877112f, 0.641210437f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.136295795f, 0.506147861f, 0.f),
    C_Vertex3f(0.143548489f, 0.51843977f, 0.f),
    C_Vertex3f(0.150206327f, 0.624506712f, 0.f),
    C_Vertex3f(0.152009964f, 0.529939651f, 0.f),
    C_Vertex3f(0.168189287f, 0.63193059f, 0.f),
    C_Vertex3f(0.161680222f, 0.540647507f, 0.f),
    C_Vertex3f(0.171784401f, 0.55001688f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.13313067f, 0.615226865f, 0.f),
    C_Vertex3f(0.116962314f, 0.604091048f, 0.f),
    C_Vertex3f(0.119372845f, 0.449059963f, 0.f),
    C_Vertex3f(0.121790409f, 0.464519978f, 0.f),
    C_Vertex3f(0.125416756f, 0.479187965f, 0.f),
    C_Vertex3f(0.130251884f, 0.493063927f, 0.f),
    C_Vertex3f(0.136295795f, 0.506147861f, 0.f),
    C_Vertex3f(0.150206327f, 0.624506712f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.037109375f, 0.43907547f, 0.f),
    C_Vertex3f(0.0388284922f, 0.392675519f, 0.f),
    C_Vertex3f(0.038903594f, 0.462233663f, 0.f),
    C_Vertex3f(0.0422667265f, 0.371385932f, 0.f),
    C_Vertex3f(0.0424920321f, 0.48420465f, 0.f),
    C_Vertex3f(0.047424078f, 0.351242781f, 0.f),
    C_Vertex3f(0.0478746891f, 0.504988432f, 0.f),
    C_Vertex3f(0.0543005466f, 0.332246065f, 0.f),
    C_Vertex3f(0.0550515652f, 0.524585009f, 0.f),
    C_Vertex3f(0.0628961325f, 0.314395785f, 0.f),
    C_Vertex3f(0.0640226603f, 0.54299438f, 0.f),
    C_Vertex3f(0.0732108355f, 0.297691941f, 0.f),
    C_Vertex3f(0.0747879744f, 0.560216546f, 0.f),
    C_Vertex3f(0.0852446556f, 0.282134533f, 0.f),
    C_Vertex3f(0.0873475075f, 0.576251507f, 0.f),
    C_Vertex3f(0.0989975929f, 0.26772356f, 0.f),
    C_Vertex3f(0.10170126f, 0.591099262f, 0.f),
    C_Vertex3f(0.113514304f, 0.255113959f, 0.f),
    C_Vertex3f(0.116962314f, 0.604091048f, 0.f),
    C_Vertex3f(0.118164063f, 0.416638374f, 0.f),
    C_Vertex3f(0.118164063f, 0.432807922f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.458007813f, 0.318071365f, 0.f),
    C_Vertex3f(0.458007813f, 0.348152161f, 0.f),
    C_Vertex3f(0.457175374f, 0.288952589f, 0.f),
    C_Vertex3f(0.457168698f, 0.375892043f, 0.f),
    C_Vertex3f(0.455510497f, 0.261396646f, 0.f),
    C_Vertex3f(0.45549047f, 0.401891828f, 0.f),
    C_Vertex3f(0.453013182f, 0.235403538f, 0.f),
    C_Vertex3f(0.452973127f, 0.426151514f, 0.f),
    C_Vertex3f(0.449683428f, 0.210973263f, 0.f),
    C_Vertex3f(0.449616671f, 0.448671103f, 0.f),
    C_Vertex3f(0.445521235f, 0.188105822f, 0.f),
    C_Vertex3f(0.4454211f, 0.469450593f, 0.f),
    C_Vertex3f(0.440526605f, 0.166801214f, 0.f),
    C_Vertex3f(0.440386415f, 0.488489985f, 0.f),
    C_Vertex3f(0.434699535f, 0.147059441f, 0.f),
    C_Vertex3f(0.434512615f, 0.50578928f, 0.f),
    C_Vertex3f(0.428040028f, 0.128880501f, 0.f),
    C_Vertex3f(0.427799702f, 0.521348476f, 0.f),
    C_Vertex3f(0.420568585f, 0.111786485f, 0.f),
    C_Vertex3f(0.420309067f, 0.536013722f, 0.f),
    C_Vertex3f(0.412285209f, 0.0957773924f, 0.f),
    C_Vertex3f(0.41204071f, 0.549785018f, 0.f),
    C_Vertex3f(0.403189898f, 0.0808532238f, 0.f),
    C_Vertex3f(0.402994633f, 0.562662363f, 0.f),
    C_Vertex3f(0.393282652f, 0.067013979f, 0.f),
    C_Vertex3f(0.393170834f, 0.574645758f, 0.f),
    C_Vertex3f(0.382569313f, 0.585735202f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.382563472f, 0.0542596579f, 0.f),
    C_Vertex3f(0.393282652f, 0.067013979f, 0.f),
    C_Vertex3f(0.382569313f, 0.585735202f, 0.f),
    C_Vertex3f(0.379837036f, 0.288516998f, 0.f),
    C_Vertex3f(0.379837036f, 0.273658752f, 0.f),
    C_Vertex3f(0.378363609f, 0.249399185f, 0.f),
    C_Vertex3f(0.375416756f, 0.225355148f, 0.f),
    C_Vertex3f(0.371032357f, 0.0425902605f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.382569313f, 0.585735202f, 0.f),
    C_Vertex3f(0.373500824f, 0.292232513f, 0.f),
    C_Vertex3f(0.379394531f, 0.301628113f, 0.f),
    C_Vertex3f(0.379615784f, 0.296382904f, 0.f),
    C_Vertex3f(0.379837036f, 0.288516998f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.373500824f, 0.292232513f, 0.f),
    C_Vertex3f(0.370605469f, 0.439313889f, 0.f),
    C_Vertex3f(0.370605469f, 0.422379494f, 0.f),
    C_Vertex3f(0.369508624f, 0.406365991f, 0.f),
    C_Vertex3f(0.367314935f, 0.391274333f, 0.f),
    C_Vertex3f(0.364024401f, 0.377104521f, 0.f),
    C_Vertex3f(0.359637022f, 0.363856554f, 0.f),
    C_Vertex3f(0.359557629f, 0.275216579f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.359637022f, 0.363856554f, 0.f),
    C_Vertex3f(0.354152799f, 0.351530433f, 0.f),
    C_Vertex3f(0.359557629f, 0.275216579f, 0.f),
    C_Vertex3f(0.347571731f, 0.340126157f, 0.f),
    C_Vertex3f(0.343458652f, 0.25997591f, 0.f),
    C_Vertex3f(0.339893818f, 0.329643726f, 0.f),
    C_Vertex3f(0.331119061f, 0.320083141f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.325203896f, 0.246510506f, 0.f),
    C_Vertex3f(0.343458652f, 0.25997591f, 0.f),
    C_Vertex3f(0.331119061f, 0.320083141f, 0.f),
    C_Vertex3f(0.321738124f, 0.311717629f, 0.f),
    C_Vertex3f(0.311751008f, 0.304547191f, 0.f),
    C_Vertex3f(0.304793358f, 0.234820366f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.311751008f, 0.304547191f, 0.f),
    C_Vertex3f(0.301157713f, 0.298571825f, 0.f),
    C_Vertex3f(0.304793358f, 0.234820366f, 0.f),
    C_Vertex3f(0.289958239f, 0.293791533f, 0.f),
    C_Vertex3f(0.283536434f, 0.226052761f, 0.f),
    C_Vertex3f(0.278152585f, 0.290206313f, 0.f),
    C_Vertex3f(0.265740752f, 0.287816167f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.261433125f, 0.220207691f, 0.f),
    C_Vertex3f(0.283536434f, 0.226052761f, 0.f),
    C_Vertex3f(0.265740752f, 0.287816167f, 0.f),
    C_Vertex3f(0.25272274f, 0.286621094f, 0.f),
    C_Vertex3f(0.239122391f, 0.286621094f, 0.f),
    C_Vertex3f(0.238483429f, 0.217285156f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.226095438f, 0.287816167f, 0.f),
    C_Vertex3f(0.21361804f, 0.290206313f, 0.f),
    C_Vertex3f(0.216653824f, 0.217285156f, 0.f),
    C_Vertex3f(0.238483429f, 0.217285156f, 0.f),
    C_Vertex3f(0.239122391f, 0.286621094f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.201690197f, 0.293791533f, 0.f),
    C_Vertex3f(0.190311909f, 0.298571825f, 0.f),
    C_Vertex3f(0.197554469f, 0.219086528f, 0.f),
    C_Vertex3f(0.216653824f, 0.217285156f, 0.f),
    C_Vertex3f(0.21361804f, 0.290206313f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.159474373f, 0.320083141f, 0.f),
    C_Vertex3f(0.161647081f, 0.228093386f, 0.f),
    C_Vertex3f(0.169203997f, 0.311717629f, 0.f),
    C_Vertex3f(0.179218888f, 0.222689271f, 0.f),
    C_Vertex3f(0.179483175f, 0.304547191f, 0.f),
    C_Vertex3f(0.197554469f, 0.219086528f, 0.f),
    C_Vertex3f(0.190311909f, 0.298571825f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.150294304f, 0.329643726f, 0.f),
    C_Vertex3f(0.142261744f, 0.339921117f, 0.f),
    C_Vertex3f(0.144839048f, 0.235298872f, 0.f),
    C_Vertex3f(0.161647081f, 0.228093386f, 0.f),
    C_Vertex3f(0.159474373f, 0.320083141f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.142261744f, 0.339921117f, 0.f),
    C_Vertex3f(0.135376692f, 0.350915313f, 0.f),
    C_Vertex3f(0.144839048f, 0.235298872f, 0.f),
    C_Vertex3f(0.129639149f, 0.362626314f, 0.f),
    C_Vertex3f(0.128794789f, 0.24430573f, 0.f),
    C_Vertex3f(0.125049114f, 0.375054121f, 0.f),
    C_Vertex3f(0.121606588f, 0.388198733f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.128794789f, 0.24430573f, 0.f),
    C_Vertex3f(0.121606588f, 0.388198733f, 0.f),
    C_Vertex3f(0.119311571f, 0.402060151f, 0.f),
    C_Vertex3f(0.118164063f, 0.416638374f, 0.f),
    C_Vertex3f(0.113514304f, 0.255113959f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.375416756f, 0.225355148f, 0.f),
    C_Vertex3f(0.370996475f, 0.201526642f, 0.f),
    C_Vertex3f(0.371032357f, 0.0425902605f, 0.f),
    C_Vertex3f(0.365102768f, 0.177913666f, 0.f),
    C_Vertex3f(0.358689308f, 0.0320057869f, 0.f),
    C_Vertex3f(0.358515739f, 0.156732559f, 0.f),
    C_Vertex3f(0.35123539f, 0.137983322f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.345534325f, 0.022506237f, 0.f),
    C_Vertex3f(0.358689308f, 0.0320057869f, 0.f),
    C_Vertex3f(0.35123539f, 0.137983322f, 0.f),
    C_Vertex3f(0.343261719f, 0.121665955f, 0.f),
    C_Vertex3f(0.334594727f, 0.107780457f, 0.f),
    C_Vertex3f(0.331812859f, 0.0141941309f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.30104351f, 0.0744867325f, 0.f),
    C_Vertex3f(0.302670479f, 0.00113224983f, 0.f),
    C_Vertex3f(0.313485622f, 0.0841908455f, 0.f),
    C_Vertex3f(0.31752491f, 0.0070694685f, 0.f),
    C_Vertex3f(0.324669361f, 0.0952887535f, 0.f),
    C_Vertex3f(0.331812859f, 0.0141941309f, 0.f),
    C_Vertex3f(0.334594727f, 0.107780457f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.201437473f, -0.0094370842f, 0.f),
    C_Vertex3f(0.219355583f, -0.0107421875f, 0.f),
    C_Vertex3f(0.219984055f, 0.0537109375f, 0.f),
    C_Vertex3f(0.237587929f, -0.0107421875f, 0.f),
    C_Vertex3f(0.239624023f, 0.0537109375f, 0.f),
    C_Vertex3f(0.25470829f, -0.00955474377f, 0.f),
    C_Vertex3f(0.256633282f, 0.055788517f, 0.f),
    C_Vertex3f(0.271262169f, -0.0071798563f, 0.f),
    C_Vertex3f(0.272539616f, 0.059943676f, 0.f),
    C_Vertex3f(0.287249565f, -0.0036175251f, 0.f),
    C_Vertex3f(0.287343025f, 0.0661764145f, 0.f),
    C_Vertex3f(0.302670479f, 0.00113224983f, 0.f),
    C_Vertex3f(0.30104351f, 0.0744867325f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.167939186f, 0.0717697144f, 0.f),
    C_Vertex3f(0.168180466f, -0.00291156769f, 0.f),
    C_Vertex3f(0.183377743f, 0.0627403259f, 0.f),
    C_Vertex3f(0.184379101f, -0.00682687759f, 0.f),
    C_Vertex3f(0.200726032f, 0.0567207336f, 0.f),
    C_Vertex3f(0.201437473f, -0.0094370842f, 0.f),
    C_Vertex3f(0.219984055f, 0.0537109375f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.157792568f, 0.0807991028f, 0.f),
    C_Vertex3f(0.151573539f, 0.0877351761f, 0.f),
    C_Vertex3f(0.152841568f, 0.00230884552f, 0.f),
    C_Vertex3f(0.168180466f, -0.00291156769f, 0.f),
    C_Vertex3f(0.167939186f, 0.0717697144f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.151573539f, 0.0877351761f, 0.f),
    C_Vertex3f(0.145899892f, 0.0955877304f, 0.f),
    C_Vertex3f(0.152841568f, 0.00230884552f, 0.f),
    C_Vertex3f(0.140771627f, 0.104356766f, 0.f),
    C_Vertex3f(0.138362408f, 0.00883436203f, 0.f),
    C_Vertex3f(0.136188745f, 0.114042282f, 0.f),
    C_Vertex3f(0.132151246f, 0.124644279f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.100083351f, 0.0362415314f, 0.f),
    C_Vertex3f(0.111983299f, 0.025800705f, 0.f),
    C_Vertex3f(0.124511719f, 0.155273438f, 0.f),
    C_Vertex3f(0.124742985f, 0.0166649818f, 0.f),
    C_Vertex3f(0.125712395f, 0.148597717f, 0.f),
    C_Vertex3f(0.138362408f, 0.00883436203f, 0.f),
    C_Vertex3f(0.128659129f, 0.136162758f, 0.f),
    C_Vertex3f(0.132151246f, 0.124644279f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.124511719f, 0.155273438f, 0.f),
    C_Vertex3f(0.048828125f, 0.1484375f, 0.f),
    C_Vertex3f(0.050028801f, 0.138980865f, 0.f),
    C_Vertex3f(0.0536174774f, 0.121126652f, 0.f),
    C_Vertex3f(0.0583934784f, 0.104331493f, 0.f),
    C_Vertex3f(0.0643568039f, 0.0885953903f, 0.f),
    C_Vertex3f(0.0715074539f, 0.0739183426f, 0.f),
    C_Vertex3f(0.0798454285f, 0.0603003502f, 0.f),
    C_Vertex3f(0.0893707275f, 0.0477414131f, 0.f),
    C_Vertex3f(0.100083351f, 0.0362415314f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.0388284922f, 0.392675519f, 0.f),
    C_Vertex3f(0.037109375f, 0.43907547f, 0.f),
    C_Vertex3f(0.037109375f, 0.415111542f, 0.f),
    C_Vertex3f(0.119372845f, 0.449059963f, 0.f),
    C_Vertex3f(0.116962314f, 0.604091048f, 0.f),
    C_Vertex3f(0.118164063f, 0.432807922f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, -1.f),
    C_FrontFace(GL_CW),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.371190071f, 0.595930696f, -1.f),
    C_Vertex3f(0.359033108f, 0.605232239f, -1.f),
    C_Vertex3f(0.359403372f, 0.498309612f, -1.f),
    C_Vertex3f(0.363884211f, 0.484871387f, -1.f),
    C_Vertex3f(0.36724484f, 0.470559359f, -1.f),
    C_Vertex3f(0.369485259f, 0.455373526f, -1.f),
    C_Vertex3f(0.370605469f, 0.439313889f, -1.f),
    C_Vertex3f(0.373500824f, 0.292232513f, -1.f),
    C_Vertex3f(0.382569313f, 0.585735202f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.320848346f, 0.552024603f, -1.f),
    C_Vertex3f(0.33027792f, 0.543324471f, -1.f),
    C_Vertex3f(0.332829356f, 0.620996475f, -1.f),
    C_Vertex3f(0.339239597f, 0.533381462f, -1.f),
    C_Vertex3f(0.346098423f, 0.613639832f, -1.f),
    C_Vertex3f(0.347081065f, 0.52256465f, -1.f),
    C_Vertex3f(0.359033108f, 0.605232239f, -1.f),
    C_Vertex3f(0.353802323f, 0.510874033f, -1.f),
    C_Vertex3f(0.359403372f, 0.498309612f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.278451085f, 0.574396372f, -1.f),
    C_Vertex3f(0.289752245f, 0.570667744f, -1.f),
    C_Vertex3f(0.291015863f, 0.636760712f, -1.f),
    C_Vertex3f(0.300585508f, 0.565696239f, -1.f),
    C_Vertex3f(0.305288076f, 0.632556915f, -1.f),
    C_Vertex3f(0.310950875f, 0.559481859f, -1.f),
    C_Vertex3f(0.319225907f, 0.62730217f, -1.f),
    C_Vertex3f(0.320848346f, 0.552024603f, -1.f),
    C_Vertex3f(0.332829356f, 0.620996475f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.228814125f, 0.576786518f, -1.f),
    C_Vertex3f(0.241521835f, 0.578125f, -1.f),
    C_Vertex3f(0.246192932f, 0.643066406f, -1.f),
    C_Vertex3f(0.254445076f, 0.578125f, -1.f),
    C_Vertex3f(0.261468291f, 0.642015457f, -1.f),
    C_Vertex3f(0.266682029f, 0.576882124f, -1.f),
    C_Vertex3f(0.276409268f, 0.639913559f, -1.f),
    C_Vertex3f(0.278451085f, 0.574396372f, -1.f),
    C_Vertex3f(0.291015863f, 0.636760712f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.193294525f, 0.564740181f, -1.f),
    C_Vertex3f(0.20470047f, 0.570094109f, -1.f),
    C_Vertex3f(0.206877112f, 0.641210437f, -1.f),
    C_Vertex3f(0.216540337f, 0.574109554f, -1.f),
    C_Vertex3f(0.227581978f, 0.643066406f, -1.f),
    C_Vertex3f(0.228814125f, 0.576786518f, -1.f),
    C_Vertex3f(0.246192932f, 0.643066406f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.187079549f, 0.637498498f, -1.f),
    C_Vertex3f(0.168189287f, 0.63193059f, -1.f),
    C_Vertex3f(0.171784401f, 0.55001688f, -1.f),
    C_Vertex3f(0.182322502f, 0.558047771f, -1.f),
    C_Vertex3f(0.193294525f, 0.564740181f, -1.f),
    C_Vertex3f(0.206877112f, 0.641210437f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.136295795f, 0.506147861f, -1.f),
    C_Vertex3f(0.143548489f, 0.51843977f, -1.f),
    C_Vertex3f(0.150206327f, 0.624506712f, -1.f),
    C_Vertex3f(0.152009964f, 0.529939651f, -1.f),
    C_Vertex3f(0.168189287f, 0.63193059f, -1.f),
    C_Vertex3f(0.161680222f, 0.540647507f, -1.f),
    C_Vertex3f(0.171784401f, 0.55001688f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.13313067f, 0.615226865f, -1.f),
    C_Vertex3f(0.116962314f, 0.604091048f, -1.f),
    C_Vertex3f(0.119372845f, 0.449059963f, -1.f),
    C_Vertex3f(0.121790409f, 0.464519978f, -1.f),
    C_Vertex3f(0.125416756f, 0.479187965f, -1.f),
    C_Vertex3f(0.130251884f, 0.493063927f, -1.f),
    C_Vertex3f(0.136295795f, 0.506147861f, -1.f),
    C_Vertex3f(0.150206327f, 0.624506712f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.037109375f, 0.43907547f, -1.f),
    C_Vertex3f(0.0388284922f, 0.392675519f, -1.f),
    C_Vertex3f(0.038903594f, 0.462233663f, -1.f),
    C_Vertex3f(0.0422667265f, 0.371385932f, -1.f),
    C_Vertex3f(0.0424920321f, 0.48420465f, -1.f),
    C_Vertex3f(0.047424078f, 0.351242781f, -1.f),
    C_Vertex3f(0.0478746891f, 0.504988432f, -1.f),
    C_Vertex3f(0.0543005466f, 0.332246065f, -1.f),
    C_Vertex3f(0.0550515652f, 0.524585009f, -1.f),
    C_Vertex3f(0.0628961325f, 0.314395785f, -1.f),
    C_Vertex3f(0.0640226603f, 0.54299438f, -1.f),
    C_Vertex3f(0.0732108355f, 0.297691941f, -1.f),
    C_Vertex3f(0.0747879744f, 0.560216546f, -1.f),
    C_Vertex3f(0.0852446556f, 0.282134533f, -1.f),
    C_Vertex3f(0.0873475075f, 0.576251507f, -1.f),
    C_Vertex3f(0.0989975929f, 0.26772356f, -1.f),
    C_Vertex3f(0.10170126f, 0.591099262f, -1.f),
    C_Vertex3f(0.113514304f, 0.255113959f, -1.f),
    C_Vertex3f(0.116962314f, 0.604091048f, -1.f),
    C_Vertex3f(0.118164063f, 0.416638374f, -1.f),
    C_Vertex3f(0.118164063f, 0.432807922f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.458007813f, 0.318071365f, -1.f),
    C_Vertex3f(0.458007813f, 0.348152161f, -1.f),
    C_Vertex3f(0.457175374f, 0.288952589f, -1.f),
    C_Vertex3f(0.457168698f, 0.375892043f, -1.f),
    C_Vertex3f(0.455510497f, 0.261396646f, -1.f),
    C_Vertex3f(0.45549047f, 0.401891828f, -1.f),
    C_Vertex3f(0.453013182f, 0.235403538f, -1.f),
    C_Vertex3f(0.452973127f, 0.426151514f, -1.f),
    C_Vertex3f(0.449683428f, 0.210973263f, -1.f),
    C_Vertex3f(0.449616671f, 0.448671103f, -1.f),
    C_Vertex3f(0.445521235f, 0.188105822f, -1.f),
    C_Vertex3f(0.4454211f, 0.469450593f, -1.f),
    C_Vertex3f(0.440526605f, 0.166801214f, -1.f),
    C_Vertex3f(0.440386415f, 0.488489985f, -1.f),
    C_Vertex3f(0.434699535f, 0.147059441f, -1.f),
    C_Vertex3f(0.434512615f, 0.50578928f, -1.f),
    C_Vertex3f(0.428040028f, 0.128880501f, -1.f),
    C_Vertex3f(0.427799702f, 0.521348476f, -1.f),
    C_Vertex3f(0.420568585f, 0.111786485f, -1.f),
    C_Vertex3f(0.420309067f, 0.536013722f, -1.f),
    C_Vertex3f(0.412285209f, 0.0957773924f, -1.f),
    C_Vertex3f(0.41204071f, 0.549785018f, -1.f),
    C_Vertex3f(0.403189898f, 0.0808532238f, -1.f),
    C_Vertex3f(0.402994633f, 0.562662363f, -1.f),
    C_Vertex3f(0.393282652f, 0.067013979f, -1.f),
    C_Vertex3f(0.393170834f, 0.574645758f, -1.f),
    C_Vertex3f(0.382569313f, 0.585735202f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.382563472f, 0.0542596579f, -1.f),
    C_Vertex3f(0.393282652f, 0.067013979f, -1.f),
    C_Vertex3f(0.382569313f, 0.585735202f, -1.f),
    C_Vertex3f(0.379837036f, 0.288516998f, -1.f),
    C_Vertex3f(0.379837036f, 0.273658752f, -1.f),
    C_Vertex3f(0.378363609f, 0.249399185f, -1.f),
    C_Vertex3f(0.375416756f, 0.225355148f, -1.f),
    C_Vertex3f(0.371032357f, 0.0425902605f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.382569313f, 0.585735202f, -1.f),
    C_Vertex3f(0.373500824f, 0.292232513f, -1.f),
    C_Vertex3f(0.379394531f, 0.301628113f, -1.f),
    C_Vertex3f(0.379615784f, 0.296382904f, -1.f),
    C_Vertex3f(0.379837036f, 0.288516998f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.373500824f, 0.292232513f, -1.f),
    C_Vertex3f(0.370605469f, 0.439313889f, -1.f),
    C_Vertex3f(0.370605469f, 0.422379494f, -1.f),
    C_Vertex3f(0.369508624f, 0.406365991f, -1.f),
    C_Vertex3f(0.367314935f, 0.391274333f, -1.f),
    C_Vertex3f(0.364024401f, 0.377104521f, -1.f),
    C_Vertex3f(0.359637022f, 0.363856554f, -1.f),
    C_Vertex3f(0.359557629f, 0.275216579f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.359637022f, 0.363856554f, -1.f),
    C_Vertex3f(0.354152799f, 0.351530433f, -1.f),
    C_Vertex3f(0.359557629f, 0.275216579f, -1.f),
    C_Vertex3f(0.347571731f, 0.340126157f, -1.f),
    C_Vertex3f(0.343458652f, 0.25997591f, -1.f),
    C_Vertex3f(0.339893818f, 0.329643726f, -1.f),
    C_Vertex3f(0.331119061f, 0.320083141f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.325203896f, 0.246510506f, -1.f),
    C_Vertex3f(0.343458652f, 0.25997591f, -1.f),
    C_Vertex3f(0.331119061f, 0.320083141f, -1.f),
    C_Vertex3f(0.321738124f, 0.311717629f, -1.f),
    C_Vertex3f(0.311751008f, 0.304547191f, -1.f),
    C_Vertex3f(0.304793358f, 0.234820366f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.311751008f, 0.304547191f, -1.f),
    C_Vertex3f(0.301157713f, 0.298571825f, -1.f),
    C_Vertex3f(0.304793358f, 0.234820366f, -1.f),
    C_Vertex3f(0.289958239f, 0.293791533f, -1.f),
    C_Vertex3f(0.283536434f, 0.226052761f, -1.f),
    C_Vertex3f(0.278152585f, 0.290206313f, -1.f),
    C_Vertex3f(0.265740752f, 0.287816167f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.261433125f, 0.220207691f, -1.f),
    C_Vertex3f(0.283536434f, 0.226052761f, -1.f),
    C_Vertex3f(0.265740752f, 0.287816167f, -1.f),
    C_Vertex3f(0.25272274f, 0.286621094f, -1.f),
    C_Vertex3f(0.239122391f, 0.286621094f, -1.f),
    C_Vertex3f(0.238483429f, 0.217285156f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.226095438f, 0.287816167f, -1.f),
    C_Vertex3f(0.21361804f, 0.290206313f, -1.f),
    C_Vertex3f(0.216653824f, 0.217285156f, -1.f),
    C_Vertex3f(0.238483429f, 0.217285156f, -1.f),
    C_Vertex3f(0.239122391f, 0.286621094f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.201690197f, 0.293791533f, -1.f),
    C_Vertex3f(0.190311909f, 0.298571825f, -1.f),
    C_Vertex3f(0.197554469f, 0.219086528f, -1.f),
    C_Vertex3f(0.216653824f, 0.217285156f, -1.f),
    C_Vertex3f(0.21361804f, 0.290206313f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.159474373f, 0.320083141f, -1.f),
    C_Vertex3f(0.161647081f, 0.228093386f, -1.f),
    C_Vertex3f(0.169203997f, 0.311717629f, -1.f),
    C_Vertex3f(0.179218888f, 0.222689271f, -1.f),
    C_Vertex3f(0.179483175f, 0.304547191f, -1.f),
    C_Vertex3f(0.197554469f, 0.219086528f, -1.f),
    C_Vertex3f(0.190311909f, 0.298571825f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.150294304f, 0.329643726f, -1.f),
    C_Vertex3f(0.142261744f, 0.339921117f, -1.f),
    C_Vertex3f(0.144839048f, 0.235298872f, -1.f),
    C_Vertex3f(0.161647081f, 0.228093386f, -1.f),
    C_Vertex3f(0.159474373f, 0.320083141f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.142261744f, 0.339921117f, -1.f),
    C_Vertex3f(0.135376692f, 0.350915313f, -1.f),
    C_Vertex3f(0.144839048f, 0.235298872f, -1.f),
    C_Vertex3f(0.129639149f, 0.362626314f, -1.f),
    C_Vertex3f(0.128794789f, 0.24430573f, -1.f),
    C_Vertex3f(0.125049114f, 0.375054121f, -1.f),
    C_Vertex3f(0.121606588f, 0.388198733f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.128794789f, 0.24430573f, -1.f),
    C_Vertex3f(0.121606588f, 0.388198733f, -1.f),
    C_Vertex3f(0.119311571f, 0.402060151f, -1.f),
    C_Vertex3f(0.118164063f, 0.416638374f, -1.f),
    C_Vertex3f(0.113514304f, 0.255113959f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.375416756f, 0.225355148f, -1.f),
    C_Vertex3f(0.370996475f, 0.201526642f, -1.f),
    C_Vertex3f(0.371032357f, 0.0425902605f, -1.f),
    C_Vertex3f(0.365102768f, 0.177913666f, -1.f),
    C_Vertex3f(0.358689308f, 0.0320057869f, -1.f),
    C_Vertex3f(0.358515739f, 0.156732559f, -1.f),
    C_Vertex3f(0.35123539f, 0.137983322f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.345534325f, 0.022506237f, -1.f),
    C_Vertex3f(0.358689308f, 0.0320057869f, -1.f),
    C_Vertex3f(0.35123539f, 0.137983322f, -1.f),
    C_Vertex3f(0.343261719f, 0.121665955f, -1.f),
    C_Vertex3f(0.334594727f, 0.107780457f, -1.f),
    C_Vertex3f(0.331812859f, 0.0141941309f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.30104351f, 0.0744867325f, -1.f),
    C_Vertex3f(0.302670479f, 0.00113224983f, -1.f),
    C_Vertex3f(0.313485622f, 0.0841908455f, -1.f),
    C_Vertex3f(0.31752491f, 0.0070694685f, -1.f),
    C_Vertex3f(0.324669361f, 0.0952887535f, -1.f),
    C_Vertex3f(0.331812859f, 0.0141941309f, -1.f),
    C_Vertex3f(0.334594727f, 0.107780457f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.201437473f, -0.0094370842f, -1.f),
    C_Vertex3f(0.219355583f, -0.0107421875f, -1.f),
    C_Vertex3f(0.219984055f, 0.0537109375f, -1.f),
    C_Vertex3f(0.237587929f, -0.0107421875f, -1.f),
    C_Vertex3f(0.239624023f, 0.0537109375f, -1.f),
    C_Vertex3f(0.25470829f, -0.00955474377f, -1.f),
    C_Vertex3f(0.256633282f, 0.055788517f, -1.f),
    C_Vertex3f(0.271262169f, -0.0071798563f, -1.f),
    C_Vertex3f(0.272539616f, 0.059943676f, -1.f),
    C_Vertex3f(0.287249565f, -0.0036175251f, -1.f),
    C_Vertex3f(0.287343025f, 0.0661764145f, -1.f),
    C_Vertex3f(0.302670479f, 0.00113224983f, -1.f),
    C_Vertex3f(0.30104351f, 0.0744867325f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.167939186f, 0.0717697144f, -1.f),
    C_Vertex3f(0.168180466f, -0.00291156769f, -1.f),
    C_Vertex3f(0.183377743f, 0.0627403259f, -1.f),
    C_Vertex3f(0.184379101f, -0.00682687759f, -1.f),
    C_Vertex3f(0.200726032f, 0.0567207336f, -1.f),
    C_Vertex3f(0.201437473f, -0.0094370842f, -1.f),
    C_Vertex3f(0.219984055f, 0.0537109375f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.157792568f, 0.0807991028f, -1.f),
    C_Vertex3f(0.151573539f, 0.0877351761f, -1.f),
    C_Vertex3f(0.152841568f, 0.00230884552f, -1.f),
    C_Vertex3f(0.168180466f, -0.00291156769f, -1.f),
    C_Vertex3f(0.167939186f, 0.0717697144f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.151573539f, 0.0877351761f, -1.f),
    C_Vertex3f(0.145899892f, 0.0955877304f, -1.f),
    C_Vertex3f(0.152841568f, 0.00230884552f, -1.f),
    C_Vertex3f(0.140771627f, 0.104356766f, -1.f),
    C_Vertex3f(0.138362408f, 0.00883436203f, -1.f),
    C_Vertex3f(0.136188745f, 0.114042282f, -1.f),
    C_Vertex3f(0.132151246f, 0.124644279f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.100083351f, 0.0362415314f, -1.f),
    C_Vertex3f(0.111983299f, 0.025800705f, -1.f),
    C_Vertex3f(0.124511719f, 0.155273438f, -1.f),
    C_Vertex3f(0.124742985f, 0.0166649818f, -1.f),
    C_Vertex3f(0.125712395f, 0.148597717f, -1.f),
    C_Vertex3f(0.138362408f, 0.00883436203f, -1.f),
    C_Vertex3f(0.128659129f, 0.136162758f, -1.f),
    C_Vertex3f(0.132151246f, 0.124644279f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.124511719f, 0.155273438f, -1.f),
    C_Vertex3f(0.048828125f, 0.1484375f, -1.f),
    C_Vertex3f(0.050028801f, 0.138980865f, -1.f),
    C_Vertex3f(0.0536174774f, 0.121126652f, -1.f),
    C_Vertex3f(0.0583934784f, 0.104331493f, -1.f),
    C_Vertex3f(0.0643568039f, 0.0885953903f, -1.f),
    C_Vertex3f(0.0715074539f, 0.0739183426f, -1.f),
    C_Vertex3f(0.0798454285f, 0.0603003502f, -1.f),
    C_Vertex3f(0.0893707275f, 0.0477414131f, -1.f),
    C_Vertex3f(0.100083351f, 0.0362415314f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.0388284922f, 0.392675519f, -1.f),
    C_Vertex3f(0.037109375f, 0.43907547f, -1.f),
    C_Vertex3f(0.037109375f, 0.415111542f, -1.f),
    C_Vertex3f(0.119372845f, 0.449059963f, -1.f),
    C_Vertex3f(0.116962314f, 0.604091048f, -1.f),
    C_Vertex3f(0.118164063f, 0.432807922f, -1.f),
    C_End(),
    C_Translatef(0.497558594f, 0.f, 0.f),
};
static const Call char_58[] = {
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_FrontFace(GL_CW),
    C_Begin(GL_QUADS),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.0810546875f, 0.375f, 0.f),
    C_Vertex3f(0.0810546875f, 0.375f, -1.f),
    C_Vertex3f(0.0810546875f, 0.464355469f, -1.f),
    C_Vertex3f(0.0810546875f, 0.464355469f, 0.f),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.0810546875f, 0.464355469f, 0.f),
    C_Vertex3f(0.0810546875f, 0.464355469f, -1.f),
    C_Vertex3f(0.170410156f, 0.464355469f, -1.f),
    C_Vertex3f(0.170410156f, 0.464355469f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.170410156f, 0.464355469f, 0.f),
    C_Vertex3f(0.170410156f, 0.464355469f, -1.f),
    C_Vertex3f(0.170410156f, 0.375f, -1.f),
    C_Vertex3f(0.170410156f, 0.375f, 0.f),
    C_Normal3f(-0.f, -1.f, 0.f),
    C_Vertex3f(0.170410156f, 0.375f, 0.f),
    C_Vertex3f(0.170410156f, 0.375f, -1.f),
    C_Vertex3f(0.0810546875f, 0.375f, -1.f),
    C_Vertex3f(0.0810546875f, 0.375f, 0.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.0810546875f, 0.f, 0.f),
    C_Vertex3f(0.0810546875f, 0.f, -1.f),
    C_Vertex3f(0.0810546875f, 0.0893554688f, -1.f),
    C_Vertex3f(0.0810546875f, 0.0893554688f, 0.f),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.0810546875f, 0.0893554688f, 0.f),
    C_Vertex3f(0.0810546875f, 0.0893554688f, -1.f),
    C_Vertex3f(0.170410156f, 0.0893554688f, -1.f),
    C_Vertex3f(0.170410156f, 0.0893554688f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.170410156f, 0.0893554688f, 0.f),
    C_Vertex3f(0.170410156f, 0.0893554688f, -1.f),
    C_Vertex3f(0.170410156f, 0.f, -1.f),
    C_Vertex3f(0.170410156f, 0.f, 0.f),
    C_Normal3f(-0.f, -1.f, 0.f),
    C_Vertex3f(0.170410156f, 0.f, 0.f),
    C_Vertex3f(0.170410156f, 0.f, -1.f),
    C_Vertex3f(0.0810546875f, 0.f, -1.f),
    C_Vertex3f(0.0810546875f, 0.f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.0810546875f, 0.464355469f, 0.f),
    C_Vertex3f(0.0810546875f, 0.375f, 0.f),
    C_Vertex3f(0.170410156f, 0.375f, 0.f),
    C_Vertex3f(0.170410156f, 0.464355469f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.0810546875f, 0.0893554688f, 0.f),
    C_Vertex3f(0.0810546875f, 0.f, 0.f),
    C_Vertex3f(0.170410156f, 0.f, 0.f),
    C_Vertex3f(0.170410156f, 0.0893554688f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, -1.f),
    C_FrontFace(GL_CW),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.0810546875f, 0.464355469f, -1.f),
    C_Vertex3f(0.0810546875f, 0.375f, -1.f),
    C_Vertex3f(0.170410156f, 0.375f, -1.f),
    C_Vertex3f(0.170410156f, 0.464355469f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.0810546875f, 0.0893554688f, -1.f),
    C_Vertex3f(0.0810546875f, 0.f, -1.f),
    C_Vertex3f(0.170410156f, 0.f, -1.f),
    C_Vertex3f(0.170410156f, 0.0893554688f, -1.f),
    C_End(),
    C_Translatef(0.248535156f, 0.f, 0.f),
};
static const Call char_59[] = {
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_FrontFace(GL_CW),
    C_Begin(GL_QUADS),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.0795898438f, 0.375f, 0.f),
    C_Vertex3f(0.0795898438f, 0.375f, -1.f),
    C_Vertex3f(0.0795898438f, 0.464355469f, -1.f),
    C_Vertex3f(0.0795898438f, 0.464355469f, 0.f),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.0795898438f, 0.464355469f, 0.f),
    C_Vertex3f(0.0795898438f, 0.464355469f, -1.f),
    C_Vertex3f(0.168945313f, 0.464355469f, -1.f),
    C_Vertex3f(0.168945313f, 0.464355469f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.168945313f, 0.464355469f, 0.f),
    C_Vertex3f(0.168945313f, 0.464355469f, -1.f),
    C_Vertex3f(0.168945313f, 0.375f, -1.f),
    C_Vertex3f(0.168945313f, 0.375f, 0.f),
    C_Normal3f(-0.f, -1.f, 0.f),
    C_Vertex3f(0.168945313f, 0.375f, 0.f),
    C_Vertex3f(0.168945313f, 0.375f, -1.f),
    C_Vertex3f(0.0795898438f, 0.375f, -1.f),
    C_Vertex3f(0.0795898438f, 0.375f, 0.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.0795898438f, 0.f, 0.f),
    C_Vertex3f(0.0795898438f, 0.f, -1.f),
    C_Vertex3f(0.0795898438f, 0.0893554688f, -1.f),
    C_Vertex3f(0.0795898438f, 0.0893554688f, 0.f),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.0795898438f, 0.0893554688f, 0.f),
    C_Vertex3f(0.0795898438f, 0.0893554688f, -1.f),
    C_Vertex3f(0.168945313f, 0.0893554688f, -1.f),
    C_Vertex3f(0.168945313f, 0.0893554688f, 0.f),
    C_End(),
    C_Begin(GL_QUAD_STRIP),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.168945313f, 0.0893554688f, 0.f),
    C_Vertex3f(0.168945313f, 0.0893554688f, -1.f),
    C_Normal3f(0.999845922f, -0.017552482f, 0.f),
    C_Vertex3f(0.168945313f, -0.0123672485f, 0.f),
    C_Vertex3f(0.168945313f, -0.0123672485f, -1.f),
    C_Normal3f(0.988292277f, -0.152572513f, 0.f),
    C_Vertex3f(0.16676712f, -0.0347213745f, 0.f),
    C_Vertex3f(0.16676712f, -0.0347213745f, -1.f),
    C_Normal3f(0.960453153f, -0.278441697f, 0.f),
    C_Vertex3f(0.162410736f, -0.0546951294f, 0.f),
    C_Vertex3f(0.162410736f, -0.0546951294f, -1.f),
    C_Normal3f(0.906842053f, -0.421470672f, 0.f),
    C_Vertex3f(0.15587616f, -0.0722885132f, 0.f),
    C_Vertex3f(0.15587616f, -0.0722885132f, -1.f),
    C_Normal3f(0.820653856f, -0.571425498f, 0.f),
    C_Vertex3f(0.147163391f, -0.0875015259f, 0.f),
    C_Vertex3f(0.147163391f, -0.0875015259f, -1.f),
    C_Normal3f(0.709192693f, -0.705014646f, 0.f),
    C_Vertex3f(0.135890961f, -0.100990295f, 0.f),
    C_Vertex3f(0.135890961f, -0.100990295f, -1.f),
    C_Normal3f(0.585075676f, -0.810978711f, 0.f),
    C_Vertex3f(0.122058868f, -0.112754822f, 0.f),
    C_Vertex3f(0.122058868f, -0.112754822f, -1.f),
    C_Normal3f(0.481169224f, -0.876627743f, 0.f),
    C_Vertex3f(0.105667114f, -0.122795105f, 0.f),
    C_Vertex3f(0.105667114f, -0.122795105f, -1.f),
    C_Normal3f(0.401824236f, -0.915716887f, 0.f),
    C_Vertex3f(0.0961914063f, -0.126953125f, 0.f),
    C_Vertex3f(0.0961914063f, -0.126953125f, -1.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.837327302f, -0.546702027f, 0.f),
    C_Vertex3f(0.0961914063f, -0.126953125f, 0.f),
    C_Vertex3f(0.0961914063f, -0.126953125f, -1.f),
    C_Vertex3f(0.07421875f, -0.0932998657f, -1.f),
    C_Vertex3f(0.07421875f, -0.0932998657f, 0.f),
    C_End(),
    C_Begin(GL_QUAD_STRIP),
    C_Normal3f(-0.402259469f, 0.915525675f, 0.f),
    C_Vertex3f(0.07421875f, -0.0932998657f, 0.f),
    C_Vertex3f(0.07421875f, -0.0932998657f, -1.f),
    C_Normal3f(-0.486692309f, 0.873573482f, 0.f),
    C_Vertex3f(0.0804481506f, -0.0905628204f, 0.f),
    C_Vertex3f(0.0804481506f, -0.0905628204f, -1.f),
    C_Normal3f(-0.595117092f, 0.803638995f, 0.f),
    C_Vertex3f(0.0912671089f, -0.0838017464f, 0.f),
    C_Vertex3f(0.0912671089f, -0.0838017464f, -1.f),
    C_Normal3f(-0.720752895f, 0.693192124f, 0.f),
    C_Vertex3f(0.100446224f, -0.0757536888f, 0.f),
    C_Vertex3f(0.100446224f, -0.0757536888f, -1.f),
    C_Normal3f(-0.829470992f, 0.558549702f, 0.f),
    C_Vertex3f(0.107985497f, -0.0664186478f, 0.f),
    C_Vertex3f(0.107985497f, -0.0664186478f, -1.f),
    C_Normal3f(-0.913641572f, 0.406520873f, 0.f),
    C_Vertex3f(0.113884926f, -0.0557966232f, 0.f),
    C_Vertex3f(0.113884926f, -0.0557966232f, -1.f),
    C_Normal3f(-0.963291168f, 0.268458724f, 0.f),
    C_Vertex3f(0.11847353f, -0.0428471565f, 0.f),
    C_Vertex3f(0.11847353f, -0.0428471565f, -1.f),
    C_Normal3f(-0.987516761f, 0.157514051f, 0.f),
    C_Vertex3f(0.121751308f, -0.0275702477f, 0.f),
    C_Vertex3f(0.121751308f, -0.0275702477f, -1.f),
    C_Normal3f(-0.996553242f, 0.0829556137f, 0.f),
    C_Vertex3f(0.123718262f, -0.00996589661f, 0.f),
    C_Vertex3f(0.123718262f, -0.00996589661f, -1.f),
    C_Normal3f(-0.999458671f, 0.03290084f, 0.f),
    C_Vertex3f(0.124046326f, 0.f, 0.f),
    C_Vertex3f(0.124046326f, 0.f, -1.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.f, -1.f, 0.f),
    C_Vertex3f(0.124046326f, 0.f, 0.f),
    C_Vertex3f(0.124046326f, 0.f, -1.f),
    C_Vertex3f(0.0795898438f, 0.f, -1.f),
    C_Vertex3f(0.0795898438f, 0.f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.0795898438f, 0.464355469f, 0.f),
    C_Vertex3f(0.0795898438f, 0.375f, 0.f),
    C_Vertex3f(0.168945313f, 0.375f, 0.f),
    C_Vertex3f(0.168945313f, 0.464355469f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.168945313f, 0.0893554688f, 0.f),
    C_Vertex3f(0.0795898438f, 0.0893554688f, 0.f),
    C_Vertex3f(0.124046326f, 0.f, 0.f),
    C_Vertex3f(0.135890961f, -0.100990295f, 0.f),
    C_Vertex3f(0.147163391f, -0.0875015259f, 0.f),
    C_Vertex3f(0.15587616f, -0.0722885132f, 0.f),
    C_Vertex3f(0.162410736f, -0.0546951294f, 0.f),
    C_Vertex3f(0.16676712f, -0.0347213745f, 0.f),
    C_Vertex3f(0.168945313f, -0.0123672485f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.123718262f, -0.00996589661f, 0.f),
    C_Vertex3f(0.121751308f, -0.0275702477f, 0.f),
    C_Vertex3f(0.122058868f, -0.112754822f, 0.f),
    C_Vertex3f(0.135890961f, -0.100990295f, 0.f),
    C_Vertex3f(0.124046326f, 0.f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.122058868f, -0.112754822f, 0.f),
    C_Vertex3f(0.121751308f, -0.0275702477f, 0.f),
    C_Vertex3f(0.11847353f, -0.0428471565f, 0.f),
    C_Vertex3f(0.113884926f, -0.0557966232f, 0.f),
    C_Vertex3f(0.107985497f, -0.0664186478f, 0.f),
    C_Vertex3f(0.105667114f, -0.122795105f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.100446224f, -0.0757536888f, 0.f),
    C_Vertex3f(0.0912671089f, -0.0838017464f, 0.f),
    C_Vertex3f(0.0961914063f, -0.126953125f, 0.f),
    C_Vertex3f(0.105667114f, -0.122795105f, 0.f),
    C_Vertex3f(0.107985497f, -0.0664186478f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.0804481506f, -0.0905628204f, 0.f),
    C_Vertex3f(0.07421875f, -0.0932998657f, 0.f),
    C_Vertex3f(0.0961914063f, -0.126953125f, 0.f),
    C_Vertex3f(0.0912671089f, -0.0838017464f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.124046326f, 0.f, 0.f),
    C_Vertex3f(0.0795898438f, 0.0893554688f, 0.f),
    C_Vertex3f(0.0795898438f, 0.f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, -1.f),
    C_FrontFace(GL_CW),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.0795898438f, 0.464355469f, -1.f),
    C_Vertex3f(0.0795898438f, 0.375f, -1.f),
    C_Vertex3f(0.168945313f, 0.375f, -1.f),
    C_Vertex3f(0.168945313f, 0.464355469f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.168945313f, 0.0893554688f, -1.f),
    C_Vertex3f(0.0795898438f, 0.0893554688f, -1.f),
    C_Vertex3f(0.124046326f, 0.f, -1.f),
    C_Vertex3f(0.135890961f, -0.100990295f, -1.f),
    C_Vertex3f(0.147163391f, -0.0875015259f, -1.f),
    C_Vertex3f(0.15587616f, -0.0722885132f, -1.f),
    C_Vertex3f(0.162410736f, -0.0546951294f, -1.f),
    C_Vertex3f(0.16676712f, -0.0347213745f, -1.f),
    C_Vertex3f(0.168945313f, -0.0123672485f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.123718262f, -0.00996589661f, -1.f),
    C_Vertex3f(0.121751308f, -0.0275702477f, -1.f),
    C_Vertex3f(0.122058868f, -0.112754822f, -1.f),
    C_Vertex3f(0.135890961f, -0.100990295f, -1.f),
    C_Vertex3f(0.124046326f, 0.f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.122058868f, -0.112754822f, -1.f),
    C_Vertex3f(0.121751308f, -0.0275702477f, -1.f),
    C_Vertex3f(0.11847353f, -0.0428471565f, -1.f),
    C_Vertex3f(0.113884926f, -0.0557966232f, -1.f),
    C_Vertex3f(0.107985497f, -0.0664186478f, -1.f),
    C_Vertex3f(0.105667114f, -0.122795105f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.100446224f, -0.0757536888f, -1.f),
    C_Vertex3f(0.0912671089f, -0.0838017464f, -1.f),
    C_Vertex3f(0.0961914063f, -0.126953125f, -1.f),
    C_Vertex3f(0.105667114f, -0.122795105f, -1.f),
    C_Vertex3f(0.107985497f, -0.0664186478f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.0804481506f, -0.0905628204f, -1.f),
    C_Vertex3f(0.07421875f, -0.0932998657f, -1.f),
    C_Vertex3f(0.0961914063f, -0.126953125f, -1.f),
    C_Vertex3f(0.0912671089f, -0.0838017464f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.124046326f, 0.f, -1.f),
    C_Vertex3f(0.0795898438f, 0.0893554688f, -1.f),
    C_Vertex3f(0.0795898438f, 0.f, -1.f),
    C_End(),
    C_Translatef(0.248535156f, 0.f, 0.f),
};
static const Call char_60[] = {
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_FrontFace(GL_CW),
    C_Begin(GL_QUADS),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.048828125f, 0.280273438f, 0.f),
    C_Vertex3f(0.048828125f, 0.280273438f, -1.f),
    C_Vertex3f(0.048828125f, 0.354003906f, -1.f),
    C_Vertex3f(0.048828125f, 0.354003906f, 0.f),
    C_Normal3f(-0.389432311f, 0.921055138f, 0.f),
    C_Vertex3f(0.048828125f, 0.354003906f, 0.f),
    C_Vertex3f(0.048828125f, 0.354003906f, -1.f),
    C_Vertex3f(0.47265625f, 0.533203125f, -1.f),
    C_Vertex3f(0.47265625f, 0.533203125f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.47265625f, 0.533203125f, 0.f),
    C_Vertex3f(0.47265625f, 0.533203125f, -1.f),
    C_Vertex3f(0.47265625f, 0.454589844f, -1.f),
    C_Vertex3f(0.47265625f, 0.454589844f, 0.f),
    C_Normal3f(0.379836679f, -0.925053537f, 0.f),
    C_Vertex3f(0.47265625f, 0.454589844f, 0.f),
    C_Vertex3f(0.47265625f, 0.454589844f, -1.f),
    C_Vertex3f(0.13671875f, 0.316650391f, -1.f),
    C_Vertex3f(0.13671875f, 0.316650391f, 0.f),
    C_Normal3f(0.382134259f, 0.924106777f, 0.f),
    C_Vertex3f(0.13671875f, 0.316650391f, 0.f),
    C_Vertex3f(0.13671875f, 0.316650391f, -1.f),
    C_Vertex3f(0.47265625f, 0.177734375f, -1.f),
    C_Vertex3f(0.47265625f, 0.177734375f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.47265625f, 0.177734375f, 0.f),
    C_Vertex3f(0.47265625f, 0.177734375f, -1.f),
    C_Vertex3f(0.47265625f, 0.0991210938f, -1.f),
    C_Vertex3f(0.47265625f, 0.0991210938f, 0.f),
    C_Normal3f(-0.393024117f, -0.919528127f, 0.f),
    C_Vertex3f(0.47265625f, 0.0991210938f, 0.f),
    C_Vertex3f(0.47265625f, 0.0991210938f, -1.f),
    C_Vertex3f(0.048828125f, 0.280273438f, -1.f),
    C_Vertex3f(0.048828125f, 0.280273438f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.13671875f, 0.316650391f, 0.f),
    C_Vertex3f(0.47265625f, 0.454589844f, 0.f),
    C_Vertex3f(0.47265625f, 0.533203125f, 0.f),
    C_Vertex3f(0.048828125f, 0.354003906f, 0.f),
    C_Vertex3f(0.47265625f, 0.0991210938f, 0.f),
    C_Vertex3f(0.47265625f, 0.177734375f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.47265625f, 0.0991210938f, 0.f),
    C_Vertex3f(0.048828125f, 0.354003906f, 0.f),
    C_Vertex3f(0.048828125f, 0.280273438f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, -1.f),
    C_FrontFace(GL_CW),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.13671875f, 0.316650391f, -1.f),
    C_Vertex3f(0.47265625f, 0.454589844f, -1.f),
    C_Vertex3f(0.47265625f, 0.533203125f, -1.f),
    C_Vertex3f(0.048828125f, 0.354003906f, -1.f),
    C_Vertex3f(0.47265625f, 0.0991210938f, -1.f),
    C_Vertex3f(0.47265625f, 0.177734375f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.47265625f, 0.0991210938f, -1.f),
    C_Vertex3f(0.048828125f, 0.354003906f, -1.f),
    C_Vertex3f(0.048828125f, 0.280273438f, -1.f),
    C_End(),
    C_Translatef(0.522460938f, 0.f, 0.f),
};
static const Call char_61[] = {
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_FrontFace(GL_CW),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.f, -1.f, 0.f),
    C_Vertex3f(0.47265625f, 0.376953125f, 0.f),
    C_Vertex3f(0.47265625f, 0.376953125f, -1.f),
    C_Vertex3f(0.0498046875f, 0.376953125f, -1.f),
    C_Vertex3f(0.0498046875f, 0.376953125f, 0.f),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.0498046875f, 0.376953125f, 0.f),
    C_Vertex3f(0.0498046875f, 0.376953125f, -1.f),
    C_Vertex3f(0.0498046875f, 0.450195313f, -1.f),
    C_Vertex3f(0.0498046875f, 0.450195313f, 0.f),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.0498046875f, 0.450195313f, 0.f),
    C_Vertex3f(0.0498046875f, 0.450195313f, -1.f),
    C_Vertex3f(0.47265625f, 0.450195313f, -1.f),
    C_Vertex3f(0.47265625f, 0.450195313f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.47265625f, 0.450195313f, 0.f),
    C_Vertex3f(0.47265625f, 0.450195313f, -1.f),
    C_Vertex3f(0.47265625f, 0.376953125f, -1.f),
    C_Vertex3f(0.47265625f, 0.376953125f, 0.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.f, -1.f, 0.f),
    C_Vertex3f(0.47265625f, 0.182128906f, 0.f),
    C_Vertex3f(0.47265625f, 0.182128906f, -1.f),
    C_Vertex3f(0.0498046875f, 0.182128906f, -1.f),
    C_Vertex3f(0.0498046875f, 0.182128906f, 0.f),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.0498046875f, 0.182128906f, 0.f),
    C_Vertex3f(0.0498046875f, 0.182128906f, -1.f),
    C_Vertex3f(0.0498046875f, 0.255371094f, -1.f),
    C_Vertex3f(0.0498046875f, 0.255371094f, 0.f),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.0498046875f, 0.255371094f, 0.f),
    C_Vertex3f(0.0498046875f, 0.255371094f, -1.f),
    C_Vertex3f(0.47265625f, 0.255371094f, -1.f),
    C_Vertex3f(0.47265625f, 0.255371094f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.47265625f, 0.255371094f, 0.f),
    C_Vertex3f(0.47265625f, 0.255371094f, -1.f),
    C_Vertex3f(0.47265625f, 0.182128906f, -1.f),
    C_Vertex3f(0.47265625f, 0.182128906f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.0498046875f, 0.450195313f, 0.f),
    C_Vertex3f(0.0498046875f, 0.376953125f, 0.f),
    C_Vertex3f(0.47265625f, 0.376953125f, 0.f),
    C_Vertex3f(0.47265625f, 0.450195313f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.0498046875f, 0.255371094f, 0.f),
    C_Vertex3f(0.0498046875f, 0.182128906f, 0.f),
    C_Vertex3f(0.47265625f, 0.182128906f, 0.f),
    C_Vertex3f(0.47265625f, 0.255371094f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, -1.f),
    C_FrontFace(GL_CW),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.0498046875f, 0.450195313f, -1.f),
    C_Vertex3f(0.0498046875f, 0.376953125f, -1.f),
    C_Vertex3f(0.47265625f, 0.376953125f, -1.f),
    C_Vertex3f(0.47265625f, 0.450195313f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.0498046875f, 0.255371094f, -1.f),
    C_Vertex3f(0.0498046875f, 0.182128906f, -1.f),
    C_Vertex3f(0.47265625f, 0.182128906f, -1.f),
    C_Vertex3f(0.47265625f, 0.255371094f, -1.f),
    C_End(),
    C_Translatef(0.522460938f, 0.f, 0.f),
};
static const Call char_62[] = {
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_FrontFace(GL_CW),
    C_Begin(GL_QUADS),
    C_Normal3f(0.393024117f, -0.919528127f, 0.f),
    C_Vertex3f(0.47265625f, 0.280273438f, 0.f),
    C_Vertex3f(0.47265625f, 0.280273438f, -1.f),
    C_Vertex3f(0.048828125f, 0.0991210938f, -1.f),
    C_Vertex3f(0.048828125f, 0.0991210938f, 0.f),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.048828125f, 0.0991210938f, 0.f),
    C_Vertex3f(0.048828125f, 0.0991210938f, -1.f),
    C_Vertex3f(0.048828125f, 0.177734375f, -1.f),
    C_Vertex3f(0.048828125f, 0.177734375f, 0.f),
    C_Normal3f(-0.382609159f, 0.92391032f, 0.f),
    C_Vertex3f(0.048828125f, 0.177734375f, 0.f),
    C_Vertex3f(0.048828125f, 0.177734375f, -1.f),
    C_Vertex3f(0.384277344f, 0.316650391f, -1.f),
    C_Vertex3f(0.384277344f, 0.316650391f, 0.f),
    C_Normal3f(-0.380309671f, -0.924859226f, 0.f),
    C_Vertex3f(0.384277344f, 0.316650391f, 0.f),
    C_Vertex3f(0.384277344f, 0.316650391f, -1.f),
    C_Vertex3f(0.048828125f, 0.454589844f, -1.f),
    C_Vertex3f(0.048828125f, 0.454589844f, 0.f),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.048828125f, 0.454589844f, 0.f),
    C_Vertex3f(0.048828125f, 0.454589844f, -1.f),
    C_Vertex3f(0.048828125f, 0.533203125f, -1.f),
    C_Vertex3f(0.048828125f, 0.533203125f, 0.f),
    C_Normal3f(0.389432311f, 0.921055138f, 0.f),
    C_Vertex3f(0.048828125f, 0.533203125f, 0.f),
    C_Vertex3f(0.048828125f, 0.533203125f, -1.f),
    C_Vertex3f(0.47265625f, 0.354003906f, -1.f),
    C_Vertex3f(0.47265625f, 0.354003906f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.47265625f, 0.354003906f, 0.f),
    C_Vertex3f(0.47265625f, 0.354003906f, -1.f),
    C_Vertex3f(0.47265625f, 0.280273438f, -1.f),
    C_Vertex3f(0.47265625f, 0.280273438f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.384277344f, 0.316650391f, 0.f),
    C_Vertex3f(0.048828125f, 0.177734375f, 0.f),
    C_Vertex3f(0.47265625f, 0.280273438f, 0.f),
    C_Vertex3f(0.47265625f, 0.354003906f, 0.f),
    C_Vertex3f(0.048828125f, 0.533203125f, 0.f),
    C_Vertex3f(0.048828125f, 0.454589844f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.47265625f, 0.280273438f, 0.f),
    C_Vertex3f(0.048828125f, 0.177734375f, 0.f),
    C_Vertex3f(0.048828125f, 0.0991210938f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, -1.f),
    C_FrontFace(GL_CW),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.384277344f, 0.316650391f, -1.f),
    C_Vertex3f(0.048828125f, 0.177734375f, -1.f),
    C_Vertex3f(0.47265625f, 0.280273438f, -1.f),
    C_Vertex3f(0.47265625f, 0.354003906f, -1.f),
    C_Vertex3f(0.048828125f, 0.533203125f, -1.f),
    C_Vertex3f(0.048828125f, 0.454589844f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.47265625f, 0.280273438f, -1.f),
    C_Vertex3f(0.048828125f, 0.177734375f, -1.f),
    C_Vertex3f(0.048828125f, 0.0991210938f, -1.f),
    C_End(),
    C_Translatef(0.522460938f, 0.f, 0.f),
};
static const Call char_63[] = {
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_FrontFace(GL_CW),
    C_Begin(GL_QUAD_STRIP),
    C_Normal3f(-0.999603152f, -0.028171517f, 0.f),
    C_Vertex3f(0.206054688f, 0.157714844f, 0.f),
    C_Vertex3f(0.206054688f, 0.157714844f, -1.f),
    C_Normal3f(-0.999671996f, -0.025609972f, 0.f),
    C_Vertex3f(0.205944061f, 0.161640167f, 0.f),
    C_Vertex3f(0.205944061f, 0.161640167f, -1.f),
    C_Normal3f(-0.999765217f, -0.0216690525f, 0.f),
    C_Vertex3f(0.205778122f, 0.168510437f, 0.f),
    C_Vertex3f(0.205778122f, 0.168510437f, -1.f),
    C_Normal3f(-0.999881983f, -0.0153637817f, 0.f),
    C_Vertex3f(0.205667496f, 0.17440033f, 0.f),
    C_Vertex3f(0.205667496f, 0.17440033f, -1.f),
    C_Normal3f(-0.99999553f, -0.00300050387f, 0.f),
    C_Vertex3f(0.205612183f, 0.179309845f, 0.f),
    C_Vertex3f(0.205612183f, 0.179309845f, -1.f),
    C_Normal3f(-0.998910069f, 0.0466757566f, 0.f),
    C_Vertex3f(0.205612183f, 0.192834854f, 0.f),
    C_Vertex3f(0.205612183f, 0.192834854f, -1.f),
    C_Normal3f(-0.99305743f, 0.117630437f, 0.f),
    C_Vertex3f(0.207250595f, 0.214373589f, 0.f),
    C_Vertex3f(0.207250595f, 0.214373589f, -1.f),
    C_Normal3f(-0.977915823f, 0.208998993f, 0.f),
    C_Vertex3f(0.21052742f, 0.234330177f, 0.f),
    C_Vertex3f(0.21052742f, 0.234330177f, -1.f),
    C_Normal3f(-0.956230164f, 0.292615771f, 0.f),
    C_Vertex3f(0.215442657f, 0.25270462f, 0.f),
    C_Vertex3f(0.215442657f, 0.25270462f, -1.f),
    C_Normal3f(-0.932974398f, 0.359942704f, 0.f),
    C_Vertex3f(0.218719482f, 0.261100769f, 0.f),
    C_Vertex3f(0.218719482f, 0.261100769f, -1.f),
    C_Normal3f(-0.909795761f, 0.415056139f, 0.f),
    C_Vertex3f(0.221122742f, 0.267427444f, 0.f),
    C_Vertex3f(0.221122742f, 0.267427444f, -1.f),
    C_Normal3f(-0.87583065f, 0.48261863f, 0.f),
    C_Vertex3f(0.227402687f, 0.280134201f, 0.f),
    C_Vertex3f(0.227402687f, 0.280134201f, -1.f),
    C_Normal3f(-0.833085954f, 0.553143442f, 0.f),
    C_Vertex3f(0.235156059f, 0.292894363f, 0.f),
    C_Vertex3f(0.235156059f, 0.292894363f, -1.f),
    C_Normal3f(-0.791139424f, 0.611635864f, 0.f),
    C_Vertex3f(0.244382858f, 0.305707932f, 0.f),
    C_Vertex3f(0.244382858f, 0.305707932f, -1.f),
    C_Normal3f(-0.74516499f, 0.666880071f, 0.f),
    C_Vertex3f(0.253662109f, 0.316831589f, 0.f),
    C_Vertex3f(0.253662109f, 0.316831589f, -1.f),
    C_Normal3f(-0.708310902f, 0.70590055f, 0.f),
    C_Vertex3f(0.264660358f, 0.328365803f, 0.f),
    C_Vertex3f(0.264660358f, 0.328365803f, -1.f),
    C_Normal3f(-0.684892952f, 0.728643656f, 0.f),
    C_Vertex3f(0.27879858f, 0.34205389f, 0.f),
    C_Vertex3f(0.27879858f, 0.34205389f, -1.f),
    C_Normal3f(-0.669042826f, 0.743223846f, 0.f),
    C_Vertex3f(0.296076775f, 0.357895851f, 0.f),
    C_Vertex3f(0.296076775f, 0.357895851f, -1.f),
    C_Normal3f(-0.666873932f, 0.745170534f, 0.f),
    C_Vertex3f(0.3113904f, 0.371392727f, 0.f),
    C_Vertex3f(0.3113904f, 0.371392727f, -1.f),
    C_Normal3f(-0.684084535f, 0.7294029f, 0.f),
    C_Vertex3f(0.320705533f, 0.379936814f, 0.f),
    C_Vertex3f(0.320705533f, 0.379936814f, -1.f),
    C_Normal3f(-0.702139735f, 0.712039113f, 0.f),
    C_Vertex3f(0.329126716f, 0.388027072f, 0.f),
    C_Vertex3f(0.329126716f, 0.388027072f, -1.f),
    C_Normal3f(-0.72298795f, 0.690860569f, 0.f),
    C_Vertex3f(0.336653948f, 0.3956635f, 0.f),
    C_Vertex3f(0.336653948f, 0.3956635f, -1.f),
    C_Normal3f(-0.747223794f, 0.664572418f, 0.f),
    C_Vertex3f(0.34328723f, 0.402846098f, 0.f),
    C_Vertex3f(0.34328723f, 0.402846098f, -1.f),
    C_Normal3f(-0.775553286f, 0.631282151f, 0.f),
    C_Vertex3f(0.349026561f, 0.409574866f, 0.f),
    C_Vertex3f(0.349026561f, 0.409574866f, -1.f),
    C_Normal3f(-0.808746099f, 0.588157952f, 0.f),
    C_Vertex3f(0.353871942f, 0.415849805f, 0.f),
    C_Vertex3f(0.353871942f, 0.415849805f, -1.f),
    C_Normal3f(-0.851630449f, 0.524142802f, 0.f),
    C_Vertex3f(0.357823372f, 0.421670914f, 0.f),
    C_Vertex3f(0.357823372f, 0.421670914f, -1.f),
    C_Normal3f(-0.903002501f, 0.429635316f, 0.f),
    C_Vertex3f(0.362409592f, 0.429721832f, 0.f),
    C_Vertex3f(0.362409592f, 0.429721832f, -1.f),
    C_Normal3f(-0.948754191f, 0.316014826f, 0.f),
    C_Vertex3f(0.366995811f, 0.44094944f, 0.f),
    C_Vertex3f(0.366995811f, 0.44094944f, -1.f),
    C_Normal3f(-0.982132018f, 0.188192725f, 0.f),
    C_Vertex3f(0.370053291f, 0.452670097f, 0.f),
    C_Vertex3f(0.370053291f, 0.452670097f, -1.f),
    C_Normal3f(-0.998029828f, 0.0627413541f, 0.f),
    C_Vertex3f(0.371582031f, 0.464883804f, 0.f),
    C_Vertex3f(0.371582031f, 0.464883804f, -1.f),
    C_Normal3f(-0.998849511f, -0.0479538701f, 0.f),
    C_Vertex3f(0.371582031f, 0.476987839f, 0.f),
    C_Vertex3f(0.371582031f, 0.476987839f, -1.f),
    C_Normal3f(-0.988561869f, -0.150815591f, 0.f),
    C_Vertex3f(0.370465517f, 0.488140106f, 0.f),
    C_Vertex3f(0.370465517f, 0.488140106f, -1.f),
    C_Normal3f(-0.967203021f, -0.254004717f, 0.f),
    C_Vertex3f(0.368232489f, 0.498943329f, 0.f),
    C_Vertex3f(0.368232489f, 0.498943329f, -1.f),
    C_Normal3f(-0.934737384f, -0.355339378f, 0.f),
    C_Vertex3f(0.364882946f, 0.509397507f, 0.f),
    C_Vertex3f(0.364882946f, 0.509397507f, -1.f),
    C_Normal3f(-0.892296255f, -0.451450229f, 0.f),
    C_Vertex3f(0.360416889f, 0.51950264f, 0.f),
    C_Vertex3f(0.360416889f, 0.51950264f, -1.f),
    C_Normal3f(-0.841927052f, -0.539591253f, 0.f),
    C_Vertex3f(0.354834318f, 0.529258728f, 0.f),
    C_Vertex3f(0.354834318f, 0.529258728f, -1.f),
    C_Normal3f(-0.786185205f, -0.61799103f, 0.f),
    C_Vertex3f(0.348135233f, 0.538665771f, 0.f),
    C_Vertex3f(0.348135233f, 0.538665771f, -1.f),
    C_Normal3f(-0.727670848f, -0.685926437f, 0.f),
    C_Vertex3f(0.340319633f, 0.54772377f, 0.f),
    C_Vertex3f(0.340319633f, 0.54772377f, -1.f),
    C_Normal3f(-0.664413273f, -0.747365475f, 0.f),
    C_Vertex3f(0.33138752f, 0.556432724f, 0.f),
    C_Vertex3f(0.33138752f, 0.556432724f, -1.f),
    C_Normal3f(-0.589825988f, -0.807530344f, 0.f),
    C_Vertex3f(0.321951628f, 0.564053059f, 0.f),
    C_Vertex3f(0.321951628f, 0.564053059f, -1.f),
    C_Normal3f(-0.506540477f, -0.862216115f, 0.f),
    C_Vertex3f(0.312011957f, 0.570584774f, 0.f),
    C_Vertex3f(0.312011957f, 0.570584774f, -1.f),
    C_Normal3f(-0.416426837f, -0.909169197f, 0.f),
    C_Vertex3f(0.301568508f, 0.57602787f, 0.f),
    C_Vertex3f(0.301568508f, 0.57602787f, -1.f),
    C_Normal3f(-0.322089702f, -0.946709096f, 0.f),
    C_Vertex3f(0.290621281f, 0.580382347f, 0.f),
    C_Vertex3f(0.290621281f, 0.580382347f, -1.f),
    C_Normal3f(-0.226509124f, -0.974009037f, 0.f),
    C_Vertex3f(0.279170275f, 0.583648205f, 0.f),
    C_Vertex3f(0.279170275f, 0.583648205f, -1.f),
    C_Normal3f(-0.132592306f, -0.991170585f, 0.f),
    C_Vertex3f(0.26721549f, 0.585825443f, 0.f),
    C_Vertex3f(0.26721549f, 0.585825443f, -1.f),
    C_Normal3f(-0.0431529954f, -0.999068379f, 0.f),
    C_Vertex3f(0.254756927f, 0.586914063f, 0.f),
    C_Vertex3f(0.254756927f, 0.586914063f, -1.f),
    C_Normal3f(0.0398654193f, -0.999204993f, 0.f),
    C_Vertex3f(0.242012024f, 0.586914063f, 0.f),
    C_Vertex3f(0.242012024f, 0.586914063f, -1.f),
    C_Normal3f(0.125079542f, -0.992146671f, 0.f),
    C_Vertex3f(0.230002046f, 0.585926414f, 0.f),
    C_Vertex3f(0.230002046f, 0.585926414f, -1.f),
    C_Normal3f(0.214670882f, -0.976686418f, 0.f),
    C_Vertex3f(0.218509555f, 0.583951116f, 0.f),
    C_Vertex3f(0.218509555f, 0.583951116f, -1.f),
    C_Normal3f(0.306995809f, -0.95171082f, 0.f),
    C_Vertex3f(0.207534552f, 0.580988169f, 0.f),
    C_Vertex3f(0.207534552f, 0.580988169f, -1.f),
    C_Normal3f(0.399494916f, -0.916735411f, 0.f),
    C_Vertex3f(0.197077036f, 0.577037573f, 0.f),
    C_Vertex3f(0.197077036f, 0.577037573f, -1.f),
    C_Normal3f(0.489326686f, -0.872100592f, 0.f),
    C_Vertex3f(0.187137008f, 0.572099328f, 0.f),
    C_Vertex3f(0.187137008f, 0.572099328f, -1.f),
    C_Normal3f(0.573765874f, -0.819019377f, 0.f),
    C_Vertex3f(0.177714467f, 0.566173434f, 0.f),
    C_Vertex3f(0.177714467f, 0.566173434f, -1.f),
    C_Normal3f(0.650601208f, -0.75941956f, 0.f),
    C_Vertex3f(0.168809414f, 0.559259892f, 0.f),
    C_Vertex3f(0.168809414f, 0.559259892f, -1.f),
    C_Normal3f(0.725305557f, -0.688427091f, 0.f),
    C_Vertex3f(0.160421848f, 0.5513587f, 0.f),
    C_Vertex3f(0.160421848f, 0.5513587f, -1.f),
    C_Normal3f(0.794816077f, -0.606850445f, 0.f),
    C_Vertex3f(0.152755857f, 0.542346358f, 0.f),
    C_Vertex3f(0.152755857f, 0.542346358f, -1.f),
    C_Normal3f(0.851234734f, -0.524785161f, 0.f),
    C_Vertex3f(0.145811439f, 0.532222867f, 0.f),
    C_Vertex3f(0.145811439f, 0.532222867f, -1.f),
    C_Normal3f(0.895429015f, -0.445204407f, 0.f),
    C_Vertex3f(0.139588594f, 0.520988226f, 0.f),
    C_Vertex3f(0.139588594f, 0.520988226f, -1.f),
    C_Normal3f(0.928974032f, -0.370144963f, 0.f),
    C_Vertex3f(0.134087324f, 0.508642435f, 0.f),
    C_Vertex3f(0.134087324f, 0.508642435f, -1.f),
    C_Normal3f(0.953701735f, -0.3007541f, 0.f),
    C_Vertex3f(0.129307628f, 0.495185494f, 0.f),
    C_Vertex3f(0.129307628f, 0.495185494f, -1.f),
    C_Normal3f(0.971392512f, -0.237479746f, 0.f),
    C_Vertex3f(0.125249505f, 0.480617404f, 0.f),
    C_Vertex3f(0.125249505f, 0.480617404f, -1.f),
    C_Normal3f(0.981897891f, -0.189411268f, 0.f),
    C_Vertex3f(0.121912956f, 0.464938164f, 0.f),
    C_Vertex3f(0.121912956f, 0.464938164f, -1.f),
    C_Normal3f(0.988088369f, -0.153887212f, 0.f),
    C_Vertex3f(0.120605469f, 0.456542969f, 0.f),
    C_Vertex3f(0.120605469f, 0.456542969f, -1.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.125505731f, -0.992092907f, 0.f),
    C_Vertex3f(0.120605469f, 0.456542969f, 0.f),
    C_Vertex3f(0.120605469f, 0.456542969f, -1.f),
    C_Vertex3f(0.0395507813f, 0.466796875f, -1.f),
    C_Vertex3f(0.0395507813f, 0.466796875f, 0.f),
    C_End(),
    C_Begin(GL_QUAD_STRIP),
    C_Normal3f(-0.992633283f, 0.121158153f, 0.f),
    C_Vertex3f(0.0395507813f, 0.466796875f, 0.f),
    C_Vertex3f(0.0395507813f, 0.466796875f, -1.f),
    C_Normal3f(-0.98606503f, 0.16636081f, 0.f),
    C_Vertex3f(0.0409154892f, 0.477977753f, 0.f),
    C_Vertex3f(0.0409154892f, 0.477977753f, -1.f),
    C_Normal3f(-0.973989725f, 0.226592034f, 0.f),
    C_Vertex3f(0.0449889898f, 0.49903059f, 0.f),
    C_Vertex3f(0.0449889898f, 0.49903059f, -1.f),
    C_Normal3f(-0.952699065f, 0.303915471f, 0.f),
    C_Vertex3f(0.0504065752f, 0.518774509f, 0.f),
    C_Vertex3f(0.0504065752f, 0.518774509f, -1.f),
    C_Normal3f(-0.922612906f, 0.385727227f, 0.f),
    C_Vertex3f(0.0571682453f, 0.537209511f, 0.f),
    C_Vertex3f(0.0571682453f, 0.537209511f, -1.f),
    C_Normal3f(-0.882510185f, 0.470293373f, 0.f),
    C_Vertex3f(0.0652740002f, 0.554335594f, 0.f),
    C_Vertex3f(0.0652740002f, 0.554335594f, -1.f),
    C_Normal3f(-0.831710637f, 0.555209398f, 0.f),
    C_Vertex3f(0.0747238398f, 0.57015276f, 0.f),
    C_Vertex3f(0.0747238398f, 0.57015276f, -1.f),
    C_Normal3f(-0.770373464f, 0.637592852f, 0.f),
    C_Vertex3f(0.0855177641f, 0.584661007f, 0.f),
    C_Vertex3f(0.0855177641f, 0.584661007f, -1.f),
    C_Normal3f(-0.699673057f, 0.714463174f, 0.f),
    C_Vertex3f(0.0976557732f, 0.597860336f, 0.f),
    C_Vertex3f(0.0976557732f, 0.597860336f, -1.f),
    C_Normal3f(-0.622231483f, 0.782833219f, 0.f),
    C_Vertex3f(0.111137867f, 0.609750748f, 0.f),
    C_Vertex3f(0.111137867f, 0.609750748f, -1.f),
    C_Normal3f(-0.538702428f, 0.842496157f, 0.f),
    C_Vertex3f(0.125704646f, 0.620154858f, 0.f),
    C_Vertex3f(0.125704646f, 0.620154858f, -1.f),
    C_Normal3f(-0.450639337f, 0.892706037f, 0.f),
    C_Vertex3f(0.141356111f, 0.629072666f, 0.f),
    C_Vertex3f(0.141356111f, 0.629072666f, -1.f),
    C_Normal3f(-0.360989749f, 0.932569742f, 0.f),
    C_Vertex3f(0.15809226f, 0.636504173f, 0.f),
    C_Vertex3f(0.15809226f, 0.636504173f, -1.f),
    C_Normal3f(-0.27256155f, 0.962138295f, 0.f),
    C_Vertex3f(0.175913095f, 0.642449379f, 0.f),
    C_Vertex3f(0.175913095f, 0.642449379f, -1.f),
    C_Normal3f(-0.187667623f, 0.982232571f, 0.f),
    C_Vertex3f(0.194818616f, 0.646908283f, 0.f),
    C_Vertex3f(0.194818616f, 0.646908283f, -1.f),
    C_Normal3f(-0.107946888f, 0.994156659f, 0.f),
    C_Vertex3f(0.214808822f, 0.649880886f, 0.f),
    C_Vertex3f(0.214808822f, 0.649880886f, -1.f),
    C_Normal3f(-0.0338443778f, 0.99942708f, 0.f),
    C_Vertex3f(0.235883713f, 0.651367188f, 0.f),
    C_Vertex3f(0.235883713f, 0.651367188f, -1.f),
    C_Normal3f(0.0354284644f, 0.999372184f, 0.f),
    C_Vertex3f(0.258699417f, 0.651367188f, 0.f),
    C_Vertex3f(0.258699417f, 0.651367188f, -1.f),
    C_Normal3f(0.109895512f, 0.993943155f, 0.f),
    C_Vertex3f(0.280983925f, 0.649768353f, 0.f),
    C_Vertex3f(0.280983925f, 0.649768353f, -1.f),
    C_Normal3f(0.191344365f, 0.981522977f, 0.f),
    C_Vertex3f(0.302081108f, 0.646570683f, 0.f),
    C_Vertex3f(0.302081108f, 0.646570683f, -1.f),
    C_Normal3f(0.278259575f, 0.960505962f, 0.f),
    C_Vertex3f(0.321990967f, 0.641774178f, 0.f),
    C_Vertex3f(0.321990967f, 0.641774178f, -1.f),
    C_Normal3f(0.368879229f, 0.929477394f, 0.f),
    C_Vertex3f(0.340713501f, 0.635378838f, 0.f),
    C_Vertex3f(0.340713501f, 0.635378838f, -1.f),
    C_Normal3f(0.460692316f, 0.88755995f, 0.f),
    C_Vertex3f(0.358248711f, 0.627384663f, 0.f),
    C_Vertex3f(0.358248711f, 0.627384663f, -1.f),
    C_Normal3f(0.550644338f, 0.834739923f, 0.f),
    C_Vertex3f(0.374596596f, 0.617791653f, 0.f),
    C_Vertex3f(0.374596596f, 0.617791653f, -1.f),
    C_Normal3f(0.635549128f, 0.772060454f, 0.f),
    C_Vertex3f(0.389757156f, 0.606599808f, 0.f),
    C_Vertex3f(0.389757156f, 0.606599808f, -1.f),
    C_Normal3f(0.707797468f, 0.706415355f, 0.f),
    C_Vertex3f(0.403730392f, 0.593809128f, 0.f),
    C_Vertex3f(0.403730392f, 0.593809128f, -1.f),
    C_Normal3f(0.772137403f, 0.635455549f, 0.f),
    C_Vertex3f(0.415956974f, 0.58034873f, 0.f),
    C_Vertex3f(0.415956974f, 0.58034873f, -1.f),
    C_Normal3f(0.833024919f, 0.553235471f, 0.f),
    C_Vertex3f(0.426436901f, 0.566218615f, 0.f),
    C_Vertex3f(0.426436901f, 0.566218615f, -1.f),
    C_Normal3f(0.88745904f, 0.460886776f, 0.f),
    C_Vertex3f(0.435170174f, 0.551418781f, 0.f),
    C_Vertex3f(0.435170174f, 0.551418781f, -1.f),
    C_Normal3f(0.932658434f, 0.360760838f, 0.f),
    C_Vertex3f(0.442156792f, 0.53594923f, 0.f),
    C_Vertex3f(0.442156792f, 0.53594923f, -1.f),
    C_Normal3f(0.966620386f, 0.256212622f, 0.f),
    C_Vertex3f(0.447396755f, 0.519809961f, 0.f),
    C_Vertex3f(0.447396755f, 0.519809961f, -1.f),
    C_Normal3f(0.988523066f, 0.151069522f, 0.f),
    C_Vertex3f(0.450890064f, 0.503000975f, 0.f),
    C_Vertex3f(0.450890064f, 0.503000975f, -1.f),
    C_Normal3f(0.998890519f, 0.0470920689f, 0.f),
    C_Vertex3f(0.452636719f, 0.48552227f, 0.f),
    C_Vertex3f(0.452636719f, 0.48552227f, -1.f),
    C_Normal3f(0.998091877f, -0.0617452972f, 0.f),
    C_Vertex3f(0.452636719f, 0.46595192f, 0.f),
    C_Vertex3f(0.452636719f, 0.46595192f, -1.f),
    C_Normal3f(0.983028471f, -0.183452785f, 0.f),
    C_Vertex3f(0.450178146f, 0.445780277f, 0.f),
    C_Vertex3f(0.450178146f, 0.445780277f, -1.f),
    C_Normal3f(0.95117116f, -0.308663964f, 0.f),
    C_Vertex3f(0.445261002f, 0.426429272f, 0.f),
    C_Vertex3f(0.445261002f, 0.426429272f, -1.f),
    C_Normal3f(0.907212973f, -0.420671791f, 0.f),
    C_Vertex3f(0.437885284f, 0.407898903f, 0.f),
    C_Vertex3f(0.437885284f, 0.407898903f, -1.f),
    C_Normal3f(0.859156251f, -0.511713445f, 0.f),
    C_Vertex3f(0.430509567f, 0.394616604f, 0.f),
    C_Vertex3f(0.430509567f, 0.394616604f, -1.f),
    C_Normal3f(0.81993717f, -0.572453558f, 0.f),
    C_Vertex3f(0.424417734f, 0.385287166f, 0.f),
    C_Vertex3f(0.424417734f, 0.385287166f, -1.f),
    C_Normal3f(0.787677884f, -0.616087377f, 0.f),
    C_Vertex3f(0.417151213f, 0.375483155f, 0.f),
    C_Vertex3f(0.417151213f, 0.375483155f, -1.f),
    C_Normal3f(0.758723319f, -0.651413083f, 0.f),
    C_Vertex3f(0.408710003f, 0.365204573f, 0.f),
    C_Vertex3f(0.408710003f, 0.365204573f, -1.f),
    C_Normal3f(0.732865512f, -0.68037343f, 0.f),
    C_Vertex3f(0.399094105f, 0.354451418f, 0.f),
    C_Vertex3f(0.399094105f, 0.354451418f, -1.f),
    C_Normal3f(0.709797263f, -0.704405963f, 0.f),
    C_Vertex3f(0.388303518f, 0.343223691f, 0.f),
    C_Vertex3f(0.388303518f, 0.343223691f, -1.f),
    C_Normal3f(0.689192295f, -0.724578619f, 0.f),
    C_Vertex3f(0.376338243f, 0.331521392f, 0.f),
    C_Vertex3f(0.376338243f, 0.331521392f, -1.f),
    C_Normal3f(0.671597004f, -0.74091655f, 0.f),
    C_Vertex3f(0.36319828f, 0.319344521f, 0.f),
    C_Vertex3f(0.36319828f, 0.319344521f, -1.f),
    C_Normal3f(0.666077137f, -0.745882928f, 0.f),
    C_Vertex3f(0.351233482f, 0.308765411f, 0.f),
    C_Vertex3f(0.351233482f, 0.308765411f, -1.f),
    C_Normal3f(0.675726533f, -0.737152398f, 0.f),
    C_Vertex3f(0.342451572f, 0.300817609f, 0.f),
    C_Vertex3f(0.342451572f, 0.300817609f, -1.f),
    C_Normal3f(0.686391294f, -0.727232337f, 0.f),
    C_Vertex3f(0.334502697f, 0.293428779f, 0.f),
    C_Vertex3f(0.334502697f, 0.293428779f, -1.f),
    C_Normal3f(0.699113369f, -0.715010822f, 0.f),
    C_Vertex3f(0.327386856f, 0.286598921f, 0.f),
    C_Vertex3f(0.327386856f, 0.286598921f, -1.f),
    C_Normal3f(0.714527726f, -0.699607193f, 0.f),
    C_Vertex3f(0.32110405f, 0.280328035f, 0.f),
    C_Vertex3f(0.32110405f, 0.280328035f, -1.f),
    C_Normal3f(0.733543277f, -0.679642797f, 0.f),
    C_Vertex3f(0.315654278f, 0.274616122f, 0.f),
    C_Vertex3f(0.315654278f, 0.274616122f, -1.f),
    C_Normal3f(0.757489383f, -0.652847409f, 0.f),
    C_Vertex3f(0.31103754f, 0.269463181f, 0.f),
    C_Vertex3f(0.31103754f, 0.269463181f, -1.f),
    C_Normal3f(0.796097815f, -0.605167985f, 0.f),
    C_Vertex3f(0.307253838f, 0.264869213f, 0.f),
    C_Vertex3f(0.307253838f, 0.264869213f, -1.f),
    C_Normal3f(0.871388972f, -0.490592599f, 0.f),
    C_Vertex3f(0.299877167f, 0.254781723f, 0.f),
    C_Vertex3f(0.299877167f, 0.254781723f, -1.f),
    C_Normal3f(0.934900761f, -0.354909271f, 0.f),
    C_Vertex3f(0.291135788f, 0.236240387f, 0.f),
    C_Vertex3f(0.291135788f, 0.236240387f, -1.f),
    C_Normal3f(0.976498902f, -0.215522289f, 0.f),
    C_Vertex3f(0.286875725f, 0.220533371f, 0.f),
    C_Vertex3f(0.286875725f, 0.220533371f, -1.f),
    C_Normal3f(0.992140055f, -0.12513271f, 0.f),
    C_Vertex3f(0.284636021f, 0.206790924f, 0.f),
    C_Vertex3f(0.284636021f, 0.206790924f, -1.f),
    C_Normal3f(0.997431517f, -0.0716258362f, 0.f),
    C_Vertex3f(0.282996655f, 0.189777374f, 0.f),
    C_Vertex3f(0.282996655f, 0.189777374f, -1.f),
    C_Normal3f(0.999230742f, -0.0392172821f, 0.f),
    C_Vertex3f(0.281957626f, 0.169492722f, 0.f),
    C_Vertex3f(0.281957626f, 0.169492722f, -1.f),
    C_Normal3f(0.99982667f, -0.0186202526f, 0.f),
    C_Vertex3f(0.281738281f, 0.157714844f, 0.f),
    C_Vertex3f(0.281738281f, 0.157714844f, -1.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.f, -1.f, 0.f),
    C_Vertex3f(0.281738281f, 0.157714844f, 0.f),
    C_Vertex3f(0.281738281f, 0.157714844f, -1.f),
    C_Vertex3f(0.206054688f, 0.157714844f, -1.f),
    C_Vertex3f(0.206054688f, 0.157714844f, 0.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(-1.f, 0.f, 0.f),
    C_Vertex3f(0.192382813f, 0.f, 0.f),
    C_Vertex3f(0.192382813f, 0.f, -1.f),
    C_Vertex3f(0.192382813f, 0.0893554688f, -1.f),
    C_Vertex3f(0.192382813f, 0.0893554688f, 0.f),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.192382813f, 0.0893554688f, 0.f),
    C_Vertex3f(0.192382813f, 0.0893554688f, -1.f),
    C_Vertex3f(0.281738281f, 0.0893554688f, -1.f),
    C_Vertex3f(0.281738281f, 0.0893554688f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.281738281f, 0.0893554688f, 0.f),
    C_Vertex3f(0.281738281f, 0.0893554688f, -1.f),
    C_Vertex3f(0.281738281f, 0.f, -1.f),
    C_Vertex3f(0.281738281f, 0.f, 0.f),
    C_Normal3f(-0.f, -1.f, 0.f),
    C_Vertex3f(0.281738281f, 0.f, 0.f),
    C_Vertex3f(0.281738281f, 0.f, -1.f),
    C_Vertex3f(0.192382813f, 0.f, -1.f),
    C_Vertex3f(0.192382813f, 0.f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.374596596f, 0.617791653f, 0.f),
    C_Vertex3f(0.358248711f, 0.627384663f, 0.f),
    C_Vertex3f(0.360416889f, 0.51950264f, 0.f),
    C_Vertex3f(0.364882946f, 0.509397507f, 0.f),
    C_Vertex3f(0.368232489f, 0.498943329f, 0.f),
    C_Vertex3f(0.370465517f, 0.488140106f, 0.f),
    C_Vertex3f(0.371582031f, 0.476987839f, 0.f),
    C_Vertex3f(0.376338243f, 0.331521392f, 0.f),
    C_Vertex3f(0.389757156f, 0.606599808f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.33138752f, 0.556432724f, 0.f),
    C_Vertex3f(0.340319633f, 0.54772377f, 0.f),
    C_Vertex3f(0.340713501f, 0.635378838f, 0.f),
    C_Vertex3f(0.348135233f, 0.538665771f, 0.f),
    C_Vertex3f(0.358248711f, 0.627384663f, 0.f),
    C_Vertex3f(0.354834318f, 0.529258728f, 0.f),
    C_Vertex3f(0.360416889f, 0.51950264f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.321990967f, 0.641774178f, 0.f),
    C_Vertex3f(0.302081108f, 0.646570683f, 0.f),
    C_Vertex3f(0.312011957f, 0.570584774f, 0.f),
    C_Vertex3f(0.321951628f, 0.564053059f, 0.f),
    C_Vertex3f(0.33138752f, 0.556432724f, 0.f),
    C_Vertex3f(0.340713501f, 0.635378838f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.26721549f, 0.585825443f, 0.f),
    C_Vertex3f(0.279170275f, 0.583648205f, 0.f),
    C_Vertex3f(0.280983925f, 0.649768353f, 0.f),
    C_Vertex3f(0.290621281f, 0.580382347f, 0.f),
    C_Vertex3f(0.302081108f, 0.646570683f, 0.f),
    C_Vertex3f(0.301568508f, 0.57602787f, 0.f),
    C_Vertex3f(0.312011957f, 0.570584774f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.258699417f, 0.651367188f, 0.f),
    C_Vertex3f(0.235883713f, 0.651367188f, 0.f),
    C_Vertex3f(0.242012024f, 0.586914063f, 0.f),
    C_Vertex3f(0.254756927f, 0.586914063f, 0.f),
    C_Vertex3f(0.26721549f, 0.585825443f, 0.f),
    C_Vertex3f(0.280983925f, 0.649768353f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.197077036f, 0.577037573f, 0.f),
    C_Vertex3f(0.207534552f, 0.580988169f, 0.f),
    C_Vertex3f(0.214808822f, 0.649880886f, 0.f),
    C_Vertex3f(0.218509555f, 0.583951116f, 0.f),
    C_Vertex3f(0.235883713f, 0.651367188f, 0.f),
    C_Vertex3f(0.230002046f, 0.585926414f, 0.f),
    C_Vertex3f(0.242012024f, 0.586914063f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.194818616f, 0.646908283f, 0.f),
    C_Vertex3f(0.175913095f, 0.642449379f, 0.f),
    C_Vertex3f(0.177714467f, 0.566173434f, 0.f),
    C_Vertex3f(0.187137008f, 0.572099328f, 0.f),
    C_Vertex3f(0.197077036f, 0.577037573f, 0.f),
    C_Vertex3f(0.214808822f, 0.649880886f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.145811439f, 0.532222867f, 0.f),
    C_Vertex3f(0.152755857f, 0.542346358f, 0.f),
    C_Vertex3f(0.15809226f, 0.636504173f, 0.f),
    C_Vertex3f(0.160421848f, 0.5513587f, 0.f),
    C_Vertex3f(0.175913095f, 0.642449379f, 0.f),
    C_Vertex3f(0.168809414f, 0.559259892f, 0.f),
    C_Vertex3f(0.177714467f, 0.566173434f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.141356111f, 0.629072666f, 0.f),
    C_Vertex3f(0.125704646f, 0.620154858f, 0.f),
    C_Vertex3f(0.129307628f, 0.495185494f, 0.f),
    C_Vertex3f(0.134087324f, 0.508642435f, 0.f),
    C_Vertex3f(0.139588594f, 0.520988226f, 0.f),
    C_Vertex3f(0.145811439f, 0.532222867f, 0.f),
    C_Vertex3f(0.15809226f, 0.636504173f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.125704646f, 0.620154858f, 0.f),
    C_Vertex3f(0.111137867f, 0.609750748f, 0.f),
    C_Vertex3f(0.120605469f, 0.456542969f, 0.f),
    C_Vertex3f(0.121912956f, 0.464938164f, 0.f),
    C_Vertex3f(0.125249505f, 0.480617404f, 0.f),
    C_Vertex3f(0.129307628f, 0.495185494f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.120605469f, 0.456542969f, 0.f),
    C_Vertex3f(0.111137867f, 0.609750748f, 0.f),
    C_Vertex3f(0.0976557732f, 0.597860336f, 0.f),
    C_Vertex3f(0.0855177641f, 0.584661007f, 0.f),
    C_Vertex3f(0.0747238398f, 0.57015276f, 0.f),
    C_Vertex3f(0.0652740002f, 0.554335594f, 0.f),
    C_Vertex3f(0.0571682453f, 0.537209511f, 0.f),
    C_Vertex3f(0.0504065752f, 0.518774509f, 0.f),
    C_Vertex3f(0.0449889898f, 0.49903059f, 0.f),
    C_Vertex3f(0.0409154892f, 0.477977753f, 0.f),
    C_Vertex3f(0.0395507813f, 0.466796875f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.417151213f, 0.375483155f, 0.f),
    C_Vertex3f(0.424417734f, 0.385287166f, 0.f),
    C_Vertex3f(0.426436901f, 0.566218615f, 0.f),
    C_Vertex3f(0.430509567f, 0.394616604f, 0.f),
    C_Vertex3f(0.435170174f, 0.551418781f, 0.f),
    C_Vertex3f(0.437885284f, 0.407898903f, 0.f),
    C_Vertex3f(0.442156792f, 0.53594923f, 0.f),
    C_Vertex3f(0.445261002f, 0.426429272f, 0.f),
    C_Vertex3f(0.447396755f, 0.519809961f, 0.f),
    C_Vertex3f(0.450178146f, 0.445780277f, 0.f),
    C_Vertex3f(0.450890064f, 0.503000975f, 0.f),
    C_Vertex3f(0.452636719f, 0.46595192f, 0.f),
    C_Vertex3f(0.452636719f, 0.48552227f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.376338243f, 0.331521392f, 0.f),
    C_Vertex3f(0.388303518f, 0.343223691f, 0.f),
    C_Vertex3f(0.389757156f, 0.606599808f, 0.f),
    C_Vertex3f(0.399094105f, 0.354451418f, 0.f),
    C_Vertex3f(0.403730392f, 0.593809128f, 0.f),
    C_Vertex3f(0.408710003f, 0.365204573f, 0.f),
    C_Vertex3f(0.415956974f, 0.58034873f, 0.f),
    C_Vertex3f(0.417151213f, 0.375483155f, 0.f),
    C_Vertex3f(0.426436901f, 0.566218615f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.376338243f, 0.331521392f, 0.f),
    C_Vertex3f(0.371582031f, 0.476987839f, 0.f),
    C_Vertex3f(0.371582031f, 0.464883804f, 0.f),
    C_Vertex3f(0.370053291f, 0.452670097f, 0.f),
    C_Vertex3f(0.366995811f, 0.44094944f, 0.f),
    C_Vertex3f(0.36319828f, 0.319344521f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.36319828f, 0.319344521f, 0.f),
    C_Vertex3f(0.366995811f, 0.44094944f, 0.f),
    C_Vertex3f(0.362409592f, 0.429721832f, 0.f),
    C_Vertex3f(0.357823372f, 0.421670914f, 0.f),
    C_Vertex3f(0.353871942f, 0.415849805f, 0.f),
    C_Vertex3f(0.351233482f, 0.308765411f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.32110405f, 0.280328035f, 0.f),
    C_Vertex3f(0.327386856f, 0.286598921f, 0.f),
    C_Vertex3f(0.329126716f, 0.388027072f, 0.f),
    C_Vertex3f(0.334502697f, 0.293428779f, 0.f),
    C_Vertex3f(0.336653948f, 0.3956635f, 0.f),
    C_Vertex3f(0.342451572f, 0.300817609f, 0.f),
    C_Vertex3f(0.34328723f, 0.402846098f, 0.f),
    C_Vertex3f(0.351233482f, 0.308765411f, 0.f),
    C_Vertex3f(0.349026561f, 0.409574866f, 0.f),
    C_Vertex3f(0.353871942f, 0.415849805f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.307253838f, 0.264869213f, 0.f),
    C_Vertex3f(0.31103754f, 0.269463181f, 0.f),
    C_Vertex3f(0.3113904f, 0.371392727f, 0.f),
    C_Vertex3f(0.315654278f, 0.274616122f, 0.f),
    C_Vertex3f(0.320705533f, 0.379936814f, 0.f),
    C_Vertex3f(0.32110405f, 0.280328035f, 0.f),
    C_Vertex3f(0.329126716f, 0.388027072f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.286875725f, 0.220533371f, 0.f),
    C_Vertex3f(0.291135788f, 0.236240387f, 0.f),
    C_Vertex3f(0.296076775f, 0.357895851f, 0.f),
    C_Vertex3f(0.299877167f, 0.254781723f, 0.f),
    C_Vertex3f(0.3113904f, 0.371392727f, 0.f),
    C_Vertex3f(0.307253838f, 0.264869213f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.281738281f, 0.157714844f, 0.f),
    C_Vertex3f(0.281957626f, 0.169492722f, 0.f),
    C_Vertex3f(0.27879858f, 0.34205389f, 0.f),
    C_Vertex3f(0.282996655f, 0.189777374f, 0.f),
    C_Vertex3f(0.296076775f, 0.357895851f, 0.f),
    C_Vertex3f(0.284636021f, 0.206790924f, 0.f),
    C_Vertex3f(0.286875725f, 0.220533371f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.281738281f, 0.157714844f, 0.f),
    C_Vertex3f(0.27879858f, 0.34205389f, 0.f),
    C_Vertex3f(0.264660358f, 0.328365803f, 0.f),
    C_Vertex3f(0.253662109f, 0.316831589f, 0.f),
    C_Vertex3f(0.244382858f, 0.305707932f, 0.f),
    C_Vertex3f(0.235156059f, 0.292894363f, 0.f),
    C_Vertex3f(0.227402687f, 0.280134201f, 0.f),
    C_Vertex3f(0.221122742f, 0.267427444f, 0.f),
    C_Vertex3f(0.218719482f, 0.261100769f, 0.f),
    C_Vertex3f(0.215442657f, 0.25270462f, 0.f),
    C_Vertex3f(0.21052742f, 0.234330177f, 0.f),
    C_Vertex3f(0.207250595f, 0.214373589f, 0.f),
    C_Vertex3f(0.206054688f, 0.157714844f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.207250595f, 0.214373589f, 0.f),
    C_Vertex3f(0.205612183f, 0.192834854f, 0.f),
    C_Vertex3f(0.205667496f, 0.17440033f, 0.f),
    C_Vertex3f(0.205778122f, 0.168510437f, 0.f),
    C_Vertex3f(0.205944061f, 0.161640167f, 0.f),
    C_Vertex3f(0.206054688f, 0.157714844f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.192382813f, 0.0893554688f, 0.f),
    C_Vertex3f(0.192382813f, 0.f, 0.f),
    C_Vertex3f(0.281738281f, 0.f, 0.f),
    C_Vertex3f(0.281738281f, 0.0893554688f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.205667496f, 0.17440033f, 0.f),
    C_Vertex3f(0.205612183f, 0.192834854f, 0.f),
    C_Vertex3f(0.205612183f, 0.179309845f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, -1.f),
    C_FrontFace(GL_CW),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.374596596f, 0.617791653f, -1.f),
    C_Vertex3f(0.358248711f, 0.627384663f, -1.f),
    C_Vertex3f(0.360416889f, 0.51950264f, -1.f),
    C_Vertex3f(0.364882946f, 0.509397507f, -1.f),
    C_Vertex3f(0.368232489f, 0.498943329f, -1.f),
    C_Vertex3f(0.370465517f, 0.488140106f, -1.f),
    C_Vertex3f(0.371582031f, 0.476987839f, -1.f),
    C_Vertex3f(0.376338243f, 0.331521392f, -1.f),
    C_Vertex3f(0.389757156f, 0.606599808f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.33138752f, 0.556432724f, -1.f),
    C_Vertex3f(0.340319633f, 0.54772377f, -1.f),
    C_Vertex3f(0.340713501f, 0.635378838f, -1.f),
    C_Vertex3f(0.348135233f, 0.538665771f, -1.f),
    C_Vertex3f(0.358248711f, 0.627384663f, -1.f),
    C_Vertex3f(0.354834318f, 0.529258728f, -1.f),
    C_Vertex3f(0.360416889f, 0.51950264f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.321990967f, 0.641774178f, -1.f),
    C_Vertex3f(0.302081108f, 0.646570683f, -1.f),
    C_Vertex3f(0.312011957f, 0.570584774f, -1.f),
    C_Vertex3f(0.321951628f, 0.564053059f, -1.f),
    C_Vertex3f(0.33138752f, 0.556432724f, -1.f),
    C_Vertex3f(0.340713501f, 0.635378838f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.26721549f, 0.585825443f, -1.f),
    C_Vertex3f(0.279170275f, 0.583648205f, -1.f),
    C_Vertex3f(0.280983925f, 0.649768353f, -1.f),
    C_Vertex3f(0.290621281f, 0.580382347f, -1.f),
    C_Vertex3f(0.302081108f, 0.646570683f, -1.f),
    C_Vertex3f(0.301568508f, 0.57602787f, -1.f),
    C_Vertex3f(0.312011957f, 0.570584774f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.258699417f, 0.651367188f, -1.f),
    C_Vertex3f(0.235883713f, 0.651367188f, -1.f),
    C_Vertex3f(0.242012024f, 0.586914063f, -1.f),
    C_Vertex3f(0.254756927f, 0.586914063f, -1.f),
    C_Vertex3f(0.26721549f, 0.585825443f, -1.f),
    C_Vertex3f(0.280983925f, 0.649768353f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.197077036f, 0.577037573f, -1.f),
    C_Vertex3f(0.207534552f, 0.580988169f, -1.f),
    C_Vertex3f(0.214808822f, 0.649880886f, -1.f),
    C_Vertex3f(0.218509555f, 0.583951116f, -1.f),
    C_Vertex3f(0.235883713f, 0.651367188f, -1.f),
    C_Vertex3f(0.230002046f, 0.585926414f, -1.f),
    C_Vertex3f(0.242012024f, 0.586914063f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.194818616f, 0.646908283f, -1.f),
    C_Vertex3f(0.175913095f, 0.642449379f, -1.f),
    C_Vertex3f(0.177714467f, 0.566173434f, -1.f),
    C_Vertex3f(0.187137008f, 0.572099328f, -1.f),
    C_Vertex3f(0.197077036f, 0.577037573f, -1.f),
    C_Vertex3f(0.214808822f, 0.649880886f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.145811439f, 0.532222867f, -1.f),
    C_Vertex3f(0.152755857f, 0.542346358f, -1.f),
    C_Vertex3f(0.15809226f, 0.636504173f, -1.f),
    C_Vertex3f(0.160421848f, 0.5513587f, -1.f),
    C_Vertex3f(0.175913095f, 0.642449379f, -1.f),
    C_Vertex3f(0.168809414f, 0.559259892f, -1.f),
    C_Vertex3f(0.177714467f, 0.566173434f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.141356111f, 0.629072666f, -1.f),
    C_Vertex3f(0.125704646f, 0.620154858f, -1.f),
    C_Vertex3f(0.129307628f, 0.495185494f, -1.f),
    C_Vertex3f(0.134087324f, 0.508642435f, -1.f),
    C_Vertex3f(0.139588594f, 0.520988226f, -1.f),
    C_Vertex3f(0.145811439f, 0.532222867f, -1.f),
    C_Vertex3f(0.15809226f, 0.636504173f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.125704646f, 0.620154858f, -1.f),
    C_Vertex3f(0.111137867f, 0.609750748f, -1.f),
    C_Vertex3f(0.120605469f, 0.456542969f, -1.f),
    C_Vertex3f(0.121912956f, 0.464938164f, -1.f),
    C_Vertex3f(0.125249505f, 0.480617404f, -1.f),
    C_Vertex3f(0.129307628f, 0.495185494f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.120605469f, 0.456542969f, -1.f),
    C_Vertex3f(0.111137867f, 0.609750748f, -1.f),
    C_Vertex3f(0.0976557732f, 0.597860336f, -1.f),
    C_Vertex3f(0.0855177641f, 0.584661007f, -1.f),
    C_Vertex3f(0.0747238398f, 0.57015276f, -1.f),
    C_Vertex3f(0.0652740002f, 0.554335594f, -1.f),
    C_Vertex3f(0.0571682453f, 0.537209511f, -1.f),
    C_Vertex3f(0.0504065752f, 0.518774509f, -1.f),
    C_Vertex3f(0.0449889898f, 0.49903059f, -1.f),
    C_Vertex3f(0.0409154892f, 0.477977753f, -1.f),
    C_Vertex3f(0.0395507813f, 0.466796875f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.417151213f, 0.375483155f, -1.f),
    C_Vertex3f(0.424417734f, 0.385287166f, -1.f),
    C_Vertex3f(0.426436901f, 0.566218615f, -1.f),
    C_Vertex3f(0.430509567f, 0.394616604f, -1.f),
    C_Vertex3f(0.435170174f, 0.551418781f, -1.f),
    C_Vertex3f(0.437885284f, 0.407898903f, -1.f),
    C_Vertex3f(0.442156792f, 0.53594923f, -1.f),
    C_Vertex3f(0.445261002f, 0.426429272f, -1.f),
    C_Vertex3f(0.447396755f, 0.519809961f, -1.f),
    C_Vertex3f(0.450178146f, 0.445780277f, -1.f),
    C_Vertex3f(0.450890064f, 0.503000975f, -1.f),
    C_Vertex3f(0.452636719f, 0.46595192f, -1.f),
    C_Vertex3f(0.452636719f, 0.48552227f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.376338243f, 0.331521392f, -1.f),
    C_Vertex3f(0.388303518f, 0.343223691f, -1.f),
    C_Vertex3f(0.389757156f, 0.606599808f, -1.f),
    C_Vertex3f(0.399094105f, 0.354451418f, -1.f),
    C_Vertex3f(0.403730392f, 0.593809128f, -1.f),
    C_Vertex3f(0.408710003f, 0.365204573f, -1.f),
    C_Vertex3f(0.415956974f, 0.58034873f, -1.f),
    C_Vertex3f(0.417151213f, 0.375483155f, -1.f),
    C_Vertex3f(0.426436901f, 0.566218615f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.376338243f, 0.331521392f, -1.f),
    C_Vertex3f(0.371582031f, 0.476987839f, -1.f),
    C_Vertex3f(0.371582031f, 0.464883804f, -1.f),
    C_Vertex3f(0.370053291f, 0.452670097f, -1.f),
    C_Vertex3f(0.366995811f, 0.44094944f, -1.f),
    C_Vertex3f(0.36319828f, 0.319344521f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.36319828f, 0.319344521f, -1.f),
    C_Vertex3f(0.366995811f, 0.44094944f, -1.f),
    C_Vertex3f(0.362409592f, 0.429721832f, -1.f),
    C_Vertex3f(0.357823372f, 0.421670914f, -1.f),
    C_Vertex3f(0.353871942f, 0.415849805f, -1.f),
    C_Vertex3f(0.351233482f, 0.308765411f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.32110405f, 0.280328035f, -1.f),
    C_Vertex3f(0.327386856f, 0.286598921f, -1.f),
    C_Vertex3f(0.329126716f, 0.388027072f, -1.f),
    C_Vertex3f(0.334502697f, 0.293428779f, -1.f),
    C_Vertex3f(0.336653948f, 0.3956635f, -1.f),
    C_Vertex3f(0.342451572f, 0.300817609f, -1.f),
    C_Vertex3f(0.34328723f, 0.402846098f, -1.f),
    C_Vertex3f(0.351233482f, 0.308765411f, -1.f),
    C_Vertex3f(0.349026561f, 0.409574866f, -1.f),
    C_Vertex3f(0.353871942f, 0.415849805f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.307253838f, 0.264869213f, -1.f),
    C_Vertex3f(0.31103754f, 0.269463181f, -1.f),
    C_Vertex3f(0.3113904f, 0.371392727f, -1.f),
    C_Vertex3f(0.315654278f, 0.274616122f, -1.f),
    C_Vertex3f(0.320705533f, 0.379936814f, -1.f),
    C_Vertex3f(0.32110405f, 0.280328035f, -1.f),
    C_Vertex3f(0.329126716f, 0.388027072f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.286875725f, 0.220533371f, -1.f),
    C_Vertex3f(0.291135788f, 0.236240387f, -1.f),
    C_Vertex3f(0.296076775f, 0.357895851f, -1.f),
    C_Vertex3f(0.299877167f, 0.254781723f, -1.f),
    C_Vertex3f(0.3113904f, 0.371392727f, -1.f),
    C_Vertex3f(0.307253838f, 0.264869213f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.281738281f, 0.157714844f, -1.f),
    C_Vertex3f(0.281957626f, 0.169492722f, -1.f),
    C_Vertex3f(0.27879858f, 0.34205389f, -1.f),
    C_Vertex3f(0.282996655f, 0.189777374f, -1.f),
    C_Vertex3f(0.296076775f, 0.357895851f, -1.f),
    C_Vertex3f(0.284636021f, 0.206790924f, -1.f),
    C_Vertex3f(0.286875725f, 0.220533371f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.281738281f, 0.157714844f, -1.f),
    C_Vertex3f(0.27879858f, 0.34205389f, -1.f),
    C_Vertex3f(0.264660358f, 0.328365803f, -1.f),
    C_Vertex3f(0.253662109f, 0.316831589f, -1.f),
    C_Vertex3f(0.244382858f, 0.305707932f, -1.f),
    C_Vertex3f(0.235156059f, 0.292894363f, -1.f),
    C_Vertex3f(0.227402687f, 0.280134201f, -1.f),
    C_Vertex3f(0.221122742f, 0.267427444f, -1.f),
    C_Vertex3f(0.218719482f, 0.261100769f, -1.f),
    C_Vertex3f(0.215442657f, 0.25270462f, -1.f),
    C_Vertex3f(0.21052742f, 0.234330177f, -1.f),
    C_Vertex3f(0.207250595f, 0.214373589f, -1.f),
    C_Vertex3f(0.206054688f, 0.157714844f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.207250595f, 0.214373589f, -1.f),
    C_Vertex3f(0.205612183f, 0.192834854f, -1.f),
    C_Vertex3f(0.205667496f, 0.17440033f, -1.f),
    C_Vertex3f(0.205778122f, 0.168510437f, -1.f),
    C_Vertex3f(0.205944061f, 0.161640167f, -1.f),
    C_Vertex3f(0.206054688f, 0.157714844f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.192382813f, 0.0893554688f, -1.f),
    C_Vertex3f(0.192382813f, 0.f, -1.f),
    C_Vertex3f(0.281738281f, 0.f, -1.f),
    C_Vertex3f(0.281738281f, 0.0893554688f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.205667496f, 0.17440033f, -1.f),
    C_Vertex3f(0.205612183f, 0.192834854f, -1.f),
    C_Vertex3f(0.205612183f, 0.179309845f, -1.f),
    C_End(),
    C_Translatef(0.497558594f, 0.f, 0.f),
};
static const Call char_64[] = {
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_FrontFace(GL_CW),
    C_Begin(GL_QUAD_STRIP),
    C_Normal3f(0.756130219f, -0.65442127f, 0.f),
    C_Vertex3f(0.507324219f, 0.0710906982f, 0.f),
    C_Vertex3f(0.507324219f, 0.0710906982f, -1.f),
    C_Normal3f(0.720308602f, -0.693653762f, 0.f),
    C_Vertex3f(0.500230789f, 0.0628948212f, 0.f),
    C_Vertex3f(0.500230789f, 0.0628948212f, -1.f),
    C_Normal3f(0.670676231f, -0.741750121f, 0.f),
    C_Vertex3f(0.485198975f, 0.0481152534f, 0.f),
    C_Vertex3f(0.485198975f, 0.0481152534f, -1.f),
    C_Normal3f(0.604272902f, -0.796777308f, 0.f),
    C_Vertex3f(0.469322205f, 0.0349478722f, 0.f),
    C_Vertex3f(0.469322205f, 0.0349478722f, -1.f),
    C_Normal3f(0.531205714f, -0.847242832f, 0.f),
    C_Vertex3f(0.452600479f, 0.0233926773f, 0.f),
    C_Vertex3f(0.452600479f, 0.0233926773f, -1.f),
    C_Normal3f(0.443534225f, -0.896257341f, 0.f),
    C_Vertex3f(0.435033798f, 0.0134496689f, 0.f),
    C_Vertex3f(0.435033798f, 0.0134496689f, -1.f),
    C_Normal3f(0.332807451f, -0.942994833f, 0.f),
    C_Vertex3f(0.417439461f, 0.00599241257f, 0.f),
    C_Vertex3f(0.417439461f, 0.00599241257f, -1.f),
    C_Normal3f(0.206850991f, -0.978372514f, 0.f),
    C_Vertex3f(0.399817467f, 0.00102090836f, 0.f),
    C_Vertex3f(0.399817467f, 0.00102090836f, -1.f),
    C_Normal3f(0.068508476f, -0.997650623f, 0.f),
    C_Vertex3f(0.382167816f, -0.00146484375f, 0.f),
    C_Vertex3f(0.382167816f, -0.00146484375f, -1.f),
    C_Normal3f(-0.0751502365f, -0.997172236f, 0.f),
    C_Vertex3f(0.363618851f, -0.00146484375f, 0.f),
    C_Vertex3f(0.363618851f, -0.00146484375f, -1.f),
    C_Normal3f(-0.218718082f, -0.975788057f, 0.f),
    C_Vertex3f(0.344470501f, 0.00137615204f, 0.f),
    C_Vertex3f(0.344470501f, 0.00137615204f, -1.f),
    C_Normal3f(-0.35440284f, -0.935092866f, 0.f),
    C_Vertex3f(0.325594425f, 0.00705814362f, 0.f),
    C_Vertex3f(0.325594425f, 0.00705814362f, -1.f),
    C_Normal3f(-0.474076092f, -0.880483866f, 0.f),
    C_Vertex3f(0.306990623f, 0.015581131f, 0.f),
    C_Vertex3f(0.306990623f, 0.015581131f, -1.f),
    C_Normal3f(-0.59377718f, -0.804629564f, 0.f),
    C_Vertex3f(0.288659096f, 0.0269451141f, 0.f),
    C_Vertex3f(0.288659096f, 0.0269451141f, -1.f),
    C_Normal3f(-0.711537778f, -0.702647805f, 0.f),
    C_Vertex3f(0.272046089f, 0.0413684845f, 0.f),
    C_Vertex3f(0.272046089f, 0.0413684845f, -1.f),
    C_Normal3f(-0.80452913f, -0.593913257f, 0.f),
    C_Vertex3f(0.257151604f, 0.0588512421f, 0.f),
    C_Vertex3f(0.257151604f, 0.0588512421f, -1.f),
    C_Normal3f(-0.8732391f, -0.487291843f, 0.f),
    C_Vertex3f(0.243975639f, 0.0793933868f, 0.f),
    C_Vertex3f(0.243975639f, 0.0793933868f, -1.f),
    C_Normal3f(-0.923723042f, -0.383061111f, 0.f),
    C_Vertex3f(0.232518196f, 0.102994919f, 0.f),
    C_Vertex3f(0.232518196f, 0.102994919f, -1.f),
    C_Normal3f(-0.962264001f, -0.272117496f, 0.f),
    C_Vertex3f(0.223925114f, 0.127743721f, 0.f),
    C_Vertex3f(0.223925114f, 0.127743721f, -1.f),
    C_Normal3f(-0.987080991f, -0.160222173f, 0.f),
    C_Vertex3f(0.218196392f, 0.153639793f, 0.f),
    C_Vertex3f(0.218196392f, 0.153639793f, -1.f),
    C_Normal3f(-0.998351634f, -0.0573928952f, 0.f),
    C_Vertex3f(0.215332031f, 0.180683136f, 0.f),
    C_Vertex3f(0.215332031f, 0.180683136f, -1.f),
    C_Normal3f(-0.999616981f, 0.0276760682f, 0.f),
    C_Vertex3f(0.215332031f, 0.203465462f, 0.f),
    C_Vertex3f(0.215332031f, 0.203465462f, -1.f),
    C_Normal3f(-0.995428562f, 0.0955090448f, 0.f),
    C_Vertex3f(0.216444016f, 0.220846295f, 0.f),
    C_Vertex3f(0.216444016f, 0.220846295f, -1.f),
    C_Normal3f(-0.987463713f, 0.157846361f, 0.f),
    C_Vertex3f(0.218667984f, 0.238233924f, 0.f),
    C_Vertex3f(0.218667984f, 0.238233924f, -1.f),
    C_Normal3f(-0.975880027f, 0.218307301f, 0.f),
    C_Vertex3f(0.222003937f, 0.255628347f, 0.f),
    C_Vertex3f(0.222003937f, 0.255628347f, -1.f),
    C_Normal3f(-0.961067855f, 0.276312649f, 0.f),
    C_Vertex3f(0.226451874f, 0.273029566f, 0.f),
    C_Vertex3f(0.226451874f, 0.273029566f, -1.f),
    C_Normal3f(-0.943487406f, 0.331408381f, 0.f),
    C_Vertex3f(0.232011795f, 0.290437579f, 0.f),
    C_Vertex3f(0.232011795f, 0.290437579f, -1.f),
    C_Normal3f(-0.923634887f, 0.383273602f, 0.f),
    C_Vertex3f(0.238683701f, 0.307852387f, 0.f),
    C_Vertex3f(0.238683701f, 0.307852387f, -1.f),
    C_Normal3f(-0.902009606f, 0.431716114f, 0.f),
    C_Vertex3f(0.24646759f, 0.325273991f, 0.f),
    C_Vertex3f(0.24646759f, 0.325273991f, -1.f),
    C_Normal3f(-0.87887758f, 0.477047443f, 0.f),
    C_Vertex3f(0.255363464f, 0.342702389f, 0.f),
    C_Vertex3f(0.255363464f, 0.342702389f, -1.f),
    C_Normal3f(-0.8521083f, 0.523365438f, 0.f),
    C_Vertex3f(0.264798164f, 0.359044909f, 0.f),
    C_Vertex3f(0.264798164f, 0.359044909f, -1.f),
    C_Normal3f(-0.820713818f, 0.571339548f, 0.f),
    C_Vertex3f(0.27477169f, 0.374301553f, 0.f),
    C_Vertex3f(0.27477169f, 0.374301553f, -1.f),
    C_Normal3f(-0.784239948f, 0.620457768f, 0.f),
    C_Vertex3f(0.285284042f, 0.388472319f, 0.f),
    C_Vertex3f(0.285284042f, 0.388472319f, -1.f),
    C_Normal3f(-0.742327034f, 0.670037806f, 0.f),
    C_Vertex3f(0.29633522f, 0.401557207f, 0.f),
    C_Vertex3f(0.29633522f, 0.401557207f, -1.f),
    C_Normal3f(-0.694770277f, 0.719231665f, 0.f),
    C_Vertex3f(0.307925224f, 0.413556218f, 0.f),
    C_Vertex3f(0.307925224f, 0.413556218f, -1.f),
    C_Normal3f(-0.641582727f, 0.767053902f, 0.f),
    C_Vertex3f(0.320054054f, 0.424469352f, 0.f),
    C_Vertex3f(0.320054054f, 0.424469352f, -1.f),
    C_Normal3f(-0.583047807f, 0.812437773f, 0.f),
    C_Vertex3f(0.33272171f, 0.434296608f, 0.f),
    C_Vertex3f(0.33272171f, 0.434296608f, -1.f),
    C_Normal3f(-0.528643489f, 0.848843992f, 0.f),
    C_Vertex3f(0.345928192f, 0.443037987f, 0.f),
    C_Vertex3f(0.345928192f, 0.443037987f, -1.f),
    C_Normal3f(-0.477652431f, 0.87854892f, 0.f),
    C_Vertex3f(0.359039307f, 0.450686693f, 0.f),
    C_Vertex3f(0.359039307f, 0.450686693f, -1.f),
    C_Normal3f(-0.420467198f, 0.907307744f, 0.f),
    C_Vertex3f(0.372055054f, 0.457242727f, 0.f),
    C_Vertex3f(0.372055054f, 0.457242727f, -1.f),
    C_Normal3f(-0.356827974f, 0.934170067f, 0.f),
    C_Vertex3f(0.384975433f, 0.462706089f, 0.f),
    C_Vertex3f(0.384975433f, 0.462706089f, -1.f),
    C_Normal3f(-0.286739409f, 0.958008647f, 0.f),
    C_Vertex3f(0.397800446f, 0.467076778f, 0.f),
    C_Vertex3f(0.397800446f, 0.467076778f, -1.f),
    C_Normal3f(-0.210569456f, 0.977578878f, 0.f),
    C_Vertex3f(0.41053009f, 0.470354795f, 0.f),
    C_Vertex3f(0.41053009f, 0.470354795f, -1.f),
    C_Normal3f(-0.129128382f, 0.991627812f, 0.f),
    C_Vertex3f(0.423164368f, 0.47254014f, 0.f),
    C_Vertex3f(0.423164368f, 0.47254014f, -1.f),
    C_Normal3f(-0.0386397019f, 0.999253154f, 0.f),
    C_Vertex3f(0.435703278f, 0.473632813f, 0.f),
    C_Vertex3f(0.435703278f, 0.473632813f, -1.f),
    C_Normal3f(0.0723346695f, 0.997380376f, 0.f),
    C_Vertex3f(0.451421738f, 0.473632813f, 0.f),
    C_Vertex3f(0.451421738f, 0.473632813f, -1.f),
    C_Normal3f(0.199256256f, 0.979947388f, 0.f),
    C_Vertex3f(0.469977856f, 0.47114706f, 0.f),
    C_Vertex3f(0.469977856f, 0.47114706f, -1.f),
    C_Normal3f(0.327965677f, 0.944689631f, 0.f),
    C_Vertex3f(0.488096714f, 0.466175556f, 0.f),
    C_Vertex3f(0.488096714f, 0.466175556f, -1.f),
    C_Normal3f(0.44592759f, 0.895069063f, 0.f),
    C_Vertex3f(0.505778313f, 0.4587183f, 0.f),
    C_Vertex3f(0.505778313f, 0.4587183f, -1.f),
    C_Normal3f(0.55967325f, 0.828713357f, 0.f),
    C_Vertex3f(0.523022652f, 0.448775291f, 0.f),
    C_Vertex3f(0.523022652f, 0.448775291f, -1.f),
    C_Normal3f(0.667271316f, 0.744814754f, 0.f),
    C_Vertex3f(0.539066792f, 0.436236858f, 0.f),
    C_Vertex3f(0.539066792f, 0.436236858f, -1.f),
    C_Normal3f(0.755617499f, 0.655013204f, 0.f),
    C_Vertex3f(0.553910732f, 0.421103001f, 0.f),
    C_Vertex3f(0.553910732f, 0.421103001f, -1.f),
    C_Normal3f(0.814521194f, 0.580133796f, 0.f),
    C_Vertex3f(0.567554474f, 0.403373718f, 0.f),
    C_Vertex3f(0.567554474f, 0.403373718f, -1.f),
    C_Normal3f(0.852854252f, 0.522149146f, 0.f),
    C_Vertex3f(0.573776245f, 0.393211365f, 0.f),
    C_Vertex3f(0.573776245f, 0.393211365f, -1.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.976062775f, 0.217489257f, 0.f),
    C_Vertex3f(0.573776245f, 0.393211365f, 0.f),
    C_Vertex3f(0.573776245f, 0.393211365f, -1.f),
    C_Vertex3f(0.588867188f, 0.4609375f, -1.f),
    C_Vertex3f(0.588867188f, 0.4609375f, 0.f),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.588867188f, 0.4609375f, 0.f),
    C_Vertex3f(0.588867188f, 0.4609375f, -1.f),
    C_Vertex3f(0.666992188f, 0.4609375f, -1.f),
    C_Vertex3f(0.666992188f, 0.4609375f, 0.f),
    C_End(),
    C_Begin(GL_QUAD_STRIP),
    C_Normal3f(0.977699578f, -0.210008442f, 0.f),
    C_Vertex3f(0.666992188f, 0.4609375f, 0.f),
    C_Vertex3f(0.666992188f, 0.4609375f, -1.f),
    C_Normal3f(0.977730572f, -0.209863976f, 0.f),
    C_Vertex3f(0.602309227f, 0.159804344f, 0.f),
    C_Vertex3f(0.602309227f, 0.159804344f, -1.f),
    C_Normal3f(0.978795111f, -0.204841524f, 0.f),
    C_Vertex3f(0.599436998f, 0.146206141f, 0.f),
    C_Vertex3f(0.599436998f, 0.146206141f, -1.f),
    C_Normal3f(0.979724884f, -0.200347528f, 0.f),
    C_Vertex3f(0.596975088f, 0.134316206f, 0.f),
    C_Vertex3f(0.596975088f, 0.134316206f, -1.f),
    C_Normal3f(0.980964541f, -0.194186971f, 0.f),
    C_Vertex3f(0.594923496f, 0.124134541f, 0.f),
    C_Vertex3f(0.594923496f, 0.124134541f, -1.f),
    C_Normal3f(0.982696414f, -0.185223252f, 0.f),
    C_Vertex3f(0.593282223f, 0.115661144f, 0.f),
    C_Vertex3f(0.593282223f, 0.115661144f, -1.f),
    C_Normal3f(0.9852736f, -0.17098476f, 0.f),
    C_Vertex3f(0.592051268f, 0.108896017f, 0.f),
    C_Vertex3f(0.592051268f, 0.108896017f, -1.f),
    C_Normal3f(0.989446044f, -0.144901723f, 0.f),
    C_Vertex3f(0.591230631f, 0.103839159f, 0.f),
    C_Vertex3f(0.591230631f, 0.103839159f, -1.f),
    C_Normal3f(0.998344183f, -0.0575228594f, 0.f),
    C_Vertex3f(0.590820313f, 0.10049057f, 0.f),
    C_Vertex3f(0.590820313f, 0.10049057f, -1.f),
    C_Normal3f(0.992745161f, 0.120236784f, 0.f),
    C_Vertex3f(0.590820313f, 0.0967178345f, 0.f),
    C_Vertex3f(0.590820313f, 0.0967178345f, -1.f),
    C_Normal3f(0.952898741f, 0.303288758f, 0.f),
    C_Vertex3f(0.591942787f, 0.0912227631f, 0.f),
    C_Vertex3f(0.591942787f, 0.0912227631f, -1.f),
    C_Normal3f(0.866889834f, 0.498499781f, 0.f),
    C_Vertex3f(0.594187737f, 0.0861377716f, 0.f),
    C_Vertex3f(0.594187737f, 0.0861377716f, -1.f),
    C_Normal3f(0.751115561f, 0.660170794f, 0.f),
    C_Vertex3f(0.597555161f, 0.0814628601f, 0.f),
    C_Vertex3f(0.597555161f, 0.0814628601f, -1.f),
    C_Normal3f(0.620026946f, 0.784580529f, 0.f),
    C_Vertex3f(0.602045059f, 0.0771980286f, 0.f),
    C_Vertex3f(0.602045059f, 0.0771980286f, -1.f),
    C_Normal3f(0.457096726f, 0.889416993f, 0.f),
    C_Vertex3f(0.606999397f, 0.0739994049f, 0.f),
    C_Vertex3f(0.606999397f, 0.0739994049f, -1.f),
    C_Normal3f(0.272318214f, 0.962207198f, 0.f),
    C_Vertex3f(0.612418175f, 0.0718669891f, 0.f),
    C_Vertex3f(0.612418175f, 0.0718669891f, -1.f),
    C_Normal3f(0.0715609118f, 0.997436285f, 0.f),
    C_Vertex3f(0.618301392f, 0.0708007813f, 0.f),
    C_Vertex3f(0.618301392f, 0.0708007813f, -1.f),
    C_Normal3f(-0.147234142f, 0.989101648f, 0.f),
    C_Vertex3f(0.627279282f, 0.0708007813f, 0.f),
    C_Vertex3f(0.627279282f, 0.0708007813f, -1.f),
    C_Normal3f(-0.329704612f, 0.944084048f, 0.f),
    C_Vertex3f(0.640692711f, 0.074133873f, 0.f),
    C_Vertex3f(0.640692711f, 0.074133873f, -1.f),
    C_Normal3f(-0.459165573f, 0.888350725f, 0.f),
    C_Vertex3f(0.655911446f, 0.0808000565f, 0.f),
    C_Vertex3f(0.655911446f, 0.0808000565f, -1.f),
    C_Normal3f(-0.541282117f, 0.840841055f, 0.f),
    C_Vertex3f(0.672935486f, 0.0907993317f, 0.f),
    C_Vertex3f(0.672935486f, 0.0907993317f, -1.f),
    C_Normal3f(-0.598323464f, 0.80125463f, 0.f),
    C_Vertex3f(0.688591003f, 0.101837158f, 0.f),
    C_Vertex3f(0.688591003f, 0.101837158f, -1.f),
    C_Normal3f(-0.650683463f, 0.759349048f, 0.f),
    C_Vertex3f(0.700422645f, 0.111324906f, 0.f),
    C_Vertex3f(0.700422645f, 0.111324906f, -1.f),
    C_Normal3f(-0.69875139f, 0.715364635f, 0.f),
    C_Vertex3f(0.711604238f, 0.121557117f, 0.f),
    C_Vertex3f(0.711604238f, 0.121557117f, -1.f),
    C_Normal3f(-0.743538201f, 0.668693483f, 0.f),
    C_Vertex3f(0.722135782f, 0.132533789f, 0.f),
    C_Vertex3f(0.722135782f, 0.132533789f, -1.f),
    C_Normal3f(-0.784596205f, 0.620007038f, 0.f),
    C_Vertex3f(0.732017279f, 0.144254923f, 0.f),
    C_Vertex3f(0.732017279f, 0.144254923f, -1.f),
    C_Normal3f(-0.821631789f, 0.570018709f, 0.f),
    C_Vertex3f(0.741248727f, 0.156720519f, 0.f),
    C_Vertex3f(0.741248727f, 0.156720519f, -1.f),
    C_Normal3f(-0.854508638f, 0.519437075f, 0.f),
    C_Vertex3f(0.749830127f, 0.169930577f, 0.f),
    C_Vertex3f(0.749830127f, 0.169930577f, -1.f),
    C_Normal3f(-0.885886192f, 0.463902652f, 0.f),
    C_Vertex3f(0.757761478f, 0.183885098f, 0.f),
    C_Vertex3f(0.757761478f, 0.183885098f, -1.f),
    C_Normal3f(-0.921718538f, 0.387859404f, 0.f),
    C_Vertex3f(0.768683434f, 0.205933571f, 0.f),
    C_Vertex3f(0.768683434f, 0.205933571f, -1.f),
    C_Normal3f(-0.957180798f, 0.28949064f, 0.f),
    C_Vertex3f(0.779605389f, 0.235795498f, 0.f),
    C_Vertex3f(0.779605389f, 0.235795498f, -1.f),
    C_Normal3f(-0.984404087f, 0.17592223f, 0.f),
    C_Vertex3f(0.786886692f, 0.266121387f, 0.f),
    C_Vertex3f(0.786886692f, 0.266121387f, -1.f),
    C_Normal3f(-0.997858703f, 0.0654068142f, 0.f),
    C_Vertex3f(0.790527344f, 0.29691124f, 0.f),
    C_Vertex3f(0.790527344f, 0.29691124f, -1.f),
    C_Normal3f(-0.9996261f, -0.0273443181f, 0.f),
    C_Vertex3f(0.790527344f, 0.321663857f, 0.f),
    C_Vertex3f(0.790527344f, 0.321663857f, -1.f),
    C_Normal3f(-0.995190084f, -0.0979621187f, 0.f),
    C_Vertex3f(0.789359212f, 0.33961463f, 0.f),
    C_Vertex3f(0.789359212f, 0.33961463f, -1.f),
    C_Normal3f(-0.986360073f, -0.164601639f, 0.f),
    C_Vertex3f(0.787022948f, 0.357264757f, 0.f),
    C_Vertex3f(0.787022948f, 0.357264757f, -1.f),
    C_Normal3f(-0.972890019f, -0.23126848f, 0.f),
    C_Vertex3f(0.783518553f, 0.374614239f, 0.f),
    C_Vertex3f(0.783518553f, 0.374614239f, -1.f),
    C_Normal3f(-0.954868436f, -0.297029376f, 0.f),
    C_Vertex3f(0.778846025f, 0.391663074f, 0.f),
    C_Vertex3f(0.778846025f, 0.391663074f, -1.f),
    C_Normal3f(-0.932572901f, -0.360981584f, 0.f),
    C_Vertex3f(0.773005366f, 0.408411264f, 0.f),
    C_Vertex3f(0.773005366f, 0.408411264f, -1.f),
    C_Normal3f(-0.906449676f, -0.422313869f, 0.f),
    C_Vertex3f(0.765996575f, 0.424858809f, 0.f),
    C_Vertex3f(0.765996575f, 0.424858809f, -1.f),
    C_Normal3f(-0.877074122f, -0.480355114f, 0.f),
    C_Vertex3f(0.757819653f, 0.441005707f, 0.f),
    C_Vertex3f(0.757819653f, 0.441005707f, -1.f),
    C_Normal3f(-0.841507614f, -0.540245235f, 0.f),
    C_Vertex3f(0.748474598f, 0.456851959f, 0.f),
    C_Vertex3f(0.748474598f, 0.456851959f, -1.f),
    C_Normal3f(-0.798080623f, -0.602550566f, 0.f),
    C_Vertex3f(0.737981796f, 0.471905947f, 0.f),
    C_Vertex3f(0.737981796f, 0.471905947f, -1.f),
    C_Normal3f(-0.750372529f, -0.661015272f, 0.f),
    C_Vertex3f(0.726341248f, 0.486167669f, 0.f),
    C_Vertex3f(0.726341248f, 0.486167669f, -1.f),
    C_Normal3f(-0.699338973f, -0.714790285f, 0.f),
    C_Vertex3f(0.713552952f, 0.499637127f, 0.f),
    C_Vertex3f(0.713552952f, 0.499637127f, -1.f),
    C_Normal3f(-0.646047652f, -0.763297081f, 0.f),
    C_Vertex3f(0.699616909f, 0.51231432f, 0.f),
    C_Vertex3f(0.699616909f, 0.51231432f, -1.f),
    C_Normal3f(-0.591581583f, -0.806245148f, 0.f),
    C_Vertex3f(0.684533119f, 0.524199247f, 0.f),
    C_Vertex3f(0.684533119f, 0.524199247f, -1.f),
    C_Normal3f(-0.53695333f, -0.843611956f, 0.f),
    C_Vertex3f(0.668301582f, 0.53529191f, 0.f),
    C_Vertex3f(0.668301582f, 0.53529191f, -1.f),
    C_Normal3f(-0.483042777f, -0.875596821f, 0.f),
    C_Vertex3f(0.650922298f, 0.545592308f, 0.f),
    C_Vertex3f(0.650922298f, 0.545592308f, -1.f),
    C_Normal3f(-0.428991348f, -0.90330857f, 0.f),
    C_Vertex3f(0.632395267f, 0.555100441f, 0.f),
    C_Vertex3f(0.632395267f, 0.555100441f, -1.f),
    C_Normal3f(-0.372367293f, -0.928085506f, 0.f),
    C_Vertex3f(0.613383174f, 0.563420057f, 0.f),
    C_Vertex3f(0.613383174f, 0.563420057f, -1.f),
    C_Normal3f(-0.314363658f, -0.949302554f, 0.f),
    C_Vertex3f(0.593886018f, 0.570551157f, 0.f),
    C_Vertex3f(0.593886018f, 0.570551157f, -1.f),
    C_Normal3f(-0.255656421f, -0.966767669f, 0.f),
    C_Vertex3f(0.573903799f, 0.57649374f, 0.f),
    C_Vertex3f(0.573903799f, 0.57649374f, -1.f),
    C_Normal3f(-0.196928412f, -0.980417967f, 0.f),
    C_Vertex3f(0.553436518f, 0.581247807f, 0.f),
    C_Vertex3f(0.553436518f, 0.581247807f, -1.f),
    C_Normal3f(-0.138831556f, -0.990315974f, 0.f),
    C_Vertex3f(0.532484174f, 0.584813356f, 0.f),
    C_Vertex3f(0.532484174f, 0.584813356f, -1.f),
    C_Normal3f(-0.0819549337f, -0.996636093f, 0.f),
    C_Vertex3f(0.511046767f, 0.58719039f, 0.f),
    C_Vertex3f(0.511046767f, 0.58719039f, -1.f),
    C_Normal3f(-0.0258764774f, -0.999665201f, 0.f),
    C_Vertex3f(0.489124298f, 0.588378906f, 0.f),
    C_Vertex3f(0.489124298f, 0.588378906f, -1.f),
    C_Normal3f(0.0304978415f, -0.999534845f, 0.f),
    C_Vertex3f(0.46513176f, 0.588378906f, 0.f),
    C_Vertex3f(0.46513176f, 0.588378906f, -1.f),
    C_Normal3f(0.0902814046f, -0.995916307f, 0.f),
    C_Vertex3f(0.440107584f, 0.586883307f, 0.f),
    C_Vertex3f(0.440107584f, 0.586883307f, -1.f),
    C_Normal3f(0.152728587f, -0.988268197f, 0.f),
    C_Vertex3f(0.415636778f, 0.583892107f, 0.f),
    C_Vertex3f(0.415636778f, 0.583892107f, -1.f),
    C_Normal3f(0.216186509f, -0.976352036f, 0.f),
    C_Vertex3f(0.391719341f, 0.579405308f, 0.f),
    C_Vertex3f(0.391719341f, 0.579405308f, -1.f),
    C_Normal3f(0.279861212f, -0.96004045f, 0.f),
    C_Vertex3f(0.368355274f, 0.573422909f, 0.f),
    C_Vertex3f(0.368355274f, 0.573422909f, -1.f),
    C_Normal3f(0.342906713f, -0.93936944f, 0.f),
    C_Vertex3f(0.345544577f, 0.56594491f, 0.f),
    C_Vertex3f(0.345544577f, 0.56594491f, -1.f),
    C_Normal3f(0.404477865f, -0.914547861f, 0.f),
    C_Vertex3f(0.323287249f, 0.556971312f, 0.f),
    C_Vertex3f(0.323287249f, 0.556971312f, -1.f),
    C_Normal3f(0.463785976f, -0.885947287f, 0.f),
    C_Vertex3f(0.30158329f, 0.546502113f, 0.f),
    C_Vertex3f(0.30158329f, 0.546502113f, -1.f),
    C_Normal3f(0.523001015f, -0.852331996f, 0.f),
    C_Vertex3f(0.280432701f, 0.534537315f, 0.f),
    C_Vertex3f(0.280432701f, 0.534537315f, -1.f),
    C_Normal3f(0.583377481f, -0.812201202f, 0.f),
    C_Vertex3f(0.260470867f, 0.521275043f, 0.f),
    C_Vertex3f(0.260470867f, 0.521275043f, -1.f),
    C_Normal3f(0.641666353f, -0.766983867f, 0.f),
    C_Vertex3f(0.241697788f, 0.506715298f, 0.f),
    C_Vertex3f(0.241697788f, 0.506715298f, -1.f),
    C_Normal3f(0.696816921f, -0.717249036f, 0.f),
    C_Vertex3f(0.224113464f, 0.490858078f, 0.f),
    C_Vertex3f(0.224113464f, 0.490858078f, -1.f),
    C_Normal3f(0.747911453f, -0.663798571f, 0.f),
    C_Vertex3f(0.207717896f, 0.473703384f, 0.f),
    C_Vertex3f(0.207717896f, 0.473703384f, -1.f),
    C_Normal3f(0.794240177f, -0.607603908f, 0.f),
    C_Vertex3f(0.192511082f, 0.455251217f, 0.f),
    C_Vertex3f(0.192511082f, 0.455251217f, -1.f),
    C_Normal3f(0.835347593f, -0.549722135f, 0.f),
    C_Vertex3f(0.178493023f, 0.435501575f, 0.f),
    C_Vertex3f(0.178493023f, 0.435501575f, -1.f),
    C_Normal3f(0.871042967f, -0.491206646f, 0.f),
    C_Vertex3f(0.165663719f, 0.41445446f, 0.f),
    C_Vertex3f(0.165663719f, 0.41445446f, -1.f),
    C_Normal3f(0.900101483f, -0.43568036f, 0.f),
    C_Vertex3f(0.15402317f, 0.392109871f, 0.f),
    C_Vertex3f(0.15402317f, 0.392109871f, -1.f),
    C_Normal3f(0.924557328f, -0.381043047f, 0.f),
    C_Vertex3f(0.14383769f, 0.369362593f, 0.f),
    C_Vertex3f(0.14383769f, 0.369362593f, -1.f),
    C_Normal3f(0.945986807f, -0.32420519f, 0.f),
    C_Vertex3f(0.135107279f, 0.346212626f, 0.f),
    C_Vertex3f(0.135107279f, 0.346212626f, -1.f),
    C_Normal3f(0.96404475f, -0.265739679f, 0.f),
    C_Vertex3f(0.127831936f, 0.322659969f, 0.f),
    C_Vertex3f(0.127831936f, 0.322659969f, -1.f),
    C_Normal3f(0.978491604f, -0.206286684f, 0.f),
    C_Vertex3f(0.122011662f, 0.298704624f, 0.f),
    C_Vertex3f(0.122011662f, 0.298704624f, -1.f),
    C_Normal3f(0.989207923f, -0.146518901f, 0.f),
    C_Vertex3f(0.117646456f, 0.27434659f, 0.f),
    C_Vertex3f(0.117646456f, 0.27434659f, -1.f),
    C_Normal3f(0.996199191f, -0.0871044472f, 0.f),
    C_Vertex3f(0.114736319f, 0.249585867f, 0.f),
    C_Vertex3f(0.114736319f, 0.249585867f, -1.f),
    C_Normal3f(0.999598503f, -0.0283352435f, 0.f),
    C_Vertex3f(0.11328125f, 0.224422455f, 0.f),
    C_Vertex3f(0.11328125f, 0.224422455f, -1.f),
    C_Normal3f(0.999609113f, 0.027959507f, 0.f),
    C_Vertex3f(0.11328125f, 0.198254585f, 0.f),
    C_Vertex3f(0.11328125f, 0.198254585f, -1.f),
    C_Normal3f(0.996323466f, 0.085670948f, 0.f),
    C_Vertex3f(0.114735961f, 0.172413588f, 0.f),
    C_Vertex3f(0.114735961f, 0.172413588f, -1.f),
    C_Normal3f(0.989116251f, 0.147136375f, 0.f),
    C_Vertex3f(0.117645383f, 0.14750123f, 0.f),
    C_Vertex3f(0.117645383f, 0.14750123f, -1.f),
    C_Normal3f(0.977360845f, 0.211579457f, 0.f),
    C_Vertex3f(0.122009516f, 0.123517513f, 0.f),
    C_Vertex3f(0.122009516f, 0.123517513f, -1.f),
    C_Normal3f(0.960487247f, 0.278323621f, 0.f),
    C_Vertex3f(0.12782836f, 0.100462437f, 0.f),
    C_Vertex3f(0.12782836f, 0.100462437f, -1.f),
    C_Normal3f(0.938059986f, 0.3464728f, 0.f),
    C_Vertex3f(0.135101914f, 0.0783360004f, 0.f),
    C_Vertex3f(0.135101914f, 0.0783360004f, -1.f),
    C_Normal3f(0.909848154f, 0.41494149f, 0.f),
    C_Vertex3f(0.14383018f, 0.0571382046f, 0.f),
    C_Vertex3f(0.14383018f, 0.0571382046f, -1.f),
    C_Normal3f(0.875885606f, 0.482518673f, 0.f),
    C_Vertex3f(0.154013157f, 0.0368690491f, 0.f),
    C_Vertex3f(0.154013157f, 0.0368690491f, -1.f),
    C_Normal3f(0.835863888f, 0.548936725f, 0.f),
    C_Vertex3f(0.165650845f, 0.0175285339f, 0.f),
    C_Vertex3f(0.165650845f, 0.0175285339f, -1.f),
    C_Normal3f(0.78900373f, 0.614388466f, 0.f),
    C_Vertex3f(0.178586364f, -0.000548481941f, 0.f),
    C_Vertex3f(0.178586364f, -0.000548481941f, -1.f),
    C_Normal3f(0.736043334f, 0.676934302f, 0.f),
    C_Vertex3f(0.192819715f, -0.0173619986f, 0.f),
    C_Vertex3f(0.192819715f, -0.0173619986f, -1.f),
    C_Normal3f(0.677857816f, 0.735193014f, 0.f),
    C_Vertex3f(0.208350897f, -0.0329120159f, 0.f),
    C_Vertex3f(0.208350897f, -0.0329120159f, -1.f),
    C_Normal3f(0.615647912f, 0.788021445f, 0.f),
    C_Vertex3f(0.225179911f, -0.047198534f, 0.f),
    C_Vertex3f(0.225179911f, -0.047198534f, -1.f),
    C_Normal3f(0.550819457f, 0.83462435f, 0.f),
    C_Vertex3f(0.243306756f, -0.0602215528f, 0.f),
    C_Vertex3f(0.243306756f, -0.0602215528f, -1.f),
    C_Normal3f(0.484836161f, 0.87460506f, 0.f),
    C_Vertex3f(0.262731433f, -0.0719810724f, 0.f),
    C_Vertex3f(0.262731433f, -0.0719810724f, -1.f),
    C_Normal3f(0.419076949f, 0.907950699f, 0.f),
    C_Vertex3f(0.283453941f, -0.0824770927f, 0.f),
    C_Vertex3f(0.283453941f, -0.0824770927f, -1.f),
    C_Normal3f(0.361593187f, 0.932335973f, 0.f),
    C_Vertex3f(0.305474281f, -0.0917096138f, 0.f),
    C_Vertex3f(0.305474281f, -0.0917096138f, -1.f),
    C_Normal3f(0.31115514f, 0.950359166f, 0.f),
    C_Vertex3f(0.32808876f, -0.0997880697f, 0.f),
    C_Vertex3f(0.32808876f, -0.0997880697f, -1.f),
    C_Normal3f(0.260697335f, 0.965420544f, 0.f),
    C_Vertex3f(0.351297379f, -0.106712461f, 0.f),
    C_Vertex3f(0.351297379f, -0.106712461f, -1.f),
    C_Normal3f(0.210655347f, 0.977560341f, 0.f),
    C_Vertex3f(0.375100136f, -0.112482786f, 0.f),
    C_Vertex3f(0.375100136f, -0.112482786f, -1.f),
    C_Normal3f(0.161426187f, 0.986884832f, 0.f),
    C_Vertex3f(0.399497032f, -0.117099047f, 0.f),
    C_Vertex3f(0.399497032f, -0.117099047f, -1.f),
    C_Normal3f(0.113356315f, 0.993554413f, 0.f),
    C_Vertex3f(0.424488068f, -0.120561242f, 0.f),
    C_Vertex3f(0.424488068f, -0.120561242f, -1.f),
    C_Normal3f(0.0667345002f, 0.997770786f, 0.f),
    C_Vertex3f(0.450073242f, -0.122869372f, 0.f),
    C_Vertex3f(0.450073242f, -0.122869372f, -1.f),
    C_Normal3f(0.0214139894f, 0.999770761f, 0.f),
    C_Vertex3f(0.476252556f, -0.124023438f, 0.f),
    C_Vertex3f(0.476252556f, -0.124023438f, -1.f),
    C_Normal3f(-0.0218358561f, 0.999761581f, 0.f),
    C_Vertex3f(0.503953934f, -0.124023438f, 0.f),
    C_Vertex3f(0.503953934f, -0.124023438f, -1.f),
    C_Normal3f(-0.0670700818f, 0.997748196f, 0.f),
    C_Vertex3f(0.531422377f, -0.12281847f, 0.f),
    C_Vertex3f(0.531422377f, -0.12281847f, -1.f),
    C_Normal3f(-0.116296515f, 0.993214607f, 0.f),
    C_Vertex3f(0.557729959f, -0.120408535f, 0.f),
    C_Vertex3f(0.557729959f, -0.120408535f, -1.f),
    C_Normal3f(-0.169198513f, 0.985581994f, 0.f),
    C_Vertex3f(0.582876682f, -0.116793633f, 0.f),
    C_Vertex3f(0.582876682f, -0.116793633f, -1.f),
    C_Normal3f(-0.225693256f, 0.974198341f, 0.f),
    C_Vertex3f(0.606862545f, -0.111973763f, 0.f),
    C_Vertex3f(0.606862545f, -0.111973763f, -1.f),
    C_Normal3f(-0.28552717f, 0.958370566f, 0.f),
    C_Vertex3f(0.629687548f, -0.105948925f, 0.f),
    C_Vertex3f(0.629687548f, -0.105948925f, -1.f),
    C_Normal3f(-0.348233223f, 0.937407911f, 0.f),
    C_Vertex3f(0.65135169f, -0.09871912f, 0.f),
    C_Vertex3f(0.65135169f, -0.09871912f, -1.f),
    C_Normal3f(-0.413098723f, 0.910686255f, 0.f),
    C_Vertex3f(0.671854973f, -0.0902843475f, 0.f),
    C_Vertex3f(0.671854973f, -0.0902843475f, -1.f),
    C_Normal3f(-0.467207462f, 0.884147644f, 0.f),
    C_Vertex3f(0.691197395f, -0.0806446075f, 0.f),
    C_Vertex3f(0.691197395f, -0.0806446075f, -1.f),
    C_Normal3f(-0.511200547f, 0.859461427f, 0.f),
    C_Vertex3f(0.709324121f, -0.0704846382f, 0.f),
    C_Vertex3f(0.709324121f, -0.0704846382f, -1.f),
    C_Normal3f(-0.557219684f, 0.830365062f, 0.f),
    C_Vertex3f(0.726235151f, -0.0598044395f, 0.f),
    C_Vertex3f(0.726235151f, -0.0598044395f, -1.f),
    C_Normal3f(-0.604884326f, 0.796313345f, 0.f),
    C_Vertex3f(0.741930485f, -0.0486040115f, 0.f),
    C_Vertex3f(0.741930485f, -0.0486040115f, -1.f),
    C_Normal3f(-0.653638363f, 0.756807089f, 0.f),
    C_Vertex3f(0.756410122f, -0.0368833542f, 0.f),
    C_Vertex3f(0.756410122f, -0.0368833542f, -1.f),
    C_Normal3f(-0.702734172f, 0.711452484f, 0.f),
    C_Vertex3f(0.769674063f, -0.0246424675f, 0.f),
    C_Vertex3f(0.769674063f, -0.0246424675f, -1.f),
    C_Normal3f(-0.751236498f, 0.660033107f, 0.f),
    C_Vertex3f(0.781722307f, -0.0118813515f, 0.f),
    C_Vertex3f(0.781722307f, -0.0118813515f, -1.f),
    C_Normal3f(-0.790418446f, 0.612567306f, 0.f),
    C_Vertex3f(0.792554855f, 0.0013999939f, 0.f),
    C_Vertex3f(0.792554855f, 0.0013999939f, -1.f),
    C_Normal3f(-0.820465803f, 0.571695507f, 0.f),
    C_Vertex3f(0.797363281f, 0.00830078125f, 0.f),
    C_Vertex3f(0.797363281f, 0.00830078125f, -1.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.797363281f, 0.00830078125f, 0.f),
    C_Vertex3f(0.797363281f, 0.00830078125f, -1.f),
    C_Vertex3f(0.876464844f, 0.00830078125f, -1.f),
    C_Vertex3f(0.876464844f, 0.00830078125f, 0.f),
    C_End(),
    C_Begin(GL_QUAD_STRIP),
    C_Normal3f(0.899627328f, -0.436658621f, 0.f),
    C_Vertex3f(0.876464844f, 0.00830078125f, 0.f),
    C_Vertex3f(0.876464844f, 0.00830078125f, -1.f),
    C_Normal3f(0.879334152f, -0.476205111f, 0.f),
    C_Vertex3f(0.873679161f, 0.00256156921f, 0.f),
    C_Vertex3f(0.873679161f, 0.00256156921f, -1.f),
    C_Normal3f(0.85322082f, -0.521549821f, 0.f),
    C_Vertex3f(0.867110968f, -0.00897157192f, 0.f),
    C_Vertex3f(0.867110968f, -0.00897157192f, -1.f),
    C_Normal3f(0.821458995f, -0.570267558f, 0.f),
    C_Vertex3f(0.859545946f, -0.0205594301f, 0.f),
    C_Vertex3f(0.859545946f, -0.0205594301f, -1.f),
    C_Normal3f(0.789888263f, -0.613250792f, 0.f),
    C_Vertex3f(0.850984097f, -0.0322020054f, 0.f),
    C_Vertex3f(0.850984097f, -0.0322020054f, -1.f),
    C_Normal3f(0.75902015f, -0.651067197f, 0.f),
    C_Vertex3f(0.841425419f, -0.0438992977f, 0.f),
    C_Vertex3f(0.841425419f, -0.0438992977f, -1.f),
    C_Normal3f(0.729204655f, -0.684295654f, 0.f),
    C_Vertex3f(0.830869913f, -0.0556513071f, 0.f),
    C_Vertex3f(0.830869913f, -0.0556513071f, -1.f),
    C_Normal3f(0.700663686f, -0.713491738f, 0.f),
    C_Vertex3f(0.819317579f, -0.0674580336f, 0.f),
    C_Vertex3f(0.819317579f, -0.0674580336f, -1.f),
    C_Normal3f(0.670886457f, -0.741560042f, 0.f),
    C_Vertex3f(0.806768417f, -0.0793194771f, 0.f),
    C_Vertex3f(0.806768417f, -0.0793194771f, -1.f),
    C_Normal3f(0.617338479f, -0.786697686f, 0.f),
    C_Vertex3f(0.786449432f, -0.097193718f, 0.f),
    C_Vertex3f(0.786449432f, -0.097193718f, -1.f),
    C_Normal3f(0.544763267f, -0.838589907f, 0.f),
    C_Vertex3f(0.756789684f, -0.118538857f, 0.f),
    C_Vertex3f(0.756789684f, -0.118538857f, -1.f),
    C_Normal3f(0.465266168f, -0.885170758f, 0.f),
    C_Vertex3f(0.724562168f, -0.137396812f, 0.f),
    C_Vertex3f(0.724562168f, -0.137396812f, -1.f),
    C_Normal3f(0.392207056f, -0.919876993f, 0.f),
    C_Vertex3f(0.689766884f, -0.153767586f, 0.f),
    C_Vertex3f(0.689766884f, -0.153767586f, -1.f),
    C_Normal3f(0.326920003f, -0.945052028f, 0.f),
    C_Vertex3f(0.661744595f, -0.164180279f, 0.f),
    C_Vertex3f(0.661744595f, -0.164180279f, -1.f),
    C_Normal3f(0.269984424f, -0.962864697f, 0.f),
    C_Vertex3f(0.642107368f, -0.17025435f, 0.f),
    C_Vertex3f(0.642107368f, -0.17025435f, -1.f),
    C_Normal3f(0.220902354f, -0.975295961f, 0.f),
    C_Vertex3f(0.62151444f, -0.175460696f, 0.f),
    C_Vertex3f(0.62151444f, -0.175460696f, -1.f),
    C_Normal3f(0.17455411f, -0.984647572f, 0.f),
    C_Vertex3f(0.599965811f, -0.179799318f, 0.f),
    C_Vertex3f(0.599965811f, -0.179799318f, -1.f),
    C_Normal3f(0.131008446f, -0.991381168f, 0.f),
    C_Vertex3f(0.577461481f, -0.183270216f, 0.f),
    C_Vertex3f(0.577461481f, -0.183270216f, -1.f),
    C_Normal3f(0.0902526826f, -0.99591893f, 0.f),
    C_Vertex3f(0.554001451f, -0.185873389f, 0.f),
    C_Vertex3f(0.554001451f, -0.185873389f, -1.f),
    C_Normal3f(0.0522147082f, -0.998635888f, 0.f),
    C_Vertex3f(0.529585719f, -0.187608838f, 0.f),
    C_Vertex3f(0.529585719f, -0.187608838f, -1.f),
    C_Normal3f(0.0138188228f, -0.999904513f, 0.f),
    C_Vertex3f(0.504214287f, -0.188476563f, 0.f),
    C_Vertex3f(0.504214287f, -0.188476563f, -1.f),
    C_Normal3f(-0.0370273888f, -0.999314249f, 0.f),
    C_Vertex3f(0.466798782f, -0.188476563f, 0.f),
    C_Vertex3f(0.466798782f, -0.188476563f, -1.f),
    C_Normal3f(-0.101720825f, -0.994813025f, 0.f),
    C_Vertex3f(0.42017889f, -0.185362816f, 0.f),
    C_Vertex3f(0.42017889f, -0.185362816f, -1.f),
    C_Normal3f(-0.175006777f, -0.984567225f, 0.f),
    C_Vertex3f(0.375442982f, -0.179135323f, 0.f),
    C_Vertex3f(0.375442982f, -0.179135323f, -1.f),
    C_Normal3f(-0.246104777f, -0.969243288f, 0.f),
    C_Vertex3f(0.332591057f, -0.169794083f, 0.f),
    C_Vertex3f(0.332591057f, -0.169794083f, -1.f),
    C_Normal3f(-0.308354467f, -0.951271534f, 0.f),
    C_Vertex3f(0.301865101f, -0.160452843f, 0.f),
    C_Vertex3f(0.301865101f, -0.160452843f, -1.f),
    C_Normal3f(-0.357474327f, -0.933922946f, 0.f),
    C_Vertex3f(0.282139182f, -0.153440118f, 0.f),
    C_Vertex3f(0.282139182f, -0.153440118f, -1.f),
    C_Normal3f(-0.40321216f, -0.915106595f, 0.f),
    C_Vertex3f(0.263171315f, -0.145642161f, 0.f),
    C_Vertex3f(0.263171315f, -0.145642161f, -1.f),
    C_Normal3f(-0.449632883f, -0.893213451f, 0.f),
    C_Vertex3f(0.2449615f, -0.137058973f, 0.f),
    C_Vertex3f(0.2449615f, -0.137058973f, -1.f),
    C_Normal3f(-0.496337742f, -0.868129551f, 0.f),
    C_Vertex3f(0.227509737f, -0.127690554f, 0.f),
    C_Vertex3f(0.227509737f, -0.127690554f, -1.f),
    C_Normal3f(-0.542877734f, -0.839811802f, 0.f),
    C_Vertex3f(0.210816026f, -0.117536902f, 0.f),
    C_Vertex3f(0.210816026f, -0.117536902f, -1.f),
    C_Normal3f(-0.588769078f, -0.80830127f, 0.f),
    C_Vertex3f(0.194880366f, -0.10659802f, 0.f),
    C_Vertex3f(0.194880366f, -0.10659802f, -1.f),
    C_Normal3f(-0.633513272f, -0.773731709f, 0.f),
    C_Vertex3f(0.179702759f, -0.0948739052f, 0.f),
    C_Vertex3f(0.179702759f, -0.0948739052f, -1.f),
    C_Normal3f(-0.673819363f, -0.738896132f, 0.f),
    C_Vertex3f(0.165283203f, -0.0823645592f, 0.f),
    C_Vertex3f(0.165283203f, -0.0823645592f, -1.f),
    C_Normal3f(-0.710532069f, -0.703664839f, 0.f),
    C_Vertex3f(0.151751041f, -0.0693839788f, 0.f),
    C_Vertex3f(0.151751041f, -0.0693839788f, -1.f),
    C_Normal3f(-0.746475279f, -0.665413201f, 0.f),
    C_Vertex3f(0.139106274f, -0.0559321642f, 0.f),
    C_Vertex3f(0.139106274f, -0.0559321642f, -1.f),
    C_Normal3f(-0.781225443f, -0.624248922f, 0.f),
    C_Vertex3f(0.1273489f, -0.0420091152f, 0.f),
    C_Vertex3f(0.1273489f, -0.0420091152f, -1.f),
    C_Normal3f(-0.814355552f, -0.580366313f, 0.f),
    C_Vertex3f(0.11647892f, -0.0276148319f, 0.f),
    C_Vertex3f(0.11647892f, -0.0276148319f, -1.f),
    C_Normal3f(-0.845455289f, -0.534046233f, 0.f),
    C_Vertex3f(0.106496334f, -0.0127493143f, 0.f),
    C_Vertex3f(0.106496334f, -0.0127493143f, -1.f),
    C_Normal3f(-0.874153018f, -0.485650599f, 0.f),
    C_Vertex3f(0.0974011421f, 0.00258743763f, 0.f),
    C_Vertex3f(0.0974011421f, 0.00258743763f, -1.f),
    C_Normal3f(-0.90146625f, -0.432849288f, 0.f),
    C_Vertex3f(0.0891933441f, 0.0183954239f, 0.f),
    C_Vertex3f(0.0891933441f, 0.0183954239f, -1.f),
    C_Normal3f(-0.924649835f, -0.380818248f, 0.f),
    C_Vertex3f(0.080945015f, 0.0368595123f, 0.f),
    C_Vertex3f(0.080945015f, 0.0368595123f, -1.f),
    C_Normal3f(-0.943672717f, -0.330880374f, 0.f),
    C_Vertex3f(0.0729157925f, 0.0579183102f, 0.f),
    C_Vertex3f(0.0729157925f, 0.0579183102f, -1.f),
    C_Normal3f(-0.96015203f, -0.279478163f, 0.f),
    C_Vertex3f(0.0660336018f, 0.0793869495f, 0.f),
    C_Vertex3f(0.0660336018f, 0.0793869495f, -1.f),
    C_Normal3f(-0.973754823f, -0.227599666f, 0.f),
    C_Vertex3f(0.0602984428f, 0.10126543f, 0.f),
    C_Vertex3f(0.0602984428f, 0.10126543f, -1.f),
    C_Normal3f(-0.984442949f, -0.175704136f, 0.f),
    C_Vertex3f(0.0557103157f, 0.123553753f, 0.f),
    C_Vertex3f(0.0557103157f, 0.123553753f, -1.f),
    C_Normal3f(-0.992252827f, -0.124234959f, 0.f),
    C_Vertex3f(0.0522692204f, 0.146251917f, 0.f),
    C_Vertex3f(0.0522692204f, 0.146251917f, -1.f),
    C_Normal3f(-0.997287631f, -0.073602125f, 0.f),
    C_Vertex3f(0.0499751568f, 0.169359922f, 0.f),
    C_Vertex3f(0.0499751568f, 0.169359922f, -1.f),
    C_Normal3f(-0.999723971f, -0.0234933309f, 0.f),
    C_Vertex3f(0.048828125f, 0.192877769f, 0.f),
    C_Vertex3f(0.048828125f, 0.192877769f, -1.f),
    C_Normal3f(-0.999650598f, 0.0264342558f, 0.f),
    C_Vertex3f(0.048828125f, 0.218170166f, 0.f),
    C_Vertex3f(0.048828125f, 0.218170166f, -1.f),
    C_Normal3f(-0.996955216f, 0.0779764056f, 0.f),
    C_Vertex3f(0.0501935482f, 0.244513273f, 0.f),
    C_Vertex3f(0.0501935482f, 0.244513273f, -1.f),
    C_Normal3f(-0.99140805f, 0.130806059f, 0.f),
    C_Vertex3f(0.0529243946f, 0.270542383f, 0.f),
    C_Vertex3f(0.0529243946f, 0.270542383f, -1.f),
    C_Normal3f(-0.9829638f, 0.183799371f, 0.f),
    C_Vertex3f(0.0570206642f, 0.296257496f, 0.f),
    C_Vertex3f(0.0570206642f, 0.296257496f, -1.f),
    C_Normal3f(-0.971632719f, 0.236494884f, 0.f),
    C_Vertex3f(0.062482357f, 0.321658611f, 0.f),
    C_Vertex3f(0.062482357f, 0.321658611f, -1.f),
    C_Normal3f(-0.95750016f, 0.288432688f, 0.f),
    C_Vertex3f(0.069309473f, 0.346745729f, 0.f),
    C_Vertex3f(0.069309473f, 0.346745729f, -1.f),
    C_Normal3f(-0.940723538f, 0.33917436f, 0.f),
    C_Vertex3f(0.0775020123f, 0.37151885f, 0.f),
    C_Vertex3f(0.0775020123f, 0.37151885f, -1.f),
    C_Normal3f(-0.921198428f, 0.38909325f, 0.f),
    C_Vertex3f(0.0870599747f, 0.395977974f, 0.f),
    C_Vertex3f(0.0870599747f, 0.395977974f, -1.f),
    C_Normal3f(-0.897836387f, 0.440329343f, 0.f),
    C_Vertex3f(0.0991849899f, 0.422854424f, 0.f),
    C_Vertex3f(0.0991849899f, 0.422854424f, -1.f),
    C_Normal3f(-0.868328989f, 0.495988667f, 0.f),
    C_Vertex3f(0.113911152f, 0.45072782f, 0.f),
    C_Vertex3f(0.113911152f, 0.45072782f, -1.f),
    C_Normal3f(-0.8323915f, 0.554188192f, 0.f),
    C_Vertex3f(0.130036831f, 0.476866841f, 0.f),
    C_Vertex3f(0.130036831f, 0.476866841f, -1.f),
    C_Normal3f(-0.790684581f, 0.612223804f, 0.f),
    C_Vertex3f(0.147562027f, 0.501271486f, 0.f),
    C_Vertex3f(0.147562027f, 0.501271486f, -1.f),
    C_Normal3f(-0.74326539f, 0.668996751f, 0.f),
    C_Vertex3f(0.16648674f, 0.523941755f, 0.f),
    C_Vertex3f(0.16648674f, 0.523941755f, -1.f),
    C_Normal3f(-0.69048208f, 0.723349452f, 0.f),
    C_Vertex3f(0.18681097f, 0.544877648f, 0.f),
    C_Vertex3f(0.18681097f, 0.544877648f, -1.f),
    C_Normal3f(-0.63298595f, 0.774163246f, 0.f),
    C_Vertex3f(0.208534718f, 0.564079165f, 0.f),
    C_Vertex3f(0.208534718f, 0.564079165f, -1.f),
    C_Normal3f(-0.571700573f, 0.820462346f, 0.f),
    C_Vertex3f(0.231657982f, 0.581546307f, 0.f),
    C_Vertex3f(0.231657982f, 0.581546307f, -1.f),
    C_Normal3f(-0.505510092f, 0.862820625f, 0.f),
    C_Vertex3f(0.256180763f, 0.597279072f, 0.f),
    C_Vertex3f(0.256180763f, 0.597279072f, -1.f),
    C_Normal3f(-0.434746414f, 0.900552988f, 0.f),
    C_Vertex3f(0.282007694f, 0.611045241f, 0.f),
    C_Vertex3f(0.282007694f, 0.611045241f, -1.f),
    C_Normal3f(-0.362787575f, 0.931871831f, 0.f),
    C_Vertex3f(0.309138775f, 0.622844815f, 0.f),
    C_Vertex3f(0.309138775f, 0.622844815f, -1.f),
    C_Normal3f(-0.291071981f, 0.956701219f, 0.f),
    C_Vertex3f(0.337574005f, 0.632677794f, 0.f),
    C_Vertex3f(0.337574005f, 0.632677794f, -1.f),
    C_Normal3f(-0.220886722f, 0.975299478f, 0.f),
    C_Vertex3f(0.367313385f, 0.640544176f, 0.f),
    C_Vertex3f(0.367313385f, 0.640544176f, -1.f),
    C_Normal3f(-0.153282717f, 0.988182425f, 0.f),
    C_Vertex3f(0.398356915f, 0.646443963f, 0.f),
    C_Vertex3f(0.398356915f, 0.646443963f, -1.f),
    C_Normal3f(-0.0890363529f, 0.996028364f, 0.f),
    C_Vertex3f(0.430704594f, 0.650377154f, 0.f),
    C_Vertex3f(0.430704594f, 0.650377154f, -1.f),
    C_Normal3f(-0.0303933751f, 0.999538004f, 0.f),
    C_Vertex3f(0.464356422f, 0.65234375f, 0.f),
    C_Vertex3f(0.464356422f, 0.65234375f, -1.f),
    C_Normal3f(0.0241343491f, 0.999708712f, 0.f),
    C_Vertex3f(0.495379448f, 0.65234375f, 0.f),
    C_Vertex3f(0.495379448f, 0.65234375f, -1.f),
    C_Normal3f(0.0795537084f, 0.996830523f, 0.f),
    C_Vertex3f(0.521780014f, 0.650957465f, 0.f),
    C_Vertex3f(0.521780014f, 0.650957465f, -1.f),
    C_Normal3f(0.135368988f, 0.990795255f, 0.f),
    C_Vertex3f(0.547491074f, 0.648184896f, 0.f),
    C_Vertex3f(0.547491074f, 0.648184896f, -1.f),
    C_Normal3f(0.192927867f, 0.981212974f, 0.f),
    C_Vertex3f(0.572512627f, 0.644026041f, 0.f),
    C_Vertex3f(0.572512627f, 0.644026041f, -1.f),
    C_Normal3f(0.251693755f, 0.967806876f, 0.f),
    C_Vertex3f(0.596844673f, 0.638480902f, 0.f),
    C_Vertex3f(0.596844673f, 0.638480902f, -1.f),
    C_Normal3f(0.31103304f, 0.950399101f, 0.f),
    C_Vertex3f(0.620487213f, 0.631549478f, 0.f),
    C_Vertex3f(0.620487213f, 0.631549478f, -1.f),
    C_Normal3f(0.370240599f, 0.928935885f, 0.f),
    C_Vertex3f(0.643440247f, 0.623231769f, 0.f),
    C_Vertex3f(0.643440247f, 0.623231769f, -1.f),
    C_Normal3f(0.428576469f, 0.903505564f, 0.f),
    C_Vertex3f(0.665703773f, 0.613527775f, 0.f),
    C_Vertex3f(0.665703773f, 0.613527775f, -1.f),
    C_Normal3f(0.488844037f, 0.872371197f, 0.f),
    C_Vertex3f(0.687277794f, 0.602437496f, 0.f),
    C_Vertex3f(0.687277794f, 0.602437496f, -1.f),
    C_Normal3f(0.551392078f, 0.834246278f, 0.f),
    C_Vertex3f(0.707711697f, 0.589988112f, 0.f),
    C_Vertex3f(0.707711697f, 0.589988112f, -1.f),
    C_Normal3f(0.611968577f, 0.790882111f, 0.f),
    C_Vertex3f(0.727005482f, 0.576179624f, 0.f),
    C_Vertex3f(0.727005482f, 0.576179624f, -1.f),
    C_Normal3f(0.669475675f, 0.742833972f, 0.f),
    C_Vertex3f(0.745159149f, 0.56101203f, 0.f),
    C_Vertex3f(0.745159149f, 0.56101203f, -1.f),
    C_Normal3f(0.722949505f, 0.690900862f, 0.f),
    C_Vertex3f(0.762172699f, 0.544485331f, 0.f),
    C_Vertex3f(0.762172699f, 0.544485331f, -1.f),
    C_Normal3f(0.771639407f, 0.636060297f, 0.f),
    C_Vertex3f(0.778046131f, 0.526599526f, 0.f),
    C_Vertex3f(0.778046131f, 0.526599526f, -1.f),
    C_Normal3f(0.815056741f, 0.579381108f, 0.f),
    C_Vertex3f(0.792779446f, 0.507354617f, 0.f),
    C_Vertex3f(0.792779446f, 0.507354617f, -1.f),
    C_Normal3f(0.852921307f, 0.522039473f, 0.f),
    C_Vertex3f(0.806372643f, 0.486750603f, 0.f),
    C_Vertex3f(0.806372643f, 0.486750603f, -1.f),
    C_Normal3f(0.886058152f, 0.463573962f, 0.f),
    C_Vertex3f(0.817896843f, 0.466317177f, 0.f),
    C_Vertex3f(0.817896843f, 0.466317177f, -1.f),
    C_Normal3f(0.914959371f, 0.403545946f, 0.f),
    C_Vertex3f(0.827167749f, 0.447003603f, 0.f),
    C_Vertex3f(0.827167749f, 0.447003603f, -1.f),
    C_Normal3f(0.939222753f, 0.343308389f, 0.f),
    C_Vertex3f(0.835114241f, 0.427280188f, 0.f),
    C_Vertex3f(0.835114241f, 0.427280188f, -1.f),
    C_Normal3f(0.959645331f, 0.281212986f, 0.f),
    C_Vertex3f(0.841736317f, 0.407146931f, 0.f),
    C_Vertex3f(0.841736317f, 0.407146931f, -1.f),
    C_Normal3f(0.975939512f, 0.218041152f, 0.f),
    C_Vertex3f(0.847033978f, 0.386603832f, 0.f),
    C_Vertex3f(0.847033978f, 0.386603832f, -1.f),
    C_Normal3f(0.987975478f, 0.154610366f, 0.f),
    C_Vertex3f(0.851007223f, 0.365650892f, 0.f),
    C_Vertex3f(0.851007223f, 0.365650892f, -1.f),
    C_Normal3f(0.99578464f, 0.0917227268f, 0.f),
    C_Vertex3f(0.853656054f, 0.344288111f, 0.f),
    C_Vertex3f(0.853656054f, 0.344288111f, -1.f),
    C_Normal3f(0.99963057f, 0.027181292f, 0.f),
    C_Vertex3f(0.854980469f, 0.322515488f, 0.f),
    C_Vertex3f(0.854980469f, 0.322515488f, -1.f),
    C_Normal3f(0.998836219f, -0.0482314564f, 0.f),
    C_Vertex3f(0.854980469f, 0.295580864f, 0.f),
    C_Vertex3f(0.854980469f, 0.295580864f, -1.f),
    C_Normal3f(0.990644097f, -0.136470869f, 0.f),
    C_Vertex3f(0.85219264f, 0.264781713f, 0.f),
    C_Vertex3f(0.85219264f, 0.264781713f, -1.f),
    C_Normal3f(0.973151565f, -0.230165526f, 0.f),
    C_Vertex3f(0.846616983f, 0.234870195f, 0.f),
    C_Vertex3f(0.846616983f, 0.234870195f, -1.f),
    C_Normal3f(0.946366608f, -0.323094964f, 0.f),
    C_Vertex3f(0.838253498f, 0.20584631f, 0.f),
    C_Vertex3f(0.838253498f, 0.20584631f, -1.f),
    C_Normal3f(0.910889149f, -0.412651032f, 0.f),
    C_Vertex3f(0.827102184f, 0.177710056f, 0.f),
    C_Vertex3f(0.827102184f, 0.177710056f, -1.f),
    C_Normal3f(0.868019462f, -0.496530056f, 0.f),
    C_Vertex3f(0.813163042f, 0.150461435f, 0.f),
    C_Vertex3f(0.813163042f, 0.150461435f, -1.f),
    C_Normal3f(0.819545746f, -0.573013663f, 0.f),
    C_Vertex3f(0.796436071f, 0.124100447f, 0.f),
    C_Vertex3f(0.796436071f, 0.124100447f, -1.f),
    C_Normal3f(0.768636346f, -0.639685988f, 0.f),
    C_Vertex3f(0.776921272f, 0.0986270905f, 0.f),
    C_Vertex3f(0.776921272f, 0.0986270905f, -1.f),
    C_Normal3f(0.716952682f, -0.697121918f, 0.f),
    C_Vertex3f(0.755821228f, 0.0752983093f, 0.f),
    C_Vertex3f(0.755821228f, 0.0752983093f, -1.f),
    C_Normal3f(0.656702578f, -0.754149795f, 0.f),
    C_Vertex3f(0.735459089f, 0.0559854507f, 0.f),
    C_Vertex3f(0.735459089f, 0.0559854507f, -1.f),
    C_Normal3f(0.584604025f, -0.811318755f, 0.f),
    C_Vertex3f(0.714632273f, 0.039431572f, 0.f),
    C_Vertex3f(0.714632273f, 0.039431572f, -1.f),
    C_Normal3f(0.499656409f, -0.866223693f, 0.f),
    C_Vertex3f(0.693340778f, 0.025636673f, 0.f),
    C_Vertex3f(0.693340778f, 0.025636673f, -1.f),
    C_Normal3f(0.402092576f, -0.915598989f, 0.f),
    C_Vertex3f(0.671584606f, 0.0146007538f, 0.f),
    C_Vertex3f(0.671584606f, 0.0146007538f, -1.f),
    C_Normal3f(0.293649286f, -0.955913186f, 0.f),
    C_Vertex3f(0.649363756f, 0.00632381439f, 0.f),
    C_Vertex3f(0.649363756f, 0.00632381439f, -1.f),
    C_Normal3f(0.17770423f, -0.98408401f, 0.f),
    C_Vertex3f(0.626678228f, 0.000805854797f, 0.f),
    C_Vertex3f(0.626678228f, 0.000805854797f, -1.f),
    C_Normal3f(0.0647789761f, -0.997899652f, 0.f),
    C_Vertex3f(0.603528023f, -0.001953125f, 0.f),
    C_Vertex3f(0.603528023f, -0.001953125f, -1.f),
    C_Normal3f(-0.0347846746f, -0.999394894f, 0.f),
    C_Vertex3f(0.584177017f, -0.001953125f, 0.f),
    C_Vertex3f(0.584177017f, -0.001953125f, -1.f),
    C_Normal3f(-0.132197276f, -0.991223395f, 0.f),
    C_Vertex3f(0.570538521f, -0.000804901123f, 0.f),
    C_Vertex3f(0.570538521f, -0.000804901123f, -1.f),
    C_Normal3f(-0.242867857f, -0.970059395f, 0.f),
    C_Vertex3f(0.558348656f, 0.00149154663f, 0.f),
    C_Vertex3f(0.558348656f, 0.00149154663f, -1.f),
    C_Normal3f(-0.372350246f, -0.928092241f, 0.f),
    C_Vertex3f(0.547607422f, 0.00493621826f, 0.f),
    C_Vertex3f(0.547607422f, 0.00493621826f, -1.f),
    C_Normal3f(-0.50558567f, -0.862776399f, 0.f),
    C_Vertex3f(0.538314819f, 0.00952911377f, 0.f),
    C_Vertex3f(0.538314819f, 0.00952911377f, -1.f),
    C_Normal3f(-0.631739259f, -0.775180995f, 0.f),
    C_Vertex3f(0.530252457f, 0.0151062012f, 0.f),
    C_Vertex3f(0.530252457f, 0.0151062012f, -1.f),
    C_Normal3f(-0.750184119f, -0.661229074f, 0.f),
    C_Vertex3f(0.523420334f, 0.0216674805f, 0.f),
    C_Vertex3f(0.523420334f, 0.0216674805f, -1.f),
    C_Normal3f(-0.844877541f, -0.534959793f, 0.f),
    C_Vertex3f(0.517818451f, 0.0292129517f, 0.f),
    C_Vertex3f(0.517818451f, 0.0292129517f, -1.f),
    C_Normal3f(-0.921879351f, -0.387476861f, 0.f),
    C_Vertex3f(0.514211655f, 0.0362110138f, 0.f),
    C_Vertex3f(0.514211655f, 0.0362110138f, -1.f),
    C_Normal3f(-0.965568244f, -0.260149986f, 0.f),
    C_Vertex3f(0.511752129f, 0.0436458588f, 0.f),
    C_Vertex3f(0.511752129f, 0.0436458588f, -1.f),
    C_Normal3f(-0.983915329f, -0.178635016f, 0.f),
    C_Vertex3f(0.509675026f, 0.0530490875f, 0.f),
    C_Vertex3f(0.509675026f, 0.0530490875f, -1.f),
    C_Normal3f(-0.99161762f, -0.12920697f, 0.f),
    C_Vertex3f(0.507980347f, 0.0644207001f, 0.f),
    C_Vertex3f(0.507980347f, 0.0644207001f, -1.f),
    C_Normal3f(-0.995196462f, -0.0978975073f, 0.f),
    C_Vertex3f(0.507324219f, 0.0710906982f, 0.f),
    C_Vertex3f(0.507324219f, 0.0710906982f, -1.f),
    C_End(),
    C_Begin(GL_QUAD_STRIP),
    C_Normal3f(0.998869956f, -0.0475256294f, 0.f),
    C_Vertex3f(0.296386719f, 0.198862076f, 0.f),
    C_Vertex3f(0.296386719f, 0.198862076f, -1.f),
    C_Normal3f(0.999593735f, 0.0285042413f, 0.f),
    C_Vertex3f(0.296386719f, 0.181959152f, 0.f),
    C_Vertex3f(0.296386719f, 0.181959152f, -1.f),
    C_Normal3f(0.9953565f, 0.0962566957f, 0.f),
    C_Vertex3f(0.297272325f, 0.167805433f, 0.f),
    C_Vertex3f(0.297272325f, 0.167805433f, -1.f),
    C_Normal3f(0.985594511f, 0.169125438f, 0.f),
    C_Vertex3f(0.299043536f, 0.154485941f, 0.f),
    C_Vertex3f(0.299043536f, 0.154485941f, -1.f),
    C_Normal3f(0.968562961f, 0.248768613f, 0.f),
    C_Vertex3f(0.301700354f, 0.142000675f, 0.f),
    C_Vertex3f(0.301700354f, 0.142000675f, -1.f),
    C_Normal3f(0.942454398f, 0.33433494f, 0.f),
    C_Vertex3f(0.305242777f, 0.130349636f, 0.f),
    C_Vertex3f(0.305242777f, 0.130349636f, -1.f),
    C_Normal3f(0.905593693f, 0.424146384f, 0.f),
    C_Vertex3f(0.309670806f, 0.119532824f, 0.f),
    C_Vertex3f(0.309670806f, 0.119532824f, -1.f),
    C_Normal3f(0.856814265f, 0.515625119f, 0.f),
    C_Vertex3f(0.314984441f, 0.109550238f, 0.f),
    C_Vertex3f(0.314984441f, 0.109550238f, -1.f),
    C_Normal3f(0.795885623f, 0.605446994f, 0.f),
    C_Vertex3f(0.321183681f, 0.100401878f, 0.f),
    C_Vertex3f(0.321183681f, 0.100401878f, -1.f),
    C_Normal3f(0.733895838f, 0.679261923f, 0.f),
    C_Vertex3f(0.328268528f, 0.0920877457f, 0.f),
    C_Vertex3f(0.328268528f, 0.0920877457f, -1.f),
    C_Normal3f(0.670580268f, 0.741836905f, 0.f),
    C_Vertex3f(0.335612178f, 0.0848128796f, 0.f),
    C_Vertex3f(0.335612178f, 0.0848128796f, -1.f),
    C_Normal3f(0.59446615f, 0.8041206f, 0.f),
    C_Vertex3f(0.343214631f, 0.07857728f, 0.f),
    C_Vertex3f(0.343214631f, 0.07857728f, -1.f),
    C_Normal3f(0.505118191f, 0.863050222f, 0.f),
    C_Vertex3f(0.351075888f, 0.0733809471f, 0.f),
    C_Vertex3f(0.351075888f, 0.0733809471f, -1.f),
    C_Normal3f(0.403451204f, 0.915001154f, 0.f),
    C_Vertex3f(0.359195948f, 0.0692238808f, 0.f),
    C_Vertex3f(0.359195948f, 0.0692238808f, -1.f),
    C_Normal3f(0.292055964f, 0.956401169f, 0.f),
    C_Vertex3f(0.367574811f, 0.066106081f, 0.f),
    C_Vertex3f(0.367574811f, 0.066106081f, -1.f),
    C_Normal3f(0.175067067f, 0.984556437f, 0.f),
    C_Vertex3f(0.376212478f, 0.0640275478f, 0.f),
    C_Vertex3f(0.376212478f, 0.0640275478f, -1.f),
    C_Normal3f(0.0530046299f, 0.998594344f, 0.f),
    C_Vertex3f(0.385108948f, 0.0629882813f, 0.f),
    C_Vertex3f(0.385108948f, 0.0629882813f, -1.f),
    C_Normal3f(-0.0786735713f, 0.996900439f, 0.f),
    C_Vertex3f(0.395792007f, 0.0629882813f, 0.f),
    C_Vertex3f(0.395792007f, 0.0629882813f, -1.f),
    C_Normal3f(-0.211536035f, 0.977370203f, 0.f),
    C_Vertex3f(0.40832901f, 0.0648207664f, 0.f),
    C_Vertex3f(0.40832901f, 0.0648207664f, -1.f),
    C_Normal3f(-0.331771344f, 0.943359792f, 0.f),
    C_Vertex3f(0.421192169f, 0.0684857368f, 0.f),
    C_Vertex3f(0.421192169f, 0.0684857368f, -1.f),
    C_Normal3f(-0.432980657f, 0.901403248f, 0.f),
    C_Vertex3f(0.434381485f, 0.0739831924f, 0.f),
    C_Vertex3f(0.434381485f, 0.0739831924f, -1.f),
    C_Normal3f(-0.523812532f, 0.851833582f, 0.f),
    C_Vertex3f(0.447896957f, 0.0813131332f, 0.f),
    C_Vertex3f(0.447896957f, 0.0813131332f, -1.f),
    C_Normal3f(-0.607645392f, 0.794208527f, 0.f),
    C_Vertex3f(0.461112499f, 0.090420723f, 0.f),
    C_Vertex3f(0.461112499f, 0.090420723f, -1.f),
    C_Normal3f(-0.677981257f, 0.735079169f, 0.f),
    C_Vertex3f(0.474028111f, 0.101305962f, 0.f),
    C_Vertex3f(0.474028111f, 0.101305962f, -1.f),
    C_Normal3f(-0.735981345f, 0.677001834f, 0.f),
    C_Vertex3f(0.486643791f, 0.113968849f, 0.f),
    C_Vertex3f(0.486643791f, 0.113968849f, -1.f),
    C_Normal3f(-0.79504925f, 0.606544852f, 0.f),
    C_Vertex3f(0.498959541f, 0.128409386f, 0.f),
    C_Vertex3f(0.498959541f, 0.128409386f, -1.f),
    C_Normal3f(-0.852494478f, 0.522736132f, 0.f),
    C_Vertex3f(0.510158539f, 0.144791603f, 0.f),
    C_Vertex3f(0.510158539f, 0.144791603f, -1.f),
    C_Normal3f(-0.89671123f, 0.442615986f, 0.f),
    C_Vertex3f(0.520240784f, 0.163115501f, 0.f),
    C_Vertex3f(0.520240784f, 0.163115501f, -1.f),
    C_Normal3f(-0.929791093f, 0.36808756f, 0.f),
    C_Vertex3f(0.529206276f, 0.183381081f, 0.f),
    C_Vertex3f(0.529206276f, 0.183381081f, -1.f),
    C_Normal3f(-0.955411851f, 0.295276314f, 0.f),
    C_Vertex3f(0.537055016f, 0.205588341f, 0.f),
    C_Vertex3f(0.537055016f, 0.205588341f, -1.f),
    C_Normal3f(-0.976546943f, 0.215304747f, 0.f),
    C_Vertex3f(0.54294157f, 0.227823734f, 0.f),
    C_Vertex3f(0.54294157f, 0.227823734f, -1.f),
    C_Normal3f(-0.991384983f, 0.130980074f, 0.f),
    C_Vertex3f(0.54686594f, 0.250087261f, 0.f),
    C_Vertex3f(0.54686594f, 0.250087261f, -1.f),
    C_Normal3f(-0.998850584f, 0.0479315035f, 0.f),
    C_Vertex3f(0.548828125f, 0.272378922f, 0.f),
    C_Vertex3f(0.548828125f, 0.272378922f, -1.f),
    C_Normal3f(-0.999603331f, -0.0281642675f, 0.f),
    C_Vertex3f(0.548828125f, 0.290977478f, 0.f),
    C_Vertex3f(0.548828125f, 0.290977478f, -1.f),
    C_Normal3f(-0.994914234f, -0.100726515f, 0.f),
    C_Vertex3f(0.547908425f, 0.305020809f, 0.f),
    C_Vertex3f(0.547908425f, 0.305020809f, -1.f),
    C_Normal3f(-0.984228492f, -0.176901564f, 0.f),
    C_Vertex3f(0.546069026f, 0.318230152f, 0.f),
    C_Vertex3f(0.546069026f, 0.318230152f, -1.f),
    C_Normal3f(-0.965628147f, -0.259927571f, 0.f),
    C_Vertex3f(0.543309927f, 0.330605507f, 0.f),
    C_Vertex3f(0.543309927f, 0.330605507f, -1.f),
    C_Normal3f(-0.937239826f, -0.348685414f, 0.f),
    C_Vertex3f(0.539631128f, 0.342146873f, 0.f),
    C_Vertex3f(0.539631128f, 0.342146873f, -1.f),
    C_Normal3f(-0.897436202f, -0.441144317f, 0.f),
    C_Vertex3f(0.53503263f, 0.352854252f, 0.f),
    C_Vertex3f(0.53503263f, 0.352854252f, -1.f),
    C_Normal3f(-0.845263362f, -0.534349978f, 0.f),
    C_Vertex3f(0.529514432f, 0.362727642f, 0.f),
    C_Vertex3f(0.529514432f, 0.362727642f, -1.f),
    C_Normal3f(-0.780876756f, -0.624685228f, 0.f),
    C_Vertex3f(0.523076534f, 0.371767044f, 0.f),
    C_Vertex3f(0.523076534f, 0.371767044f, -1.f),
    C_Normal3f(-0.713294387f, -0.700864553f, 0.f),
    C_Vertex3f(0.515718937f, 0.379972458f, 0.f),
    C_Vertex3f(0.515718937f, 0.379972458f, -1.f),
    C_Normal3f(-0.64207226f, -0.76664412f, 0.f),
    C_Vertex3f(0.507959485f, 0.387152195f, 0.f),
    C_Vertex3f(0.507959485f, 0.387152195f, -1.f),
    C_Normal3f(-0.559249043f, -0.828999698f, 0.f),
    C_Vertex3f(0.499798179f, 0.393306255f, 0.f),
    C_Vertex3f(0.499798179f, 0.393306255f, -1.f),
    C_Normal3f(-0.465973079f, -0.884798884f, 0.f),
    C_Vertex3f(0.491235018f, 0.398434639f, 0.f),
    C_Vertex3f(0.491235018f, 0.398434639f, -1.f),
    C_Normal3f(-0.364680827f, -0.931132555f, 0.f),
    C_Vertex3f(0.482270002f, 0.402537346f, 0.f),
    C_Vertex3f(0.482270002f, 0.402537346f, -1.f),
    C_Normal3f(-0.258866906f, -0.965912938f, 0.f),
    C_Vertex3f(0.472903132f, 0.405614376f, 0.f),
    C_Vertex3f(0.472903132f, 0.405614376f, -1.f),
    C_Normal3f(-0.152514488f, -0.988301218f, 0.f),
    C_Vertex3f(0.463134408f, 0.40766573f, 0.f),
    C_Vertex3f(0.463134408f, 0.40766573f, -1.f),
    C_Normal3f(-0.0456761569f, -0.998956263f, 0.f),
    C_Vertex3f(0.452963829f, 0.408691406f, 0.f),
    C_Vertex3f(0.452963829f, 0.408691406f, -1.f),
    C_Normal3f(0.0687286928f, -0.997635365f, 0.f),
    C_Vertex3f(0.440702438f, 0.408691406f, 0.f),
    C_Vertex3f(0.440702438f, 0.408691406f, -1.f),
    C_Normal3f(0.196035236f, -0.98059684f, 0.f),
    C_Vertex3f(0.427160263f, 0.406913757f, 0.f),
    C_Vertex3f(0.427160263f, 0.406913757f, -1.f),
    C_Normal3f(0.325044692f, -0.945698738f, 0.f),
    C_Vertex3f(0.41402626f, 0.403358459f, 0.f),
    C_Vertex3f(0.41402626f, 0.403358459f, -1.f),
    C_Normal3f(0.444975019f, -0.89554292f, 0.f),
    C_Vertex3f(0.40130043f, 0.398025513f, 0.f),
    C_Vertex3f(0.40130043f, 0.398025513f, -1.f),
    C_Normal3f(0.556717873f, -0.83070159f, 0.f),
    C_Vertex3f(0.388982773f, 0.390914917f, 0.f),
    C_Vertex3f(0.388982773f, 0.390914917f, -1.f),
    C_Normal3f(0.65222019f, -0.758029461f, 0.f),
    C_Vertex3f(0.37685585f, 0.381643295f, 0.f),
    C_Vertex3f(0.37685585f, 0.381643295f, -1.f),
    C_Normal3f(0.726351142f, -0.687323809f, 0.f),
    C_Vertex3f(0.364919662f, 0.370210648f, 0.f),
    C_Vertex3f(0.364919662f, 0.370210648f, -1.f),
    C_Normal3f(0.783187389f, -0.62178576f, 0.f),
    C_Vertex3f(0.35317421f, 0.356616974f, 0.f),
    C_Vertex3f(0.35317421f, 0.356616974f, -1.f),
    C_Normal3f(0.834036827f, -0.551708758f, 0.f),
    C_Vertex3f(0.341619492f, 0.340862274f, 0.f),
    C_Vertex3f(0.341619492f, 0.340862274f, -1.f),
    C_Normal3f(0.880773842f, -0.473537147f, 0.f),
    C_Vertex3f(0.33120966f, 0.323412418f, 0.f),
    C_Vertex3f(0.33120966f, 0.323412418f, -1.f),
    C_Normal3f(0.917068839f, -0.398728907f, 0.f),
    C_Vertex3f(0.321944714f, 0.304267406f, 0.f),
    C_Vertex3f(0.321944714f, 0.304267406f, -1.f),
    C_Normal3f(0.944442034f, -0.328678071f, 0.f),
    C_Vertex3f(0.313824654f, 0.283427238f, 0.f),
    C_Vertex3f(0.313824654f, 0.283427238f, -1.f),
    C_Normal3f(0.963826537f, -0.266530514f, 0.f),
    C_Vertex3f(0.30684948f, 0.260891914f, 0.f),
    C_Vertex3f(0.30684948f, 0.260891914f, -1.f),
    C_Normal3f(0.979394197f, -0.201958016f, 0.f),
    C_Vertex3f(0.301618099f, 0.239285946f, 0.f),
    C_Vertex3f(0.301618099f, 0.239285946f, -1.f),
    C_Normal3f(0.991729796f, -0.128342882f, 0.f),
    C_Vertex3f(0.298130512f, 0.218609333f, 0.f),
    C_Vertex3f(0.298130512f, 0.218609333f, -1.f),
    C_Normal3f(0.998869956f, -0.0475256294f, 0.f),
    C_Vertex3f(0.296386719f, 0.198862076f, 0.f),
    C_Vertex3f(0.296386719f, 0.198862076f, -1.f),
    C_End(),
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.876464844f, 0.00830078125f, 0.f),
    C_Vertex3f(0.797363281f, 0.00830078125f, 0.f),
    C_Vertex3f(0.806768417f, -0.0793194771f, 0.f),
    C_Vertex3f(0.819317579f, -0.0674580336f, 0.f),
    C_Vertex3f(0.830869913f, -0.0556513071f, 0.f),
    C_Vertex3f(0.841425419f, -0.0438992977f, 0.f),
    C_Vertex3f(0.850984097f, -0.0322020054f, 0.f),
    C_Vertex3f(0.859545946f, -0.0205594301f, 0.f),
    C_Vertex3f(0.867110968f, -0.00897157192f, 0.f),
    C_Vertex3f(0.873679161f, 0.00256156921f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.792554855f, 0.0013999939f, 0.f),
    C_Vertex3f(0.781722307f, -0.0118813515f, 0.f),
    C_Vertex3f(0.786449432f, -0.097193718f, 0.f),
    C_Vertex3f(0.806768417f, -0.0793194771f, 0.f),
    C_Vertex3f(0.797363281f, 0.00830078125f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.769674063f, -0.0246424675f, 0.f),
    C_Vertex3f(0.756410122f, -0.0368833542f, 0.f),
    C_Vertex3f(0.756789684f, -0.118538857f, 0.f),
    C_Vertex3f(0.786449432f, -0.097193718f, 0.f),
    C_Vertex3f(0.781722307f, -0.0118813515f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.756410122f, -0.0368833542f, 0.f),
    C_Vertex3f(0.741930485f, -0.0486040115f, 0.f),
    C_Vertex3f(0.756789684f, -0.118538857f, 0.f),
    C_Vertex3f(0.726235151f, -0.0598044395f, 0.f),
    C_Vertex3f(0.724562168f, -0.137396812f, 0.f),
    C_Vertex3f(0.709324121f, -0.0704846382f, 0.f),
    C_Vertex3f(0.691197395f, -0.0806446075f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.504214287f, -0.188476563f, 0.f),
    C_Vertex3f(0.529585719f, -0.187608838f, 0.f),
    C_Vertex3f(0.531422377f, -0.12281847f, 0.f),
    C_Vertex3f(0.554001451f, -0.185873389f, 0.f),
    C_Vertex3f(0.557729959f, -0.120408535f, 0.f),
    C_Vertex3f(0.577461481f, -0.183270216f, 0.f),
    C_Vertex3f(0.582876682f, -0.116793633f, 0.f),
    C_Vertex3f(0.599965811f, -0.179799318f, 0.f),
    C_Vertex3f(0.606862545f, -0.111973763f, 0.f),
    C_Vertex3f(0.62151444f, -0.175460696f, 0.f),
    C_Vertex3f(0.629687548f, -0.105948925f, 0.f),
    C_Vertex3f(0.642107368f, -0.17025435f, 0.f),
    C_Vertex3f(0.65135169f, -0.09871912f, 0.f),
    C_Vertex3f(0.661744595f, -0.164180279f, 0.f),
    C_Vertex3f(0.671854973f, -0.0902843475f, 0.f),
    C_Vertex3f(0.689766884f, -0.153767586f, 0.f),
    C_Vertex3f(0.691197395f, -0.0806446075f, 0.f),
    C_Vertex3f(0.724562168f, -0.137396812f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.531422377f, -0.12281847f, 0.f),
    C_Vertex3f(0.503953934f, -0.124023438f, 0.f),
    C_Vertex3f(0.504214287f, -0.188476563f, 0.f),
    C_Vertex3f(0.476252556f, -0.124023438f, 0.f),
    C_Vertex3f(0.466798782f, -0.188476563f, 0.f),
    C_Vertex3f(0.450073242f, -0.122869372f, 0.f),
    C_Vertex3f(0.424488068f, -0.120561242f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.466798782f, -0.188476563f, 0.f),
    C_Vertex3f(0.424488068f, -0.120561242f, 0.f),
    C_Vertex3f(0.42017889f, -0.185362816f, 0.f),
    C_Vertex3f(0.399497032f, -0.117099047f, 0.f),
    C_Vertex3f(0.375442982f, -0.179135323f, 0.f),
    C_Vertex3f(0.375100136f, -0.112482786f, 0.f),
    C_Vertex3f(0.351297379f, -0.106712461f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.332591057f, -0.169794083f, 0.f),
    C_Vertex3f(0.375442982f, -0.179135323f, 0.f),
    C_Vertex3f(0.351297379f, -0.106712461f, 0.f),
    C_Vertex3f(0.32808876f, -0.0997880697f, 0.f),
    C_Vertex3f(0.305474281f, -0.0917096138f, 0.f),
    C_Vertex3f(0.301865101f, -0.160452843f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.283453941f, -0.0824770927f, 0.f),
    C_Vertex3f(0.262731433f, -0.0719810724f, 0.f),
    C_Vertex3f(0.263171315f, -0.145642161f, 0.f),
    C_Vertex3f(0.282139182f, -0.153440118f, 0.f),
    C_Vertex3f(0.301865101f, -0.160452843f, 0.f),
    C_Vertex3f(0.305474281f, -0.0917096138f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.263171315f, -0.145642161f, 0.f),
    C_Vertex3f(0.262731433f, -0.0719810724f, 0.f),
    C_Vertex3f(0.2449615f, -0.137058973f, 0.f),
    C_Vertex3f(0.243306756f, -0.0602215528f, 0.f),
    C_Vertex3f(0.227509737f, -0.127690554f, 0.f),
    C_Vertex3f(0.225179911f, -0.047198534f, 0.f),
    C_Vertex3f(0.210816026f, -0.117536902f, 0.f),
    C_Vertex3f(0.208350897f, -0.0329120159f, 0.f),
    C_Vertex3f(0.194880366f, -0.10659802f, 0.f),
    C_Vertex3f(0.192819715f, -0.0173619986f, 0.f),
    C_Vertex3f(0.179702759f, -0.0948739052f, 0.f),
    C_Vertex3f(0.178586364f, -0.000548481941f, 0.f),
    C_Vertex3f(0.165650845f, 0.0175285339f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.179702759f, -0.0948739052f, 0.f),
    C_Vertex3f(0.165650845f, 0.0175285339f, 0.f),
    C_Vertex3f(0.165283203f, -0.0823645592f, 0.f),
    C_Vertex3f(0.154013157f, 0.0368690491f, 0.f),
    C_Vertex3f(0.151751041f, -0.0693839788f, 0.f),
    C_Vertex3f(0.14383018f, 0.0571382046f, 0.f),
    C_Vertex3f(0.139106274f, -0.0559321642f, 0.f),
    C_Vertex3f(0.135101914f, 0.0783360004f, 0.f),
    C_Vertex3f(0.12782836f, 0.100462437f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.1273489f, -0.0420091152f, 0.f),
    C_Vertex3f(0.139106274f, -0.0559321642f, 0.f),
    C_Vertex3f(0.12782836f, 0.100462437f, 0.f),
    C_Vertex3f(0.122009516f, 0.123517513f, 0.f),
    C_Vertex3f(0.117645383f, 0.14750123f, 0.f),
    C_Vertex3f(0.11647892f, -0.0276148319f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.117645383f, 0.14750123f, 0.f),
    C_Vertex3f(0.114735961f, 0.172413588f, 0.f),
    C_Vertex3f(0.11647892f, -0.0276148319f, 0.f),
    C_Vertex3f(0.11328125f, 0.198254585f, 0.f),
    C_Vertex3f(0.106496334f, -0.0127493143f, 0.f),
    C_Vertex3f(0.11328125f, 0.224422455f, 0.f),
    C_Vertex3f(0.113911152f, 0.45072782f, 0.f),
    C_Vertex3f(0.114736319f, 0.249585867f, 0.f),
    C_Vertex3f(0.130036831f, 0.476866841f, 0.f),
    C_Vertex3f(0.117646456f, 0.27434659f, 0.f),
    C_Vertex3f(0.122011662f, 0.298704624f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.547908425f, 0.305020809f, 0.f),
    C_Vertex3f(0.548828125f, 0.290977478f, 0.f),
    C_Vertex3f(0.553910732f, 0.421103001f, 0.f),
    C_Vertex3f(0.558348656f, 0.00149154663f, 0.f),
    C_Vertex3f(0.567554474f, 0.403373718f, 0.f),
    C_Vertex3f(0.570538521f, -0.000804901123f, 0.f),
    C_Vertex3f(0.573776245f, 0.393211365f, 0.f),
    C_Vertex3f(0.584177017f, -0.001953125f, 0.f),
    C_Vertex3f(0.588867188f, 0.4609375f, 0.f),
    C_Vertex3f(0.590820313f, 0.0967178345f, 0.f),
    C_Vertex3f(0.590820313f, 0.10049057f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.553910732f, 0.421103001f, 0.f),
    C_Vertex3f(0.539066792f, 0.436236858f, 0.f),
    C_Vertex3f(0.539631128f, 0.342146873f, 0.f),
    C_Vertex3f(0.543309927f, 0.330605507f, 0.f),
    C_Vertex3f(0.546069026f, 0.318230152f, 0.f),
    C_Vertex3f(0.547908425f, 0.305020809f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.539066792f, 0.436236858f, 0.f),
    C_Vertex3f(0.523022652f, 0.448775291f, 0.f),
    C_Vertex3f(0.523076534f, 0.371767044f, 0.f),
    C_Vertex3f(0.529514432f, 0.362727642f, 0.f),
    C_Vertex3f(0.53503263f, 0.352854252f, 0.f),
    C_Vertex3f(0.539631128f, 0.342146873f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.491235018f, 0.398434639f, 0.f),
    C_Vertex3f(0.499798179f, 0.393306255f, 0.f),
    C_Vertex3f(0.505778313f, 0.4587183f, 0.f),
    C_Vertex3f(0.507959485f, 0.387152195f, 0.f),
    C_Vertex3f(0.523022652f, 0.448775291f, 0.f),
    C_Vertex3f(0.515718937f, 0.379972458f, 0.f),
    C_Vertex3f(0.523076534f, 0.371767044f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.488096714f, 0.466175556f, 0.f),
    C_Vertex3f(0.469977856f, 0.47114706f, 0.f),
    C_Vertex3f(0.472903132f, 0.405614376f, 0.f),
    C_Vertex3f(0.482270002f, 0.402537346f, 0.f),
    C_Vertex3f(0.491235018f, 0.398434639f, 0.f),
    C_Vertex3f(0.505778313f, 0.4587183f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.321944714f, 0.304267406f, 0.f),
    C_Vertex3f(0.33120966f, 0.323412418f, 0.f),
    C_Vertex3f(0.33272171f, 0.434296608f, 0.f),
    C_Vertex3f(0.341619492f, 0.340862274f, 0.f),
    C_Vertex3f(0.345928192f, 0.443037987f, 0.f),
    C_Vertex3f(0.35317421f, 0.356616974f, 0.f),
    C_Vertex3f(0.359039307f, 0.450686693f, 0.f),
    C_Vertex3f(0.364919662f, 0.370210648f, 0.f),
    C_Vertex3f(0.372055054f, 0.457242727f, 0.f),
    C_Vertex3f(0.37685585f, 0.381643295f, 0.f),
    C_Vertex3f(0.384975433f, 0.462706089f, 0.f),
    C_Vertex3f(0.388982773f, 0.390914917f, 0.f),
    C_Vertex3f(0.397800446f, 0.467076778f, 0.f),
    C_Vertex3f(0.40130043f, 0.398025513f, 0.f),
    C_Vertex3f(0.41053009f, 0.470354795f, 0.f),
    C_Vertex3f(0.41402626f, 0.403358459f, 0.f),
    C_Vertex3f(0.423164368f, 0.47254014f, 0.f),
    C_Vertex3f(0.427160263f, 0.406913757f, 0.f),
    C_Vertex3f(0.435703278f, 0.473632813f, 0.f),
    C_Vertex3f(0.440702438f, 0.408691406f, 0.f),
    C_Vertex3f(0.451421738f, 0.473632813f, 0.f),
    C_Vertex3f(0.452963829f, 0.408691406f, 0.f),
    C_Vertex3f(0.469977856f, 0.47114706f, 0.f),
    C_Vertex3f(0.463134408f, 0.40766573f, 0.f),
    C_Vertex3f(0.472903132f, 0.405614376f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.301618099f, 0.239285946f, 0.f),
    C_Vertex3f(0.30684948f, 0.260891914f, 0.f),
    C_Vertex3f(0.307925224f, 0.413556218f, 0.f),
    C_Vertex3f(0.313824654f, 0.283427238f, 0.f),
    C_Vertex3f(0.320054054f, 0.424469352f, 0.f),
    C_Vertex3f(0.321944714f, 0.304267406f, 0.f),
    C_Vertex3f(0.33272171f, 0.434296608f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.301700354f, 0.142000675f, 0.f),
    C_Vertex3f(0.299043536f, 0.154485941f, 0.f),
    C_Vertex3f(0.306990623f, 0.015581131f, 0.f),
    C_Vertex3f(0.297272325f, 0.167805433f, 0.f),
    C_Vertex3f(0.288659096f, 0.0269451141f, 0.f),
    C_Vertex3f(0.296386719f, 0.181959152f, 0.f),
    C_Vertex3f(0.29633522f, 0.401557207f, 0.f),
    C_Vertex3f(0.296386719f, 0.198862076f, 0.f),
    C_Vertex3f(0.307925224f, 0.413556218f, 0.f),
    C_Vertex3f(0.298130512f, 0.218609333f, 0.f),
    C_Vertex3f(0.301618099f, 0.239285946f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.841736317f, 0.407146931f, 0.f),
    C_Vertex3f(0.835114241f, 0.427280188f, 0.f),
    C_Vertex3f(0.838253498f, 0.20584631f, 0.f),
    C_Vertex3f(0.827167749f, 0.447003603f, 0.f),
    C_Vertex3f(0.827102184f, 0.177710056f, 0.f),
    C_Vertex3f(0.817896843f, 0.466317177f, 0.f),
    C_Vertex3f(0.813163042f, 0.150461435f, 0.f),
    C_Vertex3f(0.806372643f, 0.486750603f, 0.f),
    C_Vertex3f(0.796436071f, 0.124100447f, 0.f),
    C_Vertex3f(0.792779446f, 0.507354617f, 0.f),
    C_Vertex3f(0.790527344f, 0.321663857f, 0.f),
    C_Vertex3f(0.789359212f, 0.33961463f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.792779446f, 0.507354617f, 0.f),
    C_Vertex3f(0.778046131f, 0.526599526f, 0.f),
    C_Vertex3f(0.778846025f, 0.391663074f, 0.f),
    C_Vertex3f(0.783518553f, 0.374614239f, 0.f),
    C_Vertex3f(0.787022948f, 0.357264757f, 0.f),
    C_Vertex3f(0.789359212f, 0.33961463f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.748474598f, 0.456851959f, 0.f),
    C_Vertex3f(0.757819653f, 0.441005707f, 0.f),
    C_Vertex3f(0.762172699f, 0.544485331f, 0.f),
    C_Vertex3f(0.765996575f, 0.424858809f, 0.f),
    C_Vertex3f(0.778046131f, 0.526599526f, 0.f),
    C_Vertex3f(0.773005366f, 0.408411264f, 0.f),
    C_Vertex3f(0.778846025f, 0.391663074f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.713552952f, 0.499637127f, 0.f),
    C_Vertex3f(0.726341248f, 0.486167669f, 0.f),
    C_Vertex3f(0.727005482f, 0.576179624f, 0.f),
    C_Vertex3f(0.737981796f, 0.471905947f, 0.f),
    C_Vertex3f(0.745159149f, 0.56101203f, 0.f),
    C_Vertex3f(0.748474598f, 0.456851959f, 0.f),
    C_Vertex3f(0.762172699f, 0.544485331f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.668301582f, 0.53529191f, 0.f),
    C_Vertex3f(0.684533119f, 0.524199247f, 0.f),
    C_Vertex3f(0.687277794f, 0.602437496f, 0.f),
    C_Vertex3f(0.699616909f, 0.51231432f, 0.f),
    C_Vertex3f(0.707711697f, 0.589988112f, 0.f),
    C_Vertex3f(0.713552952f, 0.499637127f, 0.f),
    C_Vertex3f(0.727005482f, 0.576179624f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.573903799f, 0.57649374f, 0.f),
    C_Vertex3f(0.593886018f, 0.570551157f, 0.f),
    C_Vertex3f(0.596844673f, 0.638480902f, 0.f),
    C_Vertex3f(0.613383174f, 0.563420057f, 0.f),
    C_Vertex3f(0.620487213f, 0.631549478f, 0.f),
    C_Vertex3f(0.632395267f, 0.555100441f, 0.f),
    C_Vertex3f(0.643440247f, 0.623231769f, 0.f),
    C_Vertex3f(0.650922298f, 0.545592308f, 0.f),
    C_Vertex3f(0.665703773f, 0.613527775f, 0.f),
    C_Vertex3f(0.668301582f, 0.53529191f, 0.f),
    C_Vertex3f(0.687277794f, 0.602437496f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.46513176f, 0.588378906f, 0.f),
    C_Vertex3f(0.489124298f, 0.588378906f, 0.f),
    C_Vertex3f(0.495379448f, 0.65234375f, 0.f),
    C_Vertex3f(0.511046767f, 0.58719039f, 0.f),
    C_Vertex3f(0.521780014f, 0.650957465f, 0.f),
    C_Vertex3f(0.532484174f, 0.584813356f, 0.f),
    C_Vertex3f(0.547491074f, 0.648184896f, 0.f),
    C_Vertex3f(0.553436518f, 0.581247807f, 0.f),
    C_Vertex3f(0.572512627f, 0.644026041f, 0.f),
    C_Vertex3f(0.573903799f, 0.57649374f, 0.f),
    C_Vertex3f(0.596844673f, 0.638480902f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.368355274f, 0.573422909f, 0.f),
    C_Vertex3f(0.391719341f, 0.579405308f, 0.f),
    C_Vertex3f(0.398356915f, 0.646443963f, 0.f),
    C_Vertex3f(0.415636778f, 0.583892107f, 0.f),
    C_Vertex3f(0.430704594f, 0.650377154f, 0.f),
    C_Vertex3f(0.440107584f, 0.586883307f, 0.f),
    C_Vertex3f(0.464356422f, 0.65234375f, 0.f),
    C_Vertex3f(0.46513176f, 0.588378906f, 0.f),
    C_Vertex3f(0.495379448f, 0.65234375f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.260470867f, 0.521275043f, 0.f),
    C_Vertex3f(0.280432701f, 0.534537315f, 0.f),
    C_Vertex3f(0.282007694f, 0.611045241f, 0.f),
    C_Vertex3f(0.30158329f, 0.546502113f, 0.f),
    C_Vertex3f(0.309138775f, 0.622844815f, 0.f),
    C_Vertex3f(0.323287249f, 0.556971312f, 0.f),
    C_Vertex3f(0.337574005f, 0.632677794f, 0.f),
    C_Vertex3f(0.345544577f, 0.56594491f, 0.f),
    C_Vertex3f(0.367313385f, 0.640544176f, 0.f),
    C_Vertex3f(0.368355274f, 0.573422909f, 0.f),
    C_Vertex3f(0.398356915f, 0.646443963f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.192511082f, 0.455251217f, 0.f),
    C_Vertex3f(0.207717896f, 0.473703384f, 0.f),
    C_Vertex3f(0.208534718f, 0.564079165f, 0.f),
    C_Vertex3f(0.224113464f, 0.490858078f, 0.f),
    C_Vertex3f(0.231657982f, 0.581546307f, 0.f),
    C_Vertex3f(0.241697788f, 0.506715298f, 0.f),
    C_Vertex3f(0.256180763f, 0.597279072f, 0.f),
    C_Vertex3f(0.260470867f, 0.521275043f, 0.f),
    C_Vertex3f(0.282007694f, 0.611045241f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.15402317f, 0.392109871f, 0.f),
    C_Vertex3f(0.165663719f, 0.41445446f, 0.f),
    C_Vertex3f(0.16648674f, 0.523941755f, 0.f),
    C_Vertex3f(0.178493023f, 0.435501575f, 0.f),
    C_Vertex3f(0.18681097f, 0.544877648f, 0.f),
    C_Vertex3f(0.192511082f, 0.455251217f, 0.f),
    C_Vertex3f(0.208534718f, 0.564079165f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.147562027f, 0.501271486f, 0.f),
    C_Vertex3f(0.130036831f, 0.476866841f, 0.f),
    C_Vertex3f(0.135107279f, 0.346212626f, 0.f),
    C_Vertex3f(0.14383769f, 0.369362593f, 0.f),
    C_Vertex3f(0.15402317f, 0.392109871f, 0.f),
    C_Vertex3f(0.16648674f, 0.523941755f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.130036831f, 0.476866841f, 0.f),
    C_Vertex3f(0.122011662f, 0.298704624f, 0.f),
    C_Vertex3f(0.127831936f, 0.322659969f, 0.f),
    C_Vertex3f(0.135107279f, 0.346212626f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.0991849899f, 0.422854424f, 0.f),
    C_Vertex3f(0.0870599747f, 0.395977974f, 0.f),
    C_Vertex3f(0.0891933441f, 0.0183954239f, 0.f),
    C_Vertex3f(0.0974011421f, 0.00258743763f, 0.f),
    C_Vertex3f(0.106496334f, -0.0127493143f, 0.f),
    C_Vertex3f(0.113911152f, 0.45072782f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.0891933441f, 0.0183954239f, 0.f),
    C_Vertex3f(0.0870599747f, 0.395977974f, 0.f),
    C_Vertex3f(0.080945015f, 0.0368595123f, 0.f),
    C_Vertex3f(0.0775020123f, 0.37151885f, 0.f),
    C_Vertex3f(0.0729157925f, 0.0579183102f, 0.f),
    C_Vertex3f(0.069309473f, 0.346745729f, 0.f),
    C_Vertex3f(0.0660336018f, 0.0793869495f, 0.f),
    C_Vertex3f(0.062482357f, 0.321658611f, 0.f),
    C_Vertex3f(0.0602984428f, 0.10126543f, 0.f),
    C_Vertex3f(0.0570206642f, 0.296257496f, 0.f),
    C_Vertex3f(0.0557103157f, 0.123553753f, 0.f),
    C_Vertex3f(0.0529243946f, 0.270542383f, 0.f),
    C_Vertex3f(0.0522692204f, 0.146251917f, 0.f),
    C_Vertex3f(0.0501935482f, 0.244513273f, 0.f),
    C_Vertex3f(0.0499751568f, 0.169359922f, 0.f),
    C_Vertex3f(0.048828125f, 0.218170166f, 0.f),
    C_Vertex3f(0.048828125f, 0.192877769f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.853656054f, 0.344288111f, 0.f),
    C_Vertex3f(0.851007223f, 0.365650892f, 0.f),
    C_Vertex3f(0.85219264f, 0.264781713f, 0.f),
    C_Vertex3f(0.854980469f, 0.295580864f, 0.f),
    C_Vertex3f(0.854980469f, 0.322515488f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.847033978f, 0.386603832f, 0.f),
    C_Vertex3f(0.841736317f, 0.407146931f, 0.f),
    C_Vertex3f(0.846616983f, 0.234870195f, 0.f),
    C_Vertex3f(0.85219264f, 0.264781713f, 0.f),
    C_Vertex3f(0.851007223f, 0.365650892f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.796436071f, 0.124100447f, 0.f),
    C_Vertex3f(0.790527344f, 0.321663857f, 0.f),
    C_Vertex3f(0.790527344f, 0.29691124f, 0.f),
    C_Vertex3f(0.786886692f, 0.266121387f, 0.f),
    C_Vertex3f(0.779605389f, 0.235795498f, 0.f),
    C_Vertex3f(0.776921272f, 0.0986270905f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.779605389f, 0.235795498f, 0.f),
    C_Vertex3f(0.768683434f, 0.205933571f, 0.f),
    C_Vertex3f(0.776921272f, 0.0986270905f, 0.f),
    C_Vertex3f(0.757761478f, 0.183885098f, 0.f),
    C_Vertex3f(0.755821228f, 0.0752983093f, 0.f),
    C_Vertex3f(0.749830127f, 0.169930577f, 0.f),
    C_Vertex3f(0.741248727f, 0.156720519f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.735459089f, 0.0559854507f, 0.f),
    C_Vertex3f(0.755821228f, 0.0752983093f, 0.f),
    C_Vertex3f(0.741248727f, 0.156720519f, 0.f),
    C_Vertex3f(0.732017279f, 0.144254923f, 0.f),
    C_Vertex3f(0.722135782f, 0.132533789f, 0.f),
    C_Vertex3f(0.714632273f, 0.039431572f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.722135782f, 0.132533789f, 0.f),
    C_Vertex3f(0.711604238f, 0.121557117f, 0.f),
    C_Vertex3f(0.714632273f, 0.039431572f, 0.f),
    C_Vertex3f(0.700422645f, 0.111324906f, 0.f),
    C_Vertex3f(0.693340778f, 0.025636673f, 0.f),
    C_Vertex3f(0.688591003f, 0.101837158f, 0.f),
    C_Vertex3f(0.672935486f, 0.0907993317f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.693340778f, 0.025636673f, 0.f),
    C_Vertex3f(0.672935486f, 0.0907993317f, 0.f),
    C_Vertex3f(0.671584606f, 0.0146007538f, 0.f),
    C_Vertex3f(0.655911446f, 0.0808000565f, 0.f),
    C_Vertex3f(0.649363756f, 0.00632381439f, 0.f),
    C_Vertex3f(0.640692711f, 0.074133873f, 0.f),
    C_Vertex3f(0.627279282f, 0.0708007813f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.626678228f, 0.000805854797f, 0.f),
    C_Vertex3f(0.649363756f, 0.00632381439f, 0.f),
    C_Vertex3f(0.627279282f, 0.0708007813f, 0.f),
    C_Vertex3f(0.618301392f, 0.0708007813f, 0.f),
    C_Vertex3f(0.612418175f, 0.0718669891f, 0.f),
    C_Vertex3f(0.606999397f, 0.0739994049f, 0.f),
    C_Vertex3f(0.603528023f, -0.001953125f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.603528023f, -0.001953125f, 0.f),
    C_Vertex3f(0.606999397f, 0.0739994049f, 0.f),
    C_Vertex3f(0.602045059f, 0.0771980286f, 0.f),
    C_Vertex3f(0.597555161f, 0.0814628601f, 0.f),
    C_Vertex3f(0.594187737f, 0.0861377716f, 0.f),
    C_Vertex3f(0.591942787f, 0.0912227631f, 0.f),
    C_Vertex3f(0.590820313f, 0.0967178345f, 0.f),
    C_Vertex3f(0.584177017f, -0.001953125f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.548828125f, 0.272378922f, 0.f),
    C_Vertex3f(0.54686594f, 0.250087261f, 0.f),
    C_Vertex3f(0.547607422f, 0.00493621826f, 0.f),
    C_Vertex3f(0.558348656f, 0.00149154663f, 0.f),
    C_Vertex3f(0.548828125f, 0.290977478f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.514211655f, 0.0362110138f, 0.f),
    C_Vertex3f(0.517818451f, 0.0292129517f, 0.f),
    C_Vertex3f(0.520240784f, 0.163115501f, 0.f),
    C_Vertex3f(0.523420334f, 0.0216674805f, 0.f),
    C_Vertex3f(0.529206276f, 0.183381081f, 0.f),
    C_Vertex3f(0.530252457f, 0.0151062012f, 0.f),
    C_Vertex3f(0.537055016f, 0.205588341f, 0.f),
    C_Vertex3f(0.538314819f, 0.00952911377f, 0.f),
    C_Vertex3f(0.54294157f, 0.227823734f, 0.f),
    C_Vertex3f(0.547607422f, 0.00493621826f, 0.f),
    C_Vertex3f(0.54686594f, 0.250087261f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.507980347f, 0.0644207001f, 0.f),
    C_Vertex3f(0.509675026f, 0.0530490875f, 0.f),
    C_Vertex3f(0.510158539f, 0.144791603f, 0.f),
    C_Vertex3f(0.511752129f, 0.0436458588f, 0.f),
    C_Vertex3f(0.520240784f, 0.163115501f, 0.f),
    C_Vertex3f(0.514211655f, 0.0362110138f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.510158539f, 0.144791603f, 0.f),
    C_Vertex3f(0.498959541f, 0.128409386f, 0.f),
    C_Vertex3f(0.500230789f, 0.0628948212f, 0.f),
    C_Vertex3f(0.507324219f, 0.0710906982f, 0.f),
    C_Vertex3f(0.507980347f, 0.0644207001f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.434381485f, 0.0739831924f, 0.f),
    C_Vertex3f(0.435033798f, 0.0134496689f, 0.f),
    C_Vertex3f(0.447896957f, 0.0813131332f, 0.f),
    C_Vertex3f(0.452600479f, 0.0233926773f, 0.f),
    C_Vertex3f(0.461112499f, 0.090420723f, 0.f),
    C_Vertex3f(0.469322205f, 0.0349478722f, 0.f),
    C_Vertex3f(0.474028111f, 0.101305962f, 0.f),
    C_Vertex3f(0.485198975f, 0.0481152534f, 0.f),
    C_Vertex3f(0.486643791f, 0.113968849f, 0.f),
    C_Vertex3f(0.500230789f, 0.0628948212f, 0.f),
    C_Vertex3f(0.498959541f, 0.128409386f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.395792007f, 0.0629882813f, 0.f),
    C_Vertex3f(0.399817467f, 0.00102090836f, 0.f),
    C_Vertex3f(0.40832901f, 0.0648207664f, 0.f),
    C_Vertex3f(0.417439461f, 0.00599241257f, 0.f),
    C_Vertex3f(0.421192169f, 0.0684857368f, 0.f),
    C_Vertex3f(0.435033798f, 0.0134496689f, 0.f),
    C_Vertex3f(0.434381485f, 0.0739831924f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.385108948f, 0.0629882813f, 0.f),
    C_Vertex3f(0.376212478f, 0.0640275478f, 0.f),
    C_Vertex3f(0.382167816f, -0.00146484375f, 0.f),
    C_Vertex3f(0.399817467f, 0.00102090836f, 0.f),
    C_Vertex3f(0.395792007f, 0.0629882813f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.367574811f, 0.066106081f, 0.f),
    C_Vertex3f(0.359195948f, 0.0692238808f, 0.f),
    C_Vertex3f(0.363618851f, -0.00146484375f, 0.f),
    C_Vertex3f(0.382167816f, -0.00146484375f, 0.f),
    C_Vertex3f(0.376212478f, 0.0640275478f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.351075888f, 0.0733809471f, 0.f),
    C_Vertex3f(0.343214631f, 0.07857728f, 0.f),
    C_Vertex3f(0.344470501f, 0.00137615204f, 0.f),
    C_Vertex3f(0.363618851f, -0.00146484375f, 0.f),
    C_Vertex3f(0.359195948f, 0.0692238808f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.343214631f, 0.07857728f, 0.f),
    C_Vertex3f(0.335612178f, 0.0848128796f, 0.f),
    C_Vertex3f(0.344470501f, 0.00137615204f, 0.f),
    C_Vertex3f(0.328268528f, 0.0920877457f, 0.f),
    C_Vertex3f(0.325594425f, 0.00705814362f, 0.f),
    C_Vertex3f(0.321183681f, 0.100401878f, 0.f),
    C_Vertex3f(0.314984441f, 0.109550238f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.309670806f, 0.119532824f, 0.f),
    C_Vertex3f(0.305242777f, 0.130349636f, 0.f),
    C_Vertex3f(0.306990623f, 0.015581131f, 0.f),
    C_Vertex3f(0.325594425f, 0.00705814362f, 0.f),
    C_Vertex3f(0.314984441f, 0.109550238f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.29633522f, 0.401557207f, 0.f),
    C_Vertex3f(0.285284042f, 0.388472319f, 0.f),
    C_Vertex3f(0.288659096f, 0.0269451141f, 0.f),
    C_Vertex3f(0.27477169f, 0.374301553f, 0.f),
    C_Vertex3f(0.272046089f, 0.0413684845f, 0.f),
    C_Vertex3f(0.264798164f, 0.359044909f, 0.f),
    C_Vertex3f(0.257151604f, 0.0588512421f, 0.f),
    C_Vertex3f(0.255363464f, 0.342702389f, 0.f),
    C_Vertex3f(0.24646759f, 0.325273991f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.257151604f, 0.0588512421f, 0.f),
    C_Vertex3f(0.24646759f, 0.325273991f, 0.f),
    C_Vertex3f(0.243975639f, 0.0793933868f, 0.f),
    C_Vertex3f(0.238683701f, 0.307852387f, 0.f),
    C_Vertex3f(0.232518196f, 0.102994919f, 0.f),
    C_Vertex3f(0.232011795f, 0.290437579f, 0.f),
    C_Vertex3f(0.226451874f, 0.273029566f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.223925114f, 0.127743721f, 0.f),
    C_Vertex3f(0.232518196f, 0.102994919f, 0.f),
    C_Vertex3f(0.226451874f, 0.273029566f, 0.f),
    C_Vertex3f(0.222003937f, 0.255628347f, 0.f),
    C_Vertex3f(0.218667984f, 0.238233924f, 0.f),
    C_Vertex3f(0.218196392f, 0.153639793f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.218196392f, 0.153639793f, 0.f),
    C_Vertex3f(0.218667984f, 0.238233924f, 0.f),
    C_Vertex3f(0.216444016f, 0.220846295f, 0.f),
    C_Vertex3f(0.215332031f, 0.203465462f, 0.f),
    C_Vertex3f(0.215332031f, 0.180683136f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.588867188f, 0.4609375f, 0.f),
    C_Vertex3f(0.590820313f, 0.10049057f, 0.f),
    C_Vertex3f(0.591230631f, 0.103839159f, 0.f),
    C_Vertex3f(0.592051268f, 0.108896017f, 0.f),
    C_Vertex3f(0.593282223f, 0.115661144f, 0.f),
    C_Vertex3f(0.594923496f, 0.124134541f, 0.f),
    C_Vertex3f(0.596975088f, 0.134316206f, 0.f),
    C_Vertex3f(0.599436998f, 0.146206141f, 0.f),
    C_Vertex3f(0.602309227f, 0.159804344f, 0.f),
    C_Vertex3f(0.666992188f, 0.4609375f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.301700354f, 0.142000675f, 0.f),
    C_Vertex3f(0.306990623f, 0.015581131f, 0.f),
    C_Vertex3f(0.305242777f, 0.130349636f, 0.f),
    C_Vertex3f(0.841736317f, 0.407146931f, 0.f),
    C_Vertex3f(0.838253498f, 0.20584631f, 0.f),
    C_Vertex3f(0.846616983f, 0.234870195f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, -1.f),
    C_FrontFace(GL_CW),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.876464844f, 0.00830078125f, -1.f),
    C_Vertex3f(0.797363281f, 0.00830078125f, -1.f),
    C_Vertex3f(0.806768417f, -0.0793194771f, -1.f),
    C_Vertex3f(0.819317579f, -0.0674580336f, -1.f),
    C_Vertex3f(0.830869913f, -0.0556513071f, -1.f),
    C_Vertex3f(0.841425419f, -0.0438992977f, -1.f),
    C_Vertex3f(0.850984097f, -0.0322020054f, -1.f),
    C_Vertex3f(0.859545946f, -0.0205594301f, -1.f),
    C_Vertex3f(0.867110968f, -0.00897157192f, -1.f),
    C_Vertex3f(0.873679161f, 0.00256156921f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.792554855f, 0.0013999939f, -1.f),
    C_Vertex3f(0.781722307f, -0.0118813515f, -1.f),
    C_Vertex3f(0.786449432f, -0.097193718f, -1.f),
    C_Vertex3f(0.806768417f, -0.0793194771f, -1.f),
    C_Vertex3f(0.797363281f, 0.00830078125f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.769674063f, -0.0246424675f, -1.f),
    C_Vertex3f(0.756410122f, -0.0368833542f, -1.f),
    C_Vertex3f(0.756789684f, -0.118538857f, -1.f),
    C_Vertex3f(0.786449432f, -0.097193718f, -1.f),
    C_Vertex3f(0.781722307f, -0.0118813515f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.756410122f, -0.0368833542f, -1.f),
    C_Vertex3f(0.741930485f, -0.0486040115f, -1.f),
    C_Vertex3f(0.756789684f, -0.118538857f, -1.f),
    C_Vertex3f(0.726235151f, -0.0598044395f, -1.f),
    C_Vertex3f(0.724562168f, -0.137396812f, -1.f),
    C_Vertex3f(0.709324121f, -0.0704846382f, -1.f),
    C_Vertex3f(0.691197395f, -0.0806446075f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.504214287f, -0.188476563f, -1.f),
    C_Vertex3f(0.529585719f, -0.187608838f, -1.f),
    C_Vertex3f(0.531422377f, -0.12281847f, -1.f),
    C_Vertex3f(0.554001451f, -0.185873389f, -1.f),
    C_Vertex3f(0.557729959f, -0.120408535f, -1.f),
    C_Vertex3f(0.577461481f, -0.183270216f, -1.f),
    C_Vertex3f(0.582876682f, -0.116793633f, -1.f),
    C_Vertex3f(0.599965811f, -0.179799318f, -1.f),
    C_Vertex3f(0.606862545f, -0.111973763f, -1.f),
    C_Vertex3f(0.62151444f, -0.175460696f, -1.f),
    C_Vertex3f(0.629687548f, -0.105948925f, -1.f),
    C_Vertex3f(0.642107368f, -0.17025435f, -1.f),
    C_Vertex3f(0.65135169f, -0.09871912f, -1.f),
    C_Vertex3f(0.661744595f, -0.164180279f, -1.f),
    C_Vertex3f(0.671854973f, -0.0902843475f, -1.f),
    C_Vertex3f(0.689766884f, -0.153767586f, -1.f),
    C_Vertex3f(0.691197395f, -0.0806446075f, -1.f),
    C_Vertex3f(0.724562168f, -0.137396812f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.531422377f, -0.12281847f, -1.f),
    C_Vertex3f(0.503953934f, -0.124023438f, -1.f),
    C_Vertex3f(0.504214287f, -0.188476563f, -1.f),
    C_Vertex3f(0.476252556f, -0.124023438f, -1.f),
    C_Vertex3f(0.466798782f, -0.188476563f, -1.f),
    C_Vertex3f(0.450073242f, -0.122869372f, -1.f),
    C_Vertex3f(0.424488068f, -0.120561242f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.466798782f, -0.188476563f, -1.f),
    C_Vertex3f(0.424488068f, -0.120561242f, -1.f),
    C_Vertex3f(0.42017889f, -0.185362816f, -1.f),
    C_Vertex3f(0.399497032f, -0.117099047f, -1.f),
    C_Vertex3f(0.375442982f, -0.179135323f, -1.f),
    C_Vertex3f(0.375100136f, -0.112482786f, -1.f),
    C_Vertex3f(0.351297379f, -0.106712461f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.332591057f, -0.169794083f, -1.f),
    C_Vertex3f(0.375442982f, -0.179135323f, -1.f),
    C_Vertex3f(0.351297379f, -0.106712461f, -1.f),
    C_Vertex3f(0.32808876f, -0.0997880697f, -1.f),
    C_Vertex3f(0.305474281f, -0.0917096138f, -1.f),
    C_Vertex3f(0.301865101f, -0.160452843f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.283453941f, -0.0824770927f, -1.f),
    C_Vertex3f(0.262731433f, -0.0719810724f, -1.f),
    C_Vertex3f(0.263171315f, -0.145642161f, -1.f),
    C_Vertex3f(0.282139182f, -0.153440118f, -1.f),
    C_Vertex3f(0.301865101f, -0.160452843f, -1.f),
    C_Vertex3f(0.305474281f, -0.0917096138f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.263171315f, -0.145642161f, -1.f),
    C_Vertex3f(0.262731433f, -0.0719810724f, -1.f),
    C_Vertex3f(0.2449615f, -0.137058973f, -1.f),
    C_Vertex3f(0.243306756f, -0.0602215528f, -1.f),
    C_Vertex3f(0.227509737f, -0.127690554f, -1.f),
    C_Vertex3f(0.225179911f, -0.047198534f, -1.f),
    C_Vertex3f(0.210816026f, -0.117536902f, -1.f),
    C_Vertex3f(0.208350897f, -0.0329120159f, -1.f),
    C_Vertex3f(0.194880366f, -0.10659802f, -1.f),
    C_Vertex3f(0.192819715f, -0.0173619986f, -1.f),
    C_Vertex3f(0.179702759f, -0.0948739052f, -1.f),
    C_Vertex3f(0.178586364f, -0.000548481941f, -1.f),
    C_Vertex3f(0.165650845f, 0.0175285339f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.179702759f, -0.0948739052f, -1.f),
    C_Vertex3f(0.165650845f, 0.0175285339f, -1.f),
    C_Vertex3f(0.165283203f, -0.0823645592f, -1.f),
    C_Vertex3f(0.154013157f, 0.0368690491f, -1.f),
    C_Vertex3f(0.151751041f, -0.0693839788f, -1.f),
    C_Vertex3f(0.14383018f, 0.0571382046f, -1.f),
    C_Vertex3f(0.139106274f, -0.0559321642f, -1.f),
    C_Vertex3f(0.135101914f, 0.0783360004f, -1.f),
    C_Vertex3f(0.12782836f, 0.100462437f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.1273489f, -0.0420091152f, -1.f),
    C_Vertex3f(0.139106274f, -0.0559321642f, -1.f),
    C_Vertex3f(0.12782836f, 0.100462437f, -1.f),
    C_Vertex3f(0.122009516f, 0.123517513f, -1.f),
    C_Vertex3f(0.117645383f, 0.14750123f, -1.f),
    C_Vertex3f(0.11647892f, -0.0276148319f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.117645383f, 0.14750123f, -1.f),
    C_Vertex3f(0.114735961f, 0.172413588f, -1.f),
    C_Vertex3f(0.11647892f, -0.0276148319f, -1.f),
    C_Vertex3f(0.11328125f, 0.198254585f, -1.f),
    C_Vertex3f(0.106496334f, -0.0127493143f, -1.f),
    C_Vertex3f(0.11328125f, 0.224422455f, -1.f),
    C_Vertex3f(0.113911152f, 0.45072782f, -1.f),
    C_Vertex3f(0.114736319f, 0.249585867f, -1.f),
    C_Vertex3f(0.130036831f, 0.476866841f, -1.f),
    C_Vertex3f(0.117646456f, 0.27434659f, -1.f),
    C_Vertex3f(0.122011662f, 0.298704624f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.547908425f, 0.305020809f, -1.f),
    C_Vertex3f(0.548828125f, 0.290977478f, -1.f),
    C_Vertex3f(0.553910732f, 0.421103001f, -1.f),
    C_Vertex3f(0.558348656f, 0.00149154663f, -1.f),
    C_Vertex3f(0.567554474f, 0.403373718f, -1.f),
    C_Vertex3f(0.570538521f, -0.000804901123f, -1.f),
    C_Vertex3f(0.573776245f, 0.393211365f, -1.f),
    C_Vertex3f(0.584177017f, -0.001953125f, -1.f),
    C_Vertex3f(0.588867188f, 0.4609375f, -1.f),
    C_Vertex3f(0.590820313f, 0.0967178345f, -1.f),
    C_Vertex3f(0.590820313f, 0.10049057f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.553910732f, 0.421103001f, -1.f),
    C_Vertex3f(0.539066792f, 0.436236858f, -1.f),
    C_Vertex3f(0.539631128f, 0.342146873f, -1.f),
    C_Vertex3f(0.543309927f, 0.330605507f, -1.f),
    C_Vertex3f(0.546069026f, 0.318230152f, -1.f),
    C_Vertex3f(0.547908425f, 0.305020809f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.539066792f, 0.436236858f, -1.f),
    C_Vertex3f(0.523022652f, 0.448775291f, -1.f),
    C_Vertex3f(0.523076534f, 0.371767044f, -1.f),
    C_Vertex3f(0.529514432f, 0.362727642f, -1.f),
    C_Vertex3f(0.53503263f, 0.352854252f, -1.f),
    C_Vertex3f(0.539631128f, 0.342146873f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.491235018f, 0.398434639f, -1.f),
    C_Vertex3f(0.499798179f, 0.393306255f, -1.f),
    C_Vertex3f(0.505778313f, 0.4587183f, -1.f),
    C_Vertex3f(0.507959485f, 0.387152195f, -1.f),
    C_Vertex3f(0.523022652f, 0.448775291f, -1.f),
    C_Vertex3f(0.515718937f, 0.379972458f, -1.f),
    C_Vertex3f(0.523076534f, 0.371767044f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.488096714f, 0.466175556f, -1.f),
    C_Vertex3f(0.469977856f, 0.47114706f, -1.f),
    C_Vertex3f(0.472903132f, 0.405614376f, -1.f),
    C_Vertex3f(0.482270002f, 0.402537346f, -1.f),
    C_Vertex3f(0.491235018f, 0.398434639f, -1.f),
    C_Vertex3f(0.505778313f, 0.4587183f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.321944714f, 0.304267406f, -1.f),
    C_Vertex3f(0.33120966f, 0.323412418f, -1.f),
    C_Vertex3f(0.33272171f, 0.434296608f, -1.f),
    C_Vertex3f(0.341619492f, 0.340862274f, -1.f),
    C_Vertex3f(0.345928192f, 0.443037987f, -1.f),
    C_Vertex3f(0.35317421f, 0.356616974f, -1.f),
    C_Vertex3f(0.359039307f, 0.450686693f, -1.f),
    C_Vertex3f(0.364919662f, 0.370210648f, -1.f),
    C_Vertex3f(0.372055054f, 0.457242727f, -1.f),
    C_Vertex3f(0.37685585f, 0.381643295f, -1.f),
    C_Vertex3f(0.384975433f, 0.462706089f, -1.f),
    C_Vertex3f(0.388982773f, 0.390914917f, -1.f),
    C_Vertex3f(0.397800446f, 0.467076778f, -1.f),
    C_Vertex3f(0.40130043f, 0.398025513f, -1.f),
    C_Vertex3f(0.41053009f, 0.470354795f, -1.f),
    C_Vertex3f(0.41402626f, 0.403358459f, -1.f),
    C_Vertex3f(0.423164368f, 0.47254014f, -1.f),
    C_Vertex3f(0.427160263f, 0.406913757f, -1.f),
    C_Vertex3f(0.435703278f, 0.473632813f, -1.f),
    C_Vertex3f(0.440702438f, 0.408691406f, -1.f),
    C_Vertex3f(0.451421738f, 0.473632813f, -1.f),
    C_Vertex3f(0.452963829f, 0.408691406f, -1.f),
    C_Vertex3f(0.469977856f, 0.47114706f, -1.f),
    C_Vertex3f(0.463134408f, 0.40766573f, -1.f),
    C_Vertex3f(0.472903132f, 0.405614376f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.301618099f, 0.239285946f, -1.f),
    C_Vertex3f(0.30684948f, 0.260891914f, -1.f),
    C_Vertex3f(0.307925224f, 0.413556218f, -1.f),
    C_Vertex3f(0.313824654f, 0.283427238f, -1.f),
    C_Vertex3f(0.320054054f, 0.424469352f, -1.f),
    C_Vertex3f(0.321944714f, 0.304267406f, -1.f),
    C_Vertex3f(0.33272171f, 0.434296608f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.301700354f, 0.142000675f, -1.f),
    C_Vertex3f(0.299043536f, 0.154485941f, -1.f),
    C_Vertex3f(0.306990623f, 0.015581131f, -1.f),
    C_Vertex3f(0.297272325f, 0.167805433f, -1.f),
    C_Vertex3f(0.288659096f, 0.0269451141f, -1.f),
    C_Vertex3f(0.296386719f, 0.181959152f, -1.f),
    C_Vertex3f(0.29633522f, 0.401557207f, -1.f),
    C_Vertex3f(0.296386719f, 0.198862076f, -1.f),
    C_Vertex3f(0.307925224f, 0.413556218f, -1.f),
    C_Vertex3f(0.298130512f, 0.218609333f, -1.f),
    C_Vertex3f(0.301618099f, 0.239285946f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.841736317f, 0.407146931f, -1.f),
    C_Vertex3f(0.835114241f, 0.427280188f, -1.f),
    C_Vertex3f(0.838253498f, 0.20584631f, -1.f),
    C_Vertex3f(0.827167749f, 0.447003603f, -1.f),
    C_Vertex3f(0.827102184f, 0.177710056f, -1.f),
    C_Vertex3f(0.817896843f, 0.466317177f, -1.f),
    C_Vertex3f(0.813163042f, 0.150461435f, -1.f),
    C_Vertex3f(0.806372643f, 0.486750603f, -1.f),
    C_Vertex3f(0.796436071f, 0.124100447f, -1.f),
    C_Vertex3f(0.792779446f, 0.507354617f, -1.f),
    C_Vertex3f(0.790527344f, 0.321663857f, -1.f),
    C_Vertex3f(0.789359212f, 0.33961463f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.792779446f, 0.507354617f, -1.f),
    C_Vertex3f(0.778046131f, 0.526599526f, -1.f),
    C_Vertex3f(0.778846025f, 0.391663074f, -1.f),
    C_Vertex3f(0.783518553f, 0.374614239f, -1.f),
    C_Vertex3f(0.787022948f, 0.357264757f, -1.f),
    C_Vertex3f(0.789359212f, 0.33961463f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.748474598f, 0.456851959f, -1.f),
    C_Vertex3f(0.757819653f, 0.441005707f, -1.f),
    C_Vertex3f(0.762172699f, 0.544485331f, -1.f),
    C_Vertex3f(0.765996575f, 0.424858809f, -1.f),
    C_Vertex3f(0.778046131f, 0.526599526f, -1.f),
    C_Vertex3f(0.773005366f, 0.408411264f, -1.f),
    C_Vertex3f(0.778846025f, 0.391663074f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.713552952f, 0.499637127f, -1.f),
    C_Vertex3f(0.726341248f, 0.486167669f, -1.f),
    C_Vertex3f(0.727005482f, 0.576179624f, -1.f),
    C_Vertex3f(0.737981796f, 0.471905947f, -1.f),
    C_Vertex3f(0.745159149f, 0.56101203f, -1.f),
    C_Vertex3f(0.748474598f, 0.456851959f, -1.f),
    C_Vertex3f(0.762172699f, 0.544485331f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.668301582f, 0.53529191f, -1.f),
    C_Vertex3f(0.684533119f, 0.524199247f, -1.f),
    C_Vertex3f(0.687277794f, 0.602437496f, -1.f),
    C_Vertex3f(0.699616909f, 0.51231432f, -1.f),
    C_Vertex3f(0.707711697f, 0.589988112f, -1.f),
    C_Vertex3f(0.713552952f, 0.499637127f, -1.f),
    C_Vertex3f(0.727005482f, 0.576179624f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.573903799f, 0.57649374f, -1.f),
    C_Vertex3f(0.593886018f, 0.570551157f, -1.f),
    C_Vertex3f(0.596844673f, 0.638480902f, -1.f),
    C_Vertex3f(0.613383174f, 0.563420057f, -1.f),
    C_Vertex3f(0.620487213f, 0.631549478f, -1.f),
    C_Vertex3f(0.632395267f, 0.555100441f, -1.f),
    C_Vertex3f(0.643440247f, 0.623231769f, -1.f),
    C_Vertex3f(0.650922298f, 0.545592308f, -1.f),
    C_Vertex3f(0.665703773f, 0.613527775f, -1.f),
    C_Vertex3f(0.668301582f, 0.53529191f, -1.f),
    C_Vertex3f(0.687277794f, 0.602437496f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.46513176f, 0.588378906f, -1.f),
    C_Vertex3f(0.489124298f, 0.588378906f, -1.f),
    C_Vertex3f(0.495379448f, 0.65234375f, -1.f),
    C_Vertex3f(0.511046767f, 0.58719039f, -1.f),
    C_Vertex3f(0.521780014f, 0.650957465f, -1.f),
    C_Vertex3f(0.532484174f, 0.584813356f, -1.f),
    C_Vertex3f(0.547491074f, 0.648184896f, -1.f),
    C_Vertex3f(0.553436518f, 0.581247807f, -1.f),
    C_Vertex3f(0.572512627f, 0.644026041f, -1.f),
    C_Vertex3f(0.573903799f, 0.57649374f, -1.f),
    C_Vertex3f(0.596844673f, 0.638480902f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.368355274f, 0.573422909f, -1.f),
    C_Vertex3f(0.391719341f, 0.579405308f, -1.f),
    C_Vertex3f(0.398356915f, 0.646443963f, -1.f),
    C_Vertex3f(0.415636778f, 0.583892107f, -1.f),
    C_Vertex3f(0.430704594f, 0.650377154f, -1.f),
    C_Vertex3f(0.440107584f, 0.586883307f, -1.f),
    C_Vertex3f(0.464356422f, 0.65234375f, -1.f),
    C_Vertex3f(0.46513176f, 0.588378906f, -1.f),
    C_Vertex3f(0.495379448f, 0.65234375f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.260470867f, 0.521275043f, -1.f),
    C_Vertex3f(0.280432701f, 0.534537315f, -1.f),
    C_Vertex3f(0.282007694f, 0.611045241f, -1.f),
    C_Vertex3f(0.30158329f, 0.546502113f, -1.f),
    C_Vertex3f(0.309138775f, 0.622844815f, -1.f),
    C_Vertex3f(0.323287249f, 0.556971312f, -1.f),
    C_Vertex3f(0.337574005f, 0.632677794f, -1.f),
    C_Vertex3f(0.345544577f, 0.56594491f, -1.f),
    C_Vertex3f(0.367313385f, 0.640544176f, -1.f),
    C_Vertex3f(0.368355274f, 0.573422909f, -1.f),
    C_Vertex3f(0.398356915f, 0.646443963f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.192511082f, 0.455251217f, -1.f),
    C_Vertex3f(0.207717896f, 0.473703384f, -1.f),
    C_Vertex3f(0.208534718f, 0.564079165f, -1.f),
    C_Vertex3f(0.224113464f, 0.490858078f, -1.f),
    C_Vertex3f(0.231657982f, 0.581546307f, -1.f),
    C_Vertex3f(0.241697788f, 0.506715298f, -1.f),
    C_Vertex3f(0.256180763f, 0.597279072f, -1.f),
    C_Vertex3f(0.260470867f, 0.521275043f, -1.f),
    C_Vertex3f(0.282007694f, 0.611045241f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.15402317f, 0.392109871f, -1.f),
    C_Vertex3f(0.165663719f, 0.41445446f, -1.f),
    C_Vertex3f(0.16648674f, 0.523941755f, -1.f),
    C_Vertex3f(0.178493023f, 0.435501575f, -1.f),
    C_Vertex3f(0.18681097f, 0.544877648f, -1.f),
    C_Vertex3f(0.192511082f, 0.455251217f, -1.f),
    C_Vertex3f(0.208534718f, 0.564079165f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.147562027f, 0.501271486f, -1.f),
    C_Vertex3f(0.130036831f, 0.476866841f, -1.f),
    C_Vertex3f(0.135107279f, 0.346212626f, -1.f),
    C_Vertex3f(0.14383769f, 0.369362593f, -1.f),
    C_Vertex3f(0.15402317f, 0.392109871f, -1.f),
    C_Vertex3f(0.16648674f, 0.523941755f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.130036831f, 0.476866841f, -1.f),
    C_Vertex3f(0.122011662f, 0.298704624f, -1.f),
    C_Vertex3f(0.127831936f, 0.322659969f, -1.f),
    C_Vertex3f(0.135107279f, 0.346212626f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.0991849899f, 0.422854424f, -1.f),
    C_Vertex3f(0.0870599747f, 0.395977974f, -1.f),
    C_Vertex3f(0.0891933441f, 0.0183954239f, -1.f),
    C_Vertex3f(0.0974011421f, 0.00258743763f, -1.f),
    C_Vertex3f(0.106496334f, -0.0127493143f, -1.f),
    C_Vertex3f(0.113911152f, 0.45072782f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.0891933441f, 0.0183954239f, -1.f),
    C_Vertex3f(0.0870599747f, 0.395977974f, -1.f),
    C_Vertex3f(0.080945015f, 0.0368595123f, -1.f),
    C_Vertex3f(0.0775020123f, 0.37151885f, -1.f),
    C_Vertex3f(0.0729157925f, 0.0579183102f, -1.f),
    C_Vertex3f(0.069309473f, 0.346745729f, -1.f),
    C_Vertex3f(0.0660336018f, 0.0793869495f, -1.f),
    C_Vertex3f(0.062482357f, 0.321658611f, -1.f),
    C_Vertex3f(0.0602984428f, 0.10126543f, -1.f),
    C_Vertex3f(0.0570206642f, 0.296257496f, -1.f),
    C_Vertex3f(0.0557103157f, 0.123553753f, -1.f),
    C_Vertex3f(0.0529243946f, 0.270542383f, -1.f),
    C_Vertex3f(0.0522692204f, 0.146251917f, -1.f),
    C_Vertex3f(0.0501935482f, 0.244513273f, -1.f),
    C_Vertex3f(0.0499751568f, 0.169359922f, -1.f),
    C_Vertex3f(0.048828125f, 0.218170166f, -1.f),
    C_Vertex3f(0.048828125f, 0.192877769f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.853656054f, 0.344288111f, -1.f),
    C_Vertex3f(0.851007223f, 0.365650892f, -1.f),
    C_Vertex3f(0.85219264f, 0.264781713f, -1.f),
    C_Vertex3f(0.854980469f, 0.295580864f, -1.f),
    C_Vertex3f(0.854980469f, 0.322515488f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.847033978f, 0.386603832f, -1.f),
    C_Vertex3f(0.841736317f, 0.407146931f, -1.f),
    C_Vertex3f(0.846616983f, 0.234870195f, -1.f),
    C_Vertex3f(0.85219264f, 0.264781713f, -1.f),
    C_Vertex3f(0.851007223f, 0.365650892f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.796436071f, 0.124100447f, -1.f),
    C_Vertex3f(0.790527344f, 0.321663857f, -1.f),
    C_Vertex3f(0.790527344f, 0.29691124f, -1.f),
    C_Vertex3f(0.786886692f, 0.266121387f, -1.f),
    C_Vertex3f(0.779605389f, 0.235795498f, -1.f),
    C_Vertex3f(0.776921272f, 0.0986270905f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.779605389f, 0.235795498f, -1.f),
    C_Vertex3f(0.768683434f, 0.205933571f, -1.f),
    C_Vertex3f(0.776921272f, 0.0986270905f, -1.f),
    C_Vertex3f(0.757761478f, 0.183885098f, -1.f),
    C_Vertex3f(0.755821228f, 0.0752983093f, -1.f),
    C_Vertex3f(0.749830127f, 0.169930577f, -1.f),
    C_Vertex3f(0.741248727f, 0.156720519f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.735459089f, 0.0559854507f, -1.f),
    C_Vertex3f(0.755821228f, 0.0752983093f, -1.f),
    C_Vertex3f(0.741248727f, 0.156720519f, -1.f),
    C_Vertex3f(0.732017279f, 0.144254923f, -1.f),
    C_Vertex3f(0.722135782f, 0.132533789f, -1.f),
    C_Vertex3f(0.714632273f, 0.039431572f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.722135782f, 0.132533789f, -1.f),
    C_Vertex3f(0.711604238f, 0.121557117f, -1.f),
    C_Vertex3f(0.714632273f, 0.039431572f, -1.f),
    C_Vertex3f(0.700422645f, 0.111324906f, -1.f),
    C_Vertex3f(0.693340778f, 0.025636673f, -1.f),
    C_Vertex3f(0.688591003f, 0.101837158f, -1.f),
    C_Vertex3f(0.672935486f, 0.0907993317f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.693340778f, 0.025636673f, -1.f),
    C_Vertex3f(0.672935486f, 0.0907993317f, -1.f),
    C_Vertex3f(0.671584606f, 0.0146007538f, -1.f),
    C_Vertex3f(0.655911446f, 0.0808000565f, -1.f),
    C_Vertex3f(0.649363756f, 0.00632381439f, -1.f),
    C_Vertex3f(0.640692711f, 0.074133873f, -1.f),
    C_Vertex3f(0.627279282f, 0.0708007813f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.626678228f, 0.000805854797f, -1.f),
    C_Vertex3f(0.649363756f, 0.00632381439f, -1.f),
    C_Vertex3f(0.627279282f, 0.0708007813f, -1.f),
    C_Vertex3f(0.618301392f, 0.0708007813f, -1.f),
    C_Vertex3f(0.612418175f, 0.0718669891f, -1.f),
    C_Vertex3f(0.606999397f, 0.0739994049f, -1.f),
    C_Vertex3f(0.603528023f, -0.001953125f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.603528023f, -0.001953125f, -1.f),
    C_Vertex3f(0.606999397f, 0.0739994049f, -1.f),
    C_Vertex3f(0.602045059f, 0.0771980286f, -1.f),
    C_Vertex3f(0.597555161f, 0.0814628601f, -1.f),
    C_Vertex3f(0.594187737f, 0.0861377716f, -1.f),
    C_Vertex3f(0.591942787f, 0.0912227631f, -1.f),
    C_Vertex3f(0.590820313f, 0.0967178345f, -1.f),
    C_Vertex3f(0.584177017f, -0.001953125f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.548828125f, 0.272378922f, -1.f),
    C_Vertex3f(0.54686594f, 0.250087261f, -1.f),
    C_Vertex3f(0.547607422f, 0.00493621826f, -1.f),
    C_Vertex3f(0.558348656f, 0.00149154663f, -1.f),
    C_Vertex3f(0.548828125f, 0.290977478f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.514211655f, 0.0362110138f, -1.f),
    C_Vertex3f(0.517818451f, 0.0292129517f, -1.f),
    C_Vertex3f(0.520240784f, 0.163115501f, -1.f),
    C_Vertex3f(0.523420334f, 0.0216674805f, -1.f),
    C_Vertex3f(0.529206276f, 0.183381081f, -1.f),
    C_Vertex3f(0.530252457f, 0.0151062012f, -1.f),
    C_Vertex3f(0.537055016f, 0.205588341f, -1.f),
    C_Vertex3f(0.538314819f, 0.00952911377f, -1.f),
    C_Vertex3f(0.54294157f, 0.227823734f, -1.f),
    C_Vertex3f(0.547607422f, 0.00493621826f, -1.f),
    C_Vertex3f(0.54686594f, 0.250087261f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.507980347f, 0.0644207001f, -1.f),
    C_Vertex3f(0.509675026f, 0.0530490875f, -1.f),
    C_Vertex3f(0.510158539f, 0.144791603f, -1.f),
    C_Vertex3f(0.511752129f, 0.0436458588f, -1.f),
    C_Vertex3f(0.520240784f, 0.163115501f, -1.f),
    C_Vertex3f(0.514211655f, 0.0362110138f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.510158539f, 0.144791603f, -1.f),
    C_Vertex3f(0.498959541f, 0.128409386f, -1.f),
    C_Vertex3f(0.500230789f, 0.0628948212f, -1.f),
    C_Vertex3f(0.507324219f, 0.0710906982f, -1.f),
    C_Vertex3f(0.507980347f, 0.0644207001f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.434381485f, 0.0739831924f, -1.f),
    C_Vertex3f(0.435033798f, 0.0134496689f, -1.f),
    C_Vertex3f(0.447896957f, 0.0813131332f, -1.f),
    C_Vertex3f(0.452600479f, 0.0233926773f, -1.f),
    C_Vertex3f(0.461112499f, 0.090420723f, -1.f),
    C_Vertex3f(0.469322205f, 0.0349478722f, -1.f),
    C_Vertex3f(0.474028111f, 0.101305962f, -1.f),
    C_Vertex3f(0.485198975f, 0.0481152534f, -1.f),
    C_Vertex3f(0.486643791f, 0.113968849f, -1.f),
    C_Vertex3f(0.500230789f, 0.0628948212f, -1.f),
    C_Vertex3f(0.498959541f, 0.128409386f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.395792007f, 0.0629882813f, -1.f),
    C_Vertex3f(0.399817467f, 0.00102090836f, -1.f),
    C_Vertex3f(0.40832901f, 0.0648207664f, -1.f),
    C_Vertex3f(0.417439461f, 0.00599241257f, -1.f),
    C_Vertex3f(0.421192169f, 0.0684857368f, -1.f),
    C_Vertex3f(0.435033798f, 0.0134496689f, -1.f),
    C_Vertex3f(0.434381485f, 0.0739831924f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.385108948f, 0.0629882813f, -1.f),
    C_Vertex3f(0.376212478f, 0.0640275478f, -1.f),
    C_Vertex3f(0.382167816f, -0.00146484375f, -1.f),
    C_Vertex3f(0.399817467f, 0.00102090836f, -1.f),
    C_Vertex3f(0.395792007f, 0.0629882813f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.367574811f, 0.066106081f, -1.f),
    C_Vertex3f(0.359195948f, 0.0692238808f, -1.f),
    C_Vertex3f(0.363618851f, -0.00146484375f, -1.f),
    C_Vertex3f(0.382167816f, -0.00146484375f, -1.f),
    C_Vertex3f(0.376212478f, 0.0640275478f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.351075888f, 0.0733809471f, -1.f),
    C_Vertex3f(0.343214631f, 0.07857728f, -1.f),
    C_Vertex3f(0.344470501f, 0.00137615204f, -1.f),
    C_Vertex3f(0.363618851f, -0.00146484375f, -1.f),
    C_Vertex3f(0.359195948f, 0.0692238808f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.343214631f, 0.07857728f, -1.f),
    C_Vertex3f(0.335612178f, 0.0848128796f, -1.f),
    C_Vertex3f(0.344470501f, 0.00137615204f, -1.f),
    C_Vertex3f(0.328268528f, 0.0920877457f, -1.f),
    C_Vertex3f(0.325594425f, 0.00705814362f, -1.f),
    C_Vertex3f(0.321183681f, 0.100401878f, -1.f),
    C_Vertex3f(0.314984441f, 0.109550238f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.309670806f, 0.119532824f, -1.f),
    C_Vertex3f(0.305242777f, 0.130349636f, -1.f),
    C_Vertex3f(0.306990623f, 0.015581131f, -1.f),
    C_Vertex3f(0.325594425f, 0.00705814362f, -1.f),
    C_Vertex3f(0.314984441f, 0.109550238f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.29633522f, 0.401557207f, -1.f),
    C_Vertex3f(0.285284042f, 0.388472319f, -1.f),
    C_Vertex3f(0.288659096f, 0.0269451141f, -1.f),
    C_Vertex3f(0.27477169f, 0.374301553f, -1.f),
    C_Vertex3f(0.272046089f, 0.0413684845f, -1.f),
    C_Vertex3f(0.264798164f, 0.359044909f, -1.f),
    C_Vertex3f(0.257151604f, 0.0588512421f, -1.f),
    C_Vertex3f(0.255363464f, 0.342702389f, -1.f),
    C_Vertex3f(0.24646759f, 0.325273991f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.257151604f, 0.0588512421f, -1.f),
    C_Vertex3f(0.24646759f, 0.325273991f, -1.f),
    C_Vertex3f(0.243975639f, 0.0793933868f, -1.f),
    C_Vertex3f(0.238683701f, 0.307852387f, -1.f),
    C_Vertex3f(0.232518196f, 0.102994919f, -1.f),
    C_Vertex3f(0.232011795f, 0.290437579f, -1.f),
    C_Vertex3f(0.226451874f, 0.273029566f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.223925114f, 0.127743721f, -1.f),
    C_Vertex3f(0.232518196f, 0.102994919f, -1.f),
    C_Vertex3f(0.226451874f, 0.273029566f, -1.f),
    C_Vertex3f(0.222003937f, 0.255628347f, -1.f),
    C_Vertex3f(0.218667984f, 0.238233924f, -1.f),
    C_Vertex3f(0.218196392f, 0.153639793f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.218196392f, 0.153639793f, -1.f),
    C_Vertex3f(0.218667984f, 0.238233924f, -1.f),
    C_Vertex3f(0.216444016f, 0.220846295f, -1.f),
    C_Vertex3f(0.215332031f, 0.203465462f, -1.f),
    C_Vertex3f(0.215332031f, 0.180683136f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.588867188f, 0.4609375f, -1.f),
    C_Vertex3f(0.590820313f, 0.10049057f, -1.f),
    C_Vertex3f(0.591230631f, 0.103839159f, -1.f),
    C_Vertex3f(0.592051268f, 0.108896017f, -1.f),
    C_Vertex3f(0.593282223f, 0.115661144f, -1.f),
    C_Vertex3f(0.594923496f, 0.124134541f, -1.f),
    C_Vertex3f(0.596975088f, 0.134316206f, -1.f),
    C_Vertex3f(0.599436998f, 0.146206141f, -1.f),
    C_Vertex3f(0.602309227f, 0.159804344f, -1.f),
    C_Vertex3f(0.666992188f, 0.4609375f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLES),
    C_Vertex3f(0.301700354f, 0.142000675f, -1.f),
    C_Vertex3f(0.306990623f, 0.015581131f, -1.f),
    C_Vertex3f(0.305242777f, 0.130349636f, -1.f),
    C_Vertex3f(0.841736317f, 0.407146931f, -1.f),
    C_Vertex3f(0.838253498f, 0.20584631f, -1.f),
    C_Vertex3f(0.846616983f, 0.234870195f, -1.f),
    C_End(),
    C_Translatef(0.908691406f, 0.f, 0.f),
};
static const Call char_65[] = {
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_FrontFace(GL_CW),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.933440149f, 0.358733237f, 0.f),
    C_Vertex3f(-0.00107574463f, 0.f, 0.f),
    C_Vertex3f(-0.00107574463f, 0.f, -1.f),
    C_Vertex3f(0.245124817f, 0.640625f, -1.f),
    C_Vertex3f(0.245124817f, 0.640625f, 0.f),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.245124817f, 0.640625f, 0.f),
    C_Vertex3f(0.245124817f, 0.640625f, -1.f),
    C_Vertex3f(0.336891174f, 0.640625f, -1.f),
    C_Vertex3f(0.336891174f, 0.640625f, 0.f),
    C_Normal3f(0.92576915f, 0.378089279f, 0.f),
    C_Vertex3f(0.336891174f, 0.640625f, 0.f),
    C_Vertex3f(0.336891174f, 0.640625f, -1.f),
    C_Vertex3f(0.598526001f, 0.f, -1.f),
    C_Vertex3f(0.598526001f, 0.f, 0.f),
    C_Normal3f(-0.f, -1.f, 0.f),
    C_Vertex3f(0.598526001f, 0.f, 0.f),
    C_Vertex3f(0.598526001f, 0.f, -1.f),
    C_Vertex3f(0.501953125f, 0.f, -1.f),
    C_Vertex3f(0.501953125f, 0.f, 0.f),
    C_Normal3f(-0.933976114f, -0.357335538f, 0.f),
    C_Vertex3f(0.501953125f, 0.f, 0.f),
    C_Vertex3f(0.501953125f, 0.f, -1.f),
    C_Vertex3f(0.427787781f, 0.193847656f, -1.f),
    C_Vertex3f(0.427787781f, 0.193847656f, 0.f),
    C_Normal3f(-0.f, -1.f, 0.f),
    C_Vertex3f(0.427787781f, 0.193847656f, 0.f),
    C_Vertex3f(0.427787781f, 0.193847656f, -1.f),
    C_Vertex3f(0.159065247f, 0.193847656f, -1.f),
    C_Vertex3f(0.159065247f, 0.193847656f, 0.f),
    C_Normal3f(0.940247476f, -0.340491831f, 0.f),
    C_Vertex3f(0.159065247f, 0.193847656f, 0.f),
    C_Vertex3f(0.159065247f, 0.193847656f, -1.f),
    C_Vertex3f(0.0888671875f, 0.f, -1.f),
    C_Vertex3f(0.0888671875f, 0.f, 0.f),
    C_Normal3f(-0.f, -1.f, 0.f),
    C_Vertex3f(0.0888671875f, 0.f, 0.f),
    C_Vertex3f(0.0888671875f, 0.f, -1.f),
    C_Vertex3f(-0.00107574463f, 0.f, -1.f),
    C_Vertex3f(-0.00107574463f, 0.f, 0.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.18359375f, 0.262695313f, 0.f),
    C_Vertex3f(0.18359375f, 0.262695313f, -1.f),
    C_Vertex3f(0.401153564f, 0.262695313f, -1.f),
    C_Vertex3f(0.401153564f, 0.262695313f, 0.f),
    C_End(),
    C_Begin(GL_QUAD_STRIP),
    C_Normal3f(-0.935599327f, -0.353063881f, 0.f),
    C_Vertex3f(0.401153564f, 0.262695313f, 0.f),
    C_Vertex3f(0.401153564f, 0.262695313f, -1.f),
    C_Normal3f(-0.935954869f, -0.352120042f, 0.f),
    C_Vertex3f(0.330211639f, 0.450687408f, 0.f),
    C_Vertex3f(0.330211639f, 0.450687408f, -1.f),
    C_Normal3f(-0.940465152f, -0.339890033f, 0.f),
    C_Vertex3f(0.323152781f, 0.470025778f, 0.f),
    C_Vertex3f(0.323152781f, 0.470025778f, -1.f),
    C_Normal3f(-0.942786753f, -0.333396405f, 0.f),
    C_Vertex3f(0.316565275f, 0.488446474f, 0.f),
    C_Vertex3f(0.316565275f, 0.488446474f, -1.f),
    C_Normal3f(-0.945318818f, -0.326147795f, 0.f),
    C_Vertex3f(0.310449123f, 0.505949497f, 0.f),
    C_Vertex3f(0.310449123f, 0.505949497f, -1.f),
    C_Normal3f(-0.948088706f, -0.318005919f, 0.f),
    C_Vertex3f(0.304804325f, 0.522534847f, 0.f),
    C_Vertex3f(0.304804325f, 0.522534847f, -1.f),
    C_Normal3f(-0.951127946f, -0.30879733f, 0.f),
    C_Vertex3f(0.29963088f, 0.538202524f, 0.f),
    C_Vertex3f(0.29963088f, 0.538202524f, -1.f),
    C_Normal3f(-0.954471946f, -0.298300862f, 0.f),
    C_Vertex3f(0.294928789f, 0.552952528f, 0.f),
    C_Vertex3f(0.294928789f, 0.552952528f, -1.f),
    C_Normal3f(-0.957520068f, -0.288366556f, 0.f),
    C_Vertex3f(0.290698051f, 0.566784859f, 0.f),
    C_Vertex3f(0.290698051f, 0.566784859f, -1.f),
    C_Normal3f(-0.9601475f, -0.279493541f, 0.f),
    C_Vertex3f(0.288818359f, 0.573242188f, 0.f),
    C_Vertex3f(0.288818359f, 0.573242188f, -1.f),
    C_End(),
    C_Begin(GL_QUAD_STRIP),
    C_Normal3f(0.97945708f, -0.201652929f, 0.f),
    C_Vertex3f(0.288818359f, 0.573242188f, 0.f),
    C_Vertex3f(0.288818359f, 0.573242188f, -1.f),
    C_Normal3f(0.974358559f, -0.225001022f, 0.f),
    C_Vertex3f(0.285654068f, 0.557872772f, 0.f),
    C_Vertex3f(0.285654068f, 0.557872772f, -1.f),
    C_Normal3f(0.967271984f, -0.253741771f, 0.f),
    C_Vertex3f(0.278186798f, 0.527202606f, 0.f),
    C_Vertex3f(0.278186798f, 0.527202606f, -1.f),
    C_Normal3f(0.957781792f, -0.287495911f, 0.f),
    C_Vertex3f(0.269580841f, 0.496601105f, 0.f),
    C_Vertex3f(0.269580841f, 0.496601105f, -1.f),
    C_Normal3f(0.949109674f, -0.314945877f, 0.f),
    C_Vertex3f(0.259836197f, 0.466068268f, 0.f),
    C_Vertex3f(0.259836197f, 0.466068268f, -1.f),
    C_Normal3f(0.93592304f, -0.352204621f, 0.f),
    C_Vertex3f(0.254394531f, 0.450836182f, 0.f),
    C_Vertex3f(0.254394531f, 0.450836182f, -1.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(0.93592304f, -0.352204621f, 0.f),
    C_Vertex3f(0.254394531f, 0.450836182f, 0.f),
    C_Vertex3f(0.254394531f, 0.450836182f, -1.f),
    C_Vertex3f(0.18359375f, 0.262695313f, -1.f),
    C_Vertex3f(0.18359375f, 0.262695313f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.323152781f, 0.470025778f, 0.f),
    C_Vertex3f(0.330211639f, 0.450687408f, 0.f),
    C_Vertex3f(0.336891174f, 0.640625f, 0.f),
    C_Vertex3f(0.401153564f, 0.262695313f, 0.f),
    C_Vertex3f(0.598526001f, 0.f, 0.f),
    C_Vertex3f(0.427787781f, 0.193847656f, 0.f),
    C_Vertex3f(0.501953125f, 0.f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.336891174f, 0.640625f, 0.f),
    C_Vertex3f(0.245124817f, 0.640625f, 0.f),
    C_Vertex3f(0.288818359f, 0.573242188f, 0.f),
    C_Vertex3f(0.290698051f, 0.566784859f, 0.f),
    C_Vertex3f(0.294928789f, 0.552952528f, 0.f),
    C_Vertex3f(0.29963088f, 0.538202524f, 0.f),
    C_Vertex3f(0.304804325f, 0.522534847f, 0.f),
    C_Vertex3f(0.310449123f, 0.505949497f, 0.f),
    C_Vertex3f(0.316565275f, 0.488446474f, 0.f),
    C_Vertex3f(0.323152781f, 0.470025778f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.288818359f, 0.573242188f, 0.f),
    C_Vertex3f(0.245124817f, 0.640625f, 0.f),
    C_Vertex3f(0.254394531f, 0.450836182f, 0.f),
    C_Vertex3f(0.259836197f, 0.466068268f, 0.f),
    C_Vertex3f(0.269580841f, 0.496601105f, 0.f),
    C_Vertex3f(0.278186798f, 0.527202606f, 0.f),
    C_Vertex3f(0.285654068f, 0.557872772f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.245124817f, 0.640625f, 0.f),
    C_Vertex3f(-0.00107574463f, 0.f, 0.f),
    C_Vertex3f(0.0888671875f, 0.f, 0.f),
    C_Vertex3f(0.159065247f, 0.193847656f, 0.f),
    C_Vertex3f(0.18359375f, 0.262695313f, 0.f),
    C_Vertex3f(0.254394531f, 0.450836182f, 0.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.18359375f, 0.262695313f, 0.f),
    C_Vertex3f(0.159065247f, 0.193847656f, 0.f),
    C_Vertex3f(0.427787781f, 0.193847656f, 0.f),
    C_Vertex3f(0.401153564f, 0.262695313f, 0.f),
    C_End(),
    C_Normal3f(0.f, 0.f, -1.f),
    C_FrontFace(GL_CW),
    C_Begin(GL_TRIANGLE_STRIP),
    C_Vertex3f(0.323152781f, 0.470025778f, -1.f),
    C_Vertex3f(0.330211639f, 0.450687408f, -1.f),
    C_Vertex3f(0.336891174f, 0.640625f, -1.f),
    C_Vertex3f(0.401153564f, 0.262695313f, -1.f),
    C_Vertex3f(0.598526001f, 0.f, -1.f),
    C_Vertex3f(0.427787781f, 0.193847656f, -1.f),
    C_Vertex3f(0.501953125f, 0.f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.336891174f, 0.640625f, -1.f),
    C_Vertex3f(0.245124817f, 0.640625f, -1.f),
    C_Vertex3f(0.288818359f, 0.573242188f, -1.f),
    C_Vertex3f(0.290698051f, 0.566784859f, -1.f),
    C_Vertex3f(0.294928789f, 0.552952528f, -1.f),
    C_Vertex3f(0.29963088f, 0.538202524f, -1.f),
    C_Vertex3f(0.304804325f, 0.522534847f, -1.f),
    C_Vertex3f(0.310449123f, 0.505949497f, -1.f),
    C_Vertex3f(0.316565275f, 0.488446474f, -1.f),
    C_Vertex3f(0.323152781f, 0.470025778f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.288818359f, 0.573242188f, -1.f),
    C_Vertex3f(0.245124817f, 0.640625f, -1.f),
    C_Vertex3f(0.254394531f, 0.450836182f, -1.f),
    C_Vertex3f(0.259836197f, 0.466068268f, -1.f),
    C_Vertex3f(0.269580841f, 0.496601105f, -1.f),
    C_Vertex3f(0.278186798f, 0.527202606f, -1.f),
    C_Vertex3f(0.285654068f, 0.557872772f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.245124817f, 0.640625f, -1.f),
    C_Vertex3f(-0.00107574463f, 0.f, -1.f),
    C_Vertex3f(0.0888671875f, 0.f, -1.f),
    C_Vertex3f(0.159065247f, 0.193847656f, -1.f),
    C_Vertex3f(0.18359375f, 0.262695313f, -1.f),
    C_Vertex3f(0.254394531f, 0.450836182f, -1.f),
    C_End(),
    C_Begin(GL_TRIANGLE_FAN),
    C_Vertex3f(0.18359375f, 0.262695313f, -1.f),
    C_Vertex3f(0.159065247f, 0.193847656f, -1.f),
    C_Vertex3f(0.427787781f, 0.193847656f, -1.f),
    C_Vertex3f(0.401153564f, 0.262695313f, -1.f),
    C_End(),
    C_Translatef(0.597167969f, 0.f, 0.f),
};
static const Call char_66[] = {
    C_Normal3f(0.f, 0.f, 1.f),
    C_FrontFace(GL_CCW),
    C_FrontFace(GL_CW),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.99999994f, 0.f, 0.f),
    C_Vertex3f(0.0654296875f, 0.f, 0.f),
    C_Vertex3f(0.0654296875f, 0.f, -1.f),
    C_Vertex3f(0.0654296875f, 0.640625f, -1.f),
    C_Vertex3f(0.0654296875f, 0.640625f, 0.f),
    C_End(),
    C_Begin(GL_QUAD_STRIP),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.0654296875f, 0.640625f, 0.f),
    C_Vertex3f(0.0654296875f, 0.640625f, -1.f),
    C_Normal3f(0.00227682921f, 0.999997437f, 0.f),
    C_Vertex3f(0.314907074f, 0.640625f, 0.f),
    C_Vertex3f(0.314907074f, 0.640625f, -1.f),
    C_Normal3f(0.0535869971f, 0.99856323f, 0.f),
    C_Vertex3f(0.332347989f, 0.640017271f, 0.f),
    C_Vertex3f(0.332347989f, 0.640017271f, -1.f),
    C_Normal3f(0.0940706357f, 0.995565534f, 0.f),
    C_Vertex3f(0.348881125f, 0.638801813f, 0.f),
    C_Vertex3f(0.348881125f, 0.638801813f, -1.f),
    C_Normal3f(0.138842821f, 0.990314364f, 0.f),
    C_Vertex3f(0.364506483f, 0.636978626f, 0.f),
    C_Vertex3f(0.364506483f, 0.636978626f, -1.f),
    C_Normal3f(0.188300446f, 0.982111454f, 0.f),
    C_Vertex3f(0.379224062f, 0.63454771f, 0.f),
    C_Vertex3f(0.379224062f, 0.63454771f, -1.f),
    C_Normal3f(0.24277702f, 0.970082045f, 0.f),
    C_Vertex3f(0.393033862f, 0.631509066f, 0.f),
    C_Vertex3f(0.393033862f, 0.631509066f, -1.f),
    C_Normal3f(0.30247134f, 0.953158498f, 0.f),
    C_Vertex3f(0.405935884f, 0.627862692f, 0.f),
    C_Vertex3f(0.405935884f, 0.627862692f, -1.f),
    C_Normal3f(0.37410599f, 0.927385926f, 0.f),
    C_Vertex3f(0.417930126f, 0.623608589f, 0.f),
    C_Vertex3f(0.417930126f, 0.623608589f, -1.f),
    C_Normal3f(0.474823654f, 0.880081058f, 0.f),
    C_Vertex3f(0.434559822f, 0.616315842f, 0.f),
    C_Vertex3f(0.434559822f, 0.616315842f, -1.f),
    C_Normal3f(0.59248507f, 0.80558151f, 0.f),
    C_Vertex3f(0.454329967f, 0.603970051f, 0.f),
    C_Vertex3f(0.454329967f, 0.603970051f, -1.f),
    C_Normal3f(0.709565461f, 0.704639554f, 0.f),
    C_Vertex3f(0.47169733f, 0.589002132f, 0.f),
    C_Vertex3f(0.47169733f, 0.589002132f, -1.f),
    C_Normal3f(0.808391511f, 0.588645101f, 0.f),
    C_Vertex3f(0.486661911f, 0.571412086f, 0.f),
    C_Vertex3f(0.486661911f, 0.571412086f, -1.f),
    C_Normal3f(0.880777955f, 0.473529458f, 0.f),
    C_Vertex3f(0.499223709f, 0.551199913f, 0.f),
    C_Vertex3f(0.499223709f, 0.551199913f, -1.f),
    C_Normal3f(0.936181247f, 0.351517648f, 0.f),
    C_Vertex3f(0.508645058f, 0.530522823f, 0.f),
    C_Vertex3f(0.508645058f, 0.530522823f, -1.f),
    C_Normal3f(0.976564884f, 0.215223134f, 0.f),
    C_Vertex3f(0.514925957f, 0.509380817f, 0.f),
    C_Vertex3f(0.514925957f, 0.509380817f, -1.f),
    C_Normal3f(0.997333109f, 0.0729850531f, 0.f),
    C_Vertex3f(0.518066406f, 0.487773895f, 0.f),
    C_Vertex3f(0.518066406f, 0.487773895f, -1.f),
    C_Normal3f(0.997725725f, -0.0674047023f, 0.f),
    C_Vertex3f(0.518066406f, 0.466466904f, 0.f),
    C_Vertex3f(0.518066406f, 0.466466904f, -1.f),
    C_Normal3f(0.978093863f, -0.208164185f, 0.f),
    C_Vertex3f(0.51527977f, 0.446526051f, 0.f),
    C_Vertex3f(0.51527977f, 0.446526051f, -1.f),
    C_Normal3f(0.939104795f, -0.34363085f, 0.f),
    C_Vertex3f(0.509706497f, 0.427186489f, 0.f),
    C_Vertex3f(0.509706497f, 0.427186489f, -1.f),
    C_Normal3f(0.883943856f, -0.467593074f, 0.f),
    C_Vertex3f(0.501346588f, 0.408448219f, 0.f),
    C_Vertex3f(0.501346588f, 0.408448219f, -1.f),
    C_Normal3f(0.808460712f, -0.588550031f, 0.f),
    C_Vertex3f(0.490200043f, 0.390311241f, 0.f),
    C_Vertex3f(0.490200043f, 0.390311241f, -1.f),
    C_Normal3f(0.709528685f, -0.704676449f, 0.f),
    C_Vertex3f(0.476212502f, 0.373922825f, 0.f),
    C_Vertex3f(0.476212502f, 0.373922825f, -1.f),
    C_Normal3f(0.602203906f, -0.798342288f, 0.f),
    C_Vertex3f(0.459383965f, 0.35928297f, 0.f),
    C_Vertex3f(0.459383965f, 0.35928297f, -1.f),
    C_Normal3f(0.512611806f, -0.858620465f, 0.f),
    C_Vertex3f(0.439714432f, 0.346391678f, 0.f),
    C_Vertex3f(0.439714432f, 0.346391678f, -1.f),
    C_Normal3f(0.443625778f, -0.896212161f, 0.f),
    C_Vertex3f(0.428459167f, 0.340820313f, 0.f),
    C_Vertex3f(0.428459167f, 0.340820313f, -1.f),
    C_End(),
    C_Begin(GL_QUAD_STRIP),
    C_Normal3f(0.280859202f, 0.959748983f, 0.f),
    C_Vertex3f(0.428459167f, 0.340820313f, 0.f),
    C_Vertex3f(0.428459167f, 0.340820313f, -1.f),
    C_Normal3f(0.322010159f, 0.946736217f, 0.f),
    C_Vertex3f(0.435739517f, 0.338689804f, 0.f),
    C_Vertex3f(0.435739517f, 0.338689804f, -1.f),
    C_Normal3f(0.375480443f, 0.926830351f, 0.f),
    C_Vertex3f(0.44945848f, 0.333677888f, 0.f),
    C_Vertex3f(0.44945848f, 0.333677888f, -1.f),
    C_Normal3f(0.442026228f, 0.897002101f, 0.f),
    C_Vertex3f(0.462335706f, 0.327915072f, 0.f),
    C_Vertex3f(0.462335706f, 0.327915072f, -1.f),
    C_Normal3f(0.510154545f, 0.860082746f, 0.f),
    C_Vertex3f(0.474371195f, 0.321401358f, 0.f),
    C_Vertex3f(0.474371195f, 0.321401358f, -1.f),
    C_Normal3f(0.578484714f, 0.815693259f, 0.f),
    C_Vertex3f(0.485564947f, 0.314136744f, 0.f),
    C_Vertex3f(0.485564947f, 0.314136744f, -1.f),
    C_Normal3f(0.645390093f, 0.763853192f, 0.f),
    C_Vertex3f(0.495916963f, 0.30612123f, 0.f),
    C_Vertex3f(0.495916963f, 0.30612123f, -1.f),
    C_Normal3f(0.709138215f, 0.705069482f, 0.f),
    C_Vertex3f(0.505427241f, 0.297354817f, 0.f),
    C_Vertex3f(0.505427241f, 0.297354817f, -1.f),
    C_Normal3f(0.768079758f, 0.640354156f, 0.f),
    C_Vertex3f(0.514095783f, 0.287837505f, 0.f),
    C_Vertex3f(0.514095783f, 0.287837505f, -1.f),
    C_Normal3f(0.819691777f, 0.572804809f, 0.f),
    C_Vertex3f(0.521922588f, 0.277569294f, 0.f),
    C_Vertex3f(0.521922588f, 0.277569294f, -1.f),
    C_Normal3f(0.865032375f, 0.501716018f, 0.f),
    C_Vertex3f(0.528771043f, 0.266837001f, 0.f),
    C_Vertex3f(0.528771043f, 0.266837001f, -1.f),
    C_Normal3f(0.90473175f, 0.42598179f, 0.f),
    C_Vertex3f(0.534641147f, 0.255640626f, 0.f),
    C_Vertex3f(0.534641147f, 0.255640626f, -1.f),
    C_Normal3f(0.937801421f, 0.347172141f, 0.f),
    C_Vertex3f(0.5395329f, 0.243980169f, 0.f),
    C_Vertex3f(0.5395329f, 0.243980169f, -1.f),
    C_Normal3f(0.963681757f, 0.267053306f, 0.f),
    C_Vertex3f(0.543446302f, 0.231855631f, 0.f),
    C_Vertex3f(0.543446302f, 0.231855631f, -1.f),
    C_Normal3f(0.982284367f, 0.187396452f, 0.f),
    C_Vertex3f(0.546381354f, 0.219267011f, 0.f),
    C_Vertex3f(0.546381354f, 0.219267011f, -1.f),
    C_Normal3f(0.993953824f, 0.109799117f, 0.f),
    C_Vertex3f(0.548338056f, 0.206214309f, 0.f),
    C_Vertex3f(0.548338056f, 0.206214309f, -1.f),
    C_Normal3f(0.999525905f, 0.0307911802f, 0.f),
    C_Vertex3f(0.549316406f, 0.192697525f, 0.f),
    C_Vertex3f(0.549316406f, 0.192697525f, -1.f),
    C_Normal3f(0.998234808f, -0.0593903735f, 0.f),
    C_Vertex3f(0.549316406f, 0.174455643f, 0.f),
    C_Vertex3f(0.549316406f, 0.174455643f, -1.f),
    C_Normal3f(0.986296535f, -0.164982155f, 0.f),
    C_Vertex3f(0.546939373f, 0.152744293f, 0.f),
    C_Vertex3f(0.546939373f, 0.152744293f, -1.f),
    C_Normal3f(0.960546494f, -0.278119296f, 0.f),
    C_Vertex3f(0.542185307f, 0.131824493f, 0.f),
    C_Vertex3f(0.542185307f, 0.131824493f, -1.f),
    C_Normal3f(0.921448112f, -0.388501436f, 0.f),
    C_Vertex3f(0.535054207f, 0.111696243f, 0.f),
    C_Vertex3f(0.535054207f, 0.111696243f, -1.f),
    C_Normal3f(0.875379264f, -0.483436853f, 0.f),
    C_Vertex3f(0.525546074f, 0.0923595428f, 0.f),
    C_Vertex3f(0.525546074f, 0.0923595428f, -1.f),
    C_Normal3f(0.819832265f, -0.572603762f, 0.f),
    C_Vertex3f(0.514918327f, 0.0752353668f, 0.f),
    C_Vertex3f(0.514918327f, 0.0752353668f, -1.f),
    C_Normal3f(0.746449828f, -0.665441751f, 0.f),
    C_Vertex3f(0.503170967f, 0.0603237152f, 0.f),
    C_Vertex3f(0.503170967f, 0.0603237152f, -1.f),
    C_Normal3f(0.653523266f, -0.75690639f, 0.f),
    C_Vertex3f(0.490303993f, 0.047624588f, 0.f),
    C_Vertex3f(0.490303993f, 0.047624588f, -1.f),
    C_Normal3f(0.55191493f, -0.833900511f, 0.f),
    C_Vertex3f(0.476317406f, 0.0371379852f, 0.f),
    C_Vertex3f(0.476317406f, 0.0371379852f, -1.f),
    C_Normal3f(0.457255363f, -0.889335454f, 0.f),
    C_Vertex3f(0.4605546f, 0.0279350281f, 0.f),
    C_Vertex3f(0.4605546f, 0.0279350281f, -1.f),
    C_Normal3f(0.36732462f, -0.930092812f, 0.f),
    C_Vertex3f(0.443015575f, 0.0200157166f, 0.f),
    C_Vertex3f(0.443015575f, 0.0200157166f, -1.f),
    C_Normal3f(0.284422666f, -0.958698988f, 0.f),
    C_Vertex3f(0.423700333f, 0.0133800507f, 0.f),
    C_Vertex3f(0.423700333f, 0.0133800507f, -1.f),
    C_Normal3f(0.205696955f, -0.978615701f, 0.f),
    C_Vertex3f(0.402608871f, 0.0080280304f, 0.f),
    C_Vertex3f(0.402608871f, 0.0080280304f, -1.f),
    C_Normal3f(0.134434149f, -0.990922451f, 0.f),
    C_Vertex3f(0.379140854f, 0.0040140152f, 0.f),
    C_Vertex3f(0.379140854f, 0.0040140152f, -1.f),
    C_Normal3f(0.0740395114f, -0.997255385f, 0.f),
    C_Vertex3f(0.35329628f, 0.00133800507f, 0.f),
    C_Vertex3f(0.35329628f, 0.00133800507f, -1.f),
    C_Normal3f(-0.f, -1.f, 0.f),
    C_Vertex3f(0.32507515f, 0.f, 0.f),
    C_Vertex3f(0.32507515f, 0.f, -1.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.f, -1.f, 0.f),
    C_Vertex3f(0.32507515f, 0.f, 0.f),
    C_Vertex3f(0.32507515f, 0.f, -1.f),
    C_Vertex3f(0.0654296875f, 0.f, -1.f),
    C_Vertex3f(0.0654296875f, 0.f, 0.f),
    C_End(),
    C_Begin(GL_QUAD_STRIP),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.150390625f, 0.371582031f, 0.f),
    C_Vertex3f(0.150390625f, 0.371582031f, -1.f),
    C_Normal3f(-0.00146206818f, 0.999998927f, 0.f),
    C_Vertex3f(0.295811653f, 0.371582031f, 0.f),
    C_Vertex3f(0.295811653f, 0.371582031f, -1.f),
    C_Normal3f(-0.0276122596f, 0.999618709f, 0.f),
    C_Vertex3f(0.308893919f, 0.371813774f, 0.f),
    C_Vertex3f(0.308893919f, 0.371813774f, -1.f),
    C_Normal3f(-0.0499319769f, 0.998752594f, 0.f),
    C_Vertex3f(0.32098031f, 0.37227726f, 0.f),
    C_Vertex3f(0.32098031f, 0.37227726f, -1.f),
    C_Normal3f(-0.0763489679f, 0.99708122f, 0.f),
    C_Vertex3f(0.332070827f, 0.372972488f, 0.f),
    C_Vertex3f(0.332070827f, 0.372972488f, -1.f),
    C_Normal3f(-0.108030796f, 0.994147599f, 0.f),
    C_Vertex3f(0.34216547f, 0.37389946f, 0.f),
    C_Vertex3f(0.34216547f, 0.37389946f, -1.f),
    C_Normal3f(-0.146592394f, 0.989197016f, 0.f),
    C_Vertex3f(0.351264238f, 0.375058174f, 0.f),
    C_Vertex3f(0.351264238f, 0.375058174f, -1.f),
    C_Normal3f(-0.194297239f, 0.980942726f, 0.f),
    C_Vertex3f(0.359367132f, 0.376448631f, 0.f),
    C_Vertex3f(0.359367132f, 0.376448631f, -1.f),
    C_Normal3f(-0.261956841f, 0.965079546f, 0.f),
    C_Vertex3f(0.366474152f, 0.378070831f, 0.f),
    C_Vertex3f(0.366474152f, 0.378070831f, -1.f),
    C_Normal3f(-0.35850963f, 0.933526039f, 0.f),
    C_Vertex3f(0.377605438f, 0.381399155f, 0.f),
    C_Vertex3f(0.377605438f, 0.381399155f, -1.f),
    C_Normal3f(-0.478592545f, 0.878037214f, 0.f),
    C_Vertex3f(0.391765118f, 0.387783527f, 0.f),
    C_Vertex3f(0.391765118f, 0.387783527f, -1.f),
    C_Normal3f(-0.616899133f, 0.78704226f, 0.f),
    C_Vertex3f(0.403933048f, 0.395749569f, 0.f),
    C_Vertex3f(0.403933048f, 0.395749569f, -1.f),
    C_Normal3f(-0.747750759f, 0.66397953f, 0.f),
    C_Vertex3f(0.41410923f, 0.405297279f, 0.f),
    C_Vertex3f(0.41410923f, 0.405297279f, -1.f),
    C_Normal3f(-0.855641603f, 0.517568648f, 0.f),
    C_Vertex3f(0.422293663f, 0.416426659f, 0.f),
    C_Vertex3f(0.422293663f, 0.416426659f, -1.f),
    C_Normal3f(-0.932973266f, 0.359945714f, 0.f),
    C_Vertex3f(0.428431988f, 0.428975582f, 0.f),
    C_Vertex3f(0.428431988f, 0.428975582f, -1.f),
    C_Normal3f(-0.978831053f, 0.204669729f, 0.f),
    C_Vertex3f(0.432524204f, 0.44294405f, 0.f),
    C_Vertex3f(0.432524204f, 0.44294405f, -1.f),
    C_Normal3f(-0.997930765f, 0.06429708f, 0.f),
    C_Vertex3f(0.434570313f, 0.458332062f, 0.f),
    C_Vertex3f(0.434570313f, 0.458332062f, -1.f),
    C_Normal3f(-0.998149037f, -0.0608146004f, 0.f),
    C_Vertex3f(0.434570313f, 0.474700928f, 0.f),
    C_Vertex3f(0.434570313f, 0.474700928f, -1.f),
    C_Normal3f(-0.98103404f, -0.193835288f, 0.f),
    C_Vertex3f(0.43266058f, 0.489676476f, 0.f),
    C_Vertex3f(0.43266058f, 0.489676476f, -1.f),
    C_Normal3f(-0.943116248f, -0.332463175f, 0.f),
    C_Vertex3f(0.428841114f, 0.503697395f, 0.f),
    C_Vertex3f(0.428841114f, 0.503697395f, -1.f),
    C_Normal3f(-0.88322705f, -0.468945712f, 0.f),
    C_Vertex3f(0.423111916f, 0.516763687f, 0.f),
    C_Vertex3f(0.423111916f, 0.516763687f, -1.f),
    C_Normal3f(-0.796916008f, -0.604090095f, 0.f),
    C_Vertex3f(0.415472984f, 0.528875351f, 0.f),
    C_Vertex3f(0.415472984f, 0.528875351f, -1.f),
    C_Normal3f(-0.675509274f, -0.737351418f, 0.f),
    C_Vertex3f(0.406197071f, 0.539077759f, 0.f),
    C_Vertex3f(0.406197071f, 0.539077759f, -1.f),
    C_Normal3f(-0.53033185f, -0.847790122f, 0.f),
    C_Vertex3f(0.395284176f, 0.547370911f, 0.f),
    C_Vertex3f(0.395284176f, 0.547370911f, -1.f),
    C_Normal3f(-0.387234747f, -0.921981156f, 0.f),
    C_Vertex3f(0.382734299f, 0.553754807f, 0.f),
    C_Vertex3f(0.382734299f, 0.553754807f, -1.f),
    C_Normal3f(-0.269298673f, -0.963056684f, 0.f),
    C_Vertex3f(0.372094154f, 0.557110786f, 0.f),
    C_Vertex3f(0.372094154f, 0.557110786f, -1.f),
    C_Normal3f(-0.198051453f, -0.980191648f, 0.f),
    C_Vertex3f(0.363731861f, 0.559068441f, 0.f),
    C_Vertex3f(0.363731861f, 0.559068441f, -1.f),
    C_Normal3f(-0.148182079f, -0.988960087f, 0.f),
    C_Vertex3f(0.354100704f, 0.560746431f, 0.f),
    C_Vertex3f(0.354100704f, 0.560746431f, -1.f),
    C_Normal3f(-0.10846357f, -0.994100451f, 0.f),
    C_Vertex3f(0.343200684f, 0.562144756f, 0.f),
    C_Vertex3f(0.343200684f, 0.562144756f, -1.f),
    C_Normal3f(-0.0762286484f, -0.997090399f, 0.f),
    C_Vertex3f(0.331031799f, 0.563263416f, 0.f),
    C_Vertex3f(0.331031799f, 0.563263416f, -1.f),
    C_Normal3f(-0.0496228114f, -0.998767972f, 0.f),
    C_Vertex3f(0.317594051f, 0.564102411f, 0.f),
    C_Vertex3f(0.317594051f, 0.564102411f, -1.f),
    C_Normal3f(-0.0273345634f, -0.999626338f, 0.f),
    C_Vertex3f(0.30288744f, 0.564661741f, 0.f),
    C_Vertex3f(0.30288744f, 0.564661741f, -1.f),
    C_Normal3f(-0.f, -1.f, 0.f),
    C_Vertex3f(0.286911964f, 0.564941406f, 0.f),
    C_Vertex3f(0.286911964f, 0.564941406f, -1.f),
    C_End(),
    C_Begin(GL_QUADS),
    C_Normal3f(-0.f, -1.f, 0.f),
    C_Vertex3f(0.286911964f, 0.564941406f, 0.f),
    C_Vertex3f(0.286911964f, 0.564941406f, -1.f),
    C_Vertex3f(0.150390625f, 0.564941406f, -1.f),
    C_Vertex3f(0.150390625f, 0.564941406f, 0.f),
    C_Normal3f(1.f, 0.f, 0.f),
    C_Vertex3f(0.150390625f, 0.564941406f, 0.f),
    C_Vertex3f(0.150390625f, 0.564941406f, -1.f),
    C_Vertex3f(0.150390625f, 0.371582031f, -1.f),
    C_Vertex3f(0.150390625f, 0.371582031f, 0.f),
    C_End(),
    C_Begin(GL_QUAD_STRIP),
    C_Normal3f(-0.f, 1.f, 0.f),
    C_Vertex3f(0.150390625f, 0.0756835938f, 0.f),
    C_Vertex3f(0.150390625f, 0.0756835938f, -1.f),
    C_Normal3f(-0.00203977409f, 0.999997973f, 0.f),
    C_Vertex3f(0.320371628f, 0.0756835938f, 0.f),
    C_Vertex3f(0.320371628f, 0.0756835938f, -1.f),
    C_Normal3f(-0.0358958766f, 0.999355555f, 0.f),
    C_Vertex3f(0.337873459f, 0.0760660172f, 0.f),
    C_Vertex3f(0.337873459f, 0.0760660172f, -1.f),
    C_Normal3f(-0.0738703236f, 0.997267842f, 0.f),
    C_Vertex3f(0.352312088f, 0.076830864f, 0.f),
    C_Vertex3f(0.352312088f, 0.076830864f, -1.f),
    C_Normal3f(-0.139587745f, 0.990209639f, 0.f),
    C_Vertex3f(0.363687515f, 0.0779781342f, 0.f),
    C_Vertex3f(0.363687515f, 0.0779781342f, -1.f),
    C_Normal3f(-0.217983484f, 0.975952446f, 0.f),
    C_Vertex3f(0.375171661f, 0.0800533295f, 0.f),
    C_Vertex3f(0.375171661f, 0.0800533295f, -1.f),
    C_Normal3f(-0.292538524f, 0.956253767f, 0.f),
    C_Vertex3f(0.388625145