package dock

import (
	"reflect"

	"pkg.deepin.io/daemon/sync/infrastructure/utils"
	. "pkg.deepin.io/daemon/sync/modules/model"
)

type Data struct {
	Version     string                            `json:"version"`
	IconSize    uint32                            `json:"icon_size"`
	DisplayMode string                            `json:"display_mode"`
	HideMode    string                            `json:"hide_mode"`
	Position    string                            `json:"position"`
	DockedApps  []string                          `json:"docked_apps"`
	Plugins     map[string]map[string]interface{} `json:"plugins"`
}

const (
	Name = "dock"
)

func (core *Data) Name() string {
	return Name
}

func (core *Data) Model() interface{} {
	return &Data{}
}

func (core *Data) ToIFC(v interface{}) DataIFC {
	return v.(*Data)
}

func (core *Data) Equal(target DataIFC) bool {
	info := target.(*Data)
	return reflect.DeepEqual(core, info)
}

func (core *Data) GenCache(DataIFC) DataIFC {
	return core
}

func (core *Data) Merge(current, cache DataIFC) {
	curInfo := current.(*Data)
	cacheInfo := cache.(*Data)
	utils.MergeString(&core.DisplayMode, curInfo.DisplayMode, cacheInfo.DisplayMode)
	utils.MergeString(&core.HideMode, curInfo.HideMode, cacheInfo.HideMode)
	utils.MergeUint32(&core.IconSize, curInfo.IconSize, cacheInfo.IconSize)
	utils.MergeString(&core.Position, curInfo.Position, cacheInfo.Position)
	if !reflect.DeepEqual(curInfo.DockedApps, cacheInfo.DockedApps) {
		core.DockedApps = curInfo.DockedApps
	}
	if !reflect.DeepEqual(curInfo.Plugins, cacheInfo.Plugins) {
		core.Plugins = curInfo.Plugins
	}
}
