/*
 * file: .../tbl-tools/ptbl/ptbl.c - given a type table generated by snacc (-T option)
 *          ptbl prints the contents of the table to stdout.
 *
 *          This may be useful for debugging.
 *
 * Copyright (C) 1993 Michael Sample
 *            and the University of British Columbia
 *
 * $Header: /baseline/SNACC/tbl-tools/ptbl/ptbl.c,v 1.2 2003/12/17 19:05:04 gronej Exp $
 * $Log: ptbl.c,v $
 * Revision 1.2  2003/12/17 19:05:04  gronej
 * SNACC baseline merged with PER v1_7 tag
 *
 * Revision 1.1.2.1  2003/11/05 14:59:00  gronej
 * working PER code merged with esnacc_1_6
 *
 * Revision 1.1.1.1  2000/08/21 20:35:48  leonberp
 * First CVS Version of SNACC.
 *
 * Revision 1.1  1997/02/15 19:26:23  rj
 * first check-in
 *
 */

#include "tbl-incl.h"
#include "tbl-gen-c-hdr.h"

void Usage PARAMS ((prg),
    char *prg)
{
    fprintf (stderr,"Usage: %s [-a] <tbl-file>\n",prg);
    fprintf (stderr,"     -a means print in ASN.1 format instead of the table data structure\n\n");
    fprintf (stderr," ptbl reads the type table from tbl-file and prints");
    fprintf (stderr," its contents\n to stdout.");
    fprintf (stderr," The table files are generated with the snacc -T option.\n");
}

int
main PARAMS ((argc, argv),
    int argc _AND_
    char **argv)
{
    char *tblFileName;
    FILE *outputFile;
    int asn1Mode = FALSE;
    TBL *tbl;

    if ((argc != 2) && (argc != 3))
    {
        Usage (argv[0]);
        return 1;
    }

    /* danger - no error checking here */
    if (argc == 2)
        tblFileName = argv[1];
    else
    {
        asn1Mode = TRUE;
        tblFileName = argv[2];
    }

    outputFile = stdout;

    InitNibbleMem (1024,1024);

    tbl = LoadTblFile (tblFileName);

    if (tbl == NULL)
        return 1;  /* Load routine will have printed errs */

    if (asn1Mode)
        PrintTblInAsn1 (outputFile, tbl);
    else
        PrintTBL (outputFile, tbl, 0);

    return 0;
} /* main */
