/*
 * Copyright (C) 2016 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <gtk/gtk.h>
#include "glue.h"
#include "glue-gui-gtk.h"
#include "glue-gui-gtk-volt-div-knob.h"
#include "sig_integer.h"
#include "sig_manage.h"
#include "sig_std_logic.h"

typedef struct {
	GtkVBoxClass parent_class;

} GuiGtkVoltDivKnobClass;

enum{
	VALUE_CHANGED_GUI,
	GUI_GTK_VOLT_DIV_KNOB_LAST_SIGNAL
};

static guint gui_gtk_volt_div_knob_signals[GUI_GTK_VOLT_DIV_KNOB_LAST_SIGNAL] = { 0 };

static void
gui_gtk_volt_div_knob_class_init(GuiGtkVoltDivKnobClass *class)
{	
    gui_gtk_volt_div_knob_signals[VALUE_CHANGED_GUI] =
	g_signal_new("value-changed-gui",
		     G_TYPE_FROM_CLASS(class),
		     G_SIGNAL_RUN_FIRST | G_SIGNAL_ACTION, /* FIXME */
		     0, NULL, NULL,
		     g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);

}

static void
on_selection_changed(GtkComboBox *widget, void *_volt_div_knob)
{
	GuiGtkVoltDivKnob *volt_div_knob = _volt_div_knob;
	g_signal_emit(G_OBJECT(volt_div_knob),
			gui_gtk_volt_div_knob_signals[VALUE_CHANGED_GUI], 0);
	
}

static void
gui_gtk_volt_div_knob_init(GuiGtkVoltDivKnob *volt_div_knob)
{
}

#if 0
static void
gui_gtk_volt_div_knob_adj_sim(void *_volt_div_knob, int val)
{
	GuiGtkPotentiometer *potentiometer = _potentiometer;

	assert(0 <= val
		&& val <= 100);

	gtk_adjustment_set_value(potentiometer->adj, (gdouble) val);
	g_signal_emit_by_name(potentiometer->adj, "changed");
	
}
#endif /* wrong approach */


GType
gui_gtk_volt_div_knob_get_type(void)
{
	static GType ttt_type = 0;

	if (! ttt_type) {
		static const GTypeInfo ttt_info = {
			sizeof(GuiGtkVoltDivKnobClass),
			NULL,	/* base_init */
			NULL,	/* base_finalize */
			(GClassInitFunc) gui_gtk_volt_div_knob_class_init,
			NULL,	/* class_finalize */
			NULL,	/* class_data */
			sizeof(GuiGtkVoltDivKnob),
			0,	/* n_preallocs */
			(GInstanceInitFunc) gui_gtk_volt_div_knob_init,
		};

		ttt_type = g_type_register_static (GTK_TYPE_HBOX,
				"VoltDivKnob", &ttt_info, 0);
	}

	return ttt_type;
}

#define GUIGTKVOLTDIVKNOB_TYPE gui_gtk_volt_div_knob_get_type()

GtkWidget *
gui_gtk_volt_div_knob_new(const char *desc)
{
	GtkWidget *vbox;
	GuiGtkVoltDivKnob *volt_div_knob;
	GtkComboBoxText *combo_box;	
	int i;

	volt_div_knob = GUI_GTK_VOLT_DIV_KNOB(g_object_new(GUIGTKVOLTDIVKNOB_TYPE, NULL));
	
	vbox = gtk_vbox_new(FALSE, 1);
	
	volt_div_knob->label = gtk_label_new(desc);
	combo_box = GTK_COMBO_BOX_TEXT(gtk_combo_box_text_new());

	 g_signal_connect (combo_box,
                    "changed",
                    G_CALLBACK (on_selection_changed),
                    volt_div_knob);


	for(i = 1; i <= 10; i++){
		char buf[5];
		sprintf(buf, "%d", i*500);
		gtk_combo_box_text_append_text(GTK_COMBO_BOX_TEXT(combo_box), buf);
	}
	gtk_combo_box_set_active(GTK_COMBO_BOX(combo_box), 0);
	volt_div_knob->combo_box =GTK_WIDGET(combo_box);	

	gtk_box_pack_start(GTK_BOX(vbox), volt_div_knob->label, FALSE, FALSE, 1);
	gtk_box_pack_start(GTK_BOX(vbox), volt_div_knob->combo_box, FALSE, FALSE, 1);
	
	gtk_box_pack_start(GTK_BOX(volt_div_knob), vbox, FALSE, FALSE, 1);
	gtk_widget_show(volt_div_knob->label);
	gtk_widget_show(volt_div_knob->combo_box);
	gtk_widget_show(vbox);
	gtk_widget_show(GTK_WIDGET(volt_div_knob));	
	return GTK_WIDGET(volt_div_knob);
}
