/*
 * Copyright (C) 2006-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __SIG_PS2_MAIN_H_INCLUDED
#define __SIG_PS2_MAIN_H_INCLUDED

#include <inttypes.h>
#include "sig_gen.h"
#include "sig_std_logic.h"

struct sig_ps2_main_funcs {
	void (*recv)(void *s, uint8_t byte);
	void (*clkrunning)(void *s, /* unsigned */ int val);
};

struct sig_ps2_main {
	enum sig_gen_type type;
	struct {
		void *s;
		const struct sig_ps2_main_funcs *f;
	} member[2];
	unsigned int nmembers;
};

struct sig_ps2_main_merge {
        struct sig_ps2_main *s0;
	struct sig_ps2_main *s1;
};

extern int
sig_ps2_send(struct sig_ps2_main *b, void *s, uint8_t byte);

extern int
sig_ps2_clkrunning(struct sig_ps2_main *b, void *s, unsigned int val);

extern void
sig_ps2_main_connect(struct sig_ps2_main *b,
		void *s, const struct sig_ps2_main_funcs *f);

extern struct sig_ps2_main *
sig_ps2_main_create(const char *name);
extern void
sig_ps2_main_destroy(struct sig_ps2_main *sig);

extern void
sig_ps2_main_suspend(struct sig_ps2_main *b, FILE *fSig);
extern void
sig_ps2_main_resume(struct sig_ps2_main *b, FILE *fSig);

extern struct sig_ps2_main_merge *
sig_ps2_main_merge(struct sig_ps2_main *s0, struct sig_ps2_main *s1);
extern void
sig_ps2_main_split(struct sig_ps2_main_merge *m);

#endif /* __SIG_PS2_MAIN_H_INCLUDED */
