; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-linux-gnux32 -verify-machineinstrs | FileCheck %s

target datalayout = "e-m:e-p:32:32-i64:64-f80:128-n8:16:32:64-S128"
target triple = "x86_64-unknown-linux-gnux32"

; probe-stack + dynamic size alloca
define void @test1(i32 %size) nounwind #0 {
; CHECK-LABEL: test1:
; CHECK:       # %bb.0: # %start
; CHECK-NEXT:    pushq %rbp
; CHECK-NEXT:    movl %esp, %ebp
; CHECK-NEXT:    # kill: def $edi killed $edi def $rdi
; CHECK-NEXT:    leal 15(%rdi), %eax
; CHECK-NEXT:    andl $-16, %eax
; CHECK-NEXT:    callq __rust_probestack
; CHECK-NEXT:    subl %eax, %esp
start:
  %alloca = alloca i8, i32 %size
  unreachable
}

; probe-stack + no-stack-arg-probe + dynamic size alloca
define void @test2(i32 %size) nounwind #1 {
; CHECK-LABEL: test2:
; CHECK:       # %bb.0: # %start
; CHECK-NEXT:    pushq %rbp
; CHECK-NEXT:    movl %esp, %ebp
; CHECK-NEXT:    addl $15, %edi
; CHECK-NEXT:    andl $-16, %edi
; CHECK-NEXT:    subl %edi, %esp
start:
  %alloca = alloca i8, i32 %size
  unreachable
}

; probe-stack + fixed size alloca not in entry block
define void @test3() nounwind #0 {
; CHECK-LABEL: test3:
; CHECK:       # %bb.0: # %start
; CHECK-NEXT:    pushq %rbp
; CHECK-NEXT:    movl %esp, %ebp
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    subl $1992, %esp # imm = 0x7C8
start:
  br label %block

block:
  %alloca = alloca i8, i32 2000
  unreachable
}

attributes #0 = { "probe-stack"="__rust_probestack" }
attributes #1 = { "probe-stack"="__rust_probestack" "no-stack-arg-probe" }
