/* test-scores.c generated by valac 0.42.3, the Vala compiler
 * generated from test-scores.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright © 2014 Nikhar Agrawal
 * Copyright © 2016 Michael Catanzaro <mcatanzaro@gnome.org>
 *
 * This file is part of libgnome-games-support.
 *
 * libgnome-games-support is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * libgnome-games-support is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with libgnome-games-support.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "libgnome-games-support.h"
#include <gio/gio.h>
#include <gee.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block2Data Block2Data;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _Block3Data Block3Data;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Block1Data {
	int _ref_count_;
	GMainLoop* main_loop;
	GamesScoresContext* context;
};

struct _Block2Data {
	int _ref_count_;
	GamesScoresCategory* category;
};

struct _Block3Data {
	int _ref_count_;
	GamesScoresCategory* category;
};



GamesScoresCategory* games_scores_category_request (const gchar* category_key);
void games_scores_add_score_sync (GamesScoresContext* context,
                                  gint score,
                                  GamesScoresCategory* category);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda4_ (Block1Data* _data1_,
                 GObject* object,
                 GAsyncResult* _result_);
static void ___lambda4__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
void games_scores_create_scores (void);
static GamesScoresCategory* _games_scores_category_request_games_scores_context_category_request_func (const gchar* category_key,
                                                                                                gpointer self);
gchar* games_scores_get_test_directory_name (void);
gchar* games_scores_get_score_directory_name (void);
gchar* games_scores_get_score_filename_for_category (const gchar* category_name);
void games_scores_delete_scores (void);
void games_scores_test_scores_files_exist (void);
void games_scores_test_save_score_to_file (void);
void games_scores_test_import_from_score_directory (void);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static GamesScoresCategory* ___lambda5_ (Block2Data* _data2_,
                                  const gchar* key);
static GamesScoresCategory* ____lambda5__games_scores_context_category_request_func (const gchar* category_key,
                                                                              gpointer self);
static gchar* ___lambda6_ (const gchar* old_key);
static gchar* ____lambda6__games_scores_directory_importer_category_convert_func (const gchar* old_key,
                                                                           gpointer self);
void games_scores_test_import_from_history_file (void);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static GamesScoresCategory* ___lambda7_ (Block3Data* _data3_,
                                  const gchar* key);
static GamesScoresCategory* ____lambda7__games_scores_context_category_request_func (const gchar* category_key,
                                                                              gpointer self);
static void ___lambda8_ (Block3Data* _data3_,
                  const gchar* line,
                  GamesScoresScore* * score,
                  GamesScoresCategory* * out_category);
static void ____lambda8__games_scores_history_file_importer_history_convert_func (const gchar* line,
                                                                           GamesScoresScore* * score,
                                                                           GamesScoresCategory* * category,
                                                                           gpointer self);
void games_scores_test_import_from_nonexistent_history_file (void);
static GamesScoresCategory* __lambda9_ (const gchar* key);
static GamesScoresCategory* ___lambda9__games_scores_context_category_request_func (const gchar* category_key,
                                                                             gpointer self);
static void __lambda10_ (const gchar* line,
                  GamesScoresScore* * score,
                  GamesScoresCategory* * category);
static void ___lambda10__games_scores_history_file_importer_history_convert_func (const gchar* line,
                                                                           GamesScoresScore* * score,
                                                                           GamesScoresCategory* * category,
                                                                           gpointer self);
gint games_scores_main (gchar** args,
                        int args_length1);
static void __lambda11_ (void);
static void ___lambda11__gtest_fixture_func (void* fixture,
                                      gpointer self);
static void _games_scores_test_scores_files_exist_gtest_fixture_func (void* fixture,
                                                               gpointer self);
static void _games_scores_delete_scores_gtest_fixture_func (void* fixture,
                                                     gpointer self);
static void __lambda12_ (void);
static void ___lambda12__gtest_fixture_func (void* fixture,
                                      gpointer self);
static void _games_scores_test_save_score_to_file_gtest_fixture_func (void* fixture,
                                                               gpointer self);
static void __lambda13_ (void);
static void ___lambda13__gtest_fixture_func (void* fixture,
                                      gpointer self);
static void _games_scores_test_import_from_score_directory_gtest_fixture_func (void* fixture,
                                                                        gpointer self);
static void __lambda14_ (void);
static void ___lambda14__gtest_fixture_func (void* fixture,
                                      gpointer self);
static void _games_scores_test_import_from_history_file_gtest_fixture_func (void* fixture,
                                                                     gpointer self);
static void __lambda15_ (void);
static void ___lambda15__gtest_fixture_func (void* fixture,
                                      gpointer self);
static void _games_scores_test_import_from_nonexistent_history_file_gtest_fixture_func (void* fixture,
                                                                                 gpointer self);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GamesScoresCategory*
games_scores_category_request (const gchar* category_key)
{
	GamesScoresCategory* result = NULL;
	GamesScoresCategory* _tmp0_;
#line 25 "test-scores.vala"
	g_return_val_if_fail (category_key != NULL, NULL);
#line 28 "test-scores.vala"
	_tmp0_ = games_scores_category_new (category_key, category_key);
#line 28 "test-scores.vala"
	result = _tmp0_;
#line 28 "test-scores.vala"
	return result;
#line 174 "test-scores.c"
}


static gpointer
_g_object_ref0 (gpointer self)
{
#line 31 "test-scores.vala"
	return self ? g_object_ref (self) : NULL;
#line 183 "test-scores.c"
}


static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
#line 31 "test-scores.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 31 "test-scores.vala"
	return _data1_;
#line 194 "test-scores.c"
}


static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 31 "test-scores.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 31 "test-scores.vala"
		_g_main_loop_unref0 (_data1_->main_loop);
#line 31 "test-scores.vala"
		_g_object_unref0 (_data1_->context);
#line 31 "test-scores.vala"
		g_slice_free (Block1Data, _data1_);
#line 211 "test-scores.c"
	}
}


static void
__lambda4_ (Block1Data* _data1_,
            GObject* object,
            GAsyncResult* _result_)
{
	GError * _inner_error_ = NULL;
#line 33 "test-scores.vala"
	g_return_if_fail (_result_ != NULL);
#line 224 "test-scores.c"
	{
		gboolean _tmp0_ = FALSE;
#line 36 "test-scores.vala"
		_tmp0_ = games_scores_context_add_score_finish (_data1_->context, _result_, &_inner_error_);
#line 36 "test-scores.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 231 "test-scores.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
#line 34 "test-scores.vala"
		e = _inner_error_;
#line 34 "test-scores.vala"
		_inner_error_ = NULL;
#line 40 "test-scores.vala"
		g_assert_not_reached ();
#line 34 "test-scores.vala"
		_g_error_free0 (e);
#line 247 "test-scores.c"
	}
	__finally0:
#line 34 "test-scores.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 34 "test-scores.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 34 "test-scores.vala"
		g_clear_error (&_inner_error_);
#line 34 "test-scores.vala"
		return;
#line 258 "test-scores.c"
	}
#line 42 "test-scores.vala"
	g_main_loop_quit (_data1_->main_loop);
#line 262 "test-scores.c"
}


static void
___lambda4__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
#line 33 "test-scores.vala"
	__lambda4_ (self, source_object, res);
#line 33 "test-scores.vala"
	block1_data_unref (self);
#line 275 "test-scores.c"
}


void
games_scores_add_score_sync (GamesScoresContext* context,
                             gint score,
                             GamesScoresCategory* category)
{
	Block1Data* _data1_;
	GamesScoresContext* _tmp0_;
	GMainContext* _tmp1_;
	GMainLoop* _tmp2_;
#line 31 "test-scores.vala"
	g_return_if_fail (context != NULL);
#line 31 "test-scores.vala"
	g_return_if_fail (category != NULL);
#line 31 "test-scores.vala"
	_data1_ = g_slice_new0 (Block1Data);
#line 31 "test-scores.vala"
	_data1_->_ref_count_ = 1;
#line 31 "test-scores.vala"
	_tmp0_ = _g_object_ref0 (context);
#line 31 "test-scores.vala"
	_g_object_unref0 (_data1_->context);
#line 31 "test-scores.vala"
	_data1_->context = _tmp0_;
#line 32 "test-scores.vala"
	_tmp1_ = g_main_context_default ();
#line 32 "test-scores.vala"
	_tmp2_ = g_main_loop_new (_tmp1_, FALSE);
#line 32 "test-scores.vala"
	_data1_->main_loop = _tmp2_;
#line 33 "test-scores.vala"
	games_scores_context_add_score (_data1_->context, (glong) score, category, NULL, ___lambda4__gasync_ready_callback, block1_data_ref (_data1_));
#line 44 "test-scores.vala"
	g_main_loop_run (_data1_->main_loop);
#line 31 "test-scores.vala"
	block1_data_unref (_data1_);
#line 31 "test-scores.vala"
	_data1_ = NULL;
#line 316 "test-scores.c"
}


static GamesScoresCategory*
_games_scores_category_request_games_scores_context_category_request_func (const gchar* category_key,
                                                                           gpointer self)
{
	GamesScoresCategory* result;
	result = games_scores_category_request (category_key);
#line 49 "test-scores.vala"
	return result;
#line 328 "test-scores.c"
}


void
games_scores_create_scores (void)
{
	GamesScoresContext* context = NULL;
	GamesScoresContext* _tmp0_;
	GamesScoresCategory* cat = NULL;
	GamesScoresCategory* _tmp1_;
#line 49 "test-scores.vala"
	_tmp0_ = games_scores_context_new ("libgnome-games-support-test", "Games Type", NULL, _games_scores_category_request_games_scores_context_category_request_func, NULL, GAMES_SCORES_STYLE_POINTS_GREATER_IS_BETTER);
#line 49 "test-scores.vala"
	context = _tmp0_;
#line 50 "test-scores.vala"
	_tmp1_ = games_scores_category_new ("cat1", "cat1");
#line 50 "test-scores.vala"
	cat = _tmp1_;
#line 51 "test-scores.vala"
	games_scores_add_score_sync (context, 101, cat);
#line 52 "test-scores.vala"
	games_scores_add_score_sync (context, 102, cat);
#line 54 "test-scores.vala"
	games_scores_category_set_key (cat, "cat2");
#line 55 "test-scores.vala"
	games_scores_category_set_name (cat, "cat2");
#line 56 "test-scores.vala"
	games_scores_add_score_sync (context, 21, cat);
#line 57 "test-scores.vala"
	games_scores_add_score_sync (context, 24, cat);
#line 47 "test-scores.vala"
	_g_object_unref0 (cat);
#line 47 "test-scores.vala"
	_g_object_unref0 (context);
#line 363 "test-scores.c"
}


gchar*
games_scores_get_test_directory_name (void)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 62 "test-scores.vala"
	_tmp0_ = g_get_user_data_dir ();
#line 62 "test-scores.vala"
	_tmp1_ = g_build_filename (_tmp0_, "libgnome-games-support-test", NULL, NULL);
#line 62 "test-scores.vala"
	result = _tmp1_;
#line 62 "test-scores.vala"
	return result;
#line 381 "test-scores.c"
}


gchar*
games_scores_get_score_directory_name (void)
{
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
#line 67 "test-scores.vala"
	_tmp0_ = games_scores_get_test_directory_name ();
#line 67 "test-scores.vala"
	_tmp1_ = _tmp0_;
#line 67 "test-scores.vala"
	_tmp2_ = g_build_filename (_tmp1_, "scores", NULL, NULL);
#line 67 "test-scores.vala"
	_tmp3_ = _tmp2_;
#line 67 "test-scores.vala"
	_g_free0 (_tmp1_);
#line 67 "test-scores.vala"
	result = _tmp3_;
#line 67 "test-scores.vala"
	return result;
#line 407 "test-scores.c"
}


gchar*
games_scores_get_score_filename_for_category (const gchar* category_name)
{
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
#line 70 "test-scores.vala"
	g_return_val_if_fail (category_name != NULL, NULL);
#line 72 "test-scores.vala"
	_tmp0_ = games_scores_get_score_directory_name ();
#line 72 "test-scores.vala"
	_tmp1_ = _tmp0_;
#line 72 "test-scores.vala"
	_tmp2_ = g_build_filename (_tmp1_, category_name, NULL);
#line 72 "test-scores.vala"
	_tmp3_ = _tmp2_;
#line 72 "test-scores.vala"
	_g_free0 (_tmp1_);
#line 72 "test-scores.vala"
	result = _tmp3_;
#line 72 "test-scores.vala"
	return result;
#line 435 "test-scores.c"
}


void
games_scores_delete_scores (void)
{
	GError * _inner_error_ = NULL;
	{
		GFile* directory = NULL;
		gchar* _tmp0_;
		gchar* _tmp1_;
		GFile* _tmp2_;
		GFile* _tmp3_;
		GFile* _tmp4_;
		GFile* parent_directory = NULL;
		gchar* _tmp20_;
		gchar* _tmp21_;
		GFile* _tmp22_;
		GFile* _tmp23_;
		GFile* _tmp24_;
#line 79 "test-scores.vala"
		_tmp0_ = games_scores_get_score_directory_name ();
#line 79 "test-scores.vala"
		_tmp1_ = _tmp0_;
#line 79 "test-scores.vala"
		_tmp2_ = g_file_new_for_path (_tmp1_);
#line 79 "test-scores.vala"
		_tmp3_ = _tmp2_;
#line 79 "test-scores.vala"
		_g_free0 (_tmp1_);
#line 79 "test-scores.vala"
		directory = _tmp3_;
#line 80 "test-scores.vala"
		_tmp4_ = directory;
#line 80 "test-scores.vala"
		if (g_file_query_exists (_tmp4_, NULL)) {
#line 472 "test-scores.c"
			GFileEnumerator* enumerator = NULL;
			GFile* _tmp5_;
			GFileEnumerator* _tmp6_;
			GFileInfo* file_info = NULL;
			GFile* _tmp19_;
#line 82 "test-scores.vala"
			_tmp5_ = directory;
#line 82 "test-scores.vala"
			_tmp6_ = g_file_enumerate_children (_tmp5_, G_FILE_ATTRIBUTE_STANDARD_NAME, 0, NULL, &_inner_error_);
#line 82 "test-scores.vala"
			enumerator = _tmp6_;
#line 82 "test-scores.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 82 "test-scores.vala"
				_g_object_unref0 (directory);
#line 488 "test-scores.c"
				goto __catch1_g_error;
			}
#line 84 "test-scores.vala"
			while (TRUE) {
#line 493 "test-scores.c"
				GFileInfo* _tmp7_ = NULL;
				GFileEnumerator* _tmp8_;
				GFileInfo* _tmp9_;
				GFileInfo* _tmp10_;
				GFileInfo* _tmp11_;
				gchar* file_name = NULL;
				GFileInfo* _tmp12_;
				const gchar* _tmp13_;
				gchar* _tmp14_;
				GFile* file = NULL;
				GFile* _tmp15_;
				const gchar* _tmp16_;
				GFile* _tmp17_;
				GFile* _tmp18_;
#line 84 "test-scores.vala"
				_tmp8_ = enumerator;
#line 84 "test-scores.vala"
				_tmp9_ = g_file_enumerator_next_file (_tmp8_, NULL, &_inner_error_);
#line 84 "test-scores.vala"
				_tmp7_ = _tmp9_;
#line 84 "test-scores.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 84 "test-scores.vala"
					_g_object_unref0 (file_info);
#line 84 "test-scores.vala"
					_g_object_unref0 (enumerator);
#line 84 "test-scores.vala"
					_g_object_unref0 (directory);
#line 522 "test-scores.c"
					goto __catch1_g_error;
				}
#line 84 "test-scores.vala"
				_tmp10_ = _tmp7_;
#line 84 "test-scores.vala"
				_tmp7_ = NULL;
#line 84 "test-scores.vala"
				_g_object_unref0 (file_info);
#line 84 "test-scores.vala"
				file_info = _tmp10_;
#line 84 "test-scores.vala"
				_tmp11_ = file_info;
#line 84 "test-scores.vala"
				if (!(_tmp11_ != NULL)) {
#line 84 "test-scores.vala"
					_g_object_unref0 (_tmp7_);
#line 84 "test-scores.vala"
					break;
#line 541 "test-scores.c"
				}
#line 86 "test-scores.vala"
				_tmp12_ = file_info;
#line 86 "test-scores.vala"
				_tmp13_ = g_file_info_get_name (_tmp12_);
#line 86 "test-scores.vala"
				_tmp14_ = g_strdup (_tmp13_);
#line 86 "test-scores.vala"
				file_name = _tmp14_;
#line 87 "test-scores.vala"
				_tmp15_ = directory;
#line 87 "test-scores.vala"
				_tmp16_ = file_name;
#line 87 "test-scores.vala"
				_tmp17_ = g_file_get_child (_tmp15_, _tmp16_);
#line 87 "test-scores.vala"
				file = _tmp17_;
#line 88 "test-scores.vala"
				_tmp18_ = file;
#line 88 "test-scores.vala"
				g_file_delete (_tmp18_, NULL, &_inner_error_);
#line 88 "test-scores.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 88 "test-scores.vala"
					_g_object_unref0 (file);
#line 88 "test-scores.vala"
					_g_free0 (file_name);
#line 88 "test-scores.vala"
					_g_object_unref0 (_tmp7_);
#line 88 "test-scores.vala"
					_g_object_unref0 (file_info);
#line 88 "test-scores.vala"
					_g_object_unref0 (enumerator);
#line 88 "test-scores.vala"
					_g_object_unref0 (directory);
#line 577 "test-scores.c"
					goto __catch1_g_error;
				}
#line 84 "test-scores.vala"
				_g_object_unref0 (file);
#line 84 "test-scores.vala"
				_g_free0 (file_name);
#line 84 "test-scores.vala"
				_g_object_unref0 (_tmp7_);
#line 586 "test-scores.c"
			}
#line 90 "test-scores.vala"
			_tmp19_ = directory;
#line 90 "test-scores.vala"
			g_file_delete (_tmp19_, NULL, &_inner_error_);
#line 90 "test-scores.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 90 "test-scores.vala"
				_g_object_unref0 (file_info);
#line 90 "test-scores.vala"
				_g_object_unref0 (enumerator);
#line 90 "test-scores.vala"
				_g_object_unref0 (directory);
#line 600 "test-scores.c"
				goto __catch1_g_error;
			}
#line 80 "test-scores.vala"
			_g_object_unref0 (file_info);
#line 80 "test-scores.vala"
			_g_object_unref0 (enumerator);
#line 607 "test-scores.c"
		}
#line 93 "test-scores.vala"
		_tmp20_ = games_scores_get_test_directory_name ();
#line 93 "test-scores.vala"
		_tmp21_ = _tmp20_;
#line 93 "test-scores.vala"
		_tmp22_ = g_file_new_for_path (_tmp21_);
#line 93 "test-scores.vala"
		_tmp23_ = _tmp22_;
#line 93 "test-scores.vala"
		_g_free0 (_tmp21_);
#line 93 "test-scores.vala"
		parent_directory = _tmp23_;
#line 94 "test-scores.vala"
		_tmp24_ = parent_directory;
#line 94 "test-scores.vala"
		if (g_file_query_exists (_tmp24_, NULL)) {
#line 625 "test-scores.c"
			GFile* _tmp25_;
#line 95 "test-scores.vala"
			_tmp25_ = parent_directory;
#line 95 "test-scores.vala"
			g_file_delete (_tmp25_, NULL, &_inner_error_);
#line 95 "test-scores.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 95 "test-scores.vala"
				_g_object_unref0 (parent_directory);
#line 95 "test-scores.vala"
				_g_object_unref0 (directory);
#line 637 "test-scores.c"
				goto __catch1_g_error;
			}
		}
#line 77 "test-scores.vala"
		_g_object_unref0 (parent_directory);
#line 77 "test-scores.vala"
		_g_object_unref0 (directory);
#line 645 "test-scores.c"
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp26_;
#line 77 "test-scores.vala"
		e = _inner_error_;
#line 77 "test-scores.vala"
		_inner_error_ = NULL;
#line 99 "test-scores.vala"
		_tmp26_ = e->message;
#line 99 "test-scores.vala"
		g_error ("test-scores.vala:99: %s", _tmp26_);
#line 77 "test-scores.vala"
		_g_error_free0 (e);
#line 662 "test-scores.c"
	}
	__finally1:
#line 77 "test-scores.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 77 "test-scores.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 77 "test-scores.vala"
		g_clear_error (&_inner_error_);
#line 77 "test-scores.vala"
		return;
#line 673 "test-scores.c"
	}
}


void
games_scores_test_scores_files_exist (void)
{
	gchar* filename = NULL;
	gchar* _tmp0_;
	GFile* file = NULL;
	const gchar* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
#line 105 "test-scores.vala"
	games_scores_create_scores ();
#line 107 "test-scores.vala"
	_tmp0_ = games_scores_get_score_filename_for_category ("cat1");
#line 107 "test-scores.vala"
	filename = _tmp0_;
#line 108 "test-scores.vala"
	_tmp1_ = filename;
#line 108 "test-scores.vala"
	_tmp2_ = g_file_new_for_path (_tmp1_);
#line 108 "test-scores.vala"
	file = _tmp2_;
#line 109 "test-scores.vala"
	_tmp3_ = file;
#line 109 "test-scores.vala"
	_vala_assert (g_file_query_exists (_tmp3_, NULL), "file.query_exists ()");
#line 111 "test-scores.vala"
	_tmp4_ = games_scores_get_score_filename_for_category ("cat2");
#line 111 "test-scores.vala"
	_g_free0 (filename);
#line 111 "test-scores.vala"
	filename = _tmp4_;
#line 112 "test-scores.vala"
	_tmp5_ = filename;
#line 112 "test-scores.vala"
	_tmp6_ = g_file_new_for_path (_tmp5_);
#line 112 "test-scores.vala"
	_g_object_unref0 (file);
#line 112 "test-scores.vala"
	file = _tmp6_;
#line 113 "test-scores.vala"
	_tmp7_ = file;
#line 113 "test-scores.vala"
	_vala_assert (g_file_query_exists (_tmp7_, NULL), "file.query_exists ()");
#line 103 "test-scores.vala"
	_g_object_unref0 (file);
#line 103 "test-scores.vala"
	_g_free0 (filename);
#line 729 "test-scores.c"
}


void
games_scores_test_save_score_to_file (void)
{
	GError * _inner_error_ = NULL;
	{
		gchar* filename = NULL;
		gchar* _tmp0_;
		GFile* file = NULL;
		const gchar* _tmp1_;
		GFile* _tmp2_;
		GFileInputStream* _tmp3_ = NULL;
		GFile* _tmp4_;
		GFileInputStream* _tmp5_;
		GDataInputStream* dis = NULL;
		GDataInputStream* _tmp6_;
		gchar* line = NULL;
		gchar* _tmp7_ = NULL;
		GDataInputStream* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		const gchar* _tmp11_;
		gchar** tokens = NULL;
		const gchar* _tmp12_;
		gchar** _tmp13_;
		gchar** _tmp14_;
		gint tokens_length1;
		gint _tokens_size_;
		gchar** _tmp15_;
		gint _tmp15__length1;
		gchar** _tmp16_;
		gint _tmp16__length1;
		const gchar* _tmp17_;
		gchar* _tmp18_ = NULL;
		GDataInputStream* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		gchar** _tmp24_;
		gchar** _tmp25_;
		gchar** _tmp26_;
		gint _tmp26__length1;
		gchar** _tmp27_;
		gint _tmp27__length1;
		const gchar* _tmp28_;
		gchar* _tmp29_ = NULL;
		GDataInputStream* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		const gchar* _tmp33_;
		gchar* _tmp34_;
		const gchar* _tmp35_;
		GFile* _tmp36_;
		GFileInputStream* _tmp37_ = NULL;
		GFile* _tmp38_;
		GFileInputStream* _tmp39_;
		GDataInputStream* _tmp40_;
		gchar* _tmp41_ = NULL;
		GDataInputStream* _tmp42_;
		gchar* _tmp43_;
		gchar* _tmp44_;
		const gchar* _tmp45_;
		const gchar* _tmp46_;
		gchar** _tmp47_;
		gchar** _tmp48_;
		gchar** _tmp49_;
		gint _tmp49__length1;
		gchar** _tmp50_;
		gint _tmp50__length1;
		const gchar* _tmp51_;
		gchar* _tmp52_ = NULL;
		GDataInputStream* _tmp53_;
		gchar* _tmp54_;
		gchar* _tmp55_;
		const gchar* _tmp56_;
		const gchar* _tmp57_;
		gchar** _tmp58_;
		gchar** _tmp59_;
		gchar** _tmp60_;
		gint _tmp60__length1;
		gchar** _tmp61_;
		gint _tmp61__length1;
		const gchar* _tmp62_;
		gchar* _tmp63_ = NULL;
		GDataInputStream* _tmp64_;
		gchar* _tmp65_;
		gchar* _tmp66_;
		const gchar* _tmp67_;
#line 120 "test-scores.vala"
		games_scores_create_scores ();
#line 121 "test-scores.vala"
		_tmp0_ = games_scores_get_score_filename_for_category ("cat1");
#line 121 "test-scores.vala"
		filename = _tmp0_;
#line 122 "test-scores.vala"
		_tmp1_ = filename;
#line 122 "test-scores.vala"
		_tmp2_ = g_file_new_for_path (_tmp1_);
#line 122 "test-scores.vala"
		file = _tmp2_;
#line 123 "test-scores.vala"
		_tmp4_ = file;
#line 123 "test-scores.vala"
		_tmp5_ = g_file_read (_tmp4_, NULL, &_inner_error_);
#line 123 "test-scores.vala"
		_tmp3_ = _tmp5_;
#line 123 "test-scores.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 123 "test-scores.vala"
			_g_object_unref0 (file);
#line 123 "test-scores.vala"
			_g_free0 (filename);
#line 845 "test-scores.c"
			goto __catch2_g_error;
		}
#line 123 "test-scores.vala"
		_tmp6_ = g_data_input_stream_new ((GInputStream*) _tmp3_);
#line 123 "test-scores.vala"
		dis = _tmp6_;
#line 126 "test-scores.vala"
		_tmp8_ = dis;
#line 126 "test-scores.vala"
		_tmp9_ = g_data_input_stream_read_line (_tmp8_, NULL, NULL, &_inner_error_);
#line 126 "test-scores.vala"
		_tmp7_ = _tmp9_;
#line 126 "test-scores.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 126 "test-scores.vala"
			_g_free0 (line);
#line 126 "test-scores.vala"
			_g_object_unref0 (dis);
#line 126 "test-scores.vala"
			_g_object_unref0 (_tmp3_);
#line 126 "test-scores.vala"
			_g_object_unref0 (file);
#line 126 "test-scores.vala"
			_g_free0 (filename);
#line 870 "test-scores.c"
			goto __catch2_g_error;
		}
#line 126 "test-scores.vala"
		_tmp10_ = _tmp7_;
#line 126 "test-scores.vala"
		_tmp7_ = NULL;
#line 126 "test-scores.vala"
		_g_free0 (line);
#line 126 "test-scores.vala"
		line = _tmp10_;
#line 126 "test-scores.vala"
		_tmp11_ = line;
#line 126 "test-scores.vala"
		_vala_assert (_tmp11_ != NULL, "(line = dis.read_line (null)) != null");
#line 128 "test-scores.vala"
		_tmp12_ = line;
#line 128 "test-scores.vala"
		_tmp14_ = _tmp13_ = g_strsplit (_tmp12_, " ", 3);
#line 128 "test-scores.vala"
		tokens = _tmp14_;
#line 128 "test-scores.vala"
		tokens_length1 = _vala_array_length (_tmp13_);
#line 128 "test-scores.vala"
		_tokens_size_ = tokens_length1;
#line 129 "test-scores.vala"
		_tmp15_ = tokens;
#line 129 "test-scores.vala"
		_tmp15__length1 = tokens_length1;
#line 129 "test-scores.vala"
		_vala_assert (_tmp15__length1 == 3, "tokens.length == 3");
#line 130 "test-scores.vala"
		_tmp16_ = tokens;
#line 130 "test-scores.vala"
		_tmp16__length1 = tokens_length1;
#line 130 "test-scores.vala"
		_tmp17_ = _tmp16_[0];
#line 130 "test-scores.vala"
		_vala_assert (g_strcmp0 (_tmp17_, "101") == 0, "tokens[0] == \"101\"");
#line 131 "test-scores.vala"
		_tmp19_ = dis;
#line 131 "test-scores.vala"
		_tmp20_ = g_data_input_stream_read_line (_tmp19_, NULL, NULL, &_inner_error_);
#line 131 "test-scores.vala"
		_tmp18_ = _tmp20_;
#line 131 "test-scores.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 131 "test-scores.vala"
			tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 131 "test-scores.vala"
			_g_free0 (_tmp7_);
#line 131 "test-scores.vala"
			_g_free0 (line);
#line 131 "test-scores.vala"
			_g_object_unref0 (dis);
#line 131 "test-scores.vala"
			_g_object_unref0 (_tmp3_);
#line 131 "test-scores.vala"
			_g_object_unref0 (file);
#line 131 "test-scores.vala"
			_g_free0 (filename);
#line 931 "test-scores.c"
			goto __catch2_g_error;
		}
#line 131 "test-scores.vala"
		_tmp21_ = _tmp18_;
#line 131 "test-scores.vala"
		_tmp18_ = NULL;
#line 131 "test-scores.vala"
		_g_free0 (line);
#line 131 "test-scores.vala"
		line = _tmp21_;
#line 131 "test-scores.vala"
		_tmp22_ = line;
#line 131 "test-scores.vala"
		_vala_assert (_tmp22_ != NULL, "(line = dis.read_line (null)) != null");
#line 133 "test-scores.vala"
		_tmp23_ = line;
#line 133 "test-scores.vala"
		_tmp25_ = _tmp24_ = g_strsplit (_tmp23_, " ", 3);
#line 133 "test-scores.vala"
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 133 "test-scores.vala"
		tokens = _tmp25_;
#line 133 "test-scores.vala"
		tokens_length1 = _vala_array_length (_tmp24_);
#line 133 "test-scores.vala"
		_tokens_size_ = tokens_length1;
#line 134 "test-scores.vala"
		_tmp26_ = tokens;
#line 134 "test-scores.vala"
		_tmp26__length1 = tokens_length1;
#line 134 "test-scores.vala"
		_vala_assert (_tmp26__length1 == 3, "tokens.length == 3");
#line 135 "test-scores.vala"
		_tmp27_ = tokens;
#line 135 "test-scores.vala"
		_tmp27__length1 = tokens_length1;
#line 135 "test-scores.vala"
		_tmp28_ = _tmp27_[0];
#line 135 "test-scores.vala"
		_vala_assert (g_strcmp0 (_tmp28_, "102") == 0, "tokens[0] == \"102\"");
#line 136 "test-scores.vala"
		_tmp30_ = dis;
#line 136 "test-scores.vala"
		_tmp31_ = g_data_input_stream_read_line (_tmp30_, NULL, NULL, &_inner_error_);
#line 136 "test-scores.vala"
		_tmp29_ = _tmp31_;
#line 136 "test-scores.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 136 "test-scores.vala"
			_g_free0 (_tmp18_);
#line 136 "test-scores.vala"
			tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 136 "test-scores.vala"
			_g_free0 (_tmp7_);
#line 136 "test-scores.vala"
			_g_free0 (line);
#line 136 "test-scores.vala"
			_g_object_unref0 (dis);
#line 136 "test-scores.vala"
			_g_object_unref0 (_tmp3_);
#line 136 "test-scores.vala"
			_g_object_unref0 (file);
#line 136 "test-scores.vala"
			_g_free0 (filename);
#line 996 "test-scores.c"
			goto __catch2_g_error;
		}
#line 136 "test-scores.vala"
		_tmp32_ = _tmp29_;
#line 136 "test-scores.vala"
		_tmp29_ = NULL;
#line 136 "test-scores.vala"
		_g_free0 (line);
#line 136 "test-scores.vala"
		line = _tmp32_;
#line 136 "test-scores.vala"
		_tmp33_ = line;
#line 136 "test-scores.vala"
		_vala_assert (_tmp33_ == NULL, "(line = dis.read_line (null)) == null");
#line 138 "test-scores.vala"
		_tmp34_ = games_scores_get_score_filename_for_category ("cat2");
#line 138 "test-scores.vala"
		_g_free0 (filename);
#line 138 "test-scores.vala"
		filename = _tmp34_;
#line 139 "test-scores.vala"
		_tmp35_ = filename;
#line 139 "test-scores.vala"
		_tmp36_ = g_file_new_for_path (_tmp35_);
#line 139 "test-scores.vala"
		_g_object_unref0 (file);
#line 139 "test-scores.vala"
		file = _tmp36_;
#line 140 "test-scores.vala"
		_tmp38_ = file;
#line 140 "test-scores.vala"
		_tmp39_ = g_file_read (_tmp38_, NULL, &_inner_error_);
#line 140 "test-scores.vala"
		_tmp37_ = _tmp39_;
#line 140 "test-scores.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 140 "test-scores.vala"
			_g_free0 (_tmp29_);
#line 140 "test-scores.vala"
			_g_free0 (_tmp18_);
#line 140 "test-scores.vala"
			tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 140 "test-scores.vala"
			_g_free0 (_tmp7_);
#line 140 "test-scores.vala"
			_g_free0 (line);
#line 140 "test-scores.vala"
			_g_object_unref0 (dis);
#line 140 "test-scores.vala"
			_g_object_unref0 (_tmp3_);
#line 140 "test-scores.vala"
			_g_object_unref0 (file);
#line 140 "test-scores.vala"
			_g_free0 (filename);
#line 1051 "test-scores.c"
			goto __catch2_g_error;
		}
#line 140 "test-scores.vala"
		_tmp40_ = g_data_input_stream_new ((GInputStream*) _tmp37_);
#line 140 "test-scores.vala"
		_g_object_unref0 (dis);
#line 140 "test-scores.vala"
		dis = _tmp40_;
#line 141 "test-scores.vala"
		_tmp42_ = dis;
#line 141 "test-scores.vala"
		_tmp43_ = g_data_input_stream_read_line (_tmp42_, NULL, NULL, &_inner_error_);
#line 141 "test-scores.vala"
		_tmp41_ = _tmp43_;
#line 141 "test-scores.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 141 "test-scores.vala"
			_g_object_unref0 (_tmp37_);
#line 141 "test-scores.vala"
			_g_free0 (_tmp29_);
#line 141 "test-scores.vala"
			_g_free0 (_tmp18_);
#line 141 "test-scores.vala"
			tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 141 "test-scores.vala"
			_g_free0 (_tmp7_);
#line 141 "test-scores.vala"
			_g_free0 (line);
#line 141 "test-scores.vala"
			_g_object_unref0 (dis);
#line 141 "test-scores.vala"
			_g_object_unref0 (_tmp3_);
#line 141 "test-scores.vala"
			_g_object_unref0 (file);
#line 141 "test-scores.vala"
			_g_free0 (filename);
#line 1088 "test-scores.c"
			goto __catch2_g_error;
		}
#line 141 "test-scores.vala"
		_tmp44_ = _tmp41_;
#line 141 "test-scores.vala"
		_tmp41_ = NULL;
#line 141 "test-scores.vala"
		_g_free0 (line);
#line 141 "test-scores.vala"
		line = _tmp44_;
#line 141 "test-scores.vala"
		_tmp45_ = line;
#line 141 "test-scores.vala"
		_vala_assert (_tmp45_ != NULL, "(line = dis.read_line (null)) != null");
#line 143 "test-scores.vala"
		_tmp46_ = line;
#line 143 "test-scores.vala"
		_tmp48_ = _tmp47_ = g_strsplit (_tmp46_, " ", 3);
#line 143 "test-scores.vala"
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 143 "test-scores.vala"
		tokens = _tmp48_;
#line 143 "test-scores.vala"
		tokens_length1 = _vala_array_length (_tmp47_);
#line 143 "test-scores.vala"
		_tokens_size_ = tokens_length1;
#line 144 "test-scores.vala"
		_tmp49_ = tokens;
#line 144 "test-scores.vala"
		_tmp49__length1 = tokens_length1;
#line 144 "test-scores.vala"
		_vala_assert (_tmp49__length1 == 3, "tokens.length == 3");
#line 145 "test-scores.vala"
		_tmp50_ = tokens;
#line 145 "test-scores.vala"
		_tmp50__length1 = tokens_length1;
#line 145 "test-scores.vala"
		_tmp51_ = _tmp50_[0];
#line 145 "test-scores.vala"
		_vala_assert (g_strcmp0 (_tmp51_, "21") == 0, "tokens[0] == \"21\"");
#line 146 "test-scores.vala"
		_tmp53_ = dis;
#line 146 "test-scores.vala"
		_tmp54_ = g_data_input_stream_read_line (_tmp53_, NULL, NULL, &_inner_error_);
#line 146 "test-scores.vala"
		_tmp52_ = _tmp54_;
#line 146 "test-scores.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 146 "test-scores.vala"
			_g_free0 (_tmp41_);
#line 146 "test-scores.vala"
			_g_object_unref0 (_tmp37_);
#line 146 "test-scores.vala"
			_g_free0 (_tmp29_);
#line 146 "test-scores.vala"
			_g_free0 (_tmp18_);
#line 146 "test-scores.vala"
			tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 146 "test-scores.vala"
			_g_free0 (_tmp7_);
#line 146 "test-scores.vala"
			_g_free0 (line);
#line 146 "test-scores.vala"
			_g_object_unref0 (dis);
#line 146 "test-scores.vala"
			_g_object_unref0 (_tmp3_);
#line 146 "test-scores.vala"
			_g_object_unref0 (file);
#line 146 "test-scores.vala"
			_g_free0 (filename);
#line 1159 "test-scores.c"
			goto __catch2_g_error;
		}
#line 146 "test-scores.vala"
		_tmp55_ = _tmp52_;
#line 146 "test-scores.vala"
		_tmp52_ = NULL;
#line 146 "test-scores.vala"
		_g_free0 (line);
#line 146 "test-scores.vala"
		line = _tmp55_;
#line 146 "test-scores.vala"
		_tmp56_ = line;
#line 146 "test-scores.vala"
		_vala_assert (_tmp56_ != NULL, "(line = dis.read_line (null)) != null");
#line 148 "test-scores.vala"
		_tmp57_ = line;
#line 148 "test-scores.vala"
		_tmp59_ = _tmp58_ = g_strsplit (_tmp57_, " ", 3);
#line 148 "test-scores.vala"
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 148 "test-scores.vala"
		tokens = _tmp59_;
#line 148 "test-scores.vala"
		tokens_length1 = _vala_array_length (_tmp58_);
#line 148 "test-scores.vala"
		_tokens_size_ = tokens_length1;
#line 149 "test-scores.vala"
		_tmp60_ = tokens;
#line 149 "test-scores.vala"
		_tmp60__length1 = tokens_length1;
#line 149 "test-scores.vala"
		_vala_assert (_tmp60__length1 == 3, "tokens.length == 3");
#line 150 "test-scores.vala"
		_tmp61_ = tokens;
#line 150 "test-scores.vala"
		_tmp61__length1 = tokens_length1;
#line 150 "test-scores.vala"
		_tmp62_ = _tmp61_[0];
#line 150 "test-scores.vala"
		_vala_assert (g_strcmp0 (_tmp62_, "24") == 0, "tokens[0] == \"24\"");
#line 151 "test-scores.vala"
		_tmp64_ = dis;
#line 151 "test-scores.vala"
		_tmp65_ = g_data_input_stream_read_line (_tmp64_, NULL, NULL, &_inner_error_);
#line 151 "test-scores.vala"
		_tmp63_ = _tmp65_;
#line 151 "test-scores.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 151 "test-scores.vala"
			_g_free0 (_tmp52_);
#line 151 "test-scores.vala"
			_g_free0 (_tmp41_);
#line 151 "test-scores.vala"
			_g_object_unref0 (_tmp37_);
#line 151 "test-scores.vala"
			_g_free0 (_tmp29_);
#line 151 "test-scores.vala"
			_g_free0 (_tmp18_);
#line 151 "test-scores.vala"
			tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 151 "test-scores.vala"
			_g_free0 (_tmp7_);
#line 151 "test-scores.vala"
			_g_free0 (line);
#line 151 "test-scores.vala"
			_g_object_unref0 (dis);
#line 151 "test-scores.vala"
			_g_object_unref0 (_tmp3_);
#line 151 "test-scores.vala"
			_g_object_unref0 (file);
#line 151 "test-scores.vala"
			_g_free0 (filename);
#line 1232 "test-scores.c"
			goto __catch2_g_error;
		}
#line 151 "test-scores.vala"
		_tmp66_ = _tmp63_;
#line 151 "test-scores.vala"
		_tmp63_ = NULL;
#line 151 "test-scores.vala"
		_g_free0 (line);
#line 151 "test-scores.vala"
		line = _tmp66_;
#line 151 "test-scores.vala"
		_tmp67_ = line;
#line 151 "test-scores.vala"
		_vala_assert (_tmp67_ == NULL, "(line = dis.read_line (null)) == null");
#line 118 "test-scores.vala"
		_g_free0 (_tmp63_);
#line 118 "test-scores.vala"
		_g_free0 (_tmp52_);
#line 118 "test-scores.vala"
		_g_free0 (_tmp41_);
#line 118 "test-scores.vala"
		_g_object_unref0 (_tmp37_);
#line 118 "test-scores.vala"
		_g_free0 (_tmp29_);
#line 118 "test-scores.vala"
		_g_free0 (_tmp18_);
#line 118 "test-scores.vala"
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 118 "test-scores.vala"
		_g_free0 (_tmp7_);
#line 118 "test-scores.vala"
		_g_free0 (line);
#line 118 "test-scores.vala"
		_g_object_unref0 (dis);
#line 118 "test-scores.vala"
		_g_object_unref0 (_tmp3_);
#line 118 "test-scores.vala"
		_g_object_unref0 (file);
#line 118 "test-scores.vala"
		_g_free0 (filename);
#line 1273 "test-scores.c"
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp68_;
#line 118 "test-scores.vala"
		e = _inner_error_;
#line 118 "test-scores.vala"
		_inner_error_ = NULL;
#line 155 "test-scores.vala"
		_tmp68_ = e->message;
#line 155 "test-scores.vala"
		g_error ("test-scores.vala:155: %s", _tmp68_);
#line 118 "test-scores.vala"
		_g_error_free0 (e);
#line 1290 "test-scores.c"
	}
	__finally2:
#line 118 "test-scores.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 118 "test-scores.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 118 "test-scores.vala"
		g_clear_error (&_inner_error_);
#line 118 "test-scores.vala"
		return;
#line 1301 "test-scores.c"
	}
}


static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
#line 161 "test-scores.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 161 "test-scores.vala"
	return _data2_;
#line 1313 "test-scores.c"
}


static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 161 "test-scores.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 161 "test-scores.vala"
		_g_object_unref0 (_data2_->category);
#line 161 "test-scores.vala"
		g_slice_free (Block2Data, _data2_);
#line 1328 "test-scores.c"
	}
}


static guint8*
string_get_data (const gchar* self,
                 int* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
#line 1498 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1499 "glib-2.0.vapi"
	res = (guint8*) self;
#line 1499 "glib-2.0.vapi"
	res_length1 = -1;
#line 1499 "glib-2.0.vapi"
	_res_size_ = res_length1;
#line 1500 "glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1500 "glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1500 "glib-2.0.vapi"
	res_length1 = (gint) _tmp1_;
#line 1500 "glib-2.0.vapi"
	_tmp2_ = res_length1;
#line 1501 "glib-2.0.vapi"
	_tmp3_ = res;
#line 1501 "glib-2.0.vapi"
	_tmp3__length1 = res_length1;
#line 1501 "glib-2.0.vapi"
	_tmp4_ = _tmp3_;
#line 1501 "glib-2.0.vapi"
	_tmp4__length1 = _tmp3__length1;
#line 1501 "glib-2.0.vapi"
	if (result_length1) {
#line 1501 "glib-2.0.vapi"
		*result_length1 = _tmp4__length1;
#line 1376 "test-scores.c"
	}
#line 1501 "glib-2.0.vapi"
	result = _tmp4_;
#line 1501 "glib-2.0.vapi"
	return result;
#line 1382 "test-scores.c"
}


static GamesScoresCategory*
___lambda5_ (Block2Data* _data2_,
             const gchar* key)
{
	GamesScoresCategory* result = NULL;
	GamesScoresCategory* _tmp0_;
	GamesScoresCategory* _tmp1_;
#line 183 "test-scores.vala"
	g_return_val_if_fail (key != NULL, NULL);
#line 184 "test-scores.vala"
	_vala_assert (g_strcmp0 (key, "new-cat") == 0, "key == \"new-cat\"");
#line 185 "test-scores.vala"
	_tmp0_ = _data2_->category;
#line 185 "test-scores.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 185 "test-scores.vala"
	result = _tmp1_;
#line 185 "test-scores.vala"
	return result;
#line 1405 "test-scores.c"
}


static GamesScoresCategory*
____lambda5__games_scores_context_category_request_func (const gchar* category_key,
                                                         gpointer self)
{
	GamesScoresCategory* result;
	result = ___lambda5_ (self, category_key);
#line 179 "test-scores.vala"
	return result;
#line 1417 "test-scores.c"
}


static gchar*
___lambda6_ (const gchar* old_key)
{
	gchar* result = NULL;
	gchar* _tmp0_;
#line 188 "test-scores.vala"
	g_return_val_if_fail (old_key != NULL, NULL);
#line 189 "test-scores.vala"
	_vala_assert (g_strcmp0 (old_key, "old-cat") == 0, "old_key == \"old-cat\"");
#line 190 "test-scores.vala"
	_tmp0_ = g_strdup ("new-cat");
#line 190 "test-scores.vala"
	result = _tmp0_;
#line 190 "test-scores.vala"
	return result;
#line 1436 "test-scores.c"
}


static gchar*
____lambda6__games_scores_directory_importer_category_convert_func (const gchar* old_key,
                                                                    gpointer self)
{
	gchar* result;
	result = ___lambda6_ (old_key);
#line 179 "test-scores.vala"
	return result;
#line 1448 "test-scores.c"
}


void
games_scores_test_import_from_score_directory (void)
{
	GError * _inner_error_ = NULL;
	{
		Block2Data* _data2_;
		GamesScoresScore* expected_score = NULL;
		GDateTime* _tmp0_;
		GDateTime* _tmp1_;
		const gchar* _tmp2_;
		GamesScoresScore* _tmp3_;
		GamesScoresScore* _tmp4_;
		GamesScoresCategory* _tmp5_;
		GFile* test_directory = NULL;
		gchar* _tmp6_;
		gchar* _tmp7_;
		GFile* _tmp8_;
		GFile* _tmp9_;
		GFile* _tmp10_;
		GFile* old_scores_file = NULL;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		GFile* _tmp15_;
		GFile* _tmp16_;
		GFileOutputStream* stream = NULL;
		GFile* _tmp17_;
		GFileOutputStream* _tmp18_;
		GFileOutputStream* _tmp19_;
		GamesScoresScore* _tmp20_;
		glong _tmp21_;
		glong _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		GamesScoresScore* _tmp25_;
		gint64 _tmp26_;
		gint64 _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		guint8* _tmp32_;
		gint _tmp32__length1;
		guint8* _tmp33_;
		gint _tmp33__length1;
		GFileOutputStream* _tmp34_;
		GFile* _tmp35_;
		GamesScoresContext* context = NULL;
		GamesScoresDirectoryImporter* _tmp36_;
		GamesScoresDirectoryImporter* _tmp37_;
		GamesScoresContext* _tmp38_;
		GamesScoresContext* _tmp39_;
		GFile* _tmp40_;
		GeeList* imported_scores = NULL;
		GamesScoresCategory* _tmp41_;
		GeeList* _tmp42_;
		gint _tmp43_;
		gint _tmp44_;
		GamesScoresScore* imported_score = NULL;
		gpointer _tmp45_;
		GamesScoresScore* _tmp46_;
#line 161 "test-scores.vala"
		_data2_ = g_slice_new0 (Block2Data);
#line 161 "test-scores.vala"
		_data2_->_ref_count_ = 1;
#line 163 "test-scores.vala"
		_tmp0_ = g_date_time_new_now_local ();
#line 163 "test-scores.vala"
		_tmp1_ = _tmp0_;
#line 163 "test-scores.vala"
		_tmp2_ = g_get_real_name ();
#line 163 "test-scores.vala"
		_tmp3_ = games_scores_score_new ((glong) 42, g_date_time_to_unix (_tmp1_), _tmp2_);
#line 163 "test-scores.vala"
		_tmp4_ = _tmp3_;
#line 163 "test-scores.vala"
		_g_date_time_unref0 (_tmp1_);
#line 163 "test-scores.vala"
		expected_score = _tmp4_;
#line 166 "test-scores.vala"
		_tmp5_ = games_scores_category_new ("new-cat", "");
#line 166 "test-scores.vala"
		_data2_->category = _tmp5_;
#line 168 "test-scores.vala"
		_tmp6_ = games_scores_get_test_directory_name ();
#line 168 "test-scores.vala"
		_tmp7_ = _tmp6_;
#line 168 "test-scores.vala"
		_tmp8_ = g_file_new_for_path (_tmp7_);
#line 168 "test-scores.vala"
		_tmp9_ = _tmp8_;
#line 168 "test-scores.vala"
		_g_free0 (_tmp7_);
#line 168 "test-scores.vala"
		test_directory = _tmp9_;
#line 169 "test-scores.vala"
		_tmp10_ = test_directory;
#line 169 "test-scores.vala"
		g_file_make_directory_with_parents (_tmp10_, NULL, &_inner_error_);
#line 169 "test-scores.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 169 "test-scores.vala"
			_g_object_unref0 (test_directory);
#line 169 "test-scores.vala"
			_g_object_unref0 (expected_score);
#line 169 "test-scores.vala"
			block2_data_unref (_data2_);
#line 169 "test-scores.vala"
			_data2_ = NULL;
#line 1562 "test-scores.c"
			goto __catch3_g_error;
		}
#line 171 "test-scores.vala"
		_tmp11_ = games_scores_get_test_directory_name ();
#line 171 "test-scores.vala"
		_tmp12_ = _tmp11_;
#line 171 "test-scores.vala"
		_tmp13_ = g_build_filename (_tmp12_, "old-cat", NULL, NULL);
#line 171 "test-scores.vala"
		_tmp14_ = _tmp13_;
#line 171 "test-scores.vala"
		_tmp15_ = g_file_new_for_path (_tmp14_);
#line 171 "test-scores.vala"
		_tmp16_ = _tmp15_;
#line 171 "test-scores.vala"
		_g_free0 (_tmp14_);
#line 171 "test-scores.vala"
		_g_free0 (_tmp12_);
#line 171 "test-scores.vala"
		old_scores_file = _tmp16_;
#line 174 "test-scores.vala"
		_tmp17_ = old_scores_file;
#line 174 "test-scores.vala"
		_tmp18_ = g_file_append_to (_tmp17_, G_FILE_CREATE_NONE, NULL, &_inner_error_);
#line 174 "test-scores.vala"
		stream = _tmp18_;
#line 174 "test-scores.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 174 "test-scores.vala"
			_g_object_unref0 (old_scores_file);
#line 174 "test-scores.vala"
			_g_object_unref0 (test_directory);
#line 174 "test-scores.vala"
			_g_object_unref0 (expected_score);
#line 174 "test-scores.vala"
			block2_data_unref (_data2_);
#line 174 "test-scores.vala"
			_data2_ = NULL;
#line 1601 "test-scores.c"
			goto __catch3_g_error;
		}
#line 175 "test-scores.vala"
		_tmp19_ = stream;
#line 175 "test-scores.vala"
		_tmp20_ = expected_score;
#line 175 "test-scores.vala"
		_tmp21_ = games_scores_score_get_score (_tmp20_);
#line 175 "test-scores.vala"
		_tmp22_ = _tmp21_;
#line 175 "test-scores.vala"
		_tmp23_ = g_strdup_printf ("%li", _tmp22_);
#line 175 "test-scores.vala"
		_tmp24_ = _tmp23_;
#line 175 "test-scores.vala"
		_tmp25_ = expected_score;
#line 175 "test-scores.vala"
		_tmp26_ = games_scores_score_get_time (_tmp25_);
#line 175 "test-scores.vala"
		_tmp27_ = _tmp26_;
#line 175 "test-scores.vala"
		_tmp28_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp27_);
#line 175 "test-scores.vala"
		_tmp29_ = _tmp28_;
#line 175 "test-scores.vala"
		_tmp30_ = g_strconcat (_tmp24_, " ", _tmp29_, "\n", NULL);
#line 175 "test-scores.vala"
		_tmp31_ = _tmp30_;
#line 175 "test-scores.vala"
		_tmp32_ = string_get_data (_tmp31_, &_tmp32__length1);
#line 175 "test-scores.vala"
		_tmp33_ = _tmp32_;
#line 175 "test-scores.vala"
		_tmp33__length1 = _tmp32__length1;
#line 175 "test-scores.vala"
		g_output_stream_write_all ((GOutputStream*) _tmp19_, _tmp33_, (gsize) _tmp33__length1, NULL, NULL, &_inner_error_);
#line 175 "test-scores.vala"
		_g_free0 (_tmp31_);
#line 175 "test-scores.vala"
		_g_free0 (_tmp29_);
#line 175 "test-scores.vala"
		_g_free0 (_tmp24_);
#line 175 "test-scores.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 175 "test-scores.vala"
			_g_object_unref0 (stream);
#line 175 "test-scores.vala"
			_g_object_unref0 (old_scores_file);
#line 175 "test-scores.vala"
			_g_object_unref0 (test_directory);
#line 175 "test-scores.vala"
			_g_object_unref0 (expected_score);
#line 175 "test-scores.vala"
			block2_data_unref (_data2_);
#line 175 "test-scores.vala"
			_data2_ = NULL;
#line 1658 "test-scores.c"
			goto __catch3_g_error;
		}
#line 176 "test-scores.vala"
		_tmp34_ = stream;
#line 176 "test-scores.vala"
		g_output_stream_close ((GOutputStream*) _tmp34_, NULL, &_inner_error_);
#line 176 "test-scores.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 176 "test-scores.vala"
			_g_object_unref0 (stream);
#line 176 "test-scores.vala"
			_g_object_unref0 (old_scores_file);
#line 176 "test-scores.vala"
			_g_object_unref0 (test_directory);
#line 176 "test-scores.vala"
			_g_object_unref0 (expected_score);
#line 176 "test-scores.vala"
			block2_data_unref (_data2_);
#line 176 "test-scores.vala"
			_data2_ = NULL;
#line 1679 "test-scores.c"
			goto __catch3_g_error;
		}
#line 177 "test-scores.vala"
		_tmp35_ = old_scores_file;
#line 177 "test-scores.vala"
		_vala_assert (g_file_query_exists (_tmp35_, NULL), "old_scores_file.query_exists ()");
#line 179 "test-scores.vala"
		_tmp36_ = games_scores_directory_importer_new_with_convert_func (____lambda6__games_scores_directory_importer_category_convert_func, NULL);
#line 179 "test-scores.vala"
		_tmp37_ = _tmp36_;
#line 179 "test-scores.vala"
		_tmp38_ = games_scores_context_new_with_importer ("libgnome-games-support-test", "", NULL, ____lambda5__games_scores_context_category_request_func, _data2_, GAMES_SCORES_STYLE_POINTS_GREATER_IS_BETTER, (GamesScoresImporter*) _tmp37_);
#line 179 "test-scores.vala"
		_tmp39_ = _tmp38_;
#line 179 "test-scores.vala"
		_g_object_unref0 (_tmp37_);
#line 179 "test-scores.vala"
		context = _tmp39_;
#line 192 "test-scores.vala"
		_tmp40_ = old_scores_file;
#line 192 "test-scores.vala"
		_vala_assert (!g_file_query_exists (_tmp40_, NULL), "!old_scores_file.query_exists ()");
#line 194 "test-scores.vala"
		_tmp41_ = _data2_->category;
#line 194 "test-scores.vala"
		_tmp42_ = games_scores_context_get_high_scores (context, _tmp41_, 10);
#line 194 "test-scores.vala"
		imported_scores = _tmp42_;
#line 195 "test-scores.vala"
		_tmp43_ = gee_collection_get_size ((GeeCollection*) imported_scores);
#line 195 "test-scores.vala"
		_tmp44_ = _tmp43_;
#line 195 "test-scores.vala"
		_vala_assert (_tmp44_ == 1, "imported_scores.size == 1");
#line 197 "test-scores.vala"
		_tmp45_ = gee_list_first (imported_scores);
#line 197 "test-scores.vala"
		imported_score = (GamesScoresScore*) _tmp45_;
#line 198 "test-scores.vala"
		_tmp46_ = expected_score;
#line 198 "test-scores.vala"
		_vala_assert (games_scores_score_equals (_tmp46_, imported_score), "Score.equals (expected_score, imported_score)");
#line 161 "test-scores.vala"
		_g_object_unref0 (imported_score);
#line 161 "test-scores.vala"
		_g_object_unref0 (imported_scores);
#line 161 "test-scores.vala"
		_g_object_unref0 (context);
#line 161 "test-scores.vala"
		_g_object_unref0 (stream);
#line 161 "test-scores.vala"
		_g_object_unref0 (old_scores_file);
#line 161 "test-scores.vala"
		_g_object_unref0 (test_directory);
#line 161 "test-scores.vala"
		_g_object_unref0 (expected_score);
#line 161 "test-scores.vala"
		block2_data_unref (_data2_);
#line 161 "test-scores.vala"
		_data2_ = NULL;
#line 1740 "test-scores.c"
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp47_;
#line 161 "test-scores.vala"
		e = _inner_error_;
#line 161 "test-scores.vala"
		_inner_error_ = NULL;
#line 202 "test-scores.vala"
		_tmp47_ = e->message;
#line 202 "test-scores.vala"
		g_error ("test-scores.vala:202: %s", _tmp47_);
#line 161 "test-scores.vala"
		_g_error_free0 (e);
#line 1757 "test-scores.c"
	}
	__finally3:
#line 161 "test-scores.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 161 "test-scores.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 161 "test-scores.vala"
		g_clear_error (&_inner_error_);
#line 161 "test-scores.vala"
		return;
#line 1768 "test-scores.c"
	}
}


static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
#line 208 "test-scores.vala"
	g_atomic_int_inc (&_data3_->_ref_count_);
#line 208 "test-scores.vala"
	return _data3_;
#line 1780 "test-scores.c"
}


static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
#line 208 "test-scores.vala"
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
#line 208 "test-scores.vala"
		_g_object_unref0 (_data3_->category);
#line 208 "test-scores.vala"
		g_slice_free (Block3Data, _data3_);
#line 1795 "test-scores.c"
	}
}


static GamesScoresCategory*
___lambda7_ (Block3Data* _data3_,
             const gchar* key)
{
	GamesScoresCategory* result = NULL;
	GamesScoresCategory* _tmp0_;
	GamesScoresCategory* _tmp1_;
#line 230 "test-scores.vala"
	g_return_val_if_fail (key != NULL, NULL);
#line 231 "test-scores.vala"
	_vala_assert (g_strcmp0 (key, "new-cat") == 0, "key == \"new-cat\"");
#line 232 "test-scores.vala"
	_tmp0_ = _data3_->category;
#line 232 "test-scores.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 232 "test-scores.vala"
	result = _tmp1_;
#line 232 "test-scores.vala"
	return result;
#line 1819 "test-scores.c"
}


static GamesScoresCategory*
____lambda7__games_scores_context_category_request_func (const gchar* category_key,
                                                         gpointer self)
{
	GamesScoresCategory* result;
	result = ___lambda7_ (self, category_key);
#line 226 "test-scores.vala"
	return result;
#line 1831 "test-scores.c"
}


static void
___lambda8_ (Block3Data* _data3_,
             const gchar* line,
             GamesScoresScore* * score,
             GamesScoresCategory* * out_category)
{
	GamesScoresScore* _vala_score = NULL;
	GamesScoresCategory* _vala_out_category = NULL;
	GamesScoresScore* _tmp0_;
	gint64 _tmp1_;
	gint64 _tmp2_;
	GamesScoresCategory* _tmp3_;
	GamesScoresCategory* _tmp4_;
#line 235 "test-scores.vala"
	g_return_if_fail (line != NULL);
#line 236 "test-scores.vala"
	_vala_assert (g_strcmp0 (line, "2016-02-13T23:15:45-0600 old-cat 42") == 0, "line == \"2016-02-13T23:15:45-0600 old-cat 42\"");
#line 237 "test-scores.vala"
	_tmp0_ = games_scores_score_new ((glong) 42, games_scores_history_file_importer_parse_date ("2016-02-13T23:15:45-0600"), NULL);
#line 237 "test-scores.vala"
	_g_object_unref0 (_vala_score);
#line 237 "test-scores.vala"
	_vala_score = _tmp0_;
#line 238 "test-scores.vala"
	_tmp1_ = games_scores_score_get_time (_vala_score);
#line 238 "test-scores.vala"
	_tmp2_ = _tmp1_;
#line 238 "test-scores.vala"
	_vala_assert (_tmp2_ == ((gint64) 1455426945), "score.time == 1455426945");
#line 239 "test-scores.vala"
	_tmp3_ = _data3_->category;
#line 239 "test-scores.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 239 "test-scores.vala"
	_g_object_unref0 (_vala_out_category);
#line 239 "test-scores.vala"
	_vala_out_category = _tmp4_;
#line 235 "test-scores.vala"
	if (score) {
#line 235 "test-scores.vala"
		*score = _vala_score;
#line 1876 "test-scores.c"
	} else {
#line 235 "test-scores.vala"
		_g_object_unref0 (_vala_score);
#line 1880 "test-scores.c"
	}
#line 235 "test-scores.vala"
	if (out_category) {
#line 235 "test-scores.vala"
		*out_category = _vala_out_category;
#line 1886 "test-scores.c"
	} else {
#line 235 "test-scores.vala"
		_g_object_unref0 (_vala_out_category);
#line 1890 "test-scores.c"
	}
}


static void
____lambda8__games_scores_history_file_importer_history_convert_func (const gchar* line,
                                                                      GamesScoresScore* * score,
                                                                      GamesScoresCategory* * category,
                                                                      gpointer self)
{
#line 226 "test-scores.vala"
	___lambda8_ (self, line, score, category);
#line 1903 "test-scores.c"
}


void
games_scores_test_import_from_history_file (void)
{
	GError * _inner_error_ = NULL;
	{
		Block3Data* _data3_;
		GamesScoresScore* expected_score = NULL;
		const gchar* _tmp0_;
		GamesScoresScore* _tmp1_;
		GamesScoresCategory* _tmp2_;
		GFile* test_directory = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GFile* _tmp5_;
		GFile* _tmp6_;
		GFile* _tmp7_;
		GFile* old_scores_file = NULL;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		GFile* _tmp12_;
		GFile* _tmp13_;
		GFileOutputStream* stream = NULL;
		GFile* _tmp14_;
		GFileOutputStream* _tmp15_;
		GFileOutputStream* _tmp16_;
		guint8* _tmp17_;
		gint _tmp17__length1;
		guint8* _tmp18_;
		gint _tmp18__length1;
		GFileOutputStream* _tmp19_;
		GFile* _tmp20_;
		GamesScoresContext* context = NULL;
		GamesScoresHistoryFileImporter* _tmp21_;
		GamesScoresHistoryFileImporter* _tmp22_;
		GamesScoresContext* _tmp23_;
		GamesScoresContext* _tmp24_;
		GFile* _tmp25_;
		GeeList* imported_scores = NULL;
		GamesScoresCategory* _tmp26_;
		GeeList* _tmp27_;
		gint _tmp28_;
		gint _tmp29_;
		GamesScoresScore* imported_score = NULL;
		gpointer _tmp30_;
		GamesScoresScore* _tmp31_;
#line 208 "test-scores.vala"
		_data3_ = g_slice_new0 (Block3Data);
#line 208 "test-scores.vala"
		_data3_->_ref_count_ = 1;
#line 210 "test-scores.vala"
		_tmp0_ = g_get_real_name ();
#line 210 "test-scores.vala"
		_tmp1_ = games_scores_score_new ((glong) 42, (gint64) 1455426945, _tmp0_);
#line 210 "test-scores.vala"
		expected_score = _tmp1_;
#line 213 "test-scores.vala"
		_tmp2_ = games_scores_category_new ("new-cat", "");
#line 213 "test-scores.vala"
		_data3_->category = _tmp2_;
#line 215 "test-scores.vala"
		_tmp3_ = games_scores_get_test_directory_name ();
#line 215 "test-scores.vala"
		_tmp4_ = _tmp3_;
#line 215 "test-scores.vala"
		_tmp5_ = g_file_new_for_path (_tmp4_);
#line 215 "test-scores.vala"
		_tmp6_ = _tmp5_;
#line 215 "test-scores.vala"
		_g_free0 (_tmp4_);
#line 215 "test-scores.vala"
		test_directory = _tmp6_;
#line 216 "test-scores.vala"
		_tmp7_ = test_directory;
#line 216 "test-scores.vala"
		g_file_make_directory_with_parents (_tmp7_, NULL, &_inner_error_);
#line 216 "test-scores.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 216 "test-scores.vala"
			_g_object_unref0 (test_directory);
#line 216 "test-scores.vala"
			_g_object_unref0 (expected_score);
#line 216 "test-scores.vala"
			block3_data_unref (_data3_);
#line 216 "test-scores.vala"
			_data3_ = NULL;
#line 1994 "test-scores.c"
			goto __catch4_g_error;
		}
#line 218 "test-scores.vala"
		_tmp8_ = games_scores_get_test_directory_name ();
#line 218 "test-scores.vala"
		_tmp9_ = _tmp8_;
#line 218 "test-scores.vala"
		_tmp10_ = g_build_filename (_tmp9_, "history", NULL, NULL);
#line 218 "test-scores.vala"
		_tmp11_ = _tmp10_;
#line 218 "test-scores.vala"
		_tmp12_ = g_file_new_for_path (_tmp11_);
#line 218 "test-scores.vala"
		_tmp13_ = _tmp12_;
#line 218 "test-scores.vala"
		_g_free0 (_tmp11_);
#line 218 "test-scores.vala"
		_g_free0 (_tmp9_);
#line 218 "test-scores.vala"
		old_scores_file = _tmp13_;
#line 221 "test-scores.vala"
		_tmp14_ = old_scores_file;
#line 221 "test-scores.vala"
		_tmp15_ = g_file_append_to (_tmp14_, G_FILE_CREATE_NONE, NULL, &_inner_error_);
#line 221 "test-scores.vala"
		stream = _tmp15_;
#line 221 "test-scores.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 221 "test-scores.vala"
			_g_object_unref0 (old_scores_file);
#line 221 "test-scores.vala"
			_g_object_unref0 (test_directory);
#line 221 "test-scores.vala"
			_g_object_unref0 (expected_score);
#line 221 "test-scores.vala"
			block3_data_unref (_data3_);
#line 221 "test-scores.vala"
			_data3_ = NULL;
#line 2033 "test-scores.c"
			goto __catch4_g_error;
		}
#line 222 "test-scores.vala"
		_tmp16_ = stream;
#line 222 "test-scores.vala"
		_tmp17_ = string_get_data ("2016-02-13T23:15:45-0600 old-cat 42\n", &_tmp17__length1);
#line 222 "test-scores.vala"
		_tmp18_ = _tmp17_;
#line 222 "test-scores.vala"
		_tmp18__length1 = _tmp17__length1;
#line 222 "test-scores.vala"
		g_output_stream_write_all ((GOutputStream*) _tmp16_, _tmp18_, (gsize) _tmp18__length1, NULL, NULL, &_inner_error_);
#line 222 "test-scores.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 222 "test-scores.vala"
			_g_object_unref0 (stream);
#line 222 "test-scores.vala"
			_g_object_unref0 (old_scores_file);
#line 222 "test-scores.vala"
			_g_object_unref0 (test_directory);
#line 222 "test-scores.vala"
			_g_object_unref0 (expected_score);
#line 222 "test-scores.vala"
			block3_data_unref (_data3_);
#line 222 "test-scores.vala"
			_data3_ = NULL;
#line 2060 "test-scores.c"
			goto __catch4_g_error;
		}
#line 223 "test-scores.vala"
		_tmp19_ = stream;
#line 223 "test-scores.vala"
		g_output_stream_close ((GOutputStream*) _tmp19_, NULL, &_inner_error_);
#line 223 "test-scores.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 223 "test-scores.vala"
			_g_object_unref0 (stream);
#line 223 "test-scores.vala"
			_g_object_unref0 (old_scores_file);
#line 223 "test-scores.vala"
			_g_object_unref0 (test_directory);
#line 223 "test-scores.vala"
			_g_object_unref0 (expected_score);
#line 223 "test-scores.vala"
			block3_data_unref (_data3_);
#line 223 "test-scores.vala"
			_data3_ = NULL;
#line 2081 "test-scores.c"
			goto __catch4_g_error;
		}
#line 224 "test-scores.vala"
		_tmp20_ = old_scores_file;
#line 224 "test-scores.vala"
		_vala_assert (g_file_query_exists (_tmp20_, NULL), "old_scores_file.query_exists ()");
#line 226 "test-scores.vala"
		_tmp21_ = games_scores_history_file_importer_new (____lambda8__games_scores_history_file_importer_history_convert_func, _data3_);
#line 226 "test-scores.vala"
		_tmp22_ = _tmp21_;
#line 226 "test-scores.vala"
		_tmp23_ = games_scores_context_new_with_importer ("libgnome-games-support-test", "", NULL, ____lambda7__games_scores_context_category_request_func, _data3_, GAMES_SCORES_STYLE_POINTS_GREATER_IS_BETTER, (GamesScoresImporter*) _tmp22_);
#line 226 "test-scores.vala"
		_tmp24_ = _tmp23_;
#line 226 "test-scores.vala"
		_g_object_unref0 (_tmp22_);
#line 226 "test-scores.vala"
		context = _tmp24_;
#line 241 "test-scores.vala"
		_tmp25_ = old_scores_file;
#line 241 "test-scores.vala"
		_vala_assert (!g_file_query_exists (_tmp25_, NULL), "!old_scores_file.query_exists ()");
#line 243 "test-scores.vala"
		_tmp26_ = _data3_->category;
#line 243 "test-scores.vala"
		_tmp27_ = games_scores_context_get_high_scores (context, _tmp26_, 10);
#line 243 "test-scores.vala"
		imported_scores = _tmp27_;
#line 244 "test-scores.vala"
		_tmp28_ = gee_collection_get_size ((GeeCollection*) imported_scores);
#line 244 "test-scores.vala"
		_tmp29_ = _tmp28_;
#line 244 "test-scores.vala"
		_vala_assert (_tmp29_ == 1, "imported_scores.size == 1");
#line 246 "test-scores.vala"
		_tmp30_ = gee_list_first (imported_scores);
#line 246 "test-scores.vala"
		imported_score = (GamesScoresScore*) _tmp30_;
#line 247 "test-scores.vala"
		_tmp31_ = expected_score;
#line 247 "test-scores.vala"
		_vala_assert (games_scores_score_equals (_tmp31_, imported_score), "Score.equals (expected_score, imported_score)");
#line 208 "test-scores.vala"
		_g_object_unref0 (imported_score);
#line 208 "test-scores.vala"
		_g_object_unref0 (imported_scores);
#line 208 "test-scores.vala"
		_g_object_unref0 (context);
#line 208 "test-scores.vala"
		_g_object_unref0 (stream);
#line 208 "test-scores.vala"
		_g_object_unref0 (old_scores_file);
#line 208 "test-scores.vala"
		_g_object_unref0 (test_directory);
#line 208 "test-scores.vala"
		_g_object_unref0 (expected_score);
#line 208 "test-scores.vala"
		block3_data_unref (_data3_);
#line 208 "test-scores.vala"
		_data3_ = NULL;
#line 2142 "test-scores.c"
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp32_;
#line 208 "test-scores.vala"
		e = _inner_error_;
#line 208 "test-scores.vala"
		_inner_error_ = NULL;
#line 251 "test-scores.vala"
		_tmp32_ = e->message;
#line 251 "test-scores.vala"
		g_error ("test-scores.vala:251: %s", _tmp32_);
#line 208 "test-scores.vala"
		_g_error_free0 (e);
#line 2159 "test-scores.c"
	}
	__finally4:
#line 208 "test-scores.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 208 "test-scores.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 208 "test-scores.vala"
		g_clear_error (&_inner_error_);
#line 208 "test-scores.vala"
		return;
#line 2170 "test-scores.c"
	}
}


static GamesScoresCategory*
__lambda9_ (const gchar* key)
{
	GamesScoresCategory* result = NULL;
#line 261 "test-scores.vala"
	g_return_val_if_fail (key != NULL, NULL);
#line 262 "test-scores.vala"
	result = NULL;
#line 262 "test-scores.vala"
	return result;
#line 2185 "test-scores.c"
}


static GamesScoresCategory*
___lambda9__games_scores_context_category_request_func (const gchar* category_key,
                                                        gpointer self)
{
	GamesScoresCategory* result;
	result = __lambda9_ (category_key);
#line 257 "test-scores.vala"
	return result;
#line 2197 "test-scores.c"
}


static void
__lambda10_ (const gchar* line,
             GamesScoresScore* * score,
             GamesScoresCategory* * category)
{
	GamesScoresScore* _vala_score = NULL;
	GamesScoresCategory* _vala_category = NULL;
#line 265 "test-scores.vala"
	g_return_if_fail (line != NULL);
#line 266 "test-scores.vala"
	_g_object_unref0 (_vala_score);
#line 266 "test-scores.vala"
	_vala_score = NULL;
#line 267 "test-scores.vala"
	_g_object_unref0 (_vala_category);
#line 267 "test-scores.vala"
	_vala_category = NULL;
#line 265 "test-scores.vala"
	if (score) {
#line 265 "test-scores.vala"
		*score = _vala_score;
#line 2222 "test-scores.c"
	} else {
#line 265 "test-scores.vala"
		_g_object_unref0 (_vala_score);
#line 2226 "test-scores.c"
	}
#line 265 "test-scores.vala"
	if (category) {
#line 265 "test-scores.vala"
		*category = _vala_category;
#line 2232 "test-scores.c"
	} else {
#line 265 "test-scores.vala"
		_g_object_unref0 (_vala_category);
#line 2236 "test-scores.c"
	}
}


static void
___lambda10__games_scores_history_file_importer_history_convert_func (const gchar* line,
                                                                      GamesScoresScore* * score,
                                                                      GamesScoresCategory* * category,
                                                                      gpointer self)
{
#line 257 "test-scores.vala"
	__lambda10_ (line, score, category);
#line 2249 "test-scores.c"
}


void
games_scores_test_import_from_nonexistent_history_file (void)
{
	GamesScoresHistoryFileImporter* _tmp0_;
	GamesScoresHistoryFileImporter* _tmp1_;
	GamesScoresContext* _tmp2_;
#line 257 "test-scores.vala"
	_tmp0_ = games_scores_history_file_importer_new (___lambda10__games_scores_history_file_importer_history_convert_func, NULL);
#line 257 "test-scores.vala"
	_tmp1_ = _tmp0_;
#line 257 "test-scores.vala"
	_tmp2_ = games_scores_context_new_with_importer ("libgnome-games-support-test", "", NULL, ___lambda9__games_scores_context_category_request_func, NULL, GAMES_SCORES_STYLE_POINTS_GREATER_IS_BETTER, (GamesScoresImporter*) _tmp1_);
#line 257 "test-scores.vala"
	_g_object_unref0 (_tmp1_);
#line 2267 "test-scores.c"
}


static void
__lambda11_ (void)
{
}


static void
___lambda11__gtest_fixture_func (void* fixture,
                                 gpointer self)
{
#line 280 "test-scores.vala"
	__lambda11_ ();
#line 2283 "test-scores.c"
}


static void
_games_scores_test_scores_files_exist_gtest_fixture_func (void* fixture,
                                                          gpointer self)
{
#line 280 "test-scores.vala"
	games_scores_test_scores_files_exist ();
#line 2293 "test-scores.c"
}


static void
_games_scores_delete_scores_gtest_fixture_func (void* fixture,
                                                gpointer self)
{
#line 280 "test-scores.vala"
	games_scores_delete_scores ();
#line 2303 "test-scores.c"
}


static void
__lambda12_ (void)
{
}


static void
___lambda12__gtest_fixture_func (void* fixture,
                                 gpointer self)
{
#line 281 "test-scores.vala"
	__lambda12_ ();
#line 2319 "test-scores.c"
}


static void
_games_scores_test_save_score_to_file_gtest_fixture_func (void* fixture,
                                                          gpointer self)
{
#line 281 "test-scores.vala"
	games_scores_test_save_score_to_file ();
#line 2329 "test-scores.c"
}


static void
__lambda13_ (void)
{
}


static void
___lambda13__gtest_fixture_func (void* fixture,
                                 gpointer self)
{
#line 282 "test-scores.vala"
	__lambda13_ ();
#line 2345 "test-scores.c"
}


static void
_games_scores_test_import_from_score_directory_gtest_fixture_func (void* fixture,
                                                                   gpointer self)
{
#line 282 "test-scores.vala"
	games_scores_test_import_from_score_directory ();
#line 2355 "test-scores.c"
}


static void
__lambda14_ (void)
{
}


static void
___lambda14__gtest_fixture_func (void* fixture,
                                 gpointer self)
{
#line 283 "test-scores.vala"
	__lambda14_ ();
#line 2371 "test-scores.c"
}


static void
_games_scores_test_import_from_history_file_gtest_fixture_func (void* fixture,
                                                                gpointer self)
{
#line 283 "test-scores.vala"
	games_scores_test_import_from_history_file ();
#line 2381 "test-scores.c"
}


static void
__lambda15_ (void)
{
}


static void
___lambda15__gtest_fixture_func (void* fixture,
                                 gpointer self)
{
#line 284 "test-scores.vala"
	__lambda15_ ();
#line 2397 "test-scores.c"
}


static void
_games_scores_test_import_from_nonexistent_history_file_gtest_fixture_func (void* fixture,
                                                                            gpointer self)
{
#line 284 "test-scores.vala"
	games_scores_test_import_from_nonexistent_history_file ();
#line 2407 "test-scores.c"
}


gint
games_scores_main (gchar** args,
                   int args_length1)
{
	gint result = 0;
	GTestSuite* test_suite = NULL;
	GTestSuite* _tmp0_;
	GTestCase* _tmp1_;
	GTestCase* _tmp2_;
	GTestCase* _tmp3_;
	GTestCase* _tmp4_;
	GTestCase* _tmp5_;
#line 276 "test-scores.vala"
	games_scores_delete_scores ();
#line 278 "test-scores.vala"
	g_test_init (&args_length1, &args, NULL);
#line 279 "test-scores.vala"
	_tmp0_ = g_test_get_root ();
#line 279 "test-scores.vala"
	test_suite = _tmp0_;
#line 280 "test-scores.vala"
	_tmp1_ = g_test_create_case ("Scores Files Created", (gsize) 0, NULL, ___lambda11__gtest_fixture_func, _games_scores_test_scores_files_exist_gtest_fixture_func, _games_scores_delete_scores_gtest_fixture_func);
#line 280 "test-scores.vala"
	g_test_suite_add (test_suite, _tmp1_);
#line 281 "test-scores.vala"
	_tmp2_ = g_test_create_case ("Save Score to File", (gsize) 0, NULL, ___lambda12__gtest_fixture_func, _games_scores_test_save_score_to_file_gtest_fixture_func, _games_scores_delete_scores_gtest_fixture_func);
#line 281 "test-scores.vala"
	g_test_suite_add (test_suite, _tmp2_);
#line 282 "test-scores.vala"
	_tmp3_ = g_test_create_case ("Import from Score Directory", (gsize) 0, NULL, ___lambda13__gtest_fixture_func, _games_scores_test_import_from_score_directory_gtest_fixture_func, _games_scores_delete_scores_gtest_fixture_func);
#line 282 "test-scores.vala"
	g_test_suite_add (test_suite, _tmp3_);
#line 283 "test-scores.vala"
	_tmp4_ = g_test_create_case ("Import from History File", (gsize) 0, NULL, ___lambda14__gtest_fixture_func, _games_scores_test_import_from_history_file_gtest_fixture_func, _games_scores_delete_scores_gtest_fixture_func);
#line 283 "test-scores.vala"
	g_test_suite_add (test_suite, _tmp4_);
#line 284 "test-scores.vala"
	_tmp5_ = g_test_create_case ("Import from Nonexistent History File", (gsize) 0, NULL, ___lambda15__gtest_fixture_func, _games_scores_test_import_from_nonexistent_history_file_gtest_fixture_func, _games_scores_delete_scores_gtest_fixture_func);
#line 284 "test-scores.vala"
	g_test_suite_add (test_suite, _tmp5_);
#line 285 "test-scores.vala"
	result = g_test_run ();
#line 285 "test-scores.vala"
	return result;
#line 2455 "test-scores.c"
}


int
main (int argc,
      char ** argv)
{
#line 273 "test-scores.vala"
	return games_scores_main (argv, argc);
#line 2465 "test-scores.c"
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



