cr.define('uos_newtab', function() {
  'use strict';

  /**
   * Be polite and insert translated hello world strings for the user on loading.
   
  function initialize() {
    $('welcome-message').textContent = loadTimeData.getStringF('welcomeMessage',
        loadTimeData.getString('userName'));
  }*/
  let searchType = 0,
      engineType = 0,
      searchLink = [
        [
          {"link" : "https://www.baidu.com/s?&ie=utf-8&wd="},
          {"link" : "https://image.baidu.com/search/index?tn=baiduimage&fm=result&ie=utf-8&word="},
          {"link" : "https://www.baidu.com/s?tn=news&word="},
          {"link" : "https://www.baidu.com/sf/vsearch?pd=video&tn=vsearch&ie=utf-8&wd="},
          {"link" : "https://map.baidu.com/search/?querytype=s&da_src=shareurl&wd="}
        ],
        [
          {"link" : "https://www.sogou.com/web?query="},
          {"link" : "https://pic.sogou.com/pics?ie=utf8&query="},
          {"link" : "https://news.sogou.com/news?ie=utf8&query="},
          {"link" : "https://v.sogou.com/v?ie=utf8&query="},
          {"link" : "http://map.sogou.com/#lq="}
        ],
        [
          {"link" : "https://www.so.com/s?ie=utf-8&src=se7_newtab_new&q="},
          {"link" : "https://image.so.com/i?ie=utf-8&src=se7_newtab_new&q="},
          {"link" : "https://news.so.com/ns?src=se7_newtab_new&q="},
          {"link" : "https://video.360kan.com/v?src=se7_newtab_new&q="},
          {"link" : "https://ditu.so.com/?&src=se7_newtab_new&k="}
        ]
      ];

  function initialize() {
    addEvents();
    chrome.send('GetSearchEnginesList', [2, 4]);
    chrome.send('getShowSite', [2, 4]);
    resizeHtmlFontSize();
  }
  function getShowSite(param){
    console.log(param);
    if(param){
      $(".home-slider-wrap").css("display","flex");
    }
  }    
  function addResult(data) {
    //alert('The result of our C++ arithmetic: 2 + 2 = ' + result);
    console.log(JSON.parse(data));
    let result = JSON.parse(data);
    if(result.defaults) {
      for(let i =0;i<result.defaults.length;i++){
        if(result.defaults[i].default && i<3){
          engineType = i;
          changeSearch(engineType);
        }
      }
    }
  }

  function addEvents(){
    $(document).on("click", ".search-wrap .head",
		function(e) {
      e.stopPropagation();
			$(".search-type-box").slideToggle();
    });
    $(document).on("click", ".search-wrap .search-type-box dl.list-item",
		function(e) {
			e.stopPropagation();
      engineType = parseInt($(this).data("index"));
      let arr = [];
      arr.push(parseInt(engineType));
      changeSearch(engineType);
      chrome.send('setDefaultSearchEngine',arr);
      $(".search-type-box").slideToggle();
    });
    $(document).on("keydown", ".search-wrap input.search_value",
		function(e) {
      e.stopPropagation();
			13 == e.keyCode && (e.stopPropagation(), search());
    });
    $(document).on("click", ".search-wrap .search-list li",
		function(e) {
      // e.stopPropagation();
      searchType = $(this).data("index");
      $(this).addClass("active").siblings().removeClass("active");
    });
    $(document).on("click", "div.thumb",
		function(e) {
			// e.stopPropagation();
			var link = $(this).parent().parent().parent().data().url;
			window.location.href = link;
    });
    $(document).on("click", "body",
		function(e) {
      e.stopPropagation();
      if(!$(".search-type-box").is(":hidden")){
        $(".search-type-box").slideToggle();
      }
    });
    window.onresize = function(){
      resizeHtmlFontSize();
    }
  }
  function changeSearch(index){
    switch (index) {
      case 0:
        $(".head img").attr("src","chrome://theme/IDR_ICON_BD");
        break; 
      case 1:
        $(".head img").attr("src","chrome://theme/IDR_ICON_SG");
        break; 
      case 2:
        $(".head img").attr("src","chrome://theme/IDR_ICON_360");
        break; 
      }
  }
  function search() {
    if ($(".search-wrap input.search_value").val().trim() == "") return false;
    let searchText = $(".search-wrap input.search_value").val();
    let searchUrl = searchLink[engineType][searchType].link+searchText;
    searchUrl = searchUrl.replace(/\s/g," ");
    console.log(engineType,searchText,searchType,searchUrl);
    window.location.href = searchUrl;
  }
  function resizeHtmlFontSize(){
    var Htmlele=document.getElementsByTagName("html")[0];
    var font =  Htmlele.offsetWidth/1920*100 > 41.6667 ? Htmlele.offsetWidth/1920*100:41.6667
    Htmlele.style.fontSize=font+"px";
  }
  // Return an object with all of the exports.
  return {
    addResult: addResult,
    initialize: initialize,
    getShowSite: getShowSite
  };
});

document.addEventListener('DOMContentLoaded', uos_newtab.initialize);