/*
 *  This file is part of the WebKit open source project.
 *  This file has been generated by generate-bindings.pl. DO NOT MODIFY!
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 */

#ifndef WebKitDOMTestObj_h
#define WebKitDOMTestObj_h

#ifdef WEBKIT_DOM_USE_UNSTABLE_API

#include <glib-object.h>
#include <webkitdom/WebKitDOMObject.h>
#include <webkitdom/webkitdomdefines-unstable.h>

G_BEGIN_DECLS

#define WEBKIT_DOM_TYPE_TEST_OBJ            (webkit_dom_test_obj_get_type())
#define WEBKIT_DOM_TEST_OBJ(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj), WEBKIT_DOM_TYPE_TEST_OBJ, WebKitDOMTestObj))
#define WEBKIT_DOM_TEST_OBJ_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass),  WEBKIT_DOM_TYPE_TEST_OBJ, WebKitDOMTestObjClass)
#define WEBKIT_DOM_IS_TEST_OBJ(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), WEBKIT_DOM_TYPE_TEST_OBJ))
#define WEBKIT_DOM_IS_TEST_OBJ_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass),  WEBKIT_DOM_TYPE_TEST_OBJ))
#define WEBKIT_DOM_TEST_OBJ_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj),  WEBKIT_DOM_TYPE_TEST_OBJ, WebKitDOMTestObjClass))

#if ENABLE(Condition1)
/**
 * WEBKIT_DOM_TEST_OBJ_CONDITIONAL_CONST:
 */
#define WEBKIT_DOM_TEST_OBJ_CONDITIONAL_CONST 0
#endif /* ENABLE(Condition1) */

/**
 * WEBKIT_DOM_TEST_OBJ_CONST_VALUE_0:
 */
#define WEBKIT_DOM_TEST_OBJ_CONST_VALUE_0 0

/**
 * WEBKIT_DOM_TEST_OBJ_CONST_VALUE_1:
 */
#define WEBKIT_DOM_TEST_OBJ_CONST_VALUE_1 1

/**
 * WEBKIT_DOM_TEST_OBJ_CONST_VALUE_2:
 */
#define WEBKIT_DOM_TEST_OBJ_CONST_VALUE_2 2

/**
 * WEBKIT_DOM_TEST_OBJ_CONST_VALUE_4:
 */
#define WEBKIT_DOM_TEST_OBJ_CONST_VALUE_4 4

/**
 * WEBKIT_DOM_TEST_OBJ_CONST_VALUE_8:
 */
#define WEBKIT_DOM_TEST_OBJ_CONST_VALUE_8 8

/**
 * WEBKIT_DOM_TEST_OBJ_CONST_VALUE_9:
 */
#define WEBKIT_DOM_TEST_OBJ_CONST_VALUE_9 -1

/**
 * WEBKIT_DOM_TEST_OBJ_CONST_VALUE_11:
 */
#define WEBKIT_DOM_TEST_OBJ_CONST_VALUE_11 0xffffffff

/**
 * WEBKIT_DOM_TEST_OBJ_CONST_VALUE_12:
 */
#define WEBKIT_DOM_TEST_OBJ_CONST_VALUE_12 0x01

/**
 * WEBKIT_DOM_TEST_OBJ_CONST_VALUE_13:
 */
#define WEBKIT_DOM_TEST_OBJ_CONST_VALUE_13 0X20

/**
 * WEBKIT_DOM_TEST_OBJ_CONST_VALUE_14:
 */
#define WEBKIT_DOM_TEST_OBJ_CONST_VALUE_14 0x1abc

/**
 * WEBKIT_DOM_TEST_OBJ_CONST_JAVASCRIPT:
 */
#define WEBKIT_DOM_TEST_OBJ_CONST_JAVASCRIPT 15

/**
 * WEBKIT_DOM_TEST_OBJ_readonly:
 */
#define WEBKIT_DOM_TEST_OBJ_readonly 0

struct _WebKitDOMTestObj {
    WebKitDOMObject parent_instance;
};

struct _WebKitDOMTestObjClass {
    WebKitDOMObjectClass parent_class;
};

WEBKIT_API GType
webkit_dom_test_obj_get_type(void);

/**
 * webkit_dom_test_obj_void_method:
 * @self: A #WebKitDOMTestObj
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_test_obj_void_method(WebKitDOMTestObj* self);

/**
 * webkit_dom_test_obj_void_method_with_args:
 * @self: A #WebKitDOMTestObj
 * @longArg: A #glong
 * @strArg: A #gchar
 * @objArg: A #WebKitDOMTestObj
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_test_obj_void_method_with_args(WebKitDOMTestObj* self, glong longArg, const gchar* strArg, WebKitDOMTestObj* objArg);

/**
 * webkit_dom_test_obj_byte_method:
 * @self: A #WebKitDOMTestObj
 *
 * Returns: A #gint8
 *
 * Stability: Unstable
**/
WEBKIT_API gint8
webkit_dom_test_obj_byte_method(WebKitDOMTestObj* self);

/**
 * webkit_dom_test_obj_byte_method_with_args:
 * @self: A #WebKitDOMTestObj
 * @byteArg: A #gint8
 * @strArg: A #gchar
 * @objArg: A #WebKitDOMTestObj
 *
 * Returns: A #gint8
 *
 * Stability: Unstable
**/
WEBKIT_API gint8
webkit_dom_test_obj_byte_method_with_args(WebKitDOMTestObj* self, gint8 byteArg, const gchar* strArg, WebKitDOMTestObj* objArg);

/**
 * webkit_dom_test_obj_octet_method:
 * @self: A #WebKitDOMTestObj
 *
 * Returns: A #guint8
 *
 * Stability: Unstable
**/
WEBKIT_API guint8
webkit_dom_test_obj_octet_method(WebKitDOMTestObj* self);

/**
 * webkit_dom_test_obj_octet_method_with_args:
 * @self: A #WebKitDOMTestObj
 * @octetArg: A #guint8
 * @strArg: A #gchar
 * @objArg: A #WebKitDOMTestObj
 *
 * Returns: A #guint8
 *
 * Stability: Unstable
**/
WEBKIT_API guint8
webkit_dom_test_obj_octet_method_with_args(WebKitDOMTestObj* self, guint8 octetArg, const gchar* strArg, WebKitDOMTestObj* objArg);

/**
 * webkit_dom_test_obj_long_method:
 * @self: A #WebKitDOMTestObj
 *
 * Returns: A #glong
 *
 * Stability: Unstable
**/
WEBKIT_API glong
webkit_dom_test_obj_long_method(WebKitDOMTestObj* self);

/**
 * webkit_dom_test_obj_long_method_with_args:
 * @self: A #WebKitDOMTestObj
 * @longArg: A #glong
 * @strArg: A #gchar
 * @objArg: A #WebKitDOMTestObj
 *
 * Returns: A #glong
 *
 * Stability: Unstable
**/
WEBKIT_API glong
webkit_dom_test_obj_long_method_with_args(WebKitDOMTestObj* self, glong longArg, const gchar* strArg, WebKitDOMTestObj* objArg);

/**
 * webkit_dom_test_obj_obj_method:
 * @self: A #WebKitDOMTestObj
 *
 * Returns: (transfer none): A #WebKitDOMTestObj
 *
 * Stability: Unstable
**/
WEBKIT_API WebKitDOMTestObj*
webkit_dom_test_obj_obj_method(WebKitDOMTestObj* self);

/**
 * webkit_dom_test_obj_obj_method_with_args:
 * @self: A #WebKitDOMTestObj
 * @longArg: A #glong
 * @strArg: A #gchar
 * @objArg: A #WebKitDOMTestObj
 *
 * Returns: (transfer none): A #WebKitDOMTestObj
 *
 * Stability: Unstable
**/
WEBKIT_API WebKitDOMTestObj*
webkit_dom_test_obj_obj_method_with_args(WebKitDOMTestObj* self, glong longArg, const gchar* strArg, WebKitDOMTestObj* objArg);

/**
 * webkit_dom_test_obj_unforgeable_method:
 * @self: A #WebKitDOMTestObj
 *
 * Returns: A #glong
 *
 * Stability: Unstable
**/
WEBKIT_API glong
webkit_dom_test_obj_unforgeable_method(WebKitDOMTestObj* self);

/**
 * webkit_dom_test_obj_method_with_enum_arg:
 * @self: A #WebKitDOMTestObj
 * @enumArg: A #WebKitDOMTestEnumType
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_test_obj_method_with_enum_arg(WebKitDOMTestObj* self, WebKitDOMTestEnumType* enumArg);

/**
 * webkit_dom_test_obj_method_with_optional_enum_arg_and_default_value:
 * @self: A #WebKitDOMTestObj
 * @enumArg: A #WebKitDOMTestEnumType
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_test_obj_method_with_optional_enum_arg_and_default_value(WebKitDOMTestObj* self, WebKitDOMTestEnumType* enumArg);

/**
 * webkit_dom_test_obj_method_that_requires_all_args_and_throws:
 * @self: A #WebKitDOMTestObj
 * @strArg: A #gchar
 * @objArg: A #WebKitDOMTestObj
 * @error: #GError
 *
 * Returns: (transfer none): A #WebKitDOMTestObj
 *
 * Stability: Unstable
**/
WEBKIT_API WebKitDOMTestObj*
webkit_dom_test_obj_method_that_requires_all_args_and_throws(WebKitDOMTestObj* self, const gchar* strArg, WebKitDOMTestObj* objArg, GError** error);

/**
 * webkit_dom_test_obj_serialized_value:
 * @self: A #WebKitDOMTestObj
 * @serializedArg: A #gchar
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_test_obj_serialized_value(WebKitDOMTestObj* self, const gchar* serializedArg);

/**
 * webkit_dom_test_obj_options_object:
 * @self: A #WebKitDOMTestObj
 * @oo: A #WebKitDOMDictionary
 * @ooo: A #WebKitDOMDictionary
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_test_obj_options_object(WebKitDOMTestObj* self, WebKitDOMDictionary* oo, WebKitDOMDictionary* ooo);

/**
 * webkit_dom_test_obj_method_with_exception:
 * @self: A #WebKitDOMTestObj
 * @error: #GError
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_test_obj_method_with_exception(WebKitDOMTestObj* self, GError** error);

/**
 * webkit_dom_test_obj_method_with_exception_with_message:
 * @self: A #WebKitDOMTestObj
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_test_obj_method_with_exception_with_message(WebKitDOMTestObj* self);

/**
 * webkit_dom_test_obj_with_script_state_void:
 * @self: A #WebKitDOMTestObj
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_test_obj_with_script_state_void(WebKitDOMTestObj* self);

/**
 * webkit_dom_test_obj_with_script_state_obj:
 * @self: A #WebKitDOMTestObj
 *
 * Returns: (transfer none): A #WebKitDOMTestObj
 *
 * Stability: Unstable
**/
WEBKIT_API WebKitDOMTestObj*
webkit_dom_test_obj_with_script_state_obj(WebKitDOMTestObj* self);

/**
 * webkit_dom_test_obj_with_script_state_void_exception:
 * @self: A #WebKitDOMTestObj
 * @error: #GError
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_test_obj_with_script_state_void_exception(WebKitDOMTestObj* self, GError** error);

/**
 * webkit_dom_test_obj_with_script_state_obj_exception:
 * @self: A #WebKitDOMTestObj
 * @error: #GError
 *
 * Returns: (transfer none): A #WebKitDOMTestObj
 *
 * Stability: Unstable
**/
WEBKIT_API WebKitDOMTestObj*
webkit_dom_test_obj_with_script_state_obj_exception(WebKitDOMTestObj* self, GError** error);

/**
 * webkit_dom_test_obj_with_script_execution_context:
 * @self: A #WebKitDOMTestObj
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_test_obj_with_script_execution_context(WebKitDOMTestObj* self);

/**
 * webkit_dom_test_obj_with_script_execution_context_and_script_state:
 * @self: A #WebKitDOMTestObj
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_test_obj_with_script_execution_context_and_script_state(WebKitDOMTestObj* self);

/**
 * webkit_dom_test_obj_with_script_execution_context_and_script_state_obj_exception:
 * @self: A #WebKitDOMTestObj
 * @error: #GError
 *
 * Returns: (transfer none): A #WebKitDOMTestObj
 *
 * Stability: Unstable
**/
WEBKIT_API WebKitDOMTestObj*
webkit_dom_test_obj_with_script_execution_context_and_script_state_obj_exception(WebKitDOMTestObj* self, GError** error);

/**
 * webkit_dom_test_obj_with_script_execution_context_and_script_state_with_spaces:
 * @self: A #WebKitDOMTestObj
 *
 * Returns: (transfer none): A #WebKitDOMTestObj
 *
 * Stability: Unstable
**/
WEBKIT_API WebKitDOMTestObj*
webkit_dom_test_obj_with_script_execution_context_and_script_state_with_spaces(WebKitDOMTestObj* self);

/**
 * webkit_dom_test_obj_method_with_optional_arg:
 * @self: A #WebKitDOMTestObj
 * @opt: A #glong
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_test_obj_method_with_optional_arg(WebKitDOMTestObj* self, glong opt);

/**
 * webkit_dom_test_obj_method_with_optional_arg_and_default_value:
 * @self: A #WebKitDOMTestObj
 * @opt: A #glong
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_test_obj_method_with_optional_arg_and_default_value(WebKitDOMTestObj* self, glong opt);

/**
 * webkit_dom_test_obj_method_with_non_optional_arg_and_optional_arg:
 * @self: A #WebKitDOMTestObj
 * @nonOpt: A #glong
 * @opt: A #glong
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_test_obj_method_with_non_optional_arg_and_optional_arg(WebKitDOMTestObj* self, glong nonOpt, glong opt);

/**
 * webkit_dom_test_obj_method_with_non_optional_arg_and_two_optional_args:
 * @self: A #WebKitDOMTestObj
 * @nonOpt: A #glong
 * @opt1: A #glong
 * @opt2: A #glong
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_test_obj_method_with_non_optional_arg_and_two_optional_args(WebKitDOMTestObj* self, glong nonOpt, glong opt1, glong opt2);

/**
 * webkit_dom_test_obj_method_with_optional_string:
 * @self: A #WebKitDOMTestObj
 * @str: A #gchar
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_test_obj_method_with_optional_string(WebKitDOMTestObj* self, const gchar* str);

/**
 * webkit_dom_test_obj_method_with_optional_string_and_default_value:
 * @self: A #WebKitDOMTestObj
 * @str: A #gchar
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_test_obj_method_with_optional_string_and_default_value(WebKitDOMTestObj* self, const gchar* str);

/**
 * webkit_dom_test_obj_method_with_optional_string_is_undefined:
 * @self: A #WebKitDOMTestObj
 * @str: A #gchar
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_test_obj_method_with_optional_string_is_undefined(WebKitDOMTestObj* self, const gchar* str);

/**
 * webkit_dom_test_obj_method_with_optional_string_is_null_string:
 * @self: A #WebKitDOMTestObj
 * @str: A #gchar
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_test_obj_method_with_optional_string_is_null_string(WebKitDOMTestObj* self, const gchar* str);

/**
 * webkit_dom_test_obj_conditional_method1:
 * @self: A #WebKitDOMTestObj
 *
 * Returns: A #gchar
 *
 * Stability: Unstable
**/
WEBKIT_API gchar*
webkit_dom_test_obj_conditional_method1(WebKitDOMTestObj* self);

/**
 * webkit_dom_test_obj_conditional_method2:
 * @self: A #WebKitDOMTestObj
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_test_obj_conditional_method2(WebKitDOMTestObj* self);

/**
 * webkit_dom_test_obj_conditional_method3:
 * @self: A #WebKitDOMTestObj
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_test_obj_conditional_method3(WebKitDOMTestObj* self);

/**
 * webkit_dom_test_obj_convert1:
 * @self: A #WebKitDOMTestObj
 * @value: A #WebKitDOMTestNode
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_test_obj_convert1(WebKitDOMTestObj* self, WebKitDOMTestNode* value);

/**
 * webkit_dom_test_obj_convert2:
 * @self: A #WebKitDOMTestObj
 * @value: A #WebKitDOMTestNode
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_test_obj_convert2(WebKitDOMTestObj* self, WebKitDOMTestNode* value);

/**
 * webkit_dom_test_obj_convert4:
 * @self: A #WebKitDOMTestObj
 * @value: A #WebKitDOMTestNode
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_test_obj_convert4(WebKitDOMTestObj* self, WebKitDOMTestNode* value);

/**
 * webkit_dom_test_obj_convert5:
 * @self: A #WebKitDOMTestObj
 * @value: A #WebKitDOMTestNode
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_test_obj_convert5(WebKitDOMTestObj* self, WebKitDOMTestNode* value);

/**
 * webkit_dom_test_obj_mutable_point_function:
 * @self: A #WebKitDOMTestObj
 *
 * Returns: (transfer none): A #WebKitDOMSVGPoint
 *
 * Stability: Unstable
**/
WEBKIT_API WebKitDOMSVGPoint*
webkit_dom_test_obj_mutable_point_function(WebKitDOMTestObj* self);

/**
 * webkit_dom_test_obj_immutable_point_function:
 * @self: A #WebKitDOMTestObj
 *
 * Returns: (transfer none): A #WebKitDOMSVGPoint
 *
 * Stability: Unstable
**/
WEBKIT_API WebKitDOMSVGPoint*
webkit_dom_test_obj_immutable_point_function(WebKitDOMTestObj* self);

/**
 * webkit_dom_test_obj_orange:
 * @self: A #WebKitDOMTestObj
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_test_obj_orange(WebKitDOMTestObj* self);

/**
 * webkit_dom_test_obj_strict_function:
 * @self: A #WebKitDOMTestObj
 * @str: A #gchar
 * @a: A #gfloat
 * @b: A #glong
 * @error: #GError
 *
 * Returns: (transfer none): A #WebKitDOMbool
 *
 * Stability: Unstable
**/
WEBKIT_API WebKitDOMbool*
webkit_dom_test_obj_strict_function(WebKitDOMTestObj* self, const gchar* str, gfloat a, glong b, GError** error);

/**
 * webkit_dom_test_obj_strict_function_with_array:
 * @self: A #WebKitDOMTestObj
 * @objArg: A #WebKitDOMTestObj
 * @array: A #glong
 * @error: #GError
 *
 * Returns: (transfer none): A #WebKitDOMbool
 *
 * Stability: Unstable
**/
WEBKIT_API WebKitDOMbool*
webkit_dom_test_obj_strict_function_with_array(WebKitDOMTestObj* self, WebKitDOMTestObj* objArg, glong array, GError** error);

/**
 * webkit_dom_test_obj_variadic_string_method:
 * @self: A #WebKitDOMTestObj
 * @head: A #gchar
 * @tail: A #gchar
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_test_obj_variadic_string_method(WebKitDOMTestObj* self, const gchar* head, const gchar* tail);

/**
 * webkit_dom_test_obj_variadic_double_method:
 * @self: A #WebKitDOMTestObj
 * @head: A #gdouble
 * @tail: A #gdouble
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_test_obj_variadic_double_method(WebKitDOMTestObj* self, gdouble head, gdouble tail);

/**
 * webkit_dom_test_obj_variadic_node_method:
 * @self: A #WebKitDOMTestObj
 * @head: A #WebKitDOMNode
 * @tail: A #WebKitDOMNode
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_test_obj_variadic_node_method(WebKitDOMTestObj* self, WebKitDOMNode* head, WebKitDOMNode* tail);

/**
 * webkit_dom_test_obj_any:
 * @self: A #WebKitDOMTestObj
 * @a: A #gfloat
 * @b: A #glong
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_test_obj_any(WebKitDOMTestObj* self, gfloat a, glong b);

/**
 * webkit_dom_test_obj_get_read_only_long_attr:
 * @self: A #WebKitDOMTestObj
 *
 * Returns: A #glong
 *
 * Stability: Unstable
**/
WEBKIT_API glong
webkit_dom_test_obj_get_read_only_long_attr(WebKitDOMTestObj* self);

/**
 * webkit_dom_test_obj_get_read_only_string_attr:
 * @self: A #WebKitDOMTestObj
 *
 * Returns: A #gchar
 *
 * Stability: Unstable
**/
WEBKIT_API gchar*
webkit_dom_test_obj_get_read_only_string_attr(WebKitDOMTestObj* self);

/**
 * webkit_dom_test_obj_get_read_only_test_obj_attr:
 * @self: A #WebKitDOMTestObj
 *
 * Returns: (transfer none): A #WebKitDOMTestObj
 *
 * Stability: Unstable
**/
WEBKIT_API WebKitDOMTestObj*
webkit_dom_test_obj_get_read_only_test_obj_attr(WebKitDOMTestObj* self);

/**
 * webkit_dom_test_obj_get_byte_attr:
 * @self: A #WebKitDOMTestObj
 *
 * Returns: A #gint8
 *
 * Stability: Unstable
**/
WEBKIT_API gint8
webkit_dom_test_obj_get_byte_attr(WebKitDOMTestObj* self);

/**
 * webkit_dom_test_obj_set_byte_attr:
 * @self: A #WebKitDOMTestObj
 * @value: A #gint8
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_test_obj_set_byte_attr(WebKitDOMTestObj* self, gint8 value);

/**
 * webkit_dom_test_obj_get_octet_attr:
 * @self: A #WebKitDOMTestObj
 *
 * Returns: A #guint8
 *
 * Stability: Unstable
**/
WEBKIT_API guint8
webkit_dom_test_obj_get_octet_attr(WebKitDOMTestObj* self);

/**
 * webkit_dom_test_obj_set_octet_attr:
 * @self: A #WebKitDOMTestObj
 * @value: A #guint8
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_test_obj_set_octet_attr(WebKitDOMTestObj* self, guint8 value);

/**
 * webkit_dom_test_obj_get_short_attr:
 * @self: A #WebKitDOMTestObj
 *
 * Returns: A #gshort
 *
 * Stability: Unstable
**/
WEBKIT_API gshort
webkit_dom_test_obj_get_short_attr(WebKitDOMTestObj* self);

/**
 * webkit_dom_test_obj_set_short_attr:
 * @self: A #WebKitDOMTestObj
 * @value: A #gshort
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_test_obj_set_short_attr(WebKitDOMTestObj* self, gshort value);

/**
 * webkit_dom_test_obj_get_unsigned_short_attr:
 * @self: A #WebKitDOMTestObj
 *
 * Returns: A #gushort
 *
 * Stability: Unstable
**/
WEBKIT_API gushort
webkit_dom_test_obj_get_unsigned_short_attr(WebKitDOMTestObj* self);

/**
 * webkit_dom_test_obj_set_unsigned_short_attr:
 * @self: A #WebKitDOMTestObj
 * @value: A #gushort
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_test_obj_set_unsigned_short_attr(WebKitDOMTestObj* self, gushort value);

/**
 * webkit_dom_test_obj_get_long_attr:
 * @self: A #WebKitDOMTestObj
 *
 * Returns: A #glong
 *
 * Stability: Unstable
**/
WEBKIT_API glong
webkit_dom_test_obj_get_long_attr(WebKitDOMTestObj* self);

/**
 * webkit_dom_test_obj_set_long_attr:
 * @self: A #WebKitDOMTestObj
 * @value: A #glong
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_test_obj_set_long_attr(WebKitDOMTestObj* self, glong value);

/**
 * webkit_dom_test_obj_get_long_long_attr:
 * @self: A #WebKitDOMTestObj
 *
 * Returns: A #gint64
 *
 * Stability: Unstable
**/
WEBKIT_API gint64
webkit_dom_test_obj_get_long_long_attr(WebKitDOMTestObj* self);

/**
 * webkit_dom_test_obj_set_long_long_attr:
 * @self: A #WebKitDOMTestObj
 * @value: A #gint64
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_test_obj_set_long_long_attr(WebKitDOMTestObj* self, gint64 value);

/**
 * webkit_dom_test_obj_get_unsigned_long_long_attr:
 * @self: A #WebKitDOMTestObj
 *
 * Returns: A #guint64
 *
 * Stability: Unstable
**/
WEBKIT_API guint64
webkit_dom_test_obj_get_unsigned_long_long_attr(WebKitDOMTestObj* self);

/**
 * webkit_dom_test_obj_set_unsigned_long_long_attr:
 * @self: A #WebKitDOMTestObj
 * @value: A #guint64
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_test_obj_set_unsigned_long_long_attr(WebKitDOMTestObj* self, guint64 value);

/**
 * webkit_dom_test_obj_get_string_attr:
 * @self: A #WebKitDOMTestObj
 *
 * Returns: A #gchar
 *
 * Stability: Unstable
**/
WEBKIT_API gchar*
webkit_dom_test_obj_get_string_attr(WebKitDOMTestObj* self);

/**
 * webkit_dom_test_obj_set_string_attr:
 * @self: A #WebKitDOMTestObj
 * @value: A #gchar
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_test_obj_set_string_attr(WebKitDOMTestObj* self, const gchar* value);

/**
 * webkit_dom_test_obj_get_test_obj_attr:
 * @self: A #WebKitDOMTestObj
 *
 * Returns: (transfer none): A #WebKitDOMTestObj
 *
 * Stability: Unstable
**/
WEBKIT_API WebKitDOMTestObj*
webkit_dom_test_obj_get_test_obj_attr(WebKitDOMTestObj* self);

/**
 * webkit_dom_test_obj_set_test_obj_attr:
 * @self: A #WebKitDOMTestObj
 * @value: A #WebKitDOMTestObj
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_test_obj_set_test_obj_attr(WebKitDOMTestObj* self, WebKitDOMTestObj* value);

/**
 * webkit_dom_test_obj_get_lenient_test_obj_attr:
 * @self: A #WebKitDOMTestObj
 *
 * Returns: (transfer none): A #WebKitDOMTestObj
 *
 * Stability: Unstable
**/
WEBKIT_API WebKitDOMTestObj*
webkit_dom_test_obj_get_lenient_test_obj_attr(WebKitDOMTestObj* self);

/**
 * webkit_dom_test_obj_set_lenient_test_obj_attr:
 * @self: A #WebKitDOMTestObj
 * @value: A #WebKitDOMTestObj
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_test_obj_set_lenient_test_obj_attr(WebKitDOMTestObj* self, WebKitDOMTestObj* value);

/**
 * webkit_dom_test_obj_get_unforgeable_attr:
 * @self: A #WebKitDOMTestObj
 *
 * Returns: A #gchar
 *
 * Stability: Unstable
**/
WEBKIT_API gchar*
webkit_dom_test_obj_get_unforgeable_attr(WebKitDOMTestObj* self);

/**
 * webkit_dom_test_obj_get_xml_obj_attr:
 * @self: A #WebKitDOMTestObj
 *
 * Returns: (transfer none): A #WebKitDOMTestObj
 *
 * Stability: Unstable
**/
WEBKIT_API WebKitDOMTestObj*
webkit_dom_test_obj_get_xml_obj_attr(WebKitDOMTestObj* self);

/**
 * webkit_dom_test_obj_set_xml_obj_attr:
 * @self: A #WebKitDOMTestObj
 * @value: A #WebKitDOMTestObj
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_test_obj_set_xml_obj_attr(WebKitDOMTestObj* self, WebKitDOMTestObj* value);

/**
 * webkit_dom_test_obj_get_create:
 * @self: A #WebKitDOMTestObj
 *
 * Returns: A #gboolean
 *
 * Stability: Unstable
**/
WEBKIT_API gboolean
webkit_dom_test_obj_get_create(WebKitDOMTestObj* self);

/**
 * webkit_dom_test_obj_set_create:
 * @self: A #WebKitDOMTestObj
 * @value: A #gboolean
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_test_obj_set_create(WebKitDOMTestObj* self, gboolean value);

/**
 * webkit_dom_test_obj_get_reflected_string_attr:
 * @self: A #WebKitDOMTestObj
 *
 * Returns: A #gchar
 *
 * Stability: Unstable
**/
WEBKIT_API gchar*
webkit_dom_test_obj_get_reflected_string_attr(WebKitDOMTestObj* self);

/**
 * webkit_dom_test_obj_set_reflected_string_attr:
 * @self: A #WebKitDOMTestObj
 * @value: A #gchar
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_test_obj_set_reflected_string_attr(WebKitDOMTestObj* self, const gchar* value);

/**
 * webkit_dom_test_obj_get_reflected_integral_attr:
 * @self: A #WebKitDOMTestObj
 *
 * Returns: A #glong
 *
 * Stability: Unstable
**/
WEBKIT_API glong
webkit_dom_test_obj_get_reflected_integral_attr(WebKitDOMTestObj* self);

/**
 * webkit_dom_test_obj_set_reflected_integral_attr:
 * @self: A #WebKitDOMTestObj
 * @value: A #glong
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_test_obj_set_reflected_integral_attr(WebKitDOMTestObj* self, glong value);

/**
 * webkit_dom_test_obj_get_reflected_unsigned_integral_attr:
 * @self: A #WebKitDOMTestObj
 *
 * Returns: A #gulong
 *
 * Stability: Unstable
**/
WEBKIT_API gulong
webkit_dom_test_obj_get_reflected_unsigned_integral_attr(WebKitDOMTestObj* self);

/**
 * webkit_dom_test_obj_set_reflected_unsigned_integral_attr:
 * @self: A #WebKitDOMTestObj
 * @value: A #gulong
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_test_obj_set_reflected_unsigned_integral_attr(WebKitDOMTestObj* self, gulong value);

/**
 * webkit_dom_test_obj_get_reflected_boolean_attr:
 * @self: A #WebKitDOMTestObj
 *
 * Returns: A #gboolean
 *
 * Stability: Unstable
**/
WEBKIT_API gboolean
webkit_dom_test_obj_get_reflected_boolean_attr(WebKitDOMTestObj* self);

/**
 * webkit_dom_test_obj_set_reflected_boolean_attr:
 * @self: A #WebKitDOMTestObj
 * @value: A #gboolean
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_test_obj_set_reflected_boolean_attr(WebKitDOMTestObj* self, gboolean value);

/**
 * webkit_dom_test_obj_get_reflected_url_attr:
 * @self: A #WebKitDOMTestObj
 *
 * Returns: A #gchar
 *
 * Stability: Unstable
**/
WEBKIT_API gchar*
webkit_dom_test_obj_get_reflected_url_attr(WebKitDOMTestObj* self);

/**
 * webkit_dom_test_obj_set_reflected_url_attr:
 * @self: A #WebKitDOMTestObj
 * @value: A #gchar
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_test_obj_set_reflected_url_attr(WebKitDOMTestObj* self, const gchar* value);

/**
 * webkit_dom_test_obj_get_reflected_string_attr:
 * @self: A #WebKitDOMTestObj
 *
 * Returns: A #gchar
 *
 * Stability: Unstable
**/
WEBKIT_API gchar*
webkit_dom_test_obj_get_reflected_string_attr(WebKitDOMTestObj* self);

/**
 * webkit_dom_test_obj_set_reflected_string_attr:
 * @self: A #WebKitDOMTestObj
 * @value: A #gchar
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_test_obj_set_reflected_string_attr(WebKitDOMTestObj* self, const gchar* value);

/**
 * webkit_dom_test_obj_get_reflected_custom_integral_attr:
 * @self: A #WebKitDOMTestObj
 *
 * Returns: A #glong
 *
 * Stability: Unstable
**/
WEBKIT_API glong
webkit_dom_test_obj_get_reflected_custom_integral_attr(WebKitDOMTestObj* self);

/**
 * webkit_dom_test_obj_set_reflected_custom_integral_attr:
 * @self: A #WebKitDOMTestObj
 * @value: A #glong
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_test_obj_set_reflected_custom_integral_attr(WebKitDOMTestObj* self, glong value);

/**
 * webkit_dom_test_obj_get_reflected_custom_boolean_attr:
 * @self: A #WebKitDOMTestObj
 *
 * Returns: A #gboolean
 *
 * Stability: Unstable
**/
WEBKIT_API gboolean
webkit_dom_test_obj_get_reflected_custom_boolean_attr(WebKitDOMTestObj* self);

/**
 * webkit_dom_test_obj_set_reflected_custom_boolean_attr:
 * @self: A #WebKitDOMTestObj
 * @value: A #gboolean
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_test_obj_set_reflected_custom_boolean_attr(WebKitDOMTestObj* self, gboolean value);

/**
 * webkit_dom_test_obj_get_reflected_custom_url_attr:
 * @self: A #WebKitDOMTestObj
 *
 * Returns: A #gchar
 *
 * Stability: Unstable
**/
WEBKIT_API gchar*
webkit_dom_test_obj_get_reflected_custom_url_attr(WebKitDOMTestObj* self);

/**
 * webkit_dom_test_obj_set_reflected_custom_url_attr:
 * @self: A #WebKitDOMTestObj
 * @value: A #gchar
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_test_obj_set_reflected_custom_url_attr(WebKitDOMTestObj* self, const gchar* value);

/**
 * webkit_dom_test_obj_get_attr_with_getter_exception:
 * @self: A #WebKitDOMTestObj
 * @error: #GError
 *
 * Returns: A #glong
 *
 * Stability: Unstable
**/
WEBKIT_API glong
webkit_dom_test_obj_get_attr_with_getter_exception(WebKitDOMTestObj* self, GError** error);

/**
 * webkit_dom_test_obj_set_attr_with_getter_exception:
 * @self: A #WebKitDOMTestObj
 * @value: A #glong
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_test_obj_set_attr_with_getter_exception(WebKitDOMTestObj* self, glong value);

/**
 * webkit_dom_test_obj_get_attr_with_getter_exception_with_message:
 * @self: A #WebKitDOMTestObj
 *
 * Returns: A #glong
 *
 * Stability: Unstable
**/
WEBKIT_API glong
webkit_dom_test_obj_get_attr_with_getter_exception_with_message(WebKitDOMTestObj* self);

/**
 * webkit_dom_test_obj_set_attr_with_getter_exception_with_message:
 * @self: A #WebKitDOMTestObj
 * @value: A #glong
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_test_obj_set_attr_with_getter_exception_with_message(WebKitDOMTestObj* self, glong value);

/**
 * webkit_dom_test_obj_get_attr_with_setter_exception:
 * @self: A #WebKitDOMTestObj
 *
 * Returns: A #glong
 *
 * Stability: Unstable
**/
WEBKIT_API glong
webkit_dom_test_obj_get_attr_with_setter_exception(WebKitDOMTestObj* self);

/**
 * webkit_dom_test_obj_set_attr_with_setter_exception:
 * @self: A #WebKitDOMTestObj
 * @value: A #glong
 * @error: #GError
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_test_obj_set_attr_with_setter_exception(WebKitDOMTestObj* self, glong value, GError** error);

/**
 * webkit_dom_test_obj_get_attr_with_setter_exception_with_message:
 * @self: A #WebKitDOMTestObj
 *
 * Returns: A #glong
 *
 * Stability: Unstable
**/
WEBKIT_API glong
webkit_dom_test_obj_get_attr_with_setter_exception_with_message(WebKitDOMTestObj* self);

/**
 * webkit_dom_test_obj_set_attr_with_setter_exception_with_message:
 * @self: A #WebKitDOMTestObj
 * @value: A #glong
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_test_obj_set_attr_with_setter_exception_with_message(WebKitDOMTestObj* self, glong value);

/**
 * webkit_dom_test_obj_get_string_attr_with_getter_exception:
 * @self: A #WebKitDOMTestObj
 * @error: #GError
 *
 * Returns: A #gchar
 *
 * Stability: Unstable
**/
WEBKIT_API gchar*
webkit_dom_test_obj_get_string_attr_with_getter_exception(WebKitDOMTestObj* self, GError** error);

/**
 * webkit_dom_test_obj_set_string_attr_with_getter_exception:
 * @self: A #WebKitDOMTestObj
 * @value: A #gchar
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_test_obj_set_string_attr_with_getter_exception(WebKitDOMTestObj* self, const gchar* value);

/**
 * webkit_dom_test_obj_get_string_attr_with_setter_exception:
 * @self: A #WebKitDOMTestObj
 *
 * Returns: A #gchar
 *
 * Stability: Unstable
**/
WEBKIT_API gchar*
webkit_dom_test_obj_get_string_attr_with_setter_exception(WebKitDOMTestObj* self);

/**
 * webkit_dom_test_obj_set_string_attr_with_setter_exception:
 * @self: A #WebKitDOMTestObj
 * @value: A #gchar
 * @error: #GError
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_test_obj_set_string_attr_with_setter_exception(WebKitDOMTestObj* self, const gchar* value, GError** error);

/**
 * webkit_dom_test_obj_get_strict_type_checking_attribute:
 * @self: A #WebKitDOMTestObj
 *
 * Returns: (transfer none): A #WebKitDOMTestObj
 *
 * Stability: Unstable
**/
WEBKIT_API WebKitDOMTestObj*
webkit_dom_test_obj_get_strict_type_checking_attribute(WebKitDOMTestObj* self);

/**
 * webkit_dom_test_obj_set_strict_type_checking_attribute:
 * @self: A #WebKitDOMTestObj
 * @value: A #WebKitDOMTestObj
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_test_obj_set_strict_type_checking_attribute(WebKitDOMTestObj* self, WebKitDOMTestObj* value);

/**
 * webkit_dom_test_obj_get_with_script_state_attribute:
 * @self: A #WebKitDOMTestObj
 *
 * Returns: A #glong
 *
 * Stability: Unstable
**/
WEBKIT_API glong
webkit_dom_test_obj_get_with_script_state_attribute(WebKitDOMTestObj* self);

/**
 * webkit_dom_test_obj_get_with_call_with_and_setter_call_with_attribute:
 * @self: A #WebKitDOMTestObj
 *
 * Returns: A #glong
 *
 * Stability: Unstable
**/
WEBKIT_API glong
webkit_dom_test_obj_get_with_call_with_and_setter_call_with_attribute(WebKitDOMTestObj* self);

/**
 * webkit_dom_test_obj_get_with_script_execution_context_attribute:
 * @self: A #WebKitDOMTestObj
 *
 * Returns: (transfer none): A #WebKitDOMTestObj
 *
 * Stability: Unstable
**/
WEBKIT_API WebKitDOMTestObj*
webkit_dom_test_obj_get_with_script_execution_context_attribute(WebKitDOMTestObj* self);

/**
 * webkit_dom_test_obj_get_with_script_state_attribute_raises:
 * @self: A #WebKitDOMTestObj
 * @error: #GError
 *
 * Returns: (transfer none): A #WebKitDOMTestObj
 *
 * Stability: Unstable
**/
WEBKIT_API WebKitDOMTestObj*
webkit_dom_test_obj_get_with_script_state_attribute_raises(WebKitDOMTestObj* self, GError** error);

/**
 * webkit_dom_test_obj_get_with_script_execution_context_attribute_raises:
 * @self: A #WebKitDOMTestObj
 * @error: #GError
 *
 * Returns: (transfer none): A #WebKitDOMTestObj
 *
 * Stability: Unstable
**/
WEBKIT_API WebKitDOMTestObj*
webkit_dom_test_obj_get_with_script_execution_context_attribute_raises(WebKitDOMTestObj* self, GError** error);

/**
 * webkit_dom_test_obj_get_with_script_execution_context_and_script_state_attribute:
 * @self: A #WebKitDOMTestObj
 *
 * Returns: (transfer none): A #WebKitDOMTestObj
 *
 * Stability: Unstable
**/
WEBKIT_API WebKitDOMTestObj*
webkit_dom_test_obj_get_with_script_execution_context_and_script_state_attribute(WebKitDOMTestObj* self);

/**
 * webkit_dom_test_obj_get_with_script_execution_context_and_script_state_attribute_raises:
 * @self: A #WebKitDOMTestObj
 * @error: #GError
 *
 * Returns: (transfer none): A #WebKitDOMTestObj
 *
 * Stability: Unstable
**/
WEBKIT_API WebKitDOMTestObj*
webkit_dom_test_obj_get_with_script_execution_context_and_script_state_attribute_raises(WebKitDOMTestObj* self, GError** error);

/**
 * webkit_dom_test_obj_get_with_script_execution_context_and_script_state_with_spaces_attribute:
 * @self: A #WebKitDOMTestObj
 *
 * Returns: (transfer none): A #WebKitDOMTestObj
 *
 * Stability: Unstable
**/
WEBKIT_API WebKitDOMTestObj*
webkit_dom_test_obj_get_with_script_execution_context_and_script_state_with_spaces_attribute(WebKitDOMTestObj* self);

/**
 * webkit_dom_test_obj_get_conditional_attr1:
 * @self: A #WebKitDOMTestObj
 *
 * Returns: A #glong
 *
 * Stability: Unstable
**/
WEBKIT_API glong
webkit_dom_test_obj_get_conditional_attr1(WebKitDOMTestObj* self);

/**
 * webkit_dom_test_obj_set_conditional_attr1:
 * @self: A #WebKitDOMTestObj
 * @value: A #glong
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_test_obj_set_conditional_attr1(WebKitDOMTestObj* self, glong value);

/**
 * webkit_dom_test_obj_get_conditional_attr2:
 * @self: A #WebKitDOMTestObj
 *
 * Returns: A #glong
 *
 * Stability: Unstable
**/
WEBKIT_API glong
webkit_dom_test_obj_get_conditional_attr2(WebKitDOMTestObj* self);

/**
 * webkit_dom_test_obj_set_conditional_attr2:
 * @self: A #WebKitDOMTestObj
 * @value: A #glong
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_test_obj_set_conditional_attr2(WebKitDOMTestObj* self, glong value);

/**
 * webkit_dom_test_obj_get_conditional_attr3:
 * @self: A #WebKitDOMTestObj
 *
 * Returns: A #glong
 *
 * Stability: Unstable
**/
WEBKIT_API glong
webkit_dom_test_obj_get_conditional_attr3(WebKitDOMTestObj* self);

/**
 * webkit_dom_test_obj_set_conditional_attr3:
 * @self: A #WebKitDOMTestObj
 * @value: A #glong
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_test_obj_set_conditional_attr3(WebKitDOMTestObj* self, glong value);

/**
 * webkit_dom_test_obj_get_any_attribute:
 * @self: A #WebKitDOMTestObj
 *
 * Returns: (transfer none): A #WebKitDOMany
 *
 * Stability: Unstable
**/
WEBKIT_API WebKitDOMany*
webkit_dom_test_obj_get_any_attribute(WebKitDOMTestObj* self);

/**
 * webkit_dom_test_obj_set_any_attribute:
 * @self: A #WebKitDOMTestObj
 * @value: A #WebKitDOMany
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_test_obj_set_any_attribute(WebKitDOMTestObj* self, WebKitDOMany* value);

/**
 * webkit_dom_test_obj_get_content_document:
 * @self: A #WebKitDOMTestObj
 *
 * Returns: (transfer none): A #WebKitDOMDocument
 *
 * Stability: Unstable
**/
WEBKIT_API WebKitDOMDocument*
webkit_dom_test_obj_get_content_document(WebKitDOMTestObj* self);

/**
 * webkit_dom_test_obj_get_mutable_point:
 * @self: A #WebKitDOMTestObj
 *
 * Returns: (transfer none): A #WebKitDOMSVGPoint
 *
 * Stability: Unstable
**/
WEBKIT_API WebKitDOMSVGPoint*
webkit_dom_test_obj_get_mutable_point(WebKitDOMTestObj* self);

/**
 * webkit_dom_test_obj_set_mutable_point:
 * @self: A #WebKitDOMTestObj
 * @value: A #WebKitDOMSVGPoint
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_test_obj_set_mutable_point(WebKitDOMTestObj* self, WebKitDOMSVGPoint* value);

/**
 * webkit_dom_test_obj_get_immutable_point:
 * @self: A #WebKitDOMTestObj
 *
 * Returns: (transfer none): A #WebKitDOMSVGPoint
 *
 * Stability: Unstable
**/
WEBKIT_API WebKitDOMSVGPoint*
webkit_dom_test_obj_get_immutable_point(WebKitDOMTestObj* self);

/**
 * webkit_dom_test_obj_set_immutable_point:
 * @self: A #WebKitDOMTestObj
 * @value: A #WebKitDOMSVGPoint
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_test_obj_set_immutable_point(WebKitDOMTestObj* self, WebKitDOMSVGPoint* value);

/**
 * webkit_dom_test_obj_get_strawberry:
 * @self: A #WebKitDOMTestObj
 *
 * Returns: A #glong
 *
 * Stability: Unstable
**/
WEBKIT_API glong
webkit_dom_test_obj_get_strawberry(WebKitDOMTestObj* self);

/**
 * webkit_dom_test_obj_set_strawberry:
 * @self: A #WebKitDOMTestObj
 * @value: A #glong
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_test_obj_set_strawberry(WebKitDOMTestObj* self, glong value);

/**
 * webkit_dom_test_obj_get_strict_float:
 * @self: A #WebKitDOMTestObj
 *
 * Returns: A #gfloat
 *
 * Stability: Unstable
**/
WEBKIT_API gfloat
webkit_dom_test_obj_get_strict_float(WebKitDOMTestObj* self);

/**
 * webkit_dom_test_obj_set_strict_float:
 * @self: A #WebKitDOMTestObj
 * @value: A #gfloat
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_test_obj_set_strict_float(WebKitDOMTestObj* self, gfloat value);

/**
 * webkit_dom_test_obj_get_description:
 * @self: A #WebKitDOMTestObj
 *
 * Returns: A #glong
 *
 * Stability: Unstable
**/
WEBKIT_API glong
webkit_dom_test_obj_get_description(WebKitDOMTestObj* self);

/**
 * webkit_dom_test_obj_get_id:
 * @self: A #WebKitDOMTestObj
 *
 * Returns: A #glong
 *
 * Stability: Unstable
**/
WEBKIT_API glong
webkit_dom_test_obj_get_id(WebKitDOMTestObj* self);

/**
 * webkit_dom_test_obj_set_id:
 * @self: A #WebKitDOMTestObj
 * @value: A #glong
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_test_obj_set_id(WebKitDOMTestObj* self, glong value);

/**
 * webkit_dom_test_obj_get_hash:
 * @self: A #WebKitDOMTestObj
 *
 * Returns: A #gchar
 *
 * Stability: Unstable
**/
WEBKIT_API gchar*
webkit_dom_test_obj_get_hash(WebKitDOMTestObj* self);

/**
 * webkit_dom_test_obj_get_replaceable_attribute:
 * @self: A #WebKitDOMTestObj
 *
 * Returns: A #glong
 *
 * Stability: Unstable
**/
WEBKIT_API glong
webkit_dom_test_obj_get_replaceable_attribute(WebKitDOMTestObj* self);

/**
 * webkit_dom_test_obj_get_nullable_double_attribute:
 * @self: A #WebKitDOMTestObj
 *
 * Returns: A #gdouble
 *
 * Stability: Unstable
**/
WEBKIT_API gdouble
webkit_dom_test_obj_get_nullable_double_attribute(WebKitDOMTestObj* self);

/**
 * webkit_dom_test_obj_get_nullable_long_attribute:
 * @self: A #WebKitDOMTestObj
 *
 * Returns: A #glong
 *
 * Stability: Unstable
**/
WEBKIT_API glong
webkit_dom_test_obj_get_nullable_long_attribute(WebKitDOMTestObj* self);

/**
 * webkit_dom_test_obj_get_nullable_boolean_attribute:
 * @self: A #WebKitDOMTestObj
 *
 * Returns: A #gboolean
 *
 * Stability: Unstable
**/
WEBKIT_API gboolean
webkit_dom_test_obj_get_nullable_boolean_attribute(WebKitDOMTestObj* self);

/**
 * webkit_dom_test_obj_get_nullable_string_attribute:
 * @self: A #WebKitDOMTestObj
 *
 * Returns: A #gchar
 *
 * Stability: Unstable
**/
WEBKIT_API gchar*
webkit_dom_test_obj_get_nullable_string_attribute(WebKitDOMTestObj* self);

/**
 * webkit_dom_test_obj_get_nullable_long_settable_attribute:
 * @self: A #WebKitDOMTestObj
 *
 * Returns: A #glong
 *
 * Stability: Unstable
**/
WEBKIT_API glong
webkit_dom_test_obj_get_nullable_long_settable_attribute(WebKitDOMTestObj* self);

/**
 * webkit_dom_test_obj_set_nullable_long_settable_attribute:
 * @self: A #WebKitDOMTestObj
 * @value: A #glong
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_test_obj_set_nullable_long_settable_attribute(WebKitDOMTestObj* self, glong value);

/**
 * webkit_dom_test_obj_get_nullable_string_value:
 * @self: A #WebKitDOMTestObj
 * @error: #GError
 *
 * Returns: A #glong
 *
 * Stability: Unstable
**/
WEBKIT_API glong
webkit_dom_test_obj_get_nullable_string_value(WebKitDOMTestObj* self, GError** error);

/**
 * webkit_dom_test_obj_set_nullable_string_value:
 * @self: A #WebKitDOMTestObj
 * @value: A #glong
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_test_obj_set_nullable_string_value(WebKitDOMTestObj* self, glong value);

/**
 * webkit_dom_test_obj_get_attribute:
 * @self: A #WebKitDOMTestObj
 *
 * Returns: A #gchar
 *
 * Stability: Unstable
**/
WEBKIT_API gchar*
webkit_dom_test_obj_get_attribute(WebKitDOMTestObj* self);

/**
 * webkit_dom_test_obj_get_put_forwards_attribute:
 * @self: A #WebKitDOMTestObj
 *
 * Returns: (transfer none): A #WebKitDOMTestNode
 *
 * Stability: Unstable
**/
WEBKIT_API WebKitDOMTestNode*
webkit_dom_test_obj_get_put_forwards_attribute(WebKitDOMTestObj* self);

/**
 * webkit_dom_test_obj_get_put_forwards_nullable_attribute:
 * @self: A #WebKitDOMTestObj
 *
 * Returns: (transfer none): A #WebKitDOMTestNode
 *
 * Stability: Unstable
**/
WEBKIT_API WebKitDOMTestNode*
webkit_dom_test_obj_get_put_forwards_nullable_attribute(WebKitDOMTestObj* self);

G_END_DECLS

#endif /* WEBKIT_DOM_USE_UNSTABLE_API */
#endif /* WebKitDOMTestObj_h */
