/* tracker-sparql-scanner.c generated by valac 0.41.90.2-8c9f4-dirty, the Vala compiler
 * generated from tracker-sparql-scanner.vala, do not modify */

/*
 * Copyright (C) 2009, Nokia
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */


#include <glib.h>
#include <glib-object.h>
#include "libtracker-sparql/tracker-sparql.h"
#include <stdlib.h>
#include <string.h>


#define TRACKER_TYPE_SPARQL_SCANNER (tracker_sparql_scanner_get_type ())
#define TRACKER_SPARQL_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_SPARQL_SCANNER, TrackerSparqlScanner))
#define TRACKER_SPARQL_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_SPARQL_SCANNER, TrackerSparqlScannerClass))
#define TRACKER_IS_SPARQL_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_SPARQL_SCANNER))
#define TRACKER_IS_SPARQL_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_SPARQL_SCANNER))
#define TRACKER_SPARQL_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_SPARQL_SCANNER, TrackerSparqlScannerClass))

typedef struct _TrackerSparqlScanner TrackerSparqlScanner;
typedef struct _TrackerSparqlScannerClass TrackerSparqlScannerClass;
typedef struct _TrackerSparqlScannerPrivate TrackerSparqlScannerPrivate;
enum  {
	TRACKER_SPARQL_SCANNER_0_PROPERTY,
	TRACKER_SPARQL_SCANNER_NUM_PROPERTIES
};
static GParamSpec* tracker_sparql_scanner_properties[TRACKER_SPARQL_SCANNER_NUM_PROPERTIES];

#define TRACKER_TYPE_SOURCE_LOCATION (tracker_source_location_get_type ())
typedef struct _TrackerSourceLocation TrackerSourceLocation;

#define TRACKER_TYPE_SPARQL_TOKEN_TYPE (tracker_sparql_token_type_get_type ())

struct _TrackerSparqlScanner {
	GObject parent_instance;
	TrackerSparqlScannerPrivate * priv;
};

struct _TrackerSparqlScannerClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlScannerPrivate {
	gchar* current;
	gchar* end;
	gint line;
	gint column;
};

struct _TrackerSourceLocation {
	gchar* pos;
	gint line;
	gint column;
};

typedef enum  {
	TRACKER_SPARQL_TOKEN_TYPE_NONE,
	TRACKER_SPARQL_TOKEN_TYPE_A,
	TRACKER_SPARQL_TOKEN_TYPE_ABS,
	TRACKER_SPARQL_TOKEN_TYPE_AS,
	TRACKER_SPARQL_TOKEN_TYPE_ASC,
	TRACKER_SPARQL_TOKEN_TYPE_ASK,
	TRACKER_SPARQL_TOKEN_TYPE_ATBASE,
	TRACKER_SPARQL_TOKEN_TYPE_ATPREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_AVG,
	TRACKER_SPARQL_TOKEN_TYPE_BASE,
	TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE,
	TRACKER_SPARQL_TOKEN_TYPE_BIND,
	TRACKER_SPARQL_TOKEN_TYPE_BOUND,
	TRACKER_SPARQL_TOKEN_TYPE_BY,
	TRACKER_SPARQL_TOKEN_TYPE_CEIL,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACKET,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS,
	TRACKER_SPARQL_TOKEN_TYPE_COALESCE,
	TRACKER_SPARQL_TOKEN_TYPE_COLON,
	TRACKER_SPARQL_TOKEN_TYPE_CONCAT,
	TRACKER_SPARQL_TOKEN_TYPE_CONTAINS,
	TRACKER_SPARQL_TOKEN_TYPE_COMMA,
	TRACKER_SPARQL_TOKEN_TYPE_CONSTRUCT,
	TRACKER_SPARQL_TOKEN_TYPE_COUNT,
	TRACKER_SPARQL_TOKEN_TYPE_DATA,
	TRACKER_SPARQL_TOKEN_TYPE_DATATYPE,
	TRACKER_SPARQL_TOKEN_TYPE_DAY,
	TRACKER_SPARQL_TOKEN_TYPE_DECIMAL,
	TRACKER_SPARQL_TOKEN_TYPE_DELETE,
	TRACKER_SPARQL_TOKEN_TYPE_DESC,
	TRACKER_SPARQL_TOKEN_TYPE_DESCRIBE,
	TRACKER_SPARQL_TOKEN_TYPE_DISTINCT,
	TRACKER_SPARQL_TOKEN_TYPE_DIV,
	TRACKER_SPARQL_TOKEN_TYPE_DOT,
	TRACKER_SPARQL_TOKEN_TYPE_DOUBLE,
	TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX,
	TRACKER_SPARQL_TOKEN_TYPE_DROP,
	TRACKER_SPARQL_TOKEN_TYPE_ENCODE_FOR_URI,
	TRACKER_SPARQL_TOKEN_TYPE_EOF,
	TRACKER_SPARQL_TOKEN_TYPE_EXISTS,
	TRACKER_SPARQL_TOKEN_TYPE_FALSE,
	TRACKER_SPARQL_TOKEN_TYPE_FILTER,
	TRACKER_SPARQL_TOKEN_TYPE_FLOOR,
	TRACKER_SPARQL_TOKEN_TYPE_FROM,
	TRACKER_SPARQL_TOKEN_TYPE_GRAPH,
	TRACKER_SPARQL_TOKEN_TYPE_GROUP,
	TRACKER_SPARQL_TOKEN_TYPE_GROUP_CONCAT,
	TRACKER_SPARQL_TOKEN_TYPE_HAVING,
	TRACKER_SPARQL_TOKEN_TYPE_HOURS,
	TRACKER_SPARQL_TOKEN_TYPE_IF,
	TRACKER_SPARQL_TOKEN_TYPE_INSERT,
	TRACKER_SPARQL_TOKEN_TYPE_INTEGER,
	TRACKER_SPARQL_TOKEN_TYPE_INTO,
	TRACKER_SPARQL_TOKEN_TYPE_IRI_REF,
	TRACKER_SPARQL_TOKEN_TYPE_ISBLANK,
	TRACKER_SPARQL_TOKEN_TYPE_ISIRI,
	TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL,
	TRACKER_SPARQL_TOKEN_TYPE_ISURI,
	TRACKER_SPARQL_TOKEN_TYPE_LANG,
	TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES,
	TRACKER_SPARQL_TOKEN_TYPE_LCASE,
	TRACKER_SPARQL_TOKEN_TYPE_LIMIT,
	TRACKER_SPARQL_TOKEN_TYPE_MAX,
	TRACKER_SPARQL_TOKEN_TYPE_MD5,
	TRACKER_SPARQL_TOKEN_TYPE_MIN,
	TRACKER_SPARQL_TOKEN_TYPE_MINUS,
	TRACKER_SPARQL_TOKEN_TYPE_MINUTES,
	TRACKER_SPARQL_TOKEN_TYPE_MONTH,
	TRACKER_SPARQL_TOKEN_TYPE_NAMED,
	TRACKER_SPARQL_TOKEN_TYPE_NOT,
	TRACKER_SPARQL_TOKEN_TYPE_NOW,
	TRACKER_SPARQL_TOKEN_TYPE_NULL,
	TRACKER_SPARQL_TOKEN_TYPE_OFFSET,
	TRACKER_SPARQL_TOKEN_TYPE_OP_AND,
	TRACKER_SPARQL_TOKEN_TYPE_OP_EQ,
	TRACKER_SPARQL_TOKEN_TYPE_OP_GE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_GT,
	TRACKER_SPARQL_TOKEN_TYPE_OP_LE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_LT,
	TRACKER_SPARQL_TOKEN_TYPE_OP_NE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_NEG,
	TRACKER_SPARQL_TOKEN_TYPE_OP_OR,
	TRACKER_SPARQL_TOKEN_TYPE_OP_IN,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS,
	TRACKER_SPARQL_TOKEN_TYPE_OPTIONAL,
	TRACKER_SPARQL_TOKEN_TYPE_OR,
	TRACKER_SPARQL_TOKEN_TYPE_ORDER,
	TRACKER_SPARQL_TOKEN_TYPE_PLUS,
	TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_PREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_RAND,
	TRACKER_SPARQL_TOKEN_TYPE_REDUCED,
	TRACKER_SPARQL_TOKEN_TYPE_REGEX,
	TRACKER_SPARQL_TOKEN_TYPE_REPLACE,
	TRACKER_SPARQL_TOKEN_TYPE_ROUND,
	TRACKER_SPARQL_TOKEN_TYPE_SAMETERM,
	TRACKER_SPARQL_TOKEN_TYPE_SECONDS,
	TRACKER_SPARQL_TOKEN_TYPE_SELECT,
	TRACKER_SPARQL_TOKEN_TYPE_SEMICOLON,
	TRACKER_SPARQL_TOKEN_TYPE_SHA1,
	TRACKER_SPARQL_TOKEN_TYPE_SHA256,
	TRACKER_SPARQL_TOKEN_TYPE_SHA512,
	TRACKER_SPARQL_TOKEN_TYPE_SILENT,
	TRACKER_SPARQL_TOKEN_TYPE_STAR,
	TRACKER_SPARQL_TOKEN_TYPE_STR,
	TRACKER_SPARQL_TOKEN_TYPE_STRAFTER,
	TRACKER_SPARQL_TOKEN_TYPE_STRBEFORE,
	TRACKER_SPARQL_TOKEN_TYPE_STRENDS,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2,
	TRACKER_SPARQL_TOKEN_TYPE_STRLEN,
	TRACKER_SPARQL_TOKEN_TYPE_STRSTARTS,
	TRACKER_SPARQL_TOKEN_TYPE_SUBSTR,
	TRACKER_SPARQL_TOKEN_TYPE_SUM,
	TRACKER_SPARQL_TOKEN_TYPE_TRUE,
	TRACKER_SPARQL_TOKEN_TYPE_UCASE,
	TRACKER_SPARQL_TOKEN_TYPE_UNION,
	TRACKER_SPARQL_TOKEN_TYPE_VAR,
	TRACKER_SPARQL_TOKEN_TYPE_WHERE,
	TRACKER_SPARQL_TOKEN_TYPE_WITH,
	TRACKER_SPARQL_TOKEN_TYPE_YEAR
} TrackerSparqlTokenType;


static gint TrackerSparqlScanner_private_offset;
static gpointer tracker_sparql_scanner_parent_class = NULL;

GType tracker_sparql_scanner_get_type (void) G_GNUC_CONST;
TrackerSparqlScanner* tracker_sparql_scanner_new (gchar* input,
                                                  gsize len);
TrackerSparqlScanner* tracker_sparql_scanner_construct (GType object_type,
                                                        gchar* input,
                                                        gsize len);
GType tracker_source_location_get_type (void) G_GNUC_CONST;
TrackerSourceLocation* tracker_source_location_dup (const TrackerSourceLocation* self);
void tracker_source_location_free (TrackerSourceLocation* self);
void tracker_sparql_scanner_seek (TrackerSparqlScanner* self,
                                  TrackerSourceLocation* location);
GType tracker_sparql_token_type_get_type (void) G_GNUC_CONST;
static TrackerSparqlTokenType tracker_sparql_scanner_get_identifier_or_keyword (TrackerSparqlScanner* self,
                                                                         gchar* begin,
                                                                         gint len);
static gboolean tracker_sparql_scanner_matches (TrackerSparqlScanner* self,
                                         gchar* begin,
                                         const gchar* keyword);
static TrackerSparqlTokenType tracker_sparql_scanner_read_number (TrackerSparqlScanner* self);
static gboolean tracker_sparql_scanner_is_pn_char (TrackerSparqlScanner* self,
                                            gchar c);
static gboolean tracker_sparql_scanner_is_pn_local_char (TrackerSparqlScanner* self,
                                                  gchar c);
static gboolean tracker_sparql_scanner_is_varname_char (TrackerSparqlScanner* self,
                                                 gchar c);
TrackerSparqlTokenType tracker_sparql_scanner_read_token (TrackerSparqlScanner* self,
                                                          TrackerSourceLocation* token_begin,
                                                          TrackerSourceLocation* token_end,
                                                          GError** error);
static void tracker_sparql_scanner_space (TrackerSparqlScanner* self);
void tracker_source_location_init (TrackerSourceLocation *self,
                                   gchar* pos,
                                   gint line,
                                   gint column);
static gboolean tracker_sparql_scanner_whitespace (TrackerSparqlScanner* self);
static gboolean tracker_sparql_scanner_comment (TrackerSparqlScanner* self);
static void tracker_sparql_scanner_finalize (GObject * obj);
const gchar* tracker_sparql_token_type_to_string (TrackerSparqlTokenType self);


static inline gpointer
tracker_sparql_scanner_get_instance_private (TrackerSparqlScanner* self)
{
	return G_STRUCT_MEMBER_P (self, TrackerSparqlScanner_private_offset);
}


TrackerSparqlScanner*
tracker_sparql_scanner_construct (GType object_type,
                                  gchar* input,
                                  gsize len)
{
	TrackerSparqlScanner * self = NULL;
	gchar* begin = NULL;
#line 27 "tracker-sparql-scanner.vala"
	self = (TrackerSparqlScanner*) g_object_new (object_type, NULL);
#line 28 "tracker-sparql-scanner.vala"
	begin = input;
#line 29 "tracker-sparql-scanner.vala"
	self->priv->end = begin + len;
#line 31 "tracker-sparql-scanner.vala"
	self->priv->current = begin;
#line 33 "tracker-sparql-scanner.vala"
	self->priv->line = 1;
#line 34 "tracker-sparql-scanner.vala"
	self->priv->column = 1;
#line 27 "tracker-sparql-scanner.vala"
	return self;
#line 276 "tracker-sparql-scanner.c"
}


TrackerSparqlScanner*
tracker_sparql_scanner_new (gchar* input,
                            gsize len)
{
#line 27 "tracker-sparql-scanner.vala"
	return tracker_sparql_scanner_construct (TRACKER_TYPE_SPARQL_SCANNER, input, len);
#line 286 "tracker-sparql-scanner.c"
}


void
tracker_sparql_scanner_seek (TrackerSparqlScanner* self,
                             TrackerSourceLocation* location)
{
	TrackerSourceLocation _tmp0_;
	gchar* _tmp1_;
	TrackerSourceLocation _tmp2_;
	gint _tmp3_;
	TrackerSourceLocation _tmp4_;
	gint _tmp5_;
#line 37 "tracker-sparql-scanner.vala"
	g_return_if_fail (self != NULL);
#line 37 "tracker-sparql-scanner.vala"
	g_return_if_fail (location != NULL);
#line 38 "tracker-sparql-scanner.vala"
	_tmp0_ = *location;
#line 38 "tracker-sparql-scanner.vala"
	_tmp1_ = _tmp0_.pos;
#line 38 "tracker-sparql-scanner.vala"
	self->priv->current = _tmp1_;
#line 39 "tracker-sparql-scanner.vala"
	_tmp2_ = *location;
#line 39 "tracker-sparql-scanner.vala"
	_tmp3_ = _tmp2_.line;
#line 39 "tracker-sparql-scanner.vala"
	self->priv->line = _tmp3_;
#line 40 "tracker-sparql-scanner.vala"
	_tmp4_ = *location;
#line 40 "tracker-sparql-scanner.vala"
	_tmp5_ = _tmp4_.column;
#line 40 "tracker-sparql-scanner.vala"
	self->priv->column = _tmp5_;
#line 322 "tracker-sparql-scanner.c"
}


static TrackerSparqlTokenType
tracker_sparql_scanner_get_identifier_or_keyword (TrackerSparqlScanner* self,
                                                  gchar* begin,
                                                  gint len)
{
	TrackerSparqlTokenType result = 0;
#line 43 "tracker-sparql-scanner.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 44 "tracker-sparql-scanner.vala"
	switch (len) {
#line 44 "tracker-sparql-scanner.vala"
		case 1:
#line 338 "tracker-sparql-scanner.c"
		{
			gchar _tmp0_;
#line 46 "tracker-sparql-scanner.vala"
			_tmp0_ = begin[0];
#line 46 "tracker-sparql-scanner.vala"
			switch (_tmp0_) {
#line 46 "tracker-sparql-scanner.vala"
				case 'A':
#line 46 "tracker-sparql-scanner.vala"
				case 'a':
#line 349 "tracker-sparql-scanner.c"
				{
#line 49 "tracker-sparql-scanner.vala"
					result = TRACKER_SPARQL_TOKEN_TYPE_A;
#line 49 "tracker-sparql-scanner.vala"
					return result;
#line 355 "tracker-sparql-scanner.c"
				}
				default:
#line 46 "tracker-sparql-scanner.vala"
				break;
#line 360 "tracker-sparql-scanner.c"
			}
#line 51 "tracker-sparql-scanner.vala"
			break;
#line 364 "tracker-sparql-scanner.c"
		}
#line 44 "tracker-sparql-scanner.vala"
		case 2:
#line 368 "tracker-sparql-scanner.c"
		{
			gchar _tmp1_;
#line 53 "tracker-sparql-scanner.vala"
			_tmp1_ = begin[0];
#line 53 "tracker-sparql-scanner.vala"
			switch (_tmp1_) {
#line 53 "tracker-sparql-scanner.vala"
				case 'A':
#line 53 "tracker-sparql-scanner.vala"
				case 'a':
#line 379 "tracker-sparql-scanner.c"
				{
#line 56 "tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "AS")) {
#line 56 "tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_AS;
#line 56 "tracker-sparql-scanner.vala"
						return result;
#line 387 "tracker-sparql-scanner.c"
					}
#line 57 "tracker-sparql-scanner.vala"
					break;
#line 391 "tracker-sparql-scanner.c"
				}
#line 53 "tracker-sparql-scanner.vala"
				case 'B':
#line 53 "tracker-sparql-scanner.vala"
				case 'b':
#line 397 "tracker-sparql-scanner.c"
				{
#line 60 "tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "BY")) {
#line 60 "tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_BY;
#line 60 "tracker-sparql-scanner.vala"
						return result;
#line 405 "tracker-sparql-scanner.c"
					}
#line 61 "tracker-sparql-scanner.vala"
					break;
#line 409 "tracker-sparql-scanner.c"
				}
#line 53 "tracker-sparql-scanner.vala"
				case 'i':
#line 53 "tracker-sparql-scanner.vala"
				case 'I':
#line 415 "tracker-sparql-scanner.c"
				{
					gchar _tmp2_;
#line 64 "tracker-sparql-scanner.vala"
					_tmp2_ = begin[1];
#line 64 "tracker-sparql-scanner.vala"
					switch (_tmp2_) {
#line 64 "tracker-sparql-scanner.vala"
						case 'F':
#line 64 "tracker-sparql-scanner.vala"
						case 'f':
#line 426 "tracker-sparql-scanner.c"
						{
#line 67 "tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "IF")) {
#line 67 "tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_IF;
#line 67 "tracker-sparql-scanner.vala"
								return result;
#line 434 "tracker-sparql-scanner.c"
							}
#line 68 "tracker-sparql-scanner.vala"
							break;
#line 438 "tracker-sparql-scanner.c"
						}
#line 64 "tracker-sparql-scanner.vala"
						case 'N':
#line 64 "tracker-sparql-scanner.vala"
						case 'n':
#line 444 "tracker-sparql-scanner.c"
						{
#line 71 "tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "IN")) {
#line 71 "tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_OP_IN;
#line 71 "tracker-sparql-scanner.vala"
								return result;
#line 452 "tracker-sparql-scanner.c"
							}
#line 72 "tracker-sparql-scanner.vala"
							break;
#line 456 "tracker-sparql-scanner.c"
						}
						default:
#line 64 "tracker-sparql-scanner.vala"
						break;
#line 461 "tracker-sparql-scanner.c"
					}
#line 74 "tracker-sparql-scanner.vala"
					break;
#line 465 "tracker-sparql-scanner.c"
				}
#line 53 "tracker-sparql-scanner.vala"
				case 'O':
#line 53 "tracker-sparql-scanner.vala"
				case 'o':
#line 471 "tracker-sparql-scanner.c"
				{
#line 77 "tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "OR")) {
#line 77 "tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_OR;
#line 77 "tracker-sparql-scanner.vala"
						return result;
#line 479 "tracker-sparql-scanner.c"
					}
#line 78 "tracker-sparql-scanner.vala"
					break;
#line 483 "tracker-sparql-scanner.c"
				}
				default:
#line 53 "tracker-sparql-scanner.vala"
				break;
#line 488 "tracker-sparql-scanner.c"
			}
#line 80 "tracker-sparql-scanner.vala"
			break;
#line 492 "tracker-sparql-scanner.c"
		}
#line 44 "tracker-sparql-scanner.vala"
		case 3:
#line 496 "tracker-sparql-scanner.c"
		{
			gchar _tmp3_;
#line 82 "tracker-sparql-scanner.vala"
			_tmp3_ = begin[0];
#line 82 "tracker-sparql-scanner.vala"
			switch (_tmp3_) {
#line 82 "tracker-sparql-scanner.vala"
				case 'A':
#line 82 "tracker-sparql-scanner.vala"
				case 'a':
#line 507 "tracker-sparql-scanner.c"
				{
					gchar _tmp4_;
#line 85 "tracker-sparql-scanner.vala"
					_tmp4_ = begin[1];
#line 85 "tracker-sparql-scanner.vala"
					switch (_tmp4_) {
#line 85 "tracker-sparql-scanner.vala"
						case 'S':
#line 85 "tracker-sparql-scanner.vala"
						case 's':
#line 518 "tracker-sparql-scanner.c"
						{
							gchar _tmp5_;
#line 88 "tracker-sparql-scanner.vala"
							_tmp5_ = begin[2];
#line 88 "tracker-sparql-scanner.vala"
							switch (_tmp5_) {
#line 88 "tracker-sparql-scanner.vala"
								case 'C':
#line 88 "tracker-sparql-scanner.vala"
								case 'c':
#line 529 "tracker-sparql-scanner.c"
								{
#line 91 "tracker-sparql-scanner.vala"
									if (tracker_sparql_scanner_matches (self, begin, "ASC")) {
#line 91 "tracker-sparql-scanner.vala"
										result = TRACKER_SPARQL_TOKEN_TYPE_ASC;
#line 91 "tracker-sparql-scanner.vala"
										return result;
#line 537 "tracker-sparql-scanner.c"
									}
#line 92 "tracker-sparql-scanner.vala"
									break;
#line 541 "tracker-sparql-scanner.c"
								}
#line 88 "tracker-sparql-scanner.vala"
								case 'K':
#line 88 "tracker-sparql-scanner.vala"
								case 'k':
#line 547 "tracker-sparql-scanner.c"
								{
#line 95 "tracker-sparql-scanner.vala"
									if (tracker_sparql_scanner_matches (self, begin, "ASK")) {
#line 95 "tracker-sparql-scanner.vala"
										result = TRACKER_SPARQL_TOKEN_TYPE_ASK;
#line 95 "tracker-sparql-scanner.vala"
										return result;
#line 555 "tracker-sparql-scanner.c"
									}
#line 96 "tracker-sparql-scanner.vala"
									break;
#line 559 "tracker-sparql-scanner.c"
								}
								default:
#line 88 "tracker-sparql-scanner.vala"
								break;
#line 564 "tracker-sparql-scanner.c"
							}
#line 98 "tracker-sparql-scanner.vala"
							break;
#line 568 "tracker-sparql-scanner.c"
						}
#line 85 "tracker-sparql-scanner.vala"
						case 'B':
#line 85 "tracker-sparql-scanner.vala"
						case 'b':
#line 574 "tracker-sparql-scanner.c"
						{
#line 101 "tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "ABS")) {
#line 101 "tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_ABS;
#line 101 "tracker-sparql-scanner.vala"
								return result;
#line 582 "tracker-sparql-scanner.c"
							}
#line 102 "tracker-sparql-scanner.vala"
							break;
#line 586 "tracker-sparql-scanner.c"
						}
#line 85 "tracker-sparql-scanner.vala"
						case 'V':
#line 85 "tracker-sparql-scanner.vala"
						case 'v':
#line 592 "tracker-sparql-scanner.c"
						{
#line 105 "tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "AVG")) {
#line 105 "tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_AVG;
#line 105 "tracker-sparql-scanner.vala"
								return result;
#line 600 "tracker-sparql-scanner.c"
							}
#line 106 "tracker-sparql-scanner.vala"
							break;
#line 604 "tracker-sparql-scanner.c"
						}
						default:
#line 85 "tracker-sparql-scanner.vala"
						break;
#line 609 "tracker-sparql-scanner.c"
					}
#line 108 "tracker-sparql-scanner.vala"
					break;
#line 613 "tracker-sparql-scanner.c"
				}
#line 82 "tracker-sparql-scanner.vala"
				case 'D':
#line 82 "tracker-sparql-scanner.vala"
				case 'd':
#line 619 "tracker-sparql-scanner.c"
				{
#line 111 "tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "DAY")) {
#line 111 "tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_DAY;
#line 111 "tracker-sparql-scanner.vala"
						return result;
#line 627 "tracker-sparql-scanner.c"
					}
#line 112 "tracker-sparql-scanner.vala"
					break;
#line 631 "tracker-sparql-scanner.c"
				}
#line 82 "tracker-sparql-scanner.vala"
				case 'M':
#line 82 "tracker-sparql-scanner.vala"
				case 'm':
#line 637 "tracker-sparql-scanner.c"
				{
					gchar _tmp6_;
#line 115 "tracker-sparql-scanner.vala"
					_tmp6_ = begin[1];
#line 115 "tracker-sparql-scanner.vala"
					switch (_tmp6_) {
#line 115 "tracker-sparql-scanner.vala"
						case 'A':
#line 115 "tracker-sparql-scanner.vala"
						case 'a':
#line 648 "tracker-sparql-scanner.c"
						{
#line 118 "tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "MAX")) {
#line 118 "tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_MAX;
#line 118 "tracker-sparql-scanner.vala"
								return result;
#line 656 "tracker-sparql-scanner.c"
							}
#line 119 "tracker-sparql-scanner.vala"
							break;
#line 660 "tracker-sparql-scanner.c"
						}
#line 115 "tracker-sparql-scanner.vala"
						case 'D':
#line 115 "tracker-sparql-scanner.vala"
						case 'd':
#line 666 "tracker-sparql-scanner.c"
						{
#line 122 "tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "MD5")) {
#line 122 "tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_MD5;
#line 122 "tracker-sparql-scanner.vala"
								return result;
#line 674 "tracker-sparql-scanner.c"
							}
#line 123 "tracker-sparql-scanner.vala"
							break;
#line 678 "tracker-sparql-scanner.c"
						}
#line 115 "tracker-sparql-scanner.vala"
						case 'I':
#line 115 "tracker-sparql-scanner.vala"
						case 'i':
#line 684 "tracker-sparql-scanner.c"
						{
#line 126 "tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "MIN")) {
#line 126 "tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_MIN;
#line 126 "tracker-sparql-scanner.vala"
								return result;
#line 692 "tracker-sparql-scanner.c"
							}
#line 127 "tracker-sparql-scanner.vala"
							break;
#line 696 "tracker-sparql-scanner.c"
						}
						default:
#line 115 "tracker-sparql-scanner.vala"
						break;
#line 701 "tracker-sparql-scanner.c"
					}
#line 129 "tracker-sparql-scanner.vala"
					break;
#line 705 "tracker-sparql-scanner.c"
				}
#line 82 "tracker-sparql-scanner.vala"
				case 'N':
#line 82 "tracker-sparql-scanner.vala"
				case 'n':
#line 711 "tracker-sparql-scanner.c"
				{
					gchar _tmp7_;
#line 132 "tracker-sparql-scanner.vala"
					_tmp7_ = begin[2];
#line 132 "tracker-sparql-scanner.vala"
					switch (_tmp7_) {
#line 132 "tracker-sparql-scanner.vala"
						case 'T':
#line 132 "tracker-sparql-scanner.vala"
						case 't':
#line 722 "tracker-sparql-scanner.c"
						{
#line 135 "tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "NOT")) {
#line 135 "tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_NOT;
#line 135 "tracker-sparql-scanner.vala"
								return result;
#line 730 "tracker-sparql-scanner.c"
							}
#line 136 "tracker-sparql-scanner.vala"
							break;
#line 734 "tracker-sparql-scanner.c"
						}
#line 132 "tracker-sparql-scanner.vala"
						case 'W':
#line 132 "tracker-sparql-scanner.vala"
						case 'w':
#line 740 "tracker-sparql-scanner.c"
						{
#line 139 "tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "NOW")) {
#line 139 "tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_NOW;
#line 139 "tracker-sparql-scanner.vala"
								return result;
#line 748 "tracker-sparql-scanner.c"
							}
#line 140 "tracker-sparql-scanner.vala"
							break;
#line 752 "tracker-sparql-scanner.c"
						}
						default:
#line 132 "tracker-sparql-scanner.vala"
						break;
#line 757 "tracker-sparql-scanner.c"
					}
#line 142 "tracker-sparql-scanner.vala"
					break;
#line 761 "tracker-sparql-scanner.c"
				}
#line 82 "tracker-sparql-scanner.vala"
				case 'S':
#line 82 "tracker-sparql-scanner.vala"
				case 's':
#line 767 "tracker-sparql-scanner.c"
				{
					gchar _tmp8_;
#line 145 "tracker-sparql-scanner.vala"
					_tmp8_ = begin[1];
#line 145 "tracker-sparql-scanner.vala"
					switch (_tmp8_) {
#line 145 "tracker-sparql-scanner.vala"
						case 'T':
#line 145 "tracker-sparql-scanner.vala"
						case 't':
#line 778 "tracker-sparql-scanner.c"
						{
#line 148 "tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "STR")) {
#line 148 "tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_STR;
#line 148 "tracker-sparql-scanner.vala"
								return result;
#line 786 "tracker-sparql-scanner.c"
							}
#line 149 "tracker-sparql-scanner.vala"
							break;
#line 790 "tracker-sparql-scanner.c"
						}
#line 145 "tracker-sparql-scanner.vala"
						case 'U':
#line 145 "tracker-sparql-scanner.vala"
						case 'u':
#line 796 "tracker-sparql-scanner.c"
						{
#line 152 "tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "SUM")) {
#line 152 "tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_SUM;
#line 152 "tracker-sparql-scanner.vala"
								return result;
#line 804 "tracker-sparql-scanner.c"
							}
#line 153 "tracker-sparql-scanner.vala"
							break;
#line 808 "tracker-sparql-scanner.c"
						}
						default:
#line 145 "tracker-sparql-scanner.vala"
						break;
#line 813 "tracker-sparql-scanner.c"
					}
#line 155 "tracker-sparql-scanner.vala"
					break;
#line 817 "tracker-sparql-scanner.c"
				}
				default:
#line 82 "tracker-sparql-scanner.vala"
				break;
#line 822 "tracker-sparql-scanner.c"
			}
#line 157 "tracker-sparql-scanner.vala"
			break;
#line 826 "tracker-sparql-scanner.c"
		}
#line 44 "tracker-sparql-scanner.vala"
		case 4:
#line 830 "tracker-sparql-scanner.c"
		{
			gchar _tmp9_;
#line 159 "tracker-sparql-scanner.vala"
			_tmp9_ = begin[0];
#line 159 "tracker-sparql-scanner.vala"
			switch (_tmp9_) {
#line 159 "tracker-sparql-scanner.vala"
				case 'B':
#line 159 "tracker-sparql-scanner.vala"
				case 'b':
#line 841 "tracker-sparql-scanner.c"
				{
					gchar _tmp10_;
#line 162 "tracker-sparql-scanner.vala"
					_tmp10_ = begin[1];
#line 162 "tracker-sparql-scanner.vala"
					switch (_tmp10_) {
#line 162 "tracker-sparql-scanner.vala"
						case 'A':
#line 162 "tracker-sparql-scanner.vala"
						case 'a':
#line 852 "tracker-sparql-scanner.c"
						{
#line 165 "tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "BASE")) {
#line 165 "tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_BASE;
#line 165 "tracker-sparql-scanner.vala"
								return result;
#line 860 "tracker-sparql-scanner.c"
							}
#line 166 "tracker-sparql-scanner.vala"
							break;
#line 864 "tracker-sparql-scanner.c"
						}
#line 162 "tracker-sparql-scanner.vala"
						case 'I':
#line 162 "tracker-sparql-scanner.vala"
						case 'i':
#line 870 "tracker-sparql-scanner.c"
						{
#line 169 "tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "BIND")) {
#line 169 "tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_BIND;
#line 169 "tracker-sparql-scanner.vala"
								return result;
#line 878 "tracker-sparql-scanner.c"
							}
#line 170 "tracker-sparql-scanner.vala"
							break;
#line 882 "tracker-sparql-scanner.c"
						}
						default:
#line 162 "tracker-sparql-scanner.vala"
						break;
#line 887 "tracker-sparql-scanner.c"
					}
#line 172 "tracker-sparql-scanner.vala"
					break;
#line 891 "tracker-sparql-scanner.c"
				}
#line 159 "tracker-sparql-scanner.vala"
				case 'C':
#line 159 "tracker-sparql-scanner.vala"
				case 'c':
#line 897 "tracker-sparql-scanner.c"
				{
#line 175 "tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "CEIL")) {
#line 175 "tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_CEIL;
#line 175 "tracker-sparql-scanner.vala"
						return result;
#line 905 "tracker-sparql-scanner.c"
					}
#line 176 "tracker-sparql-scanner.vala"
					break;
#line 909 "tracker-sparql-scanner.c"
				}
#line 159 "tracker-sparql-scanner.vala"
				case 'D':
#line 159 "tracker-sparql-scanner.vala"
				case 'd':
#line 915 "tracker-sparql-scanner.c"
				{
					gchar _tmp11_;
#line 179 "tracker-sparql-scanner.vala"
					_tmp11_ = begin[1];
#line 179 "tracker-sparql-scanner.vala"
					switch (_tmp11_) {
#line 179 "tracker-sparql-scanner.vala"
						case 'A':
#line 179 "tracker-sparql-scanner.vala"
						case 'a':
#line 926 "tracker-sparql-scanner.c"
						{
#line 182 "tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "DATA")) {
#line 182 "tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_DATA;
#line 182 "tracker-sparql-scanner.vala"
								return result;
#line 934 "tracker-sparql-scanner.c"
							}
#line 183 "tracker-sparql-scanner.vala"
							break;
#line 938 "tracker-sparql-scanner.c"
						}
#line 179 "tracker-sparql-scanner.vala"
						case 'E':
#line 179 "tracker-sparql-scanner.vala"
						case 'e':
#line 944 "tracker-sparql-scanner.c"
						{
#line 186 "tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "DESC")) {
#line 186 "tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_DESC;
#line 186 "tracker-sparql-scanner.vala"
								return result;
#line 952 "tracker-sparql-scanner.c"
							}
#line 187 "tracker-sparql-scanner.vala"
							break;
#line 956 "tracker-sparql-scanner.c"
						}
#line 179 "tracker-sparql-scanner.vala"
						case 'R':
#line 179 "tracker-sparql-scanner.vala"
						case 'r':
#line 962 "tracker-sparql-scanner.c"
						{
#line 190 "tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "DROP")) {
#line 190 "tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_DROP;
#line 190 "tracker-sparql-scanner.vala"
								return result;
#line 970 "tracker-sparql-scanner.c"
							}
#line 191 "tracker-sparql-scanner.vala"
							break;
#line 974 "tracker-sparql-scanner.c"
						}
						default:
#line 179 "tracker-sparql-scanner.vala"
						break;
#line 979 "tracker-sparql-scanner.c"
					}
#line 193 "tracker-sparql-scanner.vala"
					break;
#line 983 "tracker-sparql-scanner.c"
				}
#line 159 "tracker-sparql-scanner.vala"
				case 'F':
#line 159 "tracker-sparql-scanner.vala"
				case 'f':
#line 989 "tracker-sparql-scanner.c"
				{
#line 196 "tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "FROM")) {
#line 196 "tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_FROM;
#line 196 "tracker-sparql-scanner.vala"
						return result;
#line 997 "tracker-sparql-scanner.c"
					}
#line 197 "tracker-sparql-scanner.vala"
					break;
#line 1001 "tracker-sparql-scanner.c"
				}
#line 159 "tracker-sparql-scanner.vala"
				case 'I':
#line 159 "tracker-sparql-scanner.vala"
				case 'i':
#line 1007 "tracker-sparql-scanner.c"
				{
#line 200 "tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "INTO")) {
#line 200 "tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_INTO;
#line 200 "tracker-sparql-scanner.vala"
						return result;
#line 1015 "tracker-sparql-scanner.c"
					}
#line 201 "tracker-sparql-scanner.vala"
					break;
#line 1019 "tracker-sparql-scanner.c"
				}
#line 159 "tracker-sparql-scanner.vala"
				case 'L':
#line 159 "tracker-sparql-scanner.vala"
				case 'l':
#line 1025 "tracker-sparql-scanner.c"
				{
#line 204 "tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "LANG")) {
#line 204 "tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_LANG;
#line 204 "tracker-sparql-scanner.vala"
						return result;
#line 1033 "tracker-sparql-scanner.c"
					}
#line 205 "tracker-sparql-scanner.vala"
					break;
#line 1037 "tracker-sparql-scanner.c"
				}
#line 159 "tracker-sparql-scanner.vala"
				case 'N':
#line 159 "tracker-sparql-scanner.vala"
				case 'n':
#line 1043 "tracker-sparql-scanner.c"
				{
#line 208 "tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "NULL")) {
#line 208 "tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_NULL;
#line 208 "tracker-sparql-scanner.vala"
						return result;
#line 1051 "tracker-sparql-scanner.c"
					}
#line 209 "tracker-sparql-scanner.vala"
					break;
#line 1055 "tracker-sparql-scanner.c"
				}
#line 159 "tracker-sparql-scanner.vala"
				case 'R':
#line 159 "tracker-sparql-scanner.vala"
				case 'r':
#line 1061 "tracker-sparql-scanner.c"
				{
#line 212 "tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "RAND")) {
#line 212 "tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_RAND;
#line 212 "tracker-sparql-scanner.vala"
						return result;
#line 1069 "tracker-sparql-scanner.c"
					}
#line 213 "tracker-sparql-scanner.vala"
					break;
#line 1073 "tracker-sparql-scanner.c"
				}
#line 159 "tracker-sparql-scanner.vala"
				case 'S':
#line 159 "tracker-sparql-scanner.vala"
				case 's':
#line 1079 "tracker-sparql-scanner.c"
				{
#line 216 "tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "SHA1")) {
#line 216 "tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_SHA1;
#line 216 "tracker-sparql-scanner.vala"
						return result;
#line 1087 "tracker-sparql-scanner.c"
					}
#line 217 "tracker-sparql-scanner.vala"
					break;
#line 1091 "tracker-sparql-scanner.c"
				}
#line 159 "tracker-sparql-scanner.vala"
				case 'T':
#line 159 "tracker-sparql-scanner.vala"
				case 't':
#line 1097 "tracker-sparql-scanner.c"
				{
#line 220 "tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "TRUE")) {
#line 220 "tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_TRUE;
#line 220 "tracker-sparql-scanner.vala"
						return result;
#line 1105 "tracker-sparql-scanner.c"
					}
#line 221 "tracker-sparql-scanner.vala"
					break;
#line 1109 "tracker-sparql-scanner.c"
				}
#line 159 "tracker-sparql-scanner.vala"
				case 'W':
#line 159 "tracker-sparql-scanner.vala"
				case 'w':
#line 1115 "tracker-sparql-scanner.c"
				{
#line 224 "tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "WITH")) {
#line 224 "tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_WITH;
#line 224 "tracker-sparql-scanner.vala"
						return result;
#line 1123 "tracker-sparql-scanner.c"
					}
#line 225 "tracker-sparql-scanner.vala"
					break;
#line 1127 "tracker-sparql-scanner.c"
				}
#line 159 "tracker-sparql-scanner.vala"
				case 'Y':
#line 159 "tracker-sparql-scanner.vala"
				case 'y':
#line 1133 "tracker-sparql-scanner.c"
				{
#line 228 "tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "YEAR")) {
#line 228 "tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_YEAR;
#line 228 "tracker-sparql-scanner.vala"
						return result;
#line 1141 "tracker-sparql-scanner.c"
					}
#line 229 "tracker-sparql-scanner.vala"
					break;
#line 1145 "tracker-sparql-scanner.c"
				}
				default:
#line 159 "tracker-sparql-scanner.vala"
				break;
#line 1150 "tracker-sparql-scanner.c"
			}
#line 231 "tracker-sparql-scanner.vala"
			break;
#line 1154 "tracker-sparql-scanner.c"
		}
#line 44 "tracker-sparql-scanner.vala"
		case 5:
#line 1158 "tracker-sparql-scanner.c"
		{
			gchar _tmp12_;
#line 233 "tracker-sparql-scanner.vala"
			_tmp12_ = begin[0];
#line 233 "tracker-sparql-scanner.vala"
			switch (_tmp12_) {
#line 233 "tracker-sparql-scanner.vala"
				case 'B':
#line 233 "tracker-sparql-scanner.vala"
				case 'b':
#line 1169 "tracker-sparql-scanner.c"
				{
#line 236 "tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "BOUND")) {
#line 236 "tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_BOUND;
#line 236 "tracker-sparql-scanner.vala"
						return result;
#line 1177 "tracker-sparql-scanner.c"
					}
#line 237 "tracker-sparql-scanner.vala"
					break;
#line 1181 "tracker-sparql-scanner.c"
				}
#line 233 "tracker-sparql-scanner.vala"
				case 'C':
#line 233 "tracker-sparql-scanner.vala"
				case 'c':
#line 1187 "tracker-sparql-scanner.c"
				{
#line 240 "tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "COUNT")) {
#line 240 "tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_COUNT;
#line 240 "tracker-sparql-scanner.vala"
						return result;
#line 1195 "tracker-sparql-scanner.c"
					}
#line 241 "tracker-sparql-scanner.vala"
					break;
#line 1199 "tracker-sparql-scanner.c"
				}
#line 233 "tracker-sparql-scanner.vala"
				case 'G':
#line 233 "tracker-sparql-scanner.vala"
				case 'g':
#line 1205 "tracker-sparql-scanner.c"
				{
					gchar _tmp13_;
#line 244 "tracker-sparql-scanner.vala"
					_tmp13_ = begin[2];
#line 244 "tracker-sparql-scanner.vala"
					switch (_tmp13_) {
#line 244 "tracker-sparql-scanner.vala"
						case 'A':
#line 244 "tracker-sparql-scanner.vala"
						case 'a':
#line 1216 "tracker-sparql-scanner.c"
						{
#line 247 "tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "GRAPH")) {
#line 247 "tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_GRAPH;
#line 247 "tracker-sparql-scanner.vala"
								return result;
#line 1224 "tracker-sparql-scanner.c"
							}
#line 248 "tracker-sparql-scanner.vala"
							break;
#line 1228 "tracker-sparql-scanner.c"
						}
#line 244 "tracker-sparql-scanner.vala"
						case 'O':
#line 244 "tracker-sparql-scanner.vala"
						case 'o':
#line 1234 "tracker-sparql-scanner.c"
						{
#line 251 "tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "GROUP")) {
#line 251 "tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_GROUP;
#line 251 "tracker-sparql-scanner.vala"
								return result;
#line 1242 "tracker-sparql-scanner.c"
							}
#line 252 "tracker-sparql-scanner.vala"
							break;
#line 1246 "tracker-sparql-scanner.c"
						}
						default:
#line 244 "tracker-sparql-scanner.vala"
						break;
#line 1251 "tracker-sparql-scanner.c"
					}
#line 254 "tracker-sparql-scanner.vala"
					break;
#line 1255 "tracker-sparql-scanner.c"
				}
#line 233 "tracker-sparql-scanner.vala"
				case 'H':
#line 233 "tracker-sparql-scanner.vala"
				case 'h':
#line 1261 "tracker-sparql-scanner.c"
				{
#line 257 "tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "HOURS")) {
#line 257 "tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_HOURS;
#line 257 "tracker-sparql-scanner.vala"
						return result;
#line 1269 "tracker-sparql-scanner.c"
					}
#line 258 "tracker-sparql-scanner.vala"
					break;
#line 1273 "tracker-sparql-scanner.c"
				}
#line 233 "tracker-sparql-scanner.vala"
				case 'L':
#line 233 "tracker-sparql-scanner.vala"
				case 'l':
#line 1279 "tracker-sparql-scanner.c"
				{
					gchar _tmp14_;
#line 261 "tracker-sparql-scanner.vala"
					_tmp14_ = begin[1];
#line 261 "tracker-sparql-scanner.vala"
					switch (_tmp14_) {
#line 261 "tracker-sparql-scanner.vala"
						case 'C':
#line 261 "tracker-sparql-scanner.vala"
						case 'c':
#line 1290 "tracker-sparql-scanner.c"
						{
#line 264 "tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "LCASE")) {
#line 264 "tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_LCASE;
#line 264 "tracker-sparql-scanner.vala"
								return result;
#line 1298 "tracker-sparql-scanner.c"
							}
#line 265 "tracker-sparql-scanner.vala"
							break;
#line 1302 "tracker-sparql-scanner.c"
						}
#line 261 "tracker-sparql-scanner.vala"
						case 'I':
#line 261 "tracker-sparql-scanner.vala"
						case 'i':
#line 1308 "tracker-sparql-scanner.c"
						{
#line 268 "tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "LIMIT")) {
#line 268 "tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_LIMIT;
#line 268 "tracker-sparql-scanner.vala"
								return result;
#line 1316 "tracker-sparql-scanner.c"
							}
#line 269 "tracker-sparql-scanner.vala"
							break;
#line 1320 "tracker-sparql-scanner.c"
						}
						default:
#line 261 "tracker-sparql-scanner.vala"
						break;
#line 1325 "tracker-sparql-scanner.c"
					}
#line 271 "tracker-sparql-scanner.vala"
					break;
#line 1329 "tracker-sparql-scanner.c"
				}
#line 233 "tracker-sparql-scanner.vala"
				case 'M':
#line 233 "tracker-sparql-scanner.vala"
				case 'm':
#line 1335 "tracker-sparql-scanner.c"
				{
#line 274 "tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "MONTH")) {
#line 274 "tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_MONTH;
#line 274 "tracker-sparql-scanner.vala"
						return result;
#line 1343 "tracker-sparql-scanner.c"
					}
#line 275 "tracker-sparql-scanner.vala"
					break;
#line 1347 "tracker-sparql-scanner.c"
				}
#line 233 "tracker-sparql-scanner.vala"
				case 'N':
#line 233 "tracker-sparql-scanner.vala"
				case 'n':
#line 1353 "tracker-sparql-scanner.c"
				{
#line 278 "tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "NAMED")) {
#line 278 "tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_NAMED;
#line 278 "tracker-sparql-scanner.vala"
						return result;
#line 1361 "tracker-sparql-scanner.c"
					}
#line 279 "tracker-sparql-scanner.vala"
					break;
#line 1365 "tracker-sparql-scanner.c"
				}
#line 233 "tracker-sparql-scanner.vala"
				case 'O':
#line 233 "tracker-sparql-scanner.vala"
				case 'o':
#line 1371 "tracker-sparql-scanner.c"
				{
#line 282 "tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "ORDER")) {
#line 282 "tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_ORDER;
#line 282 "tracker-sparql-scanner.vala"
						return result;
#line 1379 "tracker-sparql-scanner.c"
					}
#line 283 "tracker-sparql-scanner.vala"
					break;
#line 1383 "tracker-sparql-scanner.c"
				}
#line 233 "tracker-sparql-scanner.vala"
				case 'R':
#line 233 "tracker-sparql-scanner.vala"
				case 'r':
#line 1389 "tracker-sparql-scanner.c"
				{
					gchar _tmp15_;
#line 286 "tracker-sparql-scanner.vala"
					_tmp15_ = begin[1];
#line 286 "tracker-sparql-scanner.vala"
					switch (_tmp15_) {
#line 286 "tracker-sparql-scanner.vala"
						case 'E':
#line 286 "tracker-sparql-scanner.vala"
						case 'e':
#line 1400 "tracker-sparql-scanner.c"
						{
#line 289 "tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "REGEX")) {
#line 289 "tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_REGEX;
#line 289 "tracker-sparql-scanner.vala"
								return result;
#line 1408 "tracker-sparql-scanner.c"
							}
#line 290 "tracker-sparql-scanner.vala"
							break;
#line 1412 "tracker-sparql-scanner.c"
						}
#line 286 "tracker-sparql-scanner.vala"
						case 'O':
#line 286 "tracker-sparql-scanner.vala"
						case 'o':
#line 1418 "tracker-sparql-scanner.c"
						{
#line 293 "tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "ROUND")) {
#line 293 "tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_ROUND;
#line 293 "tracker-sparql-scanner.vala"
								return result;
#line 1426 "tracker-sparql-scanner.c"
							}
#line 294 "tracker-sparql-scanner.vala"
							break;
#line 1430 "tracker-sparql-scanner.c"
						}
						default:
#line 286 "tracker-sparql-scanner.vala"
						break;
#line 1435 "tracker-sparql-scanner.c"
					}
#line 296 "tracker-sparql-scanner.vala"
					break;
#line 1439 "tracker-sparql-scanner.c"
				}
#line 233 "tracker-sparql-scanner.vala"
				case 'U':
#line 233 "tracker-sparql-scanner.vala"
				case 'u':
#line 1445 "tracker-sparql-scanner.c"
				{
					gchar _tmp16_;
#line 299 "tracker-sparql-scanner.vala"
					_tmp16_ = begin[1];
#line 299 "tracker-sparql-scanner.vala"
					switch (_tmp16_) {
#line 299 "tracker-sparql-scanner.vala"
						case 'N':
#line 299 "tracker-sparql-scanner.vala"
						case 'n':
#line 1456 "tracker-sparql-scanner.c"
						{
#line 302 "tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "UNION")) {
#line 302 "tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_UNION;
#line 302 "tracker-sparql-scanner.vala"
								return result;
#line 1464 "tracker-sparql-scanner.c"
							}
#line 303 "tracker-sparql-scanner.vala"
							break;
#line 1468 "tracker-sparql-scanner.c"
						}
#line 299 "tracker-sparql-scanner.vala"
						case 'C':
#line 299 "tracker-sparql-scanner.vala"
						case 'c':
#line 1474 "tracker-sparql-scanner.c"
						{
#line 306 "tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "UCASE")) {
#line 306 "tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_UCASE;
#line 306 "tracker-sparql-scanner.vala"
								return result;
#line 1482 "tracker-sparql-scanner.c"
							}
#line 307 "tracker-sparql-scanner.vala"
							break;
#line 1486 "tracker-sparql-scanner.c"
						}
						default:
#line 299 "tracker-sparql-scanner.vala"
						break;
#line 1491 "tracker-sparql-scanner.c"
					}
#line 309 "tracker-sparql-scanner.vala"
					break;
#line 1495 "tracker-sparql-scanner.c"
				}
#line 233 "tracker-sparql-scanner.vala"
				case 'W':
#line 233 "tracker-sparql-scanner.vala"
				case 'w':
#line 1501 "tracker-sparql-scanner.c"
				{
#line 312 "tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "WHERE")) {
#line 312 "tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_WHERE;
#line 312 "tracker-sparql-scanner.vala"
						return result;
#line 1509 "tracker-sparql-scanner.c"
					}
#line 313 "tracker-sparql-scanner.vala"
					break;
#line 1513 "tracker-sparql-scanner.c"
				}
#line 233 "tracker-sparql-scanner.vala"
				case 'F':
#line 233 "tracker-sparql-scanner.vala"
				case 'f':
#line 1519 "tracker-sparql-scanner.c"
				{
					gchar _tmp17_;
#line 316 "tracker-sparql-scanner.vala"
					_tmp17_ = begin[1];
#line 316 "tracker-sparql-scanner.vala"
					switch (_tmp17_) {
#line 316 "tracker-sparql-scanner.vala"
						case 'A':
#line 316 "tracker-sparql-scanner.vala"
						case 'a':
#line 1530 "tracker-sparql-scanner.c"
						{
#line 319 "tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "FALSE")) {
#line 319 "tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_FALSE;
#line 319 "tracker-sparql-scanner.vala"
								return result;
#line 1538 "tracker-sparql-scanner.c"
							}
#line 320 "tracker-sparql-scanner.vala"
							break;
#line 1542 "tracker-sparql-scanner.c"
						}
#line 316 "tracker-sparql-scanner.vala"
						case 'L':
#line 316 "tracker-sparql-scanner.vala"
						case 'l':
#line 1548 "tracker-sparql-scanner.c"
						{
#line 323 "tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "FLOOR")) {
#line 323 "tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_FLOOR;
#line 323 "tracker-sparql-scanner.vala"
								return result;
#line 1556 "tracker-sparql-scanner.c"
							}
#line 324 "tracker-sparql-scanner.vala"
							break;
#line 1560 "tracker-sparql-scanner.c"
						}
						default:
#line 316 "tracker-sparql-scanner.vala"
						break;
#line 1565 "tracker-sparql-scanner.c"
					}
#line 326 "tracker-sparql-scanner.vala"
					break;
#line 1569 "tracker-sparql-scanner.c"
				}
#line 233 "tracker-sparql-scanner.vala"
				case 'I':
#line 233 "tracker-sparql-scanner.vala"
				case 'i':
#line 1575 "tracker-sparql-scanner.c"
				{
					gchar _tmp18_;
#line 329 "tracker-sparql-scanner.vala"
					_tmp18_ = begin[1];
#line 329 "tracker-sparql-scanner.vala"
					switch (_tmp18_) {
#line 329 "tracker-sparql-scanner.vala"
						case 'S':
#line 329 "tracker-sparql-scanner.vala"
						case 's':
#line 1586 "tracker-sparql-scanner.c"
						{
							gchar _tmp19_;
#line 332 "tracker-sparql-scanner.vala"
							_tmp19_ = begin[2];
#line 332 "tracker-sparql-scanner.vala"
							switch (_tmp19_) {
#line 332 "tracker-sparql-scanner.vala"
								case 'I':
#line 332 "tracker-sparql-scanner.vala"
								case 'i':
#line 1597 "tracker-sparql-scanner.c"
								{
#line 335 "tracker-sparql-scanner.vala"
									if (tracker_sparql_scanner_matches (self, begin, "ISIRI")) {
#line 335 "tracker-sparql-scanner.vala"
										result = TRACKER_SPARQL_TOKEN_TYPE_ISIRI;
#line 335 "tracker-sparql-scanner.vala"
										return result;
#line 1605 "tracker-sparql-scanner.c"
									}
#line 336 "tracker-sparql-scanner.vala"
									break;
#line 1609 "tracker-sparql-scanner.c"
								}
#line 332 "tracker-sparql-scanner.vala"
								case 'U':
#line 332 "tracker-sparql-scanner.vala"
								case 'u':
#line 1615 "tracker-sparql-scanner.c"
								{
#line 339 "tracker-sparql-scanner.vala"
									if (tracker_sparql_scanner_matches (self, begin, "ISURI")) {
#line 339 "tracker-sparql-scanner.vala"
										result = TRACKER_SPARQL_TOKEN_TYPE_ISURI;
#line 339 "tracker-sparql-scanner.vala"
										return result;
#line 1623 "tracker-sparql-scanner.c"
									}
#line 340 "tracker-sparql-scanner.vala"
									break;
#line 1627 "tracker-sparql-scanner.c"
								}
								default:
#line 332 "tracker-sparql-scanner.vala"
								break;
#line 1632 "tracker-sparql-scanner.c"
							}
#line 342 "tracker-sparql-scanner.vala"
							break;
#line 1636 "tracker-sparql-scanner.c"
						}
						default:
#line 329 "tracker-sparql-scanner.vala"
						break;
#line 1641 "tracker-sparql-scanner.c"
					}
#line 344 "tracker-sparql-scanner.vala"
					break;
#line 1645 "tracker-sparql-scanner.c"
				}
				default:
#line 233 "tracker-sparql-scanner.vala"
				break;
#line 1650 "tracker-sparql-scanner.c"
			}
#line 346 "tracker-sparql-scanner.vala"
			break;
#line 1654 "tracker-sparql-scanner.c"
		}
#line 44 "tracker-sparql-scanner.vala"
		case 6:
#line 1658 "tracker-sparql-scanner.c"
		{
			gchar _tmp20_;
#line 348 "tracker-sparql-scanner.vala"
			_tmp20_ = begin[0];
#line 348 "tracker-sparql-scanner.vala"
			switch (_tmp20_) {
#line 348 "tracker-sparql-scanner.vala"
				case 'C':
#line 348 "tracker-sparql-scanner.vala"
				case 'c':
#line 1669 "tracker-sparql-scanner.c"
				{
#line 351 "tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "CONCAT")) {
#line 351 "tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_CONCAT;
#line 351 "tracker-sparql-scanner.vala"
						return result;
#line 1677 "tracker-sparql-scanner.c"
					}
#line 352 "tracker-sparql-scanner.vala"
					break;
#line 1681 "tracker-sparql-scanner.c"
				}
#line 348 "tracker-sparql-scanner.vala"
				case 'D':
#line 348 "tracker-sparql-scanner.vala"
				case 'd':
#line 1687 "tracker-sparql-scanner.c"
				{
#line 355 "tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "DELETE")) {
#line 355 "tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_DELETE;
#line 355 "tracker-sparql-scanner.vala"
						return result;
#line 1695 "tracker-sparql-scanner.c"
					}
#line 356 "tracker-sparql-scanner.vala"
					break;
#line 1699 "tracker-sparql-scanner.c"
				}
#line 348 "tracker-sparql-scanner.vala"
				case 'E':
#line 348 "tracker-sparql-scanner.vala"
				case 'e':
#line 1705 "tracker-sparql-scanner.c"
				{
#line 359 "tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "EXISTS")) {
#line 359 "tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_EXISTS;
#line 359 "tracker-sparql-scanner.vala"
						return result;
#line 1713 "tracker-sparql-scanner.c"
					}
#line 360 "tracker-sparql-scanner.vala"
					break;
#line 1717 "tracker-sparql-scanner.c"
				}
#line 348 "tracker-sparql-scanner.vala"
				case 'F':
#line 348 "tracker-sparql-scanner.vala"
				case 'f':
#line 1723 "tracker-sparql-scanner.c"
				{
#line 363 "tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "FILTER")) {
#line 363 "tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_FILTER;
#line 363 "tracker-sparql-scanner.vala"
						return result;
#line 1731 "tracker-sparql-scanner.c"
					}
#line 364 "tracker-sparql-scanner.vala"
					break;
#line 1735 "tracker-sparql-scanner.c"
				}
#line 348 "tracker-sparql-scanner.vala"
				case 'H':
#line 348 "tracker-sparql-scanner.vala"
				case 'h':
#line 1741 "tracker-sparql-scanner.c"
				{
#line 367 "tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "HAVING")) {
#line 367 "tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_HAVING;
#line 367 "tracker-sparql-scanner.vala"
						return result;
#line 1749 "tracker-sparql-scanner.c"
					}
#line 368 "tracker-sparql-scanner.vala"
					break;
#line 1753 "tracker-sparql-scanner.c"
				}
#line 348 "tracker-sparql-scanner.vala"
				case 'I':
#line 348 "tracker-sparql-scanner.vala"
				case 'i':
#line 1759 "tracker-sparql-scanner.c"
				{
#line 371 "tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "INSERT")) {
#line 371 "tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_INSERT;
#line 371 "tracker-sparql-scanner.vala"
						return result;
#line 1767 "tracker-sparql-scanner.c"
					}
#line 372 "tracker-sparql-scanner.vala"
					break;
#line 1771 "tracker-sparql-scanner.c"
				}
#line 348 "tracker-sparql-scanner.vala"
				case 'O':
#line 348 "tracker-sparql-scanner.vala"
				case 'o':
#line 1777 "tracker-sparql-scanner.c"
				{
#line 375 "tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "OFFSET")) {
#line 375 "tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_OFFSET;
#line 375 "tracker-sparql-scanner.vala"
						return result;
#line 1785 "tracker-sparql-scanner.c"
					}
#line 376 "tracker-sparql-scanner.vala"
					break;
#line 1789 "tracker-sparql-scanner.c"
				}
#line 348 "tracker-sparql-scanner.vala"
				case 'P':
#line 348 "tracker-sparql-scanner.vala"
				case 'p':
#line 1795 "tracker-sparql-scanner.c"
				{
#line 379 "tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "PREFIX")) {
#line 379 "tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_PREFIX;
#line 379 "tracker-sparql-scanner.vala"
						return result;
#line 1803 "tracker-sparql-scanner.c"
					}
#line 380 "tracker-sparql-scanner.vala"
					break;
#line 1807 "tracker-sparql-scanner.c"
				}
#line 348 "tracker-sparql-scanner.vala"
				case 'S':
#line 348 "tracker-sparql-scanner.vala"
				case 's':
#line 1813 "tracker-sparql-scanner.c"
				{
					gchar _tmp21_;
#line 383 "tracker-sparql-scanner.vala"
					_tmp21_ = begin[1];
#line 383 "tracker-sparql-scanner.vala"
					switch (_tmp21_) {
#line 383 "tracker-sparql-scanner.vala"
						case 'E':
#line 383 "tracker-sparql-scanner.vala"
						case 'e':
#line 1824 "tracker-sparql-scanner.c"
						{
#line 386 "tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "SELECT")) {
#line 386 "tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_SELECT;
#line 386 "tracker-sparql-scanner.vala"
								return result;
#line 1832 "tracker-sparql-scanner.c"
							}
#line 387 "tracker-sparql-scanner.vala"
							break;
#line 1836 "tracker-sparql-scanner.c"
						}
#line 383 "tracker-sparql-scanner.vala"
						case 'I':
#line 383 "tracker-sparql-scanner.vala"
						case 'i':
#line 1842 "tracker-sparql-scanner.c"
						{
#line 390 "tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "SILENT")) {
#line 390 "tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_SILENT;
#line 390 "tracker-sparql-scanner.vala"
								return result;
#line 1850 "tracker-sparql-scanner.c"
							}
#line 391 "tracker-sparql-scanner.vala"
							break;
#line 1854 "tracker-sparql-scanner.c"
						}
#line 383 "tracker-sparql-scanner.vala"
						case 'T':
#line 383 "tracker-sparql-scanner.vala"
						case 't':
#line 1860 "tracker-sparql-scanner.c"
						{
#line 394 "tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "STRLEN")) {
#line 394 "tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_STRLEN;
#line 394 "tracker-sparql-scanner.vala"
								return result;
#line 1868 "tracker-sparql-scanner.c"
							}
#line 395 "tracker-sparql-scanner.vala"
							break;
#line 1872 "tracker-sparql-scanner.c"
						}
#line 383 "tracker-sparql-scanner.vala"
						case 'U':
#line 383 "tracker-sparql-scanner.vala"
						case 'u':
#line 1878 "tracker-sparql-scanner.c"
						{
#line 398 "tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "SUBSTR")) {
#line 398 "tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_SUBSTR;
#line 398 "tracker-sparql-scanner.vala"
								return result;
#line 1886 "tracker-sparql-scanner.c"
							}
#line 399 "tracker-sparql-scanner.vala"
							break;
#line 1890 "tracker-sparql-scanner.c"
						}
#line 383 "tracker-sparql-scanner.vala"
						case 'H':
#line 383 "tracker-sparql-scanner.vala"
						case 'h':
#line 1896 "tracker-sparql-scanner.c"
						{
							gchar _tmp22_;
#line 402 "tracker-sparql-scanner.vala"
							_tmp22_ = begin[3];
#line 402 "tracker-sparql-scanner.vala"
							switch (_tmp22_) {
#line 402 "tracker-sparql-scanner.vala"
								case '2':
#line 1905 "tracker-sparql-scanner.c"
								{
#line 404 "tracker-sparql-scanner.vala"
									if (tracker_sparql_scanner_matches (self, begin, "SHA256")) {
#line 404 "tracker-sparql-scanner.vala"
										result = TRACKER_SPARQL_TOKEN_TYPE_SHA256;
#line 404 "tracker-sparql-scanner.vala"
										return result;
#line 1913 "tracker-sparql-scanner.c"
									}
#line 405 "tracker-sparql-scanner.vala"
									break;
#line 1917 "tracker-sparql-scanner.c"
								}
#line 402 "tracker-sparql-scanner.vala"
								case '5':
#line 1921 "tracker-sparql-scanner.c"
								{
#line 407 "tracker-sparql-scanner.vala"
									if (tracker_sparql_scanner_matches (self, begin, "SHA512")) {
#line 407 "tracker-sparql-scanner.vala"
										result = TRACKER_SPARQL_TOKEN_TYPE_SHA512;
#line 407 "tracker-sparql-scanner.vala"
										return result;
#line 1929 "tracker-sparql-scanner.c"
									}
#line 408 "tracker-sparql-scanner.vala"
									break;
#line 1933 "tracker-sparql-scanner.c"
								}
								default:
#line 402 "tracker-sparql-scanner.vala"
								break;
#line 1938 "tracker-sparql-scanner.c"
							}
#line 410 "tracker-sparql-scanner.vala"
							break;
#line 1942 "tracker-sparql-scanner.c"
						}
						default:
#line 383 "tracker-sparql-scanner.vala"
						break;
#line 1947 "tracker-sparql-scanner.c"
					}
#line 412 "tracker-sparql-scanner.vala"
					break;
#line 1951 "tracker-sparql-scanner.c"
				}
				default:
#line 348 "tracker-sparql-scanner.vala"
				break;
#line 1956 "tracker-sparql-scanner.c"
			}
#line 414 "tracker-sparql-scanner.vala"
			break;
#line 1960 "tracker-sparql-scanner.c"
		}
#line 44 "tracker-sparql-scanner.vala"
		case 7:
#line 1964 "tracker-sparql-scanner.c"
		{
			gchar _tmp23_;
#line 416 "tracker-sparql-scanner.vala"
			_tmp23_ = begin[0];
#line 416 "tracker-sparql-scanner.vala"
			switch (_tmp23_) {
#line 416 "tracker-sparql-scanner.vala"
				case 'M':
#line 416 "tracker-sparql-scanner.vala"
				case 'm':
#line 1975 "tracker-sparql-scanner.c"
				{
#line 419 "tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "MINUTES")) {
#line 419 "tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_MINUTES;
#line 419 "tracker-sparql-scanner.vala"
						return result;
#line 1983 "tracker-sparql-scanner.c"
					}
#line 420 "tracker-sparql-scanner.vala"
					break;
#line 1987 "tracker-sparql-scanner.c"
				}
#line 416 "tracker-sparql-scanner.vala"
				case 'R':
#line 416 "tracker-sparql-scanner.vala"
				case 'r':
#line 1993 "tracker-sparql-scanner.c"
				{
					gchar _tmp24_;
#line 423 "tracker-sparql-scanner.vala"
					_tmp24_ = begin[2];
#line 423 "tracker-sparql-scanner.vala"
					switch (_tmp24_) {
#line 423 "tracker-sparql-scanner.vala"
						case 'D':
#line 423 "tracker-sparql-scanner.vala"
						case 'd':
#line 2004 "tracker-sparql-scanner.c"
						{
#line 426 "tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "REDUCED")) {
#line 426 "tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_REDUCED;
#line 426 "tracker-sparql-scanner.vala"
								return result;
#line 2012 "tracker-sparql-scanner.c"
							}
#line 427 "tracker-sparql-scanner.vala"
							break;
#line 2016 "tracker-sparql-scanner.c"
						}
#line 423 "tracker-sparql-scanner.vala"
						case 'P':
#line 423 "tracker-sparql-scanner.vala"
						case 'p':
#line 2022 "tracker-sparql-scanner.c"
						{
#line 430 "tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "REPLACE")) {
#line 430 "tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_REPLACE;
#line 430 "tracker-sparql-scanner.vala"
								return result;
#line 2030 "tracker-sparql-scanner.c"
							}
#line 431 "tracker-sparql-scanner.vala"
							break;
#line 2034 "tracker-sparql-scanner.c"
						}
						default:
#line 423 "tracker-sparql-scanner.vala"
						break;
#line 2039 "tracker-sparql-scanner.c"
					}
#line 433 "tracker-sparql-scanner.vala"
					break;
#line 2043 "tracker-sparql-scanner.c"
				}
#line 416 "tracker-sparql-scanner.vala"
				case 'S':
#line 416 "tracker-sparql-scanner.vala"
				case 's':
#line 2049 "tracker-sparql-scanner.c"
				{
					gchar _tmp25_;
#line 436 "tracker-sparql-scanner.vala"
					_tmp25_ = begin[1];
#line 436 "tracker-sparql-scanner.vala"
					switch (_tmp25_) {
#line 436 "tracker-sparql-scanner.vala"
						case 'E':
#line 436 "tracker-sparql-scanner.vala"
						case 'e':
#line 2060 "tracker-sparql-scanner.c"
						{
#line 439 "tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "SECONDS")) {
#line 439 "tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_SECONDS;
#line 439 "tracker-sparql-scanner.vala"
								return result;
#line 2068 "tracker-sparql-scanner.c"
							}
#line 440 "tracker-sparql-scanner.vala"
							break;
#line 2072 "tracker-sparql-scanner.c"
						}
#line 436 "tracker-sparql-scanner.vala"
						case 'T':
#line 436 "tracker-sparql-scanner.vala"
						case 't':
#line 2078 "tracker-sparql-scanner.c"
						{
#line 443 "tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "STRENDS")) {
#line 443 "tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_STRENDS;
#line 443 "tracker-sparql-scanner.vala"
								return result;
#line 2086 "tracker-sparql-scanner.c"
							}
#line 444 "tracker-sparql-scanner.vala"
							break;
#line 2090 "tracker-sparql-scanner.c"
						}
						default:
#line 436 "tracker-sparql-scanner.vala"
						break;
#line 2095 "tracker-sparql-scanner.c"
					}
#line 446 "tracker-sparql-scanner.vala"
					break;
#line 2099 "tracker-sparql-scanner.c"
				}
#line 416 "tracker-sparql-scanner.vala"
				case 'I':
#line 416 "tracker-sparql-scanner.vala"
				case 'i':
#line 2105 "tracker-sparql-scanner.c"
				{
#line 449 "tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "ISBLANK")) {
#line 449 "tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_ISBLANK;
#line 449 "tracker-sparql-scanner.vala"
						return result;
#line 2113 "tracker-sparql-scanner.c"
					}
#line 450 "tracker-sparql-scanner.vala"
					break;
#line 2117 "tracker-sparql-scanner.c"
				}
				default:
#line 416 "tracker-sparql-scanner.vala"
				break;
#line 2122 "tracker-sparql-scanner.c"
			}
#line 452 "tracker-sparql-scanner.vala"
			break;
#line 2126 "tracker-sparql-scanner.c"
		}
#line 44 "tracker-sparql-scanner.vala"
		case 8:
#line 2130 "tracker-sparql-scanner.c"
		{
			gchar _tmp26_;
#line 454 "tracker-sparql-scanner.vala"
			_tmp26_ = begin[0];
#line 454 "tracker-sparql-scanner.vala"
			switch (_tmp26_) {
#line 454 "tracker-sparql-scanner.vala"
				case 'C':
#line 454 "tracker-sparql-scanner.vala"
				case 'c':
#line 2141 "tracker-sparql-scanner.c"
				{
					gchar _tmp27_;
#line 457 "tracker-sparql-scanner.vala"
					_tmp27_ = begin[2];
#line 457 "tracker-sparql-scanner.vala"
					switch (_tmp27_) {
#line 457 "tracker-sparql-scanner.vala"
						case 'A':
#line 457 "tracker-sparql-scanner.vala"
						case 'a':
#line 2152 "tracker-sparql-scanner.c"
						{
#line 460 "tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "COALESCE")) {
#line 460 "tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_COALESCE;
#line 460 "tracker-sparql-scanner.vala"
								return result;
#line 2160 "tracker-sparql-scanner.c"
							}
#line 461 "tracker-sparql-scanner.vala"
							break;
#line 2164 "tracker-sparql-scanner.c"
						}
#line 457 "tracker-sparql-scanner.vala"
						case 'N':
#line 457 "tracker-sparql-scanner.vala"
						case 'n':
#line 2170 "tracker-sparql-scanner.c"
						{
#line 464 "tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "CONTAINS")) {
#line 464 "tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_CONTAINS;
#line 464 "tracker-sparql-scanner.vala"
								return result;
#line 2178 "tracker-sparql-scanner.c"
							}
#line 465 "tracker-sparql-scanner.vala"
							break;
#line 2182 "tracker-sparql-scanner.c"
						}
						default:
#line 457 "tracker-sparql-scanner.vala"
						break;
#line 2187 "tracker-sparql-scanner.c"
					}
#line 467 "tracker-sparql-scanner.vala"
					break;
#line 2191 "tracker-sparql-scanner.c"
				}
#line 454 "tracker-sparql-scanner.vala"
				case 'D':
#line 454 "tracker-sparql-scanner.vala"
				case 'd':
#line 2197 "tracker-sparql-scanner.c"
				{
					gchar _tmp28_;
#line 470 "tracker-sparql-scanner.vala"
					_tmp28_ = begin[1];
#line 470 "tracker-sparql-scanner.vala"
					switch (_tmp28_) {
#line 470 "tracker-sparql-scanner.vala"
						case 'A':
#line 470 "tracker-sparql-scanner.vala"
						case 'a':
#line 2208 "tracker-sparql-scanner.c"
						{
#line 473 "tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "DATATYPE")) {
#line 473 "tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_DATATYPE;
#line 473 "tracker-sparql-scanner.vala"
								return result;
#line 2216 "tracker-sparql-scanner.c"
							}
#line 474 "tracker-sparql-scanner.vala"
							break;
#line 2220 "tracker-sparql-scanner.c"
						}
#line 470 "tracker-sparql-scanner.vala"
						case 'E':
#line 470 "tracker-sparql-scanner.vala"
						case 'e':
#line 2226 "tracker-sparql-scanner.c"
						{
#line 477 "tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "DESCRIBE")) {
#line 477 "tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_DESCRIBE;
#line 477 "tracker-sparql-scanner.vala"
								return result;
#line 2234 "tracker-sparql-scanner.c"
							}
#line 478 "tracker-sparql-scanner.vala"
							break;
#line 2238 "tracker-sparql-scanner.c"
						}
#line 470 "tracker-sparql-scanner.vala"
						case 'I':
#line 470 "tracker-sparql-scanner.vala"
						case 'i':
#line 2244 "tracker-sparql-scanner.c"
						{
#line 481 "tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "DISTINCT")) {
#line 481 "tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_DISTINCT;
#line 481 "tracker-sparql-scanner.vala"
								return result;
#line 2252 "tracker-sparql-scanner.c"
							}
#line 482 "tracker-sparql-scanner.vala"
							break;
#line 2256 "tracker-sparql-scanner.c"
						}
						default:
#line 470 "tracker-sparql-scanner.vala"
						break;
#line 2261 "tracker-sparql-scanner.c"
					}
#line 484 "tracker-sparql-scanner.vala"
					break;
#line 2265 "tracker-sparql-scanner.c"
				}
#line 454 "tracker-sparql-scanner.vala"
				case 'O':
#line 454 "tracker-sparql-scanner.vala"
				case 'o':
#line 2271 "tracker-sparql-scanner.c"
				{
#line 487 "tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "OPTIONAL")) {
#line 487 "tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_OPTIONAL;
#line 487 "tracker-sparql-scanner.vala"
						return result;
#line 2279 "tracker-sparql-scanner.c"
					}
#line 488 "tracker-sparql-scanner.vala"
					break;
#line 2283 "tracker-sparql-scanner.c"
				}
#line 454 "tracker-sparql-scanner.vala"
				case 'S':
#line 454 "tracker-sparql-scanner.vala"
				case 's':
#line 2289 "tracker-sparql-scanner.c"
				{
					gchar _tmp29_;
#line 491 "tracker-sparql-scanner.vala"
					_tmp29_ = begin[1];
#line 491 "tracker-sparql-scanner.vala"
					switch (_tmp29_) {
#line 491 "tracker-sparql-scanner.vala"
						case 'A':
#line 491 "tracker-sparql-scanner.vala"
						case 'a':
#line 2300 "tracker-sparql-scanner.c"
						{
#line 494 "tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "SAMETERM")) {
#line 494 "tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_SAMETERM;
#line 494 "tracker-sparql-scanner.vala"
								return result;
#line 2308 "tracker-sparql-scanner.c"
							}
#line 495 "tracker-sparql-scanner.vala"
							break;
#line 2312 "tracker-sparql-scanner.c"
						}
#line 491 "tracker-sparql-scanner.vala"
						case 'T':
#line 491 "tracker-sparql-scanner.vala"
						case 't':
#line 2318 "tracker-sparql-scanner.c"
						{
#line 498 "tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "STRAFTER")) {
#line 498 "tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_STRAFTER;
#line 498 "tracker-sparql-scanner.vala"
								return result;
#line 2326 "tracker-sparql-scanner.c"
							}
#line 499 "tracker-sparql-scanner.vala"
							break;
#line 2330 "tracker-sparql-scanner.c"
						}
						default:
#line 491 "tracker-sparql-scanner.vala"
						break;
#line 2335 "tracker-sparql-scanner.c"
					}
#line 501 "tracker-sparql-scanner.vala"
					break;
#line 2339 "tracker-sparql-scanner.c"
				}
				default:
#line 454 "tracker-sparql-scanner.vala"
				break;
#line 2344 "tracker-sparql-scanner.c"
			}
#line 503 "tracker-sparql-scanner.vala"
			break;
#line 2348 "tracker-sparql-scanner.c"
		}
#line 44 "tracker-sparql-scanner.vala"
		case 9:
#line 2352 "tracker-sparql-scanner.c"
		{
			gchar _tmp30_;
#line 505 "tracker-sparql-scanner.vala"
			_tmp30_ = begin[0];
#line 505 "tracker-sparql-scanner.vala"
			switch (_tmp30_) {
#line 505 "tracker-sparql-scanner.vala"
				case 'C':
#line 505 "tracker-sparql-scanner.vala"
				case 'c':
#line 2363 "tracker-sparql-scanner.c"
				{
#line 508 "tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "CONSTRUCT")) {
#line 508 "tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_CONSTRUCT;
#line 508 "tracker-sparql-scanner.vala"
						return result;
#line 2371 "tracker-sparql-scanner.c"
					}
#line 509 "tracker-sparql-scanner.vala"
					break;
#line 2375 "tracker-sparql-scanner.c"
				}
#line 505 "tracker-sparql-scanner.vala"
				case 'I':
#line 505 "tracker-sparql-scanner.vala"
				case 'i':
#line 2381 "tracker-sparql-scanner.c"
				{
#line 512 "tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "ISLITERAL")) {
#line 512 "tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL;
#line 512 "tracker-sparql-scanner.vala"
						return result;
#line 2389 "tracker-sparql-scanner.c"
					}
#line 513 "tracker-sparql-scanner.vala"
					break;
#line 2393 "tracker-sparql-scanner.c"
				}
#line 505 "tracker-sparql-scanner.vala"
				case 'S':
#line 505 "tracker-sparql-scanner.vala"
				case 's':
#line 2399 "tracker-sparql-scanner.c"
				{
					gchar _tmp31_;
#line 516 "tracker-sparql-scanner.vala"
					_tmp31_ = begin[3];
#line 516 "tracker-sparql-scanner.vala"
					switch (_tmp31_) {
#line 516 "tracker-sparql-scanner.vala"
						case 'B':
#line 516 "tracker-sparql-scanner.vala"
						case 'b':
#line 2410 "tracker-sparql-scanner.c"
						{
#line 519 "tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "STRBEFORE")) {
#line 519 "tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_STRBEFORE;
#line 519 "tracker-sparql-scanner.vala"
								return result;
#line 2418 "tracker-sparql-scanner.c"
							}
#line 520 "tracker-sparql-scanner.vala"
							break;
#line 2422 "tracker-sparql-scanner.c"
						}
#line 516 "tracker-sparql-scanner.vala"
						case 'S':
#line 516 "tracker-sparql-scanner.vala"
						case 's':
#line 2428 "tracker-sparql-scanner.c"
						{
#line 523 "tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "STRSTARTS")) {
#line 523 "tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_STRSTARTS;
#line 523 "tracker-sparql-scanner.vala"
								return result;
#line 2436 "tracker-sparql-scanner.c"
							}
#line 524 "tracker-sparql-scanner.vala"
							break;
#line 2440 "tracker-sparql-scanner.c"
						}
						default:
#line 516 "tracker-sparql-scanner.vala"
						break;
#line 2445 "tracker-sparql-scanner.c"
					}
#line 526 "tracker-sparql-scanner.vala"
					break;
#line 2449 "tracker-sparql-scanner.c"
				}
				default:
#line 505 "tracker-sparql-scanner.vala"
				break;
#line 2454 "tracker-sparql-scanner.c"
			}
#line 528 "tracker-sparql-scanner.vala"
			break;
#line 2458 "tracker-sparql-scanner.c"
		}
#line 44 "tracker-sparql-scanner.vala"
		case 11:
#line 2462 "tracker-sparql-scanner.c"
		{
#line 530 "tracker-sparql-scanner.vala"
			if (tracker_sparql_scanner_matches (self, begin, "LANGMATCHES")) {
#line 530 "tracker-sparql-scanner.vala"
				result = TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES;
#line 530 "tracker-sparql-scanner.vala"
				return result;
#line 2470 "tracker-sparql-scanner.c"
			}
#line 531 "tracker-sparql-scanner.vala"
			break;
#line 2474 "tracker-sparql-scanner.c"
		}
#line 44 "tracker-sparql-scanner.vala"
		case 12:
#line 2478 "tracker-sparql-scanner.c"
		{
#line 533 "tracker-sparql-scanner.vala"
			if (tracker_sparql_scanner_matches (self, begin, "GROUP_CONCAT")) {
#line 533 "tracker-sparql-scanner.vala"
				result = TRACKER_SPARQL_TOKEN_TYPE_GROUP_CONCAT;
#line 533 "tracker-sparql-scanner.vala"
				return result;
#line 2486 "tracker-sparql-scanner.c"
			}
#line 534 "tracker-sparql-scanner.vala"
			break;
#line 2490 "tracker-sparql-scanner.c"
		}
#line 44 "tracker-sparql-scanner.vala"
		case 14:
#line 2494 "tracker-sparql-scanner.c"
		{
#line 536 "tracker-sparql-scanner.vala"
			if (tracker_sparql_scanner_matches (self, begin, "ENCODE_FOR_URI")) {
#line 536 "tracker-sparql-scanner.vala"
				result = TRACKER_SPARQL_TOKEN_TYPE_ENCODE_FOR_URI;
#line 536 "tracker-sparql-scanner.vala"
				return result;
#line 2502 "tracker-sparql-scanner.c"
			}
#line 537 "tracker-sparql-scanner.vala"
			break;
#line 2506 "tracker-sparql-scanner.c"
		}
		default:
#line 44 "tracker-sparql-scanner.vala"
		break;
#line 2511 "tracker-sparql-scanner.c"
	}
#line 539 "tracker-sparql-scanner.vala"
	result = TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX;
#line 539 "tracker-sparql-scanner.vala"
	return result;
#line 2517 "tracker-sparql-scanner.c"
}


static TrackerSparqlTokenType
tracker_sparql_scanner_read_number (TrackerSparqlScanner* self)
{
	TrackerSparqlTokenType result = 0;
	TrackerSparqlTokenType type = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp24_ = FALSE;
	gboolean _tmp25_ = FALSE;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gboolean _tmp39_ = FALSE;
	gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp60_;
	gchar* _tmp61_;
#line 542 "tracker-sparql-scanner.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 543 "tracker-sparql-scanner.vala"
	type = TRACKER_SPARQL_TOKEN_TYPE_INTEGER;
#line 546 "tracker-sparql-scanner.vala"
	_tmp3_ = self->priv->current;
#line 546 "tracker-sparql-scanner.vala"
	_tmp4_ = self->priv->end;
#line 546 "tracker-sparql-scanner.vala"
	if (_tmp3_ < (_tmp4_ - 2)) {
#line 2550 "tracker-sparql-scanner.c"
		gchar* _tmp5_;
		gchar _tmp6_;
#line 546 "tracker-sparql-scanner.vala"
		_tmp5_ = self->priv->current;
#line 546 "tracker-sparql-scanner.vala"
		_tmp6_ = _tmp5_[0];
#line 546 "tracker-sparql-scanner.vala"
		_tmp2_ = _tmp6_ == '0';
#line 2559 "tracker-sparql-scanner.c"
	} else {
#line 546 "tracker-sparql-scanner.vala"
		_tmp2_ = FALSE;
#line 2563 "tracker-sparql-scanner.c"
	}
#line 546 "tracker-sparql-scanner.vala"
	if (_tmp2_) {
#line 2567 "tracker-sparql-scanner.c"
		gchar* _tmp7_;
		gchar _tmp8_;
#line 547 "tracker-sparql-scanner.vala"
		_tmp7_ = self->priv->current;
#line 547 "tracker-sparql-scanner.vala"
		_tmp8_ = _tmp7_[1];
#line 547 "tracker-sparql-scanner.vala"
		_tmp1_ = _tmp8_ == 'x';
#line 2576 "tracker-sparql-scanner.c"
	} else {
#line 546 "tracker-sparql-scanner.vala"
		_tmp1_ = FALSE;
#line 2580 "tracker-sparql-scanner.c"
	}
#line 546 "tracker-sparql-scanner.vala"
	if (_tmp1_) {
#line 2584 "tracker-sparql-scanner.c"
		gchar* _tmp9_;
		gchar _tmp10_;
#line 547 "tracker-sparql-scanner.vala"
		_tmp9_ = self->priv->current;
#line 547 "tracker-sparql-scanner.vala"
		_tmp10_ = _tmp9_[2];
#line 547 "tracker-sparql-scanner.vala"
		_tmp0_ = g_ascii_isxdigit (_tmp10_);
#line 2593 "tracker-sparql-scanner.c"
	} else {
#line 546 "tracker-sparql-scanner.vala"
		_tmp0_ = FALSE;
#line 2597 "tracker-sparql-scanner.c"
	}
#line 546 "tracker-sparql-scanner.vala"
	if (_tmp0_) {
#line 2601 "tracker-sparql-scanner.c"
		gchar* _tmp11_;
#line 549 "tracker-sparql-scanner.vala"
		_tmp11_ = self->priv->current;
#line 549 "tracker-sparql-scanner.vala"
		self->priv->current = _tmp11_ + 2;
#line 550 "tracker-sparql-scanner.vala"
		while (TRUE) {
#line 2609 "tracker-sparql-scanner.c"
			gboolean _tmp12_ = FALSE;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp17_;
#line 550 "tracker-sparql-scanner.vala"
			_tmp13_ = self->priv->current;
#line 550 "tracker-sparql-scanner.vala"
			_tmp14_ = self->priv->end;
#line 550 "tracker-sparql-scanner.vala"
			if (_tmp13_ < _tmp14_) {
#line 2620 "tracker-sparql-scanner.c"
				gchar* _tmp15_;
				gchar _tmp16_;
#line 550 "tracker-sparql-scanner.vala"
				_tmp15_ = self->priv->current;
#line 550 "tracker-sparql-scanner.vala"
				_tmp16_ = _tmp15_[0];
#line 550 "tracker-sparql-scanner.vala"
				_tmp12_ = g_ascii_isxdigit (_tmp16_);
#line 2629 "tracker-sparql-scanner.c"
			} else {
#line 550 "tracker-sparql-scanner.vala"
				_tmp12_ = FALSE;
#line 2633 "tracker-sparql-scanner.c"
			}
#line 550 "tracker-sparql-scanner.vala"
			if (!_tmp12_) {
#line 550 "tracker-sparql-scanner.vala"
				break;
#line 2639 "tracker-sparql-scanner.c"
			}
#line 551 "tracker-sparql-scanner.vala"
			_tmp17_ = self->priv->current;
#line 551 "tracker-sparql-scanner.vala"
			self->priv->current = _tmp17_ + 1;
#line 2645 "tracker-sparql-scanner.c"
		}
	} else {
#line 555 "tracker-sparql-scanner.vala"
		while (TRUE) {
#line 2650 "tracker-sparql-scanner.c"
			gboolean _tmp18_ = FALSE;
			gchar* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp23_;
#line 555 "tracker-sparql-scanner.vala"
			_tmp19_ = self->priv->current;
#line 555 "tracker-sparql-scanner.vala"
			_tmp20_ = self->priv->end;
#line 555 "tracker-sparql-scanner.vala"
			if (_tmp19_ < _tmp20_) {
#line 2661 "tracker-sparql-scanner.c"
				gchar* _tmp21_;
				gchar _tmp22_;
#line 555 "tracker-sparql-scanner.vala"
				_tmp21_ = self->priv->current;
#line 555 "tracker-sparql-scanner.vala"
				_tmp22_ = _tmp21_[0];
#line 555 "tracker-sparql-scanner.vala"
				_tmp18_ = g_ascii_isdigit (_tmp22_);
#line 2670 "tracker-sparql-scanner.c"
			} else {
#line 555 "tracker-sparql-scanner.vala"
				_tmp18_ = FALSE;
#line 2674 "tracker-sparql-scanner.c"
			}
#line 555 "tracker-sparql-scanner.vala"
			if (!_tmp18_) {
#line 555 "tracker-sparql-scanner.vala"
				break;
#line 2680 "tracker-sparql-scanner.c"
			}
#line 556 "tracker-sparql-scanner.vala"
			_tmp23_ = self->priv->current;
#line 556 "tracker-sparql-scanner.vala"
			self->priv->current = _tmp23_ + 1;
#line 2686 "tracker-sparql-scanner.c"
		}
	}
#line 561 "tracker-sparql-scanner.vala"
	_tmp26_ = self->priv->current;
#line 561 "tracker-sparql-scanner.vala"
	_tmp27_ = self->priv->end;
#line 561 "tracker-sparql-scanner.vala"
	if (_tmp26_ < (_tmp27_ - 1)) {
#line 2695 "tracker-sparql-scanner.c"
		gchar* _tmp28_;
		gchar _tmp29_;
#line 561 "tracker-sparql-scanner.vala"
		_tmp28_ = self->priv->current;
#line 561 "tracker-sparql-scanner.vala"
		_tmp29_ = _tmp28_[0];
#line 561 "tracker-sparql-scanner.vala"
		_tmp25_ = _tmp29_ == '.';
#line 2704 "tracker-sparql-scanner.c"
	} else {
#line 561 "tracker-sparql-scanner.vala"
		_tmp25_ = FALSE;
#line 2708 "tracker-sparql-scanner.c"
	}
#line 561 "tracker-sparql-scanner.vala"
	if (_tmp25_) {
#line 2712 "tracker-sparql-scanner.c"
		gchar* _tmp30_;
		gchar _tmp31_;
#line 561 "tracker-sparql-scanner.vala"
		_tmp30_ = self->priv->current;
#line 561 "tracker-sparql-scanner.vala"
		_tmp31_ = _tmp30_[1];
#line 561 "tracker-sparql-scanner.vala"
		_tmp24_ = g_ascii_isdigit (_tmp31_);
#line 2721 "tracker-sparql-scanner.c"
	} else {
#line 561 "tracker-sparql-scanner.vala"
		_tmp24_ = FALSE;
#line 2725 "tracker-sparql-scanner.c"
	}
#line 561 "tracker-sparql-scanner.vala"
	if (_tmp24_) {
#line 2729 "tracker-sparql-scanner.c"
		gchar* _tmp32_;
#line 562 "tracker-sparql-scanner.vala"
		type = TRACKER_SPARQL_TOKEN_TYPE_DOUBLE;
#line 563 "tracker-sparql-scanner.vala"
		_tmp32_ = self->priv->current;
#line 563 "tracker-sparql-scanner.vala"
		self->priv->current = _tmp32_ + 1;
#line 564 "tracker-sparql-scanner.vala"
		while (TRUE) {
#line 2739 "tracker-sparql-scanner.c"
			gboolean _tmp33_ = FALSE;
			gchar* _tmp34_;
			gchar* _tmp35_;
			gchar* _tmp38_;
#line 564 "tracker-sparql-scanner.vala"
			_tmp34_ = self->priv->current;
#line 564 "tracker-sparql-scanner.vala"
			_tmp35_ = self->priv->end;
#line 564 "tracker-sparql-scanner.vala"
			if (_tmp34_ < _tmp35_) {
#line 2750 "tracker-sparql-scanner.c"
				gchar* _tmp36_;
				gchar _tmp37_;
#line 564 "tracker-sparql-scanner.vala"
				_tmp36_ = self->priv->current;
#line 564 "tracker-sparql-scanner.vala"
				_tmp37_ = _tmp36_[0];
#line 564 "tracker-sparql-scanner.vala"
				_tmp33_ = g_ascii_isdigit (_tmp37_);
#line 2759 "tracker-sparql-scanner.c"
			} else {
#line 564 "tracker-sparql-scanner.vala"
				_tmp33_ = FALSE;
#line 2763 "tracker-sparql-scanner.c"
			}
#line 564 "tracker-sparql-scanner.vala"
			if (!_tmp33_) {
#line 564 "tracker-sparql-scanner.vala"
				break;
#line 2769 "tracker-sparql-scanner.c"
			}
#line 565 "tracker-sparql-scanner.vala"
			_tmp38_ = self->priv->current;
#line 565 "tracker-sparql-scanner.vala"
			self->priv->current = _tmp38_ + 1;
#line 2775 "tracker-sparql-scanner.c"
		}
	}
#line 570 "tracker-sparql-scanner.vala"
	_tmp40_ = self->priv->current;
#line 570 "tracker-sparql-scanner.vala"
	_tmp41_ = self->priv->end;
#line 570 "tracker-sparql-scanner.vala"
	if (_tmp40_ < _tmp41_) {
#line 2784 "tracker-sparql-scanner.c"
		gchar* _tmp42_;
		gchar _tmp43_;
#line 570 "tracker-sparql-scanner.vala"
		_tmp42_ = self->priv->current;
#line 570 "tracker-sparql-scanner.vala"
		_tmp43_ = _tmp42_[0];
#line 570 "tracker-sparql-scanner.vala"
		_tmp39_ = g_ascii_tolower (_tmp43_) == 'e';
#line 2793 "tracker-sparql-scanner.c"
	} else {
#line 570 "tracker-sparql-scanner.vala"
		_tmp39_ = FALSE;
#line 2797 "tracker-sparql-scanner.c"
	}
#line 570 "tracker-sparql-scanner.vala"
	if (_tmp39_) {
#line 2801 "tracker-sparql-scanner.c"
		gchar* _tmp44_;
		gboolean _tmp45_ = FALSE;
		gchar* _tmp46_;
		gchar* _tmp47_;
#line 571 "tracker-sparql-scanner.vala"
		type = TRACKER_SPARQL_TOKEN_TYPE_DOUBLE;
#line 572 "tracker-sparql-scanner.vala"
		_tmp44_ = self->priv->current;
#line 572 "tracker-sparql-scanner.vala"
		self->priv->current = _tmp44_ + 1;
#line 573 "tracker-sparql-scanner.vala"
		_tmp46_ = self->priv->current;
#line 573 "tracker-sparql-scanner.vala"
		_tmp47_ = self->priv->end;
#line 573 "tracker-sparql-scanner.vala"
		if (_tmp46_ < _tmp47_) {
#line 2818 "tracker-sparql-scanner.c"
			gboolean _tmp48_ = FALSE;
			gchar* _tmp49_;
			gchar _tmp50_;
#line 573 "tracker-sparql-scanner.vala"
			_tmp49_ = self->priv->current;
#line 573 "tracker-sparql-scanner.vala"
			_tmp50_ = _tmp49_[0];
#line 573 "tracker-sparql-scanner.vala"
			if (_tmp50_ == '+') {
#line 573 "tracker-sparql-scanner.vala"
				_tmp48_ = TRUE;
#line 2830 "tracker-sparql-scanner.c"
			} else {
				gchar* _tmp51_;
				gchar _tmp52_;
#line 573 "tracker-sparql-scanner.vala"
				_tmp51_ = self->priv->current;
#line 573 "tracker-sparql-scanner.vala"
				_tmp52_ = _tmp51_[0];
#line 573 "tracker-sparql-scanner.vala"
				_tmp48_ = _tmp52_ == '-';
#line 2840 "tracker-sparql-scanner.c"
			}
#line 573 "tracker-sparql-scanner.vala"
			_tmp45_ = _tmp48_;
#line 2844 "tracker-sparql-scanner.c"
		} else {
#line 573 "tracker-sparql-scanner.vala"
			_tmp45_ = FALSE;
#line 2848 "tracker-sparql-scanner.c"
		}
#line 573 "tracker-sparql-scanner.vala"
		if (_tmp45_) {
#line 2852 "tracker-sparql-scanner.c"
			gchar* _tmp53_;
#line 574 "tracker-sparql-scanner.vala"
			_tmp53_ = self->priv->current;
#line 574 "tracker-sparql-scanner.vala"
			self->priv->current = _tmp53_ + 1;
#line 2858 "tracker-sparql-scanner.c"
		}
#line 576 "tracker-sparql-scanner.vala"
		while (TRUE) {
#line 2862 "tracker-sparql-scanner.c"
			gboolean _tmp54_ = FALSE;
			gchar* _tmp55_;
			gchar* _tmp56_;
			gchar* _tmp59_;
#line 576 "tracker-sparql-scanner.vala"
			_tmp55_ = self->priv->current;
#line 576 "tracker-sparql-scanner.vala"
			_tmp56_ = self->priv->end;
#line 576 "tracker-sparql-scanner.vala"
			if (_tmp55_ < _tmp56_) {
#line 2873 "tracker-sparql-scanner.c"
				gchar* _tmp57_;
				gchar _tmp58_;
#line 576 "tracker-sparql-scanner.vala"
				_tmp57_ = self->priv->current;
#line 576 "tracker-sparql-scanner.vala"
				_tmp58_ = _tmp57_[0];
#line 576 "tracker-sparql-scanner.vala"
				_tmp54_ = g_ascii_isdigit (_tmp58_);
#line 2882 "tracker-sparql-scanner.c"
			} else {
#line 576 "tracker-sparql-scanner.vala"
				_tmp54_ = FALSE;
#line 2886 "tracker-sparql-scanner.c"
			}
#line 576 "tracker-sparql-scanner.vala"
			if (!_tmp54_) {
#line 576 "tracker-sparql-scanner.vala"
				break;
#line 2892 "tracker-sparql-scanner.c"
			}
#line 577 "tracker-sparql-scanner.vala"
			_tmp59_ = self->priv->current;
#line 577 "tracker-sparql-scanner.vala"
			self->priv->current = _tmp59_ + 1;
#line 2898 "tracker-sparql-scanner.c"
		}
	}
#line 582 "tracker-sparql-scanner.vala"
	_tmp60_ = self->priv->current;
#line 582 "tracker-sparql-scanner.vala"
	_tmp61_ = self->priv->end;
#line 582 "tracker-sparql-scanner.vala"
	if (_tmp60_ < _tmp61_) {
#line 2907 "tracker-sparql-scanner.c"
		gchar* _tmp62_;
		gchar _tmp63_;
#line 583 "tracker-sparql-scanner.vala"
		_tmp62_ = self->priv->current;
#line 583 "tracker-sparql-scanner.vala"
		_tmp63_ = _tmp62_[0];
#line 583 "tracker-sparql-scanner.vala"
		switch (_tmp63_) {
#line 583 "tracker-sparql-scanner.vala"
			case 'l':
#line 583 "tracker-sparql-scanner.vala"
			case 'L':
#line 2920 "tracker-sparql-scanner.c"
			{
				TrackerSparqlTokenType _tmp64_;
#line 586 "tracker-sparql-scanner.vala"
				_tmp64_ = type;
#line 586 "tracker-sparql-scanner.vala"
				if (_tmp64_ == TRACKER_SPARQL_TOKEN_TYPE_INTEGER) {
#line 2927 "tracker-sparql-scanner.c"
					gchar* _tmp65_;
					gboolean _tmp66_ = FALSE;
					gchar* _tmp67_;
					gchar* _tmp68_;
#line 587 "tracker-sparql-scanner.vala"
					_tmp65_ = self->priv->current;
#line 587 "tracker-sparql-scanner.vala"
					self->priv->current = _tmp65_ + 1;
#line 588 "tracker-sparql-scanner.vala"
					_tmp67_ = self->priv->current;
#line 588 "tracker-sparql-scanner.vala"
					_tmp68_ = self->priv->end;
#line 588 "tracker-sparql-scanner.vala"
					if (_tmp67_ < _tmp68_) {
#line 2942 "tracker-sparql-scanner.c"
						gchar* _tmp69_;
						gchar _tmp70_;
#line 588 "tracker-sparql-scanner.vala"
						_tmp69_ = self->priv->current;
#line 588 "tracker-sparql-scanner.vala"
						_tmp70_ = _tmp69_[0];
#line 588 "tracker-sparql-scanner.vala"
						_tmp66_ = g_ascii_tolower (_tmp70_) == 'l';
#line 2951 "tracker-sparql-scanner.c"
					} else {
#line 588 "tracker-sparql-scanner.vala"
						_tmp66_ = FALSE;
#line 2955 "tracker-sparql-scanner.c"
					}
#line 588 "tracker-sparql-scanner.vala"
					if (_tmp66_) {
#line 2959 "tracker-sparql-scanner.c"
						gchar* _tmp71_;
#line 589 "tracker-sparql-scanner.vala"
						_tmp71_ = self->priv->current;
#line 589 "tracker-sparql-scanner.vala"
						self->priv->current = _tmp71_ + 1;
#line 2965 "tracker-sparql-scanner.c"
					}
				}
#line 592 "tracker-sparql-scanner.vala"
				break;
#line 2970 "tracker-sparql-scanner.c"
			}
#line 583 "tracker-sparql-scanner.vala"
			case 'u':
#line 583 "tracker-sparql-scanner.vala"
			case 'U':
#line 2976 "tracker-sparql-scanner.c"
			{
				TrackerSparqlTokenType _tmp72_;
#line 595 "tracker-sparql-scanner.vala"
				_tmp72_ = type;
#line 595 "tracker-sparql-scanner.vala"
				if (_tmp72_ == TRACKER_SPARQL_TOKEN_TYPE_INTEGER) {
#line 2983 "tracker-sparql-scanner.c"
					gchar* _tmp73_;
					gboolean _tmp74_ = FALSE;
					gchar* _tmp75_;
					gchar* _tmp76_;
#line 596 "tracker-sparql-scanner.vala"
					_tmp73_ = self->priv->current;
#line 596 "tracker-sparql-scanner.vala"
					self->priv->current = _tmp73_ + 1;
#line 597 "tracker-sparql-scanner.vala"
					_tmp75_ = self->priv->current;
#line 597 "tracker-sparql-scanner.vala"
					_tmp76_ = self->priv->end;
#line 597 "tracker-sparql-scanner.vala"
					if (_tmp75_ < _tmp76_) {
#line 2998 "tracker-sparql-scanner.c"
						gchar* _tmp77_;
						gchar _tmp78_;
#line 597 "tracker-sparql-scanner.vala"
						_tmp77_ = self->priv->current;
#line 597 "tracker-sparql-scanner.vala"
						_tmp78_ = _tmp77_[0];
#line 597 "tracker-sparql-scanner.vala"
						_tmp74_ = g_ascii_tolower (_tmp78_) == 'l';
#line 3007 "tracker-sparql-scanner.c"
					} else {
#line 597 "tracker-sparql-scanner.vala"
						_tmp74_ = FALSE;
#line 3011 "tracker-sparql-scanner.c"
					}
#line 597 "tracker-sparql-scanner.vala"
					if (_tmp74_) {
#line 3015 "tracker-sparql-scanner.c"
						gchar* _tmp79_;
						gboolean _tmp80_ = FALSE;
						gchar* _tmp81_;
						gchar* _tmp82_;
#line 598 "tracker-sparql-scanner.vala"
						_tmp79_ = self->priv->current;
#line 598 "tracker-sparql-scanner.vala"
						self->priv->current = _tmp79_ + 1;
#line 599 "tracker-sparql-scanner.vala"
						_tmp81_ = self->priv->current;
#line 599 "tracker-sparql-scanner.vala"
						_tmp82_ = self->priv->end;
#line 599 "tracker-sparql-scanner.vala"
						if (_tmp81_ < _tmp82_) {
#line 3030 "tracker-sparql-scanner.c"
							gchar* _tmp83_;
							gchar _tmp84_;
#line 599 "tracker-sparql-scanner.vala"
							_tmp83_ = self->priv->current;
#line 599 "tracker-sparql-scanner.vala"
							_tmp84_ = _tmp83_[0];
#line 599 "tracker-sparql-scanner.vala"
							_tmp80_ = g_ascii_tolower (_tmp84_) == 'l';
#line 3039 "tracker-sparql-scanner.c"
						} else {
#line 599 "tracker-sparql-scanner.vala"
							_tmp80_ = FALSE;
#line 3043 "tracker-sparql-scanner.c"
						}
#line 599 "tracker-sparql-scanner.vala"
						if (_tmp80_) {
#line 3047 "tracker-sparql-scanner.c"
							gchar* _tmp85_;
#line 600 "tracker-sparql-scanner.vala"
							_tmp85_ = self->priv->current;
#line 600 "tracker-sparql-scanner.vala"
							self->priv->current = _tmp85_ + 1;
#line 3053 "tracker-sparql-scanner.c"
						}
					}
				}
#line 604 "tracker-sparql-scanner.vala"
				break;
#line 3059 "tracker-sparql-scanner.c"
			}
#line 583 "tracker-sparql-scanner.vala"
			case 'f':
#line 583 "tracker-sparql-scanner.vala"
			case 'F':
#line 583 "tracker-sparql-scanner.vala"
			case 'd':
#line 583 "tracker-sparql-scanner.vala"
			case 'D':
#line 3069 "tracker-sparql-scanner.c"
			{
				gchar* _tmp86_;
#line 609 "tracker-sparql-scanner.vala"
				type = TRACKER_SPARQL_TOKEN_TYPE_DOUBLE;
#line 610 "tracker-sparql-scanner.vala"
				_tmp86_ = self->priv->current;
#line 610 "tracker-sparql-scanner.vala"
				self->priv->current = _tmp86_ + 1;
#line 611 "tracker-sparql-scanner.vala"
				break;
#line 3080 "tracker-sparql-scanner.c"
			}
			default:
#line 583 "tracker-sparql-scanner.vala"
			break;
#line 3085 "tracker-sparql-scanner.c"
		}
	}
#line 615 "tracker-sparql-scanner.vala"
	result = type;
#line 615 "tracker-sparql-scanner.vala"
	return result;
#line 3092 "tracker-sparql-scanner.c"
}


static gboolean
tracker_sparql_scanner_is_pn_char (TrackerSparqlScanner* self,
                                   gchar c)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
#line 618 "tracker-sparql-scanner.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 619 "tracker-sparql-scanner.vala"
	if (g_ascii_isalnum (c)) {
#line 619 "tracker-sparql-scanner.vala"
		_tmp1_ = TRUE;
#line 3109 "tracker-sparql-scanner.c"
	} else {
#line 619 "tracker-sparql-scanner.vala"
		_tmp1_ = c == '_';
#line 3113 "tracker-sparql-scanner.c"
	}
#line 619 "tracker-sparql-scanner.vala"
	if (_tmp1_) {
#line 619 "tracker-sparql-scanner.vala"
		_tmp0_ = TRUE;
#line 3119 "tracker-sparql-scanner.c"
	} else {
#line 619 "tracker-sparql-scanner.vala"
		_tmp0_ = c == '-';
#line 3123 "tracker-sparql-scanner.c"
	}
#line 619 "tracker-sparql-scanner.vala"
	result = _tmp0_;
#line 619 "tracker-sparql-scanner.vala"
	return result;
#line 3129 "tracker-sparql-scanner.c"
}


static gboolean
tracker_sparql_scanner_is_pn_local_char (TrackerSparqlScanner* self,
                                         gchar c)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 622 "tracker-sparql-scanner.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 623 "tracker-sparql-scanner.vala"
	if (g_ascii_isalnum (c)) {
#line 623 "tracker-sparql-scanner.vala"
		_tmp2_ = TRUE;
#line 3147 "tracker-sparql-scanner.c"
	} else {
#line 623 "tracker-sparql-scanner.vala"
		_tmp2_ = c == '_';
#line 3151 "tracker-sparql-scanner.c"
	}
#line 623 "tracker-sparql-scanner.vala"
	if (_tmp2_) {
#line 623 "tracker-sparql-scanner.vala"
		_tmp1_ = TRUE;
#line 3157 "tracker-sparql-scanner.c"
	} else {
#line 623 "tracker-sparql-scanner.vala"
		_tmp1_ = c == '-';
#line 3161 "tracker-sparql-scanner.c"
	}
#line 623 "tracker-sparql-scanner.vala"
	if (_tmp1_) {
#line 623 "tracker-sparql-scanner.vala"
		_tmp0_ = TRUE;
#line 3167 "tracker-sparql-scanner.c"
	} else {
#line 623 "tracker-sparql-scanner.vala"
		_tmp0_ = c == '.';
#line 3171 "tracker-sparql-scanner.c"
	}
#line 623 "tracker-sparql-scanner.vala"
	result = _tmp0_;
#line 623 "tracker-sparql-scanner.vala"
	return result;
#line 3177 "tracker-sparql-scanner.c"
}


static gboolean
tracker_sparql_scanner_is_varname_char (TrackerSparqlScanner* self,
                                        gchar c)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 626 "tracker-sparql-scanner.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 627 "tracker-sparql-scanner.vala"
	if (g_ascii_isalnum (c)) {
#line 627 "tracker-sparql-scanner.vala"
		_tmp0_ = TRUE;
#line 3193 "tracker-sparql-scanner.c"
	} else {
#line 627 "tracker-sparql-scanner.vala"
		_tmp0_ = c == '_';
#line 3197 "tracker-sparql-scanner.c"
	}
#line 627 "tracker-sparql-scanner.vala"
	result = _tmp0_;
#line 627 "tracker-sparql-scanner.vala"
	return result;
#line 3203 "tracker-sparql-scanner.c"
}


TrackerSparqlTokenType
tracker_sparql_scanner_read_token (TrackerSparqlScanner* self,
                                   TrackerSourceLocation* token_begin,
                                   TrackerSourceLocation* token_end,
                                   GError** error)
{
	TrackerSourceLocation _vala_token_begin = {0};
	TrackerSourceLocation _vala_token_end = {0};
	TrackerSparqlTokenType result = 0;
	TrackerSparqlTokenType type = 0;
	gchar* begin = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint token_length_in_chars = 0;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gint _tmp284_;
	gchar* _tmp290_;
	gint _tmp291_;
	gint _tmp292_;
	GError * _inner_error_ = NULL;
#line 630 "tracker-sparql-scanner.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 631 "tracker-sparql-scanner.vala"
	tracker_sparql_scanner_space (self);
#line 634 "tracker-sparql-scanner.vala"
	_tmp0_ = self->priv->current;
#line 634 "tracker-sparql-scanner.vala"
	begin = _tmp0_;
#line 635 "tracker-sparql-scanner.vala"
	_tmp1_ = begin;
#line 635 "tracker-sparql-scanner.vala"
	_tmp2_ = self->priv->line;
#line 635 "tracker-sparql-scanner.vala"
	_tmp3_ = self->priv->column;
#line 635 "tracker-sparql-scanner.vala"
	tracker_source_location_init (&_vala_token_begin, _tmp1_, _tmp2_, _tmp3_);
#line 637 "tracker-sparql-scanner.vala"
	token_length_in_chars = -1;
#line 639 "tracker-sparql-scanner.vala"
	_tmp4_ = self->priv->current;
#line 639 "tracker-sparql-scanner.vala"
	_tmp5_ = self->priv->end;
#line 639 "tracker-sparql-scanner.vala"
	if (_tmp4_ >= _tmp5_) {
#line 640 "tracker-sparql-scanner.vala"
		type = TRACKER_SPARQL_TOKEN_TYPE_EOF;
#line 3256 "tracker-sparql-scanner.c"
	} else {
		gchar* _tmp6_;
		gchar _tmp7_;
#line 641 "tracker-sparql-scanner.vala"
		_tmp6_ = self->priv->current;
#line 641 "tracker-sparql-scanner.vala"
		_tmp7_ = _tmp6_[0];
#line 641 "tracker-sparql-scanner.vala"
		if (g_ascii_isalpha (_tmp7_)) {
#line 3266 "tracker-sparql-scanner.c"
			gint len = 0;
			gchar* _tmp15_;
			gint _tmp16_;
#line 643 "tracker-sparql-scanner.vala"
			len = 0;
#line 644 "tracker-sparql-scanner.vala"
			while (TRUE) {
#line 3274 "tracker-sparql-scanner.c"
				gboolean _tmp8_ = FALSE;
				gchar* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp13_;
				gint _tmp14_;
#line 644 "tracker-sparql-scanner.vala"
				_tmp9_ = self->priv->current;
#line 644 "tracker-sparql-scanner.vala"
				_tmp10_ = self->priv->end;
#line 644 "tracker-sparql-scanner.vala"
				if (_tmp9_ < _tmp10_) {
#line 3286 "tracker-sparql-scanner.c"
					gchar* _tmp11_;
					gchar _tmp12_;
#line 644 "tracker-sparql-scanner.vala"
					_tmp11_ = self->priv->current;
#line 644 "tracker-sparql-scanner.vala"
					_tmp12_ = _tmp11_[0];
#line 644 "tracker-sparql-scanner.vala"
					_tmp8_ = tracker_sparql_scanner_is_pn_char (self, _tmp12_);
#line 3295 "tracker-sparql-scanner.c"
				} else {
#line 644 "tracker-sparql-scanner.vala"
					_tmp8_ = FALSE;
#line 3299 "tracker-sparql-scanner.c"
				}
#line 644 "tracker-sparql-scanner.vala"
				if (!_tmp8_) {
#line 644 "tracker-sparql-scanner.vala"
					break;
#line 3305 "tracker-sparql-scanner.c"
				}
#line 645 "tracker-sparql-scanner.vala"
				_tmp13_ = self->priv->current;
#line 645 "tracker-sparql-scanner.vala"
				self->priv->current = _tmp13_ + 1;
#line 646 "tracker-sparql-scanner.vala"
				_tmp14_ = len;
#line 646 "tracker-sparql-scanner.vala"
				len = _tmp14_ + 1;
#line 3315 "tracker-sparql-scanner.c"
			}
#line 648 "tracker-sparql-scanner.vala"
			_tmp15_ = begin;
#line 648 "tracker-sparql-scanner.vala"
			_tmp16_ = len;
#line 648 "tracker-sparql-scanner.vala"
			type = tracker_sparql_scanner_get_identifier_or_keyword (self, _tmp15_, _tmp16_);
#line 3323 "tracker-sparql-scanner.c"
		} else {
			gchar* _tmp17_;
			gchar _tmp18_;
#line 649 "tracker-sparql-scanner.vala"
			_tmp17_ = self->priv->current;
#line 649 "tracker-sparql-scanner.vala"
			_tmp18_ = _tmp17_[0];
#line 649 "tracker-sparql-scanner.vala"
			if (g_ascii_isdigit (_tmp18_)) {
#line 650 "tracker-sparql-scanner.vala"
				type = tracker_sparql_scanner_read_number (self);
#line 3335 "tracker-sparql-scanner.c"
			} else {
				gchar* _tmp19_;
				gchar _tmp20_;
#line 652 "tracker-sparql-scanner.vala"
				_tmp19_ = self->priv->current;
#line 652 "tracker-sparql-scanner.vala"
				_tmp20_ = _tmp19_[0];
#line 652 "tracker-sparql-scanner.vala"
				switch (_tmp20_) {
#line 652 "tracker-sparql-scanner.vala"
					case '{':
#line 3347 "tracker-sparql-scanner.c"
					{
						gchar* _tmp21_;
#line 654 "tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE;
#line 655 "tracker-sparql-scanner.vala"
						_tmp21_ = self->priv->current;
#line 655 "tracker-sparql-scanner.vala"
						self->priv->current = _tmp21_ + 1;
#line 656 "tracker-sparql-scanner.vala"
						break;
#line 3358 "tracker-sparql-scanner.c"
					}
#line 652 "tracker-sparql-scanner.vala"
					case '}':
#line 3362 "tracker-sparql-scanner.c"
					{
						gchar* _tmp22_;
#line 658 "tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE;
#line 659 "tracker-sparql-scanner.vala"
						_tmp22_ = self->priv->current;
#line 659 "tracker-sparql-scanner.vala"
						self->priv->current = _tmp22_ + 1;
#line 660 "tracker-sparql-scanner.vala"
						break;
#line 3373 "tracker-sparql-scanner.c"
					}
#line 652 "tracker-sparql-scanner.vala"
					case '(':
#line 3377 "tracker-sparql-scanner.c"
					{
						gchar* _tmp23_;
#line 662 "tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS;
#line 663 "tracker-sparql-scanner.vala"
						_tmp23_ = self->priv->current;
#line 663 "tracker-sparql-scanner.vala"
						self->priv->current = _tmp23_ + 1;
#line 664 "tracker-sparql-scanner.vala"
						break;
#line 3388 "tracker-sparql-scanner.c"
					}
#line 652 "tracker-sparql-scanner.vala"
					case ')':
#line 3392 "tracker-sparql-scanner.c"
					{
						gchar* _tmp24_;
#line 666 "tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS;
#line 667 "tracker-sparql-scanner.vala"
						_tmp24_ = self->priv->current;
#line 667 "tracker-sparql-scanner.vala"
						self->priv->current = _tmp24_ + 1;
#line 668 "tracker-sparql-scanner.vala"
						break;
#line 3403 "tracker-sparql-scanner.c"
					}
#line 652 "tracker-sparql-scanner.vala"
					case '[':
#line 3407 "tracker-sparql-scanner.c"
					{
						gchar* _tmp25_;
#line 670 "tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET;
#line 671 "tracker-sparql-scanner.vala"
						_tmp25_ = self->priv->current;
#line 671 "tracker-sparql-scanner.vala"
						self->priv->current = _tmp25_ + 1;
#line 672 "tracker-sparql-scanner.vala"
						break;
#line 3418 "tracker-sparql-scanner.c"
					}
#line 652 "tracker-sparql-scanner.vala"
					case ']':
#line 3422 "tracker-sparql-scanner.c"
					{
						gchar* _tmp26_;
#line 674 "tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACKET;
#line 675 "tracker-sparql-scanner.vala"
						_tmp26_ = self->priv->current;
#line 675 "tracker-sparql-scanner.vala"
						self->priv->current = _tmp26_ + 1;
#line 676 "tracker-sparql-scanner.vala"
						break;
#line 3433 "tracker-sparql-scanner.c"
					}
#line 652 "tracker-sparql-scanner.vala"
					case '.':
#line 3437 "tracker-sparql-scanner.c"
					{
						gchar* _tmp27_;
#line 678 "tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_DOT;
#line 679 "tracker-sparql-scanner.vala"
						_tmp27_ = self->priv->current;
#line 679 "tracker-sparql-scanner.vala"
						self->priv->current = _tmp27_ + 1;
#line 680 "tracker-sparql-scanner.vala"
						break;
#line 3448 "tracker-sparql-scanner.c"
					}
#line 652 "tracker-sparql-scanner.vala"
					case ':':
#line 3452 "tracker-sparql-scanner.c"
					{
						gchar* _tmp28_;
						gchar* _tmp35_;
						gchar _tmp36_;
#line 682 "tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_COLON;
#line 683 "tracker-sparql-scanner.vala"
						_tmp28_ = self->priv->current;
#line 683 "tracker-sparql-scanner.vala"
						self->priv->current = _tmp28_ + 1;
#line 684 "tracker-sparql-scanner.vala"
						while (TRUE) {
#line 3465 "tracker-sparql-scanner.c"
							gboolean _tmp29_ = FALSE;
							gchar* _tmp30_;
							gchar* _tmp31_;
							gchar* _tmp34_;
#line 684 "tracker-sparql-scanner.vala"
							_tmp30_ = self->priv->current;
#line 684 "tracker-sparql-scanner.vala"
							_tmp31_ = self->priv->end;
#line 684 "tracker-sparql-scanner.vala"
							if (_tmp30_ < _tmp31_) {
#line 3476 "tracker-sparql-scanner.c"
								gchar* _tmp32_;
								gchar _tmp33_;
#line 684 "tracker-sparql-scanner.vala"
								_tmp32_ = self->priv->current;
#line 684 "tracker-sparql-scanner.vala"
								_tmp33_ = _tmp32_[0];
#line 684 "tracker-sparql-scanner.vala"
								_tmp29_ = tracker_sparql_scanner_is_pn_local_char (self, _tmp33_);
#line 3485 "tracker-sparql-scanner.c"
							} else {
#line 684 "tracker-sparql-scanner.vala"
								_tmp29_ = FALSE;
#line 3489 "tracker-sparql-scanner.c"
							}
#line 684 "tracker-sparql-scanner.vala"
							if (!_tmp29_) {
#line 684 "tracker-sparql-scanner.vala"
								break;
#line 3495 "tracker-sparql-scanner.c"
							}
#line 685 "tracker-sparql-scanner.vala"
							_tmp34_ = self->priv->current;
#line 685 "tracker-sparql-scanner.vala"
							self->priv->current = _tmp34_ + 1;
#line 3501 "tracker-sparql-scanner.c"
						}
#line 687 "tracker-sparql-scanner.vala"
						_tmp35_ = self->priv->current;
#line 687 "tracker-sparql-scanner.vala"
						_tmp36_ = _tmp35_[-1];
#line 687 "tracker-sparql-scanner.vala"
						if (_tmp36_ == '.') {
#line 3509 "tracker-sparql-scanner.c"
							gchar* _tmp37_;
#line 689 "tracker-sparql-scanner.vala"
							_tmp37_ = self->priv->current;
#line 689 "tracker-sparql-scanner.vala"
							self->priv->current = _tmp37_ - 1;
#line 3515 "tracker-sparql-scanner.c"
						}
#line 691 "tracker-sparql-scanner.vala"
						break;
#line 3519 "tracker-sparql-scanner.c"
					}
#line 652 "tracker-sparql-scanner.vala"
					case ',':
#line 3523 "tracker-sparql-scanner.c"
					{
						gchar* _tmp38_;
#line 693 "tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_COMMA;
#line 694 "tracker-sparql-scanner.vala"
						_tmp38_ = self->priv->current;
#line 694 "tracker-sparql-scanner.vala"
						self->priv->current = _tmp38_ + 1;
#line 695 "tracker-sparql-scanner.vala"
						break;
#line 3534 "tracker-sparql-scanner.c"
					}
#line 652 "tracker-sparql-scanner.vala"
					case ';':
#line 3538 "tracker-sparql-scanner.c"
					{
						gchar* _tmp39_;
#line 697 "tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_SEMICOLON;
#line 698 "tracker-sparql-scanner.vala"
						_tmp39_ = self->priv->current;
#line 698 "tracker-sparql-scanner.vala"
						self->priv->current = _tmp39_ + 1;
#line 699 "tracker-sparql-scanner.vala"
						break;
#line 3549 "tracker-sparql-scanner.c"
					}
#line 652 "tracker-sparql-scanner.vala"
					case '?':
#line 652 "tracker-sparql-scanner.vala"
					case '$':
#line 3555 "tracker-sparql-scanner.c"
					{
						gchar* _tmp40_;
#line 702 "tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_NONE;
#line 703 "tracker-sparql-scanner.vala"
						_tmp40_ = self->priv->current;
#line 703 "tracker-sparql-scanner.vala"
						self->priv->current = _tmp40_ + 1;
#line 704 "tracker-sparql-scanner.vala"
						while (TRUE) {
#line 3566 "tracker-sparql-scanner.c"
							gboolean _tmp41_ = FALSE;
							gchar* _tmp42_;
							gchar* _tmp43_;
							gchar* _tmp46_;
#line 704 "tracker-sparql-scanner.vala"
							_tmp42_ = self->priv->current;
#line 704 "tracker-sparql-scanner.vala"
							_tmp43_ = self->priv->end;
#line 704 "tracker-sparql-scanner.vala"
							if (_tmp42_ < _tmp43_) {
#line 3577 "tracker-sparql-scanner.c"
								gchar* _tmp44_;
								gchar _tmp45_;
#line 704 "tracker-sparql-scanner.vala"
								_tmp44_ = self->priv->current;
#line 704 "tracker-sparql-scanner.vala"
								_tmp45_ = _tmp44_[0];
#line 704 "tracker-sparql-scanner.vala"
								_tmp41_ = tracker_sparql_scanner_is_varname_char (self, _tmp45_);
#line 3586 "tracker-sparql-scanner.c"
							} else {
#line 704 "tracker-sparql-scanner.vala"
								_tmp41_ = FALSE;
#line 3590 "tracker-sparql-scanner.c"
							}
#line 704 "tracker-sparql-scanner.vala"
							if (!_tmp41_) {
#line 704 "tracker-sparql-scanner.vala"
								break;
#line 3596 "tracker-sparql-scanner.c"
							}
#line 705 "tracker-sparql-scanner.vala"
							type = TRACKER_SPARQL_TOKEN_TYPE_VAR;
#line 706 "tracker-sparql-scanner.vala"
							_tmp46_ = self->priv->current;
#line 706 "tracker-sparql-scanner.vala"
							self->priv->current = _tmp46_ + 1;
#line 3604 "tracker-sparql-scanner.c"
						}
#line 708 "tracker-sparql-scanner.vala"
						break;
#line 3608 "tracker-sparql-scanner.c"
					}
#line 652 "tracker-sparql-scanner.vala"
					case '@':
#line 3612 "tracker-sparql-scanner.c"
					{
						gchar* _tmp47_;
						gboolean _tmp48_ = FALSE;
						gchar* _tmp49_;
						gchar* _tmp50_;
						gint _tmp51_;
						gint _tmp52_;
#line 710 "tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_NONE;
#line 711 "tracker-sparql-scanner.vala"
						_tmp47_ = self->priv->current;
#line 711 "tracker-sparql-scanner.vala"
						self->priv->current = _tmp47_ + 1;
#line 712 "tracker-sparql-scanner.vala"
						_tmp49_ = self->priv->current;
#line 712 "tracker-sparql-scanner.vala"
						_tmp50_ = self->priv->end;
#line 712 "tracker-sparql-scanner.vala"
						_tmp51_ = strlen ("prefix");
#line 712 "tracker-sparql-scanner.vala"
						_tmp52_ = _tmp51_;
#line 712 "tracker-sparql-scanner.vala"
						if (_tmp49_ < (_tmp50_ - _tmp52_)) {
#line 3636 "tracker-sparql-scanner.c"
							gchar* _tmp53_;
#line 712 "tracker-sparql-scanner.vala"
							_tmp53_ = self->priv->current;
#line 712 "tracker-sparql-scanner.vala"
							_tmp48_ = tracker_sparql_scanner_matches (self, _tmp53_, "PREFIX");
#line 3642 "tracker-sparql-scanner.c"
						} else {
#line 712 "tracker-sparql-scanner.vala"
							_tmp48_ = FALSE;
#line 3646 "tracker-sparql-scanner.c"
						}
#line 712 "tracker-sparql-scanner.vala"
						if (_tmp48_) {
#line 3650 "tracker-sparql-scanner.c"
							gchar* _tmp54_;
							gint _tmp55_;
							gint _tmp56_;
#line 713 "tracker-sparql-scanner.vala"
							type = TRACKER_SPARQL_TOKEN_TYPE_ATPREFIX;
#line 714 "tracker-sparql-scanner.vala"
							_tmp54_ = self->priv->current;
#line 714 "tracker-sparql-scanner.vala"
							_tmp55_ = strlen ("prefix");
#line 714 "tracker-sparql-scanner.vala"
							_tmp56_ = _tmp55_;
#line 714 "tracker-sparql-scanner.vala"
							self->priv->current = _tmp54_ + _tmp56_;
#line 3664 "tracker-sparql-scanner.c"
						} else {
							gboolean _tmp57_ = FALSE;
							gchar* _tmp58_;
							gchar* _tmp59_;
							gint _tmp60_;
							gint _tmp61_;
#line 715 "tracker-sparql-scanner.vala"
							_tmp58_ = self->priv->current;
#line 715 "tracker-sparql-scanner.vala"
							_tmp59_ = self->priv->end;
#line 715 "tracker-sparql-scanner.vala"
							_tmp60_ = strlen ("base");
#line 715 "tracker-sparql-scanner.vala"
							_tmp61_ = _tmp60_;
#line 715 "tracker-sparql-scanner.vala"
							if (_tmp58_ < (_tmp59_ - _tmp61_)) {
#line 3681 "tracker-sparql-scanner.c"
								gchar* _tmp62_;
#line 715 "tracker-sparql-scanner.vala"
								_tmp62_ = self->priv->current;
#line 715 "tracker-sparql-scanner.vala"
								_tmp57_ = tracker_sparql_scanner_matches (self, _tmp62_, "BASE");
#line 3687 "tracker-sparql-scanner.c"
							} else {
#line 715 "tracker-sparql-scanner.vala"
								_tmp57_ = FALSE;
#line 3691 "tracker-sparql-scanner.c"
							}
#line 715 "tracker-sparql-scanner.vala"
							if (_tmp57_) {
#line 3695 "tracker-sparql-scanner.c"
								gchar* _tmp63_;
								gint _tmp64_;
								gint _tmp65_;
#line 716 "tracker-sparql-scanner.vala"
								type = TRACKER_SPARQL_TOKEN_TYPE_ATBASE;
#line 717 "tracker-sparql-scanner.vala"
								_tmp63_ = self->priv->current;
#line 717 "tracker-sparql-scanner.vala"
								_tmp64_ = strlen ("base");
#line 717 "tracker-sparql-scanner.vala"
								_tmp65_ = _tmp64_;
#line 717 "tracker-sparql-scanner.vala"
								self->priv->current = _tmp63_ + _tmp65_;
#line 3709 "tracker-sparql-scanner.c"
							}
						}
#line 719 "tracker-sparql-scanner.vala"
						break;
#line 3714 "tracker-sparql-scanner.c"
					}
#line 652 "tracker-sparql-scanner.vala"
					case '|':
#line 3718 "tracker-sparql-scanner.c"
					{
						gchar* _tmp66_;
						gchar* _tmp67_;
						gchar* _tmp68_;
#line 721 "tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_NONE;
#line 722 "tracker-sparql-scanner.vala"
						_tmp66_ = self->priv->current;
#line 722 "tracker-sparql-scanner.vala"
						self->priv->current = _tmp66_ + 1;
#line 723 "tracker-sparql-scanner.vala"
						_tmp67_ = self->priv->current;
#line 723 "tracker-sparql-scanner.vala"
						_tmp68_ = self->priv->end;
#line 723 "tracker-sparql-scanner.vala"
						if (_tmp67_ < _tmp68_) {
#line 3735 "tracker-sparql-scanner.c"
							gchar* _tmp69_;
							gchar _tmp70_;
#line 724 "tracker-sparql-scanner.vala"
							_tmp69_ = self->priv->current;
#line 724 "tracker-sparql-scanner.vala"
							_tmp70_ = _tmp69_[0];
#line 724 "tracker-sparql-scanner.vala"
							switch (_tmp70_) {
#line 724 "tracker-sparql-scanner.vala"
								case '|':
#line 3746 "tracker-sparql-scanner.c"
								{
									gchar* _tmp71_;
#line 726 "tracker-sparql-scanner.vala"
									type = TRACKER_SPARQL_TOKEN_TYPE_OP_OR;
#line 727 "tracker-sparql-scanner.vala"
									_tmp71_ = self->priv->current;
#line 727 "tracker-sparql-scanner.vala"
									self->priv->current = _tmp71_ + 1;
#line 728 "tracker-sparql-scanner.vala"
									break;
#line 3757 "tracker-sparql-scanner.c"
								}
								default:
#line 724 "tracker-sparql-scanner.vala"
								break;
#line 3762 "tracker-sparql-scanner.c"
							}
						}
#line 731 "tracker-sparql-scanner.vala"
						break;
#line 3767 "tracker-sparql-scanner.c"
					}
#line 652 "tracker-sparql-scanner.vala"
					case '&':
#line 3771 "tracker-sparql-scanner.c"
					{
						gchar* _tmp72_;
						gchar* _tmp73_;
						gchar* _tmp74_;
#line 733 "tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_NONE;
#line 734 "tracker-sparql-scanner.vala"
						_tmp72_ = self->priv->current;
#line 734 "tracker-sparql-scanner.vala"
						self->priv->current = _tmp72_ + 1;
#line 735 "tracker-sparql-scanner.vala"
						_tmp73_ = self->priv->current;
#line 735 "tracker-sparql-scanner.vala"
						_tmp74_ = self->priv->end;
#line 735 "tracker-sparql-scanner.vala"
						if (_tmp73_ < _tmp74_) {
#line 3788 "tracker-sparql-scanner.c"
							gchar* _tmp75_;
							gchar _tmp76_;
#line 736 "tracker-sparql-scanner.vala"
							_tmp75_ = self->priv->current;
#line 736 "tracker-sparql-scanner.vala"
							_tmp76_ = _tmp75_[0];
#line 736 "tracker-sparql-scanner.vala"
							switch (_tmp76_) {
#line 736 "tracker-sparql-scanner.vala"
								case '&':
#line 3799 "tracker-sparql-scanner.c"
								{
									gchar* _tmp77_;
#line 738 "tracker-sparql-scanner.vala"
									type = TRACKER_SPARQL_TOKEN_TYPE_OP_AND;
#line 739 "tracker-sparql-scanner.vala"
									_tmp77_ = self->priv->current;
#line 739 "tracker-sparql-scanner.vala"
									self->priv->current = _tmp77_ + 1;
#line 740 "tracker-sparql-scanner.vala"
									break;
#line 3810 "tracker-sparql-scanner.c"
								}
								default:
#line 736 "tracker-sparql-scanner.vala"
								break;
#line 3815 "tracker-sparql-scanner.c"
							}
						}
#line 743 "tracker-sparql-scanner.vala"
						break;
#line 3820 "tracker-sparql-scanner.c"
					}
#line 652 "tracker-sparql-scanner.vala"
					case '=':
#line 3824 "tracker-sparql-scanner.c"
					{
						gchar* _tmp78_;
#line 745 "tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_OP_EQ;
#line 746 "tracker-sparql-scanner.vala"
						_tmp78_ = self->priv->current;
#line 746 "tracker-sparql-scanner.vala"
						self->priv->current = _tmp78_ + 1;
#line 747 "tracker-sparql-scanner.vala"
						break;
#line 3835 "tracker-sparql-scanner.c"
					}
#line 652 "tracker-sparql-scanner.vala"
					case '<':
#line 3839 "tracker-sparql-scanner.c"
					{
						gchar* _tmp79_;
						gchar* _tmp80_;
						gchar* _tmp81_;
#line 749 "tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_OP_LT;
#line 750 "tracker-sparql-scanner.vala"
						_tmp79_ = self->priv->current;
#line 750 "tracker-sparql-scanner.vala"
						self->priv->current = _tmp79_ + 1;
#line 751 "tracker-sparql-scanner.vala"
						_tmp80_ = self->priv->current;
#line 751 "tracker-sparql-scanner.vala"
						_tmp81_ = self->priv->end;
#line 751 "tracker-sparql-scanner.vala"
						if (_tmp80_ < _tmp81_) {
#line 3856 "tracker-sparql-scanner.c"
							gboolean _tmp95_ = FALSE;
							gchar* _tmp96_;
							gchar* _tmp97_;
							gchar* _tmp102_;
							gchar _tmp103_;
#line 753 "tracker-sparql-scanner.vala"
							while (TRUE) {
#line 3864 "tracker-sparql-scanner.c"
								gboolean _tmp82_ = FALSE;
								gchar* _tmp83_;
								gchar* _tmp84_;
								gboolean _tmp87_ = FALSE;
								gchar* _tmp88_;
								gchar _tmp89_;
								gchar* _tmp92_;
								gchar _tmp93_;
#line 753 "tracker-sparql-scanner.vala"
								_tmp83_ = self->priv->current;
#line 753 "tracker-sparql-scanner.vala"
								_tmp84_ = self->priv->end;
#line 753 "tracker-sparql-scanner.vala"
								if (_tmp83_ < _tmp84_) {
#line 3879 "tracker-sparql-scanner.c"
									gchar* _tmp85_;
									gchar _tmp86_;
#line 753 "tracker-sparql-scanner.vala"
									_tmp85_ = self->priv->current;
#line 753 "tracker-sparql-scanner.vala"
									_tmp86_ = _tmp85_[0];
#line 753 "tracker-sparql-scanner.vala"
									_tmp82_ = _tmp86_ != '>';
#line 3888 "tracker-sparql-scanner.c"
								} else {
#line 753 "tracker-sparql-scanner.vala"
									_tmp82_ = FALSE;
#line 3892 "tracker-sparql-scanner.c"
								}
#line 753 "tracker-sparql-scanner.vala"
								if (!_tmp82_) {
#line 753 "tracker-sparql-scanner.vala"
									break;
#line 3898 "tracker-sparql-scanner.c"
								}
#line 754 "tracker-sparql-scanner.vala"
								_tmp88_ = self->priv->current;
#line 754 "tracker-sparql-scanner.vala"
								_tmp89_ = _tmp88_[0];
#line 754 "tracker-sparql-scanner.vala"
								if (((gint) _tmp89_) >= 0x00) {
#line 3906 "tracker-sparql-scanner.c"
									gchar* _tmp90_;
									gchar _tmp91_;
#line 754 "tracker-sparql-scanner.vala"
									_tmp90_ = self->priv->current;
#line 754 "tracker-sparql-scanner.vala"
									_tmp91_ = _tmp90_[0];
#line 754 "tracker-sparql-scanner.vala"
									_tmp87_ = ((gint) _tmp91_) < 0x20;
#line 3915 "tracker-sparql-scanner.c"
								} else {
#line 754 "tracker-sparql-scanner.vala"
									_tmp87_ = FALSE;
#line 3919 "tracker-sparql-scanner.c"
								}
#line 754 "tracker-sparql-scanner.vala"
								if (_tmp87_) {
#line 756 "tracker-sparql-scanner.vala"
									break;
#line 3925 "tracker-sparql-scanner.c"
								}
#line 758 "tracker-sparql-scanner.vala"
								_tmp92_ = self->priv->current;
#line 758 "tracker-sparql-scanner.vala"
								_tmp93_ = _tmp92_[0];
#line 758 "tracker-sparql-scanner.vala"
								switch (_tmp93_) {
#line 758 "tracker-sparql-scanner.vala"
									case '<':
#line 758 "tracker-sparql-scanner.vala"
									case '>':
#line 758 "tracker-sparql-scanner.vala"
									case '"':
#line 758 "tracker-sparql-scanner.vala"
									case ' ':
#line 758 "tracker-sparql-scanner.vala"
									case '{':
#line 758 "tracker-sparql-scanner.vala"
									case '}':
#line 758 "tracker-sparql-scanner.vala"
									case '|':
#line 758 "tracker-sparql-scanner.vala"
									case '^':
#line 758 "tracker-sparql-scanner.vala"
									case '`':
#line 758 "tracker-sparql-scanner.vala"
									case '\\':
#line 3953 "tracker-sparql-scanner.c"
									{
#line 770 "tracker-sparql-scanner.vala"
										break;
#line 3957 "tracker-sparql-scanner.c"
									}
									default:
									{
										gchar* _tmp94_;
#line 772 "tracker-sparql-scanner.vala"
										_tmp94_ = self->priv->current;
#line 772 "tracker-sparql-scanner.vala"
										self->priv->current = _tmp94_ + 1;
#line 773 "tracker-sparql-scanner.vala"
										continue;
#line 3968 "tracker-sparql-scanner.c"
									}
								}
#line 775 "tracker-sparql-scanner.vala"
								break;
#line 3973 "tracker-sparql-scanner.c"
							}
#line 777 "tracker-sparql-scanner.vala"
							_tmp96_ = self->priv->current;
#line 777 "tracker-sparql-scanner.vala"
							_tmp97_ = self->priv->end;
#line 777 "tracker-sparql-scanner.vala"
							if (_tmp96_ < _tmp97_) {
#line 3981 "tracker-sparql-scanner.c"
								gchar* _tmp98_;
								gchar _tmp99_;
#line 777 "tracker-sparql-scanner.vala"
								_tmp98_ = self->priv->current;
#line 777 "tracker-sparql-scanner.vala"
								_tmp99_ = _tmp98_[0];
#line 777 "tracker-sparql-scanner.vala"
								_tmp95_ = _tmp99_ == '>';
#line 3990 "tracker-sparql-scanner.c"
							} else {
#line 777 "tracker-sparql-scanner.vala"
								_tmp95_ = FALSE;
#line 3994 "tracker-sparql-scanner.c"
							}
#line 777 "tracker-sparql-scanner.vala"
							if (_tmp95_) {
#line 3998 "tracker-sparql-scanner.c"
								gchar* _tmp100_;
#line 778 "tracker-sparql-scanner.vala"
								type = TRACKER_SPARQL_TOKEN_TYPE_IRI_REF;
#line 779 "tracker-sparql-scanner.vala"
								_tmp100_ = self->priv->current;
#line 779 "tracker-sparql-scanner.vala"
								self->priv->current = _tmp100_ + 1;
#line 780 "tracker-sparql-scanner.vala"
								break;
#line 4008 "tracker-sparql-scanner.c"
							} else {
								gchar* _tmp101_;
#line 782 "tracker-sparql-scanner.vala"
								_tmp101_ = begin;
#line 782 "tracker-sparql-scanner.vala"
								self->priv->current = _tmp101_ + 1;
#line 4015 "tracker-sparql-scanner.c"
							}
#line 784 "tracker-sparql-scanner.vala"
							_tmp102_ = self->priv->current;
#line 784 "tracker-sparql-scanner.vala"
							_tmp103_ = _tmp102_[0];
#line 784 "tracker-sparql-scanner.vala"
							switch (_tmp103_) {
#line 784 "tracker-sparql-scanner.vala"
								case '=':
#line 4025 "tracker-sparql-scanner.c"
								{
									gchar* _tmp104_;
#line 786 "tracker-sparql-scanner.vala"
									type = TRACKER_SPARQL_TOKEN_TYPE_OP_LE;
#line 787 "tracker-sparql-scanner.vala"
									_tmp104_ = self->priv->current;
#line 787 "tracker-sparql-scanner.vala"
									self->priv->current = _tmp104_ + 1;
#line 788 "tracker-sparql-scanner.vala"
									break;
#line 4036 "tracker-sparql-scanner.c"
								}
								default:
#line 784 "tracker-sparql-scanner.vala"
								break;
#line 4041 "tracker-sparql-scanner.c"
							}
						}
#line 791 "tracker-sparql-scanner.vala"
						break;
#line 4046 "tracker-sparql-scanner.c"
					}
#line 652 "tracker-sparql-scanner.vala"
					case '>':
#line 4050 "tracker-sparql-scanner.c"
					{
						gchar* _tmp105_;
						gboolean _tmp106_ = FALSE;
						gchar* _tmp107_;
						gchar* _tmp108_;
#line 793 "tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_OP_GT;
#line 794 "tracker-sparql-scanner.vala"
						_tmp105_ = self->priv->current;
#line 794 "tracker-sparql-scanner.vala"
						self->priv->current = _tmp105_ + 1;
#line 795 "tracker-sparql-scanner.vala"
						_tmp107_ = self->priv->current;
#line 795 "tracker-sparql-scanner.vala"
						_tmp108_ = self->priv->end;
#line 795 "tracker-sparql-scanner.vala"
						if (_tmp107_ < _tmp108_) {
#line 4068 "tracker-sparql-scanner.c"
							gchar* _tmp109_;
							gchar _tmp110_;
#line 795 "tracker-sparql-scanner.vala"
							_tmp109_ = self->priv->current;
#line 795 "tracker-sparql-scanner.vala"
							_tmp110_ = _tmp109_[0];
#line 795 "tracker-sparql-scanner.vala"
							_tmp106_ = _tmp110_ == '=';
#line 4077 "tracker-sparql-scanner.c"
						} else {
#line 795 "tracker-sparql-scanner.vala"
							_tmp106_ = FALSE;
#line 4081 "tracker-sparql-scanner.c"
						}
#line 795 "tracker-sparql-scanner.vala"
						if (_tmp106_) {
#line 4085 "tracker-sparql-scanner.c"
							gchar* _tmp111_;
#line 796 "tracker-sparql-scanner.vala"
							type = TRACKER_SPARQL_TOKEN_TYPE_OP_GE;
#line 797 "tracker-sparql-scanner.vala"
							_tmp111_ = self->priv->current;
#line 797 "tracker-sparql-scanner.vala"
							self->priv->current = _tmp111_ + 1;
#line 4093 "tracker-sparql-scanner.c"
						}
#line 799 "tracker-sparql-scanner.vala"
						break;
#line 4097 "tracker-sparql-scanner.c"
					}
#line 652 "tracker-sparql-scanner.vala"
					case '!':
#line 4101 "tracker-sparql-scanner.c"
					{
						gchar* _tmp112_;
						gboolean _tmp113_ = FALSE;
						gchar* _tmp114_;
						gchar* _tmp115_;
#line 801 "tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_OP_NEG;
#line 802 "tracker-sparql-scanner.vala"
						_tmp112_ = self->priv->current;
#line 802 "tracker-sparql-scanner.vala"
						self->priv->current = _tmp112_ + 1;
#line 803 "tracker-sparql-scanner.vala"
						_tmp114_ = self->priv->current;
#line 803 "tracker-sparql-scanner.vala"
						_tmp115_ = self->priv->end;
#line 803 "tracker-sparql-scanner.vala"
						if (_tmp114_ < _tmp115_) {
#line 4119 "tracker-sparql-scanner.c"
							gchar* _tmp116_;
							gchar _tmp117_;
#line 803 "tracker-sparql-scanner.vala"
							_tmp116_ = self->priv->current;
#line 803 "tracker-sparql-scanner.vala"
							_tmp117_ = _tmp116_[0];
#line 803 "tracker-sparql-scanner.vala"
							_tmp113_ = _tmp117_ == '=';
#line 4128 "tracker-sparql-scanner.c"
						} else {
#line 803 "tracker-sparql-scanner.vala"
							_tmp113_ = FALSE;
#line 4132 "tracker-sparql-scanner.c"
						}
#line 803 "tracker-sparql-scanner.vala"
						if (_tmp113_) {
#line 4136 "tracker-sparql-scanner.c"
							gchar* _tmp118_;
#line 804 "tracker-sparql-scanner.vala"
							type = TRACKER_SPARQL_TOKEN_TYPE_OP_NE;
#line 805 "tracker-sparql-scanner.vala"
							_tmp118_ = self->priv->current;
#line 805 "tracker-sparql-scanner.vala"
							self->priv->current = _tmp118_ + 1;
#line 4144 "tracker-sparql-scanner.c"
						}
#line 807 "tracker-sparql-scanner.vala"
						break;
#line 4148 "tracker-sparql-scanner.c"
					}
#line 652 "tracker-sparql-scanner.vala"
					case '+':
#line 4152 "tracker-sparql-scanner.c"
					{
						gchar* _tmp119_;
#line 809 "tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_PLUS;
#line 810 "tracker-sparql-scanner.vala"
						_tmp119_ = self->priv->current;
#line 810 "tracker-sparql-scanner.vala"
						self->priv->current = _tmp119_ + 1;
#line 811 "tracker-sparql-scanner.vala"
						break;
#line 4163 "tracker-sparql-scanner.c"
					}
#line 652 "tracker-sparql-scanner.vala"
					case '-':
#line 4167 "tracker-sparql-scanner.c"
					{
						gchar* _tmp120_;
#line 813 "tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_MINUS;
#line 814 "tracker-sparql-scanner.vala"
						_tmp120_ = self->priv->current;
#line 814 "tracker-sparql-scanner.vala"
						self->priv->current = _tmp120_ + 1;
#line 815 "tracker-sparql-scanner.vala"
						break;
#line 4178 "tracker-sparql-scanner.c"
					}
#line 652 "tracker-sparql-scanner.vala"
					case '*':
#line 4182 "tracker-sparql-scanner.c"
					{
						gchar* _tmp121_;
#line 817 "tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_STAR;
#line 818 "tracker-sparql-scanner.vala"
						_tmp121_ = self->priv->current;
#line 818 "tracker-sparql-scanner.vala"
						self->priv->current = _tmp121_ + 1;
#line 819 "tracker-sparql-scanner.vala"
						break;
#line 4193 "tracker-sparql-scanner.c"
					}
#line 652 "tracker-sparql-scanner.vala"
					case '/':
#line 4197 "tracker-sparql-scanner.c"
					{
						gchar* _tmp122_;
#line 821 "tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_DIV;
#line 822 "tracker-sparql-scanner.vala"
						_tmp122_ = self->priv->current;
#line 822 "tracker-sparql-scanner.vala"
						self->priv->current = _tmp122_ + 1;
#line 823 "tracker-sparql-scanner.vala"
						break;
#line 4208 "tracker-sparql-scanner.c"
					}
#line 652 "tracker-sparql-scanner.vala"
					case '\'':
#line 652 "tracker-sparql-scanner.vala"
					case '"':
#line 4214 "tracker-sparql-scanner.c"
					{
						gboolean _tmp123_ = FALSE;
						gboolean _tmp124_ = FALSE;
						gchar* _tmp125_;
						gchar* _tmp126_;
						gchar* _tmp192_;
						gchar _tmp193_;
						gchar* _tmp194_;
						gboolean _tmp250_ = FALSE;
						gchar* _tmp251_;
						gchar* _tmp252_;
#line 826 "tracker-sparql-scanner.vala"
						_tmp125_ = self->priv->current;
#line 826 "tracker-sparql-scanner.vala"
						_tmp126_ = self->priv->end;
#line 826 "tracker-sparql-scanner.vala"
						if (_tmp125_ < (_tmp126_ - 6)) {
#line 4232 "tracker-sparql-scanner.c"
							gchar* _tmp127_;
							gchar _tmp128_;
							gchar* _tmp129_;
							gchar _tmp130_;
#line 826 "tracker-sparql-scanner.vala"
							_tmp127_ = begin;
#line 826 "tracker-sparql-scanner.vala"
							_tmp128_ = _tmp127_[1];
#line 826 "tracker-sparql-scanner.vala"
							_tmp129_ = begin;
#line 826 "tracker-sparql-scanner.vala"
							_tmp130_ = _tmp129_[0];
#line 826 "tracker-sparql-scanner.vala"
							_tmp124_ = _tmp128_ == _tmp130_;
#line 4247 "tracker-sparql-scanner.c"
						} else {
#line 826 "tracker-sparql-scanner.vala"
							_tmp124_ = FALSE;
#line 4251 "tracker-sparql-scanner.c"
						}
#line 826 "tracker-sparql-scanner.vala"
						if (_tmp124_) {
#line 4255 "tracker-sparql-scanner.c"
							gchar* _tmp131_;
							gchar _tmp132_;
							gchar* _tmp133_;
							gchar _tmp134_;
#line 826 "tracker-sparql-scanner.vala"
							_tmp131_ = begin;
#line 826 "tracker-sparql-scanner.vala"
							_tmp132_ = _tmp131_[2];
#line 826 "tracker-sparql-scanner.vala"
							_tmp133_ = begin;
#line 826 "tracker-sparql-scanner.vala"
							_tmp134_ = _tmp133_[0];
#line 826 "tracker-sparql-scanner.vala"
							_tmp123_ = _tmp132_ == _tmp134_;
#line 4270 "tracker-sparql-scanner.c"
						} else {
#line 826 "tracker-sparql-scanner.vala"
							_tmp123_ = FALSE;
#line 4274 "tracker-sparql-scanner.c"
						}
#line 826 "tracker-sparql-scanner.vala"
						if (_tmp123_) {
#line 4278 "tracker-sparql-scanner.c"
							gchar* _tmp135_;
							gchar _tmp136_;
							gchar* _tmp137_;
							gboolean _tmp173_ = FALSE;
							gboolean _tmp174_ = FALSE;
							gchar* _tmp175_;
							gchar _tmp176_;
							gchar* _tmp177_;
							gchar _tmp178_;
#line 827 "tracker-sparql-scanner.vala"
							_tmp135_ = begin;
#line 827 "tracker-sparql-scanner.vala"
							_tmp136_ = _tmp135_[0];
#line 827 "tracker-sparql-scanner.vala"
							if (_tmp136_ == '\'') {
#line 828 "tracker-sparql-scanner.vala"
								type = TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1;
#line 4296 "tracker-sparql-scanner.c"
							} else {
#line 830 "tracker-sparql-scanner.vala"
								type = TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2;
#line 4300 "tracker-sparql-scanner.c"
							}
#line 833 "tracker-sparql-scanner.vala"
							token_length_in_chars = 6;
#line 834 "tracker-sparql-scanner.vala"
							_tmp137_ = self->priv->current;
#line 834 "tracker-sparql-scanner.vala"
							self->priv->current = _tmp137_ + 3;
#line 835 "tracker-sparql-scanner.vala"
							while (TRUE) {
#line 4310 "tracker-sparql-scanner.c"
								gchar* _tmp138_;
								gchar* _tmp139_;
								gboolean _tmp140_ = FALSE;
								gboolean _tmp141_ = FALSE;
								gchar* _tmp142_;
								gchar _tmp143_;
								gchar* _tmp144_;
								gchar _tmp145_;
#line 835 "tracker-sparql-scanner.vala"
								_tmp138_ = self->priv->current;
#line 835 "tracker-sparql-scanner.vala"
								_tmp139_ = self->priv->end;
#line 835 "tracker-sparql-scanner.vala"
								if (!(_tmp138_ < (_tmp139_ - 4))) {
#line 835 "tracker-sparql-scanner.vala"
									break;
#line 4327 "tracker-sparql-scanner.c"
								}
#line 836 "tracker-sparql-scanner.vala"
								_tmp142_ = self->priv->current;
#line 836 "tracker-sparql-scanner.vala"
								_tmp143_ = _tmp142_[0];
#line 836 "tracker-sparql-scanner.vala"
								_tmp144_ = begin;
#line 836 "tracker-sparql-scanner.vala"
								_tmp145_ = _tmp144_[0];
#line 836 "tracker-sparql-scanner.vala"
								if (_tmp143_ == _tmp145_) {
#line 4339 "tracker-sparql-scanner.c"
									gchar* _tmp146_;
									gchar _tmp147_;
									gchar* _tmp148_;
									gchar _tmp149_;
#line 836 "tracker-sparql-scanner.vala"
									_tmp146_ = self->priv->current;
#line 836 "tracker-sparql-scanner.vala"
									_tmp147_ = _tmp146_[1];
#line 836 "tracker-sparql-scanner.vala"
									_tmp148_ = begin;
#line 836 "tracker-sparql-scanner.vala"
									_tmp149_ = _tmp148_[0];
#line 836 "tracker-sparql-scanner.vala"
									_tmp141_ = _tmp147_ == _tmp149_;
#line 4354 "tracker-sparql-scanner.c"
								} else {
#line 836 "tracker-sparql-scanner.vala"
									_tmp141_ = FALSE;
#line 4358 "tracker-sparql-scanner.c"
								}
#line 836 "tracker-sparql-scanner.vala"
								if (_tmp141_) {
#line 4362 "tracker-sparql-scanner.c"
									gchar* _tmp150_;
									gchar _tmp151_;
									gchar* _tmp152_;
									gchar _tmp153_;
#line 836 "tracker-sparql-scanner.vala"
									_tmp150_ = self->priv->current;
#line 836 "tracker-sparql-scanner.vala"
									_tmp151_ = _tmp150_[2];
#line 836 "tracker-sparql-scanner.vala"
									_tmp152_ = begin;
#line 836 "tracker-sparql-scanner.vala"
									_tmp153_ = _tmp152_[0];
#line 836 "tracker-sparql-scanner.vala"
									_tmp140_ = _tmp151_ == _tmp153_;
#line 4377 "tracker-sparql-scanner.c"
								} else {
#line 836 "tracker-sparql-scanner.vala"
									_tmp140_ = FALSE;
#line 4381 "tracker-sparql-scanner.c"
								}
#line 836 "tracker-sparql-scanner.vala"
								if (_tmp140_) {
#line 837 "tracker-sparql-scanner.vala"
									break;
#line 4387 "tracker-sparql-scanner.c"
								} else {
									gchar* _tmp154_;
									gchar _tmp155_;
#line 838 "tracker-sparql-scanner.vala"
									_tmp154_ = self->priv->current;
#line 838 "tracker-sparql-scanner.vala"
									_tmp155_ = _tmp154_[0];
#line 838 "tracker-sparql-scanner.vala"
									if (_tmp155_ == '\n') {
#line 4397 "tracker-sparql-scanner.c"
										gchar* _tmp156_;
										gint _tmp157_;
#line 839 "tracker-sparql-scanner.vala"
										_tmp156_ = self->priv->current;
#line 839 "tracker-sparql-scanner.vala"
										self->priv->current = _tmp156_ + 1;
#line 840 "tracker-sparql-scanner.vala"
										_tmp157_ = self->priv->line;
#line 840 "tracker-sparql-scanner.vala"
										self->priv->line = _tmp157_ + 1;
#line 841 "tracker-sparql-scanner.vala"
										self->priv->column = 1;
#line 842 "tracker-sparql-scanner.vala"
										token_length_in_chars = 3;
#line 4412 "tracker-sparql-scanner.c"
									} else {
										gchar* _tmp158_;
										gchar _tmp159_;
#line 843 "tracker-sparql-scanner.vala"
										_tmp158_ = self->priv->current;
#line 843 "tracker-sparql-scanner.vala"
										_tmp159_ = _tmp158_[0];
#line 843 "tracker-sparql-scanner.vala"
										if (((gint) ((guchar) _tmp159_)) <= 0x7f) {
#line 4422 "tracker-sparql-scanner.c"
											gchar* _tmp160_;
											gint _tmp161_;
#line 845 "tracker-sparql-scanner.vala"
											_tmp160_ = self->priv->current;
#line 845 "tracker-sparql-scanner.vala"
											self->priv->current = _tmp160_ + 1;
#line 846 "tracker-sparql-scanner.vala"
											_tmp161_ = token_length_in_chars;
#line 846 "tracker-sparql-scanner.vala"
											token_length_in_chars = _tmp161_ + 1;
#line 4433 "tracker-sparql-scanner.c"
										} else {
											gunichar u = 0U;
											gchar* _tmp162_;
											gchar* _tmp163_;
											gchar* _tmp164_;
											gunichar _tmp165_;
#line 848 "tracker-sparql-scanner.vala"
											_tmp162_ = self->priv->current;
#line 848 "tracker-sparql-scanner.vala"
											_tmp163_ = self->priv->end;
#line 848 "tracker-sparql-scanner.vala"
											_tmp164_ = self->priv->current;
#line 848 "tracker-sparql-scanner.vala"
											u = g_utf8_get_char_validated ((const gchar*) _tmp162_, (gssize) ((glong) (_tmp163_ - _tmp164_)));
#line 849 "tracker-sparql-scanner.vala"
											_tmp165_ = u;
#line 849 "tracker-sparql-scanner.vala"
											if (_tmp165_ != ((gunichar) -1)) {
#line 4452 "tracker-sparql-scanner.c"
												gchar* _tmp166_;
												gunichar _tmp167_;
												gint _tmp168_;
#line 850 "tracker-sparql-scanner.vala"
												_tmp166_ = self->priv->current;
#line 850 "tracker-sparql-scanner.vala"
												_tmp167_ = u;
#line 850 "tracker-sparql-scanner.vala"
												self->priv->current = _tmp166_ + g_unichar_to_utf8 (_tmp167_, NULL);
#line 851 "tracker-sparql-scanner.vala"
												_tmp168_ = token_length_in_chars;
#line 851 "tracker-sparql-scanner.vala"
												token_length_in_chars = _tmp168_ + 1;
#line 4466 "tracker-sparql-scanner.c"
											} else {
												gint _tmp169_;
												gint _tmp170_;
												gint _tmp171_;
												GError* _tmp172_;
#line 853 "tracker-sparql-scanner.vala"
												_tmp169_ = self->priv->line;
#line 853 "tracker-sparql-scanner.vala"
												_tmp170_ = self->priv->column;
#line 853 "tracker-sparql-scanner.vala"
												_tmp171_ = token_length_in_chars;
#line 853 "tracker-sparql-scanner.vala"
												_tmp172_ = g_error_new (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_PARSE, "%d.%d: invalid UTF-8 character", _tmp169_, _tmp170_ + _tmp171_);
#line 853 "tracker-sparql-scanner.vala"
												_inner_error_ = _tmp172_;
#line 853 "tracker-sparql-scanner.vala"
												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 853 "tracker-sparql-scanner.vala"
													g_propagate_error (error, _inner_error_);
#line 853 "tracker-sparql-scanner.vala"
													return 0;
#line 4488 "tracker-sparql-scanner.c"
												} else {
#line 853 "tracker-sparql-scanner.vala"
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 853 "tracker-sparql-scanner.vala"
													g_clear_error (&_inner_error_);
#line 853 "tracker-sparql-scanner.vala"
													return 0;
#line 4496 "tracker-sparql-scanner.c"
												}
											}
										}
									}
								}
							}
#line 857 "tracker-sparql-scanner.vala"
							_tmp175_ = self->priv->current;
#line 857 "tracker-sparql-scanner.vala"
							_tmp176_ = _tmp175_[0];
#line 857 "tracker-sparql-scanner.vala"
							_tmp177_ = begin;
#line 857 "tracker-sparql-scanner.vala"
							_tmp178_ = _tmp177_[0];
#line 857 "tracker-sparql-scanner.vala"
							if (_tmp176_ == _tmp178_) {
#line 4513 "tracker-sparql-scanner.c"
								gchar* _tmp179_;
								gchar _tmp180_;
								gchar* _tmp181_;
								gchar _tmp182_;
#line 857 "tracker-sparql-scanner.vala"
								_tmp179_ = self->priv->current;
#line 857 "tracker-sparql-scanner.vala"
								_tmp180_ = _tmp179_[1];
#line 857 "tracker-sparql-scanner.vala"
								_tmp181_ = begin;
#line 857 "tracker-sparql-scanner.vala"
								_tmp182_ = _tmp181_[0];
#line 857 "tracker-sparql-scanner.vala"
								_tmp174_ = _tmp180_ == _tmp182_;
#line 4528 "tracker-sparql-scanner.c"
							} else {
#line 857 "tracker-sparql-scanner.vala"
								_tmp174_ = FALSE;
#line 4532 "tracker-sparql-scanner.c"
							}
#line 857 "tracker-sparql-scanner.vala"
							if (_tmp174_) {
#line 4536 "tracker-sparql-scanner.c"
								gchar* _tmp183_;
								gchar _tmp184_;
								gchar* _tmp185_;
								gchar _tmp186_;
#line 857 "tracker-sparql-scanner.vala"
								_tmp183_ = self->priv->current;
#line 857 "tracker-sparql-scanner.vala"
								_tmp184_ = _tmp183_[2];
#line 857 "tracker-sparql-scanner.vala"
								_tmp185_ = begin;
#line 857 "tracker-sparql-scanner.vala"
								_tmp186_ = _tmp185_[0];
#line 857 "tracker-sparql-scanner.vala"
								_tmp173_ = _tmp184_ == _tmp186_;
#line 4551 "tracker-sparql-scanner.c"
							} else {
#line 857 "tracker-sparql-scanner.vala"
								_tmp173_ = FALSE;
#line 4555 "tracker-sparql-scanner.c"
							}
#line 857 "tracker-sparql-scanner.vala"
							if (_tmp173_) {
#line 4559 "tracker-sparql-scanner.c"
								gchar* _tmp187_;
#line 858 "tracker-sparql-scanner.vala"
								_tmp187_ = self->priv->current;
#line 858 "tracker-sparql-scanner.vala"
								self->priv->current = _tmp187_ + 3;
#line 4565 "tracker-sparql-scanner.c"
							} else {
								gint _tmp188_;
								gint _tmp189_;
								gint _tmp190_;
								GError* _tmp191_;
#line 860 "tracker-sparql-scanner.vala"
								_tmp188_ = self->priv->line;
#line 860 "tracker-sparql-scanner.vala"
								_tmp189_ = self->priv->column;
#line 860 "tracker-sparql-scanner.vala"
								_tmp190_ = token_length_in_chars;
#line 860 "tracker-sparql-scanner.vala"
								_tmp191_ = g_error_new (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_PARSE, "%d.%d: syntax error, expected \"\"\"", _tmp188_, _tmp189_ + _tmp190_);
#line 860 "tracker-sparql-scanner.vala"
								_inner_error_ = _tmp191_;
#line 860 "tracker-sparql-scanner.vala"
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 860 "tracker-sparql-scanner.vala"
									g_propagate_error (error, _inner_error_);
#line 860 "tracker-sparql-scanner.vala"
									return 0;
#line 4587 "tracker-sparql-scanner.c"
								} else {
#line 860 "tracker-sparql-scanner.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 860 "tracker-sparql-scanner.vala"
									g_clear_error (&_inner_error_);
#line 860 "tracker-sparql-scanner.vala"
									return 0;
#line 4595 "tracker-sparql-scanner.c"
								}
							}
#line 862 "tracker-sparql-scanner.vala"
							break;
#line 4600 "tracker-sparql-scanner.c"
						}
#line 865 "tracker-sparql-scanner.vala"
						_tmp192_ = begin;
#line 865 "tracker-sparql-scanner.vala"
						_tmp193_ = _tmp192_[0];
#line 865 "tracker-sparql-scanner.vala"
						if (_tmp193_ == '\'') {
#line 866 "tracker-sparql-scanner.vala"
							type = TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1;
#line 4610 "tracker-sparql-scanner.c"
						} else {
#line 868 "tracker-sparql-scanner.vala"
							type = TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2;
#line 4614 "tracker-sparql-scanner.c"
						}
#line 871 "tracker-sparql-scanner.vala"
						token_length_in_chars = 2;
#line 872 "tracker-sparql-scanner.vala"
						_tmp194_ = self->priv->current;
#line 872 "tracker-sparql-scanner.vala"
						self->priv->current = _tmp194_ + 1;
#line 873 "tracker-sparql-scanner.vala"
						while (TRUE) {
#line 4624 "tracker-sparql-scanner.c"
							gboolean _tmp195_ = FALSE;
							gchar* _tmp196_;
							gchar* _tmp197_;
							gchar* _tmp202_;
							gchar _tmp203_;
#line 873 "tracker-sparql-scanner.vala"
							_tmp196_ = self->priv->current;
#line 873 "tracker-sparql-scanner.vala"
							_tmp197_ = self->priv->end;
#line 873 "tracker-sparql-scanner.vala"
							if (_tmp196_ < _tmp197_) {
#line 4636 "tracker-sparql-scanner.c"
								gchar* _tmp198_;
								gchar _tmp199_;
								gchar* _tmp200_;
								gchar _tmp201_;
#line 873 "tracker-sparql-scanner.vala"
								_tmp198_ = self->priv->current;
#line 873 "tracker-sparql-scanner.vala"
								_tmp199_ = _tmp198_[0];
#line 873 "tracker-sparql-scanner.vala"
								_tmp200_ = begin;
#line 873 "tracker-sparql-scanner.vala"
								_tmp201_ = _tmp200_[0];
#line 873 "tracker-sparql-scanner.vala"
								_tmp195_ = _tmp199_ != _tmp201_;
#line 4651 "tracker-sparql-scanner.c"
							} else {
#line 873 "tracker-sparql-scanner.vala"
								_tmp195_ = FALSE;
#line 4655 "tracker-sparql-scanner.c"
							}
#line 873 "tracker-sparql-scanner.vala"
							if (!_tmp195_) {
#line 873 "tracker-sparql-scanner.vala"
								break;
#line 4661 "tracker-sparql-scanner.c"
							}
#line 874 "tracker-sparql-scanner.vala"
							_tmp202_ = self->priv->current;
#line 874 "tracker-sparql-scanner.vala"
							_tmp203_ = _tmp202_[0];
#line 874 "tracker-sparql-scanner.vala"
							if (_tmp203_ == '\\') {
#line 4669 "tracker-sparql-scanner.c"
								gchar* _tmp204_;
								gint _tmp205_;
								gchar* _tmp206_;
								gchar* _tmp207_;
								gchar* _tmp208_;
								gchar _tmp209_;
#line 875 "tracker-sparql-scanner.vala"
								_tmp204_ = self->priv->current;
#line 875 "tracker-sparql-scanner.vala"
								self->priv->current = _tmp204_ + 1;
#line 876 "tracker-sparql-scanner.vala"
								_tmp205_ = token_length_in_chars;
#line 876 "tracker-sparql-scanner.vala"
								token_length_in_chars = _tmp205_ + 1;
#line 877 "tracker-sparql-scanner.vala"
								_tmp206_ = self->priv->current;
#line 877 "tracker-sparql-scanner.vala"
								_tmp207_ = self->priv->end;
#line 877 "tracker-sparql-scanner.vala"
								if (_tmp206_ >= _tmp207_) {
#line 878 "tracker-sparql-scanner.vala"
									break;
#line 4692 "tracker-sparql-scanner.c"
								}
#line 881 "tracker-sparql-scanner.vala"
								_tmp208_ = self->priv->current;
#line 881 "tracker-sparql-scanner.vala"
								_tmp209_ = _tmp208_[0];
#line 881 "tracker-sparql-scanner.vala"
								switch (_tmp209_) {
#line 881 "tracker-sparql-scanner.vala"
									case '\'':
#line 881 "tracker-sparql-scanner.vala"
									case '"':
#line 881 "tracker-sparql-scanner.vala"
									case '\\':
#line 881 "tracker-sparql-scanner.vala"
									case 'b':
#line 881 "tracker-sparql-scanner.vala"
									case 'f':
#line 881 "tracker-sparql-scanner.vala"
									case 'n':
#line 881 "tracker-sparql-scanner.vala"
									case 'r':
#line 881 "tracker-sparql-scanner.vala"
									case 't':
#line 4716 "tracker-sparql-scanner.c"
									{
										gchar* _tmp210_;
										gint _tmp211_;
#line 890 "tracker-sparql-scanner.vala"
										_tmp210_ = self->priv->current;
#line 890 "tracker-sparql-scanner.vala"
										self->priv->current = _tmp210_ + 1;
#line 891 "tracker-sparql-scanner.vala"
										_tmp211_ = token_length_in_chars;
#line 891 "tracker-sparql-scanner.vala"
										token_length_in_chars = _tmp211_ + 1;
#line 892 "tracker-sparql-scanner.vala"
										break;
#line 4730 "tracker-sparql-scanner.c"
									}
#line 881 "tracker-sparql-scanner.vala"
									case 'u':
#line 4734 "tracker-sparql-scanner.c"
									{
										gchar* _tmp226_;
										gint _tmp227_;
										{
											gint i = 0;
#line 894 "tracker-sparql-scanner.vala"
											i = 0;
#line 4742 "tracker-sparql-scanner.c"
											{
												gboolean _tmp212_ = FALSE;
#line 894 "tracker-sparql-scanner.vala"
												_tmp212_ = TRUE;
#line 894 "tracker-sparql-scanner.vala"
												while (TRUE) {
#line 4749 "tracker-sparql-scanner.c"
													gint _tmp214_;
													gboolean _tmp215_ = FALSE;
													gchar* _tmp216_;
													gint _tmp217_;
													gchar* _tmp218_;
#line 894 "tracker-sparql-scanner.vala"
													if (!_tmp212_) {
#line 4757 "tracker-sparql-scanner.c"
														gint _tmp213_;
#line 894 "tracker-sparql-scanner.vala"
														_tmp213_ = i;
#line 894 "tracker-sparql-scanner.vala"
														i = _tmp213_ + 1;
#line 4763 "tracker-sparql-scanner.c"
													}
#line 894 "tracker-sparql-scanner.vala"
													_tmp212_ = FALSE;
#line 894 "tracker-sparql-scanner.vala"
													_tmp214_ = i;
#line 894 "tracker-sparql-scanner.vala"
													if (!(_tmp214_ < 4)) {
#line 894 "tracker-sparql-scanner.vala"
														break;
#line 4773 "tracker-sparql-scanner.c"
													}
#line 895 "tracker-sparql-scanner.vala"
													_tmp216_ = self->priv->current;
#line 895 "tracker-sparql-scanner.vala"
													_tmp217_ = i;
#line 895 "tracker-sparql-scanner.vala"
													_tmp218_ = self->priv->end;
#line 895 "tracker-sparql-scanner.vala"
													if (((_tmp216_ + _tmp217_) + 1) >= _tmp218_) {
#line 895 "tracker-sparql-scanner.vala"
														_tmp215_ = TRUE;
#line 4785 "tracker-sparql-scanner.c"
													} else {
														gchar* _tmp219_;
														gint _tmp220_;
														gchar _tmp221_;
#line 895 "tracker-sparql-scanner.vala"
														_tmp219_ = self->priv->current;
#line 895 "tracker-sparql-scanner.vala"
														_tmp220_ = i;
#line 895 "tracker-sparql-scanner.vala"
														_tmp221_ = _tmp219_[_tmp220_ + 1];
#line 895 "tracker-sparql-scanner.vala"
														_tmp215_ = !g_ascii_isxdigit (_tmp221_);
#line 4798 "tracker-sparql-scanner.c"
													}
#line 895 "tracker-sparql-scanner.vala"
													if (_tmp215_) {
#line 4802 "tracker-sparql-scanner.c"
														gint _tmp222_;
														gint _tmp223_;
														gint _tmp224_;
														GError* _tmp225_;
#line 896 "tracker-sparql-scanner.vala"
														_tmp222_ = self->priv->line;
#line 896 "tracker-sparql-scanner.vala"
														_tmp223_ = self->priv->column;
#line 896 "tracker-sparql-scanner.vala"
														_tmp224_ = token_length_in_chars;
#line 896 "tracker-sparql-scanner.vala"
														_tmp225_ = g_error_new (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_PARSE, "%d.%d: invalid escape sequence", _tmp222_, _tmp223_ + _tmp224_);
#line 896 "tracker-sparql-scanner.vala"
														_inner_error_ = _tmp225_;
#line 896 "tracker-sparql-scanner.vala"
														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 896 "tracker-sparql-scanner.vala"
															g_propagate_error (error, _inner_error_);
#line 896 "tracker-sparql-scanner.vala"
															return 0;
#line 4823 "tracker-sparql-scanner.c"
														} else {
#line 896 "tracker-sparql-scanner.vala"
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 896 "tracker-sparql-scanner.vala"
															g_clear_error (&_inner_error_);
#line 896 "tracker-sparql-scanner.vala"
															return 0;
#line 4831 "tracker-sparql-scanner.c"
														}
													}
												}
											}
										}
#line 899 "tracker-sparql-scanner.vala"
										_tmp226_ = self->priv->current;
#line 899 "tracker-sparql-scanner.vala"
										self->priv->current = _tmp226_ + 5;
#line 900 "tracker-sparql-scanner.vala"
										_tmp227_ = token_length_in_chars;
#line 900 "tracker-sparql-scanner.vala"
										token_length_in_chars = _tmp227_ + 5;
#line 901 "tracker-sparql-scanner.vala"
										break;
#line 4847 "tracker-sparql-scanner.c"
									}
									default:
									{
										gint _tmp228_;
										gint _tmp229_;
										gint _tmp230_;
										GError* _tmp231_;
#line 903 "tracker-sparql-scanner.vala"
										_tmp228_ = self->priv->line;
#line 903 "tracker-sparql-scanner.vala"
										_tmp229_ = self->priv->column;
#line 903 "tracker-sparql-scanner.vala"
										_tmp230_ = token_length_in_chars;
#line 903 "tracker-sparql-scanner.vala"
										_tmp231_ = g_error_new (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_PARSE, "%d.%d: invalid escape sequence", _tmp228_, _tmp229_ + _tmp230_);
#line 903 "tracker-sparql-scanner.vala"
										_inner_error_ = _tmp231_;
#line 903 "tracker-sparql-scanner.vala"
										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 903 "tracker-sparql-scanner.vala"
											g_propagate_error (error, _inner_error_);
#line 903 "tracker-sparql-scanner.vala"
											return 0;
#line 4871 "tracker-sparql-scanner.c"
										} else {
#line 903 "tracker-sparql-scanner.vala"
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 903 "tracker-sparql-scanner.vala"
											g_clear_error (&_inner_error_);
#line 903 "tracker-sparql-scanner.vala"
											return 0;
#line 4879 "tracker-sparql-scanner.c"
										}
									}
								}
							} else {
								gchar* _tmp232_;
								gchar _tmp233_;
#line 905 "tracker-sparql-scanner.vala"
								_tmp232_ = self->priv->current;
#line 905 "tracker-sparql-scanner.vala"
								_tmp233_ = _tmp232_[0];
#line 905 "tracker-sparql-scanner.vala"
								if (_tmp233_ == '\n') {
#line 906 "tracker-sparql-scanner.vala"
									break;
#line 4894 "tracker-sparql-scanner.c"
								} else {
									gchar* _tmp234_;
									gchar _tmp235_;
#line 907 "tracker-sparql-scanner.vala"
									_tmp234_ = self->priv->current;
#line 907 "tracker-sparql-scanner.vala"
									_tmp235_ = _tmp234_[0];
#line 907 "tracker-sparql-scanner.vala"
									if (((gint) ((guchar) _tmp235_)) <= 0x7f) {
#line 4904 "tracker-sparql-scanner.c"
										gchar* _tmp236_;
										gint _tmp237_;
#line 909 "tracker-sparql-scanner.vala"
										_tmp236_ = self->priv->current;
#line 909 "tracker-sparql-scanner.vala"
										self->priv->current = _tmp236_ + 1;
#line 910 "tracker-sparql-scanner.vala"
										_tmp237_ = token_length_in_chars;
#line 910 "tracker-sparql-scanner.vala"
										token_length_in_chars = _tmp237_ + 1;
#line 4915 "tracker-sparql-scanner.c"
									} else {
										gunichar u = 0U;
										gchar* _tmp238_;
										gchar* _tmp239_;
										gchar* _tmp240_;
										gunichar _tmp241_;
#line 912 "tracker-sparql-scanner.vala"
										_tmp238_ = self->priv->current;
#line 912 "tracker-sparql-scanner.vala"
										_tmp239_ = self->priv->end;
#line 912 "tracker-sparql-scanner.vala"
										_tmp240_ = self->priv->current;
#line 912 "tracker-sparql-scanner.vala"
										u = g_utf8_get_char_validated ((const gchar*) _tmp238_, (gssize) ((glong) (_tmp239_ - _tmp240_)));
#line 913 "tracker-sparql-scanner.vala"
										_tmp241_ = u;
#line 913 "tracker-sparql-scanner.vala"
										if (_tmp241_ != ((gunichar) -1)) {
#line 4934 "tracker-sparql-scanner.c"
											gchar* _tmp242_;
											gunichar _tmp243_;
											gint _tmp244_;
#line 914 "tracker-sparql-scanner.vala"
											_tmp242_ = self->priv->current;
#line 914 "tracker-sparql-scanner.vala"
											_tmp243_ = u;
#line 914 "tracker-sparql-scanner.vala"
											self->priv->current = _tmp242_ + g_unichar_to_utf8 (_tmp243_, NULL);
#line 915 "tracker-sparql-scanner.vala"
											_tmp244_ = token_length_in_chars;
#line 915 "tracker-sparql-scanner.vala"
											token_length_in_chars = _tmp244_ + 1;
#line 4948 "tracker-sparql-scanner.c"
										} else {
											gchar* _tmp245_;
											gint _tmp246_;
											gint _tmp247_;
											gint _tmp248_;
											GError* _tmp249_;
#line 917 "tracker-sparql-scanner.vala"
											_tmp245_ = self->priv->current;
#line 917 "tracker-sparql-scanner.vala"
											self->priv->current = _tmp245_ + 1;
#line 918 "tracker-sparql-scanner.vala"
											_tmp246_ = self->priv->line;
#line 918 "tracker-sparql-scanner.vala"
											_tmp247_ = self->priv->column;
#line 918 "tracker-sparql-scanner.vala"
											_tmp248_ = token_length_in_chars;
#line 918 "tracker-sparql-scanner.vala"
											_tmp249_ = g_error_new (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_PARSE, "%d.%d: invalid UTF-8 character", _tmp246_, _tmp247_ + _tmp248_);
#line 918 "tracker-sparql-scanner.vala"
											_inner_error_ = _tmp249_;
#line 918 "tracker-sparql-scanner.vala"
											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 918 "tracker-sparql-scanner.vala"
												g_propagate_error (error, _inner_error_);
#line 918 "tracker-sparql-scanner.vala"
												return 0;
#line 4975 "tracker-sparql-scanner.c"
											} else {
#line 918 "tracker-sparql-scanner.vala"
												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 918 "tracker-sparql-scanner.vala"
												g_clear_error (&_inner_error_);
#line 918 "tracker-sparql-scanner.vala"
												return 0;
#line 4983 "tracker-sparql-scanner.c"
											}
										}
									}
								}
							}
						}
#line 922 "tracker-sparql-scanner.vala"
						_tmp251_ = self->priv->current;
#line 922 "tracker-sparql-scanner.vala"
						_tmp252_ = self->priv->end;
#line 922 "tracker-sparql-scanner.vala"
						if (_tmp251_ < _tmp252_) {
#line 4996 "tracker-sparql-scanner.c"
							gchar* _tmp253_;
							gchar _tmp254_;
#line 922 "tracker-sparql-scanner.vala"
							_tmp253_ = self->priv->current;
#line 922 "tracker-sparql-scanner.vala"
							_tmp254_ = _tmp253_[0];
#line 922 "tracker-sparql-scanner.vala"
							_tmp250_ = _tmp254_ != '\n';
#line 5005 "tracker-sparql-scanner.c"
						} else {
#line 922 "tracker-sparql-scanner.vala"
							_tmp250_ = FALSE;
#line 5009 "tracker-sparql-scanner.c"
						}
#line 922 "tracker-sparql-scanner.vala"
						if (_tmp250_) {
#line 5013 "tracker-sparql-scanner.c"
							gchar* _tmp255_;
#line 923 "tracker-sparql-scanner.vala"
							_tmp255_ = self->priv->current;
#line 923 "tracker-sparql-scanner.vala"
							self->priv->current = _tmp255_ + 1;
#line 5019 "tracker-sparql-scanner.c"
						} else {
							gint _tmp256_;
							gint _tmp257_;
							gint _tmp258_;
							gchar* _tmp259_;
							gchar _tmp260_;
							GError* _tmp261_;
#line 925 "tracker-sparql-scanner.vala"
							_tmp256_ = self->priv->line;
#line 925 "tracker-sparql-scanner.vala"
							_tmp257_ = self->priv->column;
#line 925 "tracker-sparql-scanner.vala"
							_tmp258_ = token_length_in_chars;
#line 925 "tracker-sparql-scanner.vala"
							_tmp259_ = begin;
#line 925 "tracker-sparql-scanner.vala"
							_tmp260_ = _tmp259_[0];
#line 925 "tracker-sparql-scanner.vala"
							_tmp261_ = g_error_new (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_PARSE, "%d.%d: syntax error, expected %c", _tmp256_, _tmp257_ + _tmp258_, (gint) _tmp260_);
#line 925 "tracker-sparql-scanner.vala"
							_inner_error_ = _tmp261_;
#line 925 "tracker-sparql-scanner.vala"
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 925 "tracker-sparql-scanner.vala"
								g_propagate_error (error, _inner_error_);
#line 925 "tracker-sparql-scanner.vala"
								return 0;
#line 5047 "tracker-sparql-scanner.c"
							} else {
#line 925 "tracker-sparql-scanner.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 925 "tracker-sparql-scanner.vala"
								g_clear_error (&_inner_error_);
#line 925 "tracker-sparql-scanner.vala"
								return 0;
#line 5055 "tracker-sparql-scanner.c"
							}
						}
#line 927 "tracker-sparql-scanner.vala"
						break;
#line 5060 "tracker-sparql-scanner.c"
					}
#line 652 "tracker-sparql-scanner.vala"
					case '^':
#line 5064 "tracker-sparql-scanner.c"
					{
						gboolean _tmp262_ = FALSE;
						gchar* _tmp263_;
						gchar* _tmp264_;
#line 929 "tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_NONE;
#line 930 "tracker-sparql-scanner.vala"
						_tmp263_ = self->priv->current;
#line 930 "tracker-sparql-scanner.vala"
						_tmp264_ = self->priv->end;
#line 930 "tracker-sparql-scanner.vala"
						if (_tmp263_ < (_tmp264_ - 2)) {
#line 5077 "tracker-sparql-scanner.c"
							gchar* _tmp265_;
							gchar _tmp266_;
							gchar* _tmp267_;
							gchar _tmp268_;
#line 930 "tracker-sparql-scanner.vala"
							_tmp265_ = self->priv->current;
#line 930 "tracker-sparql-scanner.vala"
							_tmp266_ = _tmp265_[0];
#line 930 "tracker-sparql-scanner.vala"
							_tmp267_ = self->priv->current;
#line 930 "tracker-sparql-scanner.vala"
							_tmp268_ = _tmp267_[1];
#line 930 "tracker-sparql-scanner.vala"
							_tmp262_ = _tmp266_ == _tmp268_;
#line 5092 "tracker-sparql-scanner.c"
						} else {
#line 930 "tracker-sparql-scanner.vala"
							_tmp262_ = FALSE;
#line 5096 "tracker-sparql-scanner.c"
						}
#line 930 "tracker-sparql-scanner.vala"
						if (_tmp262_) {
#line 5100 "tracker-sparql-scanner.c"
							gchar* _tmp269_;
#line 931 "tracker-sparql-scanner.vala"
							type = TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX;
#line 932 "tracker-sparql-scanner.vala"
							_tmp269_ = self->priv->current;
#line 932 "tracker-sparql-scanner.vala"
							self->priv->current = _tmp269_ + 2;
#line 5108 "tracker-sparql-scanner.c"
						} else {
							gint _tmp270_;
							gint _tmp271_;
							GError* _tmp272_;
#line 934 "tracker-sparql-scanner.vala"
							_tmp270_ = self->priv->line;
#line 934 "tracker-sparql-scanner.vala"
							_tmp271_ = self->priv->column;
#line 934 "tracker-sparql-scanner.vala"
							_tmp272_ = g_error_new (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_PARSE, "%d.%d: syntax error, unexpected character", _tmp270_, _tmp271_);
#line 934 "tracker-sparql-scanner.vala"
							_inner_error_ = _tmp272_;
#line 934 "tracker-sparql-scanner.vala"
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 934 "tracker-sparql-scanner.vala"
								g_propagate_error (error, _inner_error_);
#line 934 "tracker-sparql-scanner.vala"
								return 0;
#line 5127 "tracker-sparql-scanner.c"
							} else {
#line 934 "tracker-sparql-scanner.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 934 "tracker-sparql-scanner.vala"
								g_clear_error (&_inner_error_);
#line 934 "tracker-sparql-scanner.vala"
								return 0;
#line 5135 "tracker-sparql-scanner.c"
							}
						}
#line 936 "tracker-sparql-scanner.vala"
						break;
#line 5140 "tracker-sparql-scanner.c"
					}
#line 652 "tracker-sparql-scanner.vala"
					case '_':
#line 5144 "tracker-sparql-scanner.c"
					{
						gchar* _tmp273_;
#line 938 "tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE;
#line 939 "tracker-sparql-scanner.vala"
						_tmp273_ = self->priv->current;
#line 939 "tracker-sparql-scanner.vala"
						self->priv->current = _tmp273_ + 1;
#line 940 "tracker-sparql-scanner.vala"
						break;
#line 5155 "tracker-sparql-scanner.c"
					}
					default:
					{
						gunichar u = 0U;
						gchar* _tmp274_;
						gchar* _tmp275_;
						gchar* _tmp276_;
						gunichar _tmp277_;
#line 942 "tracker-sparql-scanner.vala"
						_tmp274_ = self->priv->current;
#line 942 "tracker-sparql-scanner.vala"
						_tmp275_ = self->priv->end;
#line 942 "tracker-sparql-scanner.vala"
						_tmp276_ = self->priv->current;
#line 942 "tracker-sparql-scanner.vala"
						u = g_utf8_get_char_validated ((const gchar*) _tmp274_, (gssize) ((glong) (_tmp275_ - _tmp276_)));
#line 943 "tracker-sparql-scanner.vala"
						_tmp277_ = u;
#line 943 "tracker-sparql-scanner.vala"
						if (_tmp277_ != ((gunichar) -1)) {
#line 5176 "tracker-sparql-scanner.c"
							gint _tmp278_;
							gint _tmp279_;
							GError* _tmp280_;
#line 944 "tracker-sparql-scanner.vala"
							_tmp278_ = self->priv->line;
#line 944 "tracker-sparql-scanner.vala"
							_tmp279_ = self->priv->column;
#line 944 "tracker-sparql-scanner.vala"
							_tmp280_ = g_error_new (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_PARSE, "%d.%d: syntax error, unexpected character", _tmp278_, _tmp279_);
#line 944 "tracker-sparql-scanner.vala"
							_inner_error_ = _tmp280_;
#line 944 "tracker-sparql-scanner.vala"
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 944 "tracker-sparql-scanner.vala"
								g_propagate_error (error, _inner_error_);
#line 944 "tracker-sparql-scanner.vala"
								return 0;
#line 5194 "tracker-sparql-scanner.c"
							} else {
#line 944 "tracker-sparql-scanner.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 944 "tracker-sparql-scanner.vala"
								g_clear_error (&_inner_error_);
#line 944 "tracker-sparql-scanner.vala"
								return 0;
#line 5202 "tracker-sparql-scanner.c"
							}
						} else {
							gint _tmp281_;
							gint _tmp282_;
							GError* _tmp283_;
#line 946 "tracker-sparql-scanner.vala"
							_tmp281_ = self->priv->line;
#line 946 "tracker-sparql-scanner.vala"
							_tmp282_ = self->priv->column;
#line 946 "tracker-sparql-scanner.vala"
							_tmp283_ = g_error_new (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_PARSE, "%d.%d: invalid UTF-8 character", _tmp281_, _tmp282_);
#line 946 "tracker-sparql-scanner.vala"
							_inner_error_ = _tmp283_;
#line 946 "tracker-sparql-scanner.vala"
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 946 "tracker-sparql-scanner.vala"
								g_propagate_error (error, _inner_error_);
#line 946 "tracker-sparql-scanner.vala"
								return 0;
#line 5222 "tracker-sparql-scanner.c"
							} else {
#line 946 "tracker-sparql-scanner.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 946 "tracker-sparql-scanner.vala"
								g_clear_error (&_inner_error_);
#line 946 "tracker-sparql-scanner.vala"
								return 0;
#line 5230 "tracker-sparql-scanner.c"
							}
						}
					}
				}
			}
		}
	}
#line 951 "tracker-sparql-scanner.vala"
	_tmp284_ = token_length_in_chars;
#line 951 "tracker-sparql-scanner.vala"
	if (_tmp284_ < 0) {
#line 5242 "tracker-sparql-scanner.c"
		gint _tmp285_;
		gchar* _tmp286_;
		gchar* _tmp287_;
#line 952 "tracker-sparql-scanner.vala"
		_tmp285_ = self->priv->column;
#line 952 "tracker-sparql-scanner.vala"
		_tmp286_ = self->priv->current;
#line 952 "tracker-sparql-scanner.vala"
		_tmp287_ = begin;
#line 952 "tracker-sparql-scanner.vala"
		self->priv->column = _tmp285_ + ((gint) (_tmp286_ - _tmp287_));
#line 5254 "tracker-sparql-scanner.c"
	} else {
		gint _tmp288_;
		gint _tmp289_;
#line 954 "tracker-sparql-scanner.vala"
		_tmp288_ = self->priv->column;
#line 954 "tracker-sparql-scanner.vala"
		_tmp289_ = token_length_in_chars;
#line 954 "tracker-sparql-scanner.vala"
		self->priv->column = _tmp288_ + _tmp289_;
#line 5264 "tracker-sparql-scanner.c"
	}
#line 957 "tracker-sparql-scanner.vala"
	_tmp290_ = self->priv->current;
#line 957 "tracker-sparql-scanner.vala"
	_tmp291_ = self->priv->line;
#line 957 "tracker-sparql-scanner.vala"
	_tmp292_ = self->priv->column;
#line 957 "tracker-sparql-scanner.vala"
	tracker_source_location_init (&_vala_token_end, _tmp290_, _tmp291_, _tmp292_ - 1);
#line 959 "tracker-sparql-scanner.vala"
	result = type;
#line 959 "tracker-sparql-scanner.vala"
	if (token_begin) {
#line 959 "tracker-sparql-scanner.vala"
		*token_begin = _vala_token_begin;
#line 5280 "tracker-sparql-scanner.c"
	}
#line 959 "tracker-sparql-scanner.vala"
	if (token_end) {
#line 959 "tracker-sparql-scanner.vala"
		*token_end = _vala_token_end;
#line 5286 "tracker-sparql-scanner.c"
	}
#line 959 "tracker-sparql-scanner.vala"
	return result;
#line 5290 "tracker-sparql-scanner.c"
}


static gboolean
tracker_sparql_scanner_matches (TrackerSparqlScanner* self,
                                gchar* begin,
                                const gchar* keyword)
{
	gboolean result = FALSE;
	gchar* keyword_array = NULL;
#line 962 "tracker-sparql-scanner.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 962 "tracker-sparql-scanner.vala"
	g_return_val_if_fail (keyword != NULL, FALSE);
#line 963 "tracker-sparql-scanner.vala"
	keyword_array = (gchar*) keyword;
#line 5307 "tracker-sparql-scanner.c"
	{
		gint i = 0;
#line 964 "tracker-sparql-scanner.vala"
		i = 0;
#line 5312 "tracker-sparql-scanner.c"
		{
			gboolean _tmp0_ = FALSE;
#line 964 "tracker-sparql-scanner.vala"
			_tmp0_ = TRUE;
#line 964 "tracker-sparql-scanner.vala"
			while (TRUE) {
#line 5319 "tracker-sparql-scanner.c"
				gchar* _tmp2_;
				gint _tmp3_;
				gchar _tmp4_;
				gint _tmp5_;
				gchar _tmp6_;
				gchar* _tmp7_;
				gint _tmp8_;
				gchar _tmp9_;
#line 964 "tracker-sparql-scanner.vala"
				if (!_tmp0_) {
#line 5330 "tracker-sparql-scanner.c"
					gint _tmp1_;
#line 964 "tracker-sparql-scanner.vala"
					_tmp1_ = i;
#line 964 "tracker-sparql-scanner.vala"
					i = _tmp1_ + 1;
#line 5336 "tracker-sparql-scanner.c"
				}
#line 964 "tracker-sparql-scanner.vala"
				_tmp0_ = FALSE;
#line 964 "tracker-sparql-scanner.vala"
				_tmp2_ = keyword_array;
#line 964 "tracker-sparql-scanner.vala"
				_tmp3_ = i;
#line 964 "tracker-sparql-scanner.vala"
				_tmp4_ = _tmp2_[_tmp3_];
#line 964 "tracker-sparql-scanner.vala"
				if (!(((gint) _tmp4_) != 0)) {
#line 964 "tracker-sparql-scanner.vala"
					break;
#line 5350 "tracker-sparql-scanner.c"
				}
#line 965 "tracker-sparql-scanner.vala"
				_tmp5_ = i;
#line 965 "tracker-sparql-scanner.vala"
				_tmp6_ = begin[_tmp5_];
#line 965 "tracker-sparql-scanner.vala"
				_tmp7_ = keyword_array;
#line 965 "tracker-sparql-scanner.vala"
				_tmp8_ = i;
#line 965 "tracker-sparql-scanner.vala"
				_tmp9_ = _tmp7_[_tmp8_];
#line 965 "tracker-sparql-scanner.vala"
				if (g_ascii_toupper (_tmp6_) != _tmp9_) {
#line 966 "tracker-sparql-scanner.vala"
					result = FALSE;
#line 966 "tracker-sparql-scanner.vala"
					return result;
#line 5368 "tracker-sparql-scanner.c"
				}
			}
		}
	}
#line 969 "tracker-sparql-scanner.vala"
	result = TRUE;
#line 969 "tracker-sparql-scanner.vala"
	return result;
#line 5377 "tracker-sparql-scanner.c"
}


static gboolean
tracker_sparql_scanner_whitespace (TrackerSparqlScanner* self)
{
	gboolean result = FALSE;
	gboolean found = FALSE;
#line 972 "tracker-sparql-scanner.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 973 "tracker-sparql-scanner.vala"
	found = FALSE;
#line 974 "tracker-sparql-scanner.vala"
	while (TRUE) {
#line 5392 "tracker-sparql-scanner.c"
		gboolean _tmp0_ = FALSE;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp5_;
		gchar _tmp6_;
		gchar* _tmp8_;
		gint _tmp9_;
#line 974 "tracker-sparql-scanner.vala"
		_tmp1_ = self->priv->current;
#line 974 "tracker-sparql-scanner.vala"
		_tmp2_ = self->priv->end;
#line 974 "tracker-sparql-scanner.vala"
		if (_tmp1_ < _tmp2_) {
#line 5406 "tracker-sparql-scanner.c"
			gchar* _tmp3_;
			gchar _tmp4_;
#line 974 "tracker-sparql-scanner.vala"
			_tmp3_ = self->priv->current;
#line 974 "tracker-sparql-scanner.vala"
			_tmp4_ = _tmp3_[0];
#line 974 "tracker-sparql-scanner.vala"
			_tmp0_ = g_ascii_isspace (_tmp4_);
#line 5415 "tracker-sparql-scanner.c"
		} else {
#line 974 "tracker-sparql-scanner.vala"
			_tmp0_ = FALSE;
#line 5419 "tracker-sparql-scanner.c"
		}
#line 974 "tracker-sparql-scanner.vala"
		if (!_tmp0_) {
#line 974 "tracker-sparql-scanner.vala"
			break;
#line 5425 "tracker-sparql-scanner.c"
		}
#line 975 "tracker-sparql-scanner.vala"
		_tmp5_ = self->priv->current;
#line 975 "tracker-sparql-scanner.vala"
		_tmp6_ = _tmp5_[0];
#line 975 "tracker-sparql-scanner.vala"
		if (_tmp6_ == '\n') {
#line 5433 "tracker-sparql-scanner.c"
			gint _tmp7_;
#line 976 "tracker-sparql-scanner.vala"
			_tmp7_ = self->priv->line;
#line 976 "tracker-sparql-scanner.vala"
			self->priv->line = _tmp7_ + 1;
#line 977 "tracker-sparql-scanner.vala"
			self->priv->column = 0;
#line 5441 "tracker-sparql-scanner.c"
		}
#line 979 "tracker-sparql-scanner.vala"
		found = TRUE;
#line 980 "tracker-sparql-scanner.vala"
		_tmp8_ = self->priv->current;
#line 980 "tracker-sparql-scanner.vala"
		self->priv->current = _tmp8_ + 1;
#line 981 "tracker-sparql-scanner.vala"
		_tmp9_ = self->priv->column;
#line 981 "tracker-sparql-scanner.vala"
		self->priv->column = _tmp9_ + 1;
#line 5453 "tracker-sparql-scanner.c"
	}
#line 983 "tracker-sparql-scanner.vala"
	result = found;
#line 983 "tracker-sparql-scanner.vala"
	return result;
#line 5459 "tracker-sparql-scanner.c"
}


static gboolean
tracker_sparql_scanner_comment (TrackerSparqlScanner* self)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp1_;
	gchar* _tmp2_;
#line 986 "tracker-sparql-scanner.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 987 "tracker-sparql-scanner.vala"
	_tmp1_ = self->priv->current;
#line 987 "tracker-sparql-scanner.vala"
	_tmp2_ = self->priv->end;
#line 987 "tracker-sparql-scanner.vala"
	if (_tmp1_ >= _tmp2_) {
#line 987 "tracker-sparql-scanner.vala"
		_tmp0_ = TRUE;
#line 5480 "tracker-sparql-scanner.c"
	} else {
		gchar* _tmp3_;
		gchar _tmp4_;
#line 987 "tracker-sparql-scanner.vala"
		_tmp3_ = self->priv->current;
#line 987 "tracker-sparql-scanner.vala"
		_tmp4_ = _tmp3_[0];
#line 987 "tracker-sparql-scanner.vala"
		_tmp0_ = _tmp4_ != '#';
#line 5490 "tracker-sparql-scanner.c"
	}
#line 987 "tracker-sparql-scanner.vala"
	if (_tmp0_) {
#line 988 "tracker-sparql-scanner.vala"
		result = FALSE;
#line 988 "tracker-sparql-scanner.vala"
		return result;
#line 5498 "tracker-sparql-scanner.c"
	}
#line 993 "tracker-sparql-scanner.vala"
	while (TRUE) {
#line 5502 "tracker-sparql-scanner.c"
		gboolean _tmp5_ = FALSE;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp10_;
#line 993 "tracker-sparql-scanner.vala"
		_tmp6_ = self->priv->current;
#line 993 "tracker-sparql-scanner.vala"
		_tmp7_ = self->priv->end;
#line 993 "tracker-sparql-scanner.vala"
		if (_tmp6_ < _tmp7_) {
#line 5513 "tracker-sparql-scanner.c"
			gchar* _tmp8_;
			gchar _tmp9_;
#line 993 "tracker-sparql-scanner.vala"
			_tmp8_ = self->priv->current;
#line 993 "tracker-sparql-scanner.vala"
			_tmp9_ = _tmp8_[0];
#line 993 "tracker-sparql-scanner.vala"
			_tmp5_ = _tmp9_ != '\n';
#line 5522 "tracker-sparql-scanner.c"
		} else {
#line 993 "tracker-sparql-scanner.vala"
			_tmp5_ = FALSE;
#line 5526 "tracker-sparql-scanner.c"
		}
#line 993 "tracker-sparql-scanner.vala"
		if (!_tmp5_) {
#line 993 "tracker-sparql-scanner.vala"
			break;
#line 5532 "tracker-sparql-scanner.c"
		}
#line 994 "tracker-sparql-scanner.vala"
		_tmp10_ = self->priv->current;
#line 994 "tracker-sparql-scanner.vala"
		self->priv->current = _tmp10_ + 1;
#line 5538 "tracker-sparql-scanner.c"
	}
#line 997 "tracker-sparql-scanner.vala"
	result = TRUE;
#line 997 "tracker-sparql-scanner.vala"
	return result;
#line 5544 "tracker-sparql-scanner.c"
}


static void
tracker_sparql_scanner_space (TrackerSparqlScanner* self)
{
#line 1000 "tracker-sparql-scanner.vala"
	g_return_if_fail (self != NULL);
#line 1001 "tracker-sparql-scanner.vala"
	while (TRUE) {
#line 5555 "tracker-sparql-scanner.c"
		gboolean _tmp0_ = FALSE;
#line 1001 "tracker-sparql-scanner.vala"
		if (tracker_sparql_scanner_whitespace (self)) {
#line 1001 "tracker-sparql-scanner.vala"
			_tmp0_ = TRUE;
#line 5561 "tracker-sparql-scanner.c"
		} else {
#line 1001 "tracker-sparql-scanner.vala"
			_tmp0_ = tracker_sparql_scanner_comment (self);
#line 5565 "tracker-sparql-scanner.c"
		}
#line 1001 "tracker-sparql-scanner.vala"
		if (!_tmp0_) {
#line 1001 "tracker-sparql-scanner.vala"
			break;
#line 5571 "tracker-sparql-scanner.c"
		}
	}
}


static void
tracker_sparql_scanner_class_init (TrackerSparqlScannerClass * klass)
{
#line 20 "tracker-sparql-scanner.vala"
	tracker_sparql_scanner_parent_class = g_type_class_peek_parent (klass);
#line 20 "tracker-sparql-scanner.vala"
	g_type_class_adjust_private_offset (klass, &TrackerSparqlScanner_private_offset);
#line 20 "tracker-sparql-scanner.vala"
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_scanner_finalize;
#line 5586 "tracker-sparql-scanner.c"
}


static void
tracker_sparql_scanner_instance_init (TrackerSparqlScanner * self)
{
#line 20 "tracker-sparql-scanner.vala"
	self->priv = tracker_sparql_scanner_get_instance_private (self);
#line 5595 "tracker-sparql-scanner.c"
}


static void
tracker_sparql_scanner_finalize (GObject * obj)
{
	TrackerSparqlScanner * self;
#line 20 "tracker-sparql-scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_TYPE_SPARQL_SCANNER, TrackerSparqlScanner);
#line 20 "tracker-sparql-scanner.vala"
	G_OBJECT_CLASS (tracker_sparql_scanner_parent_class)->finalize (obj);
#line 5607 "tracker-sparql-scanner.c"
}


GType
tracker_sparql_scanner_get_type (void)
{
	static volatile gsize tracker_sparql_scanner_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_scanner_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlScannerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_scanner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlScanner), 0, (GInstanceInitFunc) tracker_sparql_scanner_instance_init, NULL };
		GType tracker_sparql_scanner_type_id;
		tracker_sparql_scanner_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerSparqlScanner", &g_define_type_info, 0);
		TrackerSparqlScanner_private_offset = g_type_add_instance_private (tracker_sparql_scanner_type_id, sizeof (TrackerSparqlScannerPrivate));
		g_once_init_leave (&tracker_sparql_scanner_type_id__volatile, tracker_sparql_scanner_type_id);
	}
	return tracker_sparql_scanner_type_id__volatile;
}


void
tracker_source_location_init (TrackerSourceLocation *self,
                              gchar* pos,
                              gint line,
                              gint column)
{
#line 1014 "tracker-sparql-scanner.vala"
	memset (self, 0, sizeof (TrackerSourceLocation));
#line 1015 "tracker-sparql-scanner.vala"
	(*self).pos = pos;
#line 1016 "tracker-sparql-scanner.vala"
	(*self).line = line;
#line 1017 "tracker-sparql-scanner.vala"
	(*self).column = column;
#line 5640 "tracker-sparql-scanner.c"
}


TrackerSourceLocation*
tracker_source_location_dup (const TrackerSourceLocation* self)
{
	TrackerSourceLocation* dup;
#line 1009 "tracker-sparql-scanner.vala"
	dup = g_new0 (TrackerSourceLocation, 1);
#line 1009 "tracker-sparql-scanner.vala"
	memcpy (dup, self, sizeof (TrackerSourceLocation));
#line 1009 "tracker-sparql-scanner.vala"
	return dup;
#line 5654 "tracker-sparql-scanner.c"
}


void
tracker_source_location_free (TrackerSourceLocation* self)
{
#line 1009 "tracker-sparql-scanner.vala"
	g_free (self);
#line 5663 "tracker-sparql-scanner.c"
}


GType
tracker_source_location_get_type (void)
{
	static volatile gsize tracker_source_location_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_source_location_type_id__volatile)) {
		GType tracker_source_location_type_id;
		tracker_source_location_type_id = g_boxed_type_register_static ("TrackerSourceLocation", (GBoxedCopyFunc) tracker_source_location_dup, (GBoxedFreeFunc) tracker_source_location_free);
		g_once_init_leave (&tracker_source_location_type_id__volatile, tracker_source_location_type_id);
	}
	return tracker_source_location_type_id__volatile;
}


const gchar*
tracker_sparql_token_type_to_string (TrackerSparqlTokenType self)
{
	const gchar* result = NULL;
#line 1150 "tracker-sparql-scanner.vala"
	switch (self) {
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_A:
#line 5688 "tracker-sparql-scanner.c"
		{
#line 1151 "tracker-sparql-scanner.vala"
			result = "`a'";
#line 1151 "tracker-sparql-scanner.vala"
			return result;
#line 5694 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ABS:
#line 5698 "tracker-sparql-scanner.c"
		{
#line 1152 "tracker-sparql-scanner.vala"
			result = "`ABS'";
#line 1152 "tracker-sparql-scanner.vala"
			return result;
#line 5704 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_AS:
#line 5708 "tracker-sparql-scanner.c"
		{
#line 1153 "tracker-sparql-scanner.vala"
			result = "`AS'";
#line 1153 "tracker-sparql-scanner.vala"
			return result;
#line 5714 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ASC:
#line 5718 "tracker-sparql-scanner.c"
		{
#line 1154 "tracker-sparql-scanner.vala"
			result = "`ASC'";
#line 1154 "tracker-sparql-scanner.vala"
			return result;
#line 5724 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ASK:
#line 5728 "tracker-sparql-scanner.c"
		{
#line 1155 "tracker-sparql-scanner.vala"
			result = "`ASK'";
#line 1155 "tracker-sparql-scanner.vala"
			return result;
#line 5734 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ATBASE:
#line 5738 "tracker-sparql-scanner.c"
		{
#line 1156 "tracker-sparql-scanner.vala"
			result = "`@base'";
#line 1156 "tracker-sparql-scanner.vala"
			return result;
#line 5744 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ATPREFIX:
#line 5748 "tracker-sparql-scanner.c"
		{
#line 1157 "tracker-sparql-scanner.vala"
			result = "`@prefix'";
#line 1157 "tracker-sparql-scanner.vala"
			return result;
#line 5754 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_AVG:
#line 5758 "tracker-sparql-scanner.c"
		{
#line 1158 "tracker-sparql-scanner.vala"
			result = "`AVG'";
#line 1158 "tracker-sparql-scanner.vala"
			return result;
#line 5764 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_BASE:
#line 5768 "tracker-sparql-scanner.c"
		{
#line 1159 "tracker-sparql-scanner.vala"
			result = "`BASE'";
#line 1159 "tracker-sparql-scanner.vala"
			return result;
#line 5774 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE:
#line 5778 "tracker-sparql-scanner.c"
		{
#line 1160 "tracker-sparql-scanner.vala"
			result = "blank node";
#line 1160 "tracker-sparql-scanner.vala"
			return result;
#line 5784 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_BIND:
#line 5788 "tracker-sparql-scanner.c"
		{
#line 1161 "tracker-sparql-scanner.vala"
			result = "`BIND'";
#line 1161 "tracker-sparql-scanner.vala"
			return result;
#line 5794 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_BOUND:
#line 5798 "tracker-sparql-scanner.c"
		{
#line 1162 "tracker-sparql-scanner.vala"
			result = "`BOUND'";
#line 1162 "tracker-sparql-scanner.vala"
			return result;
#line 5804 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_BY:
#line 5808 "tracker-sparql-scanner.c"
		{
#line 1163 "tracker-sparql-scanner.vala"
			result = "`BY'";
#line 1163 "tracker-sparql-scanner.vala"
			return result;
#line 5814 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_CEIL:
#line 5818 "tracker-sparql-scanner.c"
		{
#line 1164 "tracker-sparql-scanner.vala"
			result = "`CEIL'";
#line 1164 "tracker-sparql-scanner.vala"
			return result;
#line 5824 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE:
#line 5828 "tracker-sparql-scanner.c"
		{
#line 1165 "tracker-sparql-scanner.vala"
			result = "`}'";
#line 1165 "tracker-sparql-scanner.vala"
			return result;
#line 5834 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACKET:
#line 5838 "tracker-sparql-scanner.c"
		{
#line 1166 "tracker-sparql-scanner.vala"
			result = "`]'";
#line 1166 "tracker-sparql-scanner.vala"
			return result;
#line 5844 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS:
#line 5848 "tracker-sparql-scanner.c"
		{
#line 1167 "tracker-sparql-scanner.vala"
			result = "`)'";
#line 1167 "tracker-sparql-scanner.vala"
			return result;
#line 5854 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_COALESCE:
#line 5858 "tracker-sparql-scanner.c"
		{
#line 1168 "tracker-sparql-scanner.vala"
			result = "`COALESCE'";
#line 1168 "tracker-sparql-scanner.vala"
			return result;
#line 5864 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_COLON:
#line 5868 "tracker-sparql-scanner.c"
		{
#line 1169 "tracker-sparql-scanner.vala"
			result = "`:'";
#line 1169 "tracker-sparql-scanner.vala"
			return result;
#line 5874 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_CONCAT:
#line 5878 "tracker-sparql-scanner.c"
		{
#line 1170 "tracker-sparql-scanner.vala"
			result = "`CONCAT'";
#line 1170 "tracker-sparql-scanner.vala"
			return result;
#line 5884 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_CONTAINS:
#line 5888 "tracker-sparql-scanner.c"
		{
#line 1171 "tracker-sparql-scanner.vala"
			result = "`CONTAINS'";
#line 1171 "tracker-sparql-scanner.vala"
			return result;
#line 5894 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_COMMA:
#line 5898 "tracker-sparql-scanner.c"
		{
#line 1172 "tracker-sparql-scanner.vala"
			result = "`,'";
#line 1172 "tracker-sparql-scanner.vala"
			return result;
#line 5904 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_CONSTRUCT:
#line 5908 "tracker-sparql-scanner.c"
		{
#line 1173 "tracker-sparql-scanner.vala"
			result = "`CONSTRUCT'";
#line 1173 "tracker-sparql-scanner.vala"
			return result;
#line 5914 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_COUNT:
#line 5918 "tracker-sparql-scanner.c"
		{
#line 1174 "tracker-sparql-scanner.vala"
			result = "`COUNT'";
#line 1174 "tracker-sparql-scanner.vala"
			return result;
#line 5924 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DATATYPE:
#line 5928 "tracker-sparql-scanner.c"
		{
#line 1175 "tracker-sparql-scanner.vala"
			result = "`DATATYPE'";
#line 1175 "tracker-sparql-scanner.vala"
			return result;
#line 5934 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DAY:
#line 5938 "tracker-sparql-scanner.c"
		{
#line 1176 "tracker-sparql-scanner.vala"
			result = "`DAY'";
#line 1176 "tracker-sparql-scanner.vala"
			return result;
#line 5944 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DECIMAL:
#line 5948 "tracker-sparql-scanner.c"
		{
#line 1177 "tracker-sparql-scanner.vala"
			result = "`DECIMAL'";
#line 1177 "tracker-sparql-scanner.vala"
			return result;
#line 5954 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DELETE:
#line 5958 "tracker-sparql-scanner.c"
		{
#line 1178 "tracker-sparql-scanner.vala"
			result = "`DELETE'";
#line 1178 "tracker-sparql-scanner.vala"
			return result;
#line 5964 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DESC:
#line 5968 "tracker-sparql-scanner.c"
		{
#line 1179 "tracker-sparql-scanner.vala"
			result = "`DESC'";
#line 1179 "tracker-sparql-scanner.vala"
			return result;
#line 5974 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DESCRIBE:
#line 5978 "tracker-sparql-scanner.c"
		{
#line 1180 "tracker-sparql-scanner.vala"
			result = "`DESCRIBE'";
#line 1180 "tracker-sparql-scanner.vala"
			return result;
#line 5984 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DISTINCT:
#line 5988 "tracker-sparql-scanner.c"
		{
#line 1181 "tracker-sparql-scanner.vala"
			result = "`DISTINCT'";
#line 1181 "tracker-sparql-scanner.vala"
			return result;
#line 5994 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DOUBLE:
#line 5998 "tracker-sparql-scanner.c"
		{
#line 1182 "tracker-sparql-scanner.vala"
			result = "`DOUBLE'";
#line 1182 "tracker-sparql-scanner.vala"
			return result;
#line 6004 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX:
#line 6008 "tracker-sparql-scanner.c"
		{
#line 1183 "tracker-sparql-scanner.vala"
			result = "`^^'";
#line 1183 "tracker-sparql-scanner.vala"
			return result;
#line 6014 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DROP:
#line 6018 "tracker-sparql-scanner.c"
		{
#line 1184 "tracker-sparql-scanner.vala"
			result = "`DROP'";
#line 1184 "tracker-sparql-scanner.vala"
			return result;
#line 6024 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ENCODE_FOR_URI:
#line 6028 "tracker-sparql-scanner.c"
		{
#line 1185 "tracker-sparql-scanner.vala"
			result = "`ENCODE_FOR_URI'";
#line 1185 "tracker-sparql-scanner.vala"
			return result;
#line 6034 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_EOF:
#line 6038 "tracker-sparql-scanner.c"
		{
#line 1186 "tracker-sparql-scanner.vala"
			result = "end of file";
#line 1186 "tracker-sparql-scanner.vala"
			return result;
#line 6044 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_EXISTS:
#line 6048 "tracker-sparql-scanner.c"
		{
#line 1187 "tracker-sparql-scanner.vala"
			result = "`EXISTS'";
#line 1187 "tracker-sparql-scanner.vala"
			return result;
#line 6054 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_FALSE:
#line 6058 "tracker-sparql-scanner.c"
		{
#line 1188 "tracker-sparql-scanner.vala"
			result = "`false'";
#line 1188 "tracker-sparql-scanner.vala"
			return result;
#line 6064 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_FILTER:
#line 6068 "tracker-sparql-scanner.c"
		{
#line 1189 "tracker-sparql-scanner.vala"
			result = "`FILTER'";
#line 1189 "tracker-sparql-scanner.vala"
			return result;
#line 6074 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_FLOOR:
#line 6078 "tracker-sparql-scanner.c"
		{
#line 1190 "tracker-sparql-scanner.vala"
			result = "`FLOOR'";
#line 1190 "tracker-sparql-scanner.vala"
			return result;
#line 6084 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_FROM:
#line 6088 "tracker-sparql-scanner.c"
		{
#line 1191 "tracker-sparql-scanner.vala"
			result = "`FROM'";
#line 1191 "tracker-sparql-scanner.vala"
			return result;
#line 6094 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_GRAPH:
#line 6098 "tracker-sparql-scanner.c"
		{
#line 1192 "tracker-sparql-scanner.vala"
			result = "`GRAPH'";
#line 1192 "tracker-sparql-scanner.vala"
			return result;
#line 6104 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_GROUP:
#line 6108 "tracker-sparql-scanner.c"
		{
#line 1193 "tracker-sparql-scanner.vala"
			result = "`GROUP'";
#line 1193 "tracker-sparql-scanner.vala"
			return result;
#line 6114 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_GROUP_CONCAT:
#line 6118 "tracker-sparql-scanner.c"
		{
#line 1194 "tracker-sparql-scanner.vala"
			result = "`GROUP_CONCAT'";
#line 1194 "tracker-sparql-scanner.vala"
			return result;
#line 6124 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_HAVING:
#line 6128 "tracker-sparql-scanner.c"
		{
#line 1195 "tracker-sparql-scanner.vala"
			result = "`HAVING'";
#line 1195 "tracker-sparql-scanner.vala"
			return result;
#line 6134 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_HOURS:
#line 6138 "tracker-sparql-scanner.c"
		{
#line 1196 "tracker-sparql-scanner.vala"
			result = "`HOURS'";
#line 1196 "tracker-sparql-scanner.vala"
			return result;
#line 6144 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_IF:
#line 6148 "tracker-sparql-scanner.c"
		{
#line 1197 "tracker-sparql-scanner.vala"
			result = "`IF'";
#line 1197 "tracker-sparql-scanner.vala"
			return result;
#line 6154 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_INSERT:
#line 6158 "tracker-sparql-scanner.c"
		{
#line 1198 "tracker-sparql-scanner.vala"
			result = "`INSERT'";
#line 1198 "tracker-sparql-scanner.vala"
			return result;
#line 6164 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_INTEGER:
#line 6168 "tracker-sparql-scanner.c"
		{
#line 1199 "tracker-sparql-scanner.vala"
			result = "`INTEGER'";
#line 1199 "tracker-sparql-scanner.vala"
			return result;
#line 6174 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_INTO:
#line 6178 "tracker-sparql-scanner.c"
		{
#line 1200 "tracker-sparql-scanner.vala"
			result = "`INTO'";
#line 1200 "tracker-sparql-scanner.vala"
			return result;
#line 6184 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_IRI_REF:
#line 6188 "tracker-sparql-scanner.c"
		{
#line 1201 "tracker-sparql-scanner.vala"
			result = "IRI reference";
#line 1201 "tracker-sparql-scanner.vala"
			return result;
#line 6194 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ISBLANK:
#line 6198 "tracker-sparql-scanner.c"
		{
#line 1202 "tracker-sparql-scanner.vala"
			result = "`ISBLANK'";
#line 1202 "tracker-sparql-scanner.vala"
			return result;
#line 6204 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ISIRI:
#line 6208 "tracker-sparql-scanner.c"
		{
#line 1203 "tracker-sparql-scanner.vala"
			result = "`ISIRI'";
#line 1203 "tracker-sparql-scanner.vala"
			return result;
#line 6214 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL:
#line 6218 "tracker-sparql-scanner.c"
		{
#line 1204 "tracker-sparql-scanner.vala"
			result = "`ISLITERAL'";
#line 1204 "tracker-sparql-scanner.vala"
			return result;
#line 6224 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ISURI:
#line 6228 "tracker-sparql-scanner.c"
		{
#line 1205 "tracker-sparql-scanner.vala"
			result = "`ISURI'";
#line 1205 "tracker-sparql-scanner.vala"
			return result;
#line 6234 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_LANG:
#line 6238 "tracker-sparql-scanner.c"
		{
#line 1206 "tracker-sparql-scanner.vala"
			result = "`LANG'";
#line 1206 "tracker-sparql-scanner.vala"
			return result;
#line 6244 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES:
#line 6248 "tracker-sparql-scanner.c"
		{
#line 1207 "tracker-sparql-scanner.vala"
			result = "`LANGMATCHES'";
#line 1207 "tracker-sparql-scanner.vala"
			return result;
#line 6254 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_LCASE:
#line 6258 "tracker-sparql-scanner.c"
		{
#line 1208 "tracker-sparql-scanner.vala"
			result = "`LCASE'";
#line 1208 "tracker-sparql-scanner.vala"
			return result;
#line 6264 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_LIMIT:
#line 6268 "tracker-sparql-scanner.c"
		{
#line 1209 "tracker-sparql-scanner.vala"
			result = "`LIMIT'";
#line 1209 "tracker-sparql-scanner.vala"
			return result;
#line 6274 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_MAX:
#line 6278 "tracker-sparql-scanner.c"
		{
#line 1210 "tracker-sparql-scanner.vala"
			result = "`MAX'";
#line 1210 "tracker-sparql-scanner.vala"
			return result;
#line 6284 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_MD5:
#line 6288 "tracker-sparql-scanner.c"
		{
#line 1211 "tracker-sparql-scanner.vala"
			result = "`MD5'";
#line 1211 "tracker-sparql-scanner.vala"
			return result;
#line 6294 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_MIN:
#line 6298 "tracker-sparql-scanner.c"
		{
#line 1212 "tracker-sparql-scanner.vala"
			result = "`MIN'";
#line 1212 "tracker-sparql-scanner.vala"
			return result;
#line 6304 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_MINUS:
#line 6308 "tracker-sparql-scanner.c"
		{
#line 1213 "tracker-sparql-scanner.vala"
			result = "`-'";
#line 1213 "tracker-sparql-scanner.vala"
			return result;
#line 6314 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_MINUTES:
#line 6318 "tracker-sparql-scanner.c"
		{
#line 1214 "tracker-sparql-scanner.vala"
			result = "`MINUTES'";
#line 1214 "tracker-sparql-scanner.vala"
			return result;
#line 6324 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_MONTH:
#line 6328 "tracker-sparql-scanner.c"
		{
#line 1215 "tracker-sparql-scanner.vala"
			result = "`MONTH'";
#line 1215 "tracker-sparql-scanner.vala"
			return result;
#line 6334 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_NAMED:
#line 6338 "tracker-sparql-scanner.c"
		{
#line 1216 "tracker-sparql-scanner.vala"
			result = "`NAMED'";
#line 1216 "tracker-sparql-scanner.vala"
			return result;
#line 6344 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_NOT:
#line 6348 "tracker-sparql-scanner.c"
		{
#line 1217 "tracker-sparql-scanner.vala"
			result = "`NOT'";
#line 1217 "tracker-sparql-scanner.vala"
			return result;
#line 6354 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_NOW:
#line 6358 "tracker-sparql-scanner.c"
		{
#line 1218 "tracker-sparql-scanner.vala"
			result = "`NOW'";
#line 1218 "tracker-sparql-scanner.vala"
			return result;
#line 6364 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OFFSET:
#line 6368 "tracker-sparql-scanner.c"
		{
#line 1219 "tracker-sparql-scanner.vala"
			result = "`OFFSET'";
#line 1219 "tracker-sparql-scanner.vala"
			return result;
#line 6374 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OP_AND:
#line 6378 "tracker-sparql-scanner.c"
		{
#line 1220 "tracker-sparql-scanner.vala"
			result = "`&&'";
#line 1220 "tracker-sparql-scanner.vala"
			return result;
#line 6384 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OP_EQ:
#line 6388 "tracker-sparql-scanner.c"
		{
#line 1221 "tracker-sparql-scanner.vala"
			result = "`='";
#line 1221 "tracker-sparql-scanner.vala"
			return result;
#line 6394 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OP_GE:
#line 6398 "tracker-sparql-scanner.c"
		{
#line 1222 "tracker-sparql-scanner.vala"
			result = "`>='";
#line 1222 "tracker-sparql-scanner.vala"
			return result;
#line 6404 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OP_GT:
#line 6408 "tracker-sparql-scanner.c"
		{
#line 1223 "tracker-sparql-scanner.vala"
			result = "`>'";
#line 1223 "tracker-sparql-scanner.vala"
			return result;
#line 6414 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OP_LE:
#line 6418 "tracker-sparql-scanner.c"
		{
#line 1224 "tracker-sparql-scanner.vala"
			result = "`<='";
#line 1224 "tracker-sparql-scanner.vala"
			return result;
#line 6424 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OP_LT:
#line 6428 "tracker-sparql-scanner.c"
		{
#line 1225 "tracker-sparql-scanner.vala"
			result = "`<'";
#line 1225 "tracker-sparql-scanner.vala"
			return result;
#line 6434 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OP_NE:
#line 6438 "tracker-sparql-scanner.c"
		{
#line 1226 "tracker-sparql-scanner.vala"
			result = "`!='";
#line 1226 "tracker-sparql-scanner.vala"
			return result;
#line 6444 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OP_NEG:
#line 6448 "tracker-sparql-scanner.c"
		{
#line 1227 "tracker-sparql-scanner.vala"
			result = "`!'";
#line 1227 "tracker-sparql-scanner.vala"
			return result;
#line 6454 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OP_OR:
#line 6458 "tracker-sparql-scanner.c"
		{
#line 1228 "tracker-sparql-scanner.vala"
			result = "`||'";
#line 1228 "tracker-sparql-scanner.vala"
			return result;
#line 6464 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OP_IN:
#line 6468 "tracker-sparql-scanner.c"
		{
#line 1229 "tracker-sparql-scanner.vala"
			result = "`IN'";
#line 1229 "tracker-sparql-scanner.vala"
			return result;
#line 6474 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE:
#line 6478 "tracker-sparql-scanner.c"
		{
#line 1230 "tracker-sparql-scanner.vala"
			result = "`{'";
#line 1230 "tracker-sparql-scanner.vala"
			return result;
#line 6484 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET:
#line 6488 "tracker-sparql-scanner.c"
		{
#line 1231 "tracker-sparql-scanner.vala"
			result = "`['";
#line 1231 "tracker-sparql-scanner.vala"
			return result;
#line 6494 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS:
#line 6498 "tracker-sparql-scanner.c"
		{
#line 1232 "tracker-sparql-scanner.vala"
			result = "`('";
#line 1232 "tracker-sparql-scanner.vala"
			return result;
#line 6504 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OPTIONAL:
#line 6508 "tracker-sparql-scanner.c"
		{
#line 1233 "tracker-sparql-scanner.vala"
			result = "`OPTIONAL'";
#line 1233 "tracker-sparql-scanner.vala"
			return result;
#line 6514 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OR:
#line 6518 "tracker-sparql-scanner.c"
		{
#line 1234 "tracker-sparql-scanner.vala"
			result = "`OR'";
#line 1234 "tracker-sparql-scanner.vala"
			return result;
#line 6524 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ORDER:
#line 6528 "tracker-sparql-scanner.c"
		{
#line 1235 "tracker-sparql-scanner.vala"
			result = "`ORDER'";
#line 1235 "tracker-sparql-scanner.vala"
			return result;
#line 6534 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_PLUS:
#line 6538 "tracker-sparql-scanner.c"
		{
#line 1236 "tracker-sparql-scanner.vala"
			result = "`+'";
#line 1236 "tracker-sparql-scanner.vala"
			return result;
#line 6544 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX:
#line 6548 "tracker-sparql-scanner.c"
		{
#line 1237 "tracker-sparql-scanner.vala"
			result = "prefixed name";
#line 1237 "tracker-sparql-scanner.vala"
			return result;
#line 6554 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_PREFIX:
#line 6558 "tracker-sparql-scanner.c"
		{
#line 1238 "tracker-sparql-scanner.vala"
			result = "`PREFIX'";
#line 1238 "tracker-sparql-scanner.vala"
			return result;
#line 6564 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_RAND:
#line 6568 "tracker-sparql-scanner.c"
		{
#line 1239 "tracker-sparql-scanner.vala"
			result = "`RAND'";
#line 1239 "tracker-sparql-scanner.vala"
			return result;
#line 6574 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_REDUCED:
#line 6578 "tracker-sparql-scanner.c"
		{
#line 1240 "tracker-sparql-scanner.vala"
			result = "`REDUCED'";
#line 1240 "tracker-sparql-scanner.vala"
			return result;
#line 6584 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_REGEX:
#line 6588 "tracker-sparql-scanner.c"
		{
#line 1241 "tracker-sparql-scanner.vala"
			result = "`REGEX'";
#line 1241 "tracker-sparql-scanner.vala"
			return result;
#line 6594 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_REPLACE:
#line 6598 "tracker-sparql-scanner.c"
		{
#line 1242 "tracker-sparql-scanner.vala"
			result = "`REPLACE'";
#line 1242 "tracker-sparql-scanner.vala"
			return result;
#line 6604 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ROUND:
#line 6608 "tracker-sparql-scanner.c"
		{
#line 1243 "tracker-sparql-scanner.vala"
			result = "`ROUND'";
#line 1243 "tracker-sparql-scanner.vala"
			return result;
#line 6614 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_SAMETERM:
#line 6618 "tracker-sparql-scanner.c"
		{
#line 1244 "tracker-sparql-scanner.vala"
			result = "`SAMETERM'";
#line 1244 "tracker-sparql-scanner.vala"
			return result;
#line 6624 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_SECONDS:
#line 6628 "tracker-sparql-scanner.c"
		{
#line 1245 "tracker-sparql-scanner.vala"
			result = "`SECONDS'";
#line 1245 "tracker-sparql-scanner.vala"
			return result;
#line 6634 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_SELECT:
#line 6638 "tracker-sparql-scanner.c"
		{
#line 1246 "tracker-sparql-scanner.vala"
			result = "`SELECT'";
#line 1246 "tracker-sparql-scanner.vala"
			return result;
#line 6644 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_SEMICOLON:
#line 6648 "tracker-sparql-scanner.c"
		{
#line 1247 "tracker-sparql-scanner.vala"
			result = "`;'";
#line 1247 "tracker-sparql-scanner.vala"
			return result;
#line 6654 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_SHA1:
#line 6658 "tracker-sparql-scanner.c"
		{
#line 1248 "tracker-sparql-scanner.vala"
			result = "`SHA1'";
#line 1248 "tracker-sparql-scanner.vala"
			return result;
#line 6664 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_SHA256:
#line 6668 "tracker-sparql-scanner.c"
		{
#line 1249 "tracker-sparql-scanner.vala"
			result = "`SHA256'";
#line 1249 "tracker-sparql-scanner.vala"
			return result;
#line 6674 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_SHA512:
#line 6678 "tracker-sparql-scanner.c"
		{
#line 1250 "tracker-sparql-scanner.vala"
			result = "`SHA512'";
#line 1250 "tracker-sparql-scanner.vala"
			return result;
#line 6684 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_SILENT:
#line 6688 "tracker-sparql-scanner.c"
		{
#line 1251 "tracker-sparql-scanner.vala"
			result = "`SILENT'";
#line 1251 "tracker-sparql-scanner.vala"
			return result;
#line 6694 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STAR:
#line 6698 "tracker-sparql-scanner.c"
		{
#line 1252 "tracker-sparql-scanner.vala"
			result = "`*'";
#line 1252 "tracker-sparql-scanner.vala"
			return result;
#line 6704 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STR:
#line 6708 "tracker-sparql-scanner.c"
		{
#line 1253 "tracker-sparql-scanner.vala"
			result = "`STR'";
#line 1253 "tracker-sparql-scanner.vala"
			return result;
#line 6714 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRAFTER:
#line 6718 "tracker-sparql-scanner.c"
		{
#line 1254 "tracker-sparql-scanner.vala"
			result = "`STRAFTER'";
#line 1254 "tracker-sparql-scanner.vala"
			return result;
#line 6724 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRBEFORE:
#line 6728 "tracker-sparql-scanner.c"
		{
#line 1255 "tracker-sparql-scanner.vala"
			result = "`STRBEFORE'";
#line 1255 "tracker-sparql-scanner.vala"
			return result;
#line 6734 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRENDS:
#line 6738 "tracker-sparql-scanner.c"
		{
#line 1256 "tracker-sparql-scanner.vala"
			result = "`STRENDS'";
#line 1256 "tracker-sparql-scanner.vala"
			return result;
#line 6744 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1:
#line 6748 "tracker-sparql-scanner.c"
		{
#line 1257 "tracker-sparql-scanner.vala"
			result = "string literal";
#line 1257 "tracker-sparql-scanner.vala"
			return result;
#line 6754 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2:
#line 6758 "tracker-sparql-scanner.c"
		{
#line 1258 "tracker-sparql-scanner.vala"
			result = "string literal";
#line 1258 "tracker-sparql-scanner.vala"
			return result;
#line 6764 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1:
#line 6768 "tracker-sparql-scanner.c"
		{
#line 1259 "tracker-sparql-scanner.vala"
			result = "string literal";
#line 1259 "tracker-sparql-scanner.vala"
			return result;
#line 6774 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2:
#line 6778 "tracker-sparql-scanner.c"
		{
#line 1260 "tracker-sparql-scanner.vala"
			result = "string literal";
#line 1260 "tracker-sparql-scanner.vala"
			return result;
#line 6784 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRLEN:
#line 6788 "tracker-sparql-scanner.c"
		{
#line 1261 "tracker-sparql-scanner.vala"
			result = "`STRLEN'";
#line 1261 "tracker-sparql-scanner.vala"
			return result;
#line 6794 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRSTARTS:
#line 6798 "tracker-sparql-scanner.c"
		{
#line 1262 "tracker-sparql-scanner.vala"
			result = "`STRSTARTS'";
#line 1262 "tracker-sparql-scanner.vala"
			return result;
#line 6804 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_SUBSTR:
#line 6808 "tracker-sparql-scanner.c"
		{
#line 1263 "tracker-sparql-scanner.vala"
			result = "`SUBSTR'";
#line 1263 "tracker-sparql-scanner.vala"
			return result;
#line 6814 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_SUM:
#line 6818 "tracker-sparql-scanner.c"
		{
#line 1264 "tracker-sparql-scanner.vala"
			result = "`SUM'";
#line 1264 "tracker-sparql-scanner.vala"
			return result;
#line 6824 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_TRUE:
#line 6828 "tracker-sparql-scanner.c"
		{
#line 1265 "tracker-sparql-scanner.vala"
			result = "`true'";
#line 1265 "tracker-sparql-scanner.vala"
			return result;
#line 6834 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_UCASE:
#line 6838 "tracker-sparql-scanner.c"
		{
#line 1266 "tracker-sparql-scanner.vala"
			result = "`UCASE'";
#line 1266 "tracker-sparql-scanner.vala"
			return result;
#line 6844 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_UNION:
#line 6848 "tracker-sparql-scanner.c"
		{
#line 1267 "tracker-sparql-scanner.vala"
			result = "`UNION'";
#line 1267 "tracker-sparql-scanner.vala"
			return result;
#line 6854 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_VAR:
#line 6858 "tracker-sparql-scanner.c"
		{
#line 1268 "tracker-sparql-scanner.vala"
			result = "variable";
#line 1268 "tracker-sparql-scanner.vala"
			return result;
#line 6864 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_WHERE:
#line 6868 "tracker-sparql-scanner.c"
		{
#line 1269 "tracker-sparql-scanner.vala"
			result = "`WHERE'";
#line 1269 "tracker-sparql-scanner.vala"
			return result;
#line 6874 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_WITH:
#line 6878 "tracker-sparql-scanner.c"
		{
#line 1270 "tracker-sparql-scanner.vala"
			result = "`WITH'";
#line 1270 "tracker-sparql-scanner.vala"
			return result;
#line 6884 "tracker-sparql-scanner.c"
		}
#line 1150 "tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_YEAR:
#line 6888 "tracker-sparql-scanner.c"
		{
#line 1271 "tracker-sparql-scanner.vala"
			result = "`YEAR'";
#line 1271 "tracker-sparql-scanner.vala"
			return result;
#line 6894 "tracker-sparql-scanner.c"
		}
		default:
		{
#line 1272 "tracker-sparql-scanner.vala"
			result = "unknown token";
#line 1272 "tracker-sparql-scanner.vala"
			return result;
#line 6902 "tracker-sparql-scanner.c"
		}
	}
}


GType
tracker_sparql_token_type_get_type (void)
{
	static volatile gsize tracker_sparql_token_type_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_token_type_type_id__volatile)) {
		static const GEnumValue values[] = {{TRACKER_SPARQL_TOKEN_TYPE_NONE, "TRACKER_SPARQL_TOKEN_TYPE_NONE", "none"}, {TRACKER_SPARQL_TOKEN_TYPE_A, "TRACKER_SPARQL_TOKEN_TYPE_A", "a"}, {TRACKER_SPARQL_TOKEN_TYPE_ABS, "TRACKER_SPARQL_TOKEN_TYPE_ABS", "abs"}, {TRACKER_SPARQL_TOKEN_TYPE_AS, "TRACKER_SPARQL_TOKEN_TYPE_AS", "as"}, {TRACKER_SPARQL_TOKEN_TYPE_ASC, "TRACKER_SPARQL_TOKEN_TYPE_ASC", "asc"}, {TRACKER_SPARQL_TOKEN_TYPE_ASK, "TRACKER_SPARQL_TOKEN_TYPE_ASK", "ask"}, {TRACKER_SPARQL_TOKEN_TYPE_ATBASE, "TRACKER_SPARQL_TOKEN_TYPE_ATBASE", "atbase"}, {TRACKER_SPARQL_TOKEN_TYPE_ATPREFIX, "TRACKER_SPARQL_TOKEN_TYPE_ATPREFIX", "atprefix"}, {TRACKER_SPARQL_TOKEN_TYPE_AVG, "TRACKER_SPARQL_TOKEN_TYPE_AVG", "avg"}, {TRACKER_SPARQL_TOKEN_TYPE_BASE, "TRACKER_SPARQL_TOKEN_TYPE_BASE", "base"}, {TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE, "TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE", "blank-node"}, {TRACKER_SPARQL_TOKEN_TYPE_BIND, "TRACKER_SPARQL_TOKEN_TYPE_BIND", "bind"}, {TRACKER_SPARQL_TOKEN_TYPE_BOUND, "TRACKER_SPARQL_TOKEN_TYPE_BOUND", "bound"}, {TRACKER_SPARQL_TOKEN_TYPE_BY, "TRACKER_SPARQL_TOKEN_TYPE_BY", "by"}, {TRACKER_SPARQL_TOKEN_TYPE_CEIL, "TRACKER_SPARQL_TOKEN_TYPE_CEIL", "ceil"}, {TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE, "TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE", "close-brace"}, {TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACKET, "TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACKET", "close-bracket"}, {TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, "TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS", "close-parens"}, {TRACKER_SPARQL_TOKEN_TYPE_COALESCE, "TRACKER_SPARQL_TOKEN_TYPE_COALESCE", "coalesce"}, {TRACKER_SPARQL_TOKEN_TYPE_COLON, "TRACKER_SPARQL_TOKEN_TYPE_COLON", "colon"}, {TRACKER_SPARQL_TOKEN_TYPE_CONCAT, "TRACKER_SPARQL_TOKEN_TYPE_CONCAT", "concat"}, {TRACKER_SPARQL_TOKEN_TYPE_CONTAINS, "TRACKER_SPARQL_TOKEN_TYPE_CONTAINS", "contains"}, {TRACKER_SPARQL_TOKEN_TYPE_COMMA, "TRACKER_SPARQL_TOKEN_TYPE_COMMA", "comma"}, {TRACKER_SPARQL_TOKEN_TYPE_CONSTRUCT, "TRACKER_SPARQL_TOKEN_TYPE_CONSTRUCT", "construct"}, {TRACKER_SPARQL_TOKEN_TYPE_COUNT, "TRACKER_SPARQL_TOKEN_TYPE_COUNT", "count"}, {TRACKER_SPARQL_TOKEN_TYPE_DATA, "TRACKER_SPARQL_TOKEN_TYPE_DATA", "data"}, {TRACKER_SPARQL_TOKEN_TYPE_DATATYPE, "TRACKER_SPARQL_TOKEN_TYPE_DATATYPE", "datatype"}, {TRACKER_SPARQL_TOKEN_TYPE_DAY, "TRACKER_SPARQL_TOKEN_TYPE_DAY", "day"}, {TRACKER_SPARQL_TOKEN_TYPE_DECIMAL, "TRACKER_SPARQL_TOKEN_TYPE_DECIMAL", "decimal"}, {TRACKER_SPARQL_TOKEN_TYPE_DELETE, "TRACKER_SPARQL_TOKEN_TYPE_DELETE", "delete"}, {TRACKER_SPARQL_TOKEN_TYPE_DESC, "TRACKER_SPARQL_TOKEN_TYPE_DESC", "desc"}, {TRACKER_SPARQL_TOKEN_TYPE_DESCRIBE, "TRACKER_SPARQL_TOKEN_TYPE_DESCRIBE", "describe"}, {TRACKER_SPARQL_TOKEN_TYPE_DISTINCT, "TRACKER_SPARQL_TOKEN_TYPE_DISTINCT", "distinct"}, {TRACKER_SPARQL_TOKEN_TYPE_DIV, "TRACKER_SPARQL_TOKEN_TYPE_DIV", "div"}, {TRACKER_SPARQL_TOKEN_TYPE_DOT, "TRACKER_SPARQL_TOKEN_TYPE_DOT", "dot"}, {TRACKER_SPARQL_TOKEN_TYPE_DOUBLE, "TRACKER_SPARQL_TOKEN_TYPE_DOUBLE", "double"}, {TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX, "TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX", "double-circumflex"}, {TRACKER_SPARQL_TOKEN_TYPE_DROP, "TRACKER_SPARQL_TOKEN_TYPE_DROP", "drop"}, {TRACKER_SPARQL_TOKEN_TYPE_ENCODE_FOR_URI, "TRACKER_SPARQL_TOKEN_TYPE_ENCODE_FOR_URI", "encode-for-uri"}, {TRACKER_SPARQL_TOKEN_TYPE_EOF, "TRACKER_SPARQL_TOKEN_TYPE_EOF", "eof"}, {TRACKER_SPARQL_TOKEN_TYPE_EXISTS, "TRACKER_SPARQL_TOKEN_TYPE_EXISTS", "exists"}, {TRACKER_SPARQL_TOKEN_TYPE_FALSE, "TRACKER_SPARQL_TOKEN_TYPE_FALSE", "false"}, {TRACKER_SPARQL_TOKEN_TYPE_FILTER, "TRACKER_SPARQL_TOKEN_TYPE_FILTER", "filter"}, {TRACKER_SPARQL_TOKEN_TYPE_FLOOR, "TRACKER_SPARQL_TOKEN_TYPE_FLOOR", "floor"}, {TRACKER_SPARQL_TOKEN_TYPE_FROM, "TRACKER_SPARQL_TOKEN_TYPE_FROM", "from"}, {TRACKER_SPARQL_TOKEN_TYPE_GRAPH, "TRACKER_SPARQL_TOKEN_TYPE_GRAPH", "graph"}, {TRACKER_SPARQL_TOKEN_TYPE_GROUP, "TRACKER_SPARQL_TOKEN_TYPE_GROUP", "group"}, {TRACKER_SPARQL_TOKEN_TYPE_GROUP_CONCAT, "TRACKER_SPARQL_TOKEN_TYPE_GROUP_CONCAT", "group-concat"}, {TRACKER_SPARQL_TOKEN_TYPE_HAVING, "TRACKER_SPARQL_TOKEN_TYPE_HAVING", "having"}, {TRACKER_SPARQL_TOKEN_TYPE_HOURS, "TRACKER_SPARQL_TOKEN_TYPE_HOURS", "hours"}, {TRACKER_SPARQL_TOKEN_TYPE_IF, "TRACKER_SPARQL_TOKEN_TYPE_IF", "if"}, {TRACKER_SPARQL_TOKEN_TYPE_INSERT, "TRACKER_SPARQL_TOKEN_TYPE_INSERT", "insert"}, {TRACKER_SPARQL_TOKEN_TYPE_INTEGER, "TRACKER_SPARQL_TOKEN_TYPE_INTEGER", "integer"}, {TRACKER_SPARQL_TOKEN_TYPE_INTO, "TRACKER_SPARQL_TOKEN_TYPE_INTO", "into"}, {TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, "TRACKER_SPARQL_TOKEN_TYPE_IRI_REF", "iri-ref"}, {TRACKER_SPARQL_TOKEN_TYPE_ISBLANK, "TRACKER_SPARQL_TOKEN_TYPE_ISBLANK", "isblank"}, {TRACKER_SPARQL_TOKEN_TYPE_ISIRI, "TRACKER_SPARQL_TOKEN_TYPE_ISIRI", "isiri"}, {TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL, "TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL", "isliteral"}, {TRACKER_SPARQL_TOKEN_TYPE_ISURI, "TRACKER_SPARQL_TOKEN_TYPE_ISURI", "isuri"}, {TRACKER_SPARQL_TOKEN_TYPE_LANG, "TRACKER_SPARQL_TOKEN_TYPE_LANG", "lang"}, {TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES, "TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES", "langmatches"}, {TRACKER_SPARQL_TOKEN_TYPE_LCASE, "TRACKER_SPARQL_TOKEN_TYPE_LCASE", "lcase"}, {TRACKER_SPARQL_TOKEN_TYPE_LIMIT, "TRACKER_SPARQL_TOKEN_TYPE_LIMIT", "limit"}, {TRACKER_SPARQL_TOKEN_TYPE_MAX, "TRACKER_SPARQL_TOKEN_TYPE_MAX", "max"}, {TRACKER_SPARQL_TOKEN_TYPE_MD5, "TRACKER_SPARQL_TOKEN_TYPE_MD5", "md5"}, {TRACKER_SPARQL_TOKEN_TYPE_MIN, "TRACKER_SPARQL_TOKEN_TYPE_MIN", "min"}, {TRACKER_SPARQL_TOKEN_TYPE_MINUS, "TRACKER_SPARQL_TOKEN_TYPE_MINUS", "minus"}, {TRACKER_SPARQL_TOKEN_TYPE_MINUTES, "TRACKER_SPARQL_TOKEN_TYPE_MINUTES", "minutes"}, {TRACKER_SPARQL_TOKEN_TYPE_MONTH, "TRACKER_SPARQL_TOKEN_TYPE_MONTH", "month"}, {TRACKER_SPARQL_TOKEN_TYPE_NAMED, "TRACKER_SPARQL_TOKEN_TYPE_NAMED", "named"}, {TRACKER_SPARQL_TOKEN_TYPE_NOT, "TRACKER_SPARQL_TOKEN_TYPE_NOT", "not"}, {TRACKER_SPARQL_TOKEN_TYPE_NOW, "TRACKER_SPARQL_TOKEN_TYPE_NOW", "now"}, {TRACKER_SPARQL_TOKEN_TYPE_NULL, "TRACKER_SPARQL_TOKEN_TYPE_NULL", "null"}, {TRACKER_SPARQL_TOKEN_TYPE_OFFSET, "TRACKER_SPARQL_TOKEN_TYPE_OFFSET", "offset"}, {TRACKER_SPARQL_TOKEN_TYPE_OP_AND, "TRACKER_SPARQL_TOKEN_TYPE_OP_AND", "op-and"}, {TRACKER_SPARQL_TOKEN_TYPE_OP_EQ, "TRACKER_SPARQL_TOKEN_TYPE_OP_EQ", "op-eq"}, {TRACKER_SPARQL_TOKEN_TYPE_OP_GE, "TRACKER_SPARQL_TOKEN_TYPE_OP_GE", "op-ge"}, {TRACKER_SPARQL_TOKEN_TYPE_OP_GT, "TRACKER_SPARQL_TOKEN_TYPE_OP_GT", "op-gt"}, {TRACKER_SPARQL_TOKEN_TYPE_OP_LE, "TRACKER_SPARQL_TOKEN_TYPE_OP_LE", "op-le"}, {TRACKER_SPARQL_TOKEN_TYPE_OP_LT, "TRACKER_SPARQL_TOKEN_TYPE_OP_LT", "op-lt"}, {TRACKER_SPARQL_TOKEN_TYPE_OP_NE, "TRACKER_SPARQL_TOKEN_TYPE_OP_NE", "op-ne"}, {TRACKER_SPARQL_TOKEN_TYPE_OP_NEG, "TRACKER_SPARQL_TOKEN_TYPE_OP_NEG", "op-neg"}, {TRACKER_SPARQL_TOKEN_TYPE_OP_OR, "TRACKER_SPARQL_TOKEN_TYPE_OP_OR", "op-or"}, {TRACKER_SPARQL_TOKEN_TYPE_OP_IN, "TRACKER_SPARQL_TOKEN_TYPE_OP_IN", "op-in"}, {TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE, "TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE", "open-brace"}, {TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET, "TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET", "open-bracket"}, {TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, "TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS", "open-parens"}, {TRACKER_SPARQL_TOKEN_TYPE_OPTIONAL, "TRACKER_SPARQL_TOKEN_TYPE_OPTIONAL", "optional"}, {TRACKER_SPARQL_TOKEN_TYPE_OR, "TRACKER_SPARQL_TOKEN_TYPE_OR", "or"}, {TRACKER_SPARQL_TOKEN_TYPE_ORDER, "TRACKER_SPARQL_TOKEN_TYPE_ORDER", "order"}, {TRACKER_SPARQL_TOKEN_TYPE_PLUS, "TRACKER_SPARQL_TOKEN_TYPE_PLUS", "plus"}, {TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, "TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX", "pn-prefix"}, {TRACKER_SPARQL_TOKEN_TYPE_PREFIX, "TRACKER_SPARQL_TOKEN_TYPE_PREFIX", "prefix"}, {TRACKER_SPARQL_TOKEN_TYPE_RAND, "TRACKER_SPARQL_TOKEN_TYPE_RAND", "rand"}, {TRACKER_SPARQL_TOKEN_TYPE_REDUCED, "TRACKER_SPARQL_TOKEN_TYPE_REDUCED", "reduced"}, {TRACKER_SPARQL_TOKEN_TYPE_REGEX, "TRACKER_SPARQL_TOKEN_TYPE_REGEX", "regex"}, {TRACKER_SPARQL_TOKEN_TYPE_REPLACE, "TRACKER_SPARQL_TOKEN_TYPE_REPLACE", "replace"}, {TRACKER_SPARQL_TOKEN_TYPE_ROUND, "TRACKER_SPARQL_TOKEN_TYPE_ROUND", "round"}, {TRACKER_SPARQL_TOKEN_TYPE_SAMETERM, "TRACKER_SPARQL_TOKEN_TYPE_SAMETERM", "sameterm"}, {TRACKER_SPARQL_TOKEN_TYPE_SECONDS, "TRACKER_SPARQL_TOKEN_TYPE_SECONDS", "seconds"}, {TRACKER_SPARQL_TOKEN_TYPE_SELECT, "TRACKER_SPARQL_TOKEN_TYPE_SELECT", "select"}, {TRACKER_SPARQL_TOKEN_TYPE_SEMICOLON, "TRACKER_SPARQL_TOKEN_TYPE_SEMICOLON", "semicolon"}, {TRACKER_SPARQL_TOKEN_TYPE_SHA1, "TRACKER_SPARQL_TOKEN_TYPE_SHA1", "sha1"}, {TRACKER_SPARQL_TOKEN_TYPE_SHA256, "TRACKER_SPARQL_TOKEN_TYPE_SHA256", "sha256"}, {TRACKER_SPARQL_TOKEN_TYPE_SHA512, "TRACKER_SPARQL_TOKEN_TYPE_SHA512", "sha512"}, {TRACKER_SPARQL_TOKEN_TYPE_SILENT, "TRACKER_SPARQL_TOKEN_TYPE_SILENT", "silent"}, {TRACKER_SPARQL_TOKEN_TYPE_STAR, "TRACKER_SPARQL_TOKEN_TYPE_STAR", "star"}, {TRACKER_SPARQL_TOKEN_TYPE_STR, "TRACKER_SPARQL_TOKEN_TYPE_STR", "str"}, {TRACKER_SPARQL_TOKEN_TYPE_STRAFTER, "TRACKER_SPARQL_TOKEN_TYPE_STRAFTER", "strafter"}, {TRACKER_SPARQL_TOKEN_TYPE_STRBEFORE, "TRACKER_SPARQL_TOKEN_TYPE_STRBEFORE", "strbefore"}, {TRACKER_SPARQL_TOKEN_TYPE_STRENDS, "TRACKER_SPARQL_TOKEN_TYPE_STRENDS", "strends"}, {TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1, "TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1", "string-literal1"}, {TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2, "TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2", "string-literal2"}, {TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1, "TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1", "string-literal-long1"}, {TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2, "TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2", "string-literal-long2"}, {TRACKER_SPARQL_TOKEN_TYPE_STRLEN, "TRACKER_SPARQL_TOKEN_TYPE_STRLEN", "strlen"}, {TRACKER_SPARQL_TOKEN_TYPE_STRSTARTS, "TRACKER_SPARQL_TOKEN_TYPE_STRSTARTS", "strstarts"}, {TRACKER_SPARQL_TOKEN_TYPE_SUBSTR, "TRACKER_SPARQL_TOKEN_TYPE_SUBSTR", "substr"}, {TRACKER_SPARQL_TOKEN_TYPE_SUM, "TRACKER_SPARQL_TOKEN_TYPE_SUM", "sum"}, {TRACKER_SPARQL_TOKEN_TYPE_TRUE, "TRACKER_SPARQL_TOKEN_TYPE_TRUE", "true"}, {TRACKER_SPARQL_TOKEN_TYPE_UCASE, "TRACKER_SPARQL_TOKEN_TYPE_UCASE", "ucase"}, {TRACKER_SPARQL_TOKEN_TYPE_UNION, "TRACKER_SPARQL_TOKEN_TYPE_UNION", "union"}, {TRACKER_SPARQL_TOKEN_TYPE_VAR, "TRACKER_SPARQL_TOKEN_TYPE_VAR", "var"}, {TRACKER_SPARQL_TOKEN_TYPE_WHERE, "TRACKER_SPARQL_TOKEN_TYPE_WHERE", "where"}, {TRACKER_SPARQL_TOKEN_TYPE_WITH, "TRACKER_SPARQL_TOKEN_TYPE_WITH", "with"}, {TRACKER_SPARQL_TOKEN_TYPE_YEAR, "TRACKER_SPARQL_TOKEN_TYPE_YEAR", "year"}, {0, NULL, NULL}};
		GType tracker_sparql_token_type_type_id;
		tracker_sparql_token_type_type_id = g_enum_register_static ("TrackerSparqlTokenType", values);
		g_once_init_leave (&tracker_sparql_token_type_type_id__volatile, tracker_sparql_token_type_type_id);
	}
	return tracker_sparql_token_type_type_id__volatile;
}



