#ifndef TOOLBAR_H
#define TOOLBAR_H

#include <DIconButton>
#include <DPushButton>
#include <DSearchEdit>
#include <DLabel>


#include <QWidget>
#include <QLabel>

DWIDGET_USE_NAMESPACE

class ToolBar : public QWidget
{
    Q_OBJECT
public:
    explicit ToolBar(QWidget *parent = nullptr);

    QString getSearchText() {
        return this->searchEdit->text();
    }

    void enableStartBtn(bool enable) {
        this->startDownloadBtn->setEnabled(enable);
    }

    void enablePauseBtn(bool enable) {
        this->pauseDownloadBtn->setEnabled(enable);
    }

    void enableDeleteBtn(bool enable) {
        this->deleteDownloadBtn->setEnabled(enable);
    }

signals:

public slots:
    void get_table_changed(int index);
private:
    void initUI();
    void initConnections();

    DLabel *iconLable;
    DIconButton *newDownloadBtn;
    DIconButton *startDownloadBtn;
    DIconButton *stopDownloadBtn;
    DIconButton *pauseDownloadBtn;
    DIconButton *deleteDownloadBtn;
    DSearchEdit *searchEdit;
signals:
    void newDownloadBtnClicked();
    void pauseDownloadBtnClicked();
    void startDownloadBtnClicked();
    void deleteDownloadBtnClicked();
    void getSearchEditFocus(bool focus);
    void getSearchEditTextChange(QString text);


};

#endif // TOOLBAR_H
