/*
 * UosSylph -- E-Mail client library
 * Copyright (C) 2020 ~ 2021 Uniontech Software Technology Co.,Ltd.
 *
 * Author:     shuiqucheng<shuiqucheng@uniontech.com>
 *
 * Maintainer: shuiqucheng<shuiqucheng@uniontech.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "uosprocmsg.h"

GHashTable *uos_procmsg_msg_hash_table_create(GSList *mlist){
     return procmsg_msg_hash_table_create(mlist);
}

void uos_procmsg_msg_hash_table_append(GHashTable *msg_table,
                                   GSList *mlist){
    procmsg_msg_hash_table_append(msg_table,mlist);
}

GHashTable *uos_procmsg_to_folder_hash_table_create(GSList *mlist){
    return procmsg_to_folder_hash_table_create(mlist);
}

gint uos_procmsg_read_cache_data_str(FILE *fp,
                                 gchar **str){
    return procmsg_read_cache_data_str(fp,str);
}

GSList *uos_procmsg_read_cache(UosFolderItem *item,
                           gboolean scan_file){
    return procmsg_read_cache(item,scan_file);
}

void uos_procmsg_set_flags(GSList *mlist,
                       UosFolderItem *item){
    procmsg_set_flags(mlist,item);
}

void uos_procmsg_mark_all_read(UosFolderItem *item){
    procmsg_mark_all_read(item);
}

GSList *uos_procmsg_sort_msg_list(GSList *mlist,
                              UosFolderSortKey sort_key,
                                  UosFolderSortType sort_type){
    return procmsg_sort_msg_list(mlist,sort_key,sort_type);
}

gint uos_procmsg_get_last_num_in_msg_list(GSList *mlist){
    return procmsg_get_last_num_in_msg_list(mlist);
}

void uos_procmsg_msg_list_free(GSList *mlist){
    procmsg_msg_list_free(mlist);
}


void uos_procmsg_write_cache(UosMsgInfo *msginfo,
                         FILE *fp){
    procmsg_write_cache(msginfo,fp);
}

void uos_procmsg_write_flags(UosMsgInfo *msginfo,
                         FILE *fp){
    procmsg_write_flags(msginfo,fp);
}

void uos_procmsg_write_cache_list(UosFolderItem *item,
                              GSList *mlist){
    procmsg_write_cache_list(item,mlist);
}

void uos_procmsg_write_flags_list(UosFolderItem *item,
                              GSList *mlist){
    procmsg_write_flags_list(item,mlist);
}

void uos_procmsg_write_flags_for_multiple_folders(GSList *mlist){
    procmsg_write_flags_for_multiple_folders(mlist);
}

void uos_procmsg_flaginfo_list_free(GSList *flaglist){
    procmsg_flaginfo_list_free(flaglist);
}

void uos_procmsg_flush_mark_queue(UosFolderItem *item,
                              FILE *fp){
    procmsg_flush_mark_queue(item,fp);
}

void uos_procmsg_add_mark_queue(UosFolderItem *item,
                            gint num,
                            MsgFlags flags){
    procmsg_add_mark_queue(item,num,flags);
}

void uos_procmsg_flush_cache_queue(UosFolderItem *item,
                               FILE *fp){
    procmsg_flush_cache_queue(item,fp);
}

void uos_procmsg_add_cache_queue(UosFolderItem *item,
                             gint num,
                             MsgInfo *msginfo){
    procmsg_add_cache_queue(item,num,msginfo);
}

gboolean uos_procmsg_flush_folder(UosFolderItem *item){
    return procmsg_flush_folder(item);
}

void uos_procmsg_flush_folder_foreach(GHashTable *folder_table){
    procmsg_flush_folder_foreach(folder_table);
}


void uos_procmsg_add_flags(UosFolderItem *item,
                       gint num,
                       UosMsgFlags flags){
    procmsg_add_flags(item,num,flags);
}


void uos_procmsg_get_mark_sum(UosFolderItem *item,
                          gint *new1,
                          gint *unread,
                          gint *total,
                          gint *min,
                          gint *max,
                          gint first){
    procmsg_get_mark_sum(item,new1,unread,total,min,max,first);
}


FILE *uos_procmsg_open_data_file(const gchar *file,
                             guint version,
                             UosDataOpenMode mode,
                             gchar *buf,
                             size_t buf_size){
    return procmsg_open_data_file(file,version,mode,buf,buf_size);
}


FILE *uos_procmsg_open_cache_file(UosFolderItem *item,
                              UosDataOpenMode mode){
    return procmsg_open_cache_file(item,mode);
}

FILE *uos_procmsg_open_mark_file(UosFolderItem *item,
                             UosDataOpenMode mode){
    return procmsg_open_mark_file(item,mode);
}


void uos_procmsg_clear_cache(UosFolderItem *item){
    procmsg_clear_cache(item);
}

void uos_procmsg_clear_mark(UosFolderItem *item){
    procmsg_clear_mark(item);
}

GNode *uos_procmsg_get_thread_tree(GSList *mlist){
    return procmsg_get_thread_tree(mlist);
}

guint uos_procmsg_get_thread_date(GNode *node){
    return procmsg_get_thread_date(node);
}


gint uos_procmsg_move_messages(GSList *mlist, gboolean bcachepool){
    return procmsg_move_messages(mlist, bcachepool);
}

gint uos_procmsg_copy_messages(GSList *mlist){
    return procmsg_copy_messages(mlist);
}

gint uos_procmsg_add_messages_from_queue(UosFolderItem *dest,
                                     GSList *mlist,
                                     gboolean is_move){
    return procmsg_add_messages_from_queue(dest,mlist,is_move);
}

gchar *uos_procmsg_get_message_file_path(UosMsgInfo *msginfo){
    return procmsg_get_message_file_path(msginfo);
}

gchar *uos_procmsg_get_message_file(UosMsgInfo *msginfo){
    return procmsg_get_message_file(msginfo);
}

GSList *uos_procmsg_get_message_file_list(GSList *mlist){
    return procmsg_get_message_file_list(mlist);
}

void uos_procmsg_message_file_list_free(GSList *file_list){
    procmsg_message_file_list_free(file_list);
}

FILE *uos_procmsg_open_message(UosMsgInfo *msginfo){
    return procmsg_open_message(msginfo);
}

void uos_procmsg_set_decrypt_message_func(UosDecryptMessageFunc func){
    procmsg_set_decrypt_message_func(func);
}

void uos_procmsg_set_auto_decrypt_message(gboolean enabled){
    procmsg_set_auto_decrypt_message(enabled);
}

FILE *uos_procmsg_open_message_decrypted(UosMsgInfo *msginfo,
                                     UosMimeInfo **mimeinfo){
    return procmsg_open_message_decrypted(msginfo,mimeinfo);
}

gboolean uos_procmsg_msg_exist(UosMsgInfo *msginfo){
    return procmsg_msg_exist(msginfo);
}

gboolean uos_procmsg_trash_messages_exist(void){
    return procmsg_trash_messages_exist();
}

void uos_procmsg_empty_trash(UosFolderItem *trash){
    procmsg_empty_trash(trash);
}

void uos_procmsg_empty_all_trash(void){
    procmsg_empty_all_trash();
}

void uos_procmsg_remove_all_cached_messages(UosFolder *folder){
    procmsg_remove_all_cached_messages(folder);
}

gint uos_procmsg_save_to_outbox(UosFolderItem *outbox,
                            const gchar *file){
    return procmsg_save_to_outbox(outbox,file);
}

void uos_procmsg_print_message(UosMsgInfo *msginfo,
                           const gchar *cmdline,
                           gboolean all_headers){
    procmsg_print_message(msginfo,cmdline,all_headers);
}

void uos_procmsg_print_message_part(UosMsgInfo *msginfo,
                                UosMimeInfo *partinfo,
                                const gchar *cmdline,
                                gboolean all_headers){
    procmsg_print_message_part(msginfo,partinfo,cmdline,all_headers);
}


gint uos_procmsg_save_message_as_text(UosMsgInfo *msginfo,
                                  const gchar *dest,
                                  const gchar *encoding,
                                  gboolean all_headers){
    return procmsg_save_message_as_text(msginfo,dest,encoding,all_headers);
}


gint uos_procmsg_concat_partial_messages(GSList *mlist,
                                     const gchar *file){
    return procmsg_concat_partial_messages(mlist,file);
}


UosMsgInfo *uos_procmsg_get_msginfo(UosFolderItem *item,
                             gint num){
    return procmsg_get_msginfo(item,num);
}

UosMsgInfo *uos_procmsg_msginfo_copy(UosMsgInfo *msginfo){
    return procmsg_msginfo_copy(msginfo);
}

UosMsgInfo *uos_procmsg_msginfo_get_full_info(UosMsgInfo *msginfo){
    return procmsg_msginfo_get_full_info(msginfo);
}

gboolean uos_procmsg_msginfo_equal(UosMsgInfo *msginfo_a,
                               UosMsgInfo *msginfo_b){
    return procmsg_msginfo_equal(msginfo_a,msginfo_b);
}

void uos_procmsg_msginfo_free(UosMsgInfo *msginfo){
    if(msginfo)
        procmsg_msginfo_free(msginfo);
}

gint uos_procmsg_cmp_msgnum_for_sort(gconstpointer a,
                                 gconstpointer b){
    return procmsg_cmp_msgnum_for_sort(a,b);
}

//读取备份文件新增的函数
GSList *uos_procmsg_read_backup_cache(UosFolderItem *item, gboolean scanfile){
    return procmsg_read_backup_cache(item, scanfile);
}

//写入备份文件
FILE *uos_procmsg_open_backup_file(UosFolderItem *item, guint version, UosDataOpenMode mode, int backup_type){
    return procmsg_open_backup_file(item, version, mode, backup_type);
}

//读取并设置备份数据的标记信息
void uos_procmsg_set_backup_flags(GSList *mlist, UosFolderItem *item){
    procmsg_set_backup_flags(mlist, item);
}


//写入备份文件操作
void uos_procmsg_write_backup_cache(UosMsgInfo *msginfo, FILE *fp){
    procmsg_write_backup_cache(msginfo, fp);
}

void uos_procmsg_write_backup_flags(UosMsgInfo *msginfo, FILE *fp){
    procmsg_write_backup_flags(msginfo, fp);
}

//多线程文件读写锁
void uos_cache_file_thread_mutext_trylock()
{
    cache_file_thread_mutext_trylock();
}

void uos_cache_file_thread_mutext_unlock()
{
    cache_file_thread_mutext_unlock();
}

void uos_mark_file_thread_mutext_trylock()
{
    mark_file_thread_mutext_trylock();
}

void uos_mark_file_thread_mutext_unlock()
{
    mark_file_thread_mutext_unlock();
}

void uos_file_thread_mutext_destroy()
{
    cache_file_thread_mutext_destroy();

    mark_file_thread_mutext_destroy();
}

