/*
 * UosSylph -- E-Mail client library
 * Copyright (C) 2020 ~ 2021 Uniontech Software Technology Co.,Ltd.
 *
 * Author:     shuiqucheng<shuiqucheng@uniontech.com>
 *
 * Maintainer: shuiqucheng<shuiqucheng@uniontech.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __UOSSESSION_H__
#define __UOSSESSION_H__

#include "libsylph/session.h"

#include "uossocket.h"
#include "uossocks.h"
#include "uosutils.h"

#define UOSSESSION_BUFFSIZE SESSION_BUFFSIZE

typedef Session UosSession;

#define UOSSESSION(obj) SESSION(obj)

typedef SessionType UosSessionType;
#define UosSESSION_UNKNOWN SESSION_UNKNOWN
#define UosSESSION_IMAP SESSION_IMAP
#define UosSESSION_NEWS SESSION_NEWS
#define UosSESSION_SMTP SESSION_SMTP
#define UosSESSION_POP3 SESSION_POP3

typedef SessionState UosSessionState;
#define UosSESSION_READY SESSION_READY
#define UosSESSION_SEND SESSION_SEND
#define UosSESSION_RECV SESSION_RECV
#define UosSESSION_EOF SESSION_EOF
#define UosSESSION_TIMEOUT SESSION_TIMEOUT
#define UosSESSION_ERROR SESSION_ERROR
#define UosSESSION_DISCONNECTED SESSION_DISCONNECTED

typedef SessionMsgType UosSessionMsgType;
#define UosSESSION_MSG_NORMAL SESSION_MSG_NORMAL
#define UosSESSION_MSG_SEND_DATA SESSION_MSG_SEND_DATA
#define UosSESSION_MSG_RECV_DATA SESSION_MSG_RECV_DATA
#define UosSESSION_MSG_CONTROL SESSION_MSG_CONTROL
#define UosSESSION_MSG_ERROR SESSION_MSG_ERROR
#define UosSESSION_MSG_UNKNOWN SESSION_MSG_UNKNOWN

#ifndef USE_SSL
typedef SSLType UosSSLType;
#define UosSSL_NONE SSL_NONE
#endif

typedef SessionErrorValue UosSessionErrorValue;
#define UosSESSION_ERROR_OK SESSION_ERROR_OK
#define UosSESSION_ERROR_LOOKUP SESSION_ERROR_LOOKUP
#define UosSESSION_ERROR_CONNFAIL SESSION_ERROR_CONNFAIL
#define UosSESSION_ERROR_IO SESSION_ERROR_IO
#define UosSESSION_ERROR_SOCKET SESSION_ERROR_SOCKET
#define UosSESSION_ERROR_TIMEOUT SESSION_ERROR_TIMEOUT
#define UosSESSION_ERROR_ERROR SESSION_ERROR_ERROR
typedef RecvMsgNotify UosRecvMsgNotify;

typedef RecvDataProgressiveNotify UosRecvDataProgressiveNotify;

typedef RecvDataNotify UosRecvDataNotify;

typedef SendDataProgressiveNotify UosSendDataProgressiveNotify;

typedef SendDataNotify UosSendDataNotify;

void uos_session_init(UosSession *session);
gint uos_session_connect(UosSession *session,
                     const gchar *server,
                     gushort port);
gint uos_session_connect_full(UosSession *session,
                          const gchar *server,
                          gushort port,
                          UosSocksInfo *socks_info);
gint uos_session_disconnect(UosSession *session);
void uos_session_destroy(UosSession *session);
gboolean uos_session_is_connected(UosSession *session);

UosSessionErrorValue uos_session_get_error(UosSession *session);

void uos_session_set_access_time(UosSession *session);

void uos_session_set_timeout(UosSession *session,
                         guint interval);

void uos_session_set_recv_message_notify(UosSession *session,
                                     UosRecvMsgNotify notify_func,
                                     gpointer data);
void uos_session_set_recv_data_progressive_notify(UosSession *session,
                                              UosRecvDataProgressiveNotify notify_func,
                                              gpointer data);
void uos_session_set_recv_data_notify(UosSession *session,
                                  UosRecvDataNotify notify_func,
                                  gpointer data);
void uos_session_set_send_data_progressive_notify(UosSession *session,
                                              UosSendDataProgressiveNotify notify_func,
                                              gpointer data);
void uos_session_set_send_data_notify(UosSession *session,
                                  UosSendDataNotify notify_func,
                                  gpointer data);

#if USE_SSL
gint uos_session_start_tls(UosSession *session);
#endif

gint uos_session_send_msg(UosSession *session,
                      UosSessionMsgType type,
                      const gchar *msg);
gint uos_session_recv_msg(UosSession *session);
gint uos_session_send_data(UosSession *session,
                       FILE *data_fp,
                       guint size);
gint uos_session_recv_data(UosSession *session,
                       guint size,
                       const gchar *terminator);

gint uos_session_recv_data_as_file(UosSession *session,
                               guint size,
                               const gchar *terminator);

#endif /* __UOSSESSION_H__ */
