/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-130
 */ 

#ifndef VDKCURSOR_H
#define VDKCURSOR_H
// all cursor types defined in
// gdk/gdkcursors.h
#include <vdk/vdkobj.h>
class VDKCursor : public VDKObject
{
 
 public:
  VDKCursor(VDKObject *obj, GdkCursorType curType = GDK_LEFT_PTR):
    VDKObject(obj->Owner())
    {
      GdkCursor *cursor;
      obj->AddItem(this);
      cursor = gdk_cursor_new (curType);
      gdk_window_set_cursor (obj->Widget()->window, cursor);
      gdk_cursor_destroy (cursor);
    }
  ~VDKCursor() 
    {
    }
};
#endif
