/*
 * Copyright (c) 1997 by Procom Technology,Inc.
 *
 * This program can be redistributed or modified under the terms of the 
 * GNU General Public License as published by the Free Software Foundation.
 * This program is distributed without any warranty or implied warranty
 * of merchantability or fitness for a particular purpose.
 *
 * See the GNU General Public License for more details.
 *
 */
 
/* 
 * Definition of the interface to the buffer table manager 
 */

#ifndef CM_BP_H
#define CM_BP_H


typedef struct
{                              
   us32        buffer_size;        /* same size for all buffers */
   us32        number_buffers;     /* number of buffers to manage */
   us8 **      table;              /* table of pointers to indiv buffers */
   us8 *       start_memory;       /* start of memory containing buffers */
} buffer_pool_t;


#ifndef CM_BP_C
#define EXTRN extern
#else
#define EXTRN
#endif /* CM_BP_C */


EXTRN us16         bp_create (mph_t memory_pool_handle, us32 buffer_size,
                               us32 how_many_buffers, buffer_pool_t ** bt);
EXTRN us16         bp_alloc (buffer_pool_t * tbl, us8 ** buffer_allocated);
EXTRN us16         bp_free (buffer_pool_t * tbl, us8 * buffer_to_free);

#ifdef DBG

EXTRN us16         bp_inquire (buffer_pool_t * tbl);

#endif
                   

#undef EXTRN
#endif /* CM_BP_H */
