/*
 *
 *  Copyright (C) 1999-2001 Silicon Graphics, Inc.
 *
 *  Written by John Hawkes (hawkes@sgi.com)
 *  Based on lockstat.c by Jack Steiner (steiner@sgi.com)
 *
 *  Modifications by Ray Bryant (raybry@us.ibm.com) Feb-Mar 2000
 *  Changes Copyright (C) 2000 IBM, Inc.
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

static char lockstat_version[]  = "1.4.10";

#include "lockstat.h"

#include <linux/config.h>
#include <linux/utsname.h>
#include <sys/types.h>
#include <fcntl.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/time.h>
#include <linux/lockmeter.h>

extern void	closeFiles(void);
extern void	getKernelData(lstat_user_request_t **, lstat_cpu_counts_t **,
			      lstat_directory_entry_t **,
			      lstat_read_lock_cpu_counts_t **, int);
extern int	isProcFile(void);
extern void	XlateAddressToSymbol(void *, char *);
extern int	openKernelData(char *);
extern int	openMapFile(char *);
extern void	setCollectionState(int);
extern void	setMirrorOutFilename(char *);
extern char *	strSpace(void);

#ifdef TIMER
extern void cycletrace(char*);
#define TSTAMP(s)	cycletrace(s);
#else
#define TSTAMP(s)
#endif

#define DEBUGBUG

#define TRUE 1
#define FALSE 0

/* this program only reads version 5 lockstat data */
#define THIS_VERSION 5

char *helpstr[] = {
"Name"
"       lockstat - display kernel lock statistics",
"",
"SYNOPSIS",
"       lockstat [options] on/off/get/print/off+print/reset/release/query",
"",
"DESCRIPTION",
"       When run with a Lockmeter-enabled kernel, this command will display",
"       (or save for later display) statistics about the kernel locks that",
"       are being used.",
"",
"   lockstat on     turn ON the Lockmeter data gathering.",
"                   The first time this happens, the kernel also allocates the",
"                   storage required for its Lockmeter data structures.",
"   lockstat off    turn OFF the Lockmeter data gathering.",
"                   Each time data gathering is turned ON and OFF, a count",
"                   of the number of measurement intervals is incremented and",
"                   the total stats enabled time is updated.",
"                   Use 'lockstat reset' to reset counts and data to 0.",
"   lockstat get    fetch the Lockmeter data and writes it to lockstat.tmp,",
"                   or to the filename specified by the -T option (see below).",
"   lockstat print  fetch the Lockmeter data, then generate and print a report.",
"                   If neither -X nor -P is specified, then Lockmeter data",
"                   gathering must either be currently ON, or else the number of",
"                   stored Lockmeter measurement intervals must be > 0.",
"                   -X and -P cause data gathering to be turned ON (if not",
"                   already ON), and then to be turned OFF at the end of the",
"                   measurement run.  See -X and -P options below for details.",
"   lockstat off+print same as 'lockstat off' followed by 'lockstat print'.",
"   lockstat reset  reset the kernel's Lockmeter data to zero.  Otherwise, data",
"                   recorded by the next 'lockstat on' is accumulative.",
"   lockstat release  tell the kernel to release storage used to record",
"                   Lockmeter data.  Typically only used when you are done with",
"                   measurement.  In the default configuration these structures",
"                   occupy approximately 300 KB of kernel storage per processor.",
"   lockstat query  return the current state of data collection and whether or",
"                   not data is available to be 'print'ed or 'get'ed.",
"                   Each 'lockstat on';'lockstat off' pair increments an", 
"                   interval counter in the Lockmeter data.",
"                   Any time data gathering is turned ON, or when the number of",
"                   intervals is >0, you can print all the data thus far",
"                   recorded using 'lockstat print'.",
"",
"OPTIONS",
"   -m mapfile      Location of map file(s) to use for symbol table.  If not",
"                   specified, defaults to /usr/src/linux/System.map.",
"   -L file         Get the Lockmeter data from file 'file'.  If unspecified,",
"                   then the default is /proc/lockmeter.",
"                   Typically, a named disk file was previously produced",
"                   by using the -T option.  Only the 'print' keyword is allowed",
"                   if this file is specified and is not /proc/lockmeter.",
"   -T file         Used with the 'get' directive to specify a file into which",
"                   the collected data is stored.  If unspecified, defaults to",
"                   'lockstat.tmp'.  Data can later be read using the -L option.",
"   -X 'commandargs'  Run the command with the specified args and collect",
"                   Lockmeter data while the command runs.  Print a report after",
"                   the command terminates if the 'print' keyword is given,",
"                   or save the data where the -T option specifies if the 'get'",
"                   keyword is given.  Only the 'print' or 'get' keywords can be",
"                   specified with -X.",
"                   The single quotes around commandandargs are REQUIRED if",
"                   the commandandargs string contains any blanks.",
"                   If statistics are not ON, they are turned ON before the",
"                   command is executed, then back OFF after the command",
"                   terminates.  Otherwise, the current statistics collection",
"                   state is unchanged.",
"                   The -P option is not allowed with the -X option.",
"   -i string       String to print as part of the title for the report.",
"   -c cpu          By default, the statistics for all cpus are summed",
"                   together.  If \"-c a\", then the full summation report is",
"                   printed, as well as a separate report for each cpu in the",
"                   system.  Otherwise, 'cpu' identifies a specific cpu,",
"                   numbered from zero to N, and a report is generated for",
"                   just that cpu.",
"   -C              Report lock requests-per-second instead of lock utilization.",
"   -t              <Now the default!> 'lockstat -t' is equivalent to",
"                   'lockstat print'.  Prints 'total' statistics.",
"   -P sec          Report periodic statistics every 'sec' seconds.",
"                   Print the report if the 'print' keyword is specified, or save",
"                   the data where the -T option specifies if also using the",
"                   'get' keyword.  Only the 'print' or 'get' keywords can be",
"                   specified with -P, and not the -X option.",
"                   If data gathering is not ON, then it is turned ON for the",
"                   duration of the periodic report and thereafter turned back",
"                   OFF after the end of the report.  Otherwise, the current",
"                   statistics collection state remains unchanged.",
"                   The -P option is ignored if data is being read from a file",
"                   (using -L).",
"                   If multiple data gathering intervals have already been",
"                   generated and saved, then the saved data must be reset (via",
"                   'lockstat reset') before a periodic report can be started.",
"   -R count        repeat the periodic statistics report count times.",
"                   If -R is not used, 'count' defaults to 10.",
"                   The -R option is allowed with the -L option to read the",
"                   results of a periodic report that was saved in a file using",
"                   the 'get' keyword.",
#ifdef notyet
"   -S              Show semaphore information.  This is not selected by default",
"                   because I am not sure it is useful.",
#endif
" ",
"   The following options control which locks are described in the report:",
"",
"   -p persec       Report only on locks set more than 'persec' times per",
"                   second.",
"   -k percent      Report locks with more than 'percent' contention.",
"   -w              Report on \"warm\" or \"hot\" locks only, i.e., on all",
"                   locks that exhibit any contention.",
"                   This option is the same as -p 0 -k 0.",
"   -h              Report on \"hot\" locks only, which are defined as if",
"                   you specified '-p 100 -k 5'",
"   -u percent      Report locks with more than 'percent' utilization.",
"   -O              Default behavior is to report on locks that meet all of the",
"                   specified conditions.  Specify the -O flag to get a report",
"                   for locks that meet any ONE of the specified conditions.",
"   -v              Display the lockstat version.",
"",
"REPORT",
"       The report is divided into several sections:",
"               SPINLOCKS      Stats for simple spinlock_t spinlocks",
#ifdef notyet
"               MRLOCKS",
#endif
"               RWLOCK READS   Stats for READ  locks on rwlock_t spinlocks.",
"               RWLOCK WRITES  Stats for WRITE locks on rwlock_t spinlocks.",
#ifdef notyet
"               SEMAPHORES (if -S is selected)",
#endif
"",
"       The following data is collected for each lock:",
"",
"       TOT/SEC Number of times per second that the lock was set.",
"       UTIL    % of time that the lock was busy during the measurement.",
"               (Only one of the above two is printed.  The -C flag selects",
"               which one is printed.  The default is to print UTIL.)",
"       CON     Amount of contention that occurred for the lock.  The ",
"               number represents the percent of time that lock was NOT",
"               acquired without spinning or sleeping.",
#ifdef notyet
"               Note: for semaphores, the number represents the % of",
"               the time psema slept.",
#endif
"       HOLD    Mean and max lock hold times, in microseconds (us) or",
"               milliseconds (ms), and the percentage of total CPU cycles",
"               consumed by the waiting.",
"               This is reported per caller for spin locks and",
"               for write mode locks on rwlocks.  It is reported",
"               over all callers for read mode locks on rwlocks.",
"       MAXRDR  Maximum number of readers for a rwlock.",
"       RDR BUSY PERIOD Length (in microseconds) of 'reader busy' periods",
"               for a rwlock.  A reader busy period starts when the first",
"               reader lock is set and ends when the last reader releases the",
"               lock.  This statistic is reported over all read lock callers",
"               on a rwlock (not on a per caller basis).",
"       WAIT    Mean spin-wait wait time, in microseconds.",
"       WAIT WW For write locks, we also report wait time that a",
"               a writer waited for a writer holding the lock.",
"       TOTAL   Total number of times that the lock was set.",
"       NOWAIT  Percentage of times the lock was acquired without waiting",
"       SPIN    Percentage of times it was necessary to spin waiting for",
"               a spinlock.",
"       SPIN WW Percentage of times a writer could not get a rwlock because",
"               another writer was holding the lock.",
#ifdef notyet
"       SLEEP   Number of times it was necessary to sleep for a lock",
#endif
"       RJECT   Percentage of times a \"trylock\" failed.",
"       NAME    Identifies the lock and/or the routine that set the lock.",
"               If the lock is statically defined and not part of an array,",
"               both the lock name and the functions that set the ",
"               lock are listed.  If the lock is dynamically allocated,",
"               only the function name that set the lock will be listed.",
"               If spin lock code at a particular address sets more than one",
"               lock (e. g. if a procedure sets a spin lock in an argument)",
"               then stats for all such locks are combined and reported by",
"               calling address (procedure and offset) only.  No lock name",
"               or address is given in that case.",
"",
NULL};

char   env_var[] = "LOCKSTAT";
char   env_val[] = "V2";
static char defaultGetFilename[]  = "lockstat.tmp";
int dataFile;

static char defaultMapFilename[]  = "/usr/src/linux/System.map";

#define MAXCPUS			512

#define perrorx(s)		{if (errno != 0) perror(s); else fprintf(stderr,"%s:%s\n",progname,s); exit(1);}
#define fatalx(m)		fprintf(stderr, "%s: ERROR - %s\n", progname, m), exit(1)
#define min(a,b)		(((a)>(b)) ? (b) : (a))
#define max(a,b)		(((a)<(b)) ? (b) : (a))


typedef enum	{Buf_Previous, Buf_Current} get_data_buffer_enum ;
typedef enum	{Null_Entry, Spin_Entry, RLspin_Entry, WLspin_Entry, Sema_Entry} entry_type_enum;

typedef struct {
	lstat_lock_counts_t  counts;
	uint32_t	total;
	double		contention;
	double		persec;
	double          utilization;
	void		*lock_ptr;
} lock_summary_t;
	
typedef struct {
	void		*caller_ra;
	char		*caller_name;
	char		*lock_name;
	char		multilock;
	char		title_index;
	char		caller_name_len;
	entry_type_enum	entry_type;
} directory_entry_t;

directory_entry_t	directory[LSTAT_MAX_STAT_INDEX];
int			next_free_dir_index;
lstat_read_lock_counts_t read_lock_counts[LSTAT_MAX_READ_LOCK_INDEX];
#ifdef DEBUGBUG
int         read_lock_entry_used[LSTAT_MAX_READ_LOCK_INDEX]={LSTAT_MAX_READ_LOCK_INDEX * 0};
#endif
int         next_free_read_lock_index;                              

int directory_overflows=0, read_lock_overflows=0;

lstat_directory_entry_t	*kernel_directory;
lstat_directory_entry_t	*prev_kernel_directory;

lstat_cpu_counts_t	*kernel_counts;
lstat_cpu_counts_t	*prev_counts;

lstat_read_lock_cpu_counts_t *kernel_read_lock_counts;                      
lstat_read_lock_cpu_counts_t *prev_read_lock_counts;                        

lstat_lock_counts_t	total_counts[LSTAT_MAX_STAT_INDEX]; 
lstat_read_lock_counts_t rwlock_counts[LSTAT_MAX_READ_LOCK_INDEX]; 
lstat_user_request_t kernel_request, prev_request;

/* the maximum number of readers possible is the number of cpus, but sometimes a cpu may lock a */
/* read lock more than once, so, give the kernel some room for error. ......................... */
#define ABSURD_MAX_COUNT (10*numcpus)
int read_lock_increment[LSTAT_MAX_READ_LOCK_INDEX];
int prev_read_lock_increment[LSTAT_MAX_READ_LOCK_INDEX];

short			sorti[LSTAT_MAX_STAT_INDEX+2];

int			numcpus = 0;
int			state, valid;
float			cycles_per_usec;
#ifdef notyet
void			*kernel_magic_addr;
void			*kernel_end_addr;
#endif
time_t			first_start_time, start_time, end_time;
double          	deltatime;
int			skipline = 0, multiflag = 0;
char			*current_header, *last_header, *current_dashes;

struct new_utsname uts;
int period=0, count=10;
int keyword_valid = 0;
int turned_on_this_time=0;

unsigned long long    started_cycles64, ending_cycles64, enabled_cycles64;
int         intervals;

char	*dashes[] = {
    "- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -\n",
    "- - - - - - - - - - - -  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -\n",
    "- - - - - - - - - - -  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -\n"
	""};

/* these titles are used if the -C option is specified */
char	*special_titlesC[] = {
	"SPINLOCKS         HOLD            WAIT\n"
	"TOT/SEC CON    MEAN(  MAX )   MEAN(  MAX )(% CPU)     TOTAL NOWAIT SPIN RJECT  NAME",
	"RWLOCK READS   HOLD    MAX  RDR BUSY PERIOD      WAIT\n"
    "TOT/SEC CON    MEAN   RDRS   MEAN(  MAX )   MEAN(  MAX )( %CPU)     TOTAL NOWAIT SPIN  NAME",
	"RWLOCK WRITES     HOLD           WAIT (ALL)           WAIT (WW) \n"
    "TOT/SEC CON    MEAN(  MAX )   MEAN(  MAX )( %CPU)   MEAN(  MAX )     TOTAL NOWAIT SPIN(  WW )  NAME",
	"SEMAPHORES  \n  TOT/SEC  CON         TOTAL      NOWAIT       SPIN    SLEEP  NAME",
	""};

/* these titles are used if the -C option is NOT specified */
char	*special_titlesU[] = {
	"SPINLOCKS         HOLD            WAIT\n"
	"  UTIL  CON    MEAN(  MAX )   MEAN(  MAX )(% CPU)     TOTAL NOWAIT SPIN RJECT  NAME",
	"RWLOCK READS   HOLD    MAX  RDR BUSY PERIOD      WAIT\n"
    "  UTIL  CON    MEAN   RDRS   MEAN(  MAX )   MEAN(  MAX )( %CPU)     TOTAL NOWAIT SPIN  NAME",
	"RWLOCK WRITES     HOLD           WAIT (ALL)           WAIT (WW) \n"
    "  UTIL  CON    MEAN(  MAX )   MEAN(  MAX )( %CPU)   MEAN(  MAX )     TOTAL NOWAIT SPIN(  WW )  NAME",
	"SEMAPHORES  \n    UTIL    CON         TOTAL      NOWAIT       SPIN    SLEEP  NAME",
	""};
char **special_titles;

void	do_report(char *, int);
void	print_stats(char *, char *);
void	set_header(char *,char *);
void	reset_counts(lock_summary_t *);
void	add_counts(lock_summary_t *, lstat_lock_counts_t *);
int	sum_counts(lock_summary_t *, entry_type_enum);
int	set_counts(lock_summary_t *, lstat_lock_counts_t *, entry_type_enum);
void	do_help(void);
void	print_header(void);
void	print_title(char *, char *);
void	print_lock(char *, lock_summary_t *, int, entry_type_enum);
void	print_percentage(char, double, char);
void	print_time(double);
void	get_collection_state(int);
void	get_kernel_data(get_data_buffer_enum,int);
void	build_sort_directory(void);
int	sortcmp(const void *, const void *);
void	sum_data (int, int);
int	read_diff_file(void);
void	write_diff_file(void);
int     write_tmp=0;

char    *command;
char    *progname;
extern int	optind, opterr, errno;
extern char	*optarg;

int	semaopt = 0, topt = 0, Popt=0, Ropt=0, Xopt=0, Lopt=0, Copt=0, debugopt = 0, opt_debug = 0;
int Oopt = 0;
double	opt_contention = -1.0, opt_persec = -1.0, opt_utilization=-1.0;
char	*debugname=NULL;

char	*ident = 0;

char    *tmpFilename=defaultGetFilename;
char	*dataFilename;
char	*mapFilename;

char	cpulist[MAXCPUS];

int
main(int argc, char **argv)
{
#ifdef notyet
	static char	optstr[] = "Swdhvk:l:L:Op:tCc:i:m:D:P:R:T:u:X:";
#endif
	static char	optstr[] = "wdhvk:l:L:Op:tCc:i:m:D:P:R:T:u:X:";
	int		c, err = 0;
	int		args, cpunum;
	char		title[120];
	int     tmpargc;
	char    **tmpargv;

	dataFilename = defaultDataFilename;
	mapFilename  = NULL;

	progname = (char *) malloc(strlen(argv[0])+1);
	strcpy(progname, argv[0]);

	/* we make -t the default now */
	topt = 1;
	/* -P is used to specify a periodic report */

	/* special case help */
	if ((argc==1) || ((argc==2) && (!strcmp(argv[1],"--help")))) {
		do_help();
		return(0);
	}

	special_titles = special_titlesU;
	while ((c = getopt(argc, argv, optstr)) != EOF)
		switch (c) {
		case 'D':
			debugopt = 1;
			debugname = optarg;
			break;
		case 'c':
			if ((optarg == NULL) || (*optarg == '-')) {
				fprintf(stderr,"%s: Value(s) missing for -c option\n",progname);
				exit(0);
			}
			if (*optarg == 'a') {
				for (cpunum = 0; cpunum< MAXCPUS; cpunum++)
					cpulist[cpunum]++;
			} else {
				cpunum = atoi(optarg);
				if (cpunum < 0 || cpunum >= MAXCPUS)
					fatalx("invalid cpu number specified");
				cpulist[cpunum]++;
			}
			break;
		case 'C':
			Copt = 1;
			special_titles = special_titlesC;
			break;
		case 'd':
			opt_debug = 1;
			break;
		case 'w':
			opt_persec = 0.0;
			opt_contention = 0.00;
			opt_utilization = 0.0;
			break;
		case 'h':
			opt_persec = 100.0;
			opt_contention = 5.0;
			opt_utilization = 50.0;
			break;
		case 'p':
			sscanf(optarg,"%lg",&opt_persec);
			break;
		case 'k':
			if ((optarg == NULL) || (*optarg == '-')) {
				fprintf(stderr,"%s: Value missing for -k option\n",progname);
				exit(0);
			}
			sscanf(optarg,"%lg",&opt_contention);
			break;
		case 'u':
			if ((optarg == NULL) || (*optarg == '-')) {
				fprintf(stderr,"%s: Value missing for -u option\n",progname);
				exit(0);
			}
			sscanf(optarg,"%lg",&opt_utilization);
			break;
		case 'i':
			if ((optarg == NULL) || (*optarg == '-')) {
				fprintf(stderr,"%s: Value missing for -i option\n",progname);
				exit(0);
			}
			ident = optarg;
			break;
		case 'l':
		case 'L':
			if ((optarg == NULL) || (*optarg == '-')) {
				fprintf(stderr,"%s: File name missing for -L option\n",progname);
				exit(0);
			}
			Lopt = 1;
			dataFilename = optarg;
			break;
#ifdef notyet
		case 'S':
			semaopt++;
			break;
#endif
		case 't':
			topt++;
			break;
		case 'T':
			write_tmp++;
			if ((optarg == NULL) || (*optarg == '-')) {
				fprintf(stderr,"%s: File name missing for -T option\n",progname);
				exit(0);
			}
			tmpFilename = optarg;
			setMirrorOutFilename(tmpFilename);
			break;
		case 'm':
			if ((optarg == NULL) || (*optarg == '-')) {
				fprintf(stderr,"%s: File name missing for -m option\n",progname);
				exit(0);
			}
			mapFilename = optarg;	/* remember we've seen -m */
			if (!openMapFile(optarg)) {
				fprintf(stderr,"%s: Cannot open mapfile '%s'\n",
					progname, optarg);
				exit(1);
			}
			break;
		case 'P':
			if ((optarg == NULL) || (*optarg == '-')) {
				fprintf(stderr,"%s: Value missing for -P option\n",progname);
				exit(0);
			}
			Popt = 1;
			period = atoi(optarg);
			break;
		case 'R':
			if ((optarg == NULL) || (*optarg == '-')) {
				fprintf(stderr,"%s: Count missing for -R option\n",progname);
				exit(0);
			}
			Ropt = 1;
			count = atoi(optarg);
			break;
		case 'O':
			/* set flag to report on locks that meet any ONE of the conditions...  */
			Oopt = 1;
			/* update defaults so an OR of the conditions doesn't print every lock */
			/* have to do the if test to handle the case where -O is encountered   */
			/* after an option that specified a value for the indicated parameter..*/
			if (opt_utilization < 0) opt_utilization = 200.00;
			if (opt_persec < 0)      opt_persec      = 1000000000.0;
			if (opt_contention < 0)  opt_contention  = 200.00;
			break;
		case 'v':
			printf("lockstat version %s\n", lockstat_version);
			exit(1);
		case 'X':
			if ((optarg == NULL) || (*optarg == '-')) {
				fprintf(stderr,"%s: Command missing for -X option\n",progname);
				exit(0);
			}
			Xopt = 1;
			command = optarg;
			break;
		case '?':
			err = 1;
			break;
		}

	if (Popt && !Ropt && !Lopt) 
		fprintf(stderr, "%s: -P option but no -R option; count defaults to %d\n",progname,count);

	dataFile = openKernelData(dataFilename);
	if (dataFile == -1)
		{
			perror(dataFilename);
			exit(1);
		}

	TSTAMP("start");
	if (debugopt && read_diff_file())
		debugopt = 2;
	else
		get_collection_state(0);

	TSTAMP("inited");
	args = argc - optind;
	if (err || args < 0)
		fatalx("invalid arguments specified");

	if (!args) {
		fprintf(stderr,"%s: A keyword argument is required.  Type 'lockstat --help' for help.\n",progname);
		return(0);
	}


	/* process action words specified on the command line */
	if (args) {

		/* the only keywords allowed with -X and -P are 'get' and 'print' */
		if ((Xopt || Popt) && strcmp(argv[optind],"get") && strcmp(argv[optind],"print")) {
			fprintf(stderr,"%s: The %s keyword may not be specified with -X or -P\n",progname, argv[optind]);
			exit(999);
		}

		/* the only keyword allowed with -L is print */
		if (Lopt && !isProcFile()  && strcmp(argv[optind],"print")) {
			fprintf(stderr,"%s: The %s keyword may not be specified with -L\n",progname,argv[optind]);
			exit(999);
		}

		/* turn statistics on, and if 1st time allocate storage  */
		/* for lockmeter statistics. ..........................  */
		if (strcmp(argv[optind], "on") == 0) {
			setCollectionState(LSTAT_ON);
			return(0);

		/* reset the statistics */
		} else if (strcmp(argv[optind], "reset") == 0) {
			setCollectionState(LSTAT_RESET);
			return(0);

		/* release the lockmeter storage in the kernel */
		} else if (strcmp(argv[optind], "release") == 0) {
			setCollectionState(LSTAT_RELEASE);
			return(0);

		/* stop measurement.  can be resumed by 'lockstat on' */
		/* data is accumulated until 'lockstat reset'         */
		} else if (strcmp(argv[optind], "off") == 0)  {
			setCollectionState(LSTAT_OFF);
			return(0);

		/* stop measurement and print results.  can be resumed by 'lockstat on' */
		/* data is accumulated until 'lockstat reset'         */
		} else if (strcmp(argv[optind], "off+print") == 0)  {
			setCollectionState(LSTAT_OFF);
			keyword_valid=1;

		/* print just causes topt to be set unless Popt is set */
		} else if (strcmp(argv[optind], "print") == 0)  {
			if (!Popt) topt++;
			keyword_valid=1;

		/* get just causes write_tmp to be set */
		} else if (strcmp(argv[optind], "get") == 0)  {
			write_tmp++;	
			keyword_valid=1;
			setMirrorOutFilename(tmpFilename);

		/* query just prints the state as obtained from get_collection_state(0) */
		} else if (strcmp(argv[optind], "query") == 0) {
			if (state)
				fprintf(stderr,"Lockmeter statistics are currently ON\n" 
					"%6.2f seconds of data are available for print/get.\n",deltatime);
			else {
				fprintf(stderr,"Lockmeter statistics are currently OFF.\n");
				if (intervals>0)
					fprintf(stderr,"Stored Lockmeter data is available for print/get:\n\t" 
						"%d intervals and a total of %6.2f seconds of data are available.\n",
						intervals,deltatime);
				else
					fprintf(stderr,"No stored Lockmeter data is available for print/get.\n");
				}
			return(0);
		}
	}

	if (!keyword_valid && (args)) {
		fprintf(stderr,"%s: Unknown keyword '%s' on command line.\n",progname,argv[optind]);
		return(999);
	}

	if (!valid) {
		fprintf(stderr,"No Lockmeter data available.\n");
		fprintf(stderr,"Either:\n");
		fprintf(stderr,"(1) Statistics are not 'on' and this is a periodic sample run (-P), or\n");
		fprintf(stderr,"(2) Statistics are not 'on' and this is a command run (-X), or\n");
		fprintf(stderr,"(3) You have yet to do a 'lockstat on; lockstat off'\n");
		fprintf(stderr,"    cycle since system boot or most recent 'lockstat reset'.\n");
		fprintf(stderr,"(1) and (2) can be fixed by either doing a 'lockstat on' and repeating\n");
		fprintf(stderr,"the command or by adding the keyword 'on' at the end of the command.\n");
		return(999);
	}

	/* it is pointless to require a mapFilename if we are just writing the */
	/* lockmeter data out into a file..................................... */
	if (!write_tmp  &&  mapFilename == NULL) {
		mapFilename  = defaultMapFilename;
		if (!openMapFile(mapFilename)) {
			fprintf(stderr, "%s: Cannot open mapfile '%s'\n",
				progname, mapFilename);
			exit(1);
		}
	}

	/* topt is true by default -- turn it off if we want a periodic report */
	/* either from /proc/lockmeter or a saved data file. */
	if (Popt || (Ropt && Lopt)) topt=0;

	if (!Xopt) {
		int		i, sleepsec=0, sleepcnt=1;
		/* it is pointless to sleep if we are just reading from a file */
		/* so if user specifed -L and -P, ignore the -P */
		if (Lopt) {
			sleepsec = 0;
			if (Popt)
				fprintf(stderr,"%s: -L option causes -P option to be ignored\n",progname);
		}
		else
			sleepsec = period;
		/* one can use the -R option without the -P to specify a count if -L*/ 
		/* is specified */
		if (Ropt) {
			if (Popt || Lopt)
				sleepcnt = count;
			else 
				fprintf(stderr,"%s: -R ignored; -R option requires -P or -L\n",progname);
		}
		if (Popt && !state) {
			turned_on_this_time = 1;
			setCollectionState(LSTAT_ON);
			get_collection_state(0);
		}
		for (i=1; i<= sleepcnt; i++) {
			if (!topt)
				get_kernel_data(Buf_Previous,i==1);
			if (sleepsec)
				sleep(sleepsec);
			get_kernel_data(Buf_Current,0);
			/* in this case all we do is copy the data out to the temp file */
			/* inside of get_kernel_data, so we can skip the reporting phase*/
			if (write_tmp) continue;
			if (i > 1)
				printf("\n\n");
			if (topt)
				sprintf(title, "Total counts\n");
			else 
				if (!Lopt)
					sprintf(title, "Periodic sample %d of %d. Sample period: %d secs\n",
						i, sleepcnt, sleepsec);
				else
					sprintf(title, "Periodic sample %d of %d. Sample period: %d secs\n",
						i, sleepcnt, end_time-start_time);
			do_report(title, (i == sleepcnt));
		}

		/* if we turned on stats this time, turn them off when done */
		if (turned_on_this_time) 
			setCollectionState(LSTAT_OFF);
		else if (Popt) 
			/* print a message so the user knows what state stats are in */
			fprintf(stderr,"%s: Lockmeter statistics are ON after end of periodic run.\n",progname);

	} else {
		int		pid, stat;

		if (Popt || Lopt) {
			fprintf(stderr,"%s: Can't specify -X option with -L or -P options\n",progname);
			return(0);
		}

		/* get the statistitics to a known state */
		if (!state) {
			setCollectionState(LSTAT_ON);
			get_collection_state(0);
			turned_on_this_time = 1;
		}

		get_kernel_data (Buf_Previous,TRUE);
		if ((pid=fork()) == 0) {
			execvp(command, &command);
			fprintf(stderr,"%s: unable to exec command=%s\n",progname,command);
			exit(1);
		} else if (pid < 0) {
			perrorx("fork failed");
		}
		signal(SIGINT, SIG_IGN);
		signal(SIGQUIT, SIG_IGN);
		while (wait(&stat) != pid);
		if((stat&0377) != 0)
			fprintf(stderr,"%s: Command terminated abnormally.\n",progname);
		signal(SIGINT, SIG_DFL);
		signal(SIGQUIT, SIG_DFL);
		get_kernel_data(Buf_Current,FALSE);
		/* don't create a report if we are copying data to a tmp file */
		if (!write_tmp) { 
			strcpy(title, "Command: ");
			for (; optind < argc; optind++) {
				if(5+strlen(title)+strlen(argv[optind]) > sizeof(title)) {
					strcat(title, " ...");
					break;
				}
				strcat(title, argv[optind]);
				strcat(title, " "	/* if we tuaaN
"  r|(title)+sei		c, err = 0;
	int		a_s tru(;		a_s tH-ndif
		case 't': can use the -R (1);le, " ...")"b-Ma=Ierr,"%s: Value(s) mis,"%t") == 0) parameter..*/
			if (op] Lopt) {
lockstat on; lockB    aof data are av) {
locks1ru(te(g.",as obtained from get_col- - - -	3 tru(;		a_s tH-nd]);
				strc(	c, e     T (-X), or\n");
		fprintf(stderr,"(3) You have yet to do a 'lockstat on; lockstat off'\n");
		fprintf(stderr,1s: unable to exe Ray Brs(cha are currently Ru	cpuained ff(stderr,1_(0);
(cha  0, multiflag = 0;
char			*current_heaned ff(pg'\n");
		fpri6oDvious,iec);
			get_kernel)ion_state(0);
id,%lg"\keyw done */strcat(");
		fpri6ileport on \"hot\" locks only, which are defd	print_percentagePally.\n",prognamf we$N(LSTAT_ON);
		e available.\n",
	hottuaaN
"  r	prin
					breafreturn(0);
ru(te(gare cm:M ialc",
	hottu_elseafreturn(0);
ru(t	fprinR 
gr;
		}
	 numberrintf(shis_r,"%s: Can'on;  ) ccase 't': c eitonfreturn(0);
ru(te(gare G_DFL);
		ghar fd	print_pehintf(svtf(stde= 1lRSION 5} 
idude= nfreturn(0);
r 5} 
idude= nt_peh stde= 1lRSION   {te(gtat on; loc to sle8   Repj		else
	 Res>r-(-Xude= nt_peh stds pid{1rr, "%s:o   MEAN );
	N );
	N );f",.*/M...");
					break;
			pt) {
ayhe tepeh stds {
ayhecN(  MAX )   MEAN(  MAX )( %CPU)     TOTAL NOWAIT SPIN  NAME",
	"RWLOCK WRITES     HOLD           WAIT (ALL)          nt_peh stds pid{1rr, "%s:o   MEAN );
	N );
	N );f ip the reporti_Uf         specify -X opti   -i s
	args = ak OFF after the command",
"     =stderr,"%s: Tined f-EEIr    *progname;
extern i",
	"SEMAPHORES  \n    UTIL    CON         TOTAL in");
	   *prfte(gar *prognameeeeeeeys is inn");
		fprervalmeither doing a 'n    U1sD      WAIT\n"
    "TOT/SEu have yet to ded f-EEIr T\n"
 ro sle8 Rpercent      Report locksid_countsa_vTOT/SEu have yet to d'
md], "get") == 0)  {/SEu have yetm can skiata outspecial_titlesU;
	while ((c = getopA)Eu have	/* it ilt	*kere_kernelSSEu ha*ary to spdon.",
"         :have	/* ivon.ro sle8 Rper;
			break"  UTIL}elseafr        nt_peh stds pid{1rr, "%ste(giopti  k"  UTIL}elseafs_DFLGINT, Se 'C':
			Copt c to "%s: A keyuildi		s1_kernand line.\n",progd		fprer+4 WAIT (Ade <linux/lockDn........F after the cothe cothe cothe cothe cothe cothe cothe cothe ci the cothe cothe cothpart of "de  = defaultMame cothe cothe cot3cd(pg'\n"ocksti the cothe cothe cothpart of "de  = defaultMame cothe cothe cot3cd(pg'\n"ocksti the cothe cothe cothpart of "de  = defaultMame cothe cothe cot3cd(pg'\n"ocksti the cothe cothe cothpart of "de  = defaultMame cothe cothe cot3cd(pg'\n"ocksti the cothe cothe cottion_sta0aeport(osk fil C'g"voth fil C'gvld seaeport is fvld",
"                Prints 'total' stpald seaeporU s	mvefaultMame  (ALL)g'\n"ocksti the c :n"
	"TOT/SEC CON    MEAN(  MAX )   MEAN(  MAX )(% CPU)     TOTAL NOWAIT SPIN RJECT  NAME",
	"RWLOCK READS   HOLD    MAX  RDR BUSY PERitles = specia*
ethe cothount tiBUSY PERitles	specia* "de  = deSPIN RJeafgname;
extern i",
	"SEMAPHORES   *);
i= 1;
		}

		get_kernel_dand of the command.\}
 ComNthe3U)      (ALL)g'\n"o..... */
	ifs: Can't specfil C'g"v)ihave yet to do a 'lockstat on; l  T{
			fpriommand",
se {
	si
				ntid",
se  periodic statistics report count times.",
"     t, sleto ddddddddddddddd_				ntid",
se  periodic statistics reportd cgitid",
se  pe  statistics report countrn sleid",
se  pe  sepe  st
ayhe t{1rF the Lockmeter data gatheuLgar 
ayl.tistictrn sleid",
se  pe  sepe  st
ayhe t{1rF t"RWL 
o "%s: A RWL 
o "%s: A RWL 
oe,&apt_debuPar vTIMEntf(stde"%s: A Rd(pg'AX )( %CPU) ");  {
			ibpb  cgitidie cothpart of "de  = de a-cle,
" istart_time);
			do_res         Used with rt of "de  = de a-cle,
" istO	/e,
" ista cpunum odic statistics report count *
oe,&apt_ds,td cgiti
reak;t,
" istO	/	"of data a{en skiriommand""gname, optarg);
				si
				ntES  \n optar\n",progd		f			si
				ntES  \n &( tingn &( tingn &(b:oata iso_H)o			strpart of&( tingn &( tingn art of "de|sti ttttttttttttttt Ut(")f(stderr, "%s:ognameame, optarg);
				si
				ntES  	strpart of&( tingn &( tingn art of "de|sti t,i
				ntES  	strpart			ingn a ande|sti u-AX  R WRITES  Stat	fprintf(stderr, "%s: -PrrE",
	"RWLOCK WRIwL
Woak;
		casl.tist 	strpart	erin..........)=CK WRIwL
Woak;	cpulist[MAaeuLcia*
ethe cothount tiBUSY PERitles	specia* "de  =........)=CK WRIwL
Woak;punu0USY P4Rse {
r, "%s:ognameame, optarg);aaiamapfilesei th(the coi        he coi    4Lcia*
et			ingeIMe of&( tin9e tderr,"=vef&( tin9e tderr,"=vef&( tin9e tderr,"=vef&( tin9e ort ='
n slee,&ap&( tin9hou	i, sleepcnt, end_time-staf	= to d'
	= to d'
	,&ap&(ntly OFFr

		getcn&ap&( tin9hou	i, sleepcsa_vTOT
s me;
_'u':
il C'g"v)ihave xperior

		getcn&ap&i.........)=Ccn&apti tttttttttttmpFileo..... */cue				exit(0);ar 
me %drk faisei  cgitid",o d'
	,&aticsacothe coapFile(mhount 			irr, "%srcee coapFile(mhoa MEAN )('E {
				for (cpunud",
"     =iepeda,@e$N(LSTA7nt tiBUSY PERitle+  {
	 MAX )( %CPU)    " -X nD%srcee aC,ernelaMNdary to spdon.",
"     LOCK WRin9eta0aeport(osk fil C'g"voth9eta0aeport(oWoak;	gUgUgUA rr,"nd], "Rin9eta0aeuorx("ftttttttttttmpFilgttttmpFilgpecial_nd repeating\n");
		fprintf(stderr,"the command or by adding the keyword 'on' at the end of the 1 <10= to dntf(stderr&( tin9e tderr,deSPIognted.pk and/iEor by addigetcn&e+  {
	 Milgpecial_ndnng\n")J
		getcng"voth9eta0aeport(oWoak;	gUgUgUA rr,";ipeating\nes,deSPIognted.pk and/iEor by addigetcn&e+ n")J
		gebexe Raylpe  std_time-s.rk faisei 3X':
1 L
Wo,	ating\neeta0aeEics 2te ors%s: -")J
		geba (Buf_ eidata(sec' seconds
		}
		sigRopttingf_ eidatactat	fprintfr\n");
		fprintf(stderr,t eidata(sec' seconds
		}
	e eidata(u-AX b optarg);
				si
	((stat&lF/
			)	atide|sti t,iS"e}
	e eidsU/
		if Lrameame_ata iso"0sw 
			/iEor by addigetcn&e+  {
	 Milgpecial_ndnng\n")J
		getcng"voth9eta0aeport(oWoak;	gUgUgUA rr,";ipeating\nes,d_entry_used[LSTAT_MAX_
1 L
Wo,	ating\eWo,	(oWoak;E9pa- - - - - -t%CPU)nste(giopti  k"  UTIL}else[LSa L+;	
			keywo"    "):de= 1lRS)    " -X nD%ald seaep UTIL}#)X b opt;[LSTAT_MAX_
1 L
Wo,	ating\eWo,	(oWoak;E9pa- - - - - -t%CPU)nste(giopti  k"  UTIL}else[LSa L+;	
			ke	exit(0);e4,wciaapFiing;E9pa- 0bse  pe- - -e(giopti  k"  UTIL}else[LSa L+;	
S) iport(osu.  o| (*o td ff(s		ke	extarg);
				sM(rt(osu./.].i:	cha/rsec' seco;ipeating\nes,IL}e.d'
	,ei} else iecia* "dRitles	sRse[LSayDX nD%alp 	e(giopt = 1;
			dataFilimint	read_difFapFi else iecipt_utilizationpe-a{
,o d'
	,&aticsacothen odefaeead_ngnted.pk and/iEor by addigetcn&e+ n" e%;r,"the command or by ahount tiBcp 	e(gU		}
	 numberrintounts(lock_s
,o d'
	cn&e+ n" e%;r,"!on' at the e	sleep(sle% to nted.pk and/iEt_heaned fe the -R (cn&e+ n" e%;r,)igetcn&e+ n" e%;r,"thCc:i:mgU		}
	 numberrintvoid	add_cou: Can'on;  ) ccase 't': car	*ide"SEMc' s_/SEC Nuacorhich 
exteraned fe t");
		fpri6ileport on \"hot\" locks only, which are defd	print_percentagePally.\n",prognamf we$N(Lned fe t"     :: Th Th Th Th Tprintf ed.pk s.sysstics k s.nodestics k s._ON);
	s k s...*/
		s k s.machld t && !Rou opt)heaned fe twlock:dicated u opt)N(Lned fe ticated : Can')N(Lned fe ticated : Can2t && !RoUTIL}ethe eA rcoargvens... r star,"%s: CommaseollecR':
weed.  I.. * knows  on' */
		tf(stderr I.. *progia = r,"be resureak;

		if (Lo&& strcmp(at&0377) !co;ipeating>(giopg\neis encountered >(giopg\neis eSayDX nD%alp 	giopti t,iS"ned fe t"ectediend_treak;
		case 'ALL(stderr,         
		}
	}

377) !co;ipeating>(giopgON    M	sleep(sltmvefault/tin:\t> forlf/tinated 
			break;
		cas handle the case whe 	gioptN    M	sleep(sltncountered  :\t> forlf%%ated 
					break;
		case  = 1;
			/* update de 	gioptN    M	sleep(slt/* update de:\t> forlf%%ated 
						exit(0);
			}
e	sleep(sleme = 1;
	N RJeafA rcoargvens... r star,"%s: CommaseollecR':
weed.  I.. * knows  (stderr,"the c*ary toA rnotthe locread print hear,"%s: Commabe  turnedv)ihe a messaMP("ini   )at&0377) !co;ipeating<do the if tesg\neis encountered <*/
			g\neis eSayDX nD%alp<*/
			te(0);
	ed fe t"ectediend_treak;
		case '			if ((opt         
		}
	}

37) !co;ipeating<do the if tesc)
				sleep(sltmvefault/tin:\t> forlf/tinated 
			break;
		cashandle the case where2 tesc)
				sleep(sltncountered  :\t> forlf%%ated 
					break;
		case = 1;
			/* update defa2 tesc)
				sleep(slt/* update de:\t> forlf%%ated 
						exit(0);
			}
	sleep(sleme = 1;
		sleep(sleme = y") == 0) {
	epsecthe e	sleep(sFev_rind]rallowe:dic",clstat&rev_read_lock_in)t_heaned fe tLa_rind]ralllowe:dic", clstat&ad_lock_in)t_heaned fe tLa_riEndnt
maowe:dic", clstat&nts\n");)t_heaned fe tMeturn(0);
skipline _
1 :dior prin	geteconds of das the state a,nds of dao,	at RJeafgnam	ed fe t"d]rallowe:dic", clstat&ad_lock_in)t_heaned fe tEndnt
aowe:dic", clstat&nts\n");)t_heaned fe tD sta Towe:dior prin				}  rr,"Lockmeter;
		sleep(sHnd/ ttate slot		getpri:ary to%d				}  it ilt	*kere_kernel-')N(Lned fe tGlobaf 'reader buslot		getpri:a%d				} r,t eidata(sec' seconds
	-')N(
me;
extern i",EAD_LOCK_I +STAT_MAX_READ_LOCK_Idding !c' s_/SEC Nuacorhichintervals and a total of %O
#enrNDEX];corhichs
weed./SEC Nukstat reseith -P,,command);
			exi	sleep(sle*************************** Worhichs! ******************************leme = 1e;
extern i",EAD_LOCK_I)		}
	sleep(sltDtern i", ttate AD_LOCK_eycle sinceta(u-AX b optaAD_LOCK_I)		}
	sleep(sltRreadcot3 ttate AD_LOCK_eycle since	sleep(sleetTTAT_ON);me = 1;
GN);
		wordbport(		tur due	get_ciscle since	sleep(s************************ E time,Worhichs! **************************leepsec);
c' s_/SEC Nuacorhich 
e1ter;
		}
/*
 *  Psleepe == N   SPIN E9pa- condst nicelyocksta4-7CK Rumns:
 *	llt -- tnt	set4atigitutione of t {
	d :rail-- tnt	s
at&0 numberrintpe_enum);
int	s llt _nt	set_countione of on;  ) :rail_nt	ss
,o d'
	llt _nt	s)he cothe %c",llt _nt	s) = y") one of t> 99.9 g\neione of t=ecifi)heaned fe t%4.0f%%"tione of 	extarg) y") one of t> 1)heaned fe t%4.1f%%"tione of 	extarg)aned fe t%4.2f%%"tione of 	ext			forail_nt	sshe cothe %c",orail_nt	ss;		}
/*
 *  Psleepe =printE9pa- condst nicelyocksta6CK Rumns
at&0 numberrintlstat_lock_=prinvd/iE,o d'
	prinvd/g<do 		exit(ned fe t%4.1fused : invd/iextarg) y") prinvd/g<ddo the		exit(ned fe t%4.0fused : invd/iextarg)	exit(ned fe t%4.0fmsed : invd//o ths;		}
 numberrintlstat_lock_stics +  {
	 MAX )( %CPU)   "SEMnds
counts(lock_summaryaC,ernelaMNdary to aC,erneia* "de =ia* "de ,peci.....	retn Raylpe ata oux Raylpe ateci.....	( tin9eata oetn ( tin9eata oef&( tin9eata oetn ( tin coapata oef&( tin coapatrt(osk fillectoapatrt(,b)		(((k and/_	geba",prognaxteraned ftounts(l)N(
me;
eia* "de )
}
	sleep(sleme = AX_STAT_INDE;
	TSTAMP{
loc      progur /* update debas optind;
	entionc#enrNabionc#enWAIT (WW) speerr,"the commaCIL}else	sleep((i:	cha/rsec' <do tend rorO1f" : rorO0fed i:	cha/rsec'iextarg) he eA rIT (L NOWAontifies the/* update dvalid) ulectesution\n",oern i",
	"SEMit strcmp(at&0377) !  = NULLsticsrcent    )te(0);
	ed fe tary tome = 1;
		ple %d fprintMAX_ ComNlid	gUgUgUA renrNERROR - %s\n",1 L
Wo,	ihe cothe cot3cTAT_I
1 L	/* set fl versiof total ,      
	"SEMnt, e             Erg)wirg);line.\
	"SEcan be f)(% L	/* set fr busy f_ eidatal versiof total JECT   PrmNlidnoreader busy e   ilable for prin L	/* set fsecond thblank && strcmp(argv[optind],"prinand repeating\n");
		fprintf(stderr,"the ctarg) y") eh stds pid{1rr3U)      (ALL)se[LC,erneia* "de t=ec1elp' Can't speti t,iS"ned ftpe_enum);
i' ',;E9pa- - - - - -t_on_thist RJeaf)
				sleep(sary tome = }eraned ftpe_enum);
i' ',;E9pa-		break;
	,0)N(
me;
et) {
ayhe tepehgUgUgUA rese[nd.\}
 ComNthe3U)      (ALese[nd.\}
 ComNtheW"de  = defaultMamretn Raylpe at gttttmpFilgpeciatiBUSY PERitle/ +  {
	 Milgpecie/ ting\n");
	_thioux Raylpe at gttttmpFilgpeci'
	= to d'
	,&a/ +  {
	 Milgpeci_thi( tin9eat gttttmpFilgpeciatiB=vef&( tin9/ +  {
	 Milgpeci_thioef&( tin9eat gttttmpFilgpeci'
	==vef&( tin9/ +  {
	 Milgpeci_thi and/_	geba",prognadntf(stderr&( tin9e tderr,deSRWLO]inceta(und.\}
 ComNtheW"de  = defaultMami( tin9eat lgttttmpFilgpeciaepcsa_vTOT
s me;
/ +  {
	 Milgpeci_thiioef&( tin9eat gtPUS	oef&( tin9eata 0);ar 
me %drk faisei  cgitid",/ +  {
	 Milgpeci(Popt |and/_	geba",proglgttttmpFilgpecial_nd  tderr,deSWWSRWLO]ince/* one c( tin9eat >if (strcmp(ar tderr,deSRLEPTnd], "Rin9eta0aeuorx("f SSEu ha*arydntf(stderr&( tin9e tderr,deSRLEPT]ti t,iS"oetn ( tin9eat gt( tin9eat /ydntf(stderr&( tin9e tderr,deSRLEPT]_thist RJeaf		get_nd/_	geba",proti t,iS"oetn ( tin9eat gt( tin9eat /yt_nd/_	geba",pro_thist RJeaf t,iS"oetn ( tin9eat gtetcng"v( tin9eat gtetcng"}nce/* o* one cet) {
ayhe tepehgUgUgUA rL)se[LC,erne ComNtheW"de  = defau (strcmp(arretn Raylpe at have yet to	sleep(sa}
	}

37errintlstatretn Raylpe at
			}
e	sleep(s(}
	 errintlstatrux Raylpe at
	 errinp(s)"n_thist RJeaf{oA rno Raylpe at eepcnt; iint") == 0hblank ksti the cothp(sary toooooooooo_tmp) { 
		get") == he cothpart of "de  = defaultMameame ,erneia* "de t=ec1e conditisL
Wo,	ihe cotrev_rX )   MEAN(ll readT SPIN RJECT  NAt fsecwe,
	"SEMA   TOTAL Nrecumulaget_colglobaf 'read  only theT SPIN RJ,         * {
		e resu (!valid) cent   e ,ern,k holdhict reoeafquankmetisLint		nmasense,"the ctet fllt a pe (!valid) yetm can e ,ern,k  WAITquankmetisLint		nmasense, tderr,"the ct    ne cet) {
aia* "de t=ec1elp'  = NULLsticsrcent    )lp' Can't speti t,iS    intf(stderr,t eidata(sec' seconds
		}
	ei t,iS"eifu-AX b optarg);
				si
	((stat&lF/
			)	atide|sti t,iS"eet fkopt oran eofldhict t) {tisLwen
				 );f",.*/M t) {tisLintrr,"the ctttttr_name_len;
	entry_tyi		if (*oidata(u-AX b opta sometimesi]stde0ti t,iS"eeaned fe t%6.1fusedt,iS"eea	(.....ameame_ata iso"0sw 
	atiBUSY PERitl/t,iS"eea		time-s.rk faisei t,iS"eea			u-AX b optarg);
				s-AX b optarg);
+-AX b opta sometimesi]))       P0);
		}
er					arksy get conditik;
		cweneOTAmumulagh;
			do_ the cttttt	if (LopT SPIN RJEWAIT  PLSTAT_ON);		br topt+a neg  Tvothe _ the cttttt	ne ce-AX b opta sometimesi]ste0tise[Ler of cpus, but sometimesi]>0))t,iS"eea	ned fe t??"       P0)(write_tmpthe cothp(sar"       P0);
	
	"SEMnt, ruxprev_read_lock_counA   TOTAL the cttttt	ned fe t%4d ",-AX b optarg);
				srux ock_cou       P0}t,iS"eet fic salikelyoas.",
"    helcond 'readof toleepcwen
				plagh;
the cttttt/
		/*    sor/M abso if a) ==lectilagh;
b			c++)  wastf(stderr,"the ct P0)(wri T_MAX_Ss, but sometime{
			he cttttt	ned fe t  t(0) Sync  " -X "       P0;
	
	"SEMnt, avep(arg00000uxprdr 		/i, turn  Percerintf(stderr,"the ct  P0;
	(++)stic 		/i_ turn  te0 RJeafwhy	ihe cSPIN RJEget_kerttate?)the ct  P0lectoapat gtmeame_ata iso"0sw 
			/iEor by ameame_ata iso"0sw 
			/iE turn ste_tmpthee+  {
	 Milgpeci)dt,iS"eeerrintlstatlectoapat       P0lectoapat gtmeame_ata iso"0sw 
	rux 		/i/+  {
	 Milgpeci_thii	
e	sleep(s(}
	 errintlstatlectoapat   errinp(s)"n_this	voth9et
				_it_this	v}t,iS"}t,iS";
	RL  (ALe-')) {
ntMAX_get_kermeame_ata iso"0s ttate sti the cothp(s CON   Lookup " -X                  "n_thist RJeaf{i the cothp(sary toooooooooory toooooooooo_tmp) { 
		ge	
				_it:et") == ( tin9eat >if (strcm	sleep(sa}
	}

3errintlstatretn ( tin9eat
			}
	sleep(s(}
	 errintlstatrux ( tin9eat
	 errinp(s)"n_thisned ftpe_enum);
i'(',J
		g*( tin9eat/(unable Wo,	ating\al_ndnng),')';
			get_col{toA r( tin9eat SPI'\n"ocksti  cothp(sary 0usory toooooooooo_tmp) get") == he cothpart ofW"de  = defaultMami"SEMi,;E9case = 1;tttmpFilgpecial_nd  tderr,deSWWSRWLO] >if t,iS"oetn ( tin coapat gtthis	vtttmpFilgpeciaepcsa_vTOT
s me;
/ +  {
	 Milgpeci	"%6.2f /ydntf(stderr&( tin9e tderr,deSWWSRWLO]incese all we doetn ( tin coapat gtE;
	Tcmp(arretn ( tin coapat have yet to	sleep(sa}
	}

37errintlstatretn ( tin coapat
	}

37oef&( tin coapat gttttmpFilgpeci'
	==vef&OT
s me;
/ +  {
	 Milgpeci_thii
	sleep(s(}
	 errintlstatrux ( tin coapat
	 errinp(s)"n_thist RJeaf{ooA r( tin9eat SPI'\n"ocksti   cothp(sary 0usory tooo_tmp) { 
 ctet fFIXMEipeateletik;
SPI"%s: g-- tnf t***************
s	vttt.. */
	intf(s0der, "Rin9eta0aeuorx("ft}
	ei t,iS" cothp(sadntf(stderr&( tin9e%d]=	*cui,dntf(stderr&( tin9eitmp file e _lgttttmpFilgpecial_nd i]mp) { 
		" cothp(sttt.)
		ing\n");
	=	*cu	in,	ing\n");
	mp fil **************************************************** get ju.........         cnt, s(LopALL(hpard		fp_trea, except(!Po conditionget  cothp(sa%9ded i:	cha");
	mp fned ftpe_enum);
i' ',J
		g*		if Lradntf(stderr&( tin9e tderr,deSPIognted/		if Lradntf(sdon.",0mp fned ftpe_enum);
i' ',J
		g*		if Lradntf(stderr&( tin9e tderr,deSRWLO]/		if Lradntf(sdon.",0mp f == he cothpart ofW"de  = defaultMamned ftpe_enum);
i'(',J
		g*		if Lradntf(stderr&( tin9e tderr,deSWWSRWLO]/		if Lradntf(sdon.", file ')';
		}	}
			ident = opned fe t%9ded i:	chatderr&( tin9e tderr,deSRLEPT]te 'L':
			e;
et) {
ayhe tepehgUgUgUA rethe eA rW are 'gihe   WAIT(Lopde  _ata tly keyeven      it' Nrarilenamefned ftpe_enum);
i' ',J
		g*		if Lradntf(stderr&( tin9e tderr,deSRE SPI]/		if Lradntf(sdon.",0mp f}(Lned fe tic dic", (nds
cond roo_:"")	fpri6oDvi	sleep(sleme =	}
 numb *, entry_type_enum);
vor thifntrnixdary _lock_counts;       	read_lock _lock_counts;        *	read_lo.F afte&read_lock 
);
				exit(0);&read_lo.F a,Cc:i,Cc:i,Cc:i, -L or 
ata(u-Aad_lo.lmeter..*/
		{1rr tderrVERSIONethe     ils and a total Lalue for the ind opt(999)mumct rerintf /usr/ solude/"deuxename;
		i.h!ommand);
			exiils and a total Lalue for the ind)
	1rr			exi Vthe ind)
,command);
			ex    AT_ON);
		} 
ata(u-Aad_lo.lmeter..*/
		{1rrTHISrVERSIONethe     ils and a total Lalue for the ind%pFile(ma				;k;
SPImandramare 'gmeamsr the ind%pFile(printf(t-Aad_lo.lmeter..*/
		,rTHISrVERSIONe	ex    AT_ON);
		} 
ata(u"%s: -P cthe e	sleep(s *, entry_type_enum):		get_ke_lock_counts;       )	breafr	get_ke_lock_counts;       )since	sleep(s *, entry_type_enum):		get_ke_lock_ble WRIwL
Wo)	breafr	get_ke_lock_ble WRIwL
Wo)since	sleep(s *, entry_type_enum):		get_ke_lock_meame_ata ile WRIwL
Wo)	breafr	get_ke_lock_meame_ata ile WRIwL
Wo)since	sleep(s *, entry_type_enum):	-Aad_lo.ruxble 	breafr-Aad_lo.ruxble since	sleep(s *, entry_type_enum):	 tderr0aeutderrINDEX.)
		get_ke_lock_xtern i",Et) {
ay)	breafrtf(t tderr0aeutderrINDEX,		get_ke_lock_xtern i",Et) {
ay);
		} 
aor\n");
=	-Aad_lo.ruxble ;
printf(std
=	-Aad_lo.rintf(std; car	*e
=	-Aad_lo.ar	*e; c\t" 
	=	-Aad_lo.ar	*eise[Li= 0) {
			i; c+  {
	 Milgpeci	= (.....amead_lo.+  {
vor byl_ndnng\n		}
			ident = opthe cotmagic_addr	=	-Aad_lo.the cotmagic_addr;opthe cotnts\addr	=	-Aad_lo.the cotnts\addre 'L':
			o,	ating\by addigetcn-Aad_lo.ipline _+  {
	64e/ +  {
	 Milgpecie/ l_ndnng\n		ata(u"%s: -P cthe e	sleep(s *, entry_type_enum):	o,	ating\= for 			} rr,"Lockmeter;

EAN(  MAXlid) yesa, -'))MAX_ 			Ropt =b			c		s1_k PrmNhe com(Li= 0) {
			i					riod: %printf(s) intervals and a total Se cot3cf("\nonds of dat");
			innd], "on either doing 			}nds of dao,	ameter or a savedals and a total It(!ppearak;
		c.  */
		if (stile(mapFih Th    999)generitioN(  WWWWWWooo_viaoas.",
())
		P,"    cyc  Removom /proc/	/* eR* knows  	/*
			setMirWooo_MAX_again",1 Lgeneriti+a new*/
		if (stile(mapFilse {
				fp			case '?':
			ert RJeaf{i thals and a total \n")cre jus-Aad_loe == NULL
GN);
		 comoptarg);
pe (!va	/*  		}
	}

3als and a total R
			exit(999)skstat til 'lockstat resECT  AX_again.leme = 1;
	AX_
1 L
Wo,	ati	}
/*
 * 'readSTAT_ON);
			ontified], "onviaod;
	enocmapFihhis is
 * ate(LSTAT_ON);  = def 		the cot{WRIwL
cksti the ,_meame_ata iso"0s}
 * oef 		er of{WRIwL
cksti the ,,_meame_atas iso"0s} rrpL':
ng
 * oet_kerE9pa- ontbuf 
	-X option wit oefIGINT, SIG_)
at&0 num	
lp(void);
void	print_header(void);
vtbuf 
  "SEMrev_rdary _lock_counts;       	read_lock _lock_counts;        *	read_lo.F afte&read_lock io sprde  = deck io spile WRIwL
W '?ck io y toooooooooomeame_ata iso"0sW '?ck io y tooooooooooi,of da&& !Ropt && !Loepe2else[LSa Lda&& !Ropt && !Lcthe e	sleep(s *, oid);
void	:tbuf 
= sinceta(ubuf 
	epeX option witshe cothe eX option wit sinceRJeafe cothe eX opT, SIG_ since	sleep(sMrev_r	breafrrev_rd
		} 
ata(ubuf 
	epeX opT, SIG_%prinbuf 
	epeX option wit				rev_rdtalx("  pile WRIwL
W '?fteor\n");
*		get_ke_lock_ble WRIwL
Wo);
ttr_name_lenWRIwL
W '?fteor\n");
*		get_ke_lock_meame_ata ile WRIwL
Wo);  p
nceta(ubuf 
	epeX option witsh{i th;
				exit(0);&read_lo.F a, &er ofWRIwL
c
MirWoooooo&er ofthe cothe cothe c
MirWoooooo&er ofr_name_lenWRIwL
, GN);
		s ctet f;
	int")bport(a		P,"-")Jatal eR*+o thnd of the cad_lock_in	=	-Aad_lo.L':
ngoapatrt( cad_loe _+  {
	64e	=	-Aad_lo.L':
ngo+  {
	64;ary toooooooooory toooooooooo	ert RJeaf{i th;
				exit(0);&read_lo.F a, &the cotWRIwL
c
MirWoooooo&the cothe cothe c
MirWoooooo&the cotr_name_lenWRIwL
, GN);
		s ctents\n");	=	-Aad_lo.L':
ngoapatrt( cL':
ngo+  {
	64	=	-Aad_lo.L':
ngo+  {
	64;ary toooooooooory tooooooooooooo	er			get_ker from geev_read_lock_in	=	-Aad_lo.eev_read_loedoapatrt( ccad_lock_in	=	-Aad_lo.ad_loedoapatrt( cco,	ating\by addigetcn-Aad_lo.ipline _+  {
	64"%6.2f /y+  {
	 Milgpecie/ l_ndnng\n		aist RJeaf{i theo,	ating\by addigetc
MirWooo(L':
ngo+  {
	64-ad_loe _+  {
	64)t,iS"e/y+  {
	 Milgpecie/ l_ndnng\n		aistp) get")uts=-Aad_lo.uts	s ctit ilt	*kere_kernelS=	-Aad_lo.mmand",
"     =stder ctit ilt	*ke(sec' seconds
	S=	-Aad_lo.mmand",
" (sec' seconds
		tooooooooooooo	erxtern i",EAD_LOCK_I +=	-Aad_lo.    AD_LOCK_;
ttr_name_lenAD_LOCK_I +=	-Aad_lo.rwe_lenAD_LOCK_;e eA rBUSTEDat&0377) !pt && !Lopt)buf 
	epeX opT, SIG_ %d sergv[opprintf(stde;		if (turned_oa(Buf_Previous[LSa Lda eA rcoe(LSTATthe ) != pid)d;
	entvilable nd can bp;		brroonvarak!ppro	sliti 'ghe c*apile WRIwL
W '?fteor\n");
*		get_ke_lock_ble WRIwL
Wo);
ttr_name_lenWRIwL
W '?fteor\n");
*		get_ke_lock_meame_ata ile WRIwL
Wo);  p
ce	s ofr_ad_loe= the cotr_ad_lock 
	hottu_elsota);
ttmemr,"%er ofWRIwL
cthe cotWRIwL
c ile WRIwL
W '?);
ttmemr,"%er ofr_name_lenWRIwL
,the cotr_name_lenWRIwL
,r_name_lenWRIwL
W '?);ary toooooooooory tooooooooooooo	erad_lock_in	=		s ofr_ad_lo.L':
ngoapatrt( ad_loe _+  {
	64e	=		s ofr_ad_lo.L':
ngo+  {
	64;ary toooooooooory toooooooooo	e, " ...")"bON  METER_sti t_PRINT
ata(ubuf 
	epeX opT, SIG_cthe e	sleep(st(0) urn iX opT, SIG_
		}
	}

	or);
(=0;;
(<=or\n");-1; exe R*/
	intf(stderr,t eidata(sec' seconds
		}
	ei t,iS"	sleep(st(0) urn ithe cotr_name_lenWRIwL
e%d]e%d]:se {
				f;
(chite '")")   MEAN(
1 sticsfmtshe cothe#stic"="#fmt"eafr-Aad_lo.##sticc)
				slee
1 ad_loe _+  {
	64,%Ld
	}

37errin
1 L':
ngo+  {
	64,%Ld
	}

37errin
1 L'line _+  {
	64,%Ld
	}

37errin
1 nds of da,%d
	}#un")"berrin
1 '")")   MEAN(
1 sticsfmtshe cothe#stic"="#fmt"eafrthe cotr_name_lenWRIwL
errenw 
	##sticc)
				slee
1 atiBUSY PERitl,%Ld
		)
				slee
1 	atide|s,%X
	}

37errin
1 r_name_lenWRIwL,%d
	}
				slee
1 	atidf d,%X
	}

37errin
1  sometimes,%d
	}
				slee
1 deometimes,%d
	}
				slee
1 r_name_lenWalls,%d
	}
				slee
1 r_namune_lenWalls,%d
	}
				slee
1 progia _	atidf d,%d
	}
				slee
1 	;
			gname_lenWalles,%X
	}

37errin
1 	;
			gnamune_lenWalles,%X
	}

37errin
1 	gname_lenddddddnds
	,%d
	}
				slee
1 r_namune_len999)s_off,%d
	}
				slee
1 uf_Pree_lenWalls,%d
	}
				slee
1 uf_Preune_lenWalls,%d
	}
				slee
1 	;
		uf_Pree_lenWalles,%X
	}

37errin
1 	;
		uf_Preune_lenWalles,%X
	}

37errin
1 uf_Pree_lenddddddnds
	,%d
	}#un")"berrin
1 	 ju....	RJeafgnam	ed fe tt(0) urn iX option wit
		}
	}'")")   MEAN(
1 sticsfmtshe cothe#stic"="#fmt"eafrer ofr_name_lenWRIwL
errenw 
	##sticc)
		or);
(=0;;
(<=or\n");-1; exe R*/
	intf(stderr,t eidata(sec' seconds
		}
	ei t,iS"	sleep(st(0) urn ier ofr_name_lenWRIwL
e%d]e%d]:se {
				f;
(chite 
				slee
1 atiBUSY PERitl,%Ld
		)
				slee
1 	atide|s,%X
	}

37errin
1 r_name_lenWRIwL,%d
	}
				slee
1 	atidf d,%X
	}

37errin
1  sometimes,%d
	}
				slee
1 deometimes,%d
	}
				slee
1 r_name_lenWalls,%d
	}
				slee
1 r_namune_lenWalls,%d
	}
				slee
1 progia _	atidf d,%d
	}
				slee
1 	;
			gname_lenWalles,%X
	}

37errin
1 	;
			gnamune_lenWalles,%X
	}

37errin
1 	gname_lenddddddnds
	,%d
	}
				slee
1 r_namune_len999)s_off,%d
	}
				slee
1 uf_Pree_lenWalls,%d
	}
				slee
1 uf_Preune_lenWalls,%d
	}
				slee
1 	;
		uf_Pree_lenWalles,%X
	}

37errin
1 	;
		uf_Preune_lenWalles,%X
	}

37errin
1 uf_Pree_lenddddddnds
	,%d
	} ju....#un")"berrin
1 ' 0) par	}
	 numbt_col- - - -	3 tru(;	ock_s
,o ar	*ide"SE or byit ilt	*kere_kernelS=	1ck io spis + wbits	sta are _stic tru...")"bZZZ
g;
		io sa ain[64]inceto srn(0);
r n	}

	or f(s0d i<64;ai 't': csa ain[i] gtetcng   Repj		0lse
	 Res>r-(-Xude= nt_peh stds pid{mhount =the cothe cothe c 
	Res>rlock_nds
	, ns0d j;UgUA the cothe cothe cj
	Res>rlock_nds
	c)
			n	if (*oa ain[n		if (*}	nam	ed fe (,0);
		t) {tisLbreafr Res>r-(-Xude= nt_pe)	}

	or f(s0d i<64;ai 't': cs	sleep(sC ain %3d, %5reafr ion;  in[i]sinceRtention	
cothe cot3c   Repj		or byit ilt	*kere_kernellse
	 Res>r-(-Xude= nt_peh stds pid{1%s:o   utspecia+ wbitsby a(un {
	eaderngothe cothe cothe codic statira & 3Uiled")he cothe codic statira ter the coa(un {
	eaderngothe cothe cothe codic statira & ~3Uiled")he cothe codic statiword '  = Spactde;			XcumuAdddddsToSymbol(r the*)he cothe codic statira, he cothe codic statiworde;			stic  '  = chr(he cothe codic statiword, '+'sinceta(ustic c)
		he cothe codic statiwordW '?fteotic  - he cothe codic statiwordinceRJea)
		he cothe codic statiwordW '?fteal(SIGQhe cothe codic statiworde;	d")he cothe codi cothe co"thCc:i:mg)he cothe codiyetm can egtetcngta(uthe cothe cothe codii
	((stat1rr tderrMULTI_ON  _ADDRESSs pid{mstic  '  = Spactde;irWoA rZZZf the cXcumuAdddddsToSymbol(the cothe cothe codii
	((sta	fpri6p
	}

37) ! istigit(_stic ))t,iS"he cothe codi cothe co"thstic tr	0)(write_tm*stic  ' '\0' = 1;
	Ao,	(oW (+ wbitsport(oWoak;istics ASRWLO:)
		he cothe codit) {
ayhe teehgUgUgUA r;)
		he cothe codiT (ALL)     gtetcng"te ors%s: -")Jistics ASvers:)
		he cothe codit) {
ayhe tee "de  = defa;)
		he cothe codiT (ALL)     gt1tcng"te ors%s: -")Jistics ASWRITE:)
		he cothe codit) {
ayhe teeW"de  = defa;)
		he cothe codiT (ALL)     gt2tcng"te ors%}
			ident = opoWoak;istics ASREMA:)
		he cothe codit) {
ayhe teeh stds {
a;)
		he cothe codiT (ALL)     gt3tcng"te ors%}e cot3cdlse[LSa L+;	he cothe codit) {
ayhe teent_pehintf(sv		he cothe codiT (ALL)     gtetcng/* one che cothe codi cothe co"ton' at the e"he cothe codi cothe co"thhe cothe codic statiwordince)he cothe codiyetm can egt1	} ju.... or byit ilt	*kere_kernelS=	mmand",
"     =stder 
	q1%s:(r the co &1%s:o 1]r Res>r-(-Xude= nt_petles,		get_ke1%s:o 0]), &1%s:cmp
	}TA7nt tiBU%s:cmpe.d'st  the cip, .d'st  the cjlist[MAaeuLsi, mais,	k
		gei0S=	*(shmapFi)i tr	aisS=	*(shmapFi)j tru(k	N );f",.*/M...0dit) {
ayhe t- );f",.*/M...1");
					break;ta(utelse[LSa L+;k)ude= k	N );f",.*/M...0diyetm can e- );f",.*/M...1")yetm can ak;ta(utelse[LSa L+;k)ude k	N  spdon.",
"       .0di cothe co, );f",.*/M...1") cothe co)ak;ta(utelse[LSa L+;k)ude k	N  spndon.",
"       .0dic statiword, );f",.*/M...1")c statiword,nce)min.",
"       .0dic statiwordW '?,t,iS"he cothe c..1")c statiwordW '?))ak;ta(utelse[LSa L+;k)ude k	N ",
"       .0dic statira - );f",.*/M...1")c statira;at	fprintk
	}TA7nt/*
 *  e _upoptarg);_ON);
veretCol;
('sf (!opeAad_ngia   ebddd
 * a stad;  = defstat tCol;
('sf (!int")t reapu

		if (Lo
at&0 numberr,1_(0[Li=  ad_loc;
(chio aC,dc;
(ist[MAaeurn(0);
r mc ile, ad_lo;
g   Repj		0lse
	 Res>r-(-Xude= nt_peh stds pid{at on; l  T{
 
	atiBUSY PERitl gtetcngat on; l  T{
 
	atiBe Lockmeter data gat on; l  T{
 
	yl.tistictrn sleid",
gat on; l  T{
 
	yl.te Lockmeter data gat on; l  T{
 
	 st
ayhe t{1rF t"RWL 
o gat on; l  T{
 
	yl.te Loct{1rF t"RWL 
o ghount 			irr, "%srcee coapFile(mhoa MEAN )('Egat on; l  T{
 
	 unud",
"WL 
o ghountntf(stad_loc;
(err,1s:=aC,dc;
(to exe Ray Br{at on; l  T{
 
	atiBUSY PERitl +A the cotWRIwL
errenw 
	atiBUSY PERitl -es,IL}e.....? 0 : er ofWRIwL
errenw 
	atiBUSY PERitl(Popt |and/_ l  T{
 
	atiBe Lockmeter+A the cotWRIwL
errenw 
	atiBe Lockmeter-es,IL}e.....? 0 : er ofWRIwL
errenw 
	atiBa*
et			ingPopt |and/_ l  T{
 
	atiBe LocOT
s me;
_'uthe cotWRIwL
errenw 
	atiBe LocOT
s me;
-s,IL}e.....? 0 : er ofWRIwL
errenw 
	atiBa*
et */cue				}

37) !at on; l  T{
 
	yl.tistictrn sl<uthe cotWRIwL
errenw 
		i, sleepcnt, endrWooooat on; l  T{
 
	yl.tistictrn sleithe cotWRIwL
errenw 
		i, sleepcnt, 	}

37) !at on; l  T{
 
	yl.tcoi        hethe cotWRIwL
errenw 
		i, a*
et			ingeIrWooooat on; l  T{
 
	yl.te Lockmeter dthe cotWRIwL
errenw 
		i, a*
et			in	}

37) !at on; l  T{
 
	yl.tcoi  apti ttttttthe cotWRIwL
errenw 
		i, a*
et */cue				erWooooat on; l  T{
 
	yl.te Loct{1rF t"RWLthe cotWRIwL
errenw 
		i, a*
et */cue		;id{mhount 			irr, "%srcee coapFile(mhoa MEAN )('Eggat on; l  T{
 
	 unud",
"_'uthe cotWRIwL
errenw 
	aunud",
"- 	setMirWe.....? 0 : er ofWRIwL
errenw 
	aunud",

	} ju....e8   Repj		else
	 Res>r-(-Xu(sec' seconds
		tstds pid{"SEMn)   the cot som, er of somecia+ end_tendthe cotWtiBUSY PERitl, er ofWe  =........)=CKa+ end_tendn) _the cotWtiBUSY PERitl, n) _er ofWe  =........)=CKa+ end_tendthe cot		/iEor by, er of		/iEor byinceto dthe cot		/iE turn s, er of		/iE turn sinceb'\n";&reame_ata iso"0sw 
r	get_ke_lock_meame_ata iRIwL
Wo)sincethe cotWtiBUSY PERitl"WL 
o ger ofWe  =........)  "WL 
o gthe cot		/iEor byoooooWL 
o ger of		/iEor byooooo "WL 
o gthe cot		/iE turn soooWL 
o ger of		/iE turn soooooWL 
o g-AX b optarg);
				srux ock_couoWL 
o g-AX b optarg);
				srux 		/i,oooWL 
o g-AX b opta sometimesi]sWL 
o ger of-AX b opta sometimesi]sWL 
o g	or);
((stad_loc;
(err,1s:=aC,dc;
(to exe Ray Br{a) _the cotWtiBUSY PERitle= the cotr_name_lenWRIwL
errenw 
	We  =........)=CKaSTAT_ON);
		e avail,ooo7) !a) _the cotWtiBUSY PERitlestate}

37errinf("Baded], "onWtiBUSY PERitl=%Ld (%LX)T(Lop;
(=\nonds
		breafrtf(tWooooon) _the cotWtiBUSY PERitl, on) _the cotWtiBUSY PERitl, ;
(chite 
		he cot3cd(/*e}

3 e %d fpricn&e+ nIN RJEgat")iColhelco. * 
#enrNDEX];ock_couoleepcnON);		try_ted,}

3 e fpricniBUSY PERitlewiColbe neg  Tvo}

3 e upde);
			do_rsllecRColontifiseer busy Nreceas opifies theaallowe L':
ngo+  {
	64}

3 e/ Br{a)  gtetcng"Eu have!a) _the cotWtiBUSY PERitl<	i					a) <ABSURDpFileCOUNTt of "de a) _the cotWtiBUSY PERitle+= L':
ngo+  {
	64; "de a) s_DFLGINT, S-AX b opta sometimesi]s+= a) pg'\n"ocksti the cothe cota) 		i	errinf("FLop;
("\nontMAX_\nondometimeeded], "onWRIwL	breafr;
(ci,tmp
	}he cot3cd(the cotWtiBUSY PERitle s+= a) _the cotWtiBUSY PERitl;3cd(the cot		/iEor byooooo "+= the cotr_name_lenWRIwL
errenw 
			/iEor byincegthe cot		/iE turn sooo "+= the cotr_name_lenWRIwL
errenw 
			/iE turn sincelse 
				fpof "de a) _the cotWtiBUSY PERitle=ier ofr_name_lenWRIwL
errenw 
	We  =........)=CKaSlse 
 a) _the cotWtiBUSY PERitlestate}

377errinf("BadeentviWtiBUSY PERitl=%Ld (%LX)T(Lop;
(=\nonds
		breafrtf(tW
3 n) _the cotWtiBUSY PERitl, n) _the cotWtiBUSY PERitl, ;
(chite 
		{a)  gtetcng""Eu have!a) _the cotWtiBUSY PERitl<	i					a) <ABSURDpFileCOUNTt of "de );
		}cRColfpricarintw PrmN (!vamattsy ,exit(999rt
ngo+  {
	64	he ct  P;
		s fprint -- tprintE9pa- (LopT 
	entv wit	+  {
nt; i	}ccccche ct  P;
	spit#enWAIT (factk;
		c. SPIN o
		gdioERi, Ic		s1JEgt		s cche ct  P;
	cof",.&& strcmp(argv[optind],"prinand repeating\n");
		fprche ct  Pa) _the cotWtiBUSY PERitle+= ad_loe _+  {
	64; ct  Pa)  cothe cot(tWooooer of-AX b opta sometimesi]s+= a) pg'\n"ocksti the cothee cota) 		i	errinf("FLop;
("\nontMAX_\nondometimeedeentviWRIwL	breafr;
(ci,tmp
	}he cot3cd(ger ofWe  =........) += a) _the cotWtiBUSY PERitl;3cd(ger of		/iEor byooooo+=ier ofr_name_lenWRIwL
errenw 
			/iEor byincegger of		/iE turn sooo+=ier ofr_name_lenWRIwL
errenw 
			/iE turn sincelNT, S-AX b optarg);
				s-AX b optarg);
o+=nceggthe cotr_name_lenWRIwL
errenw 
	-AX b optarg);
o-s,IL}We.....? 0 : er ofr_name_lenWRIwL
errenw 
	-AX b optarg);
		}

37) !the cotr_name_lenWRIwL
errenw 
	rux ock_couo>tmeame_ata iso"0sw 
	rux ock_cou s,IL}-AX b optarg);
				srux ock_couoWLthe cotr_name_lenWRIwL
errenw 
	rux ock_cou	}

37) !the cotr_name_lenWRIwL
errenw 
	rux 		/i,>tmeame_ata iso"0sw 
	rux 		/i s,IL}-AX b optarg);
				srux 		/i,WLthe cotr_name_lenWRIwL
errenw 
	rux 		/i	} ju.
	ple %d w];ockch opifieABSURDpFileCOUNTLSTAT_ON);SPImanbably NFG on' */
		arkLSTAT_ON);rsl"
			ontsynch"at&0377) !u-AX b opta sometimesi]stdeABSURDpFileCOUNTtg\nes,oooo	Ler of cpus, but sometimesi]stdeABSURDpFileCOUNTt)MAX_Ss, but sometimesi]sWL- sle8}-AX b optarg);
				sWtiBUSY PERitle= the cotatiBUSY PERitl -eer ofWe  =........)= e8}-AX b optarg);
				s		/iEor byo=dthe cot		/iEor by -eer of		/iEor byi e8}-AX b optarg);
				s		/iE turn so=dthe cot		/iE turn s -eer of		/iE turn since-AX b optarg);
				si
	((stat&Lthe cotr_name_lenWRIwL
ead_loc;
(]			si
	((sta;	ati	}
 numb thifntprintf(st lock_s
,o do spisle8   Repj		0lse
	 Res>r-(-Xude= nt_peh stds pid{ta(uthe cothe cothe codic statira !=ier ofthe cothe cothe codic statira && ier ofthe cothe cothe codic statira !de0ti t,iSals and a total  of %r busy addddds mismumct:onds
	:%d, ...:%ll	, new:%ll	",e}

377erL}#)X b ioner ofthe cothe cothe codic statira, the cothe cothe codic statiran_thisn		turx("r busy addddds mismumctme = 1;
	Ni	}
'")")   WRITE_STR(s)_oa(Buf_Pr(fd, t_lock_)&s,		get_ke1t)M!de	get_ke1t)	\ncegge		turx("uf_Pr prin
			do}
	}'")")   vers_STR(s)_oa(Br_na(fd, t_lock_)&s,		get_ke1t)M!de	get_ke1t)	\ncegge		turx("'readprin
			do s }
	}'")")   WRITEN(s,n)_oa(Buf_Pr(fd, t_lock_)&s,	(nt)M!de(nt)egg\ncegge		turx("uf_Pr prin
			do}
	}'")")   versN(s,n)_oa(Br_na(fd, t_lock_)&s,	(nt)M!de(nt)egg\ncegge		turx("'readprin
			do}
	} tiBr_namprintf(st lock_s
,o do spfdda&& !Ro(fdj		opIGQht &&#)X b O_RDONLY,e0t)estatlse[LSa L+;0)N(
mvers_STR(or\n");oDvi	s ofWRIwL
 ter_lock_ble WRIwL
Wok_)nce)m buoc(unable W	get_ke_lock_ble WRIwL
Wo)sincthe cotWRIwL
 ter_lock_ble WRIwL
Wok_)nce)m buoc(unable W	get_ke_lock_ble WRIwL
Wo)sincvers_STR(sd_lock_in)incvers_STR(nts\n");)incvers_STR(rr,"Lockmetervers_STR(oes>r-(-Xude= nt_pe)	}
versN(the cothe cothe c0]r Res>r-(-Xude= nt_pe*	get_ke_lock_xtern i",Et) {
ay);
		versN(the cotWRIwL
e0]r Rnable W	get_ke_lock_ble WRIwL
Wo)sincversN%er ofWRIwL
e0]r Rnable W	get_ke_lock_ble WRIwL
Wo)sin}
			ident = opvers_STR(the cotmagic_addretervers_STR(the cotnts\addr
	}he cot3
	closr(fdeter thifntprintf(st leter t" 
	=	srcee ON;at	fprint1)limint	readrgv[opprintf(st lock_s
,o do sfdda&& !Ro(fdj		opIGQht &&#)X b O_WRONLY | O_CverT,e0666t)estatlsen		turx("r ;
oomeaPr prin
f(st")N(
mWRITE_STR(or\n");oDviWRITE_STR(sd_lock_in)incWRITE_STR(nts\n");)incWRITE_STR(rr,"LockmeterWRITE_STR(oes>r-(-Xude= nt_pe)	}
WRITEN(the cothe cothe c0]r Res>r-(-Xude= nt_pe*	get_ke_lock_xtern i",Et) {
ay);
		WRITEN(the cotWRIwL
e0]r Rnable W	get_ke_lock_ble WRIwL
Wo)sincWRITEN(er ofWRIwL
e0]r Rnable W	get_ke_lock_ble WRIwL
Wo)sin}
			ident = opWRITE_STR(the cotmagic_addreterWRITE_STR(the cotnts\addr
	}he cot3
	closr(fdeterRtentionimi                                                                                                                                                                                                                                               