/*
 * Copyright (c) 2014 MediaTek Inc.
 * Author: Hongzhou.Yang <hongzhou.yang@mediatek.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifndef __PINCTRL_MTK_MT8135_H
#define __PINCTRL_MTK_MT8135_H

#include <linux/pinctrl/pinctrl.h>
#include "pinctrl-mtk-common.h"

static const struct mtk_desc_pin mtk_pins_mt8135[] = {
	MTK_PIN(PINCTRL_PIN(0, "MSDC0_DAT7"),
		"D21", "mt8135",
		MTK_EINT_FUNCTION(2, 49),
		MTK_FUNCTION(0, "GPIO0"),
		MTK_FUNCTION(1, "MSDC0_DAT7"),
		MTK_FUNCTION(2, "EINT49"),
		MTK_FUNCTION(3, "I2SOUT_DAT"),
		MTK_FUNCTION(4, "DAC_DAT_OUT"),
		MTK_FUNCTION(5, "PCM1_DO"),
		MTK_FUNCTION(6, "SPI1_MO"),
		MTK_FUNCTION(7, "NALE")
	),
	MTK_PIN(PINCTRL_PIN(1, "MSDC0_DAT6"),
		"D22", "mt8135",
		MTK_EINT_FUNCTION(2, 48),
		MTK_FUNCTION(0, "GPIO1"),
		MTK_FUNCTION(1, "MSDC0_DAT6"),
		MTK_FUNCTION(2, "EINT48"),
		MTK_FUNCTION(3, "I2SIN_WS"),
		MTK_FUNCTION(4, "DAC_WS"),
		MTK_FUNCTION(5, "PCM1_WS"),
		MTK_FUNCTION(6, "SPI1_CSN"),
		MTK_FUNCTION(7, "NCLE")
	),
	MTK_PIN(PINCTRL_PIN(2, "MSDC0_DAT5"),
		"E22", "mt8135",
		MTK_EINT_FUNCTION(2, 47),
		MTK_FUNCTION(0, "GPIO2"),
		MTK_FUNCTION(1, "MSDC0_DAT5"),
		MTK_FUNCTION(2, "EINT47"),
		MTK_FUNCTION(3, "I2SIN_CK"),
		MTK_FUNCTION(4, "DAC_CK"),
		MTK_FUNCTION(5, "PCM1_CK"),
		MTK_FUNCTION(6, "SPI1_CLK"),
		MTK_FUNCTION(7, "NLD4")
	),
	MTK_PIN(PINCTRL_PIN(3, "MSDC0_DAT4"),
		"F21", "mt8135",
		MTK_EINT_FUNCTION(2, 46),
		MTK_FUNCTION(0, "GPIO3"),
		MTK_FUNCTION(1, "MSDC0_DAT4"),
		MTK_FUNCTION(2, "EINT46"),
		MTK_FUNCTION(3, "A_FUNC_CK"),
		MTK_FUNCTION(6, "LSCE1B_2X"),
		MTK_FUNCTION(7, "NLD5")
	),
	MTK_PIN(PINCTRL_PIN(4, "MSDC0_CMD"),
		"F20", "mt8135",
		MTK_EINT_FUNCTION(2, 41),
		MTK_FUNCTION(0, "GPIO4"),
		MTK_FUNCTION(1, "MSDC0_CMD"),
		MTK_FUNCTION(2, "EINT41"),
		MTK_FUNCTION(3, "A_FUNC_DOUT[0]"),
		MTK_FUNCTION(5, "USB_TEST_IO[0]"),
		MTK_FUNCTION(6, "LRSTB_2X"),
		MTK_FUNCTION(7, "NRNB")
	),
	MTK_PIN(PINCTRL_PIN(5, "MSDC0_CLK"),
		"G18", "mt8135",
		MTK_EINT_FUNCTION(2, 40),
		MTK_FUNCTION(0, "GPIO5"),
		MTK_FUNCTION(1, "MSDC0_CLK"),
		MTK_FUNCTION(2, "EINT40"),
		MTK_FUNCTION(3, "A_FUNC_DOUT[1]"),
		MTK_FUNCTION(5, "USB_TEST_IO[1]"),
		MTK_FUNCTION(6, "LPTE"),
		MTK_FUNCTION(7, "NREB")
	),
	MTK_PIN(PINCTRL_PIN(6, "MSDC0_DAT3"),
		"G21", "mt8135",
		MTK_EINT_FUNCTION(2, 45),
		MTK_FUNCTION(0, "GPIO6"),
		MTK_FUNCTION(1, "MSDC0_DAT3"),
		MTK_FUNCTION(2, "EINT45"),
		MTK_FUNCTION(3, "A_FUNC_DOUT[2]"),
		MTK_FUNCTION(5, "USB_TEST_IO[2]"),
		MTK_FUNCTION(6, "LSCE0B_2X"),
		MTK_FUNCTION(7, "NLD7")
	),
	MTK_PIN(PINCTRL_PIN(7, "MSDC0_DAT2"),
		"E21", "mt8135",
		MTK_EINT_FUNCTION(2, 44),
		MTK_FUNCTION(0, "GPIO7"),
		MTK_FUNCTION(1, "MSDC0_DAT2"),
		MTK_FUNCTION(2, "EINT44"),
		MTK_FUNCTION(3, "A_FUNC_DOUT[3]"),
		MTK_FUNCTION(5, "USB_TEST_IO[3]"),
		MTK_FUNCTION(6, "LSA0_2X"),
		MTK_FUNCTION(7, "NLD14")
	),
	MTK_PIN(PINCTRL_PIN(8, "MSDC0_DAT1"),
		"E23", "mt8135",
		MTK_EINT_FUNCTION(2, 43),
		MTK_FUNCTION(0, "GPIO8"),
		MTK_FUNCTION(1, "MSDC0_DAT1"),
		MTK_FUNCTION(2, "EINT43"),
		MTK_FUNCTION(5, "USB_TEST_IO[4]"),
		MTK_FUNCTION(6, "LSCK_2X"),
		MTK_FUNCTION(7, "NLD11")
	),
	MTK_PIN(PINCTRL_PIN(9, "MSDC0_DAT0"),
		"F22", "mt8135",
		MTK_EINT_FUNCTION(2, 42),
		MTK_FUNCTION(0, "GPIO9"),
		MTK_FUNCTION(1, "MSDC0_DAT0"),
		MTK_FUNCTION(2, "EINT42"),
		MTK_FUNCTION(5, "USB_TEST_IO[5]"),
		MTK_FUNCTION(6, "LSDA_2X")
	),
	MTK_PIN(PINCTRL_PIN(10, "NCEB0"),
		"G20", "mt8135",
		MTK_EINT_FUNCTION(2, 139),
		MTK_FUNCTION(0, "GPIO10"),
		MTK_FUNCTION(1, "NCEB0"),
		MTK_FUNCTION(2, "EINT139"),
		MTK_FUNCTION(7, "TESTA_OUT4")
	),
	MTK_PIN(PINCTRL_PIN(11, "NCEB1"),
		"L17", "mt8135",
		MTK_EINT_FUNCTION(2, 140),
		MTK_FUNCTION(0, "GPIO11"),
		MTK_FUNCTION(1, "NCEB1"),
		MTK_FUNCTION(2, "EINT140"),
		MTK_FUNCTION(6, "USB_DRVVBUS"),
		MTK_FUNCTION(7, "TESTA_OUT5")
	),
	MTK_PIN(PINCTRL_PIN(12, "NRNB"),
		"G19", "mt8135",
		MTK_EINT_FUNCTION(2, 141),
		MTK_FUNCTION(0, "GPIO12"),
		MTK_FUNCTION(1, "NRNB"),
		MTK_FUNCTION(2, "EINT141"),
		MTK_FUNCTION(3, "A_FUNC_DOUT[4]"),
		MTK_FUNCTION(7, "TESTA_OUT6")
	),
	MTK_PIN(PINCTRL_PIN(13, "NCLE"),
		"J18", "mt8135",
		MTK_EINT_FUNCTION(2, 142),
		MTK_FUNCTION(0, "GPIO13"),
		MTK_FUNCTION(1, "NCLE"),
		MTK_FUNCTION(2, "EINT142"),
		MTK_FUNCTION(3, "A_FUNC_DOUT[5]"),
		MTK_FUNCTION(4, "CM2PDN_1X"),
		MTK_FUNCTION(6, "NALE"),
		MTK_FUNCTION(7, "TESTA_OUT7")
	),
	MTK_PIN(PINCTRL_PIN(14, "NALE"),
		"J19", "mt8135",
		MTK_EINT_FUNCTION(2, 143),
		MTK_FUNCTION(0, "GPIO14"),
		MTK_FUNCTION(1, "NALE"),
		MTK_FUNCTION(2, "EINT143"),
		MTK_FUNCTION(3, "A_FUNC_DOUT[6]"),
		MTK_FUNCTION(4, "CM2MCLK_1X"),
		MTK_FUNCTION(5, "IRDA_RXD"),
		MTK_FUNCTION(6, "NCLE"),
		MTK_FUNCTION(7, "TESTA_OUT8")
	),
	MTK_PIN(PINCTRL_PIN(15, "NREB"),
		"L18", "mt8135",
		MTK_EINT_FUNCTION(2, 144),
		MTK_FUNCTION(0, "GPIO15"),
		MTK_FUNCTION(1, "NREB"),
		MTK_FUNCTION(2, "EINT144"),
		MTK_FUNCTION(3, "A_FUNC_DOUT[7]"),
		MTK_FUNCTION(4, "CM2RST_1X"),
		MTK_FUNCTION(5, "IRDA_TXD"),
		MTK_FUNCTION(7, "TESTA_OUT9")
	),
	MTK_PIN(PINCTRL_PIN(16, "NWEB"),
		"J20", "mt8135",
		MTK_EINT_FUNCTION(2, 145),
		MTK_FUNCTION(0, "GPIO16"),
		MTK_FUNCTION(1, "NWEB"),
		MTK_FUNCTION(2, "EINT145"),
		MTK_FUNCTION(3, "A_FUNC_DIN[0]"),
		MTK_FUNCTION(4, "CM2PCLK_1X"),
		MTK_FUNCTION(5, "IRDA_PDN"),
		MTK_FUNCTION(7, "TESTA_OUT10")
	),
	MTK_PIN(PINCTRL_PIN(17, "NLD0"),
		"K21", "mt8135",
		MTK_EINT_FUNCTION(2, 146),
		MTK_FUNCTION(0, "GPIO17"),
		MTK_FUNCTION(1, "NLD0"),
		MTK_FUNCTION(2, "EINT146"),
		MTK_FUNCTION(3, "A_FUNC_DIN[1]"),
		MTK_FUNCTION(4, "CM2DAT_1X[0]"),
		MTK_FUNCTION(5, "I2SIN_CK"),
		MTK_FUNCTION(6, "DAC_CK"),
		MTK_FUNCTION(7, "TESTA_OUT11")
	),
	MTK_PIN(PINCTRL_PIN(18, "NLD1"),
		"K22", "mt8135",
		MTK_EINT_FUNCTION(2, 147),
		MTK_FUNCTION(0, "GPIO18"),
		MTK_FUNCTION(1, "NLD1"),
		MTK_FUNCTION(2, "EINT147"),
		MTK_FUNCTION(3, "A_FUNC_DIN[2]"),
		MTK_FUNCTION(4, "CM2DAT_1X[1]"),
		MTK_FUNCTION(5, "I2SIN_WS"),
		MTK_FUNCTION(6, "DAC_WS"),
		MTK_FUNCTION(7, "TESTA_OUT12")
	),
	MTK_PIN(PINCTRL_PIN(19, "NLD2"),
		"J21", "mt8135",
		MTK_EINT_FUNCTION(2, 148),
		MTK_FUNCTION(0, "GPIO19"),
		MTK_FUNCTION(1, "NLD2"),
		MTK_FUNCTION(2, "EINT148"),
		MTK_FUNCTION(3, "A_FUNC_DIN[3]"),
		MTK_FUNCTION(4, "CM2DAT_1X[2]"),
		MTK_FUNCTION(5, "I2SOUT_DAT"),
		MTK_FUNCTION(6, "DAC_DAT_OUT"),
		MTK_FUNCTION(7, "TESTA_OUT13")
	),
	MTK_PIN(PINCTRL_PIN(20, "NLD3"),
		"J23", "mt8135",
		MTK_EINT_FUNCTION(2, 149),
		MTK_FUNCTION(0, "GPIO20"),
		MTK_FUNCTION(1, "NLD3"),
		MTK_FUNCTION(2, "EINT149"),
		MTK_FUNCTION(3, "A_FUNC_DIN[4]"),
		MTK_FUNCTION(4, "CM2DAT_1X[3]"),
		MTK_FUNCTION(7, "TESTA_OUT14")
	),
	MTK_PIN(PINCTRL_PIN(21, "NLD4"),
		"J22", "mt8135",
		MTK_EINT_FUNCTION(2, 150),
		MTK_FUNCTION(0, "GPIO21"),
		MTK_FUNCTION(1, "NLD4"),
		MTK_FUNCTION(2, "EINT150"),
		MTK_FUNCTION(3, "A_FUNC_DIN[5]"),
		MTK_FUNCTION(4, "CM2DAT_1X[4]"),
		MTK_FUNCTION(7, "TESTA_OUT15")
	),
	MTK_PIN(PINCTRL_PIN(22, "NLD5"),
		"H21", "mt8135",
		MTK_EINT_FUNCTION(2, 151),
		MTK_FUNCTION(0, "GPIO22"),
		MTK_FUNCTION(1, "NLD5"),
		MTK_FUNCTION(2, "EINT151"),
		MTK_FUNCTION(3, "A_FUNC_DIN[6]"),
		MTK_FUNCTION(4, "CM2DAT_1X[5]"),
		MTK_FUNCTION(7, "TESTA_OUT16")
	),
	MTK_PIN(PINCTRL_PIN(23, "NLD6"),
		"H22", "mt8135",
		MTK_EINT_FUNCTION(2, 152),
		MTK_FUNCTION(0, "GPIO23"),
		MTK_FUNCTION(1, "NLD6"),
		MTK_FUNCTION(2, "EINT152"),
		MTK_FUNCTION(3, "A_FUNC_DIN[7]"),
		MTK_FUNCTION(4, "CM2DAT_1X[6]"),
		MTK_FUNCTION(7, "TESTA_OUT17")
	),
	MTK_PIN(PINCTRL_PIN(24, "NLD7"),
		"H20", "mt8135",
		MTK_EINT_FUNCTION(2, 153),
		MTK_FUNCTION(0, "GPIO24"),
		MTK_FUNCTION(1, "NLD7"),
		MTK_FUNCTION(2, "EINT153"),
		MTK_FUNCTION(3, "A_FUNC_DIN[8]"),
		MTK_FUNCTION(4, "CM2DAT_1X[7]"),
		MTK_FUNCTION(7, "TESTA_OUT18")
	),
	MTK_PIN(PINCTRL_PIN(25, "NLD8"),
		NULL, "mt8135",
		MTK_EINT_FUNCTION(2, 154),
		MTK_FUNCTION(0, "GPIO25"),
		MTK_FUNCTION(1, "NLD8"),
		MTK_FUNCTION(2, "EINT154"),
		MTK_FUNCTION(4, "CM2DAT_1X[8]")
	),
	MTK_PIN(PINCTRL_PIN(26, "NLD9"),
		NULL, "mt8135",
		MTK_EINT_FUNCTION(2, 155),
		MTK_FUNCTION(0, "GPIO26"),
		MTK_FUNCTION(1, "NLD9"),
		MTK_FUNCTION(2, "EINT155"),
		MTK_FUNCTION(4, "CM2DAT_1X[9]"),
		MTK_FUNCTION(5, "PWM1")
	),
	MTK_PIN(PINCTRL_PIN(27, "NLD10"),
		NULL, "mt8135",
		MTK_EINT_FUNCTION(2, 156),
		MTK_FUNCTION(0, "GPIO27"),
		MTK_FUNCTION(1, "NLD10"),
		MTK_FUNCTION(2, "EINT156"),
		MTK_FUNCTION(4, "CM2VSYNC_1X"),
		MTK_FUNCTION(5, "PWM2")
	),
	MTK_PIN(PINCTRL_PIN(28, "NLD11"),
		NULL, "mt8135",
		MTK_EINT_FUNCTION(2, 157),
		MTK_FUNCTION(0, "GPIO28"),
		MTK_FUNCTION(1, "NLD11"),
		MTK_FUNCTION(2, "EINT157"),
		MTK_FUNCTION(4, "CM2HSYNC_1X"),
		MTK_FUNCTION(5, "PWM3")
	),
	MTK_PIN(PINCTRL_PIN(29, "NLD12"),
		NULL, "mt8135",
		MTK_EINT_FUNCTION(2, 158),
		MTK_FUNCTION(0, "GPIO29"),
		MTK_FUNCTION(1, "NLD12"),
		MTK_FUNCTION(2, "EINT158"),
		MTK_FUNCTION(3, "I2SIN_CK"),
		MTK_FUNCTION(4, "DAC_CK"),
		MTK_FUNCTION(5, "PCM1_CK")
	),
	MTK_PIN(PINCTRL_PIN(30, "NLD13"),
		NULL, "mt8135",
		MTK_EINT_FUNCTION(2, 159),
		MTK_FUNCTION(0, "GPIO30"),
		MTK_FUNCTION(1, "NLD13"),
		MTK_FUNCTION(2, "EINT159"),
		MTK_FUNCTION(3, "I2SIN_WS"),
		MTK_FUNCTION(4, "DAC_WS"),
		MTK_FUNCTION(5, "PCM1_WS")
	),
	MTK_PIN(PINCTRL_PIN(31, "NLD14"),
		NULL, "mt8135",
		MTK_EINT_FUNCTION(2, 160),
		MTK_FUNCTION(0, "GPIO31"),
		MTK_FUNCTION(1, "NLD14"),
		MTK_FUNCTION(2, "EINT160"),
		MTK_FUNCTION(3, "I2SOUT_DAT"),
		MTK_FUNCTION(4, "DAC_DAT_OUT"),
		MTK_FUNCTION(5, "PCM1_DO")
	),
	MTK_PIN(PINCTRL_PIN(32, "NLD15"),
		NULL, "mt8135",
		MTK_EINT_FUNCTION(2, 161),
		MTK_FUNCTION(0, "GPIO32"),
		MTK_FUNCTION(1, "NLD15"),
		MTK_FUNCTION(2, "EINT161"),
		MTK_FUNCTION(3, "DISP_PWM"),
		MTK_FUNCTION(4, "PWM4"),
		MTK_FUNCTION(5, "PCM1_DI")
	),
	MTK_PIN(PINCTRL_PIN(33, "MSDC0_RSTB"),
		"G22", "mt8135",
		MTK_EINT_FUNCTION(2, 50),
		MTK_FUNCTION(0, "GPIO33"),
		MTK_FUNCTION(1, "MSDC0_RSTB"),
		MTK_FUNCTION(2, "EINT50"),
		MTK_FUNCTION(3, "I2SIN_DAT"),
		MTK_FUNCTION(5, "PCM1_DI"),
		MTK_FUNCTION(6, "SPI1_MI"),
		MTK_FUNCTION(7, "NLD10")
	),
	MTK_PIN(PINCTRL_PIN(34, "IDDIG"),
		"N17", "mt8135",
		MTK_EINT_FUNCTION(2, 34),
		MTK_FUNCTION(0, "GPIO34"),
		MTK_FUNCTION(1, "IDDIG"),
		MTK_FUNCTION(2, "EINT34")
	),
	MTK_PIN(PINCTRL_PIN(35, "SCL3"),
		"L19", "mt8135",
		MTK_EINT_FUNCTION(2, 96),
		MTK_FUNCTION(0, "GPIO35"),
		MTK_FUNCTION(1, "SCL3"),
		MTK_FUNCTION(2, "EINT96"),
		MTK_FUNCTION(3, "CLKM6"),
		MTK_FUNCTION(4, "PWM6")
	),
	MTK_PIN(PINCTRL_PIN(36, "SDA3"),
		"L20", "mt8135",
		MTK_EINT_FUNCTION(2, 97),
		MTK_FUNCTION(0, "GPIO36"),
		MTK_FUNCTION(1, "SDA3"),
		MTK_FUNCTION(2, "EINT97")
	),
	MTK_PIN(PINCTRL_PIN(37, "AUD_CLK_MOSI"),
		"L21", "mt8135",
		MTK_EINT_FUNCTION(4, 19),
		MTK_FUNCTION(0, "GPIO37"),
		MTK_FUNCTION(1, "AUD_CLK"),
		MTK_FUNCTION(2, "ADC_CK"),
		MTK_FUNCTION(3, " HDMI_SDATA0"),
		MTK_FUNCTION(4, "EINT19"),
		MTK_FUNCTION(5, "USB_TEST_IO[6]"),
		MTK_FUNCTION(7, "TESTA_OUT19")
	),
	MTK_PIN(PINCTRL_PIN(38, "AUD_DAT_MOSI"),
		"L23", "mt8135",
		MTK_EINT_FUNCTION(4, 21),
		MTK_FUNCTION(0, "GPIO38"),
		MTK_FUNCTION(1, "AUD_DAT_MOSI"),
		MTK_FUNCTION(2, "ADC_WS"),
		MTK_FUNCTION(3, "AUD_DAT_MISO"),
		MTK_FUNCTION(4, "EINT21"),
		MTK_FUNCTION(5, "USB_TEST_IO[7]"),
		MTK_FUNCTION(7, "TESTA_OUT20")
	),
	MTK_PIN(PINCTRL_PIN(39, "AUD_DAT_MISO"),
		"L22", "mt8135",
		MTK_EINT_FUNCTION(4, 20),
		MTK_FUNCTION(0, "GPIO39"),
		MTK_FUNCTION(1, "AUD_DAT_MISO"),
		MTK_FUNCTION(2, "ADC_DAT_IN"),
		MTK_FUNCTION(3, "AUD_DAT_MOSI"),
		MTK_FUNCTION(4, "EINT20"),
		MTK_FUNCTION(5, "USB_TEST_IO[8]"),
		MTK_FUNCTION(7, "TESTA_OUT21")
	),
	MTK_PIN(PINCTRL_PIN(40, "DAC_CLK"),
		"P21", "mt8135",
		MTK_EINT_FUNCTION(2, 22),
		MTK_FUNCTION(0, "GPIO40"),
		MTK_FUNCTION(1, "DAC_CK"),
		MTK_FUNCTION(2, "EINT22"),
		MTK_FUNCTION(3, " HDMI_SDATA1"),
		MTK_FUNCTION(5, "USB_TEST_IO[9]"),
		MTK_FUNCTION(7, "TESTA_OUT22")
	),
	MTK_PIN(PINCTRL_PIN(41, "DAC_WS"),
		"N18", "mt8135",
		MTK_EINT_FUNCTION(2, 24),
		MTK_FUNCTION(0, "GPIO41"),
		MTK_FUNCTION(1, "DAC_WS"),
		MTK_FUNCTION(2, "EINT24"),
		MTK_FUNCTION(3, " HDMI_SDATA2"),
		MTK_FUNCTION(5, "USB_TEST_IO[10]"),
		MTK_FUNCTION(7, "TESTA_OUT23")
	),
	MTK_PIN(PINCTRL_PIN(42, "DAC_DAT_OUT"),
		"N22", "mt8135",
		MTK_EINT_FUNCTION(2, 23),
		MTK_FUNCTION(0, "GPIO42"),
		MTK_FUNCTION(1, "DAC_DAT_OUT"),
		MTK_FUNCTION(2, "EINT23"),
		MTK_FUNCTION(3, " HDMI_SDATA3"),
		MTK_FUNCTION(5, "USB_TEST_IO[11]"),
		MTK_FUNCTION(7, "TESTA_OUT24")
	),
	MTK_PIN(PINCTRL_PIN(43, "PWRAP_SPI0_MO"),
		"M22", "mt8135",
		MTK_EINT_FUNCTION(2, 29),
		MTK_FUNCTION(0, "GPIO43"),
		MTK_FUNCTION(1, "PWRAP_SPIDI"),
		MTK_FUNCTION(2, "EINT29")
	),
	MTK_PIN(PINCTRL_PIN(44, "PWRAP_SPI0_MI"),
		"P23", "mt8135",
		MTK_EINT_FUNCTION(2, 28),
		MTK_FUNCTION(0, "GPIO44"),
		MTK_FUNCTION(1, "PWRAP_SPIDO"),
		MTK_FUNCTION(2, "EINT28")
	),
	MTK_PIN(PINCTRL_PIN(45, "PWRAP_SPI0_CSN"),
		"M21", "mt8135",
		MTK_EINT_FUNCTION(2, 27),
		MTK_FUNCTION(0, "GPIO45"),
		MTK_FUNCTION(1, "PWRAP_SPICS_B_I"),
		MTK_FUNCTION(2, "EINT27")
	),
	MTK_PIN(PINCTRL_PIN(46, "PWRAP_SPI0_CLK"),
		"P22", "mt8135",
		MTK_EINT_FUNCTION(2, 26),
		MTK_FUNCTION(0, "GPIO46"),
		MTK_FUNCTION(1, "PWRAP_SPICK_I"),
		MTK_FUNCTION(2, "EINT26")
	),
	MTK_PIN(PINCTRL_PIN(47, "PWRAP_EVENT"),
		"M23", "mt8135",
		MTK_EINT_FUNCTION(2, 25),
		MTK_FUNCTION(0, "GPIO47"),
		MTK_FUNCTION(1, "PWRAP_EVENT_IN"),
		MTK_FUNCTION(2, "EINT25"),
		MTK_FUNCTION(7, "TESTA_OUT2")
	),
	MTK_PIN(PINCTRL_PIN(48, "RTC32K_CK"),
		"N20", "mt8135",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO48"),
		MTK_FUNCTION(1, "RTC32K_CK")
	),
	MTK_PIN(PINCTRL_PIN(49, "WATCHDOG"),
		"R22", "mt8135",
		MTK_EINT_FUNCTION(2, 36),
		MTK_FUNCTION(0, "GPIO49"),
		MTK_FUNCTION(1, "WATCHDOG"),
		MTK_FUNCTION(2, "EINT36")
	),
	MTK_PIN(PINCTRL_PIN(50, "SRCLKENA"),
		"T22", "mt8135",
		MTK_EINT_FUNCTION(2, 38),
		MTK_FUNCTION(0, "GPIO50"),
		MTK_FUNCTION(1, "SRCLKENA"),
		MTK_FUNCTION(2, "EINT38")
	),
	MTK_PIN(PINCTRL_PIN(51, "SRCVOLTEN"),
		"T23", "mt8135",
		MTK_EINT_FUNCTION(2, 37),
		MTK_FUNCTION(0, "GPIO51"),
		MTK_FUNCTION(1, "SRCVOLTEN"),
		MTK_FUNCTION(2, "EINT37")
	),
	MTK_PIN(PINCTRL_PIN(52, "EINT0"),
		"T21", "mt8135",
		MTK_EINT_FUNCTION(1, 0),
		MTK_FUNCTION(0, "GPIO52"),
		MTK_FUNCTION(1, "EINT0"),
		MTK_FUNCTION(2, "PWM1"),
		MTK_FUNCTION(3, "CLKM0"),
		MTK_FUNCTION(4, " SPDIF_OUT"),
		MTK_FUNCTION(5, "USB_TEST_IO[12]"),
		MTK_FUNCTION(7, "USB_SCL")
	),
	MTK_PIN(PINCTRL_PIN(53, "URXD2"),
		"R18", "mt8135",
		MTK_EINT_FUNCTION(2, 83),
		MTK_FUNCTION(0, "GPIO53"),
		MTK_FUNCTION(1, "URXD2"),
		MTK_FUNCTION(2, "EINT83"),
		MTK_FUNCTION(4, " HDMI_LRCK"),
		MTK_FUNCTION(5, "CLKM3"),
		MTK_FUNCTION(7, "UTXD2")
	),
	MTK_PIN(PINCTRL_PIN(54, "UTXD2"),
		"R17", "mt8135",
		MTK_EINT_FUNCTION(2, 82),
		MTK_FUNCTION(0, "GPIO54"),
		MTK_FUNCTION(1, "UTXD2"),
		MTK_FUNCTION(2, "EINT82"),
		MTK_FUNCTION(4, " HDMI_BCK_OUT"),
		MTK_FUNCTION(5, "CLKM2"),
		MTK_FUNCTION(7, "URXD2")
	),
	MTK_PIN(PINCTRL_PIN(55, "UCTS2"),
		"R20", "mt8135",
		MTK_EINT_FUNCTION(2, 84),
		MTK_FUNCTION(0, "GPIO55"),
		MTK_FUNCTION(1, "UCTS2"),
		MTK_FUNCTION(2, "EINT84"),
		MTK_FUNCTION(5, "PWM1"),
		MTK_FUNCTION(7, "URTS2")
	),
	MTK_PIN(PINCTRL_PIN(56, "URTS2"),
		"R19", "mt8135",
		MTK_EINT_FUNCTION(2, 85),
		MTK_FUNCTION(0, "GPIO56"),
		MTK_FUNCTION(1, "URTS2"),
		MTK_FUNCTION(2, "EINT85"),
		MTK_FUNCTION(5, "PWM2"),
		MTK_FUNCTION(7, "UCTS2")
	),
	MTK_PIN(PINCTRL_PIN(57, "JTCK"),
		"V17", "mt8135",
		MTK_EINT_FUNCTION(2, 188),
		MTK_FUNCTION(0, "GPIO57"),
		MTK_FUNCTION(1, "JTCK"),
		MTK_FUNCTION(2, "EINT188"),
		MTK_FUNCTION(3, "DSP1_ICK")
	),
	MTK_PIN(PINCTRL_PIN(58, "JTDO"),
		"T16", "mt8135",
		MTK_EINT_FUNCTION(2, 190),
		MTK_FUNCTION(0, "GPIO58"),
		MTK_FUNCTION(1, "JTDO"),
		MTK_FUNCTION(2, "EINT190"),
		MTK_FUNCTION(3, "DSP2_IMS")
	),
	MTK_PIN(PINCTRL_PIN(59, "JTRST_B"),
		"T19", "mt8135",
		MTK_EINT_FUNCTION(2, 0),
		MTK_FUNCTION(0, "GPIO59"),
		MTK_FUNCTION(1, "JTRST_B"),
		MTK_FUNCTION(2, "EINT0"),
		MTK_FUNCTION(3, "DSP2_ICK")
	),
	MTK_PIN(PINCTRL_PIN(60, "JTDI"),
		"T18", "mt8135",
		MTK_EINT_FUNCTION(2, 189),
		MTK_FUNCTION(0, "GPIO60"),
		MTK_FUNCTION(1, "JTDI"),
		MTK_FUNCTION(2, "EINT189"),
		MTK_FUNCTION(3, "DSP1_IMS")
	),
	MTK_PIN(PINCTRL_PIN(61, "JRTCK"),
		"T20", "mt8135",
		MTK_EINT_FUNCTION(2, 187),
		MTK_FUNCTION(0, "GPIO61"),
		MTK_FUNCTION(1, "JRTCK"),
		MTK_FUNCTION(2, "EINT187"),
		MTK_FUNCTION(3, "DSP1_ID")
	),
	MTK_PIN(PINCTRL_PIN(62, "JTMS"),
		"T17", "mt8135",
		MTK_EINT_FUNCTION(2, 191),
		MTK_FUNCTION(0, "GPIO62"),
		MTK_FUNCTION(1, "JTMS"),
		MTK_FUNCTION(2, "EINT191"),
		MTK_FUNCTION(3, "DSP2_ID")
	),
	MTK_PIN(PINCTRL_PIN(63, "MSDC1_INSI"),
		"V18", "mt8135",
		MTK_EINT_FUNCTION(1, 15),
		MTK_FUNCTION(0, "GPIO63"),
		MTK_FUNCTION(1, "MSDC1_INSI"),
		MTK_FUNCTION(3, "SCL5"),
		MTK_FUNCTION(4, "PWM6"),
		MTK_FUNCTION(5, "CLKM5"),
		MTK_FUNCTION(7, "TESTB_OUT6")
	),
	MTK_PIN(PINCTRL_PIN(64, "MSDC1_SDWPI"),
		"W18", "mt8135",
		MTK_EINT_FUNCTION(2, 58),
		MTK_FUNCTION(0, "GPIO64"),
		MTK_FUNCTION(1, "MSDC1_SDWPI"),
		MTK_FUNCTION(2, "EINT58"),
		MTK_FUNCTION(3, "SDA5"),
		MTK_FUNCTION(4, "PWM7"),
		MTK_FUNCTION(5, "CLKM6"),
		MTK_FUNCTION(7, "TESTB_OUT7")
	),
	MTK_PIN(PINCTRL_PIN(65, "MSDC2_INSI"),
		"U22", "mt8135",
		MTK_EINT_FUNCTION(1, 14),
		MTK_FUNCTION(0, "GPIO65"),
		MTK_FUNCTION(1, "MSDC2_INSI"),
		MTK_FUNCTION(5, "USB_TEST_IO[27]"),
		MTK_FUNCTION(7, "TESTA_OUT3")
	),
	MTK_PIN(PINCTRL_PIN(66, "MSDC2_SDWPI"),
		"U21", "mt8135",
		MTK_EINT_FUNCTION(2, 66),
		MTK_FUNCTION(0, "GPIO66"),
		MTK_FUNCTION(1, "MSDC2_SDWPI"),
		MTK_FUNCTION(2, "EINT66"),
		MTK_FUNCTION(5, "USB_TEST_IO[28]")
	),
	MTK_PIN(PINCTRL_PIN(67, "URXD4"),
		"V23", "mt8135",
		MTK_EINT_FUNCTION(2, 89),
		MTK_FUNCTION(0, "GPIO67"),
		MTK_FUNCTION(1, "URXD4"),
		MTK_FUNCTION(2, "EINT89"),
		MTK_FUNCTION(3, "URXD1"),
		MTK_FUNCTION(6, "UTXD4"),
		MTK_FUNCTION(7, "TESTB_OUT10")
	),
	MTK_PIN(PINCTRL_PIN(68, "UTXD4"),
		"V22", "mt8135",
		MTK_EINT_FUNCTION(2, 88),
		MTK_FUNCTION(0, "GPIO68"),
		MTK_FUNCTION(1, "UTXD4"),
		MTK_FUNCTION(2, "EINT88"),
		MTK_FUNCTION(3, "UTXD1"),
		MTK_FUNCTION(6, "URXD4"),
		MTK_FUNCTION(7, "TESTB_OUT11")
	),
	MTK_PIN(PINCTRL_PIN(69, "URXD1"),
		"W22", "mt8135",
		MTK_EINT_FUNCTION(2, 79),
		MTK_FUNCTION(0, "GPIO69"),
		MTK_FUNCTION(1, "URXD1"),
		MTK_FUNCTION(2, "EINT79"),
		MTK_FUNCTION(3, "URXD4"),
		MTK_FUNCTION(6, "UTXD1"),
		MTK_FUNCTION(7, "TESTB_OUT24")
	),
	MTK_PIN(PINCTRL_PIN(70, "UTXD1"),
		"V21", "mt8135",
		MTK_EINT_FUNCTION(2, 78),
		MTK_FUNCTION(0, "GPIO70"),
		MTK_FUNCTION(1, "UTXD1"),
		MTK_FUNCTION(2, "EINT78"),
		MTK_FUNCTION(3, "UTXD4"),
		MTK_FUNCTION(6, "URXD1"),
		MTK_FUNCTION(7, "TESTB_OUT25")
	),
	MTK_PIN(PINCTRL_PIN(71, "UCTS1"),
		"V19", "mt8135",
		MTK_EINT_FUNCTION(2, 80),
		MTK_FUNCTION(0, "GPIO71"),
		MTK_FUNCTION(1, "UCTS1"),
		MTK_FUNCTION(2, "EINT80"),
		MTK_FUNCTION(5, "CLKM0"),
		MTK_FUNCTION(6, "URTS1"),
		MTK_FUNCTION(7, "TESTB_OUT31")
	),
	MTK_PIN(PINCTRL_PIN(72, "URTS1"),
		"V20", "mt8135",
		MTK_EINT_FUNCTION(2, 81),
		MTK_FUNCTION(0, "GPIO72"),
		MTK_FUNCTION(1, "URTS1"),
		MTK_FUNCTION(2, "EINT81"),
		MTK_FUNCTION(5, "CLKM1"),
		MTK_FUNCTION(6, "UCTS1"),
		MTK_FUNCTION(7, "TESTB_OUT21")
	),
	MTK_PIN(PINCTRL_PIN(73, "PWM1"),
		"W17", "mt8135",
		MTK_EINT_FUNCTION(2, 73),
		MTK_FUNCTION(0, "GPIO73"),
		MTK_FUNCTION(1, "PWM1"),
		MTK_FUNCTION(2, "EINT73"),
		MTK_FUNCTION(5, "USB_DRVVBUS"),
		MTK_FUNCTION(6, "DISP_PWM"),
		MTK_FUNCTION(7, "TESTB_OUT8")
	),
	MTK_PIN(PINCTRL_PIN(74, "PWM2"),
		"Y17", "mt8135",
		MTK_EINT_FUNCTION(2, 74),
		MTK_FUNCTION(0, "GPIO74"),
		MTK_FUNCTION(1, "PWM2"),
		MTK_FUNCTION(2, "EINT74"),
		MTK_FUNCTION(3, "DPI33_CK"),
		MTK_FUNCTION(4, "PWM5"),
		MTK_FUNCTION(5, "URXD2"),
		MTK_FUNCTION(6, "DISP_PWM"),
		MTK_FUNCTION(7, "TESTB_OUT9")
	),
	MTK_PIN(PINCTRL_PIN(75, "PWM3"),
		"Y19", "mt8135",
		MTK_EINT_FUNCTION(2, 75),
		MTK_FUNCTION(0, "GPIO75"),
		MTK_FUNCTION(1, "PWM3"),
		MTK_FUNCTION(2, "EINT75"),
		MTK_FUNCTION(3, "DPI33_D0"),
		MTK_FUNCTION(4, "PWM6"),
		MTK_FUNCTION(5, "UTXD2"),
		MTK_FUNCTION(6, "DISP_PWM"),
		MTK_FUNCTION(7, "TESTB_OUT12")
	),
	MTK_PIN(PINCTRL_PIN(76, "PWM4"),
		"W19", "mt8135",
		MTK_EINT_FUNCTION(2, 76),
		MTK_FUNCTION(0, "GPIO76"),
		MTK_FUNCTION(1, "PWM4"),
		MTK_FUNCTION(2, "EINT76"),
		MTK_FUNCTION(3, "DPI33_D1"),
		MTK_FUNCTION(4, "PWM7"),
		MTK_FUNCTION(6, "DISP_PWM"),
		MTK_FUNCTION(7, "TESTB_OUT13")
	),
	MTK_PIN(PINCTRL_PIN(77, "MSDC2_DAT2"),
		"W21", "mt8135",
		MTK_EINT_FUNCTION(2, 63),
		MTK_FUNCTION(0, "GPIO77"),
		MTK_FUNCTION(1, "MSDC2_DAT2"),
		MTK_FUNCTION(2, "EINT63"),
		MTK_FUNCTION(4, "DSP2_IMS"),
		MTK_FUNCTION(6, "DPI33_D6"),
		MTK_FUNCTION(7, "TESTA_OUT25")
	),
	MTK_PIN(PINCTRL_PIN(78, "MSDC2_DAT3"),
		"AA23", "mt8135",
		MTK_EINT_FUNCTION(2, 64),
		MTK_FUNCTION(0, "GPIO78"),
		MTK_FUNCTION(1, "MSDC2_DAT3"),
		MTK_FUNCTION(2, "EINT64"),
		MTK_FUNCTION(4, "DSP2_ID"),
		MTK_FUNCTION(6, "DPI33_D7"),
		MTK_FUNCTION(7, "TESTA_OUT26")
	),
	MTK_PIN(PINCTRL_PIN(79, "MSDC2_CMD"),
		"Y22", "mt8135",
		MTK_EINT_FUNCTION(2, 60),
		MTK_FUNCTION(0, "GPIO79"),
		MTK_FUNCTION(1, "MSDC2_CMD"),
		MTK_FUNCTION(2, "EINT60"),
		MTK_FUNCTION(4, "DSP1_IMS"),
		MTK_FUNCTION(5, "PCM1_WS"),
		MTK_FUNCTION(6, "DPI33_D3"),
		MTK_FUNCTION(7, "TESTA_OUT0")
	),
	MTK_PIN(PINCTRL_PIN(80, "MSDC2_CLK"),
		"AA22", "mt8135",
		MTK_EINT_FUNCTION(2, 59),
		MTK_FUNCTION(0, "GPIO80"),
		MTK_FUNCTION(1, "MSDC2_CLK"),
		MTK_FUNCTION(2, "EINT59"),
		MTK_FUNCTION(4, "DSP1_ICK"),
		MTK_FUNCTION(5, "PCM1_CK"),
		MTK_FUNCTION(6, "DPI33_D2"),
		MTK_FUNCTION(7, "TESTA_OUT1")
	),
	MTK_PIN(PINCTRL_PIN(81, "MSDC2_DAT1"),
		"Y21", "mt8135",
		MTK_EINT_FUNCTION(2, 62),
		MTK_FUNCTION(0, "GPIO81"),
		MTK_FUNCTION(1, "MSDC2_DAT1"),
		MTK_FUNCTION(2, "EINT62"),
		MTK_FUNCTION(4, "DSP2_ICK"),
		MTK_FUNCTION(5, "PCM1_DO"),
		MTK_FUNCTION(6, "DPI33_D5")
	),
	MTK_PIN(PINCTRL_PIN(82, "MSDC2_DAT0"),
		"AB22", "mt8135",
		MTK_EINT_FUNCTION(2, 61),
		MTK_FUNCTION(0, "GPIO82"),
		MTK_FUNCTION(1, "MSDC2_DAT0"),
		MTK_FUNCTION(2, "EINT61"),
		MTK_FUNCTION(4, "DSP1_ID"),
		MTK_FUNCTION(5, "PCM1_DI"),
		MTK_FUNCTION(6, "DPI33_D4")
	),
	MTK_PIN(PINCTRL_PIN(83, "MSDC1_DAT0"),
		"AC19", "mt8135",
		MTK_EINT_FUNCTION(2, 53),
		MTK_FUNCTION(0, "GPIO83"),
		MTK_FUNCTION(1, "MSDC1_DAT0"),
		MTK_FUNCTION(2, "EINT53"),
		MTK_FUNCTION(3, "SCL1"),
		MTK_FUNCTION(4, "PWM2"),
		MTK_FUNCTION(5, "CLKM1"),
		MTK_FUNCTION(7, "TESTB_OUT2")
	),
	MTK_PIN(PINCTRL_PIN(84, "MSDC1_DAT1"),
		"AA19", "mt8135",
		MTK_EINT_FUNCTION(2, 54),
		MTK_FUNCTION(0, "GPIO84"),
		MTK_FUNCTION(1, "MSDC1_DAT1"),
		MTK_FUNCTION(2, "EINT54"),
		MTK_FUNCTION(3, "SDA1"),
		MTK_FUNCTION(4, "PWM3"),
		MTK_FUNCTION(5, "CLKM2"),
		MTK_FUNCTION(7, "TESTB_OUT3")
	),
	MTK_PIN(PINCTRL_PIN(85, "MSDC1_CMD"),
		"AA20", "mt8135",
		MTK_EINT_FUNCTION(2, 52),
		MTK_FUNCTION(0, "GPIO85"),
		MTK_FUNCTION(1, "MSDC1_CMD"),
		MTK_FUNCTION(2, "EINT52"),
		MTK_FUNCTION(3, "SDA0"),
		MTK_FUNCTION(4, "PWM1"),
		MTK_FUNCTION(5, "CLKM0"),
		MTK_FUNCTION(7, "TESTB_OUT1")
	),
	MTK_PIN(PINCTRL_PIN(86, "MSDC1_CLK"),
		"AB19", "mt8135",
		MTK_EINT_FUNCTION(2, 51),
		MTK_FUNCTION(0, "GPIO86"),
		MTK_FUNCTION(1, "MSDC1_CLK"),
		MTK_FUNCTION(2, "EINT51"),
		MTK_FUNCTION(3, "SCL0"),
		MTK_FUNCTION(4, "DISP_PWM"),
		MTK_FUNCTION(7, "TESTB_OUT0")
	),
	MTK_PIN(PINCTRL_PIN(87, "MSDC1_DAT2"),
		"AA21", "mt8135",
		MTK_EINT_FUNCTION(2, 55),
		MTK_FUNCTION(0, "GPIO87"),
		MTK_FUNCTION(1, "MSDC1_DAT2"),
		MTK_FUNCTION(2, "EINT55"),
		MTK_FUNCTION(3, "SCL4"),
		MTK_FUNCTION(4, "PWM4"),
		MTK_FUNCTION(5, "CLKM3"),
		MTK_FUNCTION(7, "TESTB_OUT4")
	),
	MTK_PIN(PINCTRL_PIN(88, "MSDC1_DAT3"),
		"AB20", "mt8135",
		MTK_EINT_FUNCTION(2, 56),
		MTK_FUNCTION(0, "GPIO88"),
		MTK_FUNCTION(1, "MSDC1_DAT3"),
		MTK_FUNCTION(2, "EINT56"),
		MTK_FUNCTION(3, "SDA4"),
		MTK_FUNCTION(4, "PWM5"),
		MTK_FUNCTION(5, "CLKM4"),
		MTK_FUNCTION(7, "TESTB_OUT5")
	),
	MTK_PIN(PINCTRL_PIN(89, "MSDC4_DAT0"),
		"AB8", "mt8135",
		MTK_EINT_FUNCTION(2, 133),
		MTK_FUNCTION(0, "GPIO89"),
		MTK_FUNCTION(1, "MSDC4_DAT0"),
		MTK_FUNCTION(2, "EINT133"),
		MTK_FUNCTION(4, "EXT_FRAME_SYNC"),
		MTK_FUNCTION(5, "USB_DRVVBUS"),
		MTK_FUNCTION(6, "A_FUNC_DIN[9]"),
		MTK_FUNCTION(7, "LPTE")
	),
	MTK_PIN(PINCTRL_PIN(90, "MSDC4_DAT1"),
		"AB7", "mt8135",
		MTK_EINT_FUNCTION(2, 134),
		MTK_FUNCTION(0, "GPIO90"),
		MTK_FUNCTION(1, "MSDC4_DAT1"),
		MTK_FUNCTION(2, "EINT134"),
		MTK_FUNCTION(6, "A_FUNC_DIN[10]"),
		MTK_FUNCTION(7, "LRSTB_1X")
	),
	MTK_PIN(PINCTRL_PIN(91, "MSDC4_DAT5"),
		"AA8", "mt8135",
		MTK_EINT_FUNCTION(2, 136),
		MTK_FUNCTION(0, "GPIO91"),
		MTK_FUNCTION(1, "MSDC4_DAT5"),
		MTK_FUNCTION(2, "EINT136"),
		MTK_FUNCTION(3, "I2SIN_WS"),
		MTK_FUNCTION(4, "DAC_WS"),
		MTK_FUNCTION(5, "PCM1_WS"),
		MTK_FUNCTION(6, "A_FUNC_DIN[11]"),
		MTK_FUNCTION(7, "SPI1_CSN")
	),
	MTK_PIN(PINCTRL_PIN(92, "MSDC4_DAT6"),
		"AC4", "mt8135",
		MTK_EINT_FUNCTION(2, 137),
		MTK_FUNCTION(0, "GPIO92"),
		MTK_FUNCTION(1, "MSDC4_DAT6"),
		MTK_FUNCTION(2, "EINT137"),
		MTK_FUNCTION(3, "I2SOUT_DAT"),
		MTK_FUNCTION(4, "DAC_DAT_OUT"),
		MTK_FUNCTION(5, "PCM1_DO"),
		MTK_FUNCTION(6, "A_FUNC_DIN[12]"),
		MTK_FUNCTION(7, "SPI1_MO")
	),
	MTK_PIN(PINCTRL_PIN(93, "MSDC4_DAT7"),
		"AC6", "mt8135",
		MTK_EINT_FUNCTION(2, 138),
		MTK_FUNCTION(0, "GPIO93"),
		MTK_FUNCTION(1, "MSDC4_DAT7"),
		MTK_FUNCTION(2, "EINT138"),
		MTK_FUNCTION(3, "I2SIN_DAT"),
		MTK_FUNCTION(5, "PCM1_DI"),
		MTK_FUNCTION(6, "A_FUNC_DIN[13]"),
		MTK_FUNCTION(7, "SPI1_MI")
	),
	MTK_PIN(PINCTRL_PIN(94, "MSDC4_DAT4"),
		"AA7", "mt8135",
		MTK_EINT_FUNCTION(2, 135),
		MTK_FUNCTION(0, "GPIO94"),
		MTK_FUNCTION(1, "MSDC4_DAT4"),
		MTK_FUNCTION(2, "EINT135"),
		MTK_FUNCTION(3, "I2SIN_CK"),
		MTK_FUNCTION(4, "DAC_CK"),
		MTK_FUNCTION(5, "PCM1_CK"),
		MTK_FUNCTION(6, "A_FUNC_DIN[14]"),
		MTK_FUNCTION(7, "SPI1_CLK")
	),
	MTK_PIN(PINCTRL_PIN(95, "MSDC4_DAT2"),
		"AB6", "mt8135",
		MTK_EINT_FUNCTION(2, 131),
		MTK_FUNCTION(0, "GPIO95"),
		MTK_FUNCTION(1, "MSDC4_DAT2"),
		MTK_FUNCTION(2, "EINT131"),
		MTK_FUNCTION(3, "I2SIN_WS"),
		MTK_FUNCTION(4, "CM2PDN_2X"),
		MTK_FUNCTION(5, "DAC_WS"),
		MTK_FUNCTION(6, "PCM1_WS"),
		MTK_FUNCTION(7, "LSCE0B_1X")
	),
	MTK_PIN(PINCTRL_PIN(96, "MSDC4_CLK"),
		"AB5", "mt8135",
		MTK_EINT_FUNCTION(2, 129),
		MTK_FUNCTION(0, "GPIO96"),
		MTK_FUNCTION(1, "MSDC4_CLK"),
		MTK_FUNCTION(2, "EINT129"),
		MTK_FUNCTION(3, "DPI1_CK_2X"),
		MTK_FUNCTION(4, "CM2PCLK_2X"),
		MTK_FUNCTION(5, "PWM4"),
		MTK_FUNCTION(6, "PCM1_DI"),
		MTK_FUNCTION(7, "LSCK_1X")
	),
	MTK_PIN(PINCTRL_PIN(97, "MSDC4_DAT3"),
		"Y8", "mt8135",
		MTK_EINT_FUNCTION(2, 132),
		MTK_FUNCTION(0, "GPIO97"),
		MTK_FUNCTION(1, "MSDC4_DAT3"),
		MTK_FUNCTION(2, "EINT132"),
		MTK_FUNCTION(3, "I2SOUT_DAT"),
		MTK_FUNCTION(4, "CM2RST_2X"),
		MTK_FUNCTION(5, "DAC_DAT_OUT"),
		MTK_FUNCTION(6, "PCM1_DO"),
		MTK_FUNCTION(7, "LSCE1B_1X")
	),
	MTK_PIN(PINCTRL_PIN(98, "MSDC4_CMD"),
		"AC3", "mt8135",
		MTK_EINT_FUNCTION(2, 128),
		MTK_FUNCTION(0, "GPIO98"),
		MTK_FUNCTION(1, "MSDC4_CMD"),
		MTK_FUNCTION(2, "EINT128"),
		MTK_FUNCTION(3, "DPI1_DE_2X"),
		MTK_FUNCTION(5, "PWM3"),
		MTK_FUNCTION(7, "LSDA_1X")
	),
	MTK_PIN(PINCTRL_PIN(99, "MSDC4_RSTB"),
		"AB4", "mt8135",
		MTK_EINT_FUNCTION(2, 130),
		MTK_FUNCTION(0, "GPIO99"),
		MTK_FUNCTION(1, "MSDC4_RSTB"),
		MTK_FUNCTION(2, "EINT130"),
		MTK_FUNCTION(3, "I2SIN_CK"),
		MTK_FUNCTION(4, "CM2MCLK_2X"),
		MTK_FUNCTION(5, "DAC_CK"),
		MTK_FUNCTION(6, "PCM1_CK"),
		MTK_FUNCTION(7, "LSA0_1X")
	),
	MTK_PIN(PINCTRL_PIN(100, "SDA0"),
		"W9", "mt8135",
		MTK_EINT_FUNCTION(2, 91),
		MTK_FUNCTION(0, "GPIO100"),
		MTK_FUNCTION(1, "SDA0"),
		MTK_FUNCTION(2, "EINT91"),
		MTK_FUNCTION(3, "CLKM1"),
		MTK_FUNCTION(4, "PWM1"),
		MTK_FUNCTION(7, "A_FUNC_DIN[15]")
	),
	MTK_PIN(PINCTRL_PIN(101, "SCL0"),
		"W11", "mt8135",
		MTK_EINT_FUNCTION(2, 90),
		MTK_FUNCTION(0, "GPIO101"),
		MTK_FUNCTION(1, "SCL0"),
		MTK_FUNCTION(2, "EINT90"),
		MTK_FUNCTION(3, "CLKM0"),
		MTK_FUNCTION(4, "DISP_PWM"),
		MTK_FUNCTION(7, "A_FUNC_DIN[16]")
	),
	MTK_PIN(PINCTRL_PIN(102, "EINT10_AUXIN2"),
		"AA3", "mt8135",
		MTK_EINT_FUNCTION(1, 10),
		MTK_FUNCTION(0, "GPIO102"),
		MTK_FUNCTION(1, "EINT10"),
		MTK_FUNCTION(5, "USB_TEST_IO[16]"),
		MTK_FUNCTION(6, "TESTB_OUT16"),
		MTK_FUNCTION(7, "A_FUNC_DIN[17]")
	),
	MTK_PIN(PINCTRL_PIN(103, "EINT11_AUXIN3"),
		"AB2", "mt8135",
		MTK_EINT_FUNCTION(1, 11),
		MTK_FUNCTION(0, "GPIO103"),
		MTK_FUNCTION(1, "EINT11"),
		MTK_FUNCTION(5, "USB_TEST_IO[17]"),
		MTK_FUNCTION(6, "TESTB_OUT17"),
		MTK_FUNCTION(7, "A_FUNC_DIN[18]")
	),
	MTK_PIN(PINCTRL_PIN(104, "EINT16_AUXIN4"),
		"AB3", "mt8135",
		MTK_EINT_FUNCTION(1, 16),
		MTK_FUNCTION(0, "GPIO104"),
		MTK_FUNCTION(1, "EINT16"),
		MTK_FUNCTION(5, "USB_TEST_IO[18]"),
		MTK_FUNCTION(6, "TESTB_OUT18"),
		MTK_FUNCTION(7, "A_FUNC_DIN[19]")
	),
	MTK_PIN(PINCTRL_PIN(105, "I2S_CLK"),
		"W6", "mt8135",
		MTK_EINT_FUNCTION(2, 10),
		MTK_FUNCTION(0, "GPIO105"),
		MTK_FUNCTION(1, "I2SIN_CK"),
		MTK_FUNCTION(2, "EINT10"),
		MTK_FUNCTION(3, "DAC_CK"),
		MTK_FUNCTION(4, "PCM1_CK"),
		MTK_FUNCTION(5, "USB_TEST_IO[19]"),
		MTK_FUNCTION(6, "TESTB_OUT19"),
		MTK_FUNCTION(7, "A_FUNC_DIN[20]")
	),
	MTK_PIN(PINCTRL_PIN(106, "I2S_WS"),
		"AA6", "mt8135",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO106"),
		MTK_FUNCTION(1, "I2SIN_WS"),
		MTK_FUNCTION(3, "DAC_WS"),
		MTK_FUNCTION(4, "PCM1_WS"),
		MTK_FUNCTION(5, "USB_TEST_IO[20]"),
		MTK_FUNCTION(6, "TESTB_OUT20"),
		MTK_FUNCTION(7, "A_FUNC_DIN[21]")
	),
	MTK_PIN(PINCTRL_PIN(107, "I2S_DATA_IN"),
		"AA5", "mt8135",
		MTK_EINT_FUNCTION(2, 11),
		MTK_FUNCTION(0, "GPIO107"),
		MTK_FUNCTION(1, "I2SIN_DAT"),
		MTK_FUNCTION(2, "EINT11"),
		MTK_FUNCTION(4, "PCM1_DI"),
		MTK_FUNCTION(5, "USB_TEST_IO[21]"),
		MTK_FUNCTION(6, "TESTB_OUT22"),
		MTK_FUNCTION(7, "A_FUNC_DIN[22]")
	),
	MTK_PIN(PINCTRL_PIN(108, "I2S_DATA_OUT"),
		"AA4", "mt8135",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO108"),
		MTK_FUNCTION(1, "I2SOUT_DAT"),
		MTK_FUNCTION(3, "DAC_DAT_OUT"),
		MTK_FUNCTION(4, "PCM1_DO"),
		MTK_FUNCTION(5, "USB_TEST_IO[22]"),
		MTK_FUNCTION(6, "TESTB_OUT23"),
		MTK_FUNCTION(7, "A_FUNC_DIN[23]")
	),
	MTK_PIN(PINCTRL_PIN(109, "EINT5"),
		"W5", "mt8135",
		MTK_EINT_FUNCTION(1, 5),
		MTK_FUNCTION(0, "GPIO109"),
		MTK_FUNCTION(1, "EINT5"),
		MTK_FUNCTION(2, "PWM5"),
		MTK_FUNCTION(3, "CLKM3"),
		MTK_FUNCTION(4, "GPU_JTRSTB"),
		MTK_FUNCTION(5, "USB_TEST_IO[23]"),
		MTK_FUNCTION(6, "TESTB_OUT26"),
		MTK_FUNCTION(7, "A_FUNC_DIN[24]")
	),
	MTK_PIN(PINCTRL_PIN(110, "EINT6"),
		"V5", "mt8135",
		MTK_EINT_FUNCTION(1, 6),
		MTK_FUNCTION(0, "GPIO110"),
		MTK_FUNCTION(1, "EINT6"),
		MTK_FUNCTION(2, "PWM6"),
		MTK_FUNCTION(3, "CLKM4"),
		MTK_FUNCTION(4, "GPU_JTMS"),
		MTK_FUNCTION(5, "USB_TEST_IO[24]"),
		MTK_FUNCTION(6, "TESTB_OUT27"),
		MTK_FUNCTION(7, "A_FUNC_DIN[25]")
	),
	MTK_PIN(PINCTRL_PIN(111, "EINT7"),
		"W3", "mt8135",
		MTK_EINT_FUNCTION(1, 7),
		MTK_FUNCTION(0, "GPIO111"),
		MTK_FUNCTION(1, "EINT7"),
		MTK_FUNCTION(2, "PWM7"),
		MTK_FUNCTION(3, "CLKM5"),
		MTK_FUNCTION(4, "GPU_JTDO"),
		MTK_FUNCTION(5, "USB_TEST_IO[25]"),
		MTK_FUNCTION(6, "TESTB_OUT28"),
		MTK_FUNCTION(7, "A_FUNC_DIN[26]")
	),
	MTK_PIN(PINCTRL_PIN(112, "EINT8"),
		"V6", "mt8135",
		MTK_EINT_FUNCTION(1, 8),
		MTK_FUNCTION(0, "GPIO112"),
		MTK_FUNCTION(1, "EINT8"),
		MTK_FUNCTION(2, "DISP_PWM"),
		MTK_FUNCTION(3, "CLKM6"),
		MTK_FUNCTION(4, "GPU_JTDI"),
		MTK_FUNCTION(5, "USB_TEST_IO[26]"),
		MTK_FUNCTION(6, "TESTB_OUT29"),
		MTK_FUNCTION(7, "EXT_FRAME_SYNC")
	),
	MTK_PIN(PINCTRL_PIN(113, "EINT9"),
		"W8", "mt8135",
		MTK_EINT_FUNCTION(1, 9),
		MTK_FUNCTION(0, "GPIO113"),
		MTK_FUNCTION(1, "EINT9"),
		MTK_FUNCTION(4, "GPU_JTCK"),
		MTK_FUNCTION(5, "USB_DRVVBUS"),
		MTK_FUNCTION(6, "TESTB_OUT30"),
		MTK_FUNCTION(7, "A_FUNC_DIN[27]")
	),
	MTK_PIN(PINCTRL_PIN(114, "LPCE1B"),
		"W4", "mt8135",
		MTK_EINT_FUNCTION(2, 127),
		MTK_FUNCTION(0, "GPIO114"),
		MTK_FUNCTION(1, "LPCE1B"),
		MTK_FUNCTION(2, "EINT127"),
		MTK_FUNCTION(5, "PWM2"),
		MTK_FUNCTION(6, "TESTB_OUT14"),
		MTK_FUNCTION(7, "A_FUNC_DIN[28]")
	),
	MTK_PIN(PINCTRL_PIN(115, "LPCE0B"),
		"T5", "mt8135",
		MTK_EINT_FUNCTION(2, 126),
		MTK_FUNCTION(0, "GPIO115"),
		MTK_FUNCTION(1, "LPCE0B"),
		MTK_FUNCTION(2, "EINT126"),
		MTK_FUNCTION(5, "PWM1"),
		MTK_FUNCTION(6, "TESTB_OUT15"),
		MTK_FUNCTION(7, "A_FUNC_DIN[29]")
	),
	MTK_PIN(PINCTRL_PIN(116, "DISP_PWM"),
		"V4", "mt8135",
		MTK_EINT_FUNCTION(2, 77),
		MTK_FUNCTION(0, "GPIO116"),
		MTK_FUNCTION(1, "DISP_PWM"),
		MTK_FUNCTION(2, "EINT77"),
		MTK_FUNCTION(3, "LSDI"),
		MTK_FUNCTION(4, "PWM1"),
		MTK_FUNCTION(5, "PWM2"),
		MTK_FUNCTION(7, "PWM3")
	),
	MTK_PIN(PINCTRL_PIN(117, "EINT1"),
		"T6", "mt8135",
		MTK_EINT_FUNCTION(1, 1),
		MTK_FUNCTION(0, "GPIO117"),
		MTK_FUNCTION(1, "EINT1"),
		MTK_FUNCTION(2, "PWM2"),
		MTK_FUNCTION(3, "CLKM1"),
		MTK_FUNCTION(5, "USB_TEST_IO[13]"),
		MTK_FUNCTION(7, "USB_SDA")
	),
	MTK_PIN(PINCTRL_PIN(118, "EINT2"),
		"T4", "mt8135",
		MTK_EINT_FUNCTION(1, 2),
		MTK_FUNCTION(0, "GPIO118"),
		MTK_FUNCTION(1, "EINT2"),
		MTK_FUNCTION(2, "PWM3"),
		MTK_FUNCTION(3, "CLKM2"),
		MTK_FUNCTION(5, "USB_TEST_IO[14]"),
		MTK_FUNCTION(6, "SRCLKENAI2"),
		MTK_FUNCTION(7, "A_FUNC_DIN[30]")
	),
	MTK_PIN(PINCTRL_PIN(119, "EINT3"),
		"R4", "mt8135",
		MTK_EINT_FUNCTION(1, 3),
		MTK_FUNCTION(0, "GPIO119"),
		MTK_FUNCTION(1, "EINT3"),
		MTK_FUNCTION(5, "USB_TEST_IO[15]"),
		MTK_FUNCTION(6, "SRCLKENAI1"),
		MTK_FUNCTION(7, "EXT_26M_CK")
	),
	MTK_PIN(PINCTRL_PIN(120, "EINT4"),
		"R5", "mt8135",
		MTK_EINT_FUNCTION(1, 4),
		MTK_FUNCTION(0, "GPIO120"),
		MTK_FUNCTION(1, "EINT4"),
		MTK_FUNCTION(2, "PWM4"),
		MTK_FUNCTION(5, "USB_DRVVBUS"),
		MTK_FUNCTION(7, "A_FUNC_DIN[31]")
	),
	MTK_PIN(PINCTRL_PIN(121, "DPIDE"),
		NULL, "mt8135",
		MTK_EINT_FUNCTION(2, 100),
		MTK_FUNCTION(0, "GPIO121"),
		MTK_FUNCTION(1, "DPI0_DE"),
		MTK_FUNCTION(2, "EINT100"),
		MTK_FUNCTION(3, "I2SOUT_DAT"),
		MTK_FUNCTION(4, "DAC_DAT_OUT"),
		MTK_FUNCTION(5, "PCM1_DO"),
		MTK_FUNCTION(6, "IRDA_TXD")
	),
	MTK_PIN(PINCTRL_PIN(122, "DPICK"),
		NULL, "mt8135",
		MTK_EINT_FUNCTION(2, 101),
		MTK_FUNCTION(0, "GPIO122"),
		MTK_FUNCTION(1, "DPI0_CK"),
		MTK_FUNCTION(2, "EINT101"),
		MTK_FUNCTION(3, "I2SIN_DAT"),
		MTK_FUNCTION(5, "PCM1_DI"),
		MTK_FUNCTION(6, "IRDA_PDN")
	),
	MTK_PIN(PINCTRL_PIN(123, "DPIG4"),
		NULL, "mt8135",
		MTK_EINT_FUNCTION(2, 114),
		MTK_FUNCTION(0, "GPIO123"),
		MTK_FUNCTION(1, "DPI0_G4"),
		MTK_FUNCTION(2, "EINT114"),
		MTK_FUNCTION(4, "CM2DAT_2X[0]"),
		MTK_FUNCTION(5, "DSP2_ID")
	),
	MTK_PIN(PINCTRL_PIN(124, "DPIG5"),
		NULL, "mt8135",
		MTK_EINT_FUNCTION(2, 115),
		MTK_FUNCTION(0, "GPIO124"),
		MTK_FUNCTION(1, "DPI0_G5"),
		MTK_FUNCTION(2, "EINT115"),
		MTK_FUNCTION(4, "CM2DAT_2X[1]"),
		MTK_FUNCTION(5, "DSP2_ICK")
	),
	MTK_PIN(PINCTRL_PIN(125, "DPIR3"),
		NULL, "mt8135",
		MTK_EINT_FUNCTION(2, 121),
		MTK_FUNCTION(0, "GPIO125"),
		MTK_FUNCTION(1, "DPI0_R3"),
		MTK_FUNCTION(2, "EINT121"),
		MTK_FUNCTION(4, "CM2DAT_2X[7]")
	),
	MTK_PIN(PINCTRL_PIN(126, "DPIG1"),
		NULL, "mt8135",
		MTK_EINT_FUNCTION(2, 111),
		MTK_FUNCTION(0, "GPIO126"),
		MTK_FUNCTION(1, "DPI0_G1"),
		MTK_FUNCTION(2, "EINT111"),
		MTK_FUNCTION(5, "DSP1_ICK")
	),
	MTK_PIN(PINCTRL_PIN(127, "DPIVSYNC"),
		NULL, "mt8135",
		MTK_EINT_FUNCTION(2, 98),
		MTK_FUNCTION(0, "GPIO127"),
		MTK_FUNCTION(1, "DPI0_VSYNC"),
		MTK_FUNCTION(2, "EINT98"),
		MTK_FUNCTION(3, "I2SIN_CK"),
		MTK_FUNCTION(4, "DAC_CK"),
		MTK_FUNCTION(5, "PCM1_CK")
	),
	MTK_PIN(PINCTRL_PIN(128, "DPIHSYNC"),
		NULL, "mt8135",
		MTK_EINT_FUNCTION(2, 99),
		MTK_FUNCTION(0, "GPIO128"),
		MTK_FUNCTION(1, "DPI0_HSYNC"),
		MTK_FUNCTION(2, "EINT99"),
		MTK_FUNCTION(3, "I2SIN_WS"),
		MTK_FUNCTION(4, "DAC_WS"),
		MTK_FUNCTION(5, "PCM1_WS"),
		MTK_FUNCTION(6, "IRDA_RXD")
	),
	MTK_PIN(PINCTRL_PIN(129, "DPIB0"),
		NULL, "mt8135",
		MTK_EINT_FUNCTION(2, 102),
		MTK_FUNCTION(0, "GPIO129"),
		MTK_FUNCTION(1, "DPI0_B0"),
		MTK_FUNCTION(2, "EINT102"),
		MTK_FUNCTION(4, "SCL0"),
		MTK_FUNCTION(5, "DISP_PWM")
	),
	MTK_PIN(PINCTRL_PIN(130, "DPIB1"),
		NULL, "mt8135",
		MTK_EINT_FUNCTION(2, 103),
		MTK_FUNCTION(0, "GPIO130"),
		MTK_FUNCTION(1, "DPI0_B1"),
		MTK_FUNCTION(2, "EINT103"),
		MTK_FUNCTION(3, "CLKM0"),
		MTK_FUNCTION(4, "SDA0"),
		MTK_FUNCTION(5, "PWM1")
	),
	MTK_PIN(PINCTRL_PIN(131, "DPIB2"),
		NULL, "mt8135",
		MTK_EINT_FUNCTION(2, 104),
		MTK_FUNCTION(0, "GPIO131"),
		MTK_FUNCTION(1, "DPI0_B2"),
		MTK_FUNCTION(2, "EINT104"),
		MTK_FUNCTION(3, "CLKM1"),
		MTK_FUNCTION(4, "SCL1"),
		MTK_FUNCTION(5, "PWM2")
	),
	MTK_PIN(PINCTRL_PIN(132, "DPIB3"),
		NULL, "mt8135",
		MTK_EINT_FUNCTION(2, 105),
		MTK_FUNCTION(0, "GPIO132"),
		MTK_FUNCTION(1, "DPI0_B3"),
		MTK_FUNCTION(2, "EINT105"),
		MTK_FUNCTION(3, "CLKM2"),
		MTK_FUNCTION(4, "SDA1"),
		MTK_FUNCTION(5, "PWM3")
	),
	MTK_PIN(PINCTRL_PIN(133, "DPIB4"),
		NULL, "mt8135",
		MTK_EINT_FUNCTION(2, 106),
		MTK_FUNCTION(0, "GPIO133"),
		MTK_FUNCTION(1, "DPI0_B4"),
		MTK_FUNCTION(2, "EINT106"),
		MTK_FUNCTION(3, "CLKM3"),
		MTK_FUNCTION(4, "SCL2"),
		MTK_FUNCTION(5, "PWM4")
	),
	MTK_PIN(PINCTRL_PIN(134, "DPIB5"),
		NULL, "mt8135",
		MTK_EINT_FUNCTION(2, 107),
		MTK_FUNCTION(0, "GPIO134"),
		MTK_FUNCTION(1, "DPI0_B5"),
		MTK_FUNCTION(2, "EINT107"),
		MTK_FUNCTION(3, "CLKM4"),
		MTK_FUNCTION(4, "SDA2"),
		MTK_FUNCTION(5, "PWM5")
	),
	MTK_PIN(PINCTRL_PIN(135, "DPIB6"),
		NULL, "mt8135",
		MTK_EINT_FUNCTION(2, 108),
		MTK_FUNCTION(0, "GPIO135"),
		MTK_FUNCTION(1, "DPI0_B6"),
		MTK_FUNCTION(2, "EINT108"),
		MTK_FUNCTION(3, "CLKM5"),
		MTK_FUNCTION(4, "SCL3"),
		MTK_FUNCTION(5, "PWM6")
	),
	MTK_PIN(PINCTRL_PIN(136, "DPIB7"),
		NULL, "mt8135",
		MTK_EINT_FUNCTION(2, 109),
		MTK_FUNCTION(0, "GPIO136"),
		MTK_FUNCTION(1, "DPI0_B7"),
		MTK_FUNCTION(2, "EINT109"),
		MTK_FUNCTION(3, "CLKM6"),
		MTK_FUNCTION(4, "SDA3"),
		MTK_FUNCTION(5, "PWM7")
	),
	MTK_PIN(PINCTRL_PIN(137, "DPIG0"),
		NULL, "mt8135",
		MTK_EINT_FUNCTION(2, 110),
		MTK_FUNCTION(0, "GPIO137"),
		MTK_FUNCTION(1, "DPI0_G0"),
		MTK_FUNCTION(2, "EINT110"),
		MTK_FUNCTION(5, "DSP1_ID")
	),
	MTK_PIN(PINCTRL_PIN(138, "DPIG2"),
		NULL, "mt8135",
		MTK_EINT_FUNCTION(2, 112),
		MTK_FUNCTION(0, "GPIO138"),
		MTK_FUNCTION(1, "DPI0_G2"),
		MTK_FUNCTION(2, "EINT112"),
		MTK_FUNCTION(5, "DSP1_IMS")
	),
	MTK_PIN(PINCTRL_PIN(139, "DPIG3"),
		NULL, "mt8135",
		MTK_EINT_FUNCTION(2, 113),
		MTK_FUNCTION(0, "GPIO139"),
		MTK_FUNCTION(1, "DPI0_G3"),
		MTK_FUNCTION(2, "EINT113"),
		MTK_FUNCTION(5, "DSP2_IMS")
	),
	MTK_PIN(PINCTRL_PIN(140, "DPIG6"),
		NULL, "mt8135",
		MTK_EINT_FUNCTION(2, 116),
		MTK_FUNCTION(0, "GPIO140"),
		MTK_FUNCTION(1, "DPI0_G6"),
		MTK_FUNCTION(2, "EINT116"),
		MTK_FUNCTION(4, "CM2DAT_2X[2]")
	),
	MTK_PIN(PINCTRL_PIN(141, "DPIG7"),
		NULL, "mt8135",
		MTK_EINT_FUNCTION(2, 117),
		MTK_FUNCTION(0, "GPIO141"),
		MTK_FUNCTION(1, "DPI0_G7"),
		MTK_FUNCTION(2, "EINT117"),
		MTK_FUNCTION(4, "CM2DAT_2X[3]")
	),
	MTK_PIN(PINCTRL_PIN(142, "DPIR0"),
		NULL, "mt8135",
		MTK_EINT_FUNCTION(2, 118),
		MTK_FUNCTION(0, "GPIO142"),
		MTK_FUNCTION(1, "DPI0_R0"),
		MTK_FUNCTION(2, "EINT118"),
		MTK_FUNCTION(4, "CM2DAT_2X[4]")
	),
	MTK_PIN(PINCTRL_PIN(143, "DPIR1"),
		NULL, "mt8135",
		MTK_EINT_FUNCTION(2, 119),
		MTK_FUNCTION(0, "GPIO143"),
		MTK_FUNCTION(1, "DPI0_R1"),
		MTK_FUNCTION(2, "EINT119"),
		MTK_FUNCTION(4, "CM2DAT_2X[5]")
	),
	MTK_PIN(PINCTRL_PIN(144, "DPIR2"),
		NULL, "mt8135",
		MTK_EINT_FUNCTION(2, 120),
		MTK_FUNCTION(0, "GPIO144"),
		MTK_FUNCTION(1, "DPI0_R2"),
		MTK_FUNCTION(2, "EINT120"),
		MTK_FUNCTION(4, "CM2DAT_2X[6]")
	),
	MTK_PIN(PINCTRL_PIN(145, "DPIR4"),
		NULL, "mt8135",
		MTK_EINT_FUNCTION(2, 122),
		MTK_FUNCTION(0, "GPIO145"),
		MTK_FUNCTION(1, "DPI0_R4"),
		MTK_FUNCTION(2, "EINT122"),
		MTK_FUNCTION(4, "CM2DAT_2X[8]")
	),
	MTK_PIN(PINCTRL_PIN(146, "DPIR5"),
		NULL, "mt8135",
		MTK_EINT_FUNCTION(2, 123),
		MTK_FUNCTION(0, "GPIO146"),
		MTK_FUNCTION(1, "DPI0_R5"),
		MTK_FUNCTION(2, "EINT123"),
		MTK_FUNCTION(4, "CM2DAT_2X[9]")
	),
	MTK_PIN(PINCTRL_PIN(147, "DPIR6"),
		NULL, "mt8135",
		MTK_EINT_FUNCTION(2, 124),
		MTK_FUNCTION(0, "GPIO147"),
		MTK_FUNCTION(1, "DPI0_R6"),
		MTK_FUNCTION(2, "EINT124"),
		MTK_FUNCTION(4, "CM2VSYNC_2X")
	),
	MTK_PIN(PINCTRL_PIN(148, "DPIR7"),
		NULL, "mt8135",
		MTK_EINT_FUNCTION(2, 125),
		MTK_FUNCTION(0, "GPIO148"),
		MTK_FUNCTION(1, "DPI0_R7"),
		MTK_FUNCTION(2, "EINT125"),
		MTK_FUNCTION(4, "CM2HSYNC_2X")
	),
	MTK_PIN(PINCTRL_PIN(149, "TDN3/LVDS(TDN3)"),
		"AA2", "mt8135",
		MTK_EINT_FUNCTION(2, 36),
		MTK_FUNCTION(0, "GPIO149"),
		MTK_FUNCTION(2, "EINT36")
	),
	MTK_PIN(PINCTRL_PIN(150, "TDP3/LVDS(TDP3)"),
		"AA1", "mt8135",
		MTK_EINT_FUNCTION(2, 35),
		MTK_FUNCTION(0, "GPIO150"),
		MTK_FUNCTION(2, "EINT35")
	),
	MTK_PIN(PINCTRL_PIN(151, "TDN2/LVDS(TCN)"),
		"Y2", "mt8135",
		MTK_EINT_FUNCTION(2, 169),
		MTK_FUNCTION(0, "GPIO151"),
		MTK_FUNCTION(2, "EINT169")
	),
	MTK_PIN(PINCTRL_PIN(152, "TDP2/LVDS(TCP)"),
		"Y1", "mt8135",
		MTK_EINT_FUNCTION(2, 168),
		MTK_FUNCTION(0, "GPIO152"),
		MTK_FUNCTION(2, "EINT168")
	),
	MTK_PIN(PINCTRL_PIN(153, "TCN/LVDS(TDN2)"),
		"W2", "mt8135",
		MTK_EINT_FUNCTION(2, 163),
		MTK_FUNCTION(0, "GPIO153"),
		MTK_FUNCTION(2, "EINT163")
	),
	MTK_PIN(PINCTRL_PIN(154, "TCP/LVDS(TDP2)"),
		"W1", "mt8135",
		MTK_EINT_FUNCTION(2, 162),
		MTK_FUNCTION(0, "GPIO154"),
		MTK_FUNCTION(2, "EINT162")
	),
	MTK_PIN(PINCTRL_PIN(155, "TDN1/LVDS(TDN1)"),
		"V3", "mt8135",
		MTK_EINT_FUNCTION(2, 167),
		MTK_FUNCTION(0, "GPIO155"),
		MTK_FUNCTION(2, "EINT167")
	),
	MTK_PIN(PINCTRL_PIN(156, "TDP1/LVDS(TDP1)"),
		"V2", "mt8135",
		MTK_EINT_FUNCTION(2, 166),
		MTK_FUNCTION(0, "GPIO156"),
		MTK_FUNCTION(2, "EINT166")
	),
	MTK_PIN(PINCTRL_PIN(157, "TDN0/LVDS(TDN0)"),
		"U3", "mt8135",
		MTK_EINT_FUNCTION(2, 165),
		MTK_FUNCTION(0, "GPIO157"),
		MTK_FUNCTION(2, "EINT165")
	),
	MTK_PIN(PINCTRL_PIN(158, "TDP0/LVDS(TDP0)"),
		"U2", "mt8135",
		MTK_EINT_FUNCTION(2, 164),
		MTK_FUNCTION(0, "GPIO158"),
		MTK_FUNCTION(2, "EINT164")
	),
	MTK_PIN(PINCTRL_PIN(159, "RDN3"),
		"N5", "mt8135",
		MTK_EINT_FUNCTION(2, 18),
		MTK_FUNCTION(0, "GPIO159"),
		MTK_FUNCTION(2, "EINT18")
	),
	MTK_PIN(PINCTRL_PIN(160, "RDP3"),
		"N4", "mt8135",
		MTK_EINT_FUNCTION(2, 30),
		MTK_FUNCTION(0, "GPIO160"),
		MTK_FUNCTION(2, "EINT30")
	),
	MTK_PIN(PINCTRL_PIN(161, "RDN2"),
		"T2", "mt8135",
		MTK_EINT_FUNCTION(2, 31),
		MTK_FUNCTION(0, "GPIO161"),
		MTK_FUNCTION(2, "EINT31")
	),
	MTK_PIN(PINCTRL_PIN(162, "RDP2"),
		"T3", "mt8135",
		MTK_EINT_FUNCTION(2, 32),
		MTK_FUNCTION(0, "GPIO162"),
		MTK_FUNCTION(2, "EINT32")
	),
	MTK_PIN(PINCTRL_PIN(163, "RCN"),
		"P2", "mt8135",
		MTK_EINT_FUNCTION(2, 33),
		MTK_FUNCTION(0, "GPIO163"),
		MTK_FUNCTION(2, "EINT33")
	),
	MTK_PIN(PINCTRL_PIN(164, "RCP"),
		"P3", "mt8135",
		MTK_EINT_FUNCTION(2, 39),
		MTK_FUNCTION(0, "GPIO164"),
		MTK_FUNCTION(2, "EINT39")
	),
	MTK_PIN(PINCTRL_PIN(165, "RDN1"),
		"R3", "mt8135",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO165")
	),
	MTK_PIN(PINCTRL_PIN(166, "RDP1"),
		"R2", "mt8135",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO166")
	),
	MTK_PIN(PINCTRL_PIN(167, "RDN0"),
		"N3", "mt8135",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO167")
	),
	MTK_PIN(PINCTRL_PIN(168, "RDP0"),
		"N2", "mt8135",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO168")
	),
	MTK_PIN(PINCTRL_PIN(169, "RDN1_A"),
		"M4", "mt8135",
		MTK_EINT_FUNCTION(2, 175),
		MTK_FUNCTION(0, "GPIO169"),
		MTK_FUNCTION(1, "CMDAT6"),
		MTK_FUNCTION(2, "EINT175")
	),
	MTK_PIN(PINCTRL_PIN(170, "RDP1_A"),
		"M3", "mt8135",
		MTK_EINT_FUNCTION(2, 174),
		MTK_FUNCTION(0, "GPIO170"),
		MTK_FUNCTION(1, "CMDAT7"),
		MTK_FUNCTION(2, "EINT174")
	),
	MTK_PIN(PINCTRL_PIN(171, "RCN_A"),
		"L3", "mt8135",
		MTK_EINT_FUNCTION(2, 171),
		MTK_FUNCTION(0, "GPIO171"),
		MTK_FUNCTION(1, "CMDAT8"),
		MTK_FUNCTION(2, "EINT171")
	),
	MTK_PIN(PINCTRL_PIN(172, "RCP_A"),
		"L2", "mt8135",
		MTK_EINT_FUNCTION(2, 170),
		MTK_FUNCTION(0, "GPIO172"),
		MTK_FUNCTION(1, "CMDAT9"),
		MTK_FUNCTION(2, "EINT170")
	),
	MTK_PIN(PINCTRL_PIN(173, "RDN0_A"),
		"M2", "mt8135",
		MTK_EINT_FUNCTION(2, 173),
		MTK_FUNCTION(0, "GPIO173"),
		MTK_FUNCTION(1, "CMHSYNC"),
		MTK_FUNCTION(2, "EINT173")
	),
	MTK_PIN(PINCTRL_PIN(174, "RDP0_A"),
		"M1", "mt8135",
		MTK_EINT_FUNCTION(2, 172),
		MTK_FUNCTION(0, "GPIO174"),
		MTK_FUNCTION(1, "CMVSYNC"),
		MTK_FUNCTION(2, "EINT172")
	),
	MTK_PIN(PINCTRL_PIN(175, "RDN1_B"),
		"H2", "mt8135",
		MTK_EINT_FUNCTION(2, 181),
		MTK_FUNCTION(0, "GPIO175"),
		MTK_FUNCTION(1, "CMDAT2"),
		MTK_FUNCTION(2, "EINT181"),
		MTK_FUNCTION(3, "CMCSD2")
	),
	MTK_PIN(PINCTRL_PIN(176, "RDP1_B"),
		"H1", "mt8135",
		MTK_EINT_FUNCTION(2, 180),
		MTK_FUNCTION(0, "GPIO176"),
		MTK_FUNCTION(1, "CMDAT3"),
		MTK_FUNCTION(2, "EINT180"),
		MTK_FUNCTION(3, "CMCSD3")
	),
	MTK_PIN(PINCTRL_PIN(177, "RCN_B"),
		"K3", "mt8135",
		MTK_EINT_FUNCTION(2, 177),
		MTK_FUNCTION(0, "GPIO177"),
		MTK_FUNCTION(1, "CMDAT4"),
		MTK_FUNCTION(2, "EINT177")
	),
	MTK_PIN(PINCTRL_PIN(178, "RCP_B"),
		"K2", "mt8135",
		MTK_EINT_FUNCTION(2, 176),
		MTK_FUNCTION(0, "GPIO178"),
		MTK_FUNCTION(1, "CMDAT5"),
		MTK_FUNCTION(2, "EINT176")
	),
	MTK_PIN(PINCTRL_PIN(179, "RDN0_B"),
		"J3", "mt8135",
		MTK_EINT_FUNCTION(2, 179),
		MTK_FUNCTION(0, "GPIO179"),
		MTK_FUNCTION(1, "CMDAT0"),
		MTK_FUNCTION(2, "EINT179"),
		MTK_FUNCTION(3, "CMCSD0")
	),
	MTK_PIN(PINCTRL_PIN(180, "RDP0_B"),
		"J2", "mt8135",
		MTK_EINT_FUNCTION(2, 178),
		MTK_FUNCTION(0, "GPIO180"),
		MTK_FUNCTION(1, "CMDAT1"),
		MTK_FUNCTION(2, "EINT178"),
		MTK_FUNCTION(3, "CMCSD1")
	),
	MTK_PIN(PINCTRL_PIN(181, "CMPCLK"),
		"K4", "mt8135",
		MTK_EINT_FUNCTION(2, 182),
		MTK_FUNCTION(0, "GPIO181"),
		MTK_FUNCTION(1, "CMPCLK"),
		MTK_FUNCTION(2, "EINT182"),
		MTK_FUNCTION(3, "CMCSK"),
		MTK_FUNCTION(4, "CM2MCLK_4X"),
		MTK_FUNCTION(5, "TS_AUXADC_SEL[3]"),
		MTK_FUNCTION(6, "VENC_TEST_CK"),
		MTK_FUNCTION(7, "TESTA_OUT27")
	),
	MTK_PIN(PINCTRL_PIN(182, "CMMCLK"),
		"J5", "mt8135",
		MTK_EINT_FUNCTION(2, 183),
		MTK_FUNCTION(0, "GPIO182"),
		MTK_FUNCTION(1, "CMMCLK"),
		MTK_FUNCTION(2, "EINT183"),
		MTK_FUNCTION(5, "TS_AUXADC_SEL[2]"),
		MTK_FUNCTION(7, "TESTA_OUT28")
	),
	MTK_PIN(PINCTRL_PIN(183, "CMRST"),
		"J6", "mt8135",
		MTK_EINT_FUNCTION(2, 185),
		MTK_FUNCTION(0, "GPIO183"),
		MTK_FUNCTION(1, "CMRST"),
		MTK_FUNCTION(2, "EINT185"),
		MTK_FUNCTION(5, "TS_AUXADC_SEL[1]"),
		MTK_FUNCTION(7, "TESTA_OUT30")
	),
	MTK_PIN(PINCTRL_PIN(184, "CMPDN"),
		"J4", "mt8135",
		MTK_EINT_FUNCTION(2, 184),
		MTK_FUNCTION(0, "GPIO184"),
		MTK_FUNCTION(1, "CMPDN"),
		MTK_FUNCTION(2, "EINT184"),
		MTK_FUNCTION(5, "TS_AUXADC_SEL[0]"),
		MTK_FUNCTION(7, "TESTA_OUT29")
	),
	MTK_PIN(PINCTRL_PIN(185, "CMFLASH"),
		"G4", "mt8135",
		MTK_EINT_FUNCTION(2, 186),
		MTK_FUNCTION(0, "GPIO185"),
		MTK_FUNCTION(1, "CMFLASH"),
		MTK_FUNCTION(2, "EINT186"),
		MTK_FUNCTION(3, "CM2MCLK_3X"),
		MTK_FUNCTION(6, "MFG_TEST_CK_1"),
		MTK_FUNCTION(7, "TESTA_OUT31")
	),
	MTK_PIN(PINCTRL_PIN(186, "MRG_I2S_PCM_CLK"),
		"F5", "mt8135",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO186"),
		MTK_FUNCTION(1, "MRG_I2S_PCM_CLK"),
		MTK_FUNCTION(3, "I2SIN_CK"),
		MTK_FUNCTION(4, "PCM0_CK"),
		MTK_FUNCTION(5, "DSP2_ICK"),
		MTK_FUNCTION(6, "IMG_TEST_CK"),
		MTK_FUNCTION(7, "USB_SCL")
	),
	MTK_PIN(PINCTRL_PIN(187, "MRG_I2S_PCM_SYNC"),
		"G6", "mt8135",
		MTK_EINT_FUNCTION(2, 16),
		MTK_FUNCTION(0, "GPIO187"),
		MTK_FUNCTION(1, "MRG_I2S_PCM_SYNC"),
		MTK_FUNCTION(2, "EINT16"),
		MTK_FUNCTION(3, "I2SIN_WS"),
		MTK_FUNCTION(4, "PCM0_WS"),
		MTK_FUNCTION(6, "DISP_TEST_CK")
	),
	MTK_PIN(PINCTRL_PIN(188, "MRG_I2S_PCM_RX"),
		"G3", "mt8135",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO188"),
		MTK_FUNCTION(1, "MRG_I2S_PCM_RX"),
		MTK_FUNCTION(3, "I2SIN_DAT"),
		MTK_FUNCTION(4, "PCM0_DI"),
		MTK_FUNCTION(5, "DSP2_ID"),
		MTK_FUNCTION(6, "MFG_TEST_CK"),
		MTK_FUNCTION(7, "USB_SDA")
	),
	MTK_PIN(PINCTRL_PIN(189, "MRG_I2S_PCM_TX"),
		"G5", "mt8135",
		MTK_EINT_FUNCTION(2, 17),
		MTK_FUNCTION(0, "GPIO189"),
		MTK_FUNCTION(1, "MRG_I2S_PCM_TX"),
		MTK_FUNCTION(2, "EINT17"),
		MTK_FUNCTION(3, "I2SOUT_DAT"),
		MTK_FUNCTION(4, "PCM0_DO"),
		MTK_FUNCTION(6, "VDEC_TEST_CK")
	),
	MTK_PIN(PINCTRL_PIN(190, "SRCLKENAI"),
		"K5", "mt8135",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO190"),
		MTK_FUNCTION(1, "SRCLKENAI")
	),
	MTK_PIN(PINCTRL_PIN(191, "URXD3"),
		"C3", "mt8135",
		MTK_EINT_FUNCTION(2, 87),
		MTK_FUNCTION(0, "GPIO191"),
		MTK_FUNCTION(1, "URXD3"),
		MTK_FUNCTION(2, "EINT87"),
		MTK_FUNCTION(3, "UTXD3"),
		MTK_FUNCTION(5, "TS_AUX_ST"),
		MTK_FUNCTION(6, "PWM4")
	),
	MTK_PIN(PINCTRL_PIN(192, "UTXD3"),
		"B2", "mt8135",
		MTK_EINT_FUNCTION(2, 86),
		MTK_FUNCTION(0, "GPIO192"),
		MTK_FUNCTION(1, "UTXD3"),
		MTK_FUNCTION(2, "EINT86"),
		MTK_FUNCTION(3, "URXD3"),
		MTK_FUNCTION(5, "TS_AUX_CS_B"),
		MTK_FUNCTION(6, "PWM3")
	),
	MTK_PIN(PINCTRL_PIN(193, "SDA2"),
		"G2", "mt8135",
		MTK_EINT_FUNCTION(2, 95),
		MTK_FUNCTION(0, "GPIO193"),
		MTK_FUNCTION(1, "SDA2"),
		MTK_FUNCTION(2, "EINT95"),
		MTK_FUNCTION(3, "CLKM5"),
		MTK_FUNCTION(4, "PWM5"),
		MTK_FUNCTION(5, "TS_AUX_PWDB")
	),
	MTK_PIN(PINCTRL_PIN(194, "SCL2"),
		"F4", "mt8135",
		MTK_EINT_FUNCTION(2, 94),
		MTK_FUNCTION(0, "GPIO194"),
		MTK_FUNCTION(1, "SCL2"),
		MTK_FUNCTION(2, "EINT94"),
		MTK_FUNCTION(3, "CLKM4"),
		MTK_FUNCTION(4, "PWM4"),
		MTK_FUNCTION(5, "TS_AUXADC_TEST_CK")
	),
	MTK_PIN(PINCTRL_PIN(195, "SDA1"),
		"F2", "mt8135",
		MTK_EINT_FUNCTION(2, 93),
		MTK_FUNCTION(0, "GPIO195"),
		MTK_FUNCTION(1, "SDA1"),
		MTK_FUNCTION(2, "EINT93"),
		MTK_FUNCTION(3, "CLKM3"),
		MTK_FUNCTION(4, "PWM3"),
		MTK_FUNCTION(5, "TS_AUX_SCLK_PWDB")
	),
	MTK_PIN(PINCTRL_PIN(196, "SCL1"),
		"F3", "mt8135",
		MTK_EINT_FUNCTION(2, 92),
		MTK_FUNCTION(0, "GPIO196"),
		MTK_FUNCTION(1, "SCL1"),
		MTK_FUNCTION(2, "EINT92"),
		MTK_FUNCTION(3, "CLKM2"),
		MTK_FUNCTION(4, "PWM2"),
		MTK_FUNCTION(5, "TS_AUX_DIN")
	),
	MTK_PIN(PINCTRL_PIN(197, "MSDC3_DAT2"),
		"E1", "mt8135",
		MTK_EINT_FUNCTION(2, 71),
		MTK_FUNCTION(0, "GPIO197"),
		MTK_FUNCTION(1, "MSDC3_DAT2"),
		MTK_FUNCTION(2, "EINT71"),
		MTK_FUNCTION(3, "SCL6"),
		MTK_FUNCTION(4, "PWM5"),
		MTK_FUNCTION(5, "CLKM4"),
		MTK_FUNCTION(6, "MFG_TEST_CK_2")
	),
	MTK_PIN(PINCTRL_PIN(198, "MSDC3_DAT3"),
		"C2", "mt8135",
		MTK_EINT_FUNCTION(2, 72),
		MTK_FUNCTION(0, "GPIO198"),
		MTK_FUNCTION(1, "MSDC3_DAT3"),
		MTK_FUNCTION(2, "EINT72"),
		MTK_FUNCTION(3, "SDA6"),
		MTK_FUNCTION(4, "PWM6"),
		MTK_FUNCTION(5, "CLKM5"),
		MTK_FUNCTION(6, "MFG_TEST_CK_3")
	),
	MTK_PIN(PINCTRL_PIN(199, "MSDC3_CMD"),
		"D2", "mt8135",
		MTK_EINT_FUNCTION(2, 68),
		MTK_FUNCTION(0, "GPIO199"),
		MTK_FUNCTION(1, "MSDC3_CMD"),
		MTK_FUNCTION(2, "EINT68"),
		MTK_FUNCTION(3, "SDA2"),
		MTK_FUNCTION(4, "PWM2"),
		MTK_FUNCTION(5, "CLKM1"),
		MTK_FUNCTION(6, "MFG_TEST_CK_4")
	),
	MTK_PIN(PINCTRL_PIN(200, "MSDC3_CLK"),
		"E2", "mt8135",
		MTK_EINT_FUNCTION(2, 67),
		MTK_FUNCTION(0, "GPIO200"),
		MTK_FUNCTION(1, "MSDC3_CLK"),
		MTK_FUNCTION(2, "EINT67"),
		MTK_FUNCTION(3, "SCL2"),
		MTK_FUNCTION(4, "PWM1"),
		MTK_FUNCTION(5, "CLKM0")
	),
	MTK_PIN(PINCTRL_PIN(201, "MSDC3_DAT1"),
		"D3", "mt8135",
		MTK_EINT_FUNCTION(2, 70),
		MTK_FUNCTION(0, "GPIO201"),
		MTK_FUNCTION(1, "MSDC3_DAT1"),
		MTK_FUNCTION(2, "EINT70"),
		MTK_FUNCTION(3, "SDA3"),
		MTK_FUNCTION(4, "PWM4"),
		MTK_FUNCTION(5, "CLKM3")
	),
	MTK_PIN(PINCTRL_PIN(202, "MSDC3_DAT0"),
		"E3", "mt8135",
		MTK_EINT_FUNCTION(2, 69),
		MTK_FUNCTION(0, "GPIO202"),
		MTK_FUNCTION(1, "MSDC3_DAT0"),
		MTK_FUNCTION(2, "EINT69"),
		MTK_FUNCTION(3, "SCL3"),
		MTK_FUNCTION(4, "PWM3"),
		MTK_FUNCTION(5, "CLKM2")
	),
};

#endif /* __PINCTRL_MTK_MT8135_H */
