#! /bin/perl -w
#
# change the owner of a NIS+ object
#
# Nistool is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either version 2 of the
# License, or (at your option) any later version.
#
# Nistool is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
# 
# You should have received a copy of the GNU General Public
# License along with the NIS+ Server; see the file COPYING.  If
# not, write to the Free Software Foundation, Inc., 675 Mass Ave,
# Cambridge, MA 02139, USA.
#
# Version: 0.1alpha
# Author: Ralf Lehmann <ralfl@darwin.muc.de>
#

use Nisplus;
use strict;

my $O = $ARGV[0];
my $OBJ = $ARGV[1];
my $RETSTR;
my $o;

if (!defined($O)) { usage();}
if (!defined($OBJ)) { usage();}
my $o = Nisplus->new($OBJ);
$o->getattr();
if ($RETSTR = $o->get_error()){
	print STDERR "Error: $RETSTR\n";
	exit 1;
}
$o->chown($O);
my $DIR = Nisplus::strip_first($o->name());
print `nisping $DIR`;
exit 0;


sub usage {
	print STDERR "usage: $0 dirname\n";
	exit 1;
}
