#!/bin/sh
PATH=/bin:/sbin:/usr/bin:/usr/sbin:/usr/local/bin

. /usr/share/runit/scripts/runit-functions.sh
. /etc/runit/config/system.conf

SERVICE1=mount-devfs

load_service(){
    mountpoint -q /dev || mount -t devtmpfs dev /dev -o mode=0755,nosuid

    # seed /dev with some things that might be needed (for example,
    # xudev doesn't do this compared to eudev), code from OpenRC

    # creating /dev/console, /dev/tty and /dev/tty1 to be able to write
    # to $CONSOLE with/without bootsplash before udevd creates it
    [ -c /dev/console ] || mknod -m 600 /dev/console c 5 1
    [ -c /dev/tty1 ] || mknod -m 620 /dev/tty1 c 4 1
    [ -c /dev/tty ] || mknod -m 666 /dev/tty c 5 0

    # udevd will dup its stdin/stdout/stderr to /dev/null
    # and we do not want a file which gets buffered in ram
    [ -c /dev/null ] || mknod -m 666 /dev/null c 1 3

    # so udev can add its start-message to dmesg
    [ -c /dev/kmsg ] || mknod -m 660 /dev/kmsg c 1 11

    # extra symbolic links not provided by default
    [ -e /dev/fd ]     || ln -snf /proc/self/fd /dev/fd
    [ -e /dev/stdin ]  || ln -snf /proc/self/fd/0 /dev/stdin
    [ -e /dev/stdout ] || ln -snf /proc/self/fd/1 /dev/stdout
    [ -e /dev/stderr ] || ln -snf /proc/self/fd/2 /dev/stderr
    [ -e /proc/kcore ] && ln -snf /proc/kcore /dev/core

    mkdir -p /dev/pts /dev/shm
    mountpoint -q /dev/pts || mount -t devpts devpts /dev/pts -o mode=0620,gid=5,nosuid,noexec
    mountpoint -q /dev/shm || mount -t tmpfs shm /dev/shm -o mode=1777,nosuid,nodev
    mountpoint -q /run     || mount -t tmpfs run /run -o mode=0755,nosuid,nodev
}

# MAIN START
stat_busy "Starting $SERVICE1"
load_service || stat_die $SERVICE1
add_daemon $SERVICE1
stat_done $SERVICE1

#~ # MAIN STOP
#~ stat_busy "Stopping $SERVICE1"
#~ unload_service || stat_die $SERVICE1
#~ rm_daemon $SERVICE1
#~ stat_done $SERVICE1
