/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyForeignXRef;
import genj.gedcom.PropertyPlace;
import genj.gedcom.PropertyRelationship;
import genj.gedcom.PropertySimpleValue;
import genj.gedcom.PropertyXRef;
import genj.util.WordBuffer;

public class PropertyAssociation
extends PropertyXRef {
    PropertyAssociation(String tag) {
        super(tag);
        this.assertTag("ASSO");
    }

    @Override
    public String getDisplayValue() {
        return this.getDisplayValue(true);
    }

    public String getDisplayValue(boolean fullDisplay) {
        Property place;
        String fullName;
        PropertyXRef target = this.getTarget();
        if (target == null) {
            return super.getDisplayValue();
        }
        Property parent = target.getParent();
        if (parent == null) {
            return super.getDisplayValue();
        }
        WordBuffer result = new WordBuffer(" - ");
        if (fullDisplay) {
            result.append(parent.getEntity());
        }
        String shortName = (fullName = Gedcom.getName(parent.getTag())).contains(" ") ? fullName.substring(0, fullName.indexOf(" ")) : fullName;
        result.append(fullDisplay ? fullName : shortName);
        Property date = parent.getProperty("DATE");
        if (date != null) {
            if (fullDisplay) {
                result.append(date);
            } else {
                PropertyDate pDate = (PropertyDate)date;
                result.append(pDate.getStart().getValue());
            }
        }
        if ((place = parent.getProperty("PLAC")) != null) {
            if (fullDisplay) {
                result.append(place);
            } else {
                PropertyPlace pPlace = (PropertyPlace)place;
                result.append(pPlace.getCity());
            }
        }
        return result.toString();
    }

    @Override
    protected String getForeignDisplayValue() {
        Property rela = this.getProperty("RELA");
        if (rela != null && rela.getDisplayValue().length() > 0) {
            return rela.getDisplayValue() + ": " + this.getEntity().toString();
        }
        return super.getForeignDisplayValue();
    }

    @Override
    public String getDeleteVeto() {
        if (this.getTargetEntity() == null) {
            return null;
        }
        return resources.getString("prop.asso.veto");
    }

    @Override
    public void link() throws GedcomException {
        Entity ent = this.getCandidate();
        PropertyForeignXRef fxref = new PropertyForeignXRef();
        try {
            PropertyRelationship rela = (PropertyRelationship)this.getProperty("RELA");
            ent.getProperty(rela.getAnchor()).addProperty(fxref);
        }
        catch (Throwable t) {
            ent.addProperty(fxref);
        }
        this.link(fxref);
        if ("5.5".equals(this.getGedcom().getGrammar())) {
            Property type = this.getProperty("TYPE");
            if (type == null) {
                type = this.addProperty(new PropertySimpleValue("TYPE"));
            }
            type.setValue(ent.getTag());
        }
    }

    @Override
    public String getTargetType() {
        String[] entities;
        if (!this.getMetaProperty().allows("TYPE") && "5.5".equals(this.getGedcom().getGrammar())) {
            return "INDI";
        }
        Property type = this.getProperty("TYPE");
        if (type != null) {
            return type.getValue();
        }
        String prefix = this.getValue().substring(1, 2);
        for (String entitie : entities = this.getGedcom().getEntitiesType()) {
            if (!Gedcom.getEntityPrefix(entitie).startsWith(prefix)) continue;
            return entitie;
        }
        return "INDI";
    }
}

