/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Media;
import genj.gedcom.MultiLineProperty;
import genj.gedcom.Property;
import genj.gedcom.PropertyMedia;
import genj.gedcom.PropertySimpleValue;
import genj.io.InputSource;
import genj.util.Base64;
import genj.util.ByteArray;
import java.io.InputStream;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PropertyBlob
extends Property
implements MultiLineProperty {
    private static final Logger LOG = Logger.getLogger("ancestris.app");
    private Object content = "";

    public PropertyBlob() {
        super("BLOB");
    }

    public PropertyBlob(String tag) {
        super(tag);
    }

    private byte[] getBlobData() {
        if (this.content instanceof byte[]) {
            return (byte[])this.content;
        }
        try {
            this.content = Base64.decode(this.content.toString());
        }
        catch (IllegalArgumentException e) {
            Gedcom.LOG.log(Level.WARNING, "Cannot convert blob base64 in " + this.getGedcom().getName() + "/" + this.getEntity() + "/" + this.getPath() + " into bytes (" + e.getMessage() + ")");
            return new byte[0];
        }
        return (byte[])this.content;
    }

    public Optional<InputSource> getInput() {
        return InputSource.get(this.getGedcom().getName() + "/" + this.getEntity() + "/" + this.getPath(), this.getBlobData());
    }

    public String getTitle() {
        Entity e = this.getEntity();
        return e instanceof Media ? ((Media)e).getTitle() : this.getTag();
    }

    @Override
    public String getValue() {
        if (this.content instanceof byte[]) {
            return ((byte[])this.content).length + " Raw Bytes";
        }
        return this.content.toString().length() + " Base64 Bytes";
    }

    @Override
    public MultiLineProperty.Collector getLineCollector() {
        return new BlobCollector();
    }

    @Override
    public MultiLineProperty.Iterator getLineIterator(boolean isConcFile) {
        if (this.content instanceof byte[]) {
            return new BlobIterator(Base64.encode((byte[])this.content));
        }
        return new BlobIterator(this.content.toString());
    }

    @Override
    public synchronized void setValue(String value) {
        String old = this.getValue();
        this.content = value;
        this.propagatePropertyChanged(this, old);
    }

    @Override
    public boolean addFile(InputSource is) {
        return this.load(is, true);
    }

    public boolean load(InputSource file, boolean updateMeta) {
        String old = this.getValue();
        try (InputStream in = file.open();){
            byte[] newContent = new ByteArray(in, in.available(), false).getBytes();
            this.content = newContent;
        }
        catch (Throwable t) {
            LOG.log(Level.FINE, "Unable to get the contents.", t);
            return false;
        }
        this.propagatePropertyChanged(this, old);
        Property media = this.getParent();
        if (!updateMeta || !(media instanceof PropertyMedia) && !(media instanceof Media)) {
            return true;
        }
        Property format = media.getProperty("FORM");
        if (format == null) {
            format = media.addProperty(new PropertySimpleValue("FORM"));
        }
        format.setValue(file.getExtension());
        return true;
    }

    private static class BlobIterator
    implements MultiLineProperty.Iterator {
        private String base64;
        private int offset;
        private final int LINE = 72;

        public BlobIterator(String base64) {
            this.base64 = base64;
            this.offset = 0;
        }

        @Override
        public void setValue(String base64) {
        }

        @Override
        public int getIndent() {
            return this.offset == 0 ? 0 : 1;
        }

        @Override
        public String getTag() {
            return this.offset == 0 ? this.getTag() : "CONT";
        }

        @Override
        public String getValue() {
            return this.base64.substring(this.offset, Math.min(this.offset + 72, this.base64.length()));
        }

        @Override
        public boolean next() {
            if (this.offset + 72 >= this.base64.length()) {
                return false;
            }
            this.offset += 72;
            return true;
        }
    }

    private class BlobCollector
    implements MultiLineProperty.Collector {
        private StringBuffer buffer = new StringBuffer(1024);

        private BlobCollector() {
            if (PropertyBlob.this.content instanceof String) {
                this.buffer.append(PropertyBlob.this.content);
            }
        }

        @Override
        public boolean append(int indent, String tag, String value) {
            if (indent != 1) {
                return false;
            }
            if (!"CONT".equals(tag)) {
                return false;
            }
            this.buffer.append(value.trim());
            return true;
        }

        @Override
        public String getValue() {
            return this.buffer.toString();
        }
    }
}

