/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcomcompare.tools;

import ancestris.modules.gedcomcompare.GedcomCompareTopComponent;
import ancestris.modules.gedcomcompare.tools.ComparisonFrame;
import ancestris.modules.gedcomcompare.tools.ConnectedUserFrame;
import ancestris.modules.gedcomcompare.tools.LocalGedcomFrame;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.ListModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class StatsPanel
extends JPanel {
    private final GedcomCompareTopComponent owner;
    private int nbIndis = 0;
    private int nbFams = 0;
    private int nbSTs = 0;
    private String maxArea = "";
    private int activeUsersNb = 0;
    private int rcvdConnectionsNb = 0;
    private int rcvdUniqueUsersNb = 0;
    private int rcvdUniqueOverlapsNb = 0;
    private int maxoverlap = 0;
    private int citynamesNb = 0;
    private int eventsNb = 0;
    private JPanel ORPanel;
    private JScrollPane OR_Pane;
    private JTable OR_Table;
    private JPanel UAPanel;
    private JScrollPane UA_AreasPane;
    private JLabel UA_activeusers;
    private JLabel UA_activeusers_Label;
    private JLabel UA_areas;
    private JList<String> UA_areasList;
    private JLabel UA_areas_Label;
    private JLabel UA_areaslist_Label;
    private JLabel UA_fams;
    private JLabel UA_fams_Label;
    private JLabel UA_indis;
    private JLabel UA_indis_Label;
    private JLabel UA_users;
    private JLabel UA_users_Label;
    private JPanel YRPanel;
    private JScrollPane YR_AreasPane;
    private JList<String> YR_areasList;
    private JLabel YR_areaslist_Label;
    private JLabel YR_citynames;
    private JLabel YR_citynamesLabel;
    private JLabel YR_connections;
    private JLabel YR_connectionsLabel;
    private JLabel YR_events;
    private JLabel YR_eventsLabel;
    private JLabel YR_overlaps;
    private JLabel YR_overlapsLabel;
    private JLabel YR_users;
    private JLabel YR_usersLabel;

    public StatsPanel(GedcomCompareTopComponent tstc) {
        this.owner = tstc;
        this.initComponents();
        ((JLabel)((Object)this.OR_Table.getTableHeader().getDefaultRenderer())).setHorizontalAlignment(0);
        this.calcValues();
    }

    public final void calcValues() {
        LocalGedcomFrame mgf = this.owner.getMain();
        this.nbIndis = mgf == null ? 0 : mgf.getNbOfPublicIndis();
        this.nbFams = mgf == null ? 0 : mgf.getNbOfPublicFams();
        this.nbSTs = mgf == null ? 0 : mgf.getNbOfSTs();
        this.activeUsersNb = 0;
        this.rcvdConnectionsNb = 0;
        this.rcvdUniqueUsersNb = 0;
        this.rcvdUniqueOverlapsNb = 0;
        this.maxoverlap = 0;
        this.citynamesNb = 0;
        this.eventsNb = 0;
        int size = this.owner.getConnectedUsers() == null ? 1 : this.owner.getConnectedUsers().size() + 1;
        int[][] tableData = new int[size][3];
        int row = 0;
        HashMap<String, Integer> areasMap = new HashMap<String, Integer>();
        ArrayList<String> areaCityNames = new ArrayList<String>();
        if (mgf != null) {
            this.updateMap(areasMap, mgf.getSTs());
        }
        if (this.owner.getConnectedUsers() != null) {
            for (ConnectedUserFrame user : this.owner.getConnectedUsers()) {
                if (user.isActive()) {
                    ++this.activeUsersNb;
                }
                this.nbIndis += user.getNbIndis();
                this.nbFams += user.getNbFams();
                this.nbSTs += user.getNbSTs();
                this.updateMap(areasMap, user.getSTs());
                tableData[row++] = user.getStats();
                this.rcvdConnectionsNb += user.getConnections();
                if (user.hasConnections()) {
                    ++this.rcvdUniqueUsersNb;
                }
                if (!user.hasOverlap()) continue;
                ++this.rcvdUniqueOverlapsNb;
                ComparisonFrame cf = this.owner.getComparisonFrame(user);
                this.maxoverlap = cf.getOverlap(this.maxoverlap);
                this.citynamesNb += cf.getLastCityNb();
                this.eventsNb += cf.getEventNb();
                areaCityNames.addAll(cf.getAreaCityNames());
            }
        }
        tableData[row] = new int[]{this.maxoverlap, this.citynamesNb, this.eventsNb};
        Map topMap = areasMap.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).limit(20L).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
        String[] areas = new String[20];
        int i = 0;
        for (String key : topMap.keySet()) {
            areas[i] = key + " (" + topMap.get(key) + ")";
            ++i;
        }
        this.maxArea = areas[0];
        this.UA_areasList.setListData((String[])areas);
        this.UA_users.setText("1 + " + (this.owner.getConnectedUsers() != null ? this.owner.getConnectedUsers().size() : 0));
        int ua = this.owner.isSharingOn() ? 1 : 0;
        this.UA_activeusers.setText(ua + " + " + this.activeUsersNb);
        this.UA_indis.setText("" + this.nbIndis);
        this.UA_fams.setText("" + this.nbFams);
        this.UA_areas.setText("" + this.nbSTs);
        this.setTable(tableData);
        this.YR_connections.setText("" + this.rcvdConnectionsNb);
        this.YR_users.setText("" + this.rcvdUniqueUsersNb);
        this.YR_overlaps.setText("" + this.rcvdUniqueOverlapsNb + " /\u00a0" + this.maxoverlap + "%");
        this.YR_citynames.setText("" + this.citynamesNb);
        this.YR_events.setText("" + this.eventsNb);
        this.YR_areasList.setListData((String[])areaCityNames.toArray(new String[areaCityNames.size()]));
    }

    private void updateMap(Map<String, Integer> areasMap, String[] array) {
        for (String key : array) {
            Integer score;
            if (key.trim().isEmpty()) continue;
            String[] bits = key.split("_");
            String area = bits[0].trim();
            int value = 0;
            if (bits.length > 1) {
                value = Integer.parseInt(bits[1].substring(1, bits[1].length() - 1));
            }
            if ((score = areasMap.get(area)) == null) {
                score = 0;
            }
            score = score + value;
            areasMap.put(area, score);
        }
    }

    private void initComponents() {
        this.UAPanel = new JPanel();
        this.UA_users_Label = new JLabel();
        this.UA_users = new JLabel();
        this.UA_activeusers_Label = new JLabel();
        this.UA_activeusers = new JLabel();
        this.UA_indis_Label = new JLabel();
        this.UA_indis = new JLabel();
        this.UA_fams_Label = new JLabel();
        this.UA_fams = new JLabel();
        this.UA_areas_Label = new JLabel();
        this.UA_areas = new JLabel();
        this.UA_areaslist_Label = new JLabel();
        this.UA_AreasPane = new JScrollPane();
        this.UA_areasList = new JList();
        this.ORPanel = new JPanel();
        this.OR_Pane = new JScrollPane();
        this.OR_Table = new JTable();
        this.YRPanel = new JPanel();
        this.YR_connectionsLabel = new JLabel();
        this.YR_connections = new JLabel();
        this.YR_usersLabel = new JLabel();
        this.YR_users = new JLabel();
        this.YR_overlapsLabel = new JLabel();
        this.YR_overlaps = new JLabel();
        this.YR_citynamesLabel = new JLabel();
        this.YR_citynames = new JLabel();
        this.YR_eventsLabel = new JLabel();
        this.YR_events = new JLabel();
        this.YR_areaslist_Label = new JLabel();
        this.YR_AreasPane = new JScrollPane();
        this.YR_areasList = new JList();
        this.UAPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), NbBundle.getMessage(StatsPanel.class, (String)"StatsPanel.UAPanel.border.title")));
        this.UA_users_Label.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/gedcomcompare/resources/friend16.png")));
        Mnemonics.setLocalizedText((JLabel)this.UA_users_Label, (String)NbBundle.getMessage(StatsPanel.class, (String)"StatsPanel.UA_users_Label.text"));
        this.UA_users.setHorizontalAlignment(4);
        Mnemonics.setLocalizedText((JLabel)this.UA_users, (String)NbBundle.getMessage(StatsPanel.class, (String)"StatsPanel.UA_users.text"));
        this.UA_activeusers_Label.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/gedcomcompare/resources/active.png")));
        Mnemonics.setLocalizedText((JLabel)this.UA_activeusers_Label, (String)NbBundle.getMessage(StatsPanel.class, (String)"StatsPanel.UA_activeusers_Label.text"));
        this.UA_activeusers.setHorizontalAlignment(4);
        Mnemonics.setLocalizedText((JLabel)this.UA_activeusers, (String)NbBundle.getMessage(StatsPanel.class, (String)"StatsPanel.UA_activeusers.text"));
        this.UA_indis_Label.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/gedcomcompare/resources/indi.png")));
        Mnemonics.setLocalizedText((JLabel)this.UA_indis_Label, (String)NbBundle.getMessage(StatsPanel.class, (String)"StatsPanel.UA_indis_Label.text"));
        this.UA_indis.setHorizontalAlignment(4);
        Mnemonics.setLocalizedText((JLabel)this.UA_indis, (String)NbBundle.getMessage(StatsPanel.class, (String)"StatsPanel.UA_indis.text"));
        this.UA_fams_Label.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/gedcomcompare/resources/fam.png")));
        Mnemonics.setLocalizedText((JLabel)this.UA_fams_Label, (String)NbBundle.getMessage(StatsPanel.class, (String)"StatsPanel.UA_fams_Label.text"));
        this.UA_fams.setHorizontalAlignment(4);
        Mnemonics.setLocalizedText((JLabel)this.UA_fams, (String)NbBundle.getMessage(StatsPanel.class, (String)"StatsPanel.UA_fams.text"));
        this.UA_areas_Label.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/gedcomcompare/resources/geost.png")));
        Mnemonics.setLocalizedText((JLabel)this.UA_areas_Label, (String)NbBundle.getMessage(StatsPanel.class, (String)"StatsPanel.UA_areas_Label.text"));
        this.UA_areas.setHorizontalAlignment(4);
        Mnemonics.setLocalizedText((JLabel)this.UA_areas, (String)NbBundle.getMessage(StatsPanel.class, (String)"StatsPanel.UA_areas.text"));
        this.UA_areaslist_Label.setHorizontalAlignment(0);
        this.UA_areaslist_Label.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/gedcomcompare/resources/star.png")));
        Mnemonics.setLocalizedText((JLabel)this.UA_areaslist_Label, (String)NbBundle.getMessage(StatsPanel.class, (String)"StatsPanel.UA_areaslist_Label.text"));
        this.UA_areasList.setModel((ListModel<String>)new AbstractListModel<String>(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public String getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.UA_AreasPane.setViewportView(this.UA_areasList);
        GroupLayout UAPanelLayout = new GroupLayout(this.UAPanel);
        this.UAPanel.setLayout(UAPanelLayout);
        UAPanelLayout.setHorizontalGroup(UAPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(UAPanelLayout.createSequentialGroup().addContainerGap().addGroup(UAPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.UA_areas_Label).addComponent(this.UA_fams_Label).addComponent(this.UA_indis_Label).addComponent(this.UA_activeusers_Label).addComponent(this.UA_users_Label)).addGap(18, 18, 18).addGroup(UAPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.UA_users, GroupLayout.Alignment.TRAILING).addComponent(this.UA_activeusers, GroupLayout.Alignment.TRAILING).addComponent(this.UA_indis, GroupLayout.Alignment.TRAILING).addComponent(this.UA_fams, GroupLayout.Alignment.TRAILING).addComponent(this.UA_areas, GroupLayout.Alignment.TRAILING)).addGap(18, 18, 18).addGroup(UAPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.UA_areaslist_Label, -1, -1, Short.MAX_VALUE).addComponent(this.UA_AreasPane, -1, 258, Short.MAX_VALUE)).addContainerGap()));
        UAPanelLayout.setVerticalGroup(UAPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(UAPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.UA_areaslist_Label).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(UAPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.UA_AreasPane, -1, 153, Short.MAX_VALUE).addGroup(UAPanelLayout.createSequentialGroup().addGroup(UAPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(UAPanelLayout.createSequentialGroup().addComponent(this.UA_users_Label).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.UA_activeusers_Label).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.UA_indis_Label).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.UA_fams_Label).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.UA_areas_Label)).addGroup(UAPanelLayout.createSequentialGroup().addComponent(this.UA_users).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.UA_activeusers).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.UA_indis).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.UA_fams).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.UA_areas))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        this.ORPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), NbBundle.getMessage(StatsPanel.class, (String)"StatsPanel.ORPanel.border.title")));
        this.OR_Table.setModel(new DefaultTableModel(new Object[][]{{"Overlaps", null, null, null, null}, {"City-Names", null, null, null, null}, {"Events", null, null, null, null}}, new String[]{"Variable", "Count", "%", "Average", "Max"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, Integer.class, Float.class, Integer.class, Integer.class};
                this.canEdit = new boolean[]{false, false, false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.OR_Table.getTableHeader().setReorderingAllowed(false);
        this.OR_Pane.setViewportView(this.OR_Table);
        GroupLayout ORPanelLayout = new GroupLayout(this.ORPanel);
        this.ORPanel.setLayout(ORPanelLayout);
        ORPanelLayout.setHorizontalGroup(ORPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ORPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.OR_Pane).addContainerGap()));
        ORPanelLayout.setVerticalGroup(ORPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ORPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.OR_Pane, -2, 78, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.YRPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), NbBundle.getMessage(StatsPanel.class, (String)"StatsPanel.YRPanel.border.title")));
        this.YR_connectionsLabel.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/gedcomcompare/resources/connm.png")));
        Mnemonics.setLocalizedText((JLabel)this.YR_connectionsLabel, (String)NbBundle.getMessage(StatsPanel.class, (String)"StatsPanel.YR_connectionsLabel.text"));
        this.YR_connections.setHorizontalAlignment(11);
        Mnemonics.setLocalizedText((JLabel)this.YR_connections, (String)NbBundle.getMessage(StatsPanel.class, (String)"StatsPanel.YR_connections.text"));
        this.YR_usersLabel.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/gedcomcompare/resources/connu.png")));
        Mnemonics.setLocalizedText((JLabel)this.YR_usersLabel, (String)NbBundle.getMessage(StatsPanel.class, (String)"StatsPanel.YR_usersLabel.text"));
        this.YR_users.setHorizontalAlignment(11);
        Mnemonics.setLocalizedText((JLabel)this.YR_users, (String)NbBundle.getMessage(StatsPanel.class, (String)"StatsPanel.YR_users.text"));
        this.YR_overlapsLabel.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/gedcomcompare/resources/connoverlap.png")));
        Mnemonics.setLocalizedText((JLabel)this.YR_overlapsLabel, (String)NbBundle.getMessage(StatsPanel.class, (String)"StatsPanel.YR_overlapsLabel.text"));
        this.YR_overlaps.setHorizontalAlignment(11);
        Mnemonics.setLocalizedText((JLabel)this.YR_overlaps, (String)NbBundle.getMessage(StatsPanel.class, (String)"StatsPanel.YR_overlaps.text"));
        this.YR_citynamesLabel.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/gedcomcompare/resources/indi.png")));
        Mnemonics.setLocalizedText((JLabel)this.YR_citynamesLabel, (String)NbBundle.getMessage(StatsPanel.class, (String)"StatsPanel.YR_citynamesLabel.text"));
        this.YR_citynames.setHorizontalAlignment(11);
        Mnemonics.setLocalizedText((JLabel)this.YR_citynames, (String)NbBundle.getMessage(StatsPanel.class, (String)"StatsPanel.YR_citynames.text"));
        this.YR_eventsLabel.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/gedcomcompare/resources/even.png")));
        Mnemonics.setLocalizedText((JLabel)this.YR_eventsLabel, (String)NbBundle.getMessage(StatsPanel.class, (String)"StatsPanel.YR_eventsLabel.text"));
        this.YR_events.setHorizontalAlignment(11);
        Mnemonics.setLocalizedText((JLabel)this.YR_events, (String)NbBundle.getMessage(StatsPanel.class, (String)"StatsPanel.YR_events.text"));
        this.YR_areaslist_Label.setHorizontalAlignment(0);
        this.YR_areaslist_Label.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/gedcomcompare/resources/star.png")));
        Mnemonics.setLocalizedText((JLabel)this.YR_areaslist_Label, (String)NbBundle.getMessage(StatsPanel.class, (String)"StatsPanel.YR_areaslist_Label.text"));
        this.YR_areasList.setModel((ListModel<String>)new AbstractListModel<String>(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public String getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.YR_AreasPane.setViewportView(this.YR_areasList);
        GroupLayout YRPanelLayout = new GroupLayout(this.YRPanel);
        this.YRPanel.setLayout(YRPanelLayout);
        YRPanelLayout.setHorizontalGroup(YRPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(YRPanelLayout.createSequentialGroup().addContainerGap().addGroup(YRPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.YR_citynamesLabel).addComponent(this.YR_overlapsLabel).addComponent(this.YR_usersLabel).addComponent(this.YR_connectionsLabel).addComponent(this.YR_eventsLabel)).addGap(18, 18, 18).addGroup(YRPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.YR_connections, GroupLayout.Alignment.TRAILING).addComponent(this.YR_users, GroupLayout.Alignment.TRAILING).addComponent(this.YR_overlaps, GroupLayout.Alignment.TRAILING).addComponent(this.YR_citynames, GroupLayout.Alignment.TRAILING).addComponent(this.YR_events, GroupLayout.Alignment.TRAILING)).addGap(18, 18, 18).addGroup(YRPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.YR_areaslist_Label, -1, 255, Short.MAX_VALUE).addComponent(this.YR_AreasPane)).addContainerGap()));
        YRPanelLayout.setVerticalGroup(YRPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(YRPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.YR_areaslist_Label, -1, 19, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(YRPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.YR_AreasPane, -1, 152, Short.MAX_VALUE).addGroup(YRPanelLayout.createSequentialGroup().addGroup(YRPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.YR_connectionsLabel).addComponent(this.YR_connections)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(YRPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.YR_usersLabel).addComponent(this.YR_users)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(YRPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.YR_overlapsLabel).addComponent(this.YR_overlaps)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(YRPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.YR_citynamesLabel).addComponent(this.YR_citynames)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(YRPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.YR_eventsLabel).addComponent(this.YR_events)))).addContainerGap()));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.UAPanel, -1, -1, Short.MAX_VALUE).addComponent(this.YRPanel, -1, -1, Short.MAX_VALUE).addComponent(this.ORPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.UAPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ORPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.YRPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    public int getNbIndis() {
        return this.nbIndis;
    }

    public int getNbFams() {
        return this.nbFams;
    }

    public int getNbSTs() {
        return this.nbSTs;
    }

    public String getMaxArea() {
        return this.maxArea;
    }

    public int getNbConnections() {
        return this.rcvdConnectionsNb;
    }

    public int getNbUniqueUsers() {
        return this.rcvdUniqueUsersNb;
    }

    public int getNbOverlaps() {
        return this.rcvdUniqueOverlapsNb;
    }

    public String getValues() {
        return "" + this.maxoverlap + " " + this.citynamesNb + " " + this.eventsNb;
    }

    private void setTable(int[][] tableData) {
        int[] count = new int[]{0, 0, 0};
        int[] percent = new int[]{0, 0, 0};
        int[] average = new int[]{0, 0, 0};
        int[] max = new int[]{0, 0, 0};
        for (int[] row : tableData) {
            for (int i = 0; i < 3; ++i) {
                int n = i;
                count[n] = count[n] + (row[i] > 0 ? 1 : 0);
                percent[i] = count[i] * 100 / tableData.length;
                int n2 = i;
                average[n2] = average[n2] + row[i];
                max[i] = Math.max(max[i], row[i]);
            }
        }
        for (int i = 0; i < 3; ++i) {
            if (count[i] == 0) continue;
            average[i] = average[i] / count[i];
        }
        this.OR_Table.setModel(new DefaultTableModel(new Object[][]{{NbBundle.getMessage(this.getClass(), (String)"STAT_Overlaps"), count[0], percent[0], average[0], max[0]}, {NbBundle.getMessage(this.getClass(), (String)"STAT_CityNames"), count[1], percent[1], average[1], max[1]}, {NbBundle.getMessage(this.getClass(), (String)"STAT_Events"), count[2], percent[2], average[2], max[2]}}, new String[]{NbBundle.getMessage(this.getClass(), (String)"STAT_Variable"), NbBundle.getMessage(this.getClass(), (String)"STAT_Count"), NbBundle.getMessage(this.getClass(), (String)"STAT_Percent"), NbBundle.getMessage(this.getClass(), (String)"STAT_Average"), NbBundle.getMessage(this.getClass(), (String)"STAT_Max")}){

            public Class getColumnClass(int columnIndex) {
                return columnIndex == 0 ? String.class : Integer.class;
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }
        });
        DefaultTableCellRenderer centerRenderer = new DefaultTableCellRenderer();
        centerRenderer.setHorizontalAlignment(0);
        for (int i = 1; i < 5; ++i) {
            this.OR_Table.getColumnModel().getColumn(i).setCellRenderer(centerRenderer);
        }
    }
}

